/*
     This code is distributed under the terms and conditions of the
     CCP4 licence agreement as `Part ii)' software.  See the conditions
     in the CCP4 manual for a copyright statement.
*/

/*   cparser.h

     Header file for cparser routines
     Peter Briggs CCP4 April 2001
*/

/*------------------------------------------------------------------*/

/* Structures and typedefs */

/*------------------------------------------------------------------*/

#ifndef __CParser__
#define __CParser__


#ifndef  __STDIO_H
#include <stdio.h>
#endif


#ifdef  __CPlusPlus
#define externC extern "C"
#else
#define externC
#endif


/* Parser token
   Construct to hold the information about a single token */

typedef struct {
  char   *fullstring;   /* Full string containing all of token */
  char   word[5];       /* First four characters of token */
  double value;         /* Equivalent numerical value */
  int    isstring;      /* Flag: true if token is character string */
  int    isnumber;      /* Flag: true if token is number */
  int    isquoted;      /* Flag: true if token is contained in quotes */
  int    isnull;        /* Flag: true if token is null field */
  int    ibeg,iend;     /* Begin and end character positions of token
			   in input line */
} PARSERTOKEN;

/* Parser array
   Construct to hold the information about a parsed line */

typedef struct {
  char   keyword[5];    /* Keyword (=token[1].token, uppercased) */
  int    ntokens;       /* Number of tokens */
  PARSERTOKEN *token;   /* Array of tokens */
  FILE   *fp;           /* Pointer to an external command file */
  int    maxtokens;     /* Maximum number of tokens allowed */
  char   *delim;        /* List of delimiter characters */
  char   *nulldelim;    /* List of null delimiter characters */
} PARSERARRAY;     

/*------------------------------------------------------------------*/

/* Function Prototypes */

/*------------------------------------------------------------------*/

/* Core cparser functions */

externC PARSERARRAY * cparse_start(int maxtokens);

externC int cparse_end(PARSERARRAY *parsePtr);

externC int cparse_init_token(PARSERARRAY *parsePtr, int itok);

externC int cparse_delimiters(PARSERARRAY *parsePtr, char *delim, char *nulldelim);

externC int cparse_reset(PARSERARRAY *parsePtr);

externC int cparse(char *line, PARSERARRAY *parser);

externC int cparser(char *line, int n, PARSERARRAY *parser, int print);

/* Utility functions */

externC int keymatch(const char *keyin1, const char *keyin2);

externC int strtoupper (char *str1, char *str2);

externC int strmatch (char *str1, char *str2);

externC int charmatch(char character, char *charlist);


#endif
