//
// =================================================================
//
//  MacroMolecular Data Base (MMDB)
//
//  File  m1.cpp
//
// =================================================================
//

#ifndef  __STRING_H
#include <string.h>
#endif

#ifndef  __MMDB_Manager__
#include "mmdb_manager.h"
#endif

#ifndef  __MMDB_Graph__
#include "mmdb_graph.h"
#endif

#ifndef  __MMDB_Tables__
#include "mmdb_tables.h"
#endif

#ifndef  __MMDB_SBase__
#include "mmdb_sbase.h"
#endif


int main ( int argc, char ** argv, char ** env )  {
PCMMDBManager  MMDB;
PCSBase        SBase;
int            RC,lcount;
char           S[500];
int            selHnd,nSelResidues;
PPCResidue     SelResidue;
int            i;
int            nInResidue,nInStructure,nMatched;
int            match[150];

  if (argc<2)  {
    printf ( " USAGE: m1 pdbfile [sbasedir]\n" );
    return 1;
  }

  //  1.  Make routine initializations, which must always be done
  //      before working with MMDB
  InitMatType();

  //  2.  Create an instance of MMDB
  MMDB = new CMMDBManager();

  //  3.  Read coordinate file.
  //    3.1 Set all necessary read flags -- check with the top of
  //        file  mmdb_file.h  as needed
  MMDB->SetFlag ( MMDBF_PrintCIFWarnings );

  //    3.2 MMDB provides the following function for reading
  //        coordinate files with automatic format recognition
  //        for PDB, mmCIF and MMDB BINary files:
  RC = MMDB->ReadCoorFile ( argv[1] );

  //    3.3 Check for possible errors:
  if (RC) {
    //  An error was encountered. MMDB provides an error messenger
    //  function for easy error message printing.
    printf ( " ***** ERROR #%i READ:\n\n %s\n\n",RC,GetErrorDescription(RC) );
    //  Location of the error may be identified as precise as line
    //  number and the line itself (PDB only. Errors in mmCIF are
    //  located by category/item name. Errors of reading BINary files
    //  are not locatable and the files are not editable). This
    //  information is now retrieved from MMDB input buffer:
    MMDB->GetInputBuffer ( S,lcount );
    if (lcount>=0) 
      printf ( "       LINE #%i:\n%s\n\n",lcount,S );
    else if (lcount==-1)
      printf ( "       CIF ITEM: %s\n\n",S );
    //  dispose instance of MMDB and quit:
    delete MMDB;
    return 2;
  } else  {
    //  MMDB allows to identify the type of file that has been just
    //  read:
    switch (MMDB->GetFileType())  {
      case MMDB_FILE_PDB    : printf ( " PDB"         );  break;
      case MMDB_FILE_CIF    : printf ( " mmCIF"       );  break;
      case MMDB_FILE_Binary : printf ( " MMDB binary" );  break;
      default : printf ( " Unknown (report as a bug!)" );
    }
    printf ( " file %s has been read in.\n",argv[1] );
  }


  SBase  = new CSBase ();
  if (argc<3)  RC = SBase->LoadIndex("");
         else  RC = SBase->LoadIndex(argv[2]);
  if (RC!=SBASE_Ok)  {
    printf ( " ****** sbase files not found.\n" );
    delete MMDB;
    delete SBase;
    return 1;
  }

  selHnd = MMDB->NewSelection();
  MMDB->Select ( selHnd,STYPE_RESIDUE,1,"*",ANY_RES,"*",ANY_RES,"*",
                 "*","*","*","*",SKEY_NEW );
  MMDB->GetSelIndex ( selHnd,SelResidue,nSelResidues );
  printf ( "   %i residues selected.\n",nSelResidues );

  for (i=0;i<nSelResidues;i++)  {
    RC = SBase->CheckResidue ( SelResidue[i],1,False,
                        nInResidue,nInStructure,nMatched,match );
    printf ( " %4i.  %3s",i+1,SelResidue[i]->name );
    switch (RC)  {
      case SBASE_Ok :
          printf ( "%2i|%2i:%2i -- PASSED",
                   nInResidue,nInStructure,nMatched );
        break;
      case SBASE_CheckFail :
          printf ( "%2i|%2i:%2i -- FAILED",
                   nInResidue,nInStructure,nMatched );
        break;
      case SBASE_NoAtomsFound :
          printf ( " -- NO ATOMS FOUND" );
        break;
      case SBASE_StructNotFound :
          printf ( " -- STRUCTURE NOT FOUND" );
        break;
      case SBASE_FileNotFound :
          printf ( " -- NO GRAPH FILE" );
        break;
      case SBASE_WrongIndex :
          printf ( " -- WRONG SBASE INDEX" );
        break;
      case SBASE_ReadError :
          printf ( " -- GRAPH READ ERROR" );
        break;
      default :
          printf ( " -- RETURN CODE %i",RC );
    }
    if (isNucleotide(SelResidue[i]->GetResName()))
          printf ( "  [nucleotide]\n" );
    else  printf ( "\n" );
  }

  if (MMDB)   delete MMDB;
  if (SBase)  delete SBase;

  return 0;

}



