      subroutine mn_rootf(idelim)
*-----------------------------------------------------------------------
*     Read in root histograms
*
*     $Id: mn_rootf.fpp,v 1.3 2005/05/13 20:59:21 brock Exp $
*-----------------------------------------------------------------------
*
      implicit none
*
      integer idelim
*
#include "mnlun.inc"
#if ( defined(ROOT) )
#include "mnpar.inc"
#include "mndat.inc"
#include "mninf.inc"
#include "mnflg.inc"
#include "mncmd.inc"
*
      integer idlsa1(100),idlsa2(100),idlsb1(100),idlsb2(100)
*
      character*80 tid
      integer ndhis0,ndum,ierr,nidl,nl,nmode,nh,nchar
      integer ida1,ida2,idb1,idb2,nnid,ndh1,ndh2,ida,idb
      real    err
*
      integer ivltyq,isltyq
#endif
*
*-----------------------------------------------------------------------
*
#if ( !defined(ROOT) )
      txterr = 'Root not in this Mn_Fit version'
      call mn_err('MN_ROOTF',txterr)
      goto 9000
#else
      ndhis0 = ndhis
*
*     Can either give a range of identifiers - histograms are then
*     assumed to be h100 etc. or a single histogram name
*
      nidl = 0
2000  continue
      call waityq('Give histogram number(s) or name: ')
      ndum = ivltyq(.true.,idelim)
      if(ndum.ge.0 .and. idelim.eq.0) then
        call restyq
        call mn_hrn(ida1,ida2,idb1,idb2,idelim,nnid)
        if(nnid.le.0) goto 9000
        if(nnid.gt.1) then
          call m_emsg('MN_ROOTF','Root does not know about' //
     1     ' secondary identifiers')
          call mn_err('MN_ROOTF','It will be ignored')
        endif
c       
        if(nidl.ge.100) then
          write(luntto
     +     ,'('' *** MN_ROOTF: Ran out of space to store plot''
     1     ,'' numbers to get''
     2     ,/,13X,'' Issue ROOT_FETCH command again to get more plots.'')
     2     ')
          goto 3000
        endif
*       
        nidl = nidl + 1
        idlsa1(nidl) = ida1
        idlsa2(nidl) = ida2
        idlsb1(nidl) = idb1
        idlsb2(nidl) = idb2
*
*       Get the histogram(s)
*       
        call mn_rootr(ida1,ida2,idb1,idb2,nnid)
      else
        nnid = 1
        call restyq
        nchar = isltyq(.true.,idelim,tid)
        if(nchar.le.0) goto 9000
*
*       Get a single histogram
*
        call mn_rooth(tid,ida,idb,ierr)
        if(ierr.ne.0) then
          txterr = 'Error fetching histogram ' // tid
          call mn_err('MN_ROOTF',txterr)
          goto 8000
        endif
        nidl = 1
        idlsa1(nidl) = ida
        idlsa2(nidl) = ida
        idlsb1(nidl) = idb
        idlsb2(nidl) = idb
      endif
      if(idelim.eq.0) goto 2000
3000  continue
*
8000  continue
*
*     Check that I got the histograms I wanted
*
      if(nnid.eq.1) then
          nnid = 2
          do 8100 nl=1,nidl
              if(idlsa1(nl).eq.0) then
                  idlsb1(nl) = 0
                  idlsb2(nl) = 999
              endif
8100      continue
      endif
      call mn_hng('MN_ROOTF',nnid,ndhis0,nidl,idlsa1,idlsa2
     1 ,idlsb1,idlsb2)
*
*     Make sure that the 1 and 2 dimensional histograms get errors
*     stored as well
*
      nmode = 1
      err   = 0.0
      ndh1 = ndhis0 + 1
      ndh2 = ndhis
      do 8500 nh=ndh1,ndh2
          ida = idida(nh)
          idb = ididb(nh)
          call mn_hgt(ida,idb,nh)
          if((ndim.eq.1 .or. ndim.eq.2) .and. nwppt.eq.1) then
              call mn_erc(ida,idb,nmode,err)
          endif
8500  continue
#endif
*
9000  continue
      end
