      SUBROUTINE MN_SHW(COMMIN)
C
C------------------------------------------------------------------------------
C     Shows the current values of parameters.
C     There are some special cases. Otherwise the command is passed to MN_SET.
C------------------------------------------------------------------------------
C
      IMPLICIT NONE
C
      EXTERNAL FCN,FUTIL
C
#include "mnpar.inc"
#include "mndat.inc"
#include "mnfit.inc"
#include "mnfun.inc"
#include "mnflg.inc"
#include "mnroot.inc"
#include "mnhpj.inc"
#include "mnplt.inc"
#include "mnprs.inc"
#include "mngrn.inc"
#include "mncmd.inc"
#include "mntim.inc"
#include "mntyq.inc"
#include "mnlun.inc"
C
      CHARACTER*(*) COMMIN
C
      CHARACTER*80 TITLE,TSHOW
      LOGICAL QEXIST,QMNHEX
      LOGICAL QPLOT
C
      CHARACTER*1 TTAX(3)
C
      INTEGER MSHOW
      PARAMETER (MSHOW=31)
      CHARACTER*10 SHONAM(MSHOW)
C
      INTEGER I,II,JJ,JCMD,ISTR,NSHOW,IDELIM,IERR,NH,NTLEN,IOERR
     + ,IDA,IDB,NNID,NNP,NP,NAX,LENPR
      INTEGER LENOCC
      INTEGER ISTRNQ,ICMTYQ
C
      DATA SHONAM/
     1 'ALL',       'EXCLUSIONS', 'INCLUSIONS', 'CONSTRAINT',
     + 'FLAGS',     'SIZES',
     2 'SCALE',     'FRAME',      'LIMIT',      'MODE',
     + 'TICKS',     'AXIS',       'LABEL',
     4 'DIRECTORY', 'ORDER',      'TIME',
     5 'COMMENTS',  'KEYS',       'CUTS',
     6 'LOG',       'REGISTER',   'VARIABLE',
     7 'PLOT',      'COMMANDS',   'DEFINITION', 'FILES',     'UNITS',
     8 'ALIAS',     'COMIS',      'SEGMENTS',
     Z ' '/
      DATA TTAX/'X','Y','Z'/
C
      QPLOT =.FALSE.
      IF(COMMIN.NE.' ') THEN
          DO 500 I=1,MSHOW
              IF(COMMIN.EQ.SHONAM(I)) THEN
                  JCMD = I
                  GOTO 1010
              ENDIF
500       CONTINUE
      ENDIF
C
C     Store the complete SHOW command, so that if SHOW for a
C     particular plot is asked for it can be passed onto MN_SET if necessary.
C
1000  CONTINUE
      CALL WAITYQ('Show what or ?: ')
      IF(.NOT.QPLOT) THEN
          ISTR = ISTRNQ(.TRUE.,TSHOW,NSHOW)
          IF(NSHOW.LE.0) GOTO 9000
          CALL RESTYQ
      ENDIF
      JCMD = ICMTYQ(.TRUE.,IDELIM,SHONAM)
      IF(JCMD.LT.0 .AND. IDELIM.EQ.ICHAR('?')) THEN
          CALL QUOTYQ('SHOW')
          IDELIM = 0
          CALL MN_HLP(IDELIM,IERR)
          GOTO 1000
      ENDIF
1010  CONTINUE
      IF(JCMD.GT.0) COMND2 = SHONAM(JCMD)
C
C     If the command is not recognized by SHOW try SET.
C
      IF(JCMD.EQ.0 .OR. IDELIM.GT.0) THEN
          CALL MN_DCK(IDELIM,JCMD,MSHOW,SHONAM,IERR)
          IF(IERR.EQ.2) THEN
              IF(QPLOT) THEN
                  CALL QUOTYQ(TSHOW)
              ELSE
                  CALL RESTYQ
              ENDIF
              IDELIM = 0
              CALL MN_SET(IDELIM)
          ENDIF
          GOTO 9000
      ELSEIF(JCMD.LT.0) THEN
          GOTO 9000
      ENDIF
C
C     SHOW THE PLOTS BEING MADE
C
      IF(COMND2.EQ.'ALL' .OR. COMND2.EQ.'PLOT') THEN
          IF(IDELIM.LT.0 .AND. .NOT.QPLOT) THEN
              WRITE(LUNTTO,'('' There are'',I3,'' plots in the buffer:''
     1         ,/,'' List of plots:  ''
     2         ,/,5X,''Plot'',3X,''Symbol'',3X,''Flags'',10X
     1         ,''Title'')') NHPLT
              DO 2000 I=1,NHPLT
                  QEXIST=QMNHEX(IPLTIA(I),IPLTIB(I),NH)
                  IF(QEXIST) THEN
                      TITLE = TDTIT(NH)
                      NTLEN = LENOCC(TITLE)
                      IF(NTLEN.LE.0) NTLEN = 1
                  ELSE
                      TITLE = ' '
                      NTLEN = 1
                  ENDIF
                  WRITE(LUNTTO,'((I7,I4,1X,I5,2X,2I4,1X,A))'
     1             ,IOSTAT=IOERR)
     1             IPLTIA(I),IPLTIB(I),IPLTSY(I),IPLTFL(I),IPLTCL(I)
     2             ,TITLE(1:NTLEN)
2000          CONTINUE
          ENDIF
C
          IF(COMND2.EQ.'PLOT') THEN
              QPLOT = .FALSE.
              CALL WAITYQ(
     1         'Give plot you want more information on or <CR>: ')
              CALL MN_HNO(IDA,IDB,IDELIM,NNID)
              IF(NNID.LE.0 .OR. IDA.EQ.0) GOTO 9000
              DO 2100 NNP=1,NHPLT
                  IF(IDA.EQ.IPLTIA(NNP) .AND. IDB.EQ.IPLTIB(NNP)) THEN
                      QPLOT = .TRUE.
                      NP = NNP
                      GOTO 1000
                  ENDIF
2100          CONTINUE
              WRITE(LUNTTO,'('' Plot'',I7,I4
     1         ,'' is not being plotted'')') IDA,IDB
          ENDIF
      ENDIF
C
C     SHOW EXCLUSIONS
C
      IF((COMND2.EQ.'ALL' .OR.
     +    COMND2.EQ.'EXCLUSIONS' .OR. COMND2.EQ.'INCLUSIONS') .AND.
     1   .NOT.QPLOT) THEN
          IF(NHFIT.GT.0) THEN
              DO 2500 NH=1,NHFIT
                  CALL M_EXCL(0,NH,LUNTTO,IDELIM)
2500          CONTINUE
          ELSEIF(COMND2.EQ.'EXCLUSIONS' .OR. COMND2.EQ.'INCLUSIONS')THEN
              WRITE(LUNTTO,'('' Exclusions and inclusions are''
     1         ,'' only valid inside MINUIT'')')
          ENDIF
      ENDIF
C
C     Show Constraints
C
      IF((COMND2.EQ.'ALL' .OR. COMND2.EQ.'CONSTRAINT') .AND.
     1   .NOT.QPLOT) THEN
          IF(NHFIT.GT.0) THEN
              CALL M_CSTR(0,IDELIM,FCN,FUTIL)
          ELSEIF(COMND2.EQ.'CONSTRAINT') THEN
              WRITE(LUNTTO,'('' Constraints are''
     1         ,'' only valid inside MINUIT'')')
          ENDIF
      ENDIF
C
      IF(COMND2.EQ.'ALL' .OR. COMND2.EQ.'FLAGS') THEN
          WRITE(LUNTTO,10500)
10500     FORMAT(/,' The following logical flags control what is'
     1     ,' shown on the plots'
     2     ,/,' (The SET command is given in parentheses):')
          IF(QPLOT) THEN
              WRITE(LUNTTO,10510,IOSTAT=IOERR) NDIDB,idroot
     1         ,QSBOX,NDMODE,NSHEAD,QSTEXT
     2         ,NSID,QTITLP(1,NP),QTUSER,QTGLBL
              WRITE(LUNTTO,10515,IOSTAT=IOERR) QSEXCL
     3         ,QENULL,QSNULL
     4         ,QWIND,QASCAL,QATRIM,QIGARC
              WRITE(LUNTTO,10520,IOSTAT=IOERR) (IWIND(JJ),JJ=1,2)
     1         ,(WSPACE(JJ),JJ=1,2),(QZEROP(JJ,NP),JJ=1,2)
     2         ,(IZEROP(JJ,NP),JJ=1,2)
     2         ,((IGRIDP(II,JJ,NP),JJ=1,2),II=1,2)
          ELSE
              WRITE(LUNTTO,10510,IOSTAT=IOERR) NDIDB,idroot
     1         ,QSBOX,NDMODE,NSHEAD,QSTEXT
     2         ,NSID,QTITLS(1),QTUSER,QTGLBL
              WRITE(LUNTTO,10515,IOSTAT=IOERR) QSEXCL
     3         ,QENULL,QSNULL
     4         ,QWIND,QASCAL,QATRIM,QIGARC
              WRITE(LUNTTO,10520,IOSTAT=IOERR) (IWIND(JJ),JJ=1,2)
     1         ,(WSPACE(JJ),JJ=1,2),(QZEROS(JJ),JJ=1,2)
     2         ,(IZEROS(JJ),JJ=1,2)
     2         ,((IGRIDS(II,JJ),JJ=1,2),II=1,2)
          ENDIF
10510     FORMAT(' Default secondary identifier',T40,'(IDB)',T55,I4
     1        ,/,' Default root identifier                '
     +     ,T40,'(IDR)',T51,I8
     1        ,/,' Draw a box around the plot             '
     1     ,T40,'(BOX)',T55,L4
     2        ,/,' Mode for display command               '
     2     ,T40,'(DISPLAY)',T55,I4
     3        ,/,' Mode for showing fit info on plot      '
     3     ,T40,'(HEADER)',T55,L4
     4        ,/,' Show fit information on softcopy plot  '
     4     ,T40,'(TEXT)',T55,L4
     5        ,/,' Mode for showing histogram identiers   '
     5     ,T40,'(IDSHOW)',T55,I4
     6        ,/,' Show histogram title on plot           '
     6     ,T40,'(TITLE)',T55,L4
     6        ,/,' Show user title on plot           '
     6     ,T40,'(USER)',T55,L4
     6        ,/,' Show global title on plot           '
     6     ,T40,'(GLOBAL)',T55,L4)
10515     FORMAT(' Show exclusions on plot                '
     7     ,T40,'(EXCLUSIONS)',T55,L4
     8        ,/,' Set error on zero points to 1'
     8     ,T40,'(ERR_ZERO)',T55,L4
     9        ,/,' Show zero points with zero error'
     9     ,T40,'(SHOW_ZERO)',T55,L4
     A        ,/,' Draw more then one plot on a picture   '
     A     ,T40,'(WINDOW)',T55,L4
     A        ,/,' Rescale text sizes when windowing      '
     A     ,T40,'(AUTOSCALE)',T55,L4
     A        ,/,' Drop scale on last point when windowing'
     A     ,T40,'(AUTOTRIM)',T55,L4
     A        ,/,' Use HIGZ routines for circles and arcs'
     A     ,T40,'(IGARC)',T55,L4)
10520     FORMAT(/,T55,7X,'X',T69,7X,'Y'
     +        ,/,' Number of windows'
     +     ,T40,'(WINDOW)',T55,I8,T69,I8
     +        ,/,' Spacing between windows'
     +     ,T40,'(WINDOW)',T55,F8.2,T69,F8.2
     +        ,/,' Draw a line at 0'
     1     ,T40,'(X|Y ZERO)',T55,L8,T69,L8
     5        ,/,' Symbol for line'
     5     ,T40,'(X|Y ZERO)',T55,I8,T69,I8
     5        ,/,' Symbol for grid (0=no grid)'
     5     ,T40,'(X|Y GRID)',T55,I8,T69,I8
     5        ,/,' Mode for grid (1=Big, 2=All ticks'
     5     ,T40,'(X|Y GRID)',T55,I8,T69,I8)
C
          WRITE(LUNTTO,10600)
10600     FORMAT(/,' The following logical flags control'
     1     ,' fitting and functions'
     2     ,/,' (The SET command is given in parentheses):')
          WRITE(LUNTTO,10610,IOSTAT=IOERR)
     +      QFINTG,NFINTG,QFCONV,RFCONV(1),QFAREA
     +     ,QFBINW,NFPNT,NINTFT,FNSTEP
10610     FORMAT(' Integrate across bins: '
     1     ,T40,'(FIT INTEGRATE)',T60,L4
     1        ,/,' Number of intervals: ',T60,I4
     2        ,/,' Convolute with a Gaussian: '
     2     ,T40,'(FIT CONVOLUTE)',T60,L4
     2        ,/,' Width of Gaussian: ',T60,1PG12.4
     2        ,/,' Calculate area for complicated functions'
     2     ,T40,'(FIT AREA)',T60,L4
     3        ,/,' Use bin width in functions: '
     3     ,T40,'(FUNCTION BIN_WIDTH)',T60,L4
     3        ,/,' Number of points to draw: '
     3     ,T40,'(FUNCTION POINTS)',T60,I4
     3        ,/,' Integration intervals: '
     3     ,T40,'(FUNCTION INTEGRATE)',T60,I4
     3        ,/,' Step size for differentiation: '
     3     ,T40,'(FUNCTION STEP)',T60,L4)
      ENDIF
C
      IF(COMND2.EQ.'ALL' .OR. COMND2.EQ.'SIZES') THEN
          WRITE(LUNTTO,11000)
11000     FORMAT(/,' The following values have been set'
     1     ,' for plotting'
     2     ,/,' (The SET command is given in parentheses):')
          IF(QPLOT) THEN
              WRITE(LUNTTO,11100,IOSTAT=IOERR)
     1         IPLTSY(NP),IPLTHA(NP),IPLTPA(NP)
     1         ,IPLTCO(1,NP),ipltco(2,np),ipltco(3,np)
     1         ,TITGP(3,NP),TITLP(3,NP),(TSZEP(II,NP),II=2,5)
     2         ,ALEGP(1,NP),ALEGP(2,NP)
          ELSE
              WRITE(LUNTTO,11100,IOSTAT=IOERR)
     +         NSYMS,NHATS,NPATS
     +         ,ICOLS(7),icols(8),icols(9)
     1         ,TITGS(3),TITLS(3),(TSZES(II),II=2,5)
     +         ,ALEGS(1),ALEGS(2)
          ENDIF
11100     FORMAT(
     2         /,' Symbol number           ',T40,'(SYMBOL)',T55,I4
     2        ,/,' Hatch number            ',T40,'(HATCH)',T55,I4
     2        ,/,' Pattern number          ',T40,'(PATTERN)',T55,I4
     2        ,/,' Symbol colour           ',T40,'(COLOUR)',T55,I4
     2        ,/,' Symbol colour           ',T40,'(COLOUR)',T55,I4
     2        ,/,' Symbol colour           ',T40,'(COLOUR)',T55,I4
     6        ,/,' Global/user title size  '
     6      ,T40,'(GSIZE)',T55,F6.2,' cm'
     6        ,/,' Title size          '
     6      ,T40,'(TSIZE)',T55,F6.2,' cm'
     7        ,/,' Text size in fit display'
     7      ,T40,'(USIZE)',T55,F6.2,' cm'
     3        ,/,' Header text size        '
     3      ,T40,'(IDSIZE)',T55,F6.2,' cm'
     3        ,/,' Symbol size             '
     3      ,T40,'(SSIZE)',T55,F6.2,' cm'
     3        ,/,' Unit size for lines     '
     3      ,T40,'(LSIZE)',T56,F6.3,' of picture size'
     6        ,/,' Theta for lego plots',T55,F6.0,' degrees'
     7        ,/,' Phi for lego plots',  T55,F6.0,' degrees')
C
          WRITE(LUNTTO,12000)
12000     FORMAT(/,' Variables specific to axes (all sizes in cm,'
     1     ,' angles in degrees).'
     1     ,/,' (The SET command is given in parentheses.)'
     1     ,/,T50,10X,'X',T64,10X,'Y')
          IF(QPLOT) THEN
              WRITE(LUNTTO,12100,IOSTAT=IOERR) SIZES(1),SIZES(2)
     1         ,HSZEP(1,NP),HSZEP(2,NP),AMRGP(1,NP),AMRGP(2,NP)
     1         ,IPWNDP(1,NP),IPWNDP(2,NP)
              WRITE(LUNTTO,12110,IOSTAT=IOERR)
     1         WMRGP(1,NP),WMRGP(2,NP),WSZEP(1,NP),WSZEP(2,NP)
          ELSE
              WRITE(LUNTTO,12100,IOSTAT=IOERR)
     1         SIZES(1),SIZES(2),HSZES(1),HSZES(2)
     1         ,AMRGS(1),AMRGS(2)
     1         ,IPWNDS(1),IPWNDS(2)
              WRITE(LUNTTO,12110,IOSTAT=IOERR)
     1         WMRGS(1),WMRGS(2),WSZES(1),WSZES(2)
          ENDIF
12100     FORMAT(' Overall size of picture  '
     1     ,T40,'(PSIZE)',T50,F11.2,T64,F11.2
     2        ,/,' Overall size of plot'
     2     ,T40,'(SIZE)',T50,F11.2,T64,F11.2
     3        ,/,' Left (bottom) margin size '
     3     ,T40,'(MARGIN)',T50,F11.2,T64,F11.2
     4        ,/,' Current window number'
     4     ,T40,'(WINDOW)',T50,I11,T64,I11
     Z     )
12110     FORMAT(' Offset of plot from nominal position'
     1     ,T40,'(WMARGIN)',T50,F11.2,T64,F11.2
     2        ,/,' Size of individual plot'
     2     ,T40,'(WSIZE)',T50,F11.2,T64,F11.2
     Z     )
      ENDIF
C
      IF(COMND2.EQ.'ALL'   .OR. COMND2.EQ.'SCALE' .OR.
     +   comnd2.eq.'FRAME' .or. comnd2.eq.'LIMIT' .or.
     +   comnd2.eq.'MODE') THEN
          IF(QPLOT) THEN
              WRITE(LUNTTO,13000,IOSTAT=IOERR)
     1          ((ALIMP(II,JJ,NP),JJ=1,3),II=1,2)
     1         ,((QFRAMP(II,JJ,NP),JJ=1,3),II=1,2)
     1         ,((QSCALP(II,JJ,NP),JJ=1,3),II=1,2)
     2         ,(SCLMOD(ISMODP(JJ,NP)+1),JJ=1,3)
              WRITE(LUNTTO,13010,IOSTAT=IOERR)
     3          ((SCALP(II,JJ,NP),JJ=1,3),II=1,4)
     4         ,((NINT(SCALP(II,JJ,NP)),JJ=1,3),II=5,6)
     5         ,(SCALP(7,JJ,NP),JJ=1,3)
     5         ,(NINT(SCALP(8,JJ,NP)),JJ=1,3)
          ELSE
              WRITE(LUNTTO,13000,IOSTAT=IOERR)
     1          ((ALIMS(II,JJ),JJ=1,3),II=1,2)
     1         ,((QFRAMS(II,JJ),JJ=1,3),II=1,2)
     1         ,((QSCALS(II,JJ),JJ=1,3),II=1,2)
     2         ,(SCLMOD(ISMODS(JJ)+1),JJ=1,3)
              WRITE(LUNTTO,13010,IOSTAT=IOERR)
     3          ((SCALS(II,JJ),JJ=1,3),II=1,4)
     4         ,((NINT(SCALS(II,JJ)),JJ=1,3),II=5,6)
     5         ,(SCALS(7,JJ),JJ=1,3)
     5         ,(NINT(SCALS(8,JJ)),JJ=1,3)
          ENDIF
13000     FORMAT(/,' Mode, position and size of scale.'
     1     ,/,' (The SET command is given in parentheses.)'
     1     ,/,T40,7X,'X',T54,7X,'Y',T68,7X,'Z'
     2     ,/,' Lower limit on scale     '
     2     ,T25,'(X|Y|Z LIMIT)',T40,G11.4,T54,G11.4,T68,G11.4
     3     ,/,' Upper limit on scale     '
     3     ,T25,'(X|Y|Z LIMIT)',T40,G11.4,T54,G11.4,T68,G11.4
     4     ,//,T44,10X,'X',T56,10X,'Y',T68,10X,'Z'
     4     ,/,' Draw frame at bottom (left)'
     4     ,T30,'(FRAME)',T44,10X,L1,T56,10X,L1,T68,10X,L1
     4     ,/,' Draw frame at top (right)'
     4     ,T30,'(FRAME)',T44,10X,L1,T56,10X,L1,T68,10X,L1
     4     ,/,' Draw scale at bottom (left)'
     4     ,T30,'(SCALE)',T44,10X,L1,T56,10X,L1,T68,10X,L1
     4     ,/,' Draw scale at top (right)'
     4     ,T30,'(SCALE)',T44,10X,L1,T56,10X,L1,T68,10X,L1
     5     ,/,' Mode for scale'
     5     ,T30,'(MODE)',T44,3X,A7,T56,3X,A7,T68,3X,A7)
13010     FORMAT(
     6        ' X offset of scale numbers'
     6     ,T30,'(SCALE X|Y)',T44,F11.2,T56,F11.2,T68,F11.2
     7     ,/,' Y offset of scale numbers'
     6     ,T30,'(SCALE X|Y)',T44,F11.2,T56,F11.2,T68,F11.2
     5     ,/,' Size of scale numbers    '
     6     ,T30,'(SCALE X|Y)',T44,F11.2,T56,F11.2,T68,F11.2
     6     ,/,' Angle of scale to horizontal'
     6     ,T30,'(SCALE X|Y)',T44,F11.2,T56,F11.2,T68,F11.2
     7     ,/,' Maximum number of digits'
     7     ,T30,'(SCALE X|Y)',T44,I11,T56,I11,T68,I11
     8     ,/,' Number of decimal places'
     7     ,T30,'(SCALE X|Y)',T44,I11,T56,I11,T68,I11
     9     ,/,' Multiplication factor'
     6     ,T30,'(SCALE X|Y)',T44,F11.2,T56,F11.2,T68,F11.2
     9     ,/,' Font'
     6     ,T30,'(SCALE X|Y)',T44,I11,T56,I11,T68,I11
     Z    )
      ENDIF
C
      IF(COMND2.EQ.'ALL' .OR. COMND2.EQ.'TICKS') THEN
          IF(QPLOT) THEN
              WRITE(LUNTTO,14000,IOSTAT=IOERR)
     1          ((QTICKP(II,JJ,NP),JJ=1,3),II=1,4)
              WRITE(LUNTTO,14010,IOSTAT=IOERR)
     1          ((NINT(TICKP(II,JJ,NP)),JJ=1,3),II=1,3)
     2         ,((TICKP(II,JJ,NP),JJ=1,3),II=4,5)
     2         ,((TICKP(II,JJ,NP),JJ=1,3),II=6,7)
          ELSE
              WRITE(LUNTTO,14000,IOSTAT=IOERR)
     1          ((QTICKS(II,JJ),JJ=1,3),II=1,4)
              WRITE(LUNTTO,14010,IOSTAT=IOERR)
     1          ((NINT(TICKS(II,JJ)),JJ=1,3),II=1,3)
     2         ,((TICKS(II,JJ),JJ=1,3),II=4,5)
     2         ,((TICKS(II,JJ),JJ=1,3),II=6,7)
          ENDIF
14000     FORMAT(/,' Tick numbers and sizes'
     1     ,/,' Use the SET X|Y|Z TICK command to change things'
     1     ,/,T44,10X,'X',T56,10X,'Y',T68,10X,'Z'
     2     ,/,' Ticks on bottom (left) inside'
     2     ,T30,'(TICK)',T44,10X,L1,T56,10X,L1,T68,10X,L1
     2     ,/,' Ticks on bottom (left) outside'
     2     ,T33,'(TICK)',T44,10X,L1,T56,10X,L1,T68,10X,L1
     2     ,/,' Ticks on top (right) inside'
     2     ,T30,'(TICK)',T44,10X,L1,T56,10X,L1,T68,10X,L1
     2     ,/,' Ticks on top (right) outside'
     2     ,T30,'(TICK)',T44,10X,L1,T56,10X,L1,T68,10X,L1)
14010     FORMAT(
     2        ' Total number of ticks    '
     2     ,T30,'(TICK X|Y)',T44,I11,T56,I11,T68,I11
     3     ,/,' Frequency of big ticks   '
     2     ,T30,'(TICK X|Y)',T44,I11,T56,I11,T68,I11
     4     ,/,' Offset of big ticks      '
     2     ,T30,'(TICK X|Y)',T44,I11,T56,I11,T68,I11
     5     ,/,' Tick size                '
     2     ,T30,'(TICK X|Y)',T44,F11.2,T56,F11.2,T68,F11.2
     6     ,/,' Big tick size            '
     2     ,T30,'(TICK X|Y)',T44,F11.2,T56,F11.2,T68,F11.2
     7     ,/,' Lower limit for drawing ticks'
     2     ,T30,'(TICK X|Y)',T44,1PG11.4,T56,1PG11.4,T68,1PG11.4
     8     ,/,' Upper limit for drawing ticks'
     2     ,T30,'(TICK X|Y)',T44,1PG11.4,T56,1PG11.4,T68,1PG11.4)
      ENDIF
C
      IF(COMND2.EQ.'ALL' .OR. COMND2.EQ.'AXIS' .OR.
     1   COMND2.EQ.'LABEL') THEN
          WRITE(LUNTTO,15000,IOSTAT=IOERR)
15000     FORMAT(/,' Axis labels and position of labels:'
     1     ,/,' Use the SET LABEL command to change things')
          DO 5100 NAX=1,3
              IF(QPLOT) THEN
                  LENPR = ILABLP(NAX,NP)
                  IF(LENPR.EQ.0) LENPR = 1
                  WRITE(LUNTTO,15100,IOSTAT=IOERR)
     1             TTAX(NAX),TLABLP(NAX,NP)(1:LENPR)
              ELSE
                  LENPR = ILABLS(NAX)
                  IF(LENPR.EQ.0) LENPR = 1
                  WRITE(LUNTTO,15100,IOSTAT=IOERR)
     1             TTAX(NAX),TLABLS(NAX)(1:LENPR)
              ENDIF
5100      CONTINUE
15100     FORMAT(1X,A,' axis label: ',A)
          IF(QPLOT) THEN
              WRITE(LUNTTO,15200,IOSTAT=IOERR)
     1          ((QLABLP(II,JJ,NP),JJ=1,3),II=1,3)
     1         ,((ALABLP(II,JJ,NP),JJ=1,3),II=1,4)
     2         ,(OPTNAM(NINT(ALABLP(5,JJ,NP))+2),JJ=1,3)
     1         ,(NINT(ALABLP(6,JJ,NP)),JJ=1,3)
          ELSE
              WRITE(LUNTTO,15200,IOSTAT=IOERR)
     1          ((QLABLS(II,JJ),JJ=1,3),II=1,3)
     1         ,((ALABLS(II,JJ),JJ=1,3),II=1,4)
     2         ,(OPTNAM(NINT(ALABLS(5,JJ))+2),JJ=1,3)
     1         ,(NINT(ALABLS(6,JJ)),JJ=1,3)
          ENDIF
15200     FORMAT(/,' Positions of axis labels:'
     1       ,T44,10X,'X',T56,10X,'Y',T68,10X,'Z'
     2     ,/,' Draw label at bottom (left)'
     2     ,T30,'(LABEL)',T44,10X,L1,T56,10X,L1,T68,10X,L1
     2     ,/,' Draw label at top (right)'
     2     ,T30,'(LABEL)',T44,10X,L1,T56,10X,L1,T68,10X,L1
     2     ,/,' One label per page       '
     2     ,T30,'(LABEL)',T44,10X,L1,T56,10X,L1,T68,10X,L1
     2     ,/,' X offset of axis labels  '
     2     ,T30,'(LABEL X|Y)',T44,1PG11.4,T56,1PG11.4,T68,1PG11.4
     3     ,/,' Y offset of axis labels  '
     2     ,T30,'(LABEL X|Y)',T44,1PG11.4,T56,1PG11.4,T68,1PG11.4
     4     ,/,' Size of axis labels      '
     2     ,T30,'(LABEL X|Y)',T44,1PG11.4,T56,1PG11.4,T68,1PG11.4
     5     ,/,' Angle of axis labels     '
     2     ,T30,'(LABEL X|Y)',T44,1PG11.4,T56,1PG11.4,T68,1PG11.4
     6     ,/,' Option for writing label '
     6     ,T30,'(LABEL X|Y)',T44,5X,A6,T56,5X,A6,T68,5X,A6
     9     ,/,' Font'
     6     ,T30,'(LABEL X|Y)',T44,I11,T56,I11,T68,I11)
      ENDIF
C
      CALL M_SHWG(IDELIM,QPLOT,NP)
C
 9000 CONTINUE
      END
