      SUBROUTINE cleo_LOKLUN( ILUN, CRNAME )
C.......................................................................
C.
C. LOKLUN - Permanent allocation of a unit, cannot be unlocked!
C.
C. Inputs    : ILUN   - Unit number to lock
C.           : CRNAME - CHARACTER name of calling routine
C. Outputs   : ILUN   - Set to -1 if locking fails
C. COMMON    : LUNMCI LUNMCC
C. Calls     : CLTOU  ERRLUN
C. Called    : <USER>
C.
C.......................................................................
C
C------------------------- Argument declarations -----------------------
C
      CHARACTER*(*) CRNAME
      INTEGER ILUN
C
C------------------------- EXTERNAL declarations -----------------------
C
* None
C
C------------------------- SEQUENCE declarations -----------------------
C
C
* LUNMIN - Smallest allowed LUN number
* LUNMAX - Largest  allowed LUN number
* MAXLUN - Length of the    LUN number allocation table
*
      INTEGER    LUNMIN,     LUNMAX
      PARAMETER( LUNMIN = 1, LUNMAX = 99 )
*
      INTEGER    MAXLUN
      PARAMETER( MAXLUN = LUNMAX - LUNMIN + 1 )
*
* LISUSE - Flag for LUN is in use
* LISFRE - Flag for LUN is free
* LISLOK - Flag for LUN is locked
*
      INTEGER    LISUSE,     LISFRE,     LISLOK
      PARAMETER( LISUSE = 1, LISFRE = 0, LISLOK = -1 )
*
* LUSEER - Error, LUN in use
* LRNGER - Error, LUN number out of range
* LTABER - Error, LUN allocation table corrupted
* LFULER - Error, LUN allocation table full
* LLOKER - Error, LUN is already locked
* LFLKER - Error, LUN is locked, cannot be freed
* LINIER - Error, in initialization
* LUALER - Error, found unalloacted unit connected to file
* LNONAM - Warning, Allocator name is blank
* LDIFER - Warning, Allocator and deallocator are different
*
      INTEGER    LUSEER,     LRNGER,     LTABER,     LFULER
      PARAMETER( LUSEER = 1, LRNGER = 2, LTABER = 3, LFULER = 4 )
      INTEGER    LLOKER,     LFLKER,     LINIER,     LUALER
      PARAMETER( LLOKER = 5, LFLKER = 6, LINIER = 7, LUALER = 8 )
      INTEGER    LNONAM,     LDIFER
      PARAMETER( LNONAM = 9, LDIFER =10                         )
*
* LUNTBL - The LUN allocation table
* LUNOWN - The LUN allocation owner table
*
      INTEGER         LUNTBL
      COMMON /LUNMCI/ LUNTBL(LUNMIN:LUNMAX)
      CHARACTER*8     LUNOWN
      COMMON /LUNMCC/ LUNOWN(LUNMIN:LUNMAX)
C
C------------------------- Local    declarations -----------------------
C
      INTEGER JLUN
      LOGICAL LFIRST
C
C------------------------- SAVE     declarations -----------------------
C
      SAVE LFIRST
C
C------------------------- DATA  initializations -----------------------
C
      DATA LFIRST /.TRUE./
C
C---------------------- Executable code starts here --------------------
C

      IF( LFIRST ) THEN
         LFIRST = .FALSE.
         CALL CLEO_INILUN
      ENDIF
C
C== Check validity of ILUN
C
      JLUN = -1
      IF( ILUN.LT.LUNMIN .OR. ILUN.GT.LUNMAX ) THEN
C
C== Error if ILUN is out of range
C
         CALL CLEO_ERRLUN( 'LOKLUN', ILUN, LRNGER, ' ' )

      ELSEIF( LUNTBL(ILUN).EQ.LISLOK ) THEN
C
C== Error if ILUN is already locked
C
         CALL CLEO_ERRLUN( 'LOKLUN', ILUN, LLOKER, ' ' )

      ELSEIF( LUNTBL(ILUN).EQ.LISUSE ) THEN
C
C== Error if ILUN is already allocated
C
         CALL CLEO_ERRLUN( 'LOKLUN', ILUN, LUSEER, ' ' )

      ELSEIF( LUNTBL(ILUN).EQ.LISFRE ) THEN
C
C== Allocate it if it is free
C
         LUNTBL(ILUN) = LISLOK
         JLUN         = ILUN
         IF( CRNAME.EQ.' ' ) THEN
            CALL CLEO_ERRLUN( 'LOKLUN', ILUN, LNONAM, ' ' )
         ENDIF
         LUNOWN(ILUN) = CRNAME
         CALL CLTOU( LUNOWN(ILUN) )

      ELSE
C
C== If none of the above, table must be corrupted
C
         CALL CLEO_ERRLUN( 'LOKLUN', ILUN, LTABER, ' ' )

      ENDIF
C
99    ILUN = JLUN
C
      RETURN
      END
