      DOUBLE PRECISION FUNCTION XMNC2D(NFUN,DPAR,NPAR,NPAR2,X,Y)
C
C------------------------------------------------------------------------------
C     2D Functions
C------------------------------------------------------------------------------
C
      IMPLICIT NONE
C
#include "mnusr.inc"
C
      INTEGER           NFUN,NPAR,NPAR2
      DOUBLE PRECISION  DPAR(*)
      REAL              X,Y
C
      DOUBLE PRECISION  DPX,   DPY,   DELX,  DELY
     +                 ,DXBIN, DYBIN
     +                 ,DZ1,   DZ2,   DZ3
     +                 ,VAL
     +                 ,Z2PI,  ZPI4L2, Z4L2
C
C          Z2PI   =  2 * PI
C          ZPI4L2 =  2 * PI / (4*2*LN(2))
C          Z4L2   =  4*LN(2)
C
      DATA Z2PI   /  6.283185307179586D0 /
      DATA ZPI4L2 /  1.13309D0           /
      DATA Z4L2   /  2.7725887D0 /
C
      XMNC2D = 0.0D0
      DPX    = DBLE( X )
      DPY    = DBLE( Y )
      DXBIN  = DBLE(XBINNM)
      DYBIN  = DBLE(YBINNM)
C
C     2D Gaussian (sigma)
C
      IF(NFUN.EQ.1) THEN
          VAL = DXBIN * DYBIN / Z2PI
          IF(DPAR(4) .NE. 0. .AND. DPAR(5).NE.0.0) THEN
              DELX = DPX - DPAR(2)
              DELY = DPY - DPAR(3)
              DZ1  = 1.0 / (DPAR(4) * DPAR(5))
              DZ2  = -0.5 * ((DELX/DPAR(4))**2 + (DELY/DPAR(5))**2)
              DZ3  = 0.0
              IF(DABS(DZ2).LE.36.0D0) DZ3 = DEXP(DZ2)
              XMNC2D = DZ3 * DZ1 * VAL * DPAR(1)
          ENDIF
C
C     2D Gaussian (FWHM)
C
      ELSEIF(NFUN.EQ.2) THEN
          VAL = DXBIN * DYBIN / ZPI4L2
          IF(DPAR(4) .NE. 0. .AND. DPAR(5).NE.0.0) THEN
              DELX = DPX - DPAR(2)
              DELY = DPY - DPAR(3)
              DZ1  = 1.0 / (DPAR(4) * DPAR(5))
              DZ2  = -Z4L2 * ((DELX/DPAR(4))**2 + (DELY/DPAR(5))**2)
              DZ3  = 0.0
              IF(DABS(DZ2).LE.36.0D0) DZ3 = DEXP(DZ2)
              XMNC2D = DZ3 * DZ1 * VAL * DPAR(1)
          ENDIF
      ENDIF
C
      END
