C
      SUBROUTINE TVRNG(QFORCE, XDO, YDO, XUP, YUP)
C-----
C     SET WINDOW FOR SUBSEQUENT PLOTS
C     ICUNIT = 0 means metres
C              1 means other (probably raster)
C              2 means centimetres
C              3 means millimetres
C-----
C
#include "mngrn.inc"
#include "mnlun.inc"
#include "mndbg.inc"
#include "quest.inc"
C
      LOGICAL QFORCE
      REAL XDO,YDO,XUP,YUP
C
      REAL VECT(4)
C
      SAVE
      INTEGER ICULST
      REAL RXLST,RYLST,SFACT(0:3)
      LOGICAL QSTART,BTEST
C
      DATA ICULST/-1/,RXLST/-1.0/,RYLST/-1.0/
      DATA XDOLST/-1.0/,XUPLST/-1.0/,YDOLST/-1.0/,YUPLST/-1.0/
      DATA SFACT/100.0,1.0,1.0,0.1/
      DATA QSTART/.TRUE./
C
      IF(LPDEV.LE.1) THEN
          IF(LPDEV.LE.0) CALL MN_ERR('TVRNG'
     +    ,'You have not selected any device for output')
          RETURN
      ENDIF
C
C     If all the sizes are the same as last time then don't do anything
C
      IF(.NOT.QFORCE .AND. LPDEV.EQ.NDVLST .AND.
     +   XDO.EQ.XDOLST .AND. XUP.EQ.XUPLST .AND.
     +   YDO.EQ.YDOLST .AND. YUP.EQ.YUPLST) THEN
          RETURN
      ELSE
          XDOLST = XDO
          XUPLST = XUP
          YDOLST = YDO
          YUPLST = YUP
      ENDIF
CC
      GRWIND(1) = XDO
      GRWIND(2) = YDO
      GRWIND(3) = XUP
      GRWIND(4) = YUP
C
      DIFX = GRWIND(3) - GRWIND(1)
      DIFY = GRWIND(4) - GRWIND(2)
C
#if ( defined(HIGZ) )
C
C     GET THE DEVICE SIZE
C
      IF(LPDEV.NE.NDVLST) THEN
C
#endif
#if ( defined(HIGZ) ) && ( defined(X11) )
C
        ICUNIT = 1
        IF(IPUNIT(LPDEV).LT.0) ICUNIT = 2
C
        IF(IPUNIT(LPDEV).NE.-113) THEN
          CALL IGQWK(IPDEV(LPDEV),'MXDS',VECT)
          IERR = 0
          RX = VECT(1)
          RY = VECT(2)
        ENDIF
        IF(IPUNIT(LPDEV).EQ.-113 .OR. RX.LE.0 .OR. RY.LE.0) THEN
          RX = (XUP - XDO) / SFACT(ICUNIT)
          RY = (YUP - YDO) / SFACT(ICUNIT)
        ENDIF
C
#endif
#if ( defined(HIGZ) )
        IF(QDEBUG .AND. BTEST((NDEBUG/100),0)) THEN
          CALL IGSA(IPDEV(LPDEV))
          write(txtmes,'('' Device'',I3,'' is number'',I4,
     +     '' HIGZ type'',I8)')
     +     lpdev,ipdev(lpdev),ipunit(lpdev)
          CALL MN_MES(LUNTTO,'M',TXTMES)
          WRITE(TXTMES,'('' HIGZ thinks this device size is:''
     +     ,2F13.4)',IOSTAT=IOERR) RX,RY
          CALL MN_MES(LUNTTO,'M',TXTMES)
          WRITE(TXTMES,'('' QUEST(11:15) = '',5F9.4)',IOSTAT=IOERR)
     +     (RQUEST(II),II=11,15)
          CALL MN_MES(LUNTTO,'ME',TXTMES)
          CALL IGSG(IPDEV(LPDEV))
        ENDIF
C
        IF(SZMAX(1,LPDEV).EQ.0.0 .AND. SZMAX(2,LPDEV).EQ.0.0 .AND.
     +   IERR.NE.0) THEN
          CALL IGSA(IPDEV(LPDEV))
          WRITE(TXTMES,'('' HIGZ thinks this device size is:''
     +     ,2F13.4)',IOSTAT=IOERR) RX,RY
          CALL MN_MES(LUNTTO,'M',TXTMES)
          WRITE(TXTMES,'('' HIGZ error flag is: '',I6)') IERR
          CALL MN_MES(LUNTTO,'M',TXTMES)
          CALL MN_MES(LUNTTO,'ME'
     +     ,' Device size will be set to 0.2x0.2m')
          CALL IGSG(IPDEV(LPDEV))
          ICUNIT = 0
          RX = 0.2
          RY = 0.2
        ENDIF
C
        RXLST  = RX
        RYLST  = RY
        ICULST = ICUNIT
      ELSE
        RX     = RXLST
        RY     = RYLST
        ICUNIT = ICULST
      ENDIF
C
#endif
#if ( defined(PLTSUB) )
      RX = 0.02
      RY = 0.02
      ICUNIT = 0
#endif

C
C     Sort out the window size
C
      IF(SZMAX(1,LPDEV).GT.0.0 .AND. SZMAX(2,LPDEV).GT.0.0) THEN
          ICUNIT = 2
#if ( defined(HIGZ) )
          XXMAX = SZMAX(1,LPDEV)
          YYMAX = SZMAX(2,LPDEV)
#endif
#if ( defined(PLTSUB) )
          IF(QPVERT(LPDEV)) THEN
              XXMAX = SZMAX(2,LPDEV)
              YYMAX = SZMAX(1,LPDEV)
          ELSE
              XXMAX = SZMAX(1,LPDEV)
              YYMAX = SZMAX(2,LPDEV)
          ENDIF
#endif

      ELSE
          XXMAX = RX*SFACT(ICUNIT)
          YYMAX = RY*SFACT(ICUNIT)
      ENDIF
C
C     See if the output device is big enough and if not scale down the
C     picture.
C
      SCAL = 1.0
      IF(ICUNIT.NE.1) THEN
2000      CONTINUE
          IF(SCAL*DIFX.GT.1.001*XXMAX .OR.SCAL*DIFY.GT.1.001*YYMAX) THEN
              SCAL = SCAL*0.9
              GOTO 2000
          ENDIF
          IF(LPDEV.NE.NDVLST .AND. SCAL.NE.1.0) THEN
              LEND = LENOCC(TPDEV(LPDEV))
              WRITE(TXTMES,'('' TVRNG: Device '',A
     +         ,''  Scaling factor'',F6.3,'' will be used'')')
     +         TPDEV(LPDEV)(1:LEND),SCAL
              CALL MN_MES(LUNTTO,'ME',TXTMES)
          ENDIF
C
C     If the units are raster units set the scale factor also
C     allowing for rounding errors
C
      ELSE
cicb          SCAL = AMIN1(XXMAX/DIFX,YYMAX/DIFY) * 0.995
      ENDIF
C
C     Setup the HIGZ Postscript paper size
C
      IF(IPUNIT(LPDEV).LT.0) THEN
          CALL IGRNG(XXMAX/SCAL,YYMAX/SCAL)
cicb          GOTO 9000
      ENDIF
C
      XOF_GR = ( XXMAX - SCAL*DIFX ) / 2.0
      YOF_GR = ( YYMAX - SCAL*DIFY ) / 2.0
C
#if ( defined(PLTSUB) )
      XOF_GR = XOF_GR * CMTOIN
      YOF_GR = YOF_GR * CMTOIN
#endif

C
      IF ( XOF_GR.LT.-0.001 ) THEN
          XOF_GR = 0.0
          LEND = LENOCC(TPDEV(LPDEV))
          CALL M_EMSG('TVRNG','X-axis too big for ' //
     +     TPDEV(LPDEV)(1:LEND))
      ENDIF
      XOF_GR = AMAX1(XOF_GR,0.0)
C
      IF ( YOF_GR.LT.-0.001 ) THEN
          YOF_GR = 0.0
          LEND = LENOCC(TPDEV(LPDEV))
          CALL M_EMSG('TVRNG','Y-axis too big for ' //
     +     TPDEV(LPDEV)(1:LEND))
      ENDIF
      YOF_GR = AMAX1(YOF_GR,0.0)
C
#if ( defined(HIGZ) )
      XXOFF = OFSET(1,LPDEV)
      YYOFF = OFSET(2,LPDEV)
      XOF_GR = XOF_GR + XXOFF
      YOF_GR = YOF_GR + YYOFF
C
C     POSITION THE PLOT ON THE WORKSTATION
C     GKS WORKS IN METRES
C
      IF(IPLPOS(1,LPDEV).EQ.-1) THEN
          X1 = 0.0
          X2 = SCAL*DIFX / SFACT(ICUNIT)
      ELSEIF(IPLPOS(1,LPDEV).EQ.0) THEN
          X1 = XOF_GR / SFACT(ICUNIT)
          X2 = (XOF_GR + SCAL*DIFX) / SFACT(ICUNIT)
      ELSE
          X1 = (XXMAX - SCAL*DIFX) / SFACT(ICUNIT)
          X2 = XXMAX / SFACT(ICUNIT)
      ENDIF
      IF(IPLPOS(2,LPDEV).EQ.-1) THEN
          Y1 = 0.0
          Y2 = SCAL*DIFY / SFACT(ICUNIT)
      ELSEIF(IPLPOS(2,LPDEV).EQ.0) THEN
          Y1 = YOF_GR / SFACT(ICUNIT)
          Y2 = (YOF_GR + SCAL*DIFY) / SFACT(ICUNIT)
      ELSE
          Y1 = (YYMAX - SCAL*DIFY) / SFACT(ICUNIT)
          Y2 = YYMAX / SFACT(ICUNIT)
      ENDIF
C
C     For X-Windows and HIGZ Postscript set workstation limits to the total
C     picture size.
C
      IF(ICUNIT.EQ.1 .OR. IPUNIT(LPDEV).LT.0) THEN
          X1 = 0.0
          X2 = XXMAX * SCAL
          Y1 = 0.0
          Y2 = YYMAX * SCAL
      ENDIF
C
C     Map the workstation window onto NDC space
C
      ITNR = 2
      IF((X2-X1).GT.(Y2-Y1)) THEN
          XWKWN = 1.0
          YWKWN = (Y2-Y1) / (X2-X1)
          DXWN  = 0.0
cicb          IF(ICUNIT.EQ.1) THEN
cicb              DYWN  = 0.0
cicb          ELSE
              DYWN  = 0.5 * (1.0-YWKWN)
cicb          ENDIF
      ELSE
          XWKWN = (X2-X1) / (Y2-Y1)
          YWKWN = 1.0
cicb          IF(ICUNIT.EQ.1) THEN
cicb              DXWN  = 0.0
cicb          ELSE
              DXWN  = 0.5 * (1.0-XWKWN)
cicb          ENDIF
          DYWN  = 0.0
      ENDIF
C
C     Now map the world co-ordinates onto NDC
C
      IF((DIFX/XWKWN).GT.(DIFY/YWKWN)) THEN
          XWKWC = XWKWN
          YWKWC = DIFY/DIFX * XWKWC
          DXWC  = DXWN
CICB+SELF,IF=HIGZ,IF=-X11.
CICB          DYWC  = 0.0
cicb+SELF,IF=HIGZ,IF=X11.
cicb          DYWC  = MAX(0.0,0.5 * (YWKWN-YWKWC))
cicb+SELF,IF=HIGZ,IF=-X11.
          DYWC  = MAX(0.0,0.5 * (1.0-YWKWC))
#endif
#if ( defined(HIGZ) )
      ELSE
          YWKWC = YWKWN
          XWKWC = DIFX/DIFY * YWKWC
          DYWC  = DYWN
CICB+SELF,IF=HIGZ,IF=-X11.
CICB          DXWC  = 0.0
cicb+SELF,IF=HIGZ,IF=X11.
cicb          DXWC  = MAX(0.0,0.5 * (XWKWN-XWKWC))
cicb+SELF,IF=HIGZ,IF=-X11.
          DXWC  = MAX(0.0,0.5 * (1.0-XWKWC))
#endif
#if ( defined(HIGZ) )
      ENDIF
*
      if(ipunit(lpdev).eq.7878 .or. ipunit(lpdev).eq.7879) then
          dxwc = dxwc - dxwn
          dxwn = 0.0
          dywc = dywc - dywn
          dywn = 0.0
      endif
C
C     For HIGZ Postscript expand the size of the picture in world coordinates to
C     the full size of the page
C
      IF(IPUNIT(LPDEV).LT.0) THEN
      ENDIF
C
      ANTVP(1) = DXWC
      ANTVP(2) = XWKWC + DXWC
      ANTVP(3) = DYWC
      ANTVP(4) = YWKWC + DYWC
C
      IF(QDEBUG .AND. BTEST((NDEBUG/100),0)) THEN
          CALL IGSA(IPDEV(LPDEV))
          WRITE(TXTMES,'('' Dev in workstation coords ''
     +     ,4(1PG13.4))') X1,X2,Y1,Y2
          CALL MN_MES(LUNTTO,'M',TXTMES)
          WRITE(TXTMES,'('' Workstation window (NDC)  ''
     +     ,4F13.4)') XWKWN,YWKWN,DXWN,DYWN
          CALL MN_MES(LUNTTO,'M',TXTMES)
          WRITE(TXTMES,'('' Device in world coords    ''
     +     ,2(1PG13.4))') DIFX,DIFY
          CALL MN_MES(LUNTTO,'M',TXTMES)
          WRITE(TXTMES,'('' World window (NDC)        ''
     +     ,4F13.4)') XWKWC,YWKWC,DXWC,DYWC
          CALL MN_MES(LUNTTO,'ME',TXTMES)
          CALL IGSG(IPDEV(LPDEV))
      ENDIF
C
C     Apply the transformations
C
      CALL ISWKWN(IPDEV(LPDEV),DXWN,XWKWN+DXWN,DYWN,YWKWN+DYWN)
      CALL ISWKVP(IPDEV(LPDEV),X1,X2,Y1,Y2)
C
      CALL ISVP(ITNR,DXWC,XWKWC+DXWC,DYWC,YWKWC+DYWC)
      CALL ISWN(ITNR,0.0,DIFX,0.0,DIFY)
      CALL ISELNT(ITNR)
C
#endif
#if ( defined(PLTSUB) )
C
      XXOFF = OFSET(1,LPDEV) * CMTOIN
      YYOFF = OFSET(2,LPDEV) * CMTOIN
      XOF_GR = XOF_GR + XXOFF
      YOF_GR = YOF_GR + YYOFF
      SSCAL = SCAL * CMTOIN
      XSC_GR = SSCAL
      YSC_GR = SSCAL
      X0_GR = GRWIND(1) * CMTOIN
      Y0_GR = GRWIND(2) * CMTOIN
C
C     Set the Decstation Window Size
C
      IF(TPDEV(LPDEV).EQ.'Decwindows') THEN
          XXSIZE = X0_GR + DIFX * SSCAL
          YYSIZE = Y0_GR + DIFY * SSCAL
          CALL SET_DECW_SIZE(IPUNIT(LPDEV),XXSIZE,YYSIZE)
      ENDIF
C
      CALL PLOT ( XOF_GR, YOF_GR, -3 )
      CALL SCALF( XSC_GR, YSC_GR, X0_GR, Y0_GR)
C
#endif

 9000 CONTINUE
C
C     First 2 times through TVRNG do not just return
C     Hopefully on the second picture it will move to the right spot
C
      IF(QSTART) THEN
          QSTART = .FALSE.
      ELSE
          NDVLST = LPDEV
      ENDIF
C
      END
