      SUBROUTINE MN_HBS(IDELIM)
C
C------------------------------------------------------------------------------
C     Stores histograms in HBOOK4 RZ files
C------------------------------------------------------------------------------
C
#include "mnpar.inc"
#include "mndat.inc"
#include "mnflg.inc"
#include "mncmd.inc"
#include "mnlun.inc"
C
      LOGICAL HEXIST
      LOGICAL QZERO,QRNGE
      CHARACTER*80 TXT1,DIRSAV
C
      INTEGER MSTQUL
      PARAMETER (MSTQUL=3)
      CHARACTER*10 STOQUL(MSTQUL)
      INTEGER IQUAL(10),NQUAL
      LOGICAL QNEW
C
      DATA STOQUL/'NEW','UPDATE',' '/
C
C     Set up default values for qualifiers
C
      QNEW = .TRUE.
C
C     Check for qualifiers
C
      CALL M_QUAL(IDELIM,STOQUL,MSTQUL,IQUAL,NQUAL)
      DO 1000 I=1,NQUAL
          IF(IQUAL(I).EQ.1) THEN
              QNEW = .TRUE.
          ELSEIF(IQUAL(I).EQ.2) THEN
              QNEW = .FALSE.
          ENDIF
1000  CONTINUE
C
      LUNHOU = 0
      CALL HCDIR(TXT1,'R')
      IF(QNEW) THEN
          CALL MN_FIL(-4,LUNHOU,FIL_HO,IDELIM,IERR)
          IF(IERR.NE.0) GOTO 9900
CICB          CALL HRFILE(LUNHOU,'MN_HBOUT','N')
      ELSE
          CALL MN_FIL(-5,LUNHOU,FIL_HO,IDELIM,IERR)
          IF(IERR.NE.0) GOTO 9900
CICB          CALL HRFILE(LUNHOU,'MN_HBOUT','U')
      ENDIF
      CALL HCDIR(TXT1,' ')
C
      IF(.NOT.QRFILE .AND. IDELIM.LT.0) WRITE(LUNTTO
     1 ,'('' Histograms will be stored in HBOOK format'')')
C
C     Set the HBOOK directory and save it as storing Ntuples can change
C     the directory
C
      CALL M_SDIR(1,IERR)
      IF(IERR.NE.0) GOTO 9000
      CALL HCDIR(DIRSAV,'R')
C
2000  CONTINUE
      QZERO = .FALSE.
      CALL WAITYQ('Give histograms to store (0 for all,' //
     1 ' <CR> when finished): ')
      CALL MN_HRN(IDA1,IDA2,IDB1,IDB2,IDELIM,NNID)
C
      IF(NNID.LE.0) GOTO 9000
      IF(NNID.EQ.1 .AND. IDA1.EQ.0) QZERO = .TRUE.
      QRNGE = IDA1.NE.IDA2 .OR. IDB1.NE.IDB2
C
      DO 2500 NH=1,NDHIS
          IF(IDPTRH(NH).LE.0 .OR. IDPTRD(NH).LE.0) GOTO 2500
          IDA = IDIDA(NH)
          IDB = IDIDB(NH)
          IF((NNID.EQ.1 .AND. IDA1.EQ.0) .OR.
     +       (NNID.EQ.2 .AND. IDA1.EQ.0 .AND.
     +        IDB.GE.IDB1 .AND. IDB.LE.IDB2) .OR.
     1       (IDA.GE.IDA1 .AND. IDA.LE.IDA2 .AND.
     1        IDB.GE.IDB1 .AND. IDB.LE.IDB2)) THEN
              IDH = IDA
              IF(HEXIST(IDH)) THEN
                  CALL HDELET(IDH)
              ENDIF
              CALL MN_HBN(IDA,IDB,IERR)
              IF(.NOT.QZERO .AND. .NOT.QRNGE .AND. IERR.NE.0) THEN
                  CALL MN_ERR('MN_HBS'
     +             ,'Error converting Mn_Fit plot to HBOOK plot')
                  GOTO 9000
              ENDIF
C
              IF(HEXIST(IDH)) CALL HROUT(IDH,ICYCLE,' ')
              CALL HCDIR(DIRSAV,' ')
              CALL M_SDIR(1,IERR)
          ENDIF
2500  CONTINUE
      IF(.NOT.QZERO) THEN
          GOTO 2000
      ENDIF
C
9000  CONTINUE
      CALL HRENDC('MN_HBOUT')
*ICB      CLOSE(UNIT=LUNHOU)
*ICB      CALL CLEO_FRELUN(LUNHOU,'MN_FIL')
9900  CONTINUE
      END
