      SUBROUTINE M_SKEL(NMODE,LUN,NHI,IERR,TFILE)
C
C-----------------------------------------------------------------------------
C     Writes out a skeleton COMIS function or subroutine
C     NMODE = -1 means REAL FUNCTION for NTUPLE SCAN - CWN
C     NMODE = -2 means REAL FUNCTION for CUT FILE - CWN
C     NMODE =  1 means REAL FUNCTION for NTUPLE SCAN - RWN
C     NMODE =  2 means REAL FUNCTION for CUT FILE - RWN
C     NMODE =  3 means a dummy subroutine for the CALL command
C
C     Called by M_NTPSCN, M_CCMS, M_CALL_COMIS
C-----------------------------------------------------------------------------
C
      implicit none
c
#include "mnpar.inc"
#include "mndat.inc"
#include "mninf.inc"
#include "mnprs.inc"
#include "mncwn.inc"
#include "mndbg.inc"
c
      integer isl
      common /slate/ isl(40)
c
      integer nmode,lun,nhi,ierr
      character*(*) tfile
c
      integer mlmax,mreal,mint,mlog,mdble,mchar,mcr4,mcr8,mcch
      parameter (mlmax = 80)
      parameter (mreal=1, mint=2, mlog=3, mdble=4, mchar=5)
      parameter (mcr4=1,  mcr8=2, mcch=3)
      character tline(mlmax)*66
      character*255 txt1,txt2
      character*80  tformat,tsname
      integer ndate,ntime,nyear,nmnth,nday,nhour,nmin
      integer nh,ndimu,idelim,idh,nldef(5),nlcom(3)
      character chtag*32,block*8,chdesc*40
      integer nsub,itype,isize,ielem,nfact,isub(8)
      integer i,j,ii,nn,ind1,ind2,n1,n2,nch,nl
     + ,lent,lenf,len1,len2,lnblnk
     + ,nline,ioerr
      logical  hntnew,qcwntp
      external hntnew
c
CICB      integer lun2,lun3
CICB      character tsnaml*80
c
      nh = nhi
      if(nh.gt.0) then
          ndimu  = iabs(ndim)
          idh    = idac
          qcwntp = hntnew(idh)
          if(qcwntp) then
              nldef(mreal) = 1
              nldef(mint)  = 2
              nldef(mlog)  = 3
              nldef(mdble) = 4
              nldef(mchar) = 5
              nlcom(mcr4)  = 6
              nlcom(mcr8)  = 7
              nlcom(mcch)  = 8
              do i=1,mlmax
                  tline(i) = ' '
              enddo
          endif
      else
          ndimu  = mdimmx
      endif
c
      call mn_fil(-53,lun,tfile,idelim,ierr)
      if(ierr.ne.0) goto 9000
C
C     Extract the subroutine or function name from the filename
C
      lent = lnblnk(tfile)
#if ( defined(VMS) )
      ind1 = index(tfile,']')
      ind2 = index(tfile,':')
      n1   = max0(ind1,ind2) + 1
      ind1 = index(tfile(n1:),'.')
      ind2 = index(tfile(n1:),';')
      n2   = n1 + min0(ind1,ind2) - 2
      if(ind2.eq.0) ind2 = lent
#endif
#if ( defined(UNIX) )
      n1 = 1
1000  continue
      ind1 = index(tfile(n1:),'/')
      if(ind1.gt.0) then
          n1 = n1 + ind1
          if(n1.le.lent) goto 1000
      endif
      ind2 = index(tfile(n1:),'.')
      n2 = n1 + ind2 - 2
      if(ind2.eq.0) ind2 = lent
#endif

      tsname = 'junk'
      if(n1.gt.0 .and. n2.ge.n1) tsname = tfile(n1:n2)
      call cutol(tsname)
      lenf = lnblnk(tsname)
c
c     Temporary call huwfun also
C
CICB      if(qcwntp) then
CICB          call m_llwc(tsname,tsnaml)
CICB          len1 = lnblnk(tfile)
CICB          call mn_fil(-53,lun2,tsnaml(:lenf)//'_b.f',idelim,ierr)
CICB          if(ierr.ne.0) goto 9000
CICB          call huwfun(lun2,idh,tsnaml(:lenf),0,'B')
CICB          close(unit=lun2)
CICB*
CICB          call mn_fil(-53,lun3,tsnaml(:lenf)//'_p.f',idelim,ierr)
CICB          if(ierr.ne.0) goto 9000
CICB          call huwfun(lun3,idh,tsnaml(:lenf),0,'P')
CICB          close(unit=lun3)
CICB      endif
C
      if(iabs(nmode).eq.1) then
          write(txt1,'(
     +        ''      real function '',a,''(xval)'')') tsname(1:lenf)
          lent = lnblnk(txt1)
          write(lun,'(a)') txt1(1:lent)
          txt1 = '      real xval'
          lent = lnblnk(txt1)
          write(lun,'(a)') txt1(1:lent)
      elseif(iabs(nmode).eq.2) then
          write(txt1,'(
     +        ''      real function '',a,''(xval)'')') tsname(1:lenf)
          lent = lnblnk(txt1)
          write(lun,'(a)') txt1(1:lent)
          txt1 = '      real xval'
          lent = lnblnk(txt1)
          write(lun,'(a)') txt1(1:lent)
      elseif(nmode.eq.3) then
          write(txt1,'(
     +        ''      subroutine '',a,''(xval)'')') tsname(1:lenf)
          lent = lnblnk(txt1)
          write(lun,'(a)') txt1(1:lent)
          txt1 = '      real xval'
          lent = lnblnk(txt1)
          write(lun,'(a)') txt1(1:lent)
      endif
*
      if(iabs(nmode).eq.1 .or. iabs(nmode).eq.2) then
          if(nh.gt.0) then
              txt1 = '*'
              lent = lnblnk(txt1)
              write(lun,'(a)') txt1(1:lent)
              write(lun,'(66(''*''))')
              write(txt2,'(i8)') idh
              call cleft(txt2,1,8)
              lent = lnblnk(txt2)
              nyear = nhdate / 10000
              nmnth = mod(nhdate,10000) / 100
              nday  = mod(nhdate,100)
              nhour = nhtime / 100
              nmin  = mod(nhtime,100)
              write(txt1,'(''*     Ntuple id:'',t25,a
     +         ,t30,''Created: ''
     +         ,i2.2,''/'',i2.2,''/'',i2.2,1x,i2.2,'':'',i2.2)')
     +         txt2(:lent),nday,nmnth,nyear,nhour,nmin
              lent = lnblnk(txt1)
              write(lun,'(a)') txt1(1:lent)
              lent = max0(1,lnblnk(tdtit(nh)))
              write(txt1,'(''*     Ntuple title:'',t25,a)')
     +         tdtit(nh)(:lent)
              lent = lnblnk(txt1)
              write(lun,'(a)') txt1(1:lent)
              call m_rtim(ndate,ntime)
              nyear = isl(1)
              nmnth = isl(2)
              nday  = isl(3)
              nhour = isl(4)
              nmin  = isl(5)
              write(txt1,'(''*     Skeleton created:'',t25
     +         ,i2.2,''/'',i2.2,''/'',i4.4,1x,i2.2,'':'',i2.2)')
     +         nday,nmnth,nyear,nhour,nmin
              lent = lnblnk(txt1)
              write(lun,'(a)') txt1(1:lent)
              write(lun,'(66(''*''))')
          endif
*
          txt1 = '*'
          lent = lnblnk(txt1)
          write(lun,'(a)') txt1(1:lent)
          txt1 = '*     Standard Ntuple Common Blocks:'
          lent = lnblnk(txt1)
          write(lun,'(a)') txt1(1:lent)
          txt1 = '*'
          lent = lnblnk(txt1)
          write(lun,'(a)') txt1(1:lent)
          txt1 = '      integer idnevt'
          lent = lnblnk(txt1)
          write(lun,'(a)') txt1(1:lent)
          if(nh.gt.0 .and. qcwntp) then
              txt1 = '      real vidn1,vidn2,vidn3,vidn'
          elseif(nh.gt.0) then
              txt1 = '      real vidn1,vidn2,vidn3'
          else
              txt1 = '      real vidn1,vidn2,vidn3,rval'
          endif
          lent = lnblnk(txt1)
          write(lun,'(a)') txt1(1:lent)
*
*         PAWIDN is either an array or individual variable names
*         as COMIS equivalence is not like FORTRAN equivalence
*
*         CWN
*
          if(nh.gt.0 .and. qcwntp) then
              write(txt1,'(''      common/pawidn/''
     +         ,''idnevt,vidn1,vidn2,vidn3,vidn('',i4,'')'')') mdimmx
              lent = lnblnk(txt1)
              write(lun,'(a)') txt1(1:lent)
              txt1 = '*'
              lent = lnblnk(txt1)
              write(lun,'(a)') txt1(1:lent)
*
              txt1 = '*     The Ntuple variables:'
              lent = lnblnk(txt1)
              write(lun,'(a)') txt1(1:lent)
              txt1 = '*'
              lent = lnblnk(txt1)
              write(lun,'(a)') txt1(1:lent)
*
              do 2200 i=1,iabs(ndimu)
                  call hntvdef(idh,i,chdesc,block,itype)
                  call hntvar(idh,i,chtag,block,nsub,itype,isize,ielem)
                  if(qdebug)
     +             write(6,'('' idh:'',I8,'' Tag,block:'',2(1x,a)
     +             ,'' sub,type,size,elem'',4i3,i6)')
     +             idh,chtag,block,nsub,itype,isize,ielem
                  len1 = lnblnk(chtag)
                  len2 = lnblnk(block)
                  call m_nsub(2,idh,nsub,block,chdesc,ielem
     +             ,isub,nfact,ierr)
                  if(ielem.lt.10) then
                      tformat = '(''('',i1,'')'')'
                  elseif(ielem.lt.100) then
                      tformat = '(''('',i2,'')'')'
                  elseif(ielem.lt.1000) then
                      tformat = '(''('',i3,'')'')'
                  else
                      tformat = '(''('',i4,'')'')'
                  endif
*
*                 Real*4
*
                  if(itype.eq.1 .and. isize.eq.4) then
                      nch = lnblnk(tline(nldef(mreal)))
                      if(nch+len1.gt.60) THEN
                          nldef(mreal) = nldef(mreal) + 1
                          do nl=nlcom(mcch),nldef(mreal),-1
                              tline(nl+1) = tline(nl)
                          enddo
                          nldef(mint)  = nldef(mint)  + 1
                          nldef(mlog)  = nldef(mlog)  + 1
                          nldef(mdble) = nldef(mdble) + 1
                          nldef(mchar) = nldef(mchar) + 1
                          nlcom(mcr4)  = nlcom(mcr4)  + 1
                          nlcom(mcr8)  = nlcom(mcr8)  + 1
                          nlcom(mcch)  = nlcom(mcch)  + 1
                          nch = 0
                      endif
                      tline(nldef(mreal))(nch+1:)=','//chtag(:len1)
*
                      nch = lnblnk(tline(nlcom(mcr4)))
                      if(nch+len1.gt.60) THEN
                          nlcom(mcr4) = nlcom(mcr4) + 1
                          do nl=nlcom(mcch),nlcom(mcr4),-1
                              tline(nl+1) = tline(nl)
                          enddo
                          nlcom(mcr8)  = nlcom(mcr8)  + 1
                          nlcom(mcch)  = nlcom(mcch)  + 1
                          nch = 0
                      endif
                      tline(nlcom(mcr4))(nch+1:)=','//chtag(:len1)
                      if(ielem.gt.1) then
                          nch = nch + 1 + len1
                          call m_tsub(2,nh,nsub,isub,ielem
     +                     ,tline(nlcom(mcr4))(nch+1:),n1)
*ICB                          write(tline(nlcom(mcr4))(nch+1:)
*ICB     +                     ,fmt=tformat) ielem
                      endif
*
*                 Real*8
*
                  elseif(itype.eq.1 .and. isize.eq.8) then
                      nch = lnblnk(tline(nldef(mdble)))
                      if(nch+len1.gt.60) THEN
                          nldef(mdble) = nldef(mdble) + 1
                          do nl=nlcom(mcch),nldef(mdble),-1
                              tline(nl+1) = tline(nl)
                          enddo
                          nldef(mdble) = nldef(mdble) + 1
                          nldef(mchar) = nldef(mchar) + 1
                          nlcom(mcr4)  = nlcom(mcr4)  + 1
                          nlcom(mcr8)  = nlcom(mcr8)  + 1
                          nlcom(mcch)  = nlcom(mcch)  + 1
                          nch = 0
                      endif
                      tline(nldef(mdble))(nch+1:)=','//chtag(:len1)
*
                      nch = lnblnk(tline(nlcom(mcr8)))
                      if(nch+len1.gt.60) THEN
                          nlcom(mcr8) = nlcom(mcr8) + 1
                          do nl=nlcom(mcch),nlcom(mcr8),-1
                              tline(nl+1) = tline(nl)
                          enddo
                          nlcom(mcch)  = nlcom(mcch)  + 1
                          nch = 0
                      endif
                      tline(nlcom(mcr8))(nch+1:)=','//chtag(:len1)
                      if(ielem.gt.1) then
                          nch = nch + 1 + len1
                          call m_tsub(2,nh,nsub,isub,ielem
     +                     ,tline(nlcom(mcr8))(nch+1:),n1)
*ICB                          write(tline(nlcom(mcr8))(nch+1:)
*ICB     +                     ,fmt=tformat) ielem
                      endif
*
*                 Integer signed or unsigned
*
                  elseif(itype.eq.2 .or. itype.eq.3) then
                      nch = lnblnk(tline(nldef(mint)))
                      if(nch+len1.gt.60) THEN
                          nldef(mint) = nldef(mint) + 1
                          do nl=nlcom(mcch),nldef(mint),-1
                              tline(nl+1) = tline(nl)
                          enddo
                          nldef(mlog)  = nldef(mlog)  + 1
                          nldef(mdble) = nldef(mdble) + 1
                          nldef(mchar) = nldef(mchar) + 1
                          nlcom(mcr4)  = nlcom(mcr4)  + 1
                          nlcom(mcr8)  = nlcom(mcr8)  + 1
                          nlcom(mcch)  = nlcom(mcch)  + 1
                          nch = 0
                      endif
                      tline(nldef(mint))(nch+1:)=','//chtag(:len1)
*
                      nch = lnblnk(tline(nlcom(mcr4)))
                      if(nch+len1.gt.60) THEN
                          nlcom(mcr4) = nlcom(mcr4) + 1
                          do nl=nlcom(mcch),nlcom(mcr4),-1
                              tline(nl+1) = tline(nl)
                          enddo
                          nlcom(mcr8)  = nlcom(mcr8)  + 1
                          nlcom(mcch)  = nlcom(mcch)  + 1
                          nch = 0
                      endif
                      tline(nlcom(mcr4))(nch+1:)=','//chtag(:len1)
                      if(ielem.gt.1) then
                          nch = nch + 1 + len1
                          call m_tsub(2,nh,nsub,isub,ielem
     +                     ,tline(nlcom(mcr4))(nch+1:),n1)
*ICB                          write(tline(nlcom(mcr4))(nch+1:)
*ICB     +                     ,fmt=tformat) ielem
                      endif
*
*                 Logical
*
                  elseif(itype.eq.4) then
                      nch = lnblnk(tline(nldef(mlog)))
                      if(nch+len1.gt.60) THEN
                          nldef(mlog) = nldef(mlog) + 1
                          do nl=nlcom(mcch),nldef(mlog),-1
                              tline(nl+1) = tline(nl)
                          enddo
                          nldef(mdble) = nldef(mdble) + 1
                          nldef(mchar) = nldef(mchar) + 1
                          nlcom(mcr4)  = nlcom(mcr4)  + 1
                          nlcom(mcr8)  = nlcom(mcr8)  + 1
                          nlcom(mcch)  = nlcom(mcch)  + 1
                          nch = 0
                      endif
                      tline(nldef(mlog))(nch+1:)=','//chtag(:len1)
*
                      nch = lnblnk(tline(nlcom(mcr4)))
                      if(nch+len1.gt.60) THEN
                          nlcom(mcr4) = nlcom(mcr4) + 1
                          do nl=nlcom(mcch),nlcom(mcr4),-1
                              tline(nl+1) = tline(nl)
                          enddo
                          nlcom(mcr8)  = nlcom(mcr8)  + 1
                          nlcom(mcch)  = nlcom(mcch)  + 1
                          nch = 0
                      endif
                      tline(nlcom(mcr4))(nch+1:)=','//chtag(:len1)
                      if(ielem.gt.1) then
                          nch = nch + 1 + len1
                          call m_tsub(2,nh,nsub,isub,ielem
     +                     ,tline(nlcom(mcr4))(nch+1:),n1)
*ICB                          write(tline(nlcom(mcr4))(nch+1:)
*ICB     +                     ,fmt=tformat) ielem
                      endif
*
*                 Character
*
                  elseif(itype.eq.5) then
                      nch = lnblnk(tline(nldef(mchar)))
                      if(nch+len1.gt.60) THEN
                          nldef(mchar) = nldef(mchar) + 1
                          do nl=nlcom(mcch),nldef(mchar),-1
                              tline(nl+1) = tline(nl)
                          enddo
                          nlcom(mcr4)  = nlcom(mcr4)  + 1
                          nlcom(mcr8)  = nlcom(mcr8)  + 1
                          nlcom(mcch)  = nlcom(mcch)  + 1
                          nch = 0
                      endif
                      tline(nldef(mchar))(nch+1:)=','//chtag(:len1)
                      nch = nch + 1 + len1
                      if(isize.lt.10) then
                          write(tline(nldef(mchar))(nch+1:)
     +                     ,'(''*'',i1)') isize
                      elseif(isize.lt.100) then
                          write(tline(nldef(mchar))(nch+1:)
     +                     ,'(''*'',i2)') isize
                      elseif(isize.lt.1000) then
                          write(tline(nldef(mchar))(nch+1:)
     +                     ,'(''*'',i3)') isize
                      else
                          write(tline(nldef(mchar))(nch+1:)
     +                     ,'(''*'',i4)') isize
                      endif
*
                      nch = lnblnk(tline(nlcom(mcch)))
                      if(nch+len1.gt.60) THEN
                          nlcom(mcch) = nlcom(mcch) + 1
                          nch = 0
                      endif
                      tline(nlcom(mcch))(nch+1:)=','//chtag(:len1)
                      if(ielem.gt.1) then
                          nch = nch + 1 + len1
                          call m_tsub(2,nh,nsub,isub,ielem
     +                     ,tline(nlcom(mcch))(nch+1:),n1)
*ICB                          write(tline(nlcom(mcch))(nch+1:)
*ICB     +                     ,fmt=tformat) ielem
                      endif
                  endif
 2200         continue
*
*             Write out the header
*
              if(tline(nldef(mreal)).ne.' ') then
                  txt1 = 'real'
                  len1 = lnblnk(txt1)
                  write(lun,'(6x,a)') txt1(:len1)
                  tline(1)(1:1) = ' '
                  do i=1,nldef(mreal)
                      len1 = lnblnk(tline(i))
                      write(lun,'(5x,''+'',a)') tline(i)(:len1)
                  enddo
              endif
              if(tline(nldef(mint)).ne.' ') then
                  txt1 = 'integer'
                  len1 = lnblnk(txt1)
                  write(lun,'(6x,a)') txt1(:len1)
                  tline(nldef(mreal)+1)(1:1) = ' '
                  do i=nldef(mreal)+1,nldef(mint)
                      len1 = lnblnk(tline(i))
                      write(lun,'(5x,''+'',a)') tline(i)(:len1)
                  enddo
              endif
              if(tline(nldef(mlog)).ne.' ') then
                  txt1 = 'logical'
                  len1 = lnblnk(txt1)
                  write(lun,'(6x,a)') txt1(:len1)
                  tline(nldef(mint)+1)(1:1) = ' '
                  do i=nldef(mint)+1,nldef(mlog)
                      len1 = lnblnk(tline(i))
                      write(lun,'(5x,''+'',a)') tline(i)(:len1)
                  enddo
              endif
              if(tline(nlcom(mcr4)).ne.' ') then
                  txt1 = 'common /pawcr4/'
                  len1 = lnblnk(txt1)
                  write(lun,'(6x,a)') txt1(:len1)
                  tline(nldef(mchar)+1)(1:1) = ' '
                  do i=nldef(mchar)+1,nlcom(mcr4)
                      len1 = lnblnk(tline(i))
                      write(lun,'(5x,''+'',a)') tline(i)(:len1)
                  enddo
              endif
              if(tline(nldef(mdble)).ne.' ') then
                  txt1 = 'double precision'
                  len1 = lnblnk(txt1)
                  write(lun,'(6x,a)') txt1(:len1)
                  tline(nldef(mlog)+1)(1:1) = ' '
                  do i=nldef(mlog)+1,nldef(mdble)
                      len1 = lnblnk(tline(i))
                      write(lun,'(5x,''+'',a)') tline(i)(:len1)
                  enddo
              endif
              if(tline(nlcom(mcr8)).ne.' ') then
                  txt1 = 'common /pawcr8/'
                  len1 = lnblnk(txt1)
                  write(lun,'(6x,a)') txt1(:len1)
                  tline(nlcom(mcr4)+1)(1:1) = ' '
                  do i=nlcom(mcr4)+1,nlcom(mcr8)
                      len1 = lnblnk(tline(i))
                      write(lun,'(5x,''+'',a)') tline(i)(:len1)
                  enddo
              endif
              if(tline(nldef(mchar)).ne.' ') then
                  txt1 = 'character'
                  len1 = lnblnk(txt1)
                  write(lun,'(6x,a)') txt1(:len1)
                  tline(nldef(mdble)+1)(1:1) = ' '
                  do i=nldef(mdble)+1,nldef(mchar)
                      len1 = lnblnk(tline(i))
                      write(lun,'(5x,''+'',a)') tline(i)(:len1)
                  enddo
              endif
              if(tline(nlcom(mcch)).ne.' ') then
                  txt1 = 'common /pawcch/'
                  len1 = lnblnk(txt1)
                  write(lun,'(6x,a)') txt1(:len1)
                  tline(nlcom(mcr8)+1)(1:1) = ' '
                  do i=nlcom(mcr8)+1,nlcom(mcch)
                      len1 = lnblnk(tline(i))
                      write(lun,'(5x,''+'',a)') tline(i)(:len1)
                  enddo
              endif
*
              write(lun,'(''*'',/,66(''*''))')
*
*         RWN
*
          elseif(nh.gt.0) then
              nline = (iabs(ndimu)-1)/4 + 1
              do 2500 j=1,2
                  if(j.eq.2) then
                      txt1 = '      common /pawidn/' //
     +                 ' idnevt,vidn1,vidn2,vidn3'
                      lent = lnblnk(txt1)
                      write(lun,'(a)') txt1(1:lent)
                  endif
                  do 2400 i=1,nline
                      n1 = (i-1)*4 + 1
                      n2 = min0(i*4,iabs(ndim))
                      nn = n2 - n1 + 1
                      tformat = ' '
                      write(tformat,12410) nn
12410                 format('(',i1,'('','',a))')
                      write(txt1,tformat) (tdnam(ii,nh),ii=n1,n2)
                      len1 = lnblnk(txt1)
                      call csqmbl(txt1,1,len1)
                      len1 = lnblnk(txt1)
                      if(len1.le.65) then
                         write(lun,'(5x,''+ '',a)') txt1(1:lent)
                      else
                         ind1 = index(txt1(50:),',')
                         if(ind1.gt.0) then
                            write(lun,'(5x,''+ '',a)') txt1(1:ind1-1)
                            write(lun,'(5x,''+ '',a)') txt1(ind1:lent)
                         else
                            write(lun,'(5x,''+ '',a)') txt1(1:lent)
                         endif
                      endif
2400              continue
2500          continue
          else
              write(txt1,'(
     +         ''      common /pawidn/ idnevt,vidn1,vidn2,vidn3'')')
              lent = lnblnk(txt1)
              write(lun,'(a)') txt1(1:lent)
              write(txt1,'(''     + ,rval('',i4,'')'')') ndimu
              lent = lnblnk(txt1)
              write(lun,'(a)') txt1(1:lent)
          endif
          txt1 = '*'
          lent = lnblnk(txt1)
          write(lun,'(a)') txt1(1:lent)
          txt1 = '*     Ntuple id, number of variables'
          lent = lnblnk(txt1)
          write(lun,'(a)') txt1(1:lent)
          txt1 = '      integer id,nvar'
          lent = lnblnk(txt1)
          write(lun,'(a)') txt1(1:lent)
          txt1 = '*     Lower and Upper limits on each variable'
          lent = lnblnk(txt1)
          write(lun,'(a)') txt1(1:lent)
          txt1 = '      real alo,ahi'
          lent = lnblnk(txt1)
          write(lun,'(a)') txt1(1:lent)
          if(ndimu.lt.10) then
              tformat = '(6x,a,'',alo('',i1,''),ahi('',i1,'')'')'
          elseif(ndimu.lt.100) then
              tformat = '(6x,a,'',alo('',i2,''),ahi('',i2,'')'')'
          elseif(ndimu.lt.1000) then
              tformat = '(6x,a,'',alo('',i3,''),ahi('',i3,'')'')'
          else
              tformat = '(6x,a,'',alo('',i4,''),ahi('',i4,'')'')'
          endif
          write(txt1,fmt=tformat)
     +     'common /mntpl1/ id,nvar',ndimu,ndimu
          lent = lnblnk(txt1)
          write(lun,'(a)') txt1(1:lent)
          txt1 = '*     Ntuple title and the tags'
          lent = lnblnk(txt1)
          write(lun,'(a)') txt1(1:lent)
          txt1 = '      character title*80,tags*32'
          lent = lnblnk(txt1)
          write(lun,'(a)') txt1(1:lent)
          if(ndimu.lt.10) then
              tformat = '(6x,a,'',tags('',i1,'')'')'
          elseif(ndimu.lt.100) then
              tformat = '(6x,a,'',tags('',i2,'')'')'
          elseif(ndimu.lt.1000) then
              tformat = '(6x,a,'',tags('',i3,'')'')'
          else
              tformat = '(6x,a,'',tags('',i4,'')'')'
          endif
          write(txt1,fmt=tformat)
     +     'common /mntpl2/ title',ndimu
          lent = lnblnk(txt1)
          write(lun,'(a)') txt1(1:lent)
      endif
      txt1 = '*'
      lent = lnblnk(txt1)
      write(lun,'(a)') txt1(1:lent)
C
C     Add the Mn_Fit registers and variables common block
C
      txt1 = '*     Mn_Fit registers'
      lent = lnblnk(txt1)
      write(lun,'(a)') txt1(1:lent)
      txt1 = '*     Make sure you do not overwrite this common block!'
      lent = lnblnk(txt1)
      write(lun,'(a)') txt1(1:lent)
      txt1 = '*     Alternative form is just COMMON/MNREGI/REGIS(0:500)'
      lent = lnblnk(txt1)
      write(lun,'(a)') txt1(1:lent)
      txt1 = '      real regis'
      lent = lnblnk(txt1)
      write(lun,'(a)') txt1(1:lent)
C
      nline = (nvarbl-1)/6 + 1
      if(nvarbl.le.0) nline = 0
      do 3000 j=1,2
          if(j.eq.2) then
              write(txt1,'(''      common /mnregi/ regis(0:'',i3,'')'')'
     +         ,iostat=ioerr) mvar0
              lent = lnblnk(txt1)
              write(lun,'(a)') txt1(1:lent)
          endif
          do 2900 i=1,nline
              n1 = (i-1)*6 + 1
              n2 = min0(i*6,nvarbl)
              nn = n2 - n1 + 1
              tformat = ' '
              write(tformat,13000) nn
13000         format('(5x,''+ '',',i1,'('','',a))')
              write(txt1,tformat) (varnam(ii),ii=n1,n2)
              lent = lnblnk(txt1)
              write(lun,'(a)') txt1(1:lent)
2900      continue
3000  continue
      write(lun,'(''*'')')
      write(lun,'(66(''*''))')
      write(lun,'(''*'')')
C
C     Initialize the function
C
      if(nmode.eq.2) then
          txt1 = '      ' // tsname(1:lenf) // ' = 1.0'
          lent = lnblnk(txt1)
          write(lun,'(a)') txt1(1:lent)
          txt1 = '*'
          lent = lnblnk(txt1)
          write(lun,'(a)') txt1(1:lent)
      endif
c
      txt1 = '      end'
      lent = lnblnk(txt1)
      write(lun,'(a)') txt1(1:lent)
      close(unit=lun)
C
9000  continue
      end
