      subroutine mn_rooth(tid,ida,idb,ierr)
*-----------------------------------------------------------------------
*     Routine to read a root histogram
*
*     Input:
*     tid    Root histogram identifier
*
*     $Id: mn_rooth.fpp,v 1.3 2005/06/06 09:29:16 brock Exp $
*-----------------------------------------------------------------------
      implicit none
*
      character*(*) tid
      integer ida,idb,ierr
*
#include "mnlun.inc"
#if ( defined(ROOT) )
#include "mnpar.inc"
#include "mndat.inc"
#include "mnflg.inc"
#include "mnroot.inc"
#include "slate.inc"
*
      integer idr,leni,ind,ii,ndim,nbinx,nbiny,nbinz,lent
      real    xlo,xhi,ylo,yhi,zlo,zhi
      character*80 title
      integer nwppt,npnt,nwdat,nh,nptrh,nptrd,nwh
     + ,nbppt,ntmode,nwtot,nsdate,nstime,nhdate,nhtime,nrdate,nrtime
      real edent,edlo,edhi
      integer idbin(3)
      real    adlo(3),adhi(3),acont(3**3)
      character*32 tname(3),tndef(3)
      integer istat,ioerr
      integer lnblnk, icdeci, m_root_hdr, m_root_ent
*
      logical qstart
      save tndef
      data qstart/.true./
#endif
*
*-----------------------------------------------------------------------
*
#if ( !defined(ROOT) )
      txterr = 'Root not in this Mn_Fit version'
      call mn_err('MN_ROOTH',txterr)
      goto 9000
#else
C
      IF(QSTART) THEN
          QSTART = .FALSE.
          DO 100 II=1,3
              IF(II.EQ.1) THEN
                  TNDEF(II) = 'X'
              ELSE IF(II.EQ.2) THEN
                  TNDEF(II) = 'Y'
              ELSE IF(II.EQ.3) THEN
                  TNDEF(II) = 'Z'
              ELSE
                  TNDEF(II) = ' '
              ENDIF
100       CONTINUE
      ENDIF
*
      ierr = 0
*
*     See if the histogram ID was included in the name to get
*
      idr  = 0
      leni = lnblnk(tid)
      ind  = index(tid,';')
      if(ind.eq.1 .or. ind.eq.leni) then
        txterr = 'ID syntax is name;id and not ' // tid(:leni)
        call mn_err('MN_ROOTH',txterr)
        goto 9000
      elseif(ind.gt.0) then
        idr  = icdeci(tid,ind+1,leni)
*ICB        write(6,'('' Root ID given in command: '',A,''/'',A,2X,I8)')
*ICB     +   tid(:leni),tid(ind+1:leni),idr
        leni = ind-1
      endif
*
*     Get the general histogram information
*
      title = ' '
      istat = m_root_hdr(leni,tid,lent,title
     + ,ndim,nwppt
     + ,nbinx,xlo,xhi,nbiny,ylo,yhi,nbinz,zlo,zhi
     + ,nrdate,nrtime)
      if(istat.ne.0) then
        ierr = 1
        goto 9000
      endif
*
      if(lent.le.0) then
        title = ' '
        lent  = 1
      endif
*
*     Convert root date/time 20050731/150901 to Mn_Fit 050731/1509
*
      nhdate = mod(nrdate,1000000)
      nhtime = nrtime / 100
*
*ICB      write(luntto,'('' ID: '',A,'', Dim: '',I2,'', Title: '',A)')
*ICB     + tid(:leni),ndim,title(:lent)
*ICB      write(luntto,'('' X-axis Nbin/xlo/xhi: '',I5,1X,2(1pg12.5))')
*ICB     + nbinx,xlo,xhi
*ICB      write(luntto,'('' Y-axis Nbin/ylo/yhi: '',I5,1X,2(1pg12.5))')
*ICB     + nbiny,ylo,yhi
*
*     See if we can make an ID stripping off the first character
*
      if (idr.eq.0) then
        idr = icdeci(tid,2,leni)
        if(idr.eq.0 .or. nd.eq.0) then
          idr = idroot
*ICB          write(6,'('' Root ID set to: '',I8)')
*ICB     +     idr
*ICB        else
*ICB          write(6,'('' Root ID got from name: '',A,2X,I8)')
*ICB     +     tid(:leni),idr
        endif
      endif
*
      ida = idr
      idb = ndidb
      if(iabs(ndim).eq.1) then
        npnt  = nbinx
        tname(1) = tndef(1)
      elseif(iabs(ndim).eq.2) then
        npnt  = nbinx*nbiny
        tname(1) = tndef(1)
        tname(2) = tndef(2)
      elseif(ndim.eq.3) then
        npnt  = nbinx*nbiny*nbinz
        tname(1) = tndef(1)
        tname(2) = tndef(2)
        tname(3) = tndef(3)
      else
        write(txterr,'(''Number of histogram dimensions wrong: ''
     +   ,I8)',iostat=ioerr) ndim
        call mn_err('MN_ROOTH',txterr)
        ierr = 1
        goto 9000
      endif
      idbin(1) = nbinx
      adlo(1)  = xlo
      adhi(1)  = xhi
      if(iabs(ndim).ge.2) then
        idbin(2) = nbiny
        adlo(2)  = ylo
        adhi(2)  = yhi
      endif
      if(ndim.ge.3) then
        idbin(3) = nbinz
        adlo(3)  = zlo
        adhi(3)  = zhi
      endif
*
*     Always use 32 bits per point
*
      nwdat  = npnt*nwppt
      nbppt  = 32
      ntmode = 0
*
*     Get the histogram number and the pointer
*     reserve space for the histogram
*
      call mn_hnw(ida,idb,ndim,nwdat,nh,nptrh,nptrd,nwh
     + ,nbppt,ntmode)
      if(nh.le.0) then
        ierr = 1
        goto 9000
      endif
*
*     Get the histogram contents
*
      istat = m_root_ent(leni,tid,nwppt,nwdat
     + ,edent,edlo,edhi,acont,rdat(nptrd))
      if(istat.ne.0) then
        ierr = 1
        goto 9000
      endif
**
*     Fill in the header information and the pointers
*     
      nwtot = nwh + nwdat
      nsdate = 0
      nstime = 0
      call mn_hdu(rdat(nptrh),nwtot,nwh,nwdat,ida,idb
     1 ,ndim,nwppt,npnt,nhdate,nhtime,nsdate,nstime,ntmode
     + ,edent,edlo,edhi,idbin,adlo,adhi,nbppt,acont)
      call mn_ptu(nh,nwtot,ida,idb,nptrh,nptrd,title(:lent),fil_root
     1 ,dir_hc,tname)
      call mn_msu(ida,idb,ndim,nwh,nh)
#endif
*
9000  continue
      end
