      SUBROUTINE MN_TVL(TXTI,TXTO)
C
C     Takes a text string, looks to see if there are registers,
C     parameters etc in it and replaces them with the current
C     values according to the format given
C
      implicit none
*
#include "mncmd.inc"
*
      CHARACTER*(*) TXTI,TXTO
C
      CHARACTER*255 TCHSAV
      CHARACTER*255 TXT1,TXT2,TXT3
      CHARACTER*80 TFORMAT
      real val
      integer ival,lval
      character tval*255
      integer nchsav,ichr,istr,idelim,leni,lenf,lens,lent
     + ,n1,n2,ind,nchar
     + ,lenv
      LOGICAL QREAL,QCHAR
*
      integer ichtyp, istrng, tvltyp, ivltyp, isttyp, lnblnk
      real    valtyp
C
C     See if there is more text in the TYPSCN buffer and if there is
C     get it to a safe place
C
      NCHSAV = 0
      ICHR = ICHTYP(.TRUE.)
      IF(ICHR.GT.0) THEN
        CALL RESTYP
        ISTR = ISTRNG(.TRUE.,TCHSAV,NCHSAV)
      ENDIF
C
      LENI = LNBLNK(TXTI)
      IF(LENI.LE.0) GOTO 9000
C
      N1 = 1
      TXT1 = TXTI
      LENT = LNBLNK(TXT1)
      TXTO = ' '
 1000 CONTINUE
*ICB      write(6,'('' TXT1: '',A)') txt1
      IND = INDEX(TXT1(N1:),'{')
      IF(IND.EQ.0) GOTO 1500
      N1 = N1 + IND - 1
C
C     See if last character is an at "@" - if so then skip this
C
      IF(N1.GT.1 .AND. TXT1(N1-1:N1-1).EQ.'@') THEN
        N1 = N1 + 2
        GOTO 1000
      ENDIF
C
C     Now get the end of the curly bracket and process what is inside
C
      IND = INDEX(TXT1(N1:),'}')
      IF(IND.EQ.0) THEN
        CALL MN_ERR('MN_TVL','Missing } in a text string')
        GOTO 9000
      ENDIF
      N2 = N1 + IND - 1
      IF(N2.LE.N1+1) THEN
        CALL MN_ERR('MN_TVL','No text inside a {...} block')
        GOTO 9000
      ENDIF
C
      QREAL = .FALSE.
      QCHAR = .FALSE.
      TXT2 = TXT1(N1+1:N2-1)
*ICB      write(6,'('' TXT2: '',A)') txt2
      CALL QUOTYP(TXT2)
      txt3 = txt2
      call cltou(txt3)
      IF(TXT3(1:2).eq.'CH') then
        QCHAR = .TRUE.
        lval  =  TVLTYP(.TRUE.,IDELIM,TVAL)
        IF(IDELIM.LT.0) THEN
          TFORMAT = '(A)'
          LENF = LNBLNK(TFORMAT)
          GOTO 1200
        ENDIF
      elseIF((ICHAR(TXT2(1:1)).GE.ICHAR('I') .AND.
     +        ICHAR(TXT2(1:1)).LE.ICHAR('N')) .OR.
     +       (ICHAR(TXT2(1:1)).GE.ICHAR('i') .AND.
     +        ICHAR(TXT2(1:1)).LE.ICHAR('n'))) THEN
        QREAL = .FALSE.
        IVAL  =  IVLTYP(.TRUE.,IDELIM)
        IF(IDELIM.LT.0) THEN
          TFORMAT = '(I8)'
          LENF = LNBLNK(TFORMAT)
          GOTO 1200
        ENDIF
      ELSE
        QREAL = .TRUE.
        VAL   = VALTYP(.TRUE.,IDELIM)
        IF(IDELIM.LT.0) THEN
          TFORMAT = '(1PG12.5)'
          LENF = LNBLNK(TFORMAT)
          GOTO 1200
        ENDIF
      ENDIF
      IF(IDELIM.NE.0) GOTO 9000
*
*     Must use minimal delimiters for this call as format 
*     can have anything in it and we don't want to strip any 
*     leading parentheses etc.
*
      TS5SCN = TSDSCN
      TSDSCN = ','
      LENS   = LNBLNK(TSDSCN)
      CALL SDLSCN(TSDSCN(1:LENS))
*
      ISTR = ISTRNG(.TRUE.,TFORMAT,NCHAR)
*
      TSDSCN = TS5SCN
      LENS   = LNBLNK(TSDSCN)
      CALL SDLSCN(TSDSCN(1:LENS))
*
      IF(NCHAR.LE.0) THEN
          IF(QCHAR) THEN
              TFORMAT = '(A)'
          ELSEIF(QREAL) THEN
              TFORMAT = '(1PG12.5)'
          ELSE
              TFORMAT = '(I8)'
          ENDIF
      ENDIF
      LENF = LNBLNK(TFORMAT)
      IF(TFORMAT(1:1).NE.'(' .OR. TFORMAT(LENF:LENF).NE.')') THEN
          CALL MN_ERR('MN_TVL'
     +     ,'Format must start with ( and end with )')
          GOTO 9000
      ENDIF
C
1200  CONTINUE
      IF(QCHAR) THEN
        if(lval.gt.0) then
          WRITE(TXT3,FMT=TFORMAT(1:LENF),ERR=1310) tval(:lval)
        else
          call mn_err('MN_TVL','Error in character expression')
          goto 9000
        endif
      ELSEIF(QREAL) THEN
          WRITE(TXT3,FMT=TFORMAT(1:LENF),ERR=1320) VAL
      ELSE
          WRITE(TXT3,FMT=TFORMAT(1:LENF),ERR=1330) IVAL
      ENDIF
      LENV = LNBLNK(TXT3)
      IF(LENV.GT.0) GOTO 1400
1310  CONTINUE
      CALL MN_ERR('MN_TVL','Error in format for a character: ' //
     + TFORMAT)
      GOTO 9000
1320  CONTINUE
      CALL MN_ERR('MN_TVL','Error in format for a real: ' //
     + TFORMAT)
      GOTO 9000
1330  CONTINUE
      CALL MN_ERR('MN_TVL','Error in format for an integer: ' //
     + TFORMAT)
      GOTO 9000
1400  CONTINUE
C
*ICB      write(6,'('' N1,N2,LENT: '',3I5)') n1,n2,lent
      IF(N1.LE.1 .AND. N2.GE.LENT) THEN
          TXT2 = TXT3(1:LENV)
      ELSEIF(N1.LE.1) THEN
          TXT2 = TXT3(1:LENV) // TXT1(N2+1:LENT)
      ELSEIF(N2.GE.LENT) THEN
          TXT2 = TXT1(1:N1-1) // TXT3(1:LENV)
      ELSE
          TXT2 = TXT1(1:N1-1) // TXT3(1:LENV) // TXT1(N2+1:LENT)
      ENDIF
*ICB      write(6,'('' TXT1: '',A)') txt1
*ICB      write(6,'('' TXT2: '',A)') txt2
*ICB      write(6,'('' TXT3: '',A)') txt3
C
      TXT1 = TXT2
      LENT = LNBLNK(TXT1)
      N1 = N1 + LENV - 2
      IF(N1.GE.LENT) GOTO 1500
      GOTO 1000
C
1500  CONTINUE
C
C     Now get rid of any @{ symbols that are left
C
      N1 = 1
2000  CONTINUE
      IND = INDEX(TXT1(N1:),'{')
      IF(IND.EQ.0) GOTO 3000
      N1 = N1 + IND - 1
      IF(N1.GT.1 .AND. TXT1(N1-1:N1-1).EQ.'@') THEN
          TXT2 = TXT1(1:N1-2) // TXT1(N1:)
      ENDIF
      TXT1 = TXT2
      LENT = LNBLNK(TXT1)
      N1 = N1 + 1
      IF(N1.LT.LENT) GOTO 2000
3000  CONTINUE
C
      CALL ZERTYP('.FALSE.')
      TXTO = TXT1
      GOTO 9100
C
C     Error label
C
9000  CONTINUE
      CALL ZERTYP('.FALSE.')
      TXTO = TXTI
C
C     Restore the old TYPSCN buffer
C
9100  CONTINUE
      IF(NCHSAV.GT.0) THEN
          CALL QUOTYP(TCHSAV(1:NCHSAV))
      ENDIF
C
      END
