/* Copyright (C) 2000-2002 Lavtech.com corp. All rights reserved.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/

#include "udm_config.h"

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>

#include "udm_common.h"
#include "udm_boolean.h"
#include "udm_utils.h"

/*#define DEBUG_BOOL*/


#ifdef DEBUG_BOOL
static char item_type(int cmd, unsigned long arg){
	switch(cmd){
		case UDM_STACK_LEFT:	return('(');
		case UDM_STACK_RIGHT:	return(')');
		case UDM_STACK_OR:	return('|');
		case UDM_STACK_AND:	return('&');
		case UDM_STACK_NOT:	return('~');
		case UDM_STACK_PHRASE:	return('"');
		case UDM_STACK_WORD:	return(arg?'1':'0');
		default:		return('?');
	}
}
#endif

static int TOPCMD(UDM_BOOLSTACK * s){
	if(s->ncstack)
		return(s->cstack[s->ncstack-1]);
	else
		return(UDM_STACK_BOT);
}

static int POPARG(UDM_BOOLSTACK * s){
	if(s->nastack>0){
		s->nastack--;
		return(s->astack[s->nastack]);
	}else{
		return(UDM_STACK_BOT);
	}
}

static int POPCMD(UDM_BOOLSTACK * s){
	if(s->ncstack>0){
		s->ncstack--;
		return(s->cstack[s->ncstack]);
	}else{
		return(UDM_STACK_BOT);
	}
}

static void PUSHARG(UDM_BOOLSTACK * s,unsigned long arg){
	s->astack[s->nastack]=arg;
	s->nastack++;
	if (s->nastack >= s->mastack) {
	  s->mastack += UDM_MAXSTACK;
	  s->astack = (unsigned long*)realloc(s->astack, s->mastack * sizeof(unsigned long));
	}
}

static void PUSHCMD(UDM_BOOLSTACK * s,int arg){
	s->cstack[s->ncstack]=arg;
	s->ncstack++;
	if (s->ncstack >= s->mcstack) {
	  s->mcstack += UDM_MAXSTACK;
	  s->cstack = (int*)realloc(s->cstack, s->mcstack * sizeof(int));
	}
}

/* Compute one operation and store result */
static int perform(UDM_BOOLSTACK * s,int com){
	unsigned long res,x1,x2;
	switch(com){
		case UDM_STACK_OR:
			/* This is to avoid compiler      */
			/* optimization in || calculation */
			x1=POPARG(s);
			x2=POPARG(s);
			res=(x1||x2);
#ifdef DEBUG_BOOL
			fprintf(stderr,"Perform %lu | %lu\n",x1,x2);
#endif
			PUSHARG(s,res);
			break;
		case UDM_STACK_AND:
			x1=POPARG(s);
			x2=POPARG(s);
			res=(x1&&x2);
#ifdef DEBUG_BOOL
			fprintf(stderr,"Perform %lu & %lu\n",x1,x2);
#endif
			PUSHARG(s,res);
			break;
		case UDM_STACK_NOT:
			x1=POPARG(s);
			res=x1?0:1;
#ifdef DEBUG_BOOL
			fprintf(stderr,"Perform ~%lu\n",x1);
#endif
			PUSHARG(s,res);
			break;
	}
	return(0);
}


/* Main function to calculate items sequence */
int UdmCalcBoolItems(UDM_STACK_ITEM * items, size_t nitems, size_t *count){
	UDM_BOOLSTACK s;
	int res;
	size_t i;

	/* Init stack */
	s.ncstack=0;
	s.nastack=0;
	s.mcstack = s.mastack = UDM_MAXSTACK;
	s.cstack = (int*)malloc(UDM_MAXSTACK * sizeof(int));
	s.astack = (unsigned long*)malloc(UDM_MAXSTACK * sizeof(unsigned long));


#ifdef DEBUG_BOOL
	fprintf(stderr,"--------\n");
#endif
	for(i=0;i<nitems;i++){
		int c;
#ifdef DEBUG_BOOL
		fprintf(stderr,".[%d] %c\n", i, item_type(items[i].cmd, items[i].arg));
#endif
		switch(c=items[i].cmd){
			case UDM_STACK_RIGHT:
				/* Perform till LEFT bracket */
				while((TOPCMD(&s)!=UDM_STACK_LEFT)&&(TOPCMD(&s)!=UDM_STACK_BOT))
					perform(&s,POPCMD(&s));
				/* Pop LEFT bracket itself */
				if(TOPCMD(&s)==UDM_STACK_LEFT)
					POPCMD(&s);
				break;
			case UDM_STACK_OR:
			case UDM_STACK_AND:
				while(c<=TOPCMD(&s)){
					perform(&s,POPCMD(&s));
				}
				/* IMPORTANT! No break here! That's OK*/
				/*   ! */
			case UDM_STACK_LEFT:
			case UDM_STACK_NOT:
				PUSHCMD(&s,c);
				break;
  		        case UDM_STACK_PHRASE:
				PUSHARG(&s, (count[items[i+1].arg]) ? 1UL : 0UL);
			        for (i++; items[i].cmd != UDM_STACK_PHRASE; i++)
#ifdef DEBUG_BOOL
		fprintf(stderr,"[%d] %c\n", i, item_type(items[i].cmd, count[items[i].arg]));
		fprintf(stderr,"[%d] %c\n", i, item_type(items[i].cmd, count[items[i].arg]));
#endif
				  ;
				break;
			case UDM_STACK_WORD:
			default:
				PUSHARG(&s, (count[items[i].arg]) ? 1UL : 0UL);
				break;
		}
	}
	while(TOPCMD(&s)!=UDM_STACK_BOT){
		perform(&s,POPCMD(&s));
	}
	res=POPARG(&s);
	UDM_FREE(s.cstack); UDM_FREE(s.astack);
#ifdef DEBUG_BOOL
	fprintf(stderr, "result: %d\n", res);
#endif
	return(res);
}
