/* Copyright (C) 2000-2002 Lavtech.com corp. All rights reserved.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/

#include "udm_config.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>

#include "udmsearch.h"
#include "udm_xmalloc.h"

int main(int argc, char ** argv){
	char		template_name[1024] = "";
	char		query_string[1024] = "";
	char		self[1024] = "";
	const char	*env, *lcharset, *bcharset, *htok;
	char            *last;
	UDM_ENV		*Env;
	UDM_AGENT	*Agent;
	UDM_CHARSET	*lcs = NULL, *bcs = NULL;
	UDM_DOCUMENT	*Doc;
	UDM_RESULT	*Res;
	UDM_HTMLTOK	tag;
	UDM_VARLIST	tmpl;
	int		httpd = 0, res;
	char		*HDoc=NULL;
	char		*HEnd=NULL;
	char            ch;
	const char            *content_type;
#ifdef USE_PARSER
	UDM_PARSER	*Parser;
#endif
	
	/* Output Content-type if under HTTPD	 */
	/* Some servers do not pass QUERY_STRING */
	/* if the query was empty, so check	 */
	/* REQUEST_METHOD too     to be safe     */
	
	if(getenv("QUERY_STRING")||getenv("REQUEST_METHOD")){
		httpd=1;
	}
	
	UdmInit();
	UdmVarListInit(&tmpl);
	Env = UdmEnvInit(NULL);

	/* Detect self and template name */
	if((env=getenv("UDMSEARCH_DOCTEMPLATE")))
		strncpy(template_name,env,sizeof(template_name)-1);

	if((env=getenv("QUERY_STRING"))){
		strncpy(query_string,env,sizeof(query_string)-1);
		if((env=getenv("REDIRECT_STATUS"))){

			/* Check Apache internal redirect  */
			/* via   "AddHandler" and "Action" */

			strncpy(self,(env=getenv("REDIRECT_URL"))?env:"storedoc.cgi",sizeof(self)-1);
			if(!template_name[0]){
				strncpy(template_name,(env=getenv("PATH_TRANSLATED"))?env:"",sizeof(template_name)-1);
			}
		}else{
			/* CGI executed without Apache internal redirect */

			/* Detect $Self variable with OS independant SLASHES */
			strncpy(self,(env=getenv("SCRIPT_NAME"))?env:"storedoc.cgi",sizeof(self)-1);

			if(!template_name[0]){
				char *s,*e;
				
				/*This is with OS specific SLASHES */
				env=((env=getenv("SCRIPT_FILENAME"))?env:"storedoc.cgi");

				if(strcmp(UDM_CONF_DIR,".")){
					/* Take from the config directory */
					udm_snprintf(template_name,sizeof(template_name)-1,"%s/%s", UDM_CONF_DIR,(s=strrchr(env,UDMSLASH))?(s+1):(self));
				}else{
					/* Take from the current directory */
					strncpy(template_name,env,sizeof(template_name)-1);
				}

				/* Find right slash if it presents */
				s=((s=strrchr(template_name,UDMSLASH))?s:template_name);

				/* Find .cgi substring */
				if((e=strstr(s,".cgi"))){
					/* Replace ".cgi" with ".htm" */
					e[1]='h';e[2]='t';e[3]='m';
				}else{
					strcpy(template_name,"storedoc.htm");
				}
			}
		}
	}else{
		/* Executed from command line     */
		/* or under server which does not */
		/* pass an empty QUERY_STRING var */
		if(argv[1]) udm_snprintf(query_string,sizeof(query_string)-1,"q=%s",argv[1]);
		if(!template_name[0]) udm_snprintf(template_name,sizeof(template_name),"%s/%s", UDM_CONF_DIR,"storedoc.htm");
	}

	res = UdmTemplateLoad(Env, &Env->Vars, template_name, &tmpl);
	if(res){
		if(httpd)printf("Content-Type: text/plain\r\n\r\n");
		printf("%s\n",Env->errstr);
		UdmVarListFree(&tmpl);
		UdmEnvFree(Env);
		return(0);
	}
	UdmOpenLog("storedoc.cgi",Env,!httpd);
	
	Agent=UdmAgentInit(NULL,Env,0);
	UdmVarListAddStr(&Env->Vars,"QUERY_STRING",query_string);
	UdmVarListAddStr(&Env->Vars,"self",self);
	
	UdmParseQueryString(Agent,&Env->Vars,query_string);
	
	lcharset = UdmVarListFindStr(&Env->Vars, "CS", "");
	if (lcharset == NULL || (!strcmp(lcharset, ""))) {
		lcharset=UdmVarListFindStr(&Env->Vars,"LocalCharset","iso-8859-1");
	}
	lcs=UdmGetCharSet(lcharset);
	bcharset=UdmVarListFindStr(&Env->Vars,"BrowserCharset","iso-8859-1");
	bcs=UdmGetCharSet(bcharset);

	if(httpd){
		if(!bcs){
			printf("Content-Type: text/plain\r\n\r\n");
			printf("Unknown BrowserCharset '%s' in template '%s'\n",bcharset,template_name);
			exit(0);
		} else if (!lcs) {
			printf("Content-Type: text/plain\r\n\r\n");
			printf("Unknown LocalCharset '%s' in template '%s'\n",lcharset,template_name);
			exit(0);
		}else{
			printf("Content-type: text/html; charset=%s\r\n\r\n",bcharset);
		}
	}else{
		if(!bcs){
			printf("Unknown BrowserCharset '%s' in template '%s'\n",bcharset,template_name);
			exit(0);
		}
		if(!lcs){
			printf("Unknown LocalCharset '%s' in template '%s'\n",lcharset,template_name);
			exit(0);
		}
	}
	
	/* Now start displaying template*/
	UdmTemplatePrint(Agent, stdout, NULL, 0, &Env->Vars, &tmpl, "top");
	
	/* UnStore Doc, Highlight and Display */
	
	Doc=UdmDocInit(NULL);
	Res=UdmResultInit(NULL);
	
	UdmPrepare(Agent,Res);
	UdmVarListReplaceStr(&Doc->Sections, "URL_ID", UdmVarListFindStr(&Env->Vars, "rec_id", "0"));
	
	content_type = UdmVarListFindStr(&Env->Vars, "CT", "text/html");

#ifdef USE_PARSER
	Parser = UdmParserFind(&Env->Parsers, content_type);
	if (Parser) {
		content_type = Parser->to_mime ? Parser->to_mime : "text/html";
	}
#endif

	UdmUnStoreDoc(Agent,Doc);
	if(!Doc->Buf.content)goto fin;
	
	HEnd=HDoc = (char*)malloc(UDM_MAXDOCSIZE + 32);
	*HEnd='\0';
	
	if (strncasecmp(content_type, "text/plain", 10) == 0) {
	  sprintf(HEnd, "<pre>\n");
	  HEnd += strlen(HEnd);
	}

	UdmHTMLTOKInit(&tag);
  
	for(htok = UdmHTMLToken(Doc->Buf.content, (const char **)&last, &tag) ; htok ;) {
		switch(tag.type) {
		case UDM_HTML_COM:
		case UDM_HTML_TAG:
			memcpy(HEnd,htok,(size_t)(last-htok));
			HEnd+=last-htok;
			HEnd[0]='\0';
				UdmHTMLParseTag(&tag,Doc);
			break;
		case UDM_HTML_TXT:
		        ch = *last; *last = '\0';
			if (tag.title || tag.script) {
			  sprintf(HEnd, "%s", UdmHlConvert(NULL, htok, lcs, bcs));
			} else {
			  sprintf(HEnd, "%s", UdmHlConvert(&Res->WWList, htok, lcs, bcs));
			}
			HEnd=UDM_STREND(HEnd);
			*last = ch;
			break;
		}
		htok = UdmHTMLToken(NULL, (const char **)&last, &tag);
	}
	
	if (strncasecmp(content_type, "text/plain", 10) == 0) {
	  sprintf(HEnd, "</pre>\n");
	  HEnd += strlen(HEnd);
	}

	UdmVarListAddStr(&Env->Vars, "document", HDoc);
	UdmTemplatePrint(Agent, stdout, NULL, 0, &Env->Vars, &tmpl, "result");
	
fin:
	UdmResultFree(Res);
	UdmDocFree(Doc);
	
	UdmTemplatePrint(Agent, stdout, NULL, 0, &Env->Vars, &tmpl, "bottom");
	UdmVarListFree(&tmpl);
	UdmAgentFree(Agent);
	UdmEnvFree(Env);
	UDM_FREE(HDoc);

	return(0);
}
