/* Copyright (C) 2000-2002 Lavtech.com corp. All rights reserved.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/

#ifndef _UDM_DB_INT_H
#define _UDM_DB_INT_H

#include <limits.h>

#if (HAVE_MYSQL)

#include <mysql.h>
#define ER_DUP_ENTRY            1062
#define ER_DUP_KEY		1022
#define CR_SERVER_LOST          2013
#define CR_SERVER_GONE_ERROR    2006
#define ER_SERVER_SHUTDOWN      1053
#endif

#if (HAVE_PGSQL)
#include <libpq-fe.h>
#endif

#if HAVE_IODBC
#include <sql.h>
#include <sqlext.h>
#endif

#if HAVE_EASYSOFT
#include <sql.h>
#include <sqlext.h>
#endif

#if HAVE_VIRT
#include <iodbc.h>
#include <isql.h>
#include <isqlext.h>
#endif

#if HAVE_UNIXODBC
#include <sql.h>
#include <sqlext.h>
#endif

#if HAVE_SAPDB
#include <WINDOWS.H>
#include <sql.h>
#include <sqlext.h>
#endif

#if HAVE_SOLID
#include <cli0cli.h>
#endif

#if HAVE_DB2
#include <sqlcli1.h>
#endif

#if HAVE_IBASE
#include <ibase.h>
#endif

#if HAVE_CTLIB
#include <ctpublic.h>
#endif

#if HAVE_SQLITE
#include <sqlite.h>
#endif

#if HAVE_ORACLE8
#include <oci.h>
#endif


#ifdef HAVE_ORACLE8

#define	MAX_COLS_IN_TABLE	32
#define MAX_BIND_PARAM		4
#define BUF_OUT_SIZE		128
struct param_struct{
	int out_rec;
	int out_pos[MAX_BIND_PARAM];
	int out_pos_val[MAX_BIND_PARAM][BUF_OUT_SIZE];
};
#endif


/* Multi-dict mode defines */
#define MULTI_DICTS	0xff

#define	URL_DELETE_CACHE		128
#define	URL_SELECT_CACHE		256
#define URL_LOCK_TIME			4*60*60
#define UDM_MAX_MULTI_INSERT_QSIZE	16*1024
#define NDOCS_QUERY			"SELECT count(*) FROM url"

#define UDM_SQL_UNKNOWN	0
#define UDM_SQL_SELECT	1
#define UDM_SQL_UPDATE	2

typedef struct {
	char	*sqlname;
	int	sqltype;
	int	sqllen;
} UDM_SQLFIELD;

typedef struct {
	size_t	len;
	char	*val;
} UDM_PSTR;

typedef struct {
	size_t nRows;
	size_t nCols;
	int DBDriver;
	
	UDM_SQLFIELD	*Fields;
	UDM_PSTR	*Items;
	
#ifdef HAVE_PGSQL
	PGresult  *pgsqlres;
#endif
	
#ifdef HAVE_ORACLE8
	char	*defbuff[MAX_COLS_IN_TABLE]; /* Buffers for OCIStmtFetch */
	int	col_size[MAX_COLS_IN_TABLE]; /* Size of column */
	int	col_type[MAX_COLS_IN_TABLE]; /* Type of column */
	sb2	indbuff[MAX_COLS_IN_TABLE][BUF_OUT_SIZE];  /* Indicators for NULLs */
#endif

} UDM_SQLRES;

typedef struct {
	char *word;
	size_t nintags;
	uint4 *intags;
} UDM_MULTI_CACHE_WORD;

typedef struct {
	unsigned char secno;
	size_t nwords;
	UDM_MULTI_CACHE_WORD *words;
} UDM_MULTI_CACHE_SECTION;

typedef struct {
	urlid_t url_id;
	unsigned char reindex;
	size_t nsections;
	UDM_MULTI_CACHE_SECTION *sections;
} UDM_MULTI_CACHE_URL;

typedef struct {
	size_t nurls;
	UDM_MULTI_CACHE_URL *urls;
} UDM_MULTI_CACHE_TABLE;

typedef struct {
	unsigned char free;
	size_t nrecs;
	UDM_MULTI_CACHE_TABLE tables[MULTI_DICTS + 1];
	size_t nurls;
	urlid_t *urls;
} UDM_MULTI_CACHE;

typedef struct {
	unsigned char secno;
	const char *word;
	urlid_t url_id;
	size_t nintags;
	const char *intags;
} UDM_BLOB_CACHE_WORD;

typedef struct {
	unsigned char free;
	size_t nwords;
	size_t awords;
	UDM_BLOB_CACHE_WORD *words;
} UDM_BLOB_CACHE;

typedef struct struct_udm_db {
	int	freeme;
	char	*DBName;
	int	DBMode;
	char	*where;
        char    *from;
	int	DBType;
	int	DBDriver;
	
	int	DBSQL_IN;
	int	DBSQL_LIMIT;
	int	DBSQL_GROUP;
	int	DBSQL_TRUNCATE;
	int	DBSQL_SELECT_FROM_DELETE;
        int     DBSQL_SUBSELECT;
	
	int	connected;
	int	res_limit;
	int	commit_fl;
	unsigned int	numtables;
	int	errcode;
	char	errstr[2048];
	
	int		searchd;	/* Searchd daemon descriptor         */
        UDM_VARLIST     Vars;           /* optional parameters and variables*/

#ifdef HAVE_MYSQL
	MYSQL  mysql;
#endif

#ifdef HAVE_PGSQL
	PGconn	*pgsql;
#endif

#if (HAVE_IODBC || HAVE_UNIXODBC || HAVE_SOLID || HAVE_VIRT || HAVE_EASYSOFT || HAVE_SAPDB)
	HDBC	hDbc;
	HENV	hEnv;
	HSTMT	hstmt;
#endif

#if HAVE_DB2
	SQLHANDLE	hDbc;
	SQLHANDLE	hEnv;
	SQLHANDLE	hstmt;
#endif

#ifdef HAVE_IBASE
	isc_db_handle	DBH;		/* database handle    */
	ISC_STATUS	status[20];	/* status vector      */
	isc_tr_handle   tr_handle;	/* transaction handle */ 
#endif

#ifdef HAVE_CTLIB
	CS_CONTEXT	*ctx;
	CS_CONNECTION	*conn;
#endif

#ifdef HAVE_SQLITE
	struct sqlite	*sqlt;
#endif

#ifdef HAVE_ORACLE8
	OCIEnv     *envhp;
	OCIError   *errhp;
	OCISvcCtx  *svchp;
	OCIStmt	   *stmthp;
	OCIParam   *param;
	OCIDefine  *defb[MAX_COLS_IN_TABLE];
	OCIBind    *bndhp[MAX_BIND_PARAM];
	struct param_struct *par;
#endif

	UDM_MULTI_CACHE MultiCache;
} UDM_DB;

#endif
