/* Copyright (C) 2000-2002 Lavtech.com corp. All rights reserved.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/

#ifndef _UDM_VARS_H
#define _UDM_VARS_H

extern __C_LINK UDM_VARLIST * __UDMCALL UdmVarListInit(UDM_VARLIST * vars);
extern __C_LINK void __UDMCALL UdmVarListFree(UDM_VARLIST * vars);
extern void UdmVarFree(UDM_VAR *);

extern int UdmVarListAddEnviron(UDM_VARLIST *vars, const char *name);

extern __C_LINK int __UDMCALL UdmVarListAddStr(UDM_VARLIST * vars,const char * name, const char * val);
extern int UdmVarListAddInt(UDM_VARLIST * vars,const char * name, int val);
extern int UdmVarListAddUnsigned(UDM_VARLIST * vars, const char * name, uint4 val);
extern int UdmVarListAddDouble(UDM_VARLIST * vars, const char * name, double val);
extern int UdmVarListAdd(UDM_VARLIST * Lst,UDM_VAR * S);
extern int UdmVarListDel(UDM_VARLIST * Lst,const char *name);
extern int UdmVarListReplace(UDM_VARLIST * Lst,UDM_VAR * S);

extern int UdmVarListAddLst(UDM_VARLIST * Lst,UDM_VARLIST *Src, const char *name, const char *w);
extern int UdmVarListInsLst(UDM_VARLIST * Lst,UDM_VARLIST *Src, const char *name, const char *w);
extern int UdmVarListReplaceLst(UDM_VARLIST * Lst,UDM_VARLIST *Src, const char *name, const char *w);

extern __C_LINK int __UDMCALL UdmVarListReplaceStr(UDM_VARLIST * vars,const char * name,const char * val);
extern __C_LINK int __UDMCALL UdmVarListReplaceInt(UDM_VARLIST * vars,const char * name,int val);
extern __C_LINK int __UDMCALL UdmVarListReplaceUnsigned(UDM_VARLIST * vars, const char * name, uint4 val);
extern int UdmVarListReplaceDouble(UDM_VARLIST * vars, const char * name, double val);

extern int UdmVarListInsStr(UDM_VARLIST * vars,const char * name,const char * val);
extern int UdmVarListInsInt(UDM_VARLIST * vars,const char * name,int val);

extern UDM_VAR *UdmVarListFind(UDM_VARLIST * vars,const char * name);
extern UDM_VAR *UdmVarListFindWithValue(UDM_VARLIST * vars,const char * name,const char * val);

extern __C_LINK const char * __UDMCALL UdmVarListFindStr(UDM_VARLIST * vars,const char * name,const char * defval);
extern __C_LINK int          UdmVarListFindInt(UDM_VARLIST * vars,const char * name,int defval);
extern __C_LINK unsigned     UdmVarListFindUnsigned(UDM_VARLIST * vars, const char * name, unsigned defval);
extern __C_LINK double       UdmVarListFindDouble(UDM_VARLIST * vars, const char * name, double defval);


#endif
