#ifndef DIRECTORY_H
#define DIRECTORY_H

#include <sys/types.h>
#include <vector>
#include <string>

#include "SyscallException.h"

//----------------------------------------------------------------------------
class Directory
{
  public:
    //------------------------------------------------------------------------
    typedef std::vector<std::string> FileList;

    //------------------------------------------------------------------------
    Directory();
    Directory(const char *name) throw (SyscallException);
    ~Directory();

    //------------------------------------------------------------------------
    void read(const char *name) throw (SyscallException);

    //------------------------------------------------------------------------
    const char *getName() const;

    //------------------------------------------------------------------------
    bool hasDirectory(const char *name) const;
    bool hasFile(const char *name) const;

    //------------------------------------------------------------------------
    void getFilesWithSuffix(const char* suffix, FileList &list) const;

    //------------------------------------------------------------------------
    static bool hasDirectoryInCwd(const char *name)
        throw (SyscallException);

    static bool hasFileInCwd(const char *name)
        throw (SyscallException);

    static void chdir(const char *name)
        throw (SyscallException);

    static void mkdir(const char *name,
                      mode_t mode = 0755,
                      bool recursive = false)
        throw (SyscallException);

    static void rmdir(const char *name, bool recursive = false)
        throw (SyscallException);

    static void copy(const char *src, const char *dst)
        throw (SyscallException);


  private:

    //------------------------------------------------------------------------
    class DirectoryPImpl *m_pImpl;
};

#endif //DIRECTORY_H
