#include "config.h"

#include <iostream>

#include "Directory.h"
#include "Configuration.h"


//============================================================================
// Implementation of Configuration.h
//============================================================================

#define MOAGG_FULL_DATADIR MOAGG_DATADIR"/"PACKAGE_NAME

//----------------------------------------------------------------------------
Configuration Configuration::sm_instance;

//----------------------------------------------------------------------------
Configuration::Configuration()
{
    m_dataDir = NULL;
}

//----------------------------------------------------------------------------
Configuration::~Configuration()
{
    m_dataDir = NULL;
}

//----------------------------------------------------------------------------
void Configuration::searchDataDir()
    throw (Exception)
{
    const char *directories[] = 
    {
        MOAGG_FULL_DATADIR,
        "..", "." // ".." before "." is needed for the testsuite.
    };

    Directory d;
    for (size_t i=0; i<sizeof(directories)/sizeof(const char*); i++)
    {
        m_dataDir = directories[i];

        try
        {
            d.read(m_dataDir);
            if (d.hasDirectory("gfx"))
            {
                // We found it.
                return;
            }
        }
        catch (SyscallException &e)
        {
            // continue with the for loop.
        }
    }

    throw Exception(
        std::string("Cannot find data files in '")
        .append(MOAGG_FULL_DATADIR).append("', '..' or '.'"));
}
