#ifndef RESCUEGAME_H
#define RESCUEGAME_H

#include <set>

#include "Tools.h"
#include "GameControlBase.h"

class Crate;

//----------------------------------------------------------------------------
class RescueGame : public GameControlBase
{
    //------------------------------------------------------------------------
    class Running;
    friend class Running;
    class Running : public GameStateBase
    {
        STATE_OBJECT(Running);
      public:
        Running() {}
        ~Running() {}

        void onShipLanded(Ship *ship, const Platform *platform,
                          GameControlBase *game);
    };

    //------------------------------------------------------------------------
    class UnloadingCrate;
    friend class UnloadingCrate;
    class UnloadingCrate : public GameStateBase
    {
        STATE_OBJECT(UnloadingCrate);
      public:
        UnloadingCrate() {}
        ~UnloadingCrate() {}

        void updateShipControl(ShipControl control, GameControlBase *game) {}
        void onPreUpdate(GameControlBase *game);
    };
    
    //------------------------------------------------------------------------
    class UnloadingDelay;
    friend class UnloadingDelay;
    class UnloadingDelay : public GameStateBase
    {
        STATE_OBJECT(UnloadingDelay);
      public:
        UnloadingDelay() {}
        ~UnloadingDelay() {}

        void updateShipControl(ShipControl control, GameControlBase *game) {}
        void onPreUpdate(GameControlBase *game);
    };

  public:
    //------------------------------------------------------------------------
    RescueGame();
    ~RescueGame();

    //------------------------------------------------------------------------
    void initGameControl(const XMLNode *gameControlNode)
        throw (Exception);


    //------------------------------------------------------------------------
    /// Initiates the unloading delay of the player's crates.
    void initUnloadingDelay();

    unsigned countCratesToRescue() const;


  protected:

    //------------------------------------------------------------------------
    void unloadCrate();

    //------------------------------------------------------------------------
    /// The current crate to unload.
    Crate *m_crateToUnload;

  private:

    GameStateBase *getRunningState() const { return Running::getInstance(); }
    bool continueAfterExplosion() const { return countCratesToRescue() > 0; }
};

#endif //RACEGAME_H
