#ifndef SCORETABLE_H
#define SCORETABLE_H

#include <Tools.h>

class Crate;

//----------------------------------------------------------------------------
/**
 * This class contains the actual score counting.
 * Every get-method represents a score-counting action
 * and returns the apropriate score to add.
 */
class ScoreTable
{
    SINGLETON_OBJECT(ScoreTable);

  public:
    ~ScoreTable() {}

    unsigned getCratePickUp(Crate *crate);
    unsigned getCrateRescued(Crate *crate);
    unsigned getMissileShot();
    unsigned getSAMBatteryShot();
    unsigned getTurretShot();
    unsigned getMortarShot();
    unsigned getTankShot();
    unsigned getSpareFuelStep();

  protected:
    ScoreTable() {}
};

#endif //SCORETABLE_H
