#ifndef TILES_H
#define TILES_H

#include <map>

#include "File.h"
#include "SDLCalls.h"


//----------------------------------------------------------------------------
class TileException : public Exception
{
  public:
    TileException(Uint8 id);
    ~TileException();

    std::string toString() const;

  protected:
    Uint8 m_id;
};

//----------------------------------------------------------------------------
class TileCategoryException : public Exception
{
  public:
    TileCategoryException(Uint8 id);
    ~TileCategoryException();

    std::string toString() const;

  protected:
    Uint8 m_id;
};



//----------------------------------------------------------------------------
class TileCategory
{
    typedef std::map<Uint8, SDL_Surface*> TileMap;

  public:
    ~TileCategory();

    SDL_Surface *getTile(Uint8 id) const
        throw (Exception);

    static TileCategory *create(const Uint8 categoryId, const char *dir)
        throw (Exception);

    inline SDL_Surface *operator[](Uint8 id) const
    {
        return getTile(id);
    }

    inline size_t size() const
    {
        return m_map.size();
    }

    inline bool empty() const
    {
        return m_map.empty();
    }

  protected:
    TileCategory();

  protected:
    TileMap m_map;
};


//----------------------------------------------------------------------------
class TileCategories
{
    typedef std::map<Uint8, TileCategory*> CategoryMap;

  public:
    ~TileCategories();

    const TileCategory &getCategory(Uint8 id) const
        throw (Exception);

    static void init()
        throw (Exception);
    static void destroy();

    static inline TileCategories &getInstance()
    {
        return *sm_instance;
    }

    inline const TileCategory &operator[](Uint8 id) const
    {
        return getCategory(id);
    }

    inline size_t size() const
    {
        return m_map.size();
    }

    inline bool empty() const
    {
        return m_map.empty();
    }

  protected:
    TileCategories();

  protected:
    CategoryMap m_map;
    static TileCategories *sm_instance;
};

#endif //TILES_H
