#ifndef GUI_EXCEPTION_H
#define GUI_EXCEPTION_H

#include "Exception.h"

class GuiException : public Exception
{
  public:

    GuiException(const std::string& message)
      : Exception(message) {}
    virtual ~GuiException() {}
};

class GuiMenuException : public GuiException
{
  public:

    GuiMenuException(const std::string& message, int id)
      : GuiException(message), m_id(id) {}

    virtual ~GuiMenuException() {}

    virtual std::string toString() const {
      char tmp[256];
      sprintf(tmp, "%d", m_id);
      return std::string(m_message).append(": ").append(tmp);
    }

  protected:

    int m_id;
};


#endif // GUI_EXCEPTION_H
