#ifndef KEYPRESS_WIDGET_H
#define KEYPRESS_WIDGET_H

#include <pglabel.h>
#include <pgeventobject.h>
#include <pgmessageobject.h>

class KeyPressWidget : public PG_Label, public PG_EventObject
{
  public:

    KeyPressWidget(SDLKey key, PG_Widget *parent,
        const PG_Rect &r, const char *style="ThemeWidget");
    virtual ~KeyPressWidget();

    inline SDLKey getKey()
    {
      return m_key;
    }

    void revertKey();
    void saveKey();

  protected:

    bool eventKeyDown(const SDL_KeyboardEvent *key);
    bool eventMouseButtonDown(const SDL_MouseButtonEvent *mouse);
    void eventShow();

    SDLKey m_key;
    SDLKey m_oldKey;

    bool m_focus;
};

#endif // KEYPRESS_WIDGET_H

