#include <iostream>

#include "PlayerConfiguration.h"
#include "ControlMenu.h"


MENU_SINGLETON_INIT(Control);

//----------------------------------------------------------------------
ControlMenu::ControlMenu() throw(GuiMenuException)
{
  getWidget(ID_CONTROL_MENU_OK)->SetEventObject(
    MSG_BUTTONCLICK, this, (MSG_CALLBACK_OBJ)&ControlMenu::onOk);
  getWidget(ID_CONTROL_MENU_CANCEL)->SetEventObject(
    MSG_BUTTONCLICK, this, (MSG_CALLBACK_OBJ)&ControlMenu::onCancel);

  const PlayerConfiguration::Control::KeyConfig *kc =
      PlayerConfiguration::getInstance()->getControl()->getKeyConfig();
  PG_Widget *wi;

  wi = getWidget(ID_CONTROL_MENU_THRUST);
  m_thrustWidget = new KeyPressWidget(
      kc->thrust, wi, PG_Rect(0, 0, wi->Width(), wi->Height()));
  m_thrustWidget->Show();

  wi = getWidget(ID_CONTROL_MENU_ALIGN);
  m_alignWidget = new KeyPressWidget(
      kc->align, wi, PG_Rect(0, 0, wi->Width(), wi->Height()));
  m_alignWidget->Show();

  wi = getWidget(ID_CONTROL_MENU_LEFT);
  m_leftWidget = new KeyPressWidget(
      kc->rotleft, wi, PG_Rect(0, 0, wi->Width(), wi->Height()));
  m_leftWidget->Show();

  wi = getWidget(ID_CONTROL_MENU_RIGHT);
  m_rightWidget = new KeyPressWidget(
      kc->rotright, wi, PG_Rect(0, 0, wi->Width(), wi->Height()));
  m_rightWidget->Show();
  
  wi = getWidget(ID_CONTROL_MENU_FIRE);
  m_fireWidget = new KeyPressWidget(
      kc->fire, wi, PG_Rect(0, 0, wi->Width(), wi->Height()));
  m_fireWidget->Show();
  
  wi = getWidget(ID_CONTROL_MENU_PAUSE);
  m_pauseWidget = new KeyPressWidget(
      kc->escape, wi, PG_Rect(0, 0, wi->Width(), wi->Height()));
  m_pauseWidget->Show();

  // Always show all child widgets.
  getWidget(ID_CONTROL_MENU_OK)->Show();
  getWidget(ID_CONTROL_MENU_CANCEL)->Show();
  getWidget(ID_CONTROL_MENU_THRUST_LAB)->Show();
  getWidget(ID_CONTROL_MENU_THRUST)->Show();
  getWidget(ID_CONTROL_MENU_ALIGN_LAB)->Show();
  getWidget(ID_CONTROL_MENU_ALIGN)->Show();
  getWidget(ID_CONTROL_MENU_LEFT_LAB)->Show();
  getWidget(ID_CONTROL_MENU_LEFT)->Show();
  getWidget(ID_CONTROL_MENU_RIGHT_LAB)->Show();
  getWidget(ID_CONTROL_MENU_RIGHT)->Show();
  getWidget(ID_CONTROL_MENU_FIRE_LAB)->Show();
  getWidget(ID_CONTROL_MENU_FIRE)->Show();
  getWidget(ID_CONTROL_MENU_PAUSE_LAB)->Show();
  getWidget(ID_CONTROL_MENU_PAUSE)->Show();
}

//----------------------------------------------------------------------
ControlMenu::~ControlMenu()
{
  // keypress widgets will be deleted by parents
}

//----------------------------------------------------------------------
PARAGUI_CALLBACK(ControlMenu::onOk)
{
    PlayerConfiguration::Control::KeyConfig *kc =
        PlayerConfiguration::getInstance()->getControl()->getKeyConfig();
    kc->thrust = m_thrustWidget->getKey();
    kc->align = m_alignWidget->getKey();
    kc->rotleft= m_leftWidget->getKey();
    kc->rotright = m_rightWidget->getKey();
    kc->fire = m_fireWidget->getKey();
    kc->escape = m_pauseWidget->getKey();

    m_thrustWidget->saveKey();
    m_alignWidget->saveKey();
    m_leftWidget->saveKey();
    m_rightWidget->saveKey();
    m_fireWidget->saveKey();
    m_pauseWidget->saveKey();

    PlayerConfiguration::getInstance()->writeConfiguration();

    MenuManager::getInstance()->changeTo(getPrevious(), true, false);
    return true;
}

//----------------------------------------------------------------------
PARAGUI_CALLBACK(ControlMenu::onCancel)
{
  m_thrustWidget->revertKey();
  m_alignWidget->revertKey();
  m_leftWidget->revertKey();
  m_rightWidget->revertKey();
  m_fireWidget->revertKey();
  m_pauseWidget->revertKey();
  MenuManager::getInstance()->changeTo(getPrevious(), true, false);
  return true;
}

//----------------------------------------------------------------------
void ControlMenu::eventShow()
{
  getWidget(ID_CONTROL_MENU)->Show();
}

//----------------------------------------------------------------------
void ControlMenu::eventHide()
{
  getWidget(ID_CONTROL_MENU)->Hide();
}

//----------------------------------------------------------------------
bool ControlMenu::checkKeys()
{
  int numKeys = 6;
  SDLKey *keys = new SDLKey[numKeys];
  keys[0] = m_thrustWidget->getKey();
  keys[1] = m_alignWidget->getKey();
  keys[2] = m_leftWidget->getKey();
  keys[3] = m_rightWidget->getKey();
  keys[4] = m_fireWidget->getKey();
  keys[5] = m_pauseWidget->getKey();
  
  int i, j;
  for(i = 0; i < numKeys-1; ++i)
  {
    for(j = i+1; j < numKeys ; ++j)
    {
      if(keys[i] == keys[j])
      {
        delete[] keys;
        return false;
      }
    }
  }
  delete[] keys;
  return true;
}
