#include "Tools.h"

#include "ObjectBase.h"
#include "Crates.h"
#include "Grenade.h"
#include "Missile.h"
#include "Mortars.h"
#include "Particle.h"
#include "Platform.h"
#include "Projectile.h"
#include "SAMBattery.h"
#include "Ship.h"
#include "Turrets.h"
#include "Tank.h"

#include "ObjectVisitors.h"


//----------------------------------------------------------------------------
void ObjectVisitor::visit(ObjectList &l)
{
    for (ObjectIter iter = l.begin();
         iter != l.end() && continueForLoopInVisitObjectList();
         ++iter)
    {
        // Only visit objects, that are not to be removed!
        if (!iter->toRemove)
        {
            iter->object->accept(this);
        }
    }
}

//----------------------------------------------------------------------------
void ObjectVisitor::visit(ParticleList &l)
{
    for (ParticleIter iter = l.begin(); iter != l.end(); ++iter)
    {
        // Only visit particles, that are not to be removed!
        if (!(*iter)->isRemove())
        {
            (*iter)->accept(this);
        }
    }
}


//----------------------------------------------------------------------------
void ObjectConstVisitor::visit(const ObjectList &l)
{
    for (ObjectCIter iter = l.begin();
         iter != l.end() && continueForLoopInVisitObjectList();
         ++iter)
    {
        // Only visit objects, that are not to be removed!
        if (!iter->toRemove)
        {
            iter->object->accept(this);
        }
    }
}

//----------------------------------------------------------------------------
void ObjectConstVisitor::visit(const ParticleList &l)
{
    for (ParticleCIter iter = l.begin(); iter != l.end(); ++iter)
    {
        // Only visit particles, that are not to be removed!
        if (!(*iter)->isRemove())
        {
            (*iter)->accept(this);
        }
    }
}


//----------------------------------------------------------------------------
void FindPlatformByNumberConstVisitor::do_visit(const Platform *p)
{
    if (p->getNumber() == m_number)
    {
        m_platform = p;
    }
}


//----------------------------------------------------------------------------
void FindLandingPlatformConstVisitor::do_visit(const Platform *p)
{
    if (m_ship->isInLandingZone(p->getLandingZone()))
    {
        m_platform = p;
    }
}


//----------------------------------------------------------------------------
void CountCratesToRescueConstVisitor::do_visit(const Crate *c)
{
    switch (c->getType())
    {
    case CrateSurfaces::T_SMALL:
    case CrateSurfaces::T_MEDIUM:
    case CrateSurfaces::T_BIG:
        ++m_cratesToRescue;
        break;
    default:
        break;
    }
}


//----------------------------------------------------------------------------
void HasCrateForShipConstVisitor::do_visit(const Crate *c)
{
    if (ObjectBase::isCollision(m_ship, c) &&
        m_ship->hasCapacity(c))
    {
        m_crate = c;
    }
}


//----------------------------------------------------------------------------
void InitializeExplosionParticleConstVisitor::do_visit(const GrenadeBase *g)
{
    m_particle->setLifeCount(SDLFrameRate::getFrameRate() - myRand(64));
    m_particle->setGravity();
    m_particle->setGradient();


    // Initialize the position.

    Sint16 xm, ym;
    SDL_TOOLS::getCentre(g->getPosition(), xm, ym);

    m_particle->setPosition(xm + 2 - myRand(5), ym + 2 - myRand(5));


    // Initialize the velocity.
    MATH_TOOLS::Vector relativeVelocity(
        1.0 * PARTICLE_VELOCITY/2 - (myRand(PARTICLE_VELOCITY)),
        1.0 * PARTICLE_VELOCITY/2 - (myRand(PARTICLE_VELOCITY)));

    m_particle->getFineVelocity() = g->getFineVelocity() + relativeVelocity;
}

//----------------------------------------------------------------------------
void InitializeExplosionParticleConstVisitor::do_visit(const Missile *m)
{
    do_do_visit(m);
}

//----------------------------------------------------------------------------
void InitializeExplosionParticleConstVisitor::do_visit(const MortarBase *m)
{
    m_particle->setLifeCount(SDLFrameRate::getFrameRate() - myRand(64));
    m_particle->setGravity();
    m_particle->setGradient();


    // Initialize the position.

    Sint16 xm, ym;
    SDL_TOOLS::getCentre(m->getPosition(), xm, ym);

    m_particle->setPosition(xm + 6 - myRand(13), ym + 6 - myRand(13));


    // Initialize the velocity.

    double rand1 = 1.0 * (myRand(PARTICLE_VELOCITY));
    double rand2 = 1.0 * (myRand(PARTICLE_VELOCITY));
    double offset = -1.0 * (PARTICLE_VELOCITY/2);

    switch (m->getOrientation())
    {
    case OrientatingDecorationBase::O_TOP:
        m_particle->getFineVelocity().set(offset + rand1, rand2);
        break;
    case OrientatingDecorationBase::O_BOTTOM:
        m_particle->getFineVelocity().set(offset + rand1, -rand2);
        break;
    case OrientatingDecorationBase::O_LEFT:
        m_particle->getFineVelocity().set(rand1, offset + rand2);
        break;
    case OrientatingDecorationBase::O_RIGHT:
        m_particle->getFineVelocity().set(-rand1, offset + rand2);
        break;
    }
}

//----------------------------------------------------------------------------
void InitializeExplosionParticleConstVisitor::do_visit(const ProjectileBase *p)
{
    m_particle->setLifeCount(SDLFrameRate::getFrameRate() - myRand(64));
    m_particle->setGravity();


    // Initialize the position.

    Sint16 xm, ym;
    SDL_TOOLS::getCentre(p->getPosition(), xm, ym);

    m_particle->setPosition(xm + 2 - myRand(5), ym + 2 - myRand(5));


    // Initialize the velocity.

    m_particle->getFineVelocity().set(
        1.0 * PARTICLE_VELOCITY/2 - (myRand(PARTICLE_VELOCITY)),
        1.0 * PARTICLE_VELOCITY/2 - (myRand(PARTICLE_VELOCITY)));
}

//----------------------------------------------------------------------------
void InitializeExplosionParticleConstVisitor::do_visit(const SAMBatteryBase *s)
{
    m_particle->setLifeCount(SDLFrameRate::getFrameRate() - myRand(64));
    m_particle->setGravity();
    m_particle->setGradient();


    // Initialize the position.

    Sint16 xm, ym;
    SDL_TOOLS::getCentre(s->getPosition(), xm, ym);

    m_particle->setPosition(xm + 6 - myRand(13), ym + 6 - myRand(13));


    // Initialize the velocity.

    double rand1 = 1.0 * (myRand(PARTICLE_VELOCITY));
    double rand2 = 1.0 * (myRand(PARTICLE_VELOCITY));
    double offset = -1.0 * (PARTICLE_VELOCITY/2);

    switch (s->getOrientation())
    {
    case OrientatingDecorationBase::O_TOP:
        m_particle->getFineVelocity().set(offset + rand1, rand2);
        break;
    case OrientatingDecorationBase::O_BOTTOM:
        m_particle->getFineVelocity().set(offset + rand1, -rand2);
        break;
    case OrientatingDecorationBase::O_LEFT:
        m_particle->getFineVelocity().set(rand1, offset + rand2);
        break;
    case OrientatingDecorationBase::O_RIGHT:
        m_particle->getFineVelocity().set(-rand1, offset + rand2);
        break;
    }
}

//----------------------------------------------------------------------------
void InitializeExplosionParticleConstVisitor::do_visit(const Ship *s)
{
    do_do_visit(s);
}

//----------------------------------------------------------------------------
void InitializeExplosionParticleConstVisitor::do_visit(const Tank *t)
{
    m_particle->setLifeCount(SDLFrameRate::getFrameRate() - myRand(64));
    m_particle->setGravity();
    m_particle->setGradient();


    // Initialize the position.

    Sint16 xm, ym;
    SDL_TOOLS::getCentre(t->getPosition(), xm, ym);

    m_particle->setPosition(xm + 12 - myRand(25), ym + 6 - myRand(13));


    // Initialize the velocity.

    m_particle->getFineVelocity().set(
        1.0 * PARTICLE_VELOCITY/2 - (myRand(PARTICLE_VELOCITY)),
        -1.0 * (myRand(PARTICLE_VELOCITY)));
}

//----------------------------------------------------------------------------
void InitializeExplosionParticleConstVisitor::do_visit(const TurretBase *t)
{
    m_particle->setLifeCount(SDLFrameRate::getFrameRate() - myRand(64));
    m_particle->setGravity();
    m_particle->setGradient();


    // Initialize the position.

    Sint16 xm, ym;
    SDL_TOOLS::getCentre(t->getPosition(), xm, ym);

    m_particle->setPosition(xm + 6 - myRand(13), ym + 6 - myRand(13));


    // Initialize the velocity.

    double rand1 = 1.0 * (myRand(PARTICLE_VELOCITY));
    double rand2 = 1.0 * (myRand(PARTICLE_VELOCITY));
    double offset = -1.0 * (PARTICLE_VELOCITY/2);

    switch (t->getOrientation())
    {
    case OrientatingDecorationBase::O_TOP:
        m_particle->getFineVelocity().set(offset + rand1, rand2);
        break;
    case OrientatingDecorationBase::O_BOTTOM:
        m_particle->getFineVelocity().set(offset + rand1, -rand2);
        break;
    case OrientatingDecorationBase::O_LEFT:
        m_particle->getFineVelocity().set(rand1, offset + rand2);
        break;
    case OrientatingDecorationBase::O_RIGHT:
        m_particle->getFineVelocity().set(-rand1, offset + rand2);
        break;
    }
}

//----------------------------------------------------------------------------
void InitializeExplosionParticleConstVisitor::do_do_visit(const ControllableObjectBase *o)
{
    m_particle->setLifeCount(SDLFrameRate::getFrameRate() - myRand(64));
    m_particle->setGravity();
    m_particle->setGradient();


    // Initialize the position.

    Sint16 xm, ym;
    SDL_TOOLS::getCentre(o->getPosition(), xm, ym);

    m_particle->setPosition(xm + 8 - myRand(17), ym + 8 - myRand(17));


    // Initialize the velocity.

    MATH_TOOLS::Vector relativeVelocity;
    relativeVelocity.set(
        1.0 * PARTICLE_VELOCITY/2 - (myRand(PARTICLE_VELOCITY)),
        1.0 * PARTICLE_VELOCITY/2 - (myRand(PARTICLE_VELOCITY)));

    m_particle->getFineVelocity() = o->getFineVelocity() - relativeVelocity;
}
