#ifndef BLACKHOLE_H
#define BLACKHOLE_H

#include "Tools.h"
#include "StaticDecorationBase.h"

//----------------------------------------------------------------------------
class BlackHoleSurfaces : public SingleSurfacesBase
{
    SURFACES_SINGLETON_OBJECT(BlackHoleSurfaces);
};


//----------------------------------------------------------------------------
class BlackHole : public StaticDecorationBase
{
  public:
    //------------------------------------------------------------------------
    class InitializationData : public StaticDecorationBase::InitializationData
    {
      public:
        InitializationData(const XMLNode *blackHoleNode);
        ~InitializationData();

        int gravity;
    };


    //------------------------------------------------------------------------
    virtual ~BlackHole();

    static BlackHole *create(const XMLNode *blackHoleNode);

    //------------------------------------------------------------------------
    void addGravityToPlayGround() const;

    inline int getGravity() const
    {
        return m_gravity;
    }

    //------------------------------------------------------------------------
    void update();

  protected:
    //------------------------------------------------------------------------
    BlackHole(const InitializationData &init);

  private:
    //------------------------------------------------------------------------
    DECLARE_OBJECT_VISITOR_API();

    //------------------------------------------------------------------------
    int m_gravity;
};

#endif //BLACKHOLE_H
