#ifndef TANK_H
#define TANK_H

#include "MovingDecorationBase.h"


//----------------------------------------------------------------------------
class TankSurfaces : public SingleSurfacesBase
{
    SURFACES_SINGLETON_OBJECT(TankSurfaces);
};



//----------------------------------------------------------------------------
#undef DECLARE_AIM_STRATEGY
#define DECLARE_AIM_STRATEGY(c) \
    class c; \
    friend class c; \
    class c : public AimStrategy \
    { \
        STRATEGY_OBJECT(c); \
      public: \
        c() {} \
        ~c() {} \
        void setAngle(Tank *t); \
    }


//----------------------------------------------------------------------------
#undef DECLARE_UPDATE_STATE
#define DECLARE_UPDATE_STATE(c) \
    class c; \
    friend class c; \
    class c : public UpdateState \
    { \
        STATE_OBJECT(c); \
      public: \
        c() {} \
        ~c() {} \
        void update(Tank *tank); \
    }


//----------------------------------------------------------------------------
class Tank : public MovingDecorationBase
{
    //------------------------------------------------------------------------
    enum EnumAimStrategy
    {
        AS_RANDOM,
        AS_SMART
    };

    //------------------------------------------------------------------------
    class AimStrategy
    {
      public:
        AimStrategy() {}
        virtual ~AimStrategy() {}

        static AimStrategy *get(EnumAimStrategy strategy);

        virtual void setAngle(Tank *t) = 0;
    };

    //------------------------------------------------------------------------
    DECLARE_AIM_STRATEGY(Random);
    DECLARE_AIM_STRATEGY(Smart);

    //------------------------------------------------------------------------
    class UpdateState
    {
      protected:
        UpdateState() {}
      public:
        virtual ~UpdateState() {}

        virtual void update(Tank *tank) = 0;
    };

    //------------------------------------------------------------------------
    DECLARE_UPDATE_STATE(Moving);
    DECLARE_UPDATE_STATE(WaitForShooting);
    DECLARE_UPDATE_STATE(WaitForMoving);

  public:
    //------------------------------------------------------------------------
    class InitializationData : public MovingDecorationBase::InitializationData
    {
      public:
        InitializationData(const XMLNode *tankNode);
        ~InitializationData();

        Uint16 x;
        Uint16 y;
        Uint16 w;

        unsigned hitPoints;
        unsigned speed;
        EnumAimStrategy aimStrategy;
    };

    //------------------------------------------------------------------------
    ~Tank();

    static Tank *create(const XMLNode *tankNode);

    //------------------------------------------------------------------------
    /**
     * Called for a projectile collision to determine,
     * if the tank's hitpoints are reached.
     */
    inline bool decAndTestHitPoints()
    {
        return --m_hitPoints == 0;
    }

    //------------------------------------------------------------------------
    inline int getAngle() const
    {
        return m_angle;
    }

    inline unsigned getProjectileSpeed() const
    {
        return m_projectileSpeed;
    }

    //------------------------------------------------------------------------
    inline void setUpdateState(UpdateState *state)
    {
        m_updateState = state;
    }

    //------------------------------------------------------------------------
    void update();

  protected:
    //------------------------------------------------------------------------
    Tank(const InitializationData &init);

    static Tank *create(const InitializationData &init);

    //------------------------------------------------------------------------
    void initMoving();
    void initWaitForShooting();
    void initWaitForMoving();

  private:
    //------------------------------------------------------------------------
    DECLARE_OBJECT_VISITOR_API();

    //------------------------------------------------------------------------
    Uint16 m_x;
    Uint16 m_y;
    Uint16 m_w;

    unsigned m_hitPoints;

    Uint16 m_nextOffset;

    int m_angle;
    unsigned m_projectileSpeed;

    unsigned m_frameDelay;
    unsigned m_frameCounter;

    //------------------------------------------------------------------------
    AimStrategy *m_aimStrategy;
    UpdateState *m_updateState;
};

#endif //TANK_H
