#ifndef SOUNDINTERFACE_H
#define SOUNDINTERFACE_H

#include "Tools.h"
#include "SDLTools.h"

//----------------------------------------------------------------------------
class SoundInterface
{
  public:
    //------------------------------------------------------------------------
    SoundInterface() {}
    virtual ~SoundInterface() {}

    //------------------------------------------------------------------------
    virtual void enableSound() = 0;
    virtual void disableSound() = 0;
    virtual bool isSoundEnabled() const = 0;

    virtual void enableMusic() = 0;
    virtual void disableMusic() = 0;
    virtual bool isMusicEnabled() const = 0;

    virtual void setSoundVolume(Uint8 volume) = 0;
    virtual Uint8 getSoundVolume() const = 0;
    virtual void setMusicVolume(Uint8 volume) = 0;
    virtual Uint8 getMusicVolume() const = 0;
    
    //------------------------------------------------------------------------
    virtual void playTitleMusic() = 0;
    virtual void playInGameMusic() = 0;
    virtual void playHighScoreMusic1stEntry() = 0;
    virtual void playHighScoreMusicOtherEntry() = 0;
    virtual void playHighScoreMusicNoEntry() = 0;

    //------------------------------------------------------------------------
    virtual void onShipShoot() = 0;
    virtual void onShipExplosion() = 0;
    virtual void onShipThrustOn() = 0;
    virtual void onShipThrustOff() = 0;
    virtual void onShipPlatformBump() = 0;
    virtual void onShipOutOfFuel() = 0;

    virtual void onCratePickUp() = 0;
    virtual void onCrateUnload() = 0;

    virtual void onMissileExplosion() = 0;

    virtual void onTurretShoot() = 0;
    virtual void onTurretExplosion() = 0;

    virtual void onMortarShoot() = 0;
    virtual void onMortarExplosion() = 0;

    virtual void onTankShoot() = 0;
    virtual void onTankExplosion() = 0;

    virtual void onSAMBatteryShoot() = 0;
    virtual void onSAMBatteryExplosion() = 0;

    virtual void onProjectileExplosion() = 0;
    virtual void onGrenadeExplosion() = 0;

    virtual void onAddFuelToScore() = 0;
    virtual void onAddBonusToScore() = 0;

    //------------------------------------------------------------------------
    static void setInstance(SoundInterface *instance)
    {
        sm_instance = instance;
    }

    static SoundInterface *getInstance()
    {
        return sm_instance;
    }

  private:

    //------------------------------------------------------------------------
    static SoundInterface *sm_instance;
};


//----------------------------------------------------------------------------
class NullSoundInterface : public SoundInterface
{
    SINGLETON_OBJECT(NullSoundInterface);

  public:
    //------------------------------------------------------------------------
    NullSoundInterface()
    {
        m_enableSound = false;
        m_enableMusic = false;
        m_soundVolume = 0;
        m_musicVolume = 0;
    }

    ~NullSoundInterface() {}

    //------------------------------------------------------------------------
    void enableSound() { m_enableSound = true; }
    void disableSound() { m_enableSound = false; }
    bool isSoundEnabled() const { return m_enableSound; }

    void enableMusic() { m_enableMusic = true; }
    void disableMusic() { m_enableMusic = false; }
    bool isMusicEnabled() const { return m_enableMusic; }

    void setSoundVolume(Uint8 volume) { m_soundVolume = volume; }
    Uint8 getSoundVolume() const { return m_soundVolume; }

    void setMusicVolume(Uint8 volume) { m_musicVolume = volume; }
    Uint8 getMusicVolume() const { return m_musicVolume; }

    //------------------------------------------------------------------------
    void playTitleMusic() {}
    void playInGameMusic() {}
    void playHighScoreMusic1stEntry() {}
    void playHighScoreMusicOtherEntry() {}
    void playHighScoreMusicNoEntry() {}

    //------------------------------------------------------------------------
    void onShipShoot() {}
    void onShipExplosion() {}
    void onShipThrustOn() {}
    void onShipThrustOff() {}
    void onShipPlatformBump() {}
    void onShipOutOfFuel() {}

    void onCratePickUp() {}
    void onCrateUnload() {}

    void onMissileExplosion() {}

    void onTurretShoot() {}
    void onTurretExplosion() {}

    void onMortarShoot() {}
    void onMortarExplosion() {}

    void onTankShoot() {}
    void onTankExplosion() {}

    void onSAMBatteryShoot() {}
    void onSAMBatteryExplosion() {}

    void onProjectileExplosion() {}
    void onGrenadeExplosion() {}

    void onAddFuelToScore() {}
    void onAddBonusToScore() {}

  private:
    //------------------------------------------------------------------------
    bool m_enableSound;
    bool m_enableMusic;

    Uint8 m_soundVolume;
    Uint8 m_musicVolume;
};


//----------------------------------------------------------------------------
class SoundBridge : public SoundInterface
{
    SINGLETON_OBJECT(SoundBridge);

  public:
    //------------------------------------------------------------------------
    SoundBridge() { m_thrustChannel = -1; }
    ~SoundBridge() {}

    //------------------------------------------------------------------------
    void enableSound();
    void disableSound();
    bool isSoundEnabled() const;

    void enableMusic();
    void disableMusic();
    bool isMusicEnabled() const;

    void setSoundVolume(Uint8 volume);
    Uint8 getSoundVolume() const;

    void setMusicVolume(Uint8 volume);
    Uint8 getMusicVolume() const;

    //------------------------------------------------------------------------
    void playTitleMusic();
    void playInGameMusic();
    void playHighScoreMusic1stEntry();
    void playHighScoreMusicOtherEntry();
    void playHighScoreMusicNoEntry();

    //------------------------------------------------------------------------
    void onShipShoot();
    void onShipExplosion();
    void onShipThrustOn();
    void onShipThrustOff();
    void onShipPlatformBump();
    void onShipOutOfFuel();

    void onCratePickUp();
    void onCrateUnload();

    void onMissileExplosion();

    void onTurretShoot();
    void onTurretExplosion();

    void onMortarShoot();
    void onMortarExplosion();

    void onTankShoot();
    void onTankExplosion();

    void onSAMBatteryShoot();
    void onSAMBatteryExplosion();

    void onProjectileExplosion();
    void onGrenadeExplosion();

    void onAddFuelToScore();
    void onAddBonusToScore();

  private:

    //------------------------------------------------------------------------
    int m_thrustChannel;
};

#endif //SOUNDINTERFACE_H
