#!/usr/bin/env python
# vim: ai ts=4 sts=4 et sw=4

#    PhotoView.py: Manage Photo View

#    Copyright (c) 2007 Intel Corporation
#
#    This program is free software; you can redistribute it and/or modify it
#    under the terms of the GNU General Public License as published by the Free
#    Software Foundation; version 2 of the License
#
#    This program is distributed in the hope that it will be useful, but
#    WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
#    or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
#    for more details.
#
#    You should have received a copy of the GNU General Public License along
#    with this program; if not, write to the Free Software Foundation, Inc., 59
#    Temple Place - Suite 330, Boston, MA 02111-1307, USA.

import Constant
import GeneralFunc
import sys, os, os.path, string
import pygtk, gobject
import gtk, gtk.gdk, gtk.glade
import string

class PhotoView:
    """
    A class which manage photo view.
    """

    def __init__(self, app):
        """
        init function
        """
        self.app = app
        self.wTree = gtk.glade.XML('MobilePlayer.glade',root='mp_photo_nbk')

        self.view_nbk = self.wTree.get_widget('mp_photo_nbk')
        self.view_nbk.set_show_tabs(False)

        self.state_thumbnail = 0
        self.state_playback = 1
        self.state_share = 2
        self.state_default = 3

        self.state_current = self.state_default

        # last filename
        self.last_pic_name = None

        # if first launch
        self.is_first_launch = True

        # init autoplay view

        self.photo_playback_view = self.wTree.get_widget('wm_pm_playback_wd_vb')
        self.photo_cur_img = self.wTree.get_widget("wm_pm_cur_img")

        self.init_ui()

    def set_cur_picture(self, filename):
        if os.path.isfile(filename):
            GeneralFunc.set_image_fit(self.photo_cur_img, filename)
            self.last_pic_name = filename
        else:
            pass

    def init_ui(self):
        self.view_nbk.set_current_page(self.state_current)
        widget = self.wTree.get_widget('pm_default_view_eb')
        widget.modify_bg(gtk.STATE_NORMAL, Constant.MediaColor['select_window_bg'])
        widget = self.wTree.get_widget('pm_default_view_lb')
        widget.modify_fg(gtk.STATE_NORMAL, Constant.MediaColor['select_label_fg'])
        widget = self.wTree.get_widget('pm_playback_view_eb')
        widget.modify_bg(gtk.STATE_NORMAL, Constant.MediaColor['select_window_bg'])


    def update_ui(self, is_last_view):
        self.view_nbk.set_current_page(self.state_current)
        if is_last_view == True:
            if None != self.last_pic_name:
                self.set_cur_picture(self.last_pic_name)
        else:
            # init default ui
            pass

    def update_state_thumbnail(self):
        self.state_current = self.state_thumbnail

    def update_state_playback(self):
        self.state_current = self.state_playback

    def update_state_share(self):
        self.state_current = self.state_share

    def update_state_default(self):
        self.state_current = self.state_default

    def is_first_load(self):
        return (self.is_first_launch == True)

    def mark_default_flag(self):
        self.is_first_launch = False
        self.update_ui(True)

    def set_fs_mode(self, on):
        pass
