#!/usr/bin/env python
# vim: ai ts=4 sts=4 et sw=4

#    ToolBarView.py: Manage Toolbar View

#    Copyright (c) 2007 Intel Corporation
#
#    This program is free software; you can redistribute it and/or modify it
#    under the terms of the GNU General Public License as published by the Free
#    Software Foundation; version 2 of the License
#
#    This program is distributed in the hope that it will be useful, but
#    WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
#    or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
#    for more details.
#
#    You should have received a copy of the GNU General Public License along
#    with this program; if not, write to the Free Software Foundation, Inc., 59
#    Temple Place - Suite 330, Boston, MA 02111-1307, USA.

import Constant
import GeneralFunc
import sys, os, os.path, string
import pygtk, gobject
import gtk, gtk.gdk, gtk.glade
import string

class ToolBarView:
    """
    A class which manage toolbar view.
    """

    def __init__(self, app, mode):
        """
        init function
        """
        self.name_list = {'audio':'wm_mm_toolbar_hb', 
                          'video':'wm_vm_toolbar_hb', 
                          'photo':'wm_pm_toolbar_hb',
                          }
        dic = {}
        dic['audio'] = {"on_wm_mm_tb_browse_bn_clicked" : self.on_file_open,
                     "on_wm_mm_tb_prev_bn_clicked": self.Music_Rewind,
                     "on_wm_mm_tb_play_bn_clicked" : self.Music_Play_Pause,
                     "on_wm_mm_tb_stop_bn_clicked" : self.Music_Stop,
                     "on_wm_mm_tb_next_bn_clicked" : self.Music_Forward,
                     }
        dic['video'] = {"on_wm_vm_tb_browse_bn_clicked" : self.on_file_open,
                     "on_wm_vm_tb_prev_bn_clicked": self.Video_Rewind,
                     "on_wm_vm_tb_play_bn_clicked" : self.Video_Play_Pause,
                     "on_wm_vm_tb_stop_bn_clicked" : self.Video_Stop,
                     "on_wm_vm_tb_next_bn_clicked" : self.Video_Forward,
                     "on_wm_vm_tb_fs_bn_clicked" : self.Video_FullScreen,
                     }
        dic['photo'] = {"on_wm_pm_tb_browse_bn_clicked" : self.on_file_open,
                     "on_wm_pm_tb_autoplay_bn_clicked" : self.Photo_Play_Pause,
                 }

        # init app
        self.app = app  

        # init three toolbar suites and connect signal and functions
        # init default dir
        self.wTree = {}
        self.last_browse_dir = {}
        for name in self.name_list.keys():
            self.wTree[name] = gtk.glade.XML('MobilePlayer.glade',root = self.name_list[name])
            self.wTree[name].signal_autoconnect(dic[name])
            self.last_browse_dir[name] = self.get_default_dir(name)

        # init mode and toolbar_name    
        self.cur_mode = mode
        self.cur_toolbar_name = self.get_toolbar_name(mode)


        # pack whole toolbar to a VBox
        self.cur_view = gtk.VBox()
        self.cur_toolbar = self.wTree[self.cur_mode].get_widget(self.cur_toolbar_name)
        self.cur_view.pack_start(self.cur_toolbar)

        # buttons
        self.mm_play_pause_button = self.wTree['audio'].get_widget("wm_mm_tb_play_bn")
        self.mm_stop_button = self.wTree['audio'].get_widget("wm_mm_tb_stop_bn")
        self.mm_browse_button = self.wTree['audio'].get_widget("wm_mm_tb_browse_bn")
        self.mm_prev_button = self.wTree['audio'].get_widget("wm_mm_tb_prev_bn")
        self.mm_next_button = self.wTree['audio'].get_widget("wm_mm_tb_next_bn")

        self.vm_play_pause_button = self.wTree['video'].get_widget("wm_vm_tb_play_bn")
        self.vm_stop_button = self.wTree['video'].get_widget("wm_vm_tb_stop_bn")
        self.vm_browse_button = self.wTree['video'].get_widget("wm_vm_tb_browse_bn")
        self.vm_prev_button = self.wTree['video'].get_widget("wm_vm_tb_prev_bn")
        self.vm_next_button = self.wTree['video'].get_widget("wm_vm_tb_next_bn")
        self.vm_share_button = self.wTree['video'].get_widget("wm_vm_tb_share_bn")
        self.vm_fullscreen_button = self.wTree['video'].get_widget("wm_vm_tb_fs_bn")

        self.pm_autoplay_button = self.wTree['photo'].get_widget("wm_pm_tb_autoplay_bn")
        self.pm_share_button = self.wTree['photo'].get_widget("wm_pm_tb_share_bn")
        self.pm_fullscreen_button = self.wTree['photo'].get_widget("wm_pm_tb_fs_bn")
        self.pm_browse_button = self.wTree['photo'].get_widget("wm_pm_tb_browse_bn")
        self.pm_thumb_size_bar = self.wTree['photo'].get_widget("wm_pm_tb_thumb_size_hs")

        #images
        self.music_rewind_image = self.wTree['audio'].get_widget("mm_rewind_img")
        self.music_rewind_image.set_from_file(os.path.join(Constant.MediaImagePath,'rewind.png'))
        self.music_play_image = self.wTree['audio'].get_widget("mm_play_img")
        self.music_play_image.set_from_file(os.path.join(Constant.MediaImagePath,'play.png'))
        self.music_stop_image = self.wTree['audio'].get_widget("mm_stop_img")
        self.music_stop_image.set_from_file(os.path.join(Constant.MediaImagePath,'stop.png'))
        self.music_forward_image = self.wTree['audio'].get_widget("mm_forward_img")
        self.music_forward_image.set_from_file(os.path.join(Constant.MediaImagePath,'forward.png'))
        self.music_browse_image = self.wTree['audio'].get_widget("mm_browse_img")
        self.music_browse_image.set_from_file(os.path.join(Constant.MediaImagePath,'mb_media_browse_btn.png'))

        self.video_rewind_image = self.wTree['video'].get_widget("vm_rewind_img")
        self.video_rewind_image.set_from_file(os.path.join(Constant.MediaImagePath,'rewind.png'))
        self.video_play_image = self.wTree['video'].get_widget("vm_play_img")
        self.video_play_image.set_from_file(os.path.join(Constant.MediaImagePath,'play.png'))
        self.video_stop_image = self.wTree['video'].get_widget("vm_stop_img")
        self.video_stop_image.set_from_file(os.path.join(Constant.MediaImagePath,'stop.png'))
        self.video_forward_image = self.wTree['video'].get_widget("vm_forward_img")
        self.video_forward_image.set_from_file(os.path.join(Constant.MediaImagePath,'forward.png'))
        self.video_browse_image = self.wTree['video'].get_widget("vm_browse_img")
        self.video_browse_image.set_from_file(os.path.join(Constant.MediaImagePath,'mb_media_browse_btn.png'))
        self.video_fullscreen_image = self.wTree['video'].get_widget("vm_fullscreen_img")
        self.video_fullscreen_image.set_from_file(os.path.join(Constant.MediaImagePath,'mb_media_browse_btn.png'))
        self.video_share_image = self.wTree['video'].get_widget("vm_share_img")
        self.video_share_image.set_from_file(os.path.join(Constant.MediaImagePath,'mb_media_browse_btn.png'))

        self.photo_autoplay_image = self.wTree['photo'].get_widget("pm_autoplay_img")
        self.photo_autoplay_image.set_from_file(os.path.join(Constant.MediaImagePath,'play.png'))
        self.photo_browse_image = self.wTree['photo'].get_widget("pm_browse_img")
        self.photo_browse_image.set_from_file(os.path.join(Constant.MediaImagePath,'mb_media_browse_btn.png'))
        self.photo_fullscreen_image = self.wTree['photo'].get_widget("pm_fullscreen_img")
        self.photo_fullscreen_image.set_from_file(os.path.join(Constant.MediaImagePath,'mb_media_browse_btn.png'))
        self.photo_share_image = self.wTree['photo'].get_widget("pm_share_img")
        self.photo_share_image.set_from_file(os.path.join(Constant.MediaImagePath,'mb_media_browse_btn.png'))

        # init current button suites
        self.cur_play_pause_img = self.music_play_image

        # filter
        self.file_filter = {}
        self.all_filter = gtk.FileFilter()
        self.all_filter.set_name('All')
        for mode in Constant.MediaPattern.keys():
            self.file_filter[mode] = gtk.FileFilter()
            self.file_filter[mode].set_name(mode)
            for type in Constant.MediaPattern[mode]:
                pattern = '*.' + type
                self.file_filter[mode].add_pattern(pattern)
                self.all_filter.add_pattern(pattern)

        self.init_ui()
        self.update_button(self.cur_mode, None) 

    def hide_unused(self):

        self.vm_share_button.hide()
        self.vm_fullscreen_button.hide()

        self.pm_autoplay_button.hide()
        self.pm_share_button.hide()
        self.pm_fullscreen_button.hide()
        self.pm_thumb_size_bar.hide()

    def init_ui(self):
        pass

    def update_button(self, mode, mediatype):
        if mode == 'audio':
            self.cur_prev_bn = self.mm_prev_button
            self.cur_play_bn = self.mm_play_pause_button
            self.cur_stop_bn = self.mm_stop_button
            self.cur_next_bn = self.mm_next_button
            self.cur_play_pause_img = self.music_play_image

        elif mode == 'video':
            self.cur_prev_bn = self.vm_prev_button
            self.cur_play_bn = self.vm_play_pause_button
            self.cur_stop_bn = self.vm_stop_button
            self.cur_next_bn = self.vm_next_button
            self.cur_play_pause_img = self.video_play_image

        else:
            pass

        if mode == mediatype:
            self.set_button_sensitive(mode, True)
        else:
            self.set_button_sensitive(mode, False)

    def add_filter_mode(self, dialog, mode):
        if mode in Constant.MediaType.keys():
            dialog.add_filter(self.file_filter[mode])
        elif mode == 'All':
            dialog.add_filter(self.all_filter)

    def on_file_open(self, button):
        dialog = gtk.FileChooserDialog(action=gtk.FILE_CHOOSER_ACTION_OPEN, title=Constant.MediaString['open_dlg_title'])
        if None != self.last_browse_dir[self.cur_mode] :
            dialog.set_current_folder(self.last_browse_dir[self.cur_mode])

        # filter
        for mode in Constant.MediaType.keys():
            dialog.add_filter(self.file_filter[mode])
        dialog.add_filter(self.all_filter)
        # set default filter
        dialog.set_filter(self.all_filter)

        dialog.add_button(gtk.STOCK_OK, gtk.RESPONSE_OK)
        dialog.add_button(gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL)

        if dialog.run() == gtk.RESPONSE_OK:

            filename = dialog.get_filename()
            if os.path.isfile(filename) == False:
                GeneralFunc.error_msg('no such file exist!')
                dialog.destroy()
                return

            if None != GeneralFunc.get_media_type(filename):
                self.last_browse_dir[self.cur_mode] = dialog.get_current_folder()
                self.open_media_file(filename)

        dialog.destroy()

    def open_media_file(self, filename):
        self.cur_mode = GeneralFunc.get_media_type(filename)
        # media_type
        if None != self.app.get_mediatype():
            if self.cur_mode != 'photo':
                #self.app.Stop(None)
                pass
            else:
                #stop current service
                pass

        if self.cur_mode != 'photo':
            self.app.set_mediatype(self.cur_mode)

        if self.cur_mode == 'audio':
            self.app.view['audio'].update_state_playback()
            self.app.setMusicMode(None)
            loadfile = 'file://' + filename
            self.app.Load(self.app.get_mediatype(), loadfile)

        elif self.cur_mode == 'video':
            self.app.view['video'].update_state_playback()
            self.app.setVideoMode(None)
            loadfile = 'file://' + filename
            self.app.Load(self.app.get_mediatype(), loadfile)

        elif self.cur_mode == 'photo':
            self.app.view['photo'].update_state_playback()
            self.app.setPhotoMode(None)
            self.app.view['photo'].set_cur_picture(filename)

        # update app ui
        self.app.update_all_ui()

    def get_default_dir(self, mode):
        if mode in Constant.MediaType.keys():
            return os.path.join(Constant.MediaStreamPath, mode)
        else:
            pass

    def get_toolbar_name(self, mode):
        if mode in Constant.MediaType.keys():
            return self.name_list[mode]
        else:
            pass

    def change_mode(self, mode, mediatype):
        self.cur_mode, self.cur_toolbar_name = mode, self.get_toolbar_name(mode)
        self.cur_view.remove(self.cur_toolbar)
        self.cur_toolbar = self.wTree[self.cur_mode].get_widget(self.cur_toolbar_name)
        self.cur_view.pack_start(self.cur_toolbar)
        self.update_button(mode, mediatype)
        self.hide_unused()

    def set_stop_button_state(self, state):
        self.cur_stop_bn.set_sensitive(state)

    def set_play_pause_img(self, image):
        if os.path.isfile(image):
            self.cur_play_pause_img.set_from_file(image)

    def set_button_sensitive(self, mode, is_enabled):
        if is_enabled in [True, False]:
            if mode == 'audio':
                self.mm_prev_button.set_sensitive(is_enabled)
                self.mm_play_pause_button.set_sensitive(is_enabled)
                self.mm_stop_button.set_sensitive(is_enabled)
                self.mm_next_button.set_sensitive(is_enabled)
                self.app.view['audio'].playback_set_seekbar_seekable(is_enabled)
            elif mode == 'video':
                self.vm_prev_button.set_sensitive(is_enabled)
                self.vm_play_pause_button.set_sensitive(is_enabled)
                self.vm_stop_button.set_sensitive(is_enabled)
                self.vm_next_button.set_sensitive(is_enabled)
                self.app.view['video'].playback_set_seekbar_seekable(is_enabled)
            elif mode == 'photo':
                pass
                # self.pm_autoplay_button.set_sensitive(is_enabled)

    def Music_Rewind(self, bn):
        if self.app.get_mediatype() == 'audio':
            self.app.Rewind(bn)

    def Music_Play_Pause(self, bn):
        if self.app.get_mediatype() == 'audio':
            self.app.Play_Pause(bn)

    def Music_Stop(self, bn):
        if self.app.get_mediatype() == 'audio':
            self.app.Stop(bn) 

    def Music_Forward(self, bn):
        if self.app.get_mediatype() == 'audio':
            self.app.Forward(bn)

    def Video_Rewind(self, bn):
        if self.app.get_mediatype() == 'video':
            self.app.Rewind(bn)

    def Video_Play_Pause(self, bn):
        if self.app.get_mediatype() == 'video':
            self.app.Play_Pause(bn)

    def Video_Stop(self, bn):
        if self.app.get_mediatype() == 'video':
            self.app.Stop(bn)  

    def Video_Forward(self, bn):
        if self.app.get_mediatype() == 'video':
            self.app.Forward(bn)

    def Video_FullScreen(self, bn):
        pass

    def Photo_Play_Pause(self, bn):
        pass

    def set_fs_mode(self, on):
        pass

