#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <moblin-settings-daemon/moblin-settings-client.h>
#include <gtk/gtk.h>
#include <glib/gi18n.h>

#include "activate-settings-daemon.h"

static void popup_error_message (char *msg)
{
  GtkWidget *dialog;
  char buf[1000];

  sprintf(buf, 
	"Unable to start the settings manager 'moblin-settings-daemon'.\n%s",
	msg);
  dialog = gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_WARNING,
				   GTK_BUTTONS_OK, buf);

  gtk_dialog_run (GTK_DIALOG (dialog));
  gtk_widget_destroy (dialog);
}

/* Returns FALSE if activation failed, else TRUE */
gboolean 
activate_settings_daemon (void)
{
  DBusGConnection *connection = NULL;
  DBusGProxy *proxy = NULL;
  GError *error = NULL;

  connection = dbus_g_bus_get (DBUS_BUS_SESSION, &error);
  if (connection == NULL)
    {
      popup_error_message ("Failed to establish DBUS session");
      g_error_free (error);
      return FALSE;
    }
    
  proxy = dbus_g_proxy_new_for_name (connection,
                                     "org.moblin.SettingsDaemon",
                                     "/org/moblin/SettingsDaemon",
                                     "org.moblin.SettingsDaemon");

  if (proxy == NULL)
    {
      popup_error_message ("Failed to establish DBUS connection [org.moblin.SettingsDaemon]");
      return FALSE;
    }

  if (!org_moblin_SettingsDaemon_awake(proxy, &error))
    {
      popup_error_message ("Failed to awaken daemon [moblin-settings-daemon]");
      g_error_free (error);
      return FALSE;
    }

  return TRUE;
}
