/* -*- mode: c; style: linux -*- */

/* keyboard-properties.c
 * Copyright (C) 2000-2001 Ximian, Inc.
 * Copyright (C) 2001 Jonathan Blandford
 *
 * Written by: Bradford Hovinen <hovinen@ximian.com>
 *             Rachel Hestilow <hestilow@ximian.com>
 *	       Jonathan Blandford <jrb@redhat.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <gconf/gconf-client.h>
#include <glade/glade.h>
#include <stdarg.h>

#include "capplet-util.h"
#include "keyboard-properties-xkbsk.h"

static void
dialog_response (GtkWidget *widget,
		 gint       response_id,
		 GConfClient *client)
{
	switch (response_id) {
	case GTK_RESPONSE_CLOSE:
	case GTK_RESPONSE_CANCEL:
	case GTK_RESPONSE_DELETE_EVENT:
		gtk_widget_destroy(widget);
		gtk_main_quit();
		break;
	}
}

int main(int argc, char *argv[], char *env[])
{
	GConfClient *client = NULL;
	GladeXML *dialog = NULL;

	gtk_init(&argc, &argv);
	gconf_init (argc, argv, NULL);

	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);

	client = gconf_client_get_default ();
	dialog = glade_xml_new (MA_GLADE_DIR "/keyboard-properties.glade", 
	    "keyboard_dialog", NULL);
	g_signal_connect (G_OBJECT (WID ("keyboard_dialog")), "response", 
	    (GCallback) dialog_response, client);
	setup_xkbsk_tabs (dialog, client);
	gtk_widget_show (WID ("keyboard_dialog"));

	gtk_main();
	return 0;
}
