#!/usr/bin/env python
# vim: ai ts=4 sts=4 et sw=4
# engmanag.py

#    Copyright (c) 2007 Intel Corporation
#
#    This program is free software; you can redistribute it and/or modify it
#    under the terms of the GNU General Public License as published by the Free
#    Software Foundation; version 2 of the License
#
#    This program is distributed in the hope that it will be useful, but
#    WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
#    or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
#    for more details.
#
#    You should have received a copy of the GNU General Public License along
#    with this program; if not, write to the Free Software Foundation, Inc., 59
#    Temple Place - Suite 330, Boston, MA 02111-1307, USA.
import re
import string
import os
import dbus, dbus.glib
import ConfigParser
import MoblinMedia
import Constant
"""
    class Engine
 only some get and set methods for class Engine 
 the most import method is 'GetRawEngCaps'
 Raw means a lot of MIME types ,we should check from these Raw types to test if file format(such as mp3) to be play is  supported
"""
class Engine:
    def __init__(self,confFile):
    #the MIME type list is the raw list ,and should be given by every engine  
        self.RawCapsList = list()
        self.ExactCapsList = list()
        self.bus = dbus.SessionBus()
        if self.ParserConfig(confFile):
            print 'Parser config succeed'
            self.RawCapsList = self.GetRawEngCaps(self.name)
        else :
            print 'enabled != yes or give error DBus name path'
            
  
    def ParserConfig(self,confFile):            
        cf = ConfigParser.ConfigParser()
        cf.read(confFile)
        self.enabled = cf.get('Engine','enabled')
        print 'enabled = ',self.enabled
        self.name = cf.get('Engine','name')
        self.DBusName = cf.get('Engine','DBusName')
        self.DBusPath = cf.get('Engine','DBusPath')
        try:
	    self.service = self.bus.get_object(self.DBusName,self.DBusPath)
        except:
            print 'get_object error'
            return False
        return True
	

    def IsEnableAndSupported(self):
        if self.enabled.lower()=='yes':
            if self.bus.name_has_owner(self.DBusName):
                    return True
            return False
    
    def GetDBusName(self):
        return self.DBusName

    def GetDBusPath(self):
        return self.DBusPath    
        
    def SetName(self,name):
        self.name = name

    def SetCapsList(self,CapsList):
        self.CapsList = CapsList

    def SetCapsService(self,service):
        self.service = service

    def AddPreCaps(self,FormatList):
        for i in FormatList :
            if i not in self.ExactCapsList:
                self.ExactCapsList.append(i)

    def AddCaps(self,Format):
        if Format not in self.ExactCapsList:
            self.ExactCapsList.append(Format)

    def GetExactCapsList(self):
        return self.ExactCapsList

    def GetName(self):
        return self.name

    def GetRawCapsList(self):
        return self.RawCapsList

    def SetRawCapsList(self,NewRawCapsList):
        self.RawCapsList = NewRawCapsList

    def GetService(self):
        return self.service

    def GetRawEngCaps(self,name):
        RawCapsStr = self.service.GetPluginCaps()
        CapsList = re.findall('[a-zA-Z0-9\-]+/[a-zA-Z0-9\-]+',RawCapsStr)
        FinalCapsList = list()
        for i in CapsList:
            if i not in FinalCapsList:
                FinalCapsList.append(i) 
        if FinalCapsList :
            return  FinalCapsList
        return 0
        
"""
     Class EngManag
currently the most important interface to outside world is the 'ChooseEng' method
next step ,to my point ,is to.....
""" 

class EngManag:
    def __init__(self):
        self.BusyEng=''
        self.EngList=list()
        self.GstPreCaps=['au','ogg','bmp','wav','jpeg','png']
        self.HelixPreCaps=[]
        self.EngNumber=0
        self.table=dict()
        self.SupportedList=['gst','helix']
        self.PopularGstFormat=["mp3","aac","wma","avi","wmv","3gp","mpg","asf"]
        self.PopularHelixFormat=["wav","mp3","aac","ogg","rmvb","rm"]
        for ConfigFile in os.listdir(Constant.MediaConfigsDir):
            tmp=Engine(os.path.join(Constant.MediaConfigsDir,ConfigFile))
            if tmp.IsEnableAndSupported():
                self.NewEng(tmp)
            else :
                print 'not correct engine created,not accepted by EngManag'
        for eng in self.EngList:
            self.SearchTable(eng.GetName())
            self.AddPreCaps(eng.GetName())
            print '------------init ',eng.GetName(),' end,it has caps of below-------'
            print eng.GetExactCapsList()
    def __del__(self):
        pass

    def EngError(self,n):
        pass
    
    def GetEngList(self):
        return self.EngList

    def ReloadEngCaps(self):
        #interface for user to reload engine's capability
         for eng in self.EngList:
            NewRawCapsList = eng.GetRawEngCaps(eng.GetName())
            eng.SetRawCapsList(NewRawCapsList)
            self.SearchTable(eng.GetName())
            self.AddPreCaps(eng.GetName())
            print eng.GetExactCapsList()
    def NewEng(self,engine):
        self.EngNumber+=1
        self.EngList.append(engine)
        
    def DelEng(self, name):
        if (self.IsValidEngName(name)):
            for i in self.EngList:
                if i.GetName()==name:
                    del i   
            EngManag.number -=1
        else:
            self.EngError('2')

    def IsValidEngName(self,name):
        if name in self.SupportedList:
            return 1
        return 0

    def FindEngServiceByName(self,name):
    #To use the Find* functions,you should check the return value before to use it(return value).   
        if self.IsValidEngName(name):
            for eng in self.EngList:
                if eng.GetName()==name:
                    return eng.GetService()
        self.EngError('2')
        return 0

    def FindRawCapsByName(self,name):
        if self.IsValidEngName(name):
            for eng in self.EngList:
                if eng.GetName()==name:
                    return eng.GetRawCapsList()
        self.EngError('2')
        return 0

    def FindEngByService(self,service):
        for eng in self.EngList:
                if eng.GetService()== service:
                    return eng  
        return 0      
    def FindEngByName(self,name):
        if self.IsValidEngName(name):
            for eng in self.EngList:
                if eng.GetName()==name:
                    return eng
        self.EngError('2')
        return 0

    def GetEngNum(self):
        print "There are %d media engines\n" % self.EngNumber
        return self.EngNumber

    def SelectPopFmt(self,name):
        if self.IsValidEngName(name):
            
            if name in ['gst','Gst']:
                return self.PopularGstFormat
            if name in ['helix','Helix']:
                return self.PopularHelixFormat
        else:   
            slef.EngError('2')



    def IsPartOf(self,MimeList,name):
    ##//there only one way to decide which MIME to which format
    ##@ lookup a predefine table,this can be done well by the dict stucture provided by python(table for each)
        if self.IsValidEngName(name):
            CapsList=self.FindRawCapsByName(name)
            if CapsList :
                for i in CapsList:
                    for j in MimeList:
                        if string.find(j,'&')+1: #there are two MIMEs to support a given format
                            
                            tmp=re.findall('[a-zA-Z]+/[a-zA-Z0-9\-\.]+',j)
                            orgi=len(tmp)
                            for k in tmp :
                                for m in CapsList:
                                    if string.find(m,k)+1:
                                        orgi=orgi-1;
                                if orgi==0:
                                    return 1
                            else:
                                return 0
                        elif (string.find(i,j)+1)==0:
                                pass
                        else:
                            return 1
                
                    
            else:
                self.EngError('3')
        else :
            self.EngError('1')
        return 0

    def SearchTable(self,name):
        if self.IsValidEngName(name):
            listmp3=['audio/mp3','audio/x-private1-ac3']
            listaac=['audio/x-dts']
            listwma=['audio/x-private1-ac3']
            listavi=['audio/x-private1-ac3']
            listwmv=['ms-wmv','x-wmv&audio/x-private1-ac3']
            list3gp=['video/x-raw-gray','x-3gp']
            listmpg=['video/x-h264','audio/x-mpeg','audio/x-mpg']
            listasf=['x-ms-asf','audio/x-private1-ac3']
            listjpg=['image/jpeg']
            listgif=['image/gif']
            listpng=['image/png']
            listbmp=['image/bmp','image/x-MS-bmp','x-bmp']
            listwbmp=['wbmp']
            listrm=['video/x-pn-realvideo-encrypted']
            listrmvb=['video/x-pn-realvideo-encrypted']
            listwav=['audio/x-pn-wav','audio/x-pn-windows-acm']
            listogg=['ogg']
            listmp4=['video/mp4','video/x-raw-gray']
            self.table={'mp3':listmp3,'aac':listaac,'wma':listwma,'avi':listavi,'wmv':listwmv,'3gp':list3gp,\
'mpg':listmpg,'asf':listasf,'jpg':listjpg,'gif':listgif,'png':listpng,'bmp':listbmp,'wbmp':listwbmp,\
'rm':listrm,'rmvb':listrmvb,'wav':listwav,'ogg':listogg,'mp4':listmp4}
            CurrentEng=self.FindEngByName(name)
            CurrentEng.ExactCapsList=list()
            for i in self.table.keys():
                MimeList=self.table[i]
                if self.IsPartOf(MimeList,name):
                    
                    if i not in CurrentEng.GetExactCapsList():
                        CurrentEng.GetExactCapsList().append(i)
                        
                else :
                    pass 
        
        else:
            Error('2')
            return 0

    def AddPreCaps(self,name):
        CurrentEng=self.FindEngByName(name)
        if name in ['gst','Gst']:
            CurrentEng.AddPreCaps(self.GstPreCaps)
        if name in ['helix','Helix']:
            CurrentEng.AddPreCaps(self.HelixPreCaps)
    
    def GetEngCaps(self,name): 
    # there should be a universal way to decide which format supported by the which MIME type
        if self.IsValidEngName(name):
            CurrentEng=self.FindEngByName(name)
            PopularFormat=self.SelectPopFmt(name)
            self.SearchTable(name)
            pass #'pass ' is for another tatic such as check by manual
            self.AddPreCaps(name)
            return CurrentEng.GetExactCapsList()
        else:
            self.EngError('2')
            return 0

    def Assert(self,i):
        if i:
            return 1
        else:
            return 0

    def GetEngStatus(self, name):
        if name == "gst":
            print "call service to get gstreamer engine status.\n"
        elif name == "helix":
            print "call service to get helix engine status.\n"
        else:
            print "Sorry, we don't support such engine.\n"

    def SetEngStatus(self, name):
        if name == "gst":
            print "call service to set gstreamer engine status.\n"
        elif name == "helix":
            print "call service to set helix engine status.\n"
        else:
            print "Sorry, we don't support such engine.\n"

    def ShowAllRawEngCaps(self):
        for i in self.EngList:
            print "Engine ",'"',i.GetName() ,'"',"RawCaps list :"
            print len(i.GetRawCapsList())
            for j in i.GetRawCapsList():
                print j
   
    def ShowEngCaps(self):
        for eng in self.EngList:
            print "----------------*** FYI ***--------------"
            print 'engine','"',eng.GetName(),'"',"can playback formats like these...."
            for j in eng.GetExactCapsList():
                print j
           
    def ChooseEng(self, currentMIME):

        #self.ReloadEngCaps()
        #self.ShowAllRawEngCaps()
        self.ShowEngCaps()
        for eng in self.EngList:
                CurrentCaps = eng.GetExactCapsList()    
                if self.Assert(CurrentCaps) and currentMIME in CurrentCaps:
                    print 'Engine',eng.GetName(),"is selected for current playback,enjoy..."              
                    return eng    
        self.EngError('4')
        return 'noneng'

