#!/usr/bin/env python
# vim: ai ts=4 sts=4 et sw=4
#    FileIO.py: music management class
# 
#    Copyright (c) 2007 Intel Corporation
#
#    This program is free software; you can redistribute it and/or modify it
#    under the terms of the GNU General Public License as published by the Free
#    Software Foundation; version 2 of the License
#
#    This program is distributed in the hope that it will be useful, but
#    WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
#    or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
#    for more details.
#
#    You should have received a copy of the GNU General Public License along
#    with this program; if not, write to the Free Software Foundation, Inc., 59
#    Temple Place - Suite 330, Boston, MA 02111-1307, USA.

import os.path
import string
from xml.dom import minidom
import gnomevfs
import PlayList

supportedExt=['.m3u','.pls','.xml']

def readXML(xmlName, targetName, attrList):
    if os.path.isfile(xmlName)== False:
        print "Not a real XML file!\n"
        return
    else:
        songList=[]
        file1= file(xmlName, "r")
        domfile = minidom.parse(file1)
        for element in domfile.getElementsByTagName(targetName):
            print 'element:', element
            for attr in attrList:
                print 'attr:', attr
                if element.hasAttribute(attr) == False:
                    print 'this list does not has a ', attr, 'attribute\n'
                    return
            
                content=string.strip(element.getAttribute(attr))
                songList.append(str(content))
                print 'songList:', songList
        file1.close()
        return  songList
    
def writeXML(xmlName, targetName,itemName, inputList):
    xmlFile=file(xmlName, "w")
    strings ='''<?xml version="1.0" encoding="UTF-8" ?>\n'''
    xmlFile.write(strings)
    
    strings = "<items>\n"
    xmlFile.write(strings)
    
    strings = ""
    for item in inputList:
        strings += "    <" + targetName + " " + itemName + "=" + "\"" + item + "\"" + ">\n"
        strings += "    </" + targetName + ">\n" 
    xmlFile.write(strings)
    
    strings = "</items>"
    xmlFile.write(strings)
    
    xmlFile.close()
    return
    
""" Return uri in a m3u playlist """
def getUrisFromM3u(uri):
    uris = [] 
    print "uri:", uri
    content = gnomevfs.read_entire_file(uri)
    lines = content.splitlines()
    for line in lines:
        if not line.startswith("#") and line.strip()!="":
            uris.append(line.strip())
    uris = [plsRebuildUri(uri,u) for u in uris]
    return uris
    
""" Return uri in a pls playlist """
def getUrisFromPls(uri):
    uris = []
    content = gnomevfs.read_entire_file(uri)
    lines = content.splitlines()
    for line in lines:
        if line.lower().startswith("file") and line.find("=")!=-1:
           uris.append(line[line.find("=")+1:].strip())
    uris = [plsRebuildUri(uri,u) for u in uris]
    return uris

def plsRebuildUri(base_uri,uri):
    base_uri = base_uri[:base_uri.rfind("/")]
    if uri.find("://")!=-1:
        return uri
    elif  uri[0] == "/":
        return gnomevfs.escape_path_string(uri)
    else:
        return base_uri+"/"+gnomevfs.escape_path_string(uri)

def savePlaylist(list_song, filename, ext=".m3u"):
    if ext==".m3u":
	print "savePlaylist:",filename, list_song
        fileout = file(filename, "w")
        fileout.write("\n".join([song for song in list_song]))
        fileout.close()
    elif ext==".pls":
        fileout = file(filename, "w")
        [ fileout.write("file%d=%s\n"%(i,song))  for i,song in enumerate(list_song)  if song != None  ]
        fileout.close()
    elif ext=='.xml':
        targetName = 'song'
        itemName = 'path'
        writeXML(filename, targetName,itemName, list_song)
    else:
        print "Unknow playlist type"
   
def getUrisFromFile(uri, ext='.m3u'):
    if os.path.isfile(uri):
        if ext not in supportedExt:
            return []
        elif ext == '.m3u':
            return getUrisFromM3u(uri)
        elif ext == '.pls':
            return getUrisFromPls(uri)
        elif ext == '.xml':
            targetName = 'song'
            attrList =['path']
            return readXML(uri, targetName, attrList)
        else:
            return []
    else:
        print 'no such list file!'

#if __name__== "__main__":
    #songList1 = ['/home/cathy/s1.mp3','/home/cathy/s2.mp3','/home/cathy/s3.mp3']
    #print 'test write to m3u, pls, xml:..............'
    #savePlaylist(songList1, '/home/cathy/musicManagement/test.m3u')
    #savePlaylist(songList1, '/home/cathy/musicManagement/test.pls',ext ='.pls')
    #savePlaylist(songList1, '/home/cathy/musicManagement/test.xml',ext ='.xml')

    #m3uList=[]
    #plsList=[]
    #xmlList=[]
    #print 'test read from m3u, pls, xml:..............'
    #m3uList=getUrisFromFile('/home/cathy/musicManagement/test.m3u')
    #print 'm3uList:.............\n', m3uList
    #plsList=getUrisFromFile('/home/cathy/musicManagement/test.pls', ext='.pls')
    #print 'plsList:.............\n', plsList
    #xmlList=getUrisFromFile('/home/cathy/musicManagement/test.xml', ext='.xml')
    #print 'xmlList:.............\n', xmlList

    

