#!/usr/bin/env python
# vim: ai ts=4 sts=4 et sw=4

#    MobilePlugins.py: Manage Plugins

#    Copyright (c) 2007 Intel Corporation
#
#    This program is free software; you can redistribute it and/or modify it
#    under the terms of the GNU General Public License as published by the Free
#    Software Foundation; version 2 of the License
#
#    This program is distributed in the hope that it will be useful, but
#    WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
#    or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
#    for more details.
#
#    You should have received a copy of the GNU General Public License along
#    with this program; if not, write to the Free Software Foundation, Inc., 59
#    Temple Place - Suite 330, Boston, MA 02111-1307, USA.

import math

STROKE_MAX_POINTS = 10000
STROKE_MIN_POINTS = 50
STROKE_MAX_SEQUENCE = 20
STROKE_SCALE_RATIO = 4
STROKE_BIN_COUNT_PERCENT = 0.07

class pyStroke(object):
    pointList = []
    min_x = 10000;
    min_y = 10000;
    max_x = -1;
    max_y = -1;
    point_count = 0;
    def StrokeTrans (self):
        sequence = ''
        sequence_count = 0
        prev_bin = 0
        current_bin = 0
        bin_count = 0
        first_bin = True
        delta_x = self.max_x - self.min_x
        delta_y = self.max_y - self.min_y
        bound_x_1 = self.min_x + (delta_x / 3)
        bound_x_2 = self.min_x + 2 * (delta_x / 3)
        bound_y_1 = self.min_y + (delta_y / 3)
        bound_y_2 = self.min_y + 2 * (delta_y / 3)
        if delta_x > STROKE_SCALE_RATIO * delta_y:
            bound_y_1 = (self.max_y + self.min_y - delta_x) / 2 + (delta_x / 3)
            bound_y_2 = (self.max_y + self.min_y - delta_x) / 2 + 2 * (delta_x / 3)
        elif delta_y > STROKE_SCALE_RATIO * delta_x:
            bound_x_1 = (self.max_x + self.min_x - delta_y) / 2 + (delta_y / 3)
            bound_x_2 = (self.max_x + self.min_x - delta_y) / 2 + 2 * (delta_y / 3)         
        for point in self.pointList:
            current_bin = self.stroke_bin(point, bound_x_1, bound_x_2, bound_y_1, bound_y_2)
            if prev_bin == 0:
                prev_bin = current_bin
            if prev_bin == current_bin:
                bin_count += 1
            else:
                if bin_count > (self.point_count * STROKE_BIN_COUNT_PERCENT) or first_bin == True:
                    first_bin = False
                    sequence += `prev_bin`
                bin_count=0
                prev_bin = current_bin
        self.pointList = []  
        sequence += `current_bin`
        if (self.point_count < STROKE_MIN_POINTS) or (sequence_count > STROKE_MAX_SEQUENCE):
            self.point_count = 0
            sequence = "0"
            return sequence
        return sequence
        
    def stroke_bin (self, point, bound_x_1, bound_x_2, bound_y_1, bound_y_2):
        bin_num = 1
        x,y = point
        if x > bound_x_1: bin_num += 1
        if x > bound_x_2: bin_num += 1
        if y > bound_y_1: bin_num += 3
        if y > bound_y_2: bin_num += 3
        return bin_num

    def StrokeRecord (self, x, y):
        if self.point_count < STROKE_MAX_POINTS:
            if self.pointList == []:
                self.min_x = 10000
                self.min_y = 10000
                self.max_x = -1
                self.max_y = -1
                self.point_count = 0
            else:
                lastx, lasty = self.pointList[-1]
                delx = x - lastx
                dely = y - lasty
                if math.fabs(delx) > math.fabs(dely):
                    iy = lasty
                    if delx > 0:
                        step = 1
                    else:
                        step = -1
                    for ix in range(lastx,x,step):
                        iy += math.fabs(dely / delx) * step
                        self.pointList.append((ix,iy))
                        if math.floor(ix) < self.min_x: self.min_x = math.floor(ix)
                        if math.floor(ix) > self.max_x: self.max_x = math.floor(ix)
                        if math.floor(iy) < self.min_y: self.min_y = math.floor(iy)
                        if math.floor(iy) > self.max_y: self.max_y = math.floor(iy)
                        self.point_count+=1
                else:
                    ix = lastx
                    if dely > 0:
                        step = 1
                    else:
                        step = -1
                    for iy in range (lasty,y,step):
                        ix += math.fabs(delx / dely) * step
                        self.pointList.append((ix,iy))
                        if math.floor(ix) < self.min_x: self.min_x = math.floor(ix)
                        if math.floor(ix) > self.max_x: self.max_x = math.floor(ix)
                        if math.floor(iy) < self.min_y: self.min_y = math.floor(iy)
                        if math.floor(iy) > self.max_y: self.max_y = math.floor(iy)
                        self.point_count+=1
            self.pointList.append((x,y))

