#!/usr/bin/env python
# vim: ai ts=4 sts=4 et sw=4

#    PhotoPlayback.py: Playback photo

#    Copyright (c) 2007 Intel Corporation
#
#    This program is free software; you can redistribute it and/or modify it
#    under the terms of the GNU General Public License as published by the Free
#    Software Foundation; version 2 of the License
#
#    This program is distributed in the hope that it will be useful, but
#    WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
#    or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
#    for more details.
#
#    You should have received a copy of the GNU General Public License along
#    with this program; if not, write to the Free Software Foundation, Inc., 59
#    Temple Place - Suite 330, Boston, MA 02111-1307, USA.

import os
from PIL import Image
import gtk
import sys
import pygtk
pygtk.require("2.0")
import time
import StringIO
import gc
import threading
import Constant

import Gesture

class AutoPlay(threading.Thread):
    def __init__(self,playback):
        self.interval = 1
        self.playback = playback
        self.autoplay_index = self.playback.app.view['photo'].CurIndex
        threading.Thread.__init__(self)
    
    def set_interval(self, interval=2):
        self.interval = interval
        
    def start(self):
        self.playback.ThreadLock=True
        threading.Thread.start(self)
        
    def stop(self):
        self.playback.ThreadLock=False
        
    def run(self):
        while True :
            self.playback.next()
            time.sleep(self.interval)
            if self.playback.app.view['photo'].CurIndex == self.autoplay_index:
                break   
            if not self.playback.ThreadLock :
                break
        self.playback.stopAutoplay()
        
class PhotoPlayback:
    def __init__(self,wTree,app):
        self.app = app
        self.wTree = wTree
        self.RotatedLock=False 
        self.ThreadLock=False
        self.bTrackMouse = False
        self.ResizeLock = False
        self.ResizeIncreaseBy = 0
        self.mouseStroke = Gesture.pyStroke()
        self.mouseTrackStr = ''
        self.PlaybackImage = self.wTree.get_widget("wm_pm_cur_img")
        self.ScrolledWindow = self.wTree.get_widget("pm_scroll_viewport")
        self.ScrolledWindow.set_policy(gtk.POLICY_NEVER,gtk.POLICY_ALWAYS)
        self.PlaybackEventbox = self.wTree.get_widget("pm_playback_eb")
        dic = {
            "on_pm_playback_eb_button_press_event" : self.button_press_event,
            "on_pm_cur_img_eb_motion_notify_event" : self.on_pm_cur_img_eb_motion_notify_event,
            "on_pm_cur_img_eb_button_release_event": self.on_pm_cur_img_eb_button_release_event,
            }
        self.wTree.signal_autoconnect(dic)       

    def on_pm_cur_img_eb_motion_notify_event(self, widget, event):
        if event.type == gtk.gdk.MOTION_NOTIFY:
            if self.bTrackMouse == True:
                x,y = event.x, event.y
                self.mouseStroke.StrokeRecord(x,y)

    def on_pm_cur_img_eb_button_release_event(self, widget, event):
        if event.button == 1:
            self.bTrackMouse = False
            self.mouseTrackStr = self.mouseStroke.StrokeTrans()
            if self.mouseTrackStr == '456':
                self.next()
            elif self.mouseTrackStr == '654':
                self.pre()
            elif self.mouseTrackStr == '852':
                self.resize('i')
            elif self.mouseTrackStr =='258':
                self.resize('o')
            else:
                pass

    def ConnectEvent(self):
        self.PlaybackEventbox.connect('button_press_event',)
        self.PlaybackEventbox.connect('key_press_event',self.key_press_event)
        
    def GetThumbnailView(self):
        return self.app.view['photo'].ThumbnailView
    
    def GetCurrentDir(self):
        return self.app.view['photo'].CurrentDir
    
    def key_press_event(self,widget,event):
        keyval=gtk.gdk.keyval_name(event.keyval)
        if keyval not in ['r','R']:
            self.RotatedLock=False
        if  keyval in ['n', 'N','g','G']:
            self.next()
            print 'next'
        elif keyval in ['p','P']:
            self.pre()
            print 'previous'
        elif keyval in ['r','R']:
            self.rotate()
            print 'rotate'
        elif keyval in ['a','A']:
            self.autoplay()
            print 'autoplay'
        elif keyval in['s','S']:
            self.stopAutoplay()
            print 'stop auto paly'
        elif keyval in ['Escape']:
            if self.app.get_fs_mode() == True:
                self.app.set_fs_mode(False)
        elif keyval in ['i','I','o','O']:
            self.resize(keyval)
        elif keyval in ['d','D','Delete']:
            self.remove()
        else:
            pass
    
    def button_press_event(self,widget,event):
        if event.type == gtk.gdk.BUTTON_PRESS:
            self.bTrackMouse = True
            pass
        if event.button == 1:
            if event.type == gtk.gdk._2BUTTON_PRESS:               
                if self.app.get_fs_mode() == True:
                    self.ScrolledWindow.set_policy(gtk.POLICY_NEVER,gtk.POLICY_NEVER)
                    self.app.set_fs_mode(False)                
                else:
                    self.ScrolledWindow.set_policy(gtk.POLICY_AUTOMATIC,gtk.POLICY_ALWAYS)
                    self.app.set_fs_mode(True)
            if event.type == gtk.gdk._3BUTTON_PRESS:
                pass
        
    def GetImgType(self,filename):
        
        root,ext = os.path.splitext(filename)
        img_type = ext.replace('.','').lower()
        if img_type == 'jpg':
            return 'jpeg'        
        return img_type
    
    def DisplayImage(self,filename):
        image_file = os.path.join(self.app.view['photo'].CurrentDir,filename)
        self.app.view['photo'].set_cur_picture(image_file)
        if self.app.view['toolbar'].plugins.get_plugin_count() == 0:
            # no plugins
            return
        else:
            buttons = self.app.view['toolbar'].get_plugin_buttons()
            args = []
            args.append(image_file)
            for bn in buttons['photo']:
                bn.update_args(args)
         
    def getThumbnailView(self):
        return self.app.view['photo'].ThumbnailView

    def next(self):
        self.ScrolledWindow.set_policy(gtk.POLICY_NEVER,gtk.POLICY_NEVER)
        self.ResizeIncreaseBy=0
        self.ResizeLock = False
        model = self.GetThumbnailView().model
        curdir = self.GetCurrentDir()
        self.RotatedLock = False
        if self.app.view['photo'].CurIndex >= len(model)-1:
            self.app.view['photo'].CurIndex = 0
        else:
            self.app.view['photo'].CurIndex += 1
        while True:
            imgfile = model[self.app.view['photo'].CurIndex][0].replace('\n','')
            print 'current imgfile is : ',imgfile
            nextImg = os.path.join(curdir,imgfile)
            if not model[self.app.view['photo'].CurIndex][2] == 0:
                if self.app.view['photo'].CurIndex >= len(model)-1:
                    self.app.view['photo'].CurIndex = 0
                else:
                    self.app.view['photo'].CurIndex += 1
            else:
                self.DisplayImage(nextImg)
                break
     
    def pre(self):
        self.ScrolledWindow.set_policy(gtk.POLICY_NEVER,gtk.POLICY_NEVER)
        self.ResizeIncreaseBy=0
        self.ResizeLock = False
        model=self.GetThumbnailView().model
        curdir = self.GetCurrentDir()
        self.RotatedLock = False
        if self.app.view['photo'].CurIndex <= 0:
            self.app.view['photo'].CurIndex = len(model) - 1
        else:
            self.app.view['photo'].CurIndex -= 1
        while True:
            imgfile = model[self.app.view['photo'].CurIndex][0].replace('\n','')
            PreImg = os.path.join(curdir,imgfile)
            if not model[self.app.view['photo'].CurIndex][2] == 0:
                if self.app.view['photo'].CurIndex <= 0:
                    self.app.view['photo'].CurIndex = len(model)-1
                else:
                    self.app.view['photo'].CurIndex -= 1
            else:
                self.DisplayImage(PreImg)
                break
   
    def autoplay(self):
        self.RotatedLock = False
        if not self.ThreadLock:
            self.newThread = AutoPlay(self)
            self.newThread.start()
            self.app.view['toolbar'].set_photo_autoplay_image_change()
            
            
    def stopAutoplay(self):
        self.RotatedLock = False
        if self.ThreadLock:
            self.newThread.stop()  
            self.app.view['toolbar'].set_photo_autoplay_image_default()         
            
    def is_autoplay(self):
        return self.ThreadLock
    
    def rotate(self):
        pass
    
    def delete(self):
        model = self.GetThumbnailView().model
        curdir = self.GetCurrentDir()
        imgfile = model[self.app.view['photo'].CurIndex][0].replace('\n','')
        current_img = os.path.join(curdir,imgfile)
        pass
    
    def goThumbnail(self):
        self.stopAutoplay()
        self.app.view['photo'].update_state_thumbnail()
        pass

    def resize(self,keyval):
        if not self.ResizeLock: 
            model = self.GetThumbnailView().model
            curdir = self.GetCurrentDir()
            self.imgfile = model[self.app.view['photo'].CurIndex][0].replace('\n','')
            self.current_img=os.path.join(curdir,self.imgfile)        
        if keyval in ['i','I']:
            if self.ResizeIncreaseBy > 30:
                self.ResizeIncreaseBy =30
            if self.ResizeIncreaseBy >= 4:
                self.ResizeIncreaseBy+=1
            if self.ResizeIncreaseBy >=14:
                self.ResizeIncreaseBy+=2
            self.ResizeIncreaseBy+=1         
        if keyval in ['o','O']:
            if self.ResizeIncreaseBy < 0.2 :
                self.ResizeIncreaseBy=0
            if self.ResizeIncreaseBy>14:
                self.ResizeIncreaseBy -= 1
            if self.ResizeIncreaseBy >8:
                self.ResizeIncreaseBy -= 1
            self.ResizeIncreaseBy -= 1
        if self.ResizeIncreaseBy < 0:
            self.ResizeIncreaseBy = 0
        if self.ResizeIncreaseBy >30:
            self.ResizeIncreaseBy = 30    
        if self.ResizeIncreaseBy >1:
            self.ScrolledWindow.set_policy(gtk.POLICY_AUTOMATIC,gtk.POLICY_ALWAYS)
        else:
            self.ScrolledWindow.set_policy(gtk.POLICY_NEVER,gtk.POLICY_NEVER)
        print self.ResizeIncreaseBy
        self.app.view['photo'].set_cur_picture(self.current_img,self.ResizeIncreaseBy)
       
    def remove(self):
        pass
    
    
