#!/usr/bin/perl

# (c) 2002 Eduard Bloch <blade@debian.org>, GPLv2

use strict;

if ( -z "$ARGV[0]" ) {
	print STDERR "Usage: $0 pcmcia-source-file\n";
	exit 1;
}

open(find, "find $ARGV[0] |");

while(<find>)
{
   my $file = $_;
   /^.*\/([^\/]+)\.c$/;
   my $basename = $1;
   $basename =~ s/[-,\+]/_/g;
   open(src, "<$file");
   while(<src>)
   {
      if(/^MODULE_DESCRIPTION\("([^"]+)$/)
      {
         print STDERR "WARNING: $basename has unuseable description, ignoring it.\n";
      }

      if($_ =~ s/^MODULE_DESCRIPTION\("([^"]+)".*/summary_$basename="$1"/)
      {
         print $_;
      }
   }
   close(src);
}
