
/*****************************************************************************/

/*
 *      app.c  --  Configuration Application.
 *
 *      Copyright (C) 2000
 *        Thomas Sailer (sailer@ife.ee.ethz.ch)
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*****************************************************************************/

#define _GNU_SOURCE
#define _REENTRANT

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

/* AIX requires this to be the first thing in the file.  */
#ifndef __GNUC__
# if HAVE_ALLOCA_H
#  include <alloca.h>
# else
#  ifdef _AIX
#pragma alloca
#  else
#   ifndef alloca /* predefined by HP cc +Olibcalls */
char *alloca ();
#   endif
#  endif
# endif
#endif

#include "p3dapp.h"

#include <gtk/gtk.h>

#include "interface.h"
#include "support.h"
#include "callbacks.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* ---------------------------------------------------------------------- */

#ifdef WIN32

/* free result with g_free */

static gchar *strtogtk(const char *in)
{
        WCHAR *wch, *wp;
        GdkWChar *gch, *gp;
        unsigned int i, len;
        
        if (!(len = MultiByteToWideChar(CP_ACP, MB_PRECOMPOSED, in, -1, NULL, 0)))
                return NULL;
        wch = wp = alloca(sizeof(wch[0])*len);
        gch = gp = alloca(sizeof(gch[0])*(len+1));
        if (!MultiByteToWideChar(CP_ACP, MB_PRECOMPOSED, in, -1, wch, len))
                return NULL;
        for (i = 0, wp = wch, gp = gch; i < len && *wp; i++, wp++, gp++)
                *gp = *wp;
        *gp = 0;
        return gdk_wcstombs(gch);
}

static char *gtktostr(const gchar *in)
{
        union {
                GdkWChar g[4096];
                WCHAR w[4096];
        } u;
        GdkWChar *gp;
        WCHAR *wp;
        gint len;
        unsigned int i;
        int len2;
        char *ret;

        if ((len = gdk_mbstowcs(u.g, in, sizeof(u.g)/sizeof(u.g[0]))) == -1)
                return NULL;
        for (wp = u.w, gp = u.g, i = 0; i < len; i++, gp++, wp++)
                *wp = *gp;
        if (!(len2 = WideCharToMultiByte(CP_ACP, 0, u.w, len, NULL, 0, NULL, NULL)))
                return NULL;
        ret = g_malloc(len2+1);
        if (!ret)
                return NULL;
        WideCharToMultiByte(CP_ACP, 0, u.w, len, ret, len2, NULL, NULL);
        ret[len2] = 0;
        return ret;
}

#endif /* WIN32 */

/* ---------------------------------------------------------------------- */

static GtkWidget *create_paramwidget(const struct modemparams *par, const char *typname)
{
	const struct modemparams *par2 = par;
	unsigned int parcnt = 0, i, j;
	GtkWidget *table, *w1, *w2;
	GtkObject *o1;
	GtkTooltips *tooltips;
	GList *list;
        char buf[128];
	const char *value, * const *cp;
	double nval;
#ifdef WIN32
        gchar *valueg;
        gchar *combov[8];
#endif
        
	if (!par)
		return gtk_vbox_new(FALSE, 0);
	while (par2->name) {
		par2++;
		parcnt++;
	}
	table = gtk_table_new(parcnt, 2, FALSE);
	gtk_widget_show(table);
	tooltips = gtk_tooltips_new();
	for (par2 = par, i = 0; i < parcnt; i++, par2++) {
		w1 = gtk_label_new(par2->label);
		gtk_widget_show(w1);
		gtk_table_attach(GTK_TABLE(table), w1, 0, 1, i, i+1, 
				 (GtkAttachOptions)(GTK_FILL), (GtkAttachOptions) 0, 5, 5);
		gtk_misc_set_alignment(GTK_MISC(w1), 0, 0.5);
		gtk_label_set_justify(GTK_LABEL(w1), GTK_JUSTIFY_LEFT);
		if (xml_getprop(typname, par2->name, buf, sizeof(buf)) > 0)
                        value = buf;
                else
			value = par2->dflt;
		switch (par2->type) {
		case MODEMPAR_STRING:
			w1 = gtk_entry_new();
#ifdef WIN32
                        valueg = strtogtk(value);
			gtk_entry_set_text(GTK_ENTRY(w1), valueg ?: "(null)");
                        g_free(valueg);
#else
			gtk_entry_set_text(GTK_ENTRY(w1), value);
#endif
			break;

		case MODEMPAR_COMBO:
			w1 = gtk_combo_new();
#ifdef WIN32
			list = NULL;
			for (cp = par2->u.c.combostr, j = 0; *cp && j < 8; j++, cp++) {
                                combov[j] = strtogtk(*cp);
				list = g_list_append(list, combov[j] ?: "(null)");
                        }
			gtk_combo_set_popdown_strings(GTK_COMBO(w1), list);
			g_list_free(list);
                        for (; j > 0; j--)
                                g_free(combov[j-1]);
			w2 = GTK_COMBO(w1)->entry;
			gtk_widget_show(w2);
                        valueg = strtogtk(value);
			gtk_entry_set_text(GTK_ENTRY(w2), valueg ?: "(null)");
                        g_free(valueg);
#else
			list = NULL;
			for (cp = par2->u.c.combostr, j = 0; *cp && j < 8; j++, cp++)
				list = g_list_append(list, (void *)(*cp));
			gtk_combo_set_popdown_strings(GTK_COMBO(w1), list);
			g_list_free(list);
			w2 = GTK_COMBO(w1)->entry;
			gtk_widget_show(w2);
			gtk_entry_set_text(GTK_ENTRY(w2), value);
#endif
			gtk_combo_set_value_in_list(GTK_COMBO(w1), FALSE, FALSE);
			break;

		case MODEMPAR_NUMERIC:
			nval = strtod(value, NULL);
			if (nval < par2->u.n.min)
				nval = par2->u.n.min;
			if (nval > par2->u.n.max)
				nval = par2->u.n.max;
			o1 = gtk_adjustment_new(nval, par2->u.n.min, par2->u.n.max, par2->u.n.step, 
						par2->u.n.pagestep, par2->u.n.pagestep);
			w1 = gtk_spin_button_new(GTK_ADJUSTMENT(o1), par2->u.n.step, 0);
			break;

		case MODEMPAR_CHECKBUTTON:
			w1 = gtk_check_button_new();
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(w1), (*value == '0') ? FALSE : TRUE);
			break;

		default:
			continue;
		}
		gtk_widget_show(w1);
		gtk_object_set_data(GTK_OBJECT(table), par2->name, w1);
		gtk_table_attach(GTK_TABLE(table), w1, 1, 2, i, i+1, 
				 (GtkAttachOptions)(GTK_EXPAND | GTK_FILL), (GtkAttachOptions) 0, 5, 5);
		if (par2->tooltip)
			gtk_tooltips_set_tip(tooltips, w1, par2->tooltip, NULL);
	}
	return table;
}

static void update_paramwidget(GtkWidget *table, const struct modemparams *par, const char *typname)
{
	const struct modemparams *par2 = par;
	GtkWidget *w1, *w2;
	char buf[256];
#ifdef WIN32
        char *txt;
#endif

	if (!par)
		return;
	for (par2 = par; par2->name; par2++) {
		w1 = gtk_object_get_data(GTK_OBJECT(table), par2->name);
		if (!w1)
			continue;
		switch (par2->type) {
		case MODEMPAR_STRING:
#ifdef WIN32
                        txt = gtktostr(gtk_entry_get_text(GTK_ENTRY(w1)));
			xml_setprop(typname, par2->name, txt ?: "(null)");
                        g_free(txt);
#else
			xml_setprop(typname, par2->name, gtk_entry_get_text(GTK_ENTRY(w1)));
#endif
                        break;

		case MODEMPAR_COMBO:
			w2 = GTK_COMBO(w1)->entry;
#ifdef WIN32
                        txt = gtktostr(gtk_entry_get_text(GTK_ENTRY(w2)));
			xml_setprop(typname, par2->name, txt ?: "(null)");
                        g_free(txt);
#else
			xml_setprop(typname, par2->name, gtk_entry_get_text(GTK_ENTRY(w2)));
#endif
			break;

		case MODEMPAR_NUMERIC:
			sprintf(buf, "%g", gtk_spin_button_get_value_as_float(GTK_SPIN_BUTTON(w1)));
			xml_setprop(typname, par2->name, buf);
			break;

		case MODEMPAR_CHECKBUTTON:
			xml_setprop(typname, par2->name, gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w1)) ? "1" : "0");
			break;

		default:
			continue;
		}
	}
}

/* ---------------------------------------------------------------------- */

void do_source_select(void)
{
	GtkTable *table;
	GtkWidget *w;

	table = GTK_TABLE(gtk_object_get_data(GTK_OBJECT(srcselwidget), "table1"));
	w = create_paramwidget(ioparams_soundcard, "audio");
	gtk_table_attach(table, w, 0, 1, 3, 4,
			 (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			 (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 2);
	gtk_object_set_data(GTK_OBJECT(srcselwidget), "paramwidget", w);
	w = create_paramwidget(stpparams, "stp");
	gtk_table_attach(table, w, 0, 1, 5, 6,
			 (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			 (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 2);
	gtk_object_set_data(GTK_OBJECT(srcselwidget), "stpparamwidget", w);
	gtk_widget_show(srcselwidget);
}

void on_srcsel_buttonfile_clicked(GtkButton *button, gpointer user_data)
{
	GtkWidget *w;
        char buf[128];

	gtk_widget_hide(srcselwidget);
	w = GTK_WIDGET(gtk_object_get_data(GTK_OBJECT(srcselwidget), "paramwidget"));
	update_paramwidget(w, ioparams_soundcard, "audio");
	w = GTK_WIDGET(gtk_object_get_data(GTK_OBJECT(srcselwidget), "stpparamwidget"));
	update_paramwidget(w, stpparams, "stp");
	if (xml_getprop("audio", "file", buf, sizeof(buf)) > 0)
		gtk_file_selection_set_filename(GTK_FILE_SELECTION(fileselwidget), buf);
	gtk_widget_show(fileselwidget);
}

void on_srcsel_buttoncancel_clicked(GtkButton *button, gpointer user_data)
{
	gtk_widget_hide(srcselwidget);
	gtk_main_quit();
}

void on_srcsel_buttonok_clicked(GtkButton *button, gpointer user_data)
{
	GtkWidget *w;

	gtk_widget_hide(srcselwidget);
	w = GTK_WIDGET(gtk_object_get_data(GTK_OBJECT(srcselwidget), "paramwidget"));
	update_paramwidget(w, ioparams_soundcard, "audio");
	w = GTK_WIDGET(gtk_object_get_data(GTK_OBJECT(srcselwidget), "stpparamwidget"));
	update_paramwidget(w, stpparams, "stp");
	diag_start(0);
	gtk_widget_show(receivewindow);
}

void on_filesel_buttonok_clicked(GtkButton *button, gpointer user_data)
{
	gtk_widget_hide(fileselwidget);
	xml_setprop("audio", "file", gtk_file_selection_get_filename(GTK_FILE_SELECTION(fileselwidget)));
	diag_start(1);	
	gtk_widget_show(receivewindow);
}

void on_filesel_buttoncancel_clicked(GtkButton *button, gpointer user_data)
{
	gtk_widget_hide(fileselwidget);
	gtk_main_quit();
}

/* ---------------------------------------------------------------------- */

void on_quit_activate(GtkMenuItem *menuitem, gpointer user_data)
{
        gtk_main_quit();
}

static void on_aboutok_clicked(GtkButton *button, gpointer user_data)
{
	gtk_widget_hide(GTK_WIDGET(user_data));
	gtk_widget_destroy(GTK_WIDGET(user_data));
}

void on_about_activate(GtkMenuItem *menuitem, gpointer user_data)
{
	GtkWidget *dlg = create_aboutwindow();

	gtk_signal_connect(GTK_OBJECT(gtk_object_get_data(GTK_OBJECT(dlg), "aboutok")), 
			   "clicked", GTK_SIGNAL_FUNC(on_aboutok_clicked), dlg);
	gtk_widget_show(dlg);
}

/* ---------------------------------------------------------------------- */

static void on_errorok_clicked(GtkButton *button, gpointer user_data)
{
	gtk_widget_hide(GTK_WIDGET(user_data));
	gtk_widget_destroy(GTK_WIDGET(user_data));
}

void error_dialog(const gchar *text)
{
	GtkWidget *dlg = create_errordialog();

	gtk_signal_connect(GTK_OBJECT(gtk_object_get_data(GTK_OBJECT(dlg), "errorok")), 
			   "clicked", GTK_SIGNAL_FUNC(on_errorok_clicked), dlg);
	gtk_label_set_text(GTK_LABEL(gtk_object_get_data(GTK_OBJECT(dlg), "errorlabel")), text);
	gtk_widget_show(dlg);
}

/* ---------------------------------------------------------------------- */

gboolean on_receivewindow_delete_event(GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
	gtk_main_quit();
	return TRUE;
}

gboolean on_receivewindow_destroy_event(GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
	gtk_main_quit();
	return TRUE;
}

/* ---------------------------------------------------------------------- */

