#!/bin/sh

# $Id: create_plugin.sh,v 1.6 2001/08/29 12:44:55 jk Exp $

if [ $# = 0 ]; then
	echo "Usage:"
	echo "  $0 <name> [<type>]"
	exit
fi


## getting the vars
name=$1

if [ $# > 1 ]; then
	type=$2
fi

if (echo "testing\c"; echo 1,2,3) | grep c >/dev/null; then
  # Stardent Vistra SVR4 grep lacks -e, says ghazi@caip.rutgers.edu.
  if (echo -n testing; echo 1,2,3) | sed s/-n/xn/ | grep xn >/dev/null; then
    ac_n= ac_c='
' ac_t='	'
  else
    ac_n=-n ac_c= ac_t=
  fi
else
  ac_n= ac_c='\c' ac_t=
fi

echo $ac_n "Detecting basedir... $ac_c" 
basedir=`pwd | sed "s/src.*//;s/doc.*//;s/po.*//;s/intl.*//"`

if [ ! -e $basedir/modlogan.spec.in ]; then
	echo "Couldn't detect modlogan basedir - aborting"
	exit
fi

echo "$basedir"

echo $ac_n "Detecting type of plugin... $ac_c" 
if [ x$type = x ]; then
	_bd=`echo $basedir | sed "s/\///g"`
	_t=`pwd | sed "s/\///g;s/$_bd//;s/src//;"`
	case $_t in
		input) type=$_t ;;
		output) type=$_t ;;
		processor)  type=$_t ;;
	esac
fi

if [ x$type = x ]; then
	echo "none specified"
	echo "Couldn't detect type of plugin - aborting"
	exit
fi

case $type in
	input) ;;
	output) ;;
	processor) ;;
	*) 	echo "Unknown type of plugin - aborting"
		;;
esac
echo "$type"

workdir="$basedir/src/$type"

if [ ! -d $workdir/skeleton ]; then
	echo "skeleton not found - aborting"
	exit
fi

if [ -e $workdir/$name ]; then
	echo "plugin '$name' already exists - aborting"
	exit
fi

echo $ac_n "Creating subdirectory... $ac_c" 
mkdir $workdir/$name
echo "done"

echo $ac_n "Copying skeleton code... $ac_c" 
for i in $workdir/skeleton/*.[ch]; do
	cat $i | sed "s/skeleton/$name/g" > $workdir/$name/`basename $i`
done
echo "done"

echo $ac_n "Preparing infrastructure... $ac_c" 
cat $workdir/skeleton/Makefile.am | grep "^#" | sed "s/^#//;s/skeleton/$name/" > $workdir/$name/Makefile.am
cat $workdir/skeleton/.cvsignore | sed "s/skeleton/$name/" > $workdir/$name/.cvsignore
cat $workdir/skeleton/STATUS | sed "s/skeleton/$name/" > $workdir/$name/STATUS
echo "done"

echo $ac_n "Updating $workdir/Makefile.am... $ac_c" 
cp $workdir/Makefile.am $workdir/Makefile.am.orig
cat $workdir/Makefile.am.orig | sed "/SUBDIRS/s/\(\\\\\)*$/ $name\\1/;" > $workdir/Makefile.am
echo "done"

echo $ac_n "Updating $basedir/configure.in... $ac_c" 
cp $basedir/configure.in $basedir/configure.in.orig
cat $basedir/configure.in.orig | sed "/AC_CONFIG_FILES(/,/)/{/src\/$type\/Makefile/a\\
	src\/$type\/$name\/Makefile
}" > $basedir/configure.in
echo "done"

echo "--> successfully finished"
