/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.modlogan.org
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: datatype.c,v 1.10 2004/08/27 18:32:53 ostborn Exp $
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

#include <zlib.h>

#include "config.h"
#include "mdatatypes.h"
#include "datatype.h"

/* begin of Query */

int mdata_Query_to_xml(gzFile *fd, mdata *data) {
	return 0;
}

int mdata_Query_free(mdata *data) {
	if (!data) return -1;
	if (data->type != M_DATA_TYPE_QUERY) return -1;

	return 0;
}

#ifdef HAVE_LIBADNS
int mdata_Query_setdata(mdata *data, const char *str, adns_query *query) {
#else
int mdata_Query_setdata(mdata *data, const char *str, void *query) {
#endif

	data->key = str;
	assert(data->key);

#ifdef HAVE_LIBADNS
	data->data.query.query	= query;
#endif

#if 0
	/* for the indenting of jed */
        }
#endif

	return 0;
}

int mdata_Query_from_xml(void *user_data, int tagtype, const xmlChar *value, const xmlChar **attrs) {
	return 0;
}

int mdata_Query_append(mdata *dst, mdata *src) {
	return 0;
}

mdata *mdata_Query_init() {
	mdata *data = mdata_init();
	assert(data);

	data->key		= NULL;
	data->type		= M_DATA_TYPE_QUERY;

#ifdef DEBUG_DATATYPES
	fprintf(stderr, "%s.%d: got %ld (%d)\n", __FILE__, __LINE__, data->id, data->type);
#endif
#ifdef HAVE_LIBADNS
/* init specifics */
	data->data.query.query		= NULL;
	data->data.query.hostname	= NULL;
#endif
	return data;
}

mdata *mdata_Query_copy(mdata *src) {
	return NULL;
}

#ifdef HAVE_LIBADNS
mdata *mdata_Query_create(const char *ip, adns_query * query) {
	mdata *data = mdata_Query_init();
	assert(data);
	mdata_Query_setdata(data, ip, query);

	return data;
}
#else
mdata *mdata_Query_create(const char *ip, void * query) {
	return NULL;
}
#endif
/* end of Query */
