/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.modlogan.org
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: parse.c,v 1.3 2004/08/27 20:07:38 ostborn Exp $
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <ctype.h>
#include <errno.h>

#include "mlocale.h"
#include "mplugins.h"
#include "mrecord.h"
#include "mdatatypes.h"
#include "misc.h"

#include "plugin_config.h"

#define DEBUG_PCRE

int parse_record_mysql(mconfig *ext_conf, mlogrec *record) {
	mlogrec_web *recweb = NULL;
	mlogrec_web_extclf *recext;
	config_input *conf = ext_conf->plugin_conf;
#ifdef HAVE_MYSQL
	MYSQL_ROW row;
#else
	return M_RECORD_HARD_ERROR;
#endif
	
	if (record->ext_type != M_RECORD_TYPE_WEB) {
		if (record->ext_type != M_RECORD_TYPE_UNSET) {
			mrecord_free_ext(record);
		}
		
		record->ext_type = M_RECORD_TYPE_WEB;
		record->ext = mrecord_init_web();
	}

	recweb = record->ext;
	
	if (recweb == NULL) return M_RECORD_HARD_ERROR;

	recext = mrecord_init_web_extclf();
	recweb->ext_type = M_RECORD_TYPE_WEB_EXTCLF;
	recweb->ext = recext;
	
	/*
	 * db_query = SELECT 
	 *  0   agent,
	 *  1   bytes_sent,
	 *  2   referer,
	 *  3   remote_host,
	 *  4   remote_user,
	 *  5   request_duration,
	 *  6   request_method,
	 *  7   request_protocol,
	 *  8   request_uri,
	 *  9   request_args,
	 * 10   status,
	 * 11   time_stamp,
	 * 12   virtual_host 
	 *            FROM access_grisu_home_kneschke_de
	 * 
	 */
#ifdef HAVE_MYSQL	
	if (NULL == (row = mysql_fetch_row(conf->result))) {
		return M_RECORD_EOF;
	}
	
	recweb->xfersize   = strtol(row[1],  NULL, 10);
	recext->duration = strtol(row[5],  NULL, 10);
	recweb->req_status = strtol(row[10], NULL, 10);
	record->timestamp  = strtol(row[11], NULL, 10);
	
	buffer_copy_string(recext->req_useragent,   row[0]);
	buffer_copy_string(recext->ref_url,         row[2]);
	buffer_copy_string(recweb->req_host_name,   row[3]);
	buffer_copy_string(recweb->req_user,        row[4]);
	buffer_copy_string(recweb->req_method,      row[6]);
	buffer_copy_string(recweb->req_protocol,    row[7]);
	buffer_copy_string(recweb->req_url,         row[8]);
	buffer_copy_string(recweb->req_getvars,     row[9]);
	buffer_copy_string(recext->srv_host,        row[12]);
#endif

	return M_RECORD_NO_ERROR;
}


int mplugins_input_mod_log_sql_get_next_record(mconfig *ext_conf, mlogrec *record) {
	int ret = 0;

	if (record == NULL) return M_RECORD_HARD_ERROR;

	ret = parse_record_mysql(ext_conf, record);
	
	return ret;
}
