#include <glib-object.h>
#include <dbus/dbus-glib.h>

G_BEGIN_DECLS

/**
 * MojitoServiceIface:
 *
 * Dummy typedef representing any implementation of this interface.
 */
typedef struct _MojitoServiceIface MojitoServiceIface;

/**
 * MojitoServiceIfaceClass:
 *
 * The class of MojitoServiceIface.
 */
typedef struct _MojitoServiceIfaceClass MojitoServiceIfaceClass;

GType mojito_service_iface_get_type (void);
#define MOJITO_TYPE_SERVICE_IFACE \
  (mojito_service_iface_get_type ())
#define MOJITO_SERVICE_IFACE(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), MOJITO_TYPE_SERVICE_IFACE, MojitoServiceIface))
#define MOJITO_IS_SERVICE_IFACE(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), MOJITO_TYPE_SERVICE_IFACE))
#define MOJITO_SERVICE_IFACE_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_INTERFACE((obj), MOJITO_TYPE_SERVICE_IFACE, MojitoServiceIfaceClass))


typedef void (*mojito_service_iface_update_status_impl) (MojitoServiceIface *self,
    const gchar *in_status_message,
    DBusGMethodInvocation *context);
void mojito_service_iface_implement_update_status (MojitoServiceIfaceClass *klass, mojito_service_iface_update_status_impl impl);
/**
 * mojito_service_iface_return_from_update_status:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void mojito_service_iface_return_from_update_status (DBusGMethodInvocation *context);
static inline void
mojito_service_iface_return_from_update_status (DBusGMethodInvocation *context)
{
  dbus_g_method_return (context);
}

typedef void (*mojito_service_iface_get_static_capabilities_impl) (MojitoServiceIface *self,
    DBusGMethodInvocation *context);
void mojito_service_iface_implement_get_static_capabilities (MojitoServiceIfaceClass *klass, mojito_service_iface_get_static_capabilities_impl impl);
/**
 * mojito_service_iface_return_from_get_static_capabilities:
 * @context: The D-Bus method invocation context
 * @out_caps: const gchar ** (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void mojito_service_iface_return_from_get_static_capabilities (DBusGMethodInvocation *context,
    const gchar **out_caps);
static inline void
mojito_service_iface_return_from_get_static_capabilities (DBusGMethodInvocation *context,
    const gchar **out_caps)
{
  dbus_g_method_return (context,
      out_caps);
}

typedef void (*mojito_service_iface_get_dynamic_capabilities_impl) (MojitoServiceIface *self,
    DBusGMethodInvocation *context);
void mojito_service_iface_implement_get_dynamic_capabilities (MojitoServiceIfaceClass *klass, mojito_service_iface_get_dynamic_capabilities_impl impl);
/**
 * mojito_service_iface_return_from_get_dynamic_capabilities:
 * @context: The D-Bus method invocation context
 * @out_caps: const gchar ** (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void mojito_service_iface_return_from_get_dynamic_capabilities (DBusGMethodInvocation *context,
    const gchar **out_caps);
static inline void
mojito_service_iface_return_from_get_dynamic_capabilities (DBusGMethodInvocation *context,
    const gchar **out_caps)
{
  dbus_g_method_return (context,
      out_caps);
}

typedef void (*mojito_service_iface_request_avatar_impl) (MojitoServiceIface *self,
    DBusGMethodInvocation *context);
void mojito_service_iface_implement_request_avatar (MojitoServiceIfaceClass *klass, mojito_service_iface_request_avatar_impl impl);
/**
 * mojito_service_iface_return_from_request_avatar:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void mojito_service_iface_return_from_request_avatar (DBusGMethodInvocation *context);
static inline void
mojito_service_iface_return_from_request_avatar (DBusGMethodInvocation *context)
{
  dbus_g_method_return (context);
}

void mojito_service_iface_emit_status_updated (gpointer instance,
    gboolean arg_success);
void mojito_service_iface_emit_capabilities_changed (gpointer instance,
    const gchar **arg_caps);
void mojito_service_iface_emit_avatar_retrieved (gpointer instance,
    const gchar *arg_path);
void mojito_service_iface_emit_user_changed (gpointer instance);


G_END_DECLS
