typedef struct {
    XSUM_U32 len;
    XSUM_U32 seed;
    XSUM_U32 Nresult;
} XSUM_testdata32_t;

typedef struct {
    XSUM_U32 len;
    XSUM_U64 seed;
    XSUM_U64 Nresult;
} XSUM_testdata64_t;

typedef struct {
    XSUM_U32 len;
    XSUM_U64 seed;
    XXH128_hash_t Nresult;
} XSUM_testdata128_t;

#ifndef SECRET_SAMPLE_NBBYTES
#define SECRET_SAMPLE_NBBYTES 5
#endif

typedef struct {
    XSUM_U32 seedLen;
    XSUM_U32 secretLen;
    XSUM_U8 byte[SECRET_SAMPLE_NBBYTES];
} XSUM_testdata_sample_t;

#ifndef SECRET_SIZE_MAX
#define SECRET_SIZE_MAX 9867
#endif
static const XSUM_testdata32_t XSUM_XXH32_testdata[] = {
    {    0, 0x00000000U, 0x02CC5D05U }, /* XSUM_XXH32_testdata[0] */
    {    0, 0x9E3779B1U, 0x36B78AE7U }, /* XSUM_XXH32_testdata[1] */
    {    1, 0x00000000U, 0xCF65B03EU }, /* XSUM_XXH32_testdata[2] */
    {    1, 0x9E3779B1U, 0xB4545AA4U }, /* XSUM_XXH32_testdata[3] */
    {    2, 0x00000000U, 0x1151BEE4U }, /* XSUM_XXH32_testdata[4] */
    {    2, 0x9E3779B1U, 0x1EDB879AU }, /* XSUM_XXH32_testdata[5] */
    {    3, 0x00000000U, 0xC23884F5U }, /* XSUM_XXH32_testdata[6] */
    {    3, 0x9E3779B1U, 0x1A269947U }, /* XSUM_XXH32_testdata[7] */
    {    4, 0x00000000U, 0xA9DE7CE9U }, /* XSUM_XXH32_testdata[8] */
    {    4, 0x9E3779B1U, 0x2BAAFE83U }, /* XSUM_XXH32_testdata[9] */
    {    5, 0x00000000U, 0xEB1734BBU }, /* XSUM_XXH32_testdata[10] */
    {    5, 0x9E3779B1U, 0x5874DAB0U }, /* XSUM_XXH32_testdata[11] */
    {    6, 0x00000000U, 0x659F0C97U }, /* XSUM_XXH32_testdata[12] */
    {    6, 0x9E3779B1U, 0x0BCF25C5U }, /* XSUM_XXH32_testdata[13] */
    {    7, 0x00000000U, 0x5E1056CDU }, /* XSUM_XXH32_testdata[14] */
    {    7, 0x9E3779B1U, 0x3ED9D3FCU }, /* XSUM_XXH32_testdata[15] */
    {    8, 0x00000000U, 0xA3F6F44BU }, /* XSUM_XXH32_testdata[16] */
    {    8, 0x9E3779B1U, 0xC2A8E239U }, /* XSUM_XXH32_testdata[17] */
    {    9, 0x00000000U, 0xFFB82A24U }, /* XSUM_XXH32_testdata[18] */
    {    9, 0x9E3779B1U, 0xD35632C6U }, /* XSUM_XXH32_testdata[19] */
    {   10, 0x00000000U, 0xB1E5032EU }, /* XSUM_XXH32_testdata[20] */
    {   10, 0x9E3779B1U, 0x18679D60U }, /* XSUM_XXH32_testdata[21] */
    {   11, 0x00000000U, 0x0CF2F032U }, /* XSUM_XXH32_testdata[22] */
    {   11, 0x9E3779B1U, 0xE0E99838U }, /* XSUM_XXH32_testdata[23] */
    {   12, 0x00000000U, 0xE89B5F9BU }, /* XSUM_XXH32_testdata[24] */
    {   12, 0x9E3779B1U, 0x05A6C4B5U }, /* XSUM_XXH32_testdata[25] */
    {   13, 0x00000000U, 0xC537DE02U }, /* XSUM_XXH32_testdata[26] */
    {   13, 0x9E3779B1U, 0x1298ADD0U }, /* XSUM_XXH32_testdata[27] */
    {   14, 0x00000000U, 0x1208E7E2U }, /* XSUM_XXH32_testdata[28] */
    {   14, 0x9E3779B1U, 0x6AF1D1FEU }, /* XSUM_XXH32_testdata[29] */
    {   15, 0x00000000U, 0x6B859E14U }, /* XSUM_XXH32_testdata[30] */
    {   15, 0x9E3779B1U, 0xAD53090DU }, /* XSUM_XXH32_testdata[31] */
    {   16, 0x00000000U, 0x93BA3759U }, /* XSUM_XXH32_testdata[32] */
    {   16, 0x9E3779B1U, 0xA94FC1E1U }, /* XSUM_XXH32_testdata[33] */
    {   17, 0x00000000U, 0x89FDC23EU }, /* XSUM_XXH32_testdata[34] */
    {   17, 0x9E3779B1U, 0xC9910739U }, /* XSUM_XXH32_testdata[35] */
    {   18, 0x00000000U, 0x16B53F56U }, /* XSUM_XXH32_testdata[36] */
    {   18, 0x9E3779B1U, 0x5E88116EU }, /* XSUM_XXH32_testdata[37] */
    {   19, 0x00000000U, 0x858FC8EAU }, /* XSUM_XXH32_testdata[38] */
    {   19, 0x9E3779B1U, 0x63826A8FU }, /* XSUM_XXH32_testdata[39] */
    {   20, 0x00000000U, 0x38374A35U }, /* XSUM_XXH32_testdata[40] */
    {   20, 0x9E3779B1U, 0xC691A55AU }, /* XSUM_XXH32_testdata[41] */
    {   21, 0x00000000U, 0x646A88D6U }, /* XSUM_XXH32_testdata[42] */
    {   21, 0x9E3779B1U, 0x9668CDABU }, /* XSUM_XXH32_testdata[43] */
    {   22, 0x00000000U, 0xB5CCC747U }, /* XSUM_XXH32_testdata[44] */
    {   22, 0x9E3779B1U, 0x96F6C6A1U }, /* XSUM_XXH32_testdata[45] */
    {   23, 0x00000000U, 0xCC7B3099U }, /* XSUM_XXH32_testdata[46] */
    {   23, 0x9E3779B1U, 0x174910FEU }, /* XSUM_XXH32_testdata[47] */
    {   24, 0x00000000U, 0xA6276FF0U }, /* XSUM_XXH32_testdata[48] */
    {   24, 0x9E3779B1U, 0x7AD49212U }, /* XSUM_XXH32_testdata[49] */
    {   25, 0x00000000U, 0x221B959BU }, /* XSUM_XXH32_testdata[50] */
    {   25, 0x9E3779B1U, 0xA1899908U }, /* XSUM_XXH32_testdata[51] */
    {   26, 0x00000000U, 0x3F2F5961U }, /* XSUM_XXH32_testdata[52] */
    {   26, 0x9E3779B1U, 0x6A936E6BU }, /* XSUM_XXH32_testdata[53] */
    {   27, 0x00000000U, 0x9501BDDDU }, /* XSUM_XXH32_testdata[54] */
    {   27, 0x9E3779B1U, 0x61A4E18BU }, /* XSUM_XXH32_testdata[55] */
    {   28, 0x00000000U, 0xDA976167U }, /* XSUM_XXH32_testdata[56] */
    {   28, 0x9E3779B1U, 0x261F77CFU }, /* XSUM_XXH32_testdata[57] */
    {   29, 0x00000000U, 0x249CC065U }, /* XSUM_XXH32_testdata[58] */
    {   29, 0x9E3779B1U, 0xC8EC8904U }, /* XSUM_XXH32_testdata[59] */
    {   30, 0x00000000U, 0x36BC3693U }, /* XSUM_XXH32_testdata[60] */
    {   30, 0x9E3779B1U, 0xA2800E16U }, /* XSUM_XXH32_testdata[61] */
    {   31, 0x00000000U, 0x5F40E562U }, /* XSUM_XXH32_testdata[62] */
    {   31, 0x9E3779B1U, 0x5C0C3350U }, /* XSUM_XXH32_testdata[63] */
    {   32, 0x00000000U, 0xD89829ECU }, /* XSUM_XXH32_testdata[64] */
    {   32, 0x9E3779B1U, 0xA5C44467U }, /* XSUM_XXH32_testdata[65] */
    {   33, 0x00000000U, 0x31A427E5U }, /* XSUM_XXH32_testdata[66] */
    {   33, 0x9E3779B1U, 0x0DE5B1F9U }, /* XSUM_XXH32_testdata[67] */
    {   34, 0x00000000U, 0x80B8584BU }, /* XSUM_XXH32_testdata[68] */
    {   34, 0x9E3779B1U, 0x7FFCCCFEU }, /* XSUM_XXH32_testdata[69] */
    {   35, 0x00000000U, 0x7627760AU }, /* XSUM_XXH32_testdata[70] */
    {   35, 0x9E3779B1U, 0xD060F480U }, /* XSUM_XXH32_testdata[71] */
    {   36, 0x00000000U, 0xED4F560FU }, /* XSUM_XXH32_testdata[72] */
    {   36, 0x9E3779B1U, 0x24321F47U }, /* XSUM_XXH32_testdata[73] */
    {   37, 0x00000000U, 0x1241D245U }, /* XSUM_XXH32_testdata[74] */
    {   37, 0x9E3779B1U, 0x09EFB299U }, /* XSUM_XXH32_testdata[75] */
    {   38, 0x00000000U, 0x5E1CC178U }, /* XSUM_XXH32_testdata[76] */
    {   38, 0x9E3779B1U, 0xC1322A61U }, /* XSUM_XXH32_testdata[77] */
    {   39, 0x00000000U, 0xBA125684U }, /* XSUM_XXH32_testdata[78] */
    {   39, 0x9E3779B1U, 0x2D6246FFU }, /* XSUM_XXH32_testdata[79] */
    {   40, 0x00000000U, 0xB22A36ABU }, /* XSUM_XXH32_testdata[80] */
    {   40, 0x9E3779B1U, 0xBF491205U }, /* XSUM_XXH32_testdata[81] */
    {   41, 0x00000000U, 0x161223AFU }, /* XSUM_XXH32_testdata[82] */
    {   41, 0x9E3779B1U, 0x0CB4D70FU }, /* XSUM_XXH32_testdata[83] */
    {   42, 0x00000000U, 0x11586B3FU }, /* XSUM_XXH32_testdata[84] */
    {   42, 0x9E3779B1U, 0x29218DC3U }, /* XSUM_XXH32_testdata[85] */
    {   43, 0x00000000U, 0x0A1C7CC9U }, /* XSUM_XXH32_testdata[86] */
    {   43, 0x9E3779B1U, 0x4D7337ABU }, /* XSUM_XXH32_testdata[87] */
    {   44, 0x00000000U, 0xF0910CD3U }, /* XSUM_XXH32_testdata[88] */
    {   44, 0x9E3779B1U, 0xF33E0443U }, /* XSUM_XXH32_testdata[89] */
    {   45, 0x00000000U, 0xDD97A408U }, /* XSUM_XXH32_testdata[90] */
    {   45, 0x9E3779B1U, 0x8CEC6D9CU }, /* XSUM_XXH32_testdata[91] */
    {   46, 0x00000000U, 0x3A609997U }, /* XSUM_XXH32_testdata[92] */
    {   46, 0x9E3779B1U, 0xBD3BA412U }, /* XSUM_XXH32_testdata[93] */
    {   47, 0x00000000U, 0xD5E9364EU }, /* XSUM_XXH32_testdata[94] */
    {   47, 0x9E3779B1U, 0xA463C5A4U }, /* XSUM_XXH32_testdata[95] */
    {   48, 0x00000000U, 0xBFD05CBDU }, /* XSUM_XXH32_testdata[96] */
    {   48, 0x9E3779B1U, 0x0ECCC06EU }, /* XSUM_XXH32_testdata[97] */
    {   49, 0x00000000U, 0xED9B7E81U }, /* XSUM_XXH32_testdata[98] */
    {   49, 0x9E3779B1U, 0xA7E98491U }, /* XSUM_XXH32_testdata[99] */
    {   50, 0x00000000U, 0xBDF553E2U }, /* XSUM_XXH32_testdata[100] */
    {   50, 0x9E3779B1U, 0xA937E7EDU }, /* XSUM_XXH32_testdata[101] */
    {   51, 0x00000000U, 0x3CDEED0FU }, /* XSUM_XXH32_testdata[102] */
    {   51, 0x9E3779B1U, 0x9E2ED4B1U }, /* XSUM_XXH32_testdata[103] */
    {   52, 0x00000000U, 0x27D50857U }, /* XSUM_XXH32_testdata[104] */
    {   52, 0x9E3779B1U, 0x4682E48BU }, /* XSUM_XXH32_testdata[105] */
    {   53, 0x00000000U, 0x62E63D09U }, /* XSUM_XXH32_testdata[106] */
    {   53, 0x9E3779B1U, 0x1FF1A182U }, /* XSUM_XXH32_testdata[107] */
    {   54, 0x00000000U, 0x30BACCFAU }, /* XSUM_XXH32_testdata[108] */
    {   54, 0x9E3779B1U, 0x955B14A7U }, /* XSUM_XXH32_testdata[109] */
    {   55, 0x00000000U, 0xEA5D7666U }, /* XSUM_XXH32_testdata[110] */
    {   55, 0x9E3779B1U, 0x300DDE4DU }, /* XSUM_XXH32_testdata[111] */
    {   56, 0x00000000U, 0xC8D07416U }, /* XSUM_XXH32_testdata[112] */
    {   56, 0x9E3779B1U, 0x8952E674U }, /* XSUM_XXH32_testdata[113] */
    {   57, 0x00000000U, 0xDF6987F5U }, /* XSUM_XXH32_testdata[114] */
    {   57, 0x9E3779B1U, 0x98D545E4U }, /* XSUM_XXH32_testdata[115] */
    {   58, 0x00000000U, 0x447DCE59U }, /* XSUM_XXH32_testdata[116] */
    {   58, 0x9E3779B1U, 0x1CFC5C29U }, /* XSUM_XXH32_testdata[117] */
    {   59, 0x00000000U, 0x4529090DU }, /* XSUM_XXH32_testdata[118] */
    {   59, 0x9E3779B1U, 0xE3ACD84EU }, /* XSUM_XXH32_testdata[119] */
    {   60, 0x00000000U, 0xA48E8818U }, /* XSUM_XXH32_testdata[120] */
    {   60, 0x9E3779B1U, 0x31CA20F1U }, /* XSUM_XXH32_testdata[121] */
    {   61, 0x00000000U, 0xB1C4FBB5U }, /* XSUM_XXH32_testdata[122] */
    {   61, 0x9E3779B1U, 0x21749FC9U }, /* XSUM_XXH32_testdata[123] */
    {   62, 0x00000000U, 0x84145F58U }, /* XSUM_XXH32_testdata[124] */
    {   62, 0x9E3779B1U, 0x0374E669U }, /* XSUM_XXH32_testdata[125] */
    {   63, 0x00000000U, 0xF1D48FDBU }, /* XSUM_XXH32_testdata[126] */
    {   63, 0x9E3779B1U, 0x956B3D77U }, /* XSUM_XXH32_testdata[127] */
    {   64, 0x00000000U, 0x02E95DBBU }, /* XSUM_XXH32_testdata[128] */
    {   64, 0x9E3779B1U, 0xCF82F830U }, /* XSUM_XXH32_testdata[129] */
    {   65, 0x00000000U, 0x16992B3DU }, /* XSUM_XXH32_testdata[130] */
    {   65, 0x9E3779B1U, 0x428EEC5FU }, /* XSUM_XXH32_testdata[131] */
    {   66, 0x00000000U, 0xDEFD9E68U }, /* XSUM_XXH32_testdata[132] */
    {   66, 0x9E3779B1U, 0xCED81C34U }, /* XSUM_XXH32_testdata[133] */
    {   67, 0x00000000U, 0x9667C027U }, /* XSUM_XXH32_testdata[134] */
    {   67, 0x9E3779B1U, 0x56E465E2U }, /* XSUM_XXH32_testdata[135] */
    {   68, 0x00000000U, 0xBC606CAAU }, /* XSUM_XXH32_testdata[136] */
    {   68, 0x9E3779B1U, 0x3679A1D9U }, /* XSUM_XXH32_testdata[137] */
    {   69, 0x00000000U, 0xE7069479U }, /* XSUM_XXH32_testdata[138] */
    {   69, 0x9E3779B1U, 0x5D4B3836U }, /* XSUM_XXH32_testdata[139] */
    {   70, 0x00000000U, 0xF6EBE19DU }, /* XSUM_XXH32_testdata[140] */
    {   70, 0x9E3779B1U, 0x64AD7E72U }, /* XSUM_XXH32_testdata[141] */
    {   71, 0x00000000U, 0x7ACA94AAU }, /* XSUM_XXH32_testdata[142] */
    {   71, 0x9E3779B1U, 0xA5496174U }, /* XSUM_XXH32_testdata[143] */
    {   72, 0x00000000U, 0xB78CCDD2U }, /* XSUM_XXH32_testdata[144] */
    {   72, 0x9E3779B1U, 0x6003D7C1U }, /* XSUM_XXH32_testdata[145] */
    {   73, 0x00000000U, 0x20957640U }, /* XSUM_XXH32_testdata[146] */
    {   73, 0x9E3779B1U, 0x28188381U }, /* XSUM_XXH32_testdata[147] */
    {   74, 0x00000000U, 0xC8FEB4EAU }, /* XSUM_XXH32_testdata[148] */
    {   74, 0x9E3779B1U, 0x2F41F670U }, /* XSUM_XXH32_testdata[149] */
    {   75, 0x00000000U, 0xE1299536U }, /* XSUM_XXH32_testdata[150] */
    {   75, 0x9E3779B1U, 0x7EC75712U }, /* XSUM_XXH32_testdata[151] */
    {   76, 0x00000000U, 0x120EBEC9U }, /* XSUM_XXH32_testdata[152] */
    {   76, 0x9E3779B1U, 0x174F8A9CU }, /* XSUM_XXH32_testdata[153] */
    {   77, 0x00000000U, 0x5F6F8059U }, /* XSUM_XXH32_testdata[154] */
    {   77, 0x9E3779B1U, 0xE13D45E7U }, /* XSUM_XXH32_testdata[155] */
    {   78, 0x00000000U, 0x2D18D24CU }, /* XSUM_XXH32_testdata[156] */
    {   78, 0x9E3779B1U, 0xFA4D7DC7U }, /* XSUM_XXH32_testdata[157] */
    {   79, 0x00000000U, 0x162FFDDCU }, /* XSUM_XXH32_testdata[158] */
    {   79, 0x9E3779B1U, 0x17E69038U }, /* XSUM_XXH32_testdata[159] */
    {   80, 0x00000000U, 0xB8D7E581U }, /* XSUM_XXH32_testdata[160] */
    {   80, 0x9E3779B1U, 0x65D85230U }, /* XSUM_XXH32_testdata[161] */
    {   81, 0x00000000U, 0xB13BC253U }, /* XSUM_XXH32_testdata[162] */
    {   81, 0x9E3779B1U, 0xAB0B3D44U }, /* XSUM_XXH32_testdata[163] */
    {   82, 0x00000000U, 0xA459BF95U }, /* XSUM_XXH32_testdata[164] */
    {   82, 0x9E3779B1U, 0xABB92571U }, /* XSUM_XXH32_testdata[165] */
    {   83, 0x00000000U, 0x02042BB9U }, /* XSUM_XXH32_testdata[166] */
    {   83, 0x9E3779B1U, 0x44F624EDU }, /* XSUM_XXH32_testdata[167] */
    {   84, 0x00000000U, 0x5AAC85A4U }, /* XSUM_XXH32_testdata[168] */
    {   84, 0x9E3779B1U, 0x890C0E47U }, /* XSUM_XXH32_testdata[169] */
    {   85, 0x00000000U, 0x938629B3U }, /* XSUM_XXH32_testdata[170] */
    {   85, 0x9E3779B1U, 0x2F13BAC8U }, /* XSUM_XXH32_testdata[171] */
    {   86, 0x00000000U, 0xE59B177EU }, /* XSUM_XXH32_testdata[172] */
    {   86, 0x9E3779B1U, 0x24624EDCU }, /* XSUM_XXH32_testdata[173] */
    {   87, 0x00000000U, 0xA1874DCCU }, /* XSUM_XXH32_testdata[174] */
    {   87, 0x9E3779B1U, 0xD6C644BDU }, /* XSUM_XXH32_testdata[175] */
    {   88, 0x00000000U, 0xAB18B20CU }, /* XSUM_XXH32_testdata[176] */
    {   88, 0x9E3779B1U, 0x91094C63U }, /* XSUM_XXH32_testdata[177] */
    {   89, 0x00000000U, 0x0BB0289BU }, /* XSUM_XXH32_testdata[178] */
    {   89, 0x9E3779B1U, 0x0A79DCB2U }, /* XSUM_XXH32_testdata[179] */
    {   90, 0x00000000U, 0x92AA4D3CU }, /* XSUM_XXH32_testdata[180] */
    {   90, 0x9E3779B1U, 0x5892CA32U }, /* XSUM_XXH32_testdata[181] */
    {   91, 0x00000000U, 0x88F76854U }, /* XSUM_XXH32_testdata[182] */
    {   91, 0x9E3779B1U, 0x2398BEDAU }, /* XSUM_XXH32_testdata[183] */
    {   92, 0x00000000U, 0xD4B4E941U }, /* XSUM_XXH32_testdata[184] */
    {   92, 0x9E3779B1U, 0xCBC76755U }, /* XSUM_XXH32_testdata[185] */
    {   93, 0x00000000U, 0x44CC8539U }, /* XSUM_XXH32_testdata[186] */
    {   93, 0x9E3779B1U, 0x1A2B1728U }, /* XSUM_XXH32_testdata[187] */
    {   94, 0x00000000U, 0xEC02C59FU }, /* XSUM_XXH32_testdata[188] */
    {   94, 0x9E3779B1U, 0xA2302AFEU }, /* XSUM_XXH32_testdata[189] */
    {   95, 0x00000000U, 0xF081F6AAU }, /* XSUM_XXH32_testdata[190] */
    {   95, 0x9E3779B1U, 0x7A8F0916U }, /* XSUM_XXH32_testdata[191] */
    {   96, 0x00000000U, 0x4CCF41E0U }, /* XSUM_XXH32_testdata[192] */
    {   96, 0x9E3779B1U, 0xCFA0AAECU }, /* XSUM_XXH32_testdata[193] */
    {   97, 0x00000000U, 0x914082D0U }, /* XSUM_XXH32_testdata[194] */
    {   97, 0x9E3779B1U, 0x9FCA3CB0U }, /* XSUM_XXH32_testdata[195] */
    {   98, 0x00000000U, 0x5B313627U }, /* XSUM_XXH32_testdata[196] */
    {   98, 0x9E3779B1U, 0x47F152BAU }, /* XSUM_XXH32_testdata[197] */
    {   99, 0x00000000U, 0xCC0A29F7U }, /* XSUM_XXH32_testdata[198] */
    {   99, 0x9E3779B1U, 0xE3ACED83U }, /* XSUM_XXH32_testdata[199] */
    {  100, 0x00000000U, 0x96AD8143U }, /* XSUM_XXH32_testdata[200] */
    {  100, 0x9E3779B1U, 0x83D48124U }, /* XSUM_XXH32_testdata[201] */
    {  101, 0x00000000U, 0x1B305CDBU }, /* XSUM_XXH32_testdata[202] */
    {  101, 0x9E3779B1U, 0x5839BFA6U }, /* XSUM_XXH32_testdata[203] */
    {  102, 0x00000000U, 0x3BD5DBACU }, /* XSUM_XXH32_testdata[204] */
    {  102, 0x9E3779B1U, 0x78187AB1U }, /* XSUM_XXH32_testdata[205] */
    {  103, 0x00000000U, 0x65688574U }, /* XSUM_XXH32_testdata[206] */
    {  103, 0x9E3779B1U, 0xEC1A502CU }, /* XSUM_XXH32_testdata[207] */
    {  104, 0x00000000U, 0x78861916U }, /* XSUM_XXH32_testdata[208] */
    {  104, 0x9E3779B1U, 0x0F8AC709U }, /* XSUM_XXH32_testdata[209] */
    {  105, 0x00000000U, 0x321DE7A2U }, /* XSUM_XXH32_testdata[210] */
    {  105, 0x9E3779B1U, 0x2A383E68U }, /* XSUM_XXH32_testdata[211] */
    {  106, 0x00000000U, 0x66021791U }, /* XSUM_XXH32_testdata[212] */
    {  106, 0x9E3779B1U, 0x48DBC967U }, /* XSUM_XXH32_testdata[213] */
    {  107, 0x00000000U, 0x4FBEEA6DU }, /* XSUM_XXH32_testdata[214] */
    {  107, 0x9E3779B1U, 0x81DFC749U }, /* XSUM_XXH32_testdata[215] */
    {  108, 0x00000000U, 0xBF6E81DAU }, /* XSUM_XXH32_testdata[216] */
    {  108, 0x9E3779B1U, 0x6552FB4CU }, /* XSUM_XXH32_testdata[217] */
    {  109, 0x00000000U, 0xAB53BD6CU }, /* XSUM_XXH32_testdata[218] */
    {  109, 0x9E3779B1U, 0x47045E87U }, /* XSUM_XXH32_testdata[219] */
    {  110, 0x00000000U, 0x80684E97U }, /* XSUM_XXH32_testdata[220] */
    {  110, 0x9E3779B1U, 0xEFD4C511U }, /* XSUM_XXH32_testdata[221] */
    {  111, 0x00000000U, 0xB2B2A43DU }, /* XSUM_XXH32_testdata[222] */
    {  111, 0x9E3779B1U, 0x7C42B0B3U }, /* XSUM_XXH32_testdata[223] */
    {  112, 0x00000000U, 0xBFD42090U }, /* XSUM_XXH32_testdata[224] */
    {  112, 0x9E3779B1U, 0xB8FED29FU }, /* XSUM_XXH32_testdata[225] */
    {  113, 0x00000000U, 0x17957E56U }, /* XSUM_XXH32_testdata[226] */
    {  113, 0x9E3779B1U, 0x1F838248U }, /* XSUM_XXH32_testdata[227] */
    {  114, 0x00000000U, 0x0825AA87U }, /* XSUM_XXH32_testdata[228] */
    {  114, 0x9E3779B1U, 0x588CD5CDU }, /* XSUM_XXH32_testdata[229] */
    {  115, 0x00000000U, 0x9A1D6116U }, /* XSUM_XXH32_testdata[230] */
    {  115, 0x9E3779B1U, 0xB39272D7U }, /* XSUM_XXH32_testdata[231] */
    {  116, 0x00000000U, 0x12A0643EU }, /* XSUM_XXH32_testdata[232] */
    {  116, 0x9E3779B1U, 0x0B1A2B23U }, /* XSUM_XXH32_testdata[233] */
    {  117, 0x00000000U, 0xB0D0F17BU }, /* XSUM_XXH32_testdata[234] */
    {  117, 0x9E3779B1U, 0x60C609A0U }, /* XSUM_XXH32_testdata[235] */
    {  118, 0x00000000U, 0xCDA9A095U }, /* XSUM_XXH32_testdata[236] */
    {  118, 0x9E3779B1U, 0xE0C95C1FU }, /* XSUM_XXH32_testdata[237] */
    {  119, 0x00000000U, 0x176D3D10U }, /* XSUM_XXH32_testdata[238] */
    {  119, 0x9E3779B1U, 0x18AF97ADU }, /* XSUM_XXH32_testdata[239] */
    {  120, 0x00000000U, 0xEAA71DC5U }, /* XSUM_XXH32_testdata[240] */
    {  120, 0x9E3779B1U, 0x820F245AU }, /* XSUM_XXH32_testdata[241] */
    {  121, 0x00000000U, 0x42171963U }, /* XSUM_XXH32_testdata[242] */
    {  121, 0x9E3779B1U, 0x7DA93D33U }, /* XSUM_XXH32_testdata[243] */
    {  122, 0x00000000U, 0x744024B1U }, /* XSUM_XXH32_testdata[244] */
    {  122, 0x9E3779B1U, 0x27D5D087U }, /* XSUM_XXH32_testdata[245] */
    {  123, 0x00000000U, 0x7A501B1DU }, /* XSUM_XXH32_testdata[246] */
    {  123, 0x9E3779B1U, 0xA90DADD0U }, /* XSUM_XXH32_testdata[247] */
    {  124, 0x00000000U, 0xEEF0D529U }, /* XSUM_XXH32_testdata[248] */
    {  124, 0x9E3779B1U, 0x7CC63F33U }, /* XSUM_XXH32_testdata[249] */
    {  125, 0x00000000U, 0x842E47E2U }, /* XSUM_XXH32_testdata[250] */
    {  125, 0x9E3779B1U, 0xF486621CU }, /* XSUM_XXH32_testdata[251] */
    {  126, 0x00000000U, 0xED06DF9FU }, /* XSUM_XXH32_testdata[252] */
    {  126, 0x9E3779B1U, 0xB2EC41E8U }, /* XSUM_XXH32_testdata[253] */
    {  127, 0x00000000U, 0x1E49F7FCU }, /* XSUM_XXH32_testdata[254] */
    {  127, 0x9E3779B1U, 0xC926CE8FU }, /* XSUM_XXH32_testdata[255] */
    {  128, 0x00000000U, 0x0FD07B71U }, /* XSUM_XXH32_testdata[256] */
    {  128, 0x9E3779B1U, 0x3BD1140EU }, /* XSUM_XXH32_testdata[257] */
    {  129, 0x00000000U, 0x68C9EC37U }, /* XSUM_XXH32_testdata[258] */
    {  129, 0x9E3779B1U, 0x2A9476A5U }, /* XSUM_XXH32_testdata[259] */
    {  130, 0x00000000U, 0x6F668C0EU }, /* XSUM_XXH32_testdata[260] */
    {  130, 0x9E3779B1U, 0x8FEA8125U }, /* XSUM_XXH32_testdata[261] */
    {  131, 0x00000000U, 0x250C2751U }, /* XSUM_XXH32_testdata[262] */
    {  131, 0x9E3779B1U, 0xE2620299U }, /* XSUM_XXH32_testdata[263] */
    {  132, 0x00000000U, 0x467FF462U }, /* XSUM_XXH32_testdata[264] */
    {  132, 0x9E3779B1U, 0x2B74691CU }, /* XSUM_XXH32_testdata[265] */
    {  133, 0x00000000U, 0x3433F9DBU }, /* XSUM_XXH32_testdata[266] */
    {  133, 0x9E3779B1U, 0xFF609B27U }, /* XSUM_XXH32_testdata[267] */
    {  134, 0x00000000U, 0x77D99961U }, /* XSUM_XXH32_testdata[268] */
    {  134, 0x9E3779B1U, 0x74391A4CU }, /* XSUM_XXH32_testdata[269] */
    {  135, 0x00000000U, 0x5F75EBB8U }, /* XSUM_XXH32_testdata[270] */
    {  135, 0x9E3779B1U, 0x91EE2559U }, /* XSUM_XXH32_testdata[271] */
    {  136, 0x00000000U, 0x28FB329FU }, /* XSUM_XXH32_testdata[272] */
    {  136, 0x9E3779B1U, 0x7448C47DU }, /* XSUM_XXH32_testdata[273] */
    {  137, 0x00000000U, 0xB70B14C2U }, /* XSUM_XXH32_testdata[274] */
    {  137, 0x9E3779B1U, 0x3C1F9CFAU }, /* XSUM_XXH32_testdata[275] */
    {  138, 0x00000000U, 0xF96CC1F5U }, /* XSUM_XXH32_testdata[276] */
    {  138, 0x9E3779B1U, 0xAD05AE47U }, /* XSUM_XXH32_testdata[277] */
    {  139, 0x00000000U, 0x226BFE7FU }, /* XSUM_XXH32_testdata[278] */
    {  139, 0x9E3779B1U, 0x26367250U }, /* XSUM_XXH32_testdata[279] */
    {  140, 0x00000000U, 0xE084C6C2U }, /* XSUM_XXH32_testdata[280] */
    {  140, 0x9E3779B1U, 0x0CB176A1U }, /* XSUM_XXH32_testdata[281] */
    {  141, 0x00000000U, 0x2BD9ACDEU }, /* XSUM_XXH32_testdata[282] */
    {  141, 0x9E3779B1U, 0x0D7330CCU }, /* XSUM_XXH32_testdata[283] */
    {  142, 0x00000000U, 0xE8491C05U }, /* XSUM_XXH32_testdata[284] */
    {  142, 0x9E3779B1U, 0xE39C9562U }, /* XSUM_XXH32_testdata[285] */
    {  143, 0x00000000U, 0x8C232E66U }, /* XSUM_XXH32_testdata[286] */
    {  143, 0x9E3779B1U, 0x0CB48D29U }, /* XSUM_XXH32_testdata[287] */
    {  144, 0x00000000U, 0x07505878U }, /* XSUM_XXH32_testdata[288] */
    {  144, 0x9E3779B1U, 0x6BA28596U }, /* XSUM_XXH32_testdata[289] */
    {  145, 0x00000000U, 0x9010ABAEU }, /* XSUM_XXH32_testdata[290] */
    {  145, 0x9E3779B1U, 0x76A5F3D8U }, /* XSUM_XXH32_testdata[291] */
    {  146, 0x00000000U, 0x6C421E2EU }, /* XSUM_XXH32_testdata[292] */
    {  146, 0x9E3779B1U, 0x81A9CA9EU }, /* XSUM_XXH32_testdata[293] */
    {  147, 0x00000000U, 0xF166561EU }, /* XSUM_XXH32_testdata[294] */
    {  147, 0x9E3779B1U, 0x9F47EC56U }, /* XSUM_XXH32_testdata[295] */
    {  148, 0x00000000U, 0xE5F95DE0U }, /* XSUM_XXH32_testdata[296] */
    {  148, 0x9E3779B1U, 0xE83F34DFU }, /* XSUM_XXH32_testdata[297] */
    {  149, 0x00000000U, 0x4B285245U }, /* XSUM_XXH32_testdata[298] */
    {  149, 0x9E3779B1U, 0x6E8BF7D1U }, /* XSUM_XXH32_testdata[299] */
    {  150, 0x00000000U, 0xAAC19EF4U }, /* XSUM_XXH32_testdata[300] */
    {  150, 0x9E3779B1U, 0xB1DA61CBU }, /* XSUM_XXH32_testdata[301] */
    {  151, 0x00000000U, 0x40BD0BF1U }, /* XSUM_XXH32_testdata[302] */
    {  151, 0x9E3779B1U, 0x1B4E44AEU }, /* XSUM_XXH32_testdata[303] */
    {  152, 0x00000000U, 0x3371B10DU }, /* XSUM_XXH32_testdata[304] */
    {  152, 0x9E3779B1U, 0x41CAA047U }, /* XSUM_XXH32_testdata[305] */
    {  153, 0x00000000U, 0x26BABAF8U }, /* XSUM_XXH32_testdata[306] */
    {  153, 0x9E3779B1U, 0x7F2C8740U }, /* XSUM_XXH32_testdata[307] */
    {  154, 0x00000000U, 0x66A6367BU }, /* XSUM_XXH32_testdata[308] */
    {  154, 0x9E3779B1U, 0x5F647E67U }, /* XSUM_XXH32_testdata[309] */
    {  155, 0x00000000U, 0x1A3170B4U }, /* XSUM_XXH32_testdata[310] */
    {  155, 0x9E3779B1U, 0x517CD1A2U }, /* XSUM_XXH32_testdata[311] */
    {  156, 0x00000000U, 0x829D9B68U }, /* XSUM_XXH32_testdata[312] */
    {  156, 0x9E3779B1U, 0x357D5E8CU }, /* XSUM_XXH32_testdata[313] */
    {  157, 0x00000000U, 0x1595DF79U }, /* XSUM_XXH32_testdata[314] */
    {  157, 0x9E3779B1U, 0x2AA95120U }, /* XSUM_XXH32_testdata[315] */
    {  158, 0x00000000U, 0xCC70600FU }, /* XSUM_XXH32_testdata[316] */
    {  158, 0x9E3779B1U, 0x2794A046U }, /* XSUM_XXH32_testdata[317] */
    {  159, 0x00000000U, 0xD0EBBC26U }, /* XSUM_XXH32_testdata[318] */
    {  159, 0x9E3779B1U, 0xA16EAAD4U }, /* XSUM_XXH32_testdata[319] */
    {  160, 0x00000000U, 0x468BAE76U }, /* XSUM_XXH32_testdata[320] */
    {  160, 0x9E3779B1U, 0xAD988AA2U }, /* XSUM_XXH32_testdata[321] */
    {  161, 0x00000000U, 0x49E4DC27U }, /* XSUM_XXH32_testdata[322] */
    {  161, 0x9E3779B1U, 0x1BD4400CU }, /* XSUM_XXH32_testdata[323] */
    {  162, 0x00000000U, 0x95E85961U }, /* XSUM_XXH32_testdata[324] */
    {  162, 0x9E3779B1U, 0xCEEB08DFU }, /* XSUM_XXH32_testdata[325] */
    {  163, 0x00000000U, 0x147A5E77U }, /* XSUM_XXH32_testdata[326] */
    {  163, 0x9E3779B1U, 0x6B876F53U }, /* XSUM_XXH32_testdata[327] */
    {  164, 0x00000000U, 0xF3D3DECDU }, /* XSUM_XXH32_testdata[328] */
    {  164, 0x9E3779B1U, 0xFD669393U }, /* XSUM_XXH32_testdata[329] */
    {  165, 0x00000000U, 0xE529B75BU }, /* XSUM_XXH32_testdata[330] */
    {  165, 0x9E3779B1U, 0x7D257F34U }, /* XSUM_XXH32_testdata[331] */
    {  166, 0x00000000U, 0x2C7251F6U }, /* XSUM_XXH32_testdata[332] */
    {  166, 0x9E3779B1U, 0x4569F86EU }, /* XSUM_XXH32_testdata[333] */
    {  167, 0x00000000U, 0x0EE0E8CCU }, /* XSUM_XXH32_testdata[334] */
    {  167, 0x9E3779B1U, 0x73C2A8EBU }, /* XSUM_XXH32_testdata[335] */
    {  168, 0x00000000U, 0xC00D25A0U }, /* XSUM_XXH32_testdata[336] */
    {  168, 0x9E3779B1U, 0xC37F2027U }, /* XSUM_XXH32_testdata[337] */
    {  169, 0x00000000U, 0x6DDDAF3DU }, /* XSUM_XXH32_testdata[338] */
    {  169, 0x9E3779B1U, 0xB8EF05AFU }, /* XSUM_XXH32_testdata[339] */
    {  170, 0x00000000U, 0xEFAAC76BU }, /* XSUM_XXH32_testdata[340] */
    {  170, 0x9E3779B1U, 0x7BD34115U }, /* XSUM_XXH32_testdata[341] */
    {  171, 0x00000000U, 0x00331D4BU }, /* XSUM_XXH32_testdata[342] */
    {  171, 0x9E3779B1U, 0xDCE4C464U }, /* XSUM_XXH32_testdata[343] */
    {  172, 0x00000000U, 0xCE08A470U }, /* XSUM_XXH32_testdata[344] */
    {  172, 0x9E3779B1U, 0x89988159U }, /* XSUM_XXH32_testdata[345] */
    {  173, 0x00000000U, 0xAC3606B0U }, /* XSUM_XXH32_testdata[346] */
    {  173, 0x9E3779B1U, 0x45BC9345U }, /* XSUM_XXH32_testdata[347] */
    {  174, 0x00000000U, 0xE38EE399U }, /* XSUM_XXH32_testdata[348] */
    {  174, 0x9E3779B1U, 0xE9DB0906U }, /* XSUM_XXH32_testdata[349] */
    {  175, 0x00000000U, 0xC3B39539U }, /* XSUM_XXH32_testdata[350] */
    {  175, 0x9E3779B1U, 0x4DA8A320U }, /* XSUM_XXH32_testdata[351] */
    {  176, 0x00000000U, 0x01C0ADB8U }, /* XSUM_XXH32_testdata[352] */
    {  176, 0x9E3779B1U, 0x63DF5EA5U }, /* XSUM_XXH32_testdata[353] */
    {  177, 0x00000000U, 0xC7CC4DDEU }, /* XSUM_XXH32_testdata[354] */
    {  177, 0x9E3779B1U, 0xB2A8BFD6U }, /* XSUM_XXH32_testdata[355] */
    {  178, 0x00000000U, 0x4D8EFD3EU }, /* XSUM_XXH32_testdata[356] */
    {  178, 0x9E3779B1U, 0x23346DEDU }, /* XSUM_XXH32_testdata[357] */
    {  179, 0x00000000U, 0xDB8C3D00U }, /* XSUM_XXH32_testdata[358] */
    {  179, 0x9E3779B1U, 0xD958AFB0U }, /* XSUM_XXH32_testdata[359] */
    {  180, 0x00000000U, 0x87630F0BU }, /* XSUM_XXH32_testdata[360] */
    {  180, 0x9E3779B1U, 0x0EF4A915U }, /* XSUM_XXH32_testdata[361] */
    {  181, 0x00000000U, 0xEA494866U }, /* XSUM_XXH32_testdata[362] */
    {  181, 0x9E3779B1U, 0x802BA360U }, /* XSUM_XXH32_testdata[363] */
    {  182, 0x00000000U, 0x974E6EC9U }, /* XSUM_XXH32_testdata[364] */
    {  182, 0x9E3779B1U, 0x16D34030U }, /* XSUM_XXH32_testdata[365] */
    {  183, 0x00000000U, 0x0852ACF7U }, /* XSUM_XXH32_testdata[366] */
    {  183, 0x9E3779B1U, 0xE5DCC283U }, /* XSUM_XXH32_testdata[367] */
    {  184, 0x00000000U, 0x72568284U }, /* XSUM_XXH32_testdata[368] */
    {  184, 0x9E3779B1U, 0x7B3EBBB5U }, /* XSUM_XXH32_testdata[369] */
    {  185, 0x00000000U, 0xE657B65DU }, /* XSUM_XXH32_testdata[370] */
    {  185, 0x9E3779B1U, 0xD14C4260U }, /* XSUM_XXH32_testdata[371] */
    {  186, 0x00000000U, 0xAA4D1F29U }, /* XSUM_XXH32_testdata[372] */
    {  186, 0x9E3779B1U, 0xB2957E22U }, /* XSUM_XXH32_testdata[373] */
    {  187, 0x00000000U, 0xEE027F29U }, /* XSUM_XXH32_testdata[374] */
    {  187, 0x9E3779B1U, 0xAF51CEECU }, /* XSUM_XXH32_testdata[375] */
    {  188, 0x00000000U, 0x881E82E7U }, /* XSUM_XXH32_testdata[376] */
    {  188, 0x9E3779B1U, 0x27197D64U }, /* XSUM_XXH32_testdata[377] */
    {  189, 0x00000000U, 0x34E829DAU }, /* XSUM_XXH32_testdata[378] */
    {  189, 0x9E3779B1U, 0xD72BB840U }, /* XSUM_XXH32_testdata[379] */
    {  190, 0x00000000U, 0x2A466969U }, /* XSUM_XXH32_testdata[380] */
    {  190, 0x9E3779B1U, 0xEA2A0159U }, /* XSUM_XXH32_testdata[381] */
    {  191, 0x00000000U, 0x1B97EE64U }, /* XSUM_XXH32_testdata[382] */
    {  191, 0x9E3779B1U, 0xDB59761CU }, /* XSUM_XXH32_testdata[383] */
    {  192, 0x00000000U, 0x40EA7C2FU }, /* XSUM_XXH32_testdata[384] */
    {  192, 0x9E3779B1U, 0x45FFCD43U }, /* XSUM_XXH32_testdata[385] */
    {  193, 0x00000000U, 0xCF7EF1BAU }, /* XSUM_XXH32_testdata[386] */
    {  193, 0x9E3779B1U, 0x972A1C6CU }, /* XSUM_XXH32_testdata[387] */
    {  194, 0x00000000U, 0xC048459EU }, /* XSUM_XXH32_testdata[388] */
    {  194, 0x9E3779B1U, 0xCEF37E3DU }, /* XSUM_XXH32_testdata[389] */
    {  195, 0x00000000U, 0x70536B96U }, /* XSUM_XXH32_testdata[390] */
    {  195, 0x9E3779B1U, 0x5637D2B9U }, /* XSUM_XXH32_testdata[391] */
    {  196, 0x00000000U, 0xB5248A61U }, /* XSUM_XXH32_testdata[392] */
    {  196, 0x9E3779B1U, 0x45B5F8CDU }, /* XSUM_XXH32_testdata[393] */
    {  197, 0x00000000U, 0x41BD629EU }, /* XSUM_XXH32_testdata[394] */
    {  197, 0x9E3779B1U, 0xE4467DAAU }, /* XSUM_XXH32_testdata[395] */
    {  198, 0x00000000U, 0x07F2D13FU }, /* XSUM_XXH32_testdata[396] */
    {  198, 0x9E3779B1U, 0xDF6B5563U }, /* XSUM_XXH32_testdata[397] */
    {  199, 0x00000000U, 0x04C1895FU }, /* XSUM_XXH32_testdata[398] */
    {  199, 0x9E3779B1U, 0x160380CDU }, /* XSUM_XXH32_testdata[399] */
    {  200, 0x00000000U, 0x21B47598U }, /* XSUM_XXH32_testdata[400] */
    {  200, 0x9E3779B1U, 0xA2CD69EDU }, /* XSUM_XXH32_testdata[401] */
    {  201, 0x00000000U, 0xFE4BCD4FU }, /* XSUM_XXH32_testdata[402] */
    {  201, 0x9E3779B1U, 0x90D46DB3U }, /* XSUM_XXH32_testdata[403] */
    {  202, 0x00000000U, 0xFEEC392CU }, /* XSUM_XXH32_testdata[404] */
    {  202, 0x9E3779B1U, 0xB2F49A0CU }, /* XSUM_XXH32_testdata[405] */
    {  203, 0x00000000U, 0x69548705U }, /* XSUM_XXH32_testdata[406] */
    {  203, 0x9E3779B1U, 0x87F156CCU }, /* XSUM_XXH32_testdata[407] */
    {  204, 0x00000000U, 0xDEA84C5FU }, /* XSUM_XXH32_testdata[408] */
    {  204, 0x9E3779B1U, 0x57A9236DU }, /* XSUM_XXH32_testdata[409] */
    {  205, 0x00000000U, 0xCB0685A3U }, /* XSUM_XXH32_testdata[410] */
    {  205, 0x9E3779B1U, 0x072BBA0BU }, /* XSUM_XXH32_testdata[411] */
    {  206, 0x00000000U, 0x010B5AF7U }, /* XSUM_XXH32_testdata[412] */
    {  206, 0x9E3779B1U, 0x606A02CAU }, /* XSUM_XXH32_testdata[413] */
    {  207, 0x00000000U, 0x45EA54DCU }, /* XSUM_XXH32_testdata[414] */
    {  207, 0x9E3779B1U, 0xD48744A0U }, /* XSUM_XXH32_testdata[415] */
    {  208, 0x00000000U, 0x7E8AAE87U }, /* XSUM_XXH32_testdata[416] */
    {  208, 0x9E3779B1U, 0x8F46A337U }, /* XSUM_XXH32_testdata[417] */
    {  209, 0x00000000U, 0xE7FC6C7DU }, /* XSUM_XXH32_testdata[418] */
    {  209, 0x9E3779B1U, 0x2F1B064EU }, /* XSUM_XXH32_testdata[419] */
    {  210, 0x00000000U, 0x96FBF40EU }, /* XSUM_XXH32_testdata[420] */
    {  210, 0x9E3779B1U, 0xBEE2100BU }, /* XSUM_XXH32_testdata[421] */
    {  211, 0x00000000U, 0xC0BE1A6DU }, /* XSUM_XXH32_testdata[422] */
    {  211, 0x9E3779B1U, 0x5E032ABCU }, /* XSUM_XXH32_testdata[423] */
    {  212, 0x00000000U, 0xA3FF15AEU }, /* XSUM_XXH32_testdata[424] */
    {  212, 0x9E3779B1U, 0xA1749364U }, /* XSUM_XXH32_testdata[425] */
    {  213, 0x00000000U, 0x46F95C4CU }, /* XSUM_XXH32_testdata[426] */
    {  213, 0x9E3779B1U, 0x03ED3FACU }, /* XSUM_XXH32_testdata[427] */
    {  214, 0x00000000U, 0x8D6C0F56U }, /* XSUM_XXH32_testdata[428] */
    {  214, 0x9E3779B1U, 0x4307C70AU }, /* XSUM_XXH32_testdata[429] */
    {  215, 0x00000000U, 0x51B02367U }, /* XSUM_XXH32_testdata[430] */
    {  215, 0x9E3779B1U, 0x0516313CU }, /* XSUM_XXH32_testdata[431] */
    {  216, 0x00000000U, 0xFD9F6A62U }, /* XSUM_XXH32_testdata[432] */
    {  216, 0x9E3779B1U, 0xFC05201EU }, /* XSUM_XXH32_testdata[433] */
    {  217, 0x00000000U, 0x8E62A788U }, /* XSUM_XXH32_testdata[434] */
    {  217, 0x9E3779B1U, 0xCE658A4EU }, /* XSUM_XXH32_testdata[435] */
    {  218, 0x00000000U, 0xEE9AE53EU }, /* XSUM_XXH32_testdata[436] */
    {  218, 0x9E3779B1U, 0x00B84CCFU }, /* XSUM_XXH32_testdata[437] */
    {  219, 0x00000000U, 0x1E43262AU }, /* XSUM_XXH32_testdata[438] */
    {  219, 0x9E3779B1U, 0xB4488BF6U }, /* XSUM_XXH32_testdata[439] */
    {  220, 0x00000000U, 0x5A6411DAU }, /* XSUM_XXH32_testdata[440] */
    {  220, 0x9E3779B1U, 0xA54EB98DU }, /* XSUM_XXH32_testdata[441] */
    {  221, 0x00000000U, 0xB158BC7BU }, /* XSUM_XXH32_testdata[442] */
    {  221, 0x9E3779B1U, 0x1F831198U }, /* XSUM_XXH32_testdata[443] */
    {  222, 0x00000000U, 0x5BD11DBDU }, /* XSUM_XXH32_testdata[444] */
    {  222, 0x9E3779B1U, 0x58803C5FU }, /* XSUM_XXH32_testdata[445] */
    {  223, 0x00000000U, 0xABBBBE2CU }, /* XSUM_XXH32_testdata[446] */
    {  223, 0x9E3779B1U, 0xFAFEF6E3U }, /* XSUM_XXH32_testdata[447] */
    {  224, 0x00000000U, 0x77996A88U }, /* XSUM_XXH32_testdata[448] */
    {  224, 0x9E3779B1U, 0xF9B4EBE5U }, /* XSUM_XXH32_testdata[449] */
    {  225, 0x00000000U, 0x58B792A6U }, /* XSUM_XXH32_testdata[450] */
    {  225, 0x9E3779B1U, 0x5F1CE2D5U }, /* XSUM_XXH32_testdata[451] */
    {  226, 0x00000000U, 0x3AA80B8FU }, /* XSUM_XXH32_testdata[452] */
    {  226, 0x9E3779B1U, 0x42BAFC0BU }, /* XSUM_XXH32_testdata[453] */
    {  227, 0x00000000U, 0xDCB4AAD3U }, /* XSUM_XXH32_testdata[454] */
    {  227, 0x9E3779B1U, 0xF51CBA0AU }, /* XSUM_XXH32_testdata[455] */
    {  228, 0x00000000U, 0xAD3652F9U }, /* XSUM_XXH32_testdata[456] */
    {  228, 0x9E3779B1U, 0xCD3FF465U }, /* XSUM_XXH32_testdata[457] */
    {  229, 0x00000000U, 0xA7E2F595U }, /* XSUM_XXH32_testdata[458] */
    {  229, 0x9E3779B1U, 0x0BBD609BU }, /* XSUM_XXH32_testdata[459] */
    {  230, 0x00000000U, 0x077419EDU }, /* XSUM_XXH32_testdata[460] */
    {  230, 0x9E3779B1U, 0xC7742FBFU }, /* XSUM_XXH32_testdata[461] */
    {  231, 0x00000000U, 0x0E6006C7U }, /* XSUM_XXH32_testdata[462] */
    {  231, 0x9E3779B1U, 0x7B7DEA5AU }, /* XSUM_XXH32_testdata[463] */
    {  232, 0x00000000U, 0x61BA51D3U }, /* XSUM_XXH32_testdata[464] */
    {  232, 0x9E3779B1U, 0x248CD26EU }, /* XSUM_XXH32_testdata[465] */
    {  233, 0x00000000U, 0xAAA4C78AU }, /* XSUM_XXH32_testdata[466] */
    {  233, 0x9E3779B1U, 0x06503C12U }, /* XSUM_XXH32_testdata[467] */
    {  234, 0x00000000U, 0x6CBD3AAFU }, /* XSUM_XXH32_testdata[468] */
    {  234, 0x9E3779B1U, 0x6968AC95U }, /* XSUM_XXH32_testdata[469] */
    {  235, 0x00000000U, 0x1FFDE8D3U }, /* XSUM_XXH32_testdata[470] */
    {  235, 0x9E3779B1U, 0x2BF5B0BCU }, /* XSUM_XXH32_testdata[471] */
    {  236, 0x00000000U, 0x0A722C4CU }, /* XSUM_XXH32_testdata[472] */
    {  236, 0x9E3779B1U, 0x3130CB0CU }, /* XSUM_XXH32_testdata[473] */
    {  237, 0x00000000U, 0x392B8349U }, /* XSUM_XXH32_testdata[474] */
    {  237, 0x9E3779B1U, 0x0C7E319DU }, /* XSUM_XXH32_testdata[475] */
    {  238, 0x00000000U, 0x5A40B925U }, /* XSUM_XXH32_testdata[476] */
    {  238, 0x9E3779B1U, 0x35D94906U }, /* XSUM_XXH32_testdata[477] */
    {  239, 0x00000000U, 0x7B84D789U }, /* XSUM_XXH32_testdata[478] */
    {  239, 0x9E3779B1U, 0x6B6ACD8DU }, /* XSUM_XXH32_testdata[479] */
    {  240, 0x00000000U, 0xFA6B6557U }, /* XSUM_XXH32_testdata[480] */
    {  240, 0x9E3779B1U, 0x55DF41D9U }, /* XSUM_XXH32_testdata[481] */
    {  241, 0x00000000U, 0xE5F7C54DU }, /* XSUM_XXH32_testdata[482] */
    {  241, 0x9E3779B1U, 0x13B52081U }, /* XSUM_XXH32_testdata[483] */
    {  242, 0x00000000U, 0xDB51CFEFU }, /* XSUM_XXH32_testdata[484] */
    {  242, 0x9E3779B1U, 0xEA71D8F1U }, /* XSUM_XXH32_testdata[485] */
    {  243, 0x00000000U, 0x1C39FE79U }, /* XSUM_XXH32_testdata[486] */
    {  243, 0x9E3779B1U, 0x09465000U }, /* XSUM_XXH32_testdata[487] */
    {  244, 0x00000000U, 0x9BA349FFU }, /* XSUM_XXH32_testdata[488] */
    {  244, 0x9E3779B1U, 0x0752C3A7U }, /* XSUM_XXH32_testdata[489] */
    {  245, 0x00000000U, 0x68006247U }, /* XSUM_XXH32_testdata[490] */
    {  245, 0x9E3779B1U, 0x6FB5D6BCU }, /* XSUM_XXH32_testdata[491] */
    {  246, 0x00000000U, 0xBD690B67U }, /* XSUM_XXH32_testdata[492] */
    {  246, 0x9E3779B1U, 0x8083E6ADU }, /* XSUM_XXH32_testdata[493] */
    {  247, 0x00000000U, 0x88E644F7U }, /* XSUM_XXH32_testdata[494] */
    {  247, 0x9E3779B1U, 0x6C439B41U }, /* XSUM_XXH32_testdata[495] */
    {  248, 0x00000000U, 0xDBD38174U }, /* XSUM_XXH32_testdata[496] */
    {  248, 0x9E3779B1U, 0xC21A4CFAU }, /* XSUM_XXH32_testdata[497] */
    {  249, 0x00000000U, 0x7A9A3922U }, /* XSUM_XXH32_testdata[498] */
    {  249, 0x9E3779B1U, 0x4AA70D45U }, /* XSUM_XXH32_testdata[499] */
    {  250, 0x00000000U, 0xDCA8BCBEU }, /* XSUM_XXH32_testdata[500] */
    {  250, 0x9E3779B1U, 0x57D86074U }, /* XSUM_XXH32_testdata[501] */
    {  251, 0x00000000U, 0x1CC7C17BU }, /* XSUM_XXH32_testdata[502] */
    {  251, 0x9E3779B1U, 0x5A960706U }, /* XSUM_XXH32_testdata[503] */
    {  252, 0x00000000U, 0x7DDAADACU }, /* XSUM_XXH32_testdata[504] */
    {  252, 0x9E3779B1U, 0xC8C004DCU }, /* XSUM_XXH32_testdata[505] */
    {  253, 0x00000000U, 0x72FD8191U }, /* XSUM_XXH32_testdata[506] */
    {  253, 0x9E3779B1U, 0x2F101B03U }, /* XSUM_XXH32_testdata[507] */
    {  254, 0x00000000U, 0x0D07F150U }, /* XSUM_XXH32_testdata[508] */
    {  254, 0x9E3779B1U, 0x21F78D0DU }, /* XSUM_XXH32_testdata[509] */
    {  255, 0x00000000U, 0xE048E445U }, /* XSUM_XXH32_testdata[510] */
    {  255, 0x9E3779B1U, 0x9A92B749U }, /* XSUM_XXH32_testdata[511] */
    {  256, 0x00000000U, 0x520CB910U }, /* XSUM_XXH32_testdata[512] */
    {  256, 0x9E3779B1U, 0x734E8A8DU }, /* XSUM_XXH32_testdata[513] */
    {  257, 0x00000000U, 0x9566588EU }, /* XSUM_XXH32_testdata[514] */
    {  257, 0x9E3779B1U, 0x4A06AC3FU }, /* XSUM_XXH32_testdata[515] */
    {  258, 0x00000000U, 0x58EFFE56U }, /* XSUM_XXH32_testdata[516] */
    {  258, 0x9E3779B1U, 0x0284D4DCU }, /* XSUM_XXH32_testdata[517] */
    {  259, 0x00000000U, 0x1F6CB68FU }, /* XSUM_XXH32_testdata[518] */
    {  259, 0x9E3779B1U, 0xC6DD38D6U }, /* XSUM_XXH32_testdata[519] */
    {  260, 0x00000000U, 0x0177FBC0U }, /* XSUM_XXH32_testdata[520] */
    {  260, 0x9E3779B1U, 0xCA9AC0CEU }, /* XSUM_XXH32_testdata[521] */
    {  261, 0x00000000U, 0x437BA246U }, /* XSUM_XXH32_testdata[522] */
    {  261, 0x9E3779B1U, 0x6424A4E4U }, /* XSUM_XXH32_testdata[523] */
    {  262, 0x00000000U, 0x7DFD15E7U }, /* XSUM_XXH32_testdata[524] */
    {  262, 0x9E3779B1U, 0x067EEDF2U }, /* XSUM_XXH32_testdata[525] */
    {  263, 0x00000000U, 0x7BFD60CEU }, /* XSUM_XXH32_testdata[526] */
    {  263, 0x9E3779B1U, 0xEDEE5E47U }, /* XSUM_XXH32_testdata[527] */
    {  264, 0x00000000U, 0x92E3EC8DU }, /* XSUM_XXH32_testdata[528] */
    {  264, 0x9E3779B1U, 0x467D0FCCU }, /* XSUM_XXH32_testdata[529] */
    {  265, 0x00000000U, 0xC9057B25U }, /* XSUM_XXH32_testdata[530] */
    {  265, 0x9E3779B1U, 0x2D4D5572U }, /* XSUM_XXH32_testdata[531] */
    {  266, 0x00000000U, 0xBF4A38C0U }, /* XSUM_XXH32_testdata[532] */
    {  266, 0x9E3779B1U, 0x6D9BC26BU }, /* XSUM_XXH32_testdata[533] */
    {  267, 0x00000000U, 0xAD9D6E04U }, /* XSUM_XXH32_testdata[534] */
    {  267, 0x9E3779B1U, 0x9D13F48EU }, /* XSUM_XXH32_testdata[535] */
    {  268, 0x00000000U, 0xE8818377U }, /* XSUM_XXH32_testdata[536] */
    {  268, 0x9E3779B1U, 0xA1ADFAB5U }, /* XSUM_XXH32_testdata[537] */
    {  269, 0x00000000U, 0x4050B828U }, /* XSUM_XXH32_testdata[538] */
    {  269, 0x9E3779B1U, 0x1F388E55U }, /* XSUM_XXH32_testdata[539] */
    {  270, 0x00000000U, 0xA5151E7EU }, /* XSUM_XXH32_testdata[540] */
    {  270, 0x9E3779B1U, 0x748B3C1FU }, /* XSUM_XXH32_testdata[541] */
    {  271, 0x00000000U, 0xBB29ABC8U }, /* XSUM_XXH32_testdata[542] */
    {  271, 0x9E3779B1U, 0x9E262EFAU }, /* XSUM_XXH32_testdata[543] */
    {  272, 0x00000000U, 0x42AB99E9U }, /* XSUM_XXH32_testdata[544] */
    {  272, 0x9E3779B1U, 0x14F2C194U }, /* XSUM_XXH32_testdata[545] */
    {  273, 0x00000000U, 0xF34DBFE3U }, /* XSUM_XXH32_testdata[546] */
    {  273, 0x9E3779B1U, 0xB212E03EU }, /* XSUM_XXH32_testdata[547] */
    {  274, 0x00000000U, 0x1988AD89U }, /* XSUM_XXH32_testdata[548] */
    {  274, 0x9E3779B1U, 0x03EEFF8CU }, /* XSUM_XXH32_testdata[549] */
    {  275, 0x00000000U, 0xAEE9CE0EU }, /* XSUM_XXH32_testdata[550] */
    {  275, 0x9E3779B1U, 0x23A4F5C0U }, /* XSUM_XXH32_testdata[551] */
    {  276, 0x00000000U, 0xD0C6849BU }, /* XSUM_XXH32_testdata[552] */
    {  276, 0x9E3779B1U, 0xADD3AB66U }, /* XSUM_XXH32_testdata[553] */
    {  277, 0x00000000U, 0x4FC91B31U }, /* XSUM_XXH32_testdata[554] */
    {  277, 0x9E3779B1U, 0xABDC0BC8U }, /* XSUM_XXH32_testdata[555] */
    {  278, 0x00000000U, 0xEDFEAB16U }, /* XSUM_XXH32_testdata[556] */
    {  278, 0x9E3779B1U, 0x24893F33U }, /* XSUM_XXH32_testdata[557] */
    {  279, 0x00000000U, 0xF6F08914U }, /* XSUM_XXH32_testdata[558] */
    {  279, 0x9E3779B1U, 0xD7F6AD57U }, /* XSUM_XXH32_testdata[559] */
    {  280, 0x00000000U, 0xF87B452FU }, /* XSUM_XXH32_testdata[560] */
    {  280, 0x9E3779B1U, 0xA9E93011U }, /* XSUM_XXH32_testdata[561] */
    {  281, 0x00000000U, 0x078401F1U }, /* XSUM_XXH32_testdata[562] */
    {  281, 0x9E3779B1U, 0x537B2015U }, /* XSUM_XXH32_testdata[563] */
    {  282, 0x00000000U, 0x4DC6BCCBU }, /* XSUM_XXH32_testdata[564] */
    {  282, 0x9E3779B1U, 0x9B22B136U }, /* XSUM_XXH32_testdata[565] */
    {  283, 0x00000000U, 0x45CCD5A9U }, /* XSUM_XXH32_testdata[566] */
    {  283, 0x9E3779B1U, 0x599DDBF5U }, /* XSUM_XXH32_testdata[567] */
    {  284, 0x00000000U, 0xF1545F6CU }, /* XSUM_XXH32_testdata[568] */
    {  284, 0x9E3779B1U, 0xD12B1BB5U }, /* XSUM_XXH32_testdata[569] */
    {  285, 0x00000000U, 0x55151707U }, /* XSUM_XXH32_testdata[570] */
    {  285, 0x9E3779B1U, 0xE4E65E93U }, /* XSUM_XXH32_testdata[571] */
    {  286, 0x00000000U, 0x4864CB10U }, /* XSUM_XXH32_testdata[572] */
    {  286, 0x9E3779B1U, 0xEB22E05EU }, /* XSUM_XXH32_testdata[573] */
    {  287, 0x00000000U, 0x71733C3CU }, /* XSUM_XXH32_testdata[574] */
    {  287, 0x9E3779B1U, 0x9D7C06B6U }, /* XSUM_XXH32_testdata[575] */
    {  288, 0x00000000U, 0x65FC8E1AU }, /* XSUM_XXH32_testdata[576] */
    {  288, 0x9E3779B1U, 0x0C7FE1DCU }, /* XSUM_XXH32_testdata[577] */
    {  289, 0x00000000U, 0x10C0CE0DU }, /* XSUM_XXH32_testdata[578] */
    {  289, 0x9E3779B1U, 0x24DF0067U }, /* XSUM_XXH32_testdata[579] */
    {  290, 0x00000000U, 0x052E2F18U }, /* XSUM_XXH32_testdata[580] */
    {  290, 0x9E3779B1U, 0xC8C18E54U }, /* XSUM_XXH32_testdata[581] */
    {  291, 0x00000000U, 0x5BC0E4A1U }, /* XSUM_XXH32_testdata[582] */
    {  291, 0x9E3779B1U, 0x6B4A2DD2U }, /* XSUM_XXH32_testdata[583] */
    {  292, 0x00000000U, 0x1A23A055U }, /* XSUM_XXH32_testdata[584] */
    {  292, 0x9E3779B1U, 0x7E5D990EU }, /* XSUM_XXH32_testdata[585] */
    {  293, 0x00000000U, 0xC61E0D0CU }, /* XSUM_XXH32_testdata[586] */
    {  293, 0x9E3779B1U, 0xF4589434U }, /* XSUM_XXH32_testdata[587] */
    {  294, 0x00000000U, 0x4C387BCEU }, /* XSUM_XXH32_testdata[588] */
    {  294, 0x9E3779B1U, 0x1B11D015U }, /* XSUM_XXH32_testdata[589] */
    {  295, 0x00000000U, 0x510F75D4U }, /* XSUM_XXH32_testdata[590] */
    {  295, 0x9E3779B1U, 0x6CB21524U }, /* XSUM_XXH32_testdata[591] */
    {  296, 0x00000000U, 0xF6BEA3C9U }, /* XSUM_XXH32_testdata[592] */
    {  296, 0x9E3779B1U, 0xC980EDEAU }, /* XSUM_XXH32_testdata[593] */
    {  297, 0x00000000U, 0x9985E9F7U }, /* XSUM_XXH32_testdata[594] */
    {  297, 0x9E3779B1U, 0x6202CEA4U }, /* XSUM_XXH32_testdata[595] */
    {  298, 0x00000000U, 0x846241BEU }, /* XSUM_XXH32_testdata[596] */
    {  298, 0x9E3779B1U, 0xD6270150U }, /* XSUM_XXH32_testdata[597] */
    {  299, 0x00000000U, 0xCF8AE62AU }, /* XSUM_XXH32_testdata[598] */
    {  299, 0x9E3779B1U, 0xA113A485U }, /* XSUM_XXH32_testdata[599] */
    {  300, 0x00000000U, 0xEC9EA372U }, /* XSUM_XXH32_testdata[600] */
    {  300, 0x9E3779B1U, 0x3715A8EDU }, /* XSUM_XXH32_testdata[601] */
    {  301, 0x00000000U, 0x94D2F234U }, /* XSUM_XXH32_testdata[602] */
    {  301, 0x9E3779B1U, 0xA2C6BCB3U }, /* XSUM_XXH32_testdata[603] */
    {  302, 0x00000000U, 0xC39BF654U }, /* XSUM_XXH32_testdata[604] */
    {  302, 0x9E3779B1U, 0x326D48D3U }, /* XSUM_XXH32_testdata[605] */
    {  303, 0x00000000U, 0xFA12C6C5U }, /* XSUM_XXH32_testdata[606] */
    {  303, 0x9E3779B1U, 0x1A29A870U }, /* XSUM_XXH32_testdata[607] */
    {  304, 0x00000000U, 0xE7065CF3U }, /* XSUM_XXH32_testdata[608] */
    {  304, 0x9E3779B1U, 0xEBF7E110U }, /* XSUM_XXH32_testdata[609] */
    {  305, 0x00000000U, 0x1CBFCB1DU }, /* XSUM_XXH32_testdata[610] */
    {  305, 0x9E3779B1U, 0xADE0F9DDU }, /* XSUM_XXH32_testdata[611] */
    {  306, 0x00000000U, 0xBA26761FU }, /* XSUM_XXH32_testdata[612] */
    {  306, 0x9E3779B1U, 0x4FBDDDF2U }, /* XSUM_XXH32_testdata[613] */
    {  307, 0x00000000U, 0xE5E8634BU }, /* XSUM_XXH32_testdata[614] */
    {  307, 0x9E3779B1U, 0x6CBB8159U }, /* XSUM_XXH32_testdata[615] */
    {  308, 0x00000000U, 0xCFFE7DC2U }, /* XSUM_XXH32_testdata[616] */
    {  308, 0x9E3779B1U, 0x92A11674U }, /* XSUM_XXH32_testdata[617] */
    {  309, 0x00000000U, 0x2B58D124U }, /* XSUM_XXH32_testdata[618] */
    {  309, 0x9E3779B1U, 0x48AAAEE0U }, /* XSUM_XXH32_testdata[619] */
    {  310, 0x00000000U, 0xD18C8493U }, /* XSUM_XXH32_testdata[620] */
    {  310, 0x9E3779B1U, 0x1317A5AAU }, /* XSUM_XXH32_testdata[621] */
    {  311, 0x00000000U, 0x8EF639B9U }, /* XSUM_XXH32_testdata[622] */
    {  311, 0x9E3779B1U, 0x4A7CC97FU }, /* XSUM_XXH32_testdata[623] */
    {  312, 0x00000000U, 0x3DBFE4F9U }, /* XSUM_XXH32_testdata[624] */
    {  312, 0x9E3779B1U, 0xAF633803U }, /* XSUM_XXH32_testdata[625] */
    {  313, 0x00000000U, 0x51DFDAC5U }, /* XSUM_XXH32_testdata[626] */
    {  313, 0x9E3779B1U, 0x9BE6E6E2U }, /* XSUM_XXH32_testdata[627] */
    {  314, 0x00000000U, 0x1B519B9BU }, /* XSUM_XXH32_testdata[628] */
    {  314, 0x9E3779B1U, 0x5C65F410U }, /* XSUM_XXH32_testdata[629] */
    {  315, 0x00000000U, 0x48404B91U }, /* XSUM_XXH32_testdata[630] */
    {  315, 0x9E3779B1U, 0x93E7D7E5U }, /* XSUM_XXH32_testdata[631] */
    {  316, 0x00000000U, 0xB1544BECU }, /* XSUM_XXH32_testdata[632] */
    {  316, 0x9E3779B1U, 0xCC7A607DU }, /* XSUM_XXH32_testdata[633] */
    {  317, 0x00000000U, 0x6AA52990U }, /* XSUM_XXH32_testdata[634] */
    {  317, 0x9E3779B1U, 0xEB8D1460U }, /* XSUM_XXH32_testdata[635] */
    {  318, 0x00000000U, 0xB4727934U }, /* XSUM_XXH32_testdata[636] */
    {  318, 0x9E3779B1U, 0x105DBBF1U }, /* XSUM_XXH32_testdata[637] */
    {  319, 0x00000000U, 0x6A4013B2U }, /* XSUM_XXH32_testdata[638] */
    {  319, 0x9E3779B1U, 0x35D6E00BU }, /* XSUM_XXH32_testdata[639] */
    {  320, 0x00000000U, 0x49D521A8U }, /* XSUM_XXH32_testdata[640] */
    {  320, 0x9E3779B1U, 0x2D187FE0U }, /* XSUM_XXH32_testdata[641] */
    {  321, 0x00000000U, 0x3B5AB7A6U }, /* XSUM_XXH32_testdata[642] */
    {  321, 0x9E3779B1U, 0x2C2DA227U }, /* XSUM_XXH32_testdata[643] */
    {  322, 0x00000000U, 0x67551411U }, /* XSUM_XXH32_testdata[644] */
    {  322, 0x9E3779B1U, 0xB2F00616U }, /* XSUM_XXH32_testdata[645] */
    {  323, 0x00000000U, 0xFD5DEC59U }, /* XSUM_XXH32_testdata[646] */
    {  323, 0x9E3779B1U, 0x8A31C568U }, /* XSUM_XXH32_testdata[647] */
    {  324, 0x00000000U, 0x3F132747U }, /* XSUM_XXH32_testdata[648] */
    {  324, 0x9E3779B1U, 0x76587E1FU }, /* XSUM_XXH32_testdata[649] */
    {  325, 0x00000000U, 0xEEFDDEB3U }, /* XSUM_XXH32_testdata[650] */
    {  325, 0x9E3779B1U, 0x8ECB0743U }, /* XSUM_XXH32_testdata[651] */
    {  326, 0x00000000U, 0x45608CD3U }, /* XSUM_XXH32_testdata[652] */
    {  326, 0x9E3779B1U, 0xE5BC60C0U }, /* XSUM_XXH32_testdata[653] */
    {  327, 0x00000000U, 0xF6525A8EU }, /* XSUM_XXH32_testdata[654] */
    {  327, 0x9E3779B1U, 0x73E65050U }, /* XSUM_XXH32_testdata[655] */
    {  328, 0x00000000U, 0xD04FADF7U }, /* XSUM_XXH32_testdata[656] */
    {  328, 0x9E3779B1U, 0x2DA359EDU }, /* XSUM_XXH32_testdata[657] */
    {  329, 0x00000000U, 0x9B67E7C9U }, /* XSUM_XXH32_testdata[658] */
    {  329, 0x9E3779B1U, 0xFBB252BEU }, /* XSUM_XXH32_testdata[659] */
    {  330, 0x00000000U, 0xA4C77DFEU }, /* XSUM_XXH32_testdata[660] */
    {  330, 0x9E3779B1U, 0xA6A3DBD0U }, /* XSUM_XXH32_testdata[661] */
    {  331, 0x00000000U, 0x1BDC8DACU }, /* XSUM_XXH32_testdata[662] */
    {  331, 0x9E3779B1U, 0xDCA45209U }, /* XSUM_XXH32_testdata[663] */
    {  332, 0x00000000U, 0xB9AA8A58U }, /* XSUM_XXH32_testdata[664] */
    {  332, 0x9E3779B1U, 0x2A50940AU }, /* XSUM_XXH32_testdata[665] */
    {  333, 0x00000000U, 0xABD700B2U }, /* XSUM_XXH32_testdata[666] */
    {  333, 0x9E3779B1U, 0x2D3B5B12U }, /* XSUM_XXH32_testdata[667] */
    {  334, 0x00000000U, 0x602228A2U }, /* XSUM_XXH32_testdata[668] */
    {  334, 0x9E3779B1U, 0xFE23801EU }, /* XSUM_XXH32_testdata[669] */
    {  335, 0x00000000U, 0xE6806E19U }, /* XSUM_XXH32_testdata[670] */
    {  335, 0x9E3779B1U, 0x133CD99CU }, /* XSUM_XXH32_testdata[671] */
    {  336, 0x00000000U, 0x8A2CC656U }, /* XSUM_XXH32_testdata[672] */
    {  336, 0x9E3779B1U, 0x4732A952U }, /* XSUM_XXH32_testdata[673] */
    {  337, 0x00000000U, 0xCB430B24U }, /* XSUM_XXH32_testdata[674] */
    {  337, 0x9E3779B1U, 0x6EDB7F8BU }, /* XSUM_XXH32_testdata[675] */
    {  338, 0x00000000U, 0x7E23FA9BU }, /* XSUM_XXH32_testdata[676] */
    {  338, 0x9E3779B1U, 0x9F4999B8U }, /* XSUM_XXH32_testdata[677] */
    {  339, 0x00000000U, 0xFEA69FF3U }, /* XSUM_XXH32_testdata[678] */
    {  339, 0x9E3779B1U, 0xFE349AB8U }, /* XSUM_XXH32_testdata[679] */
    {  340, 0x00000000U, 0xA3E9BCB4U }, /* XSUM_XXH32_testdata[680] */
    {  340, 0x9E3779B1U, 0x6B9FF0B9U }, /* XSUM_XXH32_testdata[681] */
    {  341, 0x00000000U, 0xC76AB0B1U }, /* XSUM_XXH32_testdata[682] */
    {  341, 0x9E3779B1U, 0xB518A754U }, /* XSUM_XXH32_testdata[683] */
    {  342, 0x00000000U, 0xC53F6198U }, /* XSUM_XXH32_testdata[684] */
    {  342, 0x9E3779B1U, 0x3AF65171U }, /* XSUM_XXH32_testdata[685] */
    {  343, 0x00000000U, 0x3CE265B5U }, /* XSUM_XXH32_testdata[686] */
    {  343, 0x9E3779B1U, 0x26BA7450U }, /* XSUM_XXH32_testdata[687] */
    {  344, 0x00000000U, 0xE8E20ACEU }, /* XSUM_XXH32_testdata[688] */
    {  344, 0x9E3779B1U, 0xFDF720D1U }, /* XSUM_XXH32_testdata[689] */
    {  345, 0x00000000U, 0x80E40F24U }, /* XSUM_XXH32_testdata[690] */
    {  345, 0x9E3779B1U, 0xE0C03B0DU }, /* XSUM_XXH32_testdata[691] */
    {  346, 0x00000000U, 0x4B108213U }, /* XSUM_XXH32_testdata[692] */
    {  346, 0x9E3779B1U, 0x41A07629U }, /* XSUM_XXH32_testdata[693] */
    {  347, 0x00000000U, 0xAB337557U }, /* XSUM_XXH32_testdata[694] */
    {  347, 0x9E3779B1U, 0x9C945052U }, /* XSUM_XXH32_testdata[695] */
    {  348, 0x00000000U, 0x712F7232U }, /* XSUM_XXH32_testdata[696] */
    {  348, 0x9E3779B1U, 0xEB74617CU }, /* XSUM_XXH32_testdata[697] */
    {  349, 0x00000000U, 0xB57F971FU }, /* XSUM_XXH32_testdata[698] */
    {  349, 0x9E3779B1U, 0xC4BF19C5U }, /* XSUM_XXH32_testdata[699] */
    {  350, 0x00000000U, 0xF7D8DEDEU }, /* XSUM_XXH32_testdata[700] */
    {  350, 0x9E3779B1U, 0x61A8BC19U }, /* XSUM_XXH32_testdata[701] */
    {  351, 0x00000000U, 0x7C7F64BDU }, /* XSUM_XXH32_testdata[702] */
    {  351, 0x9E3779B1U, 0x76556F07U }, /* XSUM_XXH32_testdata[703] */
    {  352, 0x00000000U, 0x0A6A2125U }, /* XSUM_XXH32_testdata[704] */
    {  352, 0x9E3779B1U, 0x8378198AU }, /* XSUM_XXH32_testdata[705] */
    {  353, 0x00000000U, 0x33C0055AU }, /* XSUM_XXH32_testdata[706] */
    {  353, 0x9E3779B1U, 0xD31544F6U }, /* XSUM_XXH32_testdata[707] */
    {  354, 0x00000000U, 0x35A00295U }, /* XSUM_XXH32_testdata[708] */
    {  354, 0x9E3779B1U, 0xB29C8615U }, /* XSUM_XXH32_testdata[709] */
    {  355, 0x00000000U, 0x74FF6311U }, /* XSUM_XXH32_testdata[710] */
    {  355, 0x9E3779B1U, 0xB9AE081CU }, /* XSUM_XXH32_testdata[711] */
    {  356, 0x00000000U, 0xC86E7A0CU }, /* XSUM_XXH32_testdata[712] */
    {  356, 0x9E3779B1U, 0x63EC2C92U }, /* XSUM_XXH32_testdata[713] */
    {  357, 0x00000000U, 0x9D6FAB85U }, /* XSUM_XXH32_testdata[714] */
    {  357, 0x9E3779B1U, 0x0279C7ABU }, /* XSUM_XXH32_testdata[715] */
    {  358, 0x00000000U, 0x17E5E33EU }, /* XSUM_XXH32_testdata[716] */
    {  358, 0x9E3779B1U, 0xB3604FDFU }, /* XSUM_XXH32_testdata[717] */
    {  359, 0x00000000U, 0x3386545EU }, /* XSUM_XXH32_testdata[718] */
    {  359, 0x9E3779B1U, 0x366CBB5CU }, /* XSUM_XXH32_testdata[719] */
    {  360, 0x00000000U, 0xC61A7338U }, /* XSUM_XXH32_testdata[720] */
    {  360, 0x9E3779B1U, 0x4AF57A44U }, /* XSUM_XXH32_testdata[721] */
    {  361, 0x00000000U, 0x43F1AF2AU }, /* XSUM_XXH32_testdata[722] */
    {  361, 0x9E3779B1U, 0xB8DC3EB8U }, /* XSUM_XXH32_testdata[723] */
    {  362, 0x00000000U, 0x486B7D18U }, /* XSUM_XXH32_testdata[724] */
    {  362, 0x9E3779B1U, 0x824748A0U }, /* XSUM_XXH32_testdata[725] */
    {  363, 0x00000000U, 0x3A5BF026U }, /* XSUM_XXH32_testdata[726] */
    {  363, 0x9E3779B1U, 0x25BF3D9AU }, /* XSUM_XXH32_testdata[727] */
    {  364, 0x00000000U, 0xC7C1FA0AU }, /* XSUM_XXH32_testdata[728] */
    {  364, 0x9E3779B1U, 0xBDEDD6EEU }, /* XSUM_XXH32_testdata[729] */
    {  365, 0x00000000U, 0x19A7CDDFU }, /* XSUM_XXH32_testdata[730] */
    {  365, 0x9E3779B1U, 0x042C940AU }, /* XSUM_XXH32_testdata[731] */
    {  366, 0x00000000U, 0x3581C349U }, /* XSUM_XXH32_testdata[732] */
    {  366, 0x9E3779B1U, 0xC5F48B19U }, /* XSUM_XXH32_testdata[733] */
    {  367, 0x00000000U, 0x280BC93FU }, /* XSUM_XXH32_testdata[734] */
    {  367, 0x9E3779B1U, 0x8030A20BU }, /* XSUM_XXH32_testdata[735] */
    {  368, 0x00000000U, 0xBC95D911U }, /* XSUM_XXH32_testdata[736] */
    {  368, 0x9E3779B1U, 0x374BEB53U }, /* XSUM_XXH32_testdata[737] */
    {  369, 0x00000000U, 0x9F3068D0U }, /* XSUM_XXH32_testdata[738] */
    {  369, 0x9E3779B1U, 0x65458A66U }, /* XSUM_XXH32_testdata[739] */
    {  370, 0x00000000U, 0x6F8EADAEU }, /* XSUM_XXH32_testdata[740] */
    {  370, 0x9E3779B1U, 0xFE1D6768U }, /* XSUM_XXH32_testdata[741] */
    {  371, 0x00000000U, 0x3E36A074U }, /* XSUM_XXH32_testdata[742] */
    {  371, 0x9E3779B1U, 0x2D3887B0U }, /* XSUM_XXH32_testdata[743] */
    {  372, 0x00000000U, 0x12C2A151U }, /* XSUM_XXH32_testdata[744] */
    {  372, 0x9E3779B1U, 0x051647D3U }, /* XSUM_XXH32_testdata[745] */
    {  373, 0x00000000U, 0x27BF5245U }, /* XSUM_XXH32_testdata[746] */
    {  373, 0x9E3779B1U, 0xA67650A5U }, /* XSUM_XXH32_testdata[747] */
    {  374, 0x00000000U, 0x0BEF5B6AU }, /* XSUM_XXH32_testdata[748] */
    {  374, 0x9E3779B1U, 0xAE3E4EEFU }, /* XSUM_XXH32_testdata[749] */
    {  375, 0x00000000U, 0x599E4F08U }, /* XSUM_XXH32_testdata[750] */
    {  375, 0x9E3779B1U, 0xA5998BA7U }, /* XSUM_XXH32_testdata[751] */
    {  376, 0x00000000U, 0x36609F25U }, /* XSUM_XXH32_testdata[752] */
    {  376, 0x9E3779B1U, 0x42604EA1U }, /* XSUM_XXH32_testdata[753] */
    {  377, 0x00000000U, 0xE7B39A2FU }, /* XSUM_XXH32_testdata[754] */
    {  377, 0x9E3779B1U, 0x697661E0U }, /* XSUM_XXH32_testdata[755] */
    {  378, 0x00000000U, 0xE7509987U }, /* XSUM_XXH32_testdata[756] */
    {  378, 0x9E3779B1U, 0x85F246DCU }, /* XSUM_XXH32_testdata[757] */
    {  379, 0x00000000U, 0x48B7E112U }, /* XSUM_XXH32_testdata[758] */
    {  379, 0x9E3779B1U, 0x7480F47DU }, /* XSUM_XXH32_testdata[759] */
    {  380, 0x00000000U, 0xCA811579U }, /* XSUM_XXH32_testdata[760] */
    {  380, 0x9E3779B1U, 0x1E9F7D79U }, /* XSUM_XXH32_testdata[761] */
    {  381, 0x00000000U, 0xF8DE86DDU }, /* XSUM_XXH32_testdata[762] */
    {  381, 0x9E3779B1U, 0xF4B4B8D7U }, /* XSUM_XXH32_testdata[763] */
    {  382, 0x00000000U, 0xC8263BE0U }, /* XSUM_XXH32_testdata[764] */
    {  382, 0x9E3779B1U, 0xBABF4799U }, /* XSUM_XXH32_testdata[765] */
    {  383, 0x00000000U, 0xEC62F99DU }, /* XSUM_XXH32_testdata[766] */
    {  383, 0x9E3779B1U, 0x042733CCU }, /* XSUM_XXH32_testdata[767] */
    {  384, 0x00000000U, 0x331E1EE8U }, /* XSUM_XXH32_testdata[768] */
    {  384, 0x9E3779B1U, 0xEDB1100CU }, /* XSUM_XXH32_testdata[769] */
    {  385, 0x00000000U, 0xEE508486U }, /* XSUM_XXH32_testdata[770] */
    {  385, 0x9E3779B1U, 0x6ECCA303U }, /* XSUM_XXH32_testdata[771] */
    {  386, 0x00000000U, 0xEB4A5B0AU }, /* XSUM_XXH32_testdata[772] */
    {  386, 0x9E3779B1U, 0x97D933C9U }, /* XSUM_XXH32_testdata[773] */
    {  387, 0x00000000U, 0x3104541CU }, /* XSUM_XXH32_testdata[774] */
    {  387, 0x9E3779B1U, 0xA5D8A58BU }, /* XSUM_XXH32_testdata[775] */
    {  388, 0x00000000U, 0x4E969069U }, /* XSUM_XXH32_testdata[776] */
    {  388, 0x9E3779B1U, 0x111C7F65U }, /* XSUM_XXH32_testdata[777] */
    {  389, 0x00000000U, 0x014B7E47U }, /* XSUM_XXH32_testdata[778] */
    {  389, 0x9E3779B1U, 0x475107DCU }, /* XSUM_XXH32_testdata[779] */
    {  390, 0x00000000U, 0x643A23B8U }, /* XSUM_XXH32_testdata[780] */
    {  390, 0x9E3779B1U, 0xCEF1A493U }, /* XSUM_XXH32_testdata[781] */
    {  391, 0x00000000U, 0xBB874C44U }, /* XSUM_XXH32_testdata[782] */
    {  391, 0x9E3779B1U, 0x5965F7E0U }, /* XSUM_XXH32_testdata[783] */
    {  392, 0x00000000U, 0x3223BC1BU }, /* XSUM_XXH32_testdata[784] */
    {  392, 0x9E3779B1U, 0xFCC9F419U }, /* XSUM_XXH32_testdata[785] */
    {  393, 0x00000000U, 0x0B32747CU }, /* XSUM_XXH32_testdata[786] */
    {  393, 0x9E3779B1U, 0x4D51E1A1U }, /* XSUM_XXH32_testdata[787] */
    {  394, 0x00000000U, 0x0D6B374AU }, /* XSUM_XXH32_testdata[788] */
    {  394, 0x9E3779B1U, 0x907A9B49U }, /* XSUM_XXH32_testdata[789] */
    {  395, 0x00000000U, 0xE2BD516EU }, /* XSUM_XXH32_testdata[790] */
    {  395, 0x9E3779B1U, 0xECB4F843U }, /* XSUM_XXH32_testdata[791] */
    {  396, 0x00000000U, 0xC65D7F81U }, /* XSUM_XXH32_testdata[792] */
    {  396, 0x9E3779B1U, 0xEEA47B8FU }, /* XSUM_XXH32_testdata[793] */
    {  397, 0x00000000U, 0x619EB9A8U }, /* XSUM_XXH32_testdata[794] */
    {  397, 0x9E3779B1U, 0x14B06F84U }, /* XSUM_XXH32_testdata[795] */
    {  398, 0x00000000U, 0xD7735CAFU }, /* XSUM_XXH32_testdata[796] */
    {  398, 0x9E3779B1U, 0x4C09296AU }, /* XSUM_XXH32_testdata[797] */
    {  399, 0x00000000U, 0xF62123A8U }, /* XSUM_XXH32_testdata[798] */
    {  399, 0x9E3779B1U, 0x6743524FU }, /* XSUM_XXH32_testdata[799] */
    {  400, 0x00000000U, 0x3B64DD3FU }, /* XSUM_XXH32_testdata[800] */
    {  400, 0x9E3779B1U, 0x3B929C82U }, /* XSUM_XXH32_testdata[801] */
    {  401, 0x00000000U, 0x9F142B89U }, /* XSUM_XXH32_testdata[802] */
    {  401, 0x9E3779B1U, 0xE4073DAAU }, /* XSUM_XXH32_testdata[803] */
    {  402, 0x00000000U, 0xBC88BE0CU }, /* XSUM_XXH32_testdata[804] */
    {  402, 0x9E3779B1U, 0x0F66FD8DU }, /* XSUM_XXH32_testdata[805] */
    {  403, 0x00000000U, 0x6675FF5AU }, /* XSUM_XXH32_testdata[806] */
    {  403, 0x9E3779B1U, 0xBDE7AAB8U }, /* XSUM_XXH32_testdata[807] */
    {  404, 0x00000000U, 0x9D206630U }, /* XSUM_XXH32_testdata[808] */
    {  404, 0x9E3779B1U, 0xC1D77C42U }, /* XSUM_XXH32_testdata[809] */
    {  405, 0x00000000U, 0xEE14FA6FU }, /* XSUM_XXH32_testdata[810] */
    {  405, 0x9E3779B1U, 0x5BF87816U }, /* XSUM_XXH32_testdata[811] */
    {  406, 0x00000000U, 0x4388EF50U }, /* XSUM_XXH32_testdata[812] */
    {  406, 0x9E3779B1U, 0x8FEAFDACU }, /* XSUM_XXH32_testdata[813] */
    {  407, 0x00000000U, 0xACC118FEU }, /* XSUM_XXH32_testdata[814] */
    {  407, 0x9E3779B1U, 0x9E582945U }, /* XSUM_XXH32_testdata[815] */
    {  408, 0x00000000U, 0xF48A158DU }, /* XSUM_XXH32_testdata[816] */
    {  408, 0x9E3779B1U, 0xDB6ABD2EU }, /* XSUM_XXH32_testdata[817] */
    {  409, 0x00000000U, 0xAB172472U }, /* XSUM_XXH32_testdata[818] */
    {  409, 0x9E3779B1U, 0x3EF39FA7U }, /* XSUM_XXH32_testdata[819] */
    {  410, 0x00000000U, 0x308A5996U }, /* XSUM_XXH32_testdata[820] */
    {  410, 0x9E3779B1U, 0xDF58D30DU }, /* XSUM_XXH32_testdata[821] */
    {  411, 0x00000000U, 0x8E6632CCU }, /* XSUM_XXH32_testdata[822] */
    {  411, 0x9E3779B1U, 0x53D2AC13U }, /* XSUM_XXH32_testdata[823] */
    {  412, 0x00000000U, 0xF490CD0AU }, /* XSUM_XXH32_testdata[824] */
    {  412, 0x9E3779B1U, 0x0FCE7F43U }, /* XSUM_XXH32_testdata[825] */
    {  413, 0x00000000U, 0x7E9F0399U }, /* XSUM_XXH32_testdata[826] */
    {  413, 0x9E3779B1U, 0x21014515U }, /* XSUM_XXH32_testdata[827] */
    {  414, 0x00000000U, 0x859E5F00U }, /* XSUM_XXH32_testdata[828] */
    {  414, 0x9E3779B1U, 0x686DF7E3U }, /* XSUM_XXH32_testdata[829] */
    {  415, 0x00000000U, 0xE1E7F4E5U }, /* XSUM_XXH32_testdata[830] */
    {  415, 0x9E3779B1U, 0xD821669EU }, /* XSUM_XXH32_testdata[831] */
    {  416, 0x00000000U, 0x8E71476EU }, /* XSUM_XXH32_testdata[832] */
    {  416, 0x9E3779B1U, 0x3C03901EU }, /* XSUM_XXH32_testdata[833] */
    {  417, 0x00000000U, 0x9F24CA04U }, /* XSUM_XXH32_testdata[834] */
    {  417, 0x9E3779B1U, 0x2F51519CU }, /* XSUM_XXH32_testdata[835] */
    {  418, 0x00000000U, 0xDC70F04CU }, /* XSUM_XXH32_testdata[836] */
    {  418, 0x9E3779B1U, 0x8F28D8E8U }, /* XSUM_XXH32_testdata[837] */
    {  419, 0x00000000U, 0x214BD5BDU }, /* XSUM_XXH32_testdata[838] */
    {  419, 0x9E3779B1U, 0x1B23494CU }, /* XSUM_XXH32_testdata[839] */
    {  420, 0x00000000U, 0x7F7E0759U }, /* XSUM_XXH32_testdata[840] */
    {  420, 0x9E3779B1U, 0x825F8A94U }, /* XSUM_XXH32_testdata[841] */
    {  421, 0x00000000U, 0xB23F1C90U }, /* XSUM_XXH32_testdata[842] */
    {  421, 0x9E3779B1U, 0x2F551E69U }, /* XSUM_XXH32_testdata[843] */
    {  422, 0x00000000U, 0xE81A4E34U }, /* XSUM_XXH32_testdata[844] */
    {  422, 0x9E3779B1U, 0xEBBE70E4U }, /* XSUM_XXH32_testdata[845] */
    {  423, 0x00000000U, 0x4AAE47A6U }, /* XSUM_XXH32_testdata[846] */
    {  423, 0x9E3779B1U, 0xAC4140ABU }, /* XSUM_XXH32_testdata[847] */
    {  424, 0x00000000U, 0xFD906A48U }, /* XSUM_XXH32_testdata[848] */
    {  424, 0x9E3779B1U, 0x6A88714BU }, /* XSUM_XXH32_testdata[849] */
    {  425, 0x00000000U, 0x7570F9CEU }, /* XSUM_XXH32_testdata[850] */
    {  425, 0x9E3779B1U, 0xFB986106U }, /* XSUM_XXH32_testdata[851] */
    {  426, 0x00000000U, 0xEBD5D72BU }, /* XSUM_XXH32_testdata[852] */
    {  426, 0x9E3779B1U, 0xBECD7793U }, /* XSUM_XXH32_testdata[853] */
    {  427, 0x00000000U, 0x6C04F6E8U }, /* XSUM_XXH32_testdata[854] */
    {  427, 0x9E3779B1U, 0xCC887616U }, /* XSUM_XXH32_testdata[855] */
    {  428, 0x00000000U, 0x6514CD26U }, /* XSUM_XXH32_testdata[856] */
    {  428, 0x9E3779B1U, 0x41F71FC5U }, /* XSUM_XXH32_testdata[857] */
    {  429, 0x00000000U, 0xA287F178U }, /* XSUM_XXH32_testdata[858] */
    {  429, 0x9E3779B1U, 0xA1536EDFU }, /* XSUM_XXH32_testdata[859] */
    {  430, 0x00000000U, 0x62B099D8U }, /* XSUM_XXH32_testdata[860] */
    {  430, 0x9E3779B1U, 0x5C5504C2U }, /* XSUM_XXH32_testdata[861] */
    {  431, 0x00000000U, 0x1F6DC602U }, /* XSUM_XXH32_testdata[862] */
    {  431, 0x9E3779B1U, 0x5AE9F727U }, /* XSUM_XXH32_testdata[863] */
    {  432, 0x00000000U, 0xF248875CU }, /* XSUM_XXH32_testdata[864] */
    {  432, 0x9E3779B1U, 0x74099376U }, /* XSUM_XXH32_testdata[865] */
    {  433, 0x00000000U, 0x5590F9BAU }, /* XSUM_XXH32_testdata[866] */
    {  433, 0x9E3779B1U, 0x5ECB00D4U }, /* XSUM_XXH32_testdata[867] */
    {  434, 0x00000000U, 0x2021D0DDU }, /* XSUM_XXH32_testdata[868] */
    {  434, 0x9E3779B1U, 0x4EFAF456U }, /* XSUM_XXH32_testdata[869] */
    {  435, 0x00000000U, 0x0EACB2AAU }, /* XSUM_XXH32_testdata[870] */
    {  435, 0x9E3779B1U, 0xC5637245U }, /* XSUM_XXH32_testdata[871] */
    {  436, 0x00000000U, 0xCE6D872CU }, /* XSUM_XXH32_testdata[872] */
    {  436, 0x9E3779B1U, 0x1C276456U }, /* XSUM_XXH32_testdata[873] */
    {  437, 0x00000000U, 0x8F82A80FU }, /* XSUM_XXH32_testdata[874] */
    {  437, 0x9E3779B1U, 0x7029494BU }, /* XSUM_XXH32_testdata[875] */
    {  438, 0x00000000U, 0x4E427015U }, /* XSUM_XXH32_testdata[876] */
    {  438, 0x9E3779B1U, 0x368A39D9U }, /* XSUM_XXH32_testdata[877] */
    {  439, 0x00000000U, 0x245B6031U }, /* XSUM_XXH32_testdata[878] */
    {  439, 0x9E3779B1U, 0x80B0B122U }, /* XSUM_XXH32_testdata[879] */
    {  440, 0x00000000U, 0xAD5AFF03U }, /* XSUM_XXH32_testdata[880] */
    {  440, 0x9E3779B1U, 0xF3BC5BC5U }, /* XSUM_XXH32_testdata[881] */
    {  441, 0x00000000U, 0xCD89EA32U }, /* XSUM_XXH32_testdata[882] */
    {  441, 0x9E3779B1U, 0x5BE88559U }, /* XSUM_XXH32_testdata[883] */
    {  442, 0x00000000U, 0x57F22820U }, /* XSUM_XXH32_testdata[884] */
    {  442, 0x9E3779B1U, 0x6C60E5F3U }, /* XSUM_XXH32_testdata[885] */
    {  443, 0x00000000U, 0xB2C31C2CU }, /* XSUM_XXH32_testdata[886] */
    {  443, 0x9E3779B1U, 0xC13DF407U }, /* XSUM_XXH32_testdata[887] */
    {  444, 0x00000000U, 0x8D863D75U }, /* XSUM_XXH32_testdata[888] */
    {  444, 0x9E3779B1U, 0xC2102CEFU }, /* XSUM_XXH32_testdata[889] */
    {  445, 0x00000000U, 0x00D80351U }, /* XSUM_XXH32_testdata[890] */
    {  445, 0x9E3779B1U, 0x7A5AA759U }, /* XSUM_XXH32_testdata[891] */
    {  446, 0x00000000U, 0x6F884EE2U }, /* XSUM_XXH32_testdata[892] */
    {  446, 0x9E3779B1U, 0x093D3AFBU }, /* XSUM_XXH32_testdata[893] */
    {  447, 0x00000000U, 0xDE51F8A6U }, /* XSUM_XXH32_testdata[894] */
    {  447, 0x9E3779B1U, 0x05C1C15BU }, /* XSUM_XXH32_testdata[895] */
    {  448, 0x00000000U, 0x432830F5U }, /* XSUM_XXH32_testdata[896] */
    {  448, 0x9E3779B1U, 0xC6AECF11U }, /* XSUM_XXH32_testdata[897] */
    {  449, 0x00000000U, 0x26F802C7U }, /* XSUM_XXH32_testdata[898] */
    {  449, 0x9E3779B1U, 0xCE969CDBU }, /* XSUM_XXH32_testdata[899] */
    {  450, 0x00000000U, 0x38E984BEU }, /* XSUM_XXH32_testdata[900] */
    {  450, 0x9E3779B1U, 0xE120F08AU }, /* XSUM_XXH32_testdata[901] */
    {  451, 0x00000000U, 0x5832D435U }, /* XSUM_XXH32_testdata[902] */
    {  451, 0x9E3779B1U, 0x7F2E93ADU }, /* XSUM_XXH32_testdata[903] */
    {  452, 0x00000000U, 0x5689682DU }, /* XSUM_XXH32_testdata[904] */
    {  452, 0x9E3779B1U, 0x85793AD6U }, /* XSUM_XXH32_testdata[905] */
    {  453, 0x00000000U, 0xD777485DU }, /* XSUM_XXH32_testdata[906] */
    {  453, 0x9E3779B1U, 0x20A0C4FBU }, /* XSUM_XXH32_testdata[907] */
    {  454, 0x00000000U, 0x973A7FB6U }, /* XSUM_XXH32_testdata[908] */
    {  454, 0x9E3779B1U, 0xE7C00D0DU }, /* XSUM_XXH32_testdata[909] */
    {  455, 0x00000000U, 0x49563743U }, /* XSUM_XXH32_testdata[910] */
    {  455, 0x9E3779B1U, 0xBC845A31U }, /* XSUM_XXH32_testdata[911] */
    {  456, 0x00000000U, 0x54C77C2DU }, /* XSUM_XXH32_testdata[912] */
    {  456, 0x9E3779B1U, 0x8A4F4F36U }, /* XSUM_XXH32_testdata[913] */
    {  457, 0x00000000U, 0x664D3559U }, /* XSUM_XXH32_testdata[914] */
    {  457, 0x9E3779B1U, 0xECFB3EFAU }, /* XSUM_XXH32_testdata[915] */
    {  458, 0x00000000U, 0x98277A3BU }, /* XSUM_XXH32_testdata[916] */
    {  458, 0x9E3779B1U, 0xEE732216U }, /* XSUM_XXH32_testdata[917] */
    {  459, 0x00000000U, 0xFEB56F14U }, /* XSUM_XXH32_testdata[918] */
    {  459, 0x9E3779B1U, 0xD156A399U }, /* XSUM_XXH32_testdata[919] */
    {  460, 0x00000000U, 0xCCDE1DE4U }, /* XSUM_XXH32_testdata[920] */
    {  460, 0x9E3779B1U, 0x45B526F0U }, /* XSUM_XXH32_testdata[921] */
    {  461, 0x00000000U, 0x40BDF622U }, /* XSUM_XXH32_testdata[922] */
    {  461, 0x9E3779B1U, 0x4E5385C5U }, /* XSUM_XXH32_testdata[923] */
    {  462, 0x00000000U, 0xB49A5412U }, /* XSUM_XXH32_testdata[924] */
    {  462, 0x9E3779B1U, 0x2027820EU }, /* XSUM_XXH32_testdata[925] */
    {  463, 0x00000000U, 0xD56A74EDU }, /* XSUM_XXH32_testdata[926] */
    {  463, 0x9E3779B1U, 0x18E3A285U }, /* XSUM_XXH32_testdata[927] */
    {  464, 0x00000000U, 0x87536B30U }, /* XSUM_XXH32_testdata[928] */
    {  464, 0x9E3779B1U, 0xCBC6694CU }, /* XSUM_XXH32_testdata[929] */
    {  465, 0x00000000U, 0x5C57EBE2U }, /* XSUM_XXH32_testdata[930] */
    {  465, 0x9E3779B1U, 0xD3B0BBE1U }, /* XSUM_XXH32_testdata[931] */
    {  466, 0x00000000U, 0x0D6F434FU }, /* XSUM_XXH32_testdata[932] */
    {  466, 0x9E3779B1U, 0xB1D8E552U }, /* XSUM_XXH32_testdata[933] */
    {  467, 0x00000000U, 0x63C5A6D6U }, /* XSUM_XXH32_testdata[934] */
    {  467, 0x9E3779B1U, 0x60A72A01U }, /* XSUM_XXH32_testdata[935] */
    {  468, 0x00000000U, 0x9DF34052U }, /* XSUM_XXH32_testdata[936] */
    {  468, 0x9E3779B1U, 0x4B0919FAU }, /* XSUM_XXH32_testdata[937] */
    {  469, 0x00000000U, 0xA0893A83U }, /* XSUM_XXH32_testdata[938] */
    {  469, 0x9E3779B1U, 0xF828D25AU }, /* XSUM_XXH32_testdata[939] */
    {  470, 0x00000000U, 0x268E79E7U }, /* XSUM_XXH32_testdata[940] */
    {  470, 0x9E3779B1U, 0xE113114BU }, /* XSUM_XXH32_testdata[941] */
    {  471, 0x00000000U, 0x7B180A13U }, /* XSUM_XXH32_testdata[942] */
    {  471, 0x9E3779B1U, 0x5114F053U }, /* XSUM_XXH32_testdata[943] */
    {  472, 0x00000000U, 0x715EEEB8U }, /* XSUM_XXH32_testdata[944] */
    {  472, 0x9E3779B1U, 0xEE2237DBU }, /* XSUM_XXH32_testdata[945] */
    {  473, 0x00000000U, 0x9675D294U }, /* XSUM_XXH32_testdata[946] */
    {  473, 0x9E3779B1U, 0xDE0E0126U }, /* XSUM_XXH32_testdata[947] */
    {  474, 0x00000000U, 0x4FD98BFFU }, /* XSUM_XXH32_testdata[948] */
    {  474, 0x9E3779B1U, 0x9EB9ED42U }, /* XSUM_XXH32_testdata[949] */
    {  475, 0x00000000U, 0x82C70BFDU }, /* XSUM_XXH32_testdata[950] */
    {  475, 0x9E3779B1U, 0x2F7A5ACBU }, /* XSUM_XXH32_testdata[951] */
    {  476, 0x00000000U, 0x3E9A1572U }, /* XSUM_XXH32_testdata[952] */
    {  476, 0x9E3779B1U, 0x297C9081U }, /* XSUM_XXH32_testdata[953] */
    {  477, 0x00000000U, 0x00D57F59U }, /* XSUM_XXH32_testdata[954] */
    {  477, 0x9E3779B1U, 0x8A3B48ADU }, /* XSUM_XXH32_testdata[955] */
    {  478, 0x00000000U, 0x968C46FDU }, /* XSUM_XXH32_testdata[956] */
    {  478, 0x9E3779B1U, 0x9E6D5422U }, /* XSUM_XXH32_testdata[957] */
    {  479, 0x00000000U, 0x13D44DEDU }, /* XSUM_XXH32_testdata[958] */
    {  479, 0x9E3779B1U, 0xE0AC51ECU }, /* XSUM_XXH32_testdata[959] */
    {  480, 0x00000000U, 0xFA701665U }, /* XSUM_XXH32_testdata[960] */
    {  480, 0x9E3779B1U, 0x279E4B73U }, /* XSUM_XXH32_testdata[961] */
    {  481, 0x00000000U, 0xA02F2709U }, /* XSUM_XXH32_testdata[962] */
    {  481, 0x9E3779B1U, 0xDC94B814U }, /* XSUM_XXH32_testdata[963] */
    {  482, 0x00000000U, 0xE77711F6U }, /* XSUM_XXH32_testdata[964] */
    {  482, 0x9E3779B1U, 0xE68C3BD2U }, /* XSUM_XXH32_testdata[965] */
    {  483, 0x00000000U, 0x95470A4AU }, /* XSUM_XXH32_testdata[966] */
    {  483, 0x9E3779B1U, 0xB0E8A315U }, /* XSUM_XXH32_testdata[967] */
    {  484, 0x00000000U, 0x6702FC8EU }, /* XSUM_XXH32_testdata[968] */
    {  484, 0x9E3779B1U, 0x5230264BU }, /* XSUM_XXH32_testdata[969] */
    {  485, 0x00000000U, 0x98C3DBA5U }, /* XSUM_XXH32_testdata[970] */
    {  485, 0x9E3779B1U, 0x93949CC3U }, /* XSUM_XXH32_testdata[971] */
    {  486, 0x00000000U, 0x28C00DA0U }, /* XSUM_XXH32_testdata[972] */
    {  486, 0x9E3779B1U, 0x909F67EBU }, /* XSUM_XXH32_testdata[973] */
    {  487, 0x00000000U, 0xDBEC9175U }, /* XSUM_XXH32_testdata[974] */
    {  487, 0x9E3779B1U, 0xAD48356FU }, /* XSUM_XXH32_testdata[975] */
    {  488, 0x00000000U, 0xEF419D7BU }, /* XSUM_XXH32_testdata[976] */
    {  488, 0x9E3779B1U, 0xC6D3D6ABU }, /* XSUM_XXH32_testdata[977] */
    {  489, 0x00000000U, 0x3D4F87B3U }, /* XSUM_XXH32_testdata[978] */
    {  489, 0x9E3779B1U, 0xE3ADF317U }, /* XSUM_XXH32_testdata[979] */
    {  490, 0x00000000U, 0x2EDA373CU }, /* XSUM_XXH32_testdata[980] */
    {  490, 0x9E3779B1U, 0x8488A6BAU }, /* XSUM_XXH32_testdata[981] */
    {  491, 0x00000000U, 0xBD2D6FE1U }, /* XSUM_XXH32_testdata[982] */
    {  491, 0x9E3779B1U, 0xF99ED7DEU }, /* XSUM_XXH32_testdata[983] */
    {  492, 0x00000000U, 0x58CD817BU }, /* XSUM_XXH32_testdata[984] */
    {  492, 0x9E3779B1U, 0x7DE35E46U }, /* XSUM_XXH32_testdata[985] */
    {  493, 0x00000000U, 0xE4D1B854U }, /* XSUM_XXH32_testdata[986] */
    {  493, 0x9E3779B1U, 0x9C57E5C8U }, /* XSUM_XXH32_testdata[987] */
    {  494, 0x00000000U, 0x23E0C3CDU }, /* XSUM_XXH32_testdata[988] */
    {  494, 0x9E3779B1U, 0xD00A9348U }, /* XSUM_XXH32_testdata[989] */
    {  495, 0x00000000U, 0x673567E4U }, /* XSUM_XXH32_testdata[990] */
    {  495, 0x9E3779B1U, 0x393D7A9DU }, /* XSUM_XXH32_testdata[991] */
    {  496, 0x00000000U, 0xD8A934B3U }, /* XSUM_XXH32_testdata[992] */
    {  496, 0x9E3779B1U, 0xEAA0A65DU }, /* XSUM_XXH32_testdata[993] */
    {  497, 0x00000000U, 0x0611B201U }, /* XSUM_XXH32_testdata[994] */
    {  497, 0x9E3779B1U, 0xC30359CBU }, /* XSUM_XXH32_testdata[995] */
    {  498, 0x00000000U, 0x6561A6B7U }, /* XSUM_XXH32_testdata[996] */
    {  498, 0x9E3779B1U, 0x9E9C406FU }, /* XSUM_XXH32_testdata[997] */
    {  499, 0x00000000U, 0xC8F50206U }, /* XSUM_XXH32_testdata[998] */
    {  499, 0x9E3779B1U, 0x8428371CU }, /* XSUM_XXH32_testdata[999] */
    {  500, 0x00000000U, 0x8BEB3775U }, /* XSUM_XXH32_testdata[1000] */
    {  500, 0x9E3779B1U, 0xA901249EU }, /* XSUM_XXH32_testdata[1001] */
    {  501, 0x00000000U, 0x98582798U }, /* XSUM_XXH32_testdata[1002] */
    {  501, 0x9E3779B1U, 0x672E0008U }, /* XSUM_XXH32_testdata[1003] */
    {  502, 0x00000000U, 0x9B80E88AU }, /* XSUM_XXH32_testdata[1004] */
    {  502, 0x9E3779B1U, 0x567F3B9BU }, /* XSUM_XXH32_testdata[1005] */
    {  503, 0x00000000U, 0x322C52B7U }, /* XSUM_XXH32_testdata[1006] */
    {  503, 0x9E3779B1U, 0xD2A4AD6FU }, /* XSUM_XXH32_testdata[1007] */
    {  504, 0x00000000U, 0x06002976U }, /* XSUM_XXH32_testdata[1008] */
    {  504, 0x9E3779B1U, 0x83DC804DU }, /* XSUM_XXH32_testdata[1009] */
    {  505, 0x00000000U, 0x304BC8CEU }, /* XSUM_XXH32_testdata[1010] */
    {  505, 0x9E3779B1U, 0xC498DFE4U }, /* XSUM_XXH32_testdata[1011] */
    {  506, 0x00000000U, 0x34A20E8DU }, /* XSUM_XXH32_testdata[1012] */
    {  506, 0x9E3779B1U, 0x946BAC08U }, /* XSUM_XXH32_testdata[1013] */
    {  507, 0x00000000U, 0x992B910AU }, /* XSUM_XXH32_testdata[1014] */
    {  507, 0x9E3779B1U, 0xD20E8CDFU }, /* XSUM_XXH32_testdata[1015] */
    {  508, 0x00000000U, 0x8319D68AU }, /* XSUM_XXH32_testdata[1016] */
    {  508, 0x9E3779B1U, 0x3110E267U }, /* XSUM_XXH32_testdata[1017] */
    {  509, 0x00000000U, 0xAF0775DFU }, /* XSUM_XXH32_testdata[1018] */
    {  509, 0x9E3779B1U, 0x8A6D215BU }, /* XSUM_XXH32_testdata[1019] */
    {  510, 0x00000000U, 0x798D69BBU }, /* XSUM_XXH32_testdata[1020] */
    {  510, 0x9E3779B1U, 0xE958E92BU }, /* XSUM_XXH32_testdata[1021] */
    {  511, 0x00000000U, 0xC79D6F2EU }, /* XSUM_XXH32_testdata[1022] */
    {  511, 0x9E3779B1U, 0x4486B549U }, /* XSUM_XXH32_testdata[1023] */
    {  512, 0x00000000U, 0xD485C30AU }, /* XSUM_XXH32_testdata[1024] */
    {  512, 0x9E3779B1U, 0x6CCF94A9U }, /* XSUM_XXH32_testdata[1025] */
    {  513, 0x00000000U, 0x6C63C50EU }, /* XSUM_XXH32_testdata[1026] */
    {  513, 0x9E3779B1U, 0xAB0CEFD4U }, /* XSUM_XXH32_testdata[1027] */
    {  514, 0x00000000U, 0x2DC9B41AU }, /* XSUM_XXH32_testdata[1028] */
    {  514, 0x9E3779B1U, 0x5EC73449U }, /* XSUM_XXH32_testdata[1029] */
    {  515, 0x00000000U, 0xB0FB9A38U }, /* XSUM_XXH32_testdata[1030] */
    {  515, 0x9E3779B1U, 0xB0AC3757U }, /* XSUM_XXH32_testdata[1031] */
    {  516, 0x00000000U, 0x4A8C1861U }, /* XSUM_XXH32_testdata[1032] */
    {  516, 0x9E3779B1U, 0xFE9B0BE8U }, /* XSUM_XXH32_testdata[1033] */
    {  517, 0x00000000U, 0x75DE8B99U }, /* XSUM_XXH32_testdata[1034] */
    {  517, 0x9E3779B1U, 0x60C1EB2EU }, /* XSUM_XXH32_testdata[1035] */
    {  518, 0x00000000U, 0x008C3D32U }, /* XSUM_XXH32_testdata[1036] */
    {  518, 0x9E3779B1U, 0xF287822AU }, /* XSUM_XXH32_testdata[1037] */
    {  519, 0x00000000U, 0xF919FEFDU }, /* XSUM_XXH32_testdata[1038] */
    {  519, 0x9E3779B1U, 0x56698312U }, /* XSUM_XXH32_testdata[1039] */
    {  520, 0x00000000U, 0x1D2F12D6U }, /* XSUM_XXH32_testdata[1040] */
    {  520, 0x9E3779B1U, 0x731D9AE6U }, /* XSUM_XXH32_testdata[1041] */
    {  521, 0x00000000U, 0x2CD568BCU }, /* XSUM_XXH32_testdata[1042] */
    {  521, 0x9E3779B1U, 0x7AEC499BU }, /* XSUM_XXH32_testdata[1043] */
    {  522, 0x00000000U, 0xB03EEA72U }, /* XSUM_XXH32_testdata[1044] */
    {  522, 0x9E3779B1U, 0x7FC900D3U }, /* XSUM_XXH32_testdata[1045] */
    {  523, 0x00000000U, 0x93312B2FU }, /* XSUM_XXH32_testdata[1046] */
    {  523, 0x9E3779B1U, 0x872516FFU }, /* XSUM_XXH32_testdata[1047] */
    {  524, 0x00000000U, 0x879A2BACU }, /* XSUM_XXH32_testdata[1048] */
    {  524, 0x9E3779B1U, 0xC7E2B1C2U }, /* XSUM_XXH32_testdata[1049] */
    {  525, 0x00000000U, 0x3F152E85U }, /* XSUM_XXH32_testdata[1050] */
    {  525, 0x9E3779B1U, 0x4CAE54F1U }, /* XSUM_XXH32_testdata[1051] */
    {  526, 0x00000000U, 0xC047BF75U }, /* XSUM_XXH32_testdata[1052] */
    {  526, 0x9E3779B1U, 0xA83C9F31U }, /* XSUM_XXH32_testdata[1053] */
    {  527, 0x00000000U, 0xFFC3CA2FU }, /* XSUM_XXH32_testdata[1054] */
    {  527, 0x9E3779B1U, 0x3381A5B9U }, /* XSUM_XXH32_testdata[1055] */
    {  528, 0x00000000U, 0xCADCFDD7U }, /* XSUM_XXH32_testdata[1056] */
    {  528, 0x9E3779B1U, 0xDDEB2437U }, /* XSUM_XXH32_testdata[1057] */
    {  529, 0x00000000U, 0x8D43B097U }, /* XSUM_XXH32_testdata[1058] */
    {  529, 0x9E3779B1U, 0x079A294CU }, /* XSUM_XXH32_testdata[1059] */
    {  530, 0x00000000U, 0xEA80C01AU }, /* XSUM_XXH32_testdata[1060] */
    {  530, 0x9E3779B1U, 0x3B254F04U }, /* XSUM_XXH32_testdata[1061] */
    {  531, 0x00000000U, 0x6C09961BU }, /* XSUM_XXH32_testdata[1062] */
    {  531, 0x9E3779B1U, 0x1EFEDE87U }, /* XSUM_XXH32_testdata[1063] */
    {  532, 0x00000000U, 0xACEF9E82U }, /* XSUM_XXH32_testdata[1064] */
    {  532, 0x9E3779B1U, 0xDDB9C9A0U }, /* XSUM_XXH32_testdata[1065] */
    {  533, 0x00000000U, 0xE2656FE5U }, /* XSUM_XXH32_testdata[1066] */
    {  533, 0x9E3779B1U, 0x996A254DU }, /* XSUM_XXH32_testdata[1067] */
    {  534, 0x00000000U, 0x59FED3E4U }, /* XSUM_XXH32_testdata[1068] */
    {  534, 0x9E3779B1U, 0x4B0827ACU }, /* XSUM_XXH32_testdata[1069] */
    {  535, 0x00000000U, 0x59CC55B2U }, /* XSUM_XXH32_testdata[1070] */
    {  535, 0x9E3779B1U, 0x01DA2A1FU }, /* XSUM_XXH32_testdata[1071] */
    {  536, 0x00000000U, 0x9AD1040CU }, /* XSUM_XXH32_testdata[1072] */
    {  536, 0x9E3779B1U, 0x9B682F40U }, /* XSUM_XXH32_testdata[1073] */
    {  537, 0x00000000U, 0x2A68CF02U }, /* XSUM_XXH32_testdata[1074] */
    {  537, 0x9E3779B1U, 0xD02EBBC5U }, /* XSUM_XXH32_testdata[1075] */
    {  538, 0x00000000U, 0x6B4A67A0U }, /* XSUM_XXH32_testdata[1076] */
    {  538, 0x9E3779B1U, 0xA52541F3U }, /* XSUM_XXH32_testdata[1077] */
    {  539, 0x00000000U, 0x83C21C2FU }, /* XSUM_XXH32_testdata[1078] */
    {  539, 0x9E3779B1U, 0xEEBCB4DAU }, /* XSUM_XXH32_testdata[1079] */
    {  540, 0x00000000U, 0xA828F35EU }, /* XSUM_XXH32_testdata[1080] */
    {  540, 0x9E3779B1U, 0xC835265CU }, /* XSUM_XXH32_testdata[1081] */
    {  541, 0x00000000U, 0xFCAE55B9U }, /* XSUM_XXH32_testdata[1082] */
    {  541, 0x9E3779B1U, 0x48F7ED44U }, /* XSUM_XXH32_testdata[1083] */
    {  542, 0x00000000U, 0xE7803526U }, /* XSUM_XXH32_testdata[1084] */
    {  542, 0x9E3779B1U, 0xCF19C0EEU }, /* XSUM_XXH32_testdata[1085] */
    {  543, 0x00000000U, 0xF8B11AD8U }, /* XSUM_XXH32_testdata[1086] */
    {  543, 0x9E3779B1U, 0xA52AAE1BU }, /* XSUM_XXH32_testdata[1087] */
    {  544, 0x00000000U, 0x383709D8U }, /* XSUM_XXH32_testdata[1088] */
    {  544, 0x9E3779B1U, 0x2E987E7BU }, /* XSUM_XXH32_testdata[1089] */
    {  545, 0x00000000U, 0xEECB594AU }, /* XSUM_XXH32_testdata[1090] */
    {  545, 0x9E3779B1U, 0x26F3333DU }, /* XSUM_XXH32_testdata[1091] */
    {  546, 0x00000000U, 0xD2CAE8AAU }, /* XSUM_XXH32_testdata[1092] */
    {  546, 0x9E3779B1U, 0xF2E2CBE9U }, /* XSUM_XXH32_testdata[1093] */
    {  547, 0x00000000U, 0xF3F44D9DU }, /* XSUM_XXH32_testdata[1094] */
    {  547, 0x9E3779B1U, 0xC7D21280U }, /* XSUM_XXH32_testdata[1095] */
    {  548, 0x00000000U, 0x057CA1BBU }, /* XSUM_XXH32_testdata[1096] */
    {  548, 0x9E3779B1U, 0xD31CB27FU }, /* XSUM_XXH32_testdata[1097] */
    {  549, 0x00000000U, 0x523D1215U }, /* XSUM_XXH32_testdata[1098] */
    {  549, 0x9E3779B1U, 0x905365FFU }, /* XSUM_XXH32_testdata[1099] */
    {  550, 0x00000000U, 0x51D76F9BU }, /* XSUM_XXH32_testdata[1100] */
    {  550, 0x9E3779B1U, 0x70DFAC47U }, /* XSUM_XXH32_testdata[1101] */
    {  551, 0x00000000U, 0xFE574440U }, /* XSUM_XXH32_testdata[1102] */
    {  551, 0x9E3779B1U, 0x249EFE5CU }, /* XSUM_XXH32_testdata[1103] */
    {  552, 0x00000000U, 0x6D7C3E20U }, /* XSUM_XXH32_testdata[1104] */
    {  552, 0x9E3779B1U, 0x5F2E27D0U }, /* XSUM_XXH32_testdata[1105] */
    {  553, 0x00000000U, 0xE21902BAU }, /* XSUM_XXH32_testdata[1106] */
    {  553, 0x9E3779B1U, 0xF5FFC3CEU }, /* XSUM_XXH32_testdata[1107] */
    {  554, 0x00000000U, 0xCCB9D7D4U }, /* XSUM_XXH32_testdata[1108] */
    {  554, 0x9E3779B1U, 0x12733CD2U }, /* XSUM_XXH32_testdata[1109] */
    {  555, 0x00000000U, 0x9D220DE7U }, /* XSUM_XXH32_testdata[1110] */
    {  555, 0x9E3779B1U, 0x6B962E79U }, /* XSUM_XXH32_testdata[1111] */
    {  556, 0x00000000U, 0xD63A2252U }, /* XSUM_XXH32_testdata[1112] */
    {  556, 0x9E3779B1U, 0x137B28C0U }, /* XSUM_XXH32_testdata[1113] */
    {  557, 0x00000000U, 0x11075667U }, /* XSUM_XXH32_testdata[1114] */
    {  557, 0x9E3779B1U, 0x26D76C43U }, /* XSUM_XXH32_testdata[1115] */
    {  558, 0x00000000U, 0x93F39FA3U }, /* XSUM_XXH32_testdata[1116] */
    {  558, 0x9E3779B1U, 0x0675020DU }, /* XSUM_XXH32_testdata[1117] */
    {  559, 0x00000000U, 0xA3FE62E4U }, /* XSUM_XXH32_testdata[1118] */
    {  559, 0x9E3779B1U, 0x8B4B11B7U }, /* XSUM_XXH32_testdata[1119] */
    {  560, 0x00000000U, 0x6FCD562DU }, /* XSUM_XXH32_testdata[1120] */
    {  560, 0x9E3779B1U, 0x143B2E0EU }, /* XSUM_XXH32_testdata[1121] */
    {  561, 0x00000000U, 0xC3958E40U }, /* XSUM_XXH32_testdata[1122] */
    {  561, 0x9E3779B1U, 0x9861878AU }, /* XSUM_XXH32_testdata[1123] */
    {  562, 0x00000000U, 0x5BACD6A1U }, /* XSUM_XXH32_testdata[1124] */
    {  562, 0x9E3779B1U, 0xAA2290E9U }, /* XSUM_XXH32_testdata[1125] */
    {  563, 0x00000000U, 0x54B7AAB1U }, /* XSUM_XXH32_testdata[1126] */
    {  563, 0x9E3779B1U, 0xEF35B304U }, /* XSUM_XXH32_testdata[1127] */
    {  564, 0x00000000U, 0x3B7E557CU }, /* XSUM_XXH32_testdata[1128] */
    {  564, 0x9E3779B1U, 0xED950428U }, /* XSUM_XXH32_testdata[1129] */
    {  565, 0x00000000U, 0xCE795C36U }, /* XSUM_XXH32_testdata[1130] */
    {  565, 0x9E3779B1U, 0x0CC7CCE5U }, /* XSUM_XXH32_testdata[1131] */
    {  566, 0x00000000U, 0x3BAFE1EDU }, /* XSUM_XXH32_testdata[1132] */
    {  566, 0x9E3779B1U, 0xFC15F349U }, /* XSUM_XXH32_testdata[1133] */
    {  567, 0x00000000U, 0xC17A3D7AU }, /* XSUM_XXH32_testdata[1134] */
    {  567, 0x9E3779B1U, 0xAB844BA3U }, /* XSUM_XXH32_testdata[1135] */
    {  568, 0x00000000U, 0xB3E09646U }, /* XSUM_XXH32_testdata[1136] */
    {  568, 0x9E3779B1U, 0x02B655DBU }, /* XSUM_XXH32_testdata[1137] */
    {  569, 0x00000000U, 0xC9B1669EU }, /* XSUM_XXH32_testdata[1138] */
    {  569, 0x9E3779B1U, 0x3B334D34U }, /* XSUM_XXH32_testdata[1139] */
    {  570, 0x00000000U, 0x4D92E21DU }, /* XSUM_XXH32_testdata[1140] */
    {  570, 0x9E3779B1U, 0x0599D5AAU }, /* XSUM_XXH32_testdata[1141] */
    {  571, 0x00000000U, 0xC5628243U }, /* XSUM_XXH32_testdata[1142] */
    {  571, 0x9E3779B1U, 0x09B85AFCU }, /* XSUM_XXH32_testdata[1143] */
    {  572, 0x00000000U, 0xDD38AF07U }, /* XSUM_XXH32_testdata[1144] */
    {  572, 0x9E3779B1U, 0x141F339BU }, /* XSUM_XXH32_testdata[1145] */
    {  573, 0x00000000U, 0x039D9106U }, /* XSUM_XXH32_testdata[1146] */
    {  573, 0x9E3779B1U, 0x54588C33U }, /* XSUM_XXH32_testdata[1147] */
    {  574, 0x00000000U, 0xF0BBF203U }, /* XSUM_XXH32_testdata[1148] */
    {  574, 0x9E3779B1U, 0x10292D58U }, /* XSUM_XXH32_testdata[1149] */
    {  575, 0x00000000U, 0x64FA4DF4U }, /* XSUM_XXH32_testdata[1150] */
    {  575, 0x9E3779B1U, 0x416CCC54U }, /* XSUM_XXH32_testdata[1151] */
    {  576, 0x00000000U, 0xFF8BC9EAU }, /* XSUM_XXH32_testdata[1152] */
    {  576, 0x9E3779B1U, 0x94A8013FU }, /* XSUM_XXH32_testdata[1153] */
    {  577, 0x00000000U, 0x995CD6D4U }, /* XSUM_XXH32_testdata[1154] */
    {  577, 0x9E3779B1U, 0xF747C40DU }, /* XSUM_XXH32_testdata[1155] */
    {  578, 0x00000000U, 0x77F76E65U }, /* XSUM_XXH32_testdata[1156] */
    {  578, 0x9E3779B1U, 0x5A4E2FDFU }, /* XSUM_XXH32_testdata[1157] */
    {  579, 0x00000000U, 0x9204876BU }, /* XSUM_XXH32_testdata[1158] */
    {  579, 0x9E3779B1U, 0xC7AEDD9DU }, /* XSUM_XXH32_testdata[1159] */
    {  580, 0x00000000U, 0x8A281BF8U }, /* XSUM_XXH32_testdata[1160] */
    {  580, 0x9E3779B1U, 0x45A1BC23U }, /* XSUM_XXH32_testdata[1161] */
    {  581, 0x00000000U, 0x5E8176BBU }, /* XSUM_XXH32_testdata[1162] */
    {  581, 0x9E3779B1U, 0x6285049CU }, /* XSUM_XXH32_testdata[1163] */
    {  582, 0x00000000U, 0xC35C3FC5U }, /* XSUM_XXH32_testdata[1164] */
    {  582, 0x9E3779B1U, 0xD3E56414U }, /* XSUM_XXH32_testdata[1165] */
    {  583, 0x00000000U, 0x1E69E8BBU }, /* XSUM_XXH32_testdata[1166] */
    {  583, 0x9E3779B1U, 0xF7C983E5U }, /* XSUM_XXH32_testdata[1167] */
    {  584, 0x00000000U, 0xCFA3E33AU }, /* XSUM_XXH32_testdata[1168] */
    {  584, 0x9E3779B1U, 0x062AC722U }, /* XSUM_XXH32_testdata[1169] */
    {  585, 0x00000000U, 0x40DC036AU }, /* XSUM_XXH32_testdata[1170] */
    {  585, 0x9E3779B1U, 0xF7CA6DF7U }, /* XSUM_XXH32_testdata[1171] */
    {  586, 0x00000000U, 0x9038913EU }, /* XSUM_XXH32_testdata[1172] */
    {  586, 0x9E3779B1U, 0xAC07FED8U }, /* XSUM_XXH32_testdata[1173] */
    {  587, 0x00000000U, 0xCA36B71CU }, /* XSUM_XXH32_testdata[1174] */
    {  587, 0x9E3779B1U, 0x8298F8FBU }, /* XSUM_XXH32_testdata[1175] */
    {  588, 0x00000000U, 0x2C155240U }, /* XSUM_XXH32_testdata[1176] */
    {  588, 0x9E3779B1U, 0x47328FEBU }, /* XSUM_XXH32_testdata[1177] */
    {  589, 0x00000000U, 0xCCEF92BBU }, /* XSUM_XXH32_testdata[1178] */
    {  589, 0x9E3779B1U, 0x2EA2B429U }, /* XSUM_XXH32_testdata[1179] */
    {  590, 0x00000000U, 0x5FF56AB1U }, /* XSUM_XXH32_testdata[1180] */
    {  590, 0x9E3779B1U, 0x6B35A0ADU }, /* XSUM_XXH32_testdata[1181] */
    {  591, 0x00000000U, 0xD608BA57U }, /* XSUM_XXH32_testdata[1182] */
    {  591, 0x9E3779B1U, 0x4B4A5F5EU }, /* XSUM_XXH32_testdata[1183] */
    {  592, 0x00000000U, 0x5B1FEEECU }, /* XSUM_XXH32_testdata[1184] */
    {  592, 0x9E3779B1U, 0x20756839U }, /* XSUM_XXH32_testdata[1185] */
    {  593, 0x00000000U, 0x1ED67745U }, /* XSUM_XXH32_testdata[1186] */
    {  593, 0x9E3779B1U, 0x22C665D0U }, /* XSUM_XXH32_testdata[1187] */
    {  594, 0x00000000U, 0xF1E02CEAU }, /* XSUM_XXH32_testdata[1188] */
    {  594, 0x9E3779B1U, 0x2ACD85F8U }, /* XSUM_XXH32_testdata[1189] */
    {  595, 0x00000000U, 0x803B46A3U }, /* XSUM_XXH32_testdata[1190] */
    {  595, 0x9E3779B1U, 0xB73A088BU }, /* XSUM_XXH32_testdata[1191] */
    {  596, 0x00000000U, 0x557A2BD9U }, /* XSUM_XXH32_testdata[1192] */
    {  596, 0x9E3779B1U, 0x176BE304U }, /* XSUM_XXH32_testdata[1193] */
    {  597, 0x00000000U, 0xB7E6FAC5U }, /* XSUM_XXH32_testdata[1194] */
    {  597, 0x9E3779B1U, 0xA2028D7AU }, /* XSUM_XXH32_testdata[1195] */
    {  598, 0x00000000U, 0x48713AE1U }, /* XSUM_XXH32_testdata[1196] */
    {  598, 0x9E3779B1U, 0x6596C8A1U }, /* XSUM_XXH32_testdata[1197] */
    {  599, 0x00000000U, 0xF92390F6U }, /* XSUM_XXH32_testdata[1198] */
    {  599, 0x9E3779B1U, 0x88CE3FA5U }, /* XSUM_XXH32_testdata[1199] */
    {  600, 0x00000000U, 0x5929F25FU }, /* XSUM_XXH32_testdata[1200] */
    {  600, 0x9E3779B1U, 0xD8659733U }, /* XSUM_XXH32_testdata[1201] */
    {  601, 0x00000000U, 0x6934EF0FU }, /* XSUM_XXH32_testdata[1202] */
    {  601, 0x9E3779B1U, 0x1A66369AU }, /* XSUM_XXH32_testdata[1203] */
    {  602, 0x00000000U, 0xD62AFDCAU }, /* XSUM_XXH32_testdata[1204] */
    {  602, 0x9E3779B1U, 0x90A99973U }, /* XSUM_XXH32_testdata[1205] */
    {  603, 0x00000000U, 0x30DF07C5U }, /* XSUM_XXH32_testdata[1206] */
    {  603, 0x9E3779B1U, 0xFB1DC5EDU }, /* XSUM_XXH32_testdata[1207] */
    {  604, 0x00000000U, 0x354A95CCU }, /* XSUM_XXH32_testdata[1208] */
    {  604, 0x9E3779B1U, 0xF75E1BE4U }, /* XSUM_XXH32_testdata[1209] */
    {  605, 0x00000000U, 0xB644F7B0U }, /* XSUM_XXH32_testdata[1210] */
    {  605, 0x9E3779B1U, 0xF5DE009EU }, /* XSUM_XXH32_testdata[1211] */
    {  606, 0x00000000U, 0xA800018BU }, /* XSUM_XXH32_testdata[1212] */
    {  606, 0x9E3779B1U, 0x59C644D4U }, /* XSUM_XXH32_testdata[1213] */
    {  607, 0x00000000U, 0x22BFC8CFU }, /* XSUM_XXH32_testdata[1214] */
    {  607, 0x9E3779B1U, 0x9579DEC2U }, /* XSUM_XXH32_testdata[1215] */
    {  608, 0x00000000U, 0x7269CBF8U }, /* XSUM_XXH32_testdata[1216] */
    {  608, 0x9E3779B1U, 0x2C6EDB87U }, /* XSUM_XXH32_testdata[1217] */
    {  609, 0x00000000U, 0x2E68554DU }, /* XSUM_XXH32_testdata[1218] */
    {  609, 0x9E3779B1U, 0xDF2360BBU }, /* XSUM_XXH32_testdata[1219] */
    {  610, 0x00000000U, 0xE07AEE88U }, /* XSUM_XXH32_testdata[1220] */
    {  610, 0x9E3779B1U, 0x7272F640U }, /* XSUM_XXH32_testdata[1221] */
    {  611, 0x00000000U, 0x39486655U }, /* XSUM_XXH32_testdata[1222] */
    {  611, 0x9E3779B1U, 0xCF4AFAC3U }, /* XSUM_XXH32_testdata[1223] */
    {  612, 0x00000000U, 0x9276FE8AU }, /* XSUM_XXH32_testdata[1224] */
    {  612, 0x9E3779B1U, 0x85DCC42CU }, /* XSUM_XXH32_testdata[1225] */
    {  613, 0x00000000U, 0x0F2EF2F3U }, /* XSUM_XXH32_testdata[1226] */
    {  613, 0x9E3779B1U, 0xF34BE8BAU }, /* XSUM_XXH32_testdata[1227] */
    {  614, 0x00000000U, 0x4484C1D8U }, /* XSUM_XXH32_testdata[1228] */
    {  614, 0x9E3779B1U, 0x57E2CF3FU }, /* XSUM_XXH32_testdata[1229] */
    {  615, 0x00000000U, 0x61418265U }, /* XSUM_XXH32_testdata[1230] */
    {  615, 0x9E3779B1U, 0xC35AF718U }, /* XSUM_XXH32_testdata[1231] */
    {  616, 0x00000000U, 0x92A0ED48U }, /* XSUM_XXH32_testdata[1232] */
    {  616, 0x9E3779B1U, 0x017052A7U }, /* XSUM_XXH32_testdata[1233] */
    {  617, 0x00000000U, 0x7043FD18U }, /* XSUM_XXH32_testdata[1234] */
    {  617, 0x9E3779B1U, 0x9C2DDF98U }, /* XSUM_XXH32_testdata[1235] */
    {  618, 0x00000000U, 0x5D07E007U }, /* XSUM_XXH32_testdata[1236] */
    {  618, 0x9E3779B1U, 0x59434CB8U }, /* XSUM_XXH32_testdata[1237] */
    {  619, 0x00000000U, 0xB8FECF84U }, /* XSUM_XXH32_testdata[1238] */
    {  619, 0x9E3779B1U, 0xD91C95D4U }, /* XSUM_XXH32_testdata[1239] */
    {  620, 0x00000000U, 0x25F891A0U }, /* XSUM_XXH32_testdata[1240] */
    {  620, 0x9E3779B1U, 0x55BF001EU }, /* XSUM_XXH32_testdata[1241] */
    {  621, 0x00000000U, 0x8643600FU }, /* XSUM_XXH32_testdata[1242] */
    {  621, 0x9E3779B1U, 0x5D8AD780U }, /* XSUM_XXH32_testdata[1243] */
    {  622, 0x00000000U, 0xB45B415AU }, /* XSUM_XXH32_testdata[1244] */
    {  622, 0x9E3779B1U, 0xB7AF9ADDU }, /* XSUM_XXH32_testdata[1245] */
    {  623, 0x00000000U, 0xFFEDFB0CU }, /* XSUM_XXH32_testdata[1246] */
    {  623, 0x9E3779B1U, 0xD3D56B63U }, /* XSUM_XXH32_testdata[1247] */
    {  624, 0x00000000U, 0x299D5311U }, /* XSUM_XXH32_testdata[1248] */
    {  624, 0x9E3779B1U, 0xEC9EF02BU }, /* XSUM_XXH32_testdata[1249] */
    {  625, 0x00000000U, 0x1EC898BFU }, /* XSUM_XXH32_testdata[1250] */
    {  625, 0x9E3779B1U, 0x0FE4171DU }, /* XSUM_XXH32_testdata[1251] */
    {  626, 0x00000000U, 0x3D220B0DU }, /* XSUM_XXH32_testdata[1252] */
    {  626, 0x9E3779B1U, 0x4F611A36U }, /* XSUM_XXH32_testdata[1253] */
    {  627, 0x00000000U, 0xDF0C13CAU }, /* XSUM_XXH32_testdata[1254] */
    {  627, 0x9E3779B1U, 0xB3F9C65FU }, /* XSUM_XXH32_testdata[1255] */
    {  628, 0x00000000U, 0x74DBEB01U }, /* XSUM_XXH32_testdata[1256] */
    {  628, 0x9E3779B1U, 0x7062283CU }, /* XSUM_XXH32_testdata[1257] */
    {  629, 0x00000000U, 0xD3CE1024U }, /* XSUM_XXH32_testdata[1258] */
    {  629, 0x9E3779B1U, 0xCF5147D8U }, /* XSUM_XXH32_testdata[1259] */
    {  630, 0x00000000U, 0x248FAA29U }, /* XSUM_XXH32_testdata[1260] */
    {  630, 0x9E3779B1U, 0xCFAC6BACU }, /* XSUM_XXH32_testdata[1261] */
    {  631, 0x00000000U, 0xC369F007U }, /* XSUM_XXH32_testdata[1262] */
    {  631, 0x9E3779B1U, 0xC33F685FU }, /* XSUM_XXH32_testdata[1263] */
    {  632, 0x00000000U, 0x6FACA56EU }, /* XSUM_XXH32_testdata[1264] */
    {  632, 0x9E3779B1U, 0x05D0B46FU }, /* XSUM_XXH32_testdata[1265] */
    {  633, 0x00000000U, 0xEAF23F22U }, /* XSUM_XXH32_testdata[1266] */
    {  633, 0x9E3779B1U, 0x046AD846U }, /* XSUM_XXH32_testdata[1267] */
    {  634, 0x00000000U, 0xD97464A2U }, /* XSUM_XXH32_testdata[1268] */
    {  634, 0x9E3779B1U, 0x14A38A1BU }, /* XSUM_XXH32_testdata[1269] */
    {  635, 0x00000000U, 0x15E01FC1U }, /* XSUM_XXH32_testdata[1270] */
    {  635, 0x9E3779B1U, 0xC1C5F8B0U }, /* XSUM_XXH32_testdata[1271] */
    {  636, 0x00000000U, 0xB302CED9U }, /* XSUM_XXH32_testdata[1272] */
    {  636, 0x9E3779B1U, 0x580BE287U }, /* XSUM_XXH32_testdata[1273] */
    {  637, 0x00000000U, 0xADF7611AU }, /* XSUM_XXH32_testdata[1274] */
    {  637, 0x9E3779B1U, 0x6D7D7523U }, /* XSUM_XXH32_testdata[1275] */
    {  638, 0x00000000U, 0x8945B249U }, /* XSUM_XXH32_testdata[1276] */
    {  638, 0x9E3779B1U, 0x9B6F82ACU }, /* XSUM_XXH32_testdata[1277] */
    {  639, 0x00000000U, 0xBE350C50U }, /* XSUM_XXH32_testdata[1278] */
    {  639, 0x9E3779B1U, 0x7DDF8BBCU }, /* XSUM_XXH32_testdata[1279] */
    {  640, 0x00000000U, 0xAAA8DFC1U }, /* XSUM_XXH32_testdata[1280] */
    {  640, 0x9E3779B1U, 0xB4D5E8FFU }, /* XSUM_XXH32_testdata[1281] */
    {  641, 0x00000000U, 0xA9C2ADB2U }, /* XSUM_XXH32_testdata[1282] */
    {  641, 0x9E3779B1U, 0x124D8FEDU }, /* XSUM_XXH32_testdata[1283] */
    {  642, 0x00000000U, 0xFE8F7FEEU }, /* XSUM_XXH32_testdata[1284] */
    {  642, 0x9E3779B1U, 0x7AA9B6BFU }, /* XSUM_XXH32_testdata[1285] */
    {  643, 0x00000000U, 0x36FBB591U }, /* XSUM_XXH32_testdata[1286] */
    {  643, 0x9E3779B1U, 0x959814C7U }, /* XSUM_XXH32_testdata[1287] */
    {  644, 0x00000000U, 0x8CBC476EU }, /* XSUM_XXH32_testdata[1288] */
    {  644, 0x9E3779B1U, 0xCEA8C841U }, /* XSUM_XXH32_testdata[1289] */
    {  645, 0x00000000U, 0xC0365E3EU }, /* XSUM_XXH32_testdata[1290] */
    {  645, 0x9E3779B1U, 0xF98C999CU }, /* XSUM_XXH32_testdata[1291] */
    {  646, 0x00000000U, 0x06A6FEA3U }, /* XSUM_XXH32_testdata[1292] */
    {  646, 0x9E3779B1U, 0xB5648C61U }, /* XSUM_XXH32_testdata[1293] */
    {  647, 0x00000000U, 0x8982E615U }, /* XSUM_XXH32_testdata[1294] */
    {  647, 0x9E3779B1U, 0xB45AA50FU }, /* XSUM_XXH32_testdata[1295] */
    {  648, 0x00000000U, 0x7B446A4DU }, /* XSUM_XXH32_testdata[1296] */
    {  648, 0x9E3779B1U, 0xB7C22655U }, /* XSUM_XXH32_testdata[1297] */
    {  649, 0x00000000U, 0xA49903F7U }, /* XSUM_XXH32_testdata[1298] */
    {  649, 0x9E3779B1U, 0x5D1AC3EDU }, /* XSUM_XXH32_testdata[1299] */
    {  650, 0x00000000U, 0x1B0AE1F9U }, /* XSUM_XXH32_testdata[1300] */
    {  650, 0x9E3779B1U, 0x0532737CU }, /* XSUM_XXH32_testdata[1301] */
    {  651, 0x00000000U, 0x1487D63EU }, /* XSUM_XXH32_testdata[1302] */
    {  651, 0x9E3779B1U, 0x1919626DU }, /* XSUM_XXH32_testdata[1303] */
    {  652, 0x00000000U, 0x17824638U }, /* XSUM_XXH32_testdata[1304] */
    {  652, 0x9E3779B1U, 0xAC008CCBU }, /* XSUM_XXH32_testdata[1305] */
    {  653, 0x00000000U, 0x57824066U }, /* XSUM_XXH32_testdata[1306] */
    {  653, 0x9E3779B1U, 0xB0831EDFU }, /* XSUM_XXH32_testdata[1307] */
    {  654, 0x00000000U, 0xAD58606BU }, /* XSUM_XXH32_testdata[1308] */
    {  654, 0x9E3779B1U, 0x7DB42B57U }, /* XSUM_XXH32_testdata[1309] */
    {  655, 0x00000000U, 0xB7F5AFC1U }, /* XSUM_XXH32_testdata[1310] */
    {  655, 0x9E3779B1U, 0x0BC6BA89U }, /* XSUM_XXH32_testdata[1311] */
    {  656, 0x00000000U, 0x7BAC0653U }, /* XSUM_XXH32_testdata[1312] */
    {  656, 0x9E3779B1U, 0xCE8F2116U }, /* XSUM_XXH32_testdata[1313] */
    {  657, 0x00000000U, 0xAFF34289U }, /* XSUM_XXH32_testdata[1314] */
    {  657, 0x9E3779B1U, 0xC178DA60U }, /* XSUM_XXH32_testdata[1315] */
    {  658, 0x00000000U, 0x988F9DA6U }, /* XSUM_XXH32_testdata[1316] */
    {  658, 0x9E3779B1U, 0x6F20A426U }, /* XSUM_XXH32_testdata[1317] */
    {  659, 0x00000000U, 0xC97BC454U }, /* XSUM_XXH32_testdata[1318] */
    {  659, 0x9E3779B1U, 0xC174B4D1U }, /* XSUM_XXH32_testdata[1319] */
    {  660, 0x00000000U, 0x044A07E1U }, /* XSUM_XXH32_testdata[1320] */
    {  660, 0x9E3779B1U, 0xFF03D5A0U }, /* XSUM_XXH32_testdata[1321] */
    {  661, 0x00000000U, 0x2C8C1123U }, /* XSUM_XXH32_testdata[1322] */
    {  661, 0x9E3779B1U, 0xE8D2D489U }, /* XSUM_XXH32_testdata[1323] */
    {  662, 0x00000000U, 0xB2D9096CU }, /* XSUM_XXH32_testdata[1324] */
    {  662, 0x9E3779B1U, 0x9A752C8CU }, /* XSUM_XXH32_testdata[1325] */
    {  663, 0x00000000U, 0x65F5C022U }, /* XSUM_XXH32_testdata[1326] */
    {  663, 0x9E3779B1U, 0xD2885DA5U }, /* XSUM_XXH32_testdata[1327] */
    {  664, 0x00000000U, 0x1A9822F7U }, /* XSUM_XXH32_testdata[1328] */
    {  664, 0x9E3779B1U, 0x70B0EDD7U }, /* XSUM_XXH32_testdata[1329] */
    {  665, 0x00000000U, 0x6DF79264U }, /* XSUM_XXH32_testdata[1330] */
    {  665, 0x9E3779B1U, 0x5A08A975U }, /* XSUM_XXH32_testdata[1331] */
    {  666, 0x00000000U, 0x65033F15U }, /* XSUM_XXH32_testdata[1332] */
    {  666, 0x9E3779B1U, 0xF4350D2EU }, /* XSUM_XXH32_testdata[1333] */
    {  667, 0x00000000U, 0xA431E989U }, /* XSUM_XXH32_testdata[1334] */
    {  667, 0x9E3779B1U, 0xA3ED338BU }, /* XSUM_XXH32_testdata[1335] */
    {  668, 0x00000000U, 0x865A9B80U }, /* XSUM_XXH32_testdata[1336] */
    {  668, 0x9E3779B1U, 0xA35711A4U }, /* XSUM_XXH32_testdata[1337] */
    {  669, 0x00000000U, 0x9E0B83CEU }, /* XSUM_XXH32_testdata[1338] */
    {  669, 0x9E3779B1U, 0x4A0318C2U }, /* XSUM_XXH32_testdata[1339] */
    {  670, 0x00000000U, 0x1C1AA01AU }, /* XSUM_XXH32_testdata[1340] */
    {  670, 0x9E3779B1U, 0xCA0F79FFU }, /* XSUM_XXH32_testdata[1341] */
    {  671, 0x00000000U, 0xFD44F183U }, /* XSUM_XXH32_testdata[1342] */
    {  671, 0x9E3779B1U, 0xAE73FEF1U }, /* XSUM_XXH32_testdata[1343] */
    {  672, 0x00000000U, 0x54E2B7E3U }, /* XSUM_XXH32_testdata[1344] */
    {  672, 0x9E3779B1U, 0x53202297U }, /* XSUM_XXH32_testdata[1345] */
    {  673, 0x00000000U, 0x4E909F92U }, /* XSUM_XXH32_testdata[1346] */
    {  673, 0x9E3779B1U, 0x710B69A1U }, /* XSUM_XXH32_testdata[1347] */
    {  674, 0x00000000U, 0xAAAB145DU }, /* XSUM_XXH32_testdata[1348] */
    {  674, 0x9E3779B1U, 0x5F50BEFDU }, /* XSUM_XXH32_testdata[1349] */
    {  675, 0x00000000U, 0x4067EDF2U }, /* XSUM_XXH32_testdata[1350] */
    {  675, 0x9E3779B1U, 0x7A37B9EDU }, /* XSUM_XXH32_testdata[1351] */
    {  676, 0x00000000U, 0x3006022CU }, /* XSUM_XXH32_testdata[1352] */
    {  676, 0x9E3779B1U, 0x0FCBC3D7U }, /* XSUM_XXH32_testdata[1353] */
    {  677, 0x00000000U, 0x1D0886D2U }, /* XSUM_XXH32_testdata[1354] */
    {  677, 0x9E3779B1U, 0x33CF6C14U }, /* XSUM_XXH32_testdata[1355] */
    {  678, 0x00000000U, 0x3608EA67U }, /* XSUM_XXH32_testdata[1356] */
    {  678, 0x9E3779B1U, 0x729B2135U }, /* XSUM_XXH32_testdata[1357] */
    {  679, 0x00000000U, 0xF7434B2FU }, /* XSUM_XXH32_testdata[1358] */
    {  679, 0x9E3779B1U, 0x675F3A89U }, /* XSUM_XXH32_testdata[1359] */
    {  680, 0x00000000U, 0xFD470505U }, /* XSUM_XXH32_testdata[1360] */
    {  680, 0x9E3779B1U, 0xA7873132U }, /* XSUM_XXH32_testdata[1361] */
    {  681, 0x00000000U, 0xC1C147A7U }, /* XSUM_XXH32_testdata[1362] */
    {  681, 0x9E3779B1U, 0x76B23786U }, /* XSUM_XXH32_testdata[1363] */
    {  682, 0x00000000U, 0x91C067A6U }, /* XSUM_XXH32_testdata[1364] */
    {  682, 0x9E3779B1U, 0xEC9BED86U }, /* XSUM_XXH32_testdata[1365] */
    {  683, 0x00000000U, 0x681F83ACU }, /* XSUM_XXH32_testdata[1366] */
    {  683, 0x9E3779B1U, 0x1AFAFF43U }, /* XSUM_XXH32_testdata[1367] */
    {  684, 0x00000000U, 0x7BBBD8DFU }, /* XSUM_XXH32_testdata[1368] */
    {  684, 0x9E3779B1U, 0x09FBBFD8U }, /* XSUM_XXH32_testdata[1369] */
    {  685, 0x00000000U, 0xE646357AU }, /* XSUM_XXH32_testdata[1370] */
    {  685, 0x9E3779B1U, 0x7B379021U }, /* XSUM_XXH32_testdata[1371] */
    {  686, 0x00000000U, 0x31402396U }, /* XSUM_XXH32_testdata[1372] */
    {  686, 0x9E3779B1U, 0x56878528U }, /* XSUM_XXH32_testdata[1373] */
    {  687, 0x00000000U, 0xB72268D9U }, /* XSUM_XXH32_testdata[1374] */
    {  687, 0x9E3779B1U, 0xDAEBFD80U }, /* XSUM_XXH32_testdata[1375] */
    {  688, 0x00000000U, 0x75D3FE03U }, /* XSUM_XXH32_testdata[1376] */
    {  688, 0x9E3779B1U, 0xEA936796U }, /* XSUM_XXH32_testdata[1377] */
    {  689, 0x00000000U, 0xE99A21F6U }, /* XSUM_XXH32_testdata[1378] */
    {  689, 0x9E3779B1U, 0x123FA3BAU }, /* XSUM_XXH32_testdata[1379] */
    {  690, 0x00000000U, 0x7FF977A0U }, /* XSUM_XXH32_testdata[1380] */
    {  690, 0x9E3779B1U, 0xA9411D49U }, /* XSUM_XXH32_testdata[1381] */
    {  691, 0x00000000U, 0x9FC7E0DFU }, /* XSUM_XXH32_testdata[1382] */
    {  691, 0x9E3779B1U, 0x565EC388U }, /* XSUM_XXH32_testdata[1383] */
    {  692, 0x00000000U, 0xD6C3B2D8U }, /* XSUM_XXH32_testdata[1384] */
    {  692, 0x9E3779B1U, 0x457EE6AFU }, /* XSUM_XXH32_testdata[1385] */
    {  693, 0x00000000U, 0x4F8F5D69U }, /* XSUM_XXH32_testdata[1386] */
    {  693, 0x9E3779B1U, 0x717DE12DU }, /* XSUM_XXH32_testdata[1387] */
    {  694, 0x00000000U, 0x2562840AU }, /* XSUM_XXH32_testdata[1388] */
    {  694, 0x9E3779B1U, 0x3A2D71CFU }, /* XSUM_XXH32_testdata[1389] */
    {  695, 0x00000000U, 0x7181A588U }, /* XSUM_XXH32_testdata[1390] */
    {  695, 0x9E3779B1U, 0xDF26790AU }, /* XSUM_XXH32_testdata[1391] */
    {  696, 0x00000000U, 0x70AA2253U }, /* XSUM_XXH32_testdata[1392] */
    {  696, 0x9E3779B1U, 0x86D6EEAFU }, /* XSUM_XXH32_testdata[1393] */
    {  697, 0x00000000U, 0x9A44444DU }, /* XSUM_XXH32_testdata[1394] */
    {  697, 0x9E3779B1U, 0xE2854AC5U }, /* XSUM_XXH32_testdata[1395] */
    {  698, 0x00000000U, 0x57209128U }, /* XSUM_XXH32_testdata[1396] */
    {  698, 0x9E3779B1U, 0x455841A1U }, /* XSUM_XXH32_testdata[1397] */
    {  699, 0x00000000U, 0x8B06B883U }, /* XSUM_XXH32_testdata[1398] */
    {  699, 0x9E3779B1U, 0xB1748D9CU }, /* XSUM_XXH32_testdata[1399] */
    {  700, 0x00000000U, 0x92B71ECFU }, /* XSUM_XXH32_testdata[1400] */
    {  700, 0x9E3779B1U, 0x05DF9579U }, /* XSUM_XXH32_testdata[1401] */
    {  701, 0x00000000U, 0xD1806AB4U }, /* XSUM_XXH32_testdata[1402] */
    {  701, 0x9E3779B1U, 0x1564D2F9U }, /* XSUM_XXH32_testdata[1403] */
    {  702, 0x00000000U, 0x5E124C4BU }, /* XSUM_XXH32_testdata[1404] */
    {  702, 0x9E3779B1U, 0xC8C222C8U }, /* XSUM_XXH32_testdata[1405] */
    {  703, 0x00000000U, 0x2FDEFB21U }, /* XSUM_XXH32_testdata[1406] */
    {  703, 0x9E3779B1U, 0x96077C64U }, /* XSUM_XXH32_testdata[1407] */
    {  704, 0x00000000U, 0xEA6C2F2FU }, /* XSUM_XXH32_testdata[1408] */
    {  704, 0x9E3779B1U, 0x0E95CE2BU }, /* XSUM_XXH32_testdata[1409] */
    {  705, 0x00000000U, 0xBD1EA8DDU }, /* XSUM_XXH32_testdata[1410] */
    {  705, 0x9E3779B1U, 0xBD7512D2U }, /* XSUM_XXH32_testdata[1411] */
    {  706, 0x00000000U, 0x94221891U }, /* XSUM_XXH32_testdata[1412] */
    {  706, 0x9E3779B1U, 0x4BF7FB3DU }, /* XSUM_XXH32_testdata[1413] */
    {  707, 0x00000000U, 0xE095EB99U }, /* XSUM_XXH32_testdata[1414] */
    {  707, 0x9E3779B1U, 0x158CBC7AU }, /* XSUM_XXH32_testdata[1415] */
    {  708, 0x00000000U, 0x191074F2U }, /* XSUM_XXH32_testdata[1416] */
    {  708, 0x9E3779B1U, 0x13CC2B28U }, /* XSUM_XXH32_testdata[1417] */
    {  709, 0x00000000U, 0x0C01D9C0U }, /* XSUM_XXH32_testdata[1418] */
    {  709, 0x9E3779B1U, 0x941F1CF7U }, /* XSUM_XXH32_testdata[1419] */
    {  710, 0x00000000U, 0x2E351C94U }, /* XSUM_XXH32_testdata[1420] */
    {  710, 0x9E3779B1U, 0x8DC7405AU }, /* XSUM_XXH32_testdata[1421] */
    {  711, 0x00000000U, 0x649D385FU }, /* XSUM_XXH32_testdata[1422] */
    {  711, 0x9E3779B1U, 0x26719578U }, /* XSUM_XXH32_testdata[1423] */
    {  712, 0x00000000U, 0x1500F311U }, /* XSUM_XXH32_testdata[1424] */
    {  712, 0x9E3779B1U, 0x28E55B9EU }, /* XSUM_XXH32_testdata[1425] */
    {  713, 0x00000000U, 0xBFE4916EU }, /* XSUM_XXH32_testdata[1426] */
    {  713, 0x9E3779B1U, 0xAE001B78U }, /* XSUM_XXH32_testdata[1427] */
    {  714, 0x00000000U, 0x85221436U }, /* XSUM_XXH32_testdata[1428] */
    {  714, 0x9E3779B1U, 0x976F358BU }, /* XSUM_XXH32_testdata[1429] */
    {  715, 0x00000000U, 0xA583E7F8U }, /* XSUM_XXH32_testdata[1430] */
    {  715, 0x9E3779B1U, 0x0B4CA222U }, /* XSUM_XXH32_testdata[1431] */
    {  716, 0x00000000U, 0x09A08B97U }, /* XSUM_XXH32_testdata[1432] */
    {  716, 0x9E3779B1U, 0x5C4CBF41U }, /* XSUM_XXH32_testdata[1433] */
    {  717, 0x00000000U, 0xB5270B17U }, /* XSUM_XXH32_testdata[1434] */
    {  717, 0x9E3779B1U, 0x7F9F8805U }, /* XSUM_XXH32_testdata[1435] */
    {  718, 0x00000000U, 0x648FC4FCU }, /* XSUM_XXH32_testdata[1436] */
    {  718, 0x9E3779B1U, 0x280633CFU }, /* XSUM_XXH32_testdata[1437] */
    {  719, 0x00000000U, 0x438E4331U }, /* XSUM_XXH32_testdata[1438] */
    {  719, 0x9E3779B1U, 0x0D90CD0FU }, /* XSUM_XXH32_testdata[1439] */
    {  720, 0x00000000U, 0x5F5E67E6U }, /* XSUM_XXH32_testdata[1440] */
    {  720, 0x9E3779B1U, 0xB0BE79BDU }, /* XSUM_XXH32_testdata[1441] */
    {  721, 0x00000000U, 0x233A5C24U }, /* XSUM_XXH32_testdata[1442] */
    {  721, 0x9E3779B1U, 0x540F87BEU }, /* XSUM_XXH32_testdata[1443] */
    {  722, 0x00000000U, 0xC6A457E0U }, /* XSUM_XXH32_testdata[1444] */
    {  722, 0x9E3779B1U, 0xBA54D79DU }, /* XSUM_XXH32_testdata[1445] */
    {  723, 0x00000000U, 0xD6F57142U }, /* XSUM_XXH32_testdata[1446] */
    {  723, 0x9E3779B1U, 0x2D82EB5DU }, /* XSUM_XXH32_testdata[1447] */
    {  724, 0x00000000U, 0xC8F8634EU }, /* XSUM_XXH32_testdata[1448] */
    {  724, 0x9E3779B1U, 0x6F0B4A2CU }, /* XSUM_XXH32_testdata[1449] */
    {  725, 0x00000000U, 0x1B8F2C06U }, /* XSUM_XXH32_testdata[1450] */
    {  725, 0x9E3779B1U, 0xFDAE3F35U }, /* XSUM_XXH32_testdata[1451] */
    {  726, 0x00000000U, 0x58D06CFDU }, /* XSUM_XXH32_testdata[1452] */
    {  726, 0x9E3779B1U, 0xFBCC9165U }, /* XSUM_XXH32_testdata[1453] */
    {  727, 0x00000000U, 0x23DBAC8AU }, /* XSUM_XXH32_testdata[1454] */
    {  727, 0x9E3779B1U, 0x12ACF0E2U }, /* XSUM_XXH32_testdata[1455] */
    {  728, 0x00000000U, 0x89BF6E7FU }, /* XSUM_XXH32_testdata[1456] */
    {  728, 0x9E3779B1U, 0x5F804B41U }, /* XSUM_XXH32_testdata[1457] */
    {  729, 0x00000000U, 0xECF6498DU }, /* XSUM_XXH32_testdata[1458] */
    {  729, 0x9E3779B1U, 0xFBE4A699U }, /* XSUM_XXH32_testdata[1459] */
    {  730, 0x00000000U, 0x60979E7CU }, /* XSUM_XXH32_testdata[1460] */
    {  730, 0x9E3779B1U, 0xB7D0F58EU }, /* XSUM_XXH32_testdata[1461] */
    {  731, 0x00000000U, 0x1BC1FCD2U }, /* XSUM_XXH32_testdata[1462] */
    {  731, 0x9E3779B1U, 0x7F7750BFU }, /* XSUM_XXH32_testdata[1463] */
    {  732, 0x00000000U, 0x4C801024U }, /* XSUM_XXH32_testdata[1464] */
    {  732, 0x9E3779B1U, 0xA88C2776U }, /* XSUM_XXH32_testdata[1465] */
    {  733, 0x00000000U, 0xFD4608DAU }, /* XSUM_XXH32_testdata[1466] */
    {  733, 0x9E3779B1U, 0x2BE0F44BU }, /* XSUM_XXH32_testdata[1467] */
    {  734, 0x00000000U, 0x8683B929U }, /* XSUM_XXH32_testdata[1468] */
    {  734, 0x9E3779B1U, 0x35C57CB2U }, /* XSUM_XXH32_testdata[1469] */
    {  735, 0x00000000U, 0x5CE51D32U }, /* XSUM_XXH32_testdata[1470] */
    {  735, 0x9E3779B1U, 0xF8AD23C2U }, /* XSUM_XXH32_testdata[1471] */
    {  736, 0x00000000U, 0x916BE77FU }, /* XSUM_XXH32_testdata[1472] */
    {  736, 0x9E3779B1U, 0xDC94008DU }, /* XSUM_XXH32_testdata[1473] */
    {  737, 0x00000000U, 0xD5CD0CA2U }, /* XSUM_XXH32_testdata[1474] */
    {  737, 0x9E3779B1U, 0x01A4E15BU }, /* XSUM_XXH32_testdata[1475] */
    {  738, 0x00000000U, 0xB5A8991EU }, /* XSUM_XXH32_testdata[1476] */
    {  738, 0x9E3779B1U, 0x0FA8AB0DU }, /* XSUM_XXH32_testdata[1477] */
    {  739, 0x00000000U, 0x7BA03CDAU }, /* XSUM_XXH32_testdata[1478] */
    {  739, 0x9E3779B1U, 0xE677124BU }, /* XSUM_XXH32_testdata[1479] */
    {  740, 0x00000000U, 0x3460C7E0U }, /* XSUM_XXH32_testdata[1480] */
    {  740, 0x9E3779B1U, 0x1AB720E0U }, /* XSUM_XXH32_testdata[1481] */
    {  741, 0x00000000U, 0xD8189CB8U }, /* XSUM_XXH32_testdata[1482] */
    {  741, 0x9E3779B1U, 0x7FD2D6A7U }, /* XSUM_XXH32_testdata[1483] */
    {  742, 0x00000000U, 0x3F86374AU }, /* XSUM_XXH32_testdata[1484] */
    {  742, 0x9E3779B1U, 0xA87D05D7U }, /* XSUM_XXH32_testdata[1485] */
    {  743, 0x00000000U, 0xA978176FU }, /* XSUM_XXH32_testdata[1486] */
    {  743, 0x9E3779B1U, 0x424243F1U }, /* XSUM_XXH32_testdata[1487] */
    {  744, 0x00000000U, 0x4921F712U }, /* XSUM_XXH32_testdata[1488] */
    {  744, 0x9E3779B1U, 0x351D077EU }, /* XSUM_XXH32_testdata[1489] */
    {  745, 0x00000000U, 0xB412AF31U }, /* XSUM_XXH32_testdata[1490] */
    {  745, 0x9E3779B1U, 0xA15FC17DU }, /* XSUM_XXH32_testdata[1491] */
    {  746, 0x00000000U, 0x399725E9U }, /* XSUM_XXH32_testdata[1492] */
    {  746, 0x9E3779B1U, 0x3DE0BDE4U }, /* XSUM_XXH32_testdata[1493] */
    {  747, 0x00000000U, 0xB9C3918BU }, /* XSUM_XXH32_testdata[1494] */
    {  747, 0x9E3779B1U, 0x75129AB4U }, /* XSUM_XXH32_testdata[1495] */
    {  748, 0x00000000U, 0x6A74AB66U }, /* XSUM_XXH32_testdata[1496] */
    {  748, 0x9E3779B1U, 0x5BC783CFU }, /* XSUM_XXH32_testdata[1497] */
    {  749, 0x00000000U, 0xDA3A9061U }, /* XSUM_XXH32_testdata[1498] */
    {  749, 0x9E3779B1U, 0xD4F68C29U }, /* XSUM_XXH32_testdata[1499] */
    {  750, 0x00000000U, 0x6C6EB9BCU }, /* XSUM_XXH32_testdata[1500] */
    {  750, 0x9E3779B1U, 0xA07B0392U }, /* XSUM_XXH32_testdata[1501] */
    {  751, 0x00000000U, 0x3788DC46U }, /* XSUM_XXH32_testdata[1502] */
    {  751, 0x9E3779B1U, 0xE11ACCDAU }, /* XSUM_XXH32_testdata[1503] */
    {  752, 0x00000000U, 0x6D2F3AFDU }, /* XSUM_XXH32_testdata[1504] */
    {  752, 0x9E3779B1U, 0xD9E6ECBAU }, /* XSUM_XXH32_testdata[1505] */
    {  753, 0x00000000U, 0x7B87AB1CU }, /* XSUM_XXH32_testdata[1506] */
    {  753, 0x9E3779B1U, 0x1BC482ECU }, /* XSUM_XXH32_testdata[1507] */
    {  754, 0x00000000U, 0x8EC9696BU }, /* XSUM_XXH32_testdata[1508] */
    {  754, 0x9E3779B1U, 0x4DD8F1D8U }, /* XSUM_XXH32_testdata[1509] */
    {  755, 0x00000000U, 0x74EF1C43U }, /* XSUM_XXH32_testdata[1510] */
    {  755, 0x9E3779B1U, 0xBD88304EU }, /* XSUM_XXH32_testdata[1511] */
    {  756, 0x00000000U, 0x612AF8F5U }, /* XSUM_XXH32_testdata[1512] */
    {  756, 0x9E3779B1U, 0xDE656DA4U }, /* XSUM_XXH32_testdata[1513] */
    {  757, 0x00000000U, 0x9DD69924U }, /* XSUM_XXH32_testdata[1514] */
    {  757, 0x9E3779B1U, 0xD9905A8BU }, /* XSUM_XXH32_testdata[1515] */
    {  758, 0x00000000U, 0x39B40A78U }, /* XSUM_XXH32_testdata[1516] */
    {  758, 0x9E3779B1U, 0xD730505BU }, /* XSUM_XXH32_testdata[1517] */
    {  759, 0x00000000U, 0x149AB890U }, /* XSUM_XXH32_testdata[1518] */
    {  759, 0x9E3779B1U, 0x2944A2A0U }, /* XSUM_XXH32_testdata[1519] */
    {  760, 0x00000000U, 0x2875A5BAU }, /* XSUM_XXH32_testdata[1520] */
    {  760, 0x9E3779B1U, 0xF27711C0U }, /* XSUM_XXH32_testdata[1521] */
    {  761, 0x00000000U, 0x3880C284U }, /* XSUM_XXH32_testdata[1522] */
    {  761, 0x9E3779B1U, 0xCB288583U }, /* XSUM_XXH32_testdata[1523] */
    {  762, 0x00000000U, 0x8A947976U }, /* XSUM_XXH32_testdata[1524] */
    {  762, 0x9E3779B1U, 0x4D87BA63U }, /* XSUM_XXH32_testdata[1525] */
    {  763, 0x00000000U, 0xB32330A3U }, /* XSUM_XXH32_testdata[1526] */
    {  763, 0x9E3779B1U, 0x9E2EF837U }, /* XSUM_XXH32_testdata[1527] */
    {  764, 0x00000000U, 0x43DF832BU }, /* XSUM_XXH32_testdata[1528] */
    {  764, 0x9E3779B1U, 0x90190D1BU }, /* XSUM_XXH32_testdata[1529] */
    {  765, 0x00000000U, 0xFFF4987CU }, /* XSUM_XXH32_testdata[1530] */
    {  765, 0x9E3779B1U, 0xD9FEC95DU }, /* XSUM_XXH32_testdata[1531] */
    {  766, 0x00000000U, 0xE34251AEU }, /* XSUM_XXH32_testdata[1532] */
    {  766, 0x9E3779B1U, 0xD6236F68U }, /* XSUM_XXH32_testdata[1533] */
    {  767, 0x00000000U, 0x0EE8121CU }, /* XSUM_XXH32_testdata[1534] */
    {  767, 0x9E3779B1U, 0xA478A20CU }, /* XSUM_XXH32_testdata[1535] */
    {  768, 0x00000000U, 0xCA5128E2U }, /* XSUM_XXH32_testdata[1536] */
    {  768, 0x9E3779B1U, 0x2B7FC8B4U }, /* XSUM_XXH32_testdata[1537] */
    {  769, 0x00000000U, 0x1BF02E61U }, /* XSUM_XXH32_testdata[1538] */
    {  769, 0x9E3779B1U, 0x5BE6D729U }, /* XSUM_XXH32_testdata[1539] */
    {  770, 0x00000000U, 0xF328DB39U }, /* XSUM_XXH32_testdata[1540] */
    {  770, 0x9E3779B1U, 0x7DB3B037U }, /* XSUM_XXH32_testdata[1541] */
    {  771, 0x00000000U, 0x203C70BCU }, /* XSUM_XXH32_testdata[1542] */
    {  771, 0x9E3779B1U, 0xC919E129U }, /* XSUM_XXH32_testdata[1543] */
    {  772, 0x00000000U, 0x4C7F0C56U }, /* XSUM_XXH32_testdata[1544] */
    {  772, 0x9E3779B1U, 0x33A4929FU }, /* XSUM_XXH32_testdata[1545] */
    {  773, 0x00000000U, 0x5B47E012U }, /* XSUM_XXH32_testdata[1546] */
    {  773, 0x9E3779B1U, 0x44306653U }, /* XSUM_XXH32_testdata[1547] */
    {  774, 0x00000000U, 0x13A7A0A2U }, /* XSUM_XXH32_testdata[1548] */
    {  774, 0x9E3779B1U, 0xD3A9B1C5U }, /* XSUM_XXH32_testdata[1549] */
    {  775, 0x00000000U, 0xFF21193DU }, /* XSUM_XXH32_testdata[1550] */
    {  775, 0x9E3779B1U, 0xB7E86889U }, /* XSUM_XXH32_testdata[1551] */
    {  776, 0x00000000U, 0x535B5EF2U }, /* XSUM_XXH32_testdata[1552] */
    {  776, 0x9E3779B1U, 0xE00F76FDU }, /* XSUM_XXH32_testdata[1553] */
    {  777, 0x00000000U, 0x94797D58U }, /* XSUM_XXH32_testdata[1554] */
    {  777, 0x9E3779B1U, 0xEE685D23U }, /* XSUM_XXH32_testdata[1555] */
    {  778, 0x00000000U, 0x79BE2677U }, /* XSUM_XXH32_testdata[1556] */
    {  778, 0x9E3779B1U, 0xDB3DA974U }, /* XSUM_XXH32_testdata[1557] */
    {  779, 0x00000000U, 0xBCB775EBU }, /* XSUM_XXH32_testdata[1558] */
    {  779, 0x9E3779B1U, 0x8D9747A4U }, /* XSUM_XXH32_testdata[1559] */
    {  780, 0x00000000U, 0xB3EFEB6FU }, /* XSUM_XXH32_testdata[1560] */
    {  780, 0x9E3779B1U, 0x10342289U }, /* XSUM_XXH32_testdata[1561] */
    {  781, 0x00000000U, 0x2A9EAC26U }, /* XSUM_XXH32_testdata[1562] */
    {  781, 0x9E3779B1U, 0xE66F075AU }, /* XSUM_XXH32_testdata[1563] */
    {  782, 0x00000000U, 0xA22BF0CBU }, /* XSUM_XXH32_testdata[1564] */
    {  782, 0x9E3779B1U, 0xFA8744A0U }, /* XSUM_XXH32_testdata[1565] */
    {  783, 0x00000000U, 0xF8F97E0FU }, /* XSUM_XXH32_testdata[1566] */
    {  783, 0x9E3779B1U, 0x497A21C1U }, /* XSUM_XXH32_testdata[1567] */
    {  784, 0x00000000U, 0xC4A0816BU }, /* XSUM_XXH32_testdata[1568] */
    {  784, 0x9E3779B1U, 0x29F27769U }, /* XSUM_XXH32_testdata[1569] */
    {  785, 0x00000000U, 0xEDAD452EU }, /* XSUM_XXH32_testdata[1570] */
    {  785, 0x9E3779B1U, 0xF809A80DU }, /* XSUM_XXH32_testdata[1571] */
    {  786, 0x00000000U, 0xEDB20314U }, /* XSUM_XXH32_testdata[1572] */
    {  786, 0x9E3779B1U, 0xAD493881U }, /* XSUM_XXH32_testdata[1573] */
    {  787, 0x00000000U, 0xBC2EE0C9U }, /* XSUM_XXH32_testdata[1574] */
    {  787, 0x9E3779B1U, 0x820B9F81U }, /* XSUM_XXH32_testdata[1575] */
    {  788, 0x00000000U, 0x9A18694AU }, /* XSUM_XXH32_testdata[1576] */
    {  788, 0x9E3779B1U, 0x432C0DBAU }, /* XSUM_XXH32_testdata[1577] */
    {  789, 0x00000000U, 0xE16F826FU }, /* XSUM_XXH32_testdata[1578] */
    {  789, 0x9E3779B1U, 0xB12DEFF6U }, /* XSUM_XXH32_testdata[1579] */
    {  790, 0x00000000U, 0x74997B00U }, /* XSUM_XXH32_testdata[1580] */
    {  790, 0x9E3779B1U, 0xF2F0240FU }, /* XSUM_XXH32_testdata[1581] */
    {  791, 0x00000000U, 0xAF9343E2U }, /* XSUM_XXH32_testdata[1582] */
    {  791, 0x9E3779B1U, 0x543DE858U }, /* XSUM_XXH32_testdata[1583] */
    {  792, 0x00000000U, 0x7C24394DU }, /* XSUM_XXH32_testdata[1584] */
    {  792, 0x9E3779B1U, 0x7DC5595BU }, /* XSUM_XXH32_testdata[1585] */
    {  793, 0x00000000U, 0x14D83702U }, /* XSUM_XXH32_testdata[1586] */
    {  793, 0x9E3779B1U, 0xF53C71C4U }, /* XSUM_XXH32_testdata[1587] */
    {  794, 0x00000000U, 0x608703B9U }, /* XSUM_XXH32_testdata[1588] */
    {  794, 0x9E3779B1U, 0xAB22EDD0U }, /* XSUM_XXH32_testdata[1589] */
    {  795, 0x00000000U, 0x18D15D7EU }, /* XSUM_XXH32_testdata[1590] */
    {  795, 0x9E3779B1U, 0x09A50326U }, /* XSUM_XXH32_testdata[1591] */
    {  796, 0x00000000U, 0x560C13BBU }, /* XSUM_XXH32_testdata[1592] */
    {  796, 0x9E3779B1U, 0x0754045CU }, /* XSUM_XXH32_testdata[1593] */
    {  797, 0x00000000U, 0x36288D35U }, /* XSUM_XXH32_testdata[1594] */
    {  797, 0x9E3779B1U, 0x5F10ADC0U }, /* XSUM_XXH32_testdata[1595] */
    {  798, 0x00000000U, 0x572027D4U }, /* XSUM_XXH32_testdata[1596] */
    {  798, 0x9E3779B1U, 0x2D089D82U }, /* XSUM_XXH32_testdata[1597] */
    {  799, 0x00000000U, 0x349A7EC0U }, /* XSUM_XXH32_testdata[1598] */
    {  799, 0x9E3779B1U, 0xE1C4B3BCU }, /* XSUM_XXH32_testdata[1599] */
    {  800, 0x00000000U, 0x799ACE3AU }, /* XSUM_XXH32_testdata[1600] */
    {  800, 0x9E3779B1U, 0x94557779U }, /* XSUM_XXH32_testdata[1601] */
    {  801, 0x00000000U, 0x6006B6AEU }, /* XSUM_XXH32_testdata[1602] */
    {  801, 0x9E3779B1U, 0x3B80BC1BU }, /* XSUM_XXH32_testdata[1603] */
    {  802, 0x00000000U, 0xCB8EEF30U }, /* XSUM_XXH32_testdata[1604] */
    {  802, 0x9E3779B1U, 0x53E99BBBU }, /* XSUM_XXH32_testdata[1605] */
    {  803, 0x00000000U, 0x3CA5935FU }, /* XSUM_XXH32_testdata[1606] */
    {  803, 0x9E3779B1U, 0x79AE63A2U }, /* XSUM_XXH32_testdata[1607] */
    {  804, 0x00000000U, 0xFFCBE36BU }, /* XSUM_XXH32_testdata[1608] */
    {  804, 0x9E3779B1U, 0x42991898U }, /* XSUM_XXH32_testdata[1609] */
    {  805, 0x00000000U, 0x9E9AEB10U }, /* XSUM_XXH32_testdata[1610] */
    {  805, 0x9E3779B1U, 0xC917EBB7U }, /* XSUM_XXH32_testdata[1611] */
    {  806, 0x00000000U, 0x792D9C19U }, /* XSUM_XXH32_testdata[1612] */
    {  806, 0x9E3779B1U, 0x47430CB1U }, /* XSUM_XXH32_testdata[1613] */
    {  807, 0x00000000U, 0x0383FB25U }, /* XSUM_XXH32_testdata[1614] */
    {  807, 0x9E3779B1U, 0x87727B7EU }, /* XSUM_XXH32_testdata[1615] */
    {  808, 0x00000000U, 0x9B7DDE3FU }, /* XSUM_XXH32_testdata[1616] */
    {  808, 0x9E3779B1U, 0x1ACE553EU }, /* XSUM_XXH32_testdata[1617] */
    {  809, 0x00000000U, 0x0C585D82U }, /* XSUM_XXH32_testdata[1618] */
    {  809, 0x9E3779B1U, 0x0DBEE1DAU }, /* XSUM_XXH32_testdata[1619] */
    {  810, 0x00000000U, 0x426BD099U }, /* XSUM_XXH32_testdata[1620] */
    {  810, 0x9E3779B1U, 0xAA00D6C4U }, /* XSUM_XXH32_testdata[1621] */
    {  811, 0x00000000U, 0x5CA58FCDU }, /* XSUM_XXH32_testdata[1622] */
    {  811, 0x9E3779B1U, 0x200CD49BU }, /* XSUM_XXH32_testdata[1623] */
    {  812, 0x00000000U, 0xA005B5F3U }, /* XSUM_XXH32_testdata[1624] */
    {  812, 0x9E3779B1U, 0xC93B3EAFU }, /* XSUM_XXH32_testdata[1625] */
    {  813, 0x00000000U, 0x70ED3432U }, /* XSUM_XXH32_testdata[1626] */
    {  813, 0x9E3779B1U, 0x58CE8E37U }, /* XSUM_XXH32_testdata[1627] */
    {  814, 0x00000000U, 0x581F1F5BU }, /* XSUM_XXH32_testdata[1628] */
    {  814, 0x9E3779B1U, 0x87A7138AU }, /* XSUM_XXH32_testdata[1629] */
    {  815, 0x00000000U, 0xE01F98DBU }, /* XSUM_XXH32_testdata[1630] */
    {  815, 0x9E3779B1U, 0x2DD3C645U }, /* XSUM_XXH32_testdata[1631] */
    {  816, 0x00000000U, 0x9197D655U }, /* XSUM_XXH32_testdata[1632] */
    {  816, 0x9E3779B1U, 0x88181254U }, /* XSUM_XXH32_testdata[1633] */
    {  817, 0x00000000U, 0x8BEA65B4U }, /* XSUM_XXH32_testdata[1634] */
    {  817, 0x9E3779B1U, 0xA96D339EU }, /* XSUM_XXH32_testdata[1635] */
    {  818, 0x00000000U, 0x527578DBU }, /* XSUM_XXH32_testdata[1636] */
    {  818, 0x9E3779B1U, 0x1CB5CB64U }, /* XSUM_XXH32_testdata[1637] */
    {  819, 0x00000000U, 0x630CCD19U }, /* XSUM_XXH32_testdata[1638] */
    {  819, 0x9E3779B1U, 0xED107A3FU }, /* XSUM_XXH32_testdata[1639] */
    {  820, 0x00000000U, 0x41F3C92CU }, /* XSUM_XXH32_testdata[1640] */
    {  820, 0x9E3779B1U, 0x1ABE7E73U }, /* XSUM_XXH32_testdata[1641] */
    {  821, 0x00000000U, 0x19821DAFU }, /* XSUM_XXH32_testdata[1642] */
    {  821, 0x9E3779B1U, 0xDD0B94C3U }, /* XSUM_XXH32_testdata[1643] */
    {  822, 0x00000000U, 0xEA9FD68AU }, /* XSUM_XXH32_testdata[1644] */
    {  822, 0x9E3779B1U, 0x76282216U }, /* XSUM_XXH32_testdata[1645] */
    {  823, 0x00000000U, 0x298B22DFU }, /* XSUM_XXH32_testdata[1646] */
    {  823, 0x9E3779B1U, 0xCAB9201FU }, /* XSUM_XXH32_testdata[1647] */
    {  824, 0x00000000U, 0x1B6C1EBFU }, /* XSUM_XXH32_testdata[1648] */
    {  824, 0x9E3779B1U, 0xF79DCCE4U }, /* XSUM_XXH32_testdata[1649] */
    {  825, 0x00000000U, 0xF610D9B6U }, /* XSUM_XXH32_testdata[1650] */
    {  825, 0x9E3779B1U, 0x73062BC6U }, /* XSUM_XXH32_testdata[1651] */
    {  826, 0x00000000U, 0xBEA861F5U }, /* XSUM_XXH32_testdata[1652] */
    {  826, 0x9E3779B1U, 0x3B8CD69DU }, /* XSUM_XXH32_testdata[1653] */
    {  827, 0x00000000U, 0x3900262DU }, /* XSUM_XXH32_testdata[1654] */
    {  827, 0x9E3779B1U, 0x851AB34BU }, /* XSUM_XXH32_testdata[1655] */
    {  828, 0x00000000U, 0xD53836B9U }, /* XSUM_XXH32_testdata[1656] */
    {  828, 0x9E3779B1U, 0xC93C8FB4U }, /* XSUM_XXH32_testdata[1657] */
    {  829, 0x00000000U, 0xCC01D7B4U }, /* XSUM_XXH32_testdata[1658] */
    {  829, 0x9E3779B1U, 0x239420A2U }, /* XSUM_XXH32_testdata[1659] */
    {  830, 0x00000000U, 0x11A2A8FFU }, /* XSUM_XXH32_testdata[1660] */
    {  830, 0x9E3779B1U, 0x1C7A6CBEU }, /* XSUM_XXH32_testdata[1661] */
    {  831, 0x00000000U, 0x140A2E34U }, /* XSUM_XXH32_testdata[1662] */
    {  831, 0x9E3779B1U, 0xC8E75164U }, /* XSUM_XXH32_testdata[1663] */
    {  832, 0x00000000U, 0x0783E95AU }, /* XSUM_XXH32_testdata[1664] */
    {  832, 0x9E3779B1U, 0x021FF221U }, /* XSUM_XXH32_testdata[1665] */
    {  833, 0x00000000U, 0x8FB9CA1BU }, /* XSUM_XXH32_testdata[1666] */
    {  833, 0x9E3779B1U, 0xA1CC2DF9U }, /* XSUM_XXH32_testdata[1667] */
    {  834, 0x00000000U, 0x746A9750U }, /* XSUM_XXH32_testdata[1668] */
    {  834, 0x9E3779B1U, 0x5F16C1DDU }, /* XSUM_XXH32_testdata[1669] */
    {  835, 0x00000000U, 0x14B12F5FU }, /* XSUM_XXH32_testdata[1670] */
    {  835, 0x9E3779B1U, 0xC5005296U }, /* XSUM_XXH32_testdata[1671] */
    {  836, 0x00000000U, 0xBB9ACFA0U }, /* XSUM_XXH32_testdata[1672] */
    {  836, 0x9E3779B1U, 0x0DC8DAAFU }, /* XSUM_XXH32_testdata[1673] */
    {  837, 0x00000000U, 0x7205DC59U }, /* XSUM_XXH32_testdata[1674] */
    {  837, 0x9E3779B1U, 0xEEFC11DBU }, /* XSUM_XXH32_testdata[1675] */
    {  838, 0x00000000U, 0x0B52C9B9U }, /* XSUM_XXH32_testdata[1676] */
    {  838, 0x9E3779B1U, 0xAF1725DAU }, /* XSUM_XXH32_testdata[1677] */
    {  839, 0x00000000U, 0x464E264DU }, /* XSUM_XXH32_testdata[1678] */
    {  839, 0x9E3779B1U, 0xF8ABC41AU }, /* XSUM_XXH32_testdata[1679] */
    {  840, 0x00000000U, 0x6FE0DFAEU }, /* XSUM_XXH32_testdata[1680] */
    {  840, 0x9E3779B1U, 0x5C313325U }, /* XSUM_XXH32_testdata[1681] */
    {  841, 0x00000000U, 0x9DEE1514U }, /* XSUM_XXH32_testdata[1682] */
    {  841, 0x9E3779B1U, 0xB3EA0CA6U }, /* XSUM_XXH32_testdata[1683] */
    {  842, 0x00000000U, 0xD3A7EDCEU }, /* XSUM_XXH32_testdata[1684] */
    {  842, 0x9E3779B1U, 0x8694FFA8U }, /* XSUM_XXH32_testdata[1685] */
    {  843, 0x00000000U, 0xE842112CU }, /* XSUM_XXH32_testdata[1686] */
    {  843, 0x9E3779B1U, 0x3A6171E5U }, /* XSUM_XXH32_testdata[1687] */
    {  844, 0x00000000U, 0xD2B2F892U }, /* XSUM_XXH32_testdata[1688] */
    {  844, 0x9E3779B1U, 0xA413C6D0U }, /* XSUM_XXH32_testdata[1689] */
    {  845, 0x00000000U, 0xFEFB4745U }, /* XSUM_XXH32_testdata[1690] */
    {  845, 0x9E3779B1U, 0xE6672924U }, /* XSUM_XXH32_testdata[1691] */
    {  846, 0x00000000U, 0xAA00C849U }, /* XSUM_XXH32_testdata[1692] */
    {  846, 0x9E3779B1U, 0x2F20E493U }, /* XSUM_XXH32_testdata[1693] */
    {  847, 0x00000000U, 0x3BAB9A06U }, /* XSUM_XXH32_testdata[1694] */
    {  847, 0x9E3779B1U, 0xFD48FEABU }, /* XSUM_XXH32_testdata[1695] */
    {  848, 0x00000000U, 0x1732CE34U }, /* XSUM_XXH32_testdata[1696] */
    {  848, 0x9E3779B1U, 0xF693EFE5U }, /* XSUM_XXH32_testdata[1697] */
    {  849, 0x00000000U, 0x164D3308U }, /* XSUM_XXH32_testdata[1698] */
    {  849, 0x9E3779B1U, 0x31DB60C9U }, /* XSUM_XXH32_testdata[1699] */
    {  850, 0x00000000U, 0x2D570248U }, /* XSUM_XXH32_testdata[1700] */
    {  850, 0x9E3779B1U, 0xFFDE72F1U }, /* XSUM_XXH32_testdata[1701] */
    {  851, 0x00000000U, 0x6B8793C4U }, /* XSUM_XXH32_testdata[1702] */
    {  851, 0x9E3779B1U, 0xF8F00489U }, /* XSUM_XXH32_testdata[1703] */
    {  852, 0x00000000U, 0xEAC2EDADU }, /* XSUM_XXH32_testdata[1704] */
    {  852, 0x9E3779B1U, 0x0F2CE5ADU }, /* XSUM_XXH32_testdata[1705] */
    {  853, 0x00000000U, 0x56A12C9DU }, /* XSUM_XXH32_testdata[1706] */
    {  853, 0x9E3779B1U, 0xDA401320U }, /* XSUM_XXH32_testdata[1707] */
    {  854, 0x00000000U, 0xE1784C92U }, /* XSUM_XXH32_testdata[1708] */
    {  854, 0x9E3779B1U, 0xDC0796F4U }, /* XSUM_XXH32_testdata[1709] */
    {  855, 0x00000000U, 0xEF177BC4U }, /* XSUM_XXH32_testdata[1710] */
    {  855, 0x9E3779B1U, 0x879E8F48U }, /* XSUM_XXH32_testdata[1711] */
    {  856, 0x00000000U, 0x9F93E91FU }, /* XSUM_XXH32_testdata[1712] */
    {  856, 0x9E3779B1U, 0xFB085F0EU }, /* XSUM_XXH32_testdata[1713] */
    {  857, 0x00000000U, 0x4A47A2C0U }, /* XSUM_XXH32_testdata[1714] */
    {  857, 0x9E3779B1U, 0x9970434FU }, /* XSUM_XXH32_testdata[1715] */
    {  858, 0x00000000U, 0x0A564BC8U }, /* XSUM_XXH32_testdata[1716] */
    {  858, 0x9E3779B1U, 0x94ACD42EU }, /* XSUM_XXH32_testdata[1717] */
    {  859, 0x00000000U, 0x37664233U }, /* XSUM_XXH32_testdata[1718] */
    {  859, 0x9E3779B1U, 0x1A64836FU }, /* XSUM_XXH32_testdata[1719] */
    {  860, 0x00000000U, 0x4308CA3DU }, /* XSUM_XXH32_testdata[1720] */
    {  860, 0x9E3779B1U, 0x0E4E177DU }, /* XSUM_XXH32_testdata[1721] */
    {  861, 0x00000000U, 0xD5B7C564U }, /* XSUM_XXH32_testdata[1722] */
    {  861, 0x9E3779B1U, 0xD903E606U }, /* XSUM_XXH32_testdata[1723] */
    {  862, 0x00000000U, 0x82037110U }, /* XSUM_XXH32_testdata[1724] */
    {  862, 0x9E3779B1U, 0x75554B56U }, /* XSUM_XXH32_testdata[1725] */
    {  863, 0x00000000U, 0x145B2AE2U }, /* XSUM_XXH32_testdata[1726] */
    {  863, 0x9E3779B1U, 0x7E743179U }, /* XSUM_XXH32_testdata[1727] */
    {  864, 0x00000000U, 0x16C8B28CU }, /* XSUM_XXH32_testdata[1728] */
    {  864, 0x9E3779B1U, 0xB51D2BCFU }, /* XSUM_XXH32_testdata[1729] */
    {  865, 0x00000000U, 0x8C82C8E0U }, /* XSUM_XXH32_testdata[1730] */
    {  865, 0x9E3779B1U, 0xB2F697C2U }, /* XSUM_XXH32_testdata[1731] */
    {  866, 0x00000000U, 0xBE274BB3U }, /* XSUM_XXH32_testdata[1732] */
    {  866, 0x9E3779B1U, 0xE17C3BA2U }, /* XSUM_XXH32_testdata[1733] */
    {  867, 0x00000000U, 0x476BE8BFU }, /* XSUM_XXH32_testdata[1734] */
    {  867, 0x9E3779B1U, 0x71FAF09BU }, /* XSUM_XXH32_testdata[1735] */
    {  868, 0x00000000U, 0xAF268721U }, /* XSUM_XXH32_testdata[1736] */
    {  868, 0x9E3779B1U, 0x0F7FA222U }, /* XSUM_XXH32_testdata[1737] */
    {  869, 0x00000000U, 0x0EAD1E2AU }, /* XSUM_XXH32_testdata[1738] */
    {  869, 0x9E3779B1U, 0xF0C7FCBCU }, /* XSUM_XXH32_testdata[1739] */
    {  870, 0x00000000U, 0x63CA6795U }, /* XSUM_XXH32_testdata[1740] */
    {  870, 0x9E3779B1U, 0x6D43A2B2U }, /* XSUM_XXH32_testdata[1741] */
    {  871, 0x00000000U, 0x255F838FU }, /* XSUM_XXH32_testdata[1742] */
    {  871, 0x9E3779B1U, 0x3308BEFBU }, /* XSUM_XXH32_testdata[1743] */
    {  872, 0x00000000U, 0xB8926545U }, /* XSUM_XXH32_testdata[1744] */
    {  872, 0x9E3779B1U, 0xDD5AA75EU }, /* XSUM_XXH32_testdata[1745] */
    {  873, 0x00000000U, 0x2A1062E6U }, /* XSUM_XXH32_testdata[1746] */
    {  873, 0x9E3779B1U, 0x4B6C2322U }, /* XSUM_XXH32_testdata[1747] */
    {  874, 0x00000000U, 0xE1288231U }, /* XSUM_XXH32_testdata[1748] */
    {  874, 0x9E3779B1U, 0xF167892FU }, /* XSUM_XXH32_testdata[1749] */
    {  875, 0x00000000U, 0xC6473C63U }, /* XSUM_XXH32_testdata[1750] */
    {  875, 0x9E3779B1U, 0xDF7EE803U }, /* XSUM_XXH32_testdata[1751] */
    {  876, 0x00000000U, 0xADC3ACFBU }, /* XSUM_XXH32_testdata[1752] */
    {  876, 0x9E3779B1U, 0x5B2393CDU }, /* XSUM_XXH32_testdata[1753] */
    {  877, 0x00000000U, 0x58D5C9BAU }, /* XSUM_XXH32_testdata[1754] */
    {  877, 0x9E3779B1U, 0x4B013380U }, /* XSUM_XXH32_testdata[1755] */
    {  878, 0x00000000U, 0xC063426BU }, /* XSUM_XXH32_testdata[1756] */
    {  878, 0x9E3779B1U, 0x3431792AU }, /* XSUM_XXH32_testdata[1757] */
    {  879, 0x00000000U, 0x6F25BC05U }, /* XSUM_XXH32_testdata[1758] */
    {  879, 0x9E3779B1U, 0x2463EDABU }, /* XSUM_XXH32_testdata[1759] */
    {  880, 0x00000000U, 0x6941D23BU }, /* XSUM_XXH32_testdata[1760] */
    {  880, 0x9E3779B1U, 0x133CF5DAU }, /* XSUM_XXH32_testdata[1761] */
    {  881, 0x00000000U, 0xFE478A0CU }, /* XSUM_XXH32_testdata[1762] */
    {  881, 0x9E3779B1U, 0xDF743D6CU }, /* XSUM_XXH32_testdata[1763] */
    {  882, 0x00000000U, 0x5C20FC4BU }, /* XSUM_XXH32_testdata[1764] */
    {  882, 0x9E3779B1U, 0x0764B5DFU }, /* XSUM_XXH32_testdata[1765] */
    {  883, 0x00000000U, 0xB4D49683U }, /* XSUM_XXH32_testdata[1766] */
    {  883, 0x9E3779B1U, 0x16722D88U }, /* XSUM_XXH32_testdata[1767] */
    {  884, 0x00000000U, 0xC170FFA9U }, /* XSUM_XXH32_testdata[1768] */
    {  884, 0x9E3779B1U, 0xA536EECCU }, /* XSUM_XXH32_testdata[1769] */
    {  885, 0x00000000U, 0x4E655C59U }, /* XSUM_XXH32_testdata[1770] */
    {  885, 0x9E3779B1U, 0x39CA43A8U }, /* XSUM_XXH32_testdata[1771] */
    {  886, 0x00000000U, 0xF2B5A26DU }, /* XSUM_XXH32_testdata[1772] */
    {  886, 0x9E3779B1U, 0x8B2A6110U }, /* XSUM_XXH32_testdata[1773] */
    {  887, 0x00000000U, 0xE71437F1U }, /* XSUM_XXH32_testdata[1774] */
    {  887, 0x9E3779B1U, 0x0D3C607DU }, /* XSUM_XXH32_testdata[1775] */
    {  888, 0x00000000U, 0xB46B5CBDU }, /* XSUM_XXH32_testdata[1776] */
    {  888, 0x9E3779B1U, 0x4A74B7E8U }, /* XSUM_XXH32_testdata[1777] */
    {  889, 0x00000000U, 0xE006D455U }, /* XSUM_XXH32_testdata[1778] */
    {  889, 0x9E3779B1U, 0x471546A0U }, /* XSUM_XXH32_testdata[1779] */
    {  890, 0x00000000U, 0x02ECA8AAU }, /* XSUM_XXH32_testdata[1780] */
    {  890, 0x9E3779B1U, 0xD35D3207U }, /* XSUM_XXH32_testdata[1781] */
    {  891, 0x00000000U, 0xCEF23CC1U }, /* XSUM_XXH32_testdata[1782] */
    {  891, 0x9E3779B1U, 0x24E82C65U }, /* XSUM_XXH32_testdata[1783] */
    {  892, 0x00000000U, 0xAA24508EU }, /* XSUM_XXH32_testdata[1784] */
    {  892, 0x9E3779B1U, 0x76F48F31U }, /* XSUM_XXH32_testdata[1785] */
    {  893, 0x00000000U, 0xB2F9155FU }, /* XSUM_XXH32_testdata[1786] */
    {  893, 0x9E3779B1U, 0xEE7AD2F9U }, /* XSUM_XXH32_testdata[1787] */
    {  894, 0x00000000U, 0xE7B59BB7U }, /* XSUM_XXH32_testdata[1788] */
    {  894, 0x9E3779B1U, 0x926416CFU }, /* XSUM_XXH32_testdata[1789] */
    {  895, 0x00000000U, 0xC04896A1U }, /* XSUM_XXH32_testdata[1790] */
    {  895, 0x9E3779B1U, 0x119328BFU }, /* XSUM_XXH32_testdata[1791] */
    {  896, 0x00000000U, 0xA1C7A923U }, /* XSUM_XXH32_testdata[1792] */
    {  896, 0x9E3779B1U, 0x46149B0DU }, /* XSUM_XXH32_testdata[1793] */
    {  897, 0x00000000U, 0xFF4ED8D4U }, /* XSUM_XXH32_testdata[1794] */
    {  897, 0x9E3779B1U, 0x0F3F65EFU }, /* XSUM_XXH32_testdata[1795] */
    {  898, 0x00000000U, 0x1F82826EU }, /* XSUM_XXH32_testdata[1796] */
    {  898, 0x9E3779B1U, 0x759A1CB3U }, /* XSUM_XXH32_testdata[1797] */
    {  899, 0x00000000U, 0x1A934DC6U }, /* XSUM_XXH32_testdata[1798] */
    {  899, 0x9E3779B1U, 0x8B0E5440U }, /* XSUM_XXH32_testdata[1799] */
    {  900, 0x00000000U, 0x4C71F332U }, /* XSUM_XXH32_testdata[1800] */
    {  900, 0x9E3779B1U, 0xC9E617F3U }, /* XSUM_XXH32_testdata[1801] */
    {  901, 0x00000000U, 0x52FBDF77U }, /* XSUM_XXH32_testdata[1802] */
    {  901, 0x9E3779B1U, 0x432B13F4U }, /* XSUM_XXH32_testdata[1803] */
    {  902, 0x00000000U, 0x25D0AF8FU }, /* XSUM_XXH32_testdata[1804] */
    {  902, 0x9E3779B1U, 0x2B3F63B6U }, /* XSUM_XXH32_testdata[1805] */
    {  903, 0x00000000U, 0x311F9CD9U }, /* XSUM_XXH32_testdata[1806] */
    {  903, 0x9E3779B1U, 0x8B1E128FU }, /* XSUM_XXH32_testdata[1807] */
    {  904, 0x00000000U, 0x865F9281U }, /* XSUM_XXH32_testdata[1808] */
    {  904, 0x9E3779B1U, 0xFAA8D0FFU }, /* XSUM_XXH32_testdata[1809] */
    {  905, 0x00000000U, 0x3C320F49U }, /* XSUM_XXH32_testdata[1810] */
    {  905, 0x9E3779B1U, 0x4D968269U }, /* XSUM_XXH32_testdata[1811] */
    {  906, 0x00000000U, 0xA44A8B08U }, /* XSUM_XXH32_testdata[1812] */
    {  906, 0x9E3779B1U, 0xC1157174U }, /* XSUM_XXH32_testdata[1813] */
    {  907, 0x00000000U, 0x2933D62FU }, /* XSUM_XXH32_testdata[1814] */
    {  907, 0x9E3779B1U, 0x68DCB4D9U }, /* XSUM_XXH32_testdata[1815] */
    {  908, 0x00000000U, 0x87947414U }, /* XSUM_XXH32_testdata[1816] */
    {  908, 0x9E3779B1U, 0xD1237AD5U }, /* XSUM_XXH32_testdata[1817] */
    {  909, 0x00000000U, 0xB9C03AA0U }, /* XSUM_XXH32_testdata[1818] */
    {  909, 0x9E3779B1U, 0x04B9C681U }, /* XSUM_XXH32_testdata[1819] */
    {  910, 0x00000000U, 0xCFB8C5DFU }, /* XSUM_XXH32_testdata[1820] */
    {  910, 0x9E3779B1U, 0x35216418U }, /* XSUM_XXH32_testdata[1821] */
    {  911, 0x00000000U, 0xEA4DECC1U }, /* XSUM_XXH32_testdata[1822] */
    {  911, 0x9E3779B1U, 0xB83DE5CEU }, /* XSUM_XXH32_testdata[1823] */
    {  912, 0x00000000U, 0x3AD296A2U }, /* XSUM_XXH32_testdata[1824] */
    {  912, 0x9E3779B1U, 0xE594F5CAU }, /* XSUM_XXH32_testdata[1825] */
    {  913, 0x00000000U, 0xDB55306AU }, /* XSUM_XXH32_testdata[1826] */
    {  913, 0x9E3779B1U, 0xC726427BU }, /* XSUM_XXH32_testdata[1827] */
    {  914, 0x00000000U, 0x8205386AU }, /* XSUM_XXH32_testdata[1828] */
    {  914, 0x9E3779B1U, 0xC08D372AU }, /* XSUM_XXH32_testdata[1829] */
    {  915, 0x00000000U, 0xCC88B456U }, /* XSUM_XXH32_testdata[1830] */
    {  915, 0x9E3779B1U, 0xF81340A5U }, /* XSUM_XXH32_testdata[1831] */
    {  916, 0x00000000U, 0x3B2EC5E8U }, /* XSUM_XXH32_testdata[1832] */
    {  916, 0x9E3779B1U, 0xD06186E9U }, /* XSUM_XXH32_testdata[1833] */
    {  917, 0x00000000U, 0xB19BCF79U }, /* XSUM_XXH32_testdata[1834] */
    {  917, 0x9E3779B1U, 0xF0878A1DU }, /* XSUM_XXH32_testdata[1835] */
    {  918, 0x00000000U, 0x51B6D0B7U }, /* XSUM_XXH32_testdata[1836] */
    {  918, 0x9E3779B1U, 0xD03ABD0CU }, /* XSUM_XXH32_testdata[1837] */
    {  919, 0x00000000U, 0xA2388411U }, /* XSUM_XXH32_testdata[1838] */
    {  919, 0x9E3779B1U, 0x77D39263U }, /* XSUM_XXH32_testdata[1839] */
    {  920, 0x00000000U, 0x26B9033EU }, /* XSUM_XXH32_testdata[1840] */
    {  920, 0x9E3779B1U, 0x6FAFC1D6U }, /* XSUM_XXH32_testdata[1841] */
    {  921, 0x00000000U, 0xB1252094U }, /* XSUM_XXH32_testdata[1842] */
    {  921, 0x9E3779B1U, 0xF9A756DBU }, /* XSUM_XXH32_testdata[1843] */
    {  922, 0x00000000U, 0xFB2EA3FDU }, /* XSUM_XXH32_testdata[1844] */
    {  922, 0x9E3779B1U, 0x0CBF81BCU }, /* XSUM_XXH32_testdata[1845] */
    {  923, 0x00000000U, 0x9608E6B4U }, /* XSUM_XXH32_testdata[1846] */
    {  923, 0x9E3779B1U, 0x31D3955DU }, /* XSUM_XXH32_testdata[1847] */
    {  924, 0x00000000U, 0x7B791E4AU }, /* XSUM_XXH32_testdata[1848] */
    {  924, 0x9E3779B1U, 0x5C8FF5C1U }, /* XSUM_XXH32_testdata[1849] */
    {  925, 0x00000000U, 0xC0ADA68DU }, /* XSUM_XXH32_testdata[1850] */
    {  925, 0x9E3779B1U, 0x8A6E43EAU }, /* XSUM_XXH32_testdata[1851] */
    {  926, 0x00000000U, 0x7BE7336DU }, /* XSUM_XXH32_testdata[1852] */
    {  926, 0x9E3779B1U, 0x18617776U }, /* XSUM_XXH32_testdata[1853] */
    {  927, 0x00000000U, 0xF6508F24U }, /* XSUM_XXH32_testdata[1854] */
    {  927, 0x9E3779B1U, 0xAA0D461BU }, /* XSUM_XXH32_testdata[1855] */
    {  928, 0x00000000U, 0x2605B12DU }, /* XSUM_XXH32_testdata[1856] */
    {  928, 0x9E3779B1U, 0x35BA61DBU }, /* XSUM_XXH32_testdata[1857] */
    {  929, 0x00000000U, 0xB3E42749U }, /* XSUM_XXH32_testdata[1858] */
    {  929, 0x9E3779B1U, 0xF4153CE5U }, /* XSUM_XXH32_testdata[1859] */
    {  930, 0x00000000U, 0x9F218688U }, /* XSUM_XXH32_testdata[1860] */
    {  930, 0x9E3779B1U, 0x7FE70E23U }, /* XSUM_XXH32_testdata[1861] */
    {  931, 0x00000000U, 0xF434AA75U }, /* XSUM_XXH32_testdata[1862] */
    {  931, 0x9E3779B1U, 0x1CB726C8U }, /* XSUM_XXH32_testdata[1863] */
    {  932, 0x00000000U, 0xE73BFEFCU }, /* XSUM_XXH32_testdata[1864] */
    {  932, 0x9E3779B1U, 0xC93F71D1U }, /* XSUM_XXH32_testdata[1865] */
    {  933, 0x00000000U, 0xE5FEB2B6U }, /* XSUM_XXH32_testdata[1866] */
    {  933, 0x9E3779B1U, 0x11A57E5FU }, /* XSUM_XXH32_testdata[1867] */
    {  934, 0x00000000U, 0x8AB6D185U }, /* XSUM_XXH32_testdata[1868] */
    {  934, 0x9E3779B1U, 0xCDA30A60U }, /* XSUM_XXH32_testdata[1869] */
    {  935, 0x00000000U, 0x84C03046U }, /* XSUM_XXH32_testdata[1870] */
    {  935, 0x9E3779B1U, 0xEA293516U }, /* XSUM_XXH32_testdata[1871] */
    {  936, 0x00000000U, 0xE6975E35U }, /* XSUM_XXH32_testdata[1872] */
    {  936, 0x9E3779B1U, 0xF098711DU }, /* XSUM_XXH32_testdata[1873] */
    {  937, 0x00000000U, 0x9FC3BFBBU }, /* XSUM_XXH32_testdata[1874] */
    {  937, 0x9E3779B1U, 0x6AAEBE5DU }, /* XSUM_XXH32_testdata[1875] */
    {  938, 0x00000000U, 0xDC8B6DCBU }, /* XSUM_XXH32_testdata[1876] */
    {  938, 0x9E3779B1U, 0xDB967172U }, /* XSUM_XXH32_testdata[1877] */
    {  939, 0x00000000U, 0x9E2B4A28U }, /* XSUM_XXH32_testdata[1878] */
    {  939, 0x9E3779B1U, 0xE04AD3FFU }, /* XSUM_XXH32_testdata[1879] */
    {  940, 0x00000000U, 0xB3DC35ECU }, /* XSUM_XXH32_testdata[1880] */
    {  940, 0x9E3779B1U, 0x2B7F469CU }, /* XSUM_XXH32_testdata[1881] */
    {  941, 0x00000000U, 0xDDF34EFEU }, /* XSUM_XXH32_testdata[1882] */
    {  941, 0x9E3779B1U, 0x11037D75U }, /* XSUM_XXH32_testdata[1883] */
    {  942, 0x00000000U, 0x072116FCU }, /* XSUM_XXH32_testdata[1884] */
    {  942, 0x9E3779B1U, 0x9F32CC8BU }, /* XSUM_XXH32_testdata[1885] */
    {  943, 0x00000000U, 0xBF800F4BU }, /* XSUM_XXH32_testdata[1886] */
    {  943, 0x9E3779B1U, 0x3A408F9BU }, /* XSUM_XXH32_testdata[1887] */
    {  944, 0x00000000U, 0xEBE4533EU }, /* XSUM_XXH32_testdata[1888] */
    {  944, 0x9E3779B1U, 0x7BB63CF7U }, /* XSUM_XXH32_testdata[1889] */
    {  945, 0x00000000U, 0xE713F9ECU }, /* XSUM_XXH32_testdata[1890] */
    {  945, 0x9E3779B1U, 0xC244D3CEU }, /* XSUM_XXH32_testdata[1891] */
    {  946, 0x00000000U, 0xDE1D81AFU }, /* XSUM_XXH32_testdata[1892] */
    {  946, 0x9E3779B1U, 0x03CC2FFEU }, /* XSUM_XXH32_testdata[1893] */
    {  947, 0x00000000U, 0x830982E4U }, /* XSUM_XXH32_testdata[1894] */
    {  947, 0x9E3779B1U, 0x6CE1CADBU }, /* XSUM_XXH32_testdata[1895] */
    {  948, 0x00000000U, 0x318761FDU }, /* XSUM_XXH32_testdata[1896] */
    {  948, 0x9E3779B1U, 0x4529AC5FU }, /* XSUM_XXH32_testdata[1897] */
    {  949, 0x00000000U, 0xF750B50EU }, /* XSUM_XXH32_testdata[1898] */
    {  949, 0x9E3779B1U, 0x532E8599U }, /* XSUM_XXH32_testdata[1899] */
    {  950, 0x00000000U, 0xC8144FB8U }, /* XSUM_XXH32_testdata[1900] */
    {  950, 0x9E3779B1U, 0x3903F70FU }, /* XSUM_XXH32_testdata[1901] */
    {  951, 0x00000000U, 0x30BC4442U }, /* XSUM_XXH32_testdata[1902] */
    {  951, 0x9E3779B1U, 0x67AA8772U }, /* XSUM_XXH32_testdata[1903] */
    {  952, 0x00000000U, 0x8AE5991CU }, /* XSUM_XXH32_testdata[1904] */
    {  952, 0x9E3779B1U, 0xEA70DD9DU }, /* XSUM_XXH32_testdata[1905] */
    {  953, 0x00000000U, 0xE463B964U }, /* XSUM_XXH32_testdata[1906] */
    {  953, 0x9E3779B1U, 0xCAD6C042U }, /* XSUM_XXH32_testdata[1907] */
    {  954, 0x00000000U, 0x046D9095U }, /* XSUM_XXH32_testdata[1908] */
    {  954, 0x9E3779B1U, 0x78A6F70BU }, /* XSUM_XXH32_testdata[1909] */
    {  955, 0x00000000U, 0xF183D423U }, /* XSUM_XXH32_testdata[1910] */
    {  955, 0x9E3779B1U, 0x296EAF67U }, /* XSUM_XXH32_testdata[1911] */
    {  956, 0x00000000U, 0x739F78EEU }, /* XSUM_XXH32_testdata[1912] */
    {  956, 0x9E3779B1U, 0x49771B8AU }, /* XSUM_XXH32_testdata[1913] */
    {  957, 0x00000000U, 0xDE23CFCFU }, /* XSUM_XXH32_testdata[1914] */
    {  957, 0x9E3779B1U, 0xF0D2D9D7U }, /* XSUM_XXH32_testdata[1915] */
    {  958, 0x00000000U, 0xBDD6F4C1U }, /* XSUM_XXH32_testdata[1916] */
    {  958, 0x9E3779B1U, 0x363CA0A6U }, /* XSUM_XXH32_testdata[1917] */
    {  959, 0x00000000U, 0x2A85181AU }, /* XSUM_XXH32_testdata[1918] */
    {  959, 0x9E3779B1U, 0x7CE3C843U }, /* XSUM_XXH32_testdata[1919] */
    {  960, 0x00000000U, 0x93E1BD3CU }, /* XSUM_XXH32_testdata[1920] */
    {  960, 0x9E3779B1U, 0x89A288CFU }, /* XSUM_XXH32_testdata[1921] */
    {  961, 0x00000000U, 0xD94CFDC8U }, /* XSUM_XXH32_testdata[1922] */
    {  961, 0x9E3779B1U, 0xBC19A71AU }, /* XSUM_XXH32_testdata[1923] */
    {  962, 0x00000000U, 0xC174D2F7U }, /* XSUM_XXH32_testdata[1924] */
    {  962, 0x9E3779B1U, 0x953C5DD6U }, /* XSUM_XXH32_testdata[1925] */
    {  963, 0x00000000U, 0x8795CD3FU }, /* XSUM_XXH32_testdata[1926] */
    {  963, 0x9E3779B1U, 0x0A3071C8U }, /* XSUM_XXH32_testdata[1927] */
    {  964, 0x00000000U, 0xED5C5EF5U }, /* XSUM_XXH32_testdata[1928] */
    {  964, 0x9E3779B1U, 0x94F63473U }, /* XSUM_XXH32_testdata[1929] */
    {  965, 0x00000000U, 0x71C1F386U }, /* XSUM_XXH32_testdata[1930] */
    {  965, 0x9E3779B1U, 0x5A0A59F9U }, /* XSUM_XXH32_testdata[1931] */
    {  966, 0x00000000U, 0xF6DE7763U }, /* XSUM_XXH32_testdata[1932] */
    {  966, 0x9E3779B1U, 0xC2F383ADU }, /* XSUM_XXH32_testdata[1933] */
    {  967, 0x00000000U, 0x90EAAAAFU }, /* XSUM_XXH32_testdata[1934] */
    {  967, 0x9E3779B1U, 0x2D44AE3FU }, /* XSUM_XXH32_testdata[1935] */
    {  968, 0x00000000U, 0xFAFC5822U }, /* XSUM_XXH32_testdata[1936] */
    {  968, 0x9E3779B1U, 0x91FC5EDBU }, /* XSUM_XXH32_testdata[1937] */
    {  969, 0x00000000U, 0x3E9EDE6FU }, /* XSUM_XXH32_testdata[1938] */
    {  969, 0x9E3779B1U, 0x6182457CU }, /* XSUM_XXH32_testdata[1939] */
    {  970, 0x00000000U, 0xBBEA0543U }, /* XSUM_XXH32_testdata[1940] */
    {  970, 0x9E3779B1U, 0x069DEDF2U }, /* XSUM_XXH32_testdata[1941] */
    {  971, 0x00000000U, 0x1BECCC7FU }, /* XSUM_XXH32_testdata[1942] */
    {  971, 0x9E3779B1U, 0x5A2067D5U }, /* XSUM_XXH32_testdata[1943] */
    {  972, 0x00000000U, 0x2A6A0B06U }, /* XSUM_XXH32_testdata[1944] */
    {  972, 0x9E3779B1U, 0xCC3897B7U }, /* XSUM_XXH32_testdata[1945] */
    {  973, 0x00000000U, 0xD15F6FEAU }, /* XSUM_XXH32_testdata[1946] */
    {  973, 0x9E3779B1U, 0x91C4A037U }, /* XSUM_XXH32_testdata[1947] */
    {  974, 0x00000000U, 0xADB16A16U }, /* XSUM_XXH32_testdata[1948] */
    {  974, 0x9E3779B1U, 0xBB605662U }, /* XSUM_XXH32_testdata[1949] */
    {  975, 0x00000000U, 0xD8C78CAEU }, /* XSUM_XXH32_testdata[1950] */
    {  975, 0x9E3779B1U, 0x52F2C394U }, /* XSUM_XXH32_testdata[1951] */
    {  976, 0x00000000U, 0xF97B4816U }, /* XSUM_XXH32_testdata[1952] */
    {  976, 0x9E3779B1U, 0x1207ADA6U }, /* XSUM_XXH32_testdata[1953] */
    {  977, 0x00000000U, 0x77E56C8FU }, /* XSUM_XXH32_testdata[1954] */
    {  977, 0x9E3779B1U, 0x8DB37A95U }, /* XSUM_XXH32_testdata[1955] */
    {  978, 0x00000000U, 0x3819C3C4U }, /* XSUM_XXH32_testdata[1956] */
    {  978, 0x9E3779B1U, 0xD986DDA8U }, /* XSUM_XXH32_testdata[1957] */
    {  979, 0x00000000U, 0xA06EEB5EU }, /* XSUM_XXH32_testdata[1958] */
    {  979, 0x9E3779B1U, 0xCC9CAE2FU }, /* XSUM_XXH32_testdata[1959] */
    {  980, 0x00000000U, 0x74F8A163U }, /* XSUM_XXH32_testdata[1960] */
    {  980, 0x9E3779B1U, 0x1B694F97U }, /* XSUM_XXH32_testdata[1961] */
    {  981, 0x00000000U, 0x0D9030F4U }, /* XSUM_XXH32_testdata[1962] */
    {  981, 0x9E3779B1U, 0xC5C3D737U }, /* XSUM_XXH32_testdata[1963] */
    {  982, 0x00000000U, 0x188F83C8U }, /* XSUM_XXH32_testdata[1964] */
    {  982, 0x9E3779B1U, 0x468E9E56U }, /* XSUM_XXH32_testdata[1965] */
    {  983, 0x00000000U, 0x0506C18BU }, /* XSUM_XXH32_testdata[1966] */
    {  983, 0x9E3779B1U, 0x257A6015U }, /* XSUM_XXH32_testdata[1967] */
    {  984, 0x00000000U, 0xB7353DC6U }, /* XSUM_XXH32_testdata[1968] */
    {  984, 0x9E3779B1U, 0x65636F3CU }, /* XSUM_XXH32_testdata[1969] */
    {  985, 0x00000000U, 0x4A096F56U }, /* XSUM_XXH32_testdata[1970] */
    {  985, 0x9E3779B1U, 0x43F37A61U }, /* XSUM_XXH32_testdata[1971] */
    {  986, 0x00000000U, 0x7A00909CU }, /* XSUM_XXH32_testdata[1972] */
    {  986, 0x9E3779B1U, 0xCBEC7147U }, /* XSUM_XXH32_testdata[1973] */
    {  987, 0x00000000U, 0x31E3A48EU }, /* XSUM_XXH32_testdata[1974] */
    {  987, 0x9E3779B1U, 0xE8344DC5U }, /* XSUM_XXH32_testdata[1975] */
    {  988, 0x00000000U, 0x3A0D29FDU }, /* XSUM_XXH32_testdata[1976] */
    {  988, 0x9E3779B1U, 0x536C8206U }, /* XSUM_XXH32_testdata[1977] */
    {  989, 0x00000000U, 0xC5B7A4DDU }, /* XSUM_XXH32_testdata[1978] */
    {  989, 0x9E3779B1U, 0xCB9642ADU }, /* XSUM_XXH32_testdata[1979] */
    {  990, 0x00000000U, 0x17CF9745U }, /* XSUM_XXH32_testdata[1980] */
    {  990, 0x9E3779B1U, 0xEB0493B9U }, /* XSUM_XXH32_testdata[1981] */
    {  991, 0x00000000U, 0xDBD6EFD9U }, /* XSUM_XXH32_testdata[1982] */
    {  991, 0x9E3779B1U, 0xF8175615U }, /* XSUM_XXH32_testdata[1983] */
    {  992, 0x00000000U, 0xFF072340U }, /* XSUM_XXH32_testdata[1984] */
    {  992, 0x9E3779B1U, 0xF683DCEDU }, /* XSUM_XXH32_testdata[1985] */
    {  993, 0x00000000U, 0x07C9E5E6U }, /* XSUM_XXH32_testdata[1986] */
    {  993, 0x9E3779B1U, 0x4F3CBD36U }, /* XSUM_XXH32_testdata[1987] */
    {  994, 0x00000000U, 0x1D20BCE5U }, /* XSUM_XXH32_testdata[1988] */
    {  994, 0x9E3779B1U, 0x13A765F5U }, /* XSUM_XXH32_testdata[1989] */
    {  995, 0x00000000U, 0x1479E861U }, /* XSUM_XXH32_testdata[1990] */
    {  995, 0x9E3779B1U, 0x9859B8A4U }, /* XSUM_XXH32_testdata[1991] */
    {  996, 0x00000000U, 0x1071C16FU }, /* XSUM_XXH32_testdata[1992] */
    {  996, 0x9E3779B1U, 0x3648A1FAU }, /* XSUM_XXH32_testdata[1993] */
    {  997, 0x00000000U, 0xAA229676U }, /* XSUM_XXH32_testdata[1994] */
    {  997, 0x9E3779B1U, 0x3DBEDEDCU }, /* XSUM_XXH32_testdata[1995] */
    {  998, 0x00000000U, 0xF927434EU }, /* XSUM_XXH32_testdata[1996] */
    {  998, 0x9E3779B1U, 0x362876E7U }, /* XSUM_XXH32_testdata[1997] */
    {  999, 0x00000000U, 0x959FAFE8U }, /* XSUM_XXH32_testdata[1998] */
    {  999, 0x9E3779B1U, 0x46EA763FU }, /* XSUM_XXH32_testdata[1999] */
    { 1000, 0x00000000U, 0x2052D698U }, /* XSUM_XXH32_testdata[2000] */
    { 1000, 0x9E3779B1U, 0xD38B6679U }, /* XSUM_XXH32_testdata[2001] */
    { 1001, 0x00000000U, 0x2EAA0E22U }, /* XSUM_XXH32_testdata[2002] */
    { 1001, 0x9E3779B1U, 0x175578E1U }, /* XSUM_XXH32_testdata[2003] */
    { 1002, 0x00000000U, 0x69E28DCFU }, /* XSUM_XXH32_testdata[2004] */
    { 1002, 0x9E3779B1U, 0x9B74A874U }, /* XSUM_XXH32_testdata[2005] */
    { 1003, 0x00000000U, 0x91D77759U }, /* XSUM_XXH32_testdata[2006] */
    { 1003, 0x9E3779B1U, 0xC7EAE51DU }, /* XSUM_XXH32_testdata[2007] */
    { 1004, 0x00000000U, 0x749A0B26U }, /* XSUM_XXH32_testdata[2008] */
    { 1004, 0x9E3779B1U, 0x71D4363AU }, /* XSUM_XXH32_testdata[2009] */
    { 1005, 0x00000000U, 0x5FCDC293U }, /* XSUM_XXH32_testdata[2010] */
    { 1005, 0x9E3779B1U, 0xD9DFC560U }, /* XSUM_XXH32_testdata[2011] */
    { 1006, 0x00000000U, 0x9A7312D6U }, /* XSUM_XXH32_testdata[2012] */
    { 1006, 0x9E3779B1U, 0x029B937DU }, /* XSUM_XXH32_testdata[2013] */
    { 1007, 0x00000000U, 0x048E1C88U }, /* XSUM_XXH32_testdata[2014] */
    { 1007, 0x9E3779B1U, 0xE2F0F1DCU }, /* XSUM_XXH32_testdata[2015] */
    { 1008, 0x00000000U, 0x4A2E1A5EU }, /* XSUM_XXH32_testdata[2016] */
    { 1008, 0x9E3779B1U, 0x60AAE1B0U }, /* XSUM_XXH32_testdata[2017] */
    { 1009, 0x00000000U, 0x25C1658CU }, /* XSUM_XXH32_testdata[2018] */
    { 1009, 0x9E3779B1U, 0x7913AD41U }, /* XSUM_XXH32_testdata[2019] */
    { 1010, 0x00000000U, 0x5AC9C738U }, /* XSUM_XXH32_testdata[2020] */
    { 1010, 0x9E3779B1U, 0x9D671F2DU }, /* XSUM_XXH32_testdata[2021] */
    { 1011, 0x00000000U, 0x3FEBFA72U }, /* XSUM_XXH32_testdata[2022] */
    { 1011, 0x9E3779B1U, 0xE0B18591U }, /* XSUM_XXH32_testdata[2023] */
    { 1012, 0x00000000U, 0xC9D40D6DU }, /* XSUM_XXH32_testdata[2024] */
    { 1012, 0x9E3779B1U, 0xBE34FA85U }, /* XSUM_XXH32_testdata[2025] */
    { 1013, 0x00000000U, 0x9ADC9853U }, /* XSUM_XXH32_testdata[2026] */
    { 1013, 0x9E3779B1U, 0xF0DDB499U }, /* XSUM_XXH32_testdata[2027] */
    { 1014, 0x00000000U, 0xC5B8FFCEU }, /* XSUM_XXH32_testdata[2028] */
    { 1014, 0x9E3779B1U, 0x91C3CF2BU }, /* XSUM_XXH32_testdata[2029] */
    { 1015, 0x00000000U, 0x39D712DCU }, /* XSUM_XXH32_testdata[2030] */
    { 1015, 0x9E3779B1U, 0x16A75B67U }, /* XSUM_XXH32_testdata[2031] */
    { 1016, 0x00000000U, 0x93AA1B3CU }, /* XSUM_XXH32_testdata[2032] */
    { 1016, 0x9E3779B1U, 0x66A9A7BFU }, /* XSUM_XXH32_testdata[2033] */
    { 1017, 0x00000000U, 0x35963E31U }, /* XSUM_XXH32_testdata[2034] */
    { 1017, 0x9E3779B1U, 0x0A347870U }, /* XSUM_XXH32_testdata[2035] */
    { 1018, 0x00000000U, 0xE04FB799U }, /* XSUM_XXH32_testdata[2036] */
    { 1018, 0x9E3779B1U, 0x997B946BU }, /* XSUM_XXH32_testdata[2037] */
    { 1019, 0x00000000U, 0xDB06CDA3U }, /* XSUM_XXH32_testdata[2038] */
    { 1019, 0x9E3779B1U, 0xBA96DA73U }, /* XSUM_XXH32_testdata[2039] */
    { 1020, 0x00000000U, 0xEAC224C3U }, /* XSUM_XXH32_testdata[2040] */
    { 1020, 0x9E3779B1U, 0x9150FB03U }, /* XSUM_XXH32_testdata[2041] */
    { 1021, 0x00000000U, 0xC634C8A4U }, /* XSUM_XXH32_testdata[2042] */
    { 1021, 0x9E3779B1U, 0xED35004FU }, /* XSUM_XXH32_testdata[2043] */
    { 1022, 0x00000000U, 0x92C9F946U }, /* XSUM_XXH32_testdata[2044] */
    { 1022, 0x9E3779B1U, 0x8F9EEE88U }, /* XSUM_XXH32_testdata[2045] */
    { 1023, 0x00000000U, 0x57AA590FU }, /* XSUM_XXH32_testdata[2046] */
    { 1023, 0x9E3779B1U, 0x40CF6B0AU }, /* XSUM_XXH32_testdata[2047] */
    { 1024, 0x00000000U, 0xC08E0A35U }, /* XSUM_XXH32_testdata[2048] */
    { 1024, 0x9E3779B1U, 0x1D62EA25U }, /* XSUM_XXH32_testdata[2049] */
    { 1025, 0x00000000U, 0x75B3B8A1U }, /* XSUM_XXH32_testdata[2050] */
    { 1025, 0x9E3779B1U, 0xE3FB365AU }, /* XSUM_XXH32_testdata[2051] */
    { 1026, 0x00000000U, 0x8A547721U }, /* XSUM_XXH32_testdata[2052] */
    { 1026, 0x9E3779B1U, 0x4F243BD2U }, /* XSUM_XXH32_testdata[2053] */
    { 1027, 0x00000000U, 0x01C7549BU }, /* XSUM_XXH32_testdata[2054] */
    { 1027, 0x9E3779B1U, 0xB86E9BB2U }, /* XSUM_XXH32_testdata[2055] */
    { 1028, 0x00000000U, 0x9FD0C14DU }, /* XSUM_XXH32_testdata[2056] */
    { 1028, 0x9E3779B1U, 0x293B695CU }, /* XSUM_XXH32_testdata[2057] */
    { 1029, 0x00000000U, 0x879686E2U }, /* XSUM_XXH32_testdata[2058] */
    { 1029, 0x9E3779B1U, 0x59900271U }, /* XSUM_XXH32_testdata[2059] */
    { 1030, 0x00000000U, 0x2294579FU }, /* XSUM_XXH32_testdata[2060] */
    { 1030, 0x9E3779B1U, 0xDC2AB8A5U }, /* XSUM_XXH32_testdata[2061] */
    { 1031, 0x00000000U, 0xB2E43FE4U }, /* XSUM_XXH32_testdata[2062] */
    { 1031, 0x9E3779B1U, 0x13F41993U }, /* XSUM_XXH32_testdata[2063] */
    { 1032, 0x00000000U, 0x2A7DA48DU }, /* XSUM_XXH32_testdata[2064] */
    { 1032, 0x9E3779B1U, 0x534C0B43U }, /* XSUM_XXH32_testdata[2065] */
    { 1033, 0x00000000U, 0x5B83A015U }, /* XSUM_XXH32_testdata[2066] */
    { 1033, 0x9E3779B1U, 0xDABAC127U }, /* XSUM_XXH32_testdata[2067] */
    { 1034, 0x00000000U, 0x21DA5779U }, /* XSUM_XXH32_testdata[2068] */
    { 1034, 0x9E3779B1U, 0xBFE62480U }, /* XSUM_XXH32_testdata[2069] */
    { 1035, 0x00000000U, 0xE0985119U }, /* XSUM_XXH32_testdata[2070] */
    { 1035, 0x9E3779B1U, 0xEE508960U }, /* XSUM_XXH32_testdata[2071] */
    { 1036, 0x00000000U, 0x69F48301U }, /* XSUM_XXH32_testdata[2072] */
    { 1036, 0x9E3779B1U, 0xE8E2CABAU }, /* XSUM_XXH32_testdata[2073] */
    { 1037, 0x00000000U, 0x9FA6B478U }, /* XSUM_XXH32_testdata[2074] */
    { 1037, 0x9E3779B1U, 0x34F0858AU }, /* XSUM_XXH32_testdata[2075] */
    { 1038, 0x00000000U, 0x6F710A1EU }, /* XSUM_XXH32_testdata[2076] */
    { 1038, 0x9E3779B1U, 0xF2F3BC16U }, /* XSUM_XXH32_testdata[2077] */
    { 1039, 0x00000000U, 0x27AACA5BU }, /* XSUM_XXH32_testdata[2078] */
    { 1039, 0x9E3779B1U, 0x43E48B1FU }, /* XSUM_XXH32_testdata[2079] */
    { 1040, 0x00000000U, 0x1A5AEF00U }, /* XSUM_XXH32_testdata[2080] */
    { 1040, 0x9E3779B1U, 0xA1D1FF9CU }, /* XSUM_XXH32_testdata[2081] */
    { 1041, 0x00000000U, 0xC7CC8B3AU }, /* XSUM_XXH32_testdata[2082] */
    { 1041, 0x9E3779B1U, 0xDA22CDFAU }, /* XSUM_XXH32_testdata[2083] */
    { 1042, 0x00000000U, 0x6D5359DBU }, /* XSUM_XXH32_testdata[2084] */
    { 1042, 0x9E3779B1U, 0x16878CF8U }, /* XSUM_XXH32_testdata[2085] */
    { 1043, 0x00000000U, 0x4EDB8EE4U }, /* XSUM_XXH32_testdata[2086] */
    { 1043, 0x9E3779B1U, 0x8B14C369U }, /* XSUM_XXH32_testdata[2087] */
    { 1044, 0x00000000U, 0xDB5DE323U }, /* XSUM_XXH32_testdata[2088] */
    { 1044, 0x9E3779B1U, 0x045C871DU }, /* XSUM_XXH32_testdata[2089] */
    { 1045, 0x00000000U, 0xBBE68A80U }, /* XSUM_XXH32_testdata[2090] */
    { 1045, 0x9E3779B1U, 0x7D011233U }, /* XSUM_XXH32_testdata[2091] */
    { 1046, 0x00000000U, 0xF9E7FC3FU }, /* XSUM_XXH32_testdata[2092] */
    { 1046, 0x9E3779B1U, 0xA0D9661FU }, /* XSUM_XXH32_testdata[2093] */
    { 1047, 0x00000000U, 0x90AD6395U }, /* XSUM_XXH32_testdata[2094] */
    { 1047, 0x9E3779B1U, 0x5AC7215BU }, /* XSUM_XXH32_testdata[2095] */
    { 1048, 0x00000000U, 0x7945197AU }, /* XSUM_XXH32_testdata[2096] */
    { 1048, 0x9E3779B1U, 0x3C3E4834U }, /* XSUM_XXH32_testdata[2097] */
    { 1049, 0x00000000U, 0x64DD8B17U }, /* XSUM_XXH32_testdata[2098] */
    { 1049, 0x9E3779B1U, 0xA23725ABU }, /* XSUM_XXH32_testdata[2099] */
    { 1050, 0x00000000U, 0xA8E664CEU }, /* XSUM_XXH32_testdata[2100] */
    { 1050, 0x9E3779B1U, 0x37018E95U }, /* XSUM_XXH32_testdata[2101] */
    { 1051, 0x00000000U, 0xE2FC3D22U }, /* XSUM_XXH32_testdata[2102] */
    { 1051, 0x9E3779B1U, 0x0DAAAC18U }, /* XSUM_XXH32_testdata[2103] */
    { 1052, 0x00000000U, 0x57336162U }, /* XSUM_XXH32_testdata[2104] */
    { 1052, 0x9E3779B1U, 0x1410CB8AU }, /* XSUM_XXH32_testdata[2105] */
    { 1053, 0x00000000U, 0xACC8EAA8U }, /* XSUM_XXH32_testdata[2106] */
    { 1053, 0x9E3779B1U, 0x6B0B55CDU }, /* XSUM_XXH32_testdata[2107] */
    { 1054, 0x00000000U, 0xF1FDACF5U }, /* XSUM_XXH32_testdata[2108] */
    { 1054, 0x9E3779B1U, 0x023B6E05U }, /* XSUM_XXH32_testdata[2109] */
    { 1055, 0x00000000U, 0x9ADE3125U }, /* XSUM_XXH32_testdata[2110] */
    { 1055, 0x9E3779B1U, 0x21D168B8U }, /* XSUM_XXH32_testdata[2111] */
    { 1056, 0x00000000U, 0x2360F02DU }, /* XSUM_XXH32_testdata[2112] */
    { 1056, 0x9E3779B1U, 0x168528ABU }, /* XSUM_XXH32_testdata[2113] */
    { 1057, 0x00000000U, 0x558C8FBFU }, /* XSUM_XXH32_testdata[2114] */
    { 1057, 0x9E3779B1U, 0x6277C8FCU }, /* XSUM_XXH32_testdata[2115] */
    { 1058, 0x00000000U, 0x3972BBDFU }, /* XSUM_XXH32_testdata[2116] */
    { 1058, 0x9E3779B1U, 0xEC06EA1FU }, /* XSUM_XXH32_testdata[2117] */
    { 1059, 0x00000000U, 0x5AD25CF0U }, /* XSUM_XXH32_testdata[2118] */
    { 1059, 0x9E3779B1U, 0xBF038D64U }, /* XSUM_XXH32_testdata[2119] */
    { 1060, 0x00000000U, 0x87BB3AEDU }, /* XSUM_XXH32_testdata[2120] */
    { 1060, 0x9E3779B1U, 0xAC417030U }, /* XSUM_XXH32_testdata[2121] */
    { 1061, 0x00000000U, 0x3CA255CEU }, /* XSUM_XXH32_testdata[2122] */
    { 1061, 0x9E3779B1U, 0x34BAFD11U }, /* XSUM_XXH32_testdata[2123] */
    { 1062, 0x00000000U, 0xBFED7A26U }, /* XSUM_XXH32_testdata[2124] */
    { 1062, 0x9E3779B1U, 0xC2F51083U }, /* XSUM_XXH32_testdata[2125] */
    { 1063, 0x00000000U, 0x177C5860U }, /* XSUM_XXH32_testdata[2126] */
    { 1063, 0x9E3779B1U, 0xB008BA49U }, /* XSUM_XXH32_testdata[2127] */
    { 1064, 0x00000000U, 0xBD827070U }, /* XSUM_XXH32_testdata[2128] */
    { 1064, 0x9E3779B1U, 0x678934F0U }, /* XSUM_XXH32_testdata[2129] */
    { 1065, 0x00000000U, 0xB3568AD2U }, /* XSUM_XXH32_testdata[2130] */
    { 1065, 0x9E3779B1U, 0x67DEDF17U }, /* XSUM_XXH32_testdata[2131] */
    { 1066, 0x00000000U, 0x82EAE591U }, /* XSUM_XXH32_testdata[2132] */
    { 1066, 0x9E3779B1U, 0xF36D85BBU }, /* XSUM_XXH32_testdata[2133] */
    { 1067, 0x00000000U, 0x773A5E32U }, /* XSUM_XXH32_testdata[2134] */
    { 1067, 0x9E3779B1U, 0x580B1974U }, /* XSUM_XXH32_testdata[2135] */
    { 1068, 0x00000000U, 0xCA2C3486U }, /* XSUM_XXH32_testdata[2136] */
    { 1068, 0x9E3779B1U, 0x947F4341U }, /* XSUM_XXH32_testdata[2137] */
    { 1069, 0x00000000U, 0xFBC29794U }, /* XSUM_XXH32_testdata[2138] */
    { 1069, 0x9E3779B1U, 0x0D564165U }, /* XSUM_XXH32_testdata[2139] */
    { 1070, 0x00000000U, 0x34ADD445U }, /* XSUM_XXH32_testdata[2140] */
    { 1070, 0x9E3779B1U, 0xB3458EB4U }, /* XSUM_XXH32_testdata[2141] */
    { 1071, 0x00000000U, 0x3D40EE5AU }, /* XSUM_XXH32_testdata[2142] */
    { 1071, 0x9E3779B1U, 0x51B93541U }, /* XSUM_XXH32_testdata[2143] */
    { 1072, 0x00000000U, 0x54EE3A70U }, /* XSUM_XXH32_testdata[2144] */
    { 1072, 0x9E3779B1U, 0x37C0DFCDU }, /* XSUM_XXH32_testdata[2145] */
    { 1073, 0x00000000U, 0x473346C9U }, /* XSUM_XXH32_testdata[2146] */
    { 1073, 0x9E3779B1U, 0x10F112D8U }, /* XSUM_XXH32_testdata[2147] */
    { 1074, 0x00000000U, 0x4AF885E3U }, /* XSUM_XXH32_testdata[2148] */
    { 1074, 0x9E3779B1U, 0x70044FC2U }, /* XSUM_XXH32_testdata[2149] */
    { 1075, 0x00000000U, 0x198358B8U }, /* XSUM_XXH32_testdata[2150] */
    { 1075, 0x9E3779B1U, 0x9294EA2AU }, /* XSUM_XXH32_testdata[2151] */
    { 1076, 0x00000000U, 0x9DD6EF1AU }, /* XSUM_XXH32_testdata[2152] */
    { 1076, 0x9E3779B1U, 0x46235CBCU }, /* XSUM_XXH32_testdata[2153] */
    { 1077, 0x00000000U, 0x4CC83416U }, /* XSUM_XXH32_testdata[2154] */
    { 1077, 0x9E3779B1U, 0x707C64ECU }, /* XSUM_XXH32_testdata[2155] */
    { 1078, 0x00000000U, 0x8BDDC22EU }, /* XSUM_XXH32_testdata[2156] */
    { 1078, 0x9E3779B1U, 0xFF932B8BU }, /* XSUM_XXH32_testdata[2157] */
    { 1079, 0x00000000U, 0x24144C82U }, /* XSUM_XXH32_testdata[2158] */
    { 1079, 0x9E3779B1U, 0xBF5B8D89U }, /* XSUM_XXH32_testdata[2159] */
    { 1080, 0x00000000U, 0x628B9202U }, /* XSUM_XXH32_testdata[2160] */
    { 1080, 0x9E3779B1U, 0x51139113U }, /* XSUM_XXH32_testdata[2161] */
    { 1081, 0x00000000U, 0xF5638DCEU }, /* XSUM_XXH32_testdata[2162] */
    { 1081, 0x9E3779B1U, 0x7025E1D7U }, /* XSUM_XXH32_testdata[2163] */
    { 1082, 0x00000000U, 0x7FA5BC40U }, /* XSUM_XXH32_testdata[2164] */
    { 1082, 0x9E3779B1U, 0x359E9DFDU }, /* XSUM_XXH32_testdata[2165] */
    { 1083, 0x00000000U, 0x5D45BE3BU }, /* XSUM_XXH32_testdata[2166] */
    { 1083, 0x9E3779B1U, 0x05136309U }, /* XSUM_XXH32_testdata[2167] */
    { 1084, 0x00000000U, 0xDB9406E9U }, /* XSUM_XXH32_testdata[2168] */
    { 1084, 0x9E3779B1U, 0xA2F2FB71U }, /* XSUM_XXH32_testdata[2169] */
    { 1085, 0x00000000U, 0x86CC2786U }, /* XSUM_XXH32_testdata[2170] */
    { 1085, 0x9E3779B1U, 0xFF60906BU }, /* XSUM_XXH32_testdata[2171] */
    { 1086, 0x00000000U, 0x7D782445U }, /* XSUM_XXH32_testdata[2172] */
    { 1086, 0x9E3779B1U, 0x5B819CFDU }, /* XSUM_XXH32_testdata[2173] */
    { 1087, 0x00000000U, 0xBDF23638U }, /* XSUM_XXH32_testdata[2174] */
    { 1087, 0x9E3779B1U, 0xA840336EU }, /* XSUM_XXH32_testdata[2175] */
    { 1088, 0x00000000U, 0x23197D27U }, /* XSUM_XXH32_testdata[2176] */
    { 1088, 0x9E3779B1U, 0x4C7C9667U }, /* XSUM_XXH32_testdata[2177] */
    { 1089, 0x00000000U, 0xD8C0B8CCU }, /* XSUM_XXH32_testdata[2178] */
    { 1089, 0x9E3779B1U, 0x379C7B23U }, /* XSUM_XXH32_testdata[2179] */
    { 1090, 0x00000000U, 0x17228791U }, /* XSUM_XXH32_testdata[2180] */
    { 1090, 0x9E3779B1U, 0x61FA775EU }, /* XSUM_XXH32_testdata[2181] */
    { 1091, 0x00000000U, 0x780389C1U }, /* XSUM_XXH32_testdata[2182] */
    { 1091, 0x9E3779B1U, 0x73D6B2A1U }, /* XSUM_XXH32_testdata[2183] */
    { 1092, 0x00000000U, 0x60A4F630U }, /* XSUM_XXH32_testdata[2184] */
    { 1092, 0x9E3779B1U, 0xBDE591C6U }, /* XSUM_XXH32_testdata[2185] */
    { 1093, 0x00000000U, 0xDE644393U }, /* XSUM_XXH32_testdata[2186] */
    { 1093, 0x9E3779B1U, 0x5A500945U }, /* XSUM_XXH32_testdata[2187] */
    { 1094, 0x00000000U, 0x828B6985U }, /* XSUM_XXH32_testdata[2188] */
    { 1094, 0x9E3779B1U, 0x4337D8A6U }, /* XSUM_XXH32_testdata[2189] */
    { 1095, 0x00000000U, 0x8D4BEE0CU }, /* XSUM_XXH32_testdata[2190] */
    { 1095, 0x9E3779B1U, 0x78107E43U }, /* XSUM_XXH32_testdata[2191] */
    { 1096, 0x00000000U, 0x6DCEDB65U }, /* XSUM_XXH32_testdata[2192] */
    { 1096, 0x9E3779B1U, 0x7170920FU }, /* XSUM_XXH32_testdata[2193] */
    { 1097, 0x00000000U, 0xDE059DC1U }, /* XSUM_XXH32_testdata[2194] */
    { 1097, 0x9E3779B1U, 0x4B591746U }, /* XSUM_XXH32_testdata[2195] */
    { 1098, 0x00000000U, 0x651C323AU }, /* XSUM_XXH32_testdata[2196] */
    { 1098, 0x9E3779B1U, 0xD8919B48U }, /* XSUM_XXH32_testdata[2197] */
    { 1099, 0x00000000U, 0x29B6CED7U }, /* XSUM_XXH32_testdata[2198] */
    { 1099, 0x9E3779B1U, 0xCB69A781U }, /* XSUM_XXH32_testdata[2199] */
    { 1100, 0x00000000U, 0x648280E2U }, /* XSUM_XXH32_testdata[2200] */
    { 1100, 0x9E3779B1U, 0xA1955AC2U }, /* XSUM_XXH32_testdata[2201] */
    { 1101, 0x00000000U, 0x10985119U }, /* XSUM_XXH32_testdata[2202] */
    { 1101, 0x9E3779B1U, 0x89D6293EU }, /* XSUM_XXH32_testdata[2203] */
    { 1102, 0x00000000U, 0x8D5A31ADU }, /* XSUM_XXH32_testdata[2204] */
    { 1102, 0x9E3779B1U, 0x365F03FAU }, /* XSUM_XXH32_testdata[2205] */
    { 1103, 0x00000000U, 0x6939913FU }, /* XSUM_XXH32_testdata[2206] */
    { 1103, 0x9E3779B1U, 0xD066F511U }, /* XSUM_XXH32_testdata[2207] */
    { 1104, 0x00000000U, 0xD9EBC27CU }, /* XSUM_XXH32_testdata[2208] */
    { 1104, 0x9E3779B1U, 0x07CCDEECU }, /* XSUM_XXH32_testdata[2209] */
    { 1105, 0x00000000U, 0x45DCD964U }, /* XSUM_XXH32_testdata[2210] */
    { 1105, 0x9E3779B1U, 0x7B4B66E2U }, /* XSUM_XXH32_testdata[2211] */
    { 1106, 0x00000000U, 0xD214E256U }, /* XSUM_XXH32_testdata[2212] */
    { 1106, 0x9E3779B1U, 0x74A40958U }, /* XSUM_XXH32_testdata[2213] */
    { 1107, 0x00000000U, 0x9329C598U }, /* XSUM_XXH32_testdata[2214] */
    { 1107, 0x9E3779B1U, 0x8DC68A56U }, /* XSUM_XXH32_testdata[2215] */
    { 1108, 0x00000000U, 0x43C5D077U }, /* XSUM_XXH32_testdata[2216] */
    { 1108, 0x9E3779B1U, 0x328844F5U }, /* XSUM_XXH32_testdata[2217] */
    { 1109, 0x00000000U, 0xDF2535E4U }, /* XSUM_XXH32_testdata[2218] */
    { 1109, 0x9E3779B1U, 0xD1ACD1CFU }, /* XSUM_XXH32_testdata[2219] */
    { 1110, 0x00000000U, 0xDE6CE5DBU }, /* XSUM_XXH32_testdata[2220] */
    { 1110, 0x9E3779B1U, 0x0E2B868FU }, /* XSUM_XXH32_testdata[2221] */
    { 1111, 0x00000000U, 0xAB308EBDU }, /* XSUM_XXH32_testdata[2222] */
    { 1111, 0x9E3779B1U, 0xF35DE130U }, /* XSUM_XXH32_testdata[2223] */
    { 1112, 0x00000000U, 0xAD69BA13U }, /* XSUM_XXH32_testdata[2224] */
    { 1112, 0x9E3779B1U, 0x8A9C5F48U }, /* XSUM_XXH32_testdata[2225] */
    { 1113, 0x00000000U, 0xDD3CC30BU }, /* XSUM_XXH32_testdata[2226] */
    { 1113, 0x9E3779B1U, 0x6920848BU }, /* XSUM_XXH32_testdata[2227] */
    { 1114, 0x00000000U, 0xBB8E77EDU }, /* XSUM_XXH32_testdata[2228] */
    { 1114, 0x9E3779B1U, 0xD3FE90DDU }, /* XSUM_XXH32_testdata[2229] */
    { 1115, 0x00000000U, 0x082F674CU }, /* XSUM_XXH32_testdata[2230] */
    { 1115, 0x9E3779B1U, 0x3A405F30U }, /* XSUM_XXH32_testdata[2231] */
    { 1116, 0x00000000U, 0xAED38B9FU }, /* XSUM_XXH32_testdata[2232] */
    { 1116, 0x9E3779B1U, 0x275E3165U }, /* XSUM_XXH32_testdata[2233] */
    { 1117, 0x00000000U, 0x93E3C004U }, /* XSUM_XXH32_testdata[2234] */
    { 1117, 0x9E3779B1U, 0xAD6D4403U }, /* XSUM_XXH32_testdata[2235] */
    { 1118, 0x00000000U, 0x47B760C6U }, /* XSUM_XXH32_testdata[2236] */
    { 1118, 0x9E3779B1U, 0x2E1601C6U }, /* XSUM_XXH32_testdata[2237] */
    { 1119, 0x00000000U, 0x16BC49ABU }, /* XSUM_XXH32_testdata[2238] */
    { 1119, 0x9E3779B1U, 0x5EA405B9U }, /* XSUM_XXH32_testdata[2239] */
    { 1120, 0x00000000U, 0xC59EC900U }, /* XSUM_XXH32_testdata[2240] */
    { 1120, 0x9E3779B1U, 0xB34C0AD4U }, /* XSUM_XXH32_testdata[2241] */
    { 1121, 0x00000000U, 0xF32BE6D8U }, /* XSUM_XXH32_testdata[2242] */
    { 1121, 0x9E3779B1U, 0x0C7A26CBU }, /* XSUM_XXH32_testdata[2243] */
    { 1122, 0x00000000U, 0xCD4DEB83U }, /* XSUM_XXH32_testdata[2244] */
    { 1122, 0x9E3779B1U, 0xD9B6086FU }, /* XSUM_XXH32_testdata[2245] */
    { 1123, 0x00000000U, 0x5B563DB9U }, /* XSUM_XXH32_testdata[2246] */
    { 1123, 0x9E3779B1U, 0x8F011FEAU }, /* XSUM_XXH32_testdata[2247] */
    { 1124, 0x00000000U, 0x1D7BF599U }, /* XSUM_XXH32_testdata[2248] */
    { 1124, 0x9E3779B1U, 0x4A2D8907U }, /* XSUM_XXH32_testdata[2249] */
    { 1125, 0x00000000U, 0xC73448C3U }, /* XSUM_XXH32_testdata[2250] */
    { 1125, 0x9E3779B1U, 0xB8578745U }, /* XSUM_XXH32_testdata[2251] */
    { 1126, 0x00000000U, 0x9681D013U }, /* XSUM_XXH32_testdata[2252] */
    { 1126, 0x9E3779B1U, 0x9FBAE5F8U }, /* XSUM_XXH32_testdata[2253] */
    { 1127, 0x00000000U, 0x7BD19AF8U }, /* XSUM_XXH32_testdata[2254] */
    { 1127, 0x9E3779B1U, 0x62760CFCU }, /* XSUM_XXH32_testdata[2255] */
    { 1128, 0x00000000U, 0x6792051DU }, /* XSUM_XXH32_testdata[2256] */
    { 1128, 0x9E3779B1U, 0x2686447DU }, /* XSUM_XXH32_testdata[2257] */
    { 1129, 0x00000000U, 0xAC7AC7A8U }, /* XSUM_XXH32_testdata[2258] */
    { 1129, 0x9E3779B1U, 0x52E3F07AU }, /* XSUM_XXH32_testdata[2259] */
    { 1130, 0x00000000U, 0x652C2B30U }, /* XSUM_XXH32_testdata[2260] */
    { 1130, 0x9E3779B1U, 0x19F9FD83U }, /* XSUM_XXH32_testdata[2261] */
    { 1131, 0x00000000U, 0x9657F7D2U }, /* XSUM_XXH32_testdata[2262] */
    { 1131, 0x9E3779B1U, 0xB87E2204U }, /* XSUM_XXH32_testdata[2263] */
    { 1132, 0x00000000U, 0x105D2302U }, /* XSUM_XXH32_testdata[2264] */
    { 1132, 0x9E3779B1U, 0x0CEC52C5U }, /* XSUM_XXH32_testdata[2265] */
    { 1133, 0x00000000U, 0xB6D388D0U }, /* XSUM_XXH32_testdata[2266] */
    { 1133, 0x9E3779B1U, 0x29D2E495U }, /* XSUM_XXH32_testdata[2267] */
    { 1134, 0x00000000U, 0x02009A0CU }, /* XSUM_XXH32_testdata[2268] */
    { 1134, 0x9E3779B1U, 0x8455DE4DU }, /* XSUM_XXH32_testdata[2269] */
    { 1135, 0x00000000U, 0x2236051CU }, /* XSUM_XXH32_testdata[2270] */
    { 1135, 0x9E3779B1U, 0xED09AEA1U }, /* XSUM_XXH32_testdata[2271] */
    { 1136, 0x00000000U, 0x14C19087U }, /* XSUM_XXH32_testdata[2272] */
    { 1136, 0x9E3779B1U, 0x43853C21U }, /* XSUM_XXH32_testdata[2273] */
    { 1137, 0x00000000U, 0xC5142F70U }, /* XSUM_XXH32_testdata[2274] */
    { 1137, 0x9E3779B1U, 0x0F8730F4U }, /* XSUM_XXH32_testdata[2275] */
    { 1138, 0x00000000U, 0x8F701CBFU }, /* XSUM_XXH32_testdata[2276] */
    { 1138, 0x9E3779B1U, 0x0532601BU }, /* XSUM_XXH32_testdata[2277] */
    { 1139, 0x00000000U, 0x0F9FE493U }, /* XSUM_XXH32_testdata[2278] */
    { 1139, 0x9E3779B1U, 0xB0C649ACU }, /* XSUM_XXH32_testdata[2279] */
    { 1140, 0x00000000U, 0xF76EC761U }, /* XSUM_XXH32_testdata[2280] */
    { 1140, 0x9E3779B1U, 0x4E489FB2U }, /* XSUM_XXH32_testdata[2281] */
    { 1141, 0x00000000U, 0xAAC872F2U }, /* XSUM_XXH32_testdata[2282] */
    { 1141, 0x9E3779B1U, 0xD5235209U }, /* XSUM_XXH32_testdata[2283] */
    { 1142, 0x00000000U, 0x0FA2BBA4U }, /* XSUM_XXH32_testdata[2284] */
    { 1142, 0x9E3779B1U, 0x832FF451U }, /* XSUM_XXH32_testdata[2285] */
    { 1143, 0x00000000U, 0x1AD96E36U }, /* XSUM_XXH32_testdata[2286] */
    { 1143, 0x9E3779B1U, 0x6F3E9DFDU }, /* XSUM_XXH32_testdata[2287] */
    { 1144, 0x00000000U, 0x1423AEDFU }, /* XSUM_XXH32_testdata[2288] */
    { 1144, 0x9E3779B1U, 0x4629D110U }, /* XSUM_XXH32_testdata[2289] */
    { 1145, 0x00000000U, 0xB06A1AB2U }, /* XSUM_XXH32_testdata[2290] */
    { 1145, 0x9E3779B1U, 0x29560AD3U }, /* XSUM_XXH32_testdata[2291] */
    { 1146, 0x00000000U, 0xD3115493U }, /* XSUM_XXH32_testdata[2292] */
    { 1146, 0x9E3779B1U, 0x47214197U }, /* XSUM_XXH32_testdata[2293] */
    { 1147, 0x00000000U, 0xDA9EF2B5U }, /* XSUM_XXH32_testdata[2294] */
    { 1147, 0x9E3779B1U, 0xBB23D7ABU }, /* XSUM_XXH32_testdata[2295] */
    { 1148, 0x00000000U, 0xB8CD0CC8U }, /* XSUM_XXH32_testdata[2296] */
    { 1148, 0x9E3779B1U, 0x78D65EB7U }, /* XSUM_XXH32_testdata[2297] */
    { 1149, 0x00000000U, 0xA81E9D5DU }, /* XSUM_XXH32_testdata[2298] */
    { 1149, 0x9E3779B1U, 0x41651ADCU }, /* XSUM_XXH32_testdata[2299] */
    { 1150, 0x00000000U, 0x1C36D26CU }, /* XSUM_XXH32_testdata[2300] */
    { 1150, 0x9E3779B1U, 0x60886177U }, /* XSUM_XXH32_testdata[2301] */
    { 1151, 0x00000000U, 0x1D6A7DBAU }, /* XSUM_XXH32_testdata[2302] */
    { 1151, 0x9E3779B1U, 0xD83BE4A6U }, /* XSUM_XXH32_testdata[2303] */
    { 1152, 0x00000000U, 0x8939EF84U }, /* XSUM_XXH32_testdata[2304] */
    { 1152, 0x9E3779B1U, 0x213932A9U }, /* XSUM_XXH32_testdata[2305] */
    { 1153, 0x00000000U, 0x99A1AF03U }, /* XSUM_XXH32_testdata[2306] */
    { 1153, 0x9E3779B1U, 0x2DB68808U }, /* XSUM_XXH32_testdata[2307] */
    { 1154, 0x00000000U, 0x4AAD569FU }, /* XSUM_XXH32_testdata[2308] */
    { 1154, 0x9E3779B1U, 0x332B51DDU }, /* XSUM_XXH32_testdata[2309] */
    { 1155, 0x00000000U, 0x60F26E61U }, /* XSUM_XXH32_testdata[2310] */
    { 1155, 0x9E3779B1U, 0xDB739023U }, /* XSUM_XXH32_testdata[2311] */
    { 1156, 0x00000000U, 0x6F82F443U }, /* XSUM_XXH32_testdata[2312] */
    { 1156, 0x9E3779B1U, 0xC8431321U }, /* XSUM_XXH32_testdata[2313] */
    { 1157, 0x00000000U, 0x4E6E2FD0U }, /* XSUM_XXH32_testdata[2314] */
    { 1157, 0x9E3779B1U, 0xD60B4DA7U }, /* XSUM_XXH32_testdata[2315] */
    { 1158, 0x00000000U, 0xD205E3BFU }, /* XSUM_XXH32_testdata[2316] */
    { 1158, 0x9E3779B1U, 0xC453C261U }, /* XSUM_XXH32_testdata[2317] */
    { 1159, 0x00000000U, 0x17B4C147U }, /* XSUM_XXH32_testdata[2318] */
    { 1159, 0x9E3779B1U, 0x895E5CA0U }, /* XSUM_XXH32_testdata[2319] */
    { 1160, 0x00000000U, 0x16CF7D89U }, /* XSUM_XXH32_testdata[2320] */
    { 1160, 0x9E3779B1U, 0x3FCBE48BU }, /* XSUM_XXH32_testdata[2321] */
    { 1161, 0x00000000U, 0x6EA386C2U }, /* XSUM_XXH32_testdata[2322] */
    { 1161, 0x9E3779B1U, 0xAA9F4BC1U }, /* XSUM_XXH32_testdata[2323] */
    { 1162, 0x00000000U, 0x755960F2U }, /* XSUM_XXH32_testdata[2324] */
    { 1162, 0x9E3779B1U, 0xA5615BF2U }, /* XSUM_XXH32_testdata[2325] */
    { 1163, 0x00000000U, 0xC93F7546U }, /* XSUM_XXH32_testdata[2326] */
    { 1163, 0x9E3779B1U, 0xEE990ECEU }, /* XSUM_XXH32_testdata[2327] */
    { 1164, 0x00000000U, 0xE79AA5FAU }, /* XSUM_XXH32_testdata[2328] */
    { 1164, 0x9E3779B1U, 0xBF7C1F8CU }, /* XSUM_XXH32_testdata[2329] */
    { 1165, 0x00000000U, 0x1BF68339U }, /* XSUM_XXH32_testdata[2330] */
    { 1165, 0x9E3779B1U, 0x4F4ACACEU }, /* XSUM_XXH32_testdata[2331] */
    { 1166, 0x00000000U, 0x83069E82U }, /* XSUM_XXH32_testdata[2332] */
    { 1166, 0x9E3779B1U, 0xE0816A0FU }, /* XSUM_XXH32_testdata[2333] */
    { 1167, 0x00000000U, 0x8C7CF7E6U }, /* XSUM_XXH32_testdata[2334] */
    { 1167, 0x9E3779B1U, 0x60CD3724U }, /* XSUM_XXH32_testdata[2335] */
    { 1168, 0x00000000U, 0x37A453D3U }, /* XSUM_XXH32_testdata[2336] */
    { 1168, 0x9E3779B1U, 0xD6A5CEABU }, /* XSUM_XXH32_testdata[2337] */
    { 1169, 0x00000000U, 0xA130C800U }, /* XSUM_XXH32_testdata[2338] */
    { 1169, 0x9E3779B1U, 0xA9CDFD7BU }, /* XSUM_XXH32_testdata[2339] */
    { 1170, 0x00000000U, 0x1EA973ABU }, /* XSUM_XXH32_testdata[2340] */
    { 1170, 0x9E3779B1U, 0xCF888F1BU }, /* XSUM_XXH32_testdata[2341] */
    { 1171, 0x00000000U, 0x5202D829U }, /* XSUM_XXH32_testdata[2342] */
    { 1171, 0x9E3779B1U, 0xF36A38CAU }, /* XSUM_XXH32_testdata[2343] */
    { 1172, 0x00000000U, 0xF8F63A3DU }, /* XSUM_XXH32_testdata[2344] */
    { 1172, 0x9E3779B1U, 0xE9BA638AU }, /* XSUM_XXH32_testdata[2345] */
    { 1173, 0x00000000U, 0xD4C6B4F2U }, /* XSUM_XXH32_testdata[2346] */
    { 1173, 0x9E3779B1U, 0x479F41F6U }, /* XSUM_XXH32_testdata[2347] */
    { 1174, 0x00000000U, 0xE0DE6614U }, /* XSUM_XXH32_testdata[2348] */
    { 1174, 0x9E3779B1U, 0x43C7C3B2U }, /* XSUM_XXH32_testdata[2349] */
    { 1175, 0x00000000U, 0xD0038ACEU }, /* XSUM_XXH32_testdata[2350] */
    { 1175, 0x9E3779B1U, 0x2EA445FCU }, /* XSUM_XXH32_testdata[2351] */
    { 1176, 0x00000000U, 0x51236C50U }, /* XSUM_XXH32_testdata[2352] */
    { 1176, 0x9E3779B1U, 0x6C93A64CU }, /* XSUM_XXH32_testdata[2353] */
    { 1177, 0x00000000U, 0x77279DADU }, /* XSUM_XXH32_testdata[2354] */
    { 1177, 0x9E3779B1U, 0x2CDB5679U }, /* XSUM_XXH32_testdata[2355] */
    { 1178, 0x00000000U, 0x69730B90U }, /* XSUM_XXH32_testdata[2356] */
    { 1178, 0x9E3779B1U, 0x27787C9FU }, /* XSUM_XXH32_testdata[2357] */
    { 1179, 0x00000000U, 0x5441912EU }, /* XSUM_XXH32_testdata[2358] */
    { 1179, 0x9E3779B1U, 0x71A64E8BU }, /* XSUM_XXH32_testdata[2359] */
    { 1180, 0x00000000U, 0xEBE71841U }, /* XSUM_XXH32_testdata[2360] */
    { 1180, 0x9E3779B1U, 0x000F3EBAU }, /* XSUM_XXH32_testdata[2361] */
    { 1181, 0x00000000U, 0x7200E618U }, /* XSUM_XXH32_testdata[2362] */
    { 1181, 0x9E3779B1U, 0xE9A76CC3U }, /* XSUM_XXH32_testdata[2363] */
    { 1182, 0x00000000U, 0x7B0E020FU }, /* XSUM_XXH32_testdata[2364] */
    { 1182, 0x9E3779B1U, 0xD92D1012U }, /* XSUM_XXH32_testdata[2365] */
    { 1183, 0x00000000U, 0x4A8311BFU }, /* XSUM_XXH32_testdata[2366] */
    { 1183, 0x9E3779B1U, 0xD77133BFU }, /* XSUM_XXH32_testdata[2367] */
    { 1184, 0x00000000U, 0x3BC2EE12U }, /* XSUM_XXH32_testdata[2368] */
    { 1184, 0x9E3779B1U, 0x91A24B1DU }, /* XSUM_XXH32_testdata[2369] */
    { 1185, 0x00000000U, 0x7C1E4330U }, /* XSUM_XXH32_testdata[2370] */
    { 1185, 0x9E3779B1U, 0x3D0954DFU }, /* XSUM_XXH32_testdata[2371] */
    { 1186, 0x00000000U, 0x871B4E42U }, /* XSUM_XXH32_testdata[2372] */
    { 1186, 0x9E3779B1U, 0xA3540010U }, /* XSUM_XXH32_testdata[2373] */
    { 1187, 0x00000000U, 0x150BAECFU }, /* XSUM_XXH32_testdata[2374] */
    { 1187, 0x9E3779B1U, 0x0A9DFC4BU }, /* XSUM_XXH32_testdata[2375] */
    { 1188, 0x00000000U, 0xEB16B50BU }, /* XSUM_XXH32_testdata[2376] */
    { 1188, 0x9E3779B1U, 0xF33EA1FFU }, /* XSUM_XXH32_testdata[2377] */
    { 1189, 0x00000000U, 0x98F0B37BU }, /* XSUM_XXH32_testdata[2378] */
    { 1189, 0x9E3779B1U, 0xEF1F676FU }, /* XSUM_XXH32_testdata[2379] */
    { 1190, 0x00000000U, 0x27B6AA12U }, /* XSUM_XXH32_testdata[2380] */
    { 1190, 0x9E3779B1U, 0xFE0046B3U }, /* XSUM_XXH32_testdata[2381] */
    { 1191, 0x00000000U, 0xABC6CCFAU }, /* XSUM_XXH32_testdata[2382] */
    { 1191, 0x9E3779B1U, 0x32570C88U }, /* XSUM_XXH32_testdata[2383] */
    { 1192, 0x00000000U, 0x25887CC5U }, /* XSUM_XXH32_testdata[2384] */
    { 1192, 0x9E3779B1U, 0x9A9BFBBCU }, /* XSUM_XXH32_testdata[2385] */
    { 1193, 0x00000000U, 0x33BA8F99U }, /* XSUM_XXH32_testdata[2386] */
    { 1193, 0x9E3779B1U, 0x6A79A1D1U }, /* XSUM_XXH32_testdata[2387] */
    { 1194, 0x00000000U, 0xC544328AU }, /* XSUM_XXH32_testdata[2388] */
    { 1194, 0x9E3779B1U, 0xE0C08B6EU }, /* XSUM_XXH32_testdata[2389] */
    { 1195, 0x00000000U, 0x87AB1EE7U }, /* XSUM_XXH32_testdata[2390] */
    { 1195, 0x9E3779B1U, 0xF83CCDB5U }, /* XSUM_XXH32_testdata[2391] */
    { 1196, 0x00000000U, 0x5F78223FU }, /* XSUM_XXH32_testdata[2392] */
    { 1196, 0x9E3779B1U, 0x9E63E1DAU }, /* XSUM_XXH32_testdata[2393] */
    { 1197, 0x00000000U, 0xE60493C9U }, /* XSUM_XXH32_testdata[2394] */
    { 1197, 0x9E3779B1U, 0xD9933DC9U }, /* XSUM_XXH32_testdata[2395] */
    { 1198, 0x00000000U, 0x69D8E4F9U }, /* XSUM_XXH32_testdata[2396] */
    { 1198, 0x9E3779B1U, 0xBC11B3EDU }, /* XSUM_XXH32_testdata[2397] */
    { 1199, 0x00000000U, 0xE9F0E205U }, /* XSUM_XXH32_testdata[2398] */
    { 1199, 0x9E3779B1U, 0x7D96B61DU }, /* XSUM_XXH32_testdata[2399] */
    { 1200, 0x00000000U, 0x3837ED71U }, /* XSUM_XXH32_testdata[2400] */
    { 1200, 0x9E3779B1U, 0xB8E1DD53U }, /* XSUM_XXH32_testdata[2401] */
    { 1201, 0x00000000U, 0xFC4619C6U }, /* XSUM_XXH32_testdata[2402] */
    { 1201, 0x9E3779B1U, 0x19EF8948U }, /* XSUM_XXH32_testdata[2403] */
    { 1202, 0x00000000U, 0xB4695527U }, /* XSUM_XXH32_testdata[2404] */
    { 1202, 0x9E3779B1U, 0xDE11A2FBU }, /* XSUM_XXH32_testdata[2405] */
    { 1203, 0x00000000U, 0x7D08BED9U }, /* XSUM_XXH32_testdata[2406] */
    { 1203, 0x9E3779B1U, 0x5735FA80U }, /* XSUM_XXH32_testdata[2407] */
    { 1204, 0x00000000U, 0x88D2712BU }, /* XSUM_XXH32_testdata[2408] */
    { 1204, 0x9E3779B1U, 0xA7EDB85DU }, /* XSUM_XXH32_testdata[2409] */
    { 1205, 0x00000000U, 0x710A2AA7U }, /* XSUM_XXH32_testdata[2410] */
    { 1205, 0x9E3779B1U, 0x41B50419U }, /* XSUM_XXH32_testdata[2411] */
    { 1206, 0x00000000U, 0x356F2AC2U }, /* XSUM_XXH32_testdata[2412] */
    { 1206, 0x9E3779B1U, 0xCD13BFBCU }, /* XSUM_XXH32_testdata[2413] */
    { 1207, 0x00000000U, 0xCF6089DEU }, /* XSUM_XXH32_testdata[2414] */
    { 1207, 0x9E3779B1U, 0x64F9EEAAU }, /* XSUM_XXH32_testdata[2415] */
    { 1208, 0x00000000U, 0xE7BC737BU }, /* XSUM_XXH32_testdata[2416] */
    { 1208, 0x9E3779B1U, 0x843C0F46U }, /* XSUM_XXH32_testdata[2417] */
    { 1209, 0x00000000U, 0x77951332U }, /* XSUM_XXH32_testdata[2418] */
    { 1209, 0x9E3779B1U, 0x067CE62AU }, /* XSUM_XXH32_testdata[2419] */
    { 1210, 0x00000000U, 0xE5E13970U }, /* XSUM_XXH32_testdata[2420] */
    { 1210, 0x9E3779B1U, 0xECFCFD62U }, /* XSUM_XXH32_testdata[2421] */
    { 1211, 0x00000000U, 0xD0FC61AFU }, /* XSUM_XXH32_testdata[2422] */
    { 1211, 0x9E3779B1U, 0x700BBC98U }, /* XSUM_XXH32_testdata[2423] */
    { 1212, 0x00000000U, 0x50EFB786U }, /* XSUM_XXH32_testdata[2424] */
    { 1212, 0x9E3779B1U, 0x837A46F8U }, /* XSUM_XXH32_testdata[2425] */
    { 1213, 0x00000000U, 0x42A74DCDU }, /* XSUM_XXH32_testdata[2426] */
    { 1213, 0x9E3779B1U, 0x5B3253E2U }, /* XSUM_XXH32_testdata[2427] */
    { 1214, 0x00000000U, 0x8A993EB7U }, /* XSUM_XXH32_testdata[2428] */
    { 1214, 0x9E3779B1U, 0x52B27341U }, /* XSUM_XXH32_testdata[2429] */
    { 1215, 0x00000000U, 0x1AFEB769U }, /* XSUM_XXH32_testdata[2430] */
    { 1215, 0x9E3779B1U, 0x8EE2261FU }, /* XSUM_XXH32_testdata[2431] */
    { 1216, 0x00000000U, 0x32378261U }, /* XSUM_XXH32_testdata[2432] */
    { 1216, 0x9E3779B1U, 0x83790135U }, /* XSUM_XXH32_testdata[2433] */
    { 1217, 0x00000000U, 0xFF983CBBU }, /* XSUM_XXH32_testdata[2434] */
    { 1217, 0x9E3779B1U, 0x4DD6F776U }, /* XSUM_XXH32_testdata[2435] */
    { 1218, 0x00000000U, 0x7A16A07EU }, /* XSUM_XXH32_testdata[2436] */
    { 1218, 0x9E3779B1U, 0xF0B4B626U }, /* XSUM_XXH32_testdata[2437] */
    { 1219, 0x00000000U, 0xE8FB831BU }, /* XSUM_XXH32_testdata[2438] */
    { 1219, 0x9E3779B1U, 0x2B56D3E6U }, /* XSUM_XXH32_testdata[2439] */
    { 1220, 0x00000000U, 0x76B95829U }, /* XSUM_XXH32_testdata[2440] */
    { 1220, 0x9E3779B1U, 0x74BCFD94U }, /* XSUM_XXH32_testdata[2441] */
    { 1221, 0x00000000U, 0x8B37590EU }, /* XSUM_XXH32_testdata[2442] */
    { 1221, 0x9E3779B1U, 0x97291E81U }, /* XSUM_XXH32_testdata[2443] */
    { 1222, 0x00000000U, 0x6262F879U }, /* XSUM_XXH32_testdata[2444] */
    { 1222, 0x9E3779B1U, 0xB9E152C9U }, /* XSUM_XXH32_testdata[2445] */
    { 1223, 0x00000000U, 0x5BEB836AU }, /* XSUM_XXH32_testdata[2446] */
    { 1223, 0x9E3779B1U, 0xBA412E6AU }, /* XSUM_XXH32_testdata[2447] */
    { 1224, 0x00000000U, 0xB0D158EEU }, /* XSUM_XXH32_testdata[2448] */
    { 1224, 0x9E3779B1U, 0xC7AD3C4EU }, /* XSUM_XXH32_testdata[2449] */
    { 1225, 0x00000000U, 0x0BC682CFU }, /* XSUM_XXH32_testdata[2450] */
    { 1225, 0x9E3779B1U, 0x43AB19D1U }, /* XSUM_XXH32_testdata[2451] */
    { 1226, 0x00000000U, 0x89B07639U }, /* XSUM_XXH32_testdata[2452] */
    { 1226, 0x9E3779B1U, 0xE60EC963U }, /* XSUM_XXH32_testdata[2453] */
    { 1227, 0x00000000U, 0x8650C70AU }, /* XSUM_XXH32_testdata[2454] */
    { 1227, 0x9E3779B1U, 0xB02C48C6U }, /* XSUM_XXH32_testdata[2455] */
    { 1228, 0x00000000U, 0x2509FFFEU }, /* XSUM_XXH32_testdata[2456] */
    { 1228, 0x9E3779B1U, 0xC1897133U }, /* XSUM_XXH32_testdata[2457] */
    { 1229, 0x00000000U, 0x380B923CU }, /* XSUM_XXH32_testdata[2458] */
    { 1229, 0x9E3779B1U, 0xF444AB6CU }, /* XSUM_XXH32_testdata[2459] */
    { 1230, 0x00000000U, 0xE1A7E33EU }, /* XSUM_XXH32_testdata[2460] */
    { 1230, 0x9E3779B1U, 0xC0576797U }, /* XSUM_XXH32_testdata[2461] */
    { 1231, 0x00000000U, 0x576DA834U }, /* XSUM_XXH32_testdata[2462] */
    { 1231, 0x9E3779B1U, 0x06787E9BU }, /* XSUM_XXH32_testdata[2463] */
    { 1232, 0x00000000U, 0x34370BCDU }, /* XSUM_XXH32_testdata[2464] */
    { 1232, 0x9E3779B1U, 0x5FB3307DU }, /* XSUM_XXH32_testdata[2465] */
    { 1233, 0x00000000U, 0x5890D760U }, /* XSUM_XXH32_testdata[2466] */
    { 1233, 0x9E3779B1U, 0xF7C1AF2FU }, /* XSUM_XXH32_testdata[2467] */
    { 1234, 0x00000000U, 0x73E0A073U }, /* XSUM_XXH32_testdata[2468] */
    { 1234, 0x9E3779B1U, 0x2BD51E0EU }, /* XSUM_XXH32_testdata[2469] */
    { 1235, 0x00000000U, 0xFA5A819CU }, /* XSUM_XXH32_testdata[2470] */
    { 1235, 0x9E3779B1U, 0xFE0A936FU }, /* XSUM_XXH32_testdata[2471] */
    { 1236, 0x00000000U, 0x66E90262U }, /* XSUM_XXH32_testdata[2472] */
    { 1236, 0x9E3779B1U, 0xB22E5BB5U }, /* XSUM_XXH32_testdata[2473] */
    { 1237, 0x00000000U, 0xA4F94E8AU }, /* XSUM_XXH32_testdata[2474] */
    { 1237, 0x9E3779B1U, 0xAC47F02CU }, /* XSUM_XXH32_testdata[2475] */
    { 1238, 0x00000000U, 0x70E2CCF2U }, /* XSUM_XXH32_testdata[2476] */
    { 1238, 0x9E3779B1U, 0xE66DA26CU }, /* XSUM_XXH32_testdata[2477] */
    { 1239, 0x00000000U, 0x1C5AC9ADU }, /* XSUM_XXH32_testdata[2478] */
    { 1239, 0x9E3779B1U, 0x1CB4A6ACU }, /* XSUM_XXH32_testdata[2479] */
    { 1240, 0x00000000U, 0x388F8391U }, /* XSUM_XXH32_testdata[2480] */
    { 1240, 0x9E3779B1U, 0x91060E92U }, /* XSUM_XXH32_testdata[2481] */
    { 1241, 0x00000000U, 0x23FFA3FEU }, /* XSUM_XXH32_testdata[2482] */
    { 1241, 0x9E3779B1U, 0x3A416412U }, /* XSUM_XXH32_testdata[2483] */
    { 1242, 0x00000000U, 0x251FFE0AU }, /* XSUM_XXH32_testdata[2484] */
    { 1242, 0x9E3779B1U, 0x2E9FA9BEU }, /* XSUM_XXH32_testdata[2485] */
    { 1243, 0x00000000U, 0x74585D9CU }, /* XSUM_XXH32_testdata[2486] */
    { 1243, 0x9E3779B1U, 0xCD1B299AU }, /* XSUM_XXH32_testdata[2487] */
    { 1244, 0x00000000U, 0x67E4FD06U }, /* XSUM_XXH32_testdata[2488] */
    { 1244, 0x9E3779B1U, 0x13E07EDDU }, /* XSUM_XXH32_testdata[2489] */
    { 1245, 0x00000000U, 0x629BF7D8U }, /* XSUM_XXH32_testdata[2490] */
    { 1245, 0x9E3779B1U, 0xCD7B95CFU }, /* XSUM_XXH32_testdata[2491] */
    { 1246, 0x00000000U, 0xE19E25CAU }, /* XSUM_XXH32_testdata[2492] */
    { 1246, 0x9E3779B1U, 0x7BED7559U }, /* XSUM_XXH32_testdata[2493] */
    { 1247, 0x00000000U, 0x28770A98U }, /* XSUM_XXH32_testdata[2494] */
    { 1247, 0x9E3779B1U, 0xF8C689C3U }, /* XSUM_XXH32_testdata[2495] */
    { 1248, 0x00000000U, 0x53636FA6U }, /* XSUM_XXH32_testdata[2496] */
    { 1248, 0x9E3779B1U, 0xBCD974FEU }, /* XSUM_XXH32_testdata[2497] */
    { 1249, 0x00000000U, 0x995EE694U }, /* XSUM_XXH32_testdata[2498] */
    { 1249, 0x9E3779B1U, 0xDE6D2059U }, /* XSUM_XXH32_testdata[2499] */
    { 1250, 0x00000000U, 0x5727421AU }, /* XSUM_XXH32_testdata[2500] */
    { 1250, 0x9E3779B1U, 0x99F8CA7CU }, /* XSUM_XXH32_testdata[2501] */
    { 1251, 0x00000000U, 0x8E9171A5U }, /* XSUM_XXH32_testdata[2502] */
    { 1251, 0x9E3779B1U, 0xFD502552U }, /* XSUM_XXH32_testdata[2503] */
    { 1252, 0x00000000U, 0x17B3A980U }, /* XSUM_XXH32_testdata[2504] */
    { 1252, 0x9E3779B1U, 0x574E9EF9U }, /* XSUM_XXH32_testdata[2505] */
    { 1253, 0x00000000U, 0xEC51217CU }, /* XSUM_XXH32_testdata[2506] */
    { 1253, 0x9E3779B1U, 0x8DC0D26FU }, /* XSUM_XXH32_testdata[2507] */
    { 1254, 0x00000000U, 0x411271CFU }, /* XSUM_XXH32_testdata[2508] */
    { 1254, 0x9E3779B1U, 0xE25435A0U }, /* XSUM_XXH32_testdata[2509] */
    { 1255, 0x00000000U, 0x664FB4F9U }, /* XSUM_XXH32_testdata[2510] */
    { 1255, 0x9E3779B1U, 0xF91B6733U }, /* XSUM_XXH32_testdata[2511] */
    { 1256, 0x00000000U, 0x1FD58D25U }, /* XSUM_XXH32_testdata[2512] */
    { 1256, 0x9E3779B1U, 0x073F8259U }, /* XSUM_XXH32_testdata[2513] */
    { 1257, 0x00000000U, 0x5CF6EC0DU }, /* XSUM_XXH32_testdata[2514] */
    { 1257, 0x9E3779B1U, 0xDE1860E3U }, /* XSUM_XXH32_testdata[2515] */
    { 1258, 0x00000000U, 0xAB8872F8U }, /* XSUM_XXH32_testdata[2516] */
    { 1258, 0x9E3779B1U, 0x840A1DABU }, /* XSUM_XXH32_testdata[2517] */
    { 1259, 0x00000000U, 0xF543FDE0U }, /* XSUM_XXH32_testdata[2518] */
    { 1259, 0x9E3779B1U, 0xC2C19E71U }, /* XSUM_XXH32_testdata[2519] */
    { 1260, 0x00000000U, 0x2487744CU }, /* XSUM_XXH32_testdata[2520] */
    { 1260, 0x9E3779B1U, 0x133A67A2U }, /* XSUM_XXH32_testdata[2521] */
    { 1261, 0x00000000U, 0x9B8EF115U }, /* XSUM_XXH32_testdata[2522] */
    { 1261, 0x9E3779B1U, 0xF0469C7AU }, /* XSUM_XXH32_testdata[2523] */
    { 1262, 0x00000000U, 0x15970213U }, /* XSUM_XXH32_testdata[2524] */
    { 1262, 0x9E3779B1U, 0x42B663DDU }, /* XSUM_XXH32_testdata[2525] */
    { 1263, 0x00000000U, 0xA0953660U }, /* XSUM_XXH32_testdata[2526] */
    { 1263, 0x9E3779B1U, 0x964B8A94U }, /* XSUM_XXH32_testdata[2527] */
    { 1264, 0x00000000U, 0x8E07AE6FU }, /* XSUM_XXH32_testdata[2528] */
    { 1264, 0x9E3779B1U, 0x1DA26D93U }, /* XSUM_XXH32_testdata[2529] */
    { 1265, 0x00000000U, 0xF993B00BU }, /* XSUM_XXH32_testdata[2530] */
    { 1265, 0x9E3779B1U, 0xD3F2FA99U }, /* XSUM_XXH32_testdata[2531] */
    { 1266, 0x00000000U, 0xD0131D4AU }, /* XSUM_XXH32_testdata[2532] */
    { 1266, 0x9E3779B1U, 0x90B272F9U }, /* XSUM_XXH32_testdata[2533] */
    { 1267, 0x00000000U, 0xF1DF1C1EU }, /* XSUM_XXH32_testdata[2534] */
    { 1267, 0x9E3779B1U, 0x70C5631FU }, /* XSUM_XXH32_testdata[2535] */
    { 1268, 0x00000000U, 0xECCBEC12U }, /* XSUM_XXH32_testdata[2536] */
    { 1268, 0x9E3779B1U, 0x2C27652BU }, /* XSUM_XXH32_testdata[2537] */
    { 1269, 0x00000000U, 0xA8ABBE10U }, /* XSUM_XXH32_testdata[2538] */
    { 1269, 0x9E3779B1U, 0xE38FEE6CU }, /* XSUM_XXH32_testdata[2539] */
    { 1270, 0x00000000U, 0x9DD606C0U }, /* XSUM_XXH32_testdata[2540] */
    { 1270, 0x9E3779B1U, 0xC2BF63EEU }, /* XSUM_XXH32_testdata[2541] */
    { 1271, 0x00000000U, 0x01F80B9CU }, /* XSUM_XXH32_testdata[2542] */
    { 1271, 0x9E3779B1U, 0x89FCD27FU }, /* XSUM_XXH32_testdata[2543] */
    { 1272, 0x00000000U, 0x89E9AFC7U }, /* XSUM_XXH32_testdata[2544] */
    { 1272, 0x9E3779B1U, 0x05639959U }, /* XSUM_XXH32_testdata[2545] */
    { 1273, 0x00000000U, 0x4752B0C3U }, /* XSUM_XXH32_testdata[2546] */
    { 1273, 0x9E3779B1U, 0x9E90A542U }, /* XSUM_XXH32_testdata[2547] */
    { 1274, 0x00000000U, 0xEF38B0D4U }, /* XSUM_XXH32_testdata[2548] */
    { 1274, 0x9E3779B1U, 0x16B994DCU }, /* XSUM_XXH32_testdata[2549] */
    { 1275, 0x00000000U, 0x46195024U }, /* XSUM_XXH32_testdata[2550] */
    { 1275, 0x9E3779B1U, 0x51A1C37DU }, /* XSUM_XXH32_testdata[2551] */
    { 1276, 0x00000000U, 0x0EE0441EU }, /* XSUM_XXH32_testdata[2552] */
    { 1276, 0x9E3779B1U, 0xB834298EU }, /* XSUM_XXH32_testdata[2553] */
    { 1277, 0x00000000U, 0x8643799EU }, /* XSUM_XXH32_testdata[2554] */
    { 1277, 0x9E3779B1U, 0x7EB6266EU }, /* XSUM_XXH32_testdata[2555] */
    { 1278, 0x00000000U, 0x1466B4A6U }, /* XSUM_XXH32_testdata[2556] */
    { 1278, 0x9E3779B1U, 0xCB60768BU }, /* XSUM_XXH32_testdata[2557] */
    { 1279, 0x00000000U, 0xEEC1E880U }, /* XSUM_XXH32_testdata[2558] */
    { 1279, 0x9E3779B1U, 0x3AC5CDF6U }, /* XSUM_XXH32_testdata[2559] */
    { 1280, 0x00000000U, 0x3A7D59BFU }, /* XSUM_XXH32_testdata[2560] */
    { 1280, 0x9E3779B1U, 0xA349EC49U }, /* XSUM_XXH32_testdata[2561] */
    { 1281, 0x00000000U, 0x7D71B06CU }, /* XSUM_XXH32_testdata[2562] */
    { 1281, 0x9E3779B1U, 0xFA3E3998U }, /* XSUM_XXH32_testdata[2563] */
    { 1282, 0x00000000U, 0x158406DEU }, /* XSUM_XXH32_testdata[2564] */
    { 1282, 0x9E3779B1U, 0x2F7381BFU }, /* XSUM_XXH32_testdata[2565] */
    { 1283, 0x00000000U, 0x9272967AU }, /* XSUM_XXH32_testdata[2566] */
    { 1283, 0x9E3779B1U, 0x378C6054U }, /* XSUM_XXH32_testdata[2567] */
    { 1284, 0x00000000U, 0x43A43229U }, /* XSUM_XXH32_testdata[2568] */
    { 1284, 0x9E3779B1U, 0x367A390DU }, /* XSUM_XXH32_testdata[2569] */
    { 1285, 0x00000000U, 0xDD831C1FU }, /* XSUM_XXH32_testdata[2570] */
    { 1285, 0x9E3779B1U, 0x96724406U }, /* XSUM_XXH32_testdata[2571] */
    { 1286, 0x00000000U, 0xBBB772E8U }, /* XSUM_XXH32_testdata[2572] */
    { 1286, 0x9E3779B1U, 0x8DFB225DU }, /* XSUM_XXH32_testdata[2573] */
    { 1287, 0x00000000U, 0x16EBE500U }, /* XSUM_XXH32_testdata[2574] */
    { 1287, 0x9E3779B1U, 0x13C81E0DU }, /* XSUM_XXH32_testdata[2575] */
    { 1288, 0x00000000U, 0x1AE5A4DFU }, /* XSUM_XXH32_testdata[2576] */
    { 1288, 0x9E3779B1U, 0x5E53D10FU }, /* XSUM_XXH32_testdata[2577] */
    { 1289, 0x00000000U, 0x248A8AB2U }, /* XSUM_XXH32_testdata[2578] */
    { 1289, 0x9E3779B1U, 0x3844206AU }, /* XSUM_XXH32_testdata[2579] */
    { 1290, 0x00000000U, 0x1E9E2CE5U }, /* XSUM_XXH32_testdata[2580] */
    { 1290, 0x9E3779B1U, 0x6AD98606U }, /* XSUM_XXH32_testdata[2581] */
    { 1291, 0x00000000U, 0x9ADEF56BU }, /* XSUM_XXH32_testdata[2582] */
    { 1291, 0x9E3779B1U, 0xC41BD1F1U }, /* XSUM_XXH32_testdata[2583] */
    { 1292, 0x00000000U, 0xFCA4A1D6U }, /* XSUM_XXH32_testdata[2584] */
    { 1292, 0x9E3779B1U, 0x46429A63U }, /* XSUM_XXH32_testdata[2585] */
    { 1293, 0x00000000U, 0xBCBEF56CU }, /* XSUM_XXH32_testdata[2586] */
    { 1293, 0x9E3779B1U, 0xF25C8609U }, /* XSUM_XXH32_testdata[2587] */
    { 1294, 0x00000000U, 0xCB5593A6U }, /* XSUM_XXH32_testdata[2588] */
    { 1294, 0x9E3779B1U, 0x576BBFBBU }, /* XSUM_XXH32_testdata[2589] */
    { 1295, 0x00000000U, 0xB8CFFF93U }, /* XSUM_XXH32_testdata[2590] */
    { 1295, 0x9E3779B1U, 0x6DAA5212U }, /* XSUM_XXH32_testdata[2591] */
    { 1296, 0x00000000U, 0x40E4F5EBU }, /* XSUM_XXH32_testdata[2592] */
    { 1296, 0x9E3779B1U, 0xA937F09CU }, /* XSUM_XXH32_testdata[2593] */
    { 1297, 0x00000000U, 0xC253CF4FU }, /* XSUM_XXH32_testdata[2594] */
    { 1297, 0x9E3779B1U, 0xB11282D0U }, /* XSUM_XXH32_testdata[2595] */
    { 1298, 0x00000000U, 0x2A6C6F76U }, /* XSUM_XXH32_testdata[2596] */
    { 1298, 0x9E3779B1U, 0x6B668879U }, /* XSUM_XXH32_testdata[2597] */
    { 1299, 0x00000000U, 0x468FA26BU }, /* XSUM_XXH32_testdata[2598] */
    { 1299, 0x9E3779B1U, 0xF7E41D7CU }, /* XSUM_XXH32_testdata[2599] */
    { 1300, 0x00000000U, 0x209C6B5DU }, /* XSUM_XXH32_testdata[2600] */
    { 1300, 0x9E3779B1U, 0xF5B5CF78U }, /* XSUM_XXH32_testdata[2601] */
    { 1301, 0x00000000U, 0x3A693473U }, /* XSUM_XXH32_testdata[2602] */
    { 1301, 0x9E3779B1U, 0x80B60DE5U }, /* XSUM_XXH32_testdata[2603] */
    { 1302, 0x00000000U, 0x7F9E9BA5U }, /* XSUM_XXH32_testdata[2604] */
    { 1302, 0x9E3779B1U, 0xC6C7CB6EU }, /* XSUM_XXH32_testdata[2605] */
    { 1303, 0x00000000U, 0xEE7AC24AU }, /* XSUM_XXH32_testdata[2606] */
    { 1303, 0x9E3779B1U, 0xF9FF514AU }, /* XSUM_XXH32_testdata[2607] */
    { 1304, 0x00000000U, 0x4818F809U }, /* XSUM_XXH32_testdata[2608] */
    { 1304, 0x9E3779B1U, 0xD2E62D34U }, /* XSUM_XXH32_testdata[2609] */
    { 1305, 0x00000000U, 0xCBE8890FU }, /* XSUM_XXH32_testdata[2610] */
    { 1305, 0x9E3779B1U, 0x63674791U }, /* XSUM_XXH32_testdata[2611] */
    { 1306, 0x00000000U, 0x8E7AA579U }, /* XSUM_XXH32_testdata[2612] */
    { 1306, 0x9E3779B1U, 0x3E3749A5U }, /* XSUM_XXH32_testdata[2613] */
    { 1307, 0x00000000U, 0x93822890U }, /* XSUM_XXH32_testdata[2614] */
    { 1307, 0x9E3779B1U, 0x2B2ADA9FU }, /* XSUM_XXH32_testdata[2615] */
    { 1308, 0x00000000U, 0xF56F9743U }, /* XSUM_XXH32_testdata[2616] */
    { 1308, 0x9E3779B1U, 0x64B58491U }, /* XSUM_XXH32_testdata[2617] */
    { 1309, 0x00000000U, 0x20682B4AU }, /* XSUM_XXH32_testdata[2618] */
    { 1309, 0x9E3779B1U, 0x7ED542FCU }, /* XSUM_XXH32_testdata[2619] */
    { 1310, 0x00000000U, 0x94D0BA6AU }, /* XSUM_XXH32_testdata[2620] */
    { 1310, 0x9E3779B1U, 0xCC1D2EEAU }, /* XSUM_XXH32_testdata[2621] */
    { 1311, 0x00000000U, 0x659608A6U }, /* XSUM_XXH32_testdata[2622] */
    { 1311, 0x9E3779B1U, 0x3B166B06U }, /* XSUM_XXH32_testdata[2623] */
    { 1312, 0x00000000U, 0x332A8EE0U }, /* XSUM_XXH32_testdata[2624] */
    { 1312, 0x9E3779B1U, 0xCCB40380U }, /* XSUM_XXH32_testdata[2625] */
    { 1313, 0x00000000U, 0xEC5A7C00U }, /* XSUM_XXH32_testdata[2626] */
    { 1313, 0x9E3779B1U, 0xBFBD7EB8U }, /* XSUM_XXH32_testdata[2627] */
    { 1314, 0x00000000U, 0x876FAAA0U }, /* XSUM_XXH32_testdata[2628] */
    { 1314, 0x9E3779B1U, 0x2BD64B48U }, /* XSUM_XXH32_testdata[2629] */
    { 1315, 0x00000000U, 0xF880F710U }, /* XSUM_XXH32_testdata[2630] */
    { 1315, 0x9E3779B1U, 0x0BACA9EDU }, /* XSUM_XXH32_testdata[2631] */
    { 1316, 0x00000000U, 0x71711259U }, /* XSUM_XXH32_testdata[2632] */
    { 1316, 0x9E3779B1U, 0xF25110A5U }, /* XSUM_XXH32_testdata[2633] */
    { 1317, 0x00000000U, 0x2812251BU }, /* XSUM_XXH32_testdata[2634] */
    { 1317, 0x9E3779B1U, 0x5A42BB9FU }, /* XSUM_XXH32_testdata[2635] */
    { 1318, 0x00000000U, 0xBF018379U }, /* XSUM_XXH32_testdata[2636] */
    { 1318, 0x9E3779B1U, 0x40CA971CU }, /* XSUM_XXH32_testdata[2637] */
    { 1319, 0x00000000U, 0x090A3E78U }, /* XSUM_XXH32_testdata[2638] */
    { 1319, 0x9E3779B1U, 0xD1AE8554U }, /* XSUM_XXH32_testdata[2639] */
    { 1320, 0x00000000U, 0xC4ECE7E5U }, /* XSUM_XXH32_testdata[2640] */
    { 1320, 0x9E3779B1U, 0x030264F7U }, /* XSUM_XXH32_testdata[2641] */
    { 1321, 0x00000000U, 0x2B6CCAF7U }, /* XSUM_XXH32_testdata[2642] */
    { 1321, 0x9E3779B1U, 0x52292B0FU }, /* XSUM_XXH32_testdata[2643] */
    { 1322, 0x00000000U, 0x7E716BBEU }, /* XSUM_XXH32_testdata[2644] */
    { 1322, 0x9E3779B1U, 0x41EAB24FU }, /* XSUM_XXH32_testdata[2645] */
    { 1323, 0x00000000U, 0xAF8250C9U }, /* XSUM_XXH32_testdata[2646] */
    { 1323, 0x9E3779B1U, 0x351086A2U }, /* XSUM_XXH32_testdata[2647] */
    { 1324, 0x00000000U, 0x17690F50U }, /* XSUM_XXH32_testdata[2648] */
    { 1324, 0x9E3779B1U, 0x1B44CC23U }, /* XSUM_XXH32_testdata[2649] */
    { 1325, 0x00000000U, 0xC02F41B3U }, /* XSUM_XXH32_testdata[2650] */
    { 1325, 0x9E3779B1U, 0xAB5BC75DU }, /* XSUM_XXH32_testdata[2651] */
    { 1326, 0x00000000U, 0xF6B26054U }, /* XSUM_XXH32_testdata[2652] */
    { 1326, 0x9E3779B1U, 0x3A50A9BBU }, /* XSUM_XXH32_testdata[2653] */
    { 1327, 0x00000000U, 0x1A98D09BU }, /* XSUM_XXH32_testdata[2654] */
    { 1327, 0x9E3779B1U, 0xF732461FU }, /* XSUM_XXH32_testdata[2655] */
    { 1328, 0x00000000U, 0xB39B192CU }, /* XSUM_XXH32_testdata[2656] */
    { 1328, 0x9E3779B1U, 0x6151A4F5U }, /* XSUM_XXH32_testdata[2657] */
    { 1329, 0x00000000U, 0x8C40F824U }, /* XSUM_XXH32_testdata[2658] */
    { 1329, 0x9E3779B1U, 0x99555511U }, /* XSUM_XXH32_testdata[2659] */
    { 1330, 0x00000000U, 0x13879480U }, /* XSUM_XXH32_testdata[2660] */
    { 1330, 0x9E3779B1U, 0x939B3510U }, /* XSUM_XXH32_testdata[2661] */
    { 1331, 0x00000000U, 0xD703BB14U }, /* XSUM_XXH32_testdata[2662] */
    { 1331, 0x9E3779B1U, 0xD116A1F9U }, /* XSUM_XXH32_testdata[2663] */
    { 1332, 0x00000000U, 0x87F1C5D9U }, /* XSUM_XXH32_testdata[2664] */
    { 1332, 0x9E3779B1U, 0x14597EF7U }, /* XSUM_XXH32_testdata[2665] */
    { 1333, 0x00000000U, 0x69B31BACU }, /* XSUM_XXH32_testdata[2666] */
    { 1333, 0x9E3779B1U, 0x2CE8FA3AU }, /* XSUM_XXH32_testdata[2667] */
    { 1334, 0x00000000U, 0x37A6A8C4U }, /* XSUM_XXH32_testdata[2668] */
    { 1334, 0x9E3779B1U, 0x3779624AU }, /* XSUM_XXH32_testdata[2669] */
    { 1335, 0x00000000U, 0x941F386DU }, /* XSUM_XXH32_testdata[2670] */
    { 1335, 0x9E3779B1U, 0x1B70E156U }, /* XSUM_XXH32_testdata[2671] */
    { 1336, 0x00000000U, 0x1586CEFAU }, /* XSUM_XXH32_testdata[2672] */
    { 1336, 0x9E3779B1U, 0x84A84E53U }, /* XSUM_XXH32_testdata[2673] */
    { 1337, 0x00000000U, 0xF488CFDCU }, /* XSUM_XXH32_testdata[2674] */
    { 1337, 0x9E3779B1U, 0xEA961D61U }, /* XSUM_XXH32_testdata[2675] */
    { 1338, 0x00000000U, 0xF7828592U }, /* XSUM_XXH32_testdata[2676] */
    { 1338, 0x9E3779B1U, 0x73B68612U }, /* XSUM_XXH32_testdata[2677] */
    { 1339, 0x00000000U, 0xC60B6CACU }, /* XSUM_XXH32_testdata[2678] */
    { 1339, 0x9E3779B1U, 0x4144EA47U }, /* XSUM_XXH32_testdata[2679] */
    { 1340, 0x00000000U, 0x23D2167FU }, /* XSUM_XXH32_testdata[2680] */
    { 1340, 0x9E3779B1U, 0x7CE2B4B1U }, /* XSUM_XXH32_testdata[2681] */
    { 1341, 0x00000000U, 0x77C5C3BAU }, /* XSUM_XXH32_testdata[2682] */
    { 1341, 0x9E3779B1U, 0x26CAA0AAU }, /* XSUM_XXH32_testdata[2683] */
    { 1342, 0x00000000U, 0x9BB7390FU }, /* XSUM_XXH32_testdata[2684] */
    { 1342, 0x9E3779B1U, 0xD220E867U }, /* XSUM_XXH32_testdata[2685] */
    { 1343, 0x00000000U, 0x9AA3006FU }, /* XSUM_XXH32_testdata[2686] */
    { 1343, 0x9E3779B1U, 0x2EFE362BU }, /* XSUM_XXH32_testdata[2687] */
    { 1344, 0x00000000U, 0x7C3973CCU }, /* XSUM_XXH32_testdata[2688] */
    { 1344, 0x9E3779B1U, 0xBE444DC4U }, /* XSUM_XXH32_testdata[2689] */
    { 1345, 0x00000000U, 0x67FDA757U }, /* XSUM_XXH32_testdata[2690] */
    { 1345, 0x9E3779B1U, 0xE609D277U }, /* XSUM_XXH32_testdata[2691] */
    { 1346, 0x00000000U, 0x61965DEDU }, /* XSUM_XXH32_testdata[2692] */
    { 1346, 0x9E3779B1U, 0x793F34BBU }, /* XSUM_XXH32_testdata[2693] */
    { 1347, 0x00000000U, 0xB4861186U }, /* XSUM_XXH32_testdata[2694] */
    { 1347, 0x9E3779B1U, 0xF54A959EU }, /* XSUM_XXH32_testdata[2695] */
    { 1348, 0x00000000U, 0x4F4E0553U }, /* XSUM_XXH32_testdata[2696] */
    { 1348, 0x9E3779B1U, 0xE29AA5F5U }, /* XSUM_XXH32_testdata[2697] */
    { 1349, 0x00000000U, 0xCD296EA3U }, /* XSUM_XXH32_testdata[2698] */
    { 1349, 0x9E3779B1U, 0xAADE20F2U }, /* XSUM_XXH32_testdata[2699] */
    { 1350, 0x00000000U, 0x53C5FBFCU }, /* XSUM_XXH32_testdata[2700] */
    { 1350, 0x9E3779B1U, 0xFCB744F0U }, /* XSUM_XXH32_testdata[2701] */
    { 1351, 0x00000000U, 0xF24020ECU }, /* XSUM_XXH32_testdata[2702] */
    { 1351, 0x9E3779B1U, 0xD13DDB18U }, /* XSUM_XXH32_testdata[2703] */
    { 1352, 0x00000000U, 0xC95FAC0DU }, /* XSUM_XXH32_testdata[2704] */
    { 1352, 0x9E3779B1U, 0x4F93839EU }, /* XSUM_XXH32_testdata[2705] */
    { 1353, 0x00000000U, 0xEA326090U }, /* XSUM_XXH32_testdata[2706] */
    { 1353, 0x9E3779B1U, 0x0622F5D2U }, /* XSUM_XXH32_testdata[2707] */
    { 1354, 0x00000000U, 0x86E4DDA8U }, /* XSUM_XXH32_testdata[2708] */
    { 1354, 0x9E3779B1U, 0xB6DF4E6BU }, /* XSUM_XXH32_testdata[2709] */
    { 1355, 0x00000000U, 0xB87A0703U }, /* XSUM_XXH32_testdata[2710] */
    { 1355, 0x9E3779B1U, 0xD5C87EB7U }, /* XSUM_XXH32_testdata[2711] */
    { 1356, 0x00000000U, 0x1C342F7FU }, /* XSUM_XXH32_testdata[2712] */
    { 1356, 0x9E3779B1U, 0x23736B55U }, /* XSUM_XXH32_testdata[2713] */
    { 1357, 0x00000000U, 0x0E011104U }, /* XSUM_XXH32_testdata[2714] */
    { 1357, 0x9E3779B1U, 0xDE0F61ACU }, /* XSUM_XXH32_testdata[2715] */
    { 1358, 0x00000000U, 0x0976CE50U }, /* XSUM_XXH32_testdata[2716] */
    { 1358, 0x9E3779B1U, 0xF51DA101U }, /* XSUM_XXH32_testdata[2717] */
    { 1359, 0x00000000U, 0x72B42BB6U }, /* XSUM_XXH32_testdata[2718] */
    { 1359, 0x9E3779B1U, 0x7074D178U }, /* XSUM_XXH32_testdata[2719] */
    { 1360, 0x00000000U, 0xA5166671U }, /* XSUM_XXH32_testdata[2720] */
    { 1360, 0x9E3779B1U, 0xD522E653U }, /* XSUM_XXH32_testdata[2721] */
    { 1361, 0x00000000U, 0x43A03D77U }, /* XSUM_XXH32_testdata[2722] */
    { 1361, 0x9E3779B1U, 0x82F19731U }, /* XSUM_XXH32_testdata[2723] */
    { 1362, 0x00000000U, 0x01760E55U }, /* XSUM_XXH32_testdata[2724] */
    { 1362, 0x9E3779B1U, 0x2452BAD7U }, /* XSUM_XXH32_testdata[2725] */
    { 1363, 0x00000000U, 0x813B822CU }, /* XSUM_XXH32_testdata[2726] */
    { 1363, 0x9E3779B1U, 0x678CC0ECU }, /* XSUM_XXH32_testdata[2727] */
    { 1364, 0x00000000U, 0x6E2EAA8CU }, /* XSUM_XXH32_testdata[2728] */
    { 1364, 0x9E3779B1U, 0xCCADC6DCU }, /* XSUM_XXH32_testdata[2729] */
    { 1365, 0x00000000U, 0xFD1C6D1BU }, /* XSUM_XXH32_testdata[2730] */
    { 1365, 0x9E3779B1U, 0x0417DFBBU }, /* XSUM_XXH32_testdata[2731] */
    { 1366, 0x00000000U, 0x03A77FA3U }, /* XSUM_XXH32_testdata[2732] */
    { 1366, 0x9E3779B1U, 0xBB44CC3EU }, /* XSUM_XXH32_testdata[2733] */
    { 1367, 0x00000000U, 0x691B3F30U }, /* XSUM_XXH32_testdata[2734] */
    { 1367, 0x9E3779B1U, 0xEEAB3786U }, /* XSUM_XXH32_testdata[2735] */
    { 1368, 0x00000000U, 0x5EF7B99BU }, /* XSUM_XXH32_testdata[2736] */
    { 1368, 0x9E3779B1U, 0xF846521AU }, /* XSUM_XXH32_testdata[2737] */
    { 1369, 0x00000000U, 0x41F32CE8U }, /* XSUM_XXH32_testdata[2738] */
    { 1369, 0x9E3779B1U, 0x1378FC71U }, /* XSUM_XXH32_testdata[2739] */
    { 1370, 0x00000000U, 0xCF2A06E8U }, /* XSUM_XXH32_testdata[2740] */
    { 1370, 0x9E3779B1U, 0x1D8D45DEU }, /* XSUM_XXH32_testdata[2741] */
    { 1371, 0x00000000U, 0x29EAE45CU }, /* XSUM_XXH32_testdata[2742] */
    { 1371, 0x9E3779B1U, 0x7318BB02U }, /* XSUM_XXH32_testdata[2743] */
    { 1372, 0x00000000U, 0xE39F1B94U }, /* XSUM_XXH32_testdata[2744] */
    { 1372, 0x9E3779B1U, 0x76BE5B11U }, /* XSUM_XXH32_testdata[2745] */
    { 1373, 0x00000000U, 0x9A1A4D06U }, /* XSUM_XXH32_testdata[2746] */
    { 1373, 0x9E3779B1U, 0x4598B26EU }, /* XSUM_XXH32_testdata[2747] */
    { 1374, 0x00000000U, 0x688A7E3CU }, /* XSUM_XXH32_testdata[2748] */
    { 1374, 0x9E3779B1U, 0x27616B17U }, /* XSUM_XXH32_testdata[2749] */
    { 1375, 0x00000000U, 0xAF99A477U }, /* XSUM_XXH32_testdata[2750] */
    { 1375, 0x9E3779B1U, 0x6DA8288DU }, /* XSUM_XXH32_testdata[2751] */
    { 1376, 0x00000000U, 0x1EBE7C58U }, /* XSUM_XXH32_testdata[2752] */
    { 1376, 0x9E3779B1U, 0x51C696AAU }, /* XSUM_XXH32_testdata[2753] */
    { 1377, 0x00000000U, 0xEB84C288U }, /* XSUM_XXH32_testdata[2754] */
    { 1377, 0x9E3779B1U, 0x1CD6C654U }, /* XSUM_XXH32_testdata[2755] */
    { 1378, 0x00000000U, 0x7E837336U }, /* XSUM_XXH32_testdata[2756] */
    { 1378, 0x9E3779B1U, 0x6750EC5BU }, /* XSUM_XXH32_testdata[2757] */
    { 1379, 0x00000000U, 0xDA0750E5U }, /* XSUM_XXH32_testdata[2758] */
    { 1379, 0x9E3779B1U, 0x81CA570DU }, /* XSUM_XXH32_testdata[2759] */
    { 1380, 0x00000000U, 0x5543619FU }, /* XSUM_XXH32_testdata[2760] */
    { 1380, 0x9E3779B1U, 0xC381E5DBU }, /* XSUM_XXH32_testdata[2761] */
    { 1381, 0x00000000U, 0x616B4BDCU }, /* XSUM_XXH32_testdata[2762] */
    { 1381, 0x9E3779B1U, 0x6B75A005U }, /* XSUM_XXH32_testdata[2763] */
    { 1382, 0x00000000U, 0xF12E20FCU }, /* XSUM_XXH32_testdata[2764] */
    { 1382, 0x9E3779B1U, 0xE3D3E62EU }, /* XSUM_XXH32_testdata[2765] */
    { 1383, 0x00000000U, 0x59F2C73CU }, /* XSUM_XXH32_testdata[2766] */
    { 1383, 0x9E3779B1U, 0x5464F444U }, /* XSUM_XXH32_testdata[2767] */
    { 1384, 0x00000000U, 0x28DB96CAU }, /* XSUM_XXH32_testdata[2768] */
    { 1384, 0x9E3779B1U, 0xB7253994U }, /* XSUM_XXH32_testdata[2769] */
    { 1385, 0x00000000U, 0x11660CF1U }, /* XSUM_XXH32_testdata[2770] */
    { 1385, 0x9E3779B1U, 0x0F206FCFU }, /* XSUM_XXH32_testdata[2771] */
    { 1386, 0x00000000U, 0xE16504ADU }, /* XSUM_XXH32_testdata[2772] */
    { 1386, 0x9E3779B1U, 0xA3182A6EU }, /* XSUM_XXH32_testdata[2773] */
    { 1387, 0x00000000U, 0x8CFC9B9AU }, /* XSUM_XXH32_testdata[2774] */
    { 1387, 0x9E3779B1U, 0x9755A534U }, /* XSUM_XXH32_testdata[2775] */
    { 1388, 0x00000000U, 0xCDC0D867U }, /* XSUM_XXH32_testdata[2776] */
    { 1388, 0x9E3779B1U, 0x43F6B298U }, /* XSUM_XXH32_testdata[2777] */
    { 1389, 0x00000000U, 0x889A1EDAU }, /* XSUM_XXH32_testdata[2778] */
    { 1389, 0x9E3779B1U, 0x2C6A9486U }, /* XSUM_XXH32_testdata[2779] */
    { 1390, 0x00000000U, 0xD59AFB14U }, /* XSUM_XXH32_testdata[2780] */
    { 1390, 0x9E3779B1U, 0xD5FEEDF1U }, /* XSUM_XXH32_testdata[2781] */
    { 1391, 0x00000000U, 0x9ABE6F46U }, /* XSUM_XXH32_testdata[2782] */
    { 1391, 0x9E3779B1U, 0x2931C68CU }, /* XSUM_XXH32_testdata[2783] */
    { 1392, 0x00000000U, 0xC7A77F4CU }, /* XSUM_XXH32_testdata[2784] */
    { 1392, 0x9E3779B1U, 0xC2B5B646U }, /* XSUM_XXH32_testdata[2785] */
    { 1393, 0x00000000U, 0xF6642296U }, /* XSUM_XXH32_testdata[2786] */
    { 1393, 0x9E3779B1U, 0xA7DD4B43U }, /* XSUM_XXH32_testdata[2787] */
    { 1394, 0x00000000U, 0xB6E621FDU }, /* XSUM_XXH32_testdata[2788] */
    { 1394, 0x9E3779B1U, 0xB0B5AA8EU }, /* XSUM_XXH32_testdata[2789] */
    { 1395, 0x00000000U, 0xFC8E12A3U }, /* XSUM_XXH32_testdata[2790] */
    { 1395, 0x9E3779B1U, 0x17C09522U }, /* XSUM_XXH32_testdata[2791] */
    { 1396, 0x00000000U, 0x6C554B8AU }, /* XSUM_XXH32_testdata[2792] */
    { 1396, 0x9E3779B1U, 0x0A71965EU }, /* XSUM_XXH32_testdata[2793] */
    { 1397, 0x00000000U, 0x97EF74A7U }, /* XSUM_XXH32_testdata[2794] */
    { 1397, 0x9E3779B1U, 0xC6413DC4U }, /* XSUM_XXH32_testdata[2795] */
    { 1398, 0x00000000U, 0xAE94CB53U }, /* XSUM_XXH32_testdata[2796] */
    { 1398, 0x9E3779B1U, 0x590FD2BFU }, /* XSUM_XXH32_testdata[2797] */
    { 1399, 0x00000000U, 0xBC69B6C3U }, /* XSUM_XXH32_testdata[2798] */
    { 1399, 0x9E3779B1U, 0x97457FE4U }, /* XSUM_XXH32_testdata[2799] */
    { 1400, 0x00000000U, 0x2A72F074U }, /* XSUM_XXH32_testdata[2800] */
    { 1400, 0x9E3779B1U, 0x9C74A24CU }, /* XSUM_XXH32_testdata[2801] */
    { 1401, 0x00000000U, 0x4B6BFCC1U }, /* XSUM_XXH32_testdata[2802] */
    { 1401, 0x9E3779B1U, 0xD74133C7U }, /* XSUM_XXH32_testdata[2803] */
    { 1402, 0x00000000U, 0x7FC2D82CU }, /* XSUM_XXH32_testdata[2804] */
    { 1402, 0x9E3779B1U, 0xDC12A98DU }, /* XSUM_XXH32_testdata[2805] */
    { 1403, 0x00000000U, 0x10A30F0BU }, /* XSUM_XXH32_testdata[2806] */
    { 1403, 0x9E3779B1U, 0x556C6675U }, /* XSUM_XXH32_testdata[2807] */
    { 1404, 0x00000000U, 0x66F3957BU }, /* XSUM_XXH32_testdata[2808] */
    { 1404, 0x9E3779B1U, 0x4DFE2282U }, /* XSUM_XXH32_testdata[2809] */
    { 1405, 0x00000000U, 0x5D7B7674U }, /* XSUM_XXH32_testdata[2810] */
    { 1405, 0x9E3779B1U, 0x911584B8U }, /* XSUM_XXH32_testdata[2811] */
    { 1406, 0x00000000U, 0xD5D49314U }, /* XSUM_XXH32_testdata[2812] */
    { 1406, 0x9E3779B1U, 0xB575832DU }, /* XSUM_XXH32_testdata[2813] */
    { 1407, 0x00000000U, 0xC89A1F79U }, /* XSUM_XXH32_testdata[2814] */
    { 1407, 0x9E3779B1U, 0xBC0E196BU }, /* XSUM_XXH32_testdata[2815] */
    { 1408, 0x00000000U, 0x0DFE8294U }, /* XSUM_XXH32_testdata[2816] */
    { 1408, 0x9E3779B1U, 0xED10BD15U }, /* XSUM_XXH32_testdata[2817] */
    { 1409, 0x00000000U, 0xD19CDC2EU }, /* XSUM_XXH32_testdata[2818] */
    { 1409, 0x9E3779B1U, 0x725BD2E1U }, /* XSUM_XXH32_testdata[2819] */
    { 1410, 0x00000000U, 0x4119B72EU }, /* XSUM_XXH32_testdata[2820] */
    { 1410, 0x9E3779B1U, 0x593BC6C4U }, /* XSUM_XXH32_testdata[2821] */
    { 1411, 0x00000000U, 0x45CCE29BU }, /* XSUM_XXH32_testdata[2822] */
    { 1411, 0x9E3779B1U, 0x13D96973U }, /* XSUM_XXH32_testdata[2823] */
    { 1412, 0x00000000U, 0x21CB0B9AU }, /* XSUM_XXH32_testdata[2824] */
    { 1412, 0x9E3779B1U, 0x4A7EE4C4U }, /* XSUM_XXH32_testdata[2825] */
    { 1413, 0x00000000U, 0xA7997074U }, /* XSUM_XXH32_testdata[2826] */
    { 1413, 0x9E3779B1U, 0xBF713AB1U }, /* XSUM_XXH32_testdata[2827] */
    { 1414, 0x00000000U, 0xA2CEC4F5U }, /* XSUM_XXH32_testdata[2828] */
    { 1414, 0x9E3779B1U, 0x1FA79D80U }, /* XSUM_XXH32_testdata[2829] */
    { 1415, 0x00000000U, 0x0F814A6EU }, /* XSUM_XXH32_testdata[2830] */
    { 1415, 0x9E3779B1U, 0xA3884D73U }, /* XSUM_XXH32_testdata[2831] */
    { 1416, 0x00000000U, 0x20679E8BU }, /* XSUM_XXH32_testdata[2832] */
    { 1416, 0x9E3779B1U, 0x005C56DFU }, /* XSUM_XXH32_testdata[2833] */
    { 1417, 0x00000000U, 0x0432202FU }, /* XSUM_XXH32_testdata[2834] */
    { 1417, 0x9E3779B1U, 0xB631CD97U }, /* XSUM_XXH32_testdata[2835] */
    { 1418, 0x00000000U, 0x7D08D0FAU }, /* XSUM_XXH32_testdata[2836] */
    { 1418, 0x9E3779B1U, 0x04349D10U }, /* XSUM_XXH32_testdata[2837] */
    { 1419, 0x00000000U, 0xC3EBF980U }, /* XSUM_XXH32_testdata[2838] */
    { 1419, 0x9E3779B1U, 0x7692E29DU }, /* XSUM_XXH32_testdata[2839] */
    { 1420, 0x00000000U, 0xA56505C3U }, /* XSUM_XXH32_testdata[2840] */
    { 1420, 0x9E3779B1U, 0x5EAF087AU }, /* XSUM_XXH32_testdata[2841] */
    { 1421, 0x00000000U, 0x78CE85ACU }, /* XSUM_XXH32_testdata[2842] */
    { 1421, 0x9E3779B1U, 0x98EC1EC8U }, /* XSUM_XXH32_testdata[2843] */
    { 1422, 0x00000000U, 0xB4E81E27U }, /* XSUM_XXH32_testdata[2844] */
    { 1422, 0x9E3779B1U, 0xEE79131EU }, /* XSUM_XXH32_testdata[2845] */
    { 1423, 0x00000000U, 0x1300FB1DU }, /* XSUM_XXH32_testdata[2846] */
    { 1423, 0x9E3779B1U, 0xA6AAD254U }, /* XSUM_XXH32_testdata[2847] */
    { 1424, 0x00000000U, 0xB9F71B65U }, /* XSUM_XXH32_testdata[2848] */
    { 1424, 0x9E3779B1U, 0xFDB3F66BU }, /* XSUM_XXH32_testdata[2849] */
    { 1425, 0x00000000U, 0x21176B58U }, /* XSUM_XXH32_testdata[2850] */
    { 1425, 0x9E3779B1U, 0x0A9DAB87U }, /* XSUM_XXH32_testdata[2851] */
    { 1426, 0x00000000U, 0xA773945FU }, /* XSUM_XXH32_testdata[2852] */
    { 1426, 0x9E3779B1U, 0xF6FCF60AU }, /* XSUM_XXH32_testdata[2853] */
    { 1427, 0x00000000U, 0x9FDBE7B3U }, /* XSUM_XXH32_testdata[2854] */
    { 1427, 0x9E3779B1U, 0x670BB1A7U }, /* XSUM_XXH32_testdata[2855] */
    { 1428, 0x00000000U, 0x661DB06EU }, /* XSUM_XXH32_testdata[2856] */
    { 1428, 0x9E3779B1U, 0x4FD661AAU }, /* XSUM_XXH32_testdata[2857] */
    { 1429, 0x00000000U, 0xFB224CC2U }, /* XSUM_XXH32_testdata[2858] */
    { 1429, 0x9E3779B1U, 0x3C85B32CU }, /* XSUM_XXH32_testdata[2859] */
    { 1430, 0x00000000U, 0x463C1DC8U }, /* XSUM_XXH32_testdata[2860] */
    { 1430, 0x9E3779B1U, 0x8EB2F324U }, /* XSUM_XXH32_testdata[2861] */
    { 1431, 0x00000000U, 0x2243C699U }, /* XSUM_XXH32_testdata[2862] */
    { 1431, 0x9E3779B1U, 0x60ADE561U }, /* XSUM_XXH32_testdata[2863] */
    { 1432, 0x00000000U, 0xE0327A81U }, /* XSUM_XXH32_testdata[2864] */
    { 1432, 0x9E3779B1U, 0x6EA60C2CU }, /* XSUM_XXH32_testdata[2865] */
    { 1433, 0x00000000U, 0x299D8963U }, /* XSUM_XXH32_testdata[2866] */
    { 1433, 0x9E3779B1U, 0x959A1254U }, /* XSUM_XXH32_testdata[2867] */
    { 1434, 0x00000000U, 0x638EDEA5U }, /* XSUM_XXH32_testdata[2868] */
    { 1434, 0x9E3779B1U, 0xE9F0D047U }, /* XSUM_XXH32_testdata[2869] */
    { 1435, 0x00000000U, 0x388EC35AU }, /* XSUM_XXH32_testdata[2870] */
    { 1435, 0x9E3779B1U, 0xA946B3CAU }, /* XSUM_XXH32_testdata[2871] */
    { 1436, 0x00000000U, 0x9784535EU }, /* XSUM_XXH32_testdata[2872] */
    { 1436, 0x9E3779B1U, 0xFD5C545BU }, /* XSUM_XXH32_testdata[2873] */
    { 1437, 0x00000000U, 0xB85C3D80U }, /* XSUM_XXH32_testdata[2874] */
    { 1437, 0x9E3779B1U, 0xB1A43ACAU }, /* XSUM_XXH32_testdata[2875] */
    { 1438, 0x00000000U, 0xD980C334U }, /* XSUM_XXH32_testdata[2876] */
    { 1438, 0x9E3779B1U, 0xA16E1773U }, /* XSUM_XXH32_testdata[2877] */
    { 1439, 0x00000000U, 0x5C5B3834U }, /* XSUM_XXH32_testdata[2878] */
    { 1439, 0x9E3779B1U, 0xE50ED1FFU }, /* XSUM_XXH32_testdata[2879] */
    { 1440, 0x00000000U, 0x05D63325U }, /* XSUM_XXH32_testdata[2880] */
    { 1440, 0x9E3779B1U, 0x6EFDF566U }, /* XSUM_XXH32_testdata[2881] */
    { 1441, 0x00000000U, 0x453E6103U }, /* XSUM_XXH32_testdata[2882] */
    { 1441, 0x9E3779B1U, 0x1FAD079BU }, /* XSUM_XXH32_testdata[2883] */
    { 1442, 0x00000000U, 0x4171244AU }, /* XSUM_XXH32_testdata[2884] */
    { 1442, 0x9E3779B1U, 0x73A2B038U }, /* XSUM_XXH32_testdata[2885] */
    { 1443, 0x00000000U, 0x1ADE526BU }, /* XSUM_XXH32_testdata[2886] */
    { 1443, 0x9E3779B1U, 0xAAA56805U }, /* XSUM_XXH32_testdata[2887] */
    { 1444, 0x00000000U, 0x3B321083U }, /* XSUM_XXH32_testdata[2888] */
    { 1444, 0x9E3779B1U, 0xC84F89FAU }, /* XSUM_XXH32_testdata[2889] */
    { 1445, 0x00000000U, 0x2A2E4FCAU }, /* XSUM_XXH32_testdata[2890] */
    { 1445, 0x9E3779B1U, 0x646272DCU }, /* XSUM_XXH32_testdata[2891] */
    { 1446, 0x00000000U, 0x3F2FF28FU }, /* XSUM_XXH32_testdata[2892] */
    { 1446, 0x9E3779B1U, 0x5906DC49U }, /* XSUM_XXH32_testdata[2893] */
    { 1447, 0x00000000U, 0x897B22D0U }, /* XSUM_XXH32_testdata[2894] */
    { 1447, 0x9E3779B1U, 0x89A088E7U }, /* XSUM_XXH32_testdata[2895] */
    { 1448, 0x00000000U, 0x4C898B3AU }, /* XSUM_XXH32_testdata[2896] */
    { 1448, 0x9E3779B1U, 0x12C8E645U }, /* XSUM_XXH32_testdata[2897] */
    { 1449, 0x00000000U, 0xC5B555C4U }, /* XSUM_XXH32_testdata[2898] */
    { 1449, 0x9E3779B1U, 0x3A8EE208U }, /* XSUM_XXH32_testdata[2899] */
    { 1450, 0x00000000U, 0xC81121CEU }, /* XSUM_XXH32_testdata[2900] */
    { 1450, 0x9E3779B1U, 0x2C11D7DFU }, /* XSUM_XXH32_testdata[2901] */
    { 1451, 0x00000000U, 0x27EBC1E1U }, /* XSUM_XXH32_testdata[2902] */
    { 1451, 0x9E3779B1U, 0x150C1A09U }, /* XSUM_XXH32_testdata[2903] */
    { 1452, 0x00000000U, 0xF57F7F47U }, /* XSUM_XXH32_testdata[2904] */
    { 1452, 0x9E3779B1U, 0xC896F626U }, /* XSUM_XXH32_testdata[2905] */
    { 1453, 0x00000000U, 0xB15772A2U }, /* XSUM_XXH32_testdata[2906] */
    { 1453, 0x9E3779B1U, 0xBD60C28BU }, /* XSUM_XXH32_testdata[2907] */
    { 1454, 0x00000000U, 0x8E2D55E3U }, /* XSUM_XXH32_testdata[2908] */
    { 1454, 0x9E3779B1U, 0xDF18385DU }, /* XSUM_XXH32_testdata[2909] */
    { 1455, 0x00000000U, 0x7D0BC3ADU }, /* XSUM_XXH32_testdata[2910] */
    { 1455, 0x9E3779B1U, 0x48DCD49FU }, /* XSUM_XXH32_testdata[2911] */
    { 1456, 0x00000000U, 0x99FB477DU }, /* XSUM_XXH32_testdata[2912] */
    { 1456, 0x9E3779B1U, 0x902CA6AAU }, /* XSUM_XXH32_testdata[2913] */
    { 1457, 0x00000000U, 0xB267EB4CU }, /* XSUM_XXH32_testdata[2914] */
    { 1457, 0x9E3779B1U, 0x56DA93D9U }, /* XSUM_XXH32_testdata[2915] */
    { 1458, 0x00000000U, 0x4F1C3B24U }, /* XSUM_XXH32_testdata[2916] */
    { 1458, 0x9E3779B1U, 0x2F707029U }, /* XSUM_XXH32_testdata[2917] */
    { 1459, 0x00000000U, 0xE192EC10U }, /* XSUM_XXH32_testdata[2918] */
    { 1459, 0x9E3779B1U, 0xE99EEC91U }, /* XSUM_XXH32_testdata[2919] */
    { 1460, 0x00000000U, 0x64563F28U }, /* XSUM_XXH32_testdata[2920] */
    { 1460, 0x9E3779B1U, 0x793DB711U }, /* XSUM_XXH32_testdata[2921] */
    { 1461, 0x00000000U, 0xD772C184U }, /* XSUM_XXH32_testdata[2922] */
    { 1461, 0x9E3779B1U, 0x0FE2DAF3U }, /* XSUM_XXH32_testdata[2923] */
    { 1462, 0x00000000U, 0x76E3DC31U }, /* XSUM_XXH32_testdata[2924] */
    { 1462, 0x9E3779B1U, 0x254AD675U }, /* XSUM_XXH32_testdata[2925] */
    { 1463, 0x00000000U, 0xB1942E60U }, /* XSUM_XXH32_testdata[2926] */
    { 1463, 0x9E3779B1U, 0xE1825B19U }, /* XSUM_XXH32_testdata[2927] */
    { 1464, 0x00000000U, 0x56275E1AU }, /* XSUM_XXH32_testdata[2928] */
    { 1464, 0x9E3779B1U, 0xECF903CDU }, /* XSUM_XXH32_testdata[2929] */
    { 1465, 0x00000000U, 0x2AF29989U }, /* XSUM_XXH32_testdata[2930] */
    { 1465, 0x9E3779B1U, 0xD9420B30U }, /* XSUM_XXH32_testdata[2931] */
    { 1466, 0x00000000U, 0x27E74C8BU }, /* XSUM_XXH32_testdata[2932] */
    { 1466, 0x9E3779B1U, 0xDA1E69CBU }, /* XSUM_XXH32_testdata[2933] */
    { 1467, 0x00000000U, 0xA04901DBU }, /* XSUM_XXH32_testdata[2934] */
    { 1467, 0x9E3779B1U, 0x607C8CAAU }, /* XSUM_XXH32_testdata[2935] */
    { 1468, 0x00000000U, 0xBBE4680AU }, /* XSUM_XXH32_testdata[2936] */
    { 1468, 0x9E3779B1U, 0x064A986EU }, /* XSUM_XXH32_testdata[2937] */
    { 1469, 0x00000000U, 0x3DADD008U }, /* XSUM_XXH32_testdata[2938] */
    { 1469, 0x9E3779B1U, 0xD2A871C1U }, /* XSUM_XXH32_testdata[2939] */
    { 1470, 0x00000000U, 0xCA095253U }, /* XSUM_XXH32_testdata[2940] */
    { 1470, 0x9E3779B1U, 0x8CA6E1BBU }, /* XSUM_XXH32_testdata[2941] */
    { 1471, 0x00000000U, 0x5AF8F550U }, /* XSUM_XXH32_testdata[2942] */
    { 1471, 0x9E3779B1U, 0xCEDC8EC4U }, /* XSUM_XXH32_testdata[2943] */
    { 1472, 0x00000000U, 0xA07B441AU }, /* XSUM_XXH32_testdata[2944] */
    { 1472, 0x9E3779B1U, 0x5507B3F0U }, /* XSUM_XXH32_testdata[2945] */
    { 1473, 0x00000000U, 0xAAF45E2FU }, /* XSUM_XXH32_testdata[2946] */
    { 1473, 0x9E3779B1U, 0x1ED667D2U }, /* XSUM_XXH32_testdata[2947] */
    { 1474, 0x00000000U, 0xB5CA74FDU }, /* XSUM_XXH32_testdata[2948] */
    { 1474, 0x9E3779B1U, 0x43524B7DU }, /* XSUM_XXH32_testdata[2949] */
    { 1475, 0x00000000U, 0xCF8DFD2EU }, /* XSUM_XXH32_testdata[2950] */
    { 1475, 0x9E3779B1U, 0x6F25725DU }, /* XSUM_XXH32_testdata[2951] */
    { 1476, 0x00000000U, 0xA89A68F6U }, /* XSUM_XXH32_testdata[2952] */
    { 1476, 0x9E3779B1U, 0xAB183A36U }, /* XSUM_XXH32_testdata[2953] */
    { 1477, 0x00000000U, 0x83496213U }, /* XSUM_XXH32_testdata[2954] */
    { 1477, 0x9E3779B1U, 0xA407EEF5U }, /* XSUM_XXH32_testdata[2955] */
    { 1478, 0x00000000U, 0x156DA784U }, /* XSUM_XXH32_testdata[2956] */
    { 1478, 0x9E3779B1U, 0x0A2FCEFAU }, /* XSUM_XXH32_testdata[2957] */
    { 1479, 0x00000000U, 0x629390E3U }, /* XSUM_XXH32_testdata[2958] */
    { 1479, 0x9E3779B1U, 0xF6438AD7U }, /* XSUM_XXH32_testdata[2959] */
    { 1480, 0x00000000U, 0x964F5433U }, /* XSUM_XXH32_testdata[2960] */
    { 1480, 0x9E3779B1U, 0xC87AA437U }, /* XSUM_XXH32_testdata[2961] */
    { 1481, 0x00000000U, 0x4FFB969CU }, /* XSUM_XXH32_testdata[2962] */
    { 1481, 0x9E3779B1U, 0xB06FCA77U }, /* XSUM_XXH32_testdata[2963] */
    { 1482, 0x00000000U, 0x29FA6415U }, /* XSUM_XXH32_testdata[2964] */
    { 1482, 0x9E3779B1U, 0x32D0A061U }, /* XSUM_XXH32_testdata[2965] */
    { 1483, 0x00000000U, 0x7AC08121U }, /* XSUM_XXH32_testdata[2966] */
    { 1483, 0x9E3779B1U, 0x6018A9D9U }, /* XSUM_XXH32_testdata[2967] */
    { 1484, 0x00000000U, 0x563D07CBU }, /* XSUM_XXH32_testdata[2968] */
    { 1484, 0x9E3779B1U, 0x4E5044BAU }, /* XSUM_XXH32_testdata[2969] */
    { 1485, 0x00000000U, 0xECEE3205U }, /* XSUM_XXH32_testdata[2970] */
    { 1485, 0x9E3779B1U, 0xF26D5CFBU }, /* XSUM_XXH32_testdata[2971] */
    { 1486, 0x00000000U, 0x2058A8BAU }, /* XSUM_XXH32_testdata[2972] */
    { 1486, 0x9E3779B1U, 0xC3DA1C88U }, /* XSUM_XXH32_testdata[2973] */
    { 1487, 0x00000000U, 0x5F4FBAA4U }, /* XSUM_XXH32_testdata[2974] */
    { 1487, 0x9E3779B1U, 0x129D0986U }, /* XSUM_XXH32_testdata[2975] */
    { 1488, 0x00000000U, 0xCF6B03FCU }, /* XSUM_XXH32_testdata[2976] */
    { 1488, 0x9E3779B1U, 0xDD6944C8U }, /* XSUM_XXH32_testdata[2977] */
    { 1489, 0x00000000U, 0xB619554CU }, /* XSUM_XXH32_testdata[2978] */
    { 1489, 0x9E3779B1U, 0xCDC97809U }, /* XSUM_XXH32_testdata[2979] */
    { 1490, 0x00000000U, 0xAD7132F7U }, /* XSUM_XXH32_testdata[2980] */
    { 1490, 0x9E3779B1U, 0x386790A9U }, /* XSUM_XXH32_testdata[2981] */
    { 1491, 0x00000000U, 0x9A87DD2BU }, /* XSUM_XXH32_testdata[2982] */
    { 1491, 0x9E3779B1U, 0x54B35790U }, /* XSUM_XXH32_testdata[2983] */
    { 1492, 0x00000000U, 0x02C8444FU }, /* XSUM_XXH32_testdata[2984] */
    { 1492, 0x9E3779B1U, 0xCFB45FEEU }, /* XSUM_XXH32_testdata[2985] */
    { 1493, 0x00000000U, 0xCE87416BU }, /* XSUM_XXH32_testdata[2986] */
    { 1493, 0x9E3779B1U, 0x0C212296U }, /* XSUM_XXH32_testdata[2987] */
    { 1494, 0x00000000U, 0x4D57C6D5U }, /* XSUM_XXH32_testdata[2988] */
    { 1494, 0x9E3779B1U, 0x53F52AE8U }, /* XSUM_XXH32_testdata[2989] */
    { 1495, 0x00000000U, 0xF4F18C65U }, /* XSUM_XXH32_testdata[2990] */
    { 1495, 0x9E3779B1U, 0x2F34B21FU }, /* XSUM_XXH32_testdata[2991] */
    { 1496, 0x00000000U, 0x331FD711U }, /* XSUM_XXH32_testdata[2992] */
    { 1496, 0x9E3779B1U, 0xDD314583U }, /* XSUM_XXH32_testdata[2993] */
    { 1497, 0x00000000U, 0x64D5DAD8U }, /* XSUM_XXH32_testdata[2994] */
    { 1497, 0x9E3779B1U, 0x77C85656U }, /* XSUM_XXH32_testdata[2995] */
    { 1498, 0x00000000U, 0x3DB5FA68U }, /* XSUM_XXH32_testdata[2996] */
    { 1498, 0x9E3779B1U, 0xD7507175U }, /* XSUM_XXH32_testdata[2997] */
    { 1499, 0x00000000U, 0x9418E95AU }, /* XSUM_XXH32_testdata[2998] */
    { 1499, 0x9E3779B1U, 0x918D3ADFU }, /* XSUM_XXH32_testdata[2999] */
    { 1500, 0x00000000U, 0x674259FFU }, /* XSUM_XXH32_testdata[3000] */
    { 1500, 0x9E3779B1U, 0xE0EFA6CCU }, /* XSUM_XXH32_testdata[3001] */
    { 1501, 0x00000000U, 0x4E07DE91U }, /* XSUM_XXH32_testdata[3002] */
    { 1501, 0x9E3779B1U, 0xBA624772U }, /* XSUM_XXH32_testdata[3003] */
    { 1502, 0x00000000U, 0x03110631U }, /* XSUM_XXH32_testdata[3004] */
    { 1502, 0x9E3779B1U, 0xA888214EU }, /* XSUM_XXH32_testdata[3005] */
    { 1503, 0x00000000U, 0x87144AA6U }, /* XSUM_XXH32_testdata[3006] */
    { 1503, 0x9E3779B1U, 0x84E14834U }, /* XSUM_XXH32_testdata[3007] */
    { 1504, 0x00000000U, 0x41785DE7U }, /* XSUM_XXH32_testdata[3008] */
    { 1504, 0x9E3779B1U, 0x33C2EC4EU }, /* XSUM_XXH32_testdata[3009] */
    { 1505, 0x00000000U, 0xCE8FEAFDU }, /* XSUM_XXH32_testdata[3010] */
    { 1505, 0x9E3779B1U, 0x4CBF6CA8U }, /* XSUM_XXH32_testdata[3011] */
    { 1506, 0x00000000U, 0xE26FDA0CU }, /* XSUM_XXH32_testdata[3012] */
    { 1506, 0x9E3779B1U, 0x14F27E32U }, /* XSUM_XXH32_testdata[3013] */
    { 1507, 0x00000000U, 0xE07C8111U }, /* XSUM_XXH32_testdata[3014] */
    { 1507, 0x9E3779B1U, 0xEDA376E0U }, /* XSUM_XXH32_testdata[3015] */
    { 1508, 0x00000000U, 0x6E8003DDU }, /* XSUM_XXH32_testdata[3016] */
    { 1508, 0x9E3779B1U, 0x82A82D30U }, /* XSUM_XXH32_testdata[3017] */
    { 1509, 0x00000000U, 0xD137BE39U }, /* XSUM_XXH32_testdata[3018] */
    { 1509, 0x9E3779B1U, 0x4F015C3EU }, /* XSUM_XXH32_testdata[3019] */
    { 1510, 0x00000000U, 0xFEDEB13BU }, /* XSUM_XXH32_testdata[3020] */
    { 1510, 0x9E3779B1U, 0x132FBE15U }, /* XSUM_XXH32_testdata[3021] */
    { 1511, 0x00000000U, 0x7325E15FU }, /* XSUM_XXH32_testdata[3022] */
    { 1511, 0x9E3779B1U, 0xEB95FE4EU }, /* XSUM_XXH32_testdata[3023] */
    { 1512, 0x00000000U, 0xC2A22C8CU }, /* XSUM_XXH32_testdata[3024] */
    { 1512, 0x9E3779B1U, 0x383E1AC9U }, /* XSUM_XXH32_testdata[3025] */
    { 1513, 0x00000000U, 0xFDD37C10U }, /* XSUM_XXH32_testdata[3026] */
    { 1513, 0x9E3779B1U, 0xFBDC4EA7U }, /* XSUM_XXH32_testdata[3027] */
    { 1514, 0x00000000U, 0x4CBC00D0U }, /* XSUM_XXH32_testdata[3028] */
    { 1514, 0x9E3779B1U, 0x98C3F136U }, /* XSUM_XXH32_testdata[3029] */
    { 1515, 0x00000000U, 0xDB7E0D03U }, /* XSUM_XXH32_testdata[3030] */
    { 1515, 0x9E3779B1U, 0xEBB98383U }, /* XSUM_XXH32_testdata[3031] */
    { 1516, 0x00000000U, 0x95410C0FU }, /* XSUM_XXH32_testdata[3032] */
    { 1516, 0x9E3779B1U, 0x40AFA4BDU }, /* XSUM_XXH32_testdata[3033] */
    { 1517, 0x00000000U, 0x7FA84979U }, /* XSUM_XXH32_testdata[3034] */
    { 1517, 0x9E3779B1U, 0x3357E626U }, /* XSUM_XXH32_testdata[3035] */
    { 1518, 0x00000000U, 0x0D1F40E5U }, /* XSUM_XXH32_testdata[3036] */
    { 1518, 0x9E3779B1U, 0x2D2C352FU }, /* XSUM_XXH32_testdata[3037] */
    { 1519, 0x00000000U, 0xB0A1BE9FU }, /* XSUM_XXH32_testdata[3038] */
    { 1519, 0x9E3779B1U, 0x0F550ACAU }, /* XSUM_XXH32_testdata[3039] */
    { 1520, 0x00000000U, 0x7474BFB8U }, /* XSUM_XXH32_testdata[3040] */
    { 1520, 0x9E3779B1U, 0x17693B78U }, /* XSUM_XXH32_testdata[3041] */
    { 1521, 0x00000000U, 0x626CDFA2U }, /* XSUM_XXH32_testdata[3042] */
    { 1521, 0x9E3779B1U, 0xCC95C9AFU }, /* XSUM_XXH32_testdata[3043] */
    { 1522, 0x00000000U, 0x19509450U }, /* XSUM_XXH32_testdata[3044] */
    { 1522, 0x9E3779B1U, 0xD2009357U }, /* XSUM_XXH32_testdata[3045] */
    { 1523, 0x00000000U, 0x769D6B1FU }, /* XSUM_XXH32_testdata[3046] */
    { 1523, 0x9E3779B1U, 0xADB558C6U }, /* XSUM_XXH32_testdata[3047] */
    { 1524, 0x00000000U, 0x4D443049U }, /* XSUM_XXH32_testdata[3048] */
    { 1524, 0x9E3779B1U, 0xB3A1687CU }, /* XSUM_XXH32_testdata[3049] */
    { 1525, 0x00000000U, 0xFB204799U }, /* XSUM_XXH32_testdata[3050] */
    { 1525, 0x9E3779B1U, 0xD2C092DEU }, /* XSUM_XXH32_testdata[3051] */
    { 1526, 0x00000000U, 0xBF3CA14CU }, /* XSUM_XXH32_testdata[3052] */
    { 1526, 0x9E3779B1U, 0x39D0056CU }, /* XSUM_XXH32_testdata[3053] */
    { 1527, 0x00000000U, 0xAE18783FU }, /* XSUM_XXH32_testdata[3054] */
    { 1527, 0x9E3779B1U, 0x8815EF45U }, /* XSUM_XXH32_testdata[3055] */
    { 1528, 0x00000000U, 0x0E703449U }, /* XSUM_XXH32_testdata[3056] */
    { 1528, 0x9E3779B1U, 0x328B093AU }, /* XSUM_XXH32_testdata[3057] */
    { 1529, 0x00000000U, 0x05471860U }, /* XSUM_XXH32_testdata[3058] */
    { 1529, 0x9E3779B1U, 0x17CE7233U }, /* XSUM_XXH32_testdata[3059] */
    { 1530, 0x00000000U, 0x6A0B50F5U }, /* XSUM_XXH32_testdata[3060] */
    { 1530, 0x9E3779B1U, 0x057CCE6DU }, /* XSUM_XXH32_testdata[3061] */
    { 1531, 0x00000000U, 0x7A6F6CFFU }, /* XSUM_XXH32_testdata[3062] */
    { 1531, 0x9E3779B1U, 0xE16B59A3U }, /* XSUM_XXH32_testdata[3063] */
    { 1532, 0x00000000U, 0x14E75DF7U }, /* XSUM_XXH32_testdata[3064] */
    { 1532, 0x9E3779B1U, 0x9E23C989U }, /* XSUM_XXH32_testdata[3065] */
    { 1533, 0x00000000U, 0xDDDFCE27U }, /* XSUM_XXH32_testdata[3066] */
    { 1533, 0x9E3779B1U, 0xF4B30D84U }, /* XSUM_XXH32_testdata[3067] */
    { 1534, 0x00000000U, 0x9E6E08B2U }, /* XSUM_XXH32_testdata[3068] */
    { 1534, 0x9E3779B1U, 0x41E04963U }, /* XSUM_XXH32_testdata[3069] */
    { 1535, 0x00000000U, 0xEF50F869U }, /* XSUM_XXH32_testdata[3070] */
    { 1535, 0x9E3779B1U, 0xFAFD83C0U }, /* XSUM_XXH32_testdata[3071] */
    { 1536, 0x00000000U, 0xCAEAC495U }, /* XSUM_XXH32_testdata[3072] */
    { 1536, 0x9E3779B1U, 0xA8CC0205U }, /* XSUM_XXH32_testdata[3073] */
    { 1537, 0x00000000U, 0xE3D25FD3U }, /* XSUM_XXH32_testdata[3074] */
    { 1537, 0x9E3779B1U, 0x5D16D2F5U }, /* XSUM_XXH32_testdata[3075] */
    { 1538, 0x00000000U, 0x487B3691U }, /* XSUM_XXH32_testdata[3076] */
    { 1538, 0x9E3779B1U, 0xF3978D4AU }, /* XSUM_XXH32_testdata[3077] */
    { 1539, 0x00000000U, 0x3898029BU }, /* XSUM_XXH32_testdata[3078] */
    { 1539, 0x9E3779B1U, 0x3FCC4B91U }, /* XSUM_XXH32_testdata[3079] */
    { 1540, 0x00000000U, 0xB7DDBCA0U }, /* XSUM_XXH32_testdata[3080] */
    { 1540, 0x9E3779B1U, 0x45E04D2CU }, /* XSUM_XXH32_testdata[3081] */
    { 1541, 0x00000000U, 0xC37F7E70U }, /* XSUM_XXH32_testdata[3082] */
    { 1541, 0x9E3779B1U, 0xFE16DD89U }, /* XSUM_XXH32_testdata[3083] */
    { 1542, 0x00000000U, 0x060AE3DEU }, /* XSUM_XXH32_testdata[3084] */
    { 1542, 0x9E3779B1U, 0x85B6EC0AU }, /* XSUM_XXH32_testdata[3085] */
    { 1543, 0x00000000U, 0xBB725132U }, /* XSUM_XXH32_testdata[3086] */
    { 1543, 0x9E3779B1U, 0x71782E92U }, /* XSUM_XXH32_testdata[3087] */
    { 1544, 0x00000000U, 0x7EE2D172U }, /* XSUM_XXH32_testdata[3088] */
    { 1544, 0x9E3779B1U, 0xFF5C12C6U }, /* XSUM_XXH32_testdata[3089] */
    { 1545, 0x00000000U, 0x5295D2E4U }, /* XSUM_XXH32_testdata[3090] */
    { 1545, 0x9E3779B1U, 0x052C95F6U }, /* XSUM_XXH32_testdata[3091] */
    { 1546, 0x00000000U, 0xE67BAB10U }, /* XSUM_XXH32_testdata[3092] */
    { 1546, 0x9E3779B1U, 0x15F52144U }, /* XSUM_XXH32_testdata[3093] */
    { 1547, 0x00000000U, 0x6503A0A3U }, /* XSUM_XXH32_testdata[3094] */
    { 1547, 0x9E3779B1U, 0xD4ACA0DEU }, /* XSUM_XXH32_testdata[3095] */
    { 1548, 0x00000000U, 0x3362BDCEU }, /* XSUM_XXH32_testdata[3096] */
    { 1548, 0x9E3779B1U, 0x517AF9BAU }, /* XSUM_XXH32_testdata[3097] */
    { 1549, 0x00000000U, 0x60F74AC9U }, /* XSUM_XXH32_testdata[3098] */
    { 1549, 0x9E3779B1U, 0x43271084U }, /* XSUM_XXH32_testdata[3099] */
    { 1550, 0x00000000U, 0x0476F312U }, /* XSUM_XXH32_testdata[3100] */
    { 1550, 0x9E3779B1U, 0xB42F9F68U }, /* XSUM_XXH32_testdata[3101] */
    { 1551, 0x00000000U, 0xCDBF47ADU }, /* XSUM_XXH32_testdata[3102] */
    { 1551, 0x9E3779B1U, 0xCAEA9D94U }, /* XSUM_XXH32_testdata[3103] */
    { 1552, 0x00000000U, 0xBCD69D2EU }, /* XSUM_XXH32_testdata[3104] */
    { 1552, 0x9E3779B1U, 0x7107F2FBU }, /* XSUM_XXH32_testdata[3105] */
    { 1553, 0x00000000U, 0x142B122FU }, /* XSUM_XXH32_testdata[3106] */
    { 1553, 0x9E3779B1U, 0x71FDE2CAU }, /* XSUM_XXH32_testdata[3107] */
    { 1554, 0x00000000U, 0x45AABBB8U }, /* XSUM_XXH32_testdata[3108] */
    { 1554, 0x9E3779B1U, 0x64AFA993U }, /* XSUM_XXH32_testdata[3109] */
    { 1555, 0x00000000U, 0xB539794DU }, /* XSUM_XXH32_testdata[3110] */
    { 1555, 0x9E3779B1U, 0x27D686FDU }, /* XSUM_XXH32_testdata[3111] */
    { 1556, 0x00000000U, 0x101D2A68U }, /* XSUM_XXH32_testdata[3112] */
    { 1556, 0x9E3779B1U, 0xD5A4C045U }, /* XSUM_XXH32_testdata[3113] */
    { 1557, 0x00000000U, 0x97A150AAU }, /* XSUM_XXH32_testdata[3114] */
    { 1557, 0x9E3779B1U, 0xA46B85DDU }, /* XSUM_XXH32_testdata[3115] */
    { 1558, 0x00000000U, 0xBDD558BAU }, /* XSUM_XXH32_testdata[3116] */
    { 1558, 0x9E3779B1U, 0xC886C618U }, /* XSUM_XXH32_testdata[3117] */
    { 1559, 0x00000000U, 0xD4F7AFE9U }, /* XSUM_XXH32_testdata[3118] */
    { 1559, 0x9E3779B1U, 0x318E5D9EU }, /* XSUM_XXH32_testdata[3119] */
    { 1560, 0x00000000U, 0x2F45D9FBU }, /* XSUM_XXH32_testdata[3120] */
    { 1560, 0x9E3779B1U, 0x331208FBU }, /* XSUM_XXH32_testdata[3121] */
    { 1561, 0x00000000U, 0x008C885AU }, /* XSUM_XXH32_testdata[3122] */
    { 1561, 0x9E3779B1U, 0xA70D4FFEU }, /* XSUM_XXH32_testdata[3123] */
    { 1562, 0x00000000U, 0xF71796C8U }, /* XSUM_XXH32_testdata[3124] */
    { 1562, 0x9E3779B1U, 0x252BDB47U }, /* XSUM_XXH32_testdata[3125] */
    { 1563, 0x00000000U, 0xC6774B56U }, /* XSUM_XXH32_testdata[3126] */
    { 1563, 0x9E3779B1U, 0xEB767076U }, /* XSUM_XXH32_testdata[3127] */
    { 1564, 0x00000000U, 0x4C0A4B6CU }, /* XSUM_XXH32_testdata[3128] */
    { 1564, 0x9E3779B1U, 0x57529A30U }, /* XSUM_XXH32_testdata[3129] */
    { 1565, 0x00000000U, 0x5A136E53U }, /* XSUM_XXH32_testdata[3130] */
    { 1565, 0x9E3779B1U, 0xE07A7093U }, /* XSUM_XXH32_testdata[3131] */
    { 1566, 0x00000000U, 0x3E12759FU }, /* XSUM_XXH32_testdata[3132] */
    { 1566, 0x9E3779B1U, 0xCE2C10E2U }, /* XSUM_XXH32_testdata[3133] */
    { 1567, 0x00000000U, 0x6C45240DU }, /* XSUM_XXH32_testdata[3134] */
    { 1567, 0x9E3779B1U, 0x80B2D8D4U }, /* XSUM_XXH32_testdata[3135] */
    { 1568, 0x00000000U, 0xC345288AU }, /* XSUM_XXH32_testdata[3136] */
    { 1568, 0x9E3779B1U, 0x61A52DC6U }, /* XSUM_XXH32_testdata[3137] */
    { 1569, 0x00000000U, 0x941F7F2AU }, /* XSUM_XXH32_testdata[3138] */
    { 1569, 0x9E3779B1U, 0xAEF866E2U }, /* XSUM_XXH32_testdata[3139] */
    { 1570, 0x00000000U, 0x5AC3E1E9U }, /* XSUM_XXH32_testdata[3140] */
    { 1570, 0x9E3779B1U, 0x82C08BD8U }, /* XSUM_XXH32_testdata[3141] */
    { 1571, 0x00000000U, 0xE83EE277U }, /* XSUM_XXH32_testdata[3142] */
    { 1571, 0x9E3779B1U, 0xEDEE8879U }, /* XSUM_XXH32_testdata[3143] */
    { 1572, 0x00000000U, 0xE74B6772U }, /* XSUM_XXH32_testdata[3144] */
    { 1572, 0x9E3779B1U, 0xF3A1613FU }, /* XSUM_XXH32_testdata[3145] */
    { 1573, 0x00000000U, 0xA76838E6U }, /* XSUM_XXH32_testdata[3146] */
    { 1573, 0x9E3779B1U, 0x6D41138BU }, /* XSUM_XXH32_testdata[3147] */
    { 1574, 0x00000000U, 0x0A8F13C0U }, /* XSUM_XXH32_testdata[3148] */
    { 1574, 0x9E3779B1U, 0x612E7A18U }, /* XSUM_XXH32_testdata[3149] */
    { 1575, 0x00000000U, 0xF5AF3C9FU }, /* XSUM_XXH32_testdata[3150] */
    { 1575, 0x9E3779B1U, 0x3B7FA341U }, /* XSUM_XXH32_testdata[3151] */
    { 1576, 0x00000000U, 0xD27B3DCEU }, /* XSUM_XXH32_testdata[3152] */
    { 1576, 0x9E3779B1U, 0x1F31D76DU }, /* XSUM_XXH32_testdata[3153] */
    { 1577, 0x00000000U, 0xB55D9484U }, /* XSUM_XXH32_testdata[3154] */
    { 1577, 0x9E3779B1U, 0x46B6C803U }, /* XSUM_XXH32_testdata[3155] */
    { 1578, 0x00000000U, 0x3752DBDDU }, /* XSUM_XXH32_testdata[3156] */
    { 1578, 0x9E3779B1U, 0x247E932FU }, /* XSUM_XXH32_testdata[3157] */
    { 1579, 0x00000000U, 0x912CDF3DU }, /* XSUM_XXH32_testdata[3158] */
    { 1579, 0x9E3779B1U, 0x9836AF33U }, /* XSUM_XXH32_testdata[3159] */
    { 1580, 0x00000000U, 0xA9DE063CU }, /* XSUM_XXH32_testdata[3160] */
    { 1580, 0x9E3779B1U, 0xF4EE7FA9U }, /* XSUM_XXH32_testdata[3161] */
    { 1581, 0x00000000U, 0x06749F4FU }, /* XSUM_XXH32_testdata[3162] */
    { 1581, 0x9E3779B1U, 0xFCC5252DU }, /* XSUM_XXH32_testdata[3163] */
    { 1582, 0x00000000U, 0x5DC1592BU }, /* XSUM_XXH32_testdata[3164] */
    { 1582, 0x9E3779B1U, 0xFF68F018U }, /* XSUM_XXH32_testdata[3165] */
    { 1583, 0x00000000U, 0x743D7A27U }, /* XSUM_XXH32_testdata[3166] */
    { 1583, 0x9E3779B1U, 0xAAEF044BU }, /* XSUM_XXH32_testdata[3167] */
    { 1584, 0x00000000U, 0xD5404470U }, /* XSUM_XXH32_testdata[3168] */
    { 1584, 0x9E3779B1U, 0xF132B470U }, /* XSUM_XXH32_testdata[3169] */
    { 1585, 0x00000000U, 0xDA7360D4U }, /* XSUM_XXH32_testdata[3170] */
    { 1585, 0x9E3779B1U, 0x1EC1B37EU }, /* XSUM_XXH32_testdata[3171] */
    { 1586, 0x00000000U, 0x445FB92CU }, /* XSUM_XXH32_testdata[3172] */
    { 1586, 0x9E3779B1U, 0x7481A47FU }, /* XSUM_XXH32_testdata[3173] */
    { 1587, 0x00000000U, 0x5BD2477EU }, /* XSUM_XXH32_testdata[3174] */
    { 1587, 0x9E3779B1U, 0xD4489185U }, /* XSUM_XXH32_testdata[3175] */
    { 1588, 0x00000000U, 0x7DD85E84U }, /* XSUM_XXH32_testdata[3176] */
    { 1588, 0x9E3779B1U, 0xEA64C606U }, /* XSUM_XXH32_testdata[3177] */
    { 1589, 0x00000000U, 0x903FC496U }, /* XSUM_XXH32_testdata[3178] */
    { 1589, 0x9E3779B1U, 0x825283F5U }, /* XSUM_XXH32_testdata[3179] */
    { 1590, 0x00000000U, 0x81277601U }, /* XSUM_XXH32_testdata[3180] */
    { 1590, 0x9E3779B1U, 0x27B1C618U }, /* XSUM_XXH32_testdata[3181] */
    { 1591, 0x00000000U, 0x07B54E36U }, /* XSUM_XXH32_testdata[3182] */
    { 1591, 0x9E3779B1U, 0x5DAB41E4U }, /* XSUM_XXH32_testdata[3183] */
    { 1592, 0x00000000U, 0x62DFFFF5U }, /* XSUM_XXH32_testdata[3184] */
    { 1592, 0x9E3779B1U, 0x3DCF3AA5U }, /* XSUM_XXH32_testdata[3185] */
    { 1593, 0x00000000U, 0xF3330310U }, /* XSUM_XXH32_testdata[3186] */
    { 1593, 0x9E3779B1U, 0x3FC691CBU }, /* XSUM_XXH32_testdata[3187] */
    { 1594, 0x00000000U, 0xDEEEDC03U }, /* XSUM_XXH32_testdata[3188] */
    { 1594, 0x9E3779B1U, 0xA95E5A7DU }, /* XSUM_XXH32_testdata[3189] */
    { 1595, 0x00000000U, 0x2EE08B7FU }, /* XSUM_XXH32_testdata[3190] */
    { 1595, 0x9E3779B1U, 0x88555D5BU }, /* XSUM_XXH32_testdata[3191] */
    { 1596, 0x00000000U, 0xC4578E00U }, /* XSUM_XXH32_testdata[3192] */
    { 1596, 0x9E3779B1U, 0xBB0305A3U }, /* XSUM_XXH32_testdata[3193] */
    { 1597, 0x00000000U, 0xDE6AE940U }, /* XSUM_XXH32_testdata[3194] */
    { 1597, 0x9E3779B1U, 0x2BA92E4EU }, /* XSUM_XXH32_testdata[3195] */
    { 1598, 0x00000000U, 0x792980E1U }, /* XSUM_XXH32_testdata[3196] */
    { 1598, 0x9E3779B1U, 0x0ED42502U }, /* XSUM_XXH32_testdata[3197] */
    { 1599, 0x00000000U, 0x24F0A805U }, /* XSUM_XXH32_testdata[3198] */
    { 1599, 0x9E3779B1U, 0x199FF9E1U }, /* XSUM_XXH32_testdata[3199] */
    { 1600, 0x00000000U, 0x69C3E0B8U }, /* XSUM_XXH32_testdata[3200] */
    { 1600, 0x9E3779B1U, 0xE6E788CAU }, /* XSUM_XXH32_testdata[3201] */
    { 1601, 0x00000000U, 0x22AC8B9AU }, /* XSUM_XXH32_testdata[3202] */
    { 1601, 0x9E3779B1U, 0x31651B71U }, /* XSUM_XXH32_testdata[3203] */
    { 1602, 0x00000000U, 0x98B5775BU }, /* XSUM_XXH32_testdata[3204] */
    { 1602, 0x9E3779B1U, 0xFFDBEAF5U }, /* XSUM_XXH32_testdata[3205] */
    { 1603, 0x00000000U, 0x53229D3EU }, /* XSUM_XXH32_testdata[3206] */
    { 1603, 0x9E3779B1U, 0xAEA4EA2BU }, /* XSUM_XXH32_testdata[3207] */
    { 1604, 0x00000000U, 0xC0BEAF77U }, /* XSUM_XXH32_testdata[3208] */
    { 1604, 0x9E3779B1U, 0x2E8891E7U }, /* XSUM_XXH32_testdata[3209] */
    { 1605, 0x00000000U, 0x62124272U }, /* XSUM_XXH32_testdata[3210] */
    { 1605, 0x9E3779B1U, 0x4FE4E574U }, /* XSUM_XXH32_testdata[3211] */
    { 1606, 0x00000000U, 0x70586C78U }, /* XSUM_XXH32_testdata[3212] */
    { 1606, 0x9E3779B1U, 0xF068C21FU }, /* XSUM_XXH32_testdata[3213] */
    { 1607, 0x00000000U, 0xEE89B69AU }, /* XSUM_XXH32_testdata[3214] */
    { 1607, 0x9E3779B1U, 0x723FAE30U }, /* XSUM_XXH32_testdata[3215] */
    { 1608, 0x00000000U, 0x9ADB5F45U }, /* XSUM_XXH32_testdata[3216] */
    { 1608, 0x9E3779B1U, 0xDDE5745AU }, /* XSUM_XXH32_testdata[3217] */
    { 1609, 0x00000000U, 0x8FA79B0DU }, /* XSUM_XXH32_testdata[3218] */
    { 1609, 0x9E3779B1U, 0x7C99609CU }, /* XSUM_XXH32_testdata[3219] */
    { 1610, 0x00000000U, 0x16B32173U }, /* XSUM_XXH32_testdata[3220] */
    { 1610, 0x9E3779B1U, 0x0497F374U }, /* XSUM_XXH32_testdata[3221] */
    { 1611, 0x00000000U, 0xCBA2143CU }, /* XSUM_XXH32_testdata[3222] */
    { 1611, 0x9E3779B1U, 0xDF9010FEU }, /* XSUM_XXH32_testdata[3223] */
    { 1612, 0x00000000U, 0xADE62487U }, /* XSUM_XXH32_testdata[3224] */
    { 1612, 0x9E3779B1U, 0xB44C25B3U }, /* XSUM_XXH32_testdata[3225] */
    { 1613, 0x00000000U, 0x452CEDE9U }, /* XSUM_XXH32_testdata[3226] */
    { 1613, 0x9E3779B1U, 0xF9AC73F0U }, /* XSUM_XXH32_testdata[3227] */
    { 1614, 0x00000000U, 0xCC64BBE5U }, /* XSUM_XXH32_testdata[3228] */
    { 1614, 0x9E3779B1U, 0x51E6057AU }, /* XSUM_XXH32_testdata[3229] */
    { 1615, 0x00000000U, 0x4320809CU }, /* XSUM_XXH32_testdata[3230] */
    { 1615, 0x9E3779B1U, 0x8388B4D2U }, /* XSUM_XXH32_testdata[3231] */
    { 1616, 0x00000000U, 0x93DF3953U }, /* XSUM_XXH32_testdata[3232] */
    { 1616, 0x9E3779B1U, 0x671A3AACU }, /* XSUM_XXH32_testdata[3233] */
    { 1617, 0x00000000U, 0x04202C23U }, /* XSUM_XXH32_testdata[3234] */
    { 1617, 0x9E3779B1U, 0x413FC0A0U }, /* XSUM_XXH32_testdata[3235] */
    { 1618, 0x00000000U, 0x361C6485U }, /* XSUM_XXH32_testdata[3236] */
    { 1618, 0x9E3779B1U, 0xF8111A49U }, /* XSUM_XXH32_testdata[3237] */
    { 1619, 0x00000000U, 0x8A111046U }, /* XSUM_XXH32_testdata[3238] */
    { 1619, 0x9E3779B1U, 0x48044B1DU }, /* XSUM_XXH32_testdata[3239] */
    { 1620, 0x00000000U, 0x13D4185AU }, /* XSUM_XXH32_testdata[3240] */
    { 1620, 0x9E3779B1U, 0xE93AD7B2U }, /* XSUM_XXH32_testdata[3241] */
    { 1621, 0x00000000U, 0x5153C5C2U }, /* XSUM_XXH32_testdata[3242] */
    { 1621, 0x9E3779B1U, 0xCB800472U }, /* XSUM_XXH32_testdata[3243] */
    { 1622, 0x00000000U, 0x269D3B69U }, /* XSUM_XXH32_testdata[3244] */
    { 1622, 0x9E3779B1U, 0xCDE65B27U }, /* XSUM_XXH32_testdata[3245] */
    { 1623, 0x00000000U, 0x66377C72U }, /* XSUM_XXH32_testdata[3246] */
    { 1623, 0x9E3779B1U, 0x810A240DU }, /* XSUM_XXH32_testdata[3247] */
    { 1624, 0x00000000U, 0x6C594B68U }, /* XSUM_XXH32_testdata[3248] */
    { 1624, 0x9E3779B1U, 0x0EB0699DU }, /* XSUM_XXH32_testdata[3249] */
    { 1625, 0x00000000U, 0x9A5DC06AU }, /* XSUM_XXH32_testdata[3250] */
    { 1625, 0x9E3779B1U, 0xDCC172F6U }, /* XSUM_XXH32_testdata[3251] */
    { 1626, 0x00000000U, 0x0C1B45B9U }, /* XSUM_XXH32_testdata[3252] */
    { 1626, 0x9E3779B1U, 0x34CC574DU }, /* XSUM_XXH32_testdata[3253] */
    { 1627, 0x00000000U, 0x310CBE13U }, /* XSUM_XXH32_testdata[3254] */
    { 1627, 0x9E3779B1U, 0xA9CB0D8AU }, /* XSUM_XXH32_testdata[3255] */
    { 1628, 0x00000000U, 0xEDFF967DU }, /* XSUM_XXH32_testdata[3256] */
    { 1628, 0x9E3779B1U, 0x8ED7DEA9U }, /* XSUM_XXH32_testdata[3257] */
    { 1629, 0x00000000U, 0x651BF2CCU }, /* XSUM_XXH32_testdata[3258] */
    { 1629, 0x9E3779B1U, 0x119A0D04U }, /* XSUM_XXH32_testdata[3259] */
    { 1630, 0x00000000U, 0x71D3637AU }, /* XSUM_XXH32_testdata[3260] */
    { 1630, 0x9E3779B1U, 0x50D31238U }, /* XSUM_XXH32_testdata[3261] */
    { 1631, 0x00000000U, 0x67842A4CU }, /* XSUM_XXH32_testdata[3262] */
    { 1631, 0x9E3779B1U, 0x78723313U }, /* XSUM_XXH32_testdata[3263] */
    { 1632, 0x00000000U, 0x317673D3U }, /* XSUM_XXH32_testdata[3264] */
    { 1632, 0x9E3779B1U, 0xBA999B66U }, /* XSUM_XXH32_testdata[3265] */
    { 1633, 0x00000000U, 0xF9327254U }, /* XSUM_XXH32_testdata[3266] */
    { 1633, 0x9E3779B1U, 0xA929E8BFU }, /* XSUM_XXH32_testdata[3267] */
    { 1634, 0x00000000U, 0x4A8CEBC0U }, /* XSUM_XXH32_testdata[3268] */
    { 1634, 0x9E3779B1U, 0xD7871C32U }, /* XSUM_XXH32_testdata[3269] */
    { 1635, 0x00000000U, 0x2C3EAE94U }, /* XSUM_XXH32_testdata[3270] */
    { 1635, 0x9E3779B1U, 0x9621F9C9U }, /* XSUM_XXH32_testdata[3271] */
    { 1636, 0x00000000U, 0x3A9F4086U }, /* XSUM_XXH32_testdata[3272] */
    { 1636, 0x9E3779B1U, 0x1FB22723U }, /* XSUM_XXH32_testdata[3273] */
    { 1637, 0x00000000U, 0x4E05810FU }, /* XSUM_XXH32_testdata[3274] */
    { 1637, 0x9E3779B1U, 0xA3FD1E61U }, /* XSUM_XXH32_testdata[3275] */
    { 1638, 0x00000000U, 0x20673048U }, /* XSUM_XXH32_testdata[3276] */
    { 1638, 0x9E3779B1U, 0xE63ECC6EU }, /* XSUM_XXH32_testdata[3277] */
    { 1639, 0x00000000U, 0x78D87CC7U }, /* XSUM_XXH32_testdata[3278] */
    { 1639, 0x9E3779B1U, 0x05F211C2U }, /* XSUM_XXH32_testdata[3279] */
    { 1640, 0x00000000U, 0xDD0E43C9U }, /* XSUM_XXH32_testdata[3280] */
    { 1640, 0x9E3779B1U, 0x80F9B51CU }, /* XSUM_XXH32_testdata[3281] */
    { 1641, 0x00000000U, 0xEFE929FEU }, /* XSUM_XXH32_testdata[3282] */
    { 1641, 0x9E3779B1U, 0x061AD4EDU }, /* XSUM_XXH32_testdata[3283] */
    { 1642, 0x00000000U, 0x8F7B4847U }, /* XSUM_XXH32_testdata[3284] */
    { 1642, 0x9E3779B1U, 0x569C592AU }, /* XSUM_XXH32_testdata[3285] */
    { 1643, 0x00000000U, 0xC3378BE1U }, /* XSUM_XXH32_testdata[3286] */
    { 1643, 0x9E3779B1U, 0x55CC7380U }, /* XSUM_XXH32_testdata[3287] */
    { 1644, 0x00000000U, 0x664C36C2U }, /* XSUM_XXH32_testdata[3288] */
    { 1644, 0x9E3779B1U, 0x81CC0C9DU }, /* XSUM_XXH32_testdata[3289] */
    { 1645, 0x00000000U, 0xF33D179FU }, /* XSUM_XXH32_testdata[3290] */
    { 1645, 0x9E3779B1U, 0xA233BFEAU }, /* XSUM_XXH32_testdata[3291] */
    { 1646, 0x00000000U, 0x6818BCFBU }, /* XSUM_XXH32_testdata[3292] */
    { 1646, 0x9E3779B1U, 0xAD02A241U }, /* XSUM_XXH32_testdata[3293] */
    { 1647, 0x00000000U, 0xDFEDABA5U }, /* XSUM_XXH32_testdata[3294] */
    { 1647, 0x9E3779B1U, 0xFEF25E03U }, /* XSUM_XXH32_testdata[3295] */
    { 1648, 0x00000000U, 0x5AB37E18U }, /* XSUM_XXH32_testdata[3296] */
    { 1648, 0x9E3779B1U, 0x4F27E3E9U }, /* XSUM_XXH32_testdata[3297] */
    { 1649, 0x00000000U, 0x64272622U }, /* XSUM_XXH32_testdata[3298] */
    { 1649, 0x9E3779B1U, 0x538E70B4U }, /* XSUM_XXH32_testdata[3299] */
    { 1650, 0x00000000U, 0xCCD30467U }, /* XSUM_XXH32_testdata[3300] */
    { 1650, 0x9E3779B1U, 0xD2E7EF12U }, /* XSUM_XXH32_testdata[3301] */
    { 1651, 0x00000000U, 0xBAF49CE7U }, /* XSUM_XXH32_testdata[3302] */
    { 1651, 0x9E3779B1U, 0x05D32855U }, /* XSUM_XXH32_testdata[3303] */
    { 1652, 0x00000000U, 0x7AA0EDE0U }, /* XSUM_XXH32_testdata[3304] */
    { 1652, 0x9E3779B1U, 0xC7605BC2U }, /* XSUM_XXH32_testdata[3305] */
    { 1653, 0x00000000U, 0x27455A35U }, /* XSUM_XXH32_testdata[3306] */
    { 1653, 0x9E3779B1U, 0xCB4D341DU }, /* XSUM_XXH32_testdata[3307] */
    { 1654, 0x00000000U, 0x59C4E522U }, /* XSUM_XXH32_testdata[3308] */
    { 1654, 0x9E3779B1U, 0x1F3255BEU }, /* XSUM_XXH32_testdata[3309] */
    { 1655, 0x00000000U, 0x9CFAFF1DU }, /* XSUM_XXH32_testdata[3310] */
    { 1655, 0x9E3779B1U, 0x4CB680F2U }, /* XSUM_XXH32_testdata[3311] */
    { 1656, 0x00000000U, 0x5B310E7FU }, /* XSUM_XXH32_testdata[3312] */
    { 1656, 0x9E3779B1U, 0x9B4C866FU }, /* XSUM_XXH32_testdata[3313] */
    { 1657, 0x00000000U, 0x17AC02D8U }, /* XSUM_XXH32_testdata[3314] */
    { 1657, 0x9E3779B1U, 0xB31D5FFFU }, /* XSUM_XXH32_testdata[3315] */
    { 1658, 0x00000000U, 0x5B6F4445U }, /* XSUM_XXH32_testdata[3316] */
    { 1658, 0x9E3779B1U, 0xD29EC0B9U }, /* XSUM_XXH32_testdata[3317] */
    { 1659, 0x00000000U, 0xCC11B11FU }, /* XSUM_XXH32_testdata[3318] */
    { 1659, 0x9E3779B1U, 0x4F398D58U }, /* XSUM_XXH32_testdata[3319] */
    { 1660, 0x00000000U, 0x33E681A4U }, /* XSUM_XXH32_testdata[3320] */
    { 1660, 0x9E3779B1U, 0x2C1373E0U }, /* XSUM_XXH32_testdata[3321] */
    { 1661, 0x00000000U, 0x60E1313DU }, /* XSUM_XXH32_testdata[3322] */
    { 1661, 0x9E3779B1U, 0x822F8D03U }, /* XSUM_XXH32_testdata[3323] */
    { 1662, 0x00000000U, 0x62A047B0U }, /* XSUM_XXH32_testdata[3324] */
    { 1662, 0x9E3779B1U, 0x46A24926U }, /* XSUM_XXH32_testdata[3325] */
    { 1663, 0x00000000U, 0x3012204EU }, /* XSUM_XXH32_testdata[3326] */
    { 1663, 0x9E3779B1U, 0x7169EF8BU }, /* XSUM_XXH32_testdata[3327] */
    { 1664, 0x00000000U, 0x408F3A81U }, /* XSUM_XXH32_testdata[3328] */
    { 1664, 0x9E3779B1U, 0x7C50BB58U }, /* XSUM_XXH32_testdata[3329] */
    { 1665, 0x00000000U, 0x6C39225AU }, /* XSUM_XXH32_testdata[3330] */
    { 1665, 0x9E3779B1U, 0xB669E5A9U }, /* XSUM_XXH32_testdata[3331] */
    { 1666, 0x00000000U, 0x599550BBU }, /* XSUM_XXH32_testdata[3332] */
    { 1666, 0x9E3779B1U, 0x65003175U }, /* XSUM_XXH32_testdata[3333] */
    { 1667, 0x00000000U, 0xD404013CU }, /* XSUM_XXH32_testdata[3334] */
    { 1667, 0x9E3779B1U, 0x60DFC657U }, /* XSUM_XXH32_testdata[3335] */
    { 1668, 0x00000000U, 0xCD4EBD76U }, /* XSUM_XXH32_testdata[3336] */
    { 1668, 0x9E3779B1U, 0x72EA10FEU }, /* XSUM_XXH32_testdata[3337] */
    { 1669, 0x00000000U, 0xA679D904U }, /* XSUM_XXH32_testdata[3338] */
    { 1669, 0x9E3779B1U, 0x37B164BAU }, /* XSUM_XXH32_testdata[3339] */
    { 1670, 0x00000000U, 0x4DB14B0FU }, /* XSUM_XXH32_testdata[3340] */
    { 1670, 0x9E3779B1U, 0xF5DC18A1U }, /* XSUM_XXH32_testdata[3341] */
    { 1671, 0x00000000U, 0xB096F444U }, /* XSUM_XXH32_testdata[3342] */
    { 1671, 0x9E3779B1U, 0xEFFB5BEFU }, /* XSUM_XXH32_testdata[3343] */
    { 1672, 0x00000000U, 0x81FCEF81U }, /* XSUM_XXH32_testdata[3344] */
    { 1672, 0x9E3779B1U, 0x8D2965EBU }, /* XSUM_XXH32_testdata[3345] */
    { 1673, 0x00000000U, 0x8265AD62U }, /* XSUM_XXH32_testdata[3346] */
    { 1673, 0x9E3779B1U, 0x49271FBEU }, /* XSUM_XXH32_testdata[3347] */
    { 1674, 0x00000000U, 0x8E7C7FF9U }, /* XSUM_XXH32_testdata[3348] */
    { 1674, 0x9E3779B1U, 0xADEB3401U }, /* XSUM_XXH32_testdata[3349] */
    { 1675, 0x00000000U, 0x9A5E2DA0U }, /* XSUM_XXH32_testdata[3350] */
    { 1675, 0x9E3779B1U, 0xEC9D7A32U }, /* XSUM_XXH32_testdata[3351] */
    { 1676, 0x00000000U, 0x68E9E370U }, /* XSUM_XXH32_testdata[3352] */
    { 1676, 0x9E3779B1U, 0xDB6F560BU }, /* XSUM_XXH32_testdata[3353] */
    { 1677, 0x00000000U, 0x8E02268DU }, /* XSUM_XXH32_testdata[3354] */
    { 1677, 0x9E3779B1U, 0x0B56E3D6U }, /* XSUM_XXH32_testdata[3355] */
    { 1678, 0x00000000U, 0x45CC6C57U }, /* XSUM_XXH32_testdata[3356] */
    { 1678, 0x9E3779B1U, 0xCC9779C0U }, /* XSUM_XXH32_testdata[3357] */
    { 1679, 0x00000000U, 0x2324FBA7U }, /* XSUM_XXH32_testdata[3358] */
    { 1679, 0x9E3779B1U, 0x244537E0U }, /* XSUM_XXH32_testdata[3359] */
    { 1680, 0x00000000U, 0xC62F556DU }, /* XSUM_XXH32_testdata[3360] */
    { 1680, 0x9E3779B1U, 0x9B94A640U }, /* XSUM_XXH32_testdata[3361] */
    { 1681, 0x00000000U, 0x681F98E5U }, /* XSUM_XXH32_testdata[3362] */
    { 1681, 0x9E3779B1U, 0x17D4BAEAU }, /* XSUM_XXH32_testdata[3363] */
    { 1682, 0x00000000U, 0x99E09BB2U }, /* XSUM_XXH32_testdata[3364] */
    { 1682, 0x9E3779B1U, 0xF72A51BAU }, /* XSUM_XXH32_testdata[3365] */
    { 1683, 0x00000000U, 0x042B1A8DU }, /* XSUM_XXH32_testdata[3366] */
    { 1683, 0x9E3779B1U, 0xD0CAD102U }, /* XSUM_XXH32_testdata[3367] */
    { 1684, 0x00000000U, 0x82EB1661U }, /* XSUM_XXH32_testdata[3368] */
    { 1684, 0x9E3779B1U, 0x82776D3AU }, /* XSUM_XXH32_testdata[3369] */
    { 1685, 0x00000000U, 0x3E97EED3U }, /* XSUM_XXH32_testdata[3370] */
    { 1685, 0x9E3779B1U, 0xE5135CF4U }, /* XSUM_XXH32_testdata[3371] */
    { 1686, 0x00000000U, 0x3D0D6E6DU }, /* XSUM_XXH32_testdata[3372] */
    { 1686, 0x9E3779B1U, 0x9809AEAFU }, /* XSUM_XXH32_testdata[3373] */
    { 1687, 0x00000000U, 0x615E6059U }, /* XSUM_XXH32_testdata[3374] */
    { 1687, 0x9E3779B1U, 0xCCFCDC15U }, /* XSUM_XXH32_testdata[3375] */
    { 1688, 0x00000000U, 0x3B63CFFAU }, /* XSUM_XXH32_testdata[3376] */
    { 1688, 0x9E3779B1U, 0xA2D1E698U }, /* XSUM_XXH32_testdata[3377] */
    { 1689, 0x00000000U, 0xCA855ACEU }, /* XSUM_XXH32_testdata[3378] */
    { 1689, 0x9E3779B1U, 0xE49B6DF2U }, /* XSUM_XXH32_testdata[3379] */
    { 1690, 0x00000000U, 0xDAD3ECACU }, /* XSUM_XXH32_testdata[3380] */
    { 1690, 0x9E3779B1U, 0xFE88C14AU }, /* XSUM_XXH32_testdata[3381] */
    { 1691, 0x00000000U, 0x52FA0946U }, /* XSUM_XXH32_testdata[3382] */
    { 1691, 0x9E3779B1U, 0x1A782519U }, /* XSUM_XXH32_testdata[3383] */
    { 1692, 0x00000000U, 0xFDB31695U }, /* XSUM_XXH32_testdata[3384] */
    { 1692, 0x9E3779B1U, 0xF7CBB51DU }, /* XSUM_XXH32_testdata[3385] */
    { 1693, 0x00000000U, 0xE9D5F2BAU }, /* XSUM_XXH32_testdata[3386] */
    { 1693, 0x9E3779B1U, 0x99A31C9BU }, /* XSUM_XXH32_testdata[3387] */
    { 1694, 0x00000000U, 0x5459DBAFU }, /* XSUM_XXH32_testdata[3388] */
    { 1694, 0x9E3779B1U, 0xDBBCD8B0U }, /* XSUM_XXH32_testdata[3389] */
    { 1695, 0x00000000U, 0xBA88B7F2U }, /* XSUM_XXH32_testdata[3390] */
    { 1695, 0x9E3779B1U, 0xB0FC5975U }, /* XSUM_XXH32_testdata[3391] */
    { 1696, 0x00000000U, 0x542E753BU }, /* XSUM_XXH32_testdata[3392] */
    { 1696, 0x9E3779B1U, 0x6F41F0EAU }, /* XSUM_XXH32_testdata[3393] */
    { 1697, 0x00000000U, 0xD747761AU }, /* XSUM_XXH32_testdata[3394] */
    { 1697, 0x9E3779B1U, 0x46E6312CU }, /* XSUM_XXH32_testdata[3395] */
    { 1698, 0x00000000U, 0x9548110BU }, /* XSUM_XXH32_testdata[3396] */
    { 1698, 0x9E3779B1U, 0xA42C1D06U }, /* XSUM_XXH32_testdata[3397] */
    { 1699, 0x00000000U, 0x2CF0AAE6U }, /* XSUM_XXH32_testdata[3398] */
    { 1699, 0x9E3779B1U, 0x10780840U }, /* XSUM_XXH32_testdata[3399] */
    { 1700, 0x00000000U, 0xA6AA95F5U }, /* XSUM_XXH32_testdata[3400] */
    { 1700, 0x9E3779B1U, 0xE9B158A6U }, /* XSUM_XXH32_testdata[3401] */
    { 1701, 0x00000000U, 0x5A9A645CU }, /* XSUM_XXH32_testdata[3402] */
    { 1701, 0x9E3779B1U, 0x3BAE2478U }, /* XSUM_XXH32_testdata[3403] */
    { 1702, 0x00000000U, 0x192C8773U }, /* XSUM_XXH32_testdata[3404] */
    { 1702, 0x9E3779B1U, 0xBD13D3E0U }, /* XSUM_XXH32_testdata[3405] */
    { 1703, 0x00000000U, 0xD5B93B41U }, /* XSUM_XXH32_testdata[3406] */
    { 1703, 0x9E3779B1U, 0xEB0829E6U }, /* XSUM_XXH32_testdata[3407] */
    { 1704, 0x00000000U, 0xF7C7918FU }, /* XSUM_XXH32_testdata[3408] */
    { 1704, 0x9E3779B1U, 0x680E768AU }, /* XSUM_XXH32_testdata[3409] */
    { 1705, 0x00000000U, 0x2372E6A7U }, /* XSUM_XXH32_testdata[3410] */
    { 1705, 0x9E3779B1U, 0x6F0D01F4U }, /* XSUM_XXH32_testdata[3411] */
    { 1706, 0x00000000U, 0x990AAEB1U }, /* XSUM_XXH32_testdata[3412] */
    { 1706, 0x9E3779B1U, 0xF97347BEU }, /* XSUM_XXH32_testdata[3413] */
    { 1707, 0x00000000U, 0xF3E40C65U }, /* XSUM_XXH32_testdata[3414] */
    { 1707, 0x9E3779B1U, 0x8D0EBE91U }, /* XSUM_XXH32_testdata[3415] */
    { 1708, 0x00000000U, 0xCC7C23B9U }, /* XSUM_XXH32_testdata[3416] */
    { 1708, 0x9E3779B1U, 0xBE9A8B09U }, /* XSUM_XXH32_testdata[3417] */
    { 1709, 0x00000000U, 0x9CA6781BU }, /* XSUM_XXH32_testdata[3418] */
    { 1709, 0x9E3779B1U, 0x1A91A40BU }, /* XSUM_XXH32_testdata[3419] */
    { 1710, 0x00000000U, 0xB05A9E99U }, /* XSUM_XXH32_testdata[3420] */
    { 1710, 0x9E3779B1U, 0x64C37B87U }, /* XSUM_XXH32_testdata[3421] */
    { 1711, 0x00000000U, 0x97D3C609U }, /* XSUM_XXH32_testdata[3422] */
    { 1711, 0x9E3779B1U, 0x333DD359U }, /* XSUM_XXH32_testdata[3423] */
    { 1712, 0x00000000U, 0x7DE5FD3CU }, /* XSUM_XXH32_testdata[3424] */
    { 1712, 0x9E3779B1U, 0x574A505AU }, /* XSUM_XXH32_testdata[3425] */
    { 1713, 0x00000000U, 0xBD7B8FF1U }, /* XSUM_XXH32_testdata[3426] */
    { 1713, 0x9E3779B1U, 0x99E5EC63U }, /* XSUM_XXH32_testdata[3427] */
    { 1714, 0x00000000U, 0x5041BAB5U }, /* XSUM_XXH32_testdata[3428] */
    { 1714, 0x9E3779B1U, 0x2300775CU }, /* XSUM_XXH32_testdata[3429] */
    { 1715, 0x00000000U, 0xDB53444BU }, /* XSUM_XXH32_testdata[3430] */
    { 1715, 0x9E3779B1U, 0x0BB5DBF6U }, /* XSUM_XXH32_testdata[3431] */
    { 1716, 0x00000000U, 0x01921E73U }, /* XSUM_XXH32_testdata[3432] */
    { 1716, 0x9E3779B1U, 0xF334E07BU }, /* XSUM_XXH32_testdata[3433] */
    { 1717, 0x00000000U, 0xC33C0305U }, /* XSUM_XXH32_testdata[3434] */
    { 1717, 0x9E3779B1U, 0xF43B5057U }, /* XSUM_XXH32_testdata[3435] */
    { 1718, 0x00000000U, 0xA4CD39C0U }, /* XSUM_XXH32_testdata[3436] */
    { 1718, 0x9E3779B1U, 0xC4493765U }, /* XSUM_XXH32_testdata[3437] */
    { 1719, 0x00000000U, 0x892D8D24U }, /* XSUM_XXH32_testdata[3438] */
    { 1719, 0x9E3779B1U, 0x7E599228U }, /* XSUM_XXH32_testdata[3439] */
    { 1720, 0x00000000U, 0xFC19B5D6U }, /* XSUM_XXH32_testdata[3440] */
    { 1720, 0x9E3779B1U, 0x8EBD8BA9U }, /* XSUM_XXH32_testdata[3441] */
    { 1721, 0x00000000U, 0x600EDC39U }, /* XSUM_XXH32_testdata[3442] */
    { 1721, 0x9E3779B1U, 0x6F2BAF03U }, /* XSUM_XXH32_testdata[3443] */
    { 1722, 0x00000000U, 0x8C008B7EU }, /* XSUM_XXH32_testdata[3444] */
    { 1722, 0x9E3779B1U, 0xD0009FE0U }, /* XSUM_XXH32_testdata[3445] */
    { 1723, 0x00000000U, 0xDB386119U }, /* XSUM_XXH32_testdata[3446] */
    { 1723, 0x9E3779B1U, 0xA4F84879U }, /* XSUM_XXH32_testdata[3447] */
    { 1724, 0x00000000U, 0xCC3A4EF6U }, /* XSUM_XXH32_testdata[3448] */
    { 1724, 0x9E3779B1U, 0x3DE35C10U }, /* XSUM_XXH32_testdata[3449] */
    { 1725, 0x00000000U, 0xEC3ADBB3U }, /* XSUM_XXH32_testdata[3450] */
    { 1725, 0x9E3779B1U, 0xE9E89B01U }, /* XSUM_XXH32_testdata[3451] */
    { 1726, 0x00000000U, 0xFB3D4CDDU }, /* XSUM_XXH32_testdata[3452] */
    { 1726, 0x9E3779B1U, 0x4D9E72E2U }, /* XSUM_XXH32_testdata[3453] */
    { 1727, 0x00000000U, 0x7EE25B8BU }, /* XSUM_XXH32_testdata[3454] */
    { 1727, 0x9E3779B1U, 0x04D4A624U }, /* XSUM_XXH32_testdata[3455] */
    { 1728, 0x00000000U, 0x24DAB79DU }, /* XSUM_XXH32_testdata[3456] */
    { 1728, 0x9E3779B1U, 0x1DF8B05DU }, /* XSUM_XXH32_testdata[3457] */
    { 1729, 0x00000000U, 0x0F742CEDU }, /* XSUM_XXH32_testdata[3458] */
    { 1729, 0x9E3779B1U, 0x3BCAA4B5U }, /* XSUM_XXH32_testdata[3459] */
    { 1730, 0x00000000U, 0xFF497C79U }, /* XSUM_XXH32_testdata[3460] */
    { 1730, 0x9E3779B1U, 0x3C7DEDCCU }, /* XSUM_XXH32_testdata[3461] */
    { 1731, 0x00000000U, 0x3765E5C4U }, /* XSUM_XXH32_testdata[3462] */
    { 1731, 0x9E3779B1U, 0x59492CF8U }, /* XSUM_XXH32_testdata[3463] */
    { 1732, 0x00000000U, 0x7635BA6EU }, /* XSUM_XXH32_testdata[3464] */
    { 1732, 0x9E3779B1U, 0x0BEBDC87U }, /* XSUM_XXH32_testdata[3465] */
    { 1733, 0x00000000U, 0x19307110U }, /* XSUM_XXH32_testdata[3466] */
    { 1733, 0x9E3779B1U, 0xC3516C3CU }, /* XSUM_XXH32_testdata[3467] */
    { 1734, 0x00000000U, 0xCCEAB411U }, /* XSUM_XXH32_testdata[3468] */
    { 1734, 0x9E3779B1U, 0x74845921U }, /* XSUM_XXH32_testdata[3469] */
    { 1735, 0x00000000U, 0x13D97A5DU }, /* XSUM_XXH32_testdata[3470] */
    { 1735, 0x9E3779B1U, 0x2AE04859U }, /* XSUM_XXH32_testdata[3471] */
    { 1736, 0x00000000U, 0x061C3AE4U }, /* XSUM_XXH32_testdata[3472] */
    { 1736, 0x9E3779B1U, 0x57B7A0BEU }, /* XSUM_XXH32_testdata[3473] */
    { 1737, 0x00000000U, 0x51D52105U }, /* XSUM_XXH32_testdata[3474] */
    { 1737, 0x9E3779B1U, 0x8F0844D0U }, /* XSUM_XXH32_testdata[3475] */
    { 1738, 0x00000000U, 0x98BDFE27U }, /* XSUM_XXH32_testdata[3476] */
    { 1738, 0x9E3779B1U, 0xA9E0EBDEU }, /* XSUM_XXH32_testdata[3477] */
    { 1739, 0x00000000U, 0x763FFEC3U }, /* XSUM_XXH32_testdata[3478] */
    { 1739, 0x9E3779B1U, 0x931260F2U }, /* XSUM_XXH32_testdata[3479] */
    { 1740, 0x00000000U, 0xD1B7D887U }, /* XSUM_XXH32_testdata[3480] */
    { 1740, 0x9E3779B1U, 0x7A9B1234U }, /* XSUM_XXH32_testdata[3481] */
    { 1741, 0x00000000U, 0xD9102280U }, /* XSUM_XXH32_testdata[3482] */
    { 1741, 0x9E3779B1U, 0xDF4A9EE5U }, /* XSUM_XXH32_testdata[3483] */
    { 1742, 0x00000000U, 0x2243E274U }, /* XSUM_XXH32_testdata[3484] */
    { 1742, 0x9E3779B1U, 0xD4C0E6CDU }, /* XSUM_XXH32_testdata[3485] */
    { 1743, 0x00000000U, 0xE7DD634CU }, /* XSUM_XXH32_testdata[3486] */
    { 1743, 0x9E3779B1U, 0x954E5D7CU }, /* XSUM_XXH32_testdata[3487] */
    { 1744, 0x00000000U, 0xBFC75BBAU }, /* XSUM_XXH32_testdata[3488] */
    { 1744, 0x9E3779B1U, 0x168A72BFU }, /* XSUM_XXH32_testdata[3489] */
    { 1745, 0x00000000U, 0x2ED3FFF3U }, /* XSUM_XXH32_testdata[3490] */
    { 1745, 0x9E3779B1U, 0x7A3B8B52U }, /* XSUM_XXH32_testdata[3491] */
    { 1746, 0x00000000U, 0x6E707159U }, /* XSUM_XXH32_testdata[3492] */
    { 1746, 0x9E3779B1U, 0x6094673DU }, /* XSUM_XXH32_testdata[3493] */
    { 1747, 0x00000000U, 0x277394B3U }, /* XSUM_XXH32_testdata[3494] */
    { 1747, 0x9E3779B1U, 0xE99C979CU }, /* XSUM_XXH32_testdata[3495] */
    { 1748, 0x00000000U, 0x53F423D8U }, /* XSUM_XXH32_testdata[3496] */
    { 1748, 0x9E3779B1U, 0xE7A545EFU }, /* XSUM_XXH32_testdata[3497] */
    { 1749, 0x00000000U, 0x630AE151U }, /* XSUM_XXH32_testdata[3498] */
    { 1749, 0x9E3779B1U, 0xFE4E5696U }, /* XSUM_XXH32_testdata[3499] */
    { 1750, 0x00000000U, 0xC5593C27U }, /* XSUM_XXH32_testdata[3500] */
    { 1750, 0x9E3779B1U, 0xB1CA7B86U }, /* XSUM_XXH32_testdata[3501] */
    { 1751, 0x00000000U, 0x5AE5BBB9U }, /* XSUM_XXH32_testdata[3502] */
    { 1751, 0x9E3779B1U, 0x56989C77U }, /* XSUM_XXH32_testdata[3503] */
    { 1752, 0x00000000U, 0x78521C51U }, /* XSUM_XXH32_testdata[3504] */
    { 1752, 0x9E3779B1U, 0x366E0D0CU }, /* XSUM_XXH32_testdata[3505] */
    { 1753, 0x00000000U, 0x6A4BF3BFU }, /* XSUM_XXH32_testdata[3506] */
    { 1753, 0x9E3779B1U, 0x9EDABA80U }, /* XSUM_XXH32_testdata[3507] */
    { 1754, 0x00000000U, 0xB9387E10U }, /* XSUM_XXH32_testdata[3508] */
    { 1754, 0x9E3779B1U, 0x00D382A8U }, /* XSUM_XXH32_testdata[3509] */
    { 1755, 0x00000000U, 0x4A2FD2B4U }, /* XSUM_XXH32_testdata[3510] */
    { 1755, 0x9E3779B1U, 0x9AA8406DU }, /* XSUM_XXH32_testdata[3511] */
    { 1756, 0x00000000U, 0x00C5BC25U }, /* XSUM_XXH32_testdata[3512] */
    { 1756, 0x9E3779B1U, 0xFD11C9F2U }, /* XSUM_XXH32_testdata[3513] */
    { 1757, 0x00000000U, 0xEC01B48EU }, /* XSUM_XXH32_testdata[3514] */
    { 1757, 0x9E3779B1U, 0xEB47E67EU }, /* XSUM_XXH32_testdata[3515] */
    { 1758, 0x00000000U, 0x378AF63AU }, /* XSUM_XXH32_testdata[3516] */
    { 1758, 0x9E3779B1U, 0x16E2DA1CU }, /* XSUM_XXH32_testdata[3517] */
    { 1759, 0x00000000U, 0x2864F6F9U }, /* XSUM_XXH32_testdata[3518] */
    { 1759, 0x9E3779B1U, 0x5F0FBAF9U }, /* XSUM_XXH32_testdata[3519] */
    { 1760, 0x00000000U, 0x55CB3E32U }, /* XSUM_XXH32_testdata[3520] */
    { 1760, 0x9E3779B1U, 0x1748E0A1U }, /* XSUM_XXH32_testdata[3521] */
    { 1761, 0x00000000U, 0x0929BB1EU }, /* XSUM_XXH32_testdata[3522] */
    { 1761, 0x9E3779B1U, 0x0FAFECC7U }, /* XSUM_XXH32_testdata[3523] */
    { 1762, 0x00000000U, 0xE6B5CF33U }, /* XSUM_XXH32_testdata[3524] */
    { 1762, 0x9E3779B1U, 0xF4F85670U }, /* XSUM_XXH32_testdata[3525] */
    { 1763, 0x00000000U, 0x9F1F7730U }, /* XSUM_XXH32_testdata[3526] */
    { 1763, 0x9E3779B1U, 0x01DFC99DU }, /* XSUM_XXH32_testdata[3527] */
    { 1764, 0x00000000U, 0x71DFC0ADU }, /* XSUM_XXH32_testdata[3528] */
    { 1764, 0x9E3779B1U, 0x3B84DE0BU }, /* XSUM_XXH32_testdata[3529] */
    { 1765, 0x00000000U, 0xD3A3110CU }, /* XSUM_XXH32_testdata[3530] */
    { 1765, 0x9E3779B1U, 0xC93FD24EU }, /* XSUM_XXH32_testdata[3531] */
    { 1766, 0x00000000U, 0xC3610593U }, /* XSUM_XXH32_testdata[3532] */
    { 1766, 0x9E3779B1U, 0x312499FAU }, /* XSUM_XXH32_testdata[3533] */
    { 1767, 0x00000000U, 0x68688EBFU }, /* XSUM_XXH32_testdata[3534] */
    { 1767, 0x9E3779B1U, 0x2D91AB3AU }, /* XSUM_XXH32_testdata[3535] */
    { 1768, 0x00000000U, 0xCACAD38CU }, /* XSUM_XXH32_testdata[3536] */
    { 1768, 0x9E3779B1U, 0x7E15B8CDU }, /* XSUM_XXH32_testdata[3537] */
    { 1769, 0x00000000U, 0x58BFB196U }, /* XSUM_XXH32_testdata[3538] */
    { 1769, 0x9E3779B1U, 0x175D758AU }, /* XSUM_XXH32_testdata[3539] */
    { 1770, 0x00000000U, 0x24F3AE05U }, /* XSUM_XXH32_testdata[3540] */
    { 1770, 0x9E3779B1U, 0x81AD7357U }, /* XSUM_XXH32_testdata[3541] */
    { 1771, 0x00000000U, 0xA70DA8D8U }, /* XSUM_XXH32_testdata[3542] */
    { 1771, 0x9E3779B1U, 0xD6AFAB19U }, /* XSUM_XXH32_testdata[3543] */
    { 1772, 0x00000000U, 0xFC2574B0U }, /* XSUM_XXH32_testdata[3544] */
    { 1772, 0x9E3779B1U, 0xE172024BU }, /* XSUM_XXH32_testdata[3545] */
    { 1773, 0x00000000U, 0xF6FDBC2FU }, /* XSUM_XXH32_testdata[3546] */
    { 1773, 0x9E3779B1U, 0xEA6581AEU }, /* XSUM_XXH32_testdata[3547] */
    { 1774, 0x00000000U, 0x35DB2870U }, /* XSUM_XXH32_testdata[3548] */
    { 1774, 0x9E3779B1U, 0x69F112FEU }, /* XSUM_XXH32_testdata[3549] */
    { 1775, 0x00000000U, 0xE6706FFAU }, /* XSUM_XXH32_testdata[3550] */
    { 1775, 0x9E3779B1U, 0x6966DF53U }, /* XSUM_XXH32_testdata[3551] */
    { 1776, 0x00000000U, 0xE877A90AU }, /* XSUM_XXH32_testdata[3552] */
    { 1776, 0x9E3779B1U, 0x29B895B6U }, /* XSUM_XXH32_testdata[3553] */
    { 1777, 0x00000000U, 0xBE2511A5U }, /* XSUM_XXH32_testdata[3554] */
    { 1777, 0x9E3779B1U, 0x39900621U }, /* XSUM_XXH32_testdata[3555] */
    { 1778, 0x00000000U, 0xA165C1D0U }, /* XSUM_XXH32_testdata[3556] */
    { 1778, 0x9E3779B1U, 0x74D4FB26U }, /* XSUM_XXH32_testdata[3557] */
    { 1779, 0x00000000U, 0xA0429FDBU }, /* XSUM_XXH32_testdata[3558] */
    { 1779, 0x9E3779B1U, 0x9C833D53U }, /* XSUM_XXH32_testdata[3559] */
    { 1780, 0x00000000U, 0xE2D89452U }, /* XSUM_XXH32_testdata[3560] */
    { 1780, 0x9E3779B1U, 0x9FC1796DU }, /* XSUM_XXH32_testdata[3561] */
    { 1781, 0x00000000U, 0x4DEB03BDU }, /* XSUM_XXH32_testdata[3562] */
    { 1781, 0x9E3779B1U, 0xC03B780EU }, /* XSUM_XXH32_testdata[3563] */
    { 1782, 0x00000000U, 0x7BA5D015U }, /* XSUM_XXH32_testdata[3564] */
    { 1782, 0x9E3779B1U, 0x82D3F686U }, /* XSUM_XXH32_testdata[3565] */
    { 1783, 0x00000000U, 0xBFC22D50U }, /* XSUM_XXH32_testdata[3566] */
    { 1783, 0x9E3779B1U, 0xBCB54CB7U }, /* XSUM_XXH32_testdata[3567] */
    { 1784, 0x00000000U, 0x13148452U }, /* XSUM_XXH32_testdata[3568] */
    { 1784, 0x9E3779B1U, 0x102E0045U }, /* XSUM_XXH32_testdata[3569] */
    { 1785, 0x00000000U, 0x78100DF0U }, /* XSUM_XXH32_testdata[3570] */
    { 1785, 0x9E3779B1U, 0x5048C9C9U }, /* XSUM_XXH32_testdata[3571] */
    { 1786, 0x00000000U, 0x17DB38E9U }, /* XSUM_XXH32_testdata[3572] */
    { 1786, 0x9E3779B1U, 0x31BF2171U }, /* XSUM_XXH32_testdata[3573] */
    { 1787, 0x00000000U, 0x6629FD8DU }, /* XSUM_XXH32_testdata[3574] */
    { 1787, 0x9E3779B1U, 0x3D471279U }, /* XSUM_XXH32_testdata[3575] */
    { 1788, 0x00000000U, 0xD2113A3BU }, /* XSUM_XXH32_testdata[3576] */
    { 1788, 0x9E3779B1U, 0x53FB034FU }, /* XSUM_XXH32_testdata[3577] */
    { 1789, 0x00000000U, 0xBB1272A4U }, /* XSUM_XXH32_testdata[3578] */
    { 1789, 0x9E3779B1U, 0xAC115D7EU }, /* XSUM_XXH32_testdata[3579] */
    { 1790, 0x00000000U, 0x8B226487U }, /* XSUM_XXH32_testdata[3580] */
    { 1790, 0x9E3779B1U, 0xCEA61776U }, /* XSUM_XXH32_testdata[3581] */
    { 1791, 0x00000000U, 0xD605D290U }, /* XSUM_XXH32_testdata[3582] */
    { 1791, 0x9E3779B1U, 0x1BBC5AFBU }, /* XSUM_XXH32_testdata[3583] */
    { 1792, 0x00000000U, 0xBE8D8D76U }, /* XSUM_XXH32_testdata[3584] */
    { 1792, 0x9E3779B1U, 0x66BA8C59U }, /* XSUM_XXH32_testdata[3585] */
    { 1793, 0x00000000U, 0x14857281U }, /* XSUM_XXH32_testdata[3586] */
    { 1793, 0x9E3779B1U, 0x7A0703D7U }, /* XSUM_XXH32_testdata[3587] */
    { 1794, 0x00000000U, 0x5658F513U }, /* XSUM_XXH32_testdata[3588] */
    { 1794, 0x9E3779B1U, 0x72DC0CFAU }, /* XSUM_XXH32_testdata[3589] */
    { 1795, 0x00000000U, 0x752BEC93U }, /* XSUM_XXH32_testdata[3590] */
    { 1795, 0x9E3779B1U, 0xC0081D69U }, /* XSUM_XXH32_testdata[3591] */
    { 1796, 0x00000000U, 0x6476840BU }, /* XSUM_XXH32_testdata[3592] */
    { 1796, 0x9E3779B1U, 0x7889C41CU }, /* XSUM_XXH32_testdata[3593] */
    { 1797, 0x00000000U, 0x0CFF8F75U }, /* XSUM_XXH32_testdata[3594] */
    { 1797, 0x9E3779B1U, 0x639154B1U }, /* XSUM_XXH32_testdata[3595] */
    { 1798, 0x00000000U, 0xA9C6831CU }, /* XSUM_XXH32_testdata[3596] */
    { 1798, 0x9E3779B1U, 0x71A27D1FU }, /* XSUM_XXH32_testdata[3597] */
    { 1799, 0x00000000U, 0x89CF677AU }, /* XSUM_XXH32_testdata[3598] */
    { 1799, 0x9E3779B1U, 0xBB85DD8EU }, /* XSUM_XXH32_testdata[3599] */
    { 1800, 0x00000000U, 0x1223F2C2U }, /* XSUM_XXH32_testdata[3600] */
    { 1800, 0x9E3779B1U, 0xC1880B38U }, /* XSUM_XXH32_testdata[3601] */
    { 1801, 0x00000000U, 0xB845B8E0U }, /* XSUM_XXH32_testdata[3602] */
    { 1801, 0x9E3779B1U, 0x7C590E01U }, /* XSUM_XXH32_testdata[3603] */
    { 1802, 0x00000000U, 0x2A43CFD1U }, /* XSUM_XXH32_testdata[3604] */
    { 1802, 0x9E3779B1U, 0x015D6FB5U }, /* XSUM_XXH32_testdata[3605] */
    { 1803, 0x00000000U, 0x93B783D2U }, /* XSUM_XXH32_testdata[3606] */
    { 1803, 0x9E3779B1U, 0xE0DBE536U }, /* XSUM_XXH32_testdata[3607] */
    { 1804, 0x00000000U, 0xFEC27017U }, /* XSUM_XXH32_testdata[3608] */
    { 1804, 0x9E3779B1U, 0xA4EA1580U }, /* XSUM_XXH32_testdata[3609] */
    { 1805, 0x00000000U, 0x8CC3CE1AU }, /* XSUM_XXH32_testdata[3610] */
    { 1805, 0x9E3779B1U, 0xBE3AC11DU }, /* XSUM_XXH32_testdata[3611] */
    { 1806, 0x00000000U, 0x51C1FF40U }, /* XSUM_XXH32_testdata[3612] */
    { 1806, 0x9E3779B1U, 0xD340B9A1U }, /* XSUM_XXH32_testdata[3613] */
    { 1807, 0x00000000U, 0x757E3F6BU }, /* XSUM_XXH32_testdata[3614] */
    { 1807, 0x9E3779B1U, 0x2AB07ACDU }, /* XSUM_XXH32_testdata[3615] */
    { 1808, 0x00000000U, 0x23F89184U }, /* XSUM_XXH32_testdata[3616] */
    { 1808, 0x9E3779B1U, 0x87971AC1U }, /* XSUM_XXH32_testdata[3617] */
    { 1809, 0x00000000U, 0xFC2994F1U }, /* XSUM_XXH32_testdata[3618] */
    { 1809, 0x9E3779B1U, 0x9E2FA412U }, /* XSUM_XXH32_testdata[3619] */
    { 1810, 0x00000000U, 0x21881031U }, /* XSUM_XXH32_testdata[3620] */
    { 1810, 0x9E3779B1U, 0xECDB5201U }, /* XSUM_XXH32_testdata[3621] */
    { 1811, 0x00000000U, 0x45CA23E5U }, /* XSUM_XXH32_testdata[3622] */
    { 1811, 0x9E3779B1U, 0xB6344F2AU }, /* XSUM_XXH32_testdata[3623] */
    { 1812, 0x00000000U, 0x786BABFCU }, /* XSUM_XXH32_testdata[3624] */
    { 1812, 0x9E3779B1U, 0x8AC7B376U }, /* XSUM_XXH32_testdata[3625] */
    { 1813, 0x00000000U, 0x7FC15759U }, /* XSUM_XXH32_testdata[3626] */
    { 1813, 0x9E3779B1U, 0x772AB3D6U }, /* XSUM_XXH32_testdata[3627] */
    { 1814, 0x00000000U, 0xAE95D00AU }, /* XSUM_XXH32_testdata[3628] */
    { 1814, 0x9E3779B1U, 0x1A3AADA7U }, /* XSUM_XXH32_testdata[3629] */
    { 1815, 0x00000000U, 0x691FE11BU }, /* XSUM_XXH32_testdata[3630] */
    { 1815, 0x9E3779B1U, 0x454A104CU }, /* XSUM_XXH32_testdata[3631] */
    { 1816, 0x00000000U, 0x879BE524U }, /* XSUM_XXH32_testdata[3632] */
    { 1816, 0x9E3779B1U, 0xD4F14B55U }, /* XSUM_XXH32_testdata[3633] */
    { 1817, 0x00000000U, 0x324367F6U }, /* XSUM_XXH32_testdata[3634] */
    { 1817, 0x9E3779B1U, 0xCD7C3424U }, /* XSUM_XXH32_testdata[3635] */
    { 1818, 0x00000000U, 0x806AC2C6U }, /* XSUM_XXH32_testdata[3636] */
    { 1818, 0x9E3779B1U, 0xB1D59D27U }, /* XSUM_XXH32_testdata[3637] */
    { 1819, 0x00000000U, 0x1304BC0FU }, /* XSUM_XXH32_testdata[3638] */
    { 1819, 0x9E3779B1U, 0xA8435FC1U }, /* XSUM_XXH32_testdata[3639] */
    { 1820, 0x00000000U, 0x9D554B46U }, /* XSUM_XXH32_testdata[3640] */
    { 1820, 0x9E3779B1U, 0x5E964343U }, /* XSUM_XXH32_testdata[3641] */
    { 1821, 0x00000000U, 0xB36C2C88U }, /* XSUM_XXH32_testdata[3642] */
    { 1821, 0x9E3779B1U, 0x48EF1982U }, /* XSUM_XXH32_testdata[3643] */
    { 1822, 0x00000000U, 0xDEBA7341U }, /* XSUM_XXH32_testdata[3644] */
    { 1822, 0x9E3779B1U, 0xAD09EC67U }, /* XSUM_XXH32_testdata[3645] */
    { 1823, 0x00000000U, 0x175EA52BU }, /* XSUM_XXH32_testdata[3646] */
    { 1823, 0x9E3779B1U, 0xA8574931U }, /* XSUM_XXH32_testdata[3647] */
    { 1824, 0x00000000U, 0x2F5DCC8CU }, /* XSUM_XXH32_testdata[3648] */
    { 1824, 0x9E3779B1U, 0xF2D4B7C2U }, /* XSUM_XXH32_testdata[3649] */
    { 1825, 0x00000000U, 0xCB4DEF13U }, /* XSUM_XXH32_testdata[3650] */
    { 1825, 0x9E3779B1U, 0xF8D9DA7CU }, /* XSUM_XXH32_testdata[3651] */
    { 1826, 0x00000000U, 0x4E1A72E1U }, /* XSUM_XXH32_testdata[3652] */
    { 1826, 0x9E3779B1U, 0x41811E2CU }, /* XSUM_XXH32_testdata[3653] */
    { 1827, 0x00000000U, 0xA58FC1D7U }, /* XSUM_XXH32_testdata[3654] */
    { 1827, 0x9E3779B1U, 0x3F880806U }, /* XSUM_XXH32_testdata[3655] */
    { 1828, 0x00000000U, 0x0275E715U }, /* XSUM_XXH32_testdata[3656] */
    { 1828, 0x9E3779B1U, 0x530CDE35U }, /* XSUM_XXH32_testdata[3657] */
    { 1829, 0x00000000U, 0xCAF2B117U }, /* XSUM_XXH32_testdata[3658] */
    { 1829, 0x9E3779B1U, 0x65EDEA16U }, /* XSUM_XXH32_testdata[3659] */
    { 1830, 0x00000000U, 0xE20DACBBU }, /* XSUM_XXH32_testdata[3660] */
    { 1830, 0x9E3779B1U, 0x35440710U }, /* XSUM_XXH32_testdata[3661] */
    { 1831, 0x00000000U, 0xD4D95AA5U }, /* XSUM_XXH32_testdata[3662] */
    { 1831, 0x9E3779B1U, 0x1E810AD6U }, /* XSUM_XXH32_testdata[3663] */
    { 1832, 0x00000000U, 0xA20D541FU }, /* XSUM_XXH32_testdata[3664] */
    { 1832, 0x9E3779B1U, 0x7E0C0B5EU }, /* XSUM_XXH32_testdata[3665] */
    { 1833, 0x00000000U, 0xC119D0B6U }, /* XSUM_XXH32_testdata[3666] */
    { 1833, 0x9E3779B1U, 0x1FFB7EBAU }, /* XSUM_XXH32_testdata[3667] */
    { 1834, 0x00000000U, 0x8D17CD37U }, /* XSUM_XXH32_testdata[3668] */
    { 1834, 0x9E3779B1U, 0xC4C176EBU }, /* XSUM_XXH32_testdata[3669] */
    { 1835, 0x00000000U, 0x675B3F12U }, /* XSUM_XXH32_testdata[3670] */
    { 1835, 0x9E3779B1U, 0x6A1EAE37U }, /* XSUM_XXH32_testdata[3671] */
    { 1836, 0x00000000U, 0x1B214A29U }, /* XSUM_XXH32_testdata[3672] */
    { 1836, 0x9E3779B1U, 0xB1C040B4U }, /* XSUM_XXH32_testdata[3673] */
    { 1837, 0x00000000U, 0xA1ECBA48U }, /* XSUM_XXH32_testdata[3674] */
    { 1837, 0x9E3779B1U, 0x5746365EU }, /* XSUM_XXH32_testdata[3675] */
    { 1838, 0x00000000U, 0x5112DAB6U }, /* XSUM_XXH32_testdata[3676] */
    { 1838, 0x9E3779B1U, 0x1BE9DB5EU }, /* XSUM_XXH32_testdata[3677] */
    { 1839, 0x00000000U, 0x777392A2U }, /* XSUM_XXH32_testdata[3678] */
    { 1839, 0x9E3779B1U, 0xBA81062EU }, /* XSUM_XXH32_testdata[3679] */
    { 1840, 0x00000000U, 0x51F8185EU }, /* XSUM_XXH32_testdata[3680] */
    { 1840, 0x9E3779B1U, 0x72FFCF3EU }, /* XSUM_XXH32_testdata[3681] */
    { 1841, 0x00000000U, 0x99BA6C88U }, /* XSUM_XXH32_testdata[3682] */
    { 1841, 0x9E3779B1U, 0x9C58C6ABU }, /* XSUM_XXH32_testdata[3683] */
    { 1842, 0x00000000U, 0xA6A21A54U }, /* XSUM_XXH32_testdata[3684] */
    { 1842, 0x9E3779B1U, 0x44C74437U }, /* XSUM_XXH32_testdata[3685] */
    { 1843, 0x00000000U, 0x252CA0DEU }, /* XSUM_XXH32_testdata[3686] */
    { 1843, 0x9E3779B1U, 0x3FB62BB2U }, /* XSUM_XXH32_testdata[3687] */
    { 1844, 0x00000000U, 0x06DE7EABU }, /* XSUM_XXH32_testdata[3688] */
    { 1844, 0x9E3779B1U, 0x50E2A47AU }, /* XSUM_XXH32_testdata[3689] */
    { 1845, 0x00000000U, 0xA65D3237U }, /* XSUM_XXH32_testdata[3690] */
    { 1845, 0x9E3779B1U, 0x0A2D01FAU }, /* XSUM_XXH32_testdata[3691] */
    { 1846, 0x00000000U, 0x04F43A59U }, /* XSUM_XXH32_testdata[3692] */
    { 1846, 0x9E3779B1U, 0x51111F7EU }, /* XSUM_XXH32_testdata[3693] */
    { 1847, 0x00000000U, 0x6F4019A8U }, /* XSUM_XXH32_testdata[3694] */
    { 1847, 0x9E3779B1U, 0xE20F3576U }, /* XSUM_XXH32_testdata[3695] */
    { 1848, 0x00000000U, 0xD866CDA1U }, /* XSUM_XXH32_testdata[3696] */
    { 1848, 0x9E3779B1U, 0x1AC08626U }, /* XSUM_XXH32_testdata[3697] */
    { 1849, 0x00000000U, 0x0A51B4EAU }, /* XSUM_XXH32_testdata[3698] */
    { 1849, 0x9E3779B1U, 0xAC6041B3U }, /* XSUM_XXH32_testdata[3699] */
    { 1850, 0x00000000U, 0x0AC59D71U }, /* XSUM_XXH32_testdata[3700] */
    { 1850, 0x9E3779B1U, 0x88F8915EU }, /* XSUM_XXH32_testdata[3701] */
    { 1851, 0x00000000U, 0x5F92FA39U }, /* XSUM_XXH32_testdata[3702] */
    { 1851, 0x9E3779B1U, 0xF25E4F80U }, /* XSUM_XXH32_testdata[3703] */
    { 1852, 0x00000000U, 0x2D213040U }, /* XSUM_XXH32_testdata[3704] */
    { 1852, 0x9E3779B1U, 0x54C7D298U }, /* XSUM_XXH32_testdata[3705] */
    { 1853, 0x00000000U, 0x1B95E174U }, /* XSUM_XXH32_testdata[3706] */
    { 1853, 0x9E3779B1U, 0xAE824BB0U }, /* XSUM_XXH32_testdata[3707] */
    { 1854, 0x00000000U, 0xA15D6FF6U }, /* XSUM_XXH32_testdata[3708] */
    { 1854, 0x9E3779B1U, 0x0681ACF4U }, /* XSUM_XXH32_testdata[3709] */
    { 1855, 0x00000000U, 0xEBD376F2U }, /* XSUM_XXH32_testdata[3710] */
    { 1855, 0x9E3779B1U, 0x6D348553U }, /* XSUM_XXH32_testdata[3711] */
    { 1856, 0x00000000U, 0x578A3039U }, /* XSUM_XXH32_testdata[3712] */
    { 1856, 0x9E3779B1U, 0xBE3F47FEU }, /* XSUM_XXH32_testdata[3713] */
    { 1857, 0x00000000U, 0xA3F62009U }, /* XSUM_XXH32_testdata[3714] */
    { 1857, 0x9E3779B1U, 0xA618308CU }, /* XSUM_XXH32_testdata[3715] */
    { 1858, 0x00000000U, 0x5D53EC58U }, /* XSUM_XXH32_testdata[3716] */
    { 1858, 0x9E3779B1U, 0x9EFF05C1U }, /* XSUM_XXH32_testdata[3717] */
    { 1859, 0x00000000U, 0xC0BA7D48U }, /* XSUM_XXH32_testdata[3718] */
    { 1859, 0x9E3779B1U, 0x83FBDC4CU }, /* XSUM_XXH32_testdata[3719] */
    { 1860, 0x00000000U, 0x90EAE29DU }, /* XSUM_XXH32_testdata[3720] */
    { 1860, 0x9E3779B1U, 0xDD27AD43U }, /* XSUM_XXH32_testdata[3721] */
    { 1861, 0x00000000U, 0xAA9C88CCU }, /* XSUM_XXH32_testdata[3722] */
    { 1861, 0x9E3779B1U, 0x11555FE1U }, /* XSUM_XXH32_testdata[3723] */
    { 1862, 0x00000000U, 0x04799A10U }, /* XSUM_XXH32_testdata[3724] */
    { 1862, 0x9E3779B1U, 0xA9ACC8FBU }, /* XSUM_XXH32_testdata[3725] */
    { 1863, 0x00000000U, 0xED292432U }, /* XSUM_XXH32_testdata[3726] */
    { 1863, 0x9E3779B1U, 0x8E3C1F47U }, /* XSUM_XXH32_testdata[3727] */
    { 1864, 0x00000000U, 0x43C09E40U }, /* XSUM_XXH32_testdata[3728] */
    { 1864, 0x9E3779B1U, 0xBFB300C8U }, /* XSUM_XXH32_testdata[3729] */
    { 1865, 0x00000000U, 0x7BE1BF3EU }, /* XSUM_XXH32_testdata[3730] */
    { 1865, 0x9E3779B1U, 0x58621FC8U }, /* XSUM_XXH32_testdata[3731] */
    { 1866, 0x00000000U, 0x99F615E2U }, /* XSUM_XXH32_testdata[3732] */
    { 1866, 0x9E3779B1U, 0x4638A085U }, /* XSUM_XXH32_testdata[3733] */
    { 1867, 0x00000000U, 0x602FF217U }, /* XSUM_XXH32_testdata[3734] */
    { 1867, 0x9E3779B1U, 0xCB54058AU }, /* XSUM_XXH32_testdata[3735] */
    { 1868, 0x00000000U, 0xBB4A90B4U }, /* XSUM_XXH32_testdata[3736] */
    { 1868, 0x9E3779B1U, 0x812A8213U }, /* XSUM_XXH32_testdata[3737] */
    { 1869, 0x00000000U, 0xDBAB5AE4U }, /* XSUM_XXH32_testdata[3738] */
    { 1869, 0x9E3779B1U, 0x9FB2B073U }, /* XSUM_XXH32_testdata[3739] */
    { 1870, 0x00000000U, 0xE9C0B924U }, /* XSUM_XXH32_testdata[3740] */
    { 1870, 0x9E3779B1U, 0xCF33FD14U }, /* XSUM_XXH32_testdata[3741] */
    { 1871, 0x00000000U, 0x4C150BD1U }, /* XSUM_XXH32_testdata[3742] */
    { 1871, 0x9E3779B1U, 0x6FC102DEU }, /* XSUM_XXH32_testdata[3743] */
    { 1872, 0x00000000U, 0x128952FFU }, /* XSUM_XXH32_testdata[3744] */
    { 1872, 0x9E3779B1U, 0xF056CC68U }, /* XSUM_XXH32_testdata[3745] */
    { 1873, 0x00000000U, 0x2F630230U }, /* XSUM_XXH32_testdata[3746] */
    { 1873, 0x9E3779B1U, 0x6200B0A0U }, /* XSUM_XXH32_testdata[3747] */
    { 1874, 0x00000000U, 0x95113D65U }, /* XSUM_XXH32_testdata[3748] */
    { 1874, 0x9E3779B1U, 0xA2266DC8U }, /* XSUM_XXH32_testdata[3749] */
    { 1875, 0x00000000U, 0xEB5EC5FAU }, /* XSUM_XXH32_testdata[3750] */
    { 1875, 0x9E3779B1U, 0x258ED07AU }, /* XSUM_XXH32_testdata[3751] */
    { 1876, 0x00000000U, 0xBC41D480U }, /* XSUM_XXH32_testdata[3752] */
    { 1876, 0x9E3779B1U, 0xF6ECF7E5U }, /* XSUM_XXH32_testdata[3753] */
    { 1877, 0x00000000U, 0x53A61D66U }, /* XSUM_XXH32_testdata[3754] */
    { 1877, 0x9E3779B1U, 0x7161D2FEU }, /* XSUM_XXH32_testdata[3755] */
    { 1878, 0x00000000U, 0x6E525359U }, /* XSUM_XXH32_testdata[3756] */
    { 1878, 0x9E3779B1U, 0x55E29EB2U }, /* XSUM_XXH32_testdata[3757] */
    { 1879, 0x00000000U, 0x4B6C6614U }, /* XSUM_XXH32_testdata[3758] */
    { 1879, 0x9E3779B1U, 0xD6467881U }, /* XSUM_XXH32_testdata[3759] */
    { 1880, 0x00000000U, 0xB04444F7U }, /* XSUM_XXH32_testdata[3760] */
    { 1880, 0x9E3779B1U, 0x268DC86DU }, /* XSUM_XXH32_testdata[3761] */
    { 1881, 0x00000000U, 0xD6941295U }, /* XSUM_XXH32_testdata[3762] */
    { 1881, 0x9E3779B1U, 0xD7407476U }, /* XSUM_XXH32_testdata[3763] */
    { 1882, 0x00000000U, 0x1B195D84U }, /* XSUM_XXH32_testdata[3764] */
    { 1882, 0x9E3779B1U, 0x677236D7U }, /* XSUM_XXH32_testdata[3765] */
    { 1883, 0x00000000U, 0xBB4F8831U }, /* XSUM_XXH32_testdata[3766] */
    { 1883, 0x9E3779B1U, 0x7355DFAEU }, /* XSUM_XXH32_testdata[3767] */
    { 1884, 0x00000000U, 0xBE445C3DU }, /* XSUM_XXH32_testdata[3768] */
    { 1884, 0x9E3779B1U, 0xC7418A25U }, /* XSUM_XXH32_testdata[3769] */
    { 1885, 0x00000000U, 0x0F1B2DC8U }, /* XSUM_XXH32_testdata[3770] */
    { 1885, 0x9E3779B1U, 0x58763266U }, /* XSUM_XXH32_testdata[3771] */
    { 1886, 0x00000000U, 0x151A031CU }, /* XSUM_XXH32_testdata[3772] */
    { 1886, 0x9E3779B1U, 0xE5227743U }, /* XSUM_XXH32_testdata[3773] */
    { 1887, 0x00000000U, 0x8A90D1CDU }, /* XSUM_XXH32_testdata[3774] */
    { 1887, 0x9E3779B1U, 0xCAD9223CU }, /* XSUM_XXH32_testdata[3775] */
    { 1888, 0x00000000U, 0x8EAAA692U }, /* XSUM_XXH32_testdata[3776] */
    { 1888, 0x9E3779B1U, 0x71B65B2EU }, /* XSUM_XXH32_testdata[3777] */
    { 1889, 0x00000000U, 0x3CAEBA43U }, /* XSUM_XXH32_testdata[3778] */
    { 1889, 0x9E3779B1U, 0x548D96ABU }, /* XSUM_XXH32_testdata[3779] */
    { 1890, 0x00000000U, 0x02A753A0U }, /* XSUM_XXH32_testdata[3780] */
    { 1890, 0x9E3779B1U, 0xF2819E92U }, /* XSUM_XXH32_testdata[3781] */
    { 1891, 0x00000000U, 0x79338331U }, /* XSUM_XXH32_testdata[3782] */
    { 1891, 0x9E3779B1U, 0x501DC079U }, /* XSUM_XXH32_testdata[3783] */
    { 1892, 0x00000000U, 0x8B0F6D10U }, /* XSUM_XXH32_testdata[3784] */
    { 1892, 0x9E3779B1U, 0x9084EBAEU }, /* XSUM_XXH32_testdata[3785] */
    { 1893, 0x00000000U, 0xD2717BE6U }, /* XSUM_XXH32_testdata[3786] */
    { 1893, 0x9E3779B1U, 0x2707C7AAU }, /* XSUM_XXH32_testdata[3787] */
    { 1894, 0x00000000U, 0x0DF2C2A8U }, /* XSUM_XXH32_testdata[3788] */
    { 1894, 0x9E3779B1U, 0xC9DC005EU }, /* XSUM_XXH32_testdata[3789] */
    { 1895, 0x00000000U, 0x0226E73AU }, /* XSUM_XXH32_testdata[3790] */
    { 1895, 0x9E3779B1U, 0x8710F413U }, /* XSUM_XXH32_testdata[3791] */
    { 1896, 0x00000000U, 0x2A3AEE59U }, /* XSUM_XXH32_testdata[3792] */
    { 1896, 0x9E3779B1U, 0x851FB087U }, /* XSUM_XXH32_testdata[3793] */
    { 1897, 0x00000000U, 0x9E7C31B8U }, /* XSUM_XXH32_testdata[3794] */
    { 1897, 0x9E3779B1U, 0x65F68117U }, /* XSUM_XXH32_testdata[3795] */
    { 1898, 0x00000000U, 0x0049DB67U }, /* XSUM_XXH32_testdata[3796] */
    { 1898, 0x9E3779B1U, 0x0095735EU }, /* XSUM_XXH32_testdata[3797] */
    { 1899, 0x00000000U, 0x2A359B32U }, /* XSUM_XXH32_testdata[3798] */
    { 1899, 0x9E3779B1U, 0x6B86292AU }, /* XSUM_XXH32_testdata[3799] */
    { 1900, 0x00000000U, 0x5035F959U }, /* XSUM_XXH32_testdata[3800] */
    { 1900, 0x9E3779B1U, 0x38350BD6U }, /* XSUM_XXH32_testdata[3801] */
    { 1901, 0x00000000U, 0xF1F7F830U }, /* XSUM_XXH32_testdata[3802] */
    { 1901, 0x9E3779B1U, 0x8CE3F218U }, /* XSUM_XXH32_testdata[3803] */
    { 1902, 0x00000000U, 0x2DD3318CU }, /* XSUM_XXH32_testdata[3804] */
    { 1902, 0x9E3779B1U, 0x765A45E8U }, /* XSUM_XXH32_testdata[3805] */
    { 1903, 0x00000000U, 0xD75689F9U }, /* XSUM_XXH32_testdata[3806] */
    { 1903, 0x9E3779B1U, 0x4787E4F4U }, /* XSUM_XXH32_testdata[3807] */
    { 1904, 0x00000000U, 0xF860CFF0U }, /* XSUM_XXH32_testdata[3808] */
    { 1904, 0x9E3779B1U, 0xF51D4BFEU }, /* XSUM_XXH32_testdata[3809] */
    { 1905, 0x00000000U, 0xFF9A6461U }, /* XSUM_XXH32_testdata[3810] */
    { 1905, 0x9E3779B1U, 0x4408E97AU }, /* XSUM_XXH32_testdata[3811] */
    { 1906, 0x00000000U, 0xF6F3050EU }, /* XSUM_XXH32_testdata[3812] */
    { 1906, 0x9E3779B1U, 0xC621019AU }, /* XSUM_XXH32_testdata[3813] */
    { 1907, 0x00000000U, 0x8BFA355EU }, /* XSUM_XXH32_testdata[3814] */
    { 1907, 0x9E3779B1U, 0x9F55973DU }, /* XSUM_XXH32_testdata[3815] */
    { 1908, 0x00000000U, 0xAFFA76B1U }, /* XSUM_XXH32_testdata[3816] */
    { 1908, 0x9E3779B1U, 0x0DABD32CU }, /* XSUM_XXH32_testdata[3817] */
    { 1909, 0x00000000U, 0x10F56148U }, /* XSUM_XXH32_testdata[3818] */
    { 1909, 0x9E3779B1U, 0xA90D4AD4U }, /* XSUM_XXH32_testdata[3819] */
    { 1910, 0x00000000U, 0x02851F1BU }, /* XSUM_XXH32_testdata[3820] */
    { 1910, 0x9E3779B1U, 0xB316A5DDU }, /* XSUM_XXH32_testdata[3821] */
    { 1911, 0x00000000U, 0x53824F89U }, /* XSUM_XXH32_testdata[3822] */
    { 1911, 0x9E3779B1U, 0x4078E403U }, /* XSUM_XXH32_testdata[3823] */
    { 1912, 0x00000000U, 0x00B86DC6U }, /* XSUM_XXH32_testdata[3824] */
    { 1912, 0x9E3779B1U, 0x4542E1B4U }, /* XSUM_XXH32_testdata[3825] */
    { 1913, 0x00000000U, 0x207B79BCU }, /* XSUM_XXH32_testdata[3826] */
    { 1913, 0x9E3779B1U, 0x832092D8U }, /* XSUM_XXH32_testdata[3827] */
    { 1914, 0x00000000U, 0x623E4AB0U }, /* XSUM_XXH32_testdata[3828] */
    { 1914, 0x9E3779B1U, 0xC6ACF116U }, /* XSUM_XXH32_testdata[3829] */
    { 1915, 0x00000000U, 0x8576A5AFU }, /* XSUM_XXH32_testdata[3830] */
    { 1915, 0x9E3779B1U, 0xBC2AEF5BU }, /* XSUM_XXH32_testdata[3831] */
    { 1916, 0x00000000U, 0x4C3376B5U }, /* XSUM_XXH32_testdata[3832] */
    { 1916, 0x9E3779B1U, 0x183EAF12U }, /* XSUM_XXH32_testdata[3833] */
    { 1917, 0x00000000U, 0x14A58F16U }, /* XSUM_XXH32_testdata[3834] */
    { 1917, 0x9E3779B1U, 0x8B011085U }, /* XSUM_XXH32_testdata[3835] */
    { 1918, 0x00000000U, 0xB9291E03U }, /* XSUM_XXH32_testdata[3836] */
    { 1918, 0x9E3779B1U, 0x7B9DE8A7U }, /* XSUM_XXH32_testdata[3837] */
    { 1919, 0x00000000U, 0xD38621DCU }, /* XSUM_XXH32_testdata[3838] */
    { 1919, 0x9E3779B1U, 0x8BF327B8U }, /* XSUM_XXH32_testdata[3839] */
    { 1920, 0x00000000U, 0x49AB85BDU }, /* XSUM_XXH32_testdata[3840] */
    { 1920, 0x9E3779B1U, 0xF9B3B5ACU }, /* XSUM_XXH32_testdata[3841] */
    { 1921, 0x00000000U, 0x5BA98FC5U }, /* XSUM_XXH32_testdata[3842] */
    { 1921, 0x9E3779B1U, 0x26AD3EAAU }, /* XSUM_XXH32_testdata[3843] */
    { 1922, 0x00000000U, 0x27483D1DU }, /* XSUM_XXH32_testdata[3844] */
    { 1922, 0x9E3779B1U, 0xBBC84864U }, /* XSUM_XXH32_testdata[3845] */
    { 1923, 0x00000000U, 0xF96BB397U }, /* XSUM_XXH32_testdata[3846] */
    { 1923, 0x9E3779B1U, 0x5140D7C4U }, /* XSUM_XXH32_testdata[3847] */
    { 1924, 0x00000000U, 0xE2D12306U }, /* XSUM_XXH32_testdata[3848] */
    { 1924, 0x9E3779B1U, 0x0B58D501U }, /* XSUM_XXH32_testdata[3849] */
    { 1925, 0x00000000U, 0x89667BBCU }, /* XSUM_XXH32_testdata[3850] */
    { 1925, 0x9E3779B1U, 0xCE96E91BU }, /* XSUM_XXH32_testdata[3851] */
    { 1926, 0x00000000U, 0x5744E350U }, /* XSUM_XXH32_testdata[3852] */
    { 1926, 0x9E3779B1U, 0x06ADC8A8U }, /* XSUM_XXH32_testdata[3853] */
    { 1927, 0x00000000U, 0x39ED429DU }, /* XSUM_XXH32_testdata[3854] */
    { 1927, 0x9E3779B1U, 0x981292C6U }, /* XSUM_XXH32_testdata[3855] */
    { 1928, 0x00000000U, 0x707AF21FU }, /* XSUM_XXH32_testdata[3856] */
    { 1928, 0x9E3779B1U, 0x4732C9F9U }, /* XSUM_XXH32_testdata[3857] */
    { 1929, 0x00000000U, 0xD88D5DA0U }, /* XSUM_XXH32_testdata[3858] */
    { 1929, 0x9E3779B1U, 0x472D33A8U }, /* XSUM_XXH32_testdata[3859] */
    { 1930, 0x00000000U, 0xFA892672U }, /* XSUM_XXH32_testdata[3860] */
    { 1930, 0x9E3779B1U, 0xADDEA018U }, /* XSUM_XXH32_testdata[3861] */
    { 1931, 0x00000000U, 0x633B2910U }, /* XSUM_XXH32_testdata[3862] */
    { 1931, 0x9E3779B1U, 0xC4E35504U }, /* XSUM_XXH32_testdata[3863] */
    { 1932, 0x00000000U, 0x50BBBD88U }, /* XSUM_XXH32_testdata[3864] */
    { 1932, 0x9E3779B1U, 0xA16C8C2CU }, /* XSUM_XXH32_testdata[3865] */
    { 1933, 0x00000000U, 0xD203BEF6U }, /* XSUM_XXH32_testdata[3866] */
    { 1933, 0x9E3779B1U, 0x889F74E9U }, /* XSUM_XXH32_testdata[3867] */
    { 1934, 0x00000000U, 0x1C50E58BU }, /* XSUM_XXH32_testdata[3868] */
    { 1934, 0x9E3779B1U, 0x783C3F67U }, /* XSUM_XXH32_testdata[3869] */
    { 1935, 0x00000000U, 0xBFA4C0CBU }, /* XSUM_XXH32_testdata[3870] */
    { 1935, 0x9E3779B1U, 0x1A0B89C2U }, /* XSUM_XXH32_testdata[3871] */
    { 1936, 0x00000000U, 0xBD617A8AU }, /* XSUM_XXH32_testdata[3872] */
    { 1936, 0x9E3779B1U, 0x87E01870U }, /* XSUM_XXH32_testdata[3873] */
    { 1937, 0x00000000U, 0x87EA5DC3U }, /* XSUM_XXH32_testdata[3874] */
    { 1937, 0x9E3779B1U, 0x4867250EU }, /* XSUM_XXH32_testdata[3875] */
    { 1938, 0x00000000U, 0xD5875D68U }, /* XSUM_XXH32_testdata[3876] */
    { 1938, 0x9E3779B1U, 0x8BBE9DFCU }, /* XSUM_XXH32_testdata[3877] */
    { 1939, 0x00000000U, 0x7F7F4B00U }, /* XSUM_XXH32_testdata[3878] */
    { 1939, 0x9E3779B1U, 0x4E6C73F8U }, /* XSUM_XXH32_testdata[3879] */
    { 1940, 0x00000000U, 0xAF99DF0CU }, /* XSUM_XXH32_testdata[3880] */
    { 1940, 0x9E3779B1U, 0xA56AAD63U }, /* XSUM_XXH32_testdata[3881] */
    { 1941, 0x00000000U, 0xF3152C3DU }, /* XSUM_XXH32_testdata[3882] */
    { 1941, 0x9E3779B1U, 0xD7916DC8U }, /* XSUM_XXH32_testdata[3883] */
    { 1942, 0x00000000U, 0xFD04A455U }, /* XSUM_XXH32_testdata[3884] */
    { 1942, 0x9E3779B1U, 0xF136DE7FU }, /* XSUM_XXH32_testdata[3885] */
    { 1943, 0x00000000U, 0xA93B1B18U }, /* XSUM_XXH32_testdata[3886] */
    { 1943, 0x9E3779B1U, 0xC872BB06U }, /* XSUM_XXH32_testdata[3887] */
    { 1944, 0x00000000U, 0x962FB20FU }, /* XSUM_XXH32_testdata[3888] */
    { 1944, 0x9E3779B1U, 0xB2EEF395U }, /* XSUM_XXH32_testdata[3889] */
    { 1945, 0x00000000U, 0xF987B8ECU }, /* XSUM_XXH32_testdata[3890] */
    { 1945, 0x9E3779B1U, 0x35E6AC22U }, /* XSUM_XXH32_testdata[3891] */
    { 1946, 0x00000000U, 0xA30BFF7BU }, /* XSUM_XXH32_testdata[3892] */
    { 1946, 0x9E3779B1U, 0x5FF3CF8EU }, /* XSUM_XXH32_testdata[3893] */
    { 1947, 0x00000000U, 0xAF72D6DCU }, /* XSUM_XXH32_testdata[3894] */
    { 1947, 0x9E3779B1U, 0x67E062DAU }, /* XSUM_XXH32_testdata[3895] */
    { 1948, 0x00000000U, 0x9C2C4E68U }, /* XSUM_XXH32_testdata[3896] */
    { 1948, 0x9E3779B1U, 0x0BEC12E0U }, /* XSUM_XXH32_testdata[3897] */
    { 1949, 0x00000000U, 0xD511ED41U }, /* XSUM_XXH32_testdata[3898] */
    { 1949, 0x9E3779B1U, 0xC59C84E8U }, /* XSUM_XXH32_testdata[3899] */
    { 1950, 0x00000000U, 0x2226F2DFU }, /* XSUM_XXH32_testdata[3900] */
    { 1950, 0x9E3779B1U, 0x5BF021A6U }, /* XSUM_XXH32_testdata[3901] */
    { 1951, 0x00000000U, 0x14357E71U }, /* XSUM_XXH32_testdata[3902] */
    { 1951, 0x9E3779B1U, 0xEC388F23U }, /* XSUM_XXH32_testdata[3903] */
    { 1952, 0x00000000U, 0xE8CDBE8FU }, /* XSUM_XXH32_testdata[3904] */
    { 1952, 0x9E3779B1U, 0x9DF13FFAU }, /* XSUM_XXH32_testdata[3905] */
    { 1953, 0x00000000U, 0x3DD52872U }, /* XSUM_XXH32_testdata[3906] */
    { 1953, 0x9E3779B1U, 0x48A62A8DU }, /* XSUM_XXH32_testdata[3907] */
    { 1954, 0x00000000U, 0x5172EAD4U }, /* XSUM_XXH32_testdata[3908] */
    { 1954, 0x9E3779B1U, 0xCC04ABF1U }, /* XSUM_XXH32_testdata[3909] */
    { 1955, 0x00000000U, 0x065D2470U }, /* XSUM_XXH32_testdata[3910] */
    { 1955, 0x9E3779B1U, 0xAE85008FU }, /* XSUM_XXH32_testdata[3911] */
    { 1956, 0x00000000U, 0x4A2CE749U }, /* XSUM_XXH32_testdata[3912] */
    { 1956, 0x9E3779B1U, 0x3A9E2B0AU }, /* XSUM_XXH32_testdata[3913] */
    { 1957, 0x00000000U, 0xC6194778U }, /* XSUM_XXH32_testdata[3914] */
    { 1957, 0x9E3779B1U, 0x18BD3E49U }, /* XSUM_XXH32_testdata[3915] */
    { 1958, 0x00000000U, 0xF325B7A3U }, /* XSUM_XXH32_testdata[3916] */
    { 1958, 0x9E3779B1U, 0xDD8614E3U }, /* XSUM_XXH32_testdata[3917] */
    { 1959, 0x00000000U, 0x0F194FC1U }, /* XSUM_XXH32_testdata[3918] */
    { 1959, 0x9E3779B1U, 0x9627C2D2U }, /* XSUM_XXH32_testdata[3919] */
    { 1960, 0x00000000U, 0x5BC110A1U }, /* XSUM_XXH32_testdata[3920] */
    { 1960, 0x9E3779B1U, 0x3304A55DU }, /* XSUM_XXH32_testdata[3921] */
    { 1961, 0x00000000U, 0x177639DFU }, /* XSUM_XXH32_testdata[3922] */
    { 1961, 0x9E3779B1U, 0x39EDE8A5U }, /* XSUM_XXH32_testdata[3923] */
    { 1962, 0x00000000U, 0xC27D185FU }, /* XSUM_XXH32_testdata[3924] */
    { 1962, 0x9E3779B1U, 0x394DD9B5U }, /* XSUM_XXH32_testdata[3925] */
    { 1963, 0x00000000U, 0x16AA8A49U }, /* XSUM_XXH32_testdata[3926] */
    { 1963, 0x9E3779B1U, 0x1762A04EU }, /* XSUM_XXH32_testdata[3927] */
    { 1964, 0x00000000U, 0x83C97FEBU }, /* XSUM_XXH32_testdata[3928] */
    { 1964, 0x9E3779B1U, 0xC84B8AFFU }, /* XSUM_XXH32_testdata[3929] */
    { 1965, 0x00000000U, 0x6A0C7F6FU }, /* XSUM_XXH32_testdata[3930] */
    { 1965, 0x9E3779B1U, 0x9887FA64U }, /* XSUM_XXH32_testdata[3931] */
    { 1966, 0x00000000U, 0x1CB29578U }, /* XSUM_XXH32_testdata[3932] */
    { 1966, 0x9E3779B1U, 0x314BCCE7U }, /* XSUM_XXH32_testdata[3933] */
    { 1967, 0x00000000U, 0xA894A59EU }, /* XSUM_XXH32_testdata[3934] */
    { 1967, 0x9E3779B1U, 0x69BF2268U }, /* XSUM_XXH32_testdata[3935] */
    { 1968, 0x00000000U, 0xC101BB45U }, /* XSUM_XXH32_testdata[3936] */
    { 1968, 0x9E3779B1U, 0x857C3BDAU }, /* XSUM_XXH32_testdata[3937] */
    { 1969, 0x00000000U, 0xED88C3A2U }, /* XSUM_XXH32_testdata[3938] */
    { 1969, 0x9E3779B1U, 0x61A6BE5AU }, /* XSUM_XXH32_testdata[3939] */
    { 1970, 0x00000000U, 0xF5331032U }, /* XSUM_XXH32_testdata[3940] */
    { 1970, 0x9E3779B1U, 0xAFEE656DU }, /* XSUM_XXH32_testdata[3941] */
    { 1971, 0x00000000U, 0xB20670B0U }, /* XSUM_XXH32_testdata[3942] */
    { 1971, 0x9E3779B1U, 0x4DCEA155U }, /* XSUM_XXH32_testdata[3943] */
    { 1972, 0x00000000U, 0xF86E69E0U }, /* XSUM_XXH32_testdata[3944] */
    { 1972, 0x9E3779B1U, 0xF140AED0U }, /* XSUM_XXH32_testdata[3945] */
    { 1973, 0x00000000U, 0x3540BC0FU }, /* XSUM_XXH32_testdata[3946] */
    { 1973, 0x9E3779B1U, 0x0EADCC04U }, /* XSUM_XXH32_testdata[3947] */
    { 1974, 0x00000000U, 0x2E735174U }, /* XSUM_XXH32_testdata[3948] */
    { 1974, 0x9E3779B1U, 0x2A939E78U }, /* XSUM_XXH32_testdata[3949] */
    { 1975, 0x00000000U, 0xA9F52C85U }, /* XSUM_XXH32_testdata[3950] */
    { 1975, 0x9E3779B1U, 0xAD17FC4FU }, /* XSUM_XXH32_testdata[3951] */
    { 1976, 0x00000000U, 0xF9FA268AU }, /* XSUM_XXH32_testdata[3952] */
    { 1976, 0x9E3779B1U, 0x971874D5U }, /* XSUM_XXH32_testdata[3953] */
    { 1977, 0x00000000U, 0xF4428F75U }, /* XSUM_XXH32_testdata[3954] */
    { 1977, 0x9E3779B1U, 0x57FBDA89U }, /* XSUM_XXH32_testdata[3955] */
    { 1978, 0x00000000U, 0x1AAC8291U }, /* XSUM_XXH32_testdata[3956] */
    { 1978, 0x9E3779B1U, 0x9E007DFDU }, /* XSUM_XXH32_testdata[3957] */
    { 1979, 0x00000000U, 0xC352B7ABU }, /* XSUM_XXH32_testdata[3958] */
    { 1979, 0x9E3779B1U, 0x4E785FFFU }, /* XSUM_XXH32_testdata[3959] */
    { 1980, 0x00000000U, 0xBAC98FF1U }, /* XSUM_XXH32_testdata[3960] */
    { 1980, 0x9E3779B1U, 0x76595F3EU }, /* XSUM_XXH32_testdata[3961] */
    { 1981, 0x00000000U, 0xA45E63FFU }, /* XSUM_XXH32_testdata[3962] */
    { 1981, 0x9E3779B1U, 0xAD3D3BD3U }, /* XSUM_XXH32_testdata[3963] */
    { 1982, 0x00000000U, 0x39DB4A7FU }, /* XSUM_XXH32_testdata[3964] */
    { 1982, 0x9E3779B1U, 0xA3E7F0FBU }, /* XSUM_XXH32_testdata[3965] */
    { 1983, 0x00000000U, 0xB66503D4U }, /* XSUM_XXH32_testdata[3966] */
    { 1983, 0x9E3779B1U, 0x1E8E1994U }, /* XSUM_XXH32_testdata[3967] */
    { 1984, 0x00000000U, 0xCF5DE874U }, /* XSUM_XXH32_testdata[3968] */
    { 1984, 0x9E3779B1U, 0x2C1B6B3CU }, /* XSUM_XXH32_testdata[3969] */
    { 1985, 0x00000000U, 0xE10E48A7U }, /* XSUM_XXH32_testdata[3970] */
    { 1985, 0x9E3779B1U, 0x07559361U }, /* XSUM_XXH32_testdata[3971] */
    { 1986, 0x00000000U, 0x066E22A7U }, /* XSUM_XXH32_testdata[3972] */
    { 1986, 0x9E3779B1U, 0x7AC5E452U }, /* XSUM_XXH32_testdata[3973] */
    { 1987, 0x00000000U, 0x188BA693U }, /* XSUM_XXH32_testdata[3974] */
    { 1987, 0x9E3779B1U, 0x8A682BCDU }, /* XSUM_XXH32_testdata[3975] */
    { 1988, 0x00000000U, 0xD0ED0A0CU }, /* XSUM_XXH32_testdata[3976] */
    { 1988, 0x9E3779B1U, 0x4FB3B028U }, /* XSUM_XXH32_testdata[3977] */
    { 1989, 0x00000000U, 0x474E34F9U }, /* XSUM_XXH32_testdata[3978] */
    { 1989, 0x9E3779B1U, 0xFBCF3FE0U }, /* XSUM_XXH32_testdata[3979] */
    { 1990, 0x00000000U, 0xD02693EFU }, /* XSUM_XXH32_testdata[3980] */
    { 1990, 0x9E3779B1U, 0x1BB07C3CU }, /* XSUM_XXH32_testdata[3981] */
    { 1991, 0x00000000U, 0x1C4CF83DU }, /* XSUM_XXH32_testdata[3982] */
    { 1991, 0x9E3779B1U, 0x20338234U }, /* XSUM_XXH32_testdata[3983] */
    { 1992, 0x00000000U, 0x6AABD9CEU }, /* XSUM_XXH32_testdata[3984] */
    { 1992, 0x9E3779B1U, 0x8EB483CAU }, /* XSUM_XXH32_testdata[3985] */
    { 1993, 0x00000000U, 0x1E773C8BU }, /* XSUM_XXH32_testdata[3986] */
    { 1993, 0x9E3779B1U, 0xB64A5A21U }, /* XSUM_XXH32_testdata[3987] */
    { 1994, 0x00000000U, 0x35AFF519U }, /* XSUM_XXH32_testdata[3988] */
    { 1994, 0x9E3779B1U, 0x473FDCE8U }, /* XSUM_XXH32_testdata[3989] */
    { 1995, 0x00000000U, 0xDC9FA8CDU }, /* XSUM_XXH32_testdata[3990] */
    { 1995, 0x9E3779B1U, 0x892138B0U }, /* XSUM_XXH32_testdata[3991] */
    { 1996, 0x00000000U, 0x6DEF8AD0U }, /* XSUM_XXH32_testdata[3992] */
    { 1996, 0x9E3779B1U, 0x457FE27BU }, /* XSUM_XXH32_testdata[3993] */
    { 1997, 0x00000000U, 0x890FB3E4U }, /* XSUM_XXH32_testdata[3994] */
    { 1997, 0x9E3779B1U, 0x1F5B9CEBU }, /* XSUM_XXH32_testdata[3995] */
    { 1998, 0x00000000U, 0xB64776BEU }, /* XSUM_XXH32_testdata[3996] */
    { 1998, 0x9E3779B1U, 0xB101B5F3U }, /* XSUM_XXH32_testdata[3997] */
    { 1999, 0x00000000U, 0xF2E14CBEU }, /* XSUM_XXH32_testdata[3998] */
    { 1999, 0x9E3779B1U, 0xCC0E148DU }, /* XSUM_XXH32_testdata[3999] */
    { 2000, 0x00000000U, 0x037244F1U }, /* XSUM_XXH32_testdata[4000] */
    { 2000, 0x9E3779B1U, 0xB2FBE118U }, /* XSUM_XXH32_testdata[4001] */
    { 2001, 0x00000000U, 0x50448CFCU }, /* XSUM_XXH32_testdata[4002] */
    { 2001, 0x9E3779B1U, 0xFA843DEBU }, /* XSUM_XXH32_testdata[4003] */
    { 2002, 0x00000000U, 0x06B8CE0AU }, /* XSUM_XXH32_testdata[4004] */
    { 2002, 0x9E3779B1U, 0x3A40336AU }, /* XSUM_XXH32_testdata[4005] */
    { 2003, 0x00000000U, 0xA630739DU }, /* XSUM_XXH32_testdata[4006] */
    { 2003, 0x9E3779B1U, 0xDB23BC34U }, /* XSUM_XXH32_testdata[4007] */
    { 2004, 0x00000000U, 0x6353FAE6U }, /* XSUM_XXH32_testdata[4008] */
    { 2004, 0x9E3779B1U, 0x3F8D9741U }, /* XSUM_XXH32_testdata[4009] */
    { 2005, 0x00000000U, 0xA60FF8FBU }, /* XSUM_XXH32_testdata[4010] */
    { 2005, 0x9E3779B1U, 0x2D6B8550U }, /* XSUM_XXH32_testdata[4011] */
    { 2006, 0x00000000U, 0x3AE24C4BU }, /* XSUM_XXH32_testdata[4012] */
    { 2006, 0x9E3779B1U, 0x5A116536U }, /* XSUM_XXH32_testdata[4013] */
    { 2007, 0x00000000U, 0x9648CE72U }, /* XSUM_XXH32_testdata[4014] */
    { 2007, 0x9E3779B1U, 0x516E552AU }, /* XSUM_XXH32_testdata[4015] */
    { 2008, 0x00000000U, 0x59A961B3U }, /* XSUM_XXH32_testdata[4016] */
    { 2008, 0x9E3779B1U, 0xEFBF6827U }, /* XSUM_XXH32_testdata[4017] */
    { 2009, 0x00000000U, 0xAD34FA0CU }, /* XSUM_XXH32_testdata[4018] */
    { 2009, 0x9E3779B1U, 0x31A65802U }, /* XSUM_XXH32_testdata[4019] */
    { 2010, 0x00000000U, 0xA35EAFE9U }, /* XSUM_XXH32_testdata[4020] */
    { 2010, 0x9E3779B1U, 0x46793AC6U }, /* XSUM_XXH32_testdata[4021] */
    { 2011, 0x00000000U, 0x7A55F70EU }, /* XSUM_XXH32_testdata[4022] */
    { 2011, 0x9E3779B1U, 0xB5CB7FE3U }, /* XSUM_XXH32_testdata[4023] */
    { 2012, 0x00000000U, 0x245FE661U }, /* XSUM_XXH32_testdata[4024] */
    { 2012, 0x9E3779B1U, 0xAB3CC11BU }, /* XSUM_XXH32_testdata[4025] */
    { 2013, 0x00000000U, 0x5D03D1B8U }, /* XSUM_XXH32_testdata[4026] */
    { 2013, 0x9E3779B1U, 0xD588E35EU }, /* XSUM_XXH32_testdata[4027] */
    { 2014, 0x00000000U, 0x9E86CEFCU }, /* XSUM_XXH32_testdata[4028] */
    { 2014, 0x9E3779B1U, 0x5A2E2EBEU }, /* XSUM_XXH32_testdata[4029] */
    { 2015, 0x00000000U, 0x08B88BD0U }, /* XSUM_XXH32_testdata[4030] */
    { 2015, 0x9E3779B1U, 0x089F95BFU }, /* XSUM_XXH32_testdata[4031] */
    { 2016, 0x00000000U, 0xC49A0201U }, /* XSUM_XXH32_testdata[4032] */
    { 2016, 0x9E3779B1U, 0x083A01CCU }, /* XSUM_XXH32_testdata[4033] */
    { 2017, 0x00000000U, 0xA8BFCB32U }, /* XSUM_XXH32_testdata[4034] */
    { 2017, 0x9E3779B1U, 0x5F51E2E9U }, /* XSUM_XXH32_testdata[4035] */
    { 2018, 0x00000000U, 0x56D0D478U }, /* XSUM_XXH32_testdata[4036] */
    { 2018, 0x9E3779B1U, 0xE86FE06CU }, /* XSUM_XXH32_testdata[4037] */
    { 2019, 0x00000000U, 0x16E681BEU }, /* XSUM_XXH32_testdata[4038] */
    { 2019, 0x9E3779B1U, 0xB4EB93CBU }, /* XSUM_XXH32_testdata[4039] */
    { 2020, 0x00000000U, 0x8A7C8329U }, /* XSUM_XXH32_testdata[4040] */
    { 2020, 0x9E3779B1U, 0x2DAACEAFU }, /* XSUM_XXH32_testdata[4041] */
    { 2021, 0x00000000U, 0xC2766DBAU }, /* XSUM_XXH32_testdata[4042] */
    { 2021, 0x9E3779B1U, 0x8FB8125FU }, /* XSUM_XXH32_testdata[4043] */
    { 2022, 0x00000000U, 0x7E60D1C2U }, /* XSUM_XXH32_testdata[4044] */
    { 2022, 0x9E3779B1U, 0xD07D751EU }, /* XSUM_XXH32_testdata[4045] */
    { 2023, 0x00000000U, 0x6214655CU }, /* XSUM_XXH32_testdata[4046] */
    { 2023, 0x9E3779B1U, 0x291474CCU }, /* XSUM_XXH32_testdata[4047] */
    { 2024, 0x00000000U, 0xBBD6C077U }, /* XSUM_XXH32_testdata[4048] */
    { 2024, 0x9E3779B1U, 0x69720F53U }, /* XSUM_XXH32_testdata[4049] */
    { 2025, 0x00000000U, 0x90AFACE9U }, /* XSUM_XXH32_testdata[4050] */
    { 2025, 0x9E3779B1U, 0x0A4A2677U }, /* XSUM_XXH32_testdata[4051] */
    { 2026, 0x00000000U, 0xEE7FA58BU }, /* XSUM_XXH32_testdata[4052] */
    { 2026, 0x9E3779B1U, 0x4C4FB263U }, /* XSUM_XXH32_testdata[4053] */
    { 2027, 0x00000000U, 0x40DC1676U }, /* XSUM_XXH32_testdata[4054] */
    { 2027, 0x9E3779B1U, 0x9B66BBC7U }, /* XSUM_XXH32_testdata[4055] */
    { 2028, 0x00000000U, 0xF053E1D4U }, /* XSUM_XXH32_testdata[4056] */
    { 2028, 0x9E3779B1U, 0xA60B2337U }, /* XSUM_XXH32_testdata[4057] */
    { 2029, 0x00000000U, 0x775F2608U }, /* XSUM_XXH32_testdata[4058] */
    { 2029, 0x9E3779B1U, 0xD31BB491U }, /* XSUM_XXH32_testdata[4059] */
    { 2030, 0x00000000U, 0x637D5315U }, /* XSUM_XXH32_testdata[4060] */
    { 2030, 0x9E3779B1U, 0x7F0210C2U }, /* XSUM_XXH32_testdata[4061] */
    { 2031, 0x00000000U, 0x5EBF2AA7U }, /* XSUM_XXH32_testdata[4062] */
    { 2031, 0x9E3779B1U, 0xE71ABE86U }, /* XSUM_XXH32_testdata[4063] */
    { 2032, 0x00000000U, 0x1C72071DU }, /* XSUM_XXH32_testdata[4064] */
    { 2032, 0x9E3779B1U, 0x07F4C560U }, /* XSUM_XXH32_testdata[4065] */
    { 2033, 0x00000000U, 0x41418F2CU }, /* XSUM_XXH32_testdata[4066] */
    { 2033, 0x9E3779B1U, 0x7EE8E647U }, /* XSUM_XXH32_testdata[4067] */
    { 2034, 0x00000000U, 0x45D9462AU }, /* XSUM_XXH32_testdata[4068] */
    { 2034, 0x9E3779B1U, 0xAF1BE5F1U }, /* XSUM_XXH32_testdata[4069] */
    { 2035, 0x00000000U, 0x21BC7874U }, /* XSUM_XXH32_testdata[4070] */
    { 2035, 0x9E3779B1U, 0xE29E0AF3U }, /* XSUM_XXH32_testdata[4071] */
    { 2036, 0x00000000U, 0xA4975122U }, /* XSUM_XXH32_testdata[4072] */
    { 2036, 0x9E3779B1U, 0xA304FF25U }, /* XSUM_XXH32_testdata[4073] */
    { 2037, 0x00000000U, 0xEFBA9648U }, /* XSUM_XXH32_testdata[4074] */
    { 2037, 0x9E3779B1U, 0x374C61BAU }, /* XSUM_XXH32_testdata[4075] */
    { 2038, 0x00000000U, 0xE1C05541U }, /* XSUM_XXH32_testdata[4076] */
    { 2038, 0x9E3779B1U, 0x4B71A074U }, /* XSUM_XXH32_testdata[4077] */
    { 2039, 0x00000000U, 0x80957D94U }, /* XSUM_XXH32_testdata[4078] */
    { 2039, 0x9E3779B1U, 0xC49E1925U }, /* XSUM_XXH32_testdata[4079] */
    { 2040, 0x00000000U, 0x6D4D1C66U }, /* XSUM_XXH32_testdata[4080] */
    { 2040, 0x9E3779B1U, 0xE1C650D3U }, /* XSUM_XXH32_testdata[4081] */
    { 2041, 0x00000000U, 0x6D646431U }, /* XSUM_XXH32_testdata[4082] */
    { 2041, 0x9E3779B1U, 0x00891D66U }, /* XSUM_XXH32_testdata[4083] */
    { 2042, 0x00000000U, 0x71099C2DU }, /* XSUM_XXH32_testdata[4084] */
    { 2042, 0x9E3779B1U, 0x4F7223C7U }, /* XSUM_XXH32_testdata[4085] */
    { 2043, 0x00000000U, 0x4A04521BU }, /* XSUM_XXH32_testdata[4086] */
    { 2043, 0x9E3779B1U, 0x139BD0D3U }, /* XSUM_XXH32_testdata[4087] */
    { 2044, 0x00000000U, 0x9E81B0E0U }, /* XSUM_XXH32_testdata[4088] */
    { 2044, 0x9E3779B1U, 0xA2D3A39BU }, /* XSUM_XXH32_testdata[4089] */
    { 2045, 0x00000000U, 0x4469E1A8U }, /* XSUM_XXH32_testdata[4090] */
    { 2045, 0x9E3779B1U, 0x7C93C1A4U }, /* XSUM_XXH32_testdata[4091] */
    { 2046, 0x00000000U, 0xB69D2E91U }, /* XSUM_XXH32_testdata[4092] */
    { 2046, 0x9E3779B1U, 0x56B9ACCEU }, /* XSUM_XXH32_testdata[4093] */
    { 2047, 0x00000000U, 0x05CF4C53U }, /* XSUM_XXH32_testdata[4094] */
    { 2047, 0x9E3779B1U, 0xDAC740B5U }, /* XSUM_XXH32_testdata[4095] */
    { 2048, 0x00000000U, 0x7C535464U }, /* XSUM_XXH32_testdata[4096] */
    { 2048, 0x9E3779B1U, 0x89688D5EU }, /* XSUM_XXH32_testdata[4097] */
    { 2049, 0x00000000U, 0x880E455CU }, /* XSUM_XXH32_testdata[4098] */
    { 2049, 0x9E3779B1U, 0x0C3F5225U }, /* XSUM_XXH32_testdata[4099] */
    { 2050, 0x00000000U, 0x0CD5328AU }, /* XSUM_XXH32_testdata[4100] */
    { 2050, 0x9E3779B1U, 0x5E4CECABU }, /* XSUM_XXH32_testdata[4101] */
    { 2051, 0x00000000U, 0xB02EC05BU }, /* XSUM_XXH32_testdata[4102] */
    { 2051, 0x9E3779B1U, 0x8EB1CA2EU }, /* XSUM_XXH32_testdata[4103] */
    { 2052, 0x00000000U, 0x819785B4U }, /* XSUM_XXH32_testdata[4104] */
    { 2052, 0x9E3779B1U, 0xEE4DC00FU }, /* XSUM_XXH32_testdata[4105] */
    { 2053, 0x00000000U, 0xBB02DD05U }, /* XSUM_XXH32_testdata[4106] */
    { 2053, 0x9E3779B1U, 0xE0B03346U }, /* XSUM_XXH32_testdata[4107] */
    { 2054, 0x00000000U, 0x9BB201E3U }, /* XSUM_XXH32_testdata[4108] */
    { 2054, 0x9E3779B1U, 0xA50B6FEFU }, /* XSUM_XXH32_testdata[4109] */
    { 2055, 0x00000000U, 0x5EB9E721U }, /* XSUM_XXH32_testdata[4110] */
    { 2055, 0x9E3779B1U, 0x84B80A21U }, /* XSUM_XXH32_testdata[4111] */
    { 2056, 0x00000000U, 0x4A8BB9DBU }, /* XSUM_XXH32_testdata[4112] */
    { 2056, 0x9E3779B1U, 0xFBFB5F35U }, /* XSUM_XXH32_testdata[4113] */
    { 2057, 0x00000000U, 0x621A3AE1U }, /* XSUM_XXH32_testdata[4114] */
    { 2057, 0x9E3779B1U, 0xE62B3DA9U }, /* XSUM_XXH32_testdata[4115] */
    { 2058, 0x00000000U, 0xD433D0D2U }, /* XSUM_XXH32_testdata[4116] */
    { 2058, 0x9E3779B1U, 0x023E0618U }, /* XSUM_XXH32_testdata[4117] */
    { 2059, 0x00000000U, 0x8D358340U }, /* XSUM_XXH32_testdata[4118] */
    { 2059, 0x9E3779B1U, 0x98103E37U }, /* XSUM_XXH32_testdata[4119] */
    { 2060, 0x00000000U, 0x1C734A82U }, /* XSUM_XXH32_testdata[4120] */
    { 2060, 0x9E3779B1U, 0xA5157D21U }, /* XSUM_XXH32_testdata[4121] */
    { 2061, 0x00000000U, 0xE4C01B2FU }, /* XSUM_XXH32_testdata[4122] */
    { 2061, 0x9E3779B1U, 0xEA9E2AE1U }, /* XSUM_XXH32_testdata[4123] */
    { 2062, 0x00000000U, 0x1EE4F10EU }, /* XSUM_XXH32_testdata[4124] */
    { 2062, 0x9E3779B1U, 0x93956AB3U }, /* XSUM_XXH32_testdata[4125] */
    { 2063, 0x00000000U, 0xA568A1D0U }, /* XSUM_XXH32_testdata[4126] */
    { 2063, 0x9E3779B1U, 0x490518BFU }, /* XSUM_XXH32_testdata[4127] */
    { 2064, 0x00000000U, 0x0894677FU }, /* XSUM_XXH32_testdata[4128] */
    { 2064, 0x9E3779B1U, 0x82829756U }, /* XSUM_XXH32_testdata[4129] */
    { 2065, 0x00000000U, 0xB2DA6FCFU }, /* XSUM_XXH32_testdata[4130] */
    { 2065, 0x9E3779B1U, 0x35F8DBEBU }, /* XSUM_XXH32_testdata[4131] */
    { 2066, 0x00000000U, 0x4A995E77U }, /* XSUM_XXH32_testdata[4132] */
    { 2066, 0x9E3779B1U, 0x67F7EB59U }, /* XSUM_XXH32_testdata[4133] */
    { 2067, 0x00000000U, 0x241E6D99U }, /* XSUM_XXH32_testdata[4134] */
    { 2067, 0x9E3779B1U, 0x7FB35950U }, /* XSUM_XXH32_testdata[4135] */
    { 2068, 0x00000000U, 0x807203FFU }, /* XSUM_XXH32_testdata[4136] */
    { 2068, 0x9E3779B1U, 0x84F6AADCU }, /* XSUM_XXH32_testdata[4137] */
    { 2069, 0x00000000U, 0x713F8660U }, /* XSUM_XXH32_testdata[4138] */
    { 2069, 0x9E3779B1U, 0x28046D70U }, /* XSUM_XXH32_testdata[4139] */
    { 2070, 0x00000000U, 0x8BB2D1DCU }, /* XSUM_XXH32_testdata[4140] */
    { 2070, 0x9E3779B1U, 0x88B61103U }, /* XSUM_XXH32_testdata[4141] */
    { 2071, 0x00000000U, 0x6952D726U }, /* XSUM_XXH32_testdata[4142] */
    { 2071, 0x9E3779B1U, 0xCA5E851DU }, /* XSUM_XXH32_testdata[4143] */
    { 2072, 0x00000000U, 0xBC494A9DU }, /* XSUM_XXH32_testdata[4144] */
    { 2072, 0x9E3779B1U, 0x2245A660U }, /* XSUM_XXH32_testdata[4145] */
    { 2073, 0x00000000U, 0xEF4414E3U }, /* XSUM_XXH32_testdata[4146] */
    { 2073, 0x9E3779B1U, 0x1720471BU }, /* XSUM_XXH32_testdata[4147] */
    { 2074, 0x00000000U, 0x498A6F0BU }, /* XSUM_XXH32_testdata[4148] */
    { 2074, 0x9E3779B1U, 0x6BC7CB59U }, /* XSUM_XXH32_testdata[4149] */
    { 2075, 0x00000000U, 0x7436EB2CU }, /* XSUM_XXH32_testdata[4150] */
    { 2075, 0x9E3779B1U, 0xD1770A41U }, /* XSUM_XXH32_testdata[4151] */
    { 2076, 0x00000000U, 0xE7ED09E0U }, /* XSUM_XXH32_testdata[4152] */
    { 2076, 0x9E3779B1U, 0xFE421D54U }, /* XSUM_XXH32_testdata[4153] */
    { 2077, 0x00000000U, 0x884E145EU }, /* XSUM_XXH32_testdata[4154] */
    { 2077, 0x9E3779B1U, 0x5106C772U }, /* XSUM_XXH32_testdata[4155] */
    { 2078, 0x00000000U, 0xA0483532U }, /* XSUM_XXH32_testdata[4156] */
    { 2078, 0x9E3779B1U, 0x807EC1E3U }, /* XSUM_XXH32_testdata[4157] */
    { 2079, 0x00000000U, 0x6E5D2A65U }, /* XSUM_XXH32_testdata[4158] */
    { 2079, 0x9E3779B1U, 0xE0AECE5AU }, /* XSUM_XXH32_testdata[4159] */
    { 2080, 0x00000000U, 0xDDFF4A1FU }, /* XSUM_XXH32_testdata[4160] */
    { 2080, 0x9E3779B1U, 0x74896BB0U }, /* XSUM_XXH32_testdata[4161] */
    { 2081, 0x00000000U, 0x8E2E4382U }, /* XSUM_XXH32_testdata[4162] */
    { 2081, 0x9E3779B1U, 0x6F62BBFFU }, /* XSUM_XXH32_testdata[4163] */
    { 2082, 0x00000000U, 0x2BA6E39CU }, /* XSUM_XXH32_testdata[4164] */
    { 2082, 0x9E3779B1U, 0x83A3C889U }, /* XSUM_XXH32_testdata[4165] */
    { 2083, 0x00000000U, 0x6108A48CU }, /* XSUM_XXH32_testdata[4166] */
    { 2083, 0x9E3779B1U, 0xAC9D1C66U }, /* XSUM_XXH32_testdata[4167] */
    { 2084, 0x00000000U, 0x0F218683U }, /* XSUM_XXH32_testdata[4168] */
    { 2084, 0x9E3779B1U, 0x9812C2A7U }, /* XSUM_XXH32_testdata[4169] */
    { 2085, 0x00000000U, 0xCFCA7398U }, /* XSUM_XXH32_testdata[4170] */
    { 2085, 0x9E3779B1U, 0xDCEBCDDDU }, /* XSUM_XXH32_testdata[4171] */
    { 2086, 0x00000000U, 0x56C5D691U }, /* XSUM_XXH32_testdata[4172] */
    { 2086, 0x9E3779B1U, 0xC37D8A9FU }, /* XSUM_XXH32_testdata[4173] */
    { 2087, 0x00000000U, 0x23C0782DU }, /* XSUM_XXH32_testdata[4174] */
    { 2087, 0x9E3779B1U, 0x32D0C4E7U }, /* XSUM_XXH32_testdata[4175] */
    { 2088, 0x00000000U, 0x52055550U }, /* XSUM_XXH32_testdata[4176] */
    { 2088, 0x9E3779B1U, 0x8153DC52U }, /* XSUM_XXH32_testdata[4177] */
    { 2089, 0x00000000U, 0x396A700FU }, /* XSUM_XXH32_testdata[4178] */
    { 2089, 0x9E3779B1U, 0x86CC74C0U }, /* XSUM_XXH32_testdata[4179] */
    { 2090, 0x00000000U, 0x3C1E21A9U }, /* XSUM_XXH32_testdata[4180] */
    { 2090, 0x9E3779B1U, 0xAA919D65U }, /* XSUM_XXH32_testdata[4181] */
    { 2091, 0x00000000U, 0xA1EE86D3U }, /* XSUM_XXH32_testdata[4182] */
    { 2091, 0x9E3779B1U, 0x7508F175U }, /* XSUM_XXH32_testdata[4183] */
    { 2092, 0x00000000U, 0x0C0C92CEU }, /* XSUM_XXH32_testdata[4184] */
    { 2092, 0x9E3779B1U, 0x31AAE533U }, /* XSUM_XXH32_testdata[4185] */
    { 2093, 0x00000000U, 0x0FED09E1U }, /* XSUM_XXH32_testdata[4186] */
    { 2093, 0x9E3779B1U, 0xA71F16A2U }, /* XSUM_XXH32_testdata[4187] */
    { 2094, 0x00000000U, 0x2B97260DU }, /* XSUM_XXH32_testdata[4188] */
    { 2094, 0x9E3779B1U, 0x1F320538U }, /* XSUM_XXH32_testdata[4189] */
    { 2095, 0x00000000U, 0x226857ECU }, /* XSUM_XXH32_testdata[4190] */
    { 2095, 0x9E3779B1U, 0xBE2AA830U }, /* XSUM_XXH32_testdata[4191] */
    { 2096, 0x00000000U, 0x483AF09AU }, /* XSUM_XXH32_testdata[4192] */
    { 2096, 0x9E3779B1U, 0xEB914369U }, /* XSUM_XXH32_testdata[4193] */
    { 2097, 0x00000000U, 0x2D17844DU }, /* XSUM_XXH32_testdata[4194] */
    { 2097, 0x9E3779B1U, 0xA950DEBDU }, /* XSUM_XXH32_testdata[4195] */
    { 2098, 0x00000000U, 0x1439FDE2U }, /* XSUM_XXH32_testdata[4196] */
    { 2098, 0x9E3779B1U, 0x26FE8A85U }, /* XSUM_XXH32_testdata[4197] */
    { 2099, 0x00000000U, 0x5772718CU }, /* XSUM_XXH32_testdata[4198] */
    { 2099, 0x9E3779B1U, 0x4FCA33C3U }, /* XSUM_XXH32_testdata[4199] */
    { 2100, 0x00000000U, 0xD9EB2B50U }, /* XSUM_XXH32_testdata[4200] */
    { 2100, 0x9E3779B1U, 0xE8F459E0U }, /* XSUM_XXH32_testdata[4201] */
    { 2101, 0x00000000U, 0xA28FB819U }, /* XSUM_XXH32_testdata[4202] */
    { 2101, 0x9E3779B1U, 0x9280CA2FU }, /* XSUM_XXH32_testdata[4203] */
    { 2102, 0x00000000U, 0xEBCFFDB8U }, /* XSUM_XXH32_testdata[4204] */
    { 2102, 0x9E3779B1U, 0xEB017DC5U }, /* XSUM_XXH32_testdata[4205] */
    { 2103, 0x00000000U, 0x54058833U }, /* XSUM_XXH32_testdata[4206] */
    { 2103, 0x9E3779B1U, 0x28EB819FU }, /* XSUM_XXH32_testdata[4207] */
    { 2104, 0x00000000U, 0xE578AD4EU }, /* XSUM_XXH32_testdata[4208] */
    { 2104, 0x9E3779B1U, 0x98998373U }, /* XSUM_XXH32_testdata[4209] */
    { 2105, 0x00000000U, 0x75DD1E49U }, /* XSUM_XXH32_testdata[4210] */
    { 2105, 0x9E3779B1U, 0x55FB4D69U }, /* XSUM_XXH32_testdata[4211] */
    { 2106, 0x00000000U, 0x266483CAU }, /* XSUM_XXH32_testdata[4212] */
    { 2106, 0x9E3779B1U, 0x1B37FDC4U }, /* XSUM_XXH32_testdata[4213] */
    { 2107, 0x00000000U, 0x2703FCA6U }, /* XSUM_XXH32_testdata[4214] */
    { 2107, 0x9E3779B1U, 0x668C4D82U }, /* XSUM_XXH32_testdata[4215] */
    { 2108, 0x00000000U, 0xCCFF2548U }, /* XSUM_XXH32_testdata[4216] */
    { 2108, 0x9E3779B1U, 0x22EBB2C2U }, /* XSUM_XXH32_testdata[4217] */
    { 2109, 0x00000000U, 0x02A027B1U }, /* XSUM_XXH32_testdata[4218] */
    { 2109, 0x9E3779B1U, 0xC8F3C892U }, /* XSUM_XXH32_testdata[4219] */
    { 2110, 0x00000000U, 0x1F3AD215U }, /* XSUM_XXH32_testdata[4220] */
    { 2110, 0x9E3779B1U, 0xF89BB413U }, /* XSUM_XXH32_testdata[4221] */
    { 2111, 0x00000000U, 0x75B32021U }, /* XSUM_XXH32_testdata[4222] */
    { 2111, 0x9E3779B1U, 0x9E179034U }, /* XSUM_XXH32_testdata[4223] */
    { 2112, 0x00000000U, 0x90BA76C2U }, /* XSUM_XXH32_testdata[4224] */
    { 2112, 0x9E3779B1U, 0x89BC588FU }, /* XSUM_XXH32_testdata[4225] */
    { 2113, 0x00000000U, 0xA4E0D6B2U }, /* XSUM_XXH32_testdata[4226] */
    { 2113, 0x9E3779B1U, 0xE5F97F9AU }, /* XSUM_XXH32_testdata[4227] */
    { 2114, 0x00000000U, 0x9B30F92FU }, /* XSUM_XXH32_testdata[4228] */
    { 2114, 0x9E3779B1U, 0xB072872FU }, /* XSUM_XXH32_testdata[4229] */
    { 2115, 0x00000000U, 0xFB8EE30EU }, /* XSUM_XXH32_testdata[4230] */
    { 2115, 0x9E3779B1U, 0xA965355EU }, /* XSUM_XXH32_testdata[4231] */
    { 2116, 0x00000000U, 0x4ECD0C57U }, /* XSUM_XXH32_testdata[4232] */
    { 2116, 0x9E3779B1U, 0x66DCD701U }, /* XSUM_XXH32_testdata[4233] */
    { 2117, 0x00000000U, 0xBDED9E14U }, /* XSUM_XXH32_testdata[4234] */
    { 2117, 0x9E3779B1U, 0x8330F84CU }, /* XSUM_XXH32_testdata[4235] */
    { 2118, 0x00000000U, 0x6636A7CBU }, /* XSUM_XXH32_testdata[4236] */
    { 2118, 0x9E3779B1U, 0xC1305149U }, /* XSUM_XXH32_testdata[4237] */
    { 2119, 0x00000000U, 0xEE6E1F55U }, /* XSUM_XXH32_testdata[4238] */
    { 2119, 0x9E3779B1U, 0x883D1A16U }, /* XSUM_XXH32_testdata[4239] */
    { 2120, 0x00000000U, 0xA3D44D6BU }, /* XSUM_XXH32_testdata[4240] */
    { 2120, 0x9E3779B1U, 0x29A7B351U }, /* XSUM_XXH32_testdata[4241] */
    { 2121, 0x00000000U, 0x8155248FU }, /* XSUM_XXH32_testdata[4242] */
    { 2121, 0x9E3779B1U, 0x115824D3U }, /* XSUM_XXH32_testdata[4243] */
    { 2122, 0x00000000U, 0xDAB244E4U }, /* XSUM_XXH32_testdata[4244] */
    { 2122, 0x9E3779B1U, 0x538CF5D7U }, /* XSUM_XXH32_testdata[4245] */
    { 2123, 0x00000000U, 0xCCADAA76U }, /* XSUM_XXH32_testdata[4246] */
    { 2123, 0x9E3779B1U, 0x79CE1918U }, /* XSUM_XXH32_testdata[4247] */
    { 2124, 0x00000000U, 0x291A0B1EU }, /* XSUM_XXH32_testdata[4248] */
    { 2124, 0x9E3779B1U, 0x0B6DFEACU }, /* XSUM_XXH32_testdata[4249] */
    { 2125, 0x00000000U, 0x6722DAE9U }, /* XSUM_XXH32_testdata[4250] */
    { 2125, 0x9E3779B1U, 0x0FE2989AU }, /* XSUM_XXH32_testdata[4251] */
    { 2126, 0x00000000U, 0xCA5552BDU }, /* XSUM_XXH32_testdata[4252] */
    { 2126, 0x9E3779B1U, 0x62FA78A6U }, /* XSUM_XXH32_testdata[4253] */
    { 2127, 0x00000000U, 0xD4D05195U }, /* XSUM_XXH32_testdata[4254] */
    { 2127, 0x9E3779B1U, 0x96D74687U }, /* XSUM_XXH32_testdata[4255] */
    { 2128, 0x00000000U, 0xAA1B18EFU }, /* XSUM_XXH32_testdata[4256] */
    { 2128, 0x9E3779B1U, 0x3916A04DU }, /* XSUM_XXH32_testdata[4257] */
    { 2129, 0x00000000U, 0x77BEC316U }, /* XSUM_XXH32_testdata[4258] */
    { 2129, 0x9E3779B1U, 0xEC73137EU }, /* XSUM_XXH32_testdata[4259] */
    { 2130, 0x00000000U, 0xB447EDE9U }, /* XSUM_XXH32_testdata[4260] */
    { 2130, 0x9E3779B1U, 0x2BAD6C2EU }, /* XSUM_XXH32_testdata[4261] */
    { 2131, 0x00000000U, 0xC4EABAB1U }, /* XSUM_XXH32_testdata[4262] */
    { 2131, 0x9E3779B1U, 0xBF962F78U }, /* XSUM_XXH32_testdata[4263] */
    { 2132, 0x00000000U, 0xF5D647AEU }, /* XSUM_XXH32_testdata[4264] */
    { 2132, 0x9E3779B1U, 0x453B9698U }, /* XSUM_XXH32_testdata[4265] */
    { 2133, 0x00000000U, 0xC067D3EBU }, /* XSUM_XXH32_testdata[4266] */
    { 2133, 0x9E3779B1U, 0x31C65AC9U }, /* XSUM_XXH32_testdata[4267] */
    { 2134, 0x00000000U, 0xED35F95BU }, /* XSUM_XXH32_testdata[4268] */
    { 2134, 0x9E3779B1U, 0x694511F0U }, /* XSUM_XXH32_testdata[4269] */
    { 2135, 0x00000000U, 0x66EAE8A9U }, /* XSUM_XXH32_testdata[4270] */
    { 2135, 0x9E3779B1U, 0xD92C573CU }, /* XSUM_XXH32_testdata[4271] */
    { 2136, 0x00000000U, 0xCB07B88BU }, /* XSUM_XXH32_testdata[4272] */
    { 2136, 0x9E3779B1U, 0x2E05A315U }, /* XSUM_XXH32_testdata[4273] */
    { 2137, 0x00000000U, 0xA507A109U }, /* XSUM_XXH32_testdata[4274] */
    { 2137, 0x9E3779B1U, 0x8F57286CU }, /* XSUM_XXH32_testdata[4275] */
    { 2138, 0x00000000U, 0xC7ED3A83U }, /* XSUM_XXH32_testdata[4276] */
    { 2138, 0x9E3779B1U, 0x79911DEEU }, /* XSUM_XXH32_testdata[4277] */
    { 2139, 0x00000000U, 0x92FC8AB7U }, /* XSUM_XXH32_testdata[4278] */
    { 2139, 0x9E3779B1U, 0x32875F23U }, /* XSUM_XXH32_testdata[4279] */
    { 2140, 0x00000000U, 0x2B0CBB1FU }, /* XSUM_XXH32_testdata[4280] */
    { 2140, 0x9E3779B1U, 0x36F822AAU }, /* XSUM_XXH32_testdata[4281] */
    { 2141, 0x00000000U, 0xC597BD36U }, /* XSUM_XXH32_testdata[4282] */
    { 2141, 0x9E3779B1U, 0x7CC8B801U }, /* XSUM_XXH32_testdata[4283] */
    { 2142, 0x00000000U, 0x7EB11318U }, /* XSUM_XXH32_testdata[4284] */
    { 2142, 0x9E3779B1U, 0x74617AD2U }, /* XSUM_XXH32_testdata[4285] */
    { 2143, 0x00000000U, 0x27275139U }, /* XSUM_XXH32_testdata[4286] */
    { 2143, 0x9E3779B1U, 0xC5EDC2F3U }, /* XSUM_XXH32_testdata[4287] */
    { 2144, 0x00000000U, 0x6A643B07U }, /* XSUM_XXH32_testdata[4288] */
    { 2144, 0x9E3779B1U, 0xF7B9436FU }, /* XSUM_XXH32_testdata[4289] */
    { 2145, 0x00000000U, 0x5015717CU }, /* XSUM_XXH32_testdata[4290] */
    { 2145, 0x9E3779B1U, 0x43760B37U }, /* XSUM_XXH32_testdata[4291] */
    { 2146, 0x00000000U, 0x2E2265F8U }, /* XSUM_XXH32_testdata[4292] */
    { 2146, 0x9E3779B1U, 0xF6DA51EEU }, /* XSUM_XXH32_testdata[4293] */
    { 2147, 0x00000000U, 0x42FBB597U }, /* XSUM_XXH32_testdata[4294] */
    { 2147, 0x9E3779B1U, 0x00330918U }, /* XSUM_XXH32_testdata[4295] */
    { 2148, 0x00000000U, 0x3FC0AD5CU }, /* XSUM_XXH32_testdata[4296] */
    { 2148, 0x9E3779B1U, 0x045DBF11U }, /* XSUM_XXH32_testdata[4297] */
    { 2149, 0x00000000U, 0x4020BF41U }, /* XSUM_XXH32_testdata[4298] */
    { 2149, 0x9E3779B1U, 0xFB478550U }, /* XSUM_XXH32_testdata[4299] */
    { 2150, 0x00000000U, 0xBA072C74U }, /* XSUM_XXH32_testdata[4300] */
    { 2150, 0x9E3779B1U, 0xE472A9E7U }, /* XSUM_XXH32_testdata[4301] */
    { 2151, 0x00000000U, 0x815645CAU }, /* XSUM_XXH32_testdata[4302] */
    { 2151, 0x9E3779B1U, 0x37ED1656U }, /* XSUM_XXH32_testdata[4303] */
    { 2152, 0x00000000U, 0x3B2B5205U }, /* XSUM_XXH32_testdata[4304] */
    { 2152, 0x9E3779B1U, 0x14752F3FU }, /* XSUM_XXH32_testdata[4305] */
    { 2153, 0x00000000U, 0x6916B481U }, /* XSUM_XXH32_testdata[4306] */
    { 2153, 0x9E3779B1U, 0xC59879F7U }, /* XSUM_XXH32_testdata[4307] */
    { 2154, 0x00000000U, 0x2306D44EU }, /* XSUM_XXH32_testdata[4308] */
    { 2154, 0x9E3779B1U, 0xC4ED179DU }, /* XSUM_XXH32_testdata[4309] */
    { 2155, 0x00000000U, 0x1CE7C121U }, /* XSUM_XXH32_testdata[4310] */
    { 2155, 0x9E3779B1U, 0x14F705A5U }, /* XSUM_XXH32_testdata[4311] */
    { 2156, 0x00000000U, 0x91321AECU }, /* XSUM_XXH32_testdata[4312] */
    { 2156, 0x9E3779B1U, 0x5A27F995U }, /* XSUM_XXH32_testdata[4313] */
    { 2157, 0x00000000U, 0x5A862E05U }, /* XSUM_XXH32_testdata[4314] */
    { 2157, 0x9E3779B1U, 0xBEFE3051U }, /* XSUM_XXH32_testdata[4315] */
    { 2158, 0x00000000U, 0x53C1D508U }, /* XSUM_XXH32_testdata[4316] */
    { 2158, 0x9E3779B1U, 0x08B825C0U }, /* XSUM_XXH32_testdata[4317] */
    { 2159, 0x00000000U, 0x998646FEU }, /* XSUM_XXH32_testdata[4318] */
    { 2159, 0x9E3779B1U, 0xE9F9CB10U }, /* XSUM_XXH32_testdata[4319] */
    { 2160, 0x00000000U, 0x73BA8D96U }, /* XSUM_XXH32_testdata[4320] */
    { 2160, 0x9E3779B1U, 0xE29F6E85U }, /* XSUM_XXH32_testdata[4321] */
    { 2161, 0x00000000U, 0xFE8E8571U }, /* XSUM_XXH32_testdata[4322] */
    { 2161, 0x9E3779B1U, 0x8702B7E4U }, /* XSUM_XXH32_testdata[4323] */
    { 2162, 0x00000000U, 0x50C31782U }, /* XSUM_XXH32_testdata[4324] */
    { 2162, 0x9E3779B1U, 0xA3CF4F8AU }, /* XSUM_XXH32_testdata[4325] */
    { 2163, 0x00000000U, 0x52332400U }, /* XSUM_XXH32_testdata[4326] */
    { 2163, 0x9E3779B1U, 0xD4753852U }, /* XSUM_XXH32_testdata[4327] */
    { 2164, 0x00000000U, 0x11981CA0U }, /* XSUM_XXH32_testdata[4328] */
    { 2164, 0x9E3779B1U, 0xB951C4E7U }, /* XSUM_XXH32_testdata[4329] */
    { 2165, 0x00000000U, 0x020CB658U }, /* XSUM_XXH32_testdata[4330] */
    { 2165, 0x9E3779B1U, 0x1C62E9FFU }, /* XSUM_XXH32_testdata[4331] */
    { 2166, 0x00000000U, 0x66A765C7U }, /* XSUM_XXH32_testdata[4332] */
    { 2166, 0x9E3779B1U, 0xD9A9267AU }, /* XSUM_XXH32_testdata[4333] */
    { 2167, 0x00000000U, 0x98D114F3U }, /* XSUM_XXH32_testdata[4334] */
    { 2167, 0x9E3779B1U, 0x26FCF092U }, /* XSUM_XXH32_testdata[4335] */
    { 2168, 0x00000000U, 0xA00817D1U }, /* XSUM_XXH32_testdata[4336] */
    { 2168, 0x9E3779B1U, 0x750C35A2U }, /* XSUM_XXH32_testdata[4337] */
    { 2169, 0x00000000U, 0xF1ACE5ADU }, /* XSUM_XXH32_testdata[4338] */
    { 2169, 0x9E3779B1U, 0x3DE1E6ABU }, /* XSUM_XXH32_testdata[4339] */
    { 2170, 0x00000000U, 0xF03CF8E3U }, /* XSUM_XXH32_testdata[4340] */
    { 2170, 0x9E3779B1U, 0x40412AD8U }, /* XSUM_XXH32_testdata[4341] */
    { 2171, 0x00000000U, 0x928C9B01U }, /* XSUM_XXH32_testdata[4342] */
    { 2171, 0x9E3779B1U, 0xA5794E20U }, /* XSUM_XXH32_testdata[4343] */
    { 2172, 0x00000000U, 0x691771D3U }, /* XSUM_XXH32_testdata[4344] */
    { 2172, 0x9E3779B1U, 0xC39FA55AU }, /* XSUM_XXH32_testdata[4345] */
    { 2173, 0x00000000U, 0xB979130AU }, /* XSUM_XXH32_testdata[4346] */
    { 2173, 0x9E3779B1U, 0x3B4ED784U }, /* XSUM_XXH32_testdata[4347] */
    { 2174, 0x00000000U, 0x4A0FD14CU }, /* XSUM_XXH32_testdata[4348] */
    { 2174, 0x9E3779B1U, 0xBD90DDE8U }, /* XSUM_XXH32_testdata[4349] */
    { 2175, 0x00000000U, 0x8B696624U }, /* XSUM_XXH32_testdata[4350] */
    { 2175, 0x9E3779B1U, 0xE712EE46U }, /* XSUM_XXH32_testdata[4351] */
    { 2176, 0x00000000U, 0x7FB86E80U }, /* XSUM_XXH32_testdata[4352] */
    { 2176, 0x9E3779B1U, 0x58063193U }, /* XSUM_XXH32_testdata[4353] */
    { 2177, 0x00000000U, 0x13A7F525U }, /* XSUM_XXH32_testdata[4354] */
    { 2177, 0x9E3779B1U, 0x4A13744DU }, /* XSUM_XXH32_testdata[4355] */
    { 2178, 0x00000000U, 0x4B1E442FU }, /* XSUM_XXH32_testdata[4356] */
    { 2178, 0x9E3779B1U, 0x94CBE9E3U }, /* XSUM_XXH32_testdata[4357] */
    { 2179, 0x00000000U, 0x498768E4U }, /* XSUM_XXH32_testdata[4358] */
    { 2179, 0x9E3779B1U, 0xA719C141U }, /* XSUM_XXH32_testdata[4359] */
    { 2180, 0x00000000U, 0xA8BDEA9FU }, /* XSUM_XXH32_testdata[4360] */
    { 2180, 0x9E3779B1U, 0x1442B51EU }, /* XSUM_XXH32_testdata[4361] */
    { 2181, 0x00000000U, 0xF7591169U }, /* XSUM_XXH32_testdata[4362] */
    { 2181, 0x9E3779B1U, 0xEE9E089EU }, /* XSUM_XXH32_testdata[4363] */
    { 2182, 0x00000000U, 0x48B900C1U }, /* XSUM_XXH32_testdata[4364] */
    { 2182, 0x9E3779B1U, 0x8B41080FU }, /* XSUM_XXH32_testdata[4365] */
    { 2183, 0x00000000U, 0x443E9B4AU }, /* XSUM_XXH32_testdata[4366] */
    { 2183, 0x9E3779B1U, 0x7417F2E4U }, /* XSUM_XXH32_testdata[4367] */
    { 2184, 0x00000000U, 0xB2464C2AU }, /* XSUM_XXH32_testdata[4368] */
    { 2184, 0x9E3779B1U, 0x700183B9U }, /* XSUM_XXH32_testdata[4369] */
    { 2185, 0x00000000U, 0xC3B03C48U }, /* XSUM_XXH32_testdata[4370] */
    { 2185, 0x9E3779B1U, 0xEBF56618U }, /* XSUM_XXH32_testdata[4371] */
    { 2186, 0x00000000U, 0x5022D513U }, /* XSUM_XXH32_testdata[4372] */
    { 2186, 0x9E3779B1U, 0xC86FB5F9U }, /* XSUM_XXH32_testdata[4373] */
    { 2187, 0x00000000U, 0xB9EE8EE7U }, /* XSUM_XXH32_testdata[4374] */
    { 2187, 0x9E3779B1U, 0x1FD9084AU }, /* XSUM_XXH32_testdata[4375] */
    { 2188, 0x00000000U, 0x5E026F1FU }, /* XSUM_XXH32_testdata[4376] */
    { 2188, 0x9E3779B1U, 0xBD338AC9U }, /* XSUM_XXH32_testdata[4377] */
    { 2189, 0x00000000U, 0xBA92F986U }, /* XSUM_XXH32_testdata[4378] */
    { 2189, 0x9E3779B1U, 0x96B1EB29U }, /* XSUM_XXH32_testdata[4379] */
    { 2190, 0x00000000U, 0xFA8B5152U }, /* XSUM_XXH32_testdata[4380] */
    { 2190, 0x9E3779B1U, 0xD2DE3CCEU }, /* XSUM_XXH32_testdata[4381] */
    { 2191, 0x00000000U, 0x14A1B5C2U }, /* XSUM_XXH32_testdata[4382] */
    { 2191, 0x9E3779B1U, 0x9F3DF200U }, /* XSUM_XXH32_testdata[4383] */
    { 2192, 0x00000000U, 0xAFBC0996U }, /* XSUM_XXH32_testdata[4384] */
    { 2192, 0x9E3779B1U, 0x419F8378U }, /* XSUM_XXH32_testdata[4385] */
    { 2193, 0x00000000U, 0x0662AD6CU }, /* XSUM_XXH32_testdata[4386] */
    { 2193, 0x9E3779B1U, 0x79AA6AB8U }, /* XSUM_XXH32_testdata[4387] */
    { 2194, 0x00000000U, 0x2714B7E6U }, /* XSUM_XXH32_testdata[4388] */
    { 2194, 0x9E3779B1U, 0xF529B3ADU }, /* XSUM_XXH32_testdata[4389] */
    { 2195, 0x00000000U, 0x563D02D5U }, /* XSUM_XXH32_testdata[4390] */
    { 2195, 0x9E3779B1U, 0x4065D039U }, /* XSUM_XXH32_testdata[4391] */
    { 2196, 0x00000000U, 0x36DCE091U }, /* XSUM_XXH32_testdata[4392] */
    { 2196, 0x9E3779B1U, 0xEABCEC00U }, /* XSUM_XXH32_testdata[4393] */
    { 2197, 0x00000000U, 0x67F9681CU }, /* XSUM_XXH32_testdata[4394] */
    { 2197, 0x9E3779B1U, 0x0E885D58U }, /* XSUM_XXH32_testdata[4395] */
    { 2198, 0x00000000U, 0xC933CA0FU }, /* XSUM_XXH32_testdata[4396] */
    { 2198, 0x9E3779B1U, 0xF1EDF626U }, /* XSUM_XXH32_testdata[4397] */
    { 2199, 0x00000000U, 0xB00C6C80U }, /* XSUM_XXH32_testdata[4398] */
    { 2199, 0x9E3779B1U, 0x65775351U }, /* XSUM_XXH32_testdata[4399] */
    { 2200, 0x00000000U, 0xD8577660U }, /* XSUM_XXH32_testdata[4400] */
    { 2200, 0x9E3779B1U, 0xB5D27E08U }, /* XSUM_XXH32_testdata[4401] */
    { 2201, 0x00000000U, 0x806C4319U }, /* XSUM_XXH32_testdata[4402] */
    { 2201, 0x9E3779B1U, 0x38C83A91U }, /* XSUM_XXH32_testdata[4403] */
    { 2202, 0x00000000U, 0xBFBBF483U }, /* XSUM_XXH32_testdata[4404] */
    { 2202, 0x9E3779B1U, 0xC3D62234U }, /* XSUM_XXH32_testdata[4405] */
    { 2203, 0x00000000U, 0xD3D92983U }, /* XSUM_XXH32_testdata[4406] */
    { 2203, 0x9E3779B1U, 0xFB1AA5C4U }, /* XSUM_XXH32_testdata[4407] */
    { 2204, 0x00000000U, 0x1627B9FEU }, /* XSUM_XXH32_testdata[4408] */
    { 2204, 0x9E3779B1U, 0x81EBA0B9U }, /* XSUM_XXH32_testdata[4409] */
    { 2205, 0x00000000U, 0x1FB26F2DU }, /* XSUM_XXH32_testdata[4410] */
    { 2205, 0x9E3779B1U, 0x7EF255DDU }, /* XSUM_XXH32_testdata[4411] */
    { 2206, 0x00000000U, 0xFED27284U }, /* XSUM_XXH32_testdata[4412] */
    { 2206, 0x9E3779B1U, 0x69255805U }, /* XSUM_XXH32_testdata[4413] */
    { 2207, 0x00000000U, 0xD708979EU }, /* XSUM_XXH32_testdata[4414] */
    { 2207, 0x9E3779B1U, 0xCDA17E54U }, /* XSUM_XXH32_testdata[4415] */
    { 2208, 0x00000000U, 0xA8550B50U }, /* XSUM_XXH32_testdata[4416] */
    { 2208, 0x9E3779B1U, 0x1F647E63U }, /* XSUM_XXH32_testdata[4417] */
    { 2209, 0x00000000U, 0x0B4BD972U }, /* XSUM_XXH32_testdata[4418] */
    { 2209, 0x9E3779B1U, 0x65BBC998U }, /* XSUM_XXH32_testdata[4419] */
    { 2210, 0x00000000U, 0x8ECE7003U }, /* XSUM_XXH32_testdata[4420] */
    { 2210, 0x9E3779B1U, 0x7929D7ABU }, /* XSUM_XXH32_testdata[4421] */
    { 2211, 0x00000000U, 0x321F41EDU }, /* XSUM_XXH32_testdata[4422] */
    { 2211, 0x9E3779B1U, 0x88B3A9FAU }, /* XSUM_XXH32_testdata[4423] */
    { 2212, 0x00000000U, 0x7FA5938FU }, /* XSUM_XXH32_testdata[4424] */
    { 2212, 0x9E3779B1U, 0xD1EC32D3U }, /* XSUM_XXH32_testdata[4425] */
    { 2213, 0x00000000U, 0x20819556U }, /* XSUM_XXH32_testdata[4426] */
    { 2213, 0x9E3779B1U, 0x609F550AU }, /* XSUM_XXH32_testdata[4427] */
    { 2214, 0x00000000U, 0xD257A8C1U }, /* XSUM_XXH32_testdata[4428] */
    { 2214, 0x9E3779B1U, 0x8C57DF62U }, /* XSUM_XXH32_testdata[4429] */
    { 2215, 0x00000000U, 0xF131CE75U }, /* XSUM_XXH32_testdata[4430] */
    { 2215, 0x9E3779B1U, 0xC2B31ED6U }, /* XSUM_XXH32_testdata[4431] */
    { 2216, 0x00000000U, 0x073FB52BU }, /* XSUM_XXH32_testdata[4432] */
    { 2216, 0x9E3779B1U, 0x308905ABU }, /* XSUM_XXH32_testdata[4433] */
    { 2217, 0x00000000U, 0x646B7573U }, /* XSUM_XXH32_testdata[4434] */
    { 2217, 0x9E3779B1U, 0x28DFBE07U }, /* XSUM_XXH32_testdata[4435] */
    { 2218, 0x00000000U, 0x5205F129U }, /* XSUM_XXH32_testdata[4436] */
    { 2218, 0x9E3779B1U, 0x5475F01BU }, /* XSUM_XXH32_testdata[4437] */
    { 2219, 0x00000000U, 0x03D8C19DU }, /* XSUM_XXH32_testdata[4438] */
    { 2219, 0x9E3779B1U, 0xCF68004DU }, /* XSUM_XXH32_testdata[4439] */
    { 2220, 0x00000000U, 0xDB6D9660U }, /* XSUM_XXH32_testdata[4440] */
    { 2220, 0x9E3779B1U, 0x66ADB310U }, /* XSUM_XXH32_testdata[4441] */
    { 2221, 0x00000000U, 0xEFD92A58U }, /* XSUM_XXH32_testdata[4442] */
    { 2221, 0x9E3779B1U, 0x93610C4FU }, /* XSUM_XXH32_testdata[4443] */
    { 2222, 0x00000000U, 0xB2F22C69U }, /* XSUM_XXH32_testdata[4444] */
    { 2222, 0x9E3779B1U, 0x20D78E8CU }, /* XSUM_XXH32_testdata[4445] */
    { 2223, 0x00000000U, 0xAB091A36U }, /* XSUM_XXH32_testdata[4446] */
    { 2223, 0x9E3779B1U, 0xD9C75461U }, /* XSUM_XXH32_testdata[4447] */
    { 2224, 0x00000000U, 0xAE997C55U }, /* XSUM_XXH32_testdata[4448] */
    { 2224, 0x9E3779B1U, 0xA8959027U }, /* XSUM_XXH32_testdata[4449] */
    { 2225, 0x00000000U, 0x7CB4E344U }, /* XSUM_XXH32_testdata[4450] */
    { 2225, 0x9E3779B1U, 0x13A10FFDU }, /* XSUM_XXH32_testdata[4451] */
    { 2226, 0x00000000U, 0x008888FBU }, /* XSUM_XXH32_testdata[4452] */
    { 2226, 0x9E3779B1U, 0xD1897F17U }, /* XSUM_XXH32_testdata[4453] */
    { 2227, 0x00000000U, 0xB6838035U }, /* XSUM_XXH32_testdata[4454] */
    { 2227, 0x9E3779B1U, 0xF7829F51U }, /* XSUM_XXH32_testdata[4455] */
    { 2228, 0x00000000U, 0xC4C87039U }, /* XSUM_XXH32_testdata[4456] */
    { 2228, 0x9E3779B1U, 0x47F00E7AU }, /* XSUM_XXH32_testdata[4457] */
    { 2229, 0x00000000U, 0xF6196C05U }, /* XSUM_XXH32_testdata[4458] */
    { 2229, 0x9E3779B1U, 0x07F98FD1U }, /* XSUM_XXH32_testdata[4459] */
    { 2230, 0x00000000U, 0xD717B53AU }, /* XSUM_XXH32_testdata[4460] */
    { 2230, 0x9E3779B1U, 0x88751237U }, /* XSUM_XXH32_testdata[4461] */
    { 2231, 0x00000000U, 0xEE206236U }, /* XSUM_XXH32_testdata[4462] */
    { 2231, 0x9E3779B1U, 0x9FD88083U }, /* XSUM_XXH32_testdata[4463] */
    { 2232, 0x00000000U, 0x20289B58U }, /* XSUM_XXH32_testdata[4464] */
    { 2232, 0x9E3779B1U, 0x5256A839U }, /* XSUM_XXH32_testdata[4465] */
    { 2233, 0x00000000U, 0xA031CD1CU }, /* XSUM_XXH32_testdata[4466] */
    { 2233, 0x9E3779B1U, 0x64590B58U }, /* XSUM_XXH32_testdata[4467] */
    { 2234, 0x00000000U, 0x2C82C500U }, /* XSUM_XXH32_testdata[4468] */
    { 2234, 0x9E3779B1U, 0x05802F24U }, /* XSUM_XXH32_testdata[4469] */
    { 2235, 0x00000000U, 0x7A008763U }, /* XSUM_XXH32_testdata[4470] */
    { 2235, 0x9E3779B1U, 0x99B6356BU }, /* XSUM_XXH32_testdata[4471] */
    { 2236, 0x00000000U, 0xF3EC5D8AU }, /* XSUM_XXH32_testdata[4472] */
    { 2236, 0x9E3779B1U, 0x51ACE959U }, /* XSUM_XXH32_testdata[4473] */
    { 2237, 0x00000000U, 0xC991D693U }, /* XSUM_XXH32_testdata[4474] */
    { 2237, 0x9E3779B1U, 0x298B272FU }, /* XSUM_XXH32_testdata[4475] */
    { 2238, 0x00000000U, 0x477DAD59U }, /* XSUM_XXH32_testdata[4476] */
    { 2238, 0x9E3779B1U, 0x012ADC64U }, /* XSUM_XXH32_testdata[4477] */
    { 2239, 0x00000000U, 0x9FBB59D9U }, /* XSUM_XXH32_testdata[4478] */
    { 2239, 0x9E3779B1U, 0x177BC5E0U }, /* XSUM_XXH32_testdata[4479] */
    { 2240, 0x00000000U, 0x59E4583DU }, /* XSUM_XXH32_testdata[4480] */
    { 2240, 0x9E3779B1U, 0x60DD71F3U }, /* XSUM_XXH32_testdata[4481] */
    { 2241, 0x00000000U, 0x2E8608B1U }, /* XSUM_XXH32_testdata[4482] */
    { 2241, 0x9E3779B1U, 0x10A1CA8BU }, /* XSUM_XXH32_testdata[4483] */
    { 2242, 0x00000000U, 0xA45E517FU }, /* XSUM_XXH32_testdata[4484] */
    { 2242, 0x9E3779B1U, 0x6C61A6D1U }, /* XSUM_XXH32_testdata[4485] */
    { 2243, 0x00000000U, 0x320E7EE7U }, /* XSUM_XXH32_testdata[4486] */
    { 2243, 0x9E3779B1U, 0x3B102816U }, /* XSUM_XXH32_testdata[4487] */
    { 2244, 0x00000000U, 0xBFF1F106U }, /* XSUM_XXH32_testdata[4488] */
    { 2244, 0x9E3779B1U, 0xF4E8F959U }, /* XSUM_XXH32_testdata[4489] */
    { 2245, 0x00000000U, 0xA2B49300U }, /* XSUM_XXH32_testdata[4490] */
    { 2245, 0x9E3779B1U, 0x659488D0U }, /* XSUM_XXH32_testdata[4491] */
    { 2246, 0x00000000U, 0xDCBC760EU }, /* XSUM_XXH32_testdata[4492] */
    { 2246, 0x9E3779B1U, 0xA95EAB52U }, /* XSUM_XXH32_testdata[4493] */
    { 2247, 0x00000000U, 0x4722715BU }, /* XSUM_XXH32_testdata[4494] */
    { 2247, 0x9E3779B1U, 0x741AC8D1U }, /* XSUM_XXH32_testdata[4495] */
    { 2248, 0x00000000U, 0x6C74A6C0U }, /* XSUM_XXH32_testdata[4496] */
    { 2248, 0x9E3779B1U, 0x9FD6C9D7U }, /* XSUM_XXH32_testdata[4497] */
    { 2249, 0x00000000U, 0x3CFE9D18U }, /* XSUM_XXH32_testdata[4498] */
    { 2249, 0x9E3779B1U, 0xE7E7597FU }, /* XSUM_XXH32_testdata[4499] */
    { 2250, 0x00000000U, 0x573EA547U }, /* XSUM_XXH32_testdata[4500] */
    { 2250, 0x9E3779B1U, 0x2FF14E69U }, /* XSUM_XXH32_testdata[4501] */
    { 2251, 0x00000000U, 0xEB0578DBU }, /* XSUM_XXH32_testdata[4502] */
    { 2251, 0x9E3779B1U, 0xA9E4F642U }, /* XSUM_XXH32_testdata[4503] */
    { 2252, 0x00000000U, 0xE69A2BBAU }, /* XSUM_XXH32_testdata[4504] */
    { 2252, 0x9E3779B1U, 0x7BADDE34U }, /* XSUM_XXH32_testdata[4505] */
    { 2253, 0x00000000U, 0x3A897C9BU }, /* XSUM_XXH32_testdata[4506] */
    { 2253, 0x9E3779B1U, 0x3A63B9D9U }, /* XSUM_XXH32_testdata[4507] */
    { 2254, 0x00000000U, 0x8C745A56U }, /* XSUM_XXH32_testdata[4508] */
    { 2254, 0x9E3779B1U, 0x3E75BE33U }, /* XSUM_XXH32_testdata[4509] */
    { 2255, 0x00000000U, 0x78A82E54U }, /* XSUM_XXH32_testdata[4510] */
    { 2255, 0x9E3779B1U, 0x54611400U }, /* XSUM_XXH32_testdata[4511] */
    { 2256, 0x00000000U, 0x7206E96CU }, /* XSUM_XXH32_testdata[4512] */
    { 2256, 0x9E3779B1U, 0x424F505DU }, /* XSUM_XXH32_testdata[4513] */
    { 2257, 0x00000000U, 0xA49636FBU }, /* XSUM_XXH32_testdata[4514] */
    { 2257, 0x9E3779B1U, 0xBD432C53U }, /* XSUM_XXH32_testdata[4515] */
    { 2258, 0x00000000U, 0x2D876C2EU }, /* XSUM_XXH32_testdata[4516] */
    { 2258, 0x9E3779B1U, 0x4EFD5C8EU }, /* XSUM_XXH32_testdata[4517] */
    { 2259, 0x00000000U, 0x2C02E2B2U }, /* XSUM_XXH32_testdata[4518] */
    { 2259, 0x9E3779B1U, 0x7300D02BU }, /* XSUM_XXH32_testdata[4519] */
    { 2260, 0x00000000U, 0x42BA6CC6U }, /* XSUM_XXH32_testdata[4520] */
    { 2260, 0x9E3779B1U, 0xF2036C3CU }, /* XSUM_XXH32_testdata[4521] */
    { 2261, 0x00000000U, 0x6AA72F1DU }, /* XSUM_XXH32_testdata[4522] */
    { 2261, 0x9E3779B1U, 0xE5959C13U }, /* XSUM_XXH32_testdata[4523] */
    { 2262, 0x00000000U, 0x93C4F084U }, /* XSUM_XXH32_testdata[4524] */
    { 2262, 0x9E3779B1U, 0x766A49E6U }, /* XSUM_XXH32_testdata[4525] */
    { 2263, 0x00000000U, 0x70D7F9C4U }, /* XSUM_XXH32_testdata[4526] */
    { 2263, 0x9E3779B1U, 0x6C15DAAFU }, /* XSUM_XXH32_testdata[4527] */
    { 2264, 0x00000000U, 0xC565B441U }, /* XSUM_XXH32_testdata[4528] */
    { 2264, 0x9E3779B1U, 0xAA9F3900U }, /* XSUM_XXH32_testdata[4529] */
    { 2265, 0x00000000U, 0x7462F69AU }, /* XSUM_XXH32_testdata[4530] */
    { 2265, 0x9E3779B1U, 0x6E3615C4U }, /* XSUM_XXH32_testdata[4531] */
    { 2266, 0x00000000U, 0x592C9892U }, /* XSUM_XXH32_testdata[4532] */
    { 2266, 0x9E3779B1U, 0xBC7837EEU }, /* XSUM_XXH32_testdata[4533] */
    { 2267, 0x00000000U, 0xEDF627B2U }, /* XSUM_XXH32_testdata[4534] */
    { 2267, 0x9E3779B1U, 0x448558C3U }, /* XSUM_XXH32_testdata[4535] */
    { 2268, 0x00000000U, 0xA8B7BC3BU }, /* XSUM_XXH32_testdata[4536] */
    { 2268, 0x9E3779B1U, 0x79DC8E55U }, /* XSUM_XXH32_testdata[4537] */
    { 2269, 0x00000000U, 0xB9BFE565U }, /* XSUM_XXH32_testdata[4538] */
    { 2269, 0x9E3779B1U, 0x6324D471U }, /* XSUM_XXH32_testdata[4539] */
    { 2270, 0x00000000U, 0x92F58D74U }, /* XSUM_XXH32_testdata[4540] */
    { 2270, 0x9E3779B1U, 0xBFC6C93CU }, /* XSUM_XXH32_testdata[4541] */
    { 2271, 0x00000000U, 0x4620E3A7U }, /* XSUM_XXH32_testdata[4542] */
    { 2271, 0x9E3779B1U, 0x24D8917CU }, /* XSUM_XXH32_testdata[4543] */
    { 2272, 0x00000000U, 0x2A361FAFU }, /* XSUM_XXH32_testdata[4544] */
    { 2272, 0x9E3779B1U, 0x6B84FA34U }, /* XSUM_XXH32_testdata[4545] */
    { 2273, 0x00000000U, 0x07FBAE52U }, /* XSUM_XXH32_testdata[4546] */
    { 2273, 0x9E3779B1U, 0x41ECD574U }, /* XSUM_XXH32_testdata[4547] */
    { 2274, 0x00000000U, 0x25316CD6U }, /* XSUM_XXH32_testdata[4548] */
    { 2274, 0x9E3779B1U, 0x980BECB7U }, /* XSUM_XXH32_testdata[4549] */
    { 2275, 0x00000000U, 0xA4C5373AU }, /* XSUM_XXH32_testdata[4550] */
    { 2275, 0x9E3779B1U, 0x39DB36E6U }, /* XSUM_XXH32_testdata[4551] */
    { 2276, 0x00000000U, 0x0A3648BBU }, /* XSUM_XXH32_testdata[4552] */
    { 2276, 0x9E3779B1U, 0x6F92247BU }, /* XSUM_XXH32_testdata[4553] */
    { 2277, 0x00000000U, 0x73337FA8U }, /* XSUM_XXH32_testdata[4554] */
    { 2277, 0x9E3779B1U, 0x4805FBC1U }, /* XSUM_XXH32_testdata[4555] */
    { 2278, 0x00000000U, 0x3D49A6E8U }, /* XSUM_XXH32_testdata[4556] */
    { 2278, 0x9E3779B1U, 0x6C7322F6U }, /* XSUM_XXH32_testdata[4557] */
    { 2279, 0x00000000U, 0x3338F5C0U }, /* XSUM_XXH32_testdata[4558] */
    { 2279, 0x9E3779B1U, 0x983C08C1U }, /* XSUM_XXH32_testdata[4559] */
    { 2280, 0x00000000U, 0x6EF8CFDAU }, /* XSUM_XXH32_testdata[4560] */
    { 2280, 0x9E3779B1U, 0xD70B484AU }, /* XSUM_XXH32_testdata[4561] */
    { 2281, 0x00000000U, 0x5A564CDFU }, /* XSUM_XXH32_testdata[4562] */
    { 2281, 0x9E3779B1U, 0x5C353DB4U }, /* XSUM_XXH32_testdata[4563] */
    { 2282, 0x00000000U, 0xC98A1064U }, /* XSUM_XXH32_testdata[4564] */
    { 2282, 0x9E3779B1U, 0x85EA76C6U }, /* XSUM_XXH32_testdata[4565] */
    { 2283, 0x00000000U, 0x8291CA32U }, /* XSUM_XXH32_testdata[4566] */
    { 2283, 0x9E3779B1U, 0x650EC76CU }, /* XSUM_XXH32_testdata[4567] */
    { 2284, 0x00000000U, 0xC3838346U }, /* XSUM_XXH32_testdata[4568] */
    { 2284, 0x9E3779B1U, 0x5C479DB6U }, /* XSUM_XXH32_testdata[4569] */
    { 2285, 0x00000000U, 0x2CA08A67U }, /* XSUM_XXH32_testdata[4570] */
    { 2285, 0x9E3779B1U, 0xF7340062U }, /* XSUM_XXH32_testdata[4571] */
    { 2286, 0x00000000U, 0x08745CDBU }, /* XSUM_XXH32_testdata[4572] */
    { 2286, 0x9E3779B1U, 0x06C8F4D1U }, /* XSUM_XXH32_testdata[4573] */
    { 2287, 0x00000000U, 0xA91F06E5U }, /* XSUM_XXH32_testdata[4574] */
    { 2287, 0x9E3779B1U, 0xC51815EFU }, /* XSUM_XXH32_testdata[4575] */
    { 2288, 0x00000000U, 0xA828DF5AU }, /* XSUM_XXH32_testdata[4576] */
    { 2288, 0x9E3779B1U, 0xD6CFD867U }, /* XSUM_XXH32_testdata[4577] */
    { 2289, 0x00000000U, 0x10695E42U }, /* XSUM_XXH32_testdata[4578] */
    { 2289, 0x9E3779B1U, 0xBE01DB37U }, /* XSUM_XXH32_testdata[4579] */
    { 2290, 0x00000000U, 0x9F7828BBU }, /* XSUM_XXH32_testdata[4580] */
    { 2290, 0x9E3779B1U, 0xB9766D05U }, /* XSUM_XXH32_testdata[4581] */
    { 2291, 0x00000000U, 0xEB54B2C6U }, /* XSUM_XXH32_testdata[4582] */
    { 2291, 0x9E3779B1U, 0x9D299329U }, /* XSUM_XXH32_testdata[4583] */
    { 2292, 0x00000000U, 0x1FC1F1CEU }, /* XSUM_XXH32_testdata[4584] */
    { 2292, 0x9E3779B1U, 0x76496642U }, /* XSUM_XXH32_testdata[4585] */
    { 2293, 0x00000000U, 0xB0C01399U }, /* XSUM_XXH32_testdata[4586] */
    { 2293, 0x9E3779B1U, 0x96F2E86AU }, /* XSUM_XXH32_testdata[4587] */
    { 2294, 0x00000000U, 0xFC0D7251U }, /* XSUM_XXH32_testdata[4588] */
    { 2294, 0x9E3779B1U, 0x6D2E955CU }, /* XSUM_XXH32_testdata[4589] */
    { 2295, 0x00000000U, 0x8391A466U }, /* XSUM_XXH32_testdata[4590] */
    { 2295, 0x9E3779B1U, 0x6F51DBCFU }, /* XSUM_XXH32_testdata[4591] */
    { 2296, 0x00000000U, 0x48546BE8U }, /* XSUM_XXH32_testdata[4592] */
    { 2296, 0x9E3779B1U, 0x5B47746BU }, /* XSUM_XXH32_testdata[4593] */
    { 2297, 0x00000000U, 0xB0BC78D8U }, /* XSUM_XXH32_testdata[4594] */
    { 2297, 0x9E3779B1U, 0xCFE99C9FU }, /* XSUM_XXH32_testdata[4595] */
    { 2298, 0x00000000U, 0x75CD83B5U }, /* XSUM_XXH32_testdata[4596] */
    { 2298, 0x9E3779B1U, 0x450083C7U }, /* XSUM_XXH32_testdata[4597] */
    { 2299, 0x00000000U, 0x38A051CDU }, /* XSUM_XXH32_testdata[4598] */
    { 2299, 0x9E3779B1U, 0xD4FB313FU }, /* XSUM_XXH32_testdata[4599] */
    { 2300, 0x00000000U, 0x99441C7FU }, /* XSUM_XXH32_testdata[4600] */
    { 2300, 0x9E3779B1U, 0x1CB8212EU }, /* XSUM_XXH32_testdata[4601] */
    { 2301, 0x00000000U, 0x0D53CF1BU }, /* XSUM_XXH32_testdata[4602] */
    { 2301, 0x9E3779B1U, 0x8A004DB5U }, /* XSUM_XXH32_testdata[4603] */
    { 2302, 0x00000000U, 0xCB001B0DU }, /* XSUM_XXH32_testdata[4604] */
    { 2302, 0x9E3779B1U, 0x00778E53U }, /* XSUM_XXH32_testdata[4605] */
    { 2303, 0x00000000U, 0xBA8260FAU }, /* XSUM_XXH32_testdata[4606] */
    { 2303, 0x9E3779B1U, 0x5F12DB08U }, /* XSUM_XXH32_testdata[4607] */
    { 2304, 0x00000000U, 0xBCEA8F53U }, /* XSUM_XXH32_testdata[4608] */
    { 2304, 0x9E3779B1U, 0x7B889175U }, /* XSUM_XXH32_testdata[4609] */
    { 2305, 0x00000000U, 0x430978EFU }, /* XSUM_XXH32_testdata[4610] */
    { 2305, 0x9E3779B1U, 0x8AF48587U }, /* XSUM_XXH32_testdata[4611] */
    { 2306, 0x00000000U, 0x8C6893DCU }, /* XSUM_XXH32_testdata[4612] */
    { 2306, 0x9E3779B1U, 0xA6C6D34CU }, /* XSUM_XXH32_testdata[4613] */
    { 2307, 0x00000000U, 0x50CD4BC8U }, /* XSUM_XXH32_testdata[4614] */
    { 2307, 0x9E3779B1U, 0x5B7B0AF5U }, /* XSUM_XXH32_testdata[4615] */
    { 2308, 0x00000000U, 0x41D30BF1U }, /* XSUM_XXH32_testdata[4616] */
    { 2308, 0x9E3779B1U, 0xF34044F6U }, /* XSUM_XXH32_testdata[4617] */
    { 2309, 0x00000000U, 0x76F916DAU }, /* XSUM_XXH32_testdata[4618] */
    { 2309, 0x9E3779B1U, 0xC7F44596U }, /* XSUM_XXH32_testdata[4619] */
    { 2310, 0x00000000U, 0x3EFDC8B8U }, /* XSUM_XXH32_testdata[4620] */
    { 2310, 0x9E3779B1U, 0x586BA8C0U }, /* XSUM_XXH32_testdata[4621] */
    { 2311, 0x00000000U, 0x7F910E8DU }, /* XSUM_XXH32_testdata[4622] */
    { 2311, 0x9E3779B1U, 0xBD823BCCU }, /* XSUM_XXH32_testdata[4623] */
    { 2312, 0x00000000U, 0xB6617DFAU }, /* XSUM_XXH32_testdata[4624] */
    { 2312, 0x9E3779B1U, 0x2C490E37U }, /* XSUM_XXH32_testdata[4625] */
    { 2313, 0x00000000U, 0x5DF58E40U }, /* XSUM_XXH32_testdata[4626] */
    { 2313, 0x9E3779B1U, 0xA92E5FDAU }, /* XSUM_XXH32_testdata[4627] */
    { 2314, 0x00000000U, 0x9129B3B7U }, /* XSUM_XXH32_testdata[4628] */
    { 2314, 0x9E3779B1U, 0x371184EFU }, /* XSUM_XXH32_testdata[4629] */
    { 2315, 0x00000000U, 0x708281D2U }, /* XSUM_XXH32_testdata[4630] */
    { 2315, 0x9E3779B1U, 0xE00BC470U }, /* XSUM_XXH32_testdata[4631] */
    { 2316, 0x00000000U, 0x88AEDFBCU }, /* XSUM_XXH32_testdata[4632] */
    { 2316, 0x9E3779B1U, 0x75F9331EU }, /* XSUM_XXH32_testdata[4633] */
    { 2317, 0x00000000U, 0x973A2135U }, /* XSUM_XXH32_testdata[4634] */
    { 2317, 0x9E3779B1U, 0x97C86A9FU }, /* XSUM_XXH32_testdata[4635] */
    { 2318, 0x00000000U, 0xEFABBB53U }, /* XSUM_XXH32_testdata[4636] */
    { 2318, 0x9E3779B1U, 0xD395FF0EU }, /* XSUM_XXH32_testdata[4637] */
    { 2319, 0x00000000U, 0x3636A669U }, /* XSUM_XXH32_testdata[4638] */
    { 2319, 0x9E3779B1U, 0x7DA41EAAU }, /* XSUM_XXH32_testdata[4639] */
    { 2320, 0x00000000U, 0xAF1B89BAU }, /* XSUM_XXH32_testdata[4640] */
    { 2320, 0x9E3779B1U, 0x2A4DF877U }, /* XSUM_XXH32_testdata[4641] */
    { 2321, 0x00000000U, 0x91C2F6A0U }, /* XSUM_XXH32_testdata[4642] */
    { 2321, 0x9E3779B1U, 0x8BCA9801U }, /* XSUM_XXH32_testdata[4643] */
    { 2322, 0x00000000U, 0x08CCBEC2U }, /* XSUM_XXH32_testdata[4644] */
    { 2322, 0x9E3779B1U, 0x7F838AB9U }, /* XSUM_XXH32_testdata[4645] */
    { 2323, 0x00000000U, 0x3E33B29BU }, /* XSUM_XXH32_testdata[4646] */
    { 2323, 0x9E3779B1U, 0xA247360BU }, /* XSUM_XXH32_testdata[4647] */
    { 2324, 0x00000000U, 0xCC83AD4AU }, /* XSUM_XXH32_testdata[4648] */
    { 2324, 0x9E3779B1U, 0xBD508C8CU }, /* XSUM_XXH32_testdata[4649] */
    { 2325, 0x00000000U, 0x809318BEU }, /* XSUM_XXH32_testdata[4650] */
    { 2325, 0x9E3779B1U, 0x95AF3438U }, /* XSUM_XXH32_testdata[4651] */
    { 2326, 0x00000000U, 0x4D8E2E9AU }, /* XSUM_XXH32_testdata[4652] */
    { 2326, 0x9E3779B1U, 0xA6FA96D0U }, /* XSUM_XXH32_testdata[4653] */
    { 2327, 0x00000000U, 0xA07CA81CU }, /* XSUM_XXH32_testdata[4654] */
    { 2327, 0x9E3779B1U, 0x499D93B5U }, /* XSUM_XXH32_testdata[4655] */
    { 2328, 0x00000000U, 0xA6470A51U }, /* XSUM_XXH32_testdata[4656] */
    { 2328, 0x9E3779B1U, 0x26ED845DU }, /* XSUM_XXH32_testdata[4657] */
    { 2329, 0x00000000U, 0x1C554C77U }, /* XSUM_XXH32_testdata[4658] */
    { 2329, 0x9E3779B1U, 0xB3627F76U }, /* XSUM_XXH32_testdata[4659] */
    { 2330, 0x00000000U, 0x7AAD0FF8U }, /* XSUM_XXH32_testdata[4660] */
    { 2330, 0x9E3779B1U, 0xBBA8C728U }, /* XSUM_XXH32_testdata[4661] */
    { 2331, 0x00000000U, 0x5A567C6FU }, /* XSUM_XXH32_testdata[4662] */
    { 2331, 0x9E3779B1U, 0x5A06BE2FU }, /* XSUM_XXH32_testdata[4663] */
    { 2332, 0x00000000U, 0x6BA98891U }, /* XSUM_XXH32_testdata[4664] */
    { 2332, 0x9E3779B1U, 0x205C0FE4U }, /* XSUM_XXH32_testdata[4665] */
    { 2333, 0x00000000U, 0x82522B2BU }, /* XSUM_XXH32_testdata[4666] */
    { 2333, 0x9E3779B1U, 0x076C9707U }, /* XSUM_XXH32_testdata[4667] */
    { 2334, 0x00000000U, 0x4DC1958BU }, /* XSUM_XXH32_testdata[4668] */
    { 2334, 0x9E3779B1U, 0xFA396A37U }, /* XSUM_XXH32_testdata[4669] */
    { 2335, 0x00000000U, 0x3AC57A52U }, /* XSUM_XXH32_testdata[4670] */
    { 2335, 0x9E3779B1U, 0xF12C465AU }, /* XSUM_XXH32_testdata[4671] */
    { 2336, 0x00000000U, 0xE3B1A4E8U }, /* XSUM_XXH32_testdata[4672] */
    { 2336, 0x9E3779B1U, 0x12C0298BU }, /* XSUM_XXH32_testdata[4673] */
    { 2337, 0x00000000U, 0xF44984F1U }, /* XSUM_XXH32_testdata[4674] */
    { 2337, 0x9E3779B1U, 0xB4DFA682U }, /* XSUM_XXH32_testdata[4675] */
    { 2338, 0x00000000U, 0x2FFF7824U }, /* XSUM_XXH32_testdata[4676] */
    { 2338, 0x9E3779B1U, 0x0973012BU }, /* XSUM_XXH32_testdata[4677] */
    { 2339, 0x00000000U, 0x30EC8C56U }, /* XSUM_XXH32_testdata[4678] */
    { 2339, 0x9E3779B1U, 0x2F7B75ADU }, /* XSUM_XXH32_testdata[4679] */
    { 2340, 0x00000000U, 0x781E8077U }, /* XSUM_XXH32_testdata[4680] */
    { 2340, 0x9E3779B1U, 0x4D1F9FE6U }, /* XSUM_XXH32_testdata[4681] */
    { 2341, 0x00000000U, 0xA7CA3DBCU }, /* XSUM_XXH32_testdata[4682] */
    { 2341, 0x9E3779B1U, 0x63A36898U }, /* XSUM_XXH32_testdata[4683] */
    { 2342, 0x00000000U, 0x8ADA3F4CU }, /* XSUM_XXH32_testdata[4684] */
    { 2342, 0x9E3779B1U, 0x81C0BBB3U }, /* XSUM_XXH32_testdata[4685] */
    { 2343, 0x00000000U, 0x8B054AC2U }, /* XSUM_XXH32_testdata[4686] */
    { 2343, 0x9E3779B1U, 0x0AF990F3U }, /* XSUM_XXH32_testdata[4687] */
    { 2344, 0x00000000U, 0x92205A23U }, /* XSUM_XXH32_testdata[4688] */
    { 2344, 0x9E3779B1U, 0x03054242U }, /* XSUM_XXH32_testdata[4689] */
    { 2345, 0x00000000U, 0xA6BE0EF5U }, /* XSUM_XXH32_testdata[4690] */
    { 2345, 0x9E3779B1U, 0xC5D4391DU }, /* XSUM_XXH32_testdata[4691] */
    { 2346, 0x00000000U, 0x401B0499U }, /* XSUM_XXH32_testdata[4692] */
    { 2346, 0x9E3779B1U, 0x7A70E3F5U }, /* XSUM_XXH32_testdata[4693] */
    { 2347, 0x00000000U, 0x061FF802U }, /* XSUM_XXH32_testdata[4694] */
    { 2347, 0x9E3779B1U, 0xF2EFAAA5U }, /* XSUM_XXH32_testdata[4695] */
    { 2348, 0x00000000U, 0xB9A50735U }, /* XSUM_XXH32_testdata[4696] */
    { 2348, 0x9E3779B1U, 0x07B543A3U }, /* XSUM_XXH32_testdata[4697] */
    { 2349, 0x00000000U, 0xD42FE578U }, /* XSUM_XXH32_testdata[4698] */
    { 2349, 0x9E3779B1U, 0x4B6ED460U }, /* XSUM_XXH32_testdata[4699] */
    { 2350, 0x00000000U, 0x48ABC923U }, /* XSUM_XXH32_testdata[4700] */
    { 2350, 0x9E3779B1U, 0x3FDAD781U }, /* XSUM_XXH32_testdata[4701] */
    { 2351, 0x00000000U, 0xA1FA455DU }, /* XSUM_XXH32_testdata[4702] */
    { 2351, 0x9E3779B1U, 0xAC421C38U }, /* XSUM_XXH32_testdata[4703] */
    { 2352, 0x00000000U, 0xF214EB71U }, /* XSUM_XXH32_testdata[4704] */
    { 2352, 0x9E3779B1U, 0xE112B0D4U }, /* XSUM_XXH32_testdata[4705] */
    { 2353, 0x00000000U, 0x8B75B819U }, /* XSUM_XXH32_testdata[4706] */
    { 2353, 0x9E3779B1U, 0x5586B7DDU }, /* XSUM_XXH32_testdata[4707] */
    { 2354, 0x00000000U, 0x205A741CU }, /* XSUM_XXH32_testdata[4708] */
    { 2354, 0x9E3779B1U, 0xC87CB465U }, /* XSUM_XXH32_testdata[4709] */
    { 2355, 0x00000000U, 0xD12DC954U }, /* XSUM_XXH32_testdata[4710] */
    { 2355, 0x9E3779B1U, 0x7DB71299U }, /* XSUM_XXH32_testdata[4711] */
    { 2356, 0x00000000U, 0xA9F34CF6U }, /* XSUM_XXH32_testdata[4712] */
    { 2356, 0x9E3779B1U, 0x7B5908E5U }, /* XSUM_XXH32_testdata[4713] */
    { 2357, 0x00000000U, 0xE634B0E9U }, /* XSUM_XXH32_testdata[4714] */
    { 2357, 0x9E3779B1U, 0x6FDD888DU }, /* XSUM_XXH32_testdata[4715] */
    { 2358, 0x00000000U, 0x31C599C4U }, /* XSUM_XXH32_testdata[4716] */
    { 2358, 0x9E3779B1U, 0x866EAF3AU }, /* XSUM_XXH32_testdata[4717] */
    { 2359, 0x00000000U, 0xE0989B24U }, /* XSUM_XXH32_testdata[4718] */
    { 2359, 0x9E3779B1U, 0xA981AD4FU }, /* XSUM_XXH32_testdata[4719] */
    { 2360, 0x00000000U, 0x6D387974U }, /* XSUM_XXH32_testdata[4720] */
    { 2360, 0x9E3779B1U, 0xF2454878U }, /* XSUM_XXH32_testdata[4721] */
    { 2361, 0x00000000U, 0xC2E39A3FU }, /* XSUM_XXH32_testdata[4722] */
    { 2361, 0x9E3779B1U, 0xFD5459E5U }, /* XSUM_XXH32_testdata[4723] */
    { 2362, 0x00000000U, 0x323EB5EBU }, /* XSUM_XXH32_testdata[4724] */
    { 2362, 0x9E3779B1U, 0xE74DCA8CU }, /* XSUM_XXH32_testdata[4725] */
    { 2363, 0x00000000U, 0x2CECE601U }, /* XSUM_XXH32_testdata[4726] */
    { 2363, 0x9E3779B1U, 0x36CD01FEU }, /* XSUM_XXH32_testdata[4727] */
    { 2364, 0x00000000U, 0x66FEC502U }, /* XSUM_XXH32_testdata[4728] */
    { 2364, 0x9E3779B1U, 0x4B2D4558U }, /* XSUM_XXH32_testdata[4729] */
    { 2365, 0x00000000U, 0x14B0C970U }, /* XSUM_XXH32_testdata[4730] */
    { 2365, 0x9E3779B1U, 0x0B4936DAU }, /* XSUM_XXH32_testdata[4731] */
    { 2366, 0x00000000U, 0xF0060AE0U }, /* XSUM_XXH32_testdata[4732] */
    { 2366, 0x9E3779B1U, 0x2654E924U }, /* XSUM_XXH32_testdata[4733] */
    { 2367, 0x00000000U, 0x4C8A9773U }, /* XSUM_XXH32_testdata[4734] */
    { 2367, 0x9E3779B1U, 0x6D5366F6U }, /* XSUM_XXH32_testdata[4735] */
    { 2368, 0x00000000U, 0xF548E34BU }, /* XSUM_XXH32_testdata[4736] */
    { 2368, 0x9E3779B1U, 0xE7AD6B44U }, /* XSUM_XXH32_testdata[4737] */
    { 2369, 0x00000000U, 0x65D503DFU }, /* XSUM_XXH32_testdata[4738] */
    { 2369, 0x9E3779B1U, 0x5BDF6961U }, /* XSUM_XXH32_testdata[4739] */
    { 2370, 0x00000000U, 0x5F26B595U }, /* XSUM_XXH32_testdata[4740] */
    { 2370, 0x9E3779B1U, 0x14CE703BU }, /* XSUM_XXH32_testdata[4741] */
    { 2371, 0x00000000U, 0xF0A01EDFU }, /* XSUM_XXH32_testdata[4742] */
    { 2371, 0x9E3779B1U, 0xB6258CA7U }, /* XSUM_XXH32_testdata[4743] */
    { 2372, 0x00000000U, 0xC0D4B27DU }, /* XSUM_XXH32_testdata[4744] */
    { 2372, 0x9E3779B1U, 0x0D321D6CU }, /* XSUM_XXH32_testdata[4745] */
    { 2373, 0x00000000U, 0xB6AB63B0U }, /* XSUM_XXH32_testdata[4746] */
    { 2373, 0x9E3779B1U, 0x7896B7C8U }, /* XSUM_XXH32_testdata[4747] */
    { 2374, 0x00000000U, 0x419BDBEBU }, /* XSUM_XXH32_testdata[4748] */
    { 2374, 0x9E3779B1U, 0xC9C20BCEU }, /* XSUM_XXH32_testdata[4749] */
    { 2375, 0x00000000U, 0x3AAF5C47U }, /* XSUM_XXH32_testdata[4750] */
    { 2375, 0x9E3779B1U, 0x1D6C7324U }, /* XSUM_XXH32_testdata[4751] */
    { 2376, 0x00000000U, 0xA02F14DBU }, /* XSUM_XXH32_testdata[4752] */
    { 2376, 0x9E3779B1U, 0x97305628U }, /* XSUM_XXH32_testdata[4753] */
    { 2377, 0x00000000U, 0x2446F15EU }, /* XSUM_XXH32_testdata[4754] */
    { 2377, 0x9E3779B1U, 0x990E91A9U }, /* XSUM_XXH32_testdata[4755] */
    { 2378, 0x00000000U, 0xBFF1B80DU }, /* XSUM_XXH32_testdata[4756] */
    { 2378, 0x9E3779B1U, 0x207555C6U }, /* XSUM_XXH32_testdata[4757] */
    { 2379, 0x00000000U, 0xCBB9DE50U }, /* XSUM_XXH32_testdata[4758] */
    { 2379, 0x9E3779B1U, 0x7C35E937U }, /* XSUM_XXH32_testdata[4759] */
    { 2380, 0x00000000U, 0xB16132E9U }, /* XSUM_XXH32_testdata[4760] */
    { 2380, 0x9E3779B1U, 0x612C4735U }, /* XSUM_XXH32_testdata[4761] */
    { 2381, 0x00000000U, 0xFA94BF99U }, /* XSUM_XXH32_testdata[4762] */
    { 2381, 0x9E3779B1U, 0xCB323A7DU }, /* XSUM_XXH32_testdata[4763] */
    { 2382, 0x00000000U, 0x66E1CCFEU }, /* XSUM_XXH32_testdata[4764] */
    { 2382, 0x9E3779B1U, 0x6172EACFU }, /* XSUM_XXH32_testdata[4765] */
    { 2383, 0x00000000U, 0x0DBA1027U }, /* XSUM_XXH32_testdata[4766] */
    { 2383, 0x9E3779B1U, 0x32B3A053U }, /* XSUM_XXH32_testdata[4767] */
    { 2384, 0x00000000U, 0x2A061A21U }, /* XSUM_XXH32_testdata[4768] */
    { 2384, 0x9E3779B1U, 0x63842046U }, /* XSUM_XXH32_testdata[4769] */
    { 2385, 0x00000000U, 0x31F706D8U }, /* XSUM_XXH32_testdata[4770] */
    { 2385, 0x9E3779B1U, 0x07065BDDU }, /* XSUM_XXH32_testdata[4771] */
    { 2386, 0x00000000U, 0xC89FFCF2U }, /* XSUM_XXH32_testdata[4772] */
    { 2386, 0x9E3779B1U, 0x380EB6D6U }, /* XSUM_XXH32_testdata[4773] */
    { 2387, 0x00000000U, 0x3ED8B0B0U }, /* XSUM_XXH32_testdata[4774] */
    { 2387, 0x9E3779B1U, 0xC87C9DA2U }, /* XSUM_XXH32_testdata[4775] */
    { 2388, 0x00000000U, 0x9166C2BDU }, /* XSUM_XXH32_testdata[4776] */
    { 2388, 0x9E3779B1U, 0x06CECF8AU }, /* XSUM_XXH32_testdata[4777] */
    { 2389, 0x00000000U, 0xE525B308U }, /* XSUM_XXH32_testdata[4778] */
    { 2389, 0x9E3779B1U, 0x20A21E29U }, /* XSUM_XXH32_testdata[4779] */
    { 2390, 0x00000000U, 0x7D3019E4U }, /* XSUM_XXH32_testdata[4780] */
    { 2390, 0x9E3779B1U, 0x0292C707U }, /* XSUM_XXH32_testdata[4781] */
    { 2391, 0x00000000U, 0x13B25959U }, /* XSUM_XXH32_testdata[4782] */
    { 2391, 0x9E3779B1U, 0xDAC018B5U }, /* XSUM_XXH32_testdata[4783] */
    { 2392, 0x00000000U, 0x162AD860U }, /* XSUM_XXH32_testdata[4784] */
    { 2392, 0x9E3779B1U, 0xB87FE27AU }, /* XSUM_XXH32_testdata[4785] */
    { 2393, 0x00000000U, 0x561FA10DU }, /* XSUM_XXH32_testdata[4786] */
    { 2393, 0x9E3779B1U, 0x7B07FDEAU }, /* XSUM_XXH32_testdata[4787] */
    { 2394, 0x00000000U, 0xD874B0F3U }, /* XSUM_XXH32_testdata[4788] */
    { 2394, 0x9E3779B1U, 0xA6E4675DU }, /* XSUM_XXH32_testdata[4789] */
    { 2395, 0x00000000U, 0x6C94309CU }, /* XSUM_XXH32_testdata[4790] */
    { 2395, 0x9E3779B1U, 0x236ED104U }, /* XSUM_XXH32_testdata[4791] */
    { 2396, 0x00000000U, 0xA0EEE992U }, /* XSUM_XXH32_testdata[4792] */
    { 2396, 0x9E3779B1U, 0x91A0C722U }, /* XSUM_XXH32_testdata[4793] */
    { 2397, 0x00000000U, 0x0C399ADAU }, /* XSUM_XXH32_testdata[4794] */
    { 2397, 0x9E3779B1U, 0xA7F1A6D5U }, /* XSUM_XXH32_testdata[4795] */
    { 2398, 0x00000000U, 0x378368A6U }, /* XSUM_XXH32_testdata[4796] */
    { 2398, 0x9E3779B1U, 0x0C3AB8E1U }, /* XSUM_XXH32_testdata[4797] */
    { 2399, 0x00000000U, 0xA358B395U }, /* XSUM_XXH32_testdata[4798] */
    { 2399, 0x9E3779B1U, 0x6FFB1BA8U }, /* XSUM_XXH32_testdata[4799] */
    { 2400, 0x00000000U, 0x70C3BAC4U }, /* XSUM_XXH32_testdata[4800] */
    { 2400, 0x9E3779B1U, 0x12C956F8U }, /* XSUM_XXH32_testdata[4801] */
    { 2401, 0x00000000U, 0xF80E72F2U }, /* XSUM_XXH32_testdata[4802] */
    { 2401, 0x9E3779B1U, 0x68936275U }, /* XSUM_XXH32_testdata[4803] */
    { 2402, 0x00000000U, 0x27E902BBU }, /* XSUM_XXH32_testdata[4804] */
    { 2402, 0x9E3779B1U, 0xDCEBAE57U }, /* XSUM_XXH32_testdata[4805] */
    { 2403, 0x00000000U, 0x0A2F00E2U }, /* XSUM_XXH32_testdata[4806] */
    { 2403, 0x9E3779B1U, 0x5134A646U }, /* XSUM_XXH32_testdata[4807] */
    { 2404, 0x00000000U, 0x7EAA4C6BU }, /* XSUM_XXH32_testdata[4808] */
    { 2404, 0x9E3779B1U, 0x0EFC5F02U }, /* XSUM_XXH32_testdata[4809] */
    { 2405, 0x00000000U, 0xF19F7631U }, /* XSUM_XXH32_testdata[4810] */
    { 2405, 0x9E3779B1U, 0x2033E2E1U }, /* XSUM_XXH32_testdata[4811] */
    { 2406, 0x00000000U, 0x5CA90E57U }, /* XSUM_XXH32_testdata[4812] */
    { 2406, 0x9E3779B1U, 0x795BF9ECU }, /* XSUM_XXH32_testdata[4813] */
    { 2407, 0x00000000U, 0xD113AA64U }, /* XSUM_XXH32_testdata[4814] */
    { 2407, 0x9E3779B1U, 0x79177ACFU }, /* XSUM_XXH32_testdata[4815] */
    { 2408, 0x00000000U, 0x50F9A43DU }, /* XSUM_XXH32_testdata[4816] */
    { 2408, 0x9E3779B1U, 0x7E3349F4U }, /* XSUM_XXH32_testdata[4817] */
    { 2409, 0x00000000U, 0x027C208DU }, /* XSUM_XXH32_testdata[4818] */
    { 2409, 0x9E3779B1U, 0x88EE986EU }, /* XSUM_XXH32_testdata[4819] */
    { 2410, 0x00000000U, 0xC32D3332U }, /* XSUM_XXH32_testdata[4820] */
    { 2410, 0x9E3779B1U, 0x34A75026U }, /* XSUM_XXH32_testdata[4821] */
    { 2411, 0x00000000U, 0x17E590DCU }, /* XSUM_XXH32_testdata[4822] */
    { 2411, 0x9E3779B1U, 0x63890C5BU }, /* XSUM_XXH32_testdata[4823] */
    { 2412, 0x00000000U, 0x5BC68CEDU }, /* XSUM_XXH32_testdata[4824] */
    { 2412, 0x9E3779B1U, 0x670759F6U }, /* XSUM_XXH32_testdata[4825] */
    { 2413, 0x00000000U, 0x657E7361U }, /* XSUM_XXH32_testdata[4826] */
    { 2413, 0x9E3779B1U, 0x14D537A3U }, /* XSUM_XXH32_testdata[4827] */
    { 2414, 0x00000000U, 0x85686695U }, /* XSUM_XXH32_testdata[4828] */
    { 2414, 0x9E3779B1U, 0xF128E84EU }, /* XSUM_XXH32_testdata[4829] */
    { 2415, 0x00000000U, 0xC665F573U }, /* XSUM_XXH32_testdata[4830] */
    { 2415, 0x9E3779B1U, 0x17C0AB75U }, /* XSUM_XXH32_testdata[4831] */
    { 2416, 0x00000000U, 0xF1043438U }, /* XSUM_XXH32_testdata[4832] */
    { 2416, 0x9E3779B1U, 0x201D2400U }, /* XSUM_XXH32_testdata[4833] */
    { 2417, 0x00000000U, 0xAF8760FDU }, /* XSUM_XXH32_testdata[4834] */
    { 2417, 0x9E3779B1U, 0xC37A051BU }, /* XSUM_XXH32_testdata[4835] */
    { 2418, 0x00000000U, 0xFE2E7C31U }, /* XSUM_XXH32_testdata[4836] */
    { 2418, 0x9E3779B1U, 0x81779EAFU }, /* XSUM_XXH32_testdata[4837] */
    { 2419, 0x00000000U, 0xE509F698U }, /* XSUM_XXH32_testdata[4838] */
    { 2419, 0x9E3779B1U, 0xD50B9B0CU }, /* XSUM_XXH32_testdata[4839] */
    { 2420, 0x00000000U, 0x5081BD39U }, /* XSUM_XXH32_testdata[4840] */
    { 2420, 0x9E3779B1U, 0x8FC0450BU }, /* XSUM_XXH32_testdata[4841] */
    { 2421, 0x00000000U, 0x81C008F1U }, /* XSUM_XXH32_testdata[4842] */
    { 2421, 0x9E3779B1U, 0xAEB2E7F2U }, /* XSUM_XXH32_testdata[4843] */
    { 2422, 0x00000000U, 0x4AE97E0DU }, /* XSUM_XXH32_testdata[4844] */
    { 2422, 0x9E3779B1U, 0xF3C343F8U }, /* XSUM_XXH32_testdata[4845] */
    { 2423, 0x00000000U, 0x607DFFD1U }, /* XSUM_XXH32_testdata[4846] */
    { 2423, 0x9E3779B1U, 0x9E312A8EU }, /* XSUM_XXH32_testdata[4847] */
    { 2424, 0x00000000U, 0xEC94619AU }, /* XSUM_XXH32_testdata[4848] */
    { 2424, 0x9E3779B1U, 0xD8ACEDE4U }, /* XSUM_XXH32_testdata[4849] */
    { 2425, 0x00000000U, 0x43825EDBU }, /* XSUM_XXH32_testdata[4850] */
    { 2425, 0x9E3779B1U, 0x84833C10U }, /* XSUM_XXH32_testdata[4851] */
    { 2426, 0x00000000U, 0x9C339CC3U }, /* XSUM_XXH32_testdata[4852] */
    { 2426, 0x9E3779B1U, 0x8336AA1BU }, /* XSUM_XXH32_testdata[4853] */
    { 2427, 0x00000000U, 0xC27DE396U }, /* XSUM_XXH32_testdata[4854] */
    { 2427, 0x9E3779B1U, 0xF97DAA8BU }, /* XSUM_XXH32_testdata[4855] */
    { 2428, 0x00000000U, 0x2F3248A4U }, /* XSUM_XXH32_testdata[4856] */
    { 2428, 0x9E3779B1U, 0xC713E2CEU }, /* XSUM_XXH32_testdata[4857] */
    { 2429, 0x00000000U, 0x4540EC38U }, /* XSUM_XXH32_testdata[4858] */
    { 2429, 0x9E3779B1U, 0xEC4D25B6U }, /* XSUM_XXH32_testdata[4859] */
    { 2430, 0x00000000U, 0xA05E2C3AU }, /* XSUM_XXH32_testdata[4860] */
    { 2430, 0x9E3779B1U, 0x9921546BU }, /* XSUM_XXH32_testdata[4861] */
    { 2431, 0x00000000U, 0x810A1384U }, /* XSUM_XXH32_testdata[4862] */
    { 2431, 0x9E3779B1U, 0x50C98DB6U }, /* XSUM_XXH32_testdata[4863] */
    { 2432, 0x00000000U, 0x7FB4B17BU }, /* XSUM_XXH32_testdata[4864] */
    { 2432, 0x9E3779B1U, 0xF241483CU }, /* XSUM_XXH32_testdata[4865] */
    { 2433, 0x00000000U, 0x0D389605U }, /* XSUM_XXH32_testdata[4866] */
    { 2433, 0x9E3779B1U, 0xBC07E8A4U }, /* XSUM_XXH32_testdata[4867] */
    { 2434, 0x00000000U, 0x168C2350U }, /* XSUM_XXH32_testdata[4868] */
    { 2434, 0x9E3779B1U, 0x8801D1ABU }, /* XSUM_XXH32_testdata[4869] */
    { 2435, 0x00000000U, 0x5283B60CU }, /* XSUM_XXH32_testdata[4870] */
    { 2435, 0x9E3779B1U, 0x10E4870AU }, /* XSUM_XXH32_testdata[4871] */
    { 2436, 0x00000000U, 0x0421D54CU }, /* XSUM_XXH32_testdata[4872] */
    { 2436, 0x9E3779B1U, 0x6E3B449BU }, /* XSUM_XXH32_testdata[4873] */
    { 2437, 0x00000000U, 0x5361F4CCU }, /* XSUM_XXH32_testdata[4874] */
    { 2437, 0x9E3779B1U, 0xFB59F19CU }, /* XSUM_XXH32_testdata[4875] */
    { 2438, 0x00000000U, 0x20D19D1FU }, /* XSUM_XXH32_testdata[4876] */
    { 2438, 0x9E3779B1U, 0x2893EAC6U }, /* XSUM_XXH32_testdata[4877] */
    { 2439, 0x00000000U, 0xDE177718U }, /* XSUM_XXH32_testdata[4878] */
    { 2439, 0x9E3779B1U, 0x3EB39364U }, /* XSUM_XXH32_testdata[4879] */
    { 2440, 0x00000000U, 0xE79B2719U }, /* XSUM_XXH32_testdata[4880] */
    { 2440, 0x9E3779B1U, 0x312643B1U }, /* XSUM_XXH32_testdata[4881] */
    { 2441, 0x00000000U, 0x4F5DFDF0U }, /* XSUM_XXH32_testdata[4882] */
    { 2441, 0x9E3779B1U, 0xED612CE1U }, /* XSUM_XXH32_testdata[4883] */
    { 2442, 0x00000000U, 0x95180588U }, /* XSUM_XXH32_testdata[4884] */
    { 2442, 0x9E3779B1U, 0x88F3CABEU }, /* XSUM_XXH32_testdata[4885] */
    { 2443, 0x00000000U, 0x0C0F7A4DU }, /* XSUM_XXH32_testdata[4886] */
    { 2443, 0x9E3779B1U, 0x2ED4F445U }, /* XSUM_XXH32_testdata[4887] */
    { 2444, 0x00000000U, 0xB880E238U }, /* XSUM_XXH32_testdata[4888] */
    { 2444, 0x9E3779B1U, 0x40A637ABU }, /* XSUM_XXH32_testdata[4889] */
    { 2445, 0x00000000U, 0xAD670B07U }, /* XSUM_XXH32_testdata[4890] */
    { 2445, 0x9E3779B1U, 0x11F26435U }, /* XSUM_XXH32_testdata[4891] */
    { 2446, 0x00000000U, 0x56C94B98U }, /* XSUM_XXH32_testdata[4892] */
    { 2446, 0x9E3779B1U, 0x60504FB2U }, /* XSUM_XXH32_testdata[4893] */
    { 2447, 0x00000000U, 0x076B6ABDU }, /* XSUM_XXH32_testdata[4894] */
    { 2447, 0x9E3779B1U, 0x642D3A22U }, /* XSUM_XXH32_testdata[4895] */
    { 2448, 0x00000000U, 0xBDCE2439U }, /* XSUM_XXH32_testdata[4896] */
    { 2448, 0x9E3779B1U, 0x7F00BA89U }, /* XSUM_XXH32_testdata[4897] */
    { 2449, 0x00000000U, 0xDFAAF476U }, /* XSUM_XXH32_testdata[4898] */
    { 2449, 0x9E3779B1U, 0x050B1532U }, /* XSUM_XXH32_testdata[4899] */
    { 2450, 0x00000000U, 0x1F1C1A57U }, /* XSUM_XXH32_testdata[4900] */
    { 2450, 0x9E3779B1U, 0xCDB6FD63U }, /* XSUM_XXH32_testdata[4901] */
    { 2451, 0x00000000U, 0xF823D563U }, /* XSUM_XXH32_testdata[4902] */
    { 2451, 0x9E3779B1U, 0xCA835153U }, /* XSUM_XXH32_testdata[4903] */
    { 2452, 0x00000000U, 0x51B522C4U }, /* XSUM_XXH32_testdata[4904] */
    { 2452, 0x9E3779B1U, 0x45900CF0U }, /* XSUM_XXH32_testdata[4905] */
    { 2453, 0x00000000U, 0x5235F781U }, /* XSUM_XXH32_testdata[4906] */
    { 2453, 0x9E3779B1U, 0x2D5AA19FU }, /* XSUM_XXH32_testdata[4907] */
    { 2454, 0x00000000U, 0x18BAE005U }, /* XSUM_XXH32_testdata[4908] */
    { 2454, 0x9E3779B1U, 0x6C048095U }, /* XSUM_XXH32_testdata[4909] */
    { 2455, 0x00000000U, 0x3AA89246U }, /* XSUM_XXH32_testdata[4910] */
    { 2455, 0x9E3779B1U, 0x38AE9554U }, /* XSUM_XXH32_testdata[4911] */
    { 2456, 0x00000000U, 0x69D553FFU }, /* XSUM_XXH32_testdata[4912] */
    { 2456, 0x9E3779B1U, 0xC31AA130U }, /* XSUM_XXH32_testdata[4913] */
    { 2457, 0x00000000U, 0xABCFC613U }, /* XSUM_XXH32_testdata[4914] */
    { 2457, 0x9E3779B1U, 0x1CFCC09FU }, /* XSUM_XXH32_testdata[4915] */
    { 2458, 0x00000000U, 0xDEFD37F7U }, /* XSUM_XXH32_testdata[4916] */
    { 2458, 0x9E3779B1U, 0x3D2B931EU }, /* XSUM_XXH32_testdata[4917] */
    { 2459, 0x00000000U, 0xC766C583U }, /* XSUM_XXH32_testdata[4918] */
    { 2459, 0x9E3779B1U, 0xF614CE02U }, /* XSUM_XXH32_testdata[4919] */
    { 2460, 0x00000000U, 0x354DE099U }, /* XSUM_XXH32_testdata[4920] */
    { 2460, 0x9E3779B1U, 0xD92DE3CEU }, /* XSUM_XXH32_testdata[4921] */
    { 2461, 0x00000000U, 0x672C6106U }, /* XSUM_XXH32_testdata[4922] */
    { 2461, 0x9E3779B1U, 0x1EB302CBU }, /* XSUM_XXH32_testdata[4923] */
    { 2462, 0x00000000U, 0xBB87002CU }, /* XSUM_XXH32_testdata[4924] */
    { 2462, 0x9E3779B1U, 0x0CFF9B2CU }, /* XSUM_XXH32_testdata[4925] */
    { 2463, 0x00000000U, 0x8E000EEEU }, /* XSUM_XXH32_testdata[4926] */
    { 2463, 0x9E3779B1U, 0x38A79CF8U }, /* XSUM_XXH32_testdata[4927] */
    { 2464, 0x00000000U, 0x690461FCU }, /* XSUM_XXH32_testdata[4928] */
    { 2464, 0x9E3779B1U, 0x2B4836B0U }, /* XSUM_XXH32_testdata[4929] */
    { 2465, 0x00000000U, 0xEEF46B6CU }, /* XSUM_XXH32_testdata[4930] */
    { 2465, 0x9E3779B1U, 0xD465986EU }, /* XSUM_XXH32_testdata[4931] */
    { 2466, 0x00000000U, 0xFB754DC6U }, /* XSUM_XXH32_testdata[4932] */
    { 2466, 0x9E3779B1U, 0xFCE69DA1U }, /* XSUM_XXH32_testdata[4933] */
    { 2467, 0x00000000U, 0xA88E1A09U }, /* XSUM_XXH32_testdata[4934] */
    { 2467, 0x9E3779B1U, 0x57214C12U }, /* XSUM_XXH32_testdata[4935] */
    { 2468, 0x00000000U, 0x78BB1C9CU }, /* XSUM_XXH32_testdata[4936] */
    { 2468, 0x9E3779B1U, 0xDF185410U }, /* XSUM_XXH32_testdata[4937] */
    { 2469, 0x00000000U, 0x6213889FU }, /* XSUM_XXH32_testdata[4938] */
    { 2469, 0x9E3779B1U, 0xAFA9F475U }, /* XSUM_XXH32_testdata[4939] */
    { 2470, 0x00000000U, 0x95B72151U }, /* XSUM_XXH32_testdata[4940] */
    { 2470, 0x9E3779B1U, 0x88128454U }, /* XSUM_XXH32_testdata[4941] */
    { 2471, 0x00000000U, 0x4BF42AACU }, /* XSUM_XXH32_testdata[4942] */
    { 2471, 0x9E3779B1U, 0x13142328U }, /* XSUM_XXH32_testdata[4943] */
    { 2472, 0x00000000U, 0x60CFC8A3U }, /* XSUM_XXH32_testdata[4944] */
    { 2472, 0x9E3779B1U, 0x9E5B1C19U }, /* XSUM_XXH32_testdata[4945] */
    { 2473, 0x00000000U, 0x5E5AB692U }, /* XSUM_XXH32_testdata[4946] */
    { 2473, 0x9E3779B1U, 0x15692D3AU }, /* XSUM_XXH32_testdata[4947] */
    { 2474, 0x00000000U, 0x10EC98B1U }, /* XSUM_XXH32_testdata[4948] */
    { 2474, 0x9E3779B1U, 0x37643386U }, /* XSUM_XXH32_testdata[4949] */
    { 2475, 0x00000000U, 0x5BDDCAADU }, /* XSUM_XXH32_testdata[4950] */
    { 2475, 0x9E3779B1U, 0xC3C71E98U }, /* XSUM_XXH32_testdata[4951] */
    { 2476, 0x00000000U, 0xB69D9411U }, /* XSUM_XXH32_testdata[4952] */
    { 2476, 0x9E3779B1U, 0x1EC82D48U }, /* XSUM_XXH32_testdata[4953] */
    { 2477, 0x00000000U, 0x8EAFEDCEU }, /* XSUM_XXH32_testdata[4954] */
    { 2477, 0x9E3779B1U, 0xB095B864U }, /* XSUM_XXH32_testdata[4955] */
    { 2478, 0x00000000U, 0x9D33ED47U }, /* XSUM_XXH32_testdata[4956] */
    { 2478, 0x9E3779B1U, 0xB36E84D2U }, /* XSUM_XXH32_testdata[4957] */
    { 2479, 0x00000000U, 0x20CA8E34U }, /* XSUM_XXH32_testdata[4958] */
    { 2479, 0x9E3779B1U, 0x92D7D0D2U }, /* XSUM_XXH32_testdata[4959] */
    { 2480, 0x00000000U, 0x6EBC10CFU }, /* XSUM_XXH32_testdata[4960] */
    { 2480, 0x9E3779B1U, 0xC769351EU }, /* XSUM_XXH32_testdata[4961] */
    { 2481, 0x00000000U, 0x283A9AB3U }, /* XSUM_XXH32_testdata[4962] */
    { 2481, 0x9E3779B1U, 0xE8274634U }, /* XSUM_XXH32_testdata[4963] */
    { 2482, 0x00000000U, 0x1D4783FBU }, /* XSUM_XXH32_testdata[4964] */
    { 2482, 0x9E3779B1U, 0x94EDEA3EU }, /* XSUM_XXH32_testdata[4965] */
    { 2483, 0x00000000U, 0xA4C2B354U }, /* XSUM_XXH32_testdata[4966] */
    { 2483, 0x9E3779B1U, 0xFA13A4EAU }, /* XSUM_XXH32_testdata[4967] */
    { 2484, 0x00000000U, 0xE2905647U }, /* XSUM_XXH32_testdata[4968] */
    { 2484, 0x9E3779B1U, 0x5CE8F0B5U }, /* XSUM_XXH32_testdata[4969] */
    { 2485, 0x00000000U, 0x9BFFBED8U }, /* XSUM_XXH32_testdata[4970] */
    { 2485, 0x9E3779B1U, 0xD476BD5EU }, /* XSUM_XXH32_testdata[4971] */
    { 2486, 0x00000000U, 0xA87A215CU }, /* XSUM_XXH32_testdata[4972] */
    { 2486, 0x9E3779B1U, 0x007637D1U }, /* XSUM_XXH32_testdata[4973] */
    { 2487, 0x00000000U, 0x88B5055DU }, /* XSUM_XXH32_testdata[4974] */
    { 2487, 0x9E3779B1U, 0x33151CAEU }, /* XSUM_XXH32_testdata[4975] */
    { 2488, 0x00000000U, 0x3B0D952CU }, /* XSUM_XXH32_testdata[4976] */
    { 2488, 0x9E3779B1U, 0x042DC20EU }, /* XSUM_XXH32_testdata[4977] */
    { 2489, 0x00000000U, 0xB2DF6455U }, /* XSUM_XXH32_testdata[4978] */
    { 2489, 0x9E3779B1U, 0xA0A9E1AEU }, /* XSUM_XXH32_testdata[4979] */
    { 2490, 0x00000000U, 0xC4719A06U }, /* XSUM_XXH32_testdata[4980] */
    { 2490, 0x9E3779B1U, 0xCC0EB049U }, /* XSUM_XXH32_testdata[4981] */
    { 2491, 0x00000000U, 0x9D0BF4D3U }, /* XSUM_XXH32_testdata[4982] */
    { 2491, 0x9E3779B1U, 0xDA2AB850U }, /* XSUM_XXH32_testdata[4983] */
    { 2492, 0x00000000U, 0xD5566A5DU }, /* XSUM_XXH32_testdata[4984] */
    { 2492, 0x9E3779B1U, 0xE31015C5U }, /* XSUM_XXH32_testdata[4985] */
    { 2493, 0x00000000U, 0x62C54019U }, /* XSUM_XXH32_testdata[4986] */
    { 2493, 0x9E3779B1U, 0x30F08047U }, /* XSUM_XXH32_testdata[4987] */
    { 2494, 0x00000000U, 0x1F8E0294U }, /* XSUM_XXH32_testdata[4988] */
    { 2494, 0x9E3779B1U, 0x05B20621U }, /* XSUM_XXH32_testdata[4989] */
    { 2495, 0x00000000U, 0xBDD763A8U }, /* XSUM_XXH32_testdata[4990] */
    { 2495, 0x9E3779B1U, 0x2B89039CU }, /* XSUM_XXH32_testdata[4991] */
    { 2496, 0x00000000U, 0xDBCA267CU }, /* XSUM_XXH32_testdata[4992] */
    { 2496, 0x9E3779B1U, 0x248B0E37U }, /* XSUM_XXH32_testdata[4993] */
    { 2497, 0x00000000U, 0x4687D6C4U }, /* XSUM_XXH32_testdata[4994] */
    { 2497, 0x9E3779B1U, 0x71A4D797U }, /* XSUM_XXH32_testdata[4995] */
    { 2498, 0x00000000U, 0x223F45C3U }, /* XSUM_XXH32_testdata[4996] */
    { 2498, 0x9E3779B1U, 0x1C480C65U }, /* XSUM_XXH32_testdata[4997] */
    { 2499, 0x00000000U, 0x71870690U }, /* XSUM_XXH32_testdata[4998] */
    { 2499, 0x9E3779B1U, 0x88ACAA6CU }, /* XSUM_XXH32_testdata[4999] */
    { 2500, 0x00000000U, 0x266F7989U }, /* XSUM_XXH32_testdata[5000] */
    { 2500, 0x9E3779B1U, 0x8997FD8DU }, /* XSUM_XXH32_testdata[5001] */
    { 2501, 0x00000000U, 0x1CBC94A7U }, /* XSUM_XXH32_testdata[5002] */
    { 2501, 0x9E3779B1U, 0xBA035B1FU }, /* XSUM_XXH32_testdata[5003] */
    { 2502, 0x00000000U, 0x8D7DED02U }, /* XSUM_XXH32_testdata[5004] */
    { 2502, 0x9E3779B1U, 0x2B388041U }, /* XSUM_XXH32_testdata[5005] */
    { 2503, 0x00000000U, 0xFEC91094U }, /* XSUM_XXH32_testdata[5006] */
    { 2503, 0x9E3779B1U, 0x8D9BE43FU }, /* XSUM_XXH32_testdata[5007] */
    { 2504, 0x00000000U, 0xEC4C3E01U }, /* XSUM_XXH32_testdata[5008] */
    { 2504, 0x9E3779B1U, 0x55830CC0U }, /* XSUM_XXH32_testdata[5009] */
    { 2505, 0x00000000U, 0xC516CBBFU }, /* XSUM_XXH32_testdata[5010] */
    { 2505, 0x9E3779B1U, 0xB86FAF5AU }, /* XSUM_XXH32_testdata[5011] */
    { 2506, 0x00000000U, 0x79747E1AU }, /* XSUM_XXH32_testdata[5012] */
    { 2506, 0x9E3779B1U, 0x99099909U }, /* XSUM_XXH32_testdata[5013] */
    { 2507, 0x00000000U, 0xCE63B747U }, /* XSUM_XXH32_testdata[5014] */
    { 2507, 0x9E3779B1U, 0xF6B7F760U }, /* XSUM_XXH32_testdata[5015] */
    { 2508, 0x00000000U, 0xA95B498BU }, /* XSUM_XXH32_testdata[5016] */
    { 2508, 0x9E3779B1U, 0xDA4A2178U }, /* XSUM_XXH32_testdata[5017] */
    { 2509, 0x00000000U, 0xE2908F0AU }, /* XSUM_XXH32_testdata[5018] */
    { 2509, 0x9E3779B1U, 0x92D2C2DAU }, /* XSUM_XXH32_testdata[5019] */
    { 2510, 0x00000000U, 0x4F23E994U }, /* XSUM_XXH32_testdata[5020] */
    { 2510, 0x9E3779B1U, 0xABFE546BU }, /* XSUM_XXH32_testdata[5021] */
    { 2511, 0x00000000U, 0xC3BA44D3U }, /* XSUM_XXH32_testdata[5022] */
    { 2511, 0x9E3779B1U, 0x380C4B29U }, /* XSUM_XXH32_testdata[5023] */
    { 2512, 0x00000000U, 0x1B0BBAF2U }, /* XSUM_XXH32_testdata[5024] */
    { 2512, 0x9E3779B1U, 0xDE65FD1BU }, /* XSUM_XXH32_testdata[5025] */
    { 2513, 0x00000000U, 0x77AA4D39U }, /* XSUM_XXH32_testdata[5026] */
    { 2513, 0x9E3779B1U, 0x054A6BF2U }, /* XSUM_XXH32_testdata[5027] */
    { 2514, 0x00000000U, 0x8A698619U }, /* XSUM_XXH32_testdata[5028] */
    { 2514, 0x9E3779B1U, 0x83B311DAU }, /* XSUM_XXH32_testdata[5029] */
    { 2515, 0x00000000U, 0x3DD07C59U }, /* XSUM_XXH32_testdata[5030] */
    { 2515, 0x9E3779B1U, 0x95DFCC93U }, /* XSUM_XXH32_testdata[5031] */
    { 2516, 0x00000000U, 0xAA71782EU }, /* XSUM_XXH32_testdata[5032] */
    { 2516, 0x9E3779B1U, 0x930CB31AU }, /* XSUM_XXH32_testdata[5033] */
    { 2517, 0x00000000U, 0xC10E46FBU }, /* XSUM_XXH32_testdata[5034] */
    { 2517, 0x9E3779B1U, 0x4E714751U }, /* XSUM_XXH32_testdata[5035] */
    { 2518, 0x00000000U, 0x00E44351U }, /* XSUM_XXH32_testdata[5036] */
    { 2518, 0x9E3779B1U, 0xA573A27FU }, /* XSUM_XXH32_testdata[5037] */
    { 2519, 0x00000000U, 0x3BBDD323U }, /* XSUM_XXH32_testdata[5038] */
    { 2519, 0x9E3779B1U, 0x7CD2EC98U }, /* XSUM_XXH32_testdata[5039] */
    { 2520, 0x00000000U, 0x56F5F0F5U }, /* XSUM_XXH32_testdata[5040] */
    { 2520, 0x9E3779B1U, 0x6DBFC220U }, /* XSUM_XXH32_testdata[5041] */
    { 2521, 0x00000000U, 0xBFCFEA1CU }, /* XSUM_XXH32_testdata[5042] */
    { 2521, 0x9E3779B1U, 0x77380567U }, /* XSUM_XXH32_testdata[5043] */
    { 2522, 0x00000000U, 0x53123268U }, /* XSUM_XXH32_testdata[5044] */
    { 2522, 0x9E3779B1U, 0xDD6DA0B4U }, /* XSUM_XXH32_testdata[5045] */
    { 2523, 0x00000000U, 0xCB49F211U }, /* XSUM_XXH32_testdata[5046] */
    { 2523, 0x9E3779B1U, 0x5B1A4A5DU }, /* XSUM_XXH32_testdata[5047] */
    { 2524, 0x00000000U, 0xBB216C60U }, /* XSUM_XXH32_testdata[5048] */
    { 2524, 0x9E3779B1U, 0xBE78F201U }, /* XSUM_XXH32_testdata[5049] */
    { 2525, 0x00000000U, 0x2BDFFA60U }, /* XSUM_XXH32_testdata[5050] */
    { 2525, 0x9E3779B1U, 0xD0766490U }, /* XSUM_XXH32_testdata[5051] */
    { 2526, 0x00000000U, 0xA3DE9270U }, /* XSUM_XXH32_testdata[5052] */
    { 2526, 0x9E3779B1U, 0xCEC85BF3U }, /* XSUM_XXH32_testdata[5053] */
    { 2527, 0x00000000U, 0xEFC57AFCU }, /* XSUM_XXH32_testdata[5054] */
    { 2527, 0x9E3779B1U, 0xC999C77CU }, /* XSUM_XXH32_testdata[5055] */
    { 2528, 0x00000000U, 0x1155BA9CU }, /* XSUM_XXH32_testdata[5056] */
    { 2528, 0x9E3779B1U, 0xF22757C6U }, /* XSUM_XXH32_testdata[5057] */
    { 2529, 0x00000000U, 0xBB71EAD2U }, /* XSUM_XXH32_testdata[5058] */
    { 2529, 0x9E3779B1U, 0x6F4EF984U }, /* XSUM_XXH32_testdata[5059] */
    { 2530, 0x00000000U, 0xEDEB9999U }, /* XSUM_XXH32_testdata[5060] */
    { 2530, 0x9E3779B1U, 0x0AA10A5FU }, /* XSUM_XXH32_testdata[5061] */
    { 2531, 0x00000000U, 0x32C51A6CU }, /* XSUM_XXH32_testdata[5062] */
    { 2531, 0x9E3779B1U, 0x2EAD7681U }, /* XSUM_XXH32_testdata[5063] */
    { 2532, 0x00000000U, 0x3495B28CU }, /* XSUM_XXH32_testdata[5064] */
    { 2532, 0x9E3779B1U, 0x5723E1FAU }, /* XSUM_XXH32_testdata[5065] */
    { 2533, 0x00000000U, 0x9AB8397EU }, /* XSUM_XXH32_testdata[5066] */
    { 2533, 0x9E3779B1U, 0xCDCF0996U }, /* XSUM_XXH32_testdata[5067] */
    { 2534, 0x00000000U, 0xFA84032BU }, /* XSUM_XXH32_testdata[5068] */
    { 2534, 0x9E3779B1U, 0x8EBFB96BU }, /* XSUM_XXH32_testdata[5069] */
    { 2535, 0x00000000U, 0xB247D845U }, /* XSUM_XXH32_testdata[5070] */
    { 2535, 0x9E3779B1U, 0xC9DC4D84U }, /* XSUM_XXH32_testdata[5071] */
    { 2536, 0x00000000U, 0xDE3C3124U }, /* XSUM_XXH32_testdata[5072] */
    { 2536, 0x9E3779B1U, 0x1B134AA2U }, /* XSUM_XXH32_testdata[5073] */
    { 2537, 0x00000000U, 0x748D3C2FU }, /* XSUM_XXH32_testdata[5074] */
    { 2537, 0x9E3779B1U, 0x137D499FU }, /* XSUM_XXH32_testdata[5075] */
    { 2538, 0x00000000U, 0x30184606U }, /* XSUM_XXH32_testdata[5076] */
    { 2538, 0x9E3779B1U, 0x1390D88DU }, /* XSUM_XXH32_testdata[5077] */
    { 2539, 0x00000000U, 0xA9BB1A2EU }, /* XSUM_XXH32_testdata[5078] */
    { 2539, 0x9E3779B1U, 0xD13D5416U }, /* XSUM_XXH32_testdata[5079] */
    { 2540, 0x00000000U, 0xBD9DECB4U }, /* XSUM_XXH32_testdata[5080] */
    { 2540, 0x9E3779B1U, 0x58AED3D4U }, /* XSUM_XXH32_testdata[5081] */
    { 2541, 0x00000000U, 0x871352E8U }, /* XSUM_XXH32_testdata[5082] */
    { 2541, 0x9E3779B1U, 0x78668F9CU }, /* XSUM_XXH32_testdata[5083] */
    { 2542, 0x00000000U, 0x2D251116U }, /* XSUM_XXH32_testdata[5084] */
    { 2542, 0x9E3779B1U, 0x3D6AE30FU }, /* XSUM_XXH32_testdata[5085] */
    { 2543, 0x00000000U, 0xB0B1A048U }, /* XSUM_XXH32_testdata[5086] */
    { 2543, 0x9E3779B1U, 0xF05AD391U }, /* XSUM_XXH32_testdata[5087] */
    { 2544, 0x00000000U, 0x64A2DB5FU }, /* XSUM_XXH32_testdata[5088] */
    { 2544, 0x9E3779B1U, 0x330B551FU }, /* XSUM_XXH32_testdata[5089] */
    { 2545, 0x00000000U, 0x1AAB93F5U }, /* XSUM_XXH32_testdata[5090] */
    { 2545, 0x9E3779B1U, 0x4B872B25U }, /* XSUM_XXH32_testdata[5091] */
    { 2546, 0x00000000U, 0x3DA05328U }, /* XSUM_XXH32_testdata[5092] */
    { 2546, 0x9E3779B1U, 0x79A5FA89U }, /* XSUM_XXH32_testdata[5093] */
    { 2547, 0x00000000U, 0xDE555F91U }, /* XSUM_XXH32_testdata[5094] */
    { 2547, 0x9E3779B1U, 0x390DB61CU }, /* XSUM_XXH32_testdata[5095] */
    { 2548, 0x00000000U, 0x8ECFAF26U }, /* XSUM_XXH32_testdata[5096] */
    { 2548, 0x9E3779B1U, 0x4DD32C3BU }, /* XSUM_XXH32_testdata[5097] */
    { 2549, 0x00000000U, 0x5F0ED460U }, /* XSUM_XXH32_testdata[5098] */
    { 2549, 0x9E3779B1U, 0x7A0BB25CU }, /* XSUM_XXH32_testdata[5099] */
    { 2550, 0x00000000U, 0xC3E328B0U }, /* XSUM_XXH32_testdata[5100] */
    { 2550, 0x9E3779B1U, 0xC8C02925U }, /* XSUM_XXH32_testdata[5101] */
    { 2551, 0x00000000U, 0x9B95BB28U }, /* XSUM_XXH32_testdata[5102] */
    { 2551, 0x9E3779B1U, 0x6609D410U }, /* XSUM_XXH32_testdata[5103] */
    { 2552, 0x00000000U, 0x7FC5A65FU }, /* XSUM_XXH32_testdata[5104] */
    { 2552, 0x9E3779B1U, 0xC0E9A0ADU }, /* XSUM_XXH32_testdata[5105] */
    { 2553, 0x00000000U, 0x5D323F7DU }, /* XSUM_XXH32_testdata[5106] */
    { 2553, 0x9E3779B1U, 0x38FBB4D5U }, /* XSUM_XXH32_testdata[5107] */
    { 2554, 0x00000000U, 0xAD3C2619U }, /* XSUM_XXH32_testdata[5108] */
    { 2554, 0x9E3779B1U, 0x4CBE5431U }, /* XSUM_XXH32_testdata[5109] */
    { 2555, 0x00000000U, 0x2DEDCDDDU }, /* XSUM_XXH32_testdata[5110] */
    { 2555, 0x9E3779B1U, 0xF121C811U }, /* XSUM_XXH32_testdata[5111] */
    { 2556, 0x00000000U, 0xBCC6DA50U }, /* XSUM_XXH32_testdata[5112] */
    { 2556, 0x9E3779B1U, 0x0EE12681U }, /* XSUM_XXH32_testdata[5113] */
    { 2557, 0x00000000U, 0x13BE5756U }, /* XSUM_XXH32_testdata[5114] */
    { 2557, 0x9E3779B1U, 0x773E8E4DU }, /* XSUM_XXH32_testdata[5115] */
    { 2558, 0x00000000U, 0x1CA3BA3FU }, /* XSUM_XXH32_testdata[5116] */
    { 2558, 0x9E3779B1U, 0xCACA1974U }, /* XSUM_XXH32_testdata[5117] */
    { 2559, 0x00000000U, 0x153CAD63U }, /* XSUM_XXH32_testdata[5118] */
    { 2559, 0x9E3779B1U, 0xD046722DU }, /* XSUM_XXH32_testdata[5119] */
    { 2560, 0x00000000U, 0x1ABA29BAU }, /* XSUM_XXH32_testdata[5120] */
    { 2560, 0x9E3779B1U, 0x51D83022U }, /* XSUM_XXH32_testdata[5121] */
    { 2561, 0x00000000U, 0xADE87E35U }, /* XSUM_XXH32_testdata[5122] */
    { 2561, 0x9E3779B1U, 0x97BC0802U }, /* XSUM_XXH32_testdata[5123] */
    { 2562, 0x00000000U, 0x7C693BDEU }, /* XSUM_XXH32_testdata[5124] */
    { 2562, 0x9E3779B1U, 0x3610DFC4U }, /* XSUM_XXH32_testdata[5125] */
    { 2563, 0x00000000U, 0xCAB42EDAU }, /* XSUM_XXH32_testdata[5126] */
    { 2563, 0x9E3779B1U, 0x9C98F65BU }, /* XSUM_XXH32_testdata[5127] */
    { 2564, 0x00000000U, 0x1BEE92DEU }, /* XSUM_XXH32_testdata[5128] */
    { 2564, 0x9E3779B1U, 0xA092C145U }, /* XSUM_XXH32_testdata[5129] */
    { 2565, 0x00000000U, 0x5340661FU }, /* XSUM_XXH32_testdata[5130] */
    { 2565, 0x9E3779B1U, 0xFC3013D6U }, /* XSUM_XXH32_testdata[5131] */
    { 2566, 0x00000000U, 0xA00BE528U }, /* XSUM_XXH32_testdata[5132] */
    { 2566, 0x9E3779B1U, 0x88E43904U }, /* XSUM_XXH32_testdata[5133] */
    { 2567, 0x00000000U, 0x5B70F3CAU }, /* XSUM_XXH32_testdata[5134] */
    { 2567, 0x9E3779B1U, 0x963DBA98U }, /* XSUM_XXH32_testdata[5135] */
    { 2568, 0x00000000U, 0xCA186675U }, /* XSUM_XXH32_testdata[5136] */
    { 2568, 0x9E3779B1U, 0x771ED8ACU }, /* XSUM_XXH32_testdata[5137] */
    { 2569, 0x00000000U, 0x8ADF1BD0U }, /* XSUM_XXH32_testdata[5138] */
    { 2569, 0x9E3779B1U, 0x566F3C4EU }, /* XSUM_XXH32_testdata[5139] */
    { 2570, 0x00000000U, 0x95E0C3ECU }, /* XSUM_XXH32_testdata[5140] */
    { 2570, 0x9E3779B1U, 0xC33D4E92U }, /* XSUM_XXH32_testdata[5141] */
    { 2571, 0x00000000U, 0xB2EF66DFU }, /* XSUM_XXH32_testdata[5142] */
    { 2571, 0x9E3779B1U, 0x0F8D7D36U }, /* XSUM_XXH32_testdata[5143] */
    { 2572, 0x00000000U, 0xA700C815U }, /* XSUM_XXH32_testdata[5144] */
    { 2572, 0x9E3779B1U, 0xA8B82AC3U }, /* XSUM_XXH32_testdata[5145] */
    { 2573, 0x00000000U, 0x2898B84AU }, /* XSUM_XXH32_testdata[5146] */
    { 2573, 0x9E3779B1U, 0x338AE2C0U }, /* XSUM_XXH32_testdata[5147] */
    { 2574, 0x00000000U, 0x0B8D628AU }, /* XSUM_XXH32_testdata[5148] */
    { 2574, 0x9E3779B1U, 0x999867C3U }, /* XSUM_XXH32_testdata[5149] */
    { 2575, 0x00000000U, 0x80E4BAD6U }, /* XSUM_XXH32_testdata[5150] */
    { 2575, 0x9E3779B1U, 0x2F4350BFU }, /* XSUM_XXH32_testdata[5151] */
    { 2576, 0x00000000U, 0x5A4BF4F5U }, /* XSUM_XXH32_testdata[5152] */
    { 2576, 0x9E3779B1U, 0xB583DD59U }, /* XSUM_XXH32_testdata[5153] */
    { 2577, 0x00000000U, 0xCBBEE1FFU }, /* XSUM_XXH32_testdata[5154] */
    { 2577, 0x9E3779B1U, 0x19C5CAB0U }, /* XSUM_XXH32_testdata[5155] */
    { 2578, 0x00000000U, 0x84DA9375U }, /* XSUM_XXH32_testdata[5156] */
    { 2578, 0x9E3779B1U, 0x302900F6U }, /* XSUM_XXH32_testdata[5157] */
    { 2579, 0x00000000U, 0xD61C2E53U }, /* XSUM_XXH32_testdata[5158] */
    { 2579, 0x9E3779B1U, 0xC8B528EBU }, /* XSUM_XXH32_testdata[5159] */
    { 2580, 0x00000000U, 0xDB46C259U }, /* XSUM_XXH32_testdata[5160] */
    { 2580, 0x9E3779B1U, 0x24565891U }, /* XSUM_XXH32_testdata[5161] */
    { 2581, 0x00000000U, 0x3B9B6E50U }, /* XSUM_XXH32_testdata[5162] */
    { 2581, 0x9E3779B1U, 0xE31D1333U }, /* XSUM_XXH32_testdata[5163] */
    { 2582, 0x00000000U, 0xC2192C93U }, /* XSUM_XXH32_testdata[5164] */
    { 2582, 0x9E3779B1U, 0xB4ECDB50U }, /* XSUM_XXH32_testdata[5165] */
    { 2583, 0x00000000U, 0xEE3138CFU }, /* XSUM_XXH32_testdata[5166] */
    { 2583, 0x9E3779B1U, 0x97A34761U }, /* XSUM_XXH32_testdata[5167] */
    { 2584, 0x00000000U, 0xB947C19AU }, /* XSUM_XXH32_testdata[5168] */
    { 2584, 0x9E3779B1U, 0x7ABB56ABU }, /* XSUM_XXH32_testdata[5169] */
    { 2585, 0x00000000U, 0xC1FD5E79U }, /* XSUM_XXH32_testdata[5170] */
    { 2585, 0x9E3779B1U, 0x1EF60D93U }, /* XSUM_XXH32_testdata[5171] */
    { 2586, 0x00000000U, 0x29B23FB2U }, /* XSUM_XXH32_testdata[5172] */
    { 2586, 0x9E3779B1U, 0x788A9EFDU }, /* XSUM_XXH32_testdata[5173] */
    { 2587, 0x00000000U, 0xE86DD88FU }, /* XSUM_XXH32_testdata[5174] */
    { 2587, 0x9E3779B1U, 0x84FAFF47U }, /* XSUM_XXH32_testdata[5175] */
    { 2588, 0x00000000U, 0x4AE06B62U }, /* XSUM_XXH32_testdata[5176] */
    { 2588, 0x9E3779B1U, 0xACA1A31DU }, /* XSUM_XXH32_testdata[5177] */
    { 2589, 0x00000000U, 0x972BB1C4U }, /* XSUM_XXH32_testdata[5178] */
    { 2589, 0x9E3779B1U, 0xB2BA8F34U }, /* XSUM_XXH32_testdata[5179] */
    { 2590, 0x00000000U, 0xBA75790CU }, /* XSUM_XXH32_testdata[5180] */
    { 2590, 0x9E3779B1U, 0x6521A567U }, /* XSUM_XXH32_testdata[5181] */
    { 2591, 0x00000000U, 0x0051F6F3U }, /* XSUM_XXH32_testdata[5182] */
    { 2591, 0x9E3779B1U, 0xAB35F09EU }, /* XSUM_XXH32_testdata[5183] */
    { 2592, 0x00000000U, 0xC086C3D6U }, /* XSUM_XXH32_testdata[5184] */
    { 2592, 0x9E3779B1U, 0xD999A842U }, /* XSUM_XXH32_testdata[5185] */
    { 2593, 0x00000000U, 0x2FAAE8F6U }, /* XSUM_XXH32_testdata[5186] */
    { 2593, 0x9E3779B1U, 0xE28218AFU }, /* XSUM_XXH32_testdata[5187] */
    { 2594, 0x00000000U, 0x6FF01C64U }, /* XSUM_XXH32_testdata[5188] */
    { 2594, 0x9E3779B1U, 0xF4979DCBU }, /* XSUM_XXH32_testdata[5189] */
    { 2595, 0x00000000U, 0x2E66493DU }, /* XSUM_XXH32_testdata[5190] */
    { 2595, 0x9E3779B1U, 0x0C3FF755U }, /* XSUM_XXH32_testdata[5191] */
    { 2596, 0x00000000U, 0xF3CA0A8FU }, /* XSUM_XXH32_testdata[5192] */
    { 2596, 0x9E3779B1U, 0xBE5665A9U }, /* XSUM_XXH32_testdata[5193] */
    { 2597, 0x00000000U, 0xA3D1F12DU }, /* XSUM_XXH32_testdata[5194] */
    { 2597, 0x9E3779B1U, 0xE37C6962U }, /* XSUM_XXH32_testdata[5195] */
    { 2598, 0x00000000U, 0x1BC5E3FCU }, /* XSUM_XXH32_testdata[5196] */
    { 2598, 0x9E3779B1U, 0x508C0A20U }, /* XSUM_XXH32_testdata[5197] */
    { 2599, 0x00000000U, 0x6A9E3256U }, /* XSUM_XXH32_testdata[5198] */
    { 2599, 0x9E3779B1U, 0x1550A26EU }, /* XSUM_XXH32_testdata[5199] */
    { 2600, 0x00000000U, 0xEF3A2069U }, /* XSUM_XXH32_testdata[5200] */
    { 2600, 0x9E3779B1U, 0x5DC7FA5FU }, /* XSUM_XXH32_testdata[5201] */
    { 2601, 0x00000000U, 0x7011A874U }, /* XSUM_XXH32_testdata[5202] */
    { 2601, 0x9E3779B1U, 0x90ECDBA0U }, /* XSUM_XXH32_testdata[5203] */
    { 2602, 0x00000000U, 0xDF051DEFU }, /* XSUM_XXH32_testdata[5204] */
    { 2602, 0x9E3779B1U, 0xD9E10336U }, /* XSUM_XXH32_testdata[5205] */
    { 2603, 0x00000000U, 0x4F7B4CAAU }, /* XSUM_XXH32_testdata[5206] */
    { 2603, 0x9E3779B1U, 0xFD43224AU }, /* XSUM_XXH32_testdata[5207] */
    { 2604, 0x00000000U, 0xABE84A3AU }, /* XSUM_XXH32_testdata[5208] */
    { 2604, 0x9E3779B1U, 0x4BD78879U }, /* XSUM_XXH32_testdata[5209] */
    { 2605, 0x00000000U, 0x9EF62713U }, /* XSUM_XXH32_testdata[5210] */
    { 2605, 0x9E3779B1U, 0xB2B119F8U }, /* XSUM_XXH32_testdata[5211] */
    { 2606, 0x00000000U, 0x88919716U }, /* XSUM_XXH32_testdata[5212] */
    { 2606, 0x9E3779B1U, 0xC7B45CF4U }, /* XSUM_XXH32_testdata[5213] */
    { 2607, 0x00000000U, 0x9C077C09U }, /* XSUM_XXH32_testdata[5214] */
    { 2607, 0x9E3779B1U, 0xFE7EE296U }, /* XSUM_XXH32_testdata[5215] */
    { 2608, 0x00000000U, 0x54E5DF23U }, /* XSUM_XXH32_testdata[5216] */
    { 2608, 0x9E3779B1U, 0x7A0EA04FU }, /* XSUM_XXH32_testdata[5217] */
    { 2609, 0x00000000U, 0x266D2A26U }, /* XSUM_XXH32_testdata[5218] */
    { 2609, 0x9E3779B1U, 0x60D9C6FAU }, /* XSUM_XXH32_testdata[5219] */
    { 2610, 0x00000000U, 0x46D08D97U }, /* XSUM_XXH32_testdata[5220] */
    { 2610, 0x9E3779B1U, 0xC4DA710AU }, /* XSUM_XXH32_testdata[5221] */
    { 2611, 0x00000000U, 0x94B7EAA8U }, /* XSUM_XXH32_testdata[5222] */
    { 2611, 0x9E3779B1U, 0xB5140456U }, /* XSUM_XXH32_testdata[5223] */
    { 2612, 0x00000000U, 0xA16CC5CAU }, /* XSUM_XXH32_testdata[5224] */
    { 2612, 0x9E3779B1U, 0x0579FFFAU }, /* XSUM_XXH32_testdata[5225] */
    { 2613, 0x00000000U, 0x1506CC2CU }, /* XSUM_XXH32_testdata[5226] */
    { 2613, 0x9E3779B1U, 0x18EFF4DFU }, /* XSUM_XXH32_testdata[5227] */
    { 2614, 0x00000000U, 0xED5C7F33U }, /* XSUM_XXH32_testdata[5228] */
    { 2614, 0x9E3779B1U, 0x8B398C71U }, /* XSUM_XXH32_testdata[5229] */
    { 2615, 0x00000000U, 0xC9F9F086U }, /* XSUM_XXH32_testdata[5230] */
    { 2615, 0x9E3779B1U, 0x0149AC29U }, /* XSUM_XXH32_testdata[5231] */
    { 2616, 0x00000000U, 0x0BC9D6D6U }, /* XSUM_XXH32_testdata[5232] */
    { 2616, 0x9E3779B1U, 0x09DD4562U }, /* XSUM_XXH32_testdata[5233] */
    { 2617, 0x00000000U, 0xA6ECDE67U }, /* XSUM_XXH32_testdata[5234] */
    { 2617, 0x9E3779B1U, 0x87D85AC8U }, /* XSUM_XXH32_testdata[5235] */
    { 2618, 0x00000000U, 0x6F24D814U }, /* XSUM_XXH32_testdata[5236] */
    { 2618, 0x9E3779B1U, 0xC1778CE5U }, /* XSUM_XXH32_testdata[5237] */
    { 2619, 0x00000000U, 0xDEE74062U }, /* XSUM_XXH32_testdata[5238] */
    { 2619, 0x9E3779B1U, 0xA13874B9U }, /* XSUM_XXH32_testdata[5239] */
    { 2620, 0x00000000U, 0x935BF986U }, /* XSUM_XXH32_testdata[5240] */
    { 2620, 0x9E3779B1U, 0x105E8B4AU }, /* XSUM_XXH32_testdata[5241] */
    { 2621, 0x00000000U, 0x2B8941E8U }, /* XSUM_XXH32_testdata[5242] */
    { 2621, 0x9E3779B1U, 0x1987630FU }, /* XSUM_XXH32_testdata[5243] */
    { 2622, 0x00000000U, 0xD5B55ED9U }, /* XSUM_XXH32_testdata[5244] */
    { 2622, 0x9E3779B1U, 0x558D1D07U }, /* XSUM_XXH32_testdata[5245] */
    { 2623, 0x00000000U, 0x4B90FD59U }, /* XSUM_XXH32_testdata[5246] */
    { 2623, 0x9E3779B1U, 0x7174560EU }, /* XSUM_XXH32_testdata[5247] */
    { 2624, 0x00000000U, 0x819572F5U }, /* XSUM_XXH32_testdata[5248] */
    { 2624, 0x9E3779B1U, 0x2ADEBAFDU }, /* XSUM_XXH32_testdata[5249] */
    { 2625, 0x00000000U, 0x7FF479D5U }, /* XSUM_XXH32_testdata[5250] */
    { 2625, 0x9E3779B1U, 0x316797DAU }, /* XSUM_XXH32_testdata[5251] */
    { 2626, 0x00000000U, 0x9CA96662U }, /* XSUM_XXH32_testdata[5252] */
    { 2626, 0x9E3779B1U, 0xF5640CB8U }, /* XSUM_XXH32_testdata[5253] */
    { 2627, 0x00000000U, 0xDB9DC926U }, /* XSUM_XXH32_testdata[5254] */
    { 2627, 0x9E3779B1U, 0x6C4A6A53U }, /* XSUM_XXH32_testdata[5255] */
    { 2628, 0x00000000U, 0x3253A88DU }, /* XSUM_XXH32_testdata[5256] */
    { 2628, 0x9E3779B1U, 0xA0FAD05EU }, /* XSUM_XXH32_testdata[5257] */
    { 2629, 0x00000000U, 0xB216A6C4U }, /* XSUM_XXH32_testdata[5258] */
    { 2629, 0x9E3779B1U, 0x86743372U }, /* XSUM_XXH32_testdata[5259] */
    { 2630, 0x00000000U, 0x5675D3D6U }, /* XSUM_XXH32_testdata[5260] */
    { 2630, 0x9E3779B1U, 0xA48FCF88U }, /* XSUM_XXH32_testdata[5261] */
    { 2631, 0x00000000U, 0x29C3CF00U }, /* XSUM_XXH32_testdata[5262] */
    { 2631, 0x9E3779B1U, 0x744F824FU }, /* XSUM_XXH32_testdata[5263] */
    { 2632, 0x00000000U, 0xFFE94921U }, /* XSUM_XXH32_testdata[5264] */
    { 2632, 0x9E3779B1U, 0x7A2AD348U }, /* XSUM_XXH32_testdata[5265] */
    { 2633, 0x00000000U, 0x8ED862F3U }, /* XSUM_XXH32_testdata[5266] */
    { 2633, 0x9E3779B1U, 0xEF43D56CU }, /* XSUM_XXH32_testdata[5267] */
    { 2634, 0x00000000U, 0x79B104B1U }, /* XSUM_XXH32_testdata[5268] */
    { 2634, 0x9E3779B1U, 0x5996D647U }, /* XSUM_XXH32_testdata[5269] */
    { 2635, 0x00000000U, 0x6E8F6903U }, /* XSUM_XXH32_testdata[5270] */
    { 2635, 0x9E3779B1U, 0x17B9C1DFU }, /* XSUM_XXH32_testdata[5271] */
    { 2636, 0x00000000U, 0x147555C3U }, /* XSUM_XXH32_testdata[5272] */
    { 2636, 0x9E3779B1U, 0x84E2C5A8U }, /* XSUM_XXH32_testdata[5273] */
    { 2637, 0x00000000U, 0x5AFDD73CU }, /* XSUM_XXH32_testdata[5274] */
    { 2637, 0x9E3779B1U, 0xBF3F9C0EU }, /* XSUM_XXH32_testdata[5275] */
    { 2638, 0x00000000U, 0x0EF90C7EU }, /* XSUM_XXH32_testdata[5276] */
    { 2638, 0x9E3779B1U, 0xCDC67BAEU }, /* XSUM_XXH32_testdata[5277] */
    { 2639, 0x00000000U, 0xA64BB85EU }, /* XSUM_XXH32_testdata[5278] */
    { 2639, 0x9E3779B1U, 0xE96E9BA0U }, /* XSUM_XXH32_testdata[5279] */
    { 2640, 0x00000000U, 0x28DFAE9AU }, /* XSUM_XXH32_testdata[5280] */
    { 2640, 0x9E3779B1U, 0xD42DC543U }, /* XSUM_XXH32_testdata[5281] */
    { 2641, 0x00000000U, 0xF10ACA82U }, /* XSUM_XXH32_testdata[5282] */
    { 2641, 0x9E3779B1U, 0x38BAB76EU }, /* XSUM_XXH32_testdata[5283] */
    { 2642, 0x00000000U, 0xB1958BE4U }, /* XSUM_XXH32_testdata[5284] */
    { 2642, 0x9E3779B1U, 0xCAF2760FU }, /* XSUM_XXH32_testdata[5285] */
    { 2643, 0x00000000U, 0x2EC97AD3U }, /* XSUM_XXH32_testdata[5286] */
    { 2643, 0x9E3779B1U, 0xC4D00FC1U }, /* XSUM_XXH32_testdata[5287] */
    { 2644, 0x00000000U, 0xEE0453E5U }, /* XSUM_XXH32_testdata[5288] */
    { 2644, 0x9E3779B1U, 0xFBECD6EEU }, /* XSUM_XXH32_testdata[5289] */
    { 2645, 0x00000000U, 0x89C63061U }, /* XSUM_XXH32_testdata[5290] */
    { 2645, 0x9E3779B1U, 0x2FBDEC89U }, /* XSUM_XXH32_testdata[5291] */
    { 2646, 0x00000000U, 0xADF740ACU }, /* XSUM_XXH32_testdata[5292] */
    { 2646, 0x9E3779B1U, 0x8E60E397U }, /* XSUM_XXH32_testdata[5293] */
    { 2647, 0x00000000U, 0x67DDA68EU }, /* XSUM_XXH32_testdata[5294] */
    { 2647, 0x9E3779B1U, 0xBA2934E0U }, /* XSUM_XXH32_testdata[5295] */
    { 2648, 0x00000000U, 0x5425D298U }, /* XSUM_XXH32_testdata[5296] */
    { 2648, 0x9E3779B1U, 0xF4B9737FU }, /* XSUM_XXH32_testdata[5297] */
    { 2649, 0x00000000U, 0x65390777U }, /* XSUM_XXH32_testdata[5298] */
    { 2649, 0x9E3779B1U, 0x79237015U }, /* XSUM_XXH32_testdata[5299] */
    { 2650, 0x00000000U, 0x3E1D5015U }, /* XSUM_XXH32_testdata[5300] */
    { 2650, 0x9E3779B1U, 0xEAEF8B71U }, /* XSUM_XXH32_testdata[5301] */
    { 2651, 0x00000000U, 0xE4ABFBF2U }, /* XSUM_XXH32_testdata[5302] */
    { 2651, 0x9E3779B1U, 0xE280D30FU }, /* XSUM_XXH32_testdata[5303] */
    { 2652, 0x00000000U, 0xE3FAC3F0U }, /* XSUM_XXH32_testdata[5304] */
    { 2652, 0x9E3779B1U, 0x47DB7B3CU }, /* XSUM_XXH32_testdata[5305] */
    { 2653, 0x00000000U, 0x0829971DU }, /* XSUM_XXH32_testdata[5306] */
    { 2653, 0x9E3779B1U, 0xA515CF6CU }, /* XSUM_XXH32_testdata[5307] */
    { 2654, 0x00000000U, 0x63FE1B1EU }, /* XSUM_XXH32_testdata[5308] */
    { 2654, 0x9E3779B1U, 0x80D208D6U }, /* XSUM_XXH32_testdata[5309] */
    { 2655, 0x00000000U, 0x345AC2C8U }, /* XSUM_XXH32_testdata[5310] */
    { 2655, 0x9E3779B1U, 0x55214C47U }, /* XSUM_XXH32_testdata[5311] */
    { 2656, 0x00000000U, 0x728C3834U }, /* XSUM_XXH32_testdata[5312] */
    { 2656, 0x9E3779B1U, 0xF24FCD50U }, /* XSUM_XXH32_testdata[5313] */
    { 2657, 0x00000000U, 0xF7D04B18U }, /* XSUM_XXH32_testdata[5314] */
    { 2657, 0x9E3779B1U, 0x09A5503BU }, /* XSUM_XXH32_testdata[5315] */
    { 2658, 0x00000000U, 0xE5F59CD4U }, /* XSUM_XXH32_testdata[5316] */
    { 2658, 0x9E3779B1U, 0xB9F629E2U }, /* XSUM_XXH32_testdata[5317] */
    { 2659, 0x00000000U, 0x91819CE5U }, /* XSUM_XXH32_testdata[5318] */
    { 2659, 0x9E3779B1U, 0xB26BA83BU }, /* XSUM_XXH32_testdata[5319] */
    { 2660, 0x00000000U, 0x386059D9U }, /* XSUM_XXH32_testdata[5320] */
    { 2660, 0x9E3779B1U, 0x9F695DE7U }, /* XSUM_XXH32_testdata[5321] */
    { 2661, 0x00000000U, 0x35755CCBU }, /* XSUM_XXH32_testdata[5322] */
    { 2661, 0x9E3779B1U, 0x8E9E3C73U }, /* XSUM_XXH32_testdata[5323] */
    { 2662, 0x00000000U, 0x296ED7F5U }, /* XSUM_XXH32_testdata[5324] */
    { 2662, 0x9E3779B1U, 0x3B09C74DU }, /* XSUM_XXH32_testdata[5325] */
    { 2663, 0x00000000U, 0xEBBEFEBAU }, /* XSUM_XXH32_testdata[5326] */
    { 2663, 0x9E3779B1U, 0xCAE4636CU }, /* XSUM_XXH32_testdata[5327] */
    { 2664, 0x00000000U, 0x9069B173U }, /* XSUM_XXH32_testdata[5328] */
    { 2664, 0x9E3779B1U, 0x54F2649BU }, /* XSUM_XXH32_testdata[5329] */
    { 2665, 0x00000000U, 0x466182B7U }, /* XSUM_XXH32_testdata[5330] */
    { 2665, 0x9E3779B1U, 0xD35EBF1CU }, /* XSUM_XXH32_testdata[5331] */
    { 2666, 0x00000000U, 0x3E076B02U }, /* XSUM_XXH32_testdata[5332] */
    { 2666, 0x9E3779B1U, 0xB53173B8U }, /* XSUM_XXH32_testdata[5333] */
    { 2667, 0x00000000U, 0x87A62EE5U }, /* XSUM_XXH32_testdata[5334] */
    { 2667, 0x9E3779B1U, 0xC71A70A9U }, /* XSUM_XXH32_testdata[5335] */
    { 2668, 0x00000000U, 0x19FA51B7U }, /* XSUM_XXH32_testdata[5336] */
    { 2668, 0x9E3779B1U, 0x5DE5FB17U }, /* XSUM_XXH32_testdata[5337] */
    { 2669, 0x00000000U, 0xBF6DD183U }, /* XSUM_XXH32_testdata[5338] */
    { 2669, 0x9E3779B1U, 0x6F2E3E6BU }, /* XSUM_XXH32_testdata[5339] */
    { 2670, 0x00000000U, 0xFEC8B9C5U }, /* XSUM_XXH32_testdata[5340] */
    { 2670, 0x9E3779B1U, 0x81523330U }, /* XSUM_XXH32_testdata[5341] */
    { 2671, 0x00000000U, 0x128F0CF7U }, /* XSUM_XXH32_testdata[5342] */
    { 2671, 0x9E3779B1U, 0x71D3FE04U }, /* XSUM_XXH32_testdata[5343] */
    { 2672, 0x00000000U, 0xDC954677U }, /* XSUM_XXH32_testdata[5344] */
    { 2672, 0x9E3779B1U, 0x14D1AEC6U }, /* XSUM_XXH32_testdata[5345] */
    { 2673, 0x00000000U, 0x1F9C8546U }, /* XSUM_XXH32_testdata[5346] */
    { 2673, 0x9E3779B1U, 0x72873EECU }, /* XSUM_XXH32_testdata[5347] */
    { 2674, 0x00000000U, 0xAA8C6432U }, /* XSUM_XXH32_testdata[5348] */
    { 2674, 0x9E3779B1U, 0x04FD8FF0U }, /* XSUM_XXH32_testdata[5349] */
    { 2675, 0x00000000U, 0xC5D6F479U }, /* XSUM_XXH32_testdata[5350] */
    { 2675, 0x9E3779B1U, 0xA06A12AEU }, /* XSUM_XXH32_testdata[5351] */
    { 2676, 0x00000000U, 0x78436351U }, /* XSUM_XXH32_testdata[5352] */
    { 2676, 0x9E3779B1U, 0xA9966893U }, /* XSUM_XXH32_testdata[5353] */
    { 2677, 0x00000000U, 0x7B747ED2U }, /* XSUM_XXH32_testdata[5354] */
    { 2677, 0x9E3779B1U, 0x54487A50U }, /* XSUM_XXH32_testdata[5355] */
    { 2678, 0x00000000U, 0x00C30B81U }, /* XSUM_XXH32_testdata[5356] */
    { 2678, 0x9E3779B1U, 0x511DD715U }, /* XSUM_XXH32_testdata[5357] */
    { 2679, 0x00000000U, 0xC21D907DU }, /* XSUM_XXH32_testdata[5358] */
    { 2679, 0x9E3779B1U, 0x931E5DC7U }, /* XSUM_XXH32_testdata[5359] */
    { 2680, 0x00000000U, 0x23DCC170U }, /* XSUM_XXH32_testdata[5360] */
    { 2680, 0x9E3779B1U, 0xAE6B07C2U }, /* XSUM_XXH32_testdata[5361] */
    { 2681, 0x00000000U, 0x61289FF0U }, /* XSUM_XXH32_testdata[5362] */
    { 2681, 0x9E3779B1U, 0x430C1894U }, /* XSUM_XXH32_testdata[5363] */
    { 2682, 0x00000000U, 0x6467A6D4U }, /* XSUM_XXH32_testdata[5364] */
    { 2682, 0x9E3779B1U, 0xBAC82073U }, /* XSUM_XXH32_testdata[5365] */
    { 2683, 0x00000000U, 0x9C3AF95BU }, /* XSUM_XXH32_testdata[5366] */
    { 2683, 0x9E3779B1U, 0x600880A9U }, /* XSUM_XXH32_testdata[5367] */
    { 2684, 0x00000000U, 0x883BF584U }, /* XSUM_XXH32_testdata[5368] */
    { 2684, 0x9E3779B1U, 0xD23A72C2U }, /* XSUM_XXH32_testdata[5369] */
    { 2685, 0x00000000U, 0x4283CB47U }, /* XSUM_XXH32_testdata[5370] */
    { 2685, 0x9E3779B1U, 0xF4643357U }, /* XSUM_XXH32_testdata[5371] */
    { 2686, 0x00000000U, 0x775547D9U }, /* XSUM_XXH32_testdata[5372] */
    { 2686, 0x9E3779B1U, 0xFAA2E46EU }, /* XSUM_XXH32_testdata[5373] */
    { 2687, 0x00000000U, 0xA8F45C39U }, /* XSUM_XXH32_testdata[5374] */
    { 2687, 0x9E3779B1U, 0x20E0FCD6U }, /* XSUM_XXH32_testdata[5375] */
    { 2688, 0x00000000U, 0x3D03700BU }, /* XSUM_XXH32_testdata[5376] */
    { 2688, 0x9E3779B1U, 0x53452CDBU }, /* XSUM_XXH32_testdata[5377] */
    { 2689, 0x00000000U, 0xBDD6E7E9U }, /* XSUM_XXH32_testdata[5378] */
    { 2689, 0x9E3779B1U, 0x427DE32BU }, /* XSUM_XXH32_testdata[5379] */
    { 2690, 0x00000000U, 0x48D79403U }, /* XSUM_XXH32_testdata[5380] */
    { 2690, 0x9E3779B1U, 0xC1E8052AU }, /* XSUM_XXH32_testdata[5381] */
    { 2691, 0x00000000U, 0x6724D420U }, /* XSUM_XXH32_testdata[5382] */
    { 2691, 0x9E3779B1U, 0x6658D971U }, /* XSUM_XXH32_testdata[5383] */
    { 2692, 0x00000000U, 0x34410C1CU }, /* XSUM_XXH32_testdata[5384] */
    { 2692, 0x9E3779B1U, 0x61CF4F0DU }, /* XSUM_XXH32_testdata[5385] */
    { 2693, 0x00000000U, 0x78330DFCU }, /* XSUM_XXH32_testdata[5386] */
    { 2693, 0x9E3779B1U, 0x7366F99EU }, /* XSUM_XXH32_testdata[5387] */
    { 2694, 0x00000000U, 0x6A6BC845U }, /* XSUM_XXH32_testdata[5388] */
    { 2694, 0x9E3779B1U, 0x113DA139U }, /* XSUM_XXH32_testdata[5389] */
    { 2695, 0x00000000U, 0x870BA124U }, /* XSUM_XXH32_testdata[5390] */
    { 2695, 0x9E3779B1U, 0xE779D60DU }, /* XSUM_XXH32_testdata[5391] */
    { 2696, 0x00000000U, 0xF11ABFF6U }, /* XSUM_XXH32_testdata[5392] */
    { 2696, 0x9E3779B1U, 0x4B8BF8C6U }, /* XSUM_XXH32_testdata[5393] */
    { 2697, 0x00000000U, 0x6661B68CU }, /* XSUM_XXH32_testdata[5394] */
    { 2697, 0x9E3779B1U, 0xF777EE84U }, /* XSUM_XXH32_testdata[5395] */
    { 2698, 0x00000000U, 0xB705B4BDU }, /* XSUM_XXH32_testdata[5396] */
    { 2698, 0x9E3779B1U, 0x8EFBED1DU }, /* XSUM_XXH32_testdata[5397] */
    { 2699, 0x00000000U, 0x25D23917U }, /* XSUM_XXH32_testdata[5398] */
    { 2699, 0x9E3779B1U, 0xD602C138U }, /* XSUM_XXH32_testdata[5399] */
    { 2700, 0x00000000U, 0x96D45C73U }, /* XSUM_XXH32_testdata[5400] */
    { 2700, 0x9E3779B1U, 0x7B6D5D92U }, /* XSUM_XXH32_testdata[5401] */
    { 2701, 0x00000000U, 0x2404B012U }, /* XSUM_XXH32_testdata[5402] */
    { 2701, 0x9E3779B1U, 0xF80257D4U }, /* XSUM_XXH32_testdata[5403] */
    { 2702, 0x00000000U, 0xB3BB7ED1U }, /* XSUM_XXH32_testdata[5404] */
    { 2702, 0x9E3779B1U, 0x8751A09EU }, /* XSUM_XXH32_testdata[5405] */
    { 2703, 0x00000000U, 0x406E0E4EU }, /* XSUM_XXH32_testdata[5406] */
    { 2703, 0x9E3779B1U, 0x7AC0153FU }, /* XSUM_XXH32_testdata[5407] */
    { 2704, 0x00000000U, 0xB2B82914U }, /* XSUM_XXH32_testdata[5408] */
    { 2704, 0x9E3779B1U, 0xA0D20F9EU }, /* XSUM_XXH32_testdata[5409] */
    { 2705, 0x00000000U, 0x1D0F4FFAU }, /* XSUM_XXH32_testdata[5410] */
    { 2705, 0x9E3779B1U, 0xC7FD7E08U }, /* XSUM_XXH32_testdata[5411] */
    { 2706, 0x00000000U, 0x132C7D2AU }, /* XSUM_XXH32_testdata[5412] */
    { 2706, 0x9E3779B1U, 0xDD1FBC98U }, /* XSUM_XXH32_testdata[5413] */
    { 2707, 0x00000000U, 0xB2F7BCBAU }, /* XSUM_XXH32_testdata[5414] */
    { 2707, 0x9E3779B1U, 0xF037EF59U }, /* XSUM_XXH32_testdata[5415] */
    { 2708, 0x00000000U, 0x9D308CA4U }, /* XSUM_XXH32_testdata[5416] */
    { 2708, 0x9E3779B1U, 0xB2843B4DU }, /* XSUM_XXH32_testdata[5417] */
    { 2709, 0x00000000U, 0x294E4D94U }, /* XSUM_XXH32_testdata[5418] */
    { 2709, 0x9E3779B1U, 0x77E7910DU }, /* XSUM_XXH32_testdata[5419] */
    { 2710, 0x00000000U, 0x538C9176U }, /* XSUM_XXH32_testdata[5420] */
    { 2710, 0x9E3779B1U, 0xD89C74B6U }, /* XSUM_XXH32_testdata[5421] */
    { 2711, 0x00000000U, 0xF850B7E3U }, /* XSUM_XXH32_testdata[5422] */
    { 2711, 0x9E3779B1U, 0xA9EAEFEAU }, /* XSUM_XXH32_testdata[5423] */
    { 2712, 0x00000000U, 0x59A65DF2U }, /* XSUM_XXH32_testdata[5424] */
    { 2712, 0x9E3779B1U, 0xE1E2DDC5U }, /* XSUM_XXH32_testdata[5425] */
    { 2713, 0x00000000U, 0x96F15385U }, /* XSUM_XXH32_testdata[5426] */
    { 2713, 0x9E3779B1U, 0xB5658981U }, /* XSUM_XXH32_testdata[5427] */
    { 2714, 0x00000000U, 0xF5D23C46U }, /* XSUM_XXH32_testdata[5428] */
    { 2714, 0x9E3779B1U, 0xCFC11CD5U }, /* XSUM_XXH32_testdata[5429] */
    { 2715, 0x00000000U, 0xC50611ADU }, /* XSUM_XXH32_testdata[5430] */
    { 2715, 0x9E3779B1U, 0x489ADED0U }, /* XSUM_XXH32_testdata[5431] */
    { 2716, 0x00000000U, 0x9B9FC940U }, /* XSUM_XXH32_testdata[5432] */
    { 2716, 0x9E3779B1U, 0x6A23E943U }, /* XSUM_XXH32_testdata[5433] */
    { 2717, 0x00000000U, 0xF0BB20F0U }, /* XSUM_XXH32_testdata[5434] */
    { 2717, 0x9E3779B1U, 0x8B640A2AU }, /* XSUM_XXH32_testdata[5435] */
    { 2718, 0x00000000U, 0xE5B2613CU }, /* XSUM_XXH32_testdata[5436] */
    { 2718, 0x9E3779B1U, 0x68D0ACDCU }, /* XSUM_XXH32_testdata[5437] */
    { 2719, 0x00000000U, 0x168B4FFCU }, /* XSUM_XXH32_testdata[5438] */
    { 2719, 0x9E3779B1U, 0x99AC56D5U }, /* XSUM_XXH32_testdata[5439] */
    { 2720, 0x00000000U, 0x1C967381U }, /* XSUM_XXH32_testdata[5440] */
    { 2720, 0x9E3779B1U, 0xA0C87AB2U }, /* XSUM_XXH32_testdata[5441] */
    { 2721, 0x00000000U, 0x3B941315U }, /* XSUM_XXH32_testdata[5442] */
    { 2721, 0x9E3779B1U, 0xD91E6380U }, /* XSUM_XXH32_testdata[5443] */
    { 2722, 0x00000000U, 0x3FA50533U }, /* XSUM_XXH32_testdata[5444] */
    { 2722, 0x9E3779B1U, 0x9E249CCDU }, /* XSUM_XXH32_testdata[5445] */
    { 2723, 0x00000000U, 0x866AFD00U }, /* XSUM_XXH32_testdata[5446] */
    { 2723, 0x9E3779B1U, 0x2CC6E1E5U }, /* XSUM_XXH32_testdata[5447] */
    { 2724, 0x00000000U, 0x47D70775U }, /* XSUM_XXH32_testdata[5448] */
    { 2724, 0x9E3779B1U, 0x0AE88051U }, /* XSUM_XXH32_testdata[5449] */
    { 2725, 0x00000000U, 0xCD1BA69FU }, /* XSUM_XXH32_testdata[5450] */
    { 2725, 0x9E3779B1U, 0x96DECF85U }, /* XSUM_XXH32_testdata[5451] */
    { 2726, 0x00000000U, 0xA8625423U }, /* XSUM_XXH32_testdata[5452] */
    { 2726, 0x9E3779B1U, 0xA2410F18U }, /* XSUM_XXH32_testdata[5453] */
    { 2727, 0x00000000U, 0x38195889U }, /* XSUM_XXH32_testdata[5454] */
    { 2727, 0x9E3779B1U, 0x4BD38529U }, /* XSUM_XXH32_testdata[5455] */
    { 2728, 0x00000000U, 0x070F89C8U }, /* XSUM_XXH32_testdata[5456] */
    { 2728, 0x9E3779B1U, 0xDF06AF11U }, /* XSUM_XXH32_testdata[5457] */
    { 2729, 0x00000000U, 0x8E80915AU }, /* XSUM_XXH32_testdata[5458] */
    { 2729, 0x9E3779B1U, 0x4A06DCA0U }, /* XSUM_XXH32_testdata[5459] */
    { 2730, 0x00000000U, 0xBC112A49U }, /* XSUM_XXH32_testdata[5460] */
    { 2730, 0x9E3779B1U, 0x05C9CC27U }, /* XSUM_XXH32_testdata[5461] */
    { 2731, 0x00000000U, 0xA1B81A7EU }, /* XSUM_XXH32_testdata[5462] */
    { 2731, 0x9E3779B1U, 0xB3633441U }, /* XSUM_XXH32_testdata[5463] */
    { 2732, 0x00000000U, 0xD4268862U }, /* XSUM_XXH32_testdata[5464] */
    { 2732, 0x9E3779B1U, 0x3E627514U }, /* XSUM_XXH32_testdata[5465] */
    { 2733, 0x00000000U, 0x5593FD89U }, /* XSUM_XXH32_testdata[5466] */
    { 2733, 0x9E3779B1U, 0xCA01BBF0U }, /* XSUM_XXH32_testdata[5467] */
    { 2734, 0x00000000U, 0x851FDB7DU }, /* XSUM_XXH32_testdata[5468] */
    { 2734, 0x9E3779B1U, 0xB7DE2200U }, /* XSUM_XXH32_testdata[5469] */
    { 2735, 0x00000000U, 0xA0230D8AU }, /* XSUM_XXH32_testdata[5470] */
    { 2735, 0x9E3779B1U, 0x4C98ECC3U }, /* XSUM_XXH32_testdata[5471] */
    { 2736, 0x00000000U, 0x91523E73U }, /* XSUM_XXH32_testdata[5472] */
    { 2736, 0x9E3779B1U, 0x45AD598CU }, /* XSUM_XXH32_testdata[5473] */
    { 2737, 0x00000000U, 0xBF5C144EU }, /* XSUM_XXH32_testdata[5474] */
    { 2737, 0x9E3779B1U, 0xF0A520B6U }, /* XSUM_XXH32_testdata[5475] */
    { 2738, 0x00000000U, 0x55D29805U }, /* XSUM_XXH32_testdata[5476] */
    { 2738, 0x9E3779B1U, 0x7E76F531U }, /* XSUM_XXH32_testdata[5477] */
    { 2739, 0x00000000U, 0xE77D999EU }, /* XSUM_XXH32_testdata[5478] */
    { 2739, 0x9E3779B1U, 0x97489CB6U }, /* XSUM_XXH32_testdata[5479] */
    { 2740, 0x00000000U, 0xC08CF749U }, /* XSUM_XXH32_testdata[5480] */
    { 2740, 0x9E3779B1U, 0x54BBEB2EU }, /* XSUM_XXH32_testdata[5481] */
    { 2741, 0x00000000U, 0x23664C44U }, /* XSUM_XXH32_testdata[5482] */
    { 2741, 0x9E3779B1U, 0x3247CE9AU }, /* XSUM_XXH32_testdata[5483] */
    { 2742, 0x00000000U, 0x5FF2A503U }, /* XSUM_XXH32_testdata[5484] */
    { 2742, 0x9E3779B1U, 0x8C517D75U }, /* XSUM_XXH32_testdata[5485] */
    { 2743, 0x00000000U, 0x6167CF50U }, /* XSUM_XXH32_testdata[5486] */
    { 2743, 0x9E3779B1U, 0x0E019D74U }, /* XSUM_XXH32_testdata[5487] */
    { 2744, 0x00000000U, 0x54917AA2U }, /* XSUM_XXH32_testdata[5488] */
    { 2744, 0x9E3779B1U, 0xB54B21B8U }, /* XSUM_XXH32_testdata[5489] */
    { 2745, 0x00000000U, 0x7B8C955DU }, /* XSUM_XXH32_testdata[5490] */
    { 2745, 0x9E3779B1U, 0x9003306DU }, /* XSUM_XXH32_testdata[5491] */
    { 2746, 0x00000000U, 0xBF41C4B3U }, /* XSUM_XXH32_testdata[5492] */
    { 2746, 0x9E3779B1U, 0xE42BCDF3U }, /* XSUM_XXH32_testdata[5493] */
    { 2747, 0x00000000U, 0xECAF5690U }, /* XSUM_XXH32_testdata[5494] */
    { 2747, 0x9E3779B1U, 0x8F078525U }, /* XSUM_XXH32_testdata[5495] */
    { 2748, 0x00000000U, 0x649FBA7FU }, /* XSUM_XXH32_testdata[5496] */
    { 2748, 0x9E3779B1U, 0x3891C62EU }, /* XSUM_XXH32_testdata[5497] */
    { 2749, 0x00000000U, 0x92F8A489U }, /* XSUM_XXH32_testdata[5498] */
    { 2749, 0x9E3779B1U, 0x9ED412CDU }, /* XSUM_XXH32_testdata[5499] */
    { 2750, 0x00000000U, 0x5D6125DBU }, /* XSUM_XXH32_testdata[5500] */
    { 2750, 0x9E3779B1U, 0xC04AD3C5U }, /* XSUM_XXH32_testdata[5501] */
    { 2751, 0x00000000U, 0xDA1B2BBAU }, /* XSUM_XXH32_testdata[5502] */
    { 2751, 0x9E3779B1U, 0xCD87B55CU }, /* XSUM_XXH32_testdata[5503] */
    { 2752, 0x00000000U, 0x5D54F5CFU }, /* XSUM_XXH32_testdata[5504] */
    { 2752, 0x9E3779B1U, 0x1CA0D0CFU }, /* XSUM_XXH32_testdata[5505] */
    { 2753, 0x00000000U, 0x38093FF9U }, /* XSUM_XXH32_testdata[5506] */
    { 2753, 0x9E3779B1U, 0x8DAFB0D3U }, /* XSUM_XXH32_testdata[5507] */
    { 2754, 0x00000000U, 0xC8289512U }, /* XSUM_XXH32_testdata[5508] */
    { 2754, 0x9E3779B1U, 0x5F94DF3BU }, /* XSUM_XXH32_testdata[5509] */
    { 2755, 0x00000000U, 0x80111DEEU }, /* XSUM_XXH32_testdata[5510] */
    { 2755, 0x9E3779B1U, 0xACBEEEE5U }, /* XSUM_XXH32_testdata[5511] */
    { 2756, 0x00000000U, 0x6DA1C5D4U }, /* XSUM_XXH32_testdata[5512] */
    { 2756, 0x9E3779B1U, 0x8EC6544EU }, /* XSUM_XXH32_testdata[5513] */
    { 2757, 0x00000000U, 0xFB1AF805U }, /* XSUM_XXH32_testdata[5514] */
    { 2757, 0x9E3779B1U, 0xC454EF93U }, /* XSUM_XXH32_testdata[5515] */
    { 2758, 0x00000000U, 0x292A653DU }, /* XSUM_XXH32_testdata[5516] */
    { 2758, 0x9E3779B1U, 0x103F2718U }, /* XSUM_XXH32_testdata[5517] */
    { 2759, 0x00000000U, 0x8AFD632FU }, /* XSUM_XXH32_testdata[5518] */
    { 2759, 0x9E3779B1U, 0xD6D5797CU }, /* XSUM_XXH32_testdata[5519] */
    { 2760, 0x00000000U, 0x12DB2265U }, /* XSUM_XXH32_testdata[5520] */
    { 2760, 0x9E3779B1U, 0x8FCCDBF8U }, /* XSUM_XXH32_testdata[5521] */
    { 2761, 0x00000000U, 0x5ADE7086U }, /* XSUM_XXH32_testdata[5522] */
    { 2761, 0x9E3779B1U, 0x48E1E9A1U }, /* XSUM_XXH32_testdata[5523] */
    { 2762, 0x00000000U, 0xAC10836EU }, /* XSUM_XXH32_testdata[5524] */
    { 2762, 0x9E3779B1U, 0x1FF522F5U }, /* XSUM_XXH32_testdata[5525] */
    { 2763, 0x00000000U, 0x6AA04729U }, /* XSUM_XXH32_testdata[5526] */
    { 2763, 0x9E3779B1U, 0x55E9EB83U }, /* XSUM_XXH32_testdata[5527] */
    { 2764, 0x00000000U, 0xDCC2CB34U }, /* XSUM_XXH32_testdata[5528] */
    { 2764, 0x9E3779B1U, 0xC0422B11U }, /* XSUM_XXH32_testdata[5529] */
    { 2765, 0x00000000U, 0x744A85FEU }, /* XSUM_XXH32_testdata[5530] */
    { 2765, 0x9E3779B1U, 0x7831CF41U }, /* XSUM_XXH32_testdata[5531] */
    { 2766, 0x00000000U, 0xE438101FU }, /* XSUM_XXH32_testdata[5532] */
    { 2766, 0x9E3779B1U, 0x00C9AF6EU }, /* XSUM_XXH32_testdata[5533] */
    { 2767, 0x00000000U, 0xB4AFAC85U }, /* XSUM_XXH32_testdata[5534] */
    { 2767, 0x9E3779B1U, 0xA5015D0FU }, /* XSUM_XXH32_testdata[5535] */
    { 2768, 0x00000000U, 0xFB673462U }, /* XSUM_XXH32_testdata[5536] */
    { 2768, 0x9E3779B1U, 0xAD10C891U }, /* XSUM_XXH32_testdata[5537] */
    { 2769, 0x00000000U, 0x54B334F5U }, /* XSUM_XXH32_testdata[5538] */
    { 2769, 0x9E3779B1U, 0x57657ABAU }, /* XSUM_XXH32_testdata[5539] */
    { 2770, 0x00000000U, 0x067159E8U }, /* XSUM_XXH32_testdata[5540] */
    { 2770, 0x9E3779B1U, 0x570E14C6U }, /* XSUM_XXH32_testdata[5541] */
    { 2771, 0x00000000U, 0xCF730C58U }, /* XSUM_XXH32_testdata[5542] */
    { 2771, 0x9E3779B1U, 0xF1BEFB0BU }, /* XSUM_XXH32_testdata[5543] */
    { 2772, 0x00000000U, 0xA6555537U }, /* XSUM_XXH32_testdata[5544] */
    { 2772, 0x9E3779B1U, 0x44986ACBU }, /* XSUM_XXH32_testdata[5545] */
    { 2773, 0x00000000U, 0x4CB31427U }, /* XSUM_XXH32_testdata[5546] */
    { 2773, 0x9E3779B1U, 0xF7F7EA4EU }, /* XSUM_XXH32_testdata[5547] */
    { 2774, 0x00000000U, 0x8DED665AU }, /* XSUM_XXH32_testdata[5548] */
    { 2774, 0x9E3779B1U, 0xD0BF38CCU }, /* XSUM_XXH32_testdata[5549] */
    { 2775, 0x00000000U, 0xB9A7FCE0U }, /* XSUM_XXH32_testdata[5550] */
    { 2775, 0x9E3779B1U, 0x7C3DBA58U }, /* XSUM_XXH32_testdata[5551] */
    { 2776, 0x00000000U, 0x6B8A34C2U }, /* XSUM_XXH32_testdata[5552] */
    { 2776, 0x9E3779B1U, 0xC489B547U }, /* XSUM_XXH32_testdata[5553] */
    { 2777, 0x00000000U, 0x6A80AC94U }, /* XSUM_XXH32_testdata[5554] */
    { 2777, 0x9E3779B1U, 0xD3D9B559U }, /* XSUM_XXH32_testdata[5555] */
    { 2778, 0x00000000U, 0x1EA784DFU }, /* XSUM_XXH32_testdata[5556] */
    { 2778, 0x9E3779B1U, 0x0F72F335U }, /* XSUM_XXH32_testdata[5557] */
    { 2779, 0x00000000U, 0xEC658F01U }, /* XSUM_XXH32_testdata[5558] */
    { 2779, 0x9E3779B1U, 0x50864FBAU }, /* XSUM_XXH32_testdata[5559] */
    { 2780, 0x00000000U, 0x7BE8A68DU }, /* XSUM_XXH32_testdata[5560] */
    { 2780, 0x9E3779B1U, 0x6239E532U }, /* XSUM_XXH32_testdata[5561] */
    { 2781, 0x00000000U, 0xA0C81CFDU }, /* XSUM_XXH32_testdata[5562] */
    { 2781, 0x9E3779B1U, 0x9625D6DEU }, /* XSUM_XXH32_testdata[5563] */
    { 2782, 0x00000000U, 0x49DC7164U }, /* XSUM_XXH32_testdata[5564] */
    { 2782, 0x9E3779B1U, 0x9EA1983AU }, /* XSUM_XXH32_testdata[5565] */
    { 2783, 0x00000000U, 0xCA12B02EU }, /* XSUM_XXH32_testdata[5566] */
    { 2783, 0x9E3779B1U, 0xFE2C3732U }, /* XSUM_XXH32_testdata[5567] */
    { 2784, 0x00000000U, 0xF26C69B4U }, /* XSUM_XXH32_testdata[5568] */
    { 2784, 0x9E3779B1U, 0x2CE3B4F4U }, /* XSUM_XXH32_testdata[5569] */
    { 2785, 0x00000000U, 0x9E2A7683U }, /* XSUM_XXH32_testdata[5570] */
    { 2785, 0x9E3779B1U, 0x03CC5D74U }, /* XSUM_XXH32_testdata[5571] */
    { 2786, 0x00000000U, 0x7D464299U }, /* XSUM_XXH32_testdata[5572] */
    { 2786, 0x9E3779B1U, 0xEC2A1AEDU }, /* XSUM_XXH32_testdata[5573] */
    { 2787, 0x00000000U, 0x37D18702U }, /* XSUM_XXH32_testdata[5574] */
    { 2787, 0x9E3779B1U, 0x985AAE49U }, /* XSUM_XXH32_testdata[5575] */
    { 2788, 0x00000000U, 0x09A47F14U }, /* XSUM_XXH32_testdata[5576] */
    { 2788, 0x9E3779B1U, 0x7F4C942CU }, /* XSUM_XXH32_testdata[5577] */
    { 2789, 0x00000000U, 0x10275B1BU }, /* XSUM_XXH32_testdata[5578] */
    { 2789, 0x9E3779B1U, 0x75FF3962U }, /* XSUM_XXH32_testdata[5579] */
    { 2790, 0x00000000U, 0x921922CCU }, /* XSUM_XXH32_testdata[5580] */
    { 2790, 0x9E3779B1U, 0x408DAE7AU }, /* XSUM_XXH32_testdata[5581] */
    { 2791, 0x00000000U, 0x5752654DU }, /* XSUM_XXH32_testdata[5582] */
    { 2791, 0x9E3779B1U, 0xE2F27F6BU }, /* XSUM_XXH32_testdata[5583] */
    { 2792, 0x00000000U, 0x545600A6U }, /* XSUM_XXH32_testdata[5584] */
    { 2792, 0x9E3779B1U, 0x6E72E1DFU }, /* XSUM_XXH32_testdata[5585] */
    { 2793, 0x00000000U, 0xE0128B8DU }, /* XSUM_XXH32_testdata[5586] */
    { 2793, 0x9E3779B1U, 0xF726FF9EU }, /* XSUM_XXH32_testdata[5587] */
    { 2794, 0x00000000U, 0x051387C8U }, /* XSUM_XXH32_testdata[5588] */
    { 2794, 0x9E3779B1U, 0x90A42546U }, /* XSUM_XXH32_testdata[5589] */
    { 2795, 0x00000000U, 0xE96E9CC2U }, /* XSUM_XXH32_testdata[5590] */
    { 2795, 0x9E3779B1U, 0x545F6201U }, /* XSUM_XXH32_testdata[5591] */
    { 2796, 0x00000000U, 0x2D5C8D96U }, /* XSUM_XXH32_testdata[5592] */
    { 2796, 0x9E3779B1U, 0x5769B737U }, /* XSUM_XXH32_testdata[5593] */
    { 2797, 0x00000000U, 0x1ACC992CU }, /* XSUM_XXH32_testdata[5594] */
    { 2797, 0x9E3779B1U, 0xB2871004U }, /* XSUM_XXH32_testdata[5595] */
    { 2798, 0x00000000U, 0x64E3753FU }, /* XSUM_XXH32_testdata[5596] */
    { 2798, 0x9E3779B1U, 0x9E91644EU }, /* XSUM_XXH32_testdata[5597] */
    { 2799, 0x00000000U, 0xC098EC8CU }, /* XSUM_XXH32_testdata[5598] */
    { 2799, 0x9E3779B1U, 0xF75A5C44U }, /* XSUM_XXH32_testdata[5599] */
    { 2800, 0x00000000U, 0x0AEC90EEU }, /* XSUM_XXH32_testdata[5600] */
    { 2800, 0x9E3779B1U, 0x3483BEAAU }, /* XSUM_XXH32_testdata[5601] */
    { 2801, 0x00000000U, 0x66C8AF32U }, /* XSUM_XXH32_testdata[5602] */
    { 2801, 0x9E3779B1U, 0x20257751U }, /* XSUM_XXH32_testdata[5603] */
    { 2802, 0x00000000U, 0x0208B7C5U }, /* XSUM_XXH32_testdata[5604] */
    { 2802, 0x9E3779B1U, 0xEE231D12U }, /* XSUM_XXH32_testdata[5605] */
    { 2803, 0x00000000U, 0x2FB02482U }, /* XSUM_XXH32_testdata[5606] */
    { 2803, 0x9E3779B1U, 0xBBEEEB6DU }, /* XSUM_XXH32_testdata[5607] */
    { 2804, 0x00000000U, 0x7455071DU }, /* XSUM_XXH32_testdata[5608] */
    { 2804, 0x9E3779B1U, 0xB69F8B50U }, /* XSUM_XXH32_testdata[5609] */
    { 2805, 0x00000000U, 0xAD0079AEU }, /* XSUM_XXH32_testdata[5610] */
    { 2805, 0x9E3779B1U, 0xED7C62B3U }, /* XSUM_XXH32_testdata[5611] */
    { 2806, 0x00000000U, 0x0B164DE3U }, /* XSUM_XXH32_testdata[5612] */
    { 2806, 0x9E3779B1U, 0x929CE95FU }, /* XSUM_XXH32_testdata[5613] */
    { 2807, 0x00000000U, 0x8129C829U }, /* XSUM_XXH32_testdata[5614] */
    { 2807, 0x9E3779B1U, 0xEE7F1D68U }, /* XSUM_XXH32_testdata[5615] */
    { 2808, 0x00000000U, 0x2F31A376U }, /* XSUM_XXH32_testdata[5616] */
    { 2808, 0x9E3779B1U, 0xEA574A56U }, /* XSUM_XXH32_testdata[5617] */
    { 2809, 0x00000000U, 0x3DC19066U }, /* XSUM_XXH32_testdata[5618] */
    { 2809, 0x9E3779B1U, 0xA10720CBU }, /* XSUM_XXH32_testdata[5619] */
    { 2810, 0x00000000U, 0x413B2F37U }, /* XSUM_XXH32_testdata[5620] */
    { 2810, 0x9E3779B1U, 0xF5BDA1A6U }, /* XSUM_XXH32_testdata[5621] */
    { 2811, 0x00000000U, 0x32C6535CU }, /* XSUM_XXH32_testdata[5622] */
    { 2811, 0x9E3779B1U, 0x75B7D6E5U }, /* XSUM_XXH32_testdata[5623] */
    { 2812, 0x00000000U, 0xFE287DF2U }, /* XSUM_XXH32_testdata[5624] */
    { 2812, 0x9E3779B1U, 0x58E50093U }, /* XSUM_XXH32_testdata[5625] */
    { 2813, 0x00000000U, 0x2E51BC73U }, /* XSUM_XXH32_testdata[5626] */
    { 2813, 0x9E3779B1U, 0x44718D78U }, /* XSUM_XXH32_testdata[5627] */
    { 2814, 0x00000000U, 0x96B81EC3U }, /* XSUM_XXH32_testdata[5628] */
    { 2814, 0x9E3779B1U, 0x6BF333FBU }, /* XSUM_XXH32_testdata[5629] */
    { 2815, 0x00000000U, 0x1ACD00E5U }, /* XSUM_XXH32_testdata[5630] */
    { 2815, 0x9E3779B1U, 0xCA53EF2CU }, /* XSUM_XXH32_testdata[5631] */
    { 2816, 0x00000000U, 0x6BDD0B9CU }, /* XSUM_XXH32_testdata[5632] */
    { 2816, 0x9E3779B1U, 0x01EE1441U }, /* XSUM_XXH32_testdata[5633] */
    { 2817, 0x00000000U, 0xD72F2478U }, /* XSUM_XXH32_testdata[5634] */
    { 2817, 0x9E3779B1U, 0xA648EA45U }, /* XSUM_XXH32_testdata[5635] */
    { 2818, 0x00000000U, 0xE9E3DFC2U }, /* XSUM_XXH32_testdata[5636] */
    { 2818, 0x9E3779B1U, 0x3B09D998U }, /* XSUM_XXH32_testdata[5637] */
    { 2819, 0x00000000U, 0x5BFE487EU }, /* XSUM_XXH32_testdata[5638] */
    { 2819, 0x9E3779B1U, 0x40E7F952U }, /* XSUM_XXH32_testdata[5639] */
    { 2820, 0x00000000U, 0x2D077C99U }, /* XSUM_XXH32_testdata[5640] */
    { 2820, 0x9E3779B1U, 0xB59A99EDU }, /* XSUM_XXH32_testdata[5641] */
    { 2821, 0x00000000U, 0xAEDF4A0BU }, /* XSUM_XXH32_testdata[5642] */
    { 2821, 0x9E3779B1U, 0x91D03418U }, /* XSUM_XXH32_testdata[5643] */
    { 2822, 0x00000000U, 0x5C97CF3EU }, /* XSUM_XXH32_testdata[5644] */
    { 2822, 0x9E3779B1U, 0x5A6F09DFU }, /* XSUM_XXH32_testdata[5645] */
    { 2823, 0x00000000U, 0x110E78AFU }, /* XSUM_XXH32_testdata[5646] */
    { 2823, 0x9E3779B1U, 0x707B42A0U }, /* XSUM_XXH32_testdata[5647] */
    { 2824, 0x00000000U, 0x07781E1EU }, /* XSUM_XXH32_testdata[5648] */
    { 2824, 0x9E3779B1U, 0xDE3F08A5U }, /* XSUM_XXH32_testdata[5649] */
    { 2825, 0x00000000U, 0xF82A8FC4U }, /* XSUM_XXH32_testdata[5650] */
    { 2825, 0x9E3779B1U, 0x418A4F5DU }, /* XSUM_XXH32_testdata[5651] */
    { 2826, 0x00000000U, 0x2D0B6892U }, /* XSUM_XXH32_testdata[5652] */
    { 2826, 0x9E3779B1U, 0x64A44926U }, /* XSUM_XXH32_testdata[5653] */
    { 2827, 0x00000000U, 0x3370A87CU }, /* XSUM_XXH32_testdata[5654] */
    { 2827, 0x9E3779B1U, 0x55EEFDBBU }, /* XSUM_XXH32_testdata[5655] */
    { 2828, 0x00000000U, 0x90FB19E2U }, /* XSUM_XXH32_testdata[5656] */
    { 2828, 0x9E3779B1U, 0x948565EEU }, /* XSUM_XXH32_testdata[5657] */
    { 2829, 0x00000000U, 0x59677021U }, /* XSUM_XXH32_testdata[5658] */
    { 2829, 0x9E3779B1U, 0x93BEFBCAU }, /* XSUM_XXH32_testdata[5659] */
    { 2830, 0x00000000U, 0xC6E84587U }, /* XSUM_XXH32_testdata[5660] */
    { 2830, 0x9E3779B1U, 0x47745AC8U }, /* XSUM_XXH32_testdata[5661] */
    { 2831, 0x00000000U, 0xAC2EBA34U }, /* XSUM_XXH32_testdata[5662] */
    { 2831, 0x9E3779B1U, 0x18176CA3U }, /* XSUM_XXH32_testdata[5663] */
    { 2832, 0x00000000U, 0xCFD418B7U }, /* XSUM_XXH32_testdata[5664] */
    { 2832, 0x9E3779B1U, 0x05243DC9U }, /* XSUM_XXH32_testdata[5665] */
    { 2833, 0x00000000U, 0x8B9FA14CU }, /* XSUM_XXH32_testdata[5666] */
    { 2833, 0x9E3779B1U, 0x99EEDC11U }, /* XSUM_XXH32_testdata[5667] */
    { 2834, 0x00000000U, 0x2F8EA61CU }, /* XSUM_XXH32_testdata[5668] */
    { 2834, 0x9E3779B1U, 0x84FFD078U }, /* XSUM_XXH32_testdata[5669] */
    { 2835, 0x00000000U, 0xB93FA3DDU }, /* XSUM_XXH32_testdata[5670] */
    { 2835, 0x9E3779B1U, 0x6FA5DFE1U }, /* XSUM_XXH32_testdata[5671] */
    { 2836, 0x00000000U, 0x4B3E099DU }, /* XSUM_XXH32_testdata[5672] */
    { 2836, 0x9E3779B1U, 0x1D5C6DDCU }, /* XSUM_XXH32_testdata[5673] */
    { 2837, 0x00000000U, 0x7E5E5805U }, /* XSUM_XXH32_testdata[5674] */
    { 2837, 0x9E3779B1U, 0x8AA6C4E6U }, /* XSUM_XXH32_testdata[5675] */
    { 2838, 0x00000000U, 0x0388F8F1U }, /* XSUM_XXH32_testdata[5676] */
    { 2838, 0x9E3779B1U, 0x5AF9FE66U }, /* XSUM_XXH32_testdata[5677] */
    { 2839, 0x00000000U, 0xB2D948DAU }, /* XSUM_XXH32_testdata[5678] */
    { 2839, 0x9E3779B1U, 0xDADF89C9U }, /* XSUM_XXH32_testdata[5679] */
    { 2840, 0x00000000U, 0x4375D874U }, /* XSUM_XXH32_testdata[5680] */
    { 2840, 0x9E3779B1U, 0x1D4E417EU }, /* XSUM_XXH32_testdata[5681] */
    { 2841, 0x00000000U, 0xB97066F7U }, /* XSUM_XXH32_testdata[5682] */
    { 2841, 0x9E3779B1U, 0x986F05F1U }, /* XSUM_XXH32_testdata[5683] */
    { 2842, 0x00000000U, 0x126921E0U }, /* XSUM_XXH32_testdata[5684] */
    { 2842, 0x9E3779B1U, 0xB451A61BU }, /* XSUM_XXH32_testdata[5685] */
    { 2843, 0x00000000U, 0xE8165EF7U }, /* XSUM_XXH32_testdata[5686] */
    { 2843, 0x9E3779B1U, 0x504AD607U }, /* XSUM_XXH32_testdata[5687] */
    { 2844, 0x00000000U, 0xE016BE32U }, /* XSUM_XXH32_testdata[5688] */
    { 2844, 0x9E3779B1U, 0x65417295U }, /* XSUM_XXH32_testdata[5689] */
    { 2845, 0x00000000U, 0xE0447CFFU }, /* XSUM_XXH32_testdata[5690] */
    { 2845, 0x9E3779B1U, 0x01D677B9U }, /* XSUM_XXH32_testdata[5691] */
    { 2846, 0x00000000U, 0xA1743CAFU }, /* XSUM_XXH32_testdata[5692] */
    { 2846, 0x9E3779B1U, 0xEC062830U }, /* XSUM_XXH32_testdata[5693] */
    { 2847, 0x00000000U, 0x64D64BB9U }, /* XSUM_XXH32_testdata[5694] */
    { 2847, 0x9E3779B1U, 0xA6E518C8U }, /* XSUM_XXH32_testdata[5695] */
    { 2848, 0x00000000U, 0x10FDCB68U }, /* XSUM_XXH32_testdata[5696] */
    { 2848, 0x9E3779B1U, 0x3F1F7470U }, /* XSUM_XXH32_testdata[5697] */
    { 2849, 0x00000000U, 0xE475F379U }, /* XSUM_XXH32_testdata[5698] */
    { 2849, 0x9E3779B1U, 0x264D6363U }, /* XSUM_XXH32_testdata[5699] */
    { 2850, 0x00000000U, 0x5FD4DB79U }, /* XSUM_XXH32_testdata[5700] */
    { 2850, 0x9E3779B1U, 0x44BBF0CCU }, /* XSUM_XXH32_testdata[5701] */
    { 2851, 0x00000000U, 0x956431FEU }, /* XSUM_XXH32_testdata[5702] */
    { 2851, 0x9E3779B1U, 0x4BF184ECU }, /* XSUM_XXH32_testdata[5703] */
    { 2852, 0x00000000U, 0x0FDB9858U }, /* XSUM_XXH32_testdata[5704] */
    { 2852, 0x9E3779B1U, 0xED1B181FU }, /* XSUM_XXH32_testdata[5705] */
    { 2853, 0x00000000U, 0x7476CFEBU }, /* XSUM_XXH32_testdata[5706] */
    { 2853, 0x9E3779B1U, 0x5CB7A179U }, /* XSUM_XXH32_testdata[5707] */
    { 2854, 0x00000000U, 0xD38082C1U }, /* XSUM_XXH32_testdata[5708] */
    { 2854, 0x9E3779B1U, 0x4858100AU }, /* XSUM_XXH32_testdata[5709] */
    { 2855, 0x00000000U, 0x95E8C751U }, /* XSUM_XXH32_testdata[5710] */
    { 2855, 0x9E3779B1U, 0xE669B64FU }, /* XSUM_XXH32_testdata[5711] */
    { 2856, 0x00000000U, 0xB80005D4U }, /* XSUM_XXH32_testdata[5712] */
    { 2856, 0x9E3779B1U, 0x9C85A331U }, /* XSUM_XXH32_testdata[5713] */
    { 2857, 0x00000000U, 0x2F4CF2C5U }, /* XSUM_XXH32_testdata[5714] */
    { 2857, 0x9E3779B1U, 0xB500F804U }, /* XSUM_XXH32_testdata[5715] */
    { 2858, 0x00000000U, 0xB5D502EBU }, /* XSUM_XXH32_testdata[5716] */
    { 2858, 0x9E3779B1U, 0x0C960597U }, /* XSUM_XXH32_testdata[5717] */
    { 2859, 0x00000000U, 0x86386B7DU }, /* XSUM_XXH32_testdata[5718] */
    { 2859, 0x9E3779B1U, 0x5F3F38FEU }, /* XSUM_XXH32_testdata[5719] */
    { 2860, 0x00000000U, 0x50454BDAU }, /* XSUM_XXH32_testdata[5720] */
    { 2860, 0x9E3779B1U, 0xC628A4F9U }, /* XSUM_XXH32_testdata[5721] */
    { 2861, 0x00000000U, 0x6C4F9758U }, /* XSUM_XXH32_testdata[5722] */
    { 2861, 0x9E3779B1U, 0xB39F1641U }, /* XSUM_XXH32_testdata[5723] */
    { 2862, 0x00000000U, 0x535393C8U }, /* XSUM_XXH32_testdata[5724] */
    { 2862, 0x9E3779B1U, 0x0F17E5C2U }, /* XSUM_XXH32_testdata[5725] */
    { 2863, 0x00000000U, 0x9D8AB6D8U }, /* XSUM_XXH32_testdata[5726] */
    { 2863, 0x9E3779B1U, 0xF00959D4U }, /* XSUM_XXH32_testdata[5727] */
    { 2864, 0x00000000U, 0x34669285U }, /* XSUM_XXH32_testdata[5728] */
    { 2864, 0x9E3779B1U, 0x74806FACU }, /* XSUM_XXH32_testdata[5729] */
    { 2865, 0x00000000U, 0xAABDB643U }, /* XSUM_XXH32_testdata[5730] */
    { 2865, 0x9E3779B1U, 0x287840A3U }, /* XSUM_XXH32_testdata[5731] */
    { 2866, 0x00000000U, 0xC6251F32U }, /* XSUM_XXH32_testdata[5732] */
    { 2866, 0x9E3779B1U, 0x49856D67U }, /* XSUM_XXH32_testdata[5733] */
    { 2867, 0x00000000U, 0xE205A26AU }, /* XSUM_XXH32_testdata[5734] */
    { 2867, 0x9E3779B1U, 0x9436CDD1U }, /* XSUM_XXH32_testdata[5735] */
    { 2868, 0x00000000U, 0x4E5E7323U }, /* XSUM_XXH32_testdata[5736] */
    { 2868, 0x9E3779B1U, 0x2AFAB027U }, /* XSUM_XXH32_testdata[5737] */
    { 2869, 0x00000000U, 0x7646C51DU }, /* XSUM_XXH32_testdata[5738] */
    { 2869, 0x9E3779B1U, 0x40E60330U }, /* XSUM_XXH32_testdata[5739] */
    { 2870, 0x00000000U, 0xEC6BFE35U }, /* XSUM_XXH32_testdata[5740] */
    { 2870, 0x9E3779B1U, 0xDFDC9D76U }, /* XSUM_XXH32_testdata[5741] */
    { 2871, 0x00000000U, 0xA4E2C93AU }, /* XSUM_XXH32_testdata[5742] */
    { 2871, 0x9E3779B1U, 0x2A12988BU }, /* XSUM_XXH32_testdata[5743] */
    { 2872, 0x00000000U, 0xD49AC4CEU }, /* XSUM_XXH32_testdata[5744] */
    { 2872, 0x9E3779B1U, 0x556DD939U }, /* XSUM_XXH32_testdata[5745] */
    { 2873, 0x00000000U, 0xC2D8F776U }, /* XSUM_XXH32_testdata[5746] */
    { 2873, 0x9E3779B1U, 0x8BB1AE11U }, /* XSUM_XXH32_testdata[5747] */
    { 2874, 0x00000000U, 0x8502FA30U }, /* XSUM_XXH32_testdata[5748] */
    { 2874, 0x9E3779B1U, 0xC729E56CU }, /* XSUM_XXH32_testdata[5749] */
    { 2875, 0x00000000U, 0x5F809ED5U }, /* XSUM_XXH32_testdata[5750] */
    { 2875, 0x9E3779B1U, 0x8CC6EAAFU }, /* XSUM_XXH32_testdata[5751] */
    { 2876, 0x00000000U, 0xBD800A9FU }, /* XSUM_XXH32_testdata[5752] */
    { 2876, 0x9E3779B1U, 0xED6C0E0EU }, /* XSUM_XXH32_testdata[5753] */
    { 2877, 0x00000000U, 0xCD191B6CU }, /* XSUM_XXH32_testdata[5754] */
    { 2877, 0x9E3779B1U, 0x018F583DU }, /* XSUM_XXH32_testdata[5755] */
    { 2878, 0x00000000U, 0x33D204D4U }, /* XSUM_XXH32_testdata[5756] */
    { 2878, 0x9E3779B1U, 0x87DFAF4DU }, /* XSUM_XXH32_testdata[5757] */
    { 2879, 0x00000000U, 0xCCCE92A0U }, /* XSUM_XXH32_testdata[5758] */
    { 2879, 0x9E3779B1U, 0x11CDE586U }, /* XSUM_XXH32_testdata[5759] */
    { 2880, 0x00000000U, 0xF131872CU }, /* XSUM_XXH32_testdata[5760] */
    { 2880, 0x9E3779B1U, 0xF433CAD6U }, /* XSUM_XXH32_testdata[5761] */
    { 2881, 0x00000000U, 0xE272C8CFU }, /* XSUM_XXH32_testdata[5762] */
    { 2881, 0x9E3779B1U, 0x3E6034EDU }, /* XSUM_XXH32_testdata[5763] */
    { 2882, 0x00000000U, 0xFBF2C98EU }, /* XSUM_XXH32_testdata[5764] */
    { 2882, 0x9E3779B1U, 0x1F9B0EB8U }, /* XSUM_XXH32_testdata[5765] */
    { 2883, 0x00000000U, 0x064096BDU }, /* XSUM_XXH32_testdata[5766] */
    { 2883, 0x9E3779B1U, 0xE2BC2B69U }, /* XSUM_XXH32_testdata[5767] */
    { 2884, 0x00000000U, 0x370670E3U }, /* XSUM_XXH32_testdata[5768] */
    { 2884, 0x9E3779B1U, 0x894D74A5U }, /* XSUM_XXH32_testdata[5769] */
    { 2885, 0x00000000U, 0x89CDD613U }, /* XSUM_XXH32_testdata[5770] */
    { 2885, 0x9E3779B1U, 0x268A843FU }, /* XSUM_XXH32_testdata[5771] */
    { 2886, 0x00000000U, 0x7C9A130CU }, /* XSUM_XXH32_testdata[5772] */
    { 2886, 0x9E3779B1U, 0xBCB743A2U }, /* XSUM_XXH32_testdata[5773] */
    { 2887, 0x00000000U, 0xC8E7C80AU }, /* XSUM_XXH32_testdata[5774] */
    { 2887, 0x9E3779B1U, 0x81B18AA9U }, /* XSUM_XXH32_testdata[5775] */
    { 2888, 0x00000000U, 0x530EF44CU }, /* XSUM_XXH32_testdata[5776] */
    { 2888, 0x9E3779B1U, 0x60599386U }, /* XSUM_XXH32_testdata[5777] */
    { 2889, 0x00000000U, 0x3F360F6DU }, /* XSUM_XXH32_testdata[5778] */
    { 2889, 0x9E3779B1U, 0x57F16D0BU }, /* XSUM_XXH32_testdata[5779] */
    { 2890, 0x00000000U, 0x751F5D7BU }, /* XSUM_XXH32_testdata[5780] */
    { 2890, 0x9E3779B1U, 0x90E5254FU }, /* XSUM_XXH32_testdata[5781] */
    { 2891, 0x00000000U, 0xFB9505C7U }, /* XSUM_XXH32_testdata[5782] */
    { 2891, 0x9E3779B1U, 0xBF6BE72EU }, /* XSUM_XXH32_testdata[5783] */
    { 2892, 0x00000000U, 0xAB270177U }, /* XSUM_XXH32_testdata[5784] */
    { 2892, 0x9E3779B1U, 0x578E1EA3U }, /* XSUM_XXH32_testdata[5785] */
    { 2893, 0x00000000U, 0x9BE1BF35U }, /* XSUM_XXH32_testdata[5786] */
    { 2893, 0x9E3779B1U, 0x2AEC40CAU }, /* XSUM_XXH32_testdata[5787] */
    { 2894, 0x00000000U, 0x6DA78B70U }, /* XSUM_XXH32_testdata[5788] */
    { 2894, 0x9E3779B1U, 0xFE6E9BFBU }, /* XSUM_XXH32_testdata[5789] */
    { 2895, 0x00000000U, 0x92D76350U }, /* XSUM_XXH32_testdata[5790] */
    { 2895, 0x9E3779B1U, 0x649C5A2AU }, /* XSUM_XXH32_testdata[5791] */
    { 2896, 0x00000000U, 0x2F25D0AEU }, /* XSUM_XXH32_testdata[5792] */
    { 2896, 0x9E3779B1U, 0x637B907BU }, /* XSUM_XXH32_testdata[5793] */
    { 2897, 0x00000000U, 0xCFFEE0E2U }, /* XSUM_XXH32_testdata[5794] */
    { 2897, 0x9E3779B1U, 0x1F5775C9U }, /* XSUM_XXH32_testdata[5795] */
    { 2898, 0x00000000U, 0x3E71B1EFU }, /* XSUM_XXH32_testdata[5796] */
    { 2898, 0x9E3779B1U, 0xDD09C98EU }, /* XSUM_XXH32_testdata[5797] */
    { 2899, 0x00000000U, 0x4194541FU }, /* XSUM_XXH32_testdata[5798] */
    { 2899, 0x9E3779B1U, 0x180A0CEEU }, /* XSUM_XXH32_testdata[5799] */
    { 2900, 0x00000000U, 0x2B09A958U }, /* XSUM_XXH32_testdata[5800] */
    { 2900, 0x9E3779B1U, 0xDF682AB5U }, /* XSUM_XXH32_testdata[5801] */
    { 2901, 0x00000000U, 0x8300C2E7U }, /* XSUM_XXH32_testdata[5802] */
    { 2901, 0x9E3779B1U, 0xDBB03537U }, /* XSUM_XXH32_testdata[5803] */
    { 2902, 0x00000000U, 0x18A07793U }, /* XSUM_XXH32_testdata[5804] */
    { 2902, 0x9E3779B1U, 0xAF0FB9BFU }, /* XSUM_XXH32_testdata[5805] */
    { 2903, 0x00000000U, 0x43D7A654U }, /* XSUM_XXH32_testdata[5806] */
    { 2903, 0x9E3779B1U, 0xF60FD833U }, /* XSUM_XXH32_testdata[5807] */
    { 2904, 0x00000000U, 0x8F82C0F9U }, /* XSUM_XXH32_testdata[5808] */
    { 2904, 0x9E3779B1U, 0xF736225AU }, /* XSUM_XXH32_testdata[5809] */
    { 2905, 0x00000000U, 0x636F2D35U }, /* XSUM_XXH32_testdata[5810] */
    { 2905, 0x9E3779B1U, 0xE5A521DAU }, /* XSUM_XXH32_testdata[5811] */
    { 2906, 0x00000000U, 0x8159C1B4U }, /* XSUM_XXH32_testdata[5812] */
    { 2906, 0x9E3779B1U, 0x236C551DU }, /* XSUM_XXH32_testdata[5813] */
    { 2907, 0x00000000U, 0xDF4CA751U }, /* XSUM_XXH32_testdata[5814] */
    { 2907, 0x9E3779B1U, 0x9A9CEC7CU }, /* XSUM_XXH32_testdata[5815] */
    { 2908, 0x00000000U, 0x8F62FC0AU }, /* XSUM_XXH32_testdata[5816] */
    { 2908, 0x9E3779B1U, 0x694589B4U }, /* XSUM_XXH32_testdata[5817] */
    { 2909, 0x00000000U, 0xD6E638AEU }, /* XSUM_XXH32_testdata[5818] */
    { 2909, 0x9E3779B1U, 0x26E452DDU }, /* XSUM_XXH32_testdata[5819] */
    { 2910, 0x00000000U, 0x820F9440U }, /* XSUM_XXH32_testdata[5820] */
    { 2910, 0x9E3779B1U, 0xB2D048E1U }, /* XSUM_XXH32_testdata[5821] */
    { 2911, 0x00000000U, 0x2670DD96U }, /* XSUM_XXH32_testdata[5822] */
    { 2911, 0x9E3779B1U, 0xCEDC28EBU }, /* XSUM_XXH32_testdata[5823] */
    { 2912, 0x00000000U, 0x1A911C9AU }, /* XSUM_XXH32_testdata[5824] */
    { 2912, 0x9E3779B1U, 0xC62A7A09U }, /* XSUM_XXH32_testdata[5825] */
    { 2913, 0x00000000U, 0xCF2B7C95U }, /* XSUM_XXH32_testdata[5826] */
    { 2913, 0x9E3779B1U, 0x44D7DAC9U }, /* XSUM_XXH32_testdata[5827] */
    { 2914, 0x00000000U, 0x28225B2CU }, /* XSUM_XXH32_testdata[5828] */
    { 2914, 0x9E3779B1U, 0xA545F9C8U }, /* XSUM_XXH32_testdata[5829] */
    { 2915, 0x00000000U, 0x91882039U }, /* XSUM_XXH32_testdata[5830] */
    { 2915, 0x9E3779B1U, 0x14584116U }, /* XSUM_XXH32_testdata[5831] */
    { 2916, 0x00000000U, 0x872E972DU }, /* XSUM_XXH32_testdata[5832] */
    { 2916, 0x9E3779B1U, 0x738A66FEU }, /* XSUM_XXH32_testdata[5833] */
    { 2917, 0x00000000U, 0x00B45E1CU }, /* XSUM_XXH32_testdata[5834] */
    { 2917, 0x9E3779B1U, 0xBFFF306DU }, /* XSUM_XXH32_testdata[5835] */
    { 2918, 0x00000000U, 0x47C8F697U }, /* XSUM_XXH32_testdata[5836] */
    { 2918, 0x9E3779B1U, 0x13D3E8CFU }, /* XSUM_XXH32_testdata[5837] */
    { 2919, 0x00000000U, 0x0A7E8141U }, /* XSUM_XXH32_testdata[5838] */
    { 2919, 0x9E3779B1U, 0x415D09D6U }, /* XSUM_XXH32_testdata[5839] */
    { 2920, 0x00000000U, 0xF911F0F0U }, /* XSUM_XXH32_testdata[5840] */
    { 2920, 0x9E3779B1U, 0x865BA41AU }, /* XSUM_XXH32_testdata[5841] */
    { 2921, 0x00000000U, 0x4CB65FE2U }, /* XSUM_XXH32_testdata[5842] */
    { 2921, 0x9E3779B1U, 0x0E62F2C1U }, /* XSUM_XXH32_testdata[5843] */
    { 2922, 0x00000000U, 0x1BE816F4U }, /* XSUM_XXH32_testdata[5844] */
    { 2922, 0x9E3779B1U, 0x778E6D31U }, /* XSUM_XXH32_testdata[5845] */
    { 2923, 0x00000000U, 0x20B0B680U }, /* XSUM_XXH32_testdata[5846] */
    { 2923, 0x9E3779B1U, 0xCB15CF45U }, /* XSUM_XXH32_testdata[5847] */
    { 2924, 0x00000000U, 0x6FADEEE9U }, /* XSUM_XXH32_testdata[5848] */
    { 2924, 0x9E3779B1U, 0xFB61B056U }, /* XSUM_XXH32_testdata[5849] */
    { 2925, 0x00000000U, 0xDDF3D4DCU }, /* XSUM_XXH32_testdata[5850] */
    { 2925, 0x9E3779B1U, 0x1C9E2FFCU }, /* XSUM_XXH32_testdata[5851] */
    { 2926, 0x00000000U, 0x15DCD8E9U }, /* XSUM_XXH32_testdata[5852] */
    { 2926, 0x9E3779B1U, 0x27691377U }, /* XSUM_XXH32_testdata[5853] */
    { 2927, 0x00000000U, 0xBD3AA7B5U }, /* XSUM_XXH32_testdata[5854] */
    { 2927, 0x9E3779B1U, 0xE59A1F2FU }, /* XSUM_XXH32_testdata[5855] */
    { 2928, 0x00000000U, 0xEDC462CEU }, /* XSUM_XXH32_testdata[5856] */
    { 2928, 0x9E3779B1U, 0x8632E73CU }, /* XSUM_XXH32_testdata[5857] */
    { 2929, 0x00000000U, 0xC7912A14U }, /* XSUM_XXH32_testdata[5858] */
    { 2929, 0x9E3779B1U, 0xC31A06D8U }, /* XSUM_XXH32_testdata[5859] */
    { 2930, 0x00000000U, 0x41F1DED3U }, /* XSUM_XXH32_testdata[5860] */
    { 2930, 0x9E3779B1U, 0x198EA7C0U }, /* XSUM_XXH32_testdata[5861] */
    { 2931, 0x00000000U, 0x7BFC4567U }, /* XSUM_XXH32_testdata[5862] */
    { 2931, 0x9E3779B1U, 0xD277E97BU }, /* XSUM_XXH32_testdata[5863] */
    { 2932, 0x00000000U, 0x500D6E61U }, /* XSUM_XXH32_testdata[5864] */
    { 2932, 0x9E3779B1U, 0xBBB97B59U }, /* XSUM_XXH32_testdata[5865] */
    { 2933, 0x00000000U, 0x833B0AB5U }, /* XSUM_XXH32_testdata[5866] */
    { 2933, 0x9E3779B1U, 0xF362690DU }, /* XSUM_XXH32_testdata[5867] */
    { 2934, 0x00000000U, 0x9D0DF51CU }, /* XSUM_XXH32_testdata[5868] */
    { 2934, 0x9E3779B1U, 0xA9CD2FF5U }, /* XSUM_XXH32_testdata[5869] */
    { 2935, 0x00000000U, 0x25B61DBEU }, /* XSUM_XXH32_testdata[5870] */
    { 2935, 0x9E3779B1U, 0x3DF906B1U }, /* XSUM_XXH32_testdata[5871] */
    { 2936, 0x00000000U, 0x2711D6BEU }, /* XSUM_XXH32_testdata[5872] */
    { 2936, 0x9E3779B1U, 0x0E945370U }, /* XSUM_XXH32_testdata[5873] */
    { 2937, 0x00000000U, 0xC486EEA6U }, /* XSUM_XXH32_testdata[5874] */
    { 2937, 0x9E3779B1U, 0x847F9D58U }, /* XSUM_XXH32_testdata[5875] */
    { 2938, 0x00000000U, 0xF6028851U }, /* XSUM_XXH32_testdata[5876] */
    { 2938, 0x9E3779B1U, 0x3D0DAB96U }, /* XSUM_XXH32_testdata[5877] */
    { 2939, 0x00000000U, 0x2F554587U }, /* XSUM_XXH32_testdata[5878] */
    { 2939, 0x9E3779B1U, 0x9EE4A0E0U }, /* XSUM_XXH32_testdata[5879] */
    { 2940, 0x00000000U, 0xB63D3442U }, /* XSUM_XXH32_testdata[5880] */
    { 2940, 0x9E3779B1U, 0xC9176E49U }, /* XSUM_XXH32_testdata[5881] */
    { 2941, 0x00000000U, 0x6E61DBD1U }, /* XSUM_XXH32_testdata[5882] */
    { 2941, 0x9E3779B1U, 0x9B40EADAU }, /* XSUM_XXH32_testdata[5883] */
    { 2942, 0x00000000U, 0x6BF948A1U }, /* XSUM_XXH32_testdata[5884] */
    { 2942, 0x9E3779B1U, 0x335D0A7BU }, /* XSUM_XXH32_testdata[5885] */
    { 2943, 0x00000000U, 0x59F3204CU }, /* XSUM_XXH32_testdata[5886] */
    { 2943, 0x9E3779B1U, 0x1A5FB81BU }, /* XSUM_XXH32_testdata[5887] */
    { 2944, 0x00000000U, 0x856DD3C0U }, /* XSUM_XXH32_testdata[5888] */
    { 2944, 0x9E3779B1U, 0x3DE6DE92U }, /* XSUM_XXH32_testdata[5889] */
    { 2945, 0x00000000U, 0x5C326DD2U }, /* XSUM_XXH32_testdata[5890] */
    { 2945, 0x9E3779B1U, 0xC885EB29U }, /* XSUM_XXH32_testdata[5891] */
    { 2946, 0x00000000U, 0x1198D533U }, /* XSUM_XXH32_testdata[5892] */
    { 2946, 0x9E3779B1U, 0xBFBB9DAEU }, /* XSUM_XXH32_testdata[5893] */
    { 2947, 0x00000000U, 0x56278EAEU }, /* XSUM_XXH32_testdata[5894] */
    { 2947, 0x9E3779B1U, 0x6EF003F5U }, /* XSUM_XXH32_testdata[5895] */
    { 2948, 0x00000000U, 0x321CB244U }, /* XSUM_XXH32_testdata[5896] */
    { 2948, 0x9E3779B1U, 0x4572AAC0U }, /* XSUM_XXH32_testdata[5897] */
    { 2949, 0x00000000U, 0x43702D7FU }, /* XSUM_XXH32_testdata[5898] */
    { 2949, 0x9E3779B1U, 0x16C3BED0U }, /* XSUM_XXH32_testdata[5899] */
    { 2950, 0x00000000U, 0x1E097144U }, /* XSUM_XXH32_testdata[5900] */
    { 2950, 0x9E3779B1U, 0x03960131U }, /* XSUM_XXH32_testdata[5901] */
    { 2951, 0x00000000U, 0x8A47F205U }, /* XSUM_XXH32_testdata[5902] */
    { 2951, 0x9E3779B1U, 0xF2B9301EU }, /* XSUM_XXH32_testdata[5903] */
    { 2952, 0x00000000U, 0xB1487765U }, /* XSUM_XXH32_testdata[5904] */
    { 2952, 0x9E3779B1U, 0xCC9F40BFU }, /* XSUM_XXH32_testdata[5905] */
    { 2953, 0x00000000U, 0xA008001EU }, /* XSUM_XXH32_testdata[5906] */
    { 2953, 0x9E3779B1U, 0xD017F867U }, /* XSUM_XXH32_testdata[5907] */
    { 2954, 0x00000000U, 0x4F292665U }, /* XSUM_XXH32_testdata[5908] */
    { 2954, 0x9E3779B1U, 0xE416E73CU }, /* XSUM_XXH32_testdata[5909] */
    { 2955, 0x00000000U, 0xE0AFE330U }, /* XSUM_XXH32_testdata[5910] */
    { 2955, 0x9E3779B1U, 0x47EFEF4BU }, /* XSUM_XXH32_testdata[5911] */
    { 2956, 0x00000000U, 0xF6C977D5U }, /* XSUM_XXH32_testdata[5912] */
    { 2956, 0x9E3779B1U, 0x57E7630EU }, /* XSUM_XXH32_testdata[5913] */
    { 2957, 0x00000000U, 0x2CE47441U }, /* XSUM_XXH32_testdata[5914] */
    { 2957, 0x9E3779B1U, 0x32FA12B7U }, /* XSUM_XXH32_testdata[5915] */
    { 2958, 0x00000000U, 0x55908F04U }, /* XSUM_XXH32_testdata[5916] */
    { 2958, 0x9E3779B1U, 0x172D8645U }, /* XSUM_XXH32_testdata[5917] */
    { 2959, 0x00000000U, 0xB019060CU }, /* XSUM_XXH32_testdata[5918] */
    { 2959, 0x9E3779B1U, 0xC4D8CA7FU }, /* XSUM_XXH32_testdata[5919] */
    { 2960, 0x00000000U, 0xBBD31580U }, /* XSUM_XXH32_testdata[5920] */
    { 2960, 0x9E3779B1U, 0x2C9C790AU }, /* XSUM_XXH32_testdata[5921] */
    { 2961, 0x00000000U, 0x0A25CF53U }, /* XSUM_XXH32_testdata[5922] */
    { 2961, 0x9E3779B1U, 0xC7F0BBA8U }, /* XSUM_XXH32_testdata[5923] */
    { 2962, 0x00000000U, 0xC4C287B0U }, /* XSUM_XXH32_testdata[5924] */
    { 2962, 0x9E3779B1U, 0x07D2E01FU }, /* XSUM_XXH32_testdata[5925] */
    { 2963, 0x00000000U, 0x867F489CU }, /* XSUM_XXH32_testdata[5926] */
    { 2963, 0x9E3779B1U, 0x3C370C6FU }, /* XSUM_XXH32_testdata[5927] */
    { 2964, 0x00000000U, 0xFCB9A78CU }, /* XSUM_XXH32_testdata[5928] */
    { 2964, 0x9E3779B1U, 0x9BC99E56U }, /* XSUM_XXH32_testdata[5929] */
    { 2965, 0x00000000U, 0x954D08E4U }, /* XSUM_XXH32_testdata[5930] */
    { 2965, 0x9E3779B1U, 0x79D09F28U }, /* XSUM_XXH32_testdata[5931] */
    { 2966, 0x00000000U, 0x011EC304U }, /* XSUM_XXH32_testdata[5932] */
    { 2966, 0x9E3779B1U, 0x7A62A282U }, /* XSUM_XXH32_testdata[5933] */
    { 2967, 0x00000000U, 0xDBB4AED4U }, /* XSUM_XXH32_testdata[5934] */
    { 2967, 0x9E3779B1U, 0x8CF782A7U }, /* XSUM_XXH32_testdata[5935] */
    { 2968, 0x00000000U, 0x82E2A299U }, /* XSUM_XXH32_testdata[5936] */
    { 2968, 0x9E3779B1U, 0x8318B8C8U }, /* XSUM_XXH32_testdata[5937] */
    { 2969, 0x00000000U, 0x737E90A1U }, /* XSUM_XXH32_testdata[5938] */
    { 2969, 0x9E3779B1U, 0xE3DCDCD5U }, /* XSUM_XXH32_testdata[5939] */
    { 2970, 0x00000000U, 0xFB4B300DU }, /* XSUM_XXH32_testdata[5940] */
    { 2970, 0x9E3779B1U, 0xFC6BA74CU }, /* XSUM_XXH32_testdata[5941] */
    { 2971, 0x00000000U, 0x5B5D301AU }, /* XSUM_XXH32_testdata[5942] */
    { 2971, 0x9E3779B1U, 0x70A97341U }, /* XSUM_XXH32_testdata[5943] */
    { 2972, 0x00000000U, 0x707F8706U }, /* XSUM_XXH32_testdata[5944] */
    { 2972, 0x9E3779B1U, 0x8208FF05U }, /* XSUM_XXH32_testdata[5945] */
    { 2973, 0x00000000U, 0xD46D3BD7U }, /* XSUM_XXH32_testdata[5946] */
    { 2973, 0x9E3779B1U, 0xF97FD829U }, /* XSUM_XXH32_testdata[5947] */
    { 2974, 0x00000000U, 0x3B853D38U }, /* XSUM_XXH32_testdata[5948] */
    { 2974, 0x9E3779B1U, 0xB068F481U }, /* XSUM_XXH32_testdata[5949] */
    { 2975, 0x00000000U, 0x18B0B34FU }, /* XSUM_XXH32_testdata[5950] */
    { 2975, 0x9E3779B1U, 0xF295B71EU }, /* XSUM_XXH32_testdata[5951] */
    { 2976, 0x00000000U, 0xB9EAA1ACU }, /* XSUM_XXH32_testdata[5952] */
    { 2976, 0x9E3779B1U, 0x8FCC965FU }, /* XSUM_XXH32_testdata[5953] */
    { 2977, 0x00000000U, 0xBE611863U }, /* XSUM_XXH32_testdata[5954] */
    { 2977, 0x9E3779B1U, 0x379F5EBFU }, /* XSUM_XXH32_testdata[5955] */
    { 2978, 0x00000000U, 0x1111B83CU }, /* XSUM_XXH32_testdata[5956] */
    { 2978, 0x9E3779B1U, 0x66FF91B8U }, /* XSUM_XXH32_testdata[5957] */
    { 2979, 0x00000000U, 0x1BCCB558U }, /* XSUM_XXH32_testdata[5958] */
    { 2979, 0x9E3779B1U, 0x20658C38U }, /* XSUM_XXH32_testdata[5959] */
    { 2980, 0x00000000U, 0xAAB5B933U }, /* XSUM_XXH32_testdata[5960] */
    { 2980, 0x9E3779B1U, 0x84DCB796U }, /* XSUM_XXH32_testdata[5961] */
    { 2981, 0x00000000U, 0xF373FDC4U }, /* XSUM_XXH32_testdata[5962] */
    { 2981, 0x9E3779B1U, 0x6DE7A7A8U }, /* XSUM_XXH32_testdata[5963] */
    { 2982, 0x00000000U, 0x0195E191U }, /* XSUM_XXH32_testdata[5964] */
    { 2982, 0x9E3779B1U, 0xDE816C61U }, /* XSUM_XXH32_testdata[5965] */
    { 2983, 0x00000000U, 0x29193BCEU }, /* XSUM_XXH32_testdata[5966] */
    { 2983, 0x9E3779B1U, 0x1CE6F15BU }, /* XSUM_XXH32_testdata[5967] */
    { 2984, 0x00000000U, 0x5A489757U }, /* XSUM_XXH32_testdata[5968] */
    { 2984, 0x9E3779B1U, 0xE84C9D02U }, /* XSUM_XXH32_testdata[5969] */
    { 2985, 0x00000000U, 0x9A8D2836U }, /* XSUM_XXH32_testdata[5970] */
    { 2985, 0x9E3779B1U, 0x561AD322U }, /* XSUM_XXH32_testdata[5971] */
    { 2986, 0x00000000U, 0xA334309EU }, /* XSUM_XXH32_testdata[5972] */
    { 2986, 0x9E3779B1U, 0x4D373B75U }, /* XSUM_XXH32_testdata[5973] */
    { 2987, 0x00000000U, 0x0C989056U }, /* XSUM_XXH32_testdata[5974] */
    { 2987, 0x9E3779B1U, 0xECD70EC8U }, /* XSUM_XXH32_testdata[5975] */
    { 2988, 0x00000000U, 0xDC615020U }, /* XSUM_XXH32_testdata[5976] */
    { 2988, 0x9E3779B1U, 0x492373CAU }, /* XSUM_XXH32_testdata[5977] */
    { 2989, 0x00000000U, 0x8B3CF068U }, /* XSUM_XXH32_testdata[5978] */
    { 2989, 0x9E3779B1U, 0x86B08886U }, /* XSUM_XXH32_testdata[5979] */
    { 2990, 0x00000000U, 0x4391DB09U }, /* XSUM_XXH32_testdata[5980] */
    { 2990, 0x9E3779B1U, 0xD8CF567FU }, /* XSUM_XXH32_testdata[5981] */
    { 2991, 0x00000000U, 0x1A7A1BF9U }, /* XSUM_XXH32_testdata[5982] */
    { 2991, 0x9E3779B1U, 0x5B31BE82U }, /* XSUM_XXH32_testdata[5983] */
    { 2992, 0x00000000U, 0x423A109DU }, /* XSUM_XXH32_testdata[5984] */
    { 2992, 0x9E3779B1U, 0xD62AB7FCU }, /* XSUM_XXH32_testdata[5985] */
    { 2993, 0x00000000U, 0x2910FCA6U }, /* XSUM_XXH32_testdata[5986] */
    { 2993, 0x9E3779B1U, 0xF6C41F6AU }, /* XSUM_XXH32_testdata[5987] */
    { 2994, 0x00000000U, 0x9225C21CU }, /* XSUM_XXH32_testdata[5988] */
    { 2994, 0x9E3779B1U, 0x176B2457U }, /* XSUM_XXH32_testdata[5989] */
    { 2995, 0x00000000U, 0x8B56A4DEU }, /* XSUM_XXH32_testdata[5990] */
    { 2995, 0x9E3779B1U, 0x0F4E15FAU }, /* XSUM_XXH32_testdata[5991] */
    { 2996, 0x00000000U, 0x3470DB81U }, /* XSUM_XXH32_testdata[5992] */
    { 2996, 0x9E3779B1U, 0x48D239ECU }, /* XSUM_XXH32_testdata[5993] */
    { 2997, 0x00000000U, 0xC466E875U }, /* XSUM_XXH32_testdata[5994] */
    { 2997, 0x9E3779B1U, 0x40297694U }, /* XSUM_XXH32_testdata[5995] */
    { 2998, 0x00000000U, 0x310D7935U }, /* XSUM_XXH32_testdata[5996] */
    { 2998, 0x9E3779B1U, 0x9C82CD08U }, /* XSUM_XXH32_testdata[5997] */
    { 2999, 0x00000000U, 0x1410789DU }, /* XSUM_XXH32_testdata[5998] */
    { 2999, 0x9E3779B1U, 0xA34ACC55U }, /* XSUM_XXH32_testdata[5999] */
    { 3000, 0x00000000U, 0x7DE4955CU }, /* XSUM_XXH32_testdata[6000] */
    { 3000, 0x9E3779B1U, 0x595FB316U }, /* XSUM_XXH32_testdata[6001] */
    { 3001, 0x00000000U, 0xC33AC27EU }, /* XSUM_XXH32_testdata[6002] */
    { 3001, 0x9E3779B1U, 0x76BCAFEFU }, /* XSUM_XXH32_testdata[6003] */
    { 3002, 0x00000000U, 0x824DD320U }, /* XSUM_XXH32_testdata[6004] */
    { 3002, 0x9E3779B1U, 0x6F7D851AU }, /* XSUM_XXH32_testdata[6005] */
    { 3003, 0x00000000U, 0x59B47801U }, /* XSUM_XXH32_testdata[6006] */
    { 3003, 0x9E3779B1U, 0xDD67D6A4U }, /* XSUM_XXH32_testdata[6007] */
    { 3004, 0x00000000U, 0xB8395F2CU }, /* XSUM_XXH32_testdata[6008] */
    { 3004, 0x9E3779B1U, 0xFE7A73A1U }, /* XSUM_XXH32_testdata[6009] */
    { 3005, 0x00000000U, 0xE66147FFU }, /* XSUM_XXH32_testdata[6010] */
    { 3005, 0x9E3779B1U, 0x781AA1FCU }, /* XSUM_XXH32_testdata[6011] */
    { 3006, 0x00000000U, 0x05B76570U }, /* XSUM_XXH32_testdata[6012] */
    { 3006, 0x9E3779B1U, 0xC560E325U }, /* XSUM_XXH32_testdata[6013] */
    { 3007, 0x00000000U, 0x74B4319FU }, /* XSUM_XXH32_testdata[6014] */
    { 3007, 0x9E3779B1U, 0x783B331CU }, /* XSUM_XXH32_testdata[6015] */
    { 3008, 0x00000000U, 0x0A1A629DU }, /* XSUM_XXH32_testdata[6016] */
    { 3008, 0x9E3779B1U, 0x9ADD6ABCU }, /* XSUM_XXH32_testdata[6017] */
    { 3009, 0x00000000U, 0xCD70D942U }, /* XSUM_XXH32_testdata[6018] */
    { 3009, 0x9E3779B1U, 0x1BFB81F6U }, /* XSUM_XXH32_testdata[6019] */
    { 3010, 0x00000000U, 0x56694BEBU }, /* XSUM_XXH32_testdata[6020] */
    { 3010, 0x9E3779B1U, 0xD4D15900U }, /* XSUM_XXH32_testdata[6021] */
    { 3011, 0x00000000U, 0x0B8F4451U }, /* XSUM_XXH32_testdata[6022] */
    { 3011, 0x9E3779B1U, 0x4228C4E0U }, /* XSUM_XXH32_testdata[6023] */
    { 3012, 0x00000000U, 0xD42EC927U }, /* XSUM_XXH32_testdata[6024] */
    { 3012, 0x9E3779B1U, 0x24EC861AU }, /* XSUM_XXH32_testdata[6025] */
    { 3013, 0x00000000U, 0x6226F2C5U }, /* XSUM_XXH32_testdata[6026] */
    { 3013, 0x9E3779B1U, 0xF6840F72U }, /* XSUM_XXH32_testdata[6027] */
    { 3014, 0x00000000U, 0x7AD77FF1U }, /* XSUM_XXH32_testdata[6028] */
    { 3014, 0x9E3779B1U, 0xBC3F2621U }, /* XSUM_XXH32_testdata[6029] */
    { 3015, 0x00000000U, 0x5413594DU }, /* XSUM_XXH32_testdata[6030] */
    { 3015, 0x9E3779B1U, 0xE96FE3EFU }, /* XSUM_XXH32_testdata[6031] */
    { 3016, 0x00000000U, 0x163019CFU }, /* XSUM_XXH32_testdata[6032] */
    { 3016, 0x9E3779B1U, 0xCE696F0BU }, /* XSUM_XXH32_testdata[6033] */
    { 3017, 0x00000000U, 0x94ECA3C3U }, /* XSUM_XXH32_testdata[6034] */
    { 3017, 0x9E3779B1U, 0x34FE249DU }, /* XSUM_XXH32_testdata[6035] */
    { 3018, 0x00000000U, 0xEB15CF8FU }, /* XSUM_XXH32_testdata[6036] */
    { 3018, 0x9E3779B1U, 0x168B5B6EU }, /* XSUM_XXH32_testdata[6037] */
    { 3019, 0x00000000U, 0xA918E275U }, /* XSUM_XXH32_testdata[6038] */
    { 3019, 0x9E3779B1U, 0xD91220BCU }, /* XSUM_XXH32_testdata[6039] */
    { 3020, 0x00000000U, 0xFC191ABBU }, /* XSUM_XXH32_testdata[6040] */
    { 3020, 0x9E3779B1U, 0x0AE2796BU }, /* XSUM_XXH32_testdata[6041] */
    { 3021, 0x00000000U, 0xDE6669BBU }, /* XSUM_XXH32_testdata[6042] */
    { 3021, 0x9E3779B1U, 0xEFEB930FU }, /* XSUM_XXH32_testdata[6043] */
    { 3022, 0x00000000U, 0xDD2D73A8U }, /* XSUM_XXH32_testdata[6044] */
    { 3022, 0x9E3779B1U, 0xD6D9CBB8U }, /* XSUM_XXH32_testdata[6045] */
    { 3023, 0x00000000U, 0xCBEE8272U }, /* XSUM_XXH32_testdata[6046] */
    { 3023, 0x9E3779B1U, 0x215FC772U }, /* XSUM_XXH32_testdata[6047] */
    { 3024, 0x00000000U, 0x014C13C3U }, /* XSUM_XXH32_testdata[6048] */
    { 3024, 0x9E3779B1U, 0x5EF83E31U }, /* XSUM_XXH32_testdata[6049] */
    { 3025, 0x00000000U, 0xEDE35D61U }, /* XSUM_XXH32_testdata[6050] */
    { 3025, 0x9E3779B1U, 0x82738A51U }, /* XSUM_XXH32_testdata[6051] */
    { 3026, 0x00000000U, 0x668B22B4U }, /* XSUM_XXH32_testdata[6052] */
    { 3026, 0x9E3779B1U, 0xB422F746U }, /* XSUM_XXH32_testdata[6053] */
    { 3027, 0x00000000U, 0x31087B46U }, /* XSUM_XXH32_testdata[6054] */
    { 3027, 0x9E3779B1U, 0x094281ACU }, /* XSUM_XXH32_testdata[6055] */
    { 3028, 0x00000000U, 0x57F41E72U }, /* XSUM_XXH32_testdata[6056] */
    { 3028, 0x9E3779B1U, 0xFFB08C2EU }, /* XSUM_XXH32_testdata[6057] */
    { 3029, 0x00000000U, 0xAF9E9E7BU }, /* XSUM_XXH32_testdata[6058] */
    { 3029, 0x9E3779B1U, 0x5CD8A1DEU }, /* XSUM_XXH32_testdata[6059] */
    { 3030, 0x00000000U, 0x75D5BFA0U }, /* XSUM_XXH32_testdata[6060] */
    { 3030, 0x9E3779B1U, 0x52FBDEF0U }, /* XSUM_XXH32_testdata[6061] */
    { 3031, 0x00000000U, 0x6E8543CFU }, /* XSUM_XXH32_testdata[6062] */
    { 3031, 0x9E3779B1U, 0x663E33ADU }, /* XSUM_XXH32_testdata[6063] */
    { 3032, 0x00000000U, 0xFDF76881U }, /* XSUM_XXH32_testdata[6064] */
    { 3032, 0x9E3779B1U, 0xE519B676U }, /* XSUM_XXH32_testdata[6065] */
    { 3033, 0x00000000U, 0x7AEFA9CAU }, /* XSUM_XXH32_testdata[6066] */
    { 3033, 0x9E3779B1U, 0x865C3370U }, /* XSUM_XXH32_testdata[6067] */
    { 3034, 0x00000000U, 0x00EF3B72U }, /* XSUM_XXH32_testdata[6068] */
    { 3034, 0x9E3779B1U, 0x5721E410U }, /* XSUM_XXH32_testdata[6069] */
    { 3035, 0x00000000U, 0x1C6729ABU }, /* XSUM_XXH32_testdata[6070] */
    { 3035, 0x9E3779B1U, 0x8D18CB9AU }, /* XSUM_XXH32_testdata[6071] */
    { 3036, 0x00000000U, 0xECE697A3U }, /* XSUM_XXH32_testdata[6072] */
    { 3036, 0x9E3779B1U, 0x2065FD13U }, /* XSUM_XXH32_testdata[6073] */
    { 3037, 0x00000000U, 0xC0F2C8CCU }, /* XSUM_XXH32_testdata[6074] */
    { 3037, 0x9E3779B1U, 0xED60F9EEU }, /* XSUM_XXH32_testdata[6075] */
    { 3038, 0x00000000U, 0xDD7D2260U }, /* XSUM_XXH32_testdata[6076] */
    { 3038, 0x9E3779B1U, 0x869C9DFDU }, /* XSUM_XXH32_testdata[6077] */
    { 3039, 0x00000000U, 0x87DEC6DAU }, /* XSUM_XXH32_testdata[6078] */
    { 3039, 0x9E3779B1U, 0x41D284ADU }, /* XSUM_XXH32_testdata[6079] */
    { 3040, 0x00000000U, 0xCA8DA6B0U }, /* XSUM_XXH32_testdata[6080] */
    { 3040, 0x9E3779B1U, 0xFBAB5DD5U }, /* XSUM_XXH32_testdata[6081] */
    { 3041, 0x00000000U, 0x68A1D3EDU }, /* XSUM_XXH32_testdata[6082] */
    { 3041, 0x9E3779B1U, 0x41249766U }, /* XSUM_XXH32_testdata[6083] */
    { 3042, 0x00000000U, 0x3E4E842BU }, /* XSUM_XXH32_testdata[6084] */
    { 3042, 0x9E3779B1U, 0xB3C5D77DU }, /* XSUM_XXH32_testdata[6085] */
    { 3043, 0x00000000U, 0xE0EEA85BU }, /* XSUM_XXH32_testdata[6086] */
    { 3043, 0x9E3779B1U, 0x05EFB10DU }, /* XSUM_XXH32_testdata[6087] */
    { 3044, 0x00000000U, 0x477537C9U }, /* XSUM_XXH32_testdata[6088] */
    { 3044, 0x9E3779B1U, 0xF583F875U }, /* XSUM_XXH32_testdata[6089] */
    { 3045, 0x00000000U, 0x99C55376U }, /* XSUM_XXH32_testdata[6090] */
    { 3045, 0x9E3779B1U, 0x8492D63DU }, /* XSUM_XXH32_testdata[6091] */
    { 3046, 0x00000000U, 0x9D2314F3U }, /* XSUM_XXH32_testdata[6092] */
    { 3046, 0x9E3779B1U, 0x2A17457BU }, /* XSUM_XXH32_testdata[6093] */
    { 3047, 0x00000000U, 0xF520B774U }, /* XSUM_XXH32_testdata[6094] */
    { 3047, 0x9E3779B1U, 0xCBC0E177U }, /* XSUM_XXH32_testdata[6095] */
    { 3048, 0x00000000U, 0x7DF6260AU }, /* XSUM_XXH32_testdata[6096] */
    { 3048, 0x9E3779B1U, 0x2B849C8EU }, /* XSUM_XXH32_testdata[6097] */
    { 3049, 0x00000000U, 0x2316EEF0U }, /* XSUM_XXH32_testdata[6098] */
    { 3049, 0x9E3779B1U, 0x8C00785BU }, /* XSUM_XXH32_testdata[6099] */
    { 3050, 0x00000000U, 0x8BF00BADU }, /* XSUM_XXH32_testdata[6100] */
    { 3050, 0x9E3779B1U, 0x08C199F5U }, /* XSUM_XXH32_testdata[6101] */
    { 3051, 0x00000000U, 0xD9EB661CU }, /* XSUM_XXH32_testdata[6102] */
    { 3051, 0x9E3779B1U, 0x1615E50DU }, /* XSUM_XXH32_testdata[6103] */
    { 3052, 0x00000000U, 0x09AF9665U }, /* XSUM_XXH32_testdata[6104] */
    { 3052, 0x9E3779B1U, 0x8001C98FU }, /* XSUM_XXH32_testdata[6105] */
    { 3053, 0x00000000U, 0x213FC05FU }, /* XSUM_XXH32_testdata[6106] */
    { 3053, 0x9E3779B1U, 0xFDB85DACU }, /* XSUM_XXH32_testdata[6107] */
    { 3054, 0x00000000U, 0x330167EEU }, /* XSUM_XXH32_testdata[6108] */
    { 3054, 0x9E3779B1U, 0x8C7954D3U }, /* XSUM_XXH32_testdata[6109] */
    { 3055, 0x00000000U, 0x1114A4F7U }, /* XSUM_XXH32_testdata[6110] */
    { 3055, 0x9E3779B1U, 0x8DD32A76U }, /* XSUM_XXH32_testdata[6111] */
    { 3056, 0x00000000U, 0xA84F141BU }, /* XSUM_XXH32_testdata[6112] */
    { 3056, 0x9E3779B1U, 0xA0CFB287U }, /* XSUM_XXH32_testdata[6113] */
    { 3057, 0x00000000U, 0x46408A5AU }, /* XSUM_XXH32_testdata[6114] */
    { 3057, 0x9E3779B1U, 0xB332175BU }, /* XSUM_XXH32_testdata[6115] */
    { 3058, 0x00000000U, 0xE3780AA0U }, /* XSUM_XXH32_testdata[6116] */
    { 3058, 0x9E3779B1U, 0x00A8A855U }, /* XSUM_XXH32_testdata[6117] */
    { 3059, 0x00000000U, 0x764D099DU }, /* XSUM_XXH32_testdata[6118] */
    { 3059, 0x9E3779B1U, 0x092B48AEU }, /* XSUM_XXH32_testdata[6119] */
    { 3060, 0x00000000U, 0x436F6078U }, /* XSUM_XXH32_testdata[6120] */
    { 3060, 0x9E3779B1U, 0x4589D0DAU }, /* XSUM_XXH32_testdata[6121] */
    { 3061, 0x00000000U, 0x2391A33DU }, /* XSUM_XXH32_testdata[6122] */
    { 3061, 0x9E3779B1U, 0x355113B7U }, /* XSUM_XXH32_testdata[6123] */
    { 3062, 0x00000000U, 0x60163C95U }, /* XSUM_XXH32_testdata[6124] */
    { 3062, 0x9E3779B1U, 0xB5CC6958U }, /* XSUM_XXH32_testdata[6125] */
    { 3063, 0x00000000U, 0x02740200U }, /* XSUM_XXH32_testdata[6126] */
    { 3063, 0x9E3779B1U, 0x8E0E8A88U }, /* XSUM_XXH32_testdata[6127] */
    { 3064, 0x00000000U, 0x7846D7E6U }, /* XSUM_XXH32_testdata[6128] */
    { 3064, 0x9E3779B1U, 0x54DBB912U }, /* XSUM_XXH32_testdata[6129] */
    { 3065, 0x00000000U, 0x6F098C1FU }, /* XSUM_XXH32_testdata[6130] */
    { 3065, 0x9E3779B1U, 0xD14C4216U }, /* XSUM_XXH32_testdata[6131] */
    { 3066, 0x00000000U, 0x99225C5CU }, /* XSUM_XXH32_testdata[6132] */
    { 3066, 0x9E3779B1U, 0x2BF95082U }, /* XSUM_XXH32_testdata[6133] */
    { 3067, 0x00000000U, 0x296ED4B0U }, /* XSUM_XXH32_testdata[6134] */
    { 3067, 0x9E3779B1U, 0xE209F1E1U }, /* XSUM_XXH32_testdata[6135] */
    { 3068, 0x00000000U, 0x36F7B802U }, /* XSUM_XXH32_testdata[6136] */
    { 3068, 0x9E3779B1U, 0x26E5BE90U }, /* XSUM_XXH32_testdata[6137] */
    { 3069, 0x00000000U, 0x3B4B7916U }, /* XSUM_XXH32_testdata[6138] */
    { 3069, 0x9E3779B1U, 0x72E4B2A2U }, /* XSUM_XXH32_testdata[6139] */
    { 3070, 0x00000000U, 0x625DFF2CU }, /* XSUM_XXH32_testdata[6140] */
    { 3070, 0x9E3779B1U, 0x29B404B8U }, /* XSUM_XXH32_testdata[6141] */
    { 3071, 0x00000000U, 0x449F449CU }, /* XSUM_XXH32_testdata[6142] */
    { 3071, 0x9E3779B1U, 0xE9AD9AB3U }, /* XSUM_XXH32_testdata[6143] */
    { 3072, 0x00000000U, 0xA0FDFF1BU }, /* XSUM_XXH32_testdata[6144] */
    { 3072, 0x9E3779B1U, 0x67E35938U }, /* XSUM_XXH32_testdata[6145] */
    { 3073, 0x00000000U, 0xE7483D94U }, /* XSUM_XXH32_testdata[6146] */
    { 3073, 0x9E3779B1U, 0x566A16BDU }, /* XSUM_XXH32_testdata[6147] */
    { 3074, 0x00000000U, 0x00EA37A4U }, /* XSUM_XXH32_testdata[6148] */
    { 3074, 0x9E3779B1U, 0x29F448B2U }, /* XSUM_XXH32_testdata[6149] */
    { 3075, 0x00000000U, 0x053238F7U }, /* XSUM_XXH32_testdata[6150] */
    { 3075, 0x9E3779B1U, 0x957262A4U }, /* XSUM_XXH32_testdata[6151] */
    { 3076, 0x00000000U, 0xA3EB26E9U }, /* XSUM_XXH32_testdata[6152] */
    { 3076, 0x9E3779B1U, 0xDCF26BFCU }, /* XSUM_XXH32_testdata[6153] */
    { 3077, 0x00000000U, 0xE50C072DU }, /* XSUM_XXH32_testdata[6154] */
    { 3077, 0x9E3779B1U, 0xC56D7FF2U }, /* XSUM_XXH32_testdata[6155] */
    { 3078, 0x00000000U, 0xBD5A413EU }, /* XSUM_XXH32_testdata[6156] */
    { 3078, 0x9E3779B1U, 0x1BBBAC67U }, /* XSUM_XXH32_testdata[6157] */
    { 3079, 0x00000000U, 0x58F5D25FU }, /* XSUM_XXH32_testdata[6158] */
    { 3079, 0x9E3779B1U, 0x27668595U }, /* XSUM_XXH32_testdata[6159] */
    { 3080, 0x00000000U, 0x4BD9A8AAU }, /* XSUM_XXH32_testdata[6160] */
    { 3080, 0x9E3779B1U, 0x318CA866U }, /* XSUM_XXH32_testdata[6161] */
    { 3081, 0x00000000U, 0x1F2B243EU }, /* XSUM_XXH32_testdata[6162] */
    { 3081, 0x9E3779B1U, 0x51FF079AU }, /* XSUM_XXH32_testdata[6163] */
    { 3082, 0x00000000U, 0x75347DC4U }, /* XSUM_XXH32_testdata[6164] */
    { 3082, 0x9E3779B1U, 0x88703B3FU }, /* XSUM_XXH32_testdata[6165] */
    { 3083, 0x00000000U, 0x9BD5BAF2U }, /* XSUM_XXH32_testdata[6166] */
    { 3083, 0x9E3779B1U, 0xA2670D17U }, /* XSUM_XXH32_testdata[6167] */
    { 3084, 0x00000000U, 0xB6727943U }, /* XSUM_XXH32_testdata[6168] */
    { 3084, 0x9E3779B1U, 0x339583BBU }, /* XSUM_XXH32_testdata[6169] */
    { 3085, 0x00000000U, 0xCAEE49F3U }, /* XSUM_XXH32_testdata[6170] */
    { 3085, 0x9E3779B1U, 0xB30FD443U }, /* XSUM_XXH32_testdata[6171] */
    { 3086, 0x00000000U, 0x2AD794ABU }, /* XSUM_XXH32_testdata[6172] */
    { 3086, 0x9E3779B1U, 0x30BF0A02U }, /* XSUM_XXH32_testdata[6173] */
    { 3087, 0x00000000U, 0x8ECFAC3DU }, /* XSUM_XXH32_testdata[6174] */
    { 3087, 0x9E3779B1U, 0xA0320348U }, /* XSUM_XXH32_testdata[6175] */
    { 3088, 0x00000000U, 0xCEEB962BU }, /* XSUM_XXH32_testdata[6176] */
    { 3088, 0x9E3779B1U, 0xD2F41917U }, /* XSUM_XXH32_testdata[6177] */
    { 3089, 0x00000000U, 0x186BB4CEU }, /* XSUM_XXH32_testdata[6178] */
    { 3089, 0x9E3779B1U, 0xF9B675D1U }, /* XSUM_XXH32_testdata[6179] */
    { 3090, 0x00000000U, 0xAF0165C0U }, /* XSUM_XXH32_testdata[6180] */
    { 3090, 0x9E3779B1U, 0x19541AE7U }, /* XSUM_XXH32_testdata[6181] */
    { 3091, 0x00000000U, 0xA0B93DFAU }, /* XSUM_XXH32_testdata[6182] */
    { 3091, 0x9E3779B1U, 0xAFF891FFU }, /* XSUM_XXH32_testdata[6183] */
    { 3092, 0x00000000U, 0xAA524FCBU }, /* XSUM_XXH32_testdata[6184] */
    { 3092, 0x9E3779B1U, 0x54BEF5C6U }, /* XSUM_XXH32_testdata[6185] */
    { 3093, 0x00000000U, 0x2E513252U }, /* XSUM_XXH32_testdata[6186] */
    { 3093, 0x9E3779B1U, 0xF5B2F5A5U }, /* XSUM_XXH32_testdata[6187] */
    { 3094, 0x00000000U, 0xFDFB5811U }, /* XSUM_XXH32_testdata[6188] */
    { 3094, 0x9E3779B1U, 0x4C7D0E64U }, /* XSUM_XXH32_testdata[6189] */
    { 3095, 0x00000000U, 0x0B08D5F4U }, /* XSUM_XXH32_testdata[6190] */
    { 3095, 0x9E3779B1U, 0x0541E8D7U }, /* XSUM_XXH32_testdata[6191] */
    { 3096, 0x00000000U, 0x174F7F78U }, /* XSUM_XXH32_testdata[6192] */
    { 3096, 0x9E3779B1U, 0xBCD26B40U }, /* XSUM_XXH32_testdata[6193] */
    { 3097, 0x00000000U, 0x3B422793U }, /* XSUM_XXH32_testdata[6194] */
    { 3097, 0x9E3779B1U, 0x19FF9E1BU }, /* XSUM_XXH32_testdata[6195] */
    { 3098, 0x00000000U, 0xCB4C9567U }, /* XSUM_XXH32_testdata[6196] */
    { 3098, 0x9E3779B1U, 0x224AFEA0U }, /* XSUM_XXH32_testdata[6197] */
    { 3099, 0x00000000U, 0x79993C02U }, /* XSUM_XXH32_testdata[6198] */
    { 3099, 0x9E3779B1U, 0x12D464AFU }, /* XSUM_XXH32_testdata[6199] */
    { 3100, 0x00000000U, 0x833D2386U }, /* XSUM_XXH32_testdata[6200] */
    { 3100, 0x9E3779B1U, 0x332575C2U }, /* XSUM_XXH32_testdata[6201] */
    { 3101, 0x00000000U, 0x3BA959DBU }, /* XSUM_XXH32_testdata[6202] */
    { 3101, 0x9E3779B1U, 0x64EA3277U }, /* XSUM_XXH32_testdata[6203] */
    { 3102, 0x00000000U, 0x0B933AEDU }, /* XSUM_XXH32_testdata[6204] */
    { 3102, 0x9E3779B1U, 0x2C396C64U }, /* XSUM_XXH32_testdata[6205] */
    { 3103, 0x00000000U, 0xAB31C79EU }, /* XSUM_XXH32_testdata[6206] */
    { 3103, 0x9E3779B1U, 0x4DE25C64U }, /* XSUM_XXH32_testdata[6207] */
    { 3104, 0x00000000U, 0xF2F76764U }, /* XSUM_XXH32_testdata[6208] */
    { 3104, 0x9E3779B1U, 0x30D3520BU }, /* XSUM_XXH32_testdata[6209] */
    { 3105, 0x00000000U, 0x18099809U }, /* XSUM_XXH32_testdata[6210] */
    { 3105, 0x9E3779B1U, 0xCA479E4AU }, /* XSUM_XXH32_testdata[6211] */
    { 3106, 0x00000000U, 0xB620278DU }, /* XSUM_XXH32_testdata[6212] */
    { 3106, 0x9E3779B1U, 0x5A2F5AE2U }, /* XSUM_XXH32_testdata[6213] */
    { 3107, 0x00000000U, 0x8FAA78E5U }, /* XSUM_XXH32_testdata[6214] */
    { 3107, 0x9E3779B1U, 0x3E9DEEA2U }, /* XSUM_XXH32_testdata[6215] */
    { 3108, 0x00000000U, 0xC9A6E1ABU }, /* XSUM_XXH32_testdata[6216] */
    { 3108, 0x9E3779B1U, 0xE7E01671U }, /* XSUM_XXH32_testdata[6217] */
    { 3109, 0x00000000U, 0x71F31355U }, /* XSUM_XXH32_testdata[6218] */
    { 3109, 0x9E3779B1U, 0xA757003BU }, /* XSUM_XXH32_testdata[6219] */
    { 3110, 0x00000000U, 0x80FC6DEBU }, /* XSUM_XXH32_testdata[6220] */
    { 3110, 0x9E3779B1U, 0xF9C8D1B2U }, /* XSUM_XXH32_testdata[6221] */
    { 3111, 0x00000000U, 0xB7982649U }, /* XSUM_XXH32_testdata[6222] */
    { 3111, 0x9E3779B1U, 0x434F40DBU }, /* XSUM_XXH32_testdata[6223] */
    { 3112, 0x00000000U, 0x26397B91U }, /* XSUM_XXH32_testdata[6224] */
    { 3112, 0x9E3779B1U, 0xCBA9B3DFU }, /* XSUM_XXH32_testdata[6225] */
    { 3113, 0x00000000U, 0x00DEBAE6U }, /* XSUM_XXH32_testdata[6226] */
    { 3113, 0x9E3779B1U, 0x5202E198U }, /* XSUM_XXH32_testdata[6227] */
    { 3114, 0x00000000U, 0x47E96515U }, /* XSUM_XXH32_testdata[6228] */
    { 3114, 0x9E3779B1U, 0xD871FFC3U }, /* XSUM_XXH32_testdata[6229] */
    { 3115, 0x00000000U, 0x03EC5B87U }, /* XSUM_XXH32_testdata[6230] */
    { 3115, 0x9E3779B1U, 0xB64CD958U }, /* XSUM_XXH32_testdata[6231] */
    { 3116, 0x00000000U, 0x8164EC50U }, /* XSUM_XXH32_testdata[6232] */
    { 3116, 0x9E3779B1U, 0x0250BA05U }, /* XSUM_XXH32_testdata[6233] */
    { 3117, 0x00000000U, 0x598FF0FBU }, /* XSUM_XXH32_testdata[6234] */
    { 3117, 0x9E3779B1U, 0x342BA701U }, /* XSUM_XXH32_testdata[6235] */
    { 3118, 0x00000000U, 0x361F1A0AU }, /* XSUM_XXH32_testdata[6236] */
    { 3118, 0x9E3779B1U, 0x588F5B9CU }, /* XSUM_XXH32_testdata[6237] */
    { 3119, 0x00000000U, 0x1F8B80AAU }, /* XSUM_XXH32_testdata[6238] */
    { 3119, 0x9E3779B1U, 0xD8BEDE1BU }, /* XSUM_XXH32_testdata[6239] */
    { 3120, 0x00000000U, 0x4FEE03B1U }, /* XSUM_XXH32_testdata[6240] */
    { 3120, 0x9E3779B1U, 0x23DB3750U }, /* XSUM_XXH32_testdata[6241] */
    { 3121, 0x00000000U, 0x16C4B329U }, /* XSUM_XXH32_testdata[6242] */
    { 3121, 0x9E3779B1U, 0x751AFB46U }, /* XSUM_XXH32_testdata[6243] */
    { 3122, 0x00000000U, 0x74F2D8D3U }, /* XSUM_XXH32_testdata[6244] */
    { 3122, 0x9E3779B1U, 0xF8BCDCBCU }, /* XSUM_XXH32_testdata[6245] */
    { 3123, 0x00000000U, 0x1DA68D82U }, /* XSUM_XXH32_testdata[6246] */
    { 3123, 0x9E3779B1U, 0x4E3CB62AU }, /* XSUM_XXH32_testdata[6247] */
    { 3124, 0x00000000U, 0x471A6C7EU }, /* XSUM_XXH32_testdata[6248] */
    { 3124, 0x9E3779B1U, 0xD9C5D9F6U }, /* XSUM_XXH32_testdata[6249] */
    { 3125, 0x00000000U, 0xC71BD5AAU }, /* XSUM_XXH32_testdata[6250] */
    { 3125, 0x9E3779B1U, 0xB402481FU }, /* XSUM_XXH32_testdata[6251] */
    { 3126, 0x00000000U, 0xDFBB31E5U }, /* XSUM_XXH32_testdata[6252] */
    { 3126, 0x9E3779B1U, 0xACDDED03U }, /* XSUM_XXH32_testdata[6253] */
    { 3127, 0x00000000U, 0xA088651FU }, /* XSUM_XXH32_testdata[6254] */
    { 3127, 0x9E3779B1U, 0x9E391935U }, /* XSUM_XXH32_testdata[6255] */
    { 3128, 0x00000000U, 0x2849F292U }, /* XSUM_XXH32_testdata[6256] */
    { 3128, 0x9E3779B1U, 0x8F1F943FU }, /* XSUM_XXH32_testdata[6257] */
    { 3129, 0x00000000U, 0x7D1EA42DU }, /* XSUM_XXH32_testdata[6258] */
    { 3129, 0x9E3779B1U, 0x6F54117CU }, /* XSUM_XXH32_testdata[6259] */
    { 3130, 0x00000000U, 0x4896187BU }, /* XSUM_XXH32_testdata[6260] */
    { 3130, 0x9E3779B1U, 0x6496E34FU }, /* XSUM_XXH32_testdata[6261] */
    { 3131, 0x00000000U, 0x7997DF9CU }, /* XSUM_XXH32_testdata[6262] */
    { 3131, 0x9E3779B1U, 0x6B8184D4U }, /* XSUM_XXH32_testdata[6263] */
    { 3132, 0x00000000U, 0x0C2D23BDU }, /* XSUM_XXH32_testdata[6264] */
    { 3132, 0x9E3779B1U, 0x45D10366U }, /* XSUM_XXH32_testdata[6265] */
    { 3133, 0x00000000U, 0x33D90B93U }, /* XSUM_XXH32_testdata[6266] */
    { 3133, 0x9E3779B1U, 0x087A7D97U }, /* XSUM_XXH32_testdata[6267] */
    { 3134, 0x00000000U, 0xAF4AA558U }, /* XSUM_XXH32_testdata[6268] */
    { 3134, 0x9E3779B1U, 0x61497C38U }, /* XSUM_XXH32_testdata[6269] */
    { 3135, 0x00000000U, 0xEE45D13BU }, /* XSUM_XXH32_testdata[6270] */
    { 3135, 0x9E3779B1U, 0xB08E73A5U }, /* XSUM_XXH32_testdata[6271] */
    { 3136, 0x00000000U, 0xD235FE2DU }, /* XSUM_XXH32_testdata[6272] */
    { 3136, 0x9E3779B1U, 0xFE40CD43U }, /* XSUM_XXH32_testdata[6273] */
    { 3137, 0x00000000U, 0xD12843BEU }, /* XSUM_XXH32_testdata[6274] */
    { 3137, 0x9E3779B1U, 0xF1FD0CBEU }, /* XSUM_XXH32_testdata[6275] */
    { 3138, 0x00000000U, 0x264EB7F5U }, /* XSUM_XXH32_testdata[6276] */
    { 3138, 0x9E3779B1U, 0x02B75CFFU }, /* XSUM_XXH32_testdata[6277] */
    { 3139, 0x00000000U, 0x8C7DFB2FU }, /* XSUM_XXH32_testdata[6278] */
    { 3139, 0x9E3779B1U, 0xEC45FCE8U }, /* XSUM_XXH32_testdata[6279] */
    { 3140, 0x00000000U, 0x9146025EU }, /* XSUM_XXH32_testdata[6280] */
    { 3140, 0x9E3779B1U, 0x1F38B156U }, /* XSUM_XXH32_testdata[6281] */
    { 3141, 0x00000000U, 0x5FF2766DU }, /* XSUM_XXH32_testdata[6282] */
    { 3141, 0x9E3779B1U, 0xA5413F98U }, /* XSUM_XXH32_testdata[6283] */
    { 3142, 0x00000000U, 0xA88969E3U }, /* XSUM_XXH32_testdata[6284] */
    { 3142, 0x9E3779B1U, 0x55805C1EU }, /* XSUM_XXH32_testdata[6285] */
    { 3143, 0x00000000U, 0x9283DCF7U }, /* XSUM_XXH32_testdata[6286] */
    { 3143, 0x9E3779B1U, 0x1A6B8D1DU }, /* XSUM_XXH32_testdata[6287] */
    { 3144, 0x00000000U, 0x37318368U }, /* XSUM_XXH32_testdata[6288] */
    { 3144, 0x9E3779B1U, 0xFE217DF2U }, /* XSUM_XXH32_testdata[6289] */
    { 3145, 0x00000000U, 0x65E78447U }, /* XSUM_XXH32_testdata[6290] */
    { 3145, 0x9E3779B1U, 0xB5E1F43CU }, /* XSUM_XXH32_testdata[6291] */
    { 3146, 0x00000000U, 0x59069A59U }, /* XSUM_XXH32_testdata[6292] */
    { 3146, 0x9E3779B1U, 0x860F50C8U }, /* XSUM_XXH32_testdata[6293] */
    { 3147, 0x00000000U, 0x3C9225C4U }, /* XSUM_XXH32_testdata[6294] */
    { 3147, 0x9E3779B1U, 0xDB0DF5B5U }, /* XSUM_XXH32_testdata[6295] */
    { 3148, 0x00000000U, 0x7747A93EU }, /* XSUM_XXH32_testdata[6296] */
    { 3148, 0x9E3779B1U, 0x031DF7FDU }, /* XSUM_XXH32_testdata[6297] */
    { 3149, 0x00000000U, 0xA195194BU }, /* XSUM_XXH32_testdata[6298] */
    { 3149, 0x9E3779B1U, 0xF6475F00U }, /* XSUM_XXH32_testdata[6299] */
    { 3150, 0x00000000U, 0xBD2CE7F4U }, /* XSUM_XXH32_testdata[6300] */
    { 3150, 0x9E3779B1U, 0x80BE1634U }, /* XSUM_XXH32_testdata[6301] */
    { 3151, 0x00000000U, 0xA2F026E9U }, /* XSUM_XXH32_testdata[6302] */
    { 3151, 0x9E3779B1U, 0x4E2A5D06U }, /* XSUM_XXH32_testdata[6303] */
    { 3152, 0x00000000U, 0xEF5C95F2U }, /* XSUM_XXH32_testdata[6304] */
    { 3152, 0x9E3779B1U, 0xC301871FU }, /* XSUM_XXH32_testdata[6305] */
    { 3153, 0x00000000U, 0x112EE61CU }, /* XSUM_XXH32_testdata[6306] */
    { 3153, 0x9E3779B1U, 0xF76C766DU }, /* XSUM_XXH32_testdata[6307] */
    { 3154, 0x00000000U, 0x8EC20863U }, /* XSUM_XXH32_testdata[6308] */
    { 3154, 0x9E3779B1U, 0xF2A61858U }, /* XSUM_XXH32_testdata[6309] */
    { 3155, 0x00000000U, 0xEBB89A0FU }, /* XSUM_XXH32_testdata[6310] */
    { 3155, 0x9E3779B1U, 0x22C16BCBU }, /* XSUM_XXH32_testdata[6311] */
    { 3156, 0x00000000U, 0xB496ED4FU }, /* XSUM_XXH32_testdata[6312] */
    { 3156, 0x9E3779B1U, 0x419F8EE7U }, /* XSUM_XXH32_testdata[6313] */
    { 3157, 0x00000000U, 0x611F6C8CU }, /* XSUM_XXH32_testdata[6314] */
    { 3157, 0x9E3779B1U, 0x5C7EF2CAU }, /* XSUM_XXH32_testdata[6315] */
    { 3158, 0x00000000U, 0xB9CA36BCU }, /* XSUM_XXH32_testdata[6316] */
    { 3158, 0x9E3779B1U, 0xD95D24EEU }, /* XSUM_XXH32_testdata[6317] */
    { 3159, 0x00000000U, 0xC94B8371U }, /* XSUM_XXH32_testdata[6318] */
    { 3159, 0x9E3779B1U, 0x532BD4BCU }, /* XSUM_XXH32_testdata[6319] */
    { 3160, 0x00000000U, 0x0713B8A6U }, /* XSUM_XXH32_testdata[6320] */
    { 3160, 0x9E3779B1U, 0xE2490945U }, /* XSUM_XXH32_testdata[6321] */
    { 3161, 0x00000000U, 0x14E2DDAEU }, /* XSUM_XXH32_testdata[6322] */
    { 3161, 0x9E3779B1U, 0x877A32C8U }, /* XSUM_XXH32_testdata[6323] */
    { 3162, 0x00000000U, 0x7EEC98C5U }, /* XSUM_XXH32_testdata[6324] */
    { 3162, 0x9E3779B1U, 0xEF999B5CU }, /* XSUM_XXH32_testdata[6325] */
    { 3163, 0x00000000U, 0xD21604D0U }, /* XSUM_XXH32_testdata[6326] */
    { 3163, 0x9E3779B1U, 0x192C3A4EU }, /* XSUM_XXH32_testdata[6327] */
    { 3164, 0x00000000U, 0x5C9A13EFU }, /* XSUM_XXH32_testdata[6328] */
    { 3164, 0x9E3779B1U, 0x40AF4518U }, /* XSUM_XXH32_testdata[6329] */
    { 3165, 0x00000000U, 0xC5088103U }, /* XSUM_XXH32_testdata[6330] */
    { 3165, 0x9E3779B1U, 0xC613F458U }, /* XSUM_XXH32_testdata[6331] */
    { 3166, 0x00000000U, 0x0D89262FU }, /* XSUM_XXH32_testdata[6332] */
    { 3166, 0x9E3779B1U, 0x313ED00CU }, /* XSUM_XXH32_testdata[6333] */
    { 3167, 0x00000000U, 0x965FEE6BU }, /* XSUM_XXH32_testdata[6334] */
    { 3167, 0x9E3779B1U, 0x53FD0764U }, /* XSUM_XXH32_testdata[6335] */
    { 3168, 0x00000000U, 0x09D04E0FU }, /* XSUM_XXH32_testdata[6336] */
    { 3168, 0x9E3779B1U, 0xB4378BE3U }, /* XSUM_XXH32_testdata[6337] */
    { 3169, 0x00000000U, 0xAE61180AU }, /* XSUM_XXH32_testdata[6338] */
    { 3169, 0x9E3779B1U, 0x330D2027U }, /* XSUM_XXH32_testdata[6339] */
    { 3170, 0x00000000U, 0x115A2C00U }, /* XSUM_XXH32_testdata[6340] */
    { 3170, 0x9E3779B1U, 0x5DB53F41U }, /* XSUM_XXH32_testdata[6341] */
    { 3171, 0x00000000U, 0xF96AE1B0U }, /* XSUM_XXH32_testdata[6342] */
    { 3171, 0x9E3779B1U, 0xE269BB5CU }, /* XSUM_XXH32_testdata[6343] */
    { 3172, 0x00000000U, 0xFB374AAFU }, /* XSUM_XXH32_testdata[6344] */
    { 3172, 0x9E3779B1U, 0xD5DFB27EU }, /* XSUM_XXH32_testdata[6345] */
    { 3173, 0x00000000U, 0x212415C0U }, /* XSUM_XXH32_testdata[6346] */
    { 3173, 0x9E3779B1U, 0xFB23A2BEU }, /* XSUM_XXH32_testdata[6347] */
    { 3174, 0x00000000U, 0x0FF88F21U }, /* XSUM_XXH32_testdata[6348] */
    { 3174, 0x9E3779B1U, 0xAC6B2D0CU }, /* XSUM_XXH32_testdata[6349] */
    { 3175, 0x00000000U, 0x2B0AC506U }, /* XSUM_XXH32_testdata[6350] */
    { 3175, 0x9E3779B1U, 0xE2CD58E9U }, /* XSUM_XXH32_testdata[6351] */
    { 3176, 0x00000000U, 0x0E676CF2U }, /* XSUM_XXH32_testdata[6352] */
    { 3176, 0x9E3779B1U, 0x17B54D7EU }, /* XSUM_XXH32_testdata[6353] */
    { 3177, 0x00000000U, 0x62421C20U }, /* XSUM_XXH32_testdata[6354] */
    { 3177, 0x9E3779B1U, 0xB4D551BBU }, /* XSUM_XXH32_testdata[6355] */
    { 3178, 0x00000000U, 0x35816186U }, /* XSUM_XXH32_testdata[6356] */
    { 3178, 0x9E3779B1U, 0xB05D3C93U }, /* XSUM_XXH32_testdata[6357] */
    { 3179, 0x00000000U, 0x90EE14C0U }, /* XSUM_XXH32_testdata[6358] */
    { 3179, 0x9E3779B1U, 0x45D85FA8U }, /* XSUM_XXH32_testdata[6359] */
    { 3180, 0x00000000U, 0xC4ECE2CEU }, /* XSUM_XXH32_testdata[6360] */
    { 3180, 0x9E3779B1U, 0xA092A0F6U }, /* XSUM_XXH32_testdata[6361] */
    { 3181, 0x00000000U, 0x2155D5C7U }, /* XSUM_XXH32_testdata[6362] */
    { 3181, 0x9E3779B1U, 0xC55B2AEAU }, /* XSUM_XXH32_testdata[6363] */
    { 3182, 0x00000000U, 0x17639761U }, /* XSUM_XXH32_testdata[6364] */
    { 3182, 0x9E3779B1U, 0x529DF2B9U }, /* XSUM_XXH32_testdata[6365] */
    { 3183, 0x00000000U, 0x0BA30CB0U }, /* XSUM_XXH32_testdata[6366] */
    { 3183, 0x9E3779B1U, 0x18813F17U }, /* XSUM_XXH32_testdata[6367] */
    { 3184, 0x00000000U, 0xCC152381U }, /* XSUM_XXH32_testdata[6368] */
    { 3184, 0x9E3779B1U, 0xE548D846U }, /* XSUM_XXH32_testdata[6369] */
    { 3185, 0x00000000U, 0x8918EC23U }, /* XSUM_XXH32_testdata[6370] */
    { 3185, 0x9E3779B1U, 0xD118CA7DU }, /* XSUM_XXH32_testdata[6371] */
    { 3186, 0x00000000U, 0x40AF52E9U }, /* XSUM_XXH32_testdata[6372] */
    { 3186, 0x9E3779B1U, 0x6664BF7BU }, /* XSUM_XXH32_testdata[6373] */
    { 3187, 0x00000000U, 0x6ACE34EDU }, /* XSUM_XXH32_testdata[6374] */
    { 3187, 0x9E3779B1U, 0x57488E57U }, /* XSUM_XXH32_testdata[6375] */
    { 3188, 0x00000000U, 0xAD9D0E93U }, /* XSUM_XXH32_testdata[6376] */
    { 3188, 0x9E3779B1U, 0xA4560825U }, /* XSUM_XXH32_testdata[6377] */
    { 3189, 0x00000000U, 0xF5DEF529U }, /* XSUM_XXH32_testdata[6378] */
    { 3189, 0x9E3779B1U, 0xFCE7A71DU }, /* XSUM_XXH32_testdata[6379] */
    { 3190, 0x00000000U, 0x403D7389U }, /* XSUM_XXH32_testdata[6380] */
    { 3190, 0x9E3779B1U, 0xABDB9466U }, /* XSUM_XXH32_testdata[6381] */
    { 3191, 0x00000000U, 0xC3D5BFEBU }, /* XSUM_XXH32_testdata[6382] */
    { 3191, 0x9E3779B1U, 0x7904F565U }, /* XSUM_XXH32_testdata[6383] */
    { 3192, 0x00000000U, 0xCD931FA8U }, /* XSUM_XXH32_testdata[6384] */
    { 3192, 0x9E3779B1U, 0x45C5A5C4U }, /* XSUM_XXH32_testdata[6385] */
    { 3193, 0x00000000U, 0x756DB004U }, /* XSUM_XXH32_testdata[6386] */
    { 3193, 0x9E3779B1U, 0x53280EDEU }, /* XSUM_XXH32_testdata[6387] */
    { 3194, 0x00000000U, 0x106C7308U }, /* XSUM_XXH32_testdata[6388] */
    { 3194, 0x9E3779B1U, 0x93A20298U }, /* XSUM_XXH32_testdata[6389] */
    { 3195, 0x00000000U, 0x04E4CE1CU }, /* XSUM_XXH32_testdata[6390] */
    { 3195, 0x9E3779B1U, 0x6A2726FFU }, /* XSUM_XXH32_testdata[6391] */
    { 3196, 0x00000000U, 0x246BC429U }, /* XSUM_XXH32_testdata[6392] */
    { 3196, 0x9E3779B1U, 0xFFBAE096U }, /* XSUM_XXH32_testdata[6393] */
    { 3197, 0x00000000U, 0x8E3FDEE9U }, /* XSUM_XXH32_testdata[6394] */
    { 3197, 0x9E3779B1U, 0xE8B5A42EU }, /* XSUM_XXH32_testdata[6395] */
    { 3198, 0x00000000U, 0x6BD846A6U }, /* XSUM_XXH32_testdata[6396] */
    { 3198, 0x9E3779B1U, 0x7CEFF93FU }, /* XSUM_XXH32_testdata[6397] */
    { 3199, 0x00000000U, 0xC1B4CAFAU }, /* XSUM_XXH32_testdata[6398] */
    { 3199, 0x9E3779B1U, 0xD936CDCEU }, /* XSUM_XXH32_testdata[6399] */
    { 3200, 0x00000000U, 0xE0342D1DU }, /* XSUM_XXH32_testdata[6400] */
    { 3200, 0x9E3779B1U, 0xA5385573U }, /* XSUM_XXH32_testdata[6401] */
    { 3201, 0x00000000U, 0xF619D53CU }, /* XSUM_XXH32_testdata[6402] */
    { 3201, 0x9E3779B1U, 0xD3253FC8U }, /* XSUM_XXH32_testdata[6403] */
    { 3202, 0x00000000U, 0x19ADCC70U }, /* XSUM_XXH32_testdata[6404] */
    { 3202, 0x9E3779B1U, 0xF3ADCBF6U }, /* XSUM_XXH32_testdata[6405] */
    { 3203, 0x00000000U, 0x1DC16C5BU }, /* XSUM_XXH32_testdata[6406] */
    { 3203, 0x9E3779B1U, 0x5EA1E98FU }, /* XSUM_XXH32_testdata[6407] */
    { 3204, 0x00000000U, 0xC99E62DBU }, /* XSUM_XXH32_testdata[6408] */
    { 3204, 0x9E3779B1U, 0x16AA36C0U }, /* XSUM_XXH32_testdata[6409] */
    { 3205, 0x00000000U, 0x265E1D17U }, /* XSUM_XXH32_testdata[6410] */
    { 3205, 0x9E3779B1U, 0x94A4586DU }, /* XSUM_XXH32_testdata[6411] */
    { 3206, 0x00000000U, 0xCD877560U }, /* XSUM_XXH32_testdata[6412] */
    { 3206, 0x9E3779B1U, 0x0DA48480U }, /* XSUM_XXH32_testdata[6413] */
    { 3207, 0x00000000U, 0x00592DEFU }, /* XSUM_XXH32_testdata[6414] */
    { 3207, 0x9E3779B1U, 0x51CCAEDAU }, /* XSUM_XXH32_testdata[6415] */
    { 3208, 0x00000000U, 0x445C408FU }, /* XSUM_XXH32_testdata[6416] */
    { 3208, 0x9E3779B1U, 0x3856ADA4U }, /* XSUM_XXH32_testdata[6417] */
    { 3209, 0x00000000U, 0x9741E838U }, /* XSUM_XXH32_testdata[6418] */
    { 3209, 0x9E3779B1U, 0x1BDF26D8U }, /* XSUM_XXH32_testdata[6419] */
    { 3210, 0x00000000U, 0x1417F232U }, /* XSUM_XXH32_testdata[6420] */
    { 3210, 0x9E3779B1U, 0x62DD81B7U }, /* XSUM_XXH32_testdata[6421] */
    { 3211, 0x00000000U, 0x62DA5B7CU }, /* XSUM_XXH32_testdata[6422] */
    { 3211, 0x9E3779B1U, 0x5B196DA5U }, /* XSUM_XXH32_testdata[6423] */
    { 3212, 0x00000000U, 0x3B069509U }, /* XSUM_XXH32_testdata[6424] */
    { 3212, 0x9E3779B1U, 0x5B29F17AU }, /* XSUM_XXH32_testdata[6425] */
    { 3213, 0x00000000U, 0xC5A43851U }, /* XSUM_XXH32_testdata[6426] */
    { 3213, 0x9E3779B1U, 0xB25ADC0EU }, /* XSUM_XXH32_testdata[6427] */
    { 3214, 0x00000000U, 0xCC590B5AU }, /* XSUM_XXH32_testdata[6428] */
    { 3214, 0x9E3779B1U, 0x007C1AD1U }, /* XSUM_XXH32_testdata[6429] */
    { 3215, 0x00000000U, 0xA8607CE5U }, /* XSUM_XXH32_testdata[6430] */
    { 3215, 0x9E3779B1U, 0xA573BD8CU }, /* XSUM_XXH32_testdata[6431] */
    { 3216, 0x00000000U, 0x42F28507U }, /* XSUM_XXH32_testdata[6432] */
    { 3216, 0x9E3779B1U, 0x6D4E9010U }, /* XSUM_XXH32_testdata[6433] */
    { 3217, 0x00000000U, 0x839D5D2DU }, /* XSUM_XXH32_testdata[6434] */
    { 3217, 0x9E3779B1U, 0x574C747CU }, /* XSUM_XXH32_testdata[6435] */
    { 3218, 0x00000000U, 0x1771DE8AU }, /* XSUM_XXH32_testdata[6436] */
    { 3218, 0x9E3779B1U, 0x93F7D225U }, /* XSUM_XXH32_testdata[6437] */
    { 3219, 0x00000000U, 0x95534138U }, /* XSUM_XXH32_testdata[6438] */
    { 3219, 0x9E3779B1U, 0x102DBB95U }, /* XSUM_XXH32_testdata[6439] */
    { 3220, 0x00000000U, 0x05ABC536U }, /* XSUM_XXH32_testdata[6440] */
    { 3220, 0x9E3779B1U, 0xD753739BU }, /* XSUM_XXH32_testdata[6441] */
    { 3221, 0x00000000U, 0xEE982049U }, /* XSUM_XXH32_testdata[6442] */
    { 3221, 0x9E3779B1U, 0x959F3AA2U }, /* XSUM_XXH32_testdata[6443] */
    { 3222, 0x00000000U, 0x73868AFFU }, /* XSUM_XXH32_testdata[6444] */
    { 3222, 0x9E3779B1U, 0xAC70F02EU }, /* XSUM_XXH32_testdata[6445] */
    { 3223, 0x00000000U, 0xF75C05ECU }, /* XSUM_XXH32_testdata[6446] */
    { 3223, 0x9E3779B1U, 0x99CAF52FU }, /* XSUM_XXH32_testdata[6447] */
    { 3224, 0x00000000U, 0xBC3692D0U }, /* XSUM_XXH32_testdata[6448] */
    { 3224, 0x9E3779B1U, 0x81AC3805U }, /* XSUM_XXH32_testdata[6449] */
    { 3225, 0x00000000U, 0x680E5B4DU }, /* XSUM_XXH32_testdata[6450] */
    { 3225, 0x9E3779B1U, 0x4B1EF946U }, /* XSUM_XXH32_testdata[6451] */
    { 3226, 0x00000000U, 0x019B60A0U }, /* XSUM_XXH32_testdata[6452] */
    { 3226, 0x9E3779B1U, 0x2937E9F3U }, /* XSUM_XXH32_testdata[6453] */
    { 3227, 0x00000000U, 0x2F301897U }, /* XSUM_XXH32_testdata[6454] */
    { 3227, 0x9E3779B1U, 0x6185A47AU }, /* XSUM_XXH32_testdata[6455] */
    { 3228, 0x00000000U, 0xA7869CF4U }, /* XSUM_XXH32_testdata[6456] */
    { 3228, 0x9E3779B1U, 0x609D5F20U }, /* XSUM_XXH32_testdata[6457] */
    { 3229, 0x00000000U, 0x8819EF16U }, /* XSUM_XXH32_testdata[6458] */
    { 3229, 0x9E3779B1U, 0x6D4AA29DU }, /* XSUM_XXH32_testdata[6459] */
    { 3230, 0x00000000U, 0x06F31D35U }, /* XSUM_XXH32_testdata[6460] */
    { 3230, 0x9E3779B1U, 0x05DBEF3FU }, /* XSUM_XXH32_testdata[6461] */
    { 3231, 0x00000000U, 0x741E61C3U }, /* XSUM_XXH32_testdata[6462] */
    { 3231, 0x9E3779B1U, 0x4A0AD26DU }, /* XSUM_XXH32_testdata[6463] */
    { 3232, 0x00000000U, 0x856224CDU }, /* XSUM_XXH32_testdata[6464] */
    { 3232, 0x9E3779B1U, 0x972BF207U }, /* XSUM_XXH32_testdata[6465] */
    { 3233, 0x00000000U, 0xCA67A7CCU }, /* XSUM_XXH32_testdata[6466] */
    { 3233, 0x9E3779B1U, 0xB910A3C8U }, /* XSUM_XXH32_testdata[6467] */
    { 3234, 0x00000000U, 0x655C5B3AU }, /* XSUM_XXH32_testdata[6468] */
    { 3234, 0x9E3779B1U, 0x6FE6356AU }, /* XSUM_XXH32_testdata[6469] */
    { 3235, 0x00000000U, 0x25B00DDAU }, /* XSUM_XXH32_testdata[6470] */
    { 3235, 0x9E3779B1U, 0x2C7197EBU }, /* XSUM_XXH32_testdata[6471] */
    { 3236, 0x00000000U, 0x4AD29ACBU }, /* XSUM_XXH32_testdata[6472] */
    { 3236, 0x9E3779B1U, 0x111614C2U }, /* XSUM_XXH32_testdata[6473] */
    { 3237, 0x00000000U, 0x1AA35D49U }, /* XSUM_XXH32_testdata[6474] */
    { 3237, 0x9E3779B1U, 0x41BC4F23U }, /* XSUM_XXH32_testdata[6475] */
    { 3238, 0x00000000U, 0xF7B66E12U }, /* XSUM_XXH32_testdata[6476] */
    { 3238, 0x9E3779B1U, 0x0B48F6B8U }, /* XSUM_XXH32_testdata[6477] */
    { 3239, 0x00000000U, 0x204E3726U }, /* XSUM_XXH32_testdata[6478] */
    { 3239, 0x9E3779B1U, 0x18E915A1U }, /* XSUM_XXH32_testdata[6479] */
    { 3240, 0x00000000U, 0x95E7D6EAU }, /* XSUM_XXH32_testdata[6480] */
    { 3240, 0x9E3779B1U, 0x6E612374U }, /* XSUM_XXH32_testdata[6481] */
    { 3241, 0x00000000U, 0x61754B6BU }, /* XSUM_XXH32_testdata[6482] */
    { 3241, 0x9E3779B1U, 0xB623D164U }, /* XSUM_XXH32_testdata[6483] */
    { 3242, 0x00000000U, 0x085B90DBU }, /* XSUM_XXH32_testdata[6484] */
    { 3242, 0x9E3779B1U, 0x6331B57BU }, /* XSUM_XXH32_testdata[6485] */
    { 3243, 0x00000000U, 0x476C0FFFU }, /* XSUM_XXH32_testdata[6486] */
    { 3243, 0x9E3779B1U, 0xE28C1525U }, /* XSUM_XXH32_testdata[6487] */
    { 3244, 0x00000000U, 0x8D803DB5U }, /* XSUM_XXH32_testdata[6488] */
    { 3244, 0x9E3779B1U, 0x3199AB10U }, /* XSUM_XXH32_testdata[6489] */
    { 3245, 0x00000000U, 0xF488DA7FU }, /* XSUM_XXH32_testdata[6490] */
    { 3245, 0x9E3779B1U, 0x5F7DA49EU }, /* XSUM_XXH32_testdata[6491] */
    { 3246, 0x00000000U, 0x8812A715U }, /* XSUM_XXH32_testdata[6492] */
    { 3246, 0x9E3779B1U, 0x917B42E4U }, /* XSUM_XXH32_testdata[6493] */
    { 3247, 0x00000000U, 0x5F4C12EEU }, /* XSUM_XXH32_testdata[6494] */
    { 3247, 0x9E3779B1U, 0x35A623D9U }, /* XSUM_XXH32_testdata[6495] */
    { 3248, 0x00000000U, 0x600E82ADU }, /* XSUM_XXH32_testdata[6496] */
    { 3248, 0x9E3779B1U, 0x8AD5A40BU }, /* XSUM_XXH32_testdata[6497] */
    { 3249, 0x00000000U, 0x23BE9DCBU }, /* XSUM_XXH32_testdata[6498] */
    { 3249, 0x9E3779B1U, 0x3491D915U }, /* XSUM_XXH32_testdata[6499] */
    { 3250, 0x00000000U, 0x4CAD4682U }, /* XSUM_XXH32_testdata[6500] */
    { 3250, 0x9E3779B1U, 0x6FE0CEC1U }, /* XSUM_XXH32_testdata[6501] */
    { 3251, 0x00000000U, 0xD1E7C008U }, /* XSUM_XXH32_testdata[6502] */
    { 3251, 0x9E3779B1U, 0x5DBE5109U }, /* XSUM_XXH32_testdata[6503] */
    { 3252, 0x00000000U, 0x3013DBCFU }, /* XSUM_XXH32_testdata[6504] */
    { 3252, 0x9E3779B1U, 0x11640895U }, /* XSUM_XXH32_testdata[6505] */
    { 3253, 0x00000000U, 0x386A63A5U }, /* XSUM_XXH32_testdata[6506] */
    { 3253, 0x9E3779B1U, 0x4473A915U }, /* XSUM_XXH32_testdata[6507] */
    { 3254, 0x00000000U, 0x10BDF5D0U }, /* XSUM_XXH32_testdata[6508] */
    { 3254, 0x9E3779B1U, 0x182894D9U }, /* XSUM_XXH32_testdata[6509] */
    { 3255, 0x00000000U, 0xC6E614F4U }, /* XSUM_XXH32_testdata[6510] */
    { 3255, 0x9E3779B1U, 0x91906BF1U }, /* XSUM_XXH32_testdata[6511] */
    { 3256, 0x00000000U, 0xB93BC1D1U }, /* XSUM_XXH32_testdata[6512] */
    { 3256, 0x9E3779B1U, 0xC22C454FU }, /* XSUM_XXH32_testdata[6513] */
    { 3257, 0x00000000U, 0xAA6B81D5U }, /* XSUM_XXH32_testdata[6514] */
    { 3257, 0x9E3779B1U, 0xFEC51FE4U }, /* XSUM_XXH32_testdata[6515] */
    { 3258, 0x00000000U, 0xC0126AEDU }, /* XSUM_XXH32_testdata[6516] */
    { 3258, 0x9E3779B1U, 0xBA3A1845U }, /* XSUM_XXH32_testdata[6517] */
    { 3259, 0x00000000U, 0x3EC9BC82U }, /* XSUM_XXH32_testdata[6518] */
    { 3259, 0x9E3779B1U, 0xEBB0C4A6U }, /* XSUM_XXH32_testdata[6519] */
    { 3260, 0x00000000U, 0xC6858062U }, /* XSUM_XXH32_testdata[6520] */
    { 3260, 0x9E3779B1U, 0x40FA8953U }, /* XSUM_XXH32_testdata[6521] */
    { 3261, 0x00000000U, 0xC6774D9FU }, /* XSUM_XXH32_testdata[6522] */
    { 3261, 0x9E3779B1U, 0x3DDF5844U }, /* XSUM_XXH32_testdata[6523] */
    { 3262, 0x00000000U, 0x2C0441B5U }, /* XSUM_XXH32_testdata[6524] */
    { 3262, 0x9E3779B1U, 0x27F83A50U }, /* XSUM_XXH32_testdata[6525] */
    { 3263, 0x00000000U, 0xFAE26B64U }, /* XSUM_XXH32_testdata[6526] */
    { 3263, 0x9E3779B1U, 0x54963B15U }, /* XSUM_XXH32_testdata[6527] */
    { 3264, 0x00000000U, 0x8E95005CU }, /* XSUM_XXH32_testdata[6528] */
    { 3264, 0x9E3779B1U, 0x40337F85U }, /* XSUM_XXH32_testdata[6529] */
    { 3265, 0x00000000U, 0x93AFC1C9U }, /* XSUM_XXH32_testdata[6530] */
    { 3265, 0x9E3779B1U, 0x19F2A63CU }, /* XSUM_XXH32_testdata[6531] */
    { 3266, 0x00000000U, 0x484E3BF5U }, /* XSUM_XXH32_testdata[6532] */
    { 3266, 0x9E3779B1U, 0x4EDD46CAU }, /* XSUM_XXH32_testdata[6533] */
    { 3267, 0x00000000U, 0x35B83394U }, /* XSUM_XXH32_testdata[6534] */
    { 3267, 0x9E3779B1U, 0x3052221CU }, /* XSUM_XXH32_testdata[6535] */
    { 3268, 0x00000000U, 0x1F2BECC8U }, /* XSUM_XXH32_testdata[6536] */
    { 3268, 0x9E3779B1U, 0xD01AD33CU }, /* XSUM_XXH32_testdata[6537] */
    { 3269, 0x00000000U, 0xD99E9DB5U }, /* XSUM_XXH32_testdata[6538] */
    { 3269, 0x9E3779B1U, 0xD988BDD6U }, /* XSUM_XXH32_testdata[6539] */
    { 3270, 0x00000000U, 0x64E5A176U }, /* XSUM_XXH32_testdata[6540] */
    { 3270, 0x9E3779B1U, 0x6514AB22U }, /* XSUM_XXH32_testdata[6541] */
    { 3271, 0x00000000U, 0x8ECB2A37U }, /* XSUM_XXH32_testdata[6542] */
    { 3271, 0x9E3779B1U, 0x5EB59754U }, /* XSUM_XXH32_testdata[6543] */
    { 3272, 0x00000000U, 0x001A88FDU }, /* XSUM_XXH32_testdata[6544] */
    { 3272, 0x9E3779B1U, 0x6C99D017U }, /* XSUM_XXH32_testdata[6545] */
    { 3273, 0x00000000U, 0x70C5F135U }, /* XSUM_XXH32_testdata[6546] */
    { 3273, 0x9E3779B1U, 0xB93B796DU }, /* XSUM_XXH32_testdata[6547] */
    { 3274, 0x00000000U, 0x3E8BE3C1U }, /* XSUM_XXH32_testdata[6548] */
    { 3274, 0x9E3779B1U, 0xEA03C59EU }, /* XSUM_XXH32_testdata[6549] */
    { 3275, 0x00000000U, 0x999E80DDU }, /* XSUM_XXH32_testdata[6550] */
    { 3275, 0x9E3779B1U, 0xD7876DEDU }, /* XSUM_XXH32_testdata[6551] */
    { 3276, 0x00000000U, 0x4A617B84U }, /* XSUM_XXH32_testdata[6552] */
    { 3276, 0x9E3779B1U, 0x0E09E1B4U }, /* XSUM_XXH32_testdata[6553] */
    { 3277, 0x00000000U, 0xFA0B3567U }, /* XSUM_XXH32_testdata[6554] */
    { 3277, 0x9E3779B1U, 0x030A9FBFU }, /* XSUM_XXH32_testdata[6555] */
    { 3278, 0x00000000U, 0x6D9D94ABU }, /* XSUM_XXH32_testdata[6556] */
    { 3278, 0x9E3779B1U, 0x05520D91U }, /* XSUM_XXH32_testdata[6557] */
    { 3279, 0x00000000U, 0x75D64587U }, /* XSUM_XXH32_testdata[6558] */
    { 3279, 0x9E3779B1U, 0xA4C1FBC4U }, /* XSUM_XXH32_testdata[6559] */
    { 3280, 0x00000000U, 0xF2CBB41AU }, /* XSUM_XXH32_testdata[6560] */
    { 3280, 0x9E3779B1U, 0x4CF0113FU }, /* XSUM_XXH32_testdata[6561] */
    { 3281, 0x00000000U, 0x7E6C071AU }, /* XSUM_XXH32_testdata[6562] */
    { 3281, 0x9E3779B1U, 0x79C7392CU }, /* XSUM_XXH32_testdata[6563] */
    { 3282, 0x00000000U, 0xDF2161B2U }, /* XSUM_XXH32_testdata[6564] */
    { 3282, 0x9E3779B1U, 0x7073AE35U }, /* XSUM_XXH32_testdata[6565] */
    { 3283, 0x00000000U, 0xF5BF713CU }, /* XSUM_XXH32_testdata[6566] */
    { 3283, 0x9E3779B1U, 0x07DF0FB4U }, /* XSUM_XXH32_testdata[6567] */
    { 3284, 0x00000000U, 0xD36272D0U }, /* XSUM_XXH32_testdata[6568] */
    { 3284, 0x9E3779B1U, 0xD2286D32U }, /* XSUM_XXH32_testdata[6569] */
    { 3285, 0x00000000U, 0x6C541941U }, /* XSUM_XXH32_testdata[6570] */
    { 3285, 0x9E3779B1U, 0xBF65CACCU }, /* XSUM_XXH32_testdata[6571] */
    { 3286, 0x00000000U, 0xB0358C54U }, /* XSUM_XXH32_testdata[6572] */
    { 3286, 0x9E3779B1U, 0x4497AC3BU }, /* XSUM_XXH32_testdata[6573] */
    { 3287, 0x00000000U, 0xDA8C13B8U }, /* XSUM_XXH32_testdata[6574] */
    { 3287, 0x9E3779B1U, 0x960CA993U }, /* XSUM_XXH32_testdata[6575] */
    { 3288, 0x00000000U, 0xCEB2AEB0U }, /* XSUM_XXH32_testdata[6576] */
    { 3288, 0x9E3779B1U, 0x2B3C60E8U }, /* XSUM_XXH32_testdata[6577] */
    { 3289, 0x00000000U, 0xE03FA93BU }, /* XSUM_XXH32_testdata[6578] */
    { 3289, 0x9E3779B1U, 0x87D22071U }, /* XSUM_XXH32_testdata[6579] */
    { 3290, 0x00000000U, 0xFA43B184U }, /* XSUM_XXH32_testdata[6580] */
    { 3290, 0x9E3779B1U, 0x6CC7A70BU }, /* XSUM_XXH32_testdata[6581] */
    { 3291, 0x00000000U, 0x6BB4FA54U }, /* XSUM_XXH32_testdata[6582] */
    { 3291, 0x9E3779B1U, 0xE8F1671CU }, /* XSUM_XXH32_testdata[6583] */
    { 3292, 0x00000000U, 0x5318921EU }, /* XSUM_XXH32_testdata[6584] */
    { 3292, 0x9E3779B1U, 0xB317068AU }, /* XSUM_XXH32_testdata[6585] */
    { 3293, 0x00000000U, 0x107B4E00U }, /* XSUM_XXH32_testdata[6586] */
    { 3293, 0x9E3779B1U, 0x7CB5ECC2U }, /* XSUM_XXH32_testdata[6587] */
    { 3294, 0x00000000U, 0xFC4B0B17U }, /* XSUM_XXH32_testdata[6588] */
    { 3294, 0x9E3779B1U, 0x4B3BE6A4U }, /* XSUM_XXH32_testdata[6589] */
    { 3295, 0x00000000U, 0x07F8C4D0U }, /* XSUM_XXH32_testdata[6590] */
    { 3295, 0x9E3779B1U, 0x73F62641U }, /* XSUM_XXH32_testdata[6591] */
    { 3296, 0x00000000U, 0x0FEEE0A8U }, /* XSUM_XXH32_testdata[6592] */
    { 3296, 0x9E3779B1U, 0x3FA23F94U }, /* XSUM_XXH32_testdata[6593] */
    { 3297, 0x00000000U, 0x7D4C4277U }, /* XSUM_XXH32_testdata[6594] */
    { 3297, 0x9E3779B1U, 0x23C17F37U }, /* XSUM_XXH32_testdata[6595] */
    { 3298, 0x00000000U, 0xE11F6DC7U }, /* XSUM_XXH32_testdata[6596] */
    { 3298, 0x9E3779B1U, 0x7D7B875DU }, /* XSUM_XXH32_testdata[6597] */
    { 3299, 0x00000000U, 0xB9D1CC35U }, /* XSUM_XXH32_testdata[6598] */
    { 3299, 0x9E3779B1U, 0x8A36EC90U }, /* XSUM_XXH32_testdata[6599] */
    { 3300, 0x00000000U, 0x83ED4387U }, /* XSUM_XXH32_testdata[6600] */
    { 3300, 0x9E3779B1U, 0x66BEE4E5U }, /* XSUM_XXH32_testdata[6601] */
    { 3301, 0x00000000U, 0xB98D4538U }, /* XSUM_XXH32_testdata[6602] */
    { 3301, 0x9E3779B1U, 0x7A1A984BU }, /* XSUM_XXH32_testdata[6603] */
    { 3302, 0x00000000U, 0xBD40F729U }, /* XSUM_XXH32_testdata[6604] */
    { 3302, 0x9E3779B1U, 0x3363FB98U }, /* XSUM_XXH32_testdata[6605] */
    { 3303, 0x00000000U, 0xD0A01436U }, /* XSUM_XXH32_testdata[6606] */
    { 3303, 0x9E3779B1U, 0x1D8FCD96U }, /* XSUM_XXH32_testdata[6607] */
    { 3304, 0x00000000U, 0xEB9230FFU }, /* XSUM_XXH32_testdata[6608] */
    { 3304, 0x9E3779B1U, 0x3D3098D7U }, /* XSUM_XXH32_testdata[6609] */
    { 3305, 0x00000000U, 0x913C866BU }, /* XSUM_XXH32_testdata[6610] */
    { 3305, 0x9E3779B1U, 0x3C6393A2U }, /* XSUM_XXH32_testdata[6611] */
    { 3306, 0x00000000U, 0x744F4934U }, /* XSUM_XXH32_testdata[6612] */
    { 3306, 0x9E3779B1U, 0x813925DBU }, /* XSUM_XXH32_testdata[6613] */
    { 3307, 0x00000000U, 0x48B5E911U }, /* XSUM_XXH32_testdata[6614] */
    { 3307, 0x9E3779B1U, 0xFB0FC1A8U }, /* XSUM_XXH32_testdata[6615] */
    { 3308, 0x00000000U, 0xD3EB7DEDU }, /* XSUM_XXH32_testdata[6616] */
    { 3308, 0x9E3779B1U, 0xECC64AAFU }, /* XSUM_XXH32_testdata[6617] */
    { 3309, 0x00000000U, 0x2BC20FB7U }, /* XSUM_XXH32_testdata[6618] */
    { 3309, 0x9E3779B1U, 0x5F771BB7U }, /* XSUM_XXH32_testdata[6619] */
    { 3310, 0x00000000U, 0x8AF8E44CU }, /* XSUM_XXH32_testdata[6620] */
    { 3310, 0x9E3779B1U, 0xF5F8505FU }, /* XSUM_XXH32_testdata[6621] */
    { 3311, 0x00000000U, 0xD4D67552U }, /* XSUM_XXH32_testdata[6622] */
    { 3311, 0x9E3779B1U, 0x7CF9D505U }, /* XSUM_XXH32_testdata[6623] */
    { 3312, 0x00000000U, 0x94241D0BU }, /* XSUM_XXH32_testdata[6624] */
    { 3312, 0x9E3779B1U, 0x32E2A2D5U }, /* XSUM_XXH32_testdata[6625] */
    { 3313, 0x00000000U, 0x1D813A73U }, /* XSUM_XXH32_testdata[6626] */
    { 3313, 0x9E3779B1U, 0xA5091361U }, /* XSUM_XXH32_testdata[6627] */
    { 3314, 0x00000000U, 0xAB534D10U }, /* XSUM_XXH32_testdata[6628] */
    { 3314, 0x9E3779B1U, 0x60E473FEU }, /* XSUM_XXH32_testdata[6629] */
    { 3315, 0x00000000U, 0xD5DECAF9U }, /* XSUM_XXH32_testdata[6630] */
    { 3315, 0x9E3779B1U, 0xE0F56CDCU }, /* XSUM_XXH32_testdata[6631] */
    { 3316, 0x00000000U, 0x82F968BCU }, /* XSUM_XXH32_testdata[6632] */
    { 3316, 0x9E3779B1U, 0xB1B5F75BU }, /* XSUM_XXH32_testdata[6633] */
    { 3317, 0x00000000U, 0x138AEFE4U }, /* XSUM_XXH32_testdata[6634] */
    { 3317, 0x9E3779B1U, 0xB255A6C2U }, /* XSUM_XXH32_testdata[6635] */
    { 3318, 0x00000000U, 0x69A181ADU }, /* XSUM_XXH32_testdata[6636] */
    { 3318, 0x9E3779B1U, 0x86B4EA3EU }, /* XSUM_XXH32_testdata[6637] */
    { 3319, 0x00000000U, 0xC8B3AE86U }, /* XSUM_XXH32_testdata[6638] */
    { 3319, 0x9E3779B1U, 0x965A64FEU }, /* XSUM_XXH32_testdata[6639] */
    { 3320, 0x00000000U, 0x29E2268CU }, /* XSUM_XXH32_testdata[6640] */
    { 3320, 0x9E3779B1U, 0x3EAE6CA9U }, /* XSUM_XXH32_testdata[6641] */
    { 3321, 0x00000000U, 0x0EF824EAU }, /* XSUM_XXH32_testdata[6642] */
    { 3321, 0x9E3779B1U, 0x1C77FCB9U }, /* XSUM_XXH32_testdata[6643] */
    { 3322, 0x00000000U, 0x853ECF62U }, /* XSUM_XXH32_testdata[6644] */
    { 3322, 0x9E3779B1U, 0xE09A7953U }, /* XSUM_XXH32_testdata[6645] */
    { 3323, 0x00000000U, 0x0806AC59U }, /* XSUM_XXH32_testdata[6646] */
    { 3323, 0x9E3779B1U, 0x7F63946CU }, /* XSUM_XXH32_testdata[6647] */
    { 3324, 0x00000000U, 0x70BA2499U }, /* XSUM_XXH32_testdata[6648] */
    { 3324, 0x9E3779B1U, 0x967776BEU }, /* XSUM_XXH32_testdata[6649] */
    { 3325, 0x00000000U, 0x05AA012BU }, /* XSUM_XXH32_testdata[6650] */
    { 3325, 0x9E3779B1U, 0xF44D90EBU }, /* XSUM_XXH32_testdata[6651] */
    { 3326, 0x00000000U, 0xC7B69097U }, /* XSUM_XXH32_testdata[6652] */
    { 3326, 0x9E3779B1U, 0x15A5DA45U }, /* XSUM_XXH32_testdata[6653] */
    { 3327, 0x00000000U, 0xA3DC485CU }, /* XSUM_XXH32_testdata[6654] */
    { 3327, 0x9E3779B1U, 0x1E4EFCA3U }, /* XSUM_XXH32_testdata[6655] */
    { 3328, 0x00000000U, 0xE31EFB4AU }, /* XSUM_XXH32_testdata[6656] */
    { 3328, 0x9E3779B1U, 0x719157B7U }, /* XSUM_XXH32_testdata[6657] */
    { 3329, 0x00000000U, 0x536C88A7U }, /* XSUM_XXH32_testdata[6658] */
    { 3329, 0x9E3779B1U, 0x16356812U }, /* XSUM_XXH32_testdata[6659] */
    { 3330, 0x00000000U, 0x4D8830E4U }, /* XSUM_XXH32_testdata[6660] */
    { 3330, 0x9E3779B1U, 0x356D307FU }, /* XSUM_XXH32_testdata[6661] */
    { 3331, 0x00000000U, 0x123A0463U }, /* XSUM_XXH32_testdata[6662] */
    { 3331, 0x9E3779B1U, 0x0F92401CU }, /* XSUM_XXH32_testdata[6663] */
    { 3332, 0x00000000U, 0xBA475FC1U }, /* XSUM_XXH32_testdata[6664] */
    { 3332, 0x9E3779B1U, 0x042517BEU }, /* XSUM_XXH32_testdata[6665] */
    { 3333, 0x00000000U, 0xD309F04AU }, /* XSUM_XXH32_testdata[6666] */
    { 3333, 0x9E3779B1U, 0xA865254DU }, /* XSUM_XXH32_testdata[6667] */
    { 3334, 0x00000000U, 0xA2709322U }, /* XSUM_XXH32_testdata[6668] */
    { 3334, 0x9E3779B1U, 0xD639FD0BU }, /* XSUM_XXH32_testdata[6669] */
    { 3335, 0x00000000U, 0xC64579F6U }, /* XSUM_XXH32_testdata[6670] */
    { 3335, 0x9E3779B1U, 0x5BF001CFU }, /* XSUM_XXH32_testdata[6671] */
    { 3336, 0x00000000U, 0x8F5936F7U }, /* XSUM_XXH32_testdata[6672] */
    { 3336, 0x9E3779B1U, 0x3C764EEBU }, /* XSUM_XXH32_testdata[6673] */
    { 3337, 0x00000000U, 0xEABCB66DU }, /* XSUM_XXH32_testdata[6674] */
    { 3337, 0x9E3779B1U, 0x14777341U }, /* XSUM_XXH32_testdata[6675] */
    { 3338, 0x00000000U, 0xBBCC4AF6U }, /* XSUM_XXH32_testdata[6676] */
    { 3338, 0x9E3779B1U, 0x1104C65CU }, /* XSUM_XXH32_testdata[6677] */
    { 3339, 0x00000000U, 0x51321A17U }, /* XSUM_XXH32_testdata[6678] */
    { 3339, 0x9E3779B1U, 0x1959B657U }, /* XSUM_XXH32_testdata[6679] */
    { 3340, 0x00000000U, 0x5B5DBB59U }, /* XSUM_XXH32_testdata[6680] */
    { 3340, 0x9E3779B1U, 0x9842D89BU }, /* XSUM_XXH32_testdata[6681] */
    { 3341, 0x00000000U, 0xF1E4FCEDU }, /* XSUM_XXH32_testdata[6682] */
    { 3341, 0x9E3779B1U, 0x049D82FCU }, /* XSUM_XXH32_testdata[6683] */
    { 3342, 0x00000000U, 0xA0B75023U }, /* XSUM_XXH32_testdata[6684] */
    { 3342, 0x9E3779B1U, 0xB1B92726U }, /* XSUM_XXH32_testdata[6685] */
    { 3343, 0x00000000U, 0xCB46965FU }, /* XSUM_XXH32_testdata[6686] */
    { 3343, 0x9E3779B1U, 0x6BDD191BU }, /* XSUM_XXH32_testdata[6687] */
    { 3344, 0x00000000U, 0x8413E631U }, /* XSUM_XXH32_testdata[6688] */
    { 3344, 0x9E3779B1U, 0xCB34899EU }, /* XSUM_XXH32_testdata[6689] */
    { 3345, 0x00000000U, 0x5379CDACU }, /* XSUM_XXH32_testdata[6690] */
    { 3345, 0x9E3779B1U, 0x7F70593DU }, /* XSUM_XXH32_testdata[6691] */
    { 3346, 0x00000000U, 0xCCBBACCBU }, /* XSUM_XXH32_testdata[6692] */
    { 3346, 0x9E3779B1U, 0x486EE3C0U }, /* XSUM_XXH32_testdata[6693] */
    { 3347, 0x00000000U, 0x7FB8DF71U }, /* XSUM_XXH32_testdata[6694] */
    { 3347, 0x9E3779B1U, 0xEFA5EFBCU }, /* XSUM_XXH32_testdata[6695] */
    { 3348, 0x00000000U, 0x9028FC89U }, /* XSUM_XXH32_testdata[6696] */
    { 3348, 0x9E3779B1U, 0x7897B1B9U }, /* XSUM_XXH32_testdata[6697] */
    { 3349, 0x00000000U, 0x110326ABU }, /* XSUM_XXH32_testdata[6698] */
    { 3349, 0x9E3779B1U, 0xE4650A9FU }, /* XSUM_XXH32_testdata[6699] */
    { 3350, 0x00000000U, 0x6A5F0854U }, /* XSUM_XXH32_testdata[6700] */
    { 3350, 0x9E3779B1U, 0x44BF80D6U }, /* XSUM_XXH32_testdata[6701] */
    { 3351, 0x00000000U, 0xB2F03EB8U }, /* XSUM_XXH32_testdata[6702] */
    { 3351, 0x9E3779B1U, 0xCE2152AFU }, /* XSUM_XXH32_testdata[6703] */
    { 3352, 0x00000000U, 0x4D09E75FU }, /* XSUM_XXH32_testdata[6704] */
    { 3352, 0x9E3779B1U, 0xE45FF7EBU }, /* XSUM_XXH32_testdata[6705] */
    { 3353, 0x00000000U, 0x6054DE76U }, /* XSUM_XXH32_testdata[6706] */
    { 3353, 0x9E3779B1U, 0xC14F850BU }, /* XSUM_XXH32_testdata[6707] */
    { 3354, 0x00000000U, 0x25E58B49U }, /* XSUM_XXH32_testdata[6708] */
    { 3354, 0x9E3779B1U, 0x8191EB72U }, /* XSUM_XXH32_testdata[6709] */
    { 3355, 0x00000000U, 0x03C78393U }, /* XSUM_XXH32_testdata[6710] */
    { 3355, 0x9E3779B1U, 0x739347B9U }, /* XSUM_XXH32_testdata[6711] */
    { 3356, 0x00000000U, 0xAA0B0CBCU }, /* XSUM_XXH32_testdata[6712] */
    { 3356, 0x9E3779B1U, 0x65B2F344U }, /* XSUM_XXH32_testdata[6713] */
    { 3357, 0x00000000U, 0x77D5CB0EU }, /* XSUM_XXH32_testdata[6714] */
    { 3357, 0x9E3779B1U, 0x8F5490AFU }, /* XSUM_XXH32_testdata[6715] */
    { 3358, 0x00000000U, 0x0936406FU }, /* XSUM_XXH32_testdata[6716] */
    { 3358, 0x9E3779B1U, 0x142DA509U }, /* XSUM_XXH32_testdata[6717] */
    { 3359, 0x00000000U, 0x769A4780U }, /* XSUM_XXH32_testdata[6718] */
    { 3359, 0x9E3779B1U, 0xA184030AU }, /* XSUM_XXH32_testdata[6719] */
    { 3360, 0x00000000U, 0xB5CDE27CU }, /* XSUM_XXH32_testdata[6720] */
    { 3360, 0x9E3779B1U, 0xD76A8C16U }, /* XSUM_XXH32_testdata[6721] */
    { 3361, 0x00000000U, 0x24C2738EU }, /* XSUM_XXH32_testdata[6722] */
    { 3361, 0x9E3779B1U, 0xEC04CFA7U }, /* XSUM_XXH32_testdata[6723] */
    { 3362, 0x00000000U, 0x25BDDA8FU }, /* XSUM_XXH32_testdata[6724] */
    { 3362, 0x9E3779B1U, 0x4E4D0E8EU }, /* XSUM_XXH32_testdata[6725] */
    { 3363, 0x00000000U, 0x808A12FDU }, /* XSUM_XXH32_testdata[6726] */
    { 3363, 0x9E3779B1U, 0x6DAF7733U }, /* XSUM_XXH32_testdata[6727] */
    { 3364, 0x00000000U, 0x5D69DFFCU }, /* XSUM_XXH32_testdata[6728] */
    { 3364, 0x9E3779B1U, 0xB4404515U }, /* XSUM_XXH32_testdata[6729] */
    { 3365, 0x00000000U, 0xD92A2946U }, /* XSUM_XXH32_testdata[6730] */
    { 3365, 0x9E3779B1U, 0xD0889582U }, /* XSUM_XXH32_testdata[6731] */
    { 3366, 0x00000000U, 0x9D147716U }, /* XSUM_XXH32_testdata[6732] */
    { 3366, 0x9E3779B1U, 0xD9326756U }, /* XSUM_XXH32_testdata[6733] */
    { 3367, 0x00000000U, 0x043BC86FU }, /* XSUM_XXH32_testdata[6734] */
    { 3367, 0x9E3779B1U, 0x00C2EC57U }, /* XSUM_XXH32_testdata[6735] */
    { 3368, 0x00000000U, 0xB2AA9F17U }, /* XSUM_XXH32_testdata[6736] */
    { 3368, 0x9E3779B1U, 0x7D8C4F0DU }, /* XSUM_XXH32_testdata[6737] */
    { 3369, 0x00000000U, 0xA020BC35U }, /* XSUM_XXH32_testdata[6738] */
    { 3369, 0x9E3779B1U, 0x60847A5AU }, /* XSUM_XXH32_testdata[6739] */
    { 3370, 0x00000000U, 0x7EE77BFFU }, /* XSUM_XXH32_testdata[6740] */
    { 3370, 0x9E3779B1U, 0xF6B3404CU }, /* XSUM_XXH32_testdata[6741] */
    { 3371, 0x00000000U, 0x97731867U }, /* XSUM_XXH32_testdata[6742] */
    { 3371, 0x9E3779B1U, 0xF945EBD4U }, /* XSUM_XXH32_testdata[6743] */
    { 3372, 0x00000000U, 0x5826C410U }, /* XSUM_XXH32_testdata[6744] */
    { 3372, 0x9E3779B1U, 0x5E0A2B89U }, /* XSUM_XXH32_testdata[6745] */
    { 3373, 0x00000000U, 0xAA457AE4U }, /* XSUM_XXH32_testdata[6746] */
    { 3373, 0x9E3779B1U, 0xA92F0D06U }, /* XSUM_XXH32_testdata[6747] */
    { 3374, 0x00000000U, 0x7D1F056DU }, /* XSUM_XXH32_testdata[6748] */
    { 3374, 0x9E3779B1U, 0xEC3252A8U }, /* XSUM_XXH32_testdata[6749] */
    { 3375, 0x00000000U, 0x6BEAD6CFU }, /* XSUM_XXH32_testdata[6750] */
    { 3375, 0x9E3779B1U, 0x9A6CC743U }, /* XSUM_XXH32_testdata[6751] */
    { 3376, 0x00000000U, 0x74F067ABU }, /* XSUM_XXH32_testdata[6752] */
    { 3376, 0x9E3779B1U, 0x2323210CU }, /* XSUM_XXH32_testdata[6753] */
    { 3377, 0x00000000U, 0xA73C775EU }, /* XSUM_XXH32_testdata[6754] */
    { 3377, 0x9E3779B1U, 0xCD94E18BU }, /* XSUM_XXH32_testdata[6755] */
    { 3378, 0x00000000U, 0x0C31FFBFU }, /* XSUM_XXH32_testdata[6756] */
    { 3378, 0x9E3779B1U, 0x102F6983U }, /* XSUM_XXH32_testdata[6757] */
    { 3379, 0x00000000U, 0xCC684E33U }, /* XSUM_XXH32_testdata[6758] */
    { 3379, 0x9E3779B1U, 0xE3E0B246U }, /* XSUM_XXH32_testdata[6759] */
    { 3380, 0x00000000U, 0xBEF5BA70U }, /* XSUM_XXH32_testdata[6760] */
    { 3380, 0x9E3779B1U, 0x0CA9BEF2U }, /* XSUM_XXH32_testdata[6761] */
    { 3381, 0x00000000U, 0x5156A4DBU }, /* XSUM_XXH32_testdata[6762] */
    { 3381, 0x9E3779B1U, 0x6ED7742BU }, /* XSUM_XXH32_testdata[6763] */
    { 3382, 0x00000000U, 0x2FCB35B0U }, /* XSUM_XXH32_testdata[6764] */
    { 3382, 0x9E3779B1U, 0x21972DBBU }, /* XSUM_XXH32_testdata[6765] */
    { 3383, 0x00000000U, 0x3C271778U }, /* XSUM_XXH32_testdata[6766] */
    { 3383, 0x9E3779B1U, 0xB6B2235AU }, /* XSUM_XXH32_testdata[6767] */
    { 3384, 0x00000000U, 0x2EC18C38U }, /* XSUM_XXH32_testdata[6768] */
    { 3384, 0x9E3779B1U, 0xA95A64ADU }, /* XSUM_XXH32_testdata[6769] */
    { 3385, 0x00000000U, 0xDE7DBE69U }, /* XSUM_XXH32_testdata[6770] */
    { 3385, 0x9E3779B1U, 0xC7035DE2U }, /* XSUM_XXH32_testdata[6771] */
    { 3386, 0x00000000U, 0x875AB117U }, /* XSUM_XXH32_testdata[6772] */
    { 3386, 0x9E3779B1U, 0x72CAC56FU }, /* XSUM_XXH32_testdata[6773] */
    { 3387, 0x00000000U, 0x3DE24FFFU }, /* XSUM_XXH32_testdata[6774] */
    { 3387, 0x9E3779B1U, 0x7E7E5AB6U }, /* XSUM_XXH32_testdata[6775] */
    { 3388, 0x00000000U, 0x9DC35FC1U }, /* XSUM_XXH32_testdata[6776] */
    { 3388, 0x9E3779B1U, 0x236146F2U }, /* XSUM_XXH32_testdata[6777] */
    { 3389, 0x00000000U, 0x766DCC65U }, /* XSUM_XXH32_testdata[6778] */
    { 3389, 0x9E3779B1U, 0x91D03786U }, /* XSUM_XXH32_testdata[6779] */
    { 3390, 0x00000000U, 0xE7EE8FE5U }, /* XSUM_XXH32_testdata[6780] */
    { 3390, 0x9E3779B1U, 0xB8BDF469U }, /* XSUM_XXH32_testdata[6781] */
    { 3391, 0x00000000U, 0x0283AC68U }, /* XSUM_XXH32_testdata[6782] */
    { 3391, 0x9E3779B1U, 0x305D6B75U }, /* XSUM_XXH32_testdata[6783] */
    { 3392, 0x00000000U, 0xAEB53FAAU }, /* XSUM_XXH32_testdata[6784] */
    { 3392, 0x9E3779B1U, 0x0AAC2941U }, /* XSUM_XXH32_testdata[6785] */
    { 3393, 0x00000000U, 0xFEEEA860U }, /* XSUM_XXH32_testdata[6786] */
    { 3393, 0x9E3779B1U, 0x4C0D5752U }, /* XSUM_XXH32_testdata[6787] */
    { 3394, 0x00000000U, 0x25472594U }, /* XSUM_XXH32_testdata[6788] */
    { 3394, 0x9E3779B1U, 0x04C78A34U }, /* XSUM_XXH32_testdata[6789] */
    { 3395, 0x00000000U, 0x5328D77BU }, /* XSUM_XXH32_testdata[6790] */
    { 3395, 0x9E3779B1U, 0x8F2F9AE5U }, /* XSUM_XXH32_testdata[6791] */
    { 3396, 0x00000000U, 0x5357180CU }, /* XSUM_XXH32_testdata[6792] */
    { 3396, 0x9E3779B1U, 0x0F498F93U }, /* XSUM_XXH32_testdata[6793] */
    { 3397, 0x00000000U, 0x9EDF44F8U }, /* XSUM_XXH32_testdata[6794] */
    { 3397, 0x9E3779B1U, 0xF33B41A9U }, /* XSUM_XXH32_testdata[6795] */
    { 3398, 0x00000000U, 0xEEC4FDA8U }, /* XSUM_XXH32_testdata[6796] */
    { 3398, 0x9E3779B1U, 0x790B3886U }, /* XSUM_XXH32_testdata[6797] */
    { 3399, 0x00000000U, 0x301F31D3U }, /* XSUM_XXH32_testdata[6798] */
    { 3399, 0x9E3779B1U, 0x27703E74U }, /* XSUM_XXH32_testdata[6799] */
    { 3400, 0x00000000U, 0x5BBDB3EDU }, /* XSUM_XXH32_testdata[6800] */
    { 3400, 0x9E3779B1U, 0xB12EAF07U }, /* XSUM_XXH32_testdata[6801] */
    { 3401, 0x00000000U, 0xA45AE1A2U }, /* XSUM_XXH32_testdata[6802] */
    { 3401, 0x9E3779B1U, 0xA082C410U }, /* XSUM_XXH32_testdata[6803] */
    { 3402, 0x00000000U, 0x203C222DU }, /* XSUM_XXH32_testdata[6804] */
    { 3402, 0x9E3779B1U, 0x906BEE72U }, /* XSUM_XXH32_testdata[6805] */
    { 3403, 0x00000000U, 0xE01B1E46U }, /* XSUM_XXH32_testdata[6806] */
    { 3403, 0x9E3779B1U, 0x6B0A432CU }, /* XSUM_XXH32_testdata[6807] */
    { 3404, 0x00000000U, 0xF5383067U }, /* XSUM_XXH32_testdata[6808] */
    { 3404, 0x9E3779B1U, 0xF9046D3FU }, /* XSUM_XXH32_testdata[6809] */
    { 3405, 0x00000000U, 0x0B575A75U }, /* XSUM_XXH32_testdata[6810] */
    { 3405, 0x9E3779B1U, 0x066DFBB2U }, /* XSUM_XXH32_testdata[6811] */
    { 3406, 0x00000000U, 0x71959F26U }, /* XSUM_XXH32_testdata[6812] */
    { 3406, 0x9E3779B1U, 0xF57BB062U }, /* XSUM_XXH32_testdata[6813] */
    { 3407, 0x00000000U, 0xCB1FD322U }, /* XSUM_XXH32_testdata[6814] */
    { 3407, 0x9E3779B1U, 0xFA006638U }, /* XSUM_XXH32_testdata[6815] */
    { 3408, 0x00000000U, 0x2B7AC79FU }, /* XSUM_XXH32_testdata[6816] */
    { 3408, 0x9E3779B1U, 0xC0EBEFB2U }, /* XSUM_XXH32_testdata[6817] */
    { 3409, 0x00000000U, 0xFBD4E663U }, /* XSUM_XXH32_testdata[6818] */
    { 3409, 0x9E3779B1U, 0x1F944A57U }, /* XSUM_XXH32_testdata[6819] */
    { 3410, 0x00000000U, 0x6524AB8EU }, /* XSUM_XXH32_testdata[6820] */
    { 3410, 0x9E3779B1U, 0xD7B4501AU }, /* XSUM_XXH32_testdata[6821] */
    { 3411, 0x00000000U, 0x02082787U }, /* XSUM_XXH32_testdata[6822] */
    { 3411, 0x9E3779B1U, 0xA46256A5U }, /* XSUM_XXH32_testdata[6823] */
    { 3412, 0x00000000U, 0x5609EBBAU }, /* XSUM_XXH32_testdata[6824] */
    { 3412, 0x9E3779B1U, 0x0C20C9BEU }, /* XSUM_XXH32_testdata[6825] */
    { 3413, 0x00000000U, 0xCFF88265U }, /* XSUM_XXH32_testdata[6826] */
    { 3413, 0x9E3779B1U, 0x8ABBB4D6U }, /* XSUM_XXH32_testdata[6827] */
    { 3414, 0x00000000U, 0x6756791CU }, /* XSUM_XXH32_testdata[6828] */
    { 3414, 0x9E3779B1U, 0x9A22BE7CU }, /* XSUM_XXH32_testdata[6829] */
    { 3415, 0x00000000U, 0x1AF57BF0U }, /* XSUM_XXH32_testdata[6830] */
    { 3415, 0x9E3779B1U, 0xC5FB4E2CU }, /* XSUM_XXH32_testdata[6831] */
    { 3416, 0x00000000U, 0x2115DE5EU }, /* XSUM_XXH32_testdata[6832] */
    { 3416, 0x9E3779B1U, 0x15F334C8U }, /* XSUM_XXH32_testdata[6833] */
    { 3417, 0x00000000U, 0xF81CF209U }, /* XSUM_XXH32_testdata[6834] */
    { 3417, 0x9E3779B1U, 0xF4A8A5ACU }, /* XSUM_XXH32_testdata[6835] */
    { 3418, 0x00000000U, 0x249AC50EU }, /* XSUM_XXH32_testdata[6836] */
    { 3418, 0x9E3779B1U, 0x638DB79CU }, /* XSUM_XXH32_testdata[6837] */
    { 3419, 0x00000000U, 0xC3697E3FU }, /* XSUM_XXH32_testdata[6838] */
    { 3419, 0x9E3779B1U, 0xADEEDE3AU }, /* XSUM_XXH32_testdata[6839] */
    { 3420, 0x00000000U, 0x75EBDDD2U }, /* XSUM_XXH32_testdata[6840] */
    { 3420, 0x9E3779B1U, 0x33683C34U }, /* XSUM_XXH32_testdata[6841] */
    { 3421, 0x00000000U, 0x10A377DBU }, /* XSUM_XXH32_testdata[6842] */
    { 3421, 0x9E3779B1U, 0xCF59A4D2U }, /* XSUM_XXH32_testdata[6843] */
    { 3422, 0x00000000U, 0xF341E29FU }, /* XSUM_XXH32_testdata[6844] */
    { 3422, 0x9E3779B1U, 0x260F37E7U }, /* XSUM_XXH32_testdata[6845] */
    { 3423, 0x00000000U, 0x0BA23FD5U }, /* XSUM_XXH32_testdata[6846] */
    { 3423, 0x9E3779B1U, 0xBBFC1663U }, /* XSUM_XXH32_testdata[6847] */
    { 3424, 0x00000000U, 0x5F1143BCU }, /* XSUM_XXH32_testdata[6848] */
    { 3424, 0x9E3779B1U, 0x008AE617U }, /* XSUM_XXH32_testdata[6849] */
    { 3425, 0x00000000U, 0xE0491B24U }, /* XSUM_XXH32_testdata[6850] */
    { 3425, 0x9E3779B1U, 0x17BFEA97U }, /* XSUM_XXH32_testdata[6851] */
    { 3426, 0x00000000U, 0xEA7763B2U }, /* XSUM_XXH32_testdata[6852] */
    { 3426, 0x9E3779B1U, 0x37D44B7AU }, /* XSUM_XXH32_testdata[6853] */
    { 3427, 0x00000000U, 0x4A00A5DDU }, /* XSUM_XXH32_testdata[6854] */
    { 3427, 0x9E3779B1U, 0xDC107BDFU }, /* XSUM_XXH32_testdata[6855] */
    { 3428, 0x00000000U, 0xB8976EDAU }, /* XSUM_XXH32_testdata[6856] */
    { 3428, 0x9E3779B1U, 0x93BE08F8U }, /* XSUM_XXH32_testdata[6857] */
    { 3429, 0x00000000U, 0xAB38E11BU }, /* XSUM_XXH32_testdata[6858] */
    { 3429, 0x9E3779B1U, 0xF5C27F53U }, /* XSUM_XXH32_testdata[6859] */
    { 3430, 0x00000000U, 0x03F96055U }, /* XSUM_XXH32_testdata[6860] */
    { 3430, 0x9E3779B1U, 0xEB4A5CC9U }, /* XSUM_XXH32_testdata[6861] */
    { 3431, 0x00000000U, 0x1F16FD93U }, /* XSUM_XXH32_testdata[6862] */
    { 3431, 0x9E3779B1U, 0x9471EEA6U }, /* XSUM_XXH32_testdata[6863] */
    { 3432, 0x00000000U, 0xE65A87CEU }, /* XSUM_XXH32_testdata[6864] */
    { 3432, 0x9E3779B1U, 0x59324147U }, /* XSUM_XXH32_testdata[6865] */
    { 3433, 0x00000000U, 0x717D73AAU }, /* XSUM_XXH32_testdata[6866] */
    { 3433, 0x9E3779B1U, 0xEDB32A85U }, /* XSUM_XXH32_testdata[6867] */
    { 3434, 0x00000000U, 0xC991171BU }, /* XSUM_XXH32_testdata[6868] */
    { 3434, 0x9E3779B1U, 0x77FC09FEU }, /* XSUM_XXH32_testdata[6869] */
    { 3435, 0x00000000U, 0x56B78DD6U }, /* XSUM_XXH32_testdata[6870] */
    { 3435, 0x9E3779B1U, 0x34EF0410U }, /* XSUM_XXH32_testdata[6871] */
    { 3436, 0x00000000U, 0x5F5F52C1U }, /* XSUM_XXH32_testdata[6872] */
    { 3436, 0x9E3779B1U, 0x60FE20A3U }, /* XSUM_XXH32_testdata[6873] */
    { 3437, 0x00000000U, 0x9B0434C3U }, /* XSUM_XXH32_testdata[6874] */
    { 3437, 0x9E3779B1U, 0xB78B9362U }, /* XSUM_XXH32_testdata[6875] */
    { 3438, 0x00000000U, 0x26B8E3D3U }, /* XSUM_XXH32_testdata[6876] */
    { 3438, 0x9E3779B1U, 0xEE2B5766U }, /* XSUM_XXH32_testdata[6877] */
    { 3439, 0x00000000U, 0xC0C09177U }, /* XSUM_XXH32_testdata[6878] */
    { 3439, 0x9E3779B1U, 0xDB2B6A3DU }, /* XSUM_XXH32_testdata[6879] */
    { 3440, 0x00000000U, 0xA8B9E919U }, /* XSUM_XXH32_testdata[6880] */
    { 3440, 0x9E3779B1U, 0x4D59CBE2U }, /* XSUM_XXH32_testdata[6881] */
    { 3441, 0x00000000U, 0x1638A859U }, /* XSUM_XXH32_testdata[6882] */
    { 3441, 0x9E3779B1U, 0x51D3D4CBU }, /* XSUM_XXH32_testdata[6883] */
    { 3442, 0x00000000U, 0xD24B0990U }, /* XSUM_XXH32_testdata[6884] */
    { 3442, 0x9E3779B1U, 0x7FE3FBCFU }, /* XSUM_XXH32_testdata[6885] */
    { 3443, 0x00000000U, 0xD11D6C53U }, /* XSUM_XXH32_testdata[6886] */
    { 3443, 0x9E3779B1U, 0x0A7ABF1AU }, /* XSUM_XXH32_testdata[6887] */
    { 3444, 0x00000000U, 0x8BE72E70U }, /* XSUM_XXH32_testdata[6888] */
    { 3444, 0x9E3779B1U, 0x1B62BA1DU }, /* XSUM_XXH32_testdata[6889] */
    { 3445, 0x00000000U, 0x733E0E94U }, /* XSUM_XXH32_testdata[6890] */
    { 3445, 0x9E3779B1U, 0xC0680C78U }, /* XSUM_XXH32_testdata[6891] */
    { 3446, 0x00000000U, 0x4C1B8249U }, /* XSUM_XXH32_testdata[6892] */
    { 3446, 0x9E3779B1U, 0xF733F468U }, /* XSUM_XXH32_testdata[6893] */
    { 3447, 0x00000000U, 0x9764625CU }, /* XSUM_XXH32_testdata[6894] */
    { 3447, 0x9E3779B1U, 0xC56D44A3U }, /* XSUM_XXH32_testdata[6895] */
    { 3448, 0x00000000U, 0xE512CF48U }, /* XSUM_XXH32_testdata[6896] */
    { 3448, 0x9E3779B1U, 0x64488BE0U }, /* XSUM_XXH32_testdata[6897] */
    { 3449, 0x00000000U, 0xDCD9FD0BU }, /* XSUM_XXH32_testdata[6898] */
    { 3449, 0x9E3779B1U, 0x1E74CCBAU }, /* XSUM_XXH32_testdata[6899] */
    { 3450, 0x00000000U, 0x05AC75D2U }, /* XSUM_XXH32_testdata[6900] */
    { 3450, 0x9E3779B1U, 0x2ADAC3D2U }, /* XSUM_XXH32_testdata[6901] */
    { 3451, 0x00000000U, 0x69FE7FBEU }, /* XSUM_XXH32_testdata[6902] */
    { 3451, 0x9E3779B1U, 0x1BEB2256U }, /* XSUM_XXH32_testdata[6903] */
    { 3452, 0x00000000U, 0x3C6CBA89U }, /* XSUM_XXH32_testdata[6904] */
    { 3452, 0x9E3779B1U, 0x33072D54U }, /* XSUM_XXH32_testdata[6905] */
    { 3453, 0x00000000U, 0xC5B30423U }, /* XSUM_XXH32_testdata[6906] */
    { 3453, 0x9E3779B1U, 0x53393BDFU }, /* XSUM_XXH32_testdata[6907] */
    { 3454, 0x00000000U, 0xCF2718A5U }, /* XSUM_XXH32_testdata[6908] */
    { 3454, 0x9E3779B1U, 0xE38FFB89U }, /* XSUM_XXH32_testdata[6909] */
    { 3455, 0x00000000U, 0x23ECAE24U }, /* XSUM_XXH32_testdata[6910] */
    { 3455, 0x9E3779B1U, 0x92B38816U }, /* XSUM_XXH32_testdata[6911] */
    { 3456, 0x00000000U, 0x2068B156U }, /* XSUM_XXH32_testdata[6912] */
    { 3456, 0x9E3779B1U, 0xA4706587U }, /* XSUM_XXH32_testdata[6913] */
    { 3457, 0x00000000U, 0x295FCAEDU }, /* XSUM_XXH32_testdata[6914] */
    { 3457, 0x9E3779B1U, 0xEFCCBF79U }, /* XSUM_XXH32_testdata[6915] */
    { 3458, 0x00000000U, 0x3EA0F67FU }, /* XSUM_XXH32_testdata[6916] */
    { 3458, 0x9E3779B1U, 0xB8DD7F54U }, /* XSUM_XXH32_testdata[6917] */
    { 3459, 0x00000000U, 0x69929055U }, /* XSUM_XXH32_testdata[6918] */
    { 3459, 0x9E3779B1U, 0x7E1F127FU }, /* XSUM_XXH32_testdata[6919] */
    { 3460, 0x00000000U, 0x97BC7E81U }, /* XSUM_XXH32_testdata[6920] */
    { 3460, 0x9E3779B1U, 0x0DD5A367U }, /* XSUM_XXH32_testdata[6921] */
    { 3461, 0x00000000U, 0x250C0660U }, /* XSUM_XXH32_testdata[6922] */
    { 3461, 0x9E3779B1U, 0x6FE7FB70U }, /* XSUM_XXH32_testdata[6923] */
    { 3462, 0x00000000U, 0xDEFF6292U }, /* XSUM_XXH32_testdata[6924] */
    { 3462, 0x9E3779B1U, 0xD8B81F51U }, /* XSUM_XXH32_testdata[6925] */
    { 3463, 0x00000000U, 0x906A34F4U }, /* XSUM_XXH32_testdata[6926] */
    { 3463, 0x9E3779B1U, 0x78805F14U }, /* XSUM_XXH32_testdata[6927] */
    { 3464, 0x00000000U, 0x509D8C8DU }, /* XSUM_XXH32_testdata[6928] */
    { 3464, 0x9E3779B1U, 0xA49A1719U }, /* XSUM_XXH32_testdata[6929] */
    { 3465, 0x00000000U, 0x89984810U }, /* XSUM_XXH32_testdata[6930] */
    { 3465, 0x9E3779B1U, 0x3D4A6AF1U }, /* XSUM_XXH32_testdata[6931] */
    { 3466, 0x00000000U, 0xB4B40A28U }, /* XSUM_XXH32_testdata[6932] */
    { 3466, 0x9E3779B1U, 0x51FF0F9DU }, /* XSUM_XXH32_testdata[6933] */
    { 3467, 0x00000000U, 0x68FD4910U }, /* XSUM_XXH32_testdata[6934] */
    { 3467, 0x9E3779B1U, 0x94CC21CDU }, /* XSUM_XXH32_testdata[6935] */
    { 3468, 0x00000000U, 0xCC20A756U }, /* XSUM_XXH32_testdata[6936] */
    { 3468, 0x9E3779B1U, 0xD5210C7EU }, /* XSUM_XXH32_testdata[6937] */
    { 3469, 0x00000000U, 0xC3204A36U }, /* XSUM_XXH32_testdata[6938] */
    { 3469, 0x9E3779B1U, 0xB49F44B9U }, /* XSUM_XXH32_testdata[6939] */
    { 3470, 0x00000000U, 0x06026F45U }, /* XSUM_XXH32_testdata[6940] */
    { 3470, 0x9E3779B1U, 0x8E034BD2U }, /* XSUM_XXH32_testdata[6941] */
    { 3471, 0x00000000U, 0xF0193F99U }, /* XSUM_XXH32_testdata[6942] */
    { 3471, 0x9E3779B1U, 0xB82C7EF6U }, /* XSUM_XXH32_testdata[6943] */
    { 3472, 0x00000000U, 0x6A506014U }, /* XSUM_XXH32_testdata[6944] */
    { 3472, 0x9E3779B1U, 0xF19AC666U }, /* XSUM_XXH32_testdata[6945] */
    { 3473, 0x00000000U, 0xD9309451U }, /* XSUM_XXH32_testdata[6946] */
    { 3473, 0x9E3779B1U, 0x5C62FE76U }, /* XSUM_XXH32_testdata[6947] */
    { 3474, 0x00000000U, 0x08AE31CBU }, /* XSUM_XXH32_testdata[6948] */
    { 3474, 0x9E3779B1U, 0x1D01F5E3U }, /* XSUM_XXH32_testdata[6949] */
    { 3475, 0x00000000U, 0x7D938D2CU }, /* XSUM_XXH32_testdata[6950] */
    { 3475, 0x9E3779B1U, 0xA20BD86BU }, /* XSUM_XXH32_testdata[6951] */
    { 3476, 0x00000000U, 0xBF98511EU }, /* XSUM_XXH32_testdata[6952] */
    { 3476, 0x9E3779B1U, 0x728F2E00U }, /* XSUM_XXH32_testdata[6953] */
    { 3477, 0x00000000U, 0x2DF29085U }, /* XSUM_XXH32_testdata[6954] */
    { 3477, 0x9E3779B1U, 0x641E0D83U }, /* XSUM_XXH32_testdata[6955] */
    { 3478, 0x00000000U, 0xD67817ACU }, /* XSUM_XXH32_testdata[6956] */
    { 3478, 0x9E3779B1U, 0x5B16D790U }, /* XSUM_XXH32_testdata[6957] */
    { 3479, 0x00000000U, 0xBF955B2DU }, /* XSUM_XXH32_testdata[6958] */
    { 3479, 0x9E3779B1U, 0x71BFD9A4U }, /* XSUM_XXH32_testdata[6959] */
    { 3480, 0x00000000U, 0x35902249U }, /* XSUM_XXH32_testdata[6960] */
    { 3480, 0x9E3779B1U, 0x983AE947U }, /* XSUM_XXH32_testdata[6961] */
    { 3481, 0x00000000U, 0x4BABEB46U }, /* XSUM_XXH32_testdata[6962] */
    { 3481, 0x9E3779B1U, 0xFDD16A9EU }, /* XSUM_XXH32_testdata[6963] */
    { 3482, 0x00000000U, 0x115C555DU }, /* XSUM_XXH32_testdata[6964] */
    { 3482, 0x9E3779B1U, 0xCFB53ADAU }, /* XSUM_XXH32_testdata[6965] */
    { 3483, 0x00000000U, 0xAAD5BEBDU }, /* XSUM_XXH32_testdata[6966] */
    { 3483, 0x9E3779B1U, 0xE0E737E4U }, /* XSUM_XXH32_testdata[6967] */
    { 3484, 0x00000000U, 0xF6096817U }, /* XSUM_XXH32_testdata[6968] */
    { 3484, 0x9E3779B1U, 0xE1DAC5D0U }, /* XSUM_XXH32_testdata[6969] */
    { 3485, 0x00000000U, 0x4264CC84U }, /* XSUM_XXH32_testdata[6970] */
    { 3485, 0x9E3779B1U, 0x874B1917U }, /* XSUM_XXH32_testdata[6971] */
    { 3486, 0x00000000U, 0x48136F2CU }, /* XSUM_XXH32_testdata[6972] */
    { 3486, 0x9E3779B1U, 0x2BA2ECB7U }, /* XSUM_XXH32_testdata[6973] */
    { 3487, 0x00000000U, 0xE3D3F58BU }, /* XSUM_XXH32_testdata[6974] */
    { 3487, 0x9E3779B1U, 0x50851C6BU }, /* XSUM_XXH32_testdata[6975] */
    { 3488, 0x00000000U, 0x398C6B2BU }, /* XSUM_XXH32_testdata[6976] */
    { 3488, 0x9E3779B1U, 0x4AAD8E7AU }, /* XSUM_XXH32_testdata[6977] */
    { 3489, 0x00000000U, 0xDCF35413U }, /* XSUM_XXH32_testdata[6978] */
    { 3489, 0x9E3779B1U, 0x9622B255U }, /* XSUM_XXH32_testdata[6979] */
    { 3490, 0x00000000U, 0xA3826B53U }, /* XSUM_XXH32_testdata[6980] */
    { 3490, 0x9E3779B1U, 0xDB328E1EU }, /* XSUM_XXH32_testdata[6981] */
    { 3491, 0x00000000U, 0x451A3160U }, /* XSUM_XXH32_testdata[6982] */
    { 3491, 0x9E3779B1U, 0x4508B0DCU }, /* XSUM_XXH32_testdata[6983] */
    { 3492, 0x00000000U, 0x044F047FU }, /* XSUM_XXH32_testdata[6984] */
    { 3492, 0x9E3779B1U, 0x501D4005U }, /* XSUM_XXH32_testdata[6985] */
    { 3493, 0x00000000U, 0xC0C2AC4EU }, /* XSUM_XXH32_testdata[6986] */
    { 3493, 0x9E3779B1U, 0x7814B99DU }, /* XSUM_XXH32_testdata[6987] */
    { 3494, 0x00000000U, 0x35EEAB21U }, /* XSUM_XXH32_testdata[6988] */
    { 3494, 0x9E3779B1U, 0x6607923FU }, /* XSUM_XXH32_testdata[6989] */
    { 3495, 0x00000000U, 0xBA4E99EEU }, /* XSUM_XXH32_testdata[6990] */
    { 3495, 0x9E3779B1U, 0xA56E19CDU }, /* XSUM_XXH32_testdata[6991] */
    { 3496, 0x00000000U, 0x364AEAA2U }, /* XSUM_XXH32_testdata[6992] */
    { 3496, 0x9E3779B1U, 0xA1C547C7U }, /* XSUM_XXH32_testdata[6993] */
    { 3497, 0x00000000U, 0xCC867552U }, /* XSUM_XXH32_testdata[6994] */
    { 3497, 0x9E3779B1U, 0x9775CA37U }, /* XSUM_XXH32_testdata[6995] */
    { 3498, 0x00000000U, 0x6CF8FB77U }, /* XSUM_XXH32_testdata[6996] */
    { 3498, 0x9E3779B1U, 0x81B04ED0U }, /* XSUM_XXH32_testdata[6997] */
    { 3499, 0x00000000U, 0x14B86A6AU }, /* XSUM_XXH32_testdata[6998] */
    { 3499, 0x9E3779B1U, 0x13CDBE00U }, /* XSUM_XXH32_testdata[6999] */
    { 3500, 0x00000000U, 0x7DCB439DU }, /* XSUM_XXH32_testdata[7000] */
    { 3500, 0x9E3779B1U, 0xF39EAA12U }, /* XSUM_XXH32_testdata[7001] */
    { 3501, 0x00000000U, 0xAB9D75CAU }, /* XSUM_XXH32_testdata[7002] */
    { 3501, 0x9E3779B1U, 0x9D1B57F0U }, /* XSUM_XXH32_testdata[7003] */
    { 3502, 0x00000000U, 0x2D241857U }, /* XSUM_XXH32_testdata[7004] */
    { 3502, 0x9E3779B1U, 0x47CFA606U }, /* XSUM_XXH32_testdata[7005] */
    { 3503, 0x00000000U, 0x82F56DF6U }, /* XSUM_XXH32_testdata[7006] */
    { 3503, 0x9E3779B1U, 0x625947AEU }, /* XSUM_XXH32_testdata[7007] */
    { 3504, 0x00000000U, 0xC6461692U }, /* XSUM_XXH32_testdata[7008] */
    { 3504, 0x9E3779B1U, 0xABC51768U }, /* XSUM_XXH32_testdata[7009] */
    { 3505, 0x00000000U, 0x997C0476U }, /* XSUM_XXH32_testdata[7010] */
    { 3505, 0x9E3779B1U, 0x264A5C81U }, /* XSUM_XXH32_testdata[7011] */
    { 3506, 0x00000000U, 0xDA324FC8U }, /* XSUM_XXH32_testdata[7012] */
    { 3506, 0x9E3779B1U, 0xCEAB447EU }, /* XSUM_XXH32_testdata[7013] */
    { 3507, 0x00000000U, 0x18F00157U }, /* XSUM_XXH32_testdata[7014] */
    { 3507, 0x9E3779B1U, 0x64EC96ABU }, /* XSUM_XXH32_testdata[7015] */
    { 3508, 0x00000000U, 0xB936F439U }, /* XSUM_XXH32_testdata[7016] */
    { 3508, 0x9E3779B1U, 0x59EBF7A4U }, /* XSUM_XXH32_testdata[7017] */
    { 3509, 0x00000000U, 0xAF357164U }, /* XSUM_XXH32_testdata[7018] */
    { 3509, 0x9E3779B1U, 0x435C7B3AU }, /* XSUM_XXH32_testdata[7019] */
    { 3510, 0x00000000U, 0x2AD409A9U }, /* XSUM_XXH32_testdata[7020] */
    { 3510, 0x9E3779B1U, 0xD34AF9A1U }, /* XSUM_XXH32_testdata[7021] */
    { 3511, 0x00000000U, 0x28FBD7BAU }, /* XSUM_XXH32_testdata[7022] */
    { 3511, 0x9E3779B1U, 0xC33EF4C7U }, /* XSUM_XXH32_testdata[7023] */
    { 3512, 0x00000000U, 0xD0F9EEFAU }, /* XSUM_XXH32_testdata[7024] */
    { 3512, 0x9E3779B1U, 0xF8E26840U }, /* XSUM_XXH32_testdata[7025] */
    { 3513, 0x00000000U, 0xF4FB0DABU }, /* XSUM_XXH32_testdata[7026] */
    { 3513, 0x9E3779B1U, 0x1190481DU }, /* XSUM_XXH32_testdata[7027] */
    { 3514, 0x00000000U, 0xF8362507U }, /* XSUM_XXH32_testdata[7028] */
    { 3514, 0x9E3779B1U, 0x5EEA6C56U }, /* XSUM_XXH32_testdata[7029] */
    { 3515, 0x00000000U, 0x6617EB1FU }, /* XSUM_XXH32_testdata[7030] */
    { 3515, 0x9E3779B1U, 0x23870DE7U }, /* XSUM_XXH32_testdata[7031] */
    { 3516, 0x00000000U, 0x1B5CE31FU }, /* XSUM_XXH32_testdata[7032] */
    { 3516, 0x9E3779B1U, 0x95E40107U }, /* XSUM_XXH32_testdata[7033] */
    { 3517, 0x00000000U, 0x4679F3F7U }, /* XSUM_XXH32_testdata[7034] */
    { 3517, 0x9E3779B1U, 0xEB9B67E9U }, /* XSUM_XXH32_testdata[7035] */
    { 3518, 0x00000000U, 0xEB172620U }, /* XSUM_XXH32_testdata[7036] */
    { 3518, 0x9E3779B1U, 0xB0B1FECCU }, /* XSUM_XXH32_testdata[7037] */
    { 3519, 0x00000000U, 0x8C884DA0U }, /* XSUM_XXH32_testdata[7038] */
    { 3519, 0x9E3779B1U, 0xC275DBE3U }, /* XSUM_XXH32_testdata[7039] */
    { 3520, 0x00000000U, 0xB9B89945U }, /* XSUM_XXH32_testdata[7040] */
    { 3520, 0x9E3779B1U, 0x4A84FE06U }, /* XSUM_XXH32_testdata[7041] */
    { 3521, 0x00000000U, 0x4F03DD19U }, /* XSUM_XXH32_testdata[7042] */
    { 3521, 0x9E3779B1U, 0x145C3B1DU }, /* XSUM_XXH32_testdata[7043] */
    { 3522, 0x00000000U, 0x9F71B20CU }, /* XSUM_XXH32_testdata[7044] */
    { 3522, 0x9E3779B1U, 0x4DD77F83U }, /* XSUM_XXH32_testdata[7045] */
    { 3523, 0x00000000U, 0xCA98EC84U }, /* XSUM_XXH32_testdata[7046] */
    { 3523, 0x9E3779B1U, 0xF41B4990U }, /* XSUM_XXH32_testdata[7047] */
    { 3524, 0x00000000U, 0xD01C61EDU }, /* XSUM_XXH32_testdata[7048] */
    { 3524, 0x9E3779B1U, 0x20155BE7U }, /* XSUM_XXH32_testdata[7049] */
    { 3525, 0x00000000U, 0x4A604702U }, /* XSUM_XXH32_testdata[7050] */
    { 3525, 0x9E3779B1U, 0xA1260022U }, /* XSUM_XXH32_testdata[7051] */
    { 3526, 0x00000000U, 0x065E509BU }, /* XSUM_XXH32_testdata[7052] */
    { 3526, 0x9E3779B1U, 0xD72E819DU }, /* XSUM_XXH32_testdata[7053] */
    { 3527, 0x00000000U, 0xE9792075U }, /* XSUM_XXH32_testdata[7054] */
    { 3527, 0x9E3779B1U, 0x1701622EU }, /* XSUM_XXH32_testdata[7055] */
    { 3528, 0x00000000U, 0x35B37877U }, /* XSUM_XXH32_testdata[7056] */
    { 3528, 0x9E3779B1U, 0x476E1658U }, /* XSUM_XXH32_testdata[7057] */
    { 3529, 0x00000000U, 0x1730D7A9U }, /* XSUM_XXH32_testdata[7058] */
    { 3529, 0x9E3779B1U, 0x40DBBCFFU }, /* XSUM_XXH32_testdata[7059] */
    { 3530, 0x00000000U, 0x62A5E278U }, /* XSUM_XXH32_testdata[7060] */
    { 3530, 0x9E3779B1U, 0xEB1DF0C7U }, /* XSUM_XXH32_testdata[7061] */
    { 3531, 0x00000000U, 0x5517A733U }, /* XSUM_XXH32_testdata[7062] */
    { 3531, 0x9E3779B1U, 0xBD815BD5U }, /* XSUM_XXH32_testdata[7063] */
    { 3532, 0x00000000U, 0x16CC0FA9U }, /* XSUM_XXH32_testdata[7064] */
    { 3532, 0x9E3779B1U, 0x37AAE186U }, /* XSUM_XXH32_testdata[7065] */
    { 3533, 0x00000000U, 0x1B5D51E6U }, /* XSUM_XXH32_testdata[7066] */
    { 3533, 0x9E3779B1U, 0x1BB9142FU }, /* XSUM_XXH32_testdata[7067] */
    { 3534, 0x00000000U, 0xD57E81A1U }, /* XSUM_XXH32_testdata[7068] */
    { 3534, 0x9E3779B1U, 0x22B33257U }, /* XSUM_XXH32_testdata[7069] */
    { 3535, 0x00000000U, 0x2C9C4DFBU }, /* XSUM_XXH32_testdata[7070] */
    { 3535, 0x9E3779B1U, 0xEC8E3D7AU }, /* XSUM_XXH32_testdata[7071] */
    { 3536, 0x00000000U, 0xC8051139U }, /* XSUM_XXH32_testdata[7072] */
    { 3536, 0x9E3779B1U, 0x66A8B1B2U }, /* XSUM_XXH32_testdata[7073] */
    { 3537, 0x00000000U, 0x6304DB45U }, /* XSUM_XXH32_testdata[7074] */
    { 3537, 0x9E3779B1U, 0x83BB1FDFU }, /* XSUM_XXH32_testdata[7075] */
    { 3538, 0x00000000U, 0xC0EC1FDFU }, /* XSUM_XXH32_testdata[7076] */
    { 3538, 0x9E3779B1U, 0x788F25ADU }, /* XSUM_XXH32_testdata[7077] */
    { 3539, 0x00000000U, 0xD3784BD2U }, /* XSUM_XXH32_testdata[7078] */
    { 3539, 0x9E3779B1U, 0x32FEC42AU }, /* XSUM_XXH32_testdata[7079] */
    { 3540, 0x00000000U, 0xBA5A0529U }, /* XSUM_XXH32_testdata[7080] */
    { 3540, 0x9E3779B1U, 0x3589D353U }, /* XSUM_XXH32_testdata[7081] */
    { 3541, 0x00000000U, 0xD7EB3631U }, /* XSUM_XXH32_testdata[7082] */
    { 3541, 0x9E3779B1U, 0xE4710E85U }, /* XSUM_XXH32_testdata[7083] */
    { 3542, 0x00000000U, 0x3D32669CU }, /* XSUM_XXH32_testdata[7084] */
    { 3542, 0x9E3779B1U, 0x616B634DU }, /* XSUM_XXH32_testdata[7085] */
    { 3543, 0x00000000U, 0xC60FC5D1U }, /* XSUM_XXH32_testdata[7086] */
    { 3543, 0x9E3779B1U, 0x9DB69990U }, /* XSUM_XXH32_testdata[7087] */
    { 3544, 0x00000000U, 0x1A75BAFFU }, /* XSUM_XXH32_testdata[7088] */
    { 3544, 0x9E3779B1U, 0xC360F2F0U }, /* XSUM_XXH32_testdata[7089] */
    { 3545, 0x00000000U, 0xC8030778U }, /* XSUM_XXH32_testdata[7090] */
    { 3545, 0x9E3779B1U, 0xC8B7F46CU }, /* XSUM_XXH32_testdata[7091] */
    { 3546, 0x00000000U, 0x9CFA61D4U }, /* XSUM_XXH32_testdata[7092] */
    { 3546, 0x9E3779B1U, 0xB72B3A6BU }, /* XSUM_XXH32_testdata[7093] */
    { 3547, 0x00000000U, 0x465B0498U }, /* XSUM_XXH32_testdata[7094] */
    { 3547, 0x9E3779B1U, 0x1A23E3BCU }, /* XSUM_XXH32_testdata[7095] */
    { 3548, 0x00000000U, 0xF6705104U }, /* XSUM_XXH32_testdata[7096] */
    { 3548, 0x9E3779B1U, 0x0969FAC1U }, /* XSUM_XXH32_testdata[7097] */
    { 3549, 0x00000000U, 0x2D995AE5U }, /* XSUM_XXH32_testdata[7098] */
    { 3549, 0x9E3779B1U, 0x705FF6A2U }, /* XSUM_XXH32_testdata[7099] */
    { 3550, 0x00000000U, 0xAC0277ECU }, /* XSUM_XXH32_testdata[7100] */
    { 3550, 0x9E3779B1U, 0x3A46B72AU }, /* XSUM_XXH32_testdata[7101] */
    { 3551, 0x00000000U, 0x153B0F38U }, /* XSUM_XXH32_testdata[7102] */
    { 3551, 0x9E3779B1U, 0xF734C0FFU }, /* XSUM_XXH32_testdata[7103] */
    { 3552, 0x00000000U, 0xADB62613U }, /* XSUM_XXH32_testdata[7104] */
    { 3552, 0x9E3779B1U, 0x476D2E99U }, /* XSUM_XXH32_testdata[7105] */
    { 3553, 0x00000000U, 0x40E549F9U }, /* XSUM_XXH32_testdata[7106] */
    { 3553, 0x9E3779B1U, 0x8D5DC517U }, /* XSUM_XXH32_testdata[7107] */
    { 3554, 0x00000000U, 0x5A9AE8F6U }, /* XSUM_XXH32_testdata[7108] */
    { 3554, 0x9E3779B1U, 0xD167867FU }, /* XSUM_XXH32_testdata[7109] */
    { 3555, 0x00000000U, 0x9C4BECFAU }, /* XSUM_XXH32_testdata[7110] */
    { 3555, 0x9E3779B1U, 0x1B257CF9U }, /* XSUM_XXH32_testdata[7111] */
    { 3556, 0x00000000U, 0x7BF50C64U }, /* XSUM_XXH32_testdata[7112] */
    { 3556, 0x9E3779B1U, 0xEDDE9A0AU }, /* XSUM_XXH32_testdata[7113] */
    { 3557, 0x00000000U, 0x3958598AU }, /* XSUM_XXH32_testdata[7114] */
    { 3557, 0x9E3779B1U, 0xAEC3F855U }, /* XSUM_XXH32_testdata[7115] */
    { 3558, 0x00000000U, 0x6F1B8B73U }, /* XSUM_XXH32_testdata[7116] */
    { 3558, 0x9E3779B1U, 0x0EAA923CU }, /* XSUM_XXH32_testdata[7117] */
    { 3559, 0x00000000U, 0x8DF1829EU }, /* XSUM_XXH32_testdata[7118] */
    { 3559, 0x9E3779B1U, 0x52DE3C01U }, /* XSUM_XXH32_testdata[7119] */
    { 3560, 0x00000000U, 0xA33B30D8U }, /* XSUM_XXH32_testdata[7120] */
    { 3560, 0x9E3779B1U, 0xEF5E67F0U }, /* XSUM_XXH32_testdata[7121] */
    { 3561, 0x00000000U, 0xFA8B0F56U }, /* XSUM_XXH32_testdata[7122] */
    { 3561, 0x9E3779B1U, 0x090388C0U }, /* XSUM_XXH32_testdata[7123] */
    { 3562, 0x00000000U, 0xC6871C47U }, /* XSUM_XXH32_testdata[7124] */
    { 3562, 0x9E3779B1U, 0x395BA54BU }, /* XSUM_XXH32_testdata[7125] */
    { 3563, 0x00000000U, 0x673C9DD3U }, /* XSUM_XXH32_testdata[7126] */
    { 3563, 0x9E3779B1U, 0x968E8EADU }, /* XSUM_XXH32_testdata[7127] */
    { 3564, 0x00000000U, 0x7D9EBDF6U }, /* XSUM_XXH32_testdata[7128] */
    { 3564, 0x9E3779B1U, 0x61ADCCE9U }, /* XSUM_XXH32_testdata[7129] */
    { 3565, 0x00000000U, 0xB7A2296BU }, /* XSUM_XXH32_testdata[7130] */
    { 3565, 0x9E3779B1U, 0xC1A5B56CU }, /* XSUM_XXH32_testdata[7131] */
    { 3566, 0x00000000U, 0x15D3EAF5U }, /* XSUM_XXH32_testdata[7132] */
    { 3566, 0x9E3779B1U, 0xEE84F700U }, /* XSUM_XXH32_testdata[7133] */
    { 3567, 0x00000000U, 0x68AD4088U }, /* XSUM_XXH32_testdata[7134] */
    { 3567, 0x9E3779B1U, 0x4959A852U }, /* XSUM_XXH32_testdata[7135] */
    { 3568, 0x00000000U, 0x9C9EB0E2U }, /* XSUM_XXH32_testdata[7136] */
    { 3568, 0x9E3779B1U, 0x46346CE5U }, /* XSUM_XXH32_testdata[7137] */
    { 3569, 0x00000000U, 0xF28C4CF0U }, /* XSUM_XXH32_testdata[7138] */
    { 3569, 0x9E3779B1U, 0xFD31C9EAU }, /* XSUM_XXH32_testdata[7139] */
    { 3570, 0x00000000U, 0x51E28226U }, /* XSUM_XXH32_testdata[7140] */
    { 3570, 0x9E3779B1U, 0xF971C6F2U }, /* XSUM_XXH32_testdata[7141] */
    { 3571, 0x00000000U, 0x5C531B22U }, /* XSUM_XXH32_testdata[7142] */
    { 3571, 0x9E3779B1U, 0x18A2DDFBU }, /* XSUM_XXH32_testdata[7143] */
    { 3572, 0x00000000U, 0x6E283669U }, /* XSUM_XXH32_testdata[7144] */
    { 3572, 0x9E3779B1U, 0xDB304732U }, /* XSUM_XXH32_testdata[7145] */
    { 3573, 0x00000000U, 0xC3C10F98U }, /* XSUM_XXH32_testdata[7146] */
    { 3573, 0x9E3779B1U, 0x2CEEBE73U }, /* XSUM_XXH32_testdata[7147] */
    { 3574, 0x00000000U, 0x5155011CU }, /* XSUM_XXH32_testdata[7148] */
    { 3574, 0x9E3779B1U, 0xBB0C964DU }, /* XSUM_XXH32_testdata[7149] */
    { 3575, 0x00000000U, 0x9DED4077U }, /* XSUM_XXH32_testdata[7150] */
    { 3575, 0x9E3779B1U, 0x9A75980BU }, /* XSUM_XXH32_testdata[7151] */
    { 3576, 0x00000000U, 0x93DC6857U }, /* XSUM_XXH32_testdata[7152] */
    { 3576, 0x9E3779B1U, 0x2702EE0FU }, /* XSUM_XXH32_testdata[7153] */
    { 3577, 0x00000000U, 0x1A1C2D2EU }, /* XSUM_XXH32_testdata[7154] */
    { 3577, 0x9E3779B1U, 0x716CE1D3U }, /* XSUM_XXH32_testdata[7155] */
    { 3578, 0x00000000U, 0x636F90BBU }, /* XSUM_XXH32_testdata[7156] */
    { 3578, 0x9E3779B1U, 0x1A7FA949U }, /* XSUM_XXH32_testdata[7157] */
    { 3579, 0x00000000U, 0xC822F241U }, /* XSUM_XXH32_testdata[7158] */
    { 3579, 0x9E3779B1U, 0x96E16D96U }, /* XSUM_XXH32_testdata[7159] */
    { 3580, 0x00000000U, 0xF0A8735AU }, /* XSUM_XXH32_testdata[7160] */
    { 3580, 0x9E3779B1U, 0x0156D3B9U }, /* XSUM_XXH32_testdata[7161] */
    { 3581, 0x00000000U, 0xAC8804A7U }, /* XSUM_XXH32_testdata[7162] */
    { 3581, 0x9E3779B1U, 0x5D17F278U }, /* XSUM_XXH32_testdata[7163] */
    { 3582, 0x00000000U, 0xBCBBC758U }, /* XSUM_XXH32_testdata[7164] */
    { 3582, 0x9E3779B1U, 0x03BE88E3U }, /* XSUM_XXH32_testdata[7165] */
    { 3583, 0x00000000U, 0x58DA2037U }, /* XSUM_XXH32_testdata[7166] */
    { 3583, 0x9E3779B1U, 0xFEB8042FU }, /* XSUM_XXH32_testdata[7167] */
    { 3584, 0x00000000U, 0x6893F203U }, /* XSUM_XXH32_testdata[7168] */
    { 3584, 0x9E3779B1U, 0xD884346AU }, /* XSUM_XXH32_testdata[7169] */
    { 3585, 0x00000000U, 0x920F97D0U }, /* XSUM_XXH32_testdata[7170] */
    { 3585, 0x9E3779B1U, 0xD290ACA9U }, /* XSUM_XXH32_testdata[7171] */
    { 3586, 0x00000000U, 0x9F9A51CEU }, /* XSUM_XXH32_testdata[7172] */
    { 3586, 0x9E3779B1U, 0x16637BACU }, /* XSUM_XXH32_testdata[7173] */
    { 3587, 0x00000000U, 0x1945E691U }, /* XSUM_XXH32_testdata[7174] */
    { 3587, 0x9E3779B1U, 0x26D280AEU }, /* XSUM_XXH32_testdata[7175] */
    { 3588, 0x00000000U, 0xB3C7F86DU }, /* XSUM_XXH32_testdata[7176] */
    { 3588, 0x9E3779B1U, 0x53FD0536U }, /* XSUM_XXH32_testdata[7177] */
    { 3589, 0x00000000U, 0xBBEB446AU }, /* XSUM_XXH32_testdata[7178] */
    { 3589, 0x9E3779B1U, 0xB3E8B406U }, /* XSUM_XXH32_testdata[7179] */
    { 3590, 0x00000000U, 0x9747DA45U }, /* XSUM_XXH32_testdata[7180] */
    { 3590, 0x9E3779B1U, 0x11E00421U }, /* XSUM_XXH32_testdata[7181] */
    { 3591, 0x00000000U, 0x31C26A3AU }, /* XSUM_XXH32_testdata[7182] */
    { 3591, 0x9E3779B1U, 0x80FB18F7U }, /* XSUM_XXH32_testdata[7183] */
    { 3592, 0x00000000U, 0x81BDA98BU }, /* XSUM_XXH32_testdata[7184] */
    { 3592, 0x9E3779B1U, 0xC4D7CF42U }, /* XSUM_XXH32_testdata[7185] */
    { 3593, 0x00000000U, 0x195B87A6U }, /* XSUM_XXH32_testdata[7186] */
    { 3593, 0x9E3779B1U, 0x9F2C004FU }, /* XSUM_XXH32_testdata[7187] */
    { 3594, 0x00000000U, 0xFB20D9DBU }, /* XSUM_XXH32_testdata[7188] */
    { 3594, 0x9E3779B1U, 0x2BE017EEU }, /* XSUM_XXH32_testdata[7189] */
    { 3595, 0x00000000U, 0x41657EB8U }, /* XSUM_XXH32_testdata[7190] */
    { 3595, 0x9E3779B1U, 0x37B3AD5BU }, /* XSUM_XXH32_testdata[7191] */
    { 3596, 0x00000000U, 0x0833A515U }, /* XSUM_XXH32_testdata[7192] */
    { 3596, 0x9E3779B1U, 0xD054E897U }, /* XSUM_XXH32_testdata[7193] */
    { 3597, 0x00000000U, 0xC9E91D55U }, /* XSUM_XXH32_testdata[7194] */
    { 3597, 0x9E3779B1U, 0x5EEA1C9BU }, /* XSUM_XXH32_testdata[7195] */
    { 3598, 0x00000000U, 0x536B10ACU }, /* XSUM_XXH32_testdata[7196] */
    { 3598, 0x9E3779B1U, 0x57C11BBEU }, /* XSUM_XXH32_testdata[7197] */
    { 3599, 0x00000000U, 0x62ACCDF1U }, /* XSUM_XXH32_testdata[7198] */
    { 3599, 0x9E3779B1U, 0xC80B67A2U }, /* XSUM_XXH32_testdata[7199] */
    { 3600, 0x00000000U, 0x248FA81BU }, /* XSUM_XXH32_testdata[7200] */
    { 3600, 0x9E3779B1U, 0x9A7F6193U }, /* XSUM_XXH32_testdata[7201] */
    { 3601, 0x00000000U, 0x612F2F5CU }, /* XSUM_XXH32_testdata[7202] */
    { 3601, 0x9E3779B1U, 0x68243746U }, /* XSUM_XXH32_testdata[7203] */
    { 3602, 0x00000000U, 0xDD0AF8AEU }, /* XSUM_XXH32_testdata[7204] */
    { 3602, 0x9E3779B1U, 0x69725F6BU }, /* XSUM_XXH32_testdata[7205] */
    { 3603, 0x00000000U, 0x4E426DD5U }, /* XSUM_XXH32_testdata[7206] */
    { 3603, 0x9E3779B1U, 0xA633F6E4U }, /* XSUM_XXH32_testdata[7207] */
    { 3604, 0x00000000U, 0xDB9ACEBEU }, /* XSUM_XXH32_testdata[7208] */
    { 3604, 0x9E3779B1U, 0x1F65BD5AU }, /* XSUM_XXH32_testdata[7209] */
    { 3605, 0x00000000U, 0x0926AFE3U }, /* XSUM_XXH32_testdata[7210] */
    { 3605, 0x9E3779B1U, 0xDBD7C475U }, /* XSUM_XXH32_testdata[7211] */
    { 3606, 0x00000000U, 0x7B5FCD93U }, /* XSUM_XXH32_testdata[7212] */
    { 3606, 0x9E3779B1U, 0xC5220832U }, /* XSUM_XXH32_testdata[7213] */
    { 3607, 0x00000000U, 0xABE80EF3U }, /* XSUM_XXH32_testdata[7214] */
    { 3607, 0x9E3779B1U, 0xCE0C1C05U }, /* XSUM_XXH32_testdata[7215] */
    { 3608, 0x00000000U, 0xB1BDDC30U }, /* XSUM_XXH32_testdata[7216] */
    { 3608, 0x9E3779B1U, 0x20010F7CU }, /* XSUM_XXH32_testdata[7217] */
    { 3609, 0x00000000U, 0x07CFED4AU }, /* XSUM_XXH32_testdata[7218] */
    { 3609, 0x9E3779B1U, 0x85A74074U }, /* XSUM_XXH32_testdata[7219] */
    { 3610, 0x00000000U, 0xDBD8BA2DU }, /* XSUM_XXH32_testdata[7220] */
    { 3610, 0x9E3779B1U, 0xFC3E98F8U }, /* XSUM_XXH32_testdata[7221] */
    { 3611, 0x00000000U, 0x8FE9E2FBU }, /* XSUM_XXH32_testdata[7222] */
    { 3611, 0x9E3779B1U, 0xFA564F48U }, /* XSUM_XXH32_testdata[7223] */
    { 3612, 0x00000000U, 0x05C87C18U }, /* XSUM_XXH32_testdata[7224] */
    { 3612, 0x9E3779B1U, 0x33734232U }, /* XSUM_XXH32_testdata[7225] */
    { 3613, 0x00000000U, 0x3D6E0DE9U }, /* XSUM_XXH32_testdata[7226] */
    { 3613, 0x9E3779B1U, 0x3B09945EU }, /* XSUM_XXH32_testdata[7227] */
    { 3614, 0x00000000U, 0x2E2805ACU }, /* XSUM_XXH32_testdata[7228] */
    { 3614, 0x9E3779B1U, 0x746DD566U }, /* XSUM_XXH32_testdata[7229] */
    { 3615, 0x00000000U, 0x23B192C0U }, /* XSUM_XXH32_testdata[7230] */
    { 3615, 0x9E3779B1U, 0xF8A65F68U }, /* XSUM_XXH32_testdata[7231] */
    { 3616, 0x00000000U, 0x6D4B9060U }, /* XSUM_XXH32_testdata[7232] */
    { 3616, 0x9E3779B1U, 0x9FB9D735U }, /* XSUM_XXH32_testdata[7233] */
    { 3617, 0x00000000U, 0xD0D5B57EU }, /* XSUM_XXH32_testdata[7234] */
    { 3617, 0x9E3779B1U, 0xFFC976E4U }, /* XSUM_XXH32_testdata[7235] */
    { 3618, 0x00000000U, 0x018D8944U }, /* XSUM_XXH32_testdata[7236] */
    { 3618, 0x9E3779B1U, 0x1181CB90U }, /* XSUM_XXH32_testdata[7237] */
    { 3619, 0x00000000U, 0x91CA159AU }, /* XSUM_XXH32_testdata[7238] */
    { 3619, 0x9E3779B1U, 0x55CBBA05U }, /* XSUM_XXH32_testdata[7239] */
    { 3620, 0x00000000U, 0x3A3822BAU }, /* XSUM_XXH32_testdata[7240] */
    { 3620, 0x9E3779B1U, 0x405DE479U }, /* XSUM_XXH32_testdata[7241] */
    { 3621, 0x00000000U, 0xE3008463U }, /* XSUM_XXH32_testdata[7242] */
    { 3621, 0x9E3779B1U, 0xBC60BB0CU }, /* XSUM_XXH32_testdata[7243] */
    { 3622, 0x00000000U, 0x0D7781DFU }, /* XSUM_XXH32_testdata[7244] */
    { 3622, 0x9E3779B1U, 0xBC99B44AU }, /* XSUM_XXH32_testdata[7245] */
    { 3623, 0x00000000U, 0xA6A82918U }, /* XSUM_XXH32_testdata[7246] */
    { 3623, 0x9E3779B1U, 0x04574148U }, /* XSUM_XXH32_testdata[7247] */
    { 3624, 0x00000000U, 0xCE79503BU }, /* XSUM_XXH32_testdata[7248] */
    { 3624, 0x9E3779B1U, 0xF13AE2DAU }, /* XSUM_XXH32_testdata[7249] */
    { 3625, 0x00000000U, 0xDD749303U }, /* XSUM_XXH32_testdata[7250] */
    { 3625, 0x9E3779B1U, 0x7A3FA3F5U }, /* XSUM_XXH32_testdata[7251] */
    { 3626, 0x00000000U, 0x05F3B13FU }, /* XSUM_XXH32_testdata[7252] */
    { 3626, 0x9E3779B1U, 0xDCCCA732U }, /* XSUM_XXH32_testdata[7253] */
    { 3627, 0x00000000U, 0xFD0ED277U }, /* XSUM_XXH32_testdata[7254] */
    { 3627, 0x9E3779B1U, 0x292D4ED1U }, /* XSUM_XXH32_testdata[7255] */
    { 3628, 0x00000000U, 0xE0E69D0DU }, /* XSUM_XXH32_testdata[7256] */
    { 3628, 0x9E3779B1U, 0x7A94BC7AU }, /* XSUM_XXH32_testdata[7257] */
    { 3629, 0x00000000U, 0xB1729762U }, /* XSUM_XXH32_testdata[7258] */
    { 3629, 0x9E3779B1U, 0x78782C54U }, /* XSUM_XXH32_testdata[7259] */
    { 3630, 0x00000000U, 0xA53435FFU }, /* XSUM_XXH32_testdata[7260] */
    { 3630, 0x9E3779B1U, 0x05E96413U }, /* XSUM_XXH32_testdata[7261] */
    { 3631, 0x00000000U, 0x24E8B9BAU }, /* XSUM_XXH32_testdata[7262] */
    { 3631, 0x9E3779B1U, 0x068F987BU }, /* XSUM_XXH32_testdata[7263] */
    { 3632, 0x00000000U, 0xA1D8B4CBU }, /* XSUM_XXH32_testdata[7264] */
    { 3632, 0x9E3779B1U, 0xBD6FD879U }, /* XSUM_XXH32_testdata[7265] */
    { 3633, 0x00000000U, 0x2F81612CU }, /* XSUM_XXH32_testdata[7266] */
    { 3633, 0x9E3779B1U, 0xE3CE4F02U }, /* XSUM_XXH32_testdata[7267] */
    { 3634, 0x00000000U, 0x4BECD281U }, /* XSUM_XXH32_testdata[7268] */
    { 3634, 0x9E3779B1U, 0x42D777B6U }, /* XSUM_XXH32_testdata[7269] */
    { 3635, 0x00000000U, 0xF72EB756U }, /* XSUM_XXH32_testdata[7270] */
    { 3635, 0x9E3779B1U, 0x80D63D29U }, /* XSUM_XXH32_testdata[7271] */
    { 3636, 0x00000000U, 0x1F6CE3B9U }, /* XSUM_XXH32_testdata[7272] */
    { 3636, 0x9E3779B1U, 0x100715A4U }, /* XSUM_XXH32_testdata[7273] */
    { 3637, 0x00000000U, 0x6345D314U }, /* XSUM_XXH32_testdata[7274] */
    { 3637, 0x9E3779B1U, 0xFF5303AAU }, /* XSUM_XXH32_testdata[7275] */
    { 3638, 0x00000000U, 0xF7EA7332U }, /* XSUM_XXH32_testdata[7276] */
    { 3638, 0x9E3779B1U, 0x913E1D4AU }, /* XSUM_XXH32_testdata[7277] */
    { 3639, 0x00000000U, 0xD940F160U }, /* XSUM_XXH32_testdata[7278] */
    { 3639, 0x9E3779B1U, 0x32B83120U }, /* XSUM_XXH32_testdata[7279] */
    { 3640, 0x00000000U, 0xBAA4E80DU }, /* XSUM_XXH32_testdata[7280] */
    { 3640, 0x9E3779B1U, 0xDDA189EBU }, /* XSUM_XXH32_testdata[7281] */
    { 3641, 0x00000000U, 0x090BB8C3U }, /* XSUM_XXH32_testdata[7282] */
    { 3641, 0x9E3779B1U, 0xF3477C4CU }, /* XSUM_XXH32_testdata[7283] */
    { 3642, 0x00000000U, 0xE0AE7710U }, /* XSUM_XXH32_testdata[7284] */
    { 3642, 0x9E3779B1U, 0x352779AAU }, /* XSUM_XXH32_testdata[7285] */
    { 3643, 0x00000000U, 0xEE0DDE23U }, /* XSUM_XXH32_testdata[7286] */
    { 3643, 0x9E3779B1U, 0x99297192U }, /* XSUM_XXH32_testdata[7287] */
    { 3644, 0x00000000U, 0x4FE78ECFU }, /* XSUM_XXH32_testdata[7288] */
    { 3644, 0x9E3779B1U, 0xC295548CU }, /* XSUM_XXH32_testdata[7289] */
    { 3645, 0x00000000U, 0x8003E9D6U }, /* XSUM_XXH32_testdata[7290] */
    { 3645, 0x9E3779B1U, 0xF8A5B12CU }, /* XSUM_XXH32_testdata[7291] */
    { 3646, 0x00000000U, 0xBB44D6ECU }, /* XSUM_XXH32_testdata[7292] */
    { 3646, 0x9E3779B1U, 0x4D278668U }, /* XSUM_XXH32_testdata[7293] */
    { 3647, 0x00000000U, 0x66D490B2U }, /* XSUM_XXH32_testdata[7294] */
    { 3647, 0x9E3779B1U, 0xC9BFAE22U }, /* XSUM_XXH32_testdata[7295] */
    { 3648, 0x00000000U, 0x433EEDFBU }, /* XSUM_XXH32_testdata[7296] */
    { 3648, 0x9E3779B1U, 0x6DF2AB93U }, /* XSUM_XXH32_testdata[7297] */
    { 3649, 0x00000000U, 0xAE3CC2A2U }, /* XSUM_XXH32_testdata[7298] */
    { 3649, 0x9E3779B1U, 0xFBA61A0BU }, /* XSUM_XXH32_testdata[7299] */
    { 3650, 0x00000000U, 0xD4B857B4U }, /* XSUM_XXH32_testdata[7300] */
    { 3650, 0x9E3779B1U, 0x8613D6D3U }, /* XSUM_XXH32_testdata[7301] */
    { 3651, 0x00000000U, 0xACA5779EU }, /* XSUM_XXH32_testdata[7302] */
    { 3651, 0x9E3779B1U, 0x2F99119FU }, /* XSUM_XXH32_testdata[7303] */
    { 3652, 0x00000000U, 0x6A73923DU }, /* XSUM_XXH32_testdata[7304] */
    { 3652, 0x9E3779B1U, 0xD6FE0D5EU }, /* XSUM_XXH32_testdata[7305] */
    { 3653, 0x00000000U, 0x4BB6A2B8U }, /* XSUM_XXH32_testdata[7306] */
    { 3653, 0x9E3779B1U, 0x5F5A48D4U }, /* XSUM_XXH32_testdata[7307] */
    { 3654, 0x00000000U, 0x264DC18AU }, /* XSUM_XXH32_testdata[7308] */
    { 3654, 0x9E3779B1U, 0xAA205A02U }, /* XSUM_XXH32_testdata[7309] */
    { 3655, 0x00000000U, 0x7702D38EU }, /* XSUM_XXH32_testdata[7310] */
    { 3655, 0x9E3779B1U, 0xD7A9C885U }, /* XSUM_XXH32_testdata[7311] */
    { 3656, 0x00000000U, 0xA2341A92U }, /* XSUM_XXH32_testdata[7312] */
    { 3656, 0x9E3779B1U, 0xEDA179DBU }, /* XSUM_XXH32_testdata[7313] */
    { 3657, 0x00000000U, 0xB2C78F40U }, /* XSUM_XXH32_testdata[7314] */
    { 3657, 0x9E3779B1U, 0x34D8E18AU }, /* XSUM_XXH32_testdata[7315] */
    { 3658, 0x00000000U, 0xF46825EAU }, /* XSUM_XXH32_testdata[7316] */
    { 3658, 0x9E3779B1U, 0x6BA4000DU }, /* XSUM_XXH32_testdata[7317] */
    { 3659, 0x00000000U, 0x272A1414U }, /* XSUM_XXH32_testdata[7318] */
    { 3659, 0x9E3779B1U, 0x1C225E88U }, /* XSUM_XXH32_testdata[7319] */
    { 3660, 0x00000000U, 0x4D40BB27U }, /* XSUM_XXH32_testdata[7320] */
    { 3660, 0x9E3779B1U, 0x86F6E4B7U }, /* XSUM_XXH32_testdata[7321] */
    { 3661, 0x00000000U, 0xE47B2164U }, /* XSUM_XXH32_testdata[7322] */
    { 3661, 0x9E3779B1U, 0x057B0989U }, /* XSUM_XXH32_testdata[7323] */
    { 3662, 0x00000000U, 0xF4F3B211U }, /* XSUM_XXH32_testdata[7324] */
    { 3662, 0x9E3779B1U, 0xA37ED698U }, /* XSUM_XXH32_testdata[7325] */
    { 3663, 0x00000000U, 0x66F56DEAU }, /* XSUM_XXH32_testdata[7326] */
    { 3663, 0x9E3779B1U, 0xB1A96290U }, /* XSUM_XXH32_testdata[7327] */
    { 3664, 0x00000000U, 0xD7C9727FU }, /* XSUM_XXH32_testdata[7328] */
    { 3664, 0x9E3779B1U, 0x23D3D26EU }, /* XSUM_XXH32_testdata[7329] */
    { 3665, 0x00000000U, 0xECEF42D3U }, /* XSUM_XXH32_testdata[7330] */
    { 3665, 0x9E3779B1U, 0x3F7AF7EBU }, /* XSUM_XXH32_testdata[7331] */
    { 3666, 0x00000000U, 0x8C1A3722U }, /* XSUM_XXH32_testdata[7332] */
    { 3666, 0x9E3779B1U, 0x5053CF8BU }, /* XSUM_XXH32_testdata[7333] */
    { 3667, 0x00000000U, 0xC0B70BF5U }, /* XSUM_XXH32_testdata[7334] */
    { 3667, 0x9E3779B1U, 0xE9C1437BU }, /* XSUM_XXH32_testdata[7335] */
    { 3668, 0x00000000U, 0xAFF57195U }, /* XSUM_XXH32_testdata[7336] */
    { 3668, 0x9E3779B1U, 0x631E9AB7U }, /* XSUM_XXH32_testdata[7337] */
    { 3669, 0x00000000U, 0xC7AAE176U }, /* XSUM_XXH32_testdata[7338] */
    { 3669, 0x9E3779B1U, 0x221A00AAU }, /* XSUM_XXH32_testdata[7339] */
    { 3670, 0x00000000U, 0x1352CD2BU }, /* XSUM_XXH32_testdata[7340] */
    { 3670, 0x9E3779B1U, 0x82FE38E4U }, /* XSUM_XXH32_testdata[7341] */
    { 3671, 0x00000000U, 0xF32EE209U }, /* XSUM_XXH32_testdata[7342] */
    { 3671, 0x9E3779B1U, 0xEDB27D0BU }, /* XSUM_XXH32_testdata[7343] */
    { 3672, 0x00000000U, 0x745030EEU }, /* XSUM_XXH32_testdata[7344] */
    { 3672, 0x9E3779B1U, 0x0A815D11U }, /* XSUM_XXH32_testdata[7345] */
    { 3673, 0x00000000U, 0x45973C5EU }, /* XSUM_XXH32_testdata[7346] */
    { 3673, 0x9E3779B1U, 0x7E73FDC1U }, /* XSUM_XXH32_testdata[7347] */
    { 3674, 0x00000000U, 0x031151AEU }, /* XSUM_XXH32_testdata[7348] */
    { 3674, 0x9E3779B1U, 0x88D82AA3U }, /* XSUM_XXH32_testdata[7349] */
    { 3675, 0x00000000U, 0x1AC982C5U }, /* XSUM_XXH32_testdata[7350] */
    { 3675, 0x9E3779B1U, 0xC63D047FU }, /* XSUM_XXH32_testdata[7351] */
    { 3676, 0x00000000U, 0x4C2E7260U }, /* XSUM_XXH32_testdata[7352] */
    { 3676, 0x9E3779B1U, 0x33271915U }, /* XSUM_XXH32_testdata[7353] */
    { 3677, 0x00000000U, 0x74A66944U }, /* XSUM_XXH32_testdata[7354] */
    { 3677, 0x9E3779B1U, 0xB8EC2F48U }, /* XSUM_XXH32_testdata[7355] */
    { 3678, 0x00000000U, 0xED58C98DU }, /* XSUM_XXH32_testdata[7356] */
    { 3678, 0x9E3779B1U, 0x61D8E0C5U }, /* XSUM_XXH32_testdata[7357] */
    { 3679, 0x00000000U, 0x5903CF0FU }, /* XSUM_XXH32_testdata[7358] */
    { 3679, 0x9E3779B1U, 0x7F4C3174U }, /* XSUM_XXH32_testdata[7359] */
    { 3680, 0x00000000U, 0x82CFC45FU }, /* XSUM_XXH32_testdata[7360] */
    { 3680, 0x9E3779B1U, 0x1058A07EU }, /* XSUM_XXH32_testdata[7361] */
    { 3681, 0x00000000U, 0x4D663B2DU }, /* XSUM_XXH32_testdata[7362] */
    { 3681, 0x9E3779B1U, 0xFAA5E9A8U }, /* XSUM_XXH32_testdata[7363] */
    { 3682, 0x00000000U, 0xA72C0F91U }, /* XSUM_XXH32_testdata[7364] */
    { 3682, 0x9E3779B1U, 0x9FD90FFBU }, /* XSUM_XXH32_testdata[7365] */
    { 3683, 0x00000000U, 0xA45A9480U }, /* XSUM_XXH32_testdata[7366] */
    { 3683, 0x9E3779B1U, 0x34593515U }, /* XSUM_XXH32_testdata[7367] */
    { 3684, 0x00000000U, 0xD9F22F8BU }, /* XSUM_XXH32_testdata[7368] */
    { 3684, 0x9E3779B1U, 0xE6B8FE71U }, /* XSUM_XXH32_testdata[7369] */
    { 3685, 0x00000000U, 0xEE13ABA8U }, /* XSUM_XXH32_testdata[7370] */
    { 3685, 0x9E3779B1U, 0x804A8630U }, /* XSUM_XXH32_testdata[7371] */
    { 3686, 0x00000000U, 0x6DFA7CE4U }, /* XSUM_XXH32_testdata[7372] */
    { 3686, 0x9E3779B1U, 0x67D09C0DU }, /* XSUM_XXH32_testdata[7373] */
    { 3687, 0x00000000U, 0x6EF8729AU }, /* XSUM_XXH32_testdata[7374] */
    { 3687, 0x9E3779B1U, 0x7B09E3BBU }, /* XSUM_XXH32_testdata[7375] */
    { 3688, 0x00000000U, 0x386E29C6U }, /* XSUM_XXH32_testdata[7376] */
    { 3688, 0x9E3779B1U, 0x601345A1U }, /* XSUM_XXH32_testdata[7377] */
    { 3689, 0x00000000U, 0xC36A10CCU }, /* XSUM_XXH32_testdata[7378] */
    { 3689, 0x9E3779B1U, 0xE62B5109U }, /* XSUM_XXH32_testdata[7379] */
    { 3690, 0x00000000U, 0x260FCC1BU }, /* XSUM_XXH32_testdata[7380] */
    { 3690, 0x9E3779B1U, 0x2B7E8B72U }, /* XSUM_XXH32_testdata[7381] */
    { 3691, 0x00000000U, 0xACA468F6U }, /* XSUM_XXH32_testdata[7382] */
    { 3691, 0x9E3779B1U, 0x6069FDF5U }, /* XSUM_XXH32_testdata[7383] */
    { 3692, 0x00000000U, 0x542352E4U }, /* XSUM_XXH32_testdata[7384] */
    { 3692, 0x9E3779B1U, 0x0B605099U }, /* XSUM_XXH32_testdata[7385] */
    { 3693, 0x00000000U, 0xA17F3D6EU }, /* XSUM_XXH32_testdata[7386] */
    { 3693, 0x9E3779B1U, 0x8063C86CU }, /* XSUM_XXH32_testdata[7387] */
    { 3694, 0x00000000U, 0x4F62B431U }, /* XSUM_XXH32_testdata[7388] */
    { 3694, 0x9E3779B1U, 0xB2BEC7F3U }, /* XSUM_XXH32_testdata[7389] */
    { 3695, 0x00000000U, 0xA8029317U }, /* XSUM_XXH32_testdata[7390] */
    { 3695, 0x9E3779B1U, 0x43618226U }, /* XSUM_XXH32_testdata[7391] */
    { 3696, 0x00000000U, 0x45706DF3U }, /* XSUM_XXH32_testdata[7392] */
    { 3696, 0x9E3779B1U, 0x2F35E653U }, /* XSUM_XXH32_testdata[7393] */
    { 3697, 0x00000000U, 0x5B284F60U }, /* XSUM_XXH32_testdata[7394] */
    { 3697, 0x9E3779B1U, 0x9852317AU }, /* XSUM_XXH32_testdata[7395] */
    { 3698, 0x00000000U, 0x758BF7CDU }, /* XSUM_XXH32_testdata[7396] */
    { 3698, 0x9E3779B1U, 0xEB4568B2U }, /* XSUM_XXH32_testdata[7397] */
    { 3699, 0x00000000U, 0x5D4C2318U }, /* XSUM_XXH32_testdata[7398] */
    { 3699, 0x9E3779B1U, 0x2D32982BU }, /* XSUM_XXH32_testdata[7399] */
    { 3700, 0x00000000U, 0x33C10122U }, /* XSUM_XXH32_testdata[7400] */
    { 3700, 0x9E3779B1U, 0xA3651514U }, /* XSUM_XXH32_testdata[7401] */
    { 3701, 0x00000000U, 0x83547B57U }, /* XSUM_XXH32_testdata[7402] */
    { 3701, 0x9E3779B1U, 0x1C474766U }, /* XSUM_XXH32_testdata[7403] */
    { 3702, 0x00000000U, 0xDA116714U }, /* XSUM_XXH32_testdata[7404] */
    { 3702, 0x9E3779B1U, 0x5BD04190U }, /* XSUM_XXH32_testdata[7405] */
    { 3703, 0x00000000U, 0x3065CE83U }, /* XSUM_XXH32_testdata[7406] */
    { 3703, 0x9E3779B1U, 0xE016429DU }, /* XSUM_XXH32_testdata[7407] */
    { 3704, 0x00000000U, 0xE1CCEF1BU }, /* XSUM_XXH32_testdata[7408] */
    { 3704, 0x9E3779B1U, 0xE2B2E9FAU }, /* XSUM_XXH32_testdata[7409] */
    { 3705, 0x00000000U, 0x6178948AU }, /* XSUM_XXH32_testdata[7410] */
    { 3705, 0x9E3779B1U, 0x034FF7A6U }, /* XSUM_XXH32_testdata[7411] */
    { 3706, 0x00000000U, 0xC843319DU }, /* XSUM_XXH32_testdata[7412] */
    { 3706, 0x9E3779B1U, 0x4DD7EADBU }, /* XSUM_XXH32_testdata[7413] */
    { 3707, 0x00000000U, 0x9DF614D2U }, /* XSUM_XXH32_testdata[7414] */
    { 3707, 0x9E3779B1U, 0xF556E4DFU }, /* XSUM_XXH32_testdata[7415] */
    { 3708, 0x00000000U, 0x65256DF7U }, /* XSUM_XXH32_testdata[7416] */
    { 3708, 0x9E3779B1U, 0x0360C7BBU }, /* XSUM_XXH32_testdata[7417] */
    { 3709, 0x00000000U, 0xC64ECC4EU }, /* XSUM_XXH32_testdata[7418] */
    { 3709, 0x9E3779B1U, 0x1A9836B5U }, /* XSUM_XXH32_testdata[7419] */
    { 3710, 0x00000000U, 0x2C4F1519U }, /* XSUM_XXH32_testdata[7420] */
    { 3710, 0x9E3779B1U, 0x94413DBFU }, /* XSUM_XXH32_testdata[7421] */
    { 3711, 0x00000000U, 0x7B951D8AU }, /* XSUM_XXH32_testdata[7422] */
    { 3711, 0x9E3779B1U, 0x7A753A37U }, /* XSUM_XXH32_testdata[7423] */
    { 3712, 0x00000000U, 0x94551EA8U }, /* XSUM_XXH32_testdata[7424] */
    { 3712, 0x9E3779B1U, 0xC355F747U }, /* XSUM_XXH32_testdata[7425] */
    { 3713, 0x00000000U, 0x7CC26887U }, /* XSUM_XXH32_testdata[7426] */
    { 3713, 0x9E3779B1U, 0xDD12E48CU }, /* XSUM_XXH32_testdata[7427] */
    { 3714, 0x00000000U, 0x42DDCC2AU }, /* XSUM_XXH32_testdata[7428] */
    { 3714, 0x9E3779B1U, 0x1018E2A0U }, /* XSUM_XXH32_testdata[7429] */
    { 3715, 0x00000000U, 0xA9C63B4EU }, /* XSUM_XXH32_testdata[7430] */
    { 3715, 0x9E3779B1U, 0xC20D4B7BU }, /* XSUM_XXH32_testdata[7431] */
    { 3716, 0x00000000U, 0x2655A769U }, /* XSUM_XXH32_testdata[7432] */
    { 3716, 0x9E3779B1U, 0x76B93468U }, /* XSUM_XXH32_testdata[7433] */
    { 3717, 0x00000000U, 0x58CDE87FU }, /* XSUM_XXH32_testdata[7434] */
    { 3717, 0x9E3779B1U, 0x3C90FD52U }, /* XSUM_XXH32_testdata[7435] */
    { 3718, 0x00000000U, 0xCE78CC65U }, /* XSUM_XXH32_testdata[7436] */
    { 3718, 0x9E3779B1U, 0x06DA3AC6U }, /* XSUM_XXH32_testdata[7437] */
    { 3719, 0x00000000U, 0xD1AD787DU }, /* XSUM_XXH32_testdata[7438] */
    { 3719, 0x9E3779B1U, 0x86BD7E31U }, /* XSUM_XXH32_testdata[7439] */
    { 3720, 0x00000000U, 0xCE8A56A4U }, /* XSUM_XXH32_testdata[7440] */
    { 3720, 0x9E3779B1U, 0x76F383CBU }, /* XSUM_XXH32_testdata[7441] */
    { 3721, 0x00000000U, 0xDC59A031U }, /* XSUM_XXH32_testdata[7442] */
    { 3721, 0x9E3779B1U, 0x63EA3B1FU }, /* XSUM_XXH32_testdata[7443] */
    { 3722, 0x00000000U, 0xD4705B0BU }, /* XSUM_XXH32_testdata[7444] */
    { 3722, 0x9E3779B1U, 0x56FBC37BU }, /* XSUM_XXH32_testdata[7445] */
    { 3723, 0x00000000U, 0xE62BD3C4U }, /* XSUM_XXH32_testdata[7446] */
    { 3723, 0x9E3779B1U, 0x0B23AB6FU }, /* XSUM_XXH32_testdata[7447] */
    { 3724, 0x00000000U, 0xE40798AEU }, /* XSUM_XXH32_testdata[7448] */
    { 3724, 0x9E3779B1U, 0xEC2AC096U }, /* XSUM_XXH32_testdata[7449] */
    { 3725, 0x00000000U, 0xC3396E38U }, /* XSUM_XXH32_testdata[7450] */
    { 3725, 0x9E3779B1U, 0x983FAF13U }, /* XSUM_XXH32_testdata[7451] */
    { 3726, 0x00000000U, 0x987997A1U }, /* XSUM_XXH32_testdata[7452] */
    { 3726, 0x9E3779B1U, 0x9DC3BBBCU }, /* XSUM_XXH32_testdata[7453] */
    { 3727, 0x00000000U, 0xE340542AU }, /* XSUM_XXH32_testdata[7454] */
    { 3727, 0x9E3779B1U, 0xBF89855AU }, /* XSUM_XXH32_testdata[7455] */
    { 3728, 0x00000000U, 0xCF6DD7D7U }, /* XSUM_XXH32_testdata[7456] */
    { 3728, 0x9E3779B1U, 0x320DCDC9U }, /* XSUM_XXH32_testdata[7457] */
    { 3729, 0x00000000U, 0x1D4EC2D6U }, /* XSUM_XXH32_testdata[7458] */
    { 3729, 0x9E3779B1U, 0x4858512FU }, /* XSUM_XXH32_testdata[7459] */
    { 3730, 0x00000000U, 0xB1C37596U }, /* XSUM_XXH32_testdata[7460] */
    { 3730, 0x9E3779B1U, 0x510EC4C0U }, /* XSUM_XXH32_testdata[7461] */
    { 3731, 0x00000000U, 0xF1148C52U }, /* XSUM_XXH32_testdata[7462] */
    { 3731, 0x9E3779B1U, 0x6C7F9A14U }, /* XSUM_XXH32_testdata[7463] */
    { 3732, 0x00000000U, 0x28583BAFU }, /* XSUM_XXH32_testdata[7464] */
    { 3732, 0x9E3779B1U, 0x7EEABB00U }, /* XSUM_XXH32_testdata[7465] */
    { 3733, 0x00000000U, 0xC21AD3E6U }, /* XSUM_XXH32_testdata[7466] */
    { 3733, 0x9E3779B1U, 0x30102CDDU }, /* XSUM_XXH32_testdata[7467] */
    { 3734, 0x00000000U, 0xD2817B73U }, /* XSUM_XXH32_testdata[7468] */
    { 3734, 0x9E3779B1U, 0x5E22FAD0U }, /* XSUM_XXH32_testdata[7469] */
    { 3735, 0x00000000U, 0x8A649B6DU }, /* XSUM_XXH32_testdata[7470] */
    { 3735, 0x9E3779B1U, 0xD78309FDU }, /* XSUM_XXH32_testdata[7471] */
    { 3736, 0x00000000U, 0xC45E2BFAU }, /* XSUM_XXH32_testdata[7472] */
    { 3736, 0x9E3779B1U, 0xBF3DE1C6U }, /* XSUM_XXH32_testdata[7473] */
    { 3737, 0x00000000U, 0x69636B85U }, /* XSUM_XXH32_testdata[7474] */
    { 3737, 0x9E3779B1U, 0x5D086E83U }, /* XSUM_XXH32_testdata[7475] */
    { 3738, 0x00000000U, 0x27896AF6U }, /* XSUM_XXH32_testdata[7476] */
    { 3738, 0x9E3779B1U, 0xDC7033BEU }, /* XSUM_XXH32_testdata[7477] */
    { 3739, 0x00000000U, 0xC06DD178U }, /* XSUM_XXH32_testdata[7478] */
    { 3739, 0x9E3779B1U, 0x3293F1A1U }, /* XSUM_XXH32_testdata[7479] */
    { 3740, 0x00000000U, 0x582BFEF5U }, /* XSUM_XXH32_testdata[7480] */
    { 3740, 0x9E3779B1U, 0xA3943411U }, /* XSUM_XXH32_testdata[7481] */
    { 3741, 0x00000000U, 0x9AA2E420U }, /* XSUM_XXH32_testdata[7482] */
    { 3741, 0x9E3779B1U, 0x57C2A2BBU }, /* XSUM_XXH32_testdata[7483] */
    { 3742, 0x00000000U, 0xF3A7CAABU }, /* XSUM_XXH32_testdata[7484] */
    { 3742, 0x9E3779B1U, 0x282ECF0CU }, /* XSUM_XXH32_testdata[7485] */
    { 3743, 0x00000000U, 0x1EAB3669U }, /* XSUM_XXH32_testdata[7486] */
    { 3743, 0x9E3779B1U, 0xF735DC31U }, /* XSUM_XXH32_testdata[7487] */
    { 3744, 0x00000000U, 0x0F98E12BU }, /* XSUM_XXH32_testdata[7488] */
    { 3744, 0x9E3779B1U, 0xDDB74BD3U }, /* XSUM_XXH32_testdata[7489] */
    { 3745, 0x00000000U, 0x2A215D59U }, /* XSUM_XXH32_testdata[7490] */
    { 3745, 0x9E3779B1U, 0x1009D718U }, /* XSUM_XXH32_testdata[7491] */
    { 3746, 0x00000000U, 0xD2BCF5A7U }, /* XSUM_XXH32_testdata[7492] */
    { 3746, 0x9E3779B1U, 0x7CD00940U }, /* XSUM_XXH32_testdata[7493] */
    { 3747, 0x00000000U, 0x6ACD349DU }, /* XSUM_XXH32_testdata[7494] */
    { 3747, 0x9E3779B1U, 0x0E293019U }, /* XSUM_XXH32_testdata[7495] */
    { 3748, 0x00000000U, 0x7FCC22EDU }, /* XSUM_XXH32_testdata[7496] */
    { 3748, 0x9E3779B1U, 0xBE7BF9D8U }, /* XSUM_XXH32_testdata[7497] */
    { 3749, 0x00000000U, 0xDE21C74CU }, /* XSUM_XXH32_testdata[7498] */
    { 3749, 0x9E3779B1U, 0xC41A1848U }, /* XSUM_XXH32_testdata[7499] */
    { 3750, 0x00000000U, 0x4721843AU }, /* XSUM_XXH32_testdata[7500] */
    { 3750, 0x9E3779B1U, 0x2001D2FFU }, /* XSUM_XXH32_testdata[7501] */
    { 3751, 0x00000000U, 0x72F4FA40U }, /* XSUM_XXH32_testdata[7502] */
    { 3751, 0x9E3779B1U, 0xEBC00440U }, /* XSUM_XXH32_testdata[7503] */
    { 3752, 0x00000000U, 0x36E7C784U }, /* XSUM_XXH32_testdata[7504] */
    { 3752, 0x9E3779B1U, 0x6D483275U }, /* XSUM_XXH32_testdata[7505] */
    { 3753, 0x00000000U, 0x0066FD36U }, /* XSUM_XXH32_testdata[7506] */
    { 3753, 0x9E3779B1U, 0x88F76FBCU }, /* XSUM_XXH32_testdata[7507] */
    { 3754, 0x00000000U, 0x8518918BU }, /* XSUM_XXH32_testdata[7508] */
    { 3754, 0x9E3779B1U, 0x186D0EC1U }, /* XSUM_XXH32_testdata[7509] */
    { 3755, 0x00000000U, 0x0DA7E4B3U }, /* XSUM_XXH32_testdata[7510] */
    { 3755, 0x9E3779B1U, 0xF003D842U }, /* XSUM_XXH32_testdata[7511] */
    { 3756, 0x00000000U, 0x4A2A9BACU }, /* XSUM_XXH32_testdata[7512] */
    { 3756, 0x9E3779B1U, 0x014FE30AU }, /* XSUM_XXH32_testdata[7513] */
    { 3757, 0x00000000U, 0xC8C74DADU }, /* XSUM_XXH32_testdata[7514] */
    { 3757, 0x9E3779B1U, 0x3B03D198U }, /* XSUM_XXH32_testdata[7515] */
    { 3758, 0x00000000U, 0x85394D70U }, /* XSUM_XXH32_testdata[7516] */
    { 3758, 0x9E3779B1U, 0x79633D94U }, /* XSUM_XXH32_testdata[7517] */
    { 3759, 0x00000000U, 0xA9AFA1F8U }, /* XSUM_XXH32_testdata[7518] */
    { 3759, 0x9E3779B1U, 0x0C1AD4B0U }, /* XSUM_XXH32_testdata[7519] */
    { 3760, 0x00000000U, 0x3FDBC6FCU }, /* XSUM_XXH32_testdata[7520] */
    { 3760, 0x9E3779B1U, 0x7CE81D25U }, /* XSUM_XXH32_testdata[7521] */
    { 3761, 0x00000000U, 0xAFB9F7D6U }, /* XSUM_XXH32_testdata[7522] */
    { 3761, 0x9E3779B1U, 0xBF8B8874U }, /* XSUM_XXH32_testdata[7523] */
    { 3762, 0x00000000U, 0xC6FDAD8EU }, /* XSUM_XXH32_testdata[7524] */
    { 3762, 0x9E3779B1U, 0x7893396FU }, /* XSUM_XXH32_testdata[7525] */
    { 3763, 0x00000000U, 0x01EDA010U }, /* XSUM_XXH32_testdata[7526] */
    { 3763, 0x9E3779B1U, 0xCA04CD1AU }, /* XSUM_XXH32_testdata[7527] */
    { 3764, 0x00000000U, 0xBA4019EAU }, /* XSUM_XXH32_testdata[7528] */
    { 3764, 0x9E3779B1U, 0x9A4E4382U }, /* XSUM_XXH32_testdata[7529] */
    { 3765, 0x00000000U, 0xA38F0B87U }, /* XSUM_XXH32_testdata[7530] */
    { 3765, 0x9E3779B1U, 0xAC29BF75U }, /* XSUM_XXH32_testdata[7531] */
    { 3766, 0x00000000U, 0x781A7878U }, /* XSUM_XXH32_testdata[7532] */
    { 3766, 0x9E3779B1U, 0xE7BC06E5U }, /* XSUM_XXH32_testdata[7533] */
    { 3767, 0x00000000U, 0x625E85B7U }, /* XSUM_XXH32_testdata[7534] */
    { 3767, 0x9E3779B1U, 0xAF1024E5U }, /* XSUM_XXH32_testdata[7535] */
    { 3768, 0x00000000U, 0xDEB97F02U }, /* XSUM_XXH32_testdata[7536] */
    { 3768, 0x9E3779B1U, 0xA00DB23EU }, /* XSUM_XXH32_testdata[7537] */
    { 3769, 0x00000000U, 0x7A62CC22U }, /* XSUM_XXH32_testdata[7538] */
    { 3769, 0x9E3779B1U, 0x1F907841U }, /* XSUM_XXH32_testdata[7539] */
    { 3770, 0x00000000U, 0xE0BDD2E2U }, /* XSUM_XXH32_testdata[7540] */
    { 3770, 0x9E3779B1U, 0xE86684CAU }, /* XSUM_XXH32_testdata[7541] */
    { 3771, 0x00000000U, 0xAF4703E1U }, /* XSUM_XXH32_testdata[7542] */
    { 3771, 0x9E3779B1U, 0x9479705BU }, /* XSUM_XXH32_testdata[7543] */
    { 3772, 0x00000000U, 0xB1BAD969U }, /* XSUM_XXH32_testdata[7544] */
    { 3772, 0x9E3779B1U, 0x385EE455U }, /* XSUM_XXH32_testdata[7545] */
    { 3773, 0x00000000U, 0x259496C2U }, /* XSUM_XXH32_testdata[7546] */
    { 3773, 0x9E3779B1U, 0x40506A4DU }, /* XSUM_XXH32_testdata[7547] */
    { 3774, 0x00000000U, 0xC617BBDBU }, /* XSUM_XXH32_testdata[7548] */
    { 3774, 0x9E3779B1U, 0xC3DA4B56U }, /* XSUM_XXH32_testdata[7549] */
    { 3775, 0x00000000U, 0x16887332U }, /* XSUM_XXH32_testdata[7550] */
    { 3775, 0x9E3779B1U, 0xC76DD0CAU }, /* XSUM_XXH32_testdata[7551] */
    { 3776, 0x00000000U, 0x4042E3EAU }, /* XSUM_XXH32_testdata[7552] */
    { 3776, 0x9E3779B1U, 0x0B214C11U }, /* XSUM_XXH32_testdata[7553] */
    { 3777, 0x00000000U, 0x2B97F997U }, /* XSUM_XXH32_testdata[7554] */
    { 3777, 0x9E3779B1U, 0x7830BAECU }, /* XSUM_XXH32_testdata[7555] */
    { 3778, 0x00000000U, 0x9CD1ECA8U }, /* XSUM_XXH32_testdata[7556] */
    { 3778, 0x9E3779B1U, 0x2A17A4A8U }, /* XSUM_XXH32_testdata[7557] */
    { 3779, 0x00000000U, 0x7A679A14U }, /* XSUM_XXH32_testdata[7558] */
    { 3779, 0x9E3779B1U, 0xC2C58E4CU }, /* XSUM_XXH32_testdata[7559] */
    { 3780, 0x00000000U, 0xDBE9D278U }, /* XSUM_XXH32_testdata[7560] */
    { 3780, 0x9E3779B1U, 0xDD4BBC34U }, /* XSUM_XXH32_testdata[7561] */
    { 3781, 0x00000000U, 0x671FAA61U }, /* XSUM_XXH32_testdata[7562] */
    { 3781, 0x9E3779B1U, 0x8740D41EU }, /* XSUM_XXH32_testdata[7563] */
    { 3782, 0x00000000U, 0xF6B28D11U }, /* XSUM_XXH32_testdata[7564] */
    { 3782, 0x9E3779B1U, 0x5A6708FBU }, /* XSUM_XXH32_testdata[7565] */
    { 3783, 0x00000000U, 0xBB097B12U }, /* XSUM_XXH32_testdata[7566] */
    { 3783, 0x9E3779B1U, 0x2248392FU }, /* XSUM_XXH32_testdata[7567] */
    { 3784, 0x00000000U, 0x36755952U }, /* XSUM_XXH32_testdata[7568] */
    { 3784, 0x9E3779B1U, 0x8FFAE0DDU }, /* XSUM_XXH32_testdata[7569] */
    { 3785, 0x00000000U, 0x4DCBDF78U }, /* XSUM_XXH32_testdata[7570] */
    { 3785, 0x9E3779B1U, 0x3A50A1F1U }, /* XSUM_XXH32_testdata[7571] */
    { 3786, 0x00000000U, 0x3464AA46U }, /* XSUM_XXH32_testdata[7572] */
    { 3786, 0x9E3779B1U, 0x2BF1CB29U }, /* XSUM_XXH32_testdata[7573] */
    { 3787, 0x00000000U, 0x9D818D4BU }, /* XSUM_XXH32_testdata[7574] */
    { 3787, 0x9E3779B1U, 0x950296B4U }, /* XSUM_XXH32_testdata[7575] */
    { 3788, 0x00000000U, 0x5B5E0AEEU }, /* XSUM_XXH32_testdata[7576] */
    { 3788, 0x9E3779B1U, 0x5EE69D48U }, /* XSUM_XXH32_testdata[7577] */
    { 3789, 0x00000000U, 0x93107692U }, /* XSUM_XXH32_testdata[7578] */
    { 3789, 0x9E3779B1U, 0x3F119A9BU }, /* XSUM_XXH32_testdata[7579] */
    { 3790, 0x00000000U, 0xFB077236U }, /* XSUM_XXH32_testdata[7580] */
    { 3790, 0x9E3779B1U, 0x8F497AD8U }, /* XSUM_XXH32_testdata[7581] */
    { 3791, 0x00000000U, 0x073F52A2U }, /* XSUM_XXH32_testdata[7582] */
    { 3791, 0x9E3779B1U, 0x4CF022B4U }, /* XSUM_XXH32_testdata[7583] */
    { 3792, 0x00000000U, 0xB0AC0606U }, /* XSUM_XXH32_testdata[7584] */
    { 3792, 0x9E3779B1U, 0x57004481U }, /* XSUM_XXH32_testdata[7585] */
    { 3793, 0x00000000U, 0xCC986268U }, /* XSUM_XXH32_testdata[7586] */
    { 3793, 0x9E3779B1U, 0x7A84AE37U }, /* XSUM_XXH32_testdata[7587] */
    { 3794, 0x00000000U, 0xAF087FC8U }, /* XSUM_XXH32_testdata[7588] */
    { 3794, 0x9E3779B1U, 0x0D7BDB8CU }, /* XSUM_XXH32_testdata[7589] */
    { 3795, 0x00000000U, 0xA08FDF3FU }, /* XSUM_XXH32_testdata[7590] */
    { 3795, 0x9E3779B1U, 0xE5312F02U }, /* XSUM_XXH32_testdata[7591] */
    { 3796, 0x00000000U, 0xD158C24EU }, /* XSUM_XXH32_testdata[7592] */
    { 3796, 0x9E3779B1U, 0x1C34B816U }, /* XSUM_XXH32_testdata[7593] */
    { 3797, 0x00000000U, 0xD14A0C71U }, /* XSUM_XXH32_testdata[7594] */
    { 3797, 0x9E3779B1U, 0x98E2F625U }, /* XSUM_XXH32_testdata[7595] */
    { 3798, 0x00000000U, 0x0ED185A9U }, /* XSUM_XXH32_testdata[7596] */
    { 3798, 0x9E3779B1U, 0xD2B4209AU }, /* XSUM_XXH32_testdata[7597] */
    { 3799, 0x00000000U, 0x16B4D836U }, /* XSUM_XXH32_testdata[7598] */
    { 3799, 0x9E3779B1U, 0x6935896EU }, /* XSUM_XXH32_testdata[7599] */
    { 3800, 0x00000000U, 0xBD7F5CF3U }, /* XSUM_XXH32_testdata[7600] */
    { 3800, 0x9E3779B1U, 0x6BF1228DU }, /* XSUM_XXH32_testdata[7601] */
    { 3801, 0x00000000U, 0xA9D604E6U }, /* XSUM_XXH32_testdata[7602] */
    { 3801, 0x9E3779B1U, 0xB64EF668U }, /* XSUM_XXH32_testdata[7603] */
    { 3802, 0x00000000U, 0x566C56C5U }, /* XSUM_XXH32_testdata[7604] */
    { 3802, 0x9E3779B1U, 0xE65408A8U }, /* XSUM_XXH32_testdata[7605] */
    { 3803, 0x00000000U, 0x2261D4C1U }, /* XSUM_XXH32_testdata[7606] */
    { 3803, 0x9E3779B1U, 0xBE7B5254U }, /* XSUM_XXH32_testdata[7607] */
    { 3804, 0x00000000U, 0xC3A4C591U }, /* XSUM_XXH32_testdata[7608] */
    { 3804, 0x9E3779B1U, 0xABB60F26U }, /* XSUM_XXH32_testdata[7609] */
    { 3805, 0x00000000U, 0x0808A5BCU }, /* XSUM_XXH32_testdata[7610] */
    { 3805, 0x9E3779B1U, 0xDA62707BU }, /* XSUM_XXH32_testdata[7611] */
    { 3806, 0x00000000U, 0x6D063B6FU }, /* XSUM_XXH32_testdata[7612] */
    { 3806, 0x9E3779B1U, 0x9066E12FU }, /* XSUM_XXH32_testdata[7613] */
    { 3807, 0x00000000U, 0xA5AF8879U }, /* XSUM_XXH32_testdata[7614] */
    { 3807, 0x9E3779B1U, 0x6555225CU }, /* XSUM_XXH32_testdata[7615] */
    { 3808, 0x00000000U, 0xA57B153DU }, /* XSUM_XXH32_testdata[7616] */
    { 3808, 0x9E3779B1U, 0xF6C144DAU }, /* XSUM_XXH32_testdata[7617] */
    { 3809, 0x00000000U, 0xF11EA55CU }, /* XSUM_XXH32_testdata[7618] */
    { 3809, 0x9E3779B1U, 0x3B29FAF8U }, /* XSUM_XXH32_testdata[7619] */
    { 3810, 0x00000000U, 0x9B122E12U }, /* XSUM_XXH32_testdata[7620] */
    { 3810, 0x9E3779B1U, 0x9443C58AU }, /* XSUM_XXH32_testdata[7621] */
    { 3811, 0x00000000U, 0x7EAD437FU }, /* XSUM_XXH32_testdata[7622] */
    { 3811, 0x9E3779B1U, 0x8CE36F70U }, /* XSUM_XXH32_testdata[7623] */
    { 3812, 0x00000000U, 0x8C581351U }, /* XSUM_XXH32_testdata[7624] */
    { 3812, 0x9E3779B1U, 0xB0B57046U }, /* XSUM_XXH32_testdata[7625] */
    { 3813, 0x00000000U, 0xF805D1E0U }, /* XSUM_XXH32_testdata[7626] */
    { 3813, 0x9E3779B1U, 0x60660F61U }, /* XSUM_XXH32_testdata[7627] */
    { 3814, 0x00000000U, 0xFA3ABD3FU }, /* XSUM_XXH32_testdata[7628] */
    { 3814, 0x9E3779B1U, 0xD7010979U }, /* XSUM_XXH32_testdata[7629] */
    { 3815, 0x00000000U, 0x3E9877B7U }, /* XSUM_XXH32_testdata[7630] */
    { 3815, 0x9E3779B1U, 0xBB1A7C10U }, /* XSUM_XXH32_testdata[7631] */
    { 3816, 0x00000000U, 0xE97C2563U }, /* XSUM_XXH32_testdata[7632] */
    { 3816, 0x9E3779B1U, 0x3CF2051DU }, /* XSUM_XXH32_testdata[7633] */
    { 3817, 0x00000000U, 0x512A015BU }, /* XSUM_XXH32_testdata[7634] */
    { 3817, 0x9E3779B1U, 0x6396EE27U }, /* XSUM_XXH32_testdata[7635] */
    { 3818, 0x00000000U, 0x268308C0U }, /* XSUM_XXH32_testdata[7636] */
    { 3818, 0x9E3779B1U, 0x25CA8BF5U }, /* XSUM_XXH32_testdata[7637] */
    { 3819, 0x00000000U, 0xFA027E7FU }, /* XSUM_XXH32_testdata[7638] */
    { 3819, 0x9E3779B1U, 0x2178B807U }, /* XSUM_XXH32_testdata[7639] */
    { 3820, 0x00000000U, 0x1A694F3BU }, /* XSUM_XXH32_testdata[7640] */
    { 3820, 0x9E3779B1U, 0x5B528996U }, /* XSUM_XXH32_testdata[7641] */
    { 3821, 0x00000000U, 0xE0D67F72U }, /* XSUM_XXH32_testdata[7642] */
    { 3821, 0x9E3779B1U, 0x660ED706U }, /* XSUM_XXH32_testdata[7643] */
    { 3822, 0x00000000U, 0x25F7F4C1U }, /* XSUM_XXH32_testdata[7644] */
    { 3822, 0x9E3779B1U, 0x4D57BCC8U }, /* XSUM_XXH32_testdata[7645] */
    { 3823, 0x00000000U, 0x13CF3B49U }, /* XSUM_XXH32_testdata[7646] */
    { 3823, 0x9E3779B1U, 0xFB34077BU }, /* XSUM_XXH32_testdata[7647] */
    { 3824, 0x00000000U, 0x7C963D51U }, /* XSUM_XXH32_testdata[7648] */
    { 3824, 0x9E3779B1U, 0xC6EC5647U }, /* XSUM_XXH32_testdata[7649] */
    { 3825, 0x00000000U, 0x6F471912U }, /* XSUM_XXH32_testdata[7650] */
    { 3825, 0x9E3779B1U, 0x59897DA7U }, /* XSUM_XXH32_testdata[7651] */
    { 3826, 0x00000000U, 0xD89CE092U }, /* XSUM_XXH32_testdata[7652] */
    { 3826, 0x9E3779B1U, 0x3E629F91U }, /* XSUM_XXH32_testdata[7653] */
    { 3827, 0x00000000U, 0xDDFAFBAFU }, /* XSUM_XXH32_testdata[7654] */
    { 3827, 0x9E3779B1U, 0xF21FA718U }, /* XSUM_XXH32_testdata[7655] */
    { 3828, 0x00000000U, 0x26D168AEU }, /* XSUM_XXH32_testdata[7656] */
    { 3828, 0x9E3779B1U, 0xDF449306U }, /* XSUM_XXH32_testdata[7657] */
    { 3829, 0x00000000U, 0x8482205CU }, /* XSUM_XXH32_testdata[7658] */
    { 3829, 0x9E3779B1U, 0xD1CCF932U }, /* XSUM_XXH32_testdata[7659] */
    { 3830, 0x00000000U, 0xA386DD25U }, /* XSUM_XXH32_testdata[7660] */
    { 3830, 0x9E3779B1U, 0x4466D061U }, /* XSUM_XXH32_testdata[7661] */
    { 3831, 0x00000000U, 0x29149F44U }, /* XSUM_XXH32_testdata[7662] */
    { 3831, 0x9E3779B1U, 0xE1423FA6U }, /* XSUM_XXH32_testdata[7663] */
    { 3832, 0x00000000U, 0xCC7C6F70U }, /* XSUM_XXH32_testdata[7664] */
    { 3832, 0x9E3779B1U, 0x30CBCB2CU }, /* XSUM_XXH32_testdata[7665] */
    { 3833, 0x00000000U, 0x4A008AB4U }, /* XSUM_XXH32_testdata[7666] */
    { 3833, 0x9E3779B1U, 0xCDFB2F33U }, /* XSUM_XXH32_testdata[7667] */
    { 3834, 0x00000000U, 0x80B74D26U }, /* XSUM_XXH32_testdata[7668] */
    { 3834, 0x9E3779B1U, 0x5BB29910U }, /* XSUM_XXH32_testdata[7669] */
    { 3835, 0x00000000U, 0x4155EB27U }, /* XSUM_XXH32_testdata[7670] */
    { 3835, 0x9E3779B1U, 0xFFEFD30FU }, /* XSUM_XXH32_testdata[7671] */
    { 3836, 0x00000000U, 0xF3D0515CU }, /* XSUM_XXH32_testdata[7672] */
    { 3836, 0x9E3779B1U, 0x77030B2EU }, /* XSUM_XXH32_testdata[7673] */
    { 3837, 0x00000000U, 0x603D19D6U }, /* XSUM_XXH32_testdata[7674] */
    { 3837, 0x9E3779B1U, 0xCDE0AA3DU }, /* XSUM_XXH32_testdata[7675] */
    { 3838, 0x00000000U, 0x1E970D29U }, /* XSUM_XXH32_testdata[7676] */
    { 3838, 0x9E3779B1U, 0x72E45077U }, /* XSUM_XXH32_testdata[7677] */
    { 3839, 0x00000000U, 0x4A13FC3EU }, /* XSUM_XXH32_testdata[7678] */
    { 3839, 0x9E3779B1U, 0xA36D50B6U }, /* XSUM_XXH32_testdata[7679] */
    { 3840, 0x00000000U, 0x64D71DADU }, /* XSUM_XXH32_testdata[7680] */
    { 3840, 0x9E3779B1U, 0x6FAB21D5U }, /* XSUM_XXH32_testdata[7681] */
    { 3841, 0x00000000U, 0x83A03B00U }, /* XSUM_XXH32_testdata[7682] */
    { 3841, 0x9E3779B1U, 0xF97B1C8CU }, /* XSUM_XXH32_testdata[7683] */
    { 3842, 0x00000000U, 0x830B4696U }, /* XSUM_XXH32_testdata[7684] */
    { 3842, 0x9E3779B1U, 0xBC261080U }, /* XSUM_XXH32_testdata[7685] */
    { 3843, 0x00000000U, 0x43F48F8FU }, /* XSUM_XXH32_testdata[7686] */
    { 3843, 0x9E3779B1U, 0xC96C1B20U }, /* XSUM_XXH32_testdata[7687] */
    { 3844, 0x00000000U, 0xB2B8692AU }, /* XSUM_XXH32_testdata[7688] */
    { 3844, 0x9E3779B1U, 0xF84BCF24U }, /* XSUM_XXH32_testdata[7689] */
    { 3845, 0x00000000U, 0x75280EB8U }, /* XSUM_XXH32_testdata[7690] */
    { 3845, 0x9E3779B1U, 0xE8B4575EU }, /* XSUM_XXH32_testdata[7691] */
    { 3846, 0x00000000U, 0x6B463EF9U }, /* XSUM_XXH32_testdata[7692] */
    { 3846, 0x9E3779B1U, 0x1307B6EDU }, /* XSUM_XXH32_testdata[7693] */
    { 3847, 0x00000000U, 0x66EE509EU }, /* XSUM_XXH32_testdata[7694] */
    { 3847, 0x9E3779B1U, 0xDCF0B9CFU }, /* XSUM_XXH32_testdata[7695] */
    { 3848, 0x00000000U, 0x488C3A77U }, /* XSUM_XXH32_testdata[7696] */
    { 3848, 0x9E3779B1U, 0x8D622662U }, /* XSUM_XXH32_testdata[7697] */
    { 3849, 0x00000000U, 0xA370F7D5U }, /* XSUM_XXH32_testdata[7698] */
    { 3849, 0x9E3779B1U, 0xA4247CBCU }, /* XSUM_XXH32_testdata[7699] */
    { 3850, 0x00000000U, 0x14665E34U }, /* XSUM_XXH32_testdata[7700] */
    { 3850, 0x9E3779B1U, 0x5D5F50ADU }, /* XSUM_XXH32_testdata[7701] */
    { 3851, 0x00000000U, 0xF10DCC81U }, /* XSUM_XXH32_testdata[7702] */
    { 3851, 0x9E3779B1U, 0x291946B7U }, /* XSUM_XXH32_testdata[7703] */
    { 3852, 0x00000000U, 0x54BA6F1EU }, /* XSUM_XXH32_testdata[7704] */
    { 3852, 0x9E3779B1U, 0x51A1C613U }, /* XSUM_XXH32_testdata[7705] */
    { 3853, 0x00000000U, 0x67B561A9U }, /* XSUM_XXH32_testdata[7706] */
    { 3853, 0x9E3779B1U, 0xD13A6719U }, /* XSUM_XXH32_testdata[7707] */
    { 3854, 0x00000000U, 0x99279AD5U }, /* XSUM_XXH32_testdata[7708] */
    { 3854, 0x9E3779B1U, 0xD67F6BBBU }, /* XSUM_XXH32_testdata[7709] */
    { 3855, 0x00000000U, 0xCCCC7C11U }, /* XSUM_XXH32_testdata[7710] */
    { 3855, 0x9E3779B1U, 0x541B5801U }, /* XSUM_XXH32_testdata[7711] */
    { 3856, 0x00000000U, 0x59FF8418U }, /* XSUM_XXH32_testdata[7712] */
    { 3856, 0x9E3779B1U, 0xFE5C4262U }, /* XSUM_XXH32_testdata[7713] */
    { 3857, 0x00000000U, 0x24A5A1F1U }, /* XSUM_XXH32_testdata[7714] */
    { 3857, 0x9E3779B1U, 0x3ED6437EU }, /* XSUM_XXH32_testdata[7715] */
    { 3858, 0x00000000U, 0xC835939BU }, /* XSUM_XXH32_testdata[7716] */
    { 3858, 0x9E3779B1U, 0x12D23740U }, /* XSUM_XXH32_testdata[7717] */
    { 3859, 0x00000000U, 0x9CBBF05FU }, /* XSUM_XXH32_testdata[7718] */
    { 3859, 0x9E3779B1U, 0xCA6961F0U }, /* XSUM_XXH32_testdata[7719] */
    { 3860, 0x00000000U, 0x47D3D358U }, /* XSUM_XXH32_testdata[7720] */
    { 3860, 0x9E3779B1U, 0x81C043AFU }, /* XSUM_XXH32_testdata[7721] */
    { 3861, 0x00000000U, 0xE6F8D009U }, /* XSUM_XXH32_testdata[7722] */
    { 3861, 0x9E3779B1U, 0x2DB9D6BBU }, /* XSUM_XXH32_testdata[7723] */
    { 3862, 0x00000000U, 0xEE9D8258U }, /* XSUM_XXH32_testdata[7724] */
    { 3862, 0x9E3779B1U, 0x0AD8BB66U }, /* XSUM_XXH32_testdata[7725] */
    { 3863, 0x00000000U, 0x17F39421U }, /* XSUM_XXH32_testdata[7726] */
    { 3863, 0x9E3779B1U, 0x76FBB713U }, /* XSUM_XXH32_testdata[7727] */
    { 3864, 0x00000000U, 0x7EB5E7ABU }, /* XSUM_XXH32_testdata[7728] */
    { 3864, 0x9E3779B1U, 0x09DAB747U }, /* XSUM_XXH32_testdata[7729] */
    { 3865, 0x00000000U, 0x6553C5DCU }, /* XSUM_XXH32_testdata[7730] */
    { 3865, 0x9E3779B1U, 0x86094D79U }, /* XSUM_XXH32_testdata[7731] */
    { 3866, 0x00000000U, 0x6F06720CU }, /* XSUM_XXH32_testdata[7732] */
    { 3866, 0x9E3779B1U, 0x6BE9B218U }, /* XSUM_XXH32_testdata[7733] */
    { 3867, 0x00000000U, 0x78D7B8B4U }, /* XSUM_XXH32_testdata[7734] */
    { 3867, 0x9E3779B1U, 0x699D3157U }, /* XSUM_XXH32_testdata[7735] */
    { 3868, 0x00000000U, 0xA32123A3U }, /* XSUM_XXH32_testdata[7736] */
    { 3868, 0x9E3779B1U, 0x5520DC8DU }, /* XSUM_XXH32_testdata[7737] */
    { 3869, 0x00000000U, 0x03A02F04U }, /* XSUM_XXH32_testdata[7738] */
    { 3869, 0x9E3779B1U, 0x9F1F35F4U }, /* XSUM_XXH32_testdata[7739] */
    { 3870, 0x00000000U, 0x2E556B27U }, /* XSUM_XXH32_testdata[7740] */
    { 3870, 0x9E3779B1U, 0xFB34034EU }, /* XSUM_XXH32_testdata[7741] */
    { 3871, 0x00000000U, 0x9BE507B0U }, /* XSUM_XXH32_testdata[7742] */
    { 3871, 0x9E3779B1U, 0x77D459E3U }, /* XSUM_XXH32_testdata[7743] */
    { 3872, 0x00000000U, 0xF8867EF6U }, /* XSUM_XXH32_testdata[7744] */
    { 3872, 0x9E3779B1U, 0xAAB8F729U }, /* XSUM_XXH32_testdata[7745] */
    { 3873, 0x00000000U, 0xB86F54E8U }, /* XSUM_XXH32_testdata[7746] */
    { 3873, 0x9E3779B1U, 0xADEA6037U }, /* XSUM_XXH32_testdata[7747] */
    { 3874, 0x00000000U, 0xF0F47855U }, /* XSUM_XXH32_testdata[7748] */
    { 3874, 0x9E3779B1U, 0xAD8A0372U }, /* XSUM_XXH32_testdata[7749] */
    { 3875, 0x00000000U, 0x4BFE45F6U }, /* XSUM_XXH32_testdata[7750] */
    { 3875, 0x9E3779B1U, 0xE9A92812U }, /* XSUM_XXH32_testdata[7751] */
    { 3876, 0x00000000U, 0x85664BBDU }, /* XSUM_XXH32_testdata[7752] */
    { 3876, 0x9E3779B1U, 0x475BCD1CU }, /* XSUM_XXH32_testdata[7753] */
    { 3877, 0x00000000U, 0x08B6213CU }, /* XSUM_XXH32_testdata[7754] */
    { 3877, 0x9E3779B1U, 0x1C8A380BU }, /* XSUM_XXH32_testdata[7755] */
    { 3878, 0x00000000U, 0xFC13434DU }, /* XSUM_XXH32_testdata[7756] */
    { 3878, 0x9E3779B1U, 0x50D6DEC6U }, /* XSUM_XXH32_testdata[7757] */
    { 3879, 0x00000000U, 0xAF9F3EF2U }, /* XSUM_XXH32_testdata[7758] */
    { 3879, 0x9E3779B1U, 0xAA199D3FU }, /* XSUM_XXH32_testdata[7759] */
    { 3880, 0x00000000U, 0x0FB75606U }, /* XSUM_XXH32_testdata[7760] */
    { 3880, 0x9E3779B1U, 0xFF0F8F02U }, /* XSUM_XXH32_testdata[7761] */
    { 3881, 0x00000000U, 0x7895EC0AU }, /* XSUM_XXH32_testdata[7762] */
    { 3881, 0x9E3779B1U, 0x7E7178EDU }, /* XSUM_XXH32_testdata[7763] */
    { 3882, 0x00000000U, 0xE5093ED9U }, /* XSUM_XXH32_testdata[7764] */
    { 3882, 0x9E3779B1U, 0x79C61301U }, /* XSUM_XXH32_testdata[7765] */
    { 3883, 0x00000000U, 0x3E9FF4E9U }, /* XSUM_XXH32_testdata[7766] */
    { 3883, 0x9E3779B1U, 0x4812F2BAU }, /* XSUM_XXH32_testdata[7767] */
    { 3884, 0x00000000U, 0xC5D7B46BU }, /* XSUM_XXH32_testdata[7768] */
    { 3884, 0x9E3779B1U, 0x1FD4AEA0U }, /* XSUM_XXH32_testdata[7769] */
    { 3885, 0x00000000U, 0xACCFF8B2U }, /* XSUM_XXH32_testdata[7770] */
    { 3885, 0x9E3779B1U, 0xB0D6E70DU }, /* XSUM_XXH32_testdata[7771] */
    { 3886, 0x00000000U, 0xD883BCFEU }, /* XSUM_XXH32_testdata[7772] */
    { 3886, 0x9E3779B1U, 0x8B5A2BA1U }, /* XSUM_XXH32_testdata[7773] */
    { 3887, 0x00000000U, 0x2D8E54D0U }, /* XSUM_XXH32_testdata[7774] */
    { 3887, 0x9E3779B1U, 0x9C204837U }, /* XSUM_XXH32_testdata[7775] */
    { 3888, 0x00000000U, 0x83CD7601U }, /* XSUM_XXH32_testdata[7776] */
    { 3888, 0x9E3779B1U, 0x15F8C4A8U }, /* XSUM_XXH32_testdata[7777] */
    { 3889, 0x00000000U, 0xCE768A19U }, /* XSUM_XXH32_testdata[7778] */
    { 3889, 0x9E3779B1U, 0xE06D4D94U }, /* XSUM_XXH32_testdata[7779] */
    { 3890, 0x00000000U, 0xD90533A1U }, /* XSUM_XXH32_testdata[7780] */
    { 3890, 0x9E3779B1U, 0x56FD9684U }, /* XSUM_XXH32_testdata[7781] */
    { 3891, 0x00000000U, 0xEC927BDDU }, /* XSUM_XXH32_testdata[7782] */
    { 3891, 0x9E3779B1U, 0xAA9D091FU }, /* XSUM_XXH32_testdata[7783] */
    { 3892, 0x00000000U, 0x1E6EF7E6U }, /* XSUM_XXH32_testdata[7784] */
    { 3892, 0x9E3779B1U, 0x7565B2A7U }, /* XSUM_XXH32_testdata[7785] */
    { 3893, 0x00000000U, 0xD01A9944U }, /* XSUM_XXH32_testdata[7786] */
    { 3893, 0x9E3779B1U, 0x46811809U }, /* XSUM_XXH32_testdata[7787] */
    { 3894, 0x00000000U, 0x68D85B5CU }, /* XSUM_XXH32_testdata[7788] */
    { 3894, 0x9E3779B1U, 0x792D991FU }, /* XSUM_XXH32_testdata[7789] */
    { 3895, 0x00000000U, 0x7A269257U }, /* XSUM_XXH32_testdata[7790] */
    { 3895, 0x9E3779B1U, 0xEF7146FDU }, /* XSUM_XXH32_testdata[7791] */
    { 3896, 0x00000000U, 0x61AE98B1U }, /* XSUM_XXH32_testdata[7792] */
    { 3896, 0x9E3779B1U, 0xCD2B36A1U }, /* XSUM_XXH32_testdata[7793] */
    { 3897, 0x00000000U, 0x92ED305CU }, /* XSUM_XXH32_testdata[7794] */
    { 3897, 0x9E3779B1U, 0xD8ABAA0EU }, /* XSUM_XXH32_testdata[7795] */
    { 3898, 0x00000000U, 0x07C20D7CU }, /* XSUM_XXH32_testdata[7796] */
    { 3898, 0x9E3779B1U, 0xC1063B7FU }, /* XSUM_XXH32_testdata[7797] */
    { 3899, 0x00000000U, 0xDD9669A3U }, /* XSUM_XXH32_testdata[7798] */
    { 3899, 0x9E3779B1U, 0xA57E9460U }, /* XSUM_XXH32_testdata[7799] */
    { 3900, 0x00000000U, 0xBD5481DFU }, /* XSUM_XXH32_testdata[7800] */
    { 3900, 0x9E3779B1U, 0x87A60CCFU }, /* XSUM_XXH32_testdata[7801] */
    { 3901, 0x00000000U, 0x7FB1EEE6U }, /* XSUM_XXH32_testdata[7802] */
    { 3901, 0x9E3779B1U, 0x4F7549F0U }, /* XSUM_XXH32_testdata[7803] */
    { 3902, 0x00000000U, 0xCB8ED671U }, /* XSUM_XXH32_testdata[7804] */
    { 3902, 0x9E3779B1U, 0x2DE0C434U }, /* XSUM_XXH32_testdata[7805] */
    { 3903, 0x00000000U, 0x38873EFCU }, /* XSUM_XXH32_testdata[7806] */
    { 3903, 0x9E3779B1U, 0x447605A5U }, /* XSUM_XXH32_testdata[7807] */
    { 3904, 0x00000000U, 0x46A2EE4AU }, /* XSUM_XXH32_testdata[7808] */
    { 3904, 0x9E3779B1U, 0xA6D803FDU }, /* XSUM_XXH32_testdata[7809] */
    { 3905, 0x00000000U, 0x97E737CCU }, /* XSUM_XXH32_testdata[7810] */
    { 3905, 0x9E3779B1U, 0x894E7EE9U }, /* XSUM_XXH32_testdata[7811] */
    { 3906, 0x00000000U, 0x1713685FU }, /* XSUM_XXH32_testdata[7812] */
    { 3906, 0x9E3779B1U, 0xEC134F11U }, /* XSUM_XXH32_testdata[7813] */
    { 3907, 0x00000000U, 0x5DF44D5AU }, /* XSUM_XXH32_testdata[7814] */
    { 3907, 0x9E3779B1U, 0x25DEE6CBU }, /* XSUM_XXH32_testdata[7815] */
    { 3908, 0x00000000U, 0xB7A8E6E6U }, /* XSUM_XXH32_testdata[7816] */
    { 3908, 0x9E3779B1U, 0xAA650AD6U }, /* XSUM_XXH32_testdata[7817] */
    { 3909, 0x00000000U, 0xD63DF9F8U }, /* XSUM_XXH32_testdata[7818] */
    { 3909, 0x9E3779B1U, 0x266C114FU }, /* XSUM_XXH32_testdata[7819] */
    { 3910, 0x00000000U, 0xC710C6DEU }, /* XSUM_XXH32_testdata[7820] */
    { 3910, 0x9E3779B1U, 0x2A41CE4BU }, /* XSUM_XXH32_testdata[7821] */
    { 3911, 0x00000000U, 0x4BF1284FU }, /* XSUM_XXH32_testdata[7822] */
    { 3911, 0x9E3779B1U, 0x10E356B0U }, /* XSUM_XXH32_testdata[7823] */
    { 3912, 0x00000000U, 0x54348B47U }, /* XSUM_XXH32_testdata[7824] */
    { 3912, 0x9E3779B1U, 0xDBF14B37U }, /* XSUM_XXH32_testdata[7825] */
    { 3913, 0x00000000U, 0xDA2E2CADU }, /* XSUM_XXH32_testdata[7826] */
    { 3913, 0x9E3779B1U, 0xB4777FA0U }, /* XSUM_XXH32_testdata[7827] */
    { 3914, 0x00000000U, 0x4BCD511EU }, /* XSUM_XXH32_testdata[7828] */
    { 3914, 0x9E3779B1U, 0xEAA2A15AU }, /* XSUM_XXH32_testdata[7829] */
    { 3915, 0x00000000U, 0xC2D02485U }, /* XSUM_XXH32_testdata[7830] */
    { 3915, 0x9E3779B1U, 0x0F51CB6CU }, /* XSUM_XXH32_testdata[7831] */
    { 3916, 0x00000000U, 0xAD53BE44U }, /* XSUM_XXH32_testdata[7832] */
    { 3916, 0x9E3779B1U, 0xEB0D8BE7U }, /* XSUM_XXH32_testdata[7833] */
    { 3917, 0x00000000U, 0x8D170B53U }, /* XSUM_XXH32_testdata[7834] */
    { 3917, 0x9E3779B1U, 0xF5CDEE73U }, /* XSUM_XXH32_testdata[7835] */
    { 3918, 0x00000000U, 0x12B42C2BU }, /* XSUM_XXH32_testdata[7836] */
    { 3918, 0x9E3779B1U, 0xB844C9A8U }, /* XSUM_XXH32_testdata[7837] */
    { 3919, 0x00000000U, 0x94AE50ECU }, /* XSUM_XXH32_testdata[7838] */
    { 3919, 0x9E3779B1U, 0x7B615242U }, /* XSUM_XXH32_testdata[7839] */
    { 3920, 0x00000000U, 0x57849A04U }, /* XSUM_XXH32_testdata[7840] */
    { 3920, 0x9E3779B1U, 0x6D1542C2U }, /* XSUM_XXH32_testdata[7841] */
    { 3921, 0x00000000U, 0x96A96FD8U }, /* XSUM_XXH32_testdata[7842] */
    { 3921, 0x9E3779B1U, 0xE12C8EEFU }, /* XSUM_XXH32_testdata[7843] */
    { 3922, 0x00000000U, 0xF71871BEU }, /* XSUM_XXH32_testdata[7844] */
    { 3922, 0x9E3779B1U, 0x8F550F7BU }, /* XSUM_XXH32_testdata[7845] */
    { 3923, 0x00000000U, 0x515B05FFU }, /* XSUM_XXH32_testdata[7846] */
    { 3923, 0x9E3779B1U, 0x4232D861U }, /* XSUM_XXH32_testdata[7847] */
    { 3924, 0x00000000U, 0x62186A5FU }, /* XSUM_XXH32_testdata[7848] */
    { 3924, 0x9E3779B1U, 0x4BF60E1BU }, /* XSUM_XXH32_testdata[7849] */
    { 3925, 0x00000000U, 0x1C04CC6BU }, /* XSUM_XXH32_testdata[7850] */
    { 3925, 0x9E3779B1U, 0x8FC09811U }, /* XSUM_XXH32_testdata[7851] */
    { 3926, 0x00000000U, 0xB38B7CF9U }, /* XSUM_XXH32_testdata[7852] */
    { 3926, 0x9E3779B1U, 0x098EE93AU }, /* XSUM_XXH32_testdata[7853] */
    { 3927, 0x00000000U, 0x80BBC3AAU }, /* XSUM_XXH32_testdata[7854] */
    { 3927, 0x9E3779B1U, 0x477A7F6BU }, /* XSUM_XXH32_testdata[7855] */
    { 3928, 0x00000000U, 0xC01A0F3FU }, /* XSUM_XXH32_testdata[7856] */
    { 3928, 0x9E3779B1U, 0x129F6D8DU }, /* XSUM_XXH32_testdata[7857] */
    { 3929, 0x00000000U, 0x30349E91U }, /* XSUM_XXH32_testdata[7858] */
    { 3929, 0x9E3779B1U, 0xE38A368AU }, /* XSUM_XXH32_testdata[7859] */
    { 3930, 0x00000000U, 0xBAF0D68EU }, /* XSUM_XXH32_testdata[7860] */
    { 3930, 0x9E3779B1U, 0xEBD52E84U }, /* XSUM_XXH32_testdata[7861] */
    { 3931, 0x00000000U, 0x0E54AD93U }, /* XSUM_XXH32_testdata[7862] */
    { 3931, 0x9E3779B1U, 0x7771D682U }, /* XSUM_XXH32_testdata[7863] */
    { 3932, 0x00000000U, 0x70120C61U }, /* XSUM_XXH32_testdata[7864] */
    { 3932, 0x9E3779B1U, 0xF323E4D6U }, /* XSUM_XXH32_testdata[7865] */
    { 3933, 0x00000000U, 0x5A195A5CU }, /* XSUM_XXH32_testdata[7866] */
    { 3933, 0x9E3779B1U, 0x58A3D0A0U }, /* XSUM_XXH32_testdata[7867] */
    { 3934, 0x00000000U, 0xFD5D41A3U }, /* XSUM_XXH32_testdata[7868] */
    { 3934, 0x9E3779B1U, 0x74E5A0B1U }, /* XSUM_XXH32_testdata[7869] */
    { 3935, 0x00000000U, 0xB8A50FC6U }, /* XSUM_XXH32_testdata[7870] */
    { 3935, 0x9E3779B1U, 0xAF48DB2FU }, /* XSUM_XXH32_testdata[7871] */
    { 3936, 0x00000000U, 0xD2E8CD3AU }, /* XSUM_XXH32_testdata[7872] */
    { 3936, 0x9E3779B1U, 0x65B29308U }, /* XSUM_XXH32_testdata[7873] */
    { 3937, 0x00000000U, 0x15DD43EBU }, /* XSUM_XXH32_testdata[7874] */
    { 3937, 0x9E3779B1U, 0xB22163F3U }, /* XSUM_XXH32_testdata[7875] */
    { 3938, 0x00000000U, 0xE03CAE50U }, /* XSUM_XXH32_testdata[7876] */
    { 3938, 0x9E3779B1U, 0x0AF06A23U }, /* XSUM_XXH32_testdata[7877] */
    { 3939, 0x00000000U, 0xD9BDF54BU }, /* XSUM_XXH32_testdata[7878] */
    { 3939, 0x9E3779B1U, 0xC642397DU }, /* XSUM_XXH32_testdata[7879] */
    { 3940, 0x00000000U, 0x3D38D03DU }, /* XSUM_XXH32_testdata[7880] */
    { 3940, 0x9E3779B1U, 0x5FEEE2C6U }, /* XSUM_XXH32_testdata[7881] */
    { 3941, 0x00000000U, 0xE6E32787U }, /* XSUM_XXH32_testdata[7882] */
    { 3941, 0x9E3779B1U, 0xFFF4B40EU }, /* XSUM_XXH32_testdata[7883] */
    { 3942, 0x00000000U, 0x2F4D6A83U }, /* XSUM_XXH32_testdata[7884] */
    { 3942, 0x9E3779B1U, 0x784F3FDCU }, /* XSUM_XXH32_testdata[7885] */
    { 3943, 0x00000000U, 0x1861DBEAU }, /* XSUM_XXH32_testdata[7886] */
    { 3943, 0x9E3779B1U, 0xE65491B0U }, /* XSUM_XXH32_testdata[7887] */
    { 3944, 0x00000000U, 0xED77B61DU }, /* XSUM_XXH32_testdata[7888] */
    { 3944, 0x9E3779B1U, 0xDF5998F8U }, /* XSUM_XXH32_testdata[7889] */
    { 3945, 0x00000000U, 0x3DFEDD18U }, /* XSUM_XXH32_testdata[7890] */
    { 3945, 0x9E3779B1U, 0x98A63717U }, /* XSUM_XXH32_testdata[7891] */
    { 3946, 0x00000000U, 0xD30679BCU }, /* XSUM_XXH32_testdata[7892] */
    { 3946, 0x9E3779B1U, 0x47FFDD09U }, /* XSUM_XXH32_testdata[7893] */
    { 3947, 0x00000000U, 0xBBF4185CU }, /* XSUM_XXH32_testdata[7894] */
    { 3947, 0x9E3779B1U, 0x2A5BE174U }, /* XSUM_XXH32_testdata[7895] */
    { 3948, 0x00000000U, 0xBBF7C3ACU }, /* XSUM_XXH32_testdata[7896] */
    { 3948, 0x9E3779B1U, 0x739B0E6DU }, /* XSUM_XXH32_testdata[7897] */
    { 3949, 0x00000000U, 0xFDEF3CD4U }, /* XSUM_XXH32_testdata[7898] */
    { 3949, 0x9E3779B1U, 0xD7F204B5U }, /* XSUM_XXH32_testdata[7899] */
    { 3950, 0x00000000U, 0xD6077D53U }, /* XSUM_XXH32_testdata[7900] */
    { 3950, 0x9E3779B1U, 0xD71B24FCU }, /* XSUM_XXH32_testdata[7901] */
    { 3951, 0x00000000U, 0x02183811U }, /* XSUM_XXH32_testdata[7902] */
    { 3951, 0x9E3779B1U, 0x6EB8E187U }, /* XSUM_XXH32_testdata[7903] */
    { 3952, 0x00000000U, 0x91A2A9D7U }, /* XSUM_XXH32_testdata[7904] */
    { 3952, 0x9E3779B1U, 0xAEB507EBU }, /* XSUM_XXH32_testdata[7905] */
    { 3953, 0x00000000U, 0x009FD0ABU }, /* XSUM_XXH32_testdata[7906] */
    { 3953, 0x9E3779B1U, 0x379C3117U }, /* XSUM_XXH32_testdata[7907] */
    { 3954, 0x00000000U, 0xF43CF27BU }, /* XSUM_XXH32_testdata[7908] */
    { 3954, 0x9E3779B1U, 0x041CED72U }, /* XSUM_XXH32_testdata[7909] */
    { 3955, 0x00000000U, 0xB8E4417DU }, /* XSUM_XXH32_testdata[7910] */
    { 3955, 0x9E3779B1U, 0x2D607114U }, /* XSUM_XXH32_testdata[7911] */
    { 3956, 0x00000000U, 0xED6BB1E7U }, /* XSUM_XXH32_testdata[7912] */
    { 3956, 0x9E3779B1U, 0xBC5E1C33U }, /* XSUM_XXH32_testdata[7913] */
    { 3957, 0x00000000U, 0xA5DBB09CU }, /* XSUM_XXH32_testdata[7914] */
    { 3957, 0x9E3779B1U, 0x5D23CCD5U }, /* XSUM_XXH32_testdata[7915] */
    { 3958, 0x00000000U, 0x546EB3A1U }, /* XSUM_XXH32_testdata[7916] */
    { 3958, 0x9E3779B1U, 0x996CC849U }, /* XSUM_XXH32_testdata[7917] */
    { 3959, 0x00000000U, 0x129F18C6U }, /* XSUM_XXH32_testdata[7918] */
    { 3959, 0x9E3779B1U, 0x0C81A2F7U }, /* XSUM_XXH32_testdata[7919] */
    { 3960, 0x00000000U, 0x4C9C18FCU }, /* XSUM_XXH32_testdata[7920] */
    { 3960, 0x9E3779B1U, 0x93EC97C6U }, /* XSUM_XXH32_testdata[7921] */
    { 3961, 0x00000000U, 0xB130E577U }, /* XSUM_XXH32_testdata[7922] */
    { 3961, 0x9E3779B1U, 0x8399678EU }, /* XSUM_XXH32_testdata[7923] */
    { 3962, 0x00000000U, 0x16815988U }, /* XSUM_XXH32_testdata[7924] */
    { 3962, 0x9E3779B1U, 0x37CEA8F9U }, /* XSUM_XXH32_testdata[7925] */
    { 3963, 0x00000000U, 0x5F727B8BU }, /* XSUM_XXH32_testdata[7926] */
    { 3963, 0x9E3779B1U, 0x94EF49EBU }, /* XSUM_XXH32_testdata[7927] */
    { 3964, 0x00000000U, 0x005FE263U }, /* XSUM_XXH32_testdata[7928] */
    { 3964, 0x9E3779B1U, 0x3509DBD5U }, /* XSUM_XXH32_testdata[7929] */
    { 3965, 0x00000000U, 0xFA8A772DU }, /* XSUM_XXH32_testdata[7930] */
    { 3965, 0x9E3779B1U, 0x374BF0C0U }, /* XSUM_XXH32_testdata[7931] */
    { 3966, 0x00000000U, 0x340C8BD0U }, /* XSUM_XXH32_testdata[7932] */
    { 3966, 0x9E3779B1U, 0x8809F49EU }, /* XSUM_XXH32_testdata[7933] */
    { 3967, 0x00000000U, 0x8469698DU }, /* XSUM_XXH32_testdata[7934] */
    { 3967, 0x9E3779B1U, 0x2689C53EU }, /* XSUM_XXH32_testdata[7935] */
    { 3968, 0x00000000U, 0x4AA457D5U }, /* XSUM_XXH32_testdata[7936] */
    { 3968, 0x9E3779B1U, 0x7D34F283U }, /* XSUM_XXH32_testdata[7937] */
    { 3969, 0x00000000U, 0xBC3DD886U }, /* XSUM_XXH32_testdata[7938] */
    { 3969, 0x9E3779B1U, 0xE76AF62EU }, /* XSUM_XXH32_testdata[7939] */
    { 3970, 0x00000000U, 0xDEF74F9FU }, /* XSUM_XXH32_testdata[7940] */
    { 3970, 0x9E3779B1U, 0xF1CCA937U }, /* XSUM_XXH32_testdata[7941] */
    { 3971, 0x00000000U, 0xA06416ADU }, /* XSUM_XXH32_testdata[7942] */
    { 3971, 0x9E3779B1U, 0x8E5F9379U }, /* XSUM_XXH32_testdata[7943] */
    { 3972, 0x00000000U, 0xF56A5888U }, /* XSUM_XXH32_testdata[7944] */
    { 3972, 0x9E3779B1U, 0x4FC281A3U }, /* XSUM_XXH32_testdata[7945] */
    { 3973, 0x00000000U, 0x9A4D2068U }, /* XSUM_XXH32_testdata[7946] */
    { 3973, 0x9E3779B1U, 0x757745DDU }, /* XSUM_XXH32_testdata[7947] */
    { 3974, 0x00000000U, 0x349B228AU }, /* XSUM_XXH32_testdata[7948] */
    { 3974, 0x9E3779B1U, 0x4051D17AU }, /* XSUM_XXH32_testdata[7949] */
    { 3975, 0x00000000U, 0x82E47D9BU }, /* XSUM_XXH32_testdata[7950] */
    { 3975, 0x9E3779B1U, 0x4E14B2E8U }, /* XSUM_XXH32_testdata[7951] */
    { 3976, 0x00000000U, 0x994667A4U }, /* XSUM_XXH32_testdata[7952] */
    { 3976, 0x9E3779B1U, 0x0D7851F9U }, /* XSUM_XXH32_testdata[7953] */
    { 3977, 0x00000000U, 0x469709EFU }, /* XSUM_XXH32_testdata[7954] */
    { 3977, 0x9E3779B1U, 0xB18B1384U }, /* XSUM_XXH32_testdata[7955] */
    { 3978, 0x00000000U, 0x8D55D7C5U }, /* XSUM_XXH32_testdata[7956] */
    { 3978, 0x9E3779B1U, 0xCE7564AEU }, /* XSUM_XXH32_testdata[7957] */
    { 3979, 0x00000000U, 0x159A2019U }, /* XSUM_XXH32_testdata[7958] */
    { 3979, 0x9E3779B1U, 0xBF610D39U }, /* XSUM_XXH32_testdata[7959] */
    { 3980, 0x00000000U, 0xF245B84DU }, /* XSUM_XXH32_testdata[7960] */
    { 3980, 0x9E3779B1U, 0xCBBC6035U }, /* XSUM_XXH32_testdata[7961] */
    { 3981, 0x00000000U, 0x0B7121F2U }, /* XSUM_XXH32_testdata[7962] */
    { 3981, 0x9E3779B1U, 0xEAB0A310U }, /* XSUM_XXH32_testdata[7963] */
    { 3982, 0x00000000U, 0xFBD15931U }, /* XSUM_XXH32_testdata[7964] */
    { 3982, 0x9E3779B1U, 0xDB262017U }, /* XSUM_XXH32_testdata[7965] */
    { 3983, 0x00000000U, 0x30CF793EU }, /* XSUM_XXH32_testdata[7966] */
    { 3983, 0x9E3779B1U, 0x1B7B6BB1U }, /* XSUM_XXH32_testdata[7967] */
    { 3984, 0x00000000U, 0x43672487U }, /* XSUM_XXH32_testdata[7968] */
    { 3984, 0x9E3779B1U, 0x9F640EBDU }, /* XSUM_XXH32_testdata[7969] */
    { 3985, 0x00000000U, 0x45177CD5U }, /* XSUM_XXH32_testdata[7970] */
    { 3985, 0x9E3779B1U, 0x5DE8E756U }, /* XSUM_XXH32_testdata[7971] */
    { 3986, 0x00000000U, 0xF894E893U }, /* XSUM_XXH32_testdata[7972] */
    { 3986, 0x9E3779B1U, 0xABC53110U }, /* XSUM_XXH32_testdata[7973] */
    { 3987, 0x00000000U, 0x279056D5U }, /* XSUM_XXH32_testdata[7974] */
    { 3987, 0x9E3779B1U, 0x749207ADU }, /* XSUM_XXH32_testdata[7975] */
    { 3988, 0x00000000U, 0x95BF77B3U }, /* XSUM_XXH32_testdata[7976] */
    { 3988, 0x9E3779B1U, 0xF627095EU }, /* XSUM_XXH32_testdata[7977] */
    { 3989, 0x00000000U, 0x24E19A4EU }, /* XSUM_XXH32_testdata[7978] */
    { 3989, 0x9E3779B1U, 0x83E75840U }, /* XSUM_XXH32_testdata[7979] */
    { 3990, 0x00000000U, 0x59D793D9U }, /* XSUM_XXH32_testdata[7980] */
    { 3990, 0x9E3779B1U, 0x17A72D02U }, /* XSUM_XXH32_testdata[7981] */
    { 3991, 0x00000000U, 0xBD090BCBU }, /* XSUM_XXH32_testdata[7982] */
    { 3991, 0x9E3779B1U, 0x939877B5U }, /* XSUM_XXH32_testdata[7983] */
    { 3992, 0x00000000U, 0x67E8E064U }, /* XSUM_XXH32_testdata[7984] */
    { 3992, 0x9E3779B1U, 0x6060328CU }, /* XSUM_XXH32_testdata[7985] */
    { 3993, 0x00000000U, 0x48D8FDAEU }, /* XSUM_XXH32_testdata[7986] */
    { 3993, 0x9E3779B1U, 0x7311B50CU }, /* XSUM_XXH32_testdata[7987] */
    { 3994, 0x00000000U, 0x1BE7A43EU }, /* XSUM_XXH32_testdata[7988] */
    { 3994, 0x9E3779B1U, 0xC3A4718BU }, /* XSUM_XXH32_testdata[7989] */
    { 3995, 0x00000000U, 0x4BF31EBEU }, /* XSUM_XXH32_testdata[7990] */
    { 3995, 0x9E3779B1U, 0xBD9BA34CU }, /* XSUM_XXH32_testdata[7991] */
    { 3996, 0x00000000U, 0x838F4913U }, /* XSUM_XXH32_testdata[7992] */
    { 3996, 0x9E3779B1U, 0x73E4E8D2U }, /* XSUM_XXH32_testdata[7993] */
    { 3997, 0x00000000U, 0x815D59F1U }, /* XSUM_XXH32_testdata[7994] */
    { 3997, 0x9E3779B1U, 0x77177E48U }, /* XSUM_XXH32_testdata[7995] */
    { 3998, 0x00000000U, 0xD6870B9CU }, /* XSUM_XXH32_testdata[7996] */
    { 3998, 0x9E3779B1U, 0x46C13DA0U }, /* XSUM_XXH32_testdata[7997] */
    { 3999, 0x00000000U, 0xB8303538U }, /* XSUM_XXH32_testdata[7998] */
    { 3999, 0x9E3779B1U, 0x90C2C4CEU }, /* XSUM_XXH32_testdata[7999] */
    { 4000, 0x00000000U, 0x27407F75U }, /* XSUM_XXH32_testdata[8000] */
    { 4000, 0x9E3779B1U, 0x9F60B3E1U }, /* XSUM_XXH32_testdata[8001] */
    { 4001, 0x00000000U, 0x8C75FC02U }, /* XSUM_XXH32_testdata[8002] */
    { 4001, 0x9E3779B1U, 0x075FE27BU }, /* XSUM_XXH32_testdata[8003] */
    { 4002, 0x00000000U, 0x668757FAU }, /* XSUM_XXH32_testdata[8004] */
    { 4002, 0x9E3779B1U, 0x9A5616C3U }, /* XSUM_XXH32_testdata[8005] */
    { 4003, 0x00000000U, 0x10D1AD83U }, /* XSUM_XXH32_testdata[8006] */
    { 4003, 0x9E3779B1U, 0x20A8D9BDU }, /* XSUM_XXH32_testdata[8007] */
    { 4004, 0x00000000U, 0xE31D6BD4U }, /* XSUM_XXH32_testdata[8008] */
    { 4004, 0x9E3779B1U, 0x4DE21981U }, /* XSUM_XXH32_testdata[8009] */
    { 4005, 0x00000000U, 0xC41F6246U }, /* XSUM_XXH32_testdata[8010] */
    { 4005, 0x9E3779B1U, 0x54D65F89U }, /* XSUM_XXH32_testdata[8011] */
    { 4006, 0x00000000U, 0xEEF158DDU }, /* XSUM_XXH32_testdata[8012] */
    { 4006, 0x9E3779B1U, 0x4CE9BE5CU }, /* XSUM_XXH32_testdata[8013] */
    { 4007, 0x00000000U, 0xAAB85330U }, /* XSUM_XXH32_testdata[8014] */
    { 4007, 0x9E3779B1U, 0xF35F8C3FU }, /* XSUM_XXH32_testdata[8015] */
    { 4008, 0x00000000U, 0x4B0AD61FU }, /* XSUM_XXH32_testdata[8016] */
    { 4008, 0x9E3779B1U, 0xCE41BE43U }, /* XSUM_XXH32_testdata[8017] */
    { 4009, 0x00000000U, 0xBD7AB7C8U }, /* XSUM_XXH32_testdata[8018] */
    { 4009, 0x9E3779B1U, 0x5F212BA3U }, /* XSUM_XXH32_testdata[8019] */
    { 4010, 0x00000000U, 0x7A529E7BU }, /* XSUM_XXH32_testdata[8020] */
    { 4010, 0x9E3779B1U, 0xE12B9138U }, /* XSUM_XXH32_testdata[8021] */
    { 4011, 0x00000000U, 0x3315EE74U }, /* XSUM_XXH32_testdata[8022] */
    { 4011, 0x9E3779B1U, 0x5509D419U }, /* XSUM_XXH32_testdata[8023] */
    { 4012, 0x00000000U, 0x5DF1D007U }, /* XSUM_XXH32_testdata[8024] */
    { 4012, 0x9E3779B1U, 0x5CE608C5U }, /* XSUM_XXH32_testdata[8025] */
    { 4013, 0x00000000U, 0x10D81114U }, /* XSUM_XXH32_testdata[8026] */
    { 4013, 0x9E3779B1U, 0x8D7E4E9AU }, /* XSUM_XXH32_testdata[8027] */
    { 4014, 0x00000000U, 0xE141A08CU }, /* XSUM_XXH32_testdata[8028] */
    { 4014, 0x9E3779B1U, 0xD3CD9162U }, /* XSUM_XXH32_testdata[8029] */
    { 4015, 0x00000000U, 0x785E18CEU }, /* XSUM_XXH32_testdata[8030] */
    { 4015, 0x9E3779B1U, 0x2B4422DEU }, /* XSUM_XXH32_testdata[8031] */
    { 4016, 0x00000000U, 0x74DD10AAU }, /* XSUM_XXH32_testdata[8032] */
    { 4016, 0x9E3779B1U, 0xB009AEB1U }, /* XSUM_XXH32_testdata[8033] */
    { 4017, 0x00000000U, 0xF52E9BA0U }, /* XSUM_XXH32_testdata[8034] */
    { 4017, 0x9E3779B1U, 0x5DFE3133U }, /* XSUM_XXH32_testdata[8035] */
    { 4018, 0x00000000U, 0x00D05915U }, /* XSUM_XXH32_testdata[8036] */
    { 4018, 0x9E3779B1U, 0x5A1BE64AU }, /* XSUM_XXH32_testdata[8037] */
    { 4019, 0x00000000U, 0x729F4B02U }, /* XSUM_XXH32_testdata[8038] */
    { 4019, 0x9E3779B1U, 0x34F450B5U }, /* XSUM_XXH32_testdata[8039] */
    { 4020, 0x00000000U, 0x355A8E3FU }, /* XSUM_XXH32_testdata[8040] */
    { 4020, 0x9E3779B1U, 0xFBCECC94U }, /* XSUM_XXH32_testdata[8041] */
    { 4021, 0x00000000U, 0x3BB86C47U }, /* XSUM_XXH32_testdata[8042] */
    { 4021, 0x9E3779B1U, 0x333F75E3U }, /* XSUM_XXH32_testdata[8043] */
    { 4022, 0x00000000U, 0x1858F728U }, /* XSUM_XXH32_testdata[8044] */
    { 4022, 0x9E3779B1U, 0x6CB1F916U }, /* XSUM_XXH32_testdata[8045] */
    { 4023, 0x00000000U, 0x94A2212CU }, /* XSUM_XXH32_testdata[8046] */
    { 4023, 0x9E3779B1U, 0x5E99258AU }, /* XSUM_XXH32_testdata[8047] */
    { 4024, 0x00000000U, 0xD01C1181U }, /* XSUM_XXH32_testdata[8048] */
    { 4024, 0x9E3779B1U, 0x9DAE3749U }, /* XSUM_XXH32_testdata[8049] */
    { 4025, 0x00000000U, 0x333E547CU }, /* XSUM_XXH32_testdata[8050] */
    { 4025, 0x9E3779B1U, 0x2BC8BF53U }, /* XSUM_XXH32_testdata[8051] */
    { 4026, 0x00000000U, 0xD4EB535CU }, /* XSUM_XXH32_testdata[8052] */
    { 4026, 0x9E3779B1U, 0xC8DEB70FU }, /* XSUM_XXH32_testdata[8053] */
    { 4027, 0x00000000U, 0x609CBC4CU }, /* XSUM_XXH32_testdata[8054] */
    { 4027, 0x9E3779B1U, 0x7C9D1E6AU }, /* XSUM_XXH32_testdata[8055] */
    { 4028, 0x00000000U, 0xEF78537DU }, /* XSUM_XXH32_testdata[8056] */
    { 4028, 0x9E3779B1U, 0xD8FDF2FCU }, /* XSUM_XXH32_testdata[8057] */
    { 4029, 0x00000000U, 0x2B6F86F1U }, /* XSUM_XXH32_testdata[8058] */
    { 4029, 0x9E3779B1U, 0x5B3AC784U }, /* XSUM_XXH32_testdata[8059] */
    { 4030, 0x00000000U, 0xB85A6678U }, /* XSUM_XXH32_testdata[8060] */
    { 4030, 0x9E3779B1U, 0xDDF004C4U }, /* XSUM_XXH32_testdata[8061] */
    { 4031, 0x00000000U, 0x6F14ADD5U }, /* XSUM_XXH32_testdata[8062] */
    { 4031, 0x9E3779B1U, 0x1459C82CU }, /* XSUM_XXH32_testdata[8063] */
    { 4032, 0x00000000U, 0x863FA53FU }, /* XSUM_XXH32_testdata[8064] */
    { 4032, 0x9E3779B1U, 0x95987777U }, /* XSUM_XXH32_testdata[8065] */
    { 4033, 0x00000000U, 0x46DE0517U }, /* XSUM_XXH32_testdata[8066] */
    { 4033, 0x9E3779B1U, 0x32074119U }, /* XSUM_XXH32_testdata[8067] */
    { 4034, 0x00000000U, 0xA5F02A8DU }, /* XSUM_XXH32_testdata[8068] */
    { 4034, 0x9E3779B1U, 0x89779F09U }, /* XSUM_XXH32_testdata[8069] */
    { 4035, 0x00000000U, 0xCC1ED34AU }, /* XSUM_XXH32_testdata[8070] */
    { 4035, 0x9E3779B1U, 0x8422F396U }, /* XSUM_XXH32_testdata[8071] */
    { 4036, 0x00000000U, 0xB7A415EBU }, /* XSUM_XXH32_testdata[8072] */
    { 4036, 0x9E3779B1U, 0x0C0FF63DU }, /* XSUM_XXH32_testdata[8073] */
    { 4037, 0x00000000U, 0x80B450EAU }, /* XSUM_XXH32_testdata[8074] */
    { 4037, 0x9E3779B1U, 0xD8AE13BCU }, /* XSUM_XXH32_testdata[8075] */
    { 4038, 0x00000000U, 0x122DEC1FU }, /* XSUM_XXH32_testdata[8076] */
    { 4038, 0x9E3779B1U, 0x9BA31287U }, /* XSUM_XXH32_testdata[8077] */
    { 4039, 0x00000000U, 0xC6C7FC76U }, /* XSUM_XXH32_testdata[8078] */
    { 4039, 0x9E3779B1U, 0xB9415F2AU }, /* XSUM_XXH32_testdata[8079] */
    { 4040, 0x00000000U, 0x84A802A6U }, /* XSUM_XXH32_testdata[8080] */
    { 4040, 0x9E3779B1U, 0x9C9EEC4EU }, /* XSUM_XXH32_testdata[8081] */
    { 4041, 0x00000000U, 0x2FED28BDU }, /* XSUM_XXH32_testdata[8082] */
    { 4041, 0x9E3779B1U, 0x864352F3U }, /* XSUM_XXH32_testdata[8083] */
    { 4042, 0x00000000U, 0x5CC559CEU }, /* XSUM_XXH32_testdata[8084] */
    { 4042, 0x9E3779B1U, 0x41FF23D3U }, /* XSUM_XXH32_testdata[8085] */
    { 4043, 0x00000000U, 0xAABE7A66U }, /* XSUM_XXH32_testdata[8086] */
    { 4043, 0x9E3779B1U, 0x3F907706U }, /* XSUM_XXH32_testdata[8087] */
    { 4044, 0x00000000U, 0x14EE8A88U }, /* XSUM_XXH32_testdata[8088] */
    { 4044, 0x9E3779B1U, 0x63CA9945U }, /* XSUM_XXH32_testdata[8089] */
    { 4045, 0x00000000U, 0xB87A99C1U }, /* XSUM_XXH32_testdata[8090] */
    { 4045, 0x9E3779B1U, 0xB81E7D82U }, /* XSUM_XXH32_testdata[8091] */
    { 4046, 0x00000000U, 0x5AB2D0F7U }, /* XSUM_XXH32_testdata[8092] */
    { 4046, 0x9E3779B1U, 0x7ECE396FU }, /* XSUM_XXH32_testdata[8093] */
    { 4047, 0x00000000U, 0x0EBE0F7FU }, /* XSUM_XXH32_testdata[8094] */
    { 4047, 0x9E3779B1U, 0x402F64D8U }, /* XSUM_XXH32_testdata[8095] */
    { 4048, 0x00000000U, 0xBDE1B276U }, /* XSUM_XXH32_testdata[8096] */
    { 4048, 0x9E3779B1U, 0xD5E7985EU }, /* XSUM_XXH32_testdata[8097] */
    { 4049, 0x00000000U, 0xA9015113U }, /* XSUM_XXH32_testdata[8098] */
    { 4049, 0x9E3779B1U, 0xDEAA02E7U }, /* XSUM_XXH32_testdata[8099] */
    { 4050, 0x00000000U, 0x9CA24240U }, /* XSUM_XXH32_testdata[8100] */
    { 4050, 0x9E3779B1U, 0xE91714A1U }, /* XSUM_XXH32_testdata[8101] */
    { 4051, 0x00000000U, 0x38CCE861U }, /* XSUM_XXH32_testdata[8102] */
    { 4051, 0x9E3779B1U, 0x6C4924E9U }, /* XSUM_XXH32_testdata[8103] */
    { 4052, 0x00000000U, 0x796669FAU }, /* XSUM_XXH32_testdata[8104] */
    { 4052, 0x9E3779B1U, 0xA0522CE8U }, /* XSUM_XXH32_testdata[8105] */
    { 4053, 0x00000000U, 0x7926AE74U }, /* XSUM_XXH32_testdata[8106] */
    { 4053, 0x9E3779B1U, 0xDC82F8C5U }, /* XSUM_XXH32_testdata[8107] */
    { 4054, 0x00000000U, 0xBEE9EA69U }, /* XSUM_XXH32_testdata[8108] */
    { 4054, 0x9E3779B1U, 0x6F804B98U }, /* XSUM_XXH32_testdata[8109] */
    { 4055, 0x00000000U, 0xA8274B12U }, /* XSUM_XXH32_testdata[8110] */
    { 4055, 0x9E3779B1U, 0xEC8F3D79U }, /* XSUM_XXH32_testdata[8111] */
    { 4056, 0x00000000U, 0xA348EED1U }, /* XSUM_XXH32_testdata[8112] */
    { 4056, 0x9E3779B1U, 0x2AFBA006U }, /* XSUM_XXH32_testdata[8113] */
    { 4057, 0x00000000U, 0xB7CE9F4FU }, /* XSUM_XXH32_testdata[8114] */
    { 4057, 0x9E3779B1U, 0x6FD0BA10U }, /* XSUM_XXH32_testdata[8115] */
    { 4058, 0x00000000U, 0x0D366AE5U }, /* XSUM_XXH32_testdata[8116] */
    { 4058, 0x9E3779B1U, 0x0D29F3C7U }, /* XSUM_XXH32_testdata[8117] */
    { 4059, 0x00000000U, 0x97351AF6U }, /* XSUM_XXH32_testdata[8118] */
    { 4059, 0x9E3779B1U, 0x540BC27EU }, /* XSUM_XXH32_testdata[8119] */
    { 4060, 0x00000000U, 0xF5ACE84CU }, /* XSUM_XXH32_testdata[8120] */
    { 4060, 0x9E3779B1U, 0x9ED58AF6U }, /* XSUM_XXH32_testdata[8121] */
    { 4061, 0x00000000U, 0x2F267ADEU }, /* XSUM_XXH32_testdata[8122] */
    { 4061, 0x9E3779B1U, 0x045F43FDU }, /* XSUM_XXH32_testdata[8123] */
    { 4062, 0x00000000U, 0xE515091BU }, /* XSUM_XXH32_testdata[8124] */
    { 4062, 0x9E3779B1U, 0xC026D971U }, /* XSUM_XXH32_testdata[8125] */
    { 4063, 0x00000000U, 0x68A4439CU }, /* XSUM_XXH32_testdata[8126] */
    { 4063, 0x9E3779B1U, 0x7422AA11U }, /* XSUM_XXH32_testdata[8127] */
    { 4064, 0x00000000U, 0x57AB14B9U }, /* XSUM_XXH32_testdata[8128] */
    { 4064, 0x9E3779B1U, 0xD6529D78U }, /* XSUM_XXH32_testdata[8129] */
    { 4065, 0x00000000U, 0x19F521CAU }, /* XSUM_XXH32_testdata[8130] */
    { 4065, 0x9E3779B1U, 0xDD745494U }, /* XSUM_XXH32_testdata[8131] */
    { 4066, 0x00000000U, 0xE41A92FDU }, /* XSUM_XXH32_testdata[8132] */
    { 4066, 0x9E3779B1U, 0xDA97A4C3U }, /* XSUM_XXH32_testdata[8133] */
    { 4067, 0x00000000U, 0xB6F50C6AU }, /* XSUM_XXH32_testdata[8134] */
    { 4067, 0x9E3779B1U, 0x87752A24U }, /* XSUM_XXH32_testdata[8135] */
    { 4068, 0x00000000U, 0x6A4E1762U }, /* XSUM_XXH32_testdata[8136] */
    { 4068, 0x9E3779B1U, 0x507C48A6U }, /* XSUM_XXH32_testdata[8137] */
    { 4069, 0x00000000U, 0xA31C6923U }, /* XSUM_XXH32_testdata[8138] */
    { 4069, 0x9E3779B1U, 0xFBFC01CBU }, /* XSUM_XXH32_testdata[8139] */
    { 4070, 0x00000000U, 0x57335D73U }, /* XSUM_XXH32_testdata[8140] */
    { 4070, 0x9E3779B1U, 0x1CA5241CU }, /* XSUM_XXH32_testdata[8141] */
    { 4071, 0x00000000U, 0xD984C0CDU }, /* XSUM_XXH32_testdata[8142] */
    { 4071, 0x9E3779B1U, 0xE9FDD332U }, /* XSUM_XXH32_testdata[8143] */
    { 4072, 0x00000000U, 0x2A66B234U }, /* XSUM_XXH32_testdata[8144] */
    { 4072, 0x9E3779B1U, 0x490249A8U }, /* XSUM_XXH32_testdata[8145] */
    { 4073, 0x00000000U, 0x37D2696AU }, /* XSUM_XXH32_testdata[8146] */
    { 4073, 0x9E3779B1U, 0x193E992AU }, /* XSUM_XXH32_testdata[8147] */
    { 4074, 0x00000000U, 0x50277800U }, /* XSUM_XXH32_testdata[8148] */
    { 4074, 0x9E3779B1U, 0x8B52B126U }, /* XSUM_XXH32_testdata[8149] */
    { 4075, 0x00000000U, 0x356B2944U }, /* XSUM_XXH32_testdata[8150] */
    { 4075, 0x9E3779B1U, 0x7C61D14AU }, /* XSUM_XXH32_testdata[8151] */
    { 4076, 0x00000000U, 0xDDA77E6FU }, /* XSUM_XXH32_testdata[8152] */
    { 4076, 0x9E3779B1U, 0xB7294E5DU }, /* XSUM_XXH32_testdata[8153] */
    { 4077, 0x00000000U, 0x7C52C919U }, /* XSUM_XXH32_testdata[8154] */
    { 4077, 0x9E3779B1U, 0xCC94BCCDU }, /* XSUM_XXH32_testdata[8155] */
    { 4078, 0x00000000U, 0xA76D48CEU }, /* XSUM_XXH32_testdata[8156] */
    { 4078, 0x9E3779B1U, 0x201A68B0U }, /* XSUM_XXH32_testdata[8157] */
    { 4079, 0x00000000U, 0x5A4DB117U }, /* XSUM_XXH32_testdata[8158] */
    { 4079, 0x9E3779B1U, 0x8B78046DU }, /* XSUM_XXH32_testdata[8159] */
    { 4080, 0x00000000U, 0x85A2345BU }, /* XSUM_XXH32_testdata[8160] */
    { 4080, 0x9E3779B1U, 0x45092E05U }, /* XSUM_XXH32_testdata[8161] */
    { 4081, 0x00000000U, 0x865AF0D2U }, /* XSUM_XXH32_testdata[8162] */
    { 4081, 0x9E3779B1U, 0xE61764D9U }, /* XSUM_XXH32_testdata[8163] */
    { 4082, 0x00000000U, 0x6ACB0408U }, /* XSUM_XXH32_testdata[8164] */
    { 4082, 0x9E3779B1U, 0x173D774BU }, /* XSUM_XXH32_testdata[8165] */
    { 4083, 0x00000000U, 0x31BC507AU }, /* XSUM_XXH32_testdata[8166] */
    { 4083, 0x9E3779B1U, 0x5E9CB759U }, /* XSUM_XXH32_testdata[8167] */
    { 4084, 0x00000000U, 0x73A3ADD3U }, /* XSUM_XXH32_testdata[8168] */
    { 4084, 0x9E3779B1U, 0x6B00AF58U }, /* XSUM_XXH32_testdata[8169] */
    { 4085, 0x00000000U, 0x8A21EEF2U }, /* XSUM_XXH32_testdata[8170] */
    { 4085, 0x9E3779B1U, 0x87E6D65FU }, /* XSUM_XXH32_testdata[8171] */
    { 4086, 0x00000000U, 0x5C9E19F3U }, /* XSUM_XXH32_testdata[8172] */
    { 4086, 0x9E3779B1U, 0x0841C9C4U }, /* XSUM_XXH32_testdata[8173] */
    { 4087, 0x00000000U, 0x3AF521C9U }, /* XSUM_XXH32_testdata[8174] */
    { 4087, 0x9E3779B1U, 0x156EE57EU }, /* XSUM_XXH32_testdata[8175] */
    { 4088, 0x00000000U, 0xBA4262C2U }, /* XSUM_XXH32_testdata[8176] */
    { 4088, 0x9E3779B1U, 0x8DF52DDBU }, /* XSUM_XXH32_testdata[8177] */
    { 4089, 0x00000000U, 0x47EEC3E1U }, /* XSUM_XXH32_testdata[8178] */
    { 4089, 0x9E3779B1U, 0x91AD069EU }, /* XSUM_XXH32_testdata[8179] */
    { 4090, 0x00000000U, 0x2ACC967DU }, /* XSUM_XXH32_testdata[8180] */
    { 4090, 0x9E3779B1U, 0x168F6AF1U }, /* XSUM_XXH32_testdata[8181] */
    { 4091, 0x00000000U, 0xFC796CBDU }, /* XSUM_XXH32_testdata[8182] */
    { 4091, 0x9E3779B1U, 0x23C45836U }, /* XSUM_XXH32_testdata[8183] */
    { 4092, 0x00000000U, 0xE43AD822U }, /* XSUM_XXH32_testdata[8184] */
    { 4092, 0x9E3779B1U, 0x86F738C3U }, /* XSUM_XXH32_testdata[8185] */
    { 4093, 0x00000000U, 0x36108F97U }, /* XSUM_XXH32_testdata[8186] */
    { 4093, 0x9E3779B1U, 0x73933287U }, /* XSUM_XXH32_testdata[8187] */
    { 4094, 0x00000000U, 0xDEA6DC51U }, /* XSUM_XXH32_testdata[8188] */
    { 4094, 0x9E3779B1U, 0x6453B5F7U }, /* XSUM_XXH32_testdata[8189] */
    { 4095, 0x00000000U, 0x26E3D566U }, /* XSUM_XXH32_testdata[8190] */
    { 4095, 0x9E3779B1U, 0xEC26C02CU }, /* XSUM_XXH32_testdata[8191] */
    { 4096, 0x00000000U, 0x20FC444FU }, /* XSUM_XXH32_testdata[8192] */
    { 4096, 0x9E3779B1U, 0x102AD417U }, /* XSUM_XXH32_testdata[8193] */
    { 4097, 0x00000000U, 0x4115D4E2U }, /* XSUM_XXH32_testdata[8194] */
    { 4097, 0x9E3779B1U, 0xD0552AEDU }, /* XSUM_XXH32_testdata[8195] */
    { 4098, 0x00000000U, 0x1E565A59U }, /* XSUM_XXH32_testdata[8196] */
    { 4098, 0x9E3779B1U, 0x3E708270U }, /* XSUM_XXH32_testdata[8197] */
    { 4099, 0x00000000U, 0x64E581B2U }, /* XSUM_XXH32_testdata[8198] */
    { 4099, 0x9E3779B1U, 0x9D961E05U }, /* XSUM_XXH32_testdata[8199] */
    { 4100, 0x00000000U, 0xB5468144U }, /* XSUM_XXH32_testdata[8200] */
    { 4100, 0x9E3779B1U, 0x16BAD555U }, /* XSUM_XXH32_testdata[8201] */
    { 4101, 0x00000000U, 0x591F0AE5U }, /* XSUM_XXH32_testdata[8202] */
    { 4101, 0x9E3779B1U, 0x11021719U }, /* XSUM_XXH32_testdata[8203] */
    { 4102, 0x00000000U, 0x370AB735U }, /* XSUM_XXH32_testdata[8204] */
    { 4102, 0x9E3779B1U, 0xF4458FFFU }, /* XSUM_XXH32_testdata[8205] */
    { 4103, 0x00000000U, 0x8C357473U }, /* XSUM_XXH32_testdata[8206] */
    { 4103, 0x9E3779B1U, 0x0AB98C5AU }, /* XSUM_XXH32_testdata[8207] */
    { 4104, 0x00000000U, 0x283E1806U }, /* XSUM_XXH32_testdata[8208] */
    { 4104, 0x9E3779B1U, 0xFE797FC0U }, /* XSUM_XXH32_testdata[8209] */
    { 4105, 0x00000000U, 0x1AF40E88U }, /* XSUM_XXH32_testdata[8210] */
    { 4105, 0x9E3779B1U, 0x3C68E643U }, /* XSUM_XXH32_testdata[8211] */
    { 4106, 0x00000000U, 0xF62C711BU }, /* XSUM_XXH32_testdata[8212] */
    { 4106, 0x9E3779B1U, 0xDE75FF88U }, /* XSUM_XXH32_testdata[8213] */
    { 4107, 0x00000000U, 0xF0717C1EU }, /* XSUM_XXH32_testdata[8214] */
    { 4107, 0x9E3779B1U, 0xC4B3B75AU }, /* XSUM_XXH32_testdata[8215] */
    { 4108, 0x00000000U, 0x28D9C58CU }, /* XSUM_XXH32_testdata[8216] */
    { 4108, 0x9E3779B1U, 0xC7989E18U }, /* XSUM_XXH32_testdata[8217] */
    { 4109, 0x00000000U, 0x078E1B73U }, /* XSUM_XXH32_testdata[8218] */
    { 4109, 0x9E3779B1U, 0xCC0F8DF5U }, /* XSUM_XXH32_testdata[8219] */
    { 4110, 0x00000000U, 0xE1122F9FU }, /* XSUM_XXH32_testdata[8220] */
    { 4110, 0x9E3779B1U, 0xF194A1B1U }, /* XSUM_XXH32_testdata[8221] */
    { 4111, 0x00000000U, 0x3BF2AEDDU }, /* XSUM_XXH32_testdata[8222] */
    { 4111, 0x9E3779B1U, 0x9A333866U }, /* XSUM_XXH32_testdata[8223] */
    { 4112, 0x00000000U, 0x904888B6U }, /* XSUM_XXH32_testdata[8224] */
    { 4112, 0x9E3779B1U, 0xABED9738U }, /* XSUM_XXH32_testdata[8225] */
    { 4113, 0x00000000U, 0xC373E6B2U }, /* XSUM_XXH32_testdata[8226] */
    { 4113, 0x9E3779B1U, 0xCCB77D39U }, /* XSUM_XXH32_testdata[8227] */
    { 4114, 0x00000000U, 0x341B9A96U }, /* XSUM_XXH32_testdata[8228] */
    { 4114, 0x9E3779B1U, 0xF855A055U }, /* XSUM_XXH32_testdata[8229] */
    { 4115, 0x00000000U, 0x3F4DCD64U }, /* XSUM_XXH32_testdata[8230] */
    { 4115, 0x9E3779B1U, 0xA3931670U }, /* XSUM_XXH32_testdata[8231] */
    { 4116, 0x00000000U, 0x540DAE3BU }, /* XSUM_XXH32_testdata[8232] */
    { 4116, 0x9E3779B1U, 0x68BD730DU }, /* XSUM_XXH32_testdata[8233] */
    { 4117, 0x00000000U, 0x903AD8BBU }, /* XSUM_XXH32_testdata[8234] */
    { 4117, 0x9E3779B1U, 0x2AA39C72U }, /* XSUM_XXH32_testdata[8235] */
    { 4118, 0x00000000U, 0x4C14E1EAU }, /* XSUM_XXH32_testdata[8236] */
    { 4118, 0x9E3779B1U, 0x9A3AD35EU }, /* XSUM_XXH32_testdata[8237] */
    { 4119, 0x00000000U, 0x3CAED5A3U }, /* XSUM_XXH32_testdata[8238] */
    { 4119, 0x9E3779B1U, 0xF2676329U }, /* XSUM_XXH32_testdata[8239] */
    { 4120, 0x00000000U, 0x7C84DE93U }, /* XSUM_XXH32_testdata[8240] */
    { 4120, 0x9E3779B1U, 0xE2EBED75U }, /* XSUM_XXH32_testdata[8241] */
    { 4121, 0x00000000U, 0x308FBD62U }, /* XSUM_XXH32_testdata[8242] */
    { 4121, 0x9E3779B1U, 0x20FBC7F3U }, /* XSUM_XXH32_testdata[8243] */
    { 4122, 0x00000000U, 0x758B8DD7U }, /* XSUM_XXH32_testdata[8244] */
    { 4122, 0x9E3779B1U, 0x13AAFF2BU }, /* XSUM_XXH32_testdata[8245] */
    { 4123, 0x00000000U, 0x8D1DF04EU }, /* XSUM_XXH32_testdata[8246] */
    { 4123, 0x9E3779B1U, 0xC81AC618U }, /* XSUM_XXH32_testdata[8247] */
    { 4124, 0x00000000U, 0x4DD18430U }, /* XSUM_XXH32_testdata[8248] */
    { 4124, 0x9E3779B1U, 0x914C8A76U }, /* XSUM_XXH32_testdata[8249] */
    { 4125, 0x00000000U, 0x97F719B8U }, /* XSUM_XXH32_testdata[8250] */
    { 4125, 0x9E3779B1U, 0x6057F01AU }, /* XSUM_XXH32_testdata[8251] */
    { 4126, 0x00000000U, 0x5B0750EEU }, /* XSUM_XXH32_testdata[8252] */
    { 4126, 0x9E3779B1U, 0xC787DAA4U }, /* XSUM_XXH32_testdata[8253] */
    { 4127, 0x00000000U, 0x85C97EB1U }, /* XSUM_XXH32_testdata[8254] */
    { 4127, 0x9E3779B1U, 0x4897C062U }, /* XSUM_XXH32_testdata[8255] */
    { 4128, 0x00000000U, 0x53423C9BU }, /* XSUM_XXH32_testdata[8256] */
    { 4128, 0x9E3779B1U, 0xC869D009U }, /* XSUM_XXH32_testdata[8257] */
    { 4129, 0x00000000U, 0x96EA42C3U }, /* XSUM_XXH32_testdata[8258] */
    { 4129, 0x9E3779B1U, 0xF3BA51D5U }, /* XSUM_XXH32_testdata[8259] */
    { 4130, 0x00000000U, 0xE8C15073U }, /* XSUM_XXH32_testdata[8260] */
    { 4130, 0x9E3779B1U, 0xFFE5EDA2U }, /* XSUM_XXH32_testdata[8261] */
    { 4131, 0x00000000U, 0x72C26EFCU }, /* XSUM_XXH32_testdata[8262] */
    { 4131, 0x9E3779B1U, 0x4186C6F1U }, /* XSUM_XXH32_testdata[8263] */
    { 4132, 0x00000000U, 0x30C2A80AU }, /* XSUM_XXH32_testdata[8264] */
    { 4132, 0x9E3779B1U, 0x56EEE369U }, /* XSUM_XXH32_testdata[8265] */
    { 4133, 0x00000000U, 0xEC136775U }, /* XSUM_XXH32_testdata[8266] */
    { 4133, 0x9E3779B1U, 0x05B90E20U }, /* XSUM_XXH32_testdata[8267] */
    { 4134, 0x00000000U, 0x55C86666U }, /* XSUM_XXH32_testdata[8268] */
    { 4134, 0x9E3779B1U, 0x9D888733U }, /* XSUM_XXH32_testdata[8269] */
    { 4135, 0x00000000U, 0xE33DCE33U }, /* XSUM_XXH32_testdata[8270] */
    { 4135, 0x9E3779B1U, 0x4A21932AU }, /* XSUM_XXH32_testdata[8271] */
    { 4136, 0x00000000U, 0x820CC721U }, /* XSUM_XXH32_testdata[8272] */
    { 4136, 0x9E3779B1U, 0x3720E417U }, /* XSUM_XXH32_testdata[8273] */
    { 4137, 0x00000000U, 0x91484716U }, /* XSUM_XXH32_testdata[8274] */
    { 4137, 0x9E3779B1U, 0x8A2F206CU }, /* XSUM_XXH32_testdata[8275] */
    { 4138, 0x00000000U, 0xB0BDDA46U }, /* XSUM_XXH32_testdata[8276] */
    { 4138, 0x9E3779B1U, 0xF3D55FA1U }, /* XSUM_XXH32_testdata[8277] */
    { 4139, 0x00000000U, 0x997CD6F3U }, /* XSUM_XXH32_testdata[8278] */
    { 4139, 0x9E3779B1U, 0x13136455U }, /* XSUM_XXH32_testdata[8279] */
    { 4140, 0x00000000U, 0x421FEE6EU }, /* XSUM_XXH32_testdata[8280] */
    { 4140, 0x9E3779B1U, 0x30749385U }, /* XSUM_XXH32_testdata[8281] */
    { 4141, 0x00000000U, 0xF1BBA08CU }, /* XSUM_XXH32_testdata[8282] */
    { 4141, 0x9E3779B1U, 0x20778E8AU }, /* XSUM_XXH32_testdata[8283] */
    { 4142, 0x00000000U, 0xE1843725U }, /* XSUM_XXH32_testdata[8284] */
    { 4142, 0x9E3779B1U, 0x4999E467U }, /* XSUM_XXH32_testdata[8285] */
    { 4143, 0x00000000U, 0x6E278223U }, /* XSUM_XXH32_testdata[8286] */
    { 4143, 0x9E3779B1U, 0x60853FB5U }, /* XSUM_XXH32_testdata[8287] */
    { 4144, 0x00000000U, 0xE3DF5E5EU }, /* XSUM_XXH32_testdata[8288] */
    { 4144, 0x9E3779B1U, 0x32859AA0U }, /* XSUM_XXH32_testdata[8289] */
    { 4145, 0x00000000U, 0xF17B8246U }, /* XSUM_XXH32_testdata[8290] */
    { 4145, 0x9E3779B1U, 0x1F94021AU }, /* XSUM_XXH32_testdata[8291] */
    { 4146, 0x00000000U, 0x059FE179U }, /* XSUM_XXH32_testdata[8292] */
    { 4146, 0x9E3779B1U, 0x1A19570EU }, /* XSUM_XXH32_testdata[8293] */
    { 4147, 0x00000000U, 0x1377A418U }, /* XSUM_XXH32_testdata[8294] */
    { 4147, 0x9E3779B1U, 0x725131CAU }, /* XSUM_XXH32_testdata[8295] */
    { 4148, 0x00000000U, 0x68F6D614U }, /* XSUM_XXH32_testdata[8296] */
    { 4148, 0x9E3779B1U, 0x8D6DBDEAU }, /* XSUM_XXH32_testdata[8297] */
    { 4149, 0x00000000U, 0xFAD39F40U }, /* XSUM_XXH32_testdata[8298] */
    { 4149, 0x9E3779B1U, 0xF4A552D3U }, /* XSUM_XXH32_testdata[8299] */
    { 4150, 0x00000000U, 0x0C4CC8C3U }, /* XSUM_XXH32_testdata[8300] */
    { 4150, 0x9E3779B1U, 0xF48E8895U }, /* XSUM_XXH32_testdata[8301] */
    { 4151, 0x00000000U, 0xB0753CE2U }, /* XSUM_XXH32_testdata[8302] */
    { 4151, 0x9E3779B1U, 0x3641D63EU }, /* XSUM_XXH32_testdata[8303] */
    { 4152, 0x00000000U, 0xC8CCFD46U }, /* XSUM_XXH32_testdata[8304] */
    { 4152, 0x9E3779B1U, 0x26553A09U }, /* XSUM_XXH32_testdata[8305] */
    { 4153, 0x00000000U, 0x798B4CFEU }, /* XSUM_XXH32_testdata[8306] */
    { 4153, 0x9E3779B1U, 0x3B876753U }, /* XSUM_XXH32_testdata[8307] */
    { 4154, 0x00000000U, 0x1CB63AABU }, /* XSUM_XXH32_testdata[8308] */
    { 4154, 0x9E3779B1U, 0x8A16C774U }, /* XSUM_XXH32_testdata[8309] */
    { 4155, 0x00000000U, 0x8280F4A8U }, /* XSUM_XXH32_testdata[8310] */
    { 4155, 0x9E3779B1U, 0x7B81E441U }, /* XSUM_XXH32_testdata[8311] */
    { 4156, 0x00000000U, 0xB870853EU }, /* XSUM_XXH32_testdata[8312] */
    { 4156, 0x9E3779B1U, 0x3C16BA4EU }, /* XSUM_XXH32_testdata[8313] */
    { 4157, 0x00000000U, 0xA8A1494BU }, /* XSUM_XXH32_testdata[8314] */
    { 4157, 0x9E3779B1U, 0x1D297001U }, /* XSUM_XXH32_testdata[8315] */
    { 4158, 0x00000000U, 0xF4F3E125U }, /* XSUM_XXH32_testdata[8316] */
    { 4158, 0x9E3779B1U, 0x2D68E87BU }, /* XSUM_XXH32_testdata[8317] */
    { 4159, 0x00000000U, 0x58A67826U }, /* XSUM_XXH32_testdata[8318] */
    { 4159, 0x9E3779B1U, 0x1C86EDD0U }, /* XSUM_XXH32_testdata[8319] */
    { 4160, 0x00000000U, 0xDB0D9141U }, /* XSUM_XXH32_testdata[8320] */
    { 4160, 0x9E3779B1U, 0xCCA10DF5U }, /* XSUM_XXH32_testdata[8321] */
};
static const XSUM_testdata64_t XSUM_XXH64_testdata[] = {
    {    0, 0x0000000000000000ULL, 0xEF46DB3751D8E999ULL }, /* XSUM_XXH64_testdata[0] */
    {    0, 0x000000009E3779B1ULL, 0xAC75FDA2929B17EFULL }, /* XSUM_XXH64_testdata[1] */
    {    1, 0x0000000000000000ULL, 0xE934A84ADB052768ULL }, /* XSUM_XXH64_testdata[2] */
    {    1, 0x000000009E3779B1ULL, 0x5014607643A9B4C3ULL }, /* XSUM_XXH64_testdata[3] */
    {    2, 0x0000000000000000ULL, 0x5D48CD60A77E23FFULL }, /* XSUM_XXH64_testdata[4] */
    {    2, 0x000000009E3779B1ULL, 0x9E93152232D54A39ULL }, /* XSUM_XXH64_testdata[5] */
    {    3, 0x0000000000000000ULL, 0xFF7E1959CB50794AULL }, /* XSUM_XXH64_testdata[6] */
    {    3, 0x000000009E3779B1ULL, 0xAA8584E83660F7D1ULL }, /* XSUM_XXH64_testdata[7] */
    {    4, 0x0000000000000000ULL, 0x9136A0DCA57457EEULL }, /* XSUM_XXH64_testdata[8] */
    {    4, 0x000000009E3779B1ULL, 0xCAAB286BD8E9FDB5ULL }, /* XSUM_XXH64_testdata[9] */
    {    5, 0x0000000000000000ULL, 0x9B046FB1397F09A5ULL }, /* XSUM_XXH64_testdata[10] */
    {    5, 0x000000009E3779B1ULL, 0x2AF5249930F984ECULL }, /* XSUM_XXH64_testdata[11] */
    {    6, 0x0000000000000000ULL, 0xC72565B7154268A8ULL }, /* XSUM_XXH64_testdata[12] */
    {    6, 0x000000009E3779B1ULL, 0xCA4C6723580E8EF6ULL }, /* XSUM_XXH64_testdata[13] */
    {    7, 0x0000000000000000ULL, 0x6C83909A9F01ED25ULL }, /* XSUM_XXH64_testdata[14] */
    {    7, 0x000000009E3779B1ULL, 0xF98D03B1AD6F9293ULL }, /* XSUM_XXH64_testdata[15] */
    {    8, 0x0000000000000000ULL, 0xCDBCF538E71D1348ULL }, /* XSUM_XXH64_testdata[16] */
    {    8, 0x000000009E3779B1ULL, 0xFE0C047A5353CDACULL }, /* XSUM_XXH64_testdata[17] */
    {    9, 0x0000000000000000ULL, 0x554B1AE991EDA6B6ULL }, /* XSUM_XXH64_testdata[18] */
    {    9, 0x000000009E3779B1ULL, 0x7908265248F6D73FULL }, /* XSUM_XXH64_testdata[19] */
    {   10, 0x0000000000000000ULL, 0x5D00E7351392EA84ULL }, /* XSUM_XXH64_testdata[20] */
    {   10, 0x000000009E3779B1ULL, 0x2A8AE16B86CD2F12ULL }, /* XSUM_XXH64_testdata[21] */
    {   11, 0x0000000000000000ULL, 0x6345D5746F35DA70ULL }, /* XSUM_XXH64_testdata[22] */
    {   11, 0x000000009E3779B1ULL, 0xEAA08A8C8BE3CCCFULL }, /* XSUM_XXH64_testdata[23] */
    {   12, 0x0000000000000000ULL, 0x0723BF50086EAD9AULL }, /* XSUM_XXH64_testdata[24] */
    {   12, 0x000000009E3779B1ULL, 0x8252819F4E506951ULL }, /* XSUM_XXH64_testdata[25] */
    {   13, 0x0000000000000000ULL, 0xC2E5013E3C40BCF7ULL }, /* XSUM_XXH64_testdata[26] */
    {   13, 0x000000009E3779B1ULL, 0x4DF437A291CB1039ULL }, /* XSUM_XXH64_testdata[27] */
    {   14, 0x0000000000000000ULL, 0x8282DCC4994E35C8ULL }, /* XSUM_XXH64_testdata[28] */
    {   14, 0x000000009E3779B1ULL, 0xC3BD6BF63DEB6DF0ULL }, /* XSUM_XXH64_testdata[29] */
    {   15, 0x0000000000000000ULL, 0x180719316D622D84ULL }, /* XSUM_XXH64_testdata[30] */
    {   15, 0x000000009E3779B1ULL, 0xD61105C20E91F99FULL }, /* XSUM_XXH64_testdata[31] */
    {   16, 0x0000000000000000ULL, 0x98C90B57FDFCB55CULL }, /* XSUM_XXH64_testdata[32] */
    {   16, 0x000000009E3779B1ULL, 0xC900AD2D536B607EULL }, /* XSUM_XXH64_testdata[33] */
    {   17, 0x0000000000000000ULL, 0x0D39A2D051A30C2CULL }, /* XSUM_XXH64_testdata[34] */
    {   17, 0x000000009E3779B1ULL, 0x495CD68A647C7A22ULL }, /* XSUM_XXH64_testdata[35] */
    {   18, 0x0000000000000000ULL, 0x33E84A4333B2B2EBULL }, /* XSUM_XXH64_testdata[36] */
    {   18, 0x000000009E3779B1ULL, 0x2325A30CCA1A66DDULL }, /* XSUM_XXH64_testdata[37] */
    {   19, 0x0000000000000000ULL, 0xE91C6EF31FC08F82ULL }, /* XSUM_XXH64_testdata[38] */
    {   19, 0x000000009E3779B1ULL, 0x06809662799B7D6FULL }, /* XSUM_XXH64_testdata[39] */
    {   20, 0x0000000000000000ULL, 0x5F8C68355769439EULL }, /* XSUM_XXH64_testdata[40] */
    {   20, 0x000000009E3779B1ULL, 0x97218696C2D29602ULL }, /* XSUM_XXH64_testdata[41] */
    {   21, 0x0000000000000000ULL, 0x42B0B8EE353AC461ULL }, /* XSUM_XXH64_testdata[42] */
    {   21, 0x000000009E3779B1ULL, 0x7FC0BB451B83A633ULL }, /* XSUM_XXH64_testdata[43] */
    {   22, 0x0000000000000000ULL, 0x65C935C6978098B1ULL }, /* XSUM_XXH64_testdata[44] */
    {   22, 0x000000009E3779B1ULL, 0xC4A0DD14BF835C13ULL }, /* XSUM_XXH64_testdata[45] */
    {   23, 0x0000000000000000ULL, 0xD2460ECC840B74DDULL }, /* XSUM_XXH64_testdata[46] */
    {   23, 0x000000009E3779B1ULL, 0x4B44E8DE7A396773ULL }, /* XSUM_XXH64_testdata[47] */
    {   24, 0x0000000000000000ULL, 0xF75A6DEA42DC5BF4ULL }, /* XSUM_XXH64_testdata[48] */
    {   24, 0x000000009E3779B1ULL, 0x8B7C67EB59778E22ULL }, /* XSUM_XXH64_testdata[49] */
    {   25, 0x0000000000000000ULL, 0x52FAA43C3F20B994ULL }, /* XSUM_XXH64_testdata[50] */
    {   25, 0x000000009E3779B1ULL, 0xC4FEC92EAC2C3B8AULL }, /* XSUM_XXH64_testdata[51] */
    {   26, 0x0000000000000000ULL, 0x8DB7831EC345F9A3ULL }, /* XSUM_XXH64_testdata[52] */
    {   26, 0x000000009E3779B1ULL, 0x2C2A80BCAD321466ULL }, /* XSUM_XXH64_testdata[53] */
    {   27, 0x0000000000000000ULL, 0x88945AA08051FC2DULL }, /* XSUM_XXH64_testdata[54] */
    {   27, 0x000000009E3779B1ULL, 0x3401AF8EF28FD410ULL }, /* XSUM_XXH64_testdata[55] */
    {   28, 0x0000000000000000ULL, 0x64CD9E8C96A9E2DDULL }, /* XSUM_XXH64_testdata[56] */
    {   28, 0x000000009E3779B1ULL, 0x8160FB8C20B48287ULL }, /* XSUM_XXH64_testdata[57] */
    {   29, 0x0000000000000000ULL, 0x8C8F345B634AC2B9ULL }, /* XSUM_XXH64_testdata[58] */
    {   29, 0x000000009E3779B1ULL, 0x5A327C78E4AD6678ULL }, /* XSUM_XXH64_testdata[59] */
    {   30, 0x0000000000000000ULL, 0xE2677241D4C46CAFULL }, /* XSUM_XXH64_testdata[60] */
    {   30, 0x000000009E3779B1ULL, 0xB1B2B51C93AF4866ULL }, /* XSUM_XXH64_testdata[61] */
    {   31, 0x0000000000000000ULL, 0x299B39A290E6D783ULL }, /* XSUM_XXH64_testdata[62] */
    {   31, 0x000000009E3779B1ULL, 0xDA673D5FEB5C1D79ULL }, /* XSUM_XXH64_testdata[63] */
    {   32, 0x0000000000000000ULL, 0x18B216492BB44B70ULL }, /* XSUM_XXH64_testdata[64] */
    {   32, 0x000000009E3779B1ULL, 0xB3F33BDF93ADE409ULL }, /* XSUM_XXH64_testdata[65] */
    {   33, 0x0000000000000000ULL, 0x55C8DC3E578F5B59ULL }, /* XSUM_XXH64_testdata[66] */
    {   33, 0x000000009E3779B1ULL, 0xE92C292F64BC3071ULL }, /* XSUM_XXH64_testdata[67] */
    {   34, 0x0000000000000000ULL, 0xD0CE7CBAE371BEB2ULL }, /* XSUM_XXH64_testdata[68] */
    {   34, 0x000000009E3779B1ULL, 0xC509C460280BBB12ULL }, /* XSUM_XXH64_testdata[69] */
    {   35, 0x0000000000000000ULL, 0xCB0AA8E2A7A29707ULL }, /* XSUM_XXH64_testdata[70] */
    {   35, 0x000000009E3779B1ULL, 0xECE3515C236504C7ULL }, /* XSUM_XXH64_testdata[71] */
    {   36, 0x0000000000000000ULL, 0x0AE67584084DC6A4ULL }, /* XSUM_XXH64_testdata[72] */
    {   36, 0x000000009E3779B1ULL, 0x57C73F9E3A6FC2C6ULL }, /* XSUM_XXH64_testdata[73] */
    {   37, 0x0000000000000000ULL, 0x292F5332C92B73CEULL }, /* XSUM_XXH64_testdata[74] */
    {   37, 0x000000009E3779B1ULL, 0x7762425B2E89DAD3ULL }, /* XSUM_XXH64_testdata[75] */
    {   38, 0x0000000000000000ULL, 0x5F398E2A8478BED3ULL }, /* XSUM_XXH64_testdata[76] */
    {   38, 0x000000009E3779B1ULL, 0xE842D306DC53E621ULL }, /* XSUM_XXH64_testdata[77] */
    {   39, 0x0000000000000000ULL, 0xB888CAF07592B1B3ULL }, /* XSUM_XXH64_testdata[78] */
    {   39, 0x000000009E3779B1ULL, 0x602E74D43465AC3DULL }, /* XSUM_XXH64_testdata[79] */
    {   40, 0x0000000000000000ULL, 0x23B3810D7D8B1731ULL }, /* XSUM_XXH64_testdata[80] */
    {   40, 0x000000009E3779B1ULL, 0x5A57F246772BC540ULL }, /* XSUM_XXH64_testdata[81] */
    {   41, 0x0000000000000000ULL, 0x5342C966C7F3D5F4ULL }, /* XSUM_XXH64_testdata[82] */
    {   41, 0x000000009E3779B1ULL, 0xB213FFB25FEB1CCDULL }, /* XSUM_XXH64_testdata[83] */
    {   42, 0x0000000000000000ULL, 0x77454B74F1DBBF63ULL }, /* XSUM_XXH64_testdata[84] */
    {   42, 0x000000009E3779B1ULL, 0xAED0CE7EA4202741ULL }, /* XSUM_XXH64_testdata[85] */
    {   43, 0x0000000000000000ULL, 0x9904C9350F597190ULL }, /* XSUM_XXH64_testdata[86] */
    {   43, 0x000000009E3779B1ULL, 0xA071200735E57A6AULL }, /* XSUM_XXH64_testdata[87] */
    {   44, 0x0000000000000000ULL, 0x24EC2B3D0E442641ULL }, /* XSUM_XXH64_testdata[88] */
    {   44, 0x000000009E3779B1ULL, 0x831B7452E64EB328ULL }, /* XSUM_XXH64_testdata[89] */
    {   45, 0x0000000000000000ULL, 0x4EC307EBE0A650A4ULL }, /* XSUM_XXH64_testdata[90] */
    {   45, 0x000000009E3779B1ULL, 0x66BDA694A1FD3023ULL }, /* XSUM_XXH64_testdata[91] */
    {   46, 0x0000000000000000ULL, 0x7DD1C5514B2240EFULL }, /* XSUM_XXH64_testdata[92] */
    {   46, 0x000000009E3779B1ULL, 0xD238E617805EA9BBULL }, /* XSUM_XXH64_testdata[93] */
    {   47, 0x0000000000000000ULL, 0x84A42E167CBD1FEFULL }, /* XSUM_XXH64_testdata[94] */
    {   47, 0x000000009E3779B1ULL, 0xA474B31A5132A541ULL }, /* XSUM_XXH64_testdata[95] */
    {   48, 0x0000000000000000ULL, 0xFD0FEEAC7A939933ULL }, /* XSUM_XXH64_testdata[96] */
    {   48, 0x000000009E3779B1ULL, 0x6FFE2F43A24C2302ULL }, /* XSUM_XXH64_testdata[97] */
    {   49, 0x0000000000000000ULL, 0xA91BFF78A7185B66ULL }, /* XSUM_XXH64_testdata[98] */
    {   49, 0x000000009E3779B1ULL, 0xE858B13C918498ECULL }, /* XSUM_XXH64_testdata[99] */
    {   50, 0x0000000000000000ULL, 0xDFFE9F293DDD101DULL }, /* XSUM_XXH64_testdata[100] */
    {   50, 0x000000009E3779B1ULL, 0x46521A048859CE7AULL }, /* XSUM_XXH64_testdata[101] */
    {   51, 0x0000000000000000ULL, 0x2332585C18D7483AULL }, /* XSUM_XXH64_testdata[102] */
    {   51, 0x000000009E3779B1ULL, 0x788846B44826A5D1ULL }, /* XSUM_XXH64_testdata[103] */
    {   52, 0x0000000000000000ULL, 0x5A0056511F9DD653ULL }, /* XSUM_XXH64_testdata[104] */
    {   52, 0x000000009E3779B1ULL, 0x1C0081F84C6D32DBULL }, /* XSUM_XXH64_testdata[105] */
    {   53, 0x0000000000000000ULL, 0x4426A2F5C8D59469ULL }, /* XSUM_XXH64_testdata[106] */
    {   53, 0x000000009E3779B1ULL, 0x4270188315F2CC31ULL }, /* XSUM_XXH64_testdata[107] */
    {   54, 0x0000000000000000ULL, 0x39EAF8893520636AULL }, /* XSUM_XXH64_testdata[108] */
    {   54, 0x000000009E3779B1ULL, 0xB6D6E8B68C7EF7A2ULL }, /* XSUM_XXH64_testdata[109] */
    {   55, 0x0000000000000000ULL, 0xAFEA98CC4E92F7E1ULL }, /* XSUM_XXH64_testdata[110] */
    {   55, 0x000000009E3779B1ULL, 0xE6D5C88B9135E579ULL }, /* XSUM_XXH64_testdata[111] */
    {   56, 0x0000000000000000ULL, 0xB7A6414B8D3E2597ULL }, /* XSUM_XXH64_testdata[112] */
    {   56, 0x000000009E3779B1ULL, 0xB6BD2CBFB6A64017ULL }, /* XSUM_XXH64_testdata[113] */
    {   57, 0x0000000000000000ULL, 0xF33D64569CD4B1C0ULL }, /* XSUM_XXH64_testdata[114] */
    {   57, 0x000000009E3779B1ULL, 0xB9B235447E24CA28ULL }, /* XSUM_XXH64_testdata[115] */
    {   58, 0x0000000000000000ULL, 0x93FA072F0E8FE7CAULL }, /* XSUM_XXH64_testdata[116] */
    {   58, 0x000000009E3779B1ULL, 0xB8D0D6211B80EA15ULL }, /* XSUM_XXH64_testdata[117] */
    {   59, 0x0000000000000000ULL, 0x4F2890576949D6EDULL }, /* XSUM_XXH64_testdata[118] */
    {   59, 0x000000009E3779B1ULL, 0x11E586B470B7224EULL }, /* XSUM_XXH64_testdata[119] */
    {   60, 0x0000000000000000ULL, 0x3378C44F459C290BULL }, /* XSUM_XXH64_testdata[120] */
    {   60, 0x000000009E3779B1ULL, 0xA7C18F722446E5C8ULL }, /* XSUM_XXH64_testdata[121] */
    {   61, 0x0000000000000000ULL, 0x40D486FDDDAD5CB7ULL }, /* XSUM_XXH64_testdata[122] */
    {   61, 0x000000009E3779B1ULL, 0x980BDE3212E2F025ULL }, /* XSUM_XXH64_testdata[123] */
    {   62, 0x0000000000000000ULL, 0x21664C60C551CC87ULL }, /* XSUM_XXH64_testdata[124] */
    {   62, 0x000000009E3779B1ULL, 0x128AC6F704B8A0F7ULL }, /* XSUM_XXH64_testdata[125] */
    {   63, 0x0000000000000000ULL, 0xA9EFBE0FA0F3F4E7ULL }, /* XSUM_XXH64_testdata[126] */
    {   63, 0x000000009E3779B1ULL, 0x6C911FADB05B6FC2ULL }, /* XSUM_XXH64_testdata[127] */
    {   64, 0x0000000000000000ULL, 0xEF558F8ACAC2B5CDULL }, /* XSUM_XXH64_testdata[128] */
    {   64, 0x000000009E3779B1ULL, 0xB5EEBA99264CC44FULL }, /* XSUM_XXH64_testdata[129] */
    {   65, 0x0000000000000000ULL, 0xDE0F20DC2631AF7AULL }, /* XSUM_XXH64_testdata[130] */
    {   65, 0x000000009E3779B1ULL, 0xD3F6FF3941E310CAULL }, /* XSUM_XXH64_testdata[131] */
    {   66, 0x0000000000000000ULL, 0xCF1E52EDE1C505C4ULL }, /* XSUM_XXH64_testdata[132] */
    {   66, 0x000000009E3779B1ULL, 0xBCE7B3488A29EFB1ULL }, /* XSUM_XXH64_testdata[133] */
    {   67, 0x0000000000000000ULL, 0x0965DF7219D2E741ULL }, /* XSUM_XXH64_testdata[134] */
    {   67, 0x000000009E3779B1ULL, 0x1862E884ABDC704CULL }, /* XSUM_XXH64_testdata[135] */
    {   68, 0x0000000000000000ULL, 0x1B8378E923B247A7ULL }, /* XSUM_XXH64_testdata[136] */
    {   68, 0x000000009E3779B1ULL, 0x25E6F985E36492EFULL }, /* XSUM_XXH64_testdata[137] */
    {   69, 0x0000000000000000ULL, 0x43F2B606AD9BA362ULL }, /* XSUM_XXH64_testdata[138] */
    {   69, 0x000000009E3779B1ULL, 0x81F00574A346F668ULL }, /* XSUM_XXH64_testdata[139] */
    {   70, 0x0000000000000000ULL, 0xD9C3413222F1DEA4ULL }, /* XSUM_XXH64_testdata[140] */
    {   70, 0x000000009E3779B1ULL, 0xE01652426AA1774CULL }, /* XSUM_XXH64_testdata[141] */
    {   71, 0x0000000000000000ULL, 0x3D6ECAB2BCFBE3FFULL }, /* XSUM_XXH64_testdata[142] */
    {   71, 0x000000009E3779B1ULL, 0xAAB5C313DFAC5A44ULL }, /* XSUM_XXH64_testdata[143] */
    {   72, 0x0000000000000000ULL, 0xEA8573B60D5A8800ULL }, /* XSUM_XXH64_testdata[144] */
    {   72, 0x000000009E3779B1ULL, 0xBDEE6BA43947EB30ULL }, /* XSUM_XXH64_testdata[145] */
    {   73, 0x0000000000000000ULL, 0xE372599E31F8CFFDULL }, /* XSUM_XXH64_testdata[146] */
    {   73, 0x000000009E3779B1ULL, 0xF1597384DE9FBD93ULL }, /* XSUM_XXH64_testdata[147] */
    {   74, 0x0000000000000000ULL, 0x02B86794A00BDBE8ULL }, /* XSUM_XXH64_testdata[148] */
    {   74, 0x000000009E3779B1ULL, 0x5FB940B90D39A1E6ULL }, /* XSUM_XXH64_testdata[149] */
    {   75, 0x0000000000000000ULL, 0xCA1A21FB24979810ULL }, /* XSUM_XXH64_testdata[150] */
    {   75, 0x000000009E3779B1ULL, 0x76214D8E3B169CF5ULL }, /* XSUM_XXH64_testdata[151] */
    {   76, 0x0000000000000000ULL, 0x60DFF17BEC07766DULL }, /* XSUM_XXH64_testdata[152] */
    {   76, 0x000000009E3779B1ULL, 0x9A8133A1DDAF07DBULL }, /* XSUM_XXH64_testdata[153] */
    {   77, 0x0000000000000000ULL, 0xF4AF74828DE6862DULL }, /* XSUM_XXH64_testdata[154] */
    {   77, 0x000000009E3779B1ULL, 0xD73AEC54F785E384ULL }, /* XSUM_XXH64_testdata[155] */
    {   78, 0x0000000000000000ULL, 0x828E4C8C5257CC15ULL }, /* XSUM_XXH64_testdata[156] */
    {   78, 0x000000009E3779B1ULL, 0xD2317E57923E664CULL }, /* XSUM_XXH64_testdata[157] */
    {   79, 0x0000000000000000ULL, 0x91F7F9D6008299A0ULL }, /* XSUM_XXH64_testdata[158] */
    {   79, 0x000000009E3779B1ULL, 0xE863995625F7AD52ULL }, /* XSUM_XXH64_testdata[159] */
    {   80, 0x0000000000000000ULL, 0x99BD5D25EB211099ULL }, /* XSUM_XXH64_testdata[160] */
    {   80, 0x000000009E3779B1ULL, 0x5281D5357D0B8AC4ULL }, /* XSUM_XXH64_testdata[161] */
    {   81, 0x0000000000000000ULL, 0xCB329A8F102F05BCULL }, /* XSUM_XXH64_testdata[162] */
    {   81, 0x000000009E3779B1ULL, 0x7E77B483A01E4AEDULL }, /* XSUM_XXH64_testdata[163] */
    {   82, 0x0000000000000000ULL, 0x993A0B6E6D5DF0CBULL }, /* XSUM_XXH64_testdata[164] */
    {   82, 0x000000009E3779B1ULL, 0x6DBD4234F13A5DC1ULL }, /* XSUM_XXH64_testdata[165] */
    {   83, 0x0000000000000000ULL, 0x818F4CEC407D8CF9ULL }, /* XSUM_XXH64_testdata[166] */
    {   83, 0x000000009E3779B1ULL, 0x0367C5363E62AEC3ULL }, /* XSUM_XXH64_testdata[167] */
    {   84, 0x0000000000000000ULL, 0xAF57F8CD340FB1B6ULL }, /* XSUM_XXH64_testdata[168] */
    {   84, 0x000000009E3779B1ULL, 0xC7623B4C4E6844C1ULL }, /* XSUM_XXH64_testdata[169] */
    {   85, 0x0000000000000000ULL, 0x50789F0F60EBAD3AULL }, /* XSUM_XXH64_testdata[170] */
    {   85, 0x000000009E3779B1ULL, 0xB88DA3150AAF44BEULL }, /* XSUM_XXH64_testdata[171] */
    {   86, 0x0000000000000000ULL, 0xF3214750C1A6455EULL }, /* XSUM_XXH64_testdata[172] */
    {   86, 0x000000009E3779B1ULL, 0x56C1A7FB96DE0E82ULL }, /* XSUM_XXH64_testdata[173] */
    {   87, 0x0000000000000000ULL, 0x8DBE8913BE346D20ULL }, /* XSUM_XXH64_testdata[174] */
    {   87, 0x000000009E3779B1ULL, 0x899E381BD46D1409ULL }, /* XSUM_XXH64_testdata[175] */
    {   88, 0x0000000000000000ULL, 0xA130814F81F87E43ULL }, /* XSUM_XXH64_testdata[176] */
    {   88, 0x000000009E3779B1ULL, 0xA3BF96F3D593C759ULL }, /* XSUM_XXH64_testdata[177] */
    {   89, 0x0000000000000000ULL, 0x0023276D258EDA58ULL }, /* XSUM_XXH64_testdata[178] */
    {   89, 0x000000009E3779B1ULL, 0x6779DE8C67483444ULL }, /* XSUM_XXH64_testdata[179] */
    {   90, 0x0000000000000000ULL, 0x0A0571F769B40C93ULL }, /* XSUM_XXH64_testdata[180] */
    {   90, 0x000000009E3779B1ULL, 0x9C915D4DA4BE05A6ULL }, /* XSUM_XXH64_testdata[181] */
    {   91, 0x0000000000000000ULL, 0x14A2F5051E8893C8ULL }, /* XSUM_XXH64_testdata[182] */
    {   91, 0x000000009E3779B1ULL, 0x46F62B0B3D1B66AFULL }, /* XSUM_XXH64_testdata[183] */
    {   92, 0x0000000000000000ULL, 0x4FBBE74E062367B0ULL }, /* XSUM_XXH64_testdata[184] */
    {   92, 0x000000009E3779B1ULL, 0x3190419611427263ULL }, /* XSUM_XXH64_testdata[185] */
    {   93, 0x0000000000000000ULL, 0x4B375CEF503586FCULL }, /* XSUM_XXH64_testdata[186] */
    {   93, 0x000000009E3779B1ULL, 0x821D5495DDDC7C82ULL }, /* XSUM_XXH64_testdata[187] */
    {   94, 0x0000000000000000ULL, 0x6AD4B96E4286EB70ULL }, /* XSUM_XXH64_testdata[188] */
    {   94, 0x000000009E3779B1ULL, 0x553DDDB89F3CB523ULL }, /* XSUM_XXH64_testdata[189] */
    {   95, 0x0000000000000000ULL, 0xFF9F46BDCC644624ULL }, /* XSUM_XXH64_testdata[190] */
    {   95, 0x000000009E3779B1ULL, 0x72E75A560EF624A3ULL }, /* XSUM_XXH64_testdata[191] */
    {   96, 0x0000000000000000ULL, 0x105064E743EDD1D9ULL }, /* XSUM_XXH64_testdata[192] */
    {   96, 0x000000009E3779B1ULL, 0x8FF0B4ABEE6F03CCULL }, /* XSUM_XXH64_testdata[193] */
    {   97, 0x0000000000000000ULL, 0x097B16E4E9B0A2E3ULL }, /* XSUM_XXH64_testdata[194] */
    {   97, 0x000000009E3779B1ULL, 0x9704E5147FDCC4F4ULL }, /* XSUM_XXH64_testdata[195] */
    {   98, 0x0000000000000000ULL, 0x06662519E8393FF2ULL }, /* XSUM_XXH64_testdata[196] */
    {   98, 0x000000009E3779B1ULL, 0xB2889379EAD9C5CFULL }, /* XSUM_XXH64_testdata[197] */
    {   99, 0x0000000000000000ULL, 0xB51CB5BA2957AB0BULL }, /* XSUM_XXH64_testdata[198] */
    {   99, 0x000000009E3779B1ULL, 0x5C10E54DEC4B0FA9ULL }, /* XSUM_XXH64_testdata[199] */
    {  100, 0x0000000000000000ULL, 0x4BFE019CD91D9EA4ULL }, /* XSUM_XXH64_testdata[200] */
    {  100, 0x000000009E3779B1ULL, 0x4853706DC9625CAEULL }, /* XSUM_XXH64_testdata[201] */
    {  101, 0x0000000000000000ULL, 0xA51EA2101B2D114CULL }, /* XSUM_XXH64_testdata[202] */
    {  101, 0x000000009E3779B1ULL, 0x6B38A5BBBA1F049CULL }, /* XSUM_XXH64_testdata[203] */
    {  102, 0x0000000000000000ULL, 0x26259500AD475ACFULL }, /* XSUM_XXH64_testdata[204] */
    {  102, 0x000000009E3779B1ULL, 0x6CDC4C9926C04118ULL }, /* XSUM_XXH64_testdata[205] */
    {  103, 0x0000000000000000ULL, 0x74A97F547BB8C845ULL }, /* XSUM_XXH64_testdata[206] */
    {  103, 0x000000009E3779B1ULL, 0x6A027096FB146E74ULL }, /* XSUM_XXH64_testdata[207] */
    {  104, 0x0000000000000000ULL, 0x23ED252F132DFA0FULL }, /* XSUM_XXH64_testdata[208] */
    {  104, 0x000000009E3779B1ULL, 0x1683C40FE4F3EC6EULL }, /* XSUM_XXH64_testdata[209] */
    {  105, 0x0000000000000000ULL, 0x1E03CFB52F4E43F2ULL }, /* XSUM_XXH64_testdata[210] */
    {  105, 0x000000009E3779B1ULL, 0x8399AE3FAC887392ULL }, /* XSUM_XXH64_testdata[211] */
    {  106, 0x0000000000000000ULL, 0xB3C7FBBF1E2E9E9FULL }, /* XSUM_XXH64_testdata[212] */
    {  106, 0x000000009E3779B1ULL, 0x205158F71E4AD7DAULL }, /* XSUM_XXH64_testdata[213] */
    {  107, 0x0000000000000000ULL, 0xC85AF48447573841ULL }, /* XSUM_XXH64_testdata[214] */
    {  107, 0x000000009E3779B1ULL, 0x42BE4CF154BDCB6FULL }, /* XSUM_XXH64_testdata[215] */
    {  108, 0x0000000000000000ULL, 0x395022FA4E7C679DULL }, /* XSUM_XXH64_testdata[216] */
    {  108, 0x000000009E3779B1ULL, 0x76577A7F0C793723ULL }, /* XSUM_XXH64_testdata[217] */
    {  109, 0x0000000000000000ULL, 0x931CE3A962248CB1ULL }, /* XSUM_XXH64_testdata[218] */
    {  109, 0x000000009E3779B1ULL, 0x3F3AFDE1CBFB2D78ULL }, /* XSUM_XXH64_testdata[219] */
    {  110, 0x0000000000000000ULL, 0x46A7A7126CE7D4E6ULL }, /* XSUM_XXH64_testdata[220] */
    {  110, 0x000000009E3779B1ULL, 0x6CC264DBC30D3EDCULL }, /* XSUM_XXH64_testdata[221] */
    {  111, 0x0000000000000000ULL, 0xB7AFFC461C9ECE18ULL }, /* XSUM_XXH64_testdata[222] */
    {  111, 0x000000009E3779B1ULL, 0x7D83E9E9160317ECULL }, /* XSUM_XXH64_testdata[223] */
    {  112, 0x0000000000000000ULL, 0xE5752EA6E2B34417ULL }, /* XSUM_XXH64_testdata[224] */
    {  112, 0x000000009E3779B1ULL, 0xEECB8B56A5BD00DBULL }, /* XSUM_XXH64_testdata[225] */
    {  113, 0x0000000000000000ULL, 0xFDA17FD84B50AD25ULL }, /* XSUM_XXH64_testdata[226] */
    {  113, 0x000000009E3779B1ULL, 0x47E8C074796FD671ULL }, /* XSUM_XXH64_testdata[227] */
    {  114, 0x0000000000000000ULL, 0x8751DAC0314381B6ULL }, /* XSUM_XXH64_testdata[228] */
    {  114, 0x000000009E3779B1ULL, 0xB880FBDD4FB6B274ULL }, /* XSUM_XXH64_testdata[229] */
    {  115, 0x0000000000000000ULL, 0xF7CB3E3DFCE93157ULL }, /* XSUM_XXH64_testdata[230] */
    {  115, 0x000000009E3779B1ULL, 0x55033F2004F0E78CULL }, /* XSUM_XXH64_testdata[231] */
    {  116, 0x0000000000000000ULL, 0x0A29AECEA5D8240FULL }, /* XSUM_XXH64_testdata[232] */
    {  116, 0x000000009E3779B1ULL, 0xD85DE10D5AD4E0A2ULL }, /* XSUM_XXH64_testdata[233] */
    {  117, 0x0000000000000000ULL, 0x6731FD15B033D86FULL }, /* XSUM_XXH64_testdata[234] */
    {  117, 0x000000009E3779B1ULL, 0xFC63C52FB7E3C2F5ULL }, /* XSUM_XXH64_testdata[235] */
    {  118, 0x0000000000000000ULL, 0x00BB7740D233CCA9ULL }, /* XSUM_XXH64_testdata[236] */
    {  118, 0x000000009E3779B1ULL, 0x13B679C13A3D0514ULL }, /* XSUM_XXH64_testdata[237] */
    {  119, 0x0000000000000000ULL, 0xC9577B1D5E99EADDULL }, /* XSUM_XXH64_testdata[238] */
    {  119, 0x000000009E3779B1ULL, 0xF935B21C4FB17FA0ULL }, /* XSUM_XXH64_testdata[239] */
    {  120, 0x0000000000000000ULL, 0x35E51D65936602F0ULL }, /* XSUM_XXH64_testdata[240] */
    {  120, 0x000000009E3779B1ULL, 0x8F28106B8EDD0B62ULL }, /* XSUM_XXH64_testdata[241] */
    {  121, 0x0000000000000000ULL, 0xD11761D6683C7490ULL }, /* XSUM_XXH64_testdata[242] */
    {  121, 0x000000009E3779B1ULL, 0xE48065BAFEE225FFULL }, /* XSUM_XXH64_testdata[243] */
    {  122, 0x0000000000000000ULL, 0xEC6AFA468D61B584ULL }, /* XSUM_XXH64_testdata[244] */
    {  122, 0x000000009E3779B1ULL, 0x562C3376F70E4A29ULL }, /* XSUM_XXH64_testdata[245] */
    {  123, 0x0000000000000000ULL, 0x147F4024677727ECULL }, /* XSUM_XXH64_testdata[246] */
    {  123, 0x000000009E3779B1ULL, 0x4980EF3E9B77DC0CULL }, /* XSUM_XXH64_testdata[247] */
    {  124, 0x0000000000000000ULL, 0x47FD33A91C14F035ULL }, /* XSUM_XXH64_testdata[248] */
    {  124, 0x000000009E3779B1ULL, 0x89EEA88E5DFFEBBFULL }, /* XSUM_XXH64_testdata[249] */
    {  125, 0x0000000000000000ULL, 0x7B385D8B837FAA3EULL }, /* XSUM_XXH64_testdata[250] */
    {  125, 0x000000009E3779B1ULL, 0xFE949E5EF83C19B5ULL }, /* XSUM_XXH64_testdata[251] */
    {  126, 0x0000000000000000ULL, 0xA0E5EC3ED6068228ULL }, /* XSUM_XXH64_testdata[252] */
    {  126, 0x000000009E3779B1ULL, 0x27EDDF566EA1935CULL }, /* XSUM_XXH64_testdata[253] */
    {  127, 0x0000000000000000ULL, 0x3C7A21119AA662B0ULL }, /* XSUM_XXH64_testdata[254] */
    {  127, 0x000000009E3779B1ULL, 0xB0D6DC189C06CEEDULL }, /* XSUM_XXH64_testdata[255] */
    {  128, 0x0000000000000000ULL, 0x90CA021457D96DC5ULL }, /* XSUM_XXH64_testdata[256] */
    {  128, 0x000000009E3779B1ULL, 0xED9340A202BCD1CFULL }, /* XSUM_XXH64_testdata[257] */
    {  129, 0x0000000000000000ULL, 0x41C280132D697ABAULL }, /* XSUM_XXH64_testdata[258] */
    {  129, 0x000000009E3779B1ULL, 0x1668B87489935FF5ULL }, /* XSUM_XXH64_testdata[259] */
    {  130, 0x0000000000000000ULL, 0xFCEB19904FA5852EULL }, /* XSUM_XXH64_testdata[260] */
    {  130, 0x000000009E3779B1ULL, 0x531E7902F11E5233ULL }, /* XSUM_XXH64_testdata[261] */
    {  131, 0x0000000000000000ULL, 0xA855AB9C545E3AA0ULL }, /* XSUM_XXH64_testdata[262] */
    {  131, 0x000000009E3779B1ULL, 0x38EEF63349D48351ULL }, /* XSUM_XXH64_testdata[263] */
    {  132, 0x0000000000000000ULL, 0x92FF5FE9DF03B47EULL }, /* XSUM_XXH64_testdata[264] */
    {  132, 0x000000009E3779B1ULL, 0x25499A366A4F582AULL }, /* XSUM_XXH64_testdata[265] */
    {  133, 0x0000000000000000ULL, 0xBEBABB79841EEFE3ULL }, /* XSUM_XXH64_testdata[266] */
    {  133, 0x000000009E3779B1ULL, 0x086D173652FF2C7BULL }, /* XSUM_XXH64_testdata[267] */
    {  134, 0x0000000000000000ULL, 0x83484B9261651B21ULL }, /* XSUM_XXH64_testdata[268] */
    {  134, 0x000000009E3779B1ULL, 0xF6DF65E34A988A05ULL }, /* XSUM_XXH64_testdata[269] */
    {  135, 0x0000000000000000ULL, 0x1FA13853B96095B6ULL }, /* XSUM_XXH64_testdata[270] */
    {  135, 0x000000009E3779B1ULL, 0xAE76A9DBD7A050B5ULL }, /* XSUM_XXH64_testdata[271] */
    {  136, 0x0000000000000000ULL, 0xDED15F1F9BA92FEFULL }, /* XSUM_XXH64_testdata[272] */
    {  136, 0x000000009E3779B1ULL, 0xE0DC505D8B6C72AAULL }, /* XSUM_XXH64_testdata[273] */
    {  137, 0x0000000000000000ULL, 0x413F6647912DD2EAULL }, /* XSUM_XXH64_testdata[274] */
    {  137, 0x000000009E3779B1ULL, 0x49402EC5661AF438ULL }, /* XSUM_XXH64_testdata[275] */
    {  138, 0x0000000000000000ULL, 0xBF93F15916B89700ULL }, /* XSUM_XXH64_testdata[276] */
    {  138, 0x000000009E3779B1ULL, 0x5C8B85C8837C3FF6ULL }, /* XSUM_XXH64_testdata[277] */
    {  139, 0x0000000000000000ULL, 0x9B4FD36F05521437ULL }, /* XSUM_XXH64_testdata[278] */
    {  139, 0x000000009E3779B1ULL, 0x1A2A4E33EEA8A6CCULL }, /* XSUM_XXH64_testdata[279] */
    {  140, 0x0000000000000000ULL, 0xAF1F8B36AFE6DF4FULL }, /* XSUM_XXH64_testdata[280] */
    {  140, 0x000000009E3779B1ULL, 0xA001BF8A9FA78B49ULL }, /* XSUM_XXH64_testdata[281] */
    {  141, 0x0000000000000000ULL, 0x6948F778B10726CBULL }, /* XSUM_XXH64_testdata[282] */
    {  141, 0x000000009E3779B1ULL, 0x357064D8FE34DE45ULL }, /* XSUM_XXH64_testdata[283] */
    {  142, 0x0000000000000000ULL, 0x57DE58AC79A084E8ULL }, /* XSUM_XXH64_testdata[284] */
    {  142, 0x000000009E3779B1ULL, 0xBF0781313D72D5E8ULL }, /* XSUM_XXH64_testdata[285] */
    {  143, 0x0000000000000000ULL, 0xD2CA0115A4F272AAULL }, /* XSUM_XXH64_testdata[286] */
    {  143, 0x000000009E3779B1ULL, 0x7529563A8C6AAAD6ULL }, /* XSUM_XXH64_testdata[287] */
    {  144, 0x0000000000000000ULL, 0x47999F1F28EC88A6ULL }, /* XSUM_XXH64_testdata[288] */
    {  144, 0x000000009E3779B1ULL, 0x2221C4C0807FE0F4ULL }, /* XSUM_XXH64_testdata[289] */
    {  145, 0x0000000000000000ULL, 0x18F519801BB62003ULL }, /* XSUM_XXH64_testdata[290] */
    {  145, 0x000000009E3779B1ULL, 0x98022684CD4C5A22ULL }, /* XSUM_XXH64_testdata[291] */
    {  146, 0x0000000000000000ULL, 0x15C761F415F97578ULL }, /* XSUM_XXH64_testdata[292] */
    {  146, 0x000000009E3779B1ULL, 0xB193B77D0F63741CULL }, /* XSUM_XXH64_testdata[293] */
    {  147, 0x0000000000000000ULL, 0x4BA2A072E1FF588FULL }, /* XSUM_XXH64_testdata[294] */
    {  147, 0x000000009E3779B1ULL, 0xBF8E502C905E18F7ULL }, /* XSUM_XXH64_testdata[295] */
    {  148, 0x0000000000000000ULL, 0xF2E4CB94F60F07D2ULL }, /* XSUM_XXH64_testdata[296] */
    {  148, 0x000000009E3779B1ULL, 0x7838B9B817007E06ULL }, /* XSUM_XXH64_testdata[297] */
    {  149, 0x0000000000000000ULL, 0xAFBD86DEE66EFE56ULL }, /* XSUM_XXH64_testdata[298] */
    {  149, 0x000000009E3779B1ULL, 0xC39859A0DE79A89BULL }, /* XSUM_XXH64_testdata[299] */
    {  150, 0x0000000000000000ULL, 0xC1B4E21FDB2FECE6ULL }, /* XSUM_XXH64_testdata[300] */
    {  150, 0x000000009E3779B1ULL, 0xF1B1B1CDDB38FFC7ULL }, /* XSUM_XXH64_testdata[301] */
    {  151, 0x0000000000000000ULL, 0x4DDEA4A0F2AA9CF8ULL }, /* XSUM_XXH64_testdata[302] */
    {  151, 0x000000009E3779B1ULL, 0xDA1F611EB1C2BE56ULL }, /* XSUM_XXH64_testdata[303] */
    {  152, 0x0000000000000000ULL, 0x62A15F4D530A7EA5ULL }, /* XSUM_XXH64_testdata[304] */
    {  152, 0x000000009E3779B1ULL, 0x2F0F73C639D3BAB3ULL }, /* XSUM_XXH64_testdata[305] */
    {  153, 0x0000000000000000ULL, 0x9B84F22525275E62ULL }, /* XSUM_XXH64_testdata[306] */
    {  153, 0x000000009E3779B1ULL, 0x335D15302C3E1B23ULL }, /* XSUM_XXH64_testdata[307] */
    {  154, 0x0000000000000000ULL, 0x2EEB0441C9451B1FULL }, /* XSUM_XXH64_testdata[308] */
    {  154, 0x000000009E3779B1ULL, 0x97C17A5309E528DDULL }, /* XSUM_XXH64_testdata[309] */
    {  155, 0x0000000000000000ULL, 0x1DE7F80736C5FD1FULL }, /* XSUM_XXH64_testdata[310] */
    {  155, 0x000000009E3779B1ULL, 0x122D55162B11AA70ULL }, /* XSUM_XXH64_testdata[311] */
    {  156, 0x0000000000000000ULL, 0x73745EC8FDABF21CULL }, /* XSUM_XXH64_testdata[312] */
    {  156, 0x000000009E3779B1ULL, 0x4B29B9C80C11731EULL }, /* XSUM_XXH64_testdata[313] */
    {  157, 0x0000000000000000ULL, 0x8A2890AE42E4DBC0ULL }, /* XSUM_XXH64_testdata[314] */
    {  157, 0x000000009E3779B1ULL, 0x606C98DA0FFF5E99ULL }, /* XSUM_XXH64_testdata[315] */
    {  158, 0x0000000000000000ULL, 0x6B4F62CFF8A43B80ULL }, /* XSUM_XXH64_testdata[316] */
    {  158, 0x000000009E3779B1ULL, 0x71974C55ACE70505ULL }, /* XSUM_XXH64_testdata[317] */
    {  159, 0x0000000000000000ULL, 0x5E02EFAF7ACDF19CULL }, /* XSUM_XXH64_testdata[318] */
    {  159, 0x000000009E3779B1ULL, 0x0981A09CBBBEADFDULL }, /* XSUM_XXH64_testdata[319] */
    {  160, 0x0000000000000000ULL, 0x5B11EFE8DE350A3BULL }, /* XSUM_XXH64_testdata[320] */
    {  160, 0x000000009E3779B1ULL, 0x96C22CBA2A6BC16FULL }, /* XSUM_XXH64_testdata[321] */
    {  161, 0x0000000000000000ULL, 0xAD813CA7B0D54781ULL }, /* XSUM_XXH64_testdata[322] */
    {  161, 0x000000009E3779B1ULL, 0xF782F5A5F3183FC5ULL }, /* XSUM_XXH64_testdata[323] */
    {  162, 0x0000000000000000ULL, 0xD2EC094A8B3CA48FULL }, /* XSUM_XXH64_testdata[324] */
    {  162, 0x000000009E3779B1ULL, 0x6DE21A60EE5C4ED9ULL }, /* XSUM_XXH64_testdata[325] */
    {  163, 0x0000000000000000ULL, 0x4BF3D48D5ACBF6ACULL }, /* XSUM_XXH64_testdata[326] */
    {  163, 0x000000009E3779B1ULL, 0x3A4037A4F77B80F7ULL }, /* XSUM_XXH64_testdata[327] */
    {  164, 0x0000000000000000ULL, 0xE41F05B876F996E6ULL }, /* XSUM_XXH64_testdata[328] */
    {  164, 0x000000009E3779B1ULL, 0xDF59454C354263C0ULL }, /* XSUM_XXH64_testdata[329] */
    {  165, 0x0000000000000000ULL, 0x46C8500698B33143ULL }, /* XSUM_XXH64_testdata[330] */
    {  165, 0x000000009E3779B1ULL, 0xE61470FE106DAEB6ULL }, /* XSUM_XXH64_testdata[331] */
    {  166, 0x0000000000000000ULL, 0x1FF837B89DFF74C6ULL }, /* XSUM_XXH64_testdata[332] */
    {  166, 0x000000009E3779B1ULL, 0x35EF16A3CAB6DBD8ULL }, /* XSUM_XXH64_testdata[333] */
    {  167, 0x0000000000000000ULL, 0x8A9FE53D0989B9DBULL }, /* XSUM_XXH64_testdata[334] */
    {  167, 0x000000009E3779B1ULL, 0xF09AA4A5D0C8946AULL }, /* XSUM_XXH64_testdata[335] */
    {  168, 0x0000000000000000ULL, 0x1AED20C477BA590AULL }, /* XSUM_XXH64_testdata[336] */
    {  168, 0x000000009E3779B1ULL, 0xC4AF5415867E8187ULL }, /* XSUM_XXH64_testdata[337] */
    {  169, 0x0000000000000000ULL, 0x5678A561F39E4B7FULL }, /* XSUM_XXH64_testdata[338] */
    {  169, 0x000000009E3779B1ULL, 0x79174EB2FCB8E1B5ULL }, /* XSUM_XXH64_testdata[339] */
    {  170, 0x0000000000000000ULL, 0x07BC9808A99E91CCULL }, /* XSUM_XXH64_testdata[340] */
    {  170, 0x000000009E3779B1ULL, 0xA34F995ABD6E23E9ULL }, /* XSUM_XXH64_testdata[341] */
    {  171, 0x0000000000000000ULL, 0x1A1E7EFCFC5A377FULL }, /* XSUM_XXH64_testdata[342] */
    {  171, 0x000000009E3779B1ULL, 0xD47735EC5421D191ULL }, /* XSUM_XXH64_testdata[343] */
    {  172, 0x0000000000000000ULL, 0x625449E505BB4352ULL }, /* XSUM_XXH64_testdata[344] */
    {  172, 0x000000009E3779B1ULL, 0xCBB1E8F887B1A5E1ULL }, /* XSUM_XXH64_testdata[345] */
    {  173, 0x0000000000000000ULL, 0x16D6028DF84F9C3FULL }, /* XSUM_XXH64_testdata[346] */
    {  173, 0x000000009E3779B1ULL, 0xB0635E32B423501EULL }, /* XSUM_XXH64_testdata[347] */
    {  174, 0x0000000000000000ULL, 0x10902519949F206EULL }, /* XSUM_XXH64_testdata[348] */
    {  174, 0x000000009E3779B1ULL, 0xC39AFB66FBA93BE8ULL }, /* XSUM_XXH64_testdata[349] */
    {  175, 0x0000000000000000ULL, 0x8B8F04B20E8F9322ULL }, /* XSUM_XXH64_testdata[350] */
    {  175, 0x000000009E3779B1ULL, 0xD54B025F1F25CBA5ULL }, /* XSUM_XXH64_testdata[351] */
    {  176, 0x0000000000000000ULL, 0xDF9F79B4EA272F55ULL }, /* XSUM_XXH64_testdata[352] */
    {  176, 0x000000009E3779B1ULL, 0xBEB6CC6C04783A4DULL }, /* XSUM_XXH64_testdata[353] */
    {  177, 0x0000000000000000ULL, 0x05E8B1B61DBD0B71ULL }, /* XSUM_XXH64_testdata[354] */
    {  177, 0x000000009E3779B1ULL, 0xD71F05251A958C88ULL }, /* XSUM_XXH64_testdata[355] */
    {  178, 0x0000000000000000ULL, 0xA046B4F8050FF19FULL }, /* XSUM_XXH64_testdata[356] */
    {  178, 0x000000009E3779B1ULL, 0xF01A6ADA9BB9BB7FULL }, /* XSUM_XXH64_testdata[357] */
    {  179, 0x0000000000000000ULL, 0xC3C9B9967B78F65EULL }, /* XSUM_XXH64_testdata[358] */
    {  179, 0x000000009E3779B1ULL, 0x1766738809D8F120ULL }, /* XSUM_XXH64_testdata[359] */
    {  180, 0x0000000000000000ULL, 0x07557C6E01438898ULL }, /* XSUM_XXH64_testdata[360] */
    {  180, 0x000000009E3779B1ULL, 0xFFE5FEAB5B3B9BFDULL }, /* XSUM_XXH64_testdata[361] */
    {  181, 0x0000000000000000ULL, 0x8EB6B9EA889592E4ULL }, /* XSUM_XXH64_testdata[362] */
    {  181, 0x000000009E3779B1ULL, 0x1CB0DBF962768311ULL }, /* XSUM_XXH64_testdata[363] */
    {  182, 0x0000000000000000ULL, 0xB563B680EAF93D1CULL }, /* XSUM_XXH64_testdata[364] */
    {  182, 0x000000009E3779B1ULL, 0x8096F4E5CDAB3BA8ULL }, /* XSUM_XXH64_testdata[365] */
    {  183, 0x0000000000000000ULL, 0xDC0A598546EEF8D5ULL }, /* XSUM_XXH64_testdata[366] */
    {  183, 0x000000009E3779B1ULL, 0x6FE275B936FF8655ULL }, /* XSUM_XXH64_testdata[367] */
    {  184, 0x0000000000000000ULL, 0x3DEAE67F2AF3D038ULL }, /* XSUM_XXH64_testdata[368] */
    {  184, 0x000000009E3779B1ULL, 0xBF37C0A167A2A840ULL }, /* XSUM_XXH64_testdata[369] */
    {  185, 0x0000000000000000ULL, 0xDFF0E8388895A23EULL }, /* XSUM_XXH64_testdata[370] */
    {  185, 0x000000009E3779B1ULL, 0x36B6AF6C692E8CB9ULL }, /* XSUM_XXH64_testdata[371] */
    {  186, 0x0000000000000000ULL, 0x984EF85C5A5328F2ULL }, /* XSUM_XXH64_testdata[372] */
    {  186, 0x000000009E3779B1ULL, 0x2245AB8648BF626AULL }, /* XSUM_XXH64_testdata[373] */
    {  187, 0x0000000000000000ULL, 0xFDAD135D4A190C32ULL }, /* XSUM_XXH64_testdata[374] */
    {  187, 0x000000009E3779B1ULL, 0xD5C57A08C7C4BD87ULL }, /* XSUM_XXH64_testdata[375] */
    {  188, 0x0000000000000000ULL, 0x891447ACCCE59C8AULL }, /* XSUM_XXH64_testdata[376] */
    {  188, 0x000000009E3779B1ULL, 0xFC5497CD2A840F45ULL }, /* XSUM_XXH64_testdata[377] */
    {  189, 0x0000000000000000ULL, 0x3C44BB5E8E0B8C55ULL }, /* XSUM_XXH64_testdata[378] */
    {  189, 0x000000009E3779B1ULL, 0x918834CE94A648BAULL }, /* XSUM_XXH64_testdata[379] */
    {  190, 0x0000000000000000ULL, 0xA6479C9DDC0E5E00ULL }, /* XSUM_XXH64_testdata[380] */
    {  190, 0x000000009E3779B1ULL, 0x6A01F0D349AAD4D3ULL }, /* XSUM_XXH64_testdata[381] */
    {  191, 0x0000000000000000ULL, 0xF8329DA3AD4249E8ULL }, /* XSUM_XXH64_testdata[382] */
    {  191, 0x000000009E3779B1ULL, 0xE9CCF0337B2F9F6CULL }, /* XSUM_XXH64_testdata[383] */
    {  192, 0x0000000000000000ULL, 0xB76A434AC1E4768BULL }, /* XSUM_XXH64_testdata[384] */
    {  192, 0x000000009E3779B1ULL, 0xC12D08F273988FD5ULL }, /* XSUM_XXH64_testdata[385] */
    {  193, 0x0000000000000000ULL, 0x2CDF52488C4A2F81ULL }, /* XSUM_XXH64_testdata[386] */
    {  193, 0x000000009E3779B1ULL, 0x863D55C54A8D3ED1ULL }, /* XSUM_XXH64_testdata[387] */
    {  194, 0x0000000000000000ULL, 0x46A382CC7B5D8281ULL }, /* XSUM_XXH64_testdata[388] */
    {  194, 0x000000009E3779B1ULL, 0xFD7645CA691DFB7DULL }, /* XSUM_XXH64_testdata[389] */
    {  195, 0x0000000000000000ULL, 0x52B73ECDB3EF30E4ULL }, /* XSUM_XXH64_testdata[390] */
    {  195, 0x000000009E3779B1ULL, 0x9159A6288CD2ED9CULL }, /* XSUM_XXH64_testdata[391] */
    {  196, 0x0000000000000000ULL, 0xEB9ACBEFC9258D5CULL }, /* XSUM_XXH64_testdata[392] */
    {  196, 0x000000009E3779B1ULL, 0x935F16E68F6BD8EDULL }, /* XSUM_XXH64_testdata[393] */
    {  197, 0x0000000000000000ULL, 0x3356A9D81CFB5929ULL }, /* XSUM_XXH64_testdata[394] */
    {  197, 0x000000009E3779B1ULL, 0xDDAB613134C2333BULL }, /* XSUM_XXH64_testdata[395] */
    {  198, 0x0000000000000000ULL, 0xE781C3C6402BEA01ULL }, /* XSUM_XXH64_testdata[396] */
    {  198, 0x000000009E3779B1ULL, 0xF453BBAFAC16D837ULL }, /* XSUM_XXH64_testdata[397] */
    {  199, 0x0000000000000000ULL, 0xE37FEF4496509A87ULL }, /* XSUM_XXH64_testdata[398] */
    {  199, 0x000000009E3779B1ULL, 0xCC30E66C6A06D8F7ULL }, /* XSUM_XXH64_testdata[399] */
    {  200, 0x0000000000000000ULL, 0x4D863378A2052D65ULL }, /* XSUM_XXH64_testdata[400] */
    {  200, 0x000000009E3779B1ULL, 0x254AF7CA5C98A77EULL }, /* XSUM_XXH64_testdata[401] */
    {  201, 0x0000000000000000ULL, 0xF24E8A1EFDFF290CULL }, /* XSUM_XXH64_testdata[402] */
    {  201, 0x000000009E3779B1ULL, 0xB8D8C9E545CE2F59ULL }, /* XSUM_XXH64_testdata[403] */
    {  202, 0x0000000000000000ULL, 0x5C98EE8DFA4EFCBFULL }, /* XSUM_XXH64_testdata[404] */
    {  202, 0x000000009E3779B1ULL, 0x46517A8D9B9B7E59ULL }, /* XSUM_XXH64_testdata[405] */
    {  203, 0x0000000000000000ULL, 0x836063377C48824AULL }, /* XSUM_XXH64_testdata[406] */
    {  203, 0x000000009E3779B1ULL, 0x190AF984AAAAF457ULL }, /* XSUM_XXH64_testdata[407] */
    {  204, 0x0000000000000000ULL, 0xAAB407230B8C829CULL }, /* XSUM_XXH64_testdata[408] */
    {  204, 0x000000009E3779B1ULL, 0x8649C4337A9C12D8ULL }, /* XSUM_XXH64_testdata[409] */
    {  205, 0x0000000000000000ULL, 0xAFA6E4AA2AE03314ULL }, /* XSUM_XXH64_testdata[410] */
    {  205, 0x000000009E3779B1ULL, 0xFDB87A419B4094E3ULL }, /* XSUM_XXH64_testdata[411] */
    {  206, 0x0000000000000000ULL, 0xB258FED114D4FBE6ULL }, /* XSUM_XXH64_testdata[412] */
    {  206, 0x000000009E3779B1ULL, 0x2D3CA3EE5D2578C4ULL }, /* XSUM_XXH64_testdata[413] */
    {  207, 0x0000000000000000ULL, 0xC7054B982C73EB13ULL }, /* XSUM_XXH64_testdata[414] */
    {  207, 0x000000009E3779B1ULL, 0x4E0E7EA5A365B668ULL }, /* XSUM_XXH64_testdata[415] */
    {  208, 0x0000000000000000ULL, 0x9EB4B1067F96C311ULL }, /* XSUM_XXH64_testdata[416] */
    {  208, 0x000000009E3779B1ULL, 0x0DD3A0B6D0D0B379ULL }, /* XSUM_XXH64_testdata[417] */
    {  209, 0x0000000000000000ULL, 0x7344195C54279951ULL }, /* XSUM_XXH64_testdata[418] */
    {  209, 0x000000009E3779B1ULL, 0xFBB6E34768AF7349ULL }, /* XSUM_XXH64_testdata[419] */
    {  210, 0x0000000000000000ULL, 0x84812698B4B8BF44ULL }, /* XSUM_XXH64_testdata[420] */
    {  210, 0x000000009E3779B1ULL, 0xC18DC56C45886E5DULL }, /* XSUM_XXH64_testdata[421] */
    {  211, 0x0000000000000000ULL, 0x821B3108CD99A5A8ULL }, /* XSUM_XXH64_testdata[422] */
    {  211, 0x000000009E3779B1ULL, 0x33019E48E1DAFCCCULL }, /* XSUM_XXH64_testdata[423] */
    {  212, 0x0000000000000000ULL, 0x8E8E68151D5E419DULL }, /* XSUM_XXH64_testdata[424] */
    {  212, 0x000000009E3779B1ULL, 0x6366BDDFF5532071ULL }, /* XSUM_XXH64_testdata[425] */
    {  213, 0x0000000000000000ULL, 0xFD0B5E2A5921C14AULL }, /* XSUM_XXH64_testdata[426] */
    {  213, 0x000000009E3779B1ULL, 0xA064370AB08A06A3ULL }, /* XSUM_XXH64_testdata[427] */
    {  214, 0x0000000000000000ULL, 0x87FA20EB6126D0CCULL }, /* XSUM_XXH64_testdata[428] */
    {  214, 0x000000009E3779B1ULL, 0xC98AF5F597B2D97EULL }, /* XSUM_XXH64_testdata[429] */
    {  215, 0x0000000000000000ULL, 0xA38BDC1F221B4DDCULL }, /* XSUM_XXH64_testdata[430] */
    {  215, 0x000000009E3779B1ULL, 0x6A97D20B094B06CAULL }, /* XSUM_XXH64_testdata[431] */
    {  216, 0x0000000000000000ULL, 0xD997AAAE88AE9C5FULL }, /* XSUM_XXH64_testdata[432] */
    {  216, 0x000000009E3779B1ULL, 0xCAAB4027894BCCB2ULL }, /* XSUM_XXH64_testdata[433] */
    {  217, 0x0000000000000000ULL, 0x8E031800E9DE75D5ULL }, /* XSUM_XXH64_testdata[434] */
    {  217, 0x000000009E3779B1ULL, 0x5C20B9E6594A579EULL }, /* XSUM_XXH64_testdata[435] */
    {  218, 0x0000000000000000ULL, 0x2EE2208AE332E79DULL }, /* XSUM_XXH64_testdata[436] */
    {  218, 0x000000009E3779B1ULL, 0xAAF5F7238DDF1EE6ULL }, /* XSUM_XXH64_testdata[437] */
    {  219, 0x0000000000000000ULL, 0x21B874601A4DAC92ULL }, /* XSUM_XXH64_testdata[438] */
    {  219, 0x000000009E3779B1ULL, 0x0DD13A547AAB12B7ULL }, /* XSUM_XXH64_testdata[439] */
    {  220, 0x0000000000000000ULL, 0xB44A85B423E04207ULL }, /* XSUM_XXH64_testdata[440] */
    {  220, 0x000000009E3779B1ULL, 0x959091592F4A6B26ULL }, /* XSUM_XXH64_testdata[441] */
    {  221, 0x0000000000000000ULL, 0x7C8CB92ECFE982DCULL }, /* XSUM_XXH64_testdata[442] */
    {  221, 0x000000009E3779B1ULL, 0xBE6B813AF6B8657CULL }, /* XSUM_XXH64_testdata[443] */
    {  222, 0x0000000000000000ULL, 0xB641AE8CB691C174ULL }, /* XSUM_XXH64_testdata[444] */
    {  222, 0x000000009E3779B1ULL, 0x20CB8AB7AE10C14AULL }, /* XSUM_XXH64_testdata[445] */
    {  223, 0x0000000000000000ULL, 0x3204FA238CB7A119ULL }, /* XSUM_XXH64_testdata[446] */
    {  223, 0x000000009E3779B1ULL, 0x6976AE81215D0A31ULL }, /* XSUM_XXH64_testdata[447] */
    {  224, 0x0000000000000000ULL, 0x560A22F68D44BAA4ULL }, /* XSUM_XXH64_testdata[448] */
    {  224, 0x000000009E3779B1ULL, 0xCE6601FBB696A3CBULL }, /* XSUM_XXH64_testdata[449] */
    {  225, 0x0000000000000000ULL, 0x26034ED8D4CAE4DCULL }, /* XSUM_XXH64_testdata[450] */
    {  225, 0x000000009E3779B1ULL, 0x7721221845330B35ULL }, /* XSUM_XXH64_testdata[451] */
    {  226, 0x0000000000000000ULL, 0x6C44B98E3A56766FULL }, /* XSUM_XXH64_testdata[452] */
    {  226, 0x000000009E3779B1ULL, 0xBA55D8AAECB6D3F7ULL }, /* XSUM_XXH64_testdata[453] */
    {  227, 0x0000000000000000ULL, 0x84D9943F84B3F48CULL }, /* XSUM_XXH64_testdata[454] */
    {  227, 0x000000009E3779B1ULL, 0xA1EA6FD991AB6CAFULL }, /* XSUM_XXH64_testdata[455] */
    {  228, 0x0000000000000000ULL, 0x07FBF61C952C73A0ULL }, /* XSUM_XXH64_testdata[456] */
    {  228, 0x000000009E3779B1ULL, 0x2D1ADCE3A026DB2AULL }, /* XSUM_XXH64_testdata[457] */
    {  229, 0x0000000000000000ULL, 0x7650089C595D1589ULL }, /* XSUM_XXH64_testdata[458] */
    {  229, 0x000000009E3779B1ULL, 0x39EABB22FCAE07B7ULL }, /* XSUM_XXH64_testdata[459] */
    {  230, 0x0000000000000000ULL, 0xA6E2C789AE523788ULL }, /* XSUM_XXH64_testdata[460] */
    {  230, 0x000000009E3779B1ULL, 0x75964501197A7C29ULL }, /* XSUM_XXH64_testdata[461] */
    {  231, 0x0000000000000000ULL, 0x1678FC0F21A2D189ULL }, /* XSUM_XXH64_testdata[462] */
    {  231, 0x000000009E3779B1ULL, 0xC90DE1DD55859773ULL }, /* XSUM_XXH64_testdata[463] */
    {  232, 0x0000000000000000ULL, 0x08837FC18CF9DC21ULL }, /* XSUM_XXH64_testdata[464] */
    {  232, 0x000000009E3779B1ULL, 0x7ED72B5DAD65C52FULL }, /* XSUM_XXH64_testdata[465] */
    {  233, 0x0000000000000000ULL, 0x2B8CBB3C1BE4B134ULL }, /* XSUM_XXH64_testdata[466] */
    {  233, 0x000000009E3779B1ULL, 0x52A41D95CE99F400ULL }, /* XSUM_XXH64_testdata[467] */
    {  234, 0x0000000000000000ULL, 0x48502CC375AEDE41ULL }, /* XSUM_XXH64_testdata[468] */
    {  234, 0x000000009E3779B1ULL, 0x2D3525D1960F2D21ULL }, /* XSUM_XXH64_testdata[469] */
    {  235, 0x0000000000000000ULL, 0xC9136721158E47F6ULL }, /* XSUM_XXH64_testdata[470] */
    {  235, 0x000000009E3779B1ULL, 0x777C310AFC011284ULL }, /* XSUM_XXH64_testdata[471] */
    {  236, 0x0000000000000000ULL, 0x6252A7317AF95FD4ULL }, /* XSUM_XXH64_testdata[472] */
    {  236, 0x000000009E3779B1ULL, 0xD4B0539A256E0DB4ULL }, /* XSUM_XXH64_testdata[473] */
    {  237, 0x0000000000000000ULL, 0x6FD0AAE0666C5A27ULL }, /* XSUM_XXH64_testdata[474] */
    {  237, 0x000000009E3779B1ULL, 0x23E7D04D7E99A2B7ULL }, /* XSUM_XXH64_testdata[475] */
    {  238, 0x0000000000000000ULL, 0x0C2CE719985CD28CULL }, /* XSUM_XXH64_testdata[476] */
    {  238, 0x000000009E3779B1ULL, 0xCD34C05EA95F2F61ULL }, /* XSUM_XXH64_testdata[477] */
    {  239, 0x0000000000000000ULL, 0xB93713464372DA03ULL }, /* XSUM_XXH64_testdata[478] */
    {  239, 0x000000009E3779B1ULL, 0x4BFC609CBFAEED9BULL }, /* XSUM_XXH64_testdata[479] */
    {  240, 0x0000000000000000ULL, 0xB81838D483BAEE53ULL }, /* XSUM_XXH64_testdata[480] */
    {  240, 0x000000009E3779B1ULL, 0xA4B3F965B6FE67F8ULL }, /* XSUM_XXH64_testdata[481] */
    {  241, 0x0000000000000000ULL, 0x95D76C8B4D8FC4D6ULL }, /* XSUM_XXH64_testdata[482] */
    {  241, 0x000000009E3779B1ULL, 0x19D5AD5F4BD6CB9FULL }, /* XSUM_XXH64_testdata[483] */
    {  242, 0x0000000000000000ULL, 0xF90D9317A58AACCAULL }, /* XSUM_XXH64_testdata[484] */
    {  242, 0x000000009E3779B1ULL, 0x2B3D64CA68F954F6ULL }, /* XSUM_XXH64_testdata[485] */
    {  243, 0x0000000000000000ULL, 0xDA027E06C3DAAC3FULL }, /* XSUM_XXH64_testdata[486] */
    {  243, 0x000000009E3779B1ULL, 0xD36ED0285CC2C704ULL }, /* XSUM_XXH64_testdata[487] */
    {  244, 0x0000000000000000ULL, 0x3DA619F5D6E8F158ULL }, /* XSUM_XXH64_testdata[488] */
    {  244, 0x000000009E3779B1ULL, 0x10CD0F2DB5B8EDFFULL }, /* XSUM_XXH64_testdata[489] */
    {  245, 0x0000000000000000ULL, 0x711082146B76E24FULL }, /* XSUM_XXH64_testdata[490] */
    {  245, 0x000000009E3779B1ULL, 0xD24594468B28F2D1ULL }, /* XSUM_XXH64_testdata[491] */
    {  246, 0x0000000000000000ULL, 0x598FBCF46F00187FULL }, /* XSUM_XXH64_testdata[492] */
    {  246, 0x000000009E3779B1ULL, 0xBE543D6D5301F479ULL }, /* XSUM_XXH64_testdata[493] */
    {  247, 0x0000000000000000ULL, 0x9E1B0082378B40CDULL }, /* XSUM_XXH64_testdata[494] */
    {  247, 0x000000009E3779B1ULL, 0x1CC20CEC10C69CE0ULL }, /* XSUM_XXH64_testdata[495] */
    {  248, 0x0000000000000000ULL, 0x6C8D0BD0802CEE09ULL }, /* XSUM_XXH64_testdata[496] */
    {  248, 0x000000009E3779B1ULL, 0xE4E00E9C08E9D9BEULL }, /* XSUM_XXH64_testdata[497] */
    {  249, 0x0000000000000000ULL, 0x902EECCB98DB38D7ULL }, /* XSUM_XXH64_testdata[498] */
    {  249, 0x000000009E3779B1ULL, 0x826F17162AAE3546ULL }, /* XSUM_XXH64_testdata[499] */
    {  250, 0x0000000000000000ULL, 0x98733C2D429FF9EEULL }, /* XSUM_XXH64_testdata[500] */
    {  250, 0x000000009E3779B1ULL, 0xC00A5A94ADD5C591ULL }, /* XSUM_XXH64_testdata[501] */
    {  251, 0x0000000000000000ULL, 0xD278B54D9FEC3B13ULL }, /* XSUM_XXH64_testdata[502] */
    {  251, 0x000000009E3779B1ULL, 0x22E6DA603138549CULL }, /* XSUM_XXH64_testdata[503] */
    {  252, 0x0000000000000000ULL, 0x502316D885591F05ULL }, /* XSUM_XXH64_testdata[504] */
    {  252, 0x000000009E3779B1ULL, 0x365C19466B1CE6F6ULL }, /* XSUM_XXH64_testdata[505] */
    {  253, 0x0000000000000000ULL, 0x4F27F34D5F7363B4ULL }, /* XSUM_XXH64_testdata[506] */
    {  253, 0x000000009E3779B1ULL, 0x6598472FCB3C9FDDULL }, /* XSUM_XXH64_testdata[507] */
    {  254, 0x0000000000000000ULL, 0xA8FA70BEAF15A0D5ULL }, /* XSUM_XXH64_testdata[508] */
    {  254, 0x000000009E3779B1ULL, 0xA3D08118E33A36FBULL }, /* XSUM_XXH64_testdata[509] */
    {  255, 0x0000000000000000ULL, 0xA80F35BB0DC8E3A7ULL }, /* XSUM_XXH64_testdata[510] */
    {  255, 0x000000009E3779B1ULL, 0x8E7A59762640754FULL }, /* XSUM_XXH64_testdata[511] */
    {  256, 0x0000000000000000ULL, 0x5E3F5BF94D574981ULL }, /* XSUM_XXH64_testdata[512] */
    {  256, 0x000000009E3779B1ULL, 0x34733CBD9CC1B0D5ULL }, /* XSUM_XXH64_testdata[513] */
    {  257, 0x0000000000000000ULL, 0xD36CF327DCF12221ULL }, /* XSUM_XXH64_testdata[514] */
    {  257, 0x000000009E3779B1ULL, 0x0E59955420F8807BULL }, /* XSUM_XXH64_testdata[515] */
    {  258, 0x0000000000000000ULL, 0x800D25DAF5B3E79DULL }, /* XSUM_XXH64_testdata[516] */
    {  258, 0x000000009E3779B1ULL, 0xE72AEBE1FEAA93EEULL }, /* XSUM_XXH64_testdata[517] */
    {  259, 0x0000000000000000ULL, 0x2099FA654952427CULL }, /* XSUM_XXH64_testdata[518] */
    {  259, 0x000000009E3779B1ULL, 0xBB868FAB515A5C72ULL }, /* XSUM_XXH64_testdata[519] */
    {  260, 0x0000000000000000ULL, 0xCF364A2C3982921FULL }, /* XSUM_XXH64_testdata[520] */
    {  260, 0x000000009E3779B1ULL, 0x1731084B861DFD5DULL }, /* XSUM_XXH64_testdata[521] */
    {  261, 0x0000000000000000ULL, 0x97105F1DC4406772ULL }, /* XSUM_XXH64_testdata[522] */
    {  261, 0x000000009E3779B1ULL, 0xC8574A38FBEA058EULL }, /* XSUM_XXH64_testdata[523] */
    {  262, 0x0000000000000000ULL, 0xE71A640DCC730EC5ULL }, /* XSUM_XXH64_testdata[524] */
    {  262, 0x000000009E3779B1ULL, 0x7F76151B92A28B07ULL }, /* XSUM_XXH64_testdata[525] */
    {  263, 0x0000000000000000ULL, 0xB872B62D16AE5FEEULL }, /* XSUM_XXH64_testdata[526] */
    {  263, 0x000000009E3779B1ULL, 0x9E8A8BAC522A967AULL }, /* XSUM_XXH64_testdata[527] */
    {  264, 0x0000000000000000ULL, 0xC6937E5613AACCFEULL }, /* XSUM_XXH64_testdata[528] */
    {  264, 0x000000009E3779B1ULL, 0x7FE5F28BAC9B0E91ULL }, /* XSUM_XXH64_testdata[529] */
    {  265, 0x0000000000000000ULL, 0x12471155ADA2E18EULL }, /* XSUM_XXH64_testdata[530] */
    {  265, 0x000000009E3779B1ULL, 0xBE1A23BB9138EE34ULL }, /* XSUM_XXH64_testdata[531] */
    {  266, 0x0000000000000000ULL, 0x601C8089C5387DCEULL }, /* XSUM_XXH64_testdata[532] */
    {  266, 0x000000009E3779B1ULL, 0xC462F2DD5F793449ULL }, /* XSUM_XXH64_testdata[533] */
    {  267, 0x0000000000000000ULL, 0x1352BBD50D07866DULL }, /* XSUM_XXH64_testdata[534] */
    {  267, 0x000000009E3779B1ULL, 0x234608404DFCB571ULL }, /* XSUM_XXH64_testdata[535] */
    {  268, 0x0000000000000000ULL, 0x04882F6EC3504AEEULL }, /* XSUM_XXH64_testdata[536] */
    {  268, 0x000000009E3779B1ULL, 0xC746A0D7B2CAFC8DULL }, /* XSUM_XXH64_testdata[537] */
    {  269, 0x0000000000000000ULL, 0x663D2CCDC3DB5BC9ULL }, /* XSUM_XXH64_testdata[538] */
    {  269, 0x000000009E3779B1ULL, 0x1939299519486F59ULL }, /* XSUM_XXH64_testdata[539] */
    {  270, 0x0000000000000000ULL, 0x340E8B9B5C26CA95ULL }, /* XSUM_XXH64_testdata[540] */
    {  270, 0x000000009E3779B1ULL, 0x877F54E49EC58468ULL }, /* XSUM_XXH64_testdata[541] */
    {  271, 0x0000000000000000ULL, 0xB7BD56BC66F72DA9ULL }, /* XSUM_XXH64_testdata[542] */
    {  271, 0x000000009E3779B1ULL, 0x54D0A98978531FFBULL }, /* XSUM_XXH64_testdata[543] */
    {  272, 0x0000000000000000ULL, 0xF3977B31ADA68DD8ULL }, /* XSUM_XXH64_testdata[544] */
    {  272, 0x000000009E3779B1ULL, 0x887F590222AD2734ULL }, /* XSUM_XXH64_testdata[545] */
    {  273, 0x0000000000000000ULL, 0x2C18D3B96A486E0CULL }, /* XSUM_XXH64_testdata[546] */
    {  273, 0x000000009E3779B1ULL, 0x8258EA6B5E58AB4BULL }, /* XSUM_XXH64_testdata[547] */
    {  274, 0x0000000000000000ULL, 0x969C6033EE1AF2D4ULL }, /* XSUM_XXH64_testdata[548] */
    {  274, 0x000000009E3779B1ULL, 0x9490360BADD540EEULL }, /* XSUM_XXH64_testdata[549] */
    {  275, 0x0000000000000000ULL, 0x530A8F55ED7C10B3ULL }, /* XSUM_XXH64_testdata[550] */
    {  275, 0x000000009E3779B1ULL, 0x73D1E106641AA053ULL }, /* XSUM_XXH64_testdata[551] */
    {  276, 0x0000000000000000ULL, 0x5A25F6FF03024991ULL }, /* XSUM_XXH64_testdata[552] */
    {  276, 0x000000009E3779B1ULL, 0x8AB6A691AE70F34DULL }, /* XSUM_XXH64_testdata[553] */
    {  277, 0x0000000000000000ULL, 0xF3CA1E4C597206CCULL }, /* XSUM_XXH64_testdata[554] */
    {  277, 0x000000009E3779B1ULL, 0x0798F4E8A10FCE28ULL }, /* XSUM_XXH64_testdata[555] */
    {  278, 0x0000000000000000ULL, 0xCAAC375345392108ULL }, /* XSUM_XXH64_testdata[556] */
    {  278, 0x000000009E3779B1ULL, 0x5DFF0C04C19ADF91ULL }, /* XSUM_XXH64_testdata[557] */
    {  279, 0x0000000000000000ULL, 0xCF3E45285F4C5CA9ULL }, /* XSUM_XXH64_testdata[558] */
    {  279, 0x000000009E3779B1ULL, 0xDFD2B2FF6DD9FB76ULL }, /* XSUM_XXH64_testdata[559] */
    {  280, 0x0000000000000000ULL, 0xA41A5712EB1CC987ULL }, /* XSUM_XXH64_testdata[560] */
    {  280, 0x000000009E3779B1ULL, 0xF2486AE97DF0E3CEULL }, /* XSUM_XXH64_testdata[561] */
    {  281, 0x0000000000000000ULL, 0xED5A862D4541F940ULL }, /* XSUM_XXH64_testdata[562] */
    {  281, 0x000000009E3779B1ULL, 0xABE603FE4B35C536ULL }, /* XSUM_XXH64_testdata[563] */
    {  282, 0x0000000000000000ULL, 0xA867E8D706EBA08BULL }, /* XSUM_XXH64_testdata[564] */
    {  282, 0x000000009E3779B1ULL, 0x33CA320204412931ULL }, /* XSUM_XXH64_testdata[565] */
    {  283, 0x0000000000000000ULL, 0x10B0AA9588751826ULL }, /* XSUM_XXH64_testdata[566] */
    {  283, 0x000000009E3779B1ULL, 0x6EB2D706DA6DFEECULL }, /* XSUM_XXH64_testdata[567] */
    {  284, 0x0000000000000000ULL, 0x93AD619F2B351D3FULL }, /* XSUM_XXH64_testdata[568] */
    {  284, 0x000000009E3779B1ULL, 0x9A2AFEB1654E116BULL }, /* XSUM_XXH64_testdata[569] */
    {  285, 0x0000000000000000ULL, 0x7CD2577EA97A138AULL }, /* XSUM_XXH64_testdata[570] */
    {  285, 0x000000009E3779B1ULL, 0xEC346D3CD94C94EFULL }, /* XSUM_XXH64_testdata[571] */
    {  286, 0x0000000000000000ULL, 0x345637D13E12AE04ULL }, /* XSUM_XXH64_testdata[572] */
    {  286, 0x000000009E3779B1ULL, 0x15CE12FB9BBEBCC3ULL }, /* XSUM_XXH64_testdata[573] */
    {  287, 0x0000000000000000ULL, 0x92EFB98F22F668D0ULL }, /* XSUM_XXH64_testdata[574] */
    {  287, 0x000000009E3779B1ULL, 0x0FB316B3FA8B793AULL }, /* XSUM_XXH64_testdata[575] */
    {  288, 0x0000000000000000ULL, 0x319C1E822541C647ULL }, /* XSUM_XXH64_testdata[576] */
    {  288, 0x000000009E3779B1ULL, 0x9787CAEFEC335434ULL }, /* XSUM_XXH64_testdata[577] */
    {  289, 0x0000000000000000ULL, 0xF7E6D446C8EF7C47ULL }, /* XSUM_XXH64_testdata[578] */
    {  289, 0x000000009E3779B1ULL, 0x4A0A6E963C092DA4ULL }, /* XSUM_XXH64_testdata[579] */
    {  290, 0x0000000000000000ULL, 0x585D390D6FDEF06AULL }, /* XSUM_XXH64_testdata[580] */
    {  290, 0x000000009E3779B1ULL, 0xC6B32828386DA2E9ULL }, /* XSUM_XXH64_testdata[581] */
    {  291, 0x0000000000000000ULL, 0x21F05A66A9EB9A58ULL }, /* XSUM_XXH64_testdata[582] */
    {  291, 0x000000009E3779B1ULL, 0xD00817CB66D5CB2DULL }, /* XSUM_XXH64_testdata[583] */
    {  292, 0x0000000000000000ULL, 0xBC9224537B00F4B6ULL }, /* XSUM_XXH64_testdata[584] */
    {  292, 0x000000009E3779B1ULL, 0xF733A843A9ACA128ULL }, /* XSUM_XXH64_testdata[585] */
    {  293, 0x0000000000000000ULL, 0x5979A617929E48D0ULL }, /* XSUM_XXH64_testdata[586] */
    {  293, 0x000000009E3779B1ULL, 0x7C1017B8E9589375ULL }, /* XSUM_XXH64_testdata[587] */
    {  294, 0x0000000000000000ULL, 0x4946824DD663797AULL }, /* XSUM_XXH64_testdata[588] */
    {  294, 0x000000009E3779B1ULL, 0x0488AC62F9398C6FULL }, /* XSUM_XXH64_testdata[589] */
    {  295, 0x0000000000000000ULL, 0xD9AA3E6E5ED4D24DULL }, /* XSUM_XXH64_testdata[590] */
    {  295, 0x000000009E3779B1ULL, 0x159CEEF3E08C94F6ULL }, /* XSUM_XXH64_testdata[591] */
    {  296, 0x0000000000000000ULL, 0xCC06B4824EB0D11CULL }, /* XSUM_XXH64_testdata[592] */
    {  296, 0x000000009E3779B1ULL, 0xDD5CE847198C7FE1ULL }, /* XSUM_XXH64_testdata[593] */
    {  297, 0x0000000000000000ULL, 0x4DB8E56BE4E55AC4ULL }, /* XSUM_XXH64_testdata[594] */
    {  297, 0x000000009E3779B1ULL, 0x5C053B0CD2FA23A8ULL }, /* XSUM_XXH64_testdata[595] */
    {  298, 0x0000000000000000ULL, 0x694A1B6625D43319ULL }, /* XSUM_XXH64_testdata[596] */
    {  298, 0x000000009E3779B1ULL, 0x9048FE0F555AC1A7ULL }, /* XSUM_XXH64_testdata[597] */
    {  299, 0x0000000000000000ULL, 0xD2EB28971B0A6A92ULL }, /* XSUM_XXH64_testdata[598] */
    {  299, 0x000000009E3779B1ULL, 0x46FB015EDC4F13CEULL }, /* XSUM_XXH64_testdata[599] */
    {  300, 0x0000000000000000ULL, 0x27D0E073EC12824FULL }, /* XSUM_XXH64_testdata[600] */
    {  300, 0x000000009E3779B1ULL, 0x36CB189D9F3B6AD6ULL }, /* XSUM_XXH64_testdata[601] */
    {  301, 0x0000000000000000ULL, 0xC30B134412F5070FULL }, /* XSUM_XXH64_testdata[602] */
    {  301, 0x000000009E3779B1ULL, 0x779864C9F8A50F68ULL }, /* XSUM_XXH64_testdata[603] */
    {  302, 0x0000000000000000ULL, 0x806071550D0D3FD1ULL }, /* XSUM_XXH64_testdata[604] */
    {  302, 0x000000009E3779B1ULL, 0x56848E98C174FD5EULL }, /* XSUM_XXH64_testdata[605] */
    {  303, 0x0000000000000000ULL, 0xAE4B7555B7E934ABULL }, /* XSUM_XXH64_testdata[606] */
    {  303, 0x000000009E3779B1ULL, 0x8BE172D74D5D222EULL }, /* XSUM_XXH64_testdata[607] */
    {  304, 0x0000000000000000ULL, 0xCD9F47E076057508ULL }, /* XSUM_XXH64_testdata[608] */
    {  304, 0x000000009E3779B1ULL, 0x4CCFF45F9DEE4002ULL }, /* XSUM_XXH64_testdata[609] */
    {  305, 0x0000000000000000ULL, 0xC254B8F12F935411ULL }, /* XSUM_XXH64_testdata[610] */
    {  305, 0x000000009E3779B1ULL, 0x4D3FB6613D00FE12ULL }, /* XSUM_XXH64_testdata[611] */
    {  306, 0x0000000000000000ULL, 0x8025085C29EA30FCULL }, /* XSUM_XXH64_testdata[612] */
    {  306, 0x000000009E3779B1ULL, 0x75B4382E5391B03FULL }, /* XSUM_XXH64_testdata[613] */
    {  307, 0x0000000000000000ULL, 0xD8F8D06F0951E5BEULL }, /* XSUM_XXH64_testdata[614] */
    {  307, 0x000000009E3779B1ULL, 0xE6F3F862E8BBDA07ULL }, /* XSUM_XXH64_testdata[615] */
    {  308, 0x0000000000000000ULL, 0xD77A53671A5277DDULL }, /* XSUM_XXH64_testdata[616] */
    {  308, 0x000000009E3779B1ULL, 0xEFF507C34BD9988BULL }, /* XSUM_XXH64_testdata[617] */
    {  309, 0x0000000000000000ULL, 0x165D2435E023D1C2ULL }, /* XSUM_XXH64_testdata[618] */
    {  309, 0x000000009E3779B1ULL, 0x026DB09252D02941ULL }, /* XSUM_XXH64_testdata[619] */
    {  310, 0x0000000000000000ULL, 0x58942C7734E43C86ULL }, /* XSUM_XXH64_testdata[620] */
    {  310, 0x000000009E3779B1ULL, 0xEA5278E0A3CF506FULL }, /* XSUM_XXH64_testdata[621] */
    {  311, 0x0000000000000000ULL, 0xF09F13BD4FB740EBULL }, /* XSUM_XXH64_testdata[622] */
    {  311, 0x000000009E3779B1ULL, 0x9D3738BA96BB04F3ULL }, /* XSUM_XXH64_testdata[623] */
    {  312, 0x0000000000000000ULL, 0xE183DB6F48250246ULL }, /* XSUM_XXH64_testdata[624] */
    {  312, 0x000000009E3779B1ULL, 0x28FE2DF7C30D67C9ULL }, /* XSUM_XXH64_testdata[625] */
    {  313, 0x0000000000000000ULL, 0x68A5156112811C33ULL }, /* XSUM_XXH64_testdata[626] */
    {  313, 0x000000009E3779B1ULL, 0xDDC06A1B585C4789ULL }, /* XSUM_XXH64_testdata[627] */
    {  314, 0x0000000000000000ULL, 0xA13A1BEC2CD910E4ULL }, /* XSUM_XXH64_testdata[628] */
    {  314, 0x000000009E3779B1ULL, 0xBD6698A5440ABE1AULL }, /* XSUM_XXH64_testdata[629] */
    {  315, 0x0000000000000000ULL, 0xCC2808E72EAC151BULL }, /* XSUM_XXH64_testdata[630] */
    {  315, 0x000000009E3779B1ULL, 0x2746FA4F2A0F9416ULL }, /* XSUM_XXH64_testdata[631] */
    {  316, 0x0000000000000000ULL, 0xAFBC014DCE3257E2ULL }, /* XSUM_XXH64_testdata[632] */
    {  316, 0x000000009E3779B1ULL, 0x9BBD080ACAE33B5CULL }, /* XSUM_XXH64_testdata[633] */
    {  317, 0x0000000000000000ULL, 0x4324504321847E60ULL }, /* XSUM_XXH64_testdata[634] */
    {  317, 0x000000009E3779B1ULL, 0xEE59F87AF88DFE30ULL }, /* XSUM_XXH64_testdata[635] */
    {  318, 0x0000000000000000ULL, 0x4CBA36B197D9BC3FULL }, /* XSUM_XXH64_testdata[636] */
    {  318, 0x000000009E3779B1ULL, 0x1C789101AF5830C5ULL }, /* XSUM_XXH64_testdata[637] */
    {  319, 0x0000000000000000ULL, 0x2AE10520FA6DE2E4ULL }, /* XSUM_XXH64_testdata[638] */
    {  319, 0x000000009E3779B1ULL, 0x8410CB2FBE004576ULL }, /* XSUM_XXH64_testdata[639] */
    {  320, 0x0000000000000000ULL, 0xE770CC78CD4C49D4ULL }, /* XSUM_XXH64_testdata[640] */
    {  320, 0x000000009E3779B1ULL, 0x4652D88D496EE7ADULL }, /* XSUM_XXH64_testdata[641] */
    {  321, 0x0000000000000000ULL, 0x191E5FAA4E98D58CULL }, /* XSUM_XXH64_testdata[642] */
    {  321, 0x000000009E3779B1ULL, 0x3C28DB4679112EE5ULL }, /* XSUM_XXH64_testdata[643] */
    {  322, 0x0000000000000000ULL, 0xA10BF168FB663D3EULL }, /* XSUM_XXH64_testdata[644] */
    {  322, 0x000000009E3779B1ULL, 0x7606D121C819C6B6ULL }, /* XSUM_XXH64_testdata[645] */
    {  323, 0x0000000000000000ULL, 0xD397D1291236CF7FULL }, /* XSUM_XXH64_testdata[646] */
    {  323, 0x000000009E3779B1ULL, 0x1378631DC20BFF42ULL }, /* XSUM_XXH64_testdata[647] */
    {  324, 0x0000000000000000ULL, 0x6E1A465CA0B8D8BEULL }, /* XSUM_XXH64_testdata[648] */
    {  324, 0x000000009E3779B1ULL, 0xAFEF3035641946F9ULL }, /* XSUM_XXH64_testdata[649] */
    {  325, 0x0000000000000000ULL, 0x966AC1912DA3CD24ULL }, /* XSUM_XXH64_testdata[650] */
    {  325, 0x000000009E3779B1ULL, 0xD8AF365A4401EA55ULL }, /* XSUM_XXH64_testdata[651] */
    {  326, 0x0000000000000000ULL, 0x3DE3C5C8F6E0A0A1ULL }, /* XSUM_XXH64_testdata[652] */
    {  326, 0x000000009E3779B1ULL, 0x335FDF7E051D4A87ULL }, /* XSUM_XXH64_testdata[653] */
    {  327, 0x0000000000000000ULL, 0xE8AE29289DA7F119ULL }, /* XSUM_XXH64_testdata[654] */
    {  327, 0x000000009E3779B1ULL, 0x0F26E6096850CD15ULL }, /* XSUM_XXH64_testdata[655] */
    {  328, 0x0000000000000000ULL, 0x4C35F169173D834CULL }, /* XSUM_XXH64_testdata[656] */
    {  328, 0x000000009E3779B1ULL, 0x22762DF3D9B9DF31ULL }, /* XSUM_XXH64_testdata[657] */
    {  329, 0x0000000000000000ULL, 0x5D481C44947F7A73ULL }, /* XSUM_XXH64_testdata[658] */
    {  329, 0x000000009E3779B1ULL, 0x73E1E3B8E9F181BBULL }, /* XSUM_XXH64_testdata[659] */
    {  330, 0x0000000000000000ULL, 0xC0A08CEF0DD56B16ULL }, /* XSUM_XXH64_testdata[660] */
    {  330, 0x000000009E3779B1ULL, 0x6AA1FE1042A0F6A5ULL }, /* XSUM_XXH64_testdata[661] */
    {  331, 0x0000000000000000ULL, 0x0D4449FCD664BB45ULL }, /* XSUM_XXH64_testdata[662] */
    {  331, 0x000000009E3779B1ULL, 0x4296B5AEE7D960D4ULL }, /* XSUM_XXH64_testdata[663] */
    {  332, 0x0000000000000000ULL, 0x7529CB2646E8601CULL }, /* XSUM_XXH64_testdata[664] */
    {  332, 0x000000009E3779B1ULL, 0x70CDF1FAE1A878AFULL }, /* XSUM_XXH64_testdata[665] */
    {  333, 0x0000000000000000ULL, 0x8CFBC1AF9BD2A321ULL }, /* XSUM_XXH64_testdata[666] */
    {  333, 0x000000009E3779B1ULL, 0xF642F676F8CFF339ULL }, /* XSUM_XXH64_testdata[667] */
    {  334, 0x0000000000000000ULL, 0x616AC7C331B6A379ULL }, /* XSUM_XXH64_testdata[668] */
    {  334, 0x000000009E3779B1ULL, 0x8C29C7765F64AC97ULL }, /* XSUM_XXH64_testdata[669] */
    {  335, 0x0000000000000000ULL, 0x5C3A4577DF83FB01ULL }, /* XSUM_XXH64_testdata[670] */
    {  335, 0x000000009E3779B1ULL, 0x3CAD8492DFE500A4ULL }, /* XSUM_XXH64_testdata[671] */
    {  336, 0x0000000000000000ULL, 0x0D0983F796109E3DULL }, /* XSUM_XXH64_testdata[672] */
    {  336, 0x000000009E3779B1ULL, 0x06A6E12B6D47E200ULL }, /* XSUM_XXH64_testdata[673] */
    {  337, 0x0000000000000000ULL, 0x375888A1F50EDEE0ULL }, /* XSUM_XXH64_testdata[674] */
    {  337, 0x000000009E3779B1ULL, 0xBFF6310116784CE9ULL }, /* XSUM_XXH64_testdata[675] */
    {  338, 0x0000000000000000ULL, 0xA9B57EAD56662EECULL }, /* XSUM_XXH64_testdata[676] */
    {  338, 0x000000009E3779B1ULL, 0xEDFAA3154B5EE34BULL }, /* XSUM_XXH64_testdata[677] */
    {  339, 0x0000000000000000ULL, 0x818B61D1D857C97DULL }, /* XSUM_XXH64_testdata[678] */
    {  339, 0x000000009E3779B1ULL, 0x7B41B412D222608FULL }, /* XSUM_XXH64_testdata[679] */
    {  340, 0x0000000000000000ULL, 0x2F55039F446BA2DFULL }, /* XSUM_XXH64_testdata[680] */
    {  340, 0x000000009E3779B1ULL, 0x5EBDD5B7B6C5917BULL }, /* XSUM_XXH64_testdata[681] */
    {  341, 0x0000000000000000ULL, 0x836263DF89FE557DULL }, /* XSUM_XXH64_testdata[682] */
    {  341, 0x000000009E3779B1ULL, 0x12695533AB8FE708ULL }, /* XSUM_XXH64_testdata[683] */
    {  342, 0x0000000000000000ULL, 0x4A9263DB83996FA5ULL }, /* XSUM_XXH64_testdata[684] */
    {  342, 0x000000009E3779B1ULL, 0x0A34062AD2C76F1BULL }, /* XSUM_XXH64_testdata[685] */
    {  343, 0x0000000000000000ULL, 0xE40DE98BA957A505ULL }, /* XSUM_XXH64_testdata[686] */
    {  343, 0x000000009E3779B1ULL, 0x70506F583223C18CULL }, /* XSUM_XXH64_testdata[687] */
    {  344, 0x0000000000000000ULL, 0x08DEF25D96644105ULL }, /* XSUM_XXH64_testdata[688] */
    {  344, 0x000000009E3779B1ULL, 0x4D182E0D30243BFDULL }, /* XSUM_XXH64_testdata[689] */
    {  345, 0x0000000000000000ULL, 0x430A1250DDCFD26AULL }, /* XSUM_XXH64_testdata[690] */
    {  345, 0x000000009E3779B1ULL, 0x767C2332AE03BF1BULL }, /* XSUM_XXH64_testdata[691] */
    {  346, 0x0000000000000000ULL, 0x6DE8E7F8FC988E06ULL }, /* XSUM_XXH64_testdata[692] */
    {  346, 0x000000009E3779B1ULL, 0x6F0B8A6C503A5982ULL }, /* XSUM_XXH64_testdata[693] */
    {  347, 0x0000000000000000ULL, 0x6EBE56879F51960FULL }, /* XSUM_XXH64_testdata[694] */
    {  347, 0x000000009E3779B1ULL, 0x05F00C77B7FBCBCEULL }, /* XSUM_XXH64_testdata[695] */
    {  348, 0x0000000000000000ULL, 0xBCC17D27EF9C445AULL }, /* XSUM_XXH64_testdata[696] */
    {  348, 0x000000009E3779B1ULL, 0xAE5F3DEE5E85E080ULL }, /* XSUM_XXH64_testdata[697] */
    {  349, 0x0000000000000000ULL, 0x3B2F742FD0129AAEULL }, /* XSUM_XXH64_testdata[698] */
    {  349, 0x000000009E3779B1ULL, 0xEF74A89286BBE7F9ULL }, /* XSUM_XXH64_testdata[699] */
    {  350, 0x0000000000000000ULL, 0xCBF689D13535396EULL }, /* XSUM_XXH64_testdata[700] */
    {  350, 0x000000009E3779B1ULL, 0x06E946C3CFEE32A7ULL }, /* XSUM_XXH64_testdata[701] */
    {  351, 0x0000000000000000ULL, 0x5A8B9393DD9C54ECULL }, /* XSUM_XXH64_testdata[702] */
    {  351, 0x000000009E3779B1ULL, 0x6A1E24082412D6A4ULL }, /* XSUM_XXH64_testdata[703] */
    {  352, 0x0000000000000000ULL, 0x2C7A4C67DCF81AF3ULL }, /* XSUM_XXH64_testdata[704] */
    {  352, 0x000000009E3779B1ULL, 0x2C5D8C15D3D96C34ULL }, /* XSUM_XXH64_testdata[705] */
    {  353, 0x0000000000000000ULL, 0xDC132C498167B6C6ULL }, /* XSUM_XXH64_testdata[706] */
    {  353, 0x000000009E3779B1ULL, 0x0DBF72487E53B8B6ULL }, /* XSUM_XXH64_testdata[707] */
    {  354, 0x0000000000000000ULL, 0xA73CE21C9CC96F7DULL }, /* XSUM_XXH64_testdata[708] */
    {  354, 0x000000009E3779B1ULL, 0x1904A79793369265ULL }, /* XSUM_XXH64_testdata[709] */
    {  355, 0x0000000000000000ULL, 0xA7BCA484D8B42B9DULL }, /* XSUM_XXH64_testdata[710] */
    {  355, 0x000000009E3779B1ULL, 0x96FBEA063C7BA4F2ULL }, /* XSUM_XXH64_testdata[711] */
    {  356, 0x0000000000000000ULL, 0x361759F3E6F9EC99ULL }, /* XSUM_XXH64_testdata[712] */
    {  356, 0x000000009E3779B1ULL, 0x64D86C055445C97AULL }, /* XSUM_XXH64_testdata[713] */
    {  357, 0x0000000000000000ULL, 0x9BF1088365B88CA3ULL }, /* XSUM_XXH64_testdata[714] */
    {  357, 0x000000009E3779B1ULL, 0xA2B5B2F58A05693FULL }, /* XSUM_XXH64_testdata[715] */
    {  358, 0x0000000000000000ULL, 0x44AC7D4F4A0C26C8ULL }, /* XSUM_XXH64_testdata[716] */
    {  358, 0x000000009E3779B1ULL, 0x3F397BE0323EA4E0ULL }, /* XSUM_XXH64_testdata[717] */
    {  359, 0x0000000000000000ULL, 0x51C7C0F6CC75485FULL }, /* XSUM_XXH64_testdata[718] */
    {  359, 0x000000009E3779B1ULL, 0x04B53C70E8DBCC8BULL }, /* XSUM_XXH64_testdata[719] */
    {  360, 0x0000000000000000ULL, 0x312CECE43F5ACA33ULL }, /* XSUM_XXH64_testdata[720] */
    {  360, 0x000000009E3779B1ULL, 0x9AA901719AEEE25EULL }, /* XSUM_XXH64_testdata[721] */
    {  361, 0x0000000000000000ULL, 0xA2B589598EFBBD69ULL }, /* XSUM_XXH64_testdata[722] */
    {  361, 0x000000009E3779B1ULL, 0xC2CD9A769996D0E0ULL }, /* XSUM_XXH64_testdata[723] */
    {  362, 0x0000000000000000ULL, 0x04E4833AF8933BDAULL }, /* XSUM_XXH64_testdata[724] */
    {  362, 0x000000009E3779B1ULL, 0xE6B3E1DCCA12DF05ULL }, /* XSUM_XXH64_testdata[725] */
    {  363, 0x0000000000000000ULL, 0xC84FCB24B5A21862ULL }, /* XSUM_XXH64_testdata[726] */
    {  363, 0x000000009E3779B1ULL, 0x4B89934B473558EBULL }, /* XSUM_XXH64_testdata[727] */
    {  364, 0x0000000000000000ULL, 0xF7471F5A29253EF2ULL }, /* XSUM_XXH64_testdata[728] */
    {  364, 0x000000009E3779B1ULL, 0x6CEBAFE4C3BDCD21ULL }, /* XSUM_XXH64_testdata[729] */
    {  365, 0x0000000000000000ULL, 0xC97282DCCFD2AC9EULL }, /* XSUM_XXH64_testdata[730] */
    {  365, 0x000000009E3779B1ULL, 0xFFA92422FC37582DULL }, /* XSUM_XXH64_testdata[731] */
    {  366, 0x0000000000000000ULL, 0x34ADF90A87D9BB7DULL }, /* XSUM_XXH64_testdata[732] */
    {  366, 0x000000009E3779B1ULL, 0xAE168FF3C354DA52ULL }, /* XSUM_XXH64_testdata[733] */
    {  367, 0x0000000000000000ULL, 0x3865884F1F2DBBB2ULL }, /* XSUM_XXH64_testdata[734] */
    {  367, 0x000000009E3779B1ULL, 0x32B6B3F002D03F45ULL }, /* XSUM_XXH64_testdata[735] */
    {  368, 0x0000000000000000ULL, 0xCEBBEF4F781C4FAEULL }, /* XSUM_XXH64_testdata[736] */
    {  368, 0x000000009E3779B1ULL, 0x48BB98F0956C5C45ULL }, /* XSUM_XXH64_testdata[737] */
    {  369, 0x0000000000000000ULL, 0x218BE4022357C2C5ULL }, /* XSUM_XXH64_testdata[738] */
    {  369, 0x000000009E3779B1ULL, 0x506B06A33BB769A2ULL }, /* XSUM_XXH64_testdata[739] */
    {  370, 0x0000000000000000ULL, 0xD0B8F04E8CB45BE2ULL }, /* XSUM_XXH64_testdata[740] */
    {  370, 0x000000009E3779B1ULL, 0xD6681A2EE58347F9ULL }, /* XSUM_XXH64_testdata[741] */
    {  371, 0x0000000000000000ULL, 0x21D5DF5AFD923E04ULL }, /* XSUM_XXH64_testdata[742] */
    {  371, 0x000000009E3779B1ULL, 0xF1749A54F9A73D6FULL }, /* XSUM_XXH64_testdata[743] */
    {  372, 0x0000000000000000ULL, 0xA1169572F334E450ULL }, /* XSUM_XXH64_testdata[744] */
    {  372, 0x000000009E3779B1ULL, 0x23B8C35AD1D75D48ULL }, /* XSUM_XXH64_testdata[745] */
    {  373, 0x0000000000000000ULL, 0x4BD2BB4765F571B7ULL }, /* XSUM_XXH64_testdata[746] */
    {  373, 0x000000009E3779B1ULL, 0xD65A00D88A0E022AULL }, /* XSUM_XXH64_testdata[747] */
    {  374, 0x0000000000000000ULL, 0x278416509AB11649ULL }, /* XSUM_XXH64_testdata[748] */
    {  374, 0x000000009E3779B1ULL, 0x59BE56940BF9E73DULL }, /* XSUM_XXH64_testdata[749] */
    {  375, 0x0000000000000000ULL, 0xA2F864D1E63B240AULL }, /* XSUM_XXH64_testdata[750] */
    {  375, 0x000000009E3779B1ULL, 0x04D060D22C824ED2ULL }, /* XSUM_XXH64_testdata[751] */
    {  376, 0x0000000000000000ULL, 0xC4DCB1D27FDE7788ULL }, /* XSUM_XXH64_testdata[752] */
    {  376, 0x000000009E3779B1ULL, 0x0AD31776E94CBA79ULL }, /* XSUM_XXH64_testdata[753] */
    {  377, 0x0000000000000000ULL, 0xC2F3DB934411070CULL }, /* XSUM_XXH64_testdata[754] */
    {  377, 0x000000009E3779B1ULL, 0xC28025FBB8DFD75DULL }, /* XSUM_XXH64_testdata[755] */
    {  378, 0x0000000000000000ULL, 0x0FDAEA3335593148ULL }, /* XSUM_XXH64_testdata[756] */
    {  378, 0x000000009E3779B1ULL, 0xAECA4BDA06ED5D61ULL }, /* XSUM_XXH64_testdata[757] */
    {  379, 0x0000000000000000ULL, 0x3175159612EA7796ULL }, /* XSUM_XXH64_testdata[758] */
    {  379, 0x000000009E3779B1ULL, 0xE9376AFDEF694BEEULL }, /* XSUM_XXH64_testdata[759] */
    {  380, 0x0000000000000000ULL, 0xF1C40441D14C95A5ULL }, /* XSUM_XXH64_testdata[760] */
    {  380, 0x000000009E3779B1ULL, 0x1D7886AF1856F4B6ULL }, /* XSUM_XXH64_testdata[761] */
    {  381, 0x0000000000000000ULL, 0x9B98BE37385CEB7BULL }, /* XSUM_XXH64_testdata[762] */
    {  381, 0x000000009E3779B1ULL, 0xE57C93942ADF4947ULL }, /* XSUM_XXH64_testdata[763] */
    {  382, 0x0000000000000000ULL, 0x31BFA4652E07BEB8ULL }, /* XSUM_XXH64_testdata[764] */
    {  382, 0x000000009E3779B1ULL, 0x805635A220015E23ULL }, /* XSUM_XXH64_testdata[765] */
    {  383, 0x0000000000000000ULL, 0xE612E19B7CC4D5ABULL }, /* XSUM_XXH64_testdata[766] */
    {  383, 0x000000009E3779B1ULL, 0xDEF132C77950801EULL }, /* XSUM_XXH64_testdata[767] */
    {  384, 0x0000000000000000ULL, 0xE0EFB85215C71C09ULL }, /* XSUM_XXH64_testdata[768] */
    {  384, 0x000000009E3779B1ULL, 0x0A7FF923C9D036CDULL }, /* XSUM_XXH64_testdata[769] */
    {  385, 0x0000000000000000ULL, 0xAEFC22C7F317BF44ULL }, /* XSUM_XXH64_testdata[770] */
    {  385, 0x000000009E3779B1ULL, 0xE071B502D2531E63ULL }, /* XSUM_XXH64_testdata[771] */
    {  386, 0x0000000000000000ULL, 0x21346B0FA207752DULL }, /* XSUM_XXH64_testdata[772] */
    {  386, 0x000000009E3779B1ULL, 0x295A64CDEA6E786AULL }, /* XSUM_XXH64_testdata[773] */
    {  387, 0x0000000000000000ULL, 0x7853D7E6049A5157ULL }, /* XSUM_XXH64_testdata[774] */
    {  387, 0x000000009E3779B1ULL, 0xB6C4FCDAF2B28B72ULL }, /* XSUM_XXH64_testdata[775] */
    {  388, 0x0000000000000000ULL, 0x0D44D47A8B8E172CULL }, /* XSUM_XXH64_testdata[776] */
    {  388, 0x000000009E3779B1ULL, 0xF56543F493851BB7ULL }, /* XSUM_XXH64_testdata[777] */
    {  389, 0x0000000000000000ULL, 0xBFCF76A043BEE0E5ULL }, /* XSUM_XXH64_testdata[778] */
    {  389, 0x000000009E3779B1ULL, 0x48AEE947021D9686ULL }, /* XSUM_XXH64_testdata[779] */
    {  390, 0x0000000000000000ULL, 0xFEB1F719F2BA4419ULL }, /* XSUM_XXH64_testdata[780] */
    {  390, 0x000000009E3779B1ULL, 0x8A90FB918044D765ULL }, /* XSUM_XXH64_testdata[781] */
    {  391, 0x0000000000000000ULL, 0x0B48DCCB968D6FB3ULL }, /* XSUM_XXH64_testdata[782] */
    {  391, 0x000000009E3779B1ULL, 0x4E3EA393AECE6242ULL }, /* XSUM_XXH64_testdata[783] */
    {  392, 0x0000000000000000ULL, 0x6ACEAB40DD45ECCDULL }, /* XSUM_XXH64_testdata[784] */
    {  392, 0x000000009E3779B1ULL, 0x7E79892276BB1BA3ULL }, /* XSUM_XXH64_testdata[785] */
    {  393, 0x0000000000000000ULL, 0xDB6C617D44B49B81ULL }, /* XSUM_XXH64_testdata[786] */
    {  393, 0x000000009E3779B1ULL, 0x734D33A4E578EA33ULL }, /* XSUM_XXH64_testdata[787] */
    {  394, 0x0000000000000000ULL, 0xD38D57BE8C1EFF36ULL }, /* XSUM_XXH64_testdata[788] */
    {  394, 0x000000009E3779B1ULL, 0xF131EC2E96911189ULL }, /* XSUM_XXH64_testdata[789] */
    {  395, 0x0000000000000000ULL, 0x55006129C21598FEULL }, /* XSUM_XXH64_testdata[790] */
    {  395, 0x000000009E3779B1ULL, 0x01E693808CD6B787ULL }, /* XSUM_XXH64_testdata[791] */
    {  396, 0x0000000000000000ULL, 0xDBBD4E2B7C59BEDBULL }, /* XSUM_XXH64_testdata[792] */
    {  396, 0x000000009E3779B1ULL, 0x66A1F230AB0C46B7ULL }, /* XSUM_XXH64_testdata[793] */
    {  397, 0x0000000000000000ULL, 0x2C92852B92663F53ULL }, /* XSUM_XXH64_testdata[794] */
    {  397, 0x000000009E3779B1ULL, 0xC0B250BE62D42F4DULL }, /* XSUM_XXH64_testdata[795] */
    {  398, 0x0000000000000000ULL, 0x9BD8C1E03800118DULL }, /* XSUM_XXH64_testdata[796] */
    {  398, 0x000000009E3779B1ULL, 0x29CBE4CF16F108FBULL }, /* XSUM_XXH64_testdata[797] */
    {  399, 0x0000000000000000ULL, 0xE7760069A9415F4FULL }, /* XSUM_XXH64_testdata[798] */
    {  399, 0x000000009E3779B1ULL, 0x7F3C35AE058EED4CULL }, /* XSUM_XXH64_testdata[799] */
    {  400, 0x0000000000000000ULL, 0x4581242DB7868377ULL }, /* XSUM_XXH64_testdata[800] */
    {  400, 0x000000009E3779B1ULL, 0xE3D38D3FDE215586ULL }, /* XSUM_XXH64_testdata[801] */
    {  401, 0x0000000000000000ULL, 0xE297524B7CD2F598ULL }, /* XSUM_XXH64_testdata[802] */
    {  401, 0x000000009E3779B1ULL, 0x81A7F82E9D6D490CULL }, /* XSUM_XXH64_testdata[803] */
    {  402, 0x0000000000000000ULL, 0xD479FDBC4B4D4793ULL }, /* XSUM_XXH64_testdata[804] */
    {  402, 0x000000009E3779B1ULL, 0xFB789B6F1DB92E25ULL }, /* XSUM_XXH64_testdata[805] */
    {  403, 0x0000000000000000ULL, 0xD99858FEE82283DFULL }, /* XSUM_XXH64_testdata[806] */
    {  403, 0x000000009E3779B1ULL, 0xF66589734AD3CF7EULL }, /* XSUM_XXH64_testdata[807] */
    {  404, 0x0000000000000000ULL, 0x404C0164C810B890ULL }, /* XSUM_XXH64_testdata[808] */
    {  404, 0x000000009E3779B1ULL, 0x21DF4FB8D1B99324ULL }, /* XSUM_XXH64_testdata[809] */
    {  405, 0x0000000000000000ULL, 0x0173F6874E867210ULL }, /* XSUM_XXH64_testdata[810] */
    {  405, 0x000000009E3779B1ULL, 0x145D25DD60D253B9ULL }, /* XSUM_XXH64_testdata[811] */
    {  406, 0x0000000000000000ULL, 0x68C576ADB1EBE2A3ULL }, /* XSUM_XXH64_testdata[812] */
    {  406, 0x000000009E3779B1ULL, 0xFF2169289AA10522ULL }, /* XSUM_XXH64_testdata[813] */
    {  407, 0x0000000000000000ULL, 0x6B44FA7F771A2E3EULL }, /* XSUM_XXH64_testdata[814] */
    {  407, 0x000000009E3779B1ULL, 0x72664ECE337B7043ULL }, /* XSUM_XXH64_testdata[815] */
    {  408, 0x0000000000000000ULL, 0xDD7E906896FDE2F9ULL }, /* XSUM_XXH64_testdata[816] */
    {  408, 0x000000009E3779B1ULL, 0x7BCE9F34F477DBE1ULL }, /* XSUM_XXH64_testdata[817] */
    {  409, 0x0000000000000000ULL, 0x51B9F33A8AF1319AULL }, /* XSUM_XXH64_testdata[818] */
    {  409, 0x000000009E3779B1ULL, 0x75ABF9D8FB23947EULL }, /* XSUM_XXH64_testdata[819] */
    {  410, 0x0000000000000000ULL, 0x9CD79D8A4344916BULL }, /* XSUM_XXH64_testdata[820] */
    {  410, 0x000000009E3779B1ULL, 0x1243A2C29B5721AEULL }, /* XSUM_XXH64_testdata[821] */
    {  411, 0x0000000000000000ULL, 0x40CE5A49AC1C190BULL }, /* XSUM_XXH64_testdata[822] */
    {  411, 0x000000009E3779B1ULL, 0x01ECCE7208EC5F51ULL }, /* XSUM_XXH64_testdata[823] */
    {  412, 0x0000000000000000ULL, 0x8EA0FA92E59FC1F1ULL }, /* XSUM_XXH64_testdata[824] */
    {  412, 0x000000009E3779B1ULL, 0x24E0A17C768CB4FDULL }, /* XSUM_XXH64_testdata[825] */
    {  413, 0x0000000000000000ULL, 0x091E8C2D14A662E0ULL }, /* XSUM_XXH64_testdata[826] */
    {  413, 0x000000009E3779B1ULL, 0xB47F5C5528F3F634ULL }, /* XSUM_XXH64_testdata[827] */
    {  414, 0x0000000000000000ULL, 0x00E32E71E9EF3717ULL }, /* XSUM_XXH64_testdata[828] */
    {  414, 0x000000009E3779B1ULL, 0x759D6135223861C1ULL }, /* XSUM_XXH64_testdata[829] */
    {  415, 0x0000000000000000ULL, 0xD21126D6F7FF3852ULL }, /* XSUM_XXH64_testdata[830] */
    {  415, 0x000000009E3779B1ULL, 0x7AA162EC31C286EDULL }, /* XSUM_XXH64_testdata[831] */
    {  416, 0x0000000000000000ULL, 0x7319F2B5C775AB3EULL }, /* XSUM_XXH64_testdata[832] */
    {  416, 0x000000009E3779B1ULL, 0xD21E77D8AC120FFFULL }, /* XSUM_XXH64_testdata[833] */
    {  417, 0x0000000000000000ULL, 0xF0DEB8D5833F3556ULL }, /* XSUM_XXH64_testdata[834] */
    {  417, 0x000000009E3779B1ULL, 0x71F0FCA245F29550ULL }, /* XSUM_XXH64_testdata[835] */
    {  418, 0x0000000000000000ULL, 0x3E6400FE386BF36FULL }, /* XSUM_XXH64_testdata[836] */
    {  418, 0x000000009E3779B1ULL, 0x099A003EAD1CA662ULL }, /* XSUM_XXH64_testdata[837] */
    {  419, 0x0000000000000000ULL, 0x46DCEAFF1EBC6577ULL }, /* XSUM_XXH64_testdata[838] */
    {  419, 0x000000009E3779B1ULL, 0x45C133F35B871816ULL }, /* XSUM_XXH64_testdata[839] */
    {  420, 0x0000000000000000ULL, 0x6127CB28225B3CB6ULL }, /* XSUM_XXH64_testdata[840] */
    {  420, 0x000000009E3779B1ULL, 0x1D53D6AD66E9F1C3ULL }, /* XSUM_XXH64_testdata[841] */
    {  421, 0x0000000000000000ULL, 0xCA87D1BA12B8D930ULL }, /* XSUM_XXH64_testdata[842] */
    {  421, 0x000000009E3779B1ULL, 0x11F62E4EBE932275ULL }, /* XSUM_XXH64_testdata[843] */
    {  422, 0x0000000000000000ULL, 0xFED2A07192168432ULL }, /* XSUM_XXH64_testdata[844] */
    {  422, 0x000000009E3779B1ULL, 0x7455916DCEFBACE1ULL }, /* XSUM_XXH64_testdata[845] */
    {  423, 0x0000000000000000ULL, 0x41196C0E245B0D9CULL }, /* XSUM_XXH64_testdata[846] */
    {  423, 0x000000009E3779B1ULL, 0xD90B0BAFE79A67C5ULL }, /* XSUM_XXH64_testdata[847] */
    {  424, 0x0000000000000000ULL, 0xDBA935092D6CC79FULL }, /* XSUM_XXH64_testdata[848] */
    {  424, 0x000000009E3779B1ULL, 0xF2FDF5EADABD6ECCULL }, /* XSUM_XXH64_testdata[849] */
    {  425, 0x0000000000000000ULL, 0x63655D005F220917ULL }, /* XSUM_XXH64_testdata[850] */
    {  425, 0x000000009E3779B1ULL, 0x0B7A33C49D258122ULL }, /* XSUM_XXH64_testdata[851] */
    {  426, 0x0000000000000000ULL, 0x42368F69311633D2ULL }, /* XSUM_XXH64_testdata[852] */
    {  426, 0x000000009E3779B1ULL, 0x73A1B6D645252287ULL }, /* XSUM_XXH64_testdata[853] */
    {  427, 0x0000000000000000ULL, 0x791554672DB58205ULL }, /* XSUM_XXH64_testdata[854] */
    {  427, 0x000000009E3779B1ULL, 0x3D739071089B6F16ULL }, /* XSUM_XXH64_testdata[855] */
    {  428, 0x0000000000000000ULL, 0xCE86BADA84179A50ULL }, /* XSUM_XXH64_testdata[856] */
    {  428, 0x000000009E3779B1ULL, 0xA71BA1A04BACABC6ULL }, /* XSUM_XXH64_testdata[857] */
    {  429, 0x0000000000000000ULL, 0x1B142012B60D624BULL }, /* XSUM_XXH64_testdata[858] */
    {  429, 0x000000009E3779B1ULL, 0x9D9EF3D9162F92E8ULL }, /* XSUM_XXH64_testdata[859] */
    {  430, 0x0000000000000000ULL, 0xFF2A20FBA8523036ULL }, /* XSUM_XXH64_testdata[860] */
    {  430, 0x000000009E3779B1ULL, 0x8CCFAFAA584CF34DULL }, /* XSUM_XXH64_testdata[861] */
    {  431, 0x0000000000000000ULL, 0x4F9F87B4591B0FBBULL }, /* XSUM_XXH64_testdata[862] */
    {  431, 0x000000009E3779B1ULL, 0xE09B6C699939EFA2ULL }, /* XSUM_XXH64_testdata[863] */
    {  432, 0x0000000000000000ULL, 0xF6D48B6DF8091F1EULL }, /* XSUM_XXH64_testdata[864] */
    {  432, 0x000000009E3779B1ULL, 0x7C99553C30148610ULL }, /* XSUM_XXH64_testdata[865] */
    {  433, 0x0000000000000000ULL, 0xF94E03AA24E6CF00ULL }, /* XSUM_XXH64_testdata[866] */
    {  433, 0x000000009E3779B1ULL, 0x94EFD2E9E10439A9ULL }, /* XSUM_XXH64_testdata[867] */
    {  434, 0x0000000000000000ULL, 0xF8E9464218ECE1B1ULL }, /* XSUM_XXH64_testdata[868] */
    {  434, 0x000000009E3779B1ULL, 0x1CAA675030E23E0AULL }, /* XSUM_XXH64_testdata[869] */
    {  435, 0x0000000000000000ULL, 0x945E7FFC4F72CB7AULL }, /* XSUM_XXH64_testdata[870] */
    {  435, 0x000000009E3779B1ULL, 0x016819919A72D6D1ULL }, /* XSUM_XXH64_testdata[871] */
    {  436, 0x0000000000000000ULL, 0xE5FF7BE5AD6B2401ULL }, /* XSUM_XXH64_testdata[872] */
    {  436, 0x000000009E3779B1ULL, 0x7B600C69E72AEB87ULL }, /* XSUM_XXH64_testdata[873] */
    {  437, 0x0000000000000000ULL, 0x378488B2F434ECCFULL }, /* XSUM_XXH64_testdata[874] */
    {  437, 0x000000009E3779B1ULL, 0xF2BAF2947B71BEACULL }, /* XSUM_XXH64_testdata[875] */
    {  438, 0x0000000000000000ULL, 0xAB608A8B906F7B02ULL }, /* XSUM_XXH64_testdata[876] */
    {  438, 0x000000009E3779B1ULL, 0xD452A1154FFB4456ULL }, /* XSUM_XXH64_testdata[877] */
    {  439, 0x0000000000000000ULL, 0x7AB6E12E2A2073FBULL }, /* XSUM_XXH64_testdata[878] */
    {  439, 0x000000009E3779B1ULL, 0x89F275B2098CA649ULL }, /* XSUM_XXH64_testdata[879] */
    {  440, 0x0000000000000000ULL, 0x01F8A9639790AC66ULL }, /* XSUM_XXH64_testdata[880] */
    {  440, 0x000000009E3779B1ULL, 0x765CB9BD0A0B4968ULL }, /* XSUM_XXH64_testdata[881] */
    {  441, 0x0000000000000000ULL, 0x8579DB651855FC52ULL }, /* XSUM_XXH64_testdata[882] */
    {  441, 0x000000009E3779B1ULL, 0xD696CA959FC01D27ULL }, /* XSUM_XXH64_testdata[883] */
    {  442, 0x0000000000000000ULL, 0xCB4348957960911AULL }, /* XSUM_XXH64_testdata[884] */
    {  442, 0x000000009E3779B1ULL, 0x2E64B87578774199ULL }, /* XSUM_XXH64_testdata[885] */
    {  443, 0x0000000000000000ULL, 0xD1F4906E8D06391EULL }, /* XSUM_XXH64_testdata[886] */
    {  443, 0x000000009E3779B1ULL, 0x00B7AB143869613FULL }, /* XSUM_XXH64_testdata[887] */
    {  444, 0x0000000000000000ULL, 0xA2DFAE5D5A67884FULL }, /* XSUM_XXH64_testdata[888] */
    {  444, 0x000000009E3779B1ULL, 0x70857EC5BC9AEB3CULL }, /* XSUM_XXH64_testdata[889] */
    {  445, 0x0000000000000000ULL, 0x6646E1735503A3C0ULL }, /* XSUM_XXH64_testdata[890] */
    {  445, 0x000000009E3779B1ULL, 0xD9C49B6909F3636EULL }, /* XSUM_XXH64_testdata[891] */
    {  446, 0x0000000000000000ULL, 0x8F03204478ACAF49ULL }, /* XSUM_XXH64_testdata[892] */
    {  446, 0x000000009E3779B1ULL, 0x2FF81F47418A77F5ULL }, /* XSUM_XXH64_testdata[893] */
    {  447, 0x0000000000000000ULL, 0x0EDC27091B085A82ULL }, /* XSUM_XXH64_testdata[894] */
    {  447, 0x000000009E3779B1ULL, 0x135DE1C596499D0CULL }, /* XSUM_XXH64_testdata[895] */
    {  448, 0x0000000000000000ULL, 0x465FBDC140F3780FULL }, /* XSUM_XXH64_testdata[896] */
    {  448, 0x000000009E3779B1ULL, 0xCCAD9E903167223EULL }, /* XSUM_XXH64_testdata[897] */
    {  449, 0x0000000000000000ULL, 0x51E2A5C66C3C7345ULL }, /* XSUM_XXH64_testdata[898] */
    {  449, 0x000000009E3779B1ULL, 0x27B78EE3D6A73779ULL }, /* XSUM_XXH64_testdata[899] */
    {  450, 0x0000000000000000ULL, 0x83D7FA2D0551B412ULL }, /* XSUM_XXH64_testdata[900] */
    {  450, 0x000000009E3779B1ULL, 0x008C6A8908F2EDF3ULL }, /* XSUM_XXH64_testdata[901] */
    {  451, 0x0000000000000000ULL, 0xABAFD3ABA227706EULL }, /* XSUM_XXH64_testdata[902] */
    {  451, 0x000000009E3779B1ULL, 0x7F3B2B83DA239881ULL }, /* XSUM_XXH64_testdata[903] */
    {  452, 0x0000000000000000ULL, 0x10F4E85F0D32CA78ULL }, /* XSUM_XXH64_testdata[904] */
    {  452, 0x000000009E3779B1ULL, 0xD870BB8743C029F1ULL }, /* XSUM_XXH64_testdata[905] */
    {  453, 0x0000000000000000ULL, 0xD88E868BB3172267ULL }, /* XSUM_XXH64_testdata[906] */
    {  453, 0x000000009E3779B1ULL, 0x5994B79B64070DC4ULL }, /* XSUM_XXH64_testdata[907] */
    {  454, 0x0000000000000000ULL, 0x8F7ADE427C362DEAULL }, /* XSUM_XXH64_testdata[908] */
    {  454, 0x000000009E3779B1ULL, 0x0D2D3FB152C5059DULL }, /* XSUM_XXH64_testdata[909] */
    {  455, 0x0000000000000000ULL, 0x9DD51DD63505C82DULL }, /* XSUM_XXH64_testdata[910] */
    {  455, 0x000000009E3779B1ULL, 0xC752BA5B462F513EULL }, /* XSUM_XXH64_testdata[911] */
    {  456, 0x0000000000000000ULL, 0xD68678A01FBF1CEDULL }, /* XSUM_XXH64_testdata[912] */
    {  456, 0x000000009E3779B1ULL, 0xCBCC6C108F790420ULL }, /* XSUM_XXH64_testdata[913] */
    {  457, 0x0000000000000000ULL, 0x4A8DFA47A5243AB4ULL }, /* XSUM_XXH64_testdata[914] */
    {  457, 0x000000009E3779B1ULL, 0x609D3971A15C7CABULL }, /* XSUM_XXH64_testdata[915] */
    {  458, 0x0000000000000000ULL, 0x60216DC8DBBEB687ULL }, /* XSUM_XXH64_testdata[916] */
    {  458, 0x000000009E3779B1ULL, 0x0EEF86168490597EULL }, /* XSUM_XXH64_testdata[917] */
    {  459, 0x0000000000000000ULL, 0x7E52C5716A1E2461ULL }, /* XSUM_XXH64_testdata[918] */
    {  459, 0x000000009E3779B1ULL, 0x96EFF1C70AD8F962ULL }, /* XSUM_XXH64_testdata[919] */
    {  460, 0x0000000000000000ULL, 0xDADEE2B3BC9207F5ULL }, /* XSUM_XXH64_testdata[920] */
    {  460, 0x000000009E3779B1ULL, 0x02FF311FBFE92500ULL }, /* XSUM_XXH64_testdata[921] */
    {  461, 0x0000000000000000ULL, 0x0B96DB78FF730BC9ULL }, /* XSUM_XXH64_testdata[922] */
    {  461, 0x000000009E3779B1ULL, 0x4F89125C297A641CULL }, /* XSUM_XXH64_testdata[923] */
    {  462, 0x0000000000000000ULL, 0x600B43E4F562B855ULL }, /* XSUM_XXH64_testdata[924] */
    {  462, 0x000000009E3779B1ULL, 0x9A01F7838C7E76C1ULL }, /* XSUM_XXH64_testdata[925] */
    {  463, 0x0000000000000000ULL, 0xAF11D3DA14ECEA77ULL }, /* XSUM_XXH64_testdata[926] */
    {  463, 0x000000009E3779B1ULL, 0xD3EC40A69FCC3A01ULL }, /* XSUM_XXH64_testdata[927] */
    {  464, 0x0000000000000000ULL, 0x63F9939CAF710AB3ULL }, /* XSUM_XXH64_testdata[928] */
    {  464, 0x000000009E3779B1ULL, 0x27F1AE18B0000F32ULL }, /* XSUM_XXH64_testdata[929] */
    {  465, 0x0000000000000000ULL, 0x9E3B6A4665E25791ULL }, /* XSUM_XXH64_testdata[930] */
    {  465, 0x000000009E3779B1ULL, 0x392522093E3FB48CULL }, /* XSUM_XXH64_testdata[931] */
    {  466, 0x0000000000000000ULL, 0x04D9792DD944E6FAULL }, /* XSUM_XXH64_testdata[932] */
    {  466, 0x000000009E3779B1ULL, 0x26C2C96305BB5022ULL }, /* XSUM_XXH64_testdata[933] */
    {  467, 0x0000000000000000ULL, 0x068711B25A6E0D92ULL }, /* XSUM_XXH64_testdata[934] */
    {  467, 0x000000009E3779B1ULL, 0xBD83F17500969511ULL }, /* XSUM_XXH64_testdata[935] */
    {  468, 0x0000000000000000ULL, 0x1B5A437C7788771FULL }, /* XSUM_XXH64_testdata[936] */
    {  468, 0x000000009E3779B1ULL, 0x0C932D15E6922ABDULL }, /* XSUM_XXH64_testdata[937] */
    {  469, 0x0000000000000000ULL, 0x59016F221D4813C4ULL }, /* XSUM_XXH64_testdata[938] */
    {  469, 0x000000009E3779B1ULL, 0xE26458A377C9D1ABULL }, /* XSUM_XXH64_testdata[939] */
    {  470, 0x0000000000000000ULL, 0x2663563FDE9F1831ULL }, /* XSUM_XXH64_testdata[940] */
    {  470, 0x000000009E3779B1ULL, 0x5092D399CE4818FBULL }, /* XSUM_XXH64_testdata[941] */
    {  471, 0x0000000000000000ULL, 0x0AB3383195958DFCULL }, /* XSUM_XXH64_testdata[942] */
    {  471, 0x000000009E3779B1ULL, 0xC56EF2EB4CC708AAULL }, /* XSUM_XXH64_testdata[943] */
    {  472, 0x0000000000000000ULL, 0x62059C47D32E4D90ULL }, /* XSUM_XXH64_testdata[944] */
    {  472, 0x000000009E3779B1ULL, 0x8C30EEDEA66C724EULL }, /* XSUM_XXH64_testdata[945] */
    {  473, 0x0000000000000000ULL, 0x2CB293E9758D5BECULL }, /* XSUM_XXH64_testdata[946] */
    {  473, 0x000000009E3779B1ULL, 0xEE1698A529650FD2ULL }, /* XSUM_XXH64_testdata[947] */
    {  474, 0x0000000000000000ULL, 0xCFADBE86FBA36BB3ULL }, /* XSUM_XXH64_testdata[948] */
    {  474, 0x000000009E3779B1ULL, 0x35995964704111EBULL }, /* XSUM_XXH64_testdata[949] */
    {  475, 0x0000000000000000ULL, 0x574C11EBD764D1DDULL }, /* XSUM_XXH64_testdata[950] */
    {  475, 0x000000009E3779B1ULL, 0xFC3ADBB622E9B7DCULL }, /* XSUM_XXH64_testdata[951] */
    {  476, 0x0000000000000000ULL, 0xE3D070118B3B303DULL }, /* XSUM_XXH64_testdata[952] */
    {  476, 0x000000009E3779B1ULL, 0xA7FED066373DEE9FULL }, /* XSUM_XXH64_testdata[953] */
    {  477, 0x0000000000000000ULL, 0xEA289911F5201680ULL }, /* XSUM_XXH64_testdata[954] */
    {  477, 0x000000009E3779B1ULL, 0xEB390BFDC716AA91ULL }, /* XSUM_XXH64_testdata[955] */
    {  478, 0x0000000000000000ULL, 0x8DA3DCA0B281372BULL }, /* XSUM_XXH64_testdata[956] */
    {  478, 0x000000009E3779B1ULL, 0x4349FEE4D2B17020ULL }, /* XSUM_XXH64_testdata[957] */
    {  479, 0x0000000000000000ULL, 0x02B1BBA6B8DC460BULL }, /* XSUM_XXH64_testdata[958] */
    {  479, 0x000000009E3779B1ULL, 0xDB069B2D229E4780ULL }, /* XSUM_XXH64_testdata[959] */
    {  480, 0x0000000000000000ULL, 0x40031EFCE44584AFULL }, /* XSUM_XXH64_testdata[960] */
    {  480, 0x000000009E3779B1ULL, 0x1612CF8E737DD856ULL }, /* XSUM_XXH64_testdata[961] */
    {  481, 0x0000000000000000ULL, 0x6AEC129F22336227ULL }, /* XSUM_XXH64_testdata[962] */
    {  481, 0x000000009E3779B1ULL, 0xDA87FF4EB7992996ULL }, /* XSUM_XXH64_testdata[963] */
    {  482, 0x0000000000000000ULL, 0x0843ED2BFCA993EAULL }, /* XSUM_XXH64_testdata[964] */
    {  482, 0x000000009E3779B1ULL, 0x9821FC8DB9D8022EULL }, /* XSUM_XXH64_testdata[965] */
    {  483, 0x0000000000000000ULL, 0x178E105C1B1E0134ULL }, /* XSUM_XXH64_testdata[966] */
    {  483, 0x000000009E3779B1ULL, 0x86D480B7F76DFBE9ULL }, /* XSUM_XXH64_testdata[967] */
    {  484, 0x0000000000000000ULL, 0x0DCA6F3508C285BAULL }, /* XSUM_XXH64_testdata[968] */
    {  484, 0x000000009E3779B1ULL, 0xE6C29284FF7590C5ULL }, /* XSUM_XXH64_testdata[969] */
    {  485, 0x0000000000000000ULL, 0xC023B1DB24605E35ULL }, /* XSUM_XXH64_testdata[970] */
    {  485, 0x000000009E3779B1ULL, 0xE68814F0AB2B750AULL }, /* XSUM_XXH64_testdata[971] */
    {  486, 0x0000000000000000ULL, 0x41E31D83E4F93D06ULL }, /* XSUM_XXH64_testdata[972] */
    {  486, 0x000000009E3779B1ULL, 0xEF55AE9D5E5CEA59ULL }, /* XSUM_XXH64_testdata[973] */
    {  487, 0x0000000000000000ULL, 0x093DA0BBAED7F232ULL }, /* XSUM_XXH64_testdata[974] */
    {  487, 0x000000009E3779B1ULL, 0xD220B6221C6C63A4ULL }, /* XSUM_XXH64_testdata[975] */
    {  488, 0x0000000000000000ULL, 0x761742AE716591FDULL }, /* XSUM_XXH64_testdata[976] */
    {  488, 0x000000009E3779B1ULL, 0x793924E36DBEB9A7ULL }, /* XSUM_XXH64_testdata[977] */
    {  489, 0x0000000000000000ULL, 0x0F1737AE93F62C74ULL }, /* XSUM_XXH64_testdata[978] */
    {  489, 0x000000009E3779B1ULL, 0xC0A6A71FA00BF57CULL }, /* XSUM_XXH64_testdata[979] */
    {  490, 0x0000000000000000ULL, 0xEB9D10098EF0CB74ULL }, /* XSUM_XXH64_testdata[980] */
    {  490, 0x000000009E3779B1ULL, 0x3E6998ACEDA2EE67ULL }, /* XSUM_XXH64_testdata[981] */
    {  491, 0x0000000000000000ULL, 0x5B9D47EABDA691FAULL }, /* XSUM_XXH64_testdata[982] */
    {  491, 0x000000009E3779B1ULL, 0x4CF38592DC8904D6ULL }, /* XSUM_XXH64_testdata[983] */
    {  492, 0x0000000000000000ULL, 0x6DC29C7B23F5F15EULL }, /* XSUM_XXH64_testdata[984] */
    {  492, 0x000000009E3779B1ULL, 0x7F19DF774B1928D5ULL }, /* XSUM_XXH64_testdata[985] */
    {  493, 0x0000000000000000ULL, 0x7F76280BB7FCE69FULL }, /* XSUM_XXH64_testdata[986] */
    {  493, 0x000000009E3779B1ULL, 0x522AB77524338A16ULL }, /* XSUM_XXH64_testdata[987] */
    {  494, 0x0000000000000000ULL, 0x3FC2B6A8DD5F66C4ULL }, /* XSUM_XXH64_testdata[988] */
    {  494, 0x000000009E3779B1ULL, 0x00A39203BBE1E330ULL }, /* XSUM_XXH64_testdata[989] */
    {  495, 0x0000000000000000ULL, 0xABE2CE0D9471F427ULL }, /* XSUM_XXH64_testdata[990] */
    {  495, 0x000000009E3779B1ULL, 0x7E0DB81889B923E1ULL }, /* XSUM_XXH64_testdata[991] */
    {  496, 0x0000000000000000ULL, 0x3985E21DBD3CDEF3ULL }, /* XSUM_XXH64_testdata[992] */
    {  496, 0x000000009E3779B1ULL, 0x42F6DBAC22AD2A14ULL }, /* XSUM_XXH64_testdata[993] */
    {  497, 0x0000000000000000ULL, 0x4CA22D526CAD42B4ULL }, /* XSUM_XXH64_testdata[994] */
    {  497, 0x000000009E3779B1ULL, 0x7BF4B9AEA2185F63ULL }, /* XSUM_XXH64_testdata[995] */
    {  498, 0x0000000000000000ULL, 0x1DC9E82F7DC4EE75ULL }, /* XSUM_XXH64_testdata[996] */
    {  498, 0x000000009E3779B1ULL, 0xA0E9D167061A5ADCULL }, /* XSUM_XXH64_testdata[997] */
    {  499, 0x0000000000000000ULL, 0x20667D1D1F953BF2ULL }, /* XSUM_XXH64_testdata[998] */
    {  499, 0x000000009E3779B1ULL, 0x92B92E43DC4E26C6ULL }, /* XSUM_XXH64_testdata[999] */
    {  500, 0x0000000000000000ULL, 0x0B5403D7FCC8AB6DULL }, /* XSUM_XXH64_testdata[1000] */
    {  500, 0x000000009E3779B1ULL, 0xFF6DB0A01DEE34B4ULL }, /* XSUM_XXH64_testdata[1001] */
    {  501, 0x0000000000000000ULL, 0x304D87F89595490BULL }, /* XSUM_XXH64_testdata[1002] */
    {  501, 0x000000009E3779B1ULL, 0x75173066F3589C33ULL }, /* XSUM_XXH64_testdata[1003] */
    {  502, 0x0000000000000000ULL, 0x298DB12D23F6EB97ULL }, /* XSUM_XXH64_testdata[1004] */
    {  502, 0x000000009E3779B1ULL, 0x369BFC08CF1E6A34ULL }, /* XSUM_XXH64_testdata[1005] */
    {  503, 0x0000000000000000ULL, 0xBC6611E986B7648FULL }, /* XSUM_XXH64_testdata[1006] */
    {  503, 0x000000009E3779B1ULL, 0xAC9FB74CEDFA9A33ULL }, /* XSUM_XXH64_testdata[1007] */
    {  504, 0x0000000000000000ULL, 0xA4811FB6290D19F9ULL }, /* XSUM_XXH64_testdata[1008] */
    {  504, 0x000000009E3779B1ULL, 0x78D79342AAEF81B9ULL }, /* XSUM_XXH64_testdata[1009] */
    {  505, 0x0000000000000000ULL, 0x1F791A9F0E20AD3AULL }, /* XSUM_XXH64_testdata[1010] */
    {  505, 0x000000009E3779B1ULL, 0x85570A633C613AD7ULL }, /* XSUM_XXH64_testdata[1011] */
    {  506, 0x0000000000000000ULL, 0x8AB2AE971FC81669ULL }, /* XSUM_XXH64_testdata[1012] */
    {  506, 0x000000009E3779B1ULL, 0x0C27D432268D95C9ULL }, /* XSUM_XXH64_testdata[1013] */
    {  507, 0x0000000000000000ULL, 0xA0FCE9F8B08AFAEBULL }, /* XSUM_XXH64_testdata[1014] */
    {  507, 0x000000009E3779B1ULL, 0x0CA0718807CFCA08ULL }, /* XSUM_XXH64_testdata[1015] */
    {  508, 0x0000000000000000ULL, 0xD1A9A871AD298D60ULL }, /* XSUM_XXH64_testdata[1016] */
    {  508, 0x000000009E3779B1ULL, 0xB927B690D2AB5A51ULL }, /* XSUM_XXH64_testdata[1017] */
    {  509, 0x0000000000000000ULL, 0x5CBF1E76AEF61ACFULL }, /* XSUM_XXH64_testdata[1018] */
    {  509, 0x000000009E3779B1ULL, 0x0B7DAC8575664A12ULL }, /* XSUM_XXH64_testdata[1019] */
    {  510, 0x0000000000000000ULL, 0xAB5553DFA36E8E31ULL }, /* XSUM_XXH64_testdata[1020] */
    {  510, 0x000000009E3779B1ULL, 0x88C9D9A5B729CE18ULL }, /* XSUM_XXH64_testdata[1021] */
    {  511, 0x0000000000000000ULL, 0xC049A218675DC378ULL }, /* XSUM_XXH64_testdata[1022] */
    {  511, 0x000000009E3779B1ULL, 0x127FF202F0810F95ULL }, /* XSUM_XXH64_testdata[1023] */
    {  512, 0x0000000000000000ULL, 0x4358D2FDD62B58A7ULL }, /* XSUM_XXH64_testdata[1024] */
    {  512, 0x000000009E3779B1ULL, 0x0DED69C4804C47BAULL }, /* XSUM_XXH64_testdata[1025] */
    {  513, 0x0000000000000000ULL, 0xC2240D6F6A431697ULL }, /* XSUM_XXH64_testdata[1026] */
    {  513, 0x000000009E3779B1ULL, 0x88BFA9216A4D96C9ULL }, /* XSUM_XXH64_testdata[1027] */
    {  514, 0x0000000000000000ULL, 0x901495B937ED3AE6ULL }, /* XSUM_XXH64_testdata[1028] */
    {  514, 0x000000009E3779B1ULL, 0x8129269C8C7CE568ULL }, /* XSUM_XXH64_testdata[1029] */
    {  515, 0x0000000000000000ULL, 0xC5B49EEF519A5AAEULL }, /* XSUM_XXH64_testdata[1030] */
    {  515, 0x000000009E3779B1ULL, 0xA9B6E57E112DF80DULL }, /* XSUM_XXH64_testdata[1031] */
    {  516, 0x0000000000000000ULL, 0x24BB9E47246405FBULL }, /* XSUM_XXH64_testdata[1032] */
    {  516, 0x000000009E3779B1ULL, 0x5658E4997FAE1149ULL }, /* XSUM_XXH64_testdata[1033] */
    {  517, 0x0000000000000000ULL, 0x5002F24B8C916818ULL }, /* XSUM_XXH64_testdata[1034] */
    {  517, 0x000000009E3779B1ULL, 0x1E3BAEC8B3E92684ULL }, /* XSUM_XXH64_testdata[1035] */
    {  518, 0x0000000000000000ULL, 0x98B0ED88B8DC1803ULL }, /* XSUM_XXH64_testdata[1036] */
    {  518, 0x000000009E3779B1ULL, 0x1C6643C6D7C79888ULL }, /* XSUM_XXH64_testdata[1037] */
    {  519, 0x0000000000000000ULL, 0x67A3E92CBC5AAEB8ULL }, /* XSUM_XXH64_testdata[1038] */
    {  519, 0x000000009E3779B1ULL, 0xF6B6745DD2ABEED0ULL }, /* XSUM_XXH64_testdata[1039] */
    {  520, 0x0000000000000000ULL, 0x3E765FC98AF555B2ULL }, /* XSUM_XXH64_testdata[1040] */
    {  520, 0x000000009E3779B1ULL, 0x271854A81B1F55F5ULL }, /* XSUM_XXH64_testdata[1041] */
    {  521, 0x0000000000000000ULL, 0x1481FAAE140DB52DULL }, /* XSUM_XXH64_testdata[1042] */
    {  521, 0x000000009E3779B1ULL, 0xC9CD4CF70210991DULL }, /* XSUM_XXH64_testdata[1043] */
    {  522, 0x0000000000000000ULL, 0x7076E5064B3D72D9ULL }, /* XSUM_XXH64_testdata[1044] */
    {  522, 0x000000009E3779B1ULL, 0x0A0FE463D5D1F237ULL }, /* XSUM_XXH64_testdata[1045] */
    {  523, 0x0000000000000000ULL, 0x5BFCF54F2C534E84ULL }, /* XSUM_XXH64_testdata[1046] */
    {  523, 0x000000009E3779B1ULL, 0x5129D643B208FDA0ULL }, /* XSUM_XXH64_testdata[1047] */
    {  524, 0x0000000000000000ULL, 0x6E26EA3B29E6865BULL }, /* XSUM_XXH64_testdata[1048] */
    {  524, 0x000000009E3779B1ULL, 0x535354E5D22B7C5CULL }, /* XSUM_XXH64_testdata[1049] */
    {  525, 0x0000000000000000ULL, 0x3478B4D8BC39B944ULL }, /* XSUM_XXH64_testdata[1050] */
    {  525, 0x000000009E3779B1ULL, 0x259DCF1DB85D237EULL }, /* XSUM_XXH64_testdata[1051] */
    {  526, 0x0000000000000000ULL, 0x3915A0F0D2A49F64ULL }, /* XSUM_XXH64_testdata[1052] */
    {  526, 0x000000009E3779B1ULL, 0x5A3E939F7A624CF3ULL }, /* XSUM_XXH64_testdata[1053] */
    {  527, 0x0000000000000000ULL, 0x24505C82F7CEFBB6ULL }, /* XSUM_XXH64_testdata[1054] */
    {  527, 0x000000009E3779B1ULL, 0x922D119813FC4C0EULL }, /* XSUM_XXH64_testdata[1055] */
    {  528, 0x0000000000000000ULL, 0x67B4C2454D384A60ULL }, /* XSUM_XXH64_testdata[1056] */
    {  528, 0x000000009E3779B1ULL, 0xBCF3D6E31A6EE429ULL }, /* XSUM_XXH64_testdata[1057] */
    {  529, 0x0000000000000000ULL, 0x5F59A1C17DDE57D7ULL }, /* XSUM_XXH64_testdata[1058] */
    {  529, 0x000000009E3779B1ULL, 0xC46DD68E234BF321ULL }, /* XSUM_XXH64_testdata[1059] */
    {  530, 0x0000000000000000ULL, 0xCCFBE89BF3BE2A25ULL }, /* XSUM_XXH64_testdata[1060] */
    {  530, 0x000000009E3779B1ULL, 0xA25E7E65BB76FDBAULL }, /* XSUM_XXH64_testdata[1061] */
    {  531, 0x0000000000000000ULL, 0xFD302CE018C30F51ULL }, /* XSUM_XXH64_testdata[1062] */
    {  531, 0x000000009E3779B1ULL, 0x5E44DD12B585935FULL }, /* XSUM_XXH64_testdata[1063] */
    {  532, 0x0000000000000000ULL, 0x4EF1804541C532FAULL }, /* XSUM_XXH64_testdata[1064] */
    {  532, 0x000000009E3779B1ULL, 0x99EB3A06D5E6614BULL }, /* XSUM_XXH64_testdata[1065] */
    {  533, 0x0000000000000000ULL, 0x74CC32C533C176DEULL }, /* XSUM_XXH64_testdata[1066] */
    {  533, 0x000000009E3779B1ULL, 0x3C2E21FF7EBFE1A0ULL }, /* XSUM_XXH64_testdata[1067] */
    {  534, 0x0000000000000000ULL, 0x7BB34158B6944958ULL }, /* XSUM_XXH64_testdata[1068] */
    {  534, 0x000000009E3779B1ULL, 0x4E8CEBA257509C52ULL }, /* XSUM_XXH64_testdata[1069] */
    {  535, 0x0000000000000000ULL, 0x94B0291AEC55F5BFULL }, /* XSUM_XXH64_testdata[1070] */
    {  535, 0x000000009E3779B1ULL, 0xCB9727B59D579EF7ULL }, /* XSUM_XXH64_testdata[1071] */
    {  536, 0x0000000000000000ULL, 0x514EF0CA1A6C2F67ULL }, /* XSUM_XXH64_testdata[1072] */
    {  536, 0x000000009E3779B1ULL, 0x1BB7E00DA01F12C0ULL }, /* XSUM_XXH64_testdata[1073] */
    {  537, 0x0000000000000000ULL, 0x5E457DC4B64AAE54ULL }, /* XSUM_XXH64_testdata[1074] */
    {  537, 0x000000009E3779B1ULL, 0xEED370DEDD42FABDULL }, /* XSUM_XXH64_testdata[1075] */
    {  538, 0x0000000000000000ULL, 0x666A59574A49612EULL }, /* XSUM_XXH64_testdata[1076] */
    {  538, 0x000000009E3779B1ULL, 0xFDC8FB5DB3AE0F27ULL }, /* XSUM_XXH64_testdata[1077] */
    {  539, 0x0000000000000000ULL, 0x943547AD457E482EULL }, /* XSUM_XXH64_testdata[1078] */
    {  539, 0x000000009E3779B1ULL, 0x26D0A12D8B1C7873ULL }, /* XSUM_XXH64_testdata[1079] */
    {  540, 0x0000000000000000ULL, 0xCEC717DEACCC2F1DULL }, /* XSUM_XXH64_testdata[1080] */
    {  540, 0x000000009E3779B1ULL, 0x25EA3202F903390FULL }, /* XSUM_XXH64_testdata[1081] */
    {  541, 0x0000000000000000ULL, 0xF9757DEF684219BBULL }, /* XSUM_XXH64_testdata[1082] */
    {  541, 0x000000009E3779B1ULL, 0xB51832F75506A45EULL }, /* XSUM_XXH64_testdata[1083] */
    {  542, 0x0000000000000000ULL, 0xF7FC4492A561E7DAULL }, /* XSUM_XXH64_testdata[1084] */
    {  542, 0x000000009E3779B1ULL, 0x520BDFABB1884D86ULL }, /* XSUM_XXH64_testdata[1085] */
    {  543, 0x0000000000000000ULL, 0x8CB6F74873BDF64DULL }, /* XSUM_XXH64_testdata[1086] */
    {  543, 0x000000009E3779B1ULL, 0xC1299E715C3A18EBULL }, /* XSUM_XXH64_testdata[1087] */
    {  544, 0x0000000000000000ULL, 0x1D91E7B1C88F52C1ULL }, /* XSUM_XXH64_testdata[1088] */
    {  544, 0x000000009E3779B1ULL, 0xB5DF68D5A96BF409ULL }, /* XSUM_XXH64_testdata[1089] */
    {  545, 0x0000000000000000ULL, 0x24A9D36A04E17F94ULL }, /* XSUM_XXH64_testdata[1090] */
    {  545, 0x000000009E3779B1ULL, 0x2631158788B7FB7BULL }, /* XSUM_XXH64_testdata[1091] */
    {  546, 0x0000000000000000ULL, 0xE9C08E1B73912007ULL }, /* XSUM_XXH64_testdata[1092] */
    {  546, 0x000000009E3779B1ULL, 0x7B172914DFC09111ULL }, /* XSUM_XXH64_testdata[1093] */
    {  547, 0x0000000000000000ULL, 0x75510DA9593070E1ULL }, /* XSUM_XXH64_testdata[1094] */
    {  547, 0x000000009E3779B1ULL, 0x41964CCFD38F3137ULL }, /* XSUM_XXH64_testdata[1095] */
    {  548, 0x0000000000000000ULL, 0x1677E77B436F885CULL }, /* XSUM_XXH64_testdata[1096] */
    {  548, 0x000000009E3779B1ULL, 0xAA706D5BF3D8D95FULL }, /* XSUM_XXH64_testdata[1097] */
    {  549, 0x0000000000000000ULL, 0x1A9F3999C9E39344ULL }, /* XSUM_XXH64_testdata[1098] */
    {  549, 0x000000009E3779B1ULL, 0x9F68FF0B00AE68F2ULL }, /* XSUM_XXH64_testdata[1099] */
    {  550, 0x0000000000000000ULL, 0x9D2016D72904F805ULL }, /* XSUM_XXH64_testdata[1100] */
    {  550, 0x000000009E3779B1ULL, 0x0141F8BC73F52A90ULL }, /* XSUM_XXH64_testdata[1101] */
    {  551, 0x0000000000000000ULL, 0x5CF03DF3A2F5D357ULL }, /* XSUM_XXH64_testdata[1102] */
    {  551, 0x000000009E3779B1ULL, 0x559C544C2056D112ULL }, /* XSUM_XXH64_testdata[1103] */
    {  552, 0x0000000000000000ULL, 0x01A97348A8EE6F91ULL }, /* XSUM_XXH64_testdata[1104] */
    {  552, 0x000000009E3779B1ULL, 0xE3AEC5D553649427ULL }, /* XSUM_XXH64_testdata[1105] */
    {  553, 0x0000000000000000ULL, 0x3F522FF45232CF2EULL }, /* XSUM_XXH64_testdata[1106] */
    {  553, 0x000000009E3779B1ULL, 0x34503F23E309AFAFULL }, /* XSUM_XXH64_testdata[1107] */
    {  554, 0x0000000000000000ULL, 0xA18266734BEE9F94ULL }, /* XSUM_XXH64_testdata[1108] */
    {  554, 0x000000009E3779B1ULL, 0x3D24F99B1E3B76D8ULL }, /* XSUM_XXH64_testdata[1109] */
    {  555, 0x0000000000000000ULL, 0xA0717DFB4A3B8E1EULL }, /* XSUM_XXH64_testdata[1110] */
    {  555, 0x000000009E3779B1ULL, 0xEEE4A23C2D8F50EFULL }, /* XSUM_XXH64_testdata[1111] */
    {  556, 0x0000000000000000ULL, 0x7F0F85DD67193185ULL }, /* XSUM_XXH64_testdata[1112] */
    {  556, 0x000000009E3779B1ULL, 0xDB42BAEA785B2CB9ULL }, /* XSUM_XXH64_testdata[1113] */
    {  557, 0x0000000000000000ULL, 0x56A244A82BC8FBB4ULL }, /* XSUM_XXH64_testdata[1114] */
    {  557, 0x000000009E3779B1ULL, 0x7D0F150511B37485ULL }, /* XSUM_XXH64_testdata[1115] */
    {  558, 0x0000000000000000ULL, 0x4E45075F05021681ULL }, /* XSUM_XXH64_testdata[1116] */
    {  558, 0x000000009E3779B1ULL, 0x036D48A8992DB51EULL }, /* XSUM_XXH64_testdata[1117] */
    {  559, 0x0000000000000000ULL, 0x5A9F9E3AD472B0DBULL }, /* XSUM_XXH64_testdata[1118] */
    {  559, 0x000000009E3779B1ULL, 0x65ACD2DF8EE4A20AULL }, /* XSUM_XXH64_testdata[1119] */
    {  560, 0x0000000000000000ULL, 0xDB6966B993245525ULL }, /* XSUM_XXH64_testdata[1120] */
    {  560, 0x000000009E3779B1ULL, 0x9DCE7E5C13232340ULL }, /* XSUM_XXH64_testdata[1121] */
    {  561, 0x0000000000000000ULL, 0xAD93CA30948BDB63ULL }, /* XSUM_XXH64_testdata[1122] */
    {  561, 0x000000009E3779B1ULL, 0xEEF7F0283AA720D3ULL }, /* XSUM_XXH64_testdata[1123] */
    {  562, 0x0000000000000000ULL, 0xE43B35E92AF3AED6ULL }, /* XSUM_XXH64_testdata[1124] */
    {  562, 0x000000009E3779B1ULL, 0xCF95BF0F3A88C074ULL }, /* XSUM_XXH64_testdata[1125] */
    {  563, 0x0000000000000000ULL, 0x8D5DC0F3EB4873F9ULL }, /* XSUM_XXH64_testdata[1126] */
    {  563, 0x000000009E3779B1ULL, 0x45754281C1FD99F2ULL }, /* XSUM_XXH64_testdata[1127] */
    {  564, 0x0000000000000000ULL, 0x6A293EBAB01624BCULL }, /* XSUM_XXH64_testdata[1128] */
    {  564, 0x000000009E3779B1ULL, 0xC0FFC55AEE6317FAULL }, /* XSUM_XXH64_testdata[1129] */
    {  565, 0x0000000000000000ULL, 0x04741407F8BBB92FULL }, /* XSUM_XXH64_testdata[1130] */
    {  565, 0x000000009E3779B1ULL, 0x5899532191106E6EULL }, /* XSUM_XXH64_testdata[1131] */
    {  566, 0x0000000000000000ULL, 0x9D090CF34641EA52ULL }, /* XSUM_XXH64_testdata[1132] */
    {  566, 0x000000009E3779B1ULL, 0x4C746EC3F55074D9ULL }, /* XSUM_XXH64_testdata[1133] */
    {  567, 0x0000000000000000ULL, 0x0955E5CEEA8A41C1ULL }, /* XSUM_XXH64_testdata[1134] */
    {  567, 0x000000009E3779B1ULL, 0xE976A4DD31668716ULL }, /* XSUM_XXH64_testdata[1135] */
    {  568, 0x0000000000000000ULL, 0x7E5B64DDD4B51173ULL }, /* XSUM_XXH64_testdata[1136] */
    {  568, 0x000000009E3779B1ULL, 0xB346F41C71BE5806ULL }, /* XSUM_XXH64_testdata[1137] */
    {  569, 0x0000000000000000ULL, 0xCCE1D2AA0FC3A229ULL }, /* XSUM_XXH64_testdata[1138] */
    {  569, 0x000000009E3779B1ULL, 0x94EDCA9E6CE6743AULL }, /* XSUM_XXH64_testdata[1139] */
    {  570, 0x0000000000000000ULL, 0xB8705873FE1AEB54ULL }, /* XSUM_XXH64_testdata[1140] */
    {  570, 0x000000009E3779B1ULL, 0xEA45C5C50E85D3B7ULL }, /* XSUM_XXH64_testdata[1141] */
    {  571, 0x0000000000000000ULL, 0x0DABE51C143E792AULL }, /* XSUM_XXH64_testdata[1142] */
    {  571, 0x000000009E3779B1ULL, 0x1C56D10D1F87A8B0ULL }, /* XSUM_XXH64_testdata[1143] */
    {  572, 0x0000000000000000ULL, 0x4AD363C1BC6EC5E1ULL }, /* XSUM_XXH64_testdata[1144] */
    {  572, 0x000000009E3779B1ULL, 0xCE9FC944B8F09C8DULL }, /* XSUM_XXH64_testdata[1145] */
    {  573, 0x0000000000000000ULL, 0x75FB48E97E37D8B8ULL }, /* XSUM_XXH64_testdata[1146] */
    {  573, 0x000000009E3779B1ULL, 0x6BB43FB17FC5B762ULL }, /* XSUM_XXH64_testdata[1147] */
    {  574, 0x0000000000000000ULL, 0xB3D328EB50D0CCF5ULL }, /* XSUM_XXH64_testdata[1148] */
    {  574, 0x000000009E3779B1ULL, 0x035E5DC924C3C493ULL }, /* XSUM_XXH64_testdata[1149] */
    {  575, 0x0000000000000000ULL, 0x31420D29B1218EE8ULL }, /* XSUM_XXH64_testdata[1150] */
    {  575, 0x000000009E3779B1ULL, 0x277A0972E51FEAE4ULL }, /* XSUM_XXH64_testdata[1151] */
    {  576, 0x0000000000000000ULL, 0x9A82A3688076DCA1ULL }, /* XSUM_XXH64_testdata[1152] */
    {  576, 0x000000009E3779B1ULL, 0xA26BA461FC9451F1ULL }, /* XSUM_XXH64_testdata[1153] */
    {  577, 0x0000000000000000ULL, 0xCD1C01B9E3F1FA6FULL }, /* XSUM_XXH64_testdata[1154] */
    {  577, 0x000000009E3779B1ULL, 0xD9CE5187CF5048DDULL }, /* XSUM_XXH64_testdata[1155] */
    {  578, 0x0000000000000000ULL, 0xDE91D2575FDAB0DBULL }, /* XSUM_XXH64_testdata[1156] */
    {  578, 0x000000009E3779B1ULL, 0x61B5D02A3741CFC2ULL }, /* XSUM_XXH64_testdata[1157] */
    {  579, 0x0000000000000000ULL, 0xB54C7DB3BB30256CULL }, /* XSUM_XXH64_testdata[1158] */
    {  579, 0x000000009E3779B1ULL, 0xA6689FBB8F816805ULL }, /* XSUM_XXH64_testdata[1159] */
    {  580, 0x0000000000000000ULL, 0x23530C044B342D2EULL }, /* XSUM_XXH64_testdata[1160] */
    {  580, 0x000000009E3779B1ULL, 0x5FC0A8196624DB66ULL }, /* XSUM_XXH64_testdata[1161] */
    {  581, 0x0000000000000000ULL, 0x839FB2088E05923FULL }, /* XSUM_XXH64_testdata[1162] */
    {  581, 0x000000009E3779B1ULL, 0xD6FE4112CBF7C688ULL }, /* XSUM_XXH64_testdata[1163] */
    {  582, 0x0000000000000000ULL, 0x677D89AEFB86101EULL }, /* XSUM_XXH64_testdata[1164] */
    {  582, 0x000000009E3779B1ULL, 0xFF958987E17A9409ULL }, /* XSUM_XXH64_testdata[1165] */
    {  583, 0x0000000000000000ULL, 0xDADE9284EBA56704ULL }, /* XSUM_XXH64_testdata[1166] */
    {  583, 0x000000009E3779B1ULL, 0x739B92BAF2F89A1FULL }, /* XSUM_XXH64_testdata[1167] */
    {  584, 0x0000000000000000ULL, 0x57209EFE0BAED0A7ULL }, /* XSUM_XXH64_testdata[1168] */
    {  584, 0x000000009E3779B1ULL, 0x68C502B2E4B75E2FULL }, /* XSUM_XXH64_testdata[1169] */
    {  585, 0x0000000000000000ULL, 0x0824099ACA7DEF3AULL }, /* XSUM_XXH64_testdata[1170] */
    {  585, 0x000000009E3779B1ULL, 0x31FBE2758EA5B59DULL }, /* XSUM_XXH64_testdata[1171] */
    {  586, 0x0000000000000000ULL, 0x2132D0949E6F7FDFULL }, /* XSUM_XXH64_testdata[1172] */
    {  586, 0x000000009E3779B1ULL, 0x625DB41B865B407DULL }, /* XSUM_XXH64_testdata[1173] */
    {  587, 0x0000000000000000ULL, 0x0E4746C2D50D5917ULL }, /* XSUM_XXH64_testdata[1174] */
    {  587, 0x000000009E3779B1ULL, 0x6DD623628AAC1761ULL }, /* XSUM_XXH64_testdata[1175] */
    {  588, 0x0000000000000000ULL, 0x77E3B32584EC50B4ULL }, /* XSUM_XXH64_testdata[1176] */
    {  588, 0x000000009E3779B1ULL, 0x69BE02B1BD3E7D37ULL }, /* XSUM_XXH64_testdata[1177] */
    {  589, 0x0000000000000000ULL, 0x3211124140F15B9DULL }, /* XSUM_XXH64_testdata[1178] */
    {  589, 0x000000009E3779B1ULL, 0x22EF084D2775F861ULL }, /* XSUM_XXH64_testdata[1179] */
    {  590, 0x0000000000000000ULL, 0xB4FA8435F567A322ULL }, /* XSUM_XXH64_testdata[1180] */
    {  590, 0x000000009E3779B1ULL, 0x21555016402E2716ULL }, /* XSUM_XXH64_testdata[1181] */
    {  591, 0x0000000000000000ULL, 0x3818FA95FE7ACB51ULL }, /* XSUM_XXH64_testdata[1182] */
    {  591, 0x000000009E3779B1ULL, 0x0E3BECB4E1C24C8BULL }, /* XSUM_XXH64_testdata[1183] */
    {  592, 0x0000000000000000ULL, 0x028C1C95C8857B29ULL }, /* XSUM_XXH64_testdata[1184] */
    {  592, 0x000000009E3779B1ULL, 0xBD7D4EFBF0828800ULL }, /* XSUM_XXH64_testdata[1185] */
    {  593, 0x0000000000000000ULL, 0x13C771779493B733ULL }, /* XSUM_XXH64_testdata[1186] */
    {  593, 0x000000009E3779B1ULL, 0x1018A1A348C8529CULL }, /* XSUM_XXH64_testdata[1187] */
    {  594, 0x0000000000000000ULL, 0xCDEBCA2E7F9D61E2ULL }, /* XSUM_XXH64_testdata[1188] */
    {  594, 0x000000009E3779B1ULL, 0x8309751820BD5BD3ULL }, /* XSUM_XXH64_testdata[1189] */
    {  595, 0x0000000000000000ULL, 0xE5478C3566BAB476ULL }, /* XSUM_XXH64_testdata[1190] */
    {  595, 0x000000009E3779B1ULL, 0x2BF32F50757E7FC1ULL }, /* XSUM_XXH64_testdata[1191] */
    {  596, 0x0000000000000000ULL, 0xF06A6CF2E8013156ULL }, /* XSUM_XXH64_testdata[1192] */
    {  596, 0x000000009E3779B1ULL, 0xBEF2B245D5C55DCCULL }, /* XSUM_XXH64_testdata[1193] */
    {  597, 0x0000000000000000ULL, 0x266F81CA0C23969BULL }, /* XSUM_XXH64_testdata[1194] */
    {  597, 0x000000009E3779B1ULL, 0x43642EFFD2FF7FEBULL }, /* XSUM_XXH64_testdata[1195] */
    {  598, 0x0000000000000000ULL, 0xA1BF901879F23F2AULL }, /* XSUM_XXH64_testdata[1196] */
    {  598, 0x000000009E3779B1ULL, 0xD3B509D517D12EC2ULL }, /* XSUM_XXH64_testdata[1197] */
    {  599, 0x0000000000000000ULL, 0x7C28CEDF6719474CULL }, /* XSUM_XXH64_testdata[1198] */
    {  599, 0x000000009E3779B1ULL, 0x6C5EAF85A7EC336AULL }, /* XSUM_XXH64_testdata[1199] */
    {  600, 0x0000000000000000ULL, 0x4CF9BF91EEB83F5EULL }, /* XSUM_XXH64_testdata[1200] */
    {  600, 0x000000009E3779B1ULL, 0x8EB951D069F91173ULL }, /* XSUM_XXH64_testdata[1201] */
    {  601, 0x0000000000000000ULL, 0x76E4539EA0EC590AULL }, /* XSUM_XXH64_testdata[1202] */
    {  601, 0x000000009E3779B1ULL, 0x22D996A8C929BE36ULL }, /* XSUM_XXH64_testdata[1203] */
    {  602, 0x0000000000000000ULL, 0x6FC0470B9D6EF4BEULL }, /* XSUM_XXH64_testdata[1204] */
    {  602, 0x000000009E3779B1ULL, 0x732C159EF613A0AAULL }, /* XSUM_XXH64_testdata[1205] */
    {  603, 0x0000000000000000ULL, 0xDDE052EA3BE2DACBULL }, /* XSUM_XXH64_testdata[1206] */
    {  603, 0x000000009E3779B1ULL, 0xCD49648FB4255D9DULL }, /* XSUM_XXH64_testdata[1207] */
    {  604, 0x0000000000000000ULL, 0xC90718CBA116E8EBULL }, /* XSUM_XXH64_testdata[1208] */
    {  604, 0x000000009E3779B1ULL, 0x10D6EC864F249926ULL }, /* XSUM_XXH64_testdata[1209] */
    {  605, 0x0000000000000000ULL, 0x1D58456BD464E73BULL }, /* XSUM_XXH64_testdata[1210] */
    {  605, 0x000000009E3779B1ULL, 0x4E90CC7890B43AAFULL }, /* XSUM_XXH64_testdata[1211] */
    {  606, 0x0000000000000000ULL, 0x597B6B3D90474AF9ULL }, /* XSUM_XXH64_testdata[1212] */
    {  606, 0x000000009E3779B1ULL, 0xF194718DA7019B29ULL }, /* XSUM_XXH64_testdata[1213] */
    {  607, 0x0000000000000000ULL, 0x33FCE41AECD21B33ULL }, /* XSUM_XXH64_testdata[1214] */
    {  607, 0x000000009E3779B1ULL, 0x43A2FA652A93584FULL }, /* XSUM_XXH64_testdata[1215] */
    {  608, 0x0000000000000000ULL, 0x2C0D59728FC01D2DULL }, /* XSUM_XXH64_testdata[1216] */
    {  608, 0x000000009E3779B1ULL, 0x44658B1996C7C0BDULL }, /* XSUM_XXH64_testdata[1217] */
    {  609, 0x0000000000000000ULL, 0xC7F6D6C4F5DC29E2ULL }, /* XSUM_XXH64_testdata[1218] */
    {  609, 0x000000009E3779B1ULL, 0xEED87EFF534007FFULL }, /* XSUM_XXH64_testdata[1219] */
    {  610, 0x0000000000000000ULL, 0x9AFB66E22BB9905FULL }, /* XSUM_XXH64_testdata[1220] */
    {  610, 0x000000009E3779B1ULL, 0xE106E1D712DD0192ULL }, /* XSUM_XXH64_testdata[1221] */
    {  611, 0x0000000000000000ULL, 0xF6B2DF840401FA0AULL }, /* XSUM_XXH64_testdata[1222] */
    {  611, 0x000000009E3779B1ULL, 0xA28BFC4E5702604BULL }, /* XSUM_XXH64_testdata[1223] */
    {  612, 0x0000000000000000ULL, 0xC8162570DC9FD003ULL }, /* XSUM_XXH64_testdata[1224] */
    {  612, 0x000000009E3779B1ULL, 0xA3E7D200D05B2D62ULL }, /* XSUM_XXH64_testdata[1225] */
    {  613, 0x0000000000000000ULL, 0x0286AC3D8F903D14ULL }, /* XSUM_XXH64_testdata[1226] */
    {  613, 0x000000009E3779B1ULL, 0xA33D10BDF53F315FULL }, /* XSUM_XXH64_testdata[1227] */
    {  614, 0x0000000000000000ULL, 0xBFF52353CB1757B4ULL }, /* XSUM_XXH64_testdata[1228] */
    {  614, 0x000000009E3779B1ULL, 0x86A97CDCA9B5A477ULL }, /* XSUM_XXH64_testdata[1229] */
    {  615, 0x0000000000000000ULL, 0x48B8C108F7D13A60ULL }, /* XSUM_XXH64_testdata[1230] */
    {  615, 0x000000009E3779B1ULL, 0xE25292046D57587AULL }, /* XSUM_XXH64_testdata[1231] */
    {  616, 0x0000000000000000ULL, 0x91D2D038C70D3A71ULL }, /* XSUM_XXH64_testdata[1232] */
    {  616, 0x000000009E3779B1ULL, 0x3E83FEBD509A00F4ULL }, /* XSUM_XXH64_testdata[1233] */
    {  617, 0x0000000000000000ULL, 0xCCB0593427579E67ULL }, /* XSUM_XXH64_testdata[1234] */
    {  617, 0x000000009E3779B1ULL, 0x13666E020DA9824EULL }, /* XSUM_XXH64_testdata[1235] */
    {  618, 0x0000000000000000ULL, 0x19ED6CED369FD9A3ULL }, /* XSUM_XXH64_testdata[1236] */
    {  618, 0x000000009E3779B1ULL, 0xFBDBF98D38F54A6DULL }, /* XSUM_XXH64_testdata[1237] */
    {  619, 0x0000000000000000ULL, 0xCBAB11A3AB6AF17BULL }, /* XSUM_XXH64_testdata[1238] */
    {  619, 0x000000009E3779B1ULL, 0x3ED046C76C444D61ULL }, /* XSUM_XXH64_testdata[1239] */
    {  620, 0x0000000000000000ULL, 0x5BD2185552367428ULL }, /* XSUM_XXH64_testdata[1240] */
    {  620, 0x000000009E3779B1ULL, 0xA2F581AE68859F21ULL }, /* XSUM_XXH64_testdata[1241] */
    {  621, 0x0000000000000000ULL, 0x47C5D42249D5D9B2ULL }, /* XSUM_XXH64_testdata[1242] */
    {  621, 0x000000009E3779B1ULL, 0x5D6F07C76B82CCC5ULL }, /* XSUM_XXH64_testdata[1243] */
    {  622, 0x0000000000000000ULL, 0x28488E1E8D7C584FULL }, /* XSUM_XXH64_testdata[1244] */
    {  622, 0x000000009E3779B1ULL, 0xABEEE1826D2B7A8BULL }, /* XSUM_XXH64_testdata[1245] */
    {  623, 0x0000000000000000ULL, 0xA55B551214AC23E0ULL }, /* XSUM_XXH64_testdata[1246] */
    {  623, 0x000000009E3779B1ULL, 0x688F5CD0E04C6158ULL }, /* XSUM_XXH64_testdata[1247] */
    {  624, 0x0000000000000000ULL, 0xAEB650EBD621F387ULL }, /* XSUM_XXH64_testdata[1248] */
    {  624, 0x000000009E3779B1ULL, 0x33B2FE54265F02CFULL }, /* XSUM_XXH64_testdata[1249] */
    {  625, 0x0000000000000000ULL, 0x897A1A0D4829023CULL }, /* XSUM_XXH64_testdata[1250] */
    {  625, 0x000000009E3779B1ULL, 0x6683A75899BE3D91ULL }, /* XSUM_XXH64_testdata[1251] */
    {  626, 0x0000000000000000ULL, 0x04884E809EB22519ULL }, /* XSUM_XXH64_testdata[1252] */
    {  626, 0x000000009E3779B1ULL, 0x80BFEB79D9034898ULL }, /* XSUM_XXH64_testdata[1253] */
    {  627, 0x0000000000000000ULL, 0xDC7E98BD10C22E76ULL }, /* XSUM_XXH64_testdata[1254] */
    {  627, 0x000000009E3779B1ULL, 0x1E634DBF400D8600ULL }, /* XSUM_XXH64_testdata[1255] */
    {  628, 0x0000000000000000ULL, 0x1E7241D5A438AFABULL }, /* XSUM_XXH64_testdata[1256] */
    {  628, 0x000000009E3779B1ULL, 0xADEFCEE39DE12098ULL }, /* XSUM_XXH64_testdata[1257] */
    {  629, 0x0000000000000000ULL, 0xD61E28979B7A48A1ULL }, /* XSUM_XXH64_testdata[1258] */
    {  629, 0x000000009E3779B1ULL, 0x445F302C5BD6ED7AULL }, /* XSUM_XXH64_testdata[1259] */
    {  630, 0x0000000000000000ULL, 0xF8260CCD2AC544A4ULL }, /* XSUM_XXH64_testdata[1260] */
    {  630, 0x000000009E3779B1ULL, 0x9EC84ADBE50F237DULL }, /* XSUM_XXH64_testdata[1261] */
    {  631, 0x0000000000000000ULL, 0xE6AA30BF55D14345ULL }, /* XSUM_XXH64_testdata[1262] */
    {  631, 0x000000009E3779B1ULL, 0x67C96B811EF88722ULL }, /* XSUM_XXH64_testdata[1263] */
    {  632, 0x0000000000000000ULL, 0x649255ED735C6898ULL }, /* XSUM_XXH64_testdata[1264] */
    {  632, 0x000000009E3779B1ULL, 0x943C3B50B2F484B4ULL }, /* XSUM_XXH64_testdata[1265] */
    {  633, 0x0000000000000000ULL, 0xCF71E354BD84268CULL }, /* XSUM_XXH64_testdata[1266] */
    {  633, 0x000000009E3779B1ULL, 0xAF7DF853CDB8079DULL }, /* XSUM_XXH64_testdata[1267] */
    {  634, 0x0000000000000000ULL, 0x46D4D303191EE5B0ULL }, /* XSUM_XXH64_testdata[1268] */
    {  634, 0x000000009E3779B1ULL, 0xB609739F92C47F52ULL }, /* XSUM_XXH64_testdata[1269] */
    {  635, 0x0000000000000000ULL, 0x1C9F320B91A6BB9EULL }, /* XSUM_XXH64_testdata[1270] */
    {  635, 0x000000009E3779B1ULL, 0xA12B660719BE10E3ULL }, /* XSUM_XXH64_testdata[1271] */
    {  636, 0x0000000000000000ULL, 0x26AC22CAE7CF5B0CULL }, /* XSUM_XXH64_testdata[1272] */
    {  636, 0x000000009E3779B1ULL, 0xD9C080A364645562ULL }, /* XSUM_XXH64_testdata[1273] */
    {  637, 0x0000000000000000ULL, 0xBCD103BB91439585ULL }, /* XSUM_XXH64_testdata[1274] */
    {  637, 0x000000009E3779B1ULL, 0xAD2616E969EDA0EFULL }, /* XSUM_XXH64_testdata[1275] */
    {  638, 0x0000000000000000ULL, 0xB1D101AC570CF57EULL }, /* XSUM_XXH64_testdata[1276] */
    {  638, 0x000000009E3779B1ULL, 0xA0F62D7CBDFFD19CULL }, /* XSUM_XXH64_testdata[1277] */
    {  639, 0x0000000000000000ULL, 0x7B534B7165B57FD2ULL }, /* XSUM_XXH64_testdata[1278] */
    {  639, 0x000000009E3779B1ULL, 0x436F1881A21AE883ULL }, /* XSUM_XXH64_testdata[1279] */
    {  640, 0x0000000000000000ULL, 0x05FF3E1DB4BB4690ULL }, /* XSUM_XXH64_testdata[1280] */
    {  640, 0x000000009E3779B1ULL, 0xF03DB7272A4E48BCULL }, /* XSUM_XXH64_testdata[1281] */
    {  641, 0x0000000000000000ULL, 0xA29AA8B123F0C7F1ULL }, /* XSUM_XXH64_testdata[1282] */
    {  641, 0x000000009E3779B1ULL, 0x2B2A53BDE1F1B6F1ULL }, /* XSUM_XXH64_testdata[1283] */
    {  642, 0x0000000000000000ULL, 0x4A2ACEC0CBF88F2BULL }, /* XSUM_XXH64_testdata[1284] */
    {  642, 0x000000009E3779B1ULL, 0x01B05DE3AB4B6341ULL }, /* XSUM_XXH64_testdata[1285] */
    {  643, 0x0000000000000000ULL, 0x56CB71243229B81AULL }, /* XSUM_XXH64_testdata[1286] */
    {  643, 0x000000009E3779B1ULL, 0x827F91416F18F758ULL }, /* XSUM_XXH64_testdata[1287] */
    {  644, 0x0000000000000000ULL, 0x59535655F5B6529FULL }, /* XSUM_XXH64_testdata[1288] */
    {  644, 0x000000009E3779B1ULL, 0x8B72B8ACC3F15BB2ULL }, /* XSUM_XXH64_testdata[1289] */
    {  645, 0x0000000000000000ULL, 0x19163BB1ACEBC103ULL }, /* XSUM_XXH64_testdata[1290] */
    {  645, 0x000000009E3779B1ULL, 0x84C375B214BB34A2ULL }, /* XSUM_XXH64_testdata[1291] */
    {  646, 0x0000000000000000ULL, 0x431590E65CE3BBE9ULL }, /* XSUM_XXH64_testdata[1292] */
    {  646, 0x000000009E3779B1ULL, 0xA93010265389DB3AULL }, /* XSUM_XXH64_testdata[1293] */
    {  647, 0x0000000000000000ULL, 0x55A15D30750F36CAULL }, /* XSUM_XXH64_testdata[1294] */
    {  647, 0x000000009E3779B1ULL, 0x350FE3E8E02421DFULL }, /* XSUM_XXH64_testdata[1295] */
    {  648, 0x0000000000000000ULL, 0x2D05962C50F073CBULL }, /* XSUM_XXH64_testdata[1296] */
    {  648, 0x000000009E3779B1ULL, 0x067196515DD251BAULL }, /* XSUM_XXH64_testdata[1297] */
    {  649, 0x0000000000000000ULL, 0xF72F7CCCF5391A99ULL }, /* XSUM_XXH64_testdata[1298] */
    {  649, 0x000000009E3779B1ULL, 0x6047D16A8BC7DCCAULL }, /* XSUM_XXH64_testdata[1299] */
    {  650, 0x0000000000000000ULL, 0x471707CBCF6299A1ULL }, /* XSUM_XXH64_testdata[1300] */
    {  650, 0x000000009E3779B1ULL, 0x8A929579D2BED71EULL }, /* XSUM_XXH64_testdata[1301] */
    {  651, 0x0000000000000000ULL, 0xECA5BBC4C934388AULL }, /* XSUM_XXH64_testdata[1302] */
    {  651, 0x000000009E3779B1ULL, 0x26713BCB28E26A79ULL }, /* XSUM_XXH64_testdata[1303] */
    {  652, 0x0000000000000000ULL, 0xB4772705B6696A70ULL }, /* XSUM_XXH64_testdata[1304] */
    {  652, 0x000000009E3779B1ULL, 0xB3784B97F8AC34F5ULL }, /* XSUM_XXH64_testdata[1305] */
    {  653, 0x0000000000000000ULL, 0x814AAD0468A8B2EFULL }, /* XSUM_XXH64_testdata[1306] */
    {  653, 0x000000009E3779B1ULL, 0x4D1AA4C88DD2F9FDULL }, /* XSUM_XXH64_testdata[1307] */
    {  654, 0x0000000000000000ULL, 0xE553302216B85C57ULL }, /* XSUM_XXH64_testdata[1308] */
    {  654, 0x000000009E3779B1ULL, 0x369F72F1FB7D7B94ULL }, /* XSUM_XXH64_testdata[1309] */
    {  655, 0x0000000000000000ULL, 0x70081023630B7CF1ULL }, /* XSUM_XXH64_testdata[1310] */
    {  655, 0x000000009E3779B1ULL, 0x6CFAFD089A4295E9ULL }, /* XSUM_XXH64_testdata[1311] */
    {  656, 0x0000000000000000ULL, 0x03DC7B218DF637FDULL }, /* XSUM_XXH64_testdata[1312] */
    {  656, 0x000000009E3779B1ULL, 0xFD697A1126BB52AEULL }, /* XSUM_XXH64_testdata[1313] */
    {  657, 0x0000000000000000ULL, 0xF57606558F42A829ULL }, /* XSUM_XXH64_testdata[1314] */
    {  657, 0x000000009E3779B1ULL, 0xD0704822BBF6FCFAULL }, /* XSUM_XXH64_testdata[1315] */
    {  658, 0x0000000000000000ULL, 0xDD9B01EA7E6EC4E4ULL }, /* XSUM_XXH64_testdata[1316] */
    {  658, 0x000000009E3779B1ULL, 0x7EE41C884D6306A7ULL }, /* XSUM_XXH64_testdata[1317] */
    {  659, 0x0000000000000000ULL, 0x57C8B061FA3665FEULL }, /* XSUM_XXH64_testdata[1318] */
    {  659, 0x000000009E3779B1ULL, 0xF40AB81323746F5AULL }, /* XSUM_XXH64_testdata[1319] */
    {  660, 0x0000000000000000ULL, 0xE02D3157266D7735ULL }, /* XSUM_XXH64_testdata[1320] */
    {  660, 0x000000009E3779B1ULL, 0x5EC929E844079B91ULL }, /* XSUM_XXH64_testdata[1321] */
    {  661, 0x0000000000000000ULL, 0x3CAA66663E9CFD4AULL }, /* XSUM_XXH64_testdata[1322] */
    {  661, 0x000000009E3779B1ULL, 0xF95ED3862F7671BEULL }, /* XSUM_XXH64_testdata[1323] */
    {  662, 0x0000000000000000ULL, 0xE5B2C7FAB00FB483ULL }, /* XSUM_XXH64_testdata[1324] */
    {  662, 0x000000009E3779B1ULL, 0x296B751149F59309ULL }, /* XSUM_XXH64_testdata[1325] */
    {  663, 0x0000000000000000ULL, 0xD6B2C560C538FB20ULL }, /* XSUM_XXH64_testdata[1326] */
    {  663, 0x000000009E3779B1ULL, 0x95F844EFCBB88297ULL }, /* XSUM_XXH64_testdata[1327] */
    {  664, 0x0000000000000000ULL, 0x2F3AB5ED460D5A41ULL }, /* XSUM_XXH64_testdata[1328] */
    {  664, 0x000000009E3779B1ULL, 0x38B74AA4AB2849DDULL }, /* XSUM_XXH64_testdata[1329] */
    {  665, 0x0000000000000000ULL, 0x8EDDAD24C85225B3ULL }, /* XSUM_XXH64_testdata[1330] */
    {  665, 0x000000009E3779B1ULL, 0x31A63232E799EF65ULL }, /* XSUM_XXH64_testdata[1331] */
    {  666, 0x0000000000000000ULL, 0x2281EA033306A216ULL }, /* XSUM_XXH64_testdata[1332] */
    {  666, 0x000000009E3779B1ULL, 0xD6EE53C2002531F5ULL }, /* XSUM_XXH64_testdata[1333] */
    {  667, 0x0000000000000000ULL, 0xC48A2E048533D300ULL }, /* XSUM_XXH64_testdata[1334] */
    {  667, 0x000000009E3779B1ULL, 0x4372C9C6DD4EC657ULL }, /* XSUM_XXH64_testdata[1335] */
    {  668, 0x0000000000000000ULL, 0x192DB67E9199A52EULL }, /* XSUM_XXH64_testdata[1336] */
    {  668, 0x000000009E3779B1ULL, 0x0FE34901633955EBULL }, /* XSUM_XXH64_testdata[1337] */
    {  669, 0x0000000000000000ULL, 0xE90A5997740C4248ULL }, /* XSUM_XXH64_testdata[1338] */
    {  669, 0x000000009E3779B1ULL, 0x076611986F06BB7BULL }, /* XSUM_XXH64_testdata[1339] */
    {  670, 0x0000000000000000ULL, 0x51E21FF885EE405BULL }, /* XSUM_XXH64_testdata[1340] */
    {  670, 0x000000009E3779B1ULL, 0x49B0128D84D9EFDBULL }, /* XSUM_XXH64_testdata[1341] */
    {  671, 0x0000000000000000ULL, 0xC5FDFD16766CAD4FULL }, /* XSUM_XXH64_testdata[1342] */
    {  671, 0x000000009E3779B1ULL, 0x0B0C59B2630F465AULL }, /* XSUM_XXH64_testdata[1343] */
    {  672, 0x0000000000000000ULL, 0x1BE3A090C1434100ULL }, /* XSUM_XXH64_testdata[1344] */
    {  672, 0x000000009E3779B1ULL, 0x845A616FF80C3155ULL }, /* XSUM_XXH64_testdata[1345] */
    {  673, 0x0000000000000000ULL, 0x490401AA5582784CULL }, /* XSUM_XXH64_testdata[1346] */
    {  673, 0x000000009E3779B1ULL, 0x0E9BE22886BD6FC4ULL }, /* XSUM_XXH64_testdata[1347] */
    {  674, 0x0000000000000000ULL, 0x0B104279E4777227ULL }, /* XSUM_XXH64_testdata[1348] */
    {  674, 0x000000009E3779B1ULL, 0xE153FD5F3A568AB9ULL }, /* XSUM_XXH64_testdata[1349] */
    {  675, 0x0000000000000000ULL, 0x7A1B59E94AD0BD16ULL }, /* XSUM_XXH64_testdata[1350] */
    {  675, 0x000000009E3779B1ULL, 0xAA176933FF6DC264ULL }, /* XSUM_XXH64_testdata[1351] */
    {  676, 0x0000000000000000ULL, 0xCBE6FA0E2978808AULL }, /* XSUM_XXH64_testdata[1352] */
    {  676, 0x000000009E3779B1ULL, 0xA6746B4110BC5B8EULL }, /* XSUM_XXH64_testdata[1353] */
    {  677, 0x0000000000000000ULL, 0x2AF1F2BAA896BF3FULL }, /* XSUM_XXH64_testdata[1354] */
    {  677, 0x000000009E3779B1ULL, 0x1CDC19AA2BB2BFA1ULL }, /* XSUM_XXH64_testdata[1355] */
    {  678, 0x0000000000000000ULL, 0xCF271A2B03E29283ULL }, /* XSUM_XXH64_testdata[1356] */
    {  678, 0x000000009E3779B1ULL, 0xF60C189AA7559BD8ULL }, /* XSUM_XXH64_testdata[1357] */
    {  679, 0x0000000000000000ULL, 0xB23EDF020B943EA0ULL }, /* XSUM_XXH64_testdata[1358] */
    {  679, 0x000000009E3779B1ULL, 0x5425739195F5C00CULL }, /* XSUM_XXH64_testdata[1359] */
    {  680, 0x0000000000000000ULL, 0xDA85E4B3126B21DBULL }, /* XSUM_XXH64_testdata[1360] */
    {  680, 0x000000009E3779B1ULL, 0xD3665DDE6B323975ULL }, /* XSUM_XXH64_testdata[1361] */
    {  681, 0x0000000000000000ULL, 0xB96F22C931B7A78BULL }, /* XSUM_XXH64_testdata[1362] */
    {  681, 0x000000009E3779B1ULL, 0x737917FC9F3DFDBEULL }, /* XSUM_XXH64_testdata[1363] */
    {  682, 0x0000000000000000ULL, 0x23D788241F7C70F4ULL }, /* XSUM_XXH64_testdata[1364] */
    {  682, 0x000000009E3779B1ULL, 0x4609B4CED6A47DE3ULL }, /* XSUM_XXH64_testdata[1365] */
    {  683, 0x0000000000000000ULL, 0x495242859DB54586ULL }, /* XSUM_XXH64_testdata[1366] */
    {  683, 0x000000009E3779B1ULL, 0x29120312D672CDD9ULL }, /* XSUM_XXH64_testdata[1367] */
    {  684, 0x0000000000000000ULL, 0x5BE5B8806940EBB1ULL }, /* XSUM_XXH64_testdata[1368] */
    {  684, 0x000000009E3779B1ULL, 0xF58F2D336C043805ULL }, /* XSUM_XXH64_testdata[1369] */
    {  685, 0x0000000000000000ULL, 0x4E2DCB4DF2BA078CULL }, /* XSUM_XXH64_testdata[1370] */
    {  685, 0x000000009E3779B1ULL, 0x6BEC5D8411B5C5ABULL }, /* XSUM_XXH64_testdata[1371] */
    {  686, 0x0000000000000000ULL, 0xC27F045E440D82E1ULL }, /* XSUM_XXH64_testdata[1372] */
    {  686, 0x000000009E3779B1ULL, 0x6184A044E5F84F33ULL }, /* XSUM_XXH64_testdata[1373] */
    {  687, 0x0000000000000000ULL, 0x45EB29A7913AFE09ULL }, /* XSUM_XXH64_testdata[1374] */
    {  687, 0x000000009E3779B1ULL, 0x365B61CB3BE73A26ULL }, /* XSUM_XXH64_testdata[1375] */
    {  688, 0x0000000000000000ULL, 0x8111415B9A605841ULL }, /* XSUM_XXH64_testdata[1376] */
    {  688, 0x000000009E3779B1ULL, 0xD4365B0DBF613534ULL }, /* XSUM_XXH64_testdata[1377] */
    {  689, 0x0000000000000000ULL, 0x203E45B644BDB08CULL }, /* XSUM_XXH64_testdata[1378] */
    {  689, 0x000000009E3779B1ULL, 0x4DDFEF03E0077CD3ULL }, /* XSUM_XXH64_testdata[1379] */
    {  690, 0x0000000000000000ULL, 0x23F495E0695600BBULL }, /* XSUM_XXH64_testdata[1380] */
    {  690, 0x000000009E3779B1ULL, 0x4B9493FF4E180341ULL }, /* XSUM_XXH64_testdata[1381] */
    {  691, 0x0000000000000000ULL, 0xF5DA20A3FA1CCBF0ULL }, /* XSUM_XXH64_testdata[1382] */
    {  691, 0x000000009E3779B1ULL, 0x80DC95CB42AA3040ULL }, /* XSUM_XXH64_testdata[1383] */
    {  692, 0x0000000000000000ULL, 0x6086216334B1099FULL }, /* XSUM_XXH64_testdata[1384] */
    {  692, 0x000000009E3779B1ULL, 0x202D03318BB5C23EULL }, /* XSUM_XXH64_testdata[1385] */
    {  693, 0x0000000000000000ULL, 0xA30002512E9FD4D6ULL }, /* XSUM_XXH64_testdata[1386] */
    {  693, 0x000000009E3779B1ULL, 0xF3E418E8E77B26F2ULL }, /* XSUM_XXH64_testdata[1387] */
    {  694, 0x0000000000000000ULL, 0x96828F3F86928C1BULL }, /* XSUM_XXH64_testdata[1388] */
    {  694, 0x000000009E3779B1ULL, 0xD68CA98AF0A1C386ULL }, /* XSUM_XXH64_testdata[1389] */
    {  695, 0x0000000000000000ULL, 0x1BB181CD4DBB454EULL }, /* XSUM_XXH64_testdata[1390] */
    {  695, 0x000000009E3779B1ULL, 0x373BD8F68C3C46D7ULL }, /* XSUM_XXH64_testdata[1391] */
    {  696, 0x0000000000000000ULL, 0xB0232C45D98C3FE2ULL }, /* XSUM_XXH64_testdata[1392] */
    {  696, 0x000000009E3779B1ULL, 0x9B50610C42819A28ULL }, /* XSUM_XXH64_testdata[1393] */
    {  697, 0x0000000000000000ULL, 0x9202956062E5FB18ULL }, /* XSUM_XXH64_testdata[1394] */
    {  697, 0x000000009E3779B1ULL, 0x8E311C53E693B3E8ULL }, /* XSUM_XXH64_testdata[1395] */
    {  698, 0x0000000000000000ULL, 0x8FC572079C9A24A4ULL }, /* XSUM_XXH64_testdata[1396] */
    {  698, 0x000000009E3779B1ULL, 0xADFE770D69BF07C8ULL }, /* XSUM_XXH64_testdata[1397] */
    {  699, 0x0000000000000000ULL, 0xA2B5A9750E746425ULL }, /* XSUM_XXH64_testdata[1398] */
    {  699, 0x000000009E3779B1ULL, 0xD4EB32CD53EB3148ULL }, /* XSUM_XXH64_testdata[1399] */
    {  700, 0x0000000000000000ULL, 0xC685236A544B5D40ULL }, /* XSUM_XXH64_testdata[1400] */
    {  700, 0x000000009E3779B1ULL, 0x32478E6520378C30ULL }, /* XSUM_XXH64_testdata[1401] */
    {  701, 0x0000000000000000ULL, 0x2D92BC4741267973ULL }, /* XSUM_XXH64_testdata[1402] */
    {  701, 0x000000009E3779B1ULL, 0xB78789A086DECE21ULL }, /* XSUM_XXH64_testdata[1403] */
    {  702, 0x0000000000000000ULL, 0x453111B594EF4545ULL }, /* XSUM_XXH64_testdata[1404] */
    {  702, 0x000000009E3779B1ULL, 0xFAE1FA4060B2A98EULL }, /* XSUM_XXH64_testdata[1405] */
    {  703, 0x0000000000000000ULL, 0x3BF9F17B5FBDBCA4ULL }, /* XSUM_XXH64_testdata[1406] */
    {  703, 0x000000009E3779B1ULL, 0xE66E66041C5B5F87ULL }, /* XSUM_XXH64_testdata[1407] */
    {  704, 0x0000000000000000ULL, 0x221C7CC7895C1B5AULL }, /* XSUM_XXH64_testdata[1408] */
    {  704, 0x000000009E3779B1ULL, 0x5C2C536AFF933B18ULL }, /* XSUM_XXH64_testdata[1409] */
    {  705, 0x0000000000000000ULL, 0x1027CEB18C4E43C4ULL }, /* XSUM_XXH64_testdata[1410] */
    {  705, 0x000000009E3779B1ULL, 0x3C54F98CE994DEB3ULL }, /* XSUM_XXH64_testdata[1411] */
    {  706, 0x0000000000000000ULL, 0x6B713027F4B7A434ULL }, /* XSUM_XXH64_testdata[1412] */
    {  706, 0x000000009E3779B1ULL, 0x5EF378BC5519FC55ULL }, /* XSUM_XXH64_testdata[1413] */
    {  707, 0x0000000000000000ULL, 0x07AF4FA7880E2DD5ULL }, /* XSUM_XXH64_testdata[1414] */
    {  707, 0x000000009E3779B1ULL, 0xBAD0E90C34FBB62DULL }, /* XSUM_XXH64_testdata[1415] */
    {  708, 0x0000000000000000ULL, 0xDD099BE5AD5AA854ULL }, /* XSUM_XXH64_testdata[1416] */
    {  708, 0x000000009E3779B1ULL, 0x084D4A032981B899ULL }, /* XSUM_XXH64_testdata[1417] */
    {  709, 0x0000000000000000ULL, 0x180DC3778B7A2100ULL }, /* XSUM_XXH64_testdata[1418] */
    {  709, 0x000000009E3779B1ULL, 0xE4CF857778B079C5ULL }, /* XSUM_XXH64_testdata[1419] */
    {  710, 0x0000000000000000ULL, 0x5561E952ABEB2F53ULL }, /* XSUM_XXH64_testdata[1420] */
    {  710, 0x000000009E3779B1ULL, 0x238148B86DC01222ULL }, /* XSUM_XXH64_testdata[1421] */
    {  711, 0x0000000000000000ULL, 0xC25EF08D840957C8ULL }, /* XSUM_XXH64_testdata[1422] */
    {  711, 0x000000009E3779B1ULL, 0x145BCD25D86DE9A4ULL }, /* XSUM_XXH64_testdata[1423] */
    {  712, 0x0000000000000000ULL, 0xDBA9489B8EA3BD12ULL }, /* XSUM_XXH64_testdata[1424] */
    {  712, 0x000000009E3779B1ULL, 0x6B809097A99748E1ULL }, /* XSUM_XXH64_testdata[1425] */
    {  713, 0x0000000000000000ULL, 0x2C78A12EE6FE7105ULL }, /* XSUM_XXH64_testdata[1426] */
    {  713, 0x000000009E3779B1ULL, 0x7DAA11C6EB88B381ULL }, /* XSUM_XXH64_testdata[1427] */
    {  714, 0x0000000000000000ULL, 0xD4482CCF3336E3A4ULL }, /* XSUM_XXH64_testdata[1428] */
    {  714, 0x000000009E3779B1ULL, 0x0B30DEDD0A128848ULL }, /* XSUM_XXH64_testdata[1429] */
    {  715, 0x0000000000000000ULL, 0x5EC939F5D2CE811EULL }, /* XSUM_XXH64_testdata[1430] */
    {  715, 0x000000009E3779B1ULL, 0xBBF2EE793BE646CCULL }, /* XSUM_XXH64_testdata[1431] */
    {  716, 0x0000000000000000ULL, 0xCEF19224A1B63059ULL }, /* XSUM_XXH64_testdata[1432] */
    {  716, 0x000000009E3779B1ULL, 0x42B62A02271CAE3EULL }, /* XSUM_XXH64_testdata[1433] */
    {  717, 0x0000000000000000ULL, 0xD1CDE6EAA8E955A4ULL }, /* XSUM_XXH64_testdata[1434] */
    {  717, 0x000000009E3779B1ULL, 0xB05C5979A8EB4D8DULL }, /* XSUM_XXH64_testdata[1435] */
    {  718, 0x0000000000000000ULL, 0x74FD5086482BDB49ULL }, /* XSUM_XXH64_testdata[1436] */
    {  718, 0x000000009E3779B1ULL, 0xAC8628777E410441ULL }, /* XSUM_XXH64_testdata[1437] */
    {  719, 0x0000000000000000ULL, 0x83BA9E556F56DE47ULL }, /* XSUM_XXH64_testdata[1438] */
    {  719, 0x000000009E3779B1ULL, 0x41974491D12AE57DULL }, /* XSUM_XXH64_testdata[1439] */
    {  720, 0x0000000000000000ULL, 0x41D78BFB072D6955ULL }, /* XSUM_XXH64_testdata[1440] */
    {  720, 0x000000009E3779B1ULL, 0x6E56FC95B3CA8858ULL }, /* XSUM_XXH64_testdata[1441] */
    {  721, 0x0000000000000000ULL, 0xDC1307F878A05384ULL }, /* XSUM_XXH64_testdata[1442] */
    {  721, 0x000000009E3779B1ULL, 0xBBA5463D39D44606ULL }, /* XSUM_XXH64_testdata[1443] */
    {  722, 0x0000000000000000ULL, 0x1A7901D614CEA7E4ULL }, /* XSUM_XXH64_testdata[1444] */
    {  722, 0x000000009E3779B1ULL, 0xD195AB8D56B8C297ULL }, /* XSUM_XXH64_testdata[1445] */
    {  723, 0x0000000000000000ULL, 0xE378D2D8F0A9D233ULL }, /* XSUM_XXH64_testdata[1446] */
    {  723, 0x000000009E3779B1ULL, 0x3AAC7F8069B98068ULL }, /* XSUM_XXH64_testdata[1447] */
    {  724, 0x0000000000000000ULL, 0xC5E98F64860ED0DEULL }, /* XSUM_XXH64_testdata[1448] */
    {  724, 0x000000009E3779B1ULL, 0x1A16DA9A78A3D792ULL }, /* XSUM_XXH64_testdata[1449] */
    {  725, 0x0000000000000000ULL, 0x2D548C668F4C9CC8ULL }, /* XSUM_XXH64_testdata[1450] */
    {  725, 0x000000009E3779B1ULL, 0x72C2E7DAE390ECF5ULL }, /* XSUM_XXH64_testdata[1451] */
    {  726, 0x0000000000000000ULL, 0x5BE3903DFCCAF22AULL }, /* XSUM_XXH64_testdata[1452] */
    {  726, 0x000000009E3779B1ULL, 0x9D7678A1266E1D72ULL }, /* XSUM_XXH64_testdata[1453] */
    {  727, 0x0000000000000000ULL, 0x6EBC13C6253B8B87ULL }, /* XSUM_XXH64_testdata[1454] */
    {  727, 0x000000009E3779B1ULL, 0x6C80182322695419ULL }, /* XSUM_XXH64_testdata[1455] */
    {  728, 0x0000000000000000ULL, 0xF0B1D686881496D0ULL }, /* XSUM_XXH64_testdata[1456] */
    {  728, 0x000000009E3779B1ULL, 0xAC7388304F442298ULL }, /* XSUM_XXH64_testdata[1457] */
    {  729, 0x0000000000000000ULL, 0xA8A6323813358307ULL }, /* XSUM_XXH64_testdata[1458] */
    {  729, 0x000000009E3779B1ULL, 0x29E6255CAC3E756DULL }, /* XSUM_XXH64_testdata[1459] */
    {  730, 0x0000000000000000ULL, 0xEAB6F0F43D64E0EBULL }, /* XSUM_XXH64_testdata[1460] */
    {  730, 0x000000009E3779B1ULL, 0xC5D79ECC5A3DCE90ULL }, /* XSUM_XXH64_testdata[1461] */
    {  731, 0x0000000000000000ULL, 0x3FFBEC0BA96E15DAULL }, /* XSUM_XXH64_testdata[1462] */
    {  731, 0x000000009E3779B1ULL, 0xFD1DFB6EAFA6F941ULL }, /* XSUM_XXH64_testdata[1463] */
    {  732, 0x0000000000000000ULL, 0xFA7F6D9816284150ULL }, /* XSUM_XXH64_testdata[1464] */
    {  732, 0x000000009E3779B1ULL, 0xB505D90355732F73ULL }, /* XSUM_XXH64_testdata[1465] */
    {  733, 0x0000000000000000ULL, 0xBF7712DE11B23D60ULL }, /* XSUM_XXH64_testdata[1466] */
    {  733, 0x000000009E3779B1ULL, 0xD6D9778AB869F1A4ULL }, /* XSUM_XXH64_testdata[1467] */
    {  734, 0x0000000000000000ULL, 0x93B0129C62CD6483ULL }, /* XSUM_XXH64_testdata[1468] */
    {  734, 0x000000009E3779B1ULL, 0x71E33EA3FA54C82AULL }, /* XSUM_XXH64_testdata[1469] */
    {  735, 0x0000000000000000ULL, 0xAF90158120DD29D6ULL }, /* XSUM_XXH64_testdata[1470] */
    {  735, 0x000000009E3779B1ULL, 0x62B8A52E35675EFEULL }, /* XSUM_XXH64_testdata[1471] */
    {  736, 0x0000000000000000ULL, 0xAC99EFF2DE436A5BULL }, /* XSUM_XXH64_testdata[1472] */
    {  736, 0x000000009E3779B1ULL, 0x7956AC5141242D4BULL }, /* XSUM_XXH64_testdata[1473] */
    {  737, 0x0000000000000000ULL, 0x3678E8F6C0821FD4ULL }, /* XSUM_XXH64_testdata[1474] */
    {  737, 0x000000009E3779B1ULL, 0xE9616361A44679CEULL }, /* XSUM_XXH64_testdata[1475] */
    {  738, 0x0000000000000000ULL, 0x8CD45A4EF5E7BFE5ULL }, /* XSUM_XXH64_testdata[1476] */
    {  738, 0x000000009E3779B1ULL, 0x3B31AAA739321126ULL }, /* XSUM_XXH64_testdata[1477] */
    {  739, 0x0000000000000000ULL, 0xD852E97DF516658BULL }, /* XSUM_XXH64_testdata[1478] */
    {  739, 0x000000009E3779B1ULL, 0xD7568EE876CDB7C3ULL }, /* XSUM_XXH64_testdata[1479] */
    {  740, 0x0000000000000000ULL, 0x10208312ED98A058ULL }, /* XSUM_XXH64_testdata[1480] */
    {  740, 0x000000009E3779B1ULL, 0x89AD07BF20F746A7ULL }, /* XSUM_XXH64_testdata[1481] */
    {  741, 0x0000000000000000ULL, 0x2A3406B22E762D03ULL }, /* XSUM_XXH64_testdata[1482] */
    {  741, 0x000000009E3779B1ULL, 0xA2578EBFB90F4C86ULL }, /* XSUM_XXH64_testdata[1483] */
    {  742, 0x0000000000000000ULL, 0x41012644AFCCE0E2ULL }, /* XSUM_XXH64_testdata[1484] */
    {  742, 0x000000009E3779B1ULL, 0x47C71214AAB43236ULL }, /* XSUM_XXH64_testdata[1485] */
    {  743, 0x0000000000000000ULL, 0xAFD2C945A23906BDULL }, /* XSUM_XXH64_testdata[1486] */
    {  743, 0x000000009E3779B1ULL, 0xCAF53509CAD0E259ULL }, /* XSUM_XXH64_testdata[1487] */
    {  744, 0x0000000000000000ULL, 0x40C4074DDD7A4199ULL }, /* XSUM_XXH64_testdata[1488] */
    {  744, 0x000000009E3779B1ULL, 0x14392ED852039B17ULL }, /* XSUM_XXH64_testdata[1489] */
    {  745, 0x0000000000000000ULL, 0x0E635EC64C432656ULL }, /* XSUM_XXH64_testdata[1490] */
    {  745, 0x000000009E3779B1ULL, 0xB5041FAC4DAB2AB0ULL }, /* XSUM_XXH64_testdata[1491] */
    {  746, 0x0000000000000000ULL, 0x12949B52C0D92A41ULL }, /* XSUM_XXH64_testdata[1492] */
    {  746, 0x000000009E3779B1ULL, 0x9608DEE9DCA6F74EULL }, /* XSUM_XXH64_testdata[1493] */
    {  747, 0x0000000000000000ULL, 0xAA84DA7017D17172ULL }, /* XSUM_XXH64_testdata[1494] */
    {  747, 0x000000009E3779B1ULL, 0x87852EF7548AD5B8ULL }, /* XSUM_XXH64_testdata[1495] */
    {  748, 0x0000000000000000ULL, 0xC6149B58A4E811F2ULL }, /* XSUM_XXH64_testdata[1496] */
    {  748, 0x000000009E3779B1ULL, 0x8DEEFC88819EB751ULL }, /* XSUM_XXH64_testdata[1497] */
    {  749, 0x0000000000000000ULL, 0xC0CF66EF7524697BULL }, /* XSUM_XXH64_testdata[1498] */
    {  749, 0x000000009E3779B1ULL, 0x56FBFE7D523FDC0EULL }, /* XSUM_XXH64_testdata[1499] */
    {  750, 0x0000000000000000ULL, 0x84442F5D7AC2D4D7ULL }, /* XSUM_XXH64_testdata[1500] */
    {  750, 0x000000009E3779B1ULL, 0xE6C9014C67D770C9ULL }, /* XSUM_XXH64_testdata[1501] */
    {  751, 0x0000000000000000ULL, 0x042BC7070FC1C626ULL }, /* XSUM_XXH64_testdata[1502] */
    {  751, 0x000000009E3779B1ULL, 0xAE26CFD0D282BC95ULL }, /* XSUM_XXH64_testdata[1503] */
    {  752, 0x0000000000000000ULL, 0xCB8763AD53DB25AEULL }, /* XSUM_XXH64_testdata[1504] */
    {  752, 0x000000009E3779B1ULL, 0x5E2821B40151038EULL }, /* XSUM_XXH64_testdata[1505] */
    {  753, 0x0000000000000000ULL, 0x51F94118E16AD413ULL }, /* XSUM_XXH64_testdata[1506] */
    {  753, 0x000000009E3779B1ULL, 0x0151DFC5364A1F91ULL }, /* XSUM_XXH64_testdata[1507] */
    {  754, 0x0000000000000000ULL, 0x3FDF1F3AC306E680ULL }, /* XSUM_XXH64_testdata[1508] */
    {  754, 0x000000009E3779B1ULL, 0x36212321B09E9071ULL }, /* XSUM_XXH64_testdata[1509] */
    {  755, 0x0000000000000000ULL, 0x0A7445F6011589ECULL }, /* XSUM_XXH64_testdata[1510] */
    {  755, 0x000000009E3779B1ULL, 0x3FFFD038C2BC48C6ULL }, /* XSUM_XXH64_testdata[1511] */
    {  756, 0x0000000000000000ULL, 0x627C2A6EA247B4E6ULL }, /* XSUM_XXH64_testdata[1512] */
    {  756, 0x000000009E3779B1ULL, 0x3110EA20AC9FEBB0ULL }, /* XSUM_XXH64_testdata[1513] */
    {  757, 0x0000000000000000ULL, 0x7ABBD897E50C6155ULL }, /* XSUM_XXH64_testdata[1514] */
    {  757, 0x000000009E3779B1ULL, 0x05CCFF7801E0D207ULL }, /* XSUM_XXH64_testdata[1515] */
    {  758, 0x0000000000000000ULL, 0xBABC92D700C378B8ULL }, /* XSUM_XXH64_testdata[1516] */
    {  758, 0x000000009E3779B1ULL, 0x2E0D94DB0C5E777EULL }, /* XSUM_XXH64_testdata[1517] */
    {  759, 0x0000000000000000ULL, 0xFDABE8AF396803F7ULL }, /* XSUM_XXH64_testdata[1518] */
    {  759, 0x000000009E3779B1ULL, 0x09151F2D27F87BD3ULL }, /* XSUM_XXH64_testdata[1519] */
    {  760, 0x0000000000000000ULL, 0xFCBE111F73F24456ULL }, /* XSUM_XXH64_testdata[1520] */
    {  760, 0x000000009E3779B1ULL, 0xD76B618BA8891AA9ULL }, /* XSUM_XXH64_testdata[1521] */
    {  761, 0x0000000000000000ULL, 0x9EB27A0CC2B6CE7FULL }, /* XSUM_XXH64_testdata[1522] */
    {  761, 0x000000009E3779B1ULL, 0x6DFBE8E85472A47EULL }, /* XSUM_XXH64_testdata[1523] */
    {  762, 0x0000000000000000ULL, 0xE364C7174EDBB495ULL }, /* XSUM_XXH64_testdata[1524] */
    {  762, 0x000000009E3779B1ULL, 0xA818EF1E36FA4AEFULL }, /* XSUM_XXH64_testdata[1525] */
    {  763, 0x0000000000000000ULL, 0x1965DA80EA08BB81ULL }, /* XSUM_XXH64_testdata[1526] */
    {  763, 0x000000009E3779B1ULL, 0x40B75D3F3A5E2D29ULL }, /* XSUM_XXH64_testdata[1527] */
    {  764, 0x0000000000000000ULL, 0xD23A065A7AA7C4A3ULL }, /* XSUM_XXH64_testdata[1528] */
    {  764, 0x000000009E3779B1ULL, 0x5736DA672BE838E9ULL }, /* XSUM_XXH64_testdata[1529] */
    {  765, 0x0000000000000000ULL, 0x1BFE99DED9A1BBA2ULL }, /* XSUM_XXH64_testdata[1530] */
    {  765, 0x000000009E3779B1ULL, 0x99F69E39BB7B664DULL }, /* XSUM_XXH64_testdata[1531] */
    {  766, 0x0000000000000000ULL, 0x833432C61A9ED439ULL }, /* XSUM_XXH64_testdata[1532] */
    {  766, 0x000000009E3779B1ULL, 0x162BCE222B455C24ULL }, /* XSUM_XXH64_testdata[1533] */
    {  767, 0x0000000000000000ULL, 0x4181C71628F08B1CULL }, /* XSUM_XXH64_testdata[1534] */
    {  767, 0x000000009E3779B1ULL, 0xB1488838AA3F10DAULL }, /* XSUM_XXH64_testdata[1535] */
    {  768, 0x0000000000000000ULL, 0x0E8BBB1F9B435E52ULL }, /* XSUM_XXH64_testdata[1536] */
    {  768, 0x000000009E3779B1ULL, 0x1DC7319A8ADE3B81ULL }, /* XSUM_XXH64_testdata[1537] */
    {  769, 0x0000000000000000ULL, 0xE860CAE272EA80B9ULL }, /* XSUM_XXH64_testdata[1538] */
    {  769, 0x000000009E3779B1ULL, 0x23C04C46FC231044ULL }, /* XSUM_XXH64_testdata[1539] */
    {  770, 0x0000000000000000ULL, 0x6236B3FB13743810ULL }, /* XSUM_XXH64_testdata[1540] */
    {  770, 0x000000009E3779B1ULL, 0x67DF8E2782ABA69BULL }, /* XSUM_XXH64_testdata[1541] */
    {  771, 0x0000000000000000ULL, 0xED4C203B6774E7CEULL }, /* XSUM_XXH64_testdata[1542] */
    {  771, 0x000000009E3779B1ULL, 0x552052A7444466E6ULL }, /* XSUM_XXH64_testdata[1543] */
    {  772, 0x0000000000000000ULL, 0x8CE6CDEF16AE6884ULL }, /* XSUM_XXH64_testdata[1544] */
    {  772, 0x000000009E3779B1ULL, 0x48F644C568470FA1ULL }, /* XSUM_XXH64_testdata[1545] */
    {  773, 0x0000000000000000ULL, 0x64C403D54E028867ULL }, /* XSUM_XXH64_testdata[1546] */
    {  773, 0x000000009E3779B1ULL, 0xD16C062B043553D3ULL }, /* XSUM_XXH64_testdata[1547] */
    {  774, 0x0000000000000000ULL, 0xF812CC33F77F2D44ULL }, /* XSUM_XXH64_testdata[1548] */
    {  774, 0x000000009E3779B1ULL, 0xFBCCE522CB2B8F29ULL }, /* XSUM_XXH64_testdata[1549] */
    {  775, 0x0000000000000000ULL, 0xFFF547F98ABF6895ULL }, /* XSUM_XXH64_testdata[1550] */
    {  775, 0x000000009E3779B1ULL, 0x20105BF22CEF4FD0ULL }, /* XSUM_XXH64_testdata[1551] */
    {  776, 0x0000000000000000ULL, 0x8B88372929BDEA9AULL }, /* XSUM_XXH64_testdata[1552] */
    {  776, 0x000000009E3779B1ULL, 0xFC1C6E3B87A91E85ULL }, /* XSUM_XXH64_testdata[1553] */
    {  777, 0x0000000000000000ULL, 0xF672F4ECB438B978ULL }, /* XSUM_XXH64_testdata[1554] */
    {  777, 0x000000009E3779B1ULL, 0x21D821B6C3257703ULL }, /* XSUM_XXH64_testdata[1555] */
    {  778, 0x0000000000000000ULL, 0x57B5CE95D2B999D9ULL }, /* XSUM_XXH64_testdata[1556] */
    {  778, 0x000000009E3779B1ULL, 0xEC2F3620E8EA8F78ULL }, /* XSUM_XXH64_testdata[1557] */
    {  779, 0x0000000000000000ULL, 0x9316E0487B446BD0ULL }, /* XSUM_XXH64_testdata[1558] */
    {  779, 0x000000009E3779B1ULL, 0x827337D4BE47D7E5ULL }, /* XSUM_XXH64_testdata[1559] */
    {  780, 0x0000000000000000ULL, 0xC3A2083FED8BB647ULL }, /* XSUM_XXH64_testdata[1560] */
    {  780, 0x000000009E3779B1ULL, 0x0041BC77E1938345ULL }, /* XSUM_XXH64_testdata[1561] */
    {  781, 0x0000000000000000ULL, 0xDBFBDA21100250E2ULL }, /* XSUM_XXH64_testdata[1562] */
    {  781, 0x000000009E3779B1ULL, 0xA3E23F2210DCAE3AULL }, /* XSUM_XXH64_testdata[1563] */
    {  782, 0x0000000000000000ULL, 0xB32650EC85A8E89FULL }, /* XSUM_XXH64_testdata[1564] */
    {  782, 0x000000009E3779B1ULL, 0x0BBAB579A14A004EULL }, /* XSUM_XXH64_testdata[1565] */
    {  783, 0x0000000000000000ULL, 0x0F8892E334EBFEDEULL }, /* XSUM_XXH64_testdata[1566] */
    {  783, 0x000000009E3779B1ULL, 0xF8143EE621E4AB31ULL }, /* XSUM_XXH64_testdata[1567] */
    {  784, 0x0000000000000000ULL, 0xBF068128DEE1921BULL }, /* XSUM_XXH64_testdata[1568] */
    {  784, 0x000000009E3779B1ULL, 0x9B65026776A13013ULL }, /* XSUM_XXH64_testdata[1569] */
    {  785, 0x0000000000000000ULL, 0x64CDF4EA244DF2B4ULL }, /* XSUM_XXH64_testdata[1570] */
    {  785, 0x000000009E3779B1ULL, 0x10EAC153A44AD4DDULL }, /* XSUM_XXH64_testdata[1571] */
    {  786, 0x0000000000000000ULL, 0x87B568D354323734ULL }, /* XSUM_XXH64_testdata[1572] */
    {  786, 0x000000009E3779B1ULL, 0xD48FCD6C08DA914EULL }, /* XSUM_XXH64_testdata[1573] */
    {  787, 0x0000000000000000ULL, 0x38C6ED425960C0E3ULL }, /* XSUM_XXH64_testdata[1574] */
    {  787, 0x000000009E3779B1ULL, 0xEBB7C1C275F63D62ULL }, /* XSUM_XXH64_testdata[1575] */
    {  788, 0x0000000000000000ULL, 0x8C44FE365B657772ULL }, /* XSUM_XXH64_testdata[1576] */
    {  788, 0x000000009E3779B1ULL, 0xD1B95B6CFF78274DULL }, /* XSUM_XXH64_testdata[1577] */
    {  789, 0x0000000000000000ULL, 0x3E3499D6967BAEE5ULL }, /* XSUM_XXH64_testdata[1578] */
    {  789, 0x000000009E3779B1ULL, 0x441E0EEB1BF63691ULL }, /* XSUM_XXH64_testdata[1579] */
    {  790, 0x0000000000000000ULL, 0x3C6390B33F391A0EULL }, /* XSUM_XXH64_testdata[1580] */
    {  790, 0x000000009E3779B1ULL, 0x72B21F7207AE0919ULL }, /* XSUM_XXH64_testdata[1581] */
    {  791, 0x0000000000000000ULL, 0x51D21456E0E73F66ULL }, /* XSUM_XXH64_testdata[1582] */
    {  791, 0x000000009E3779B1ULL, 0x1BACAF65F7984266ULL }, /* XSUM_XXH64_testdata[1583] */
    {  792, 0x0000000000000000ULL, 0x8C7368A49E49CC53ULL }, /* XSUM_XXH64_testdata[1584] */
    {  792, 0x000000009E3779B1ULL, 0x0CB319EAD0DE8855ULL }, /* XSUM_XXH64_testdata[1585] */
    {  793, 0x0000000000000000ULL, 0xCA68FA5D6F365ED0ULL }, /* XSUM_XXH64_testdata[1586] */
    {  793, 0x000000009E3779B1ULL, 0x2DEC7894FA59249EULL }, /* XSUM_XXH64_testdata[1587] */
    {  794, 0x0000000000000000ULL, 0x38C01A76599E30DEULL }, /* XSUM_XXH64_testdata[1588] */
    {  794, 0x000000009E3779B1ULL, 0xCF66B041DCA10B35ULL }, /* XSUM_XXH64_testdata[1589] */
    {  795, 0x0000000000000000ULL, 0xB0A8FC8D3F57896FULL }, /* XSUM_XXH64_testdata[1590] */
    {  795, 0x000000009E3779B1ULL, 0x27A3200AD7C3DC6AULL }, /* XSUM_XXH64_testdata[1591] */
    {  796, 0x0000000000000000ULL, 0xBA5D75B684F4BC67ULL }, /* XSUM_XXH64_testdata[1592] */
    {  796, 0x000000009E3779B1ULL, 0xA66532CCF59A4609ULL }, /* XSUM_XXH64_testdata[1593] */
    {  797, 0x0000000000000000ULL, 0x1BD78A442184A931ULL }, /* XSUM_XXH64_testdata[1594] */
    {  797, 0x000000009E3779B1ULL, 0x7E00B4870724948BULL }, /* XSUM_XXH64_testdata[1595] */
    {  798, 0x0000000000000000ULL, 0x6AFAB3B116CB725EULL }, /* XSUM_XXH64_testdata[1596] */
    {  798, 0x000000009E3779B1ULL, 0x6540810BA11F814EULL }, /* XSUM_XXH64_testdata[1597] */
    {  799, 0x0000000000000000ULL, 0x5A0EB3EF550813BAULL }, /* XSUM_XXH64_testdata[1598] */
    {  799, 0x000000009E3779B1ULL, 0x854F440E0C3C0B35ULL }, /* XSUM_XXH64_testdata[1599] */
    {  800, 0x0000000000000000ULL, 0x244E56B2868A0944ULL }, /* XSUM_XXH64_testdata[1600] */
    {  800, 0x000000009E3779B1ULL, 0x56EF1FA810F64E8DULL }, /* XSUM_XXH64_testdata[1601] */
    {  801, 0x0000000000000000ULL, 0xDA930E45B6312ECBULL }, /* XSUM_XXH64_testdata[1602] */
    {  801, 0x000000009E3779B1ULL, 0x4E0D99BAE5F0886FULL }, /* XSUM_XXH64_testdata[1603] */
    {  802, 0x0000000000000000ULL, 0xF6182C524C449150ULL }, /* XSUM_XXH64_testdata[1604] */
    {  802, 0x000000009E3779B1ULL, 0x7CB2C154B4E3EC88ULL }, /* XSUM_XXH64_testdata[1605] */
    {  803, 0x0000000000000000ULL, 0xCF26324B8DA162DFULL }, /* XSUM_XXH64_testdata[1606] */
    {  803, 0x000000009E3779B1ULL, 0x78FB10568FCC433EULL }, /* XSUM_XXH64_testdata[1607] */
    {  804, 0x0000000000000000ULL, 0x42C4682264A9671BULL }, /* XSUM_XXH64_testdata[1608] */
    {  804, 0x000000009E3779B1ULL, 0x41CAC9D65E5A3DC1ULL }, /* XSUM_XXH64_testdata[1609] */
    {  805, 0x0000000000000000ULL, 0xB0DD0D6AC91A338BULL }, /* XSUM_XXH64_testdata[1610] */
    {  805, 0x000000009E3779B1ULL, 0x39E04426DC2028BBULL }, /* XSUM_XXH64_testdata[1611] */
    {  806, 0x0000000000000000ULL, 0xA1CBC14F0F3C3470ULL }, /* XSUM_XXH64_testdata[1612] */
    {  806, 0x000000009E3779B1ULL, 0x07FA9B7D8AE43063ULL }, /* XSUM_XXH64_testdata[1613] */
    {  807, 0x0000000000000000ULL, 0x7ED2B5BF5CB35E5BULL }, /* XSUM_XXH64_testdata[1614] */
    {  807, 0x000000009E3779B1ULL, 0xFC15449D36A6772BULL }, /* XSUM_XXH64_testdata[1615] */
    {  808, 0x0000000000000000ULL, 0xD1DF37277BE7DFA2ULL }, /* XSUM_XXH64_testdata[1616] */
    {  808, 0x000000009E3779B1ULL, 0xD49C8B4D78D976FEULL }, /* XSUM_XXH64_testdata[1617] */
    {  809, 0x0000000000000000ULL, 0xF4F1B57FC8C040A8ULL }, /* XSUM_XXH64_testdata[1618] */
    {  809, 0x000000009E3779B1ULL, 0x01F7D6B05F87A1ECULL }, /* XSUM_XXH64_testdata[1619] */
    {  810, 0x0000000000000000ULL, 0x82EF84CF79BB87A4ULL }, /* XSUM_XXH64_testdata[1620] */
    {  810, 0x000000009E3779B1ULL, 0x0ED3237E7B220E42ULL }, /* XSUM_XXH64_testdata[1621] */
    {  811, 0x0000000000000000ULL, 0x443A0FF4897979D6ULL }, /* XSUM_XXH64_testdata[1622] */
    {  811, 0x000000009E3779B1ULL, 0x2B903EF2F3BA86D0ULL }, /* XSUM_XXH64_testdata[1623] */
    {  812, 0x0000000000000000ULL, 0x72BC3E80D2A90898ULL }, /* XSUM_XXH64_testdata[1624] */
    {  812, 0x000000009E3779B1ULL, 0xF6B7CC07E96C2CE5ULL }, /* XSUM_XXH64_testdata[1625] */
    {  813, 0x0000000000000000ULL, 0xB51DAA1C83EEF3F2ULL }, /* XSUM_XXH64_testdata[1626] */
    {  813, 0x000000009E3779B1ULL, 0xDC6A3D3DB077BFC6ULL }, /* XSUM_XXH64_testdata[1627] */
    {  814, 0x0000000000000000ULL, 0x881C1225846B1F06ULL }, /* XSUM_XXH64_testdata[1628] */
    {  814, 0x000000009E3779B1ULL, 0xE38BBFD98A656883ULL }, /* XSUM_XXH64_testdata[1629] */
    {  815, 0x0000000000000000ULL, 0x4E66F384826BD596ULL }, /* XSUM_XXH64_testdata[1630] */
    {  815, 0x000000009E3779B1ULL, 0xF4A1FC10695C98A6ULL }, /* XSUM_XXH64_testdata[1631] */
    {  816, 0x0000000000000000ULL, 0x353A363E0972420BULL }, /* XSUM_XXH64_testdata[1632] */
    {  816, 0x000000009E3779B1ULL, 0x7D4B7B24CB16C5B0ULL }, /* XSUM_XXH64_testdata[1633] */
    {  817, 0x0000000000000000ULL, 0x7A42B99973DFAB20ULL }, /* XSUM_XXH64_testdata[1634] */
    {  817, 0x000000009E3779B1ULL, 0x5AE58B1762159F8BULL }, /* XSUM_XXH64_testdata[1635] */
    {  818, 0x0000000000000000ULL, 0x2BB206E8538ACE55ULL }, /* XSUM_XXH64_testdata[1636] */
    {  818, 0x000000009E3779B1ULL, 0xED2363516B645D7FULL }, /* XSUM_XXH64_testdata[1637] */
    {  819, 0x0000000000000000ULL, 0x84B50FF7722D4142ULL }, /* XSUM_XXH64_testdata[1638] */
    {  819, 0x000000009E3779B1ULL, 0x0811B5A596470497ULL }, /* XSUM_XXH64_testdata[1639] */
    {  820, 0x0000000000000000ULL, 0xA0AD40767F613E0FULL }, /* XSUM_XXH64_testdata[1640] */
    {  820, 0x000000009E3779B1ULL, 0x018E5F50754DE2D4ULL }, /* XSUM_XXH64_testdata[1641] */
    {  821, 0x0000000000000000ULL, 0xA2B047AF06AE5BE2ULL }, /* XSUM_XXH64_testdata[1642] */
    {  821, 0x000000009E3779B1ULL, 0xD9CC9EDDFF3E06E6ULL }, /* XSUM_XXH64_testdata[1643] */
    {  822, 0x0000000000000000ULL, 0x0315BEEF76458DB0ULL }, /* XSUM_XXH64_testdata[1644] */
    {  822, 0x000000009E3779B1ULL, 0x5E77353EC42C0616ULL }, /* XSUM_XXH64_testdata[1645] */
    {  823, 0x0000000000000000ULL, 0xF5446208089F49D3ULL }, /* XSUM_XXH64_testdata[1646] */
    {  823, 0x000000009E3779B1ULL, 0xC1EB228206F03473ULL }, /* XSUM_XXH64_testdata[1647] */
    {  824, 0x0000000000000000ULL, 0xF0300A6A0C72D595ULL }, /* XSUM_XXH64_testdata[1648] */
    {  824, 0x000000009E3779B1ULL, 0xB93F9E28D37ED75BULL }, /* XSUM_XXH64_testdata[1649] */
    {  825, 0x0000000000000000ULL, 0xE38D4F27372C9836ULL }, /* XSUM_XXH64_testdata[1650] */
    {  825, 0x000000009E3779B1ULL, 0xA6E982E62AB658DAULL }, /* XSUM_XXH64_testdata[1651] */
    {  826, 0x0000000000000000ULL, 0x6A11FF2CB76790F6ULL }, /* XSUM_XXH64_testdata[1652] */
    {  826, 0x000000009E3779B1ULL, 0x4C7256B58304E77DULL }, /* XSUM_XXH64_testdata[1653] */
    {  827, 0x0000000000000000ULL, 0x878674A0772ED595ULL }, /* XSUM_XXH64_testdata[1654] */
    {  827, 0x000000009E3779B1ULL, 0xF0F34E88479A2D89ULL }, /* XSUM_XXH64_testdata[1655] */
    {  828, 0x0000000000000000ULL, 0x13E960559E0CE9B7ULL }, /* XSUM_XXH64_testdata[1656] */
    {  828, 0x000000009E3779B1ULL, 0x1487F52D81EDF8DFULL }, /* XSUM_XXH64_testdata[1657] */
    {  829, 0x0000000000000000ULL, 0xACEA80F8C6E44192ULL }, /* XSUM_XXH64_testdata[1658] */
    {  829, 0x000000009E3779B1ULL, 0x52EA26606D24635CULL }, /* XSUM_XXH64_testdata[1659] */
    {  830, 0x0000000000000000ULL, 0x2ED7C1D98D3AE131ULL }, /* XSUM_XXH64_testdata[1660] */
    {  830, 0x000000009E3779B1ULL, 0xD76EAA945F2154B3ULL }, /* XSUM_XXH64_testdata[1661] */
    {  831, 0x0000000000000000ULL, 0xCDB1D04F55C2F84BULL }, /* XSUM_XXH64_testdata[1662] */
    {  831, 0x000000009E3779B1ULL, 0x447BFC74CBAB8F87ULL }, /* XSUM_XXH64_testdata[1663] */
    {  832, 0x0000000000000000ULL, 0x3D5BAE42715B0A4DULL }, /* XSUM_XXH64_testdata[1664] */
    {  832, 0x000000009E3779B1ULL, 0x2B7257C21CFC4A6EULL }, /* XSUM_XXH64_testdata[1665] */
    {  833, 0x0000000000000000ULL, 0x14903D37319352FDULL }, /* XSUM_XXH64_testdata[1666] */
    {  833, 0x000000009E3779B1ULL, 0x6A57053BF3B5FB80ULL }, /* XSUM_XXH64_testdata[1667] */
    {  834, 0x0000000000000000ULL, 0x187F9B803814D2D1ULL }, /* XSUM_XXH64_testdata[1668] */
    {  834, 0x000000009E3779B1ULL, 0x885529ECCED2ADA8ULL }, /* XSUM_XXH64_testdata[1669] */
    {  835, 0x0000000000000000ULL, 0x644EE28E3AD57EEFULL }, /* XSUM_XXH64_testdata[1670] */
    {  835, 0x000000009E3779B1ULL, 0xD7968228B0C69B5CULL }, /* XSUM_XXH64_testdata[1671] */
    {  836, 0x0000000000000000ULL, 0xF19A2B5515B47595ULL }, /* XSUM_XXH64_testdata[1672] */
    {  836, 0x000000009E3779B1ULL, 0xD72A1257C29B5741ULL }, /* XSUM_XXH64_testdata[1673] */
    {  837, 0x0000000000000000ULL, 0x16389D633B41A832ULL }, /* XSUM_XXH64_testdata[1674] */
    {  837, 0x000000009E3779B1ULL, 0xADD0AB275CDC5412ULL }, /* XSUM_XXH64_testdata[1675] */
    {  838, 0x0000000000000000ULL, 0x24F087F628F098B7ULL }, /* XSUM_XXH64_testdata[1676] */
    {  838, 0x000000009E3779B1ULL, 0x876D727FA2EC8878ULL }, /* XSUM_XXH64_testdata[1677] */
    {  839, 0x0000000000000000ULL, 0x8BC940DB4A965289ULL }, /* XSUM_XXH64_testdata[1678] */
    {  839, 0x000000009E3779B1ULL, 0x90D59D4D67730DF3ULL }, /* XSUM_XXH64_testdata[1679] */
    {  840, 0x0000000000000000ULL, 0x13F577CF676D19EFULL }, /* XSUM_XXH64_testdata[1680] */
    {  840, 0x000000009E3779B1ULL, 0x352763C726049A02ULL }, /* XSUM_XXH64_testdata[1681] */
    {  841, 0x0000000000000000ULL, 0x22865F907214C8F1ULL }, /* XSUM_XXH64_testdata[1682] */
    {  841, 0x000000009E3779B1ULL, 0xFD7850074C82CF88ULL }, /* XSUM_XXH64_testdata[1683] */
    {  842, 0x0000000000000000ULL, 0xD0BADDA2D0D96347ULL }, /* XSUM_XXH64_testdata[1684] */
    {  842, 0x000000009E3779B1ULL, 0xB818EFDB230697ACULL }, /* XSUM_XXH64_testdata[1685] */
    {  843, 0x0000000000000000ULL, 0x0BEF1A213934ED65ULL }, /* XSUM_XXH64_testdata[1686] */
    {  843, 0x000000009E3779B1ULL, 0xDA78886C69D7CBA5ULL }, /* XSUM_XXH64_testdata[1687] */
    {  844, 0x0000000000000000ULL, 0xE10659BDCD007C7BULL }, /* XSUM_XXH64_testdata[1688] */
    {  844, 0x000000009E3779B1ULL, 0xBC34E6853275F1D3ULL }, /* XSUM_XXH64_testdata[1689] */
    {  845, 0x0000000000000000ULL, 0x618D077757488504ULL }, /* XSUM_XXH64_testdata[1690] */
    {  845, 0x000000009E3779B1ULL, 0xB4FCE3B927B285D3ULL }, /* XSUM_XXH64_testdata[1691] */
    {  846, 0x0000000000000000ULL, 0xBC3E4ECBCB0E099AULL }, /* XSUM_XXH64_testdata[1692] */
    {  846, 0x000000009E3779B1ULL, 0xF58A5039F831A050ULL }, /* XSUM_XXH64_testdata[1693] */
    {  847, 0x0000000000000000ULL, 0x2AF26B61A1340B8DULL }, /* XSUM_XXH64_testdata[1694] */
    {  847, 0x000000009E3779B1ULL, 0x1EF4C8078AF7027BULL }, /* XSUM_XXH64_testdata[1695] */
    {  848, 0x0000000000000000ULL, 0xF79ED3B2C96B1A54ULL }, /* XSUM_XXH64_testdata[1696] */
    {  848, 0x000000009E3779B1ULL, 0x96FBFA709C8819BEULL }, /* XSUM_XXH64_testdata[1697] */
    {  849, 0x0000000000000000ULL, 0x96756A37A3210EADULL }, /* XSUM_XXH64_testdata[1698] */
    {  849, 0x000000009E3779B1ULL, 0xC29466933248138FULL }, /* XSUM_XXH64_testdata[1699] */
    {  850, 0x0000000000000000ULL, 0x14F7DC8FC7D2E823ULL }, /* XSUM_XXH64_testdata[1700] */
    {  850, 0x000000009E3779B1ULL, 0xD6B9613FC6CD622AULL }, /* XSUM_XXH64_testdata[1701] */
    {  851, 0x0000000000000000ULL, 0x4623123A3E51EA8EULL }, /* XSUM_XXH64_testdata[1702] */
    {  851, 0x000000009E3779B1ULL, 0x4C7610EDC37BC6FCULL }, /* XSUM_XXH64_testdata[1703] */
    {  852, 0x0000000000000000ULL, 0x7A51C1212D0B090EULL }, /* XSUM_XXH64_testdata[1704] */
    {  852, 0x000000009E3779B1ULL, 0xA59FEBF6A4C5DE71ULL }, /* XSUM_XXH64_testdata[1705] */
    {  853, 0x0000000000000000ULL, 0x7A0E98E60EB6AAF8ULL }, /* XSUM_XXH64_testdata[1706] */
    {  853, 0x000000009E3779B1ULL, 0x34DC1180870A5B26ULL }, /* XSUM_XXH64_testdata[1707] */
    {  854, 0x0000000000000000ULL, 0xB102435DDFA595A1ULL }, /* XSUM_XXH64_testdata[1708] */
    {  854, 0x000000009E3779B1ULL, 0xF0D311DEA553C143ULL }, /* XSUM_XXH64_testdata[1709] */
    {  855, 0x0000000000000000ULL, 0x34FE3D73223764B1ULL }, /* XSUM_XXH64_testdata[1710] */
    {  855, 0x000000009E3779B1ULL, 0x6BE2B2985F732D96ULL }, /* XSUM_XXH64_testdata[1711] */
    {  856, 0x0000000000000000ULL, 0x20598ABFBD474FECULL }, /* XSUM_XXH64_testdata[1712] */
    {  856, 0x000000009E3779B1ULL, 0x23EF0E301BD9C9F4ULL }, /* XSUM_XXH64_testdata[1713] */
    {  857, 0x0000000000000000ULL, 0x78FA616B50E3AD85ULL }, /* XSUM_XXH64_testdata[1714] */
    {  857, 0x000000009E3779B1ULL, 0xE6C6095C888BCCE7ULL }, /* XSUM_XXH64_testdata[1715] */
    {  858, 0x0000000000000000ULL, 0xB01B0E699EB746EBULL }, /* XSUM_XXH64_testdata[1716] */
    {  858, 0x000000009E3779B1ULL, 0xB28D543D22BF9F46ULL }, /* XSUM_XXH64_testdata[1717] */
    {  859, 0x0000000000000000ULL, 0x00EDD4B3544BC2EBULL }, /* XSUM_XXH64_testdata[1718] */
    {  859, 0x000000009E3779B1ULL, 0x7ABBBB750FA86995ULL }, /* XSUM_XXH64_testdata[1719] */
    {  860, 0x0000000000000000ULL, 0x653CFAF1456F5C13ULL }, /* XSUM_XXH64_testdata[1720] */
    {  860, 0x000000009E3779B1ULL, 0xD81F68EC451802ADULL }, /* XSUM_XXH64_testdata[1721] */
    {  861, 0x0000000000000000ULL, 0x5AA0BA4E43D1C793ULL }, /* XSUM_XXH64_testdata[1722] */
    {  861, 0x000000009E3779B1ULL, 0x862D2B34AB6D6026ULL }, /* XSUM_XXH64_testdata[1723] */
    {  862, 0x0000000000000000ULL, 0x8FC68F658FE9A5CBULL }, /* XSUM_XXH64_testdata[1724] */
    {  862, 0x000000009E3779B1ULL, 0xD1042671C598BBE5ULL }, /* XSUM_XXH64_testdata[1725] */
    {  863, 0x0000000000000000ULL, 0xFA0BAC7815DF9FD5ULL }, /* XSUM_XXH64_testdata[1726] */
    {  863, 0x000000009E3779B1ULL, 0xFD84DE08D873DD81ULL }, /* XSUM_XXH64_testdata[1727] */
    {  864, 0x0000000000000000ULL, 0x6373353385388B37ULL }, /* XSUM_XXH64_testdata[1728] */
    {  864, 0x000000009E3779B1ULL, 0x4FC416586122807FULL }, /* XSUM_XXH64_testdata[1729] */
    {  865, 0x0000000000000000ULL, 0x835E5BC3000B56D9ULL }, /* XSUM_XXH64_testdata[1730] */
    {  865, 0x000000009E3779B1ULL, 0xBBDB205A685690D8ULL }, /* XSUM_XXH64_testdata[1731] */
    {  866, 0x0000000000000000ULL, 0xB707397892276BE4ULL }, /* XSUM_XXH64_testdata[1732] */
    {  866, 0x000000009E3779B1ULL, 0x103F64ECB55F4F46ULL }, /* XSUM_XXH64_testdata[1733] */
    {  867, 0x0000000000000000ULL, 0x9EA0EC20007A11B1ULL }, /* XSUM_XXH64_testdata[1734] */
    {  867, 0x000000009E3779B1ULL, 0xA5E19F6A316EAB66ULL }, /* XSUM_XXH64_testdata[1735] */
    {  868, 0x0000000000000000ULL, 0xB80C7041CCF517D6ULL }, /* XSUM_XXH64_testdata[1736] */
    {  868, 0x000000009E3779B1ULL, 0xCE738A5D8C69D9B3ULL }, /* XSUM_XXH64_testdata[1737] */
    {  869, 0x0000000000000000ULL, 0x11F02C4D181DB0C4ULL }, /* XSUM_XXH64_testdata[1738] */
    {  869, 0x000000009E3779B1ULL, 0x1ABBF191C6AC687DULL }, /* XSUM_XXH64_testdata[1739] */
    {  870, 0x0000000000000000ULL, 0x1D5062D6896F877BULL }, /* XSUM_XXH64_testdata[1740] */
    {  870, 0x000000009E3779B1ULL, 0x1DCC8C9627E6FCB2ULL }, /* XSUM_XXH64_testdata[1741] */
    {  871, 0x0000000000000000ULL, 0xD7AB279F53AE77E1ULL }, /* XSUM_XXH64_testdata[1742] */
    {  871, 0x000000009E3779B1ULL, 0x52EE0D0915817876ULL }, /* XSUM_XXH64_testdata[1743] */
    {  872, 0x0000000000000000ULL, 0x6100FBA816FBE4B7ULL }, /* XSUM_XXH64_testdata[1744] */
    {  872, 0x000000009E3779B1ULL, 0x05F758578F82E391ULL }, /* XSUM_XXH64_testdata[1745] */
    {  873, 0x0000000000000000ULL, 0x6DDA6AD4BA4323C2ULL }, /* XSUM_XXH64_testdata[1746] */
    {  873, 0x000000009E3779B1ULL, 0xFCEC2E73753D4906ULL }, /* XSUM_XXH64_testdata[1747] */
    {  874, 0x0000000000000000ULL, 0xEA548563BD01937AULL }, /* XSUM_XXH64_testdata[1748] */
    {  874, 0x000000009E3779B1ULL, 0x90EAC483FD3859BEULL }, /* XSUM_XXH64_testdata[1749] */
    {  875, 0x0000000000000000ULL, 0x30CC37EC769EFFFEULL }, /* XSUM_XXH64_testdata[1750] */
    {  875, 0x000000009E3779B1ULL, 0xCD0C3D904462D60BULL }, /* XSUM_XXH64_testdata[1751] */
    {  876, 0x0000000000000000ULL, 0x63353497BD23E476ULL }, /* XSUM_XXH64_testdata[1752] */
    {  876, 0x000000009E3779B1ULL, 0x76AF9EAEA230D908ULL }, /* XSUM_XXH64_testdata[1753] */
    {  877, 0x0000000000000000ULL, 0x0EC5420E89F88130ULL }, /* XSUM_XXH64_testdata[1754] */
    {  877, 0x000000009E3779B1ULL, 0xE1BF1BE604D2B4C2ULL }, /* XSUM_XXH64_testdata[1755] */
    {  878, 0x0000000000000000ULL, 0xBBE3953E2005F359ULL }, /* XSUM_XXH64_testdata[1756] */
    {  878, 0x000000009E3779B1ULL, 0xDAAFEE6A0B433A74ULL }, /* XSUM_XXH64_testdata[1757] */
    {  879, 0x0000000000000000ULL, 0x90D3F6F33135D83CULL }, /* XSUM_XXH64_testdata[1758] */
    {  879, 0x000000009E3779B1ULL, 0x7C78584945F9D2A3ULL }, /* XSUM_XXH64_testdata[1759] */
    {  880, 0x0000000000000000ULL, 0x2173BFC7F9032555ULL }, /* XSUM_XXH64_testdata[1760] */
    {  880, 0x000000009E3779B1ULL, 0x902DC15CC0AA4C5AULL }, /* XSUM_XXH64_testdata[1761] */
    {  881, 0x0000000000000000ULL, 0x2DED0B261F610F06ULL }, /* XSUM_XXH64_testdata[1762] */
    {  881, 0x000000009E3779B1ULL, 0xA08653A777086DCEULL }, /* XSUM_XXH64_testdata[1763] */
    {  882, 0x0000000000000000ULL, 0x0ACB705226711CA0ULL }, /* XSUM_XXH64_testdata[1764] */
    {  882, 0x000000009E3779B1ULL, 0x67539F629AA80FCDULL }, /* XSUM_XXH64_testdata[1765] */
    {  883, 0x0000000000000000ULL, 0xFB4F87330ACE424FULL }, /* XSUM_XXH64_testdata[1766] */
    {  883, 0x000000009E3779B1ULL, 0xFBBF941BBD03CA43ULL }, /* XSUM_XXH64_testdata[1767] */
    {  884, 0x0000000000000000ULL, 0xFD0C5105ACA1A57CULL }, /* XSUM_XXH64_testdata[1768] */
    {  884, 0x000000009E3779B1ULL, 0x9162AAFE35995B6AULL }, /* XSUM_XXH64_testdata[1769] */
    {  885, 0x0000000000000000ULL, 0x617C8D7EBF788394ULL }, /* XSUM_XXH64_testdata[1770] */
    {  885, 0x000000009E3779B1ULL, 0xD0D668987E17D7A3ULL }, /* XSUM_XXH64_testdata[1771] */
    {  886, 0x0000000000000000ULL, 0x8104F0CAB9035C58ULL }, /* XSUM_XXH64_testdata[1772] */
    {  886, 0x000000009E3779B1ULL, 0x4942ACF21CD8A90DULL }, /* XSUM_XXH64_testdata[1773] */
    {  887, 0x0000000000000000ULL, 0x2FADF9CA07A368FEULL }, /* XSUM_XXH64_testdata[1774] */
    {  887, 0x000000009E3779B1ULL, 0xA350EC17F8C8EAD1ULL }, /* XSUM_XXH64_testdata[1775] */
    {  888, 0x0000000000000000ULL, 0x51137DC208D0EB75ULL }, /* XSUM_XXH64_testdata[1776] */
    {  888, 0x000000009E3779B1ULL, 0x46F46544CFC2FC22ULL }, /* XSUM_XXH64_testdata[1777] */
    {  889, 0x0000000000000000ULL, 0x266CEF1EB52AF50CULL }, /* XSUM_XXH64_testdata[1778] */
    {  889, 0x000000009E3779B1ULL, 0xE63F8CD1C1F84E55ULL }, /* XSUM_XXH64_testdata[1779] */
    {  890, 0x0000000000000000ULL, 0xDDD3DCFD409BF671ULL }, /* XSUM_XXH64_testdata[1780] */
    {  890, 0x000000009E3779B1ULL, 0xD6AF89F86CDAFE00ULL }, /* XSUM_XXH64_testdata[1781] */
    {  891, 0x0000000000000000ULL, 0xA0F0F0A8BAF698BCULL }, /* XSUM_XXH64_testdata[1782] */
    {  891, 0x000000009E3779B1ULL, 0x65A52A08268C9FA9ULL }, /* XSUM_XXH64_testdata[1783] */
    {  892, 0x0000000000000000ULL, 0x948FAAF326AA6BC8ULL }, /* XSUM_XXH64_testdata[1784] */
    {  892, 0x000000009E3779B1ULL, 0xD36A712FA68B81BCULL }, /* XSUM_XXH64_testdata[1785] */
    {  893, 0x0000000000000000ULL, 0x9D1294E8EA5B2767ULL }, /* XSUM_XXH64_testdata[1786] */
    {  893, 0x000000009E3779B1ULL, 0xC748D486CA7151A5ULL }, /* XSUM_XXH64_testdata[1787] */
    {  894, 0x0000000000000000ULL, 0xEE40D26539640704ULL }, /* XSUM_XXH64_testdata[1788] */
    {  894, 0x000000009E3779B1ULL, 0x463157CD339EF85DULL }, /* XSUM_XXH64_testdata[1789] */
    {  895, 0x0000000000000000ULL, 0xB7D94BB4FB407B22ULL }, /* XSUM_XXH64_testdata[1790] */
    {  895, 0x000000009E3779B1ULL, 0x6B4D2776EEE18DDFULL }, /* XSUM_XXH64_testdata[1791] */
    {  896, 0x0000000000000000ULL, 0xACA27EEA7D739BABULL }, /* XSUM_XXH64_testdata[1792] */
    {  896, 0x000000009E3779B1ULL, 0xD91B812648A1A30EULL }, /* XSUM_XXH64_testdata[1793] */
    {  897, 0x0000000000000000ULL, 0xA9524B99C07C465CULL }, /* XSUM_XXH64_testdata[1794] */
    {  897, 0x000000009E3779B1ULL, 0x30A74381F6CDEBAFULL }, /* XSUM_XXH64_testdata[1795] */
    {  898, 0x0000000000000000ULL, 0x3F76A1A71AFF82FEULL }, /* XSUM_XXH64_testdata[1796] */
    {  898, 0x000000009E3779B1ULL, 0xB6BE86367CAAA2A8ULL }, /* XSUM_XXH64_testdata[1797] */
    {  899, 0x0000000000000000ULL, 0x48B60A2794AFDF38ULL }, /* XSUM_XXH64_testdata[1798] */
    {  899, 0x000000009E3779B1ULL, 0xCF13844A85C42640ULL }, /* XSUM_XXH64_testdata[1799] */
    {  900, 0x0000000000000000ULL, 0x34FC8153AD7AB930ULL }, /* XSUM_XXH64_testdata[1800] */
    {  900, 0x000000009E3779B1ULL, 0x8F7622513B1D9DC2ULL }, /* XSUM_XXH64_testdata[1801] */
    {  901, 0x0000000000000000ULL, 0xC3486BA9844E54A7ULL }, /* XSUM_XXH64_testdata[1802] */
    {  901, 0x000000009E3779B1ULL, 0x47B809760623D391ULL }, /* XSUM_XXH64_testdata[1803] */
    {  902, 0x0000000000000000ULL, 0x71853AD64F8289DAULL }, /* XSUM_XXH64_testdata[1804] */
    {  902, 0x000000009E3779B1ULL, 0x90F5DD5F5F64F358ULL }, /* XSUM_XXH64_testdata[1805] */
    {  903, 0x0000000000000000ULL, 0xC8E0F8220B712E0CULL }, /* XSUM_XXH64_testdata[1806] */
    {  903, 0x000000009E3779B1ULL, 0xD6F6EC9CBAA986FEULL }, /* XSUM_XXH64_testdata[1807] */
    {  904, 0x0000000000000000ULL, 0x872BB676473843EAULL }, /* XSUM_XXH64_testdata[1808] */
    {  904, 0x000000009E3779B1ULL, 0xBCA66531B355FBA8ULL }, /* XSUM_XXH64_testdata[1809] */
    {  905, 0x0000000000000000ULL, 0x91511FB251237F8AULL }, /* XSUM_XXH64_testdata[1810] */
    {  905, 0x000000009E3779B1ULL, 0x732F8750B0A8C0DEULL }, /* XSUM_XXH64_testdata[1811] */
    {  906, 0x0000000000000000ULL, 0x334A87FB35C0DCBFULL }, /* XSUM_XXH64_testdata[1812] */
    {  906, 0x000000009E3779B1ULL, 0x3EF0B3C2B540234BULL }, /* XSUM_XXH64_testdata[1813] */
    {  907, 0x0000000000000000ULL, 0xAB9CD37F1726884CULL }, /* XSUM_XXH64_testdata[1814] */
    {  907, 0x000000009E3779B1ULL, 0x65C05C61A776363CULL }, /* XSUM_XXH64_testdata[1815] */
    {  908, 0x0000000000000000ULL, 0x7E2163FB2CF4B65AULL }, /* XSUM_XXH64_testdata[1816] */
    {  908, 0x000000009E3779B1ULL, 0xA053852AB27A3076ULL }, /* XSUM_XXH64_testdata[1817] */
    {  909, 0x0000000000000000ULL, 0xF29A55BE01944078ULL }, /* XSUM_XXH64_testdata[1818] */
    {  909, 0x000000009E3779B1ULL, 0xF63E99236BD744CCULL }, /* XSUM_XXH64_testdata[1819] */
    {  910, 0x0000000000000000ULL, 0xC1C060207E6E3340ULL }, /* XSUM_XXH64_testdata[1820] */
    {  910, 0x000000009E3779B1ULL, 0x132569AFF75C4781ULL }, /* XSUM_XXH64_testdata[1821] */
    {  911, 0x0000000000000000ULL, 0xB854EDCBD1292F42ULL }, /* XSUM_XXH64_testdata[1822] */
    {  911, 0x000000009E3779B1ULL, 0x9678D0C55D435CEBULL }, /* XSUM_XXH64_testdata[1823] */
    {  912, 0x0000000000000000ULL, 0x3D2DCB63A651366CULL }, /* XSUM_XXH64_testdata[1824] */
    {  912, 0x000000009E3779B1ULL, 0x866B93392C2CBE06ULL }, /* XSUM_XXH64_testdata[1825] */
    {  913, 0x0000000000000000ULL, 0xD91CC0E55EB42EDAULL }, /* XSUM_XXH64_testdata[1826] */
    {  913, 0x000000009E3779B1ULL, 0xC1A3DFD9745C4E38ULL }, /* XSUM_XXH64_testdata[1827] */
    {  914, 0x0000000000000000ULL, 0x61431AC8BB741ED2ULL }, /* XSUM_XXH64_testdata[1828] */
    {  914, 0x000000009E3779B1ULL, 0x1B60366055266CF4ULL }, /* XSUM_XXH64_testdata[1829] */
    {  915, 0x0000000000000000ULL, 0xE743BE3F686C9A6AULL }, /* XSUM_XXH64_testdata[1830] */
    {  915, 0x000000009E3779B1ULL, 0xA1E4CE411D17F0AEULL }, /* XSUM_XXH64_testdata[1831] */
    {  916, 0x0000000000000000ULL, 0x1BC2C6AD98A4B8EBULL }, /* XSUM_XXH64_testdata[1832] */
    {  916, 0x000000009E3779B1ULL, 0xBDB94942A6166561ULL }, /* XSUM_XXH64_testdata[1833] */
    {  917, 0x0000000000000000ULL, 0x061C077FABCD4E19ULL }, /* XSUM_XXH64_testdata[1834] */
    {  917, 0x000000009E3779B1ULL, 0xA9D76EFF6A1B71A7ULL }, /* XSUM_XXH64_testdata[1835] */
    {  918, 0x0000000000000000ULL, 0xF64A0DD5B51C30E5ULL }, /* XSUM_XXH64_testdata[1836] */
    {  918, 0x000000009E3779B1ULL, 0x32F10E67903A0CEAULL }, /* XSUM_XXH64_testdata[1837] */
    {  919, 0x0000000000000000ULL, 0x6B41A712104E4FF4ULL }, /* XSUM_XXH64_testdata[1838] */
    {  919, 0x000000009E3779B1ULL, 0xE1B719F756DA4F87ULL }, /* XSUM_XXH64_testdata[1839] */
    {  920, 0x0000000000000000ULL, 0xB3C2A0619DEA5257ULL }, /* XSUM_XXH64_testdata[1840] */
    {  920, 0x000000009E3779B1ULL, 0x56D919AF131CF2D0ULL }, /* XSUM_XXH64_testdata[1841] */
    {  921, 0x0000000000000000ULL, 0x51D960A7EB378757ULL }, /* XSUM_XXH64_testdata[1842] */
    {  921, 0x000000009E3779B1ULL, 0x34CBFFC317CEF49DULL }, /* XSUM_XXH64_testdata[1843] */
    {  922, 0x0000000000000000ULL, 0x21636E83700D176AULL }, /* XSUM_XXH64_testdata[1844] */
    {  922, 0x000000009E3779B1ULL, 0xCCD650B5D80B7A42ULL }, /* XSUM_XXH64_testdata[1845] */
    {  923, 0x0000000000000000ULL, 0x9CBA9ADDA8FD08A0ULL }, /* XSUM_XXH64_testdata[1846] */
    {  923, 0x000000009E3779B1ULL, 0x0019FD4DEAE8E468ULL }, /* XSUM_XXH64_testdata[1847] */
    {  924, 0x0000000000000000ULL, 0x1A52459A2BA85BB9ULL }, /* XSUM_XXH64_testdata[1848] */
    {  924, 0x000000009E3779B1ULL, 0x4F90992B6872BFC9ULL }, /* XSUM_XXH64_testdata[1849] */
    {  925, 0x0000000000000000ULL, 0x3C288D42FD23A661ULL }, /* XSUM_XXH64_testdata[1850] */
    {  925, 0x000000009E3779B1ULL, 0xE0C5567515568C70ULL }, /* XSUM_XXH64_testdata[1851] */
    {  926, 0x0000000000000000ULL, 0xEB52082513C838E7ULL }, /* XSUM_XXH64_testdata[1852] */
    {  926, 0x000000009E3779B1ULL, 0xC6ACA51B377583F2ULL }, /* XSUM_XXH64_testdata[1853] */
    {  927, 0x0000000000000000ULL, 0xCFA52F73570DA102ULL }, /* XSUM_XXH64_testdata[1854] */
    {  927, 0x000000009E3779B1ULL, 0x181B265D9E12C92AULL }, /* XSUM_XXH64_testdata[1855] */
    {  928, 0x0000000000000000ULL, 0xB1D71859CCDC145CULL }, /* XSUM_XXH64_testdata[1856] */
    {  928, 0x000000009E3779B1ULL, 0xD6CF4B6547EC69EEULL }, /* XSUM_XXH64_testdata[1857] */
    {  929, 0x0000000000000000ULL, 0x875AA57CF1490668ULL }, /* XSUM_XXH64_testdata[1858] */
    {  929, 0x000000009E3779B1ULL, 0x7EBEC9A7306FD4F9ULL }, /* XSUM_XXH64_testdata[1859] */
    {  930, 0x0000000000000000ULL, 0x72F30568D01F232CULL }, /* XSUM_XXH64_testdata[1860] */
    {  930, 0x000000009E3779B1ULL, 0x5A8008AC4C3FB332ULL }, /* XSUM_XXH64_testdata[1861] */
    {  931, 0x0000000000000000ULL, 0xBCD03F6C010345C6ULL }, /* XSUM_XXH64_testdata[1862] */
    {  931, 0x000000009E3779B1ULL, 0x7A2F074904B3B410ULL }, /* XSUM_XXH64_testdata[1863] */
    {  932, 0x0000000000000000ULL, 0x8903490B16E17640ULL }, /* XSUM_XXH64_testdata[1864] */
    {  932, 0x000000009E3779B1ULL, 0x223416F08376FDE5ULL }, /* XSUM_XXH64_testdata[1865] */
    {  933, 0x0000000000000000ULL, 0xF1A6803FE1DDC5C9ULL }, /* XSUM_XXH64_testdata[1866] */
    {  933, 0x000000009E3779B1ULL, 0xD15553FF4F1ED44CULL }, /* XSUM_XXH64_testdata[1867] */
    {  934, 0x0000000000000000ULL, 0xA525D3097874B9A2ULL }, /* XSUM_XXH64_testdata[1868] */
    {  934, 0x000000009E3779B1ULL, 0xAA2A747CD00B136FULL }, /* XSUM_XXH64_testdata[1869] */
    {  935, 0x0000000000000000ULL, 0x7F0CF6FBE99304A9ULL }, /* XSUM_XXH64_testdata[1870] */
    {  935, 0x000000009E3779B1ULL, 0xFBD72C7CC65544ADULL }, /* XSUM_XXH64_testdata[1871] */
    {  936, 0x0000000000000000ULL, 0x271BA1F7BA69FDD6ULL }, /* XSUM_XXH64_testdata[1872] */
    {  936, 0x000000009E3779B1ULL, 0xFCEAFEE0E7192C17ULL }, /* XSUM_XXH64_testdata[1873] */
    {  937, 0x0000000000000000ULL, 0xE247C25676C513CBULL }, /* XSUM_XXH64_testdata[1874] */
    {  937, 0x000000009E3779B1ULL, 0xE033EC0A4174FF52ULL }, /* XSUM_XXH64_testdata[1875] */
    {  938, 0x0000000000000000ULL, 0xBEFB4A77652C56CCULL }, /* XSUM_XXH64_testdata[1876] */
    {  938, 0x000000009E3779B1ULL, 0xC2B61FDD3ADF5FF7ULL }, /* XSUM_XXH64_testdata[1877] */
    {  939, 0x0000000000000000ULL, 0x6DCDECDEAB57050CULL }, /* XSUM_XXH64_testdata[1878] */
    {  939, 0x000000009E3779B1ULL, 0x92EFA9FA284D912AULL }, /* XSUM_XXH64_testdata[1879] */
    {  940, 0x0000000000000000ULL, 0xE4E419CBB76D0043ULL }, /* XSUM_XXH64_testdata[1880] */
    {  940, 0x000000009E3779B1ULL, 0x8839ADEFCB662FDFULL }, /* XSUM_XXH64_testdata[1881] */
    {  941, 0x0000000000000000ULL, 0x3068ACB573BD2B6EULL }, /* XSUM_XXH64_testdata[1882] */
    {  941, 0x000000009E3779B1ULL, 0x839D40868319A3C4ULL }, /* XSUM_XXH64_testdata[1883] */
    {  942, 0x0000000000000000ULL, 0x344DEE28071338FBULL }, /* XSUM_XXH64_testdata[1884] */
    {  942, 0x000000009E3779B1ULL, 0x83E70B9C55EF5493ULL }, /* XSUM_XXH64_testdata[1885] */
    {  943, 0x0000000000000000ULL, 0xFDB4A05A196ED5EDULL }, /* XSUM_XXH64_testdata[1886] */
    {  943, 0x000000009E3779B1ULL, 0xAED74734787C4863ULL }, /* XSUM_XXH64_testdata[1887] */
    {  944, 0x0000000000000000ULL, 0xE722DCF003C977BAULL }, /* XSUM_XXH64_testdata[1888] */
    {  944, 0x000000009E3779B1ULL, 0x895309BDF32FDDE3ULL }, /* XSUM_XXH64_testdata[1889] */
    {  945, 0x0000000000000000ULL, 0x43B3463ABE9F927AULL }, /* XSUM_XXH64_testdata[1890] */
    {  945, 0x000000009E3779B1ULL, 0x576727D13DE3DD5DULL }, /* XSUM_XXH64_testdata[1891] */
    {  946, 0x0000000000000000ULL, 0x5B9767F7D6B88323ULL }, /* XSUM_XXH64_testdata[1892] */
    {  946, 0x000000009E3779B1ULL, 0x3E216AC3955B31C0ULL }, /* XSUM_XXH64_testdata[1893] */
    {  947, 0x0000000000000000ULL, 0xDA3134F286975C2FULL }, /* XSUM_XXH64_testdata[1894] */
    {  947, 0x000000009E3779B1ULL, 0x3295559B81610B4BULL }, /* XSUM_XXH64_testdata[1895] */
    {  948, 0x0000000000000000ULL, 0xA97793ACCF18126EULL }, /* XSUM_XXH64_testdata[1896] */
    {  948, 0x000000009E3779B1ULL, 0x9B108BD762652A33ULL }, /* XSUM_XXH64_testdata[1897] */
    {  949, 0x0000000000000000ULL, 0xF23C83E1404A8C17ULL }, /* XSUM_XXH64_testdata[1898] */
    {  949, 0x000000009E3779B1ULL, 0x4716B3E039D6BFD9ULL }, /* XSUM_XXH64_testdata[1899] */
    {  950, 0x0000000000000000ULL, 0x599BE2B47286251CULL }, /* XSUM_XXH64_testdata[1900] */
    {  950, 0x000000009E3779B1ULL, 0x913010210E777D39ULL }, /* XSUM_XXH64_testdata[1901] */
    {  951, 0x0000000000000000ULL, 0x5F0420471473F3BDULL }, /* XSUM_XXH64_testdata[1902] */
    {  951, 0x000000009E3779B1ULL, 0xEA9D059F7016A352ULL }, /* XSUM_XXH64_testdata[1903] */
    {  952, 0x0000000000000000ULL, 0x1AA24C2CFDFF7C48ULL }, /* XSUM_XXH64_testdata[1904] */
    {  952, 0x000000009E3779B1ULL, 0x2E1A1CC2C2611FA7ULL }, /* XSUM_XXH64_testdata[1905] */
    {  953, 0x0000000000000000ULL, 0xB5CA404C3C988EBBULL }, /* XSUM_XXH64_testdata[1906] */
    {  953, 0x000000009E3779B1ULL, 0xA348801D1DF18709ULL }, /* XSUM_XXH64_testdata[1907] */
    {  954, 0x0000000000000000ULL, 0x8046EC1FBE642994ULL }, /* XSUM_XXH64_testdata[1908] */
    {  954, 0x000000009E3779B1ULL, 0x4238910281F31EDCULL }, /* XSUM_XXH64_testdata[1909] */
    {  955, 0x0000000000000000ULL, 0x56649EB17A8DC510ULL }, /* XSUM_XXH64_testdata[1910] */
    {  955, 0x000000009E3779B1ULL, 0x0750A96F3B397545ULL }, /* XSUM_XXH64_testdata[1911] */
    {  956, 0x0000000000000000ULL, 0xEEDA845627F4B952ULL }, /* XSUM_XXH64_testdata[1912] */
    {  956, 0x000000009E3779B1ULL, 0x538BB5300412CE68ULL }, /* XSUM_XXH64_testdata[1913] */
    {  957, 0x0000000000000000ULL, 0x4696EADEEF6FBB6CULL }, /* XSUM_XXH64_testdata[1914] */
    {  957, 0x000000009E3779B1ULL, 0x9B474549A6AC64E8ULL }, /* XSUM_XXH64_testdata[1915] */
    {  958, 0x0000000000000000ULL, 0xEC5A49A32C3DC271ULL }, /* XSUM_XXH64_testdata[1916] */
    {  958, 0x000000009E3779B1ULL, 0xB5F40B5A8E733749ULL }, /* XSUM_XXH64_testdata[1917] */
    {  959, 0x0000000000000000ULL, 0x5939F158CAAEDA6EULL }, /* XSUM_XXH64_testdata[1918] */
    {  959, 0x000000009E3779B1ULL, 0x69E7CA70696BC500ULL }, /* XSUM_XXH64_testdata[1919] */
    {  960, 0x0000000000000000ULL, 0x750E09CF7E1CD3B8ULL }, /* XSUM_XXH64_testdata[1920] */
    {  960, 0x000000009E3779B1ULL, 0x2DB5F46D063160B3ULL }, /* XSUM_XXH64_testdata[1921] */
    {  961, 0x0000000000000000ULL, 0xE11E19248104134FULL }, /* XSUM_XXH64_testdata[1922] */
    {  961, 0x000000009E3779B1ULL, 0x8989828CDDFD747BULL }, /* XSUM_XXH64_testdata[1923] */
    {  962, 0x0000000000000000ULL, 0xF3454B991D6A8D90ULL }, /* XSUM_XXH64_testdata[1924] */
    {  962, 0x000000009E3779B1ULL, 0xD35E5E9384812064ULL }, /* XSUM_XXH64_testdata[1925] */
    {  963, 0x0000000000000000ULL, 0x8C2C92FDDA8B6524ULL }, /* XSUM_XXH64_testdata[1926] */
    {  963, 0x000000009E3779B1ULL, 0xBAC996F4F66E2BDDULL }, /* XSUM_XXH64_testdata[1927] */
    {  964, 0x0000000000000000ULL, 0xF6E54E080621A525ULL }, /* XSUM_XXH64_testdata[1928] */
    {  964, 0x000000009E3779B1ULL, 0x112E799830BA167BULL }, /* XSUM_XXH64_testdata[1929] */
    {  965, 0x0000000000000000ULL, 0x556DEB77E1B98F4CULL }, /* XSUM_XXH64_testdata[1930] */
    {  965, 0x000000009E3779B1ULL, 0xBA1546C614ABD0BBULL }, /* XSUM_XXH64_testdata[1931] */
    {  966, 0x0000000000000000ULL, 0xA2171D71218B9848ULL }, /* XSUM_XXH64_testdata[1932] */
    {  966, 0x000000009E3779B1ULL, 0xC1C9BADEC2E1B280ULL }, /* XSUM_XXH64_testdata[1933] */
    {  967, 0x0000000000000000ULL, 0xB7A00C303A4192B5ULL }, /* XSUM_XXH64_testdata[1934] */
    {  967, 0x000000009E3779B1ULL, 0xD184F4CA5B2CC460ULL }, /* XSUM_XXH64_testdata[1935] */
    {  968, 0x0000000000000000ULL, 0xF80B7C0CFBC3B4CDULL }, /* XSUM_XXH64_testdata[1936] */
    {  968, 0x000000009E3779B1ULL, 0xFB099CFB0AD9D389ULL }, /* XSUM_XXH64_testdata[1937] */
    {  969, 0x0000000000000000ULL, 0x742DC7518702E796ULL }, /* XSUM_XXH64_testdata[1938] */
    {  969, 0x000000009E3779B1ULL, 0x5EE337A15CA15E00ULL }, /* XSUM_XXH64_testdata[1939] */
    {  970, 0x0000000000000000ULL, 0xAE0EA7F413CA1EF5ULL }, /* XSUM_XXH64_testdata[1940] */
    {  970, 0x000000009E3779B1ULL, 0xC353E324D2A28D0DULL }, /* XSUM_XXH64_testdata[1941] */
    {  971, 0x0000000000000000ULL, 0xD26E87F51DA81652ULL }, /* XSUM_XXH64_testdata[1942] */
    {  971, 0x000000009E3779B1ULL, 0xC0F3AFC9249B3637ULL }, /* XSUM_XXH64_testdata[1943] */
    {  972, 0x0000000000000000ULL, 0xA9799503AF071AC9ULL }, /* XSUM_XXH64_testdata[1944] */
    {  972, 0x000000009E3779B1ULL, 0xF24AF0EF07F25EB6ULL }, /* XSUM_XXH64_testdata[1945] */
    {  973, 0x0000000000000000ULL, 0xC66DE0325C52A78DULL }, /* XSUM_XXH64_testdata[1946] */
    {  973, 0x000000009E3779B1ULL, 0x8F7ED5FF94D75176ULL }, /* XSUM_XXH64_testdata[1947] */
    {  974, 0x0000000000000000ULL, 0xD3FB599095E7A29FULL }, /* XSUM_XXH64_testdata[1948] */
    {  974, 0x000000009E3779B1ULL, 0xFEC405E51028CA41ULL }, /* XSUM_XXH64_testdata[1949] */
    {  975, 0x0000000000000000ULL, 0x99449A872FBB65DDULL }, /* XSUM_XXH64_testdata[1950] */
    {  975, 0x000000009E3779B1ULL, 0x7DB3947E8EB8D55FULL }, /* XSUM_XXH64_testdata[1951] */
    {  976, 0x0000000000000000ULL, 0x4A47B732F5E06E99ULL }, /* XSUM_XXH64_testdata[1952] */
    {  976, 0x000000009E3779B1ULL, 0xB56FBA2825D13A23ULL }, /* XSUM_XXH64_testdata[1953] */
    {  977, 0x0000000000000000ULL, 0x8C0847CAF410EA6DULL }, /* XSUM_XXH64_testdata[1954] */
    {  977, 0x000000009E3779B1ULL, 0x39FEBA2B4BAA9F00ULL }, /* XSUM_XXH64_testdata[1955] */
    {  978, 0x0000000000000000ULL, 0xF16D4BE3E3B511DCULL }, /* XSUM_XXH64_testdata[1956] */
    {  978, 0x000000009E3779B1ULL, 0x6389B4C8B6BEA831ULL }, /* XSUM_XXH64_testdata[1957] */
    {  979, 0x0000000000000000ULL, 0x2A296AC3FC625219ULL }, /* XSUM_XXH64_testdata[1958] */
    {  979, 0x000000009E3779B1ULL, 0xAC9ADB163AA0D18EULL }, /* XSUM_XXH64_testdata[1959] */
    {  980, 0x0000000000000000ULL, 0x6061CEB7EFF73662ULL }, /* XSUM_XXH64_testdata[1960] */
    {  980, 0x000000009E3779B1ULL, 0x18034E6036C02D60ULL }, /* XSUM_XXH64_testdata[1961] */
    {  981, 0x0000000000000000ULL, 0xE8F825B506A92E90ULL }, /* XSUM_XXH64_testdata[1962] */
    {  981, 0x000000009E3779B1ULL, 0xF5ECF8C154445F4BULL }, /* XSUM_XXH64_testdata[1963] */
    {  982, 0x0000000000000000ULL, 0x79E9D50DD462C193ULL }, /* XSUM_XXH64_testdata[1964] */
    {  982, 0x000000009E3779B1ULL, 0xE0D4033A724A9A79ULL }, /* XSUM_XXH64_testdata[1965] */
    {  983, 0x0000000000000000ULL, 0x98C1114F8ACBAB27ULL }, /* XSUM_XXH64_testdata[1966] */
    {  983, 0x000000009E3779B1ULL, 0xB4C9B0F97A001F59ULL }, /* XSUM_XXH64_testdata[1967] */
    {  984, 0x0000000000000000ULL, 0xF8C65A26261594B9ULL }, /* XSUM_XXH64_testdata[1968] */
    {  984, 0x000000009E3779B1ULL, 0x8AD9570512182DDDULL }, /* XSUM_XXH64_testdata[1969] */
    {  985, 0x0000000000000000ULL, 0x53C6D93F6D817304ULL }, /* XSUM_XXH64_testdata[1970] */
    {  985, 0x000000009E3779B1ULL, 0x49FF2408C49B698CULL }, /* XSUM_XXH64_testdata[1971] */
    {  986, 0x0000000000000000ULL, 0x0E9C26B081B5C0DCULL }, /* XSUM_XXH64_testdata[1972] */
    {  986, 0x000000009E3779B1ULL, 0x914E0F78AFD29E54ULL }, /* XSUM_XXH64_testdata[1973] */
    {  987, 0x0000000000000000ULL, 0xAF2249EC5A9D91ADULL }, /* XSUM_XXH64_testdata[1974] */
    {  987, 0x000000009E3779B1ULL, 0xE23567B62D4EFE9FULL }, /* XSUM_XXH64_testdata[1975] */
    {  988, 0x0000000000000000ULL, 0x30B27E44725B629AULL }, /* XSUM_XXH64_testdata[1976] */
    {  988, 0x000000009E3779B1ULL, 0x0BD2A9B438B4B30FULL }, /* XSUM_XXH64_testdata[1977] */
    {  989, 0x0000000000000000ULL, 0x9E9883AB49E285CCULL }, /* XSUM_XXH64_testdata[1978] */
    {  989, 0x000000009E3779B1ULL, 0xE9C1EB98F3FE856DULL }, /* XSUM_XXH64_testdata[1979] */
    {  990, 0x0000000000000000ULL, 0xC2579D0DF7A48C58ULL }, /* XSUM_XXH64_testdata[1980] */
    {  990, 0x000000009E3779B1ULL, 0x4E470CD8DAF8A1C6ULL }, /* XSUM_XXH64_testdata[1981] */
    {  991, 0x0000000000000000ULL, 0x8750F562170FF762ULL }, /* XSUM_XXH64_testdata[1982] */
    {  991, 0x000000009E3779B1ULL, 0xF404CA139E272C7AULL }, /* XSUM_XXH64_testdata[1983] */
    {  992, 0x0000000000000000ULL, 0x82625FC90DB9FC5EULL }, /* XSUM_XXH64_testdata[1984] */
    {  992, 0x000000009E3779B1ULL, 0x207215F0735B9C0CULL }, /* XSUM_XXH64_testdata[1985] */
    {  993, 0x0000000000000000ULL, 0x36C84A9DEAF54B57ULL }, /* XSUM_XXH64_testdata[1986] */
    {  993, 0x000000009E3779B1ULL, 0x7AD5887EF9DFDB3DULL }, /* XSUM_XXH64_testdata[1987] */
    {  994, 0x0000000000000000ULL, 0xBCA6A33B0126DCC6ULL }, /* XSUM_XXH64_testdata[1988] */
    {  994, 0x000000009E3779B1ULL, 0x254933D9522A4338ULL }, /* XSUM_XXH64_testdata[1989] */
    {  995, 0x0000000000000000ULL, 0xCC817C7754AC069BULL }, /* XSUM_XXH64_testdata[1990] */
    {  995, 0x000000009E3779B1ULL, 0x6C6D7066AC64843BULL }, /* XSUM_XXH64_testdata[1991] */
    {  996, 0x0000000000000000ULL, 0x69D1CFAB4B334AD9ULL }, /* XSUM_XXH64_testdata[1992] */
    {  996, 0x000000009E3779B1ULL, 0x7506295E03E5E62AULL }, /* XSUM_XXH64_testdata[1993] */
    {  997, 0x0000000000000000ULL, 0x6A00AAEDCE614EE0ULL }, /* XSUM_XXH64_testdata[1994] */
    {  997, 0x000000009E3779B1ULL, 0xF14BBA7E77A4116AULL }, /* XSUM_XXH64_testdata[1995] */
    {  998, 0x0000000000000000ULL, 0xE62B6467D2FDE480ULL }, /* XSUM_XXH64_testdata[1996] */
    {  998, 0x000000009E3779B1ULL, 0x94CCD1F6294C3BCDULL }, /* XSUM_XXH64_testdata[1997] */
    {  999, 0x0000000000000000ULL, 0x22EAC650671B0AA7ULL }, /* XSUM_XXH64_testdata[1998] */
    {  999, 0x000000009E3779B1ULL, 0x66285FFFD248F989ULL }, /* XSUM_XXH64_testdata[1999] */
    { 1000, 0x0000000000000000ULL, 0x52BD1358F22E9EF7ULL }, /* XSUM_XXH64_testdata[2000] */
    { 1000, 0x000000009E3779B1ULL, 0x72751A2408017E26ULL }, /* XSUM_XXH64_testdata[2001] */
    { 1001, 0x0000000000000000ULL, 0xB480E8B7515D04DDULL }, /* XSUM_XXH64_testdata[2002] */
    { 1001, 0x000000009E3779B1ULL, 0xEDE672D0F1EA02AAULL }, /* XSUM_XXH64_testdata[2003] */
    { 1002, 0x0000000000000000ULL, 0x84F40BC5966C5FABULL }, /* XSUM_XXH64_testdata[2004] */
    { 1002, 0x000000009E3779B1ULL, 0x1D0A524CA46775BBULL }, /* XSUM_XXH64_testdata[2005] */
    { 1003, 0x0000000000000000ULL, 0xBF6A62F786B68292ULL }, /* XSUM_XXH64_testdata[2006] */
    { 1003, 0x000000009E3779B1ULL, 0x03998F6F4F74F640ULL }, /* XSUM_XXH64_testdata[2007] */
    { 1004, 0x0000000000000000ULL, 0xFB534827BF545747ULL }, /* XSUM_XXH64_testdata[2008] */
    { 1004, 0x000000009E3779B1ULL, 0x677EAF30B29F2891ULL }, /* XSUM_XXH64_testdata[2009] */
    { 1005, 0x0000000000000000ULL, 0xB5E4615A2184A07FULL }, /* XSUM_XXH64_testdata[2010] */
    { 1005, 0x000000009E3779B1ULL, 0x9E6062FC87389D70ULL }, /* XSUM_XXH64_testdata[2011] */
    { 1006, 0x0000000000000000ULL, 0xFF6939DED1FF7ED2ULL }, /* XSUM_XXH64_testdata[2012] */
    { 1006, 0x000000009E3779B1ULL, 0xE53E5A582CA4C1C5ULL }, /* XSUM_XXH64_testdata[2013] */
    { 1007, 0x0000000000000000ULL, 0xA8D82A9AE2D6E8DCULL }, /* XSUM_XXH64_testdata[2014] */
    { 1007, 0x000000009E3779B1ULL, 0xDB3B18216E4DB05DULL }, /* XSUM_XXH64_testdata[2015] */
    { 1008, 0x0000000000000000ULL, 0x448D96F74D9C48EFULL }, /* XSUM_XXH64_testdata[2016] */
    { 1008, 0x000000009E3779B1ULL, 0x1B7D1895174728EBULL }, /* XSUM_XXH64_testdata[2017] */
    { 1009, 0x0000000000000000ULL, 0xACF2E9D6BAC53EC4ULL }, /* XSUM_XXH64_testdata[2018] */
    { 1009, 0x000000009E3779B1ULL, 0x8B93A579D90FA20FULL }, /* XSUM_XXH64_testdata[2019] */
    { 1010, 0x0000000000000000ULL, 0x3836C816BD0EFA4FULL }, /* XSUM_XXH64_testdata[2020] */
    { 1010, 0x000000009E3779B1ULL, 0xD9E2AA4EFB329F75ULL }, /* XSUM_XXH64_testdata[2021] */
    { 1011, 0x0000000000000000ULL, 0x0C2C0B4BA7A25E09ULL }, /* XSUM_XXH64_testdata[2022] */
    { 1011, 0x000000009E3779B1ULL, 0x2606C925EE0F0419ULL }, /* XSUM_XXH64_testdata[2023] */
    { 1012, 0x0000000000000000ULL, 0x62AC5C1F4CB7928CULL }, /* XSUM_XXH64_testdata[2024] */
    { 1012, 0x000000009E3779B1ULL, 0x24D52EAC502F74F7ULL }, /* XSUM_XXH64_testdata[2025] */
    { 1013, 0x0000000000000000ULL, 0x786BB0D229F29B54ULL }, /* XSUM_XXH64_testdata[2026] */
    { 1013, 0x000000009E3779B1ULL, 0x747E6DFAE1FF2BBCULL }, /* XSUM_XXH64_testdata[2027] */
    { 1014, 0x0000000000000000ULL, 0xDBFE59C341076FA5ULL }, /* XSUM_XXH64_testdata[2028] */
    { 1014, 0x000000009E3779B1ULL, 0xCB68F2361C5AD1FBULL }, /* XSUM_XXH64_testdata[2029] */
    { 1015, 0x0000000000000000ULL, 0x931E78AA3285CAFFULL }, /* XSUM_XXH64_testdata[2030] */
    { 1015, 0x000000009E3779B1ULL, 0x78236895F00A5AA5ULL }, /* XSUM_XXH64_testdata[2031] */
    { 1016, 0x0000000000000000ULL, 0xF26CB2AB4B1409CEULL }, /* XSUM_XXH64_testdata[2032] */
    { 1016, 0x000000009E3779B1ULL, 0xE9199F83511D52E5ULL }, /* XSUM_XXH64_testdata[2033] */
    { 1017, 0x0000000000000000ULL, 0x5E13E01057523404ULL }, /* XSUM_XXH64_testdata[2034] */
    { 1017, 0x000000009E3779B1ULL, 0x7A28922AECB03E49ULL }, /* XSUM_XXH64_testdata[2035] */
    { 1018, 0x0000000000000000ULL, 0x92274DAF25DCFCBBULL }, /* XSUM_XXH64_testdata[2036] */
    { 1018, 0x000000009E3779B1ULL, 0x4D436A00DB8CB24EULL }, /* XSUM_XXH64_testdata[2037] */
    { 1019, 0x0000000000000000ULL, 0x491D3C12E9452FECULL }, /* XSUM_XXH64_testdata[2038] */
    { 1019, 0x000000009E3779B1ULL, 0xBDE075C6FEA8DE02ULL }, /* XSUM_XXH64_testdata[2039] */
    { 1020, 0x0000000000000000ULL, 0x2EE1FABEA33935D6ULL }, /* XSUM_XXH64_testdata[2040] */
    { 1020, 0x000000009E3779B1ULL, 0x26737225155A83FEULL }, /* XSUM_XXH64_testdata[2041] */
    { 1021, 0x0000000000000000ULL, 0xA1B09D2D377A1D66ULL }, /* XSUM_XXH64_testdata[2042] */
    { 1021, 0x000000009E3779B1ULL, 0x92DEEB2EF1083DCAULL }, /* XSUM_XXH64_testdata[2043] */
    { 1022, 0x0000000000000000ULL, 0x791952F3D2A33E0AULL }, /* XSUM_XXH64_testdata[2044] */
    { 1022, 0x000000009E3779B1ULL, 0x663E52964338A17DULL }, /* XSUM_XXH64_testdata[2045] */
    { 1023, 0x0000000000000000ULL, 0xAAC72718B7620924ULL }, /* XSUM_XXH64_testdata[2046] */
    { 1023, 0x000000009E3779B1ULL, 0xE0935AF8C59B7E98ULL }, /* XSUM_XXH64_testdata[2047] */
    { 1024, 0x0000000000000000ULL, 0x4775BF7CACE4D177ULL }, /* XSUM_XXH64_testdata[2048] */
    { 1024, 0x000000009E3779B1ULL, 0x238CF9296898B465ULL }, /* XSUM_XXH64_testdata[2049] */
    { 1025, 0x0000000000000000ULL, 0x847FA6006D7C2AC0ULL }, /* XSUM_XXH64_testdata[2050] */
    { 1025, 0x000000009E3779B1ULL, 0xB2A65F21FB8D0F5EULL }, /* XSUM_XXH64_testdata[2051] */
    { 1026, 0x0000000000000000ULL, 0x9400810EBDD39C5AULL }, /* XSUM_XXH64_testdata[2052] */
    { 1026, 0x000000009E3779B1ULL, 0x82E3F353C6A49DF3ULL }, /* XSUM_XXH64_testdata[2053] */
    { 1027, 0x0000000000000000ULL, 0x2DE816315ECE98EDULL }, /* XSUM_XXH64_testdata[2054] */
    { 1027, 0x000000009E3779B1ULL, 0xF76930161775C1AAULL }, /* XSUM_XXH64_testdata[2055] */
    { 1028, 0x0000000000000000ULL, 0x2F727A3F02CF40ACULL }, /* XSUM_XXH64_testdata[2056] */
    { 1028, 0x000000009E3779B1ULL, 0xACC9532D67E1F412ULL }, /* XSUM_XXH64_testdata[2057] */
    { 1029, 0x0000000000000000ULL, 0x1FAEED43381CC350ULL }, /* XSUM_XXH64_testdata[2058] */
    { 1029, 0x000000009E3779B1ULL, 0x4A59E208A708A00EULL }, /* XSUM_XXH64_testdata[2059] */
    { 1030, 0x0000000000000000ULL, 0xA9A789D6B3ED2AB5ULL }, /* XSUM_XXH64_testdata[2060] */
    { 1030, 0x000000009E3779B1ULL, 0x4FC79BE7BADF83C8ULL }, /* XSUM_XXH64_testdata[2061] */
    { 1031, 0x0000000000000000ULL, 0x7ED4616339789533ULL }, /* XSUM_XXH64_testdata[2062] */
    { 1031, 0x000000009E3779B1ULL, 0xF4E55A1CA96AA533ULL }, /* XSUM_XXH64_testdata[2063] */
    { 1032, 0x0000000000000000ULL, 0x50A67DFFCFE9DCA9ULL }, /* XSUM_XXH64_testdata[2064] */
    { 1032, 0x000000009E3779B1ULL, 0x20C6042F883EE813ULL }, /* XSUM_XXH64_testdata[2065] */
    { 1033, 0x0000000000000000ULL, 0x4C267E0F8B0394BAULL }, /* XSUM_XXH64_testdata[2066] */
    { 1033, 0x000000009E3779B1ULL, 0xB5368D1175B5F4A3ULL }, /* XSUM_XXH64_testdata[2067] */
    { 1034, 0x0000000000000000ULL, 0x9A6F2DAE8F28DD5DULL }, /* XSUM_XXH64_testdata[2068] */
    { 1034, 0x000000009E3779B1ULL, 0x58A4412A0EC58060ULL }, /* XSUM_XXH64_testdata[2069] */
    { 1035, 0x0000000000000000ULL, 0xE353FDB7C8FC8D15ULL }, /* XSUM_XXH64_testdata[2070] */
    { 1035, 0x000000009E3779B1ULL, 0xD05C111B7F5DBB91ULL }, /* XSUM_XXH64_testdata[2071] */
    { 1036, 0x0000000000000000ULL, 0xC1DA0CC2EB62B342ULL }, /* XSUM_XXH64_testdata[2072] */
    { 1036, 0x000000009E3779B1ULL, 0xEE69BDE57BE759A4ULL }, /* XSUM_XXH64_testdata[2073] */
    { 1037, 0x0000000000000000ULL, 0xF7B88F7002C5A4A4ULL }, /* XSUM_XXH64_testdata[2074] */
    { 1037, 0x000000009E3779B1ULL, 0xECB187C58898BCE0ULL }, /* XSUM_XXH64_testdata[2075] */
    { 1038, 0x0000000000000000ULL, 0xC3FB1D1518ECC87EULL }, /* XSUM_XXH64_testdata[2076] */
    { 1038, 0x000000009E3779B1ULL, 0xBBA21C6E6134ECBFULL }, /* XSUM_XXH64_testdata[2077] */
    { 1039, 0x0000000000000000ULL, 0xE5B4095F61120E36ULL }, /* XSUM_XXH64_testdata[2078] */
    { 1039, 0x000000009E3779B1ULL, 0xB504E4EF8CBCCF5DULL }, /* XSUM_XXH64_testdata[2079] */
    { 1040, 0x0000000000000000ULL, 0x1B53D42AA76BD71AULL }, /* XSUM_XXH64_testdata[2080] */
    { 1040, 0x000000009E3779B1ULL, 0x3ECA620E8CA0E162ULL }, /* XSUM_XXH64_testdata[2081] */
    { 1041, 0x0000000000000000ULL, 0x473D4779C838A069ULL }, /* XSUM_XXH64_testdata[2082] */
    { 1041, 0x000000009E3779B1ULL, 0xFF807BE46C510E36ULL }, /* XSUM_XXH64_testdata[2083] */
    { 1042, 0x0000000000000000ULL, 0x1D9940A24B80F97FULL }, /* XSUM_XXH64_testdata[2084] */
    { 1042, 0x000000009E3779B1ULL, 0xBD60D6ED58A888C3ULL }, /* XSUM_XXH64_testdata[2085] */
    { 1043, 0x0000000000000000ULL, 0x35252855430B9A3AULL }, /* XSUM_XXH64_testdata[2086] */
    { 1043, 0x000000009E3779B1ULL, 0x12394E6629A2394FULL }, /* XSUM_XXH64_testdata[2087] */
    { 1044, 0x0000000000000000ULL, 0x04EDD587E551081DULL }, /* XSUM_XXH64_testdata[2088] */
    { 1044, 0x000000009E3779B1ULL, 0x1AE86BF0CABD862BULL }, /* XSUM_XXH64_testdata[2089] */
    { 1045, 0x0000000000000000ULL, 0xB8F2D42D37481FA5ULL }, /* XSUM_XXH64_testdata[2090] */
    { 1045, 0x000000009E3779B1ULL, 0x250AB92B17C7DD2EULL }, /* XSUM_XXH64_testdata[2091] */
    { 1046, 0x0000000000000000ULL, 0x004A1C0FA3C6CD18ULL }, /* XSUM_XXH64_testdata[2092] */
    { 1046, 0x000000009E3779B1ULL, 0x807402EA52F8EFF7ULL }, /* XSUM_XXH64_testdata[2093] */
    { 1047, 0x0000000000000000ULL, 0xB034FAD5832FB8C0ULL }, /* XSUM_XXH64_testdata[2094] */
    { 1047, 0x000000009E3779B1ULL, 0x53274E56DE083226ULL }, /* XSUM_XXH64_testdata[2095] */
    { 1048, 0x0000000000000000ULL, 0x17542E3F48CFD64EULL }, /* XSUM_XXH64_testdata[2096] */
    { 1048, 0x000000009E3779B1ULL, 0xB2C45D680285EACBULL }, /* XSUM_XXH64_testdata[2097] */
    { 1049, 0x0000000000000000ULL, 0x7BA19DF2AE6AFBA2ULL }, /* XSUM_XXH64_testdata[2098] */
    { 1049, 0x000000009E3779B1ULL, 0x0709B30BB9936974ULL }, /* XSUM_XXH64_testdata[2099] */
    { 1050, 0x0000000000000000ULL, 0xC1DF9499D4B9556EULL }, /* XSUM_XXH64_testdata[2100] */
    { 1050, 0x000000009E3779B1ULL, 0x5E335FADC2BC52EBULL }, /* XSUM_XXH64_testdata[2101] */
    { 1051, 0x0000000000000000ULL, 0x85D1DD53E32148C0ULL }, /* XSUM_XXH64_testdata[2102] */
    { 1051, 0x000000009E3779B1ULL, 0xA65B59B05420991AULL }, /* XSUM_XXH64_testdata[2103] */
    { 1052, 0x0000000000000000ULL, 0x18D6BEE1C8D19D55ULL }, /* XSUM_XXH64_testdata[2104] */
    { 1052, 0x000000009E3779B1ULL, 0x405C984C9EC5674CULL }, /* XSUM_XXH64_testdata[2105] */
    { 1053, 0x0000000000000000ULL, 0x73BFFE4CF55749FAULL }, /* XSUM_XXH64_testdata[2106] */
    { 1053, 0x000000009E3779B1ULL, 0x4047C36707DA2790ULL }, /* XSUM_XXH64_testdata[2107] */
    { 1054, 0x0000000000000000ULL, 0xD8F7B9A27877D772ULL }, /* XSUM_XXH64_testdata[2108] */
    { 1054, 0x000000009E3779B1ULL, 0x7BDB2E27BC8F53ECULL }, /* XSUM_XXH64_testdata[2109] */
    { 1055, 0x0000000000000000ULL, 0x8B856CFA292934DAULL }, /* XSUM_XXH64_testdata[2110] */
    { 1055, 0x000000009E3779B1ULL, 0xF2EB44BED91BD79EULL }, /* XSUM_XXH64_testdata[2111] */
    { 1056, 0x0000000000000000ULL, 0x1F97894F15918722ULL }, /* XSUM_XXH64_testdata[2112] */
    { 1056, 0x000000009E3779B1ULL, 0x910D84B7344C3A34ULL }, /* XSUM_XXH64_testdata[2113] */
    { 1057, 0x0000000000000000ULL, 0x68A161AB02FA67BDULL }, /* XSUM_XXH64_testdata[2114] */
    { 1057, 0x000000009E3779B1ULL, 0x9FBB3C4E81B805C9ULL }, /* XSUM_XXH64_testdata[2115] */
    { 1058, 0x0000000000000000ULL, 0x0F169E5CA75D12A7ULL }, /* XSUM_XXH64_testdata[2116] */
    { 1058, 0x000000009E3779B1ULL, 0xAF84CC9EACA77C82ULL }, /* XSUM_XXH64_testdata[2117] */
    { 1059, 0x0000000000000000ULL, 0xE45264695EBCA721ULL }, /* XSUM_XXH64_testdata[2118] */
    { 1059, 0x000000009E3779B1ULL, 0xFB6D5AB1BA69E123ULL }, /* XSUM_XXH64_testdata[2119] */
    { 1060, 0x0000000000000000ULL, 0x235E2A1946DE1C9BULL }, /* XSUM_XXH64_testdata[2120] */
    { 1060, 0x000000009E3779B1ULL, 0x87B2A8A0FE63C375ULL }, /* XSUM_XXH64_testdata[2121] */
    { 1061, 0x0000000000000000ULL, 0xBF9C20F217025612ULL }, /* XSUM_XXH64_testdata[2122] */
    { 1061, 0x000000009E3779B1ULL, 0x41197864FF94B0B5ULL }, /* XSUM_XXH64_testdata[2123] */
    { 1062, 0x0000000000000000ULL, 0x515EAE35A8201954ULL }, /* XSUM_XXH64_testdata[2124] */
    { 1062, 0x000000009E3779B1ULL, 0xD84D1477C3289A04ULL }, /* XSUM_XXH64_testdata[2125] */
    { 1063, 0x0000000000000000ULL, 0xFC6AF0AC0CBBDE96ULL }, /* XSUM_XXH64_testdata[2126] */
    { 1063, 0x000000009E3779B1ULL, 0x68DAD59819FB9704ULL }, /* XSUM_XXH64_testdata[2127] */
    { 1064, 0x0000000000000000ULL, 0x9E00693AED5C571FULL }, /* XSUM_XXH64_testdata[2128] */
    { 1064, 0x000000009E3779B1ULL, 0xB90ADE1CFD9DE43FULL }, /* XSUM_XXH64_testdata[2129] */
    { 1065, 0x0000000000000000ULL, 0x99866D8AFB9F261EULL }, /* XSUM_XXH64_testdata[2130] */
    { 1065, 0x000000009E3779B1ULL, 0x8F2886A69BC0DA49ULL }, /* XSUM_XXH64_testdata[2131] */
    { 1066, 0x0000000000000000ULL, 0x8E32E6D4CE722645ULL }, /* XSUM_XXH64_testdata[2132] */
    { 1066, 0x000000009E3779B1ULL, 0xAF0C5BD253C608DEULL }, /* XSUM_XXH64_testdata[2133] */
    { 1067, 0x0000000000000000ULL, 0x763B7C6F61794267ULL }, /* XSUM_XXH64_testdata[2134] */
    { 1067, 0x000000009E3779B1ULL, 0x710D42A53E21F189ULL }, /* XSUM_XXH64_testdata[2135] */
    { 1068, 0x0000000000000000ULL, 0x2AAF42B037E263D2ULL }, /* XSUM_XXH64_testdata[2136] */
    { 1068, 0x000000009E3779B1ULL, 0xE75A9C9818B8E9A2ULL }, /* XSUM_XXH64_testdata[2137] */
    { 1069, 0x0000000000000000ULL, 0xD0B124FEAA8BC17CULL }, /* XSUM_XXH64_testdata[2138] */
    { 1069, 0x000000009E3779B1ULL, 0x2C447E9FB310EEFEULL }, /* XSUM_XXH64_testdata[2139] */
    { 1070, 0x0000000000000000ULL, 0x811421D866CFE3A3ULL }, /* XSUM_XXH64_testdata[2140] */
    { 1070, 0x000000009E3779B1ULL, 0x3BE32827DD550FA2ULL }, /* XSUM_XXH64_testdata[2141] */
    { 1071, 0x0000000000000000ULL, 0xE50EF5BA589F2FC3ULL }, /* XSUM_XXH64_testdata[2142] */
    { 1071, 0x000000009E3779B1ULL, 0xE19F7B8C367E5887ULL }, /* XSUM_XXH64_testdata[2143] */
    { 1072, 0x0000000000000000ULL, 0x737EFC7B06D47CBDULL }, /* XSUM_XXH64_testdata[2144] */
    { 1072, 0x000000009E3779B1ULL, 0xC081A3138E6D55AAULL }, /* XSUM_XXH64_testdata[2145] */
    { 1073, 0x0000000000000000ULL, 0xDE1791F5A69D7BEDULL }, /* XSUM_XXH64_testdata[2146] */
    { 1073, 0x000000009E3779B1ULL, 0x14507D40277164EBULL }, /* XSUM_XXH64_testdata[2147] */
    { 1074, 0x0000000000000000ULL, 0x544D569F180718FAULL }, /* XSUM_XXH64_testdata[2148] */
    { 1074, 0x000000009E3779B1ULL, 0x69DD83FEECAE8C7CULL }, /* XSUM_XXH64_testdata[2149] */
    { 1075, 0x0000000000000000ULL, 0x5BBDA56F78F9E485ULL }, /* XSUM_XXH64_testdata[2150] */
    { 1075, 0x000000009E3779B1ULL, 0x0AD509D729D0FB11ULL }, /* XSUM_XXH64_testdata[2151] */
    { 1076, 0x0000000000000000ULL, 0x68A91DF67CF9D691ULL }, /* XSUM_XXH64_testdata[2152] */
    { 1076, 0x000000009E3779B1ULL, 0xE4F216B27A707FD6ULL }, /* XSUM_XXH64_testdata[2153] */
    { 1077, 0x0000000000000000ULL, 0x647E9EBB14A16875ULL }, /* XSUM_XXH64_testdata[2154] */
    { 1077, 0x000000009E3779B1ULL, 0xD361DEC7B3FD8447ULL }, /* XSUM_XXH64_testdata[2155] */
    { 1078, 0x0000000000000000ULL, 0x6BCCC123273D16DDULL }, /* XSUM_XXH64_testdata[2156] */
    { 1078, 0x000000009E3779B1ULL, 0x2A2D1667E8534641ULL }, /* XSUM_XXH64_testdata[2157] */
    { 1079, 0x0000000000000000ULL, 0x0469DF5210B0A319ULL }, /* XSUM_XXH64_testdata[2158] */
    { 1079, 0x000000009E3779B1ULL, 0x8ED90D0C1A1A55F7ULL }, /* XSUM_XXH64_testdata[2159] */
    { 1080, 0x0000000000000000ULL, 0xBBB4D377BC41D40CULL }, /* XSUM_XXH64_testdata[2160] */
    { 1080, 0x000000009E3779B1ULL, 0x56EEA659CBFE6C71ULL }, /* XSUM_XXH64_testdata[2161] */
    { 1081, 0x0000000000000000ULL, 0x795A4C700E6DA14FULL }, /* XSUM_XXH64_testdata[2162] */
    { 1081, 0x000000009E3779B1ULL, 0x112E11E4FA4F38A1ULL }, /* XSUM_XXH64_testdata[2163] */
    { 1082, 0x0000000000000000ULL, 0x4B6E46F3FFD5BBDBULL }, /* XSUM_XXH64_testdata[2164] */
    { 1082, 0x000000009E3779B1ULL, 0xB0AC59178769887DULL }, /* XSUM_XXH64_testdata[2165] */
    { 1083, 0x0000000000000000ULL, 0x94E9689B67388F6FULL }, /* XSUM_XXH64_testdata[2166] */
    { 1083, 0x000000009E3779B1ULL, 0x2E94DA5C4AA8C222ULL }, /* XSUM_XXH64_testdata[2167] */
    { 1084, 0x0000000000000000ULL, 0xDCD358B889D0E2DCULL }, /* XSUM_XXH64_testdata[2168] */
    { 1084, 0x000000009E3779B1ULL, 0x60BB19C570953807ULL }, /* XSUM_XXH64_testdata[2169] */
    { 1085, 0x0000000000000000ULL, 0x1DD076F36B610A34ULL }, /* XSUM_XXH64_testdata[2170] */
    { 1085, 0x000000009E3779B1ULL, 0x0E388F4CE044B784ULL }, /* XSUM_XXH64_testdata[2171] */
    { 1086, 0x0000000000000000ULL, 0xA0D41FB4573E4663ULL }, /* XSUM_XXH64_testdata[2172] */
    { 1086, 0x000000009E3779B1ULL, 0x19B04148C5762DE0ULL }, /* XSUM_XXH64_testdata[2173] */
    { 1087, 0x0000000000000000ULL, 0x2ED91C113ADEB4E2ULL }, /* XSUM_XXH64_testdata[2174] */
    { 1087, 0x000000009E3779B1ULL, 0x990F97AC0A97687BULL }, /* XSUM_XXH64_testdata[2175] */
    { 1088, 0x0000000000000000ULL, 0xFD460A306F72CB1BULL }, /* XSUM_XXH64_testdata[2176] */
    { 1088, 0x000000009E3779B1ULL, 0xADC92E18954D9DE3ULL }, /* XSUM_XXH64_testdata[2177] */
    { 1089, 0x0000000000000000ULL, 0x760381BAB3D0091EULL }, /* XSUM_XXH64_testdata[2178] */
    { 1089, 0x000000009E3779B1ULL, 0x8E2D2D722A6305EEULL }, /* XSUM_XXH64_testdata[2179] */
    { 1090, 0x0000000000000000ULL, 0xAD195A94E1A4181BULL }, /* XSUM_XXH64_testdata[2180] */
    { 1090, 0x000000009E3779B1ULL, 0xE28BFA2C7B79AA88ULL }, /* XSUM_XXH64_testdata[2181] */
    { 1091, 0x0000000000000000ULL, 0x7ECE1AD155B15433ULL }, /* XSUM_XXH64_testdata[2182] */
    { 1091, 0x000000009E3779B1ULL, 0xF0E411DC6DE53E8CULL }, /* XSUM_XXH64_testdata[2183] */
    { 1092, 0x0000000000000000ULL, 0x1C52AF648C034FD3ULL }, /* XSUM_XXH64_testdata[2184] */
    { 1092, 0x000000009E3779B1ULL, 0x92879E26235BDDE5ULL }, /* XSUM_XXH64_testdata[2185] */
    { 1093, 0x0000000000000000ULL, 0x78F1C0D5738C5B7BULL }, /* XSUM_XXH64_testdata[2186] */
    { 1093, 0x000000009E3779B1ULL, 0x194884189103099EULL }, /* XSUM_XXH64_testdata[2187] */
    { 1094, 0x0000000000000000ULL, 0x094F82164FC2F627ULL }, /* XSUM_XXH64_testdata[2188] */
    { 1094, 0x000000009E3779B1ULL, 0x3E19EF4057FD11FFULL }, /* XSUM_XXH64_testdata[2189] */
    { 1095, 0x0000000000000000ULL, 0x54BEC413CC381E17ULL }, /* XSUM_XXH64_testdata[2190] */
    { 1095, 0x000000009E3779B1ULL, 0x34DA38067783BF0CULL }, /* XSUM_XXH64_testdata[2191] */
    { 1096, 0x0000000000000000ULL, 0xF5D1EAFEB0E65349ULL }, /* XSUM_XXH64_testdata[2192] */
    { 1096, 0x000000009E3779B1ULL, 0x55BCD771E3C2205FULL }, /* XSUM_XXH64_testdata[2193] */
    { 1097, 0x0000000000000000ULL, 0xC516358FA266550FULL }, /* XSUM_XXH64_testdata[2194] */
    { 1097, 0x000000009E3779B1ULL, 0x29DDD72541A268E4ULL }, /* XSUM_XXH64_testdata[2195] */
    { 1098, 0x0000000000000000ULL, 0xFA68CB989E20C255ULL }, /* XSUM_XXH64_testdata[2196] */
    { 1098, 0x000000009E3779B1ULL, 0x87F38CE2E7ABDAE6ULL }, /* XSUM_XXH64_testdata[2197] */
    { 1099, 0x0000000000000000ULL, 0x367D1901C5FCF67FULL }, /* XSUM_XXH64_testdata[2198] */
    { 1099, 0x000000009E3779B1ULL, 0xC92DB29414420FF7ULL }, /* XSUM_XXH64_testdata[2199] */
    { 1100, 0x0000000000000000ULL, 0x12D589E96BF39DE3ULL }, /* XSUM_XXH64_testdata[2200] */
    { 1100, 0x000000009E3779B1ULL, 0x668C0582557401FEULL }, /* XSUM_XXH64_testdata[2201] */
    { 1101, 0x0000000000000000ULL, 0x5595F02F28A75172ULL }, /* XSUM_XXH64_testdata[2202] */
    { 1101, 0x000000009E3779B1ULL, 0x38382D209D505743ULL }, /* XSUM_XXH64_testdata[2203] */
    { 1102, 0x0000000000000000ULL, 0xD4A991EF58C4FF7EULL }, /* XSUM_XXH64_testdata[2204] */
    { 1102, 0x000000009E3779B1ULL, 0x2EF0CD65E3434824ULL }, /* XSUM_XXH64_testdata[2205] */
    { 1103, 0x0000000000000000ULL, 0x6CDE39F1651D3864ULL }, /* XSUM_XXH64_testdata[2206] */
    { 1103, 0x000000009E3779B1ULL, 0xA952A8112F3F1C6FULL }, /* XSUM_XXH64_testdata[2207] */
    { 1104, 0x0000000000000000ULL, 0xE907C2A215074EACULL }, /* XSUM_XXH64_testdata[2208] */
    { 1104, 0x000000009E3779B1ULL, 0x372CCCC9380C4522ULL }, /* XSUM_XXH64_testdata[2209] */
    { 1105, 0x0000000000000000ULL, 0x3E7461E33C9C35E7ULL }, /* XSUM_XXH64_testdata[2210] */
    { 1105, 0x000000009E3779B1ULL, 0x2C4184886BB73F25ULL }, /* XSUM_XXH64_testdata[2211] */
    { 1106, 0x0000000000000000ULL, 0x0E30173DD9269D5DULL }, /* XSUM_XXH64_testdata[2212] */
    { 1106, 0x000000009E3779B1ULL, 0x637FDD34CF4F27EEULL }, /* XSUM_XXH64_testdata[2213] */
    { 1107, 0x0000000000000000ULL, 0xB7C113A6FF4307D7ULL }, /* XSUM_XXH64_testdata[2214] */
    { 1107, 0x000000009E3779B1ULL, 0x87D2A6B45D4AB6FFULL }, /* XSUM_XXH64_testdata[2215] */
    { 1108, 0x0000000000000000ULL, 0x78FDDCB965009322ULL }, /* XSUM_XXH64_testdata[2216] */
    { 1108, 0x000000009E3779B1ULL, 0xB19EBDCE7BB2ADDDULL }, /* XSUM_XXH64_testdata[2217] */
    { 1109, 0x0000000000000000ULL, 0x0D0889E52A5C010CULL }, /* XSUM_XXH64_testdata[2218] */
    { 1109, 0x000000009E3779B1ULL, 0xAF1004C57A6F9DE0ULL }, /* XSUM_XXH64_testdata[2219] */
    { 1110, 0x0000000000000000ULL, 0x3B9DC9C1F4E9DE7AULL }, /* XSUM_XXH64_testdata[2220] */
    { 1110, 0x000000009E3779B1ULL, 0x527752B49538B0F2ULL }, /* XSUM_XXH64_testdata[2221] */
    { 1111, 0x0000000000000000ULL, 0xF859004CA4B1561AULL }, /* XSUM_XXH64_testdata[2222] */
    { 1111, 0x000000009E3779B1ULL, 0x6AB43BEFD21472E2ULL }, /* XSUM_XXH64_testdata[2223] */
    { 1112, 0x0000000000000000ULL, 0x4752619FE11B12C1ULL }, /* XSUM_XXH64_testdata[2224] */
    { 1112, 0x000000009E3779B1ULL, 0x579C10B3F6468855ULL }, /* XSUM_XXH64_testdata[2225] */
    { 1113, 0x0000000000000000ULL, 0xF445865A468E2559ULL }, /* XSUM_XXH64_testdata[2226] */
    { 1113, 0x000000009E3779B1ULL, 0x879B0858BF9F8B12ULL }, /* XSUM_XXH64_testdata[2227] */
    { 1114, 0x0000000000000000ULL, 0x188FC1F04125E582ULL }, /* XSUM_XXH64_testdata[2228] */
    { 1114, 0x000000009E3779B1ULL, 0x4B3B438A7FE86BDBULL }, /* XSUM_XXH64_testdata[2229] */
    { 1115, 0x0000000000000000ULL, 0x2757DE9950DB7B34ULL }, /* XSUM_XXH64_testdata[2230] */
    { 1115, 0x000000009E3779B1ULL, 0xE0277B35CFDF8FC9ULL }, /* XSUM_XXH64_testdata[2231] */
    { 1116, 0x0000000000000000ULL, 0x2432631A9914E56DULL }, /* XSUM_XXH64_testdata[2232] */
    { 1116, 0x000000009E3779B1ULL, 0xE1ECA45CBFC450D1ULL }, /* XSUM_XXH64_testdata[2233] */
    { 1117, 0x0000000000000000ULL, 0x784986E0B24A7B76ULL }, /* XSUM_XXH64_testdata[2234] */
    { 1117, 0x000000009E3779B1ULL, 0xF79A46B492BD36F5ULL }, /* XSUM_XXH64_testdata[2235] */
    { 1118, 0x0000000000000000ULL, 0x334AF852416C3E51ULL }, /* XSUM_XXH64_testdata[2236] */
    { 1118, 0x000000009E3779B1ULL, 0x4377DC81D3C0709EULL }, /* XSUM_XXH64_testdata[2237] */
    { 1119, 0x0000000000000000ULL, 0xB92AD21BC4B87A72ULL }, /* XSUM_XXH64_testdata[2238] */
    { 1119, 0x000000009E3779B1ULL, 0x65E4A386510740ACULL }, /* XSUM_XXH64_testdata[2239] */
    { 1120, 0x0000000000000000ULL, 0x95617FD81C67DCC5ULL }, /* XSUM_XXH64_testdata[2240] */
    { 1120, 0x000000009E3779B1ULL, 0x22B02A44A9800701ULL }, /* XSUM_XXH64_testdata[2241] */
    { 1121, 0x0000000000000000ULL, 0xA811DFF2AD0B59FCULL }, /* XSUM_XXH64_testdata[2242] */
    { 1121, 0x000000009E3779B1ULL, 0x8CE4D290DAD5AC1AULL }, /* XSUM_XXH64_testdata[2243] */
    { 1122, 0x0000000000000000ULL, 0x1F3E5BD6C132B6E7ULL }, /* XSUM_XXH64_testdata[2244] */
    { 1122, 0x000000009E3779B1ULL, 0x7B6B1A0DCA9A79FEULL }, /* XSUM_XXH64_testdata[2245] */
    { 1123, 0x0000000000000000ULL, 0xBABFE4C7669A7A10ULL }, /* XSUM_XXH64_testdata[2246] */
    { 1123, 0x000000009E3779B1ULL, 0x1700A80B4222D0D9ULL }, /* XSUM_XXH64_testdata[2247] */
    { 1124, 0x0000000000000000ULL, 0x600135D9B1CD6D10ULL }, /* XSUM_XXH64_testdata[2248] */
    { 1124, 0x000000009E3779B1ULL, 0x3703C7E34E5C0F81ULL }, /* XSUM_XXH64_testdata[2249] */
    { 1125, 0x0000000000000000ULL, 0x272EFE5F1BE54486ULL }, /* XSUM_XXH64_testdata[2250] */
    { 1125, 0x000000009E3779B1ULL, 0x9B10466FEE9AA53CULL }, /* XSUM_XXH64_testdata[2251] */
    { 1126, 0x0000000000000000ULL, 0x6E68BC9459FDF676ULL }, /* XSUM_XXH64_testdata[2252] */
    { 1126, 0x000000009E3779B1ULL, 0x7F012D428795FECFULL }, /* XSUM_XXH64_testdata[2253] */
    { 1127, 0x0000000000000000ULL, 0x36354AAF87F918B0ULL }, /* XSUM_XXH64_testdata[2254] */
    { 1127, 0x000000009E3779B1ULL, 0x39CDE43E8781C078ULL }, /* XSUM_XXH64_testdata[2255] */
    { 1128, 0x0000000000000000ULL, 0x400E307D555C9833ULL }, /* XSUM_XXH64_testdata[2256] */
    { 1128, 0x000000009E3779B1ULL, 0x583DBE10736315E8ULL }, /* XSUM_XXH64_testdata[2257] */
    { 1129, 0x0000000000000000ULL, 0x05EA9E6AC9B27A81ULL }, /* XSUM_XXH64_testdata[2258] */
    { 1129, 0x000000009E3779B1ULL, 0x6A692E0C09AEF41CULL }, /* XSUM_XXH64_testdata[2259] */
    { 1130, 0x0000000000000000ULL, 0xDC58A6438477CAACULL }, /* XSUM_XXH64_testdata[2260] */
    { 1130, 0x000000009E3779B1ULL, 0x8388F7B4F0802E67ULL }, /* XSUM_XXH64_testdata[2261] */
    { 1131, 0x0000000000000000ULL, 0xC574095AA26C05A0ULL }, /* XSUM_XXH64_testdata[2262] */
    { 1131, 0x000000009E3779B1ULL, 0xDC2383D39CFBF56DULL }, /* XSUM_XXH64_testdata[2263] */
    { 1132, 0x0000000000000000ULL, 0x94064E01CD2A6FE0ULL }, /* XSUM_XXH64_testdata[2264] */
    { 1132, 0x000000009E3779B1ULL, 0x6A9067CE69D02464ULL }, /* XSUM_XXH64_testdata[2265] */
    { 1133, 0x0000000000000000ULL, 0x884EF021B54F562AULL }, /* XSUM_XXH64_testdata[2266] */
    { 1133, 0x000000009E3779B1ULL, 0xE5DC362A735474C2ULL }, /* XSUM_XXH64_testdata[2267] */
    { 1134, 0x0000000000000000ULL, 0x591662DDD26BFC25ULL }, /* XSUM_XXH64_testdata[2268] */
    { 1134, 0x000000009E3779B1ULL, 0x3054E14A201DD8AFULL }, /* XSUM_XXH64_testdata[2269] */
    { 1135, 0x0000000000000000ULL, 0xE1A61BA71F2A3D5CULL }, /* XSUM_XXH64_testdata[2270] */
    { 1135, 0x000000009E3779B1ULL, 0xCC8FD2796D352F91ULL }, /* XSUM_XXH64_testdata[2271] */
    { 1136, 0x0000000000000000ULL, 0x57251DDEA62C943BULL }, /* XSUM_XXH64_testdata[2272] */
    { 1136, 0x000000009E3779B1ULL, 0xA3C18F7908E93DCAULL }, /* XSUM_XXH64_testdata[2273] */
    { 1137, 0x0000000000000000ULL, 0xE616EE8FCC325DD9ULL }, /* XSUM_XXH64_testdata[2274] */
    { 1137, 0x000000009E3779B1ULL, 0x14B5984BA4854C63ULL }, /* XSUM_XXH64_testdata[2275] */
    { 1138, 0x0000000000000000ULL, 0x0D39F4FC469C0357ULL }, /* XSUM_XXH64_testdata[2276] */
    { 1138, 0x000000009E3779B1ULL, 0x5E931C3934A4E81CULL }, /* XSUM_XXH64_testdata[2277] */
    { 1139, 0x0000000000000000ULL, 0x15CF3D6F0E7255E7ULL }, /* XSUM_XXH64_testdata[2278] */
    { 1139, 0x000000009E3779B1ULL, 0xBF60E1ADBF19203AULL }, /* XSUM_XXH64_testdata[2279] */
    { 1140, 0x0000000000000000ULL, 0xA64D34B6C8F3EFC1ULL }, /* XSUM_XXH64_testdata[2280] */
    { 1140, 0x000000009E3779B1ULL, 0x6C47E635AE407E84ULL }, /* XSUM_XXH64_testdata[2281] */
    { 1141, 0x0000000000000000ULL, 0xACF821860B451FCEULL }, /* XSUM_XXH64_testdata[2282] */
    { 1141, 0x000000009E3779B1ULL, 0x71F4165B85DAA4F4ULL }, /* XSUM_XXH64_testdata[2283] */
    { 1142, 0x0000000000000000ULL, 0x99BDECD90D1C556FULL }, /* XSUM_XXH64_testdata[2284] */
    { 1142, 0x000000009E3779B1ULL, 0x336571C12EC4D692ULL }, /* XSUM_XXH64_testdata[2285] */
    { 1143, 0x0000000000000000ULL, 0x259E2BDD0BE78EAFULL }, /* XSUM_XXH64_testdata[2286] */
    { 1143, 0x000000009E3779B1ULL, 0x188F8DA02C1FC2ECULL }, /* XSUM_XXH64_testdata[2287] */
    { 1144, 0x0000000000000000ULL, 0x1EE5F1941FC489BEULL }, /* XSUM_XXH64_testdata[2288] */
    { 1144, 0x000000009E3779B1ULL, 0xFD2302544F9E3F28ULL }, /* XSUM_XXH64_testdata[2289] */
    { 1145, 0x0000000000000000ULL, 0xC1DCDCBB7AEFF4A0ULL }, /* XSUM_XXH64_testdata[2290] */
    { 1145, 0x000000009E3779B1ULL, 0x7825C283C62D149BULL }, /* XSUM_XXH64_testdata[2291] */
    { 1146, 0x0000000000000000ULL, 0xFE00C6F8B53471A4ULL }, /* XSUM_XXH64_testdata[2292] */
    { 1146, 0x000000009E3779B1ULL, 0x1A4AA51ABFFCF0D9ULL }, /* XSUM_XXH64_testdata[2293] */
    { 1147, 0x0000000000000000ULL, 0x2A168E528A7AF3B2ULL }, /* XSUM_XXH64_testdata[2294] */
    { 1147, 0x000000009E3779B1ULL, 0x087D47D143B332A7ULL }, /* XSUM_XXH64_testdata[2295] */
    { 1148, 0x0000000000000000ULL, 0x015FCA9C7C890189ULL }, /* XSUM_XXH64_testdata[2296] */
    { 1148, 0x000000009E3779B1ULL, 0x9C4815A4F92DA120ULL }, /* XSUM_XXH64_testdata[2297] */
    { 1149, 0x0000000000000000ULL, 0x7B0353BD972DC808ULL }, /* XSUM_XXH64_testdata[2298] */
    { 1149, 0x000000009E3779B1ULL, 0xB5BBC5E9063D325EULL }, /* XSUM_XXH64_testdata[2299] */
    { 1150, 0x0000000000000000ULL, 0x1DD0D8B978883013ULL }, /* XSUM_XXH64_testdata[2300] */
    { 1150, 0x000000009E3779B1ULL, 0x9A3DD1A5571A33F6ULL }, /* XSUM_XXH64_testdata[2301] */
    { 1151, 0x0000000000000000ULL, 0xB41A8F0808C8F74FULL }, /* XSUM_XXH64_testdata[2302] */
    { 1151, 0x000000009E3779B1ULL, 0x7F89F5FC585C35F2ULL }, /* XSUM_XXH64_testdata[2303] */
    { 1152, 0x0000000000000000ULL, 0x19299073B367095BULL }, /* XSUM_XXH64_testdata[2304] */
    { 1152, 0x000000009E3779B1ULL, 0xC9B3C9DFDD08DFDAULL }, /* XSUM_XXH64_testdata[2305] */
    { 1153, 0x0000000000000000ULL, 0x5932E340EC7286BFULL }, /* XSUM_XXH64_testdata[2306] */
    { 1153, 0x000000009E3779B1ULL, 0x851B8D860BC35C79ULL }, /* XSUM_XXH64_testdata[2307] */
    { 1154, 0x0000000000000000ULL, 0x06F2A17411E8A3EBULL }, /* XSUM_XXH64_testdata[2308] */
    { 1154, 0x000000009E3779B1ULL, 0x9932BDD1CDE62B64ULL }, /* XSUM_XXH64_testdata[2309] */
    { 1155, 0x0000000000000000ULL, 0x88D143F288A22EDFULL }, /* XSUM_XXH64_testdata[2310] */
    { 1155, 0x000000009E3779B1ULL, 0x03231A1762E1AABEULL }, /* XSUM_XXH64_testdata[2311] */
    { 1156, 0x0000000000000000ULL, 0x5D85DEC090DF9397ULL }, /* XSUM_XXH64_testdata[2312] */
    { 1156, 0x000000009E3779B1ULL, 0x178C30FF5FC153DDULL }, /* XSUM_XXH64_testdata[2313] */
    { 1157, 0x0000000000000000ULL, 0x05FFA1FA6F91696EULL }, /* XSUM_XXH64_testdata[2314] */
    { 1157, 0x000000009E3779B1ULL, 0x5CB67BAA9C962418ULL }, /* XSUM_XXH64_testdata[2315] */
    { 1158, 0x0000000000000000ULL, 0xC80FB4BFAB1B9084ULL }, /* XSUM_XXH64_testdata[2316] */
    { 1158, 0x000000009E3779B1ULL, 0x412066FE4F363F24ULL }, /* XSUM_XXH64_testdata[2317] */
    { 1159, 0x0000000000000000ULL, 0xEF36F48EE689911EULL }, /* XSUM_XXH64_testdata[2318] */
    { 1159, 0x000000009E3779B1ULL, 0x4839BA4B8E17E0C8ULL }, /* XSUM_XXH64_testdata[2319] */
    { 1160, 0x0000000000000000ULL, 0x6D61FCBAA6DB87A4ULL }, /* XSUM_XXH64_testdata[2320] */
    { 1160, 0x000000009E3779B1ULL, 0x16A4E424A4FA0453ULL }, /* XSUM_XXH64_testdata[2321] */
    { 1161, 0x0000000000000000ULL, 0xBED318F98DB4C4E8ULL }, /* XSUM_XXH64_testdata[2322] */
    { 1161, 0x000000009E3779B1ULL, 0x23668F33B18A4BEBULL }, /* XSUM_XXH64_testdata[2323] */
    { 1162, 0x0000000000000000ULL, 0xFD31ACBCFBC6AD11ULL }, /* XSUM_XXH64_testdata[2324] */
    { 1162, 0x000000009E3779B1ULL, 0x050D8302FEAFB128ULL }, /* XSUM_XXH64_testdata[2325] */
    { 1163, 0x0000000000000000ULL, 0xCA568513811EF5BBULL }, /* XSUM_XXH64_testdata[2326] */
    { 1163, 0x000000009E3779B1ULL, 0x265BE8CF72F7AC15ULL }, /* XSUM_XXH64_testdata[2327] */
    { 1164, 0x0000000000000000ULL, 0x27F4365CEB48E09DULL }, /* XSUM_XXH64_testdata[2328] */
    { 1164, 0x000000009E3779B1ULL, 0x6EA0E954F8CC9F28ULL }, /* XSUM_XXH64_testdata[2329] */
    { 1165, 0x0000000000000000ULL, 0xC4BAA96C8811F3A8ULL }, /* XSUM_XXH64_testdata[2330] */
    { 1165, 0x000000009E3779B1ULL, 0x6E1CDCC80574DA15ULL }, /* XSUM_XXH64_testdata[2331] */
    { 1166, 0x0000000000000000ULL, 0xD929F2B0CBC2D114ULL }, /* XSUM_XXH64_testdata[2332] */
    { 1166, 0x000000009E3779B1ULL, 0x8BB7D3CC05EC477AULL }, /* XSUM_XXH64_testdata[2333] */
    { 1167, 0x0000000000000000ULL, 0x07CDEC2DC1D4F277ULL }, /* XSUM_XXH64_testdata[2334] */
    { 1167, 0x000000009E3779B1ULL, 0x224D339D5431A954ULL }, /* XSUM_XXH64_testdata[2335] */
    { 1168, 0x0000000000000000ULL, 0x61F0F00477994DA9ULL }, /* XSUM_XXH64_testdata[2336] */
    { 1168, 0x000000009E3779B1ULL, 0x17A041B59D2A3095ULL }, /* XSUM_XXH64_testdata[2337] */
    { 1169, 0x0000000000000000ULL, 0x11D00BAC17A2CCBCULL }, /* XSUM_XXH64_testdata[2338] */
    { 1169, 0x000000009E3779B1ULL, 0xD3D1406E4C63388DULL }, /* XSUM_XXH64_testdata[2339] */
    { 1170, 0x0000000000000000ULL, 0xF32C0F3CBE07DB46ULL }, /* XSUM_XXH64_testdata[2340] */
    { 1170, 0x000000009E3779B1ULL, 0x784B0288B54047F3ULL }, /* XSUM_XXH64_testdata[2341] */
    { 1171, 0x0000000000000000ULL, 0x83B6BF8C214040C4ULL }, /* XSUM_XXH64_testdata[2342] */
    { 1171, 0x000000009E3779B1ULL, 0x33D255BCE663322AULL }, /* XSUM_XXH64_testdata[2343] */
    { 1172, 0x0000000000000000ULL, 0xD0488365B79E9B3EULL }, /* XSUM_XXH64_testdata[2344] */
    { 1172, 0x000000009E3779B1ULL, 0xDC1741BBC24625C0ULL }, /* XSUM_XXH64_testdata[2345] */
    { 1173, 0x0000000000000000ULL, 0xF6EB55C349B2D4E9ULL }, /* XSUM_XXH64_testdata[2346] */
    { 1173, 0x000000009E3779B1ULL, 0x9D98A4C8A46FBD91ULL }, /* XSUM_XXH64_testdata[2347] */
    { 1174, 0x0000000000000000ULL, 0x3797AFA18CA75B65ULL }, /* XSUM_XXH64_testdata[2348] */
    { 1174, 0x000000009E3779B1ULL, 0xE2A7BA7D2E0507F1ULL }, /* XSUM_XXH64_testdata[2349] */
    { 1175, 0x0000000000000000ULL, 0x60019E1F20F136ABULL }, /* XSUM_XXH64_testdata[2350] */
    { 1175, 0x000000009E3779B1ULL, 0x8A49874B1CF28677ULL }, /* XSUM_XXH64_testdata[2351] */
    { 1176, 0x0000000000000000ULL, 0x16733C73052055DCULL }, /* XSUM_XXH64_testdata[2352] */
    { 1176, 0x000000009E3779B1ULL, 0xDA424093EE2A4003ULL }, /* XSUM_XXH64_testdata[2353] */
    { 1177, 0x0000000000000000ULL, 0xAA5A32E8F609A8BEULL }, /* XSUM_XXH64_testdata[2354] */
    { 1177, 0x000000009E3779B1ULL, 0xBFD91A5EB0FE6C8CULL }, /* XSUM_XXH64_testdata[2355] */
    { 1178, 0x0000000000000000ULL, 0x6B83C2851782FF4AULL }, /* XSUM_XXH64_testdata[2356] */
    { 1178, 0x000000009E3779B1ULL, 0x49342F0F95C2EEE4ULL }, /* XSUM_XXH64_testdata[2357] */
    { 1179, 0x0000000000000000ULL, 0x954B1ADBA2381E5FULL }, /* XSUM_XXH64_testdata[2358] */
    { 1179, 0x000000009E3779B1ULL, 0xA20D6149D5427C1AULL }, /* XSUM_XXH64_testdata[2359] */
    { 1180, 0x0000000000000000ULL, 0x603B9A19DCFF5CB2ULL }, /* XSUM_XXH64_testdata[2360] */
    { 1180, 0x000000009E3779B1ULL, 0xB841AC8384BB8411ULL }, /* XSUM_XXH64_testdata[2361] */
    { 1181, 0x0000000000000000ULL, 0x51691426D289A80FULL }, /* XSUM_XXH64_testdata[2362] */
    { 1181, 0x000000009E3779B1ULL, 0x7F8A490E89A3BF94ULL }, /* XSUM_XXH64_testdata[2363] */
    { 1182, 0x0000000000000000ULL, 0xFEBFD0B41A829058ULL }, /* XSUM_XXH64_testdata[2364] */
    { 1182, 0x000000009E3779B1ULL, 0x14B98F8A153E1C30ULL }, /* XSUM_XXH64_testdata[2365] */
    { 1183, 0x0000000000000000ULL, 0x25AF016AE33CBD1AULL }, /* XSUM_XXH64_testdata[2366] */
    { 1183, 0x000000009E3779B1ULL, 0xC75FCDB74B967884ULL }, /* XSUM_XXH64_testdata[2367] */
    { 1184, 0x0000000000000000ULL, 0x8CBA134148EC71F9ULL }, /* XSUM_XXH64_testdata[2368] */
    { 1184, 0x000000009E3779B1ULL, 0x5DB47CCDF0979822ULL }, /* XSUM_XXH64_testdata[2369] */
    { 1185, 0x0000000000000000ULL, 0x9E8F0A368CB1C464ULL }, /* XSUM_XXH64_testdata[2370] */
    { 1185, 0x000000009E3779B1ULL, 0x419591366CD6E563ULL }, /* XSUM_XXH64_testdata[2371] */
    { 1186, 0x0000000000000000ULL, 0xB474F625CC1A199AULL }, /* XSUM_XXH64_testdata[2372] */
    { 1186, 0x000000009E3779B1ULL, 0x89146F83CE0A3E62ULL }, /* XSUM_XXH64_testdata[2373] */
    { 1187, 0x0000000000000000ULL, 0x16D86EAE8BDE1ADFULL }, /* XSUM_XXH64_testdata[2374] */
    { 1187, 0x000000009E3779B1ULL, 0xDC1A57B254C5CA1AULL }, /* XSUM_XXH64_testdata[2375] */
    { 1188, 0x0000000000000000ULL, 0x7EFE00D599C5D016ULL }, /* XSUM_XXH64_testdata[2376] */
    { 1188, 0x000000009E3779B1ULL, 0x8A21FBD75CA322F6ULL }, /* XSUM_XXH64_testdata[2377] */
    { 1189, 0x0000000000000000ULL, 0x67FAF88309EDF12BULL }, /* XSUM_XXH64_testdata[2378] */
    { 1189, 0x000000009E3779B1ULL, 0xAEBE493AFE2A6936ULL }, /* XSUM_XXH64_testdata[2379] */
    { 1190, 0x0000000000000000ULL, 0x29B4A61FEEE3442DULL }, /* XSUM_XXH64_testdata[2380] */
    { 1190, 0x000000009E3779B1ULL, 0xACC85878200FE439ULL }, /* XSUM_XXH64_testdata[2381] */
    { 1191, 0x0000000000000000ULL, 0x9D502E7F7FA7C40FULL }, /* XSUM_XXH64_testdata[2382] */
    { 1191, 0x000000009E3779B1ULL, 0x640172B0CA181D3BULL }, /* XSUM_XXH64_testdata[2383] */
    { 1192, 0x0000000000000000ULL, 0xF910BB146476145AULL }, /* XSUM_XXH64_testdata[2384] */
    { 1192, 0x000000009E3779B1ULL, 0xA7D3E542B5D7FBD5ULL }, /* XSUM_XXH64_testdata[2385] */
    { 1193, 0x0000000000000000ULL, 0xEE6EDC237138173AULL }, /* XSUM_XXH64_testdata[2386] */
    { 1193, 0x000000009E3779B1ULL, 0xD43F10425C748F89ULL }, /* XSUM_XXH64_testdata[2387] */
    { 1194, 0x0000000000000000ULL, 0xE24B4A7F0E76E783ULL }, /* XSUM_XXH64_testdata[2388] */
    { 1194, 0x000000009E3779B1ULL, 0x2320E33A5302A4D5ULL }, /* XSUM_XXH64_testdata[2389] */
    { 1195, 0x0000000000000000ULL, 0x7978C40AEFC877D0ULL }, /* XSUM_XXH64_testdata[2390] */
    { 1195, 0x000000009E3779B1ULL, 0x8D73ABDFA5720846ULL }, /* XSUM_XXH64_testdata[2391] */
    { 1196, 0x0000000000000000ULL, 0xE691FED11EDFF221ULL }, /* XSUM_XXH64_testdata[2392] */
    { 1196, 0x000000009E3779B1ULL, 0x8EAB2E32B082FC73ULL }, /* XSUM_XXH64_testdata[2393] */
    { 1197, 0x0000000000000000ULL, 0x3E9542A45384F0F6ULL }, /* XSUM_XXH64_testdata[2394] */
    { 1197, 0x000000009E3779B1ULL, 0x4A2E556C5707C4F5ULL }, /* XSUM_XXH64_testdata[2395] */
    { 1198, 0x0000000000000000ULL, 0xF802820EB3AD6070ULL }, /* XSUM_XXH64_testdata[2396] */
    { 1198, 0x000000009E3779B1ULL, 0x5718062EBB4800CDULL }, /* XSUM_XXH64_testdata[2397] */
    { 1199, 0x0000000000000000ULL, 0x9D2D4751EF93B51CULL }, /* XSUM_XXH64_testdata[2398] */
    { 1199, 0x000000009E3779B1ULL, 0x3CC9E217D7BD6672ULL }, /* XSUM_XXH64_testdata[2399] */
    { 1200, 0x0000000000000000ULL, 0x73CDFEC0002BC5E1ULL }, /* XSUM_XXH64_testdata[2400] */
    { 1200, 0x000000009E3779B1ULL, 0x155B5DE4EE0A0D69ULL }, /* XSUM_XXH64_testdata[2401] */
    { 1201, 0x0000000000000000ULL, 0xC9517C4AAA35A42AULL }, /* XSUM_XXH64_testdata[2402] */
    { 1201, 0x000000009E3779B1ULL, 0xE76B0F144E7074CAULL }, /* XSUM_XXH64_testdata[2403] */
    { 1202, 0x0000000000000000ULL, 0x0E5C02541611F938ULL }, /* XSUM_XXH64_testdata[2404] */
    { 1202, 0x000000009E3779B1ULL, 0x06640F4567E510C8ULL }, /* XSUM_XXH64_testdata[2405] */
    { 1203, 0x0000000000000000ULL, 0x526346FC056B4ECCULL }, /* XSUM_XXH64_testdata[2406] */
    { 1203, 0x000000009E3779B1ULL, 0x62166B520E3472B9ULL }, /* XSUM_XXH64_testdata[2407] */
    { 1204, 0x0000000000000000ULL, 0xF05E21326F4C017AULL }, /* XSUM_XXH64_testdata[2408] */
    { 1204, 0x000000009E3779B1ULL, 0xA2A6CE0C2C6ED983ULL }, /* XSUM_XXH64_testdata[2409] */
    { 1205, 0x0000000000000000ULL, 0xC46EEBBC8B7C1603ULL }, /* XSUM_XXH64_testdata[2410] */
    { 1205, 0x000000009E3779B1ULL, 0xBAE8603180B08E2BULL }, /* XSUM_XXH64_testdata[2411] */
    { 1206, 0x0000000000000000ULL, 0x51A55AAC52816910ULL }, /* XSUM_XXH64_testdata[2412] */
    { 1206, 0x000000009E3779B1ULL, 0x2387042F1109188DULL }, /* XSUM_XXH64_testdata[2413] */
    { 1207, 0x0000000000000000ULL, 0x26198421168E2E66ULL }, /* XSUM_XXH64_testdata[2414] */
    { 1207, 0x000000009E3779B1ULL, 0x23A27911E90F259AULL }, /* XSUM_XXH64_testdata[2415] */
    { 1208, 0x0000000000000000ULL, 0x9A99D5A5C9343767ULL }, /* XSUM_XXH64_testdata[2416] */
    { 1208, 0x000000009E3779B1ULL, 0xFB830D9101644EECULL }, /* XSUM_XXH64_testdata[2417] */
    { 1209, 0x0000000000000000ULL, 0xA2E2D8A60B7FF51FULL }, /* XSUM_XXH64_testdata[2418] */
    { 1209, 0x000000009E3779B1ULL, 0xCFBED9FCC3B850C9ULL }, /* XSUM_XXH64_testdata[2419] */
    { 1210, 0x0000000000000000ULL, 0xF1ADA080F3C3C553ULL }, /* XSUM_XXH64_testdata[2420] */
    { 1210, 0x000000009E3779B1ULL, 0xF0834836F99E1490ULL }, /* XSUM_XXH64_testdata[2421] */
    { 1211, 0x0000000000000000ULL, 0x7CDBE0F7EA5B896EULL }, /* XSUM_XXH64_testdata[2422] */
    { 1211, 0x000000009E3779B1ULL, 0x70D4AE6F9E51886BULL }, /* XSUM_XXH64_testdata[2423] */
    { 1212, 0x0000000000000000ULL, 0xCE770894F4D5D15DULL }, /* XSUM_XXH64_testdata[2424] */
    { 1212, 0x000000009E3779B1ULL, 0x755452B89ED9F2D1ULL }, /* XSUM_XXH64_testdata[2425] */
    { 1213, 0x0000000000000000ULL, 0xBB83E0EFFA7DFA54ULL }, /* XSUM_XXH64_testdata[2426] */
    { 1213, 0x000000009E3779B1ULL, 0x58FB723E54294F76ULL }, /* XSUM_XXH64_testdata[2427] */
    { 1214, 0x0000000000000000ULL, 0x54C03BCFC0E5458BULL }, /* XSUM_XXH64_testdata[2428] */
    { 1214, 0x000000009E3779B1ULL, 0xEAB3B6A957D1DF6FULL }, /* XSUM_XXH64_testdata[2429] */
    { 1215, 0x0000000000000000ULL, 0xB5E8FDA67A9FA240ULL }, /* XSUM_XXH64_testdata[2430] */
    { 1215, 0x000000009E3779B1ULL, 0x56E89D36D1AB6C1DULL }, /* XSUM_XXH64_testdata[2431] */
    { 1216, 0x0000000000000000ULL, 0xDE77182C65201337ULL }, /* XSUM_XXH64_testdata[2432] */
    { 1216, 0x000000009E3779B1ULL, 0x28975264E8B4E338ULL }, /* XSUM_XXH64_testdata[2433] */
    { 1217, 0x0000000000000000ULL, 0x9BEE0EB2647A7EEBULL }, /* XSUM_XXH64_testdata[2434] */
    { 1217, 0x000000009E3779B1ULL, 0x2E8CBA0CDC387C20ULL }, /* XSUM_XXH64_testdata[2435] */
    { 1218, 0x0000000000000000ULL, 0xB62D99439AFDAEDBULL }, /* XSUM_XXH64_testdata[2436] */
    { 1218, 0x000000009E3779B1ULL, 0xA4DB5D64DDD956BBULL }, /* XSUM_XXH64_testdata[2437] */
    { 1219, 0x0000000000000000ULL, 0xE8D11AC02B8EAB7BULL }, /* XSUM_XXH64_testdata[2438] */
    { 1219, 0x000000009E3779B1ULL, 0x2DBE469FA220C472ULL }, /* XSUM_XXH64_testdata[2439] */
    { 1220, 0x0000000000000000ULL, 0xCBAD51EEDD66816DULL }, /* XSUM_XXH64_testdata[2440] */
    { 1220, 0x000000009E3779B1ULL, 0xBA02659904B857E0ULL }, /* XSUM_XXH64_testdata[2441] */
    { 1221, 0x0000000000000000ULL, 0x93EA7CF6DCB8AD89ULL }, /* XSUM_XXH64_testdata[2442] */
    { 1221, 0x000000009E3779B1ULL, 0xED8BA7BA701C9FFEULL }, /* XSUM_XXH64_testdata[2443] */
    { 1222, 0x0000000000000000ULL, 0x3E659462BCDB4687ULL }, /* XSUM_XXH64_testdata[2444] */
    { 1222, 0x000000009E3779B1ULL, 0xF6E9E66FE5D72528ULL }, /* XSUM_XXH64_testdata[2445] */
    { 1223, 0x0000000000000000ULL, 0xC50CB9759B1EF03DULL }, /* XSUM_XXH64_testdata[2446] */
    { 1223, 0x000000009E3779B1ULL, 0x0D5298DFA1E249D0ULL }, /* XSUM_XXH64_testdata[2447] */
    { 1224, 0x0000000000000000ULL, 0xEC928828A817C2A7ULL }, /* XSUM_XXH64_testdata[2448] */
    { 1224, 0x000000009E3779B1ULL, 0xFAF833E82E2D9640ULL }, /* XSUM_XXH64_testdata[2449] */
    { 1225, 0x0000000000000000ULL, 0x76B7DC3535DA6818ULL }, /* XSUM_XXH64_testdata[2450] */
    { 1225, 0x000000009E3779B1ULL, 0x065AFF3ACD0996B8ULL }, /* XSUM_XXH64_testdata[2451] */
    { 1226, 0x0000000000000000ULL, 0x06383BC6E3D960A7ULL }, /* XSUM_XXH64_testdata[2452] */
    { 1226, 0x000000009E3779B1ULL, 0xCBE4D0EE4ABA90F7ULL }, /* XSUM_XXH64_testdata[2453] */
    { 1227, 0x0000000000000000ULL, 0xC68FF1A111675934ULL }, /* XSUM_XXH64_testdata[2454] */
    { 1227, 0x000000009E3779B1ULL, 0xC31BAFCB29D08595ULL }, /* XSUM_XXH64_testdata[2455] */
    { 1228, 0x0000000000000000ULL, 0x2C26E822520C7733ULL }, /* XSUM_XXH64_testdata[2456] */
    { 1228, 0x000000009E3779B1ULL, 0x2D125AC8523AAB2CULL }, /* XSUM_XXH64_testdata[2457] */
    { 1229, 0x0000000000000000ULL, 0xC00294B5D505B24FULL }, /* XSUM_XXH64_testdata[2458] */
    { 1229, 0x000000009E3779B1ULL, 0x7540334EDC7C1BF0ULL }, /* XSUM_XXH64_testdata[2459] */
    { 1230, 0x0000000000000000ULL, 0x10E88D954C31D7F0ULL }, /* XSUM_XXH64_testdata[2460] */
    { 1230, 0x000000009E3779B1ULL, 0x2F6F2890F1D3C877ULL }, /* XSUM_XXH64_testdata[2461] */
    { 1231, 0x0000000000000000ULL, 0xCA6D15CAFAEA0146ULL }, /* XSUM_XXH64_testdata[2462] */
    { 1231, 0x000000009E3779B1ULL, 0xA3D94C473B19D016ULL }, /* XSUM_XXH64_testdata[2463] */
    { 1232, 0x0000000000000000ULL, 0x640B2E1F424F09FAULL }, /* XSUM_XXH64_testdata[2464] */
    { 1232, 0x000000009E3779B1ULL, 0x1DCCFB4B6FE20C99ULL }, /* XSUM_XXH64_testdata[2465] */
    { 1233, 0x0000000000000000ULL, 0xB4790504226D3011ULL }, /* XSUM_XXH64_testdata[2466] */
    { 1233, 0x000000009E3779B1ULL, 0xFF1DD978AD406AC1ULL }, /* XSUM_XXH64_testdata[2467] */
    { 1234, 0x0000000000000000ULL, 0x3A4525188BB049C2ULL }, /* XSUM_XXH64_testdata[2468] */
    { 1234, 0x000000009E3779B1ULL, 0x12E61CAA320BD366ULL }, /* XSUM_XXH64_testdata[2469] */
    { 1235, 0x0000000000000000ULL, 0x993465458AA35087ULL }, /* XSUM_XXH64_testdata[2470] */
    { 1235, 0x000000009E3779B1ULL, 0x178B9FFD8135E6FEULL }, /* XSUM_XXH64_testdata[2471] */
    { 1236, 0x0000000000000000ULL, 0xCD6BBCA73EA4BE8BULL }, /* XSUM_XXH64_testdata[2472] */
    { 1236, 0x000000009E3779B1ULL, 0xEE2B003F9D074AE6ULL }, /* XSUM_XXH64_testdata[2473] */
    { 1237, 0x0000000000000000ULL, 0x90A512E03AFCD3E9ULL }, /* XSUM_XXH64_testdata[2474] */
    { 1237, 0x000000009E3779B1ULL, 0x7C04E47203E1752EULL }, /* XSUM_XXH64_testdata[2475] */
    { 1238, 0x0000000000000000ULL, 0x9F8C688C51ADDEB9ULL }, /* XSUM_XXH64_testdata[2476] */
    { 1238, 0x000000009E3779B1ULL, 0x60C6FEF44E7BF23FULL }, /* XSUM_XXH64_testdata[2477] */
    { 1239, 0x0000000000000000ULL, 0xD6D6BC345847890EULL }, /* XSUM_XXH64_testdata[2478] */
    { 1239, 0x000000009E3779B1ULL, 0x21AB7B16F663A955ULL }, /* XSUM_XXH64_testdata[2479] */
    { 1240, 0x0000000000000000ULL, 0x12A0469391C4DA89ULL }, /* XSUM_XXH64_testdata[2480] */
    { 1240, 0x000000009E3779B1ULL, 0xBA448958A73046ACULL }, /* XSUM_XXH64_testdata[2481] */
    { 1241, 0x0000000000000000ULL, 0xB5A18E47A7361A03ULL }, /* XSUM_XXH64_testdata[2482] */
    { 1241, 0x000000009E3779B1ULL, 0xFF8A6D2D8C8066FFULL }, /* XSUM_XXH64_testdata[2483] */
    { 1242, 0x0000000000000000ULL, 0x1BB832B76D7ED273ULL }, /* XSUM_XXH64_testdata[2484] */
    { 1242, 0x000000009E3779B1ULL, 0xCE8B78067B96E1DAULL }, /* XSUM_XXH64_testdata[2485] */
    { 1243, 0x0000000000000000ULL, 0x5D5C95147DF7BAB7ULL }, /* XSUM_XXH64_testdata[2486] */
    { 1243, 0x000000009E3779B1ULL, 0x9CC5328E65DFC6BCULL }, /* XSUM_XXH64_testdata[2487] */
    { 1244, 0x0000000000000000ULL, 0xBA1913F9F322F428ULL }, /* XSUM_XXH64_testdata[2488] */
    { 1244, 0x000000009E3779B1ULL, 0x59347B04EEAC3308ULL }, /* XSUM_XXH64_testdata[2489] */
    { 1245, 0x0000000000000000ULL, 0x258263D261040E96ULL }, /* XSUM_XXH64_testdata[2490] */
    { 1245, 0x000000009E3779B1ULL, 0x8D389AEAE6B4F1C1ULL }, /* XSUM_XXH64_testdata[2491] */
    { 1246, 0x0000000000000000ULL, 0x760FF274356E9C5FULL }, /* XSUM_XXH64_testdata[2492] */
    { 1246, 0x000000009E3779B1ULL, 0x7783C41F0339CCDAULL }, /* XSUM_XXH64_testdata[2493] */
    { 1247, 0x0000000000000000ULL, 0xAF849E2A261EB492ULL }, /* XSUM_XXH64_testdata[2494] */
    { 1247, 0x000000009E3779B1ULL, 0xACC69D37544594A8ULL }, /* XSUM_XXH64_testdata[2495] */
    { 1248, 0x0000000000000000ULL, 0x0DE54E89CB210CDCULL }, /* XSUM_XXH64_testdata[2496] */
    { 1248, 0x000000009E3779B1ULL, 0x61E849CA2EBEF9FFULL }, /* XSUM_XXH64_testdata[2497] */
    { 1249, 0x0000000000000000ULL, 0x5A3C8D08EB806BCEULL }, /* XSUM_XXH64_testdata[2498] */
    { 1249, 0x000000009E3779B1ULL, 0x379DC4974782BDD9ULL }, /* XSUM_XXH64_testdata[2499] */
    { 1250, 0x0000000000000000ULL, 0x368DC1131379B9FEULL }, /* XSUM_XXH64_testdata[2500] */
    { 1250, 0x000000009E3779B1ULL, 0x13325A3E8F165C63ULL }, /* XSUM_XXH64_testdata[2501] */
    { 1251, 0x0000000000000000ULL, 0x0F27CA33D9737A85ULL }, /* XSUM_XXH64_testdata[2502] */
    { 1251, 0x000000009E3779B1ULL, 0xC9A06B73A3CD97BCULL }, /* XSUM_XXH64_testdata[2503] */
    { 1252, 0x0000000000000000ULL, 0xF7138A9DA0358357ULL }, /* XSUM_XXH64_testdata[2504] */
    { 1252, 0x000000009E3779B1ULL, 0x483D37B4699A0BA5ULL }, /* XSUM_XXH64_testdata[2505] */
    { 1253, 0x0000000000000000ULL, 0xBB6044EAFE2A37DDULL }, /* XSUM_XXH64_testdata[2506] */
    { 1253, 0x000000009E3779B1ULL, 0xE832E33610F21528ULL }, /* XSUM_XXH64_testdata[2507] */
    { 1254, 0x0000000000000000ULL, 0x93F9A5C948795368ULL }, /* XSUM_XXH64_testdata[2508] */
    { 1254, 0x000000009E3779B1ULL, 0x9B5F496CB9421EBFULL }, /* XSUM_XXH64_testdata[2509] */
    { 1255, 0x0000000000000000ULL, 0x50BCB44F97A7E98EULL }, /* XSUM_XXH64_testdata[2510] */
    { 1255, 0x000000009E3779B1ULL, 0x89449A81F35B0468ULL }, /* XSUM_XXH64_testdata[2511] */
    { 1256, 0x0000000000000000ULL, 0xA300597AED91639AULL }, /* XSUM_XXH64_testdata[2512] */
    { 1256, 0x000000009E3779B1ULL, 0x612B85ADF15F21D6ULL }, /* XSUM_XXH64_testdata[2513] */
    { 1257, 0x0000000000000000ULL, 0x368F340A4488595CULL }, /* XSUM_XXH64_testdata[2514] */
    { 1257, 0x000000009E3779B1ULL, 0x669D33F4ABDF123CULL }, /* XSUM_XXH64_testdata[2515] */
    { 1258, 0x0000000000000000ULL, 0xABDFE2C1351C975CULL }, /* XSUM_XXH64_testdata[2516] */
    { 1258, 0x000000009E3779B1ULL, 0xD62D73141A7B16D3ULL }, /* XSUM_XXH64_testdata[2517] */
    { 1259, 0x0000000000000000ULL, 0x80E36E7DF86965A4ULL }, /* XSUM_XXH64_testdata[2518] */
    { 1259, 0x000000009E3779B1ULL, 0x4625C93A0EA7D013ULL }, /* XSUM_XXH64_testdata[2519] */
    { 1260, 0x0000000000000000ULL, 0xFB4CBD33B3DF9999ULL }, /* XSUM_XXH64_testdata[2520] */
    { 1260, 0x000000009E3779B1ULL, 0x363E4DFFEAFD4E6BULL }, /* XSUM_XXH64_testdata[2521] */
    { 1261, 0x0000000000000000ULL, 0x0E91C1D363780BBAULL }, /* XSUM_XXH64_testdata[2522] */
    { 1261, 0x000000009E3779B1ULL, 0x79DAFA2A931AA790ULL }, /* XSUM_XXH64_testdata[2523] */
    { 1262, 0x0000000000000000ULL, 0xB598E511B92FA54DULL }, /* XSUM_XXH64_testdata[2524] */
    { 1262, 0x000000009E3779B1ULL, 0x7452FF1D15408118ULL }, /* XSUM_XXH64_testdata[2525] */
    { 1263, 0x0000000000000000ULL, 0x6619E94FE3900A83ULL }, /* XSUM_XXH64_testdata[2526] */
    { 1263, 0x000000009E3779B1ULL, 0x4FB18DBBE813F3E0ULL }, /* XSUM_XXH64_testdata[2527] */
    { 1264, 0x0000000000000000ULL, 0xD06D2CBB6A4B4E8CULL }, /* XSUM_XXH64_testdata[2528] */
    { 1264, 0x000000009E3779B1ULL, 0x9AF61B3055DDFE08ULL }, /* XSUM_XXH64_testdata[2529] */
    { 1265, 0x0000000000000000ULL, 0xD1900B0CC6086C0EULL }, /* XSUM_XXH64_testdata[2530] */
    { 1265, 0x000000009E3779B1ULL, 0xE4063D30E4B884C2ULL }, /* XSUM_XXH64_testdata[2531] */
    { 1266, 0x0000000000000000ULL, 0x98AA9D73F2DAC51FULL }, /* XSUM_XXH64_testdata[2532] */
    { 1266, 0x000000009E3779B1ULL, 0x2E7DA66C23F348FDULL }, /* XSUM_XXH64_testdata[2533] */
    { 1267, 0x0000000000000000ULL, 0xA4EE1CAA73D39420ULL }, /* XSUM_XXH64_testdata[2534] */
    { 1267, 0x000000009E3779B1ULL, 0xB4D806D4A19DE853ULL }, /* XSUM_XXH64_testdata[2535] */
    { 1268, 0x0000000000000000ULL, 0x94AB4731B858F960ULL }, /* XSUM_XXH64_testdata[2536] */
    { 1268, 0x000000009E3779B1ULL, 0x5A8A9DC20D29F6BFULL }, /* XSUM_XXH64_testdata[2537] */
    { 1269, 0x0000000000000000ULL, 0x3876F287061992F2ULL }, /* XSUM_XXH64_testdata[2538] */
    { 1269, 0x000000009E3779B1ULL, 0xFC975910A170AA4AULL }, /* XSUM_XXH64_testdata[2539] */
    { 1270, 0x0000000000000000ULL, 0x5FD5A4DB54952F6CULL }, /* XSUM_XXH64_testdata[2540] */
    { 1270, 0x000000009E3779B1ULL, 0x036428121B4923F4ULL }, /* XSUM_XXH64_testdata[2541] */
    { 1271, 0x0000000000000000ULL, 0x6829473CA97E14F9ULL }, /* XSUM_XXH64_testdata[2542] */
    { 1271, 0x000000009E3779B1ULL, 0x01B5CD722CC40F2AULL }, /* XSUM_XXH64_testdata[2543] */
    { 1272, 0x0000000000000000ULL, 0xBE8A58BE020D3230ULL }, /* XSUM_XXH64_testdata[2544] */
    { 1272, 0x000000009E3779B1ULL, 0x6DAF9D0FE539903FULL }, /* XSUM_XXH64_testdata[2545] */
    { 1273, 0x0000000000000000ULL, 0x72AB5959633F5E27ULL }, /* XSUM_XXH64_testdata[2546] */
    { 1273, 0x000000009E3779B1ULL, 0x7D6F1923C6515C62ULL }, /* XSUM_XXH64_testdata[2547] */
    { 1274, 0x0000000000000000ULL, 0x8061916A374A52D9ULL }, /* XSUM_XXH64_testdata[2548] */
    { 1274, 0x000000009E3779B1ULL, 0x658A01111D5ACD46ULL }, /* XSUM_XXH64_testdata[2549] */
    { 1275, 0x0000000000000000ULL, 0xB7824002D110E264ULL }, /* XSUM_XXH64_testdata[2550] */
    { 1275, 0x000000009E3779B1ULL, 0xED42D01CB92B156CULL }, /* XSUM_XXH64_testdata[2551] */
    { 1276, 0x0000000000000000ULL, 0x0DBB0A3AEAD70D92ULL }, /* XSUM_XXH64_testdata[2552] */
    { 1276, 0x000000009E3779B1ULL, 0xAA81164963B74FD9ULL }, /* XSUM_XXH64_testdata[2553] */
    { 1277, 0x0000000000000000ULL, 0x601AD4BD37F3E98AULL }, /* XSUM_XXH64_testdata[2554] */
    { 1277, 0x000000009E3779B1ULL, 0x5E3395B8DE13A1AFULL }, /* XSUM_XXH64_testdata[2555] */
    { 1278, 0x0000000000000000ULL, 0x090F1C6FAB3195D0ULL }, /* XSUM_XXH64_testdata[2556] */
    { 1278, 0x000000009E3779B1ULL, 0x270DA22809FB4A56ULL }, /* XSUM_XXH64_testdata[2557] */
    { 1279, 0x0000000000000000ULL, 0x5522EF6FB953BBB7ULL }, /* XSUM_XXH64_testdata[2558] */
    { 1279, 0x000000009E3779B1ULL, 0xE0D3915752724221ULL }, /* XSUM_XXH64_testdata[2559] */
    { 1280, 0x0000000000000000ULL, 0x620780F4DA000BA0ULL }, /* XSUM_XXH64_testdata[2560] */
    { 1280, 0x000000009E3779B1ULL, 0x411FCE4EC0CD4D04ULL }, /* XSUM_XXH64_testdata[2561] */
    { 1281, 0x0000000000000000ULL, 0x8BE240B151E4AFB4ULL }, /* XSUM_XXH64_testdata[2562] */
    { 1281, 0x000000009E3779B1ULL, 0x5BC1006A8ECC7A82ULL }, /* XSUM_XXH64_testdata[2563] */
    { 1282, 0x0000000000000000ULL, 0x393728DEF8661B73ULL }, /* XSUM_XXH64_testdata[2564] */
    { 1282, 0x000000009E3779B1ULL, 0xFE7B502FFA49EF1AULL }, /* XSUM_XXH64_testdata[2565] */
    { 1283, 0x0000000000000000ULL, 0x96216CB0767E98B0ULL }, /* XSUM_XXH64_testdata[2566] */
    { 1283, 0x000000009E3779B1ULL, 0x5F796F16052AEC6BULL }, /* XSUM_XXH64_testdata[2567] */
    { 1284, 0x0000000000000000ULL, 0x4A72C5266407E593ULL }, /* XSUM_XXH64_testdata[2568] */
    { 1284, 0x000000009E3779B1ULL, 0xEBB729E300EC6656ULL }, /* XSUM_XXH64_testdata[2569] */
    { 1285, 0x0000000000000000ULL, 0x45BF8D6F7DC8DD11ULL }, /* XSUM_XXH64_testdata[2570] */
    { 1285, 0x000000009E3779B1ULL, 0x0FD93C9A526ED216ULL }, /* XSUM_XXH64_testdata[2571] */
    { 1286, 0x0000000000000000ULL, 0x7D95824B549B71CBULL }, /* XSUM_XXH64_testdata[2572] */
    { 1286, 0x000000009E3779B1ULL, 0xC2401042E5370568ULL }, /* XSUM_XXH64_testdata[2573] */
    { 1287, 0x0000000000000000ULL, 0x2CBFD6B6589C2905ULL }, /* XSUM_XXH64_testdata[2574] */
    { 1287, 0x000000009E3779B1ULL, 0x45C807941C51E844ULL }, /* XSUM_XXH64_testdata[2575] */
    { 1288, 0x0000000000000000ULL, 0x161BF2E173FFE0A0ULL }, /* XSUM_XXH64_testdata[2576] */
    { 1288, 0x000000009E3779B1ULL, 0x4BA7064E1EE3ABABULL }, /* XSUM_XXH64_testdata[2577] */
    { 1289, 0x0000000000000000ULL, 0x96EBFEDE5314C917ULL }, /* XSUM_XXH64_testdata[2578] */
    { 1289, 0x000000009E3779B1ULL, 0xC41857D925B1C574ULL }, /* XSUM_XXH64_testdata[2579] */
    { 1290, 0x0000000000000000ULL, 0xD3DBD1B2793B3913ULL }, /* XSUM_XXH64_testdata[2580] */
    { 1290, 0x000000009E3779B1ULL, 0x1BB19D4D9BC8C1EFULL }, /* XSUM_XXH64_testdata[2581] */
    { 1291, 0x0000000000000000ULL, 0x504C62B822A74FEDULL }, /* XSUM_XXH64_testdata[2582] */
    { 1291, 0x000000009E3779B1ULL, 0xD74421D8EF71F824ULL }, /* XSUM_XXH64_testdata[2583] */
    { 1292, 0x0000000000000000ULL, 0x0420AE710D4369F1ULL }, /* XSUM_XXH64_testdata[2584] */
    { 1292, 0x000000009E3779B1ULL, 0x6F9E7625EBB09291ULL }, /* XSUM_XXH64_testdata[2585] */
    { 1293, 0x0000000000000000ULL, 0x625A4E46766C5A3CULL }, /* XSUM_XXH64_testdata[2586] */
    { 1293, 0x000000009E3779B1ULL, 0xA9AE6496FE24B1CDULL }, /* XSUM_XXH64_testdata[2587] */
    { 1294, 0x0000000000000000ULL, 0x6D2D56B92F532AA1ULL }, /* XSUM_XXH64_testdata[2588] */
    { 1294, 0x000000009E3779B1ULL, 0xA365E105007B3D4BULL }, /* XSUM_XXH64_testdata[2589] */
    { 1295, 0x0000000000000000ULL, 0x6CE423EEB218BA1EULL }, /* XSUM_XXH64_testdata[2590] */
    { 1295, 0x000000009E3779B1ULL, 0x362275B2201E775DULL }, /* XSUM_XXH64_testdata[2591] */
    { 1296, 0x0000000000000000ULL, 0x57E7A8881FE5AE81ULL }, /* XSUM_XXH64_testdata[2592] */
    { 1296, 0x000000009E3779B1ULL, 0xF0A74F821C1AD1C1ULL }, /* XSUM_XXH64_testdata[2593] */
    { 1297, 0x0000000000000000ULL, 0xF1303BE97BB4A246ULL }, /* XSUM_XXH64_testdata[2594] */
    { 1297, 0x000000009E3779B1ULL, 0xC5DC38AFF72A9152ULL }, /* XSUM_XXH64_testdata[2595] */
    { 1298, 0x0000000000000000ULL, 0x9F66761CFFCB45B1ULL }, /* XSUM_XXH64_testdata[2596] */
    { 1298, 0x000000009E3779B1ULL, 0x046041DA0532975AULL }, /* XSUM_XXH64_testdata[2597] */
    { 1299, 0x0000000000000000ULL, 0x251386907EF2F085ULL }, /* XSUM_XXH64_testdata[2598] */
    { 1299, 0x000000009E3779B1ULL, 0x0BF0ADBD09C1AC4EULL }, /* XSUM_XXH64_testdata[2599] */
    { 1300, 0x0000000000000000ULL, 0x0A02074E30FC36FFULL }, /* XSUM_XXH64_testdata[2600] */
    { 1300, 0x000000009E3779B1ULL, 0x1AA00DE7FB6AB7DDULL }, /* XSUM_XXH64_testdata[2601] */
    { 1301, 0x0000000000000000ULL, 0x4B39E4D9BFA370EAULL }, /* XSUM_XXH64_testdata[2602] */
    { 1301, 0x000000009E3779B1ULL, 0xF4F19AD9A6F4277AULL }, /* XSUM_XXH64_testdata[2603] */
    { 1302, 0x0000000000000000ULL, 0x4672255174D95AF2ULL }, /* XSUM_XXH64_testdata[2604] */
    { 1302, 0x000000009E3779B1ULL, 0x9B8F68A596C484DBULL }, /* XSUM_XXH64_testdata[2605] */
    { 1303, 0x0000000000000000ULL, 0x0B3FA19454D12CDCULL }, /* XSUM_XXH64_testdata[2606] */
    { 1303, 0x000000009E3779B1ULL, 0xDE31CEA673ABFB4AULL }, /* XSUM_XXH64_testdata[2607] */
    { 1304, 0x0000000000000000ULL, 0x5AD5DD0AECCD49D6ULL }, /* XSUM_XXH64_testdata[2608] */
    { 1304, 0x000000009E3779B1ULL, 0x1CB9C7C2176B6770ULL }, /* XSUM_XXH64_testdata[2609] */
    { 1305, 0x0000000000000000ULL, 0xA5577C5E9001E583ULL }, /* XSUM_XXH64_testdata[2610] */
    { 1305, 0x000000009E3779B1ULL, 0xE9E3B6DE8FA67E13ULL }, /* XSUM_XXH64_testdata[2611] */
    { 1306, 0x0000000000000000ULL, 0x0F74C89D25ECBA2EULL }, /* XSUM_XXH64_testdata[2612] */
    { 1306, 0x000000009E3779B1ULL, 0x77A114AD8C9712BBULL }, /* XSUM_XXH64_testdata[2613] */
    { 1307, 0x0000000000000000ULL, 0x8F12CD107793E8ACULL }, /* XSUM_XXH64_testdata[2614] */
    { 1307, 0x000000009E3779B1ULL, 0x78D700D966328A18ULL }, /* XSUM_XXH64_testdata[2615] */
    { 1308, 0x0000000000000000ULL, 0xFD0109A81B799CFFULL }, /* XSUM_XXH64_testdata[2616] */
    { 1308, 0x000000009E3779B1ULL, 0x5EEBECB070F7B11CULL }, /* XSUM_XXH64_testdata[2617] */
    { 1309, 0x0000000000000000ULL, 0x9CBB8CE45E0B230AULL }, /* XSUM_XXH64_testdata[2618] */
    { 1309, 0x000000009E3779B1ULL, 0x6B756934FB7B7EDDULL }, /* XSUM_XXH64_testdata[2619] */
    { 1310, 0x0000000000000000ULL, 0x1DCD7B65323353C2ULL }, /* XSUM_XXH64_testdata[2620] */
    { 1310, 0x000000009E3779B1ULL, 0xAF699F491E0422D0ULL }, /* XSUM_XXH64_testdata[2621] */
    { 1311, 0x0000000000000000ULL, 0xACBDD24166A3D165ULL }, /* XSUM_XXH64_testdata[2622] */
    { 1311, 0x000000009E3779B1ULL, 0x048EA11D235CC86AULL }, /* XSUM_XXH64_testdata[2623] */
    { 1312, 0x0000000000000000ULL, 0x86C56523EB82696FULL }, /* XSUM_XXH64_testdata[2624] */
    { 1312, 0x000000009E3779B1ULL, 0x9A7B448CE5801A12ULL }, /* XSUM_XXH64_testdata[2625] */
    { 1313, 0x0000000000000000ULL, 0x1CE9B1FF5C0DF599ULL }, /* XSUM_XXH64_testdata[2626] */
    { 1313, 0x000000009E3779B1ULL, 0x1B23F0FD44BB34B8ULL }, /* XSUM_XXH64_testdata[2627] */
    { 1314, 0x0000000000000000ULL, 0xD5BF5A00BCBAC10CULL }, /* XSUM_XXH64_testdata[2628] */
    { 1314, 0x000000009E3779B1ULL, 0x9D4D890FA4E2EDA9ULL }, /* XSUM_XXH64_testdata[2629] */
    { 1315, 0x0000000000000000ULL, 0x6114C5E7EA3AD99DULL }, /* XSUM_XXH64_testdata[2630] */
    { 1315, 0x000000009E3779B1ULL, 0x3157827C67062E52ULL }, /* XSUM_XXH64_testdata[2631] */
    { 1316, 0x0000000000000000ULL, 0xC19238B4711F0A91ULL }, /* XSUM_XXH64_testdata[2632] */
    { 1316, 0x000000009E3779B1ULL, 0x3218A499FC46F348ULL }, /* XSUM_XXH64_testdata[2633] */
    { 1317, 0x0000000000000000ULL, 0xD424E17CF418A27EULL }, /* XSUM_XXH64_testdata[2634] */
    { 1317, 0x000000009E3779B1ULL, 0x9298929DB8C68228ULL }, /* XSUM_XXH64_testdata[2635] */
    { 1318, 0x0000000000000000ULL, 0xDA58D90A8397A6E7ULL }, /* XSUM_XXH64_testdata[2636] */
    { 1318, 0x000000009E3779B1ULL, 0x895B8F957AF9E3B0ULL }, /* XSUM_XXH64_testdata[2637] */
    { 1319, 0x0000000000000000ULL, 0xA9AC97A1B9A9C335ULL }, /* XSUM_XXH64_testdata[2638] */
    { 1319, 0x000000009E3779B1ULL, 0x44069E8EC3A9AE46ULL }, /* XSUM_XXH64_testdata[2639] */
    { 1320, 0x0000000000000000ULL, 0xB05F1E644ED3F09AULL }, /* XSUM_XXH64_testdata[2640] */
    { 1320, 0x000000009E3779B1ULL, 0x2741CB1FB955D529ULL }, /* XSUM_XXH64_testdata[2641] */
    { 1321, 0x0000000000000000ULL, 0x636235DE7AD43328ULL }, /* XSUM_XXH64_testdata[2642] */
    { 1321, 0x000000009E3779B1ULL, 0x1FDC0680D864142DULL }, /* XSUM_XXH64_testdata[2643] */
    { 1322, 0x0000000000000000ULL, 0x821690F2B23DD596ULL }, /* XSUM_XXH64_testdata[2644] */
    { 1322, 0x000000009E3779B1ULL, 0x8EFC06CACA6C24D1ULL }, /* XSUM_XXH64_testdata[2645] */
    { 1323, 0x0000000000000000ULL, 0xDD18B16D27A40B8CULL }, /* XSUM_XXH64_testdata[2646] */
    { 1323, 0x000000009E3779B1ULL, 0xB6044F19A110EE6AULL }, /* XSUM_XXH64_testdata[2647] */
    { 1324, 0x0000000000000000ULL, 0x3A038D0F25729ED8ULL }, /* XSUM_XXH64_testdata[2648] */
    { 1324, 0x000000009E3779B1ULL, 0x5A3FC610059044EBULL }, /* XSUM_XXH64_testdata[2649] */
    { 1325, 0x0000000000000000ULL, 0x35DC34B52F743250ULL }, /* XSUM_XXH64_testdata[2650] */
    { 1325, 0x000000009E3779B1ULL, 0xFF15107CAF2EF318ULL }, /* XSUM_XXH64_testdata[2651] */
    { 1326, 0x0000000000000000ULL, 0x1F2499166B03FD84ULL }, /* XSUM_XXH64_testdata[2652] */
    { 1326, 0x000000009E3779B1ULL, 0x8C304B194F9E4407ULL }, /* XSUM_XXH64_testdata[2653] */
    { 1327, 0x0000000000000000ULL, 0xD1D3D9937F31EBB3ULL }, /* XSUM_XXH64_testdata[2654] */
    { 1327, 0x000000009E3779B1ULL, 0x79B78D9E74862661ULL }, /* XSUM_XXH64_testdata[2655] */
    { 1328, 0x0000000000000000ULL, 0xE709EE1A35098365ULL }, /* XSUM_XXH64_testdata[2656] */
    { 1328, 0x000000009E3779B1ULL, 0xE1CFAFF78C6B23D2ULL }, /* XSUM_XXH64_testdata[2657] */
    { 1329, 0x0000000000000000ULL, 0xB12C7D1FBF2660FDULL }, /* XSUM_XXH64_testdata[2658] */
    { 1329, 0x000000009E3779B1ULL, 0x0EB7314B42C4782DULL }, /* XSUM_XXH64_testdata[2659] */
    { 1330, 0x0000000000000000ULL, 0x45E695DC6211BF44ULL }, /* XSUM_XXH64_testdata[2660] */
    { 1330, 0x000000009E3779B1ULL, 0x449D2A747B882733ULL }, /* XSUM_XXH64_testdata[2661] */
    { 1331, 0x0000000000000000ULL, 0x51BFFC24CED5C05DULL }, /* XSUM_XXH64_testdata[2662] */
    { 1331, 0x000000009E3779B1ULL, 0x4C643504A0EA9A5CULL }, /* XSUM_XXH64_testdata[2663] */
    { 1332, 0x0000000000000000ULL, 0x0C0F3DD79316A847ULL }, /* XSUM_XXH64_testdata[2664] */
    { 1332, 0x000000009E3779B1ULL, 0x54F568721DE3221DULL }, /* XSUM_XXH64_testdata[2665] */
    { 1333, 0x0000000000000000ULL, 0x6CE58BECEE8FEDB8ULL }, /* XSUM_XXH64_testdata[2666] */
    { 1333, 0x000000009E3779B1ULL, 0xDEE477768D9FAB72ULL }, /* XSUM_XXH64_testdata[2667] */
    { 1334, 0x0000000000000000ULL, 0x438579D86A9C15ACULL }, /* XSUM_XXH64_testdata[2668] */
    { 1334, 0x000000009E3779B1ULL, 0x16B36B7128883832ULL }, /* XSUM_XXH64_testdata[2669] */
    { 1335, 0x0000000000000000ULL, 0x0CBE8973D7F46722ULL }, /* XSUM_XXH64_testdata[2670] */
    { 1335, 0x000000009E3779B1ULL, 0xAB6A2F42B23D166FULL }, /* XSUM_XXH64_testdata[2671] */
    { 1336, 0x0000000000000000ULL, 0xD59552DAA0FA53B7ULL }, /* XSUM_XXH64_testdata[2672] */
    { 1336, 0x000000009E3779B1ULL, 0x548AB163F16CCAE5ULL }, /* XSUM_XXH64_testdata[2673] */
    { 1337, 0x0000000000000000ULL, 0xF46DD30316E0C084ULL }, /* XSUM_XXH64_testdata[2674] */
    { 1337, 0x000000009E3779B1ULL, 0xEDEA0A122A6A072BULL }, /* XSUM_XXH64_testdata[2675] */
    { 1338, 0x0000000000000000ULL, 0x452088C712C624D5ULL }, /* XSUM_XXH64_testdata[2676] */
    { 1338, 0x000000009E3779B1ULL, 0x83540FF52504F1B8ULL }, /* XSUM_XXH64_testdata[2677] */
    { 1339, 0x0000000000000000ULL, 0xA560912E46111B7FULL }, /* XSUM_XXH64_testdata[2678] */
    { 1339, 0x000000009E3779B1ULL, 0x2D6BB8E5263346E6ULL }, /* XSUM_XXH64_testdata[2679] */
    { 1340, 0x0000000000000000ULL, 0x6DA14D62717846D8ULL }, /* XSUM_XXH64_testdata[2680] */
    { 1340, 0x000000009E3779B1ULL, 0x114E2AE65121AD4DULL }, /* XSUM_XXH64_testdata[2681] */
    { 1341, 0x0000000000000000ULL, 0x918717AC22073D5BULL }, /* XSUM_XXH64_testdata[2682] */
    { 1341, 0x000000009E3779B1ULL, 0x6BC0B407F5C02975ULL }, /* XSUM_XXH64_testdata[2683] */
    { 1342, 0x0000000000000000ULL, 0x57444473A4A9CC90ULL }, /* XSUM_XXH64_testdata[2684] */
    { 1342, 0x000000009E3779B1ULL, 0x276AD11CD9F35079ULL }, /* XSUM_XXH64_testdata[2685] */
    { 1343, 0x0000000000000000ULL, 0x7AEE235559D4C0C8ULL }, /* XSUM_XXH64_testdata[2686] */
    { 1343, 0x000000009E3779B1ULL, 0x5D1427663CCB9705ULL }, /* XSUM_XXH64_testdata[2687] */
    { 1344, 0x0000000000000000ULL, 0x15DC7B5D5799797DULL }, /* XSUM_XXH64_testdata[2688] */
    { 1344, 0x000000009E3779B1ULL, 0x2B4E77316D560D11ULL }, /* XSUM_XXH64_testdata[2689] */
    { 1345, 0x0000000000000000ULL, 0x769B557586674FE0ULL }, /* XSUM_XXH64_testdata[2690] */
    { 1345, 0x000000009E3779B1ULL, 0x5D1B1868C61F2FB8ULL }, /* XSUM_XXH64_testdata[2691] */
    { 1346, 0x0000000000000000ULL, 0xF9ACBC483F6B3B7AULL }, /* XSUM_XXH64_testdata[2692] */
    { 1346, 0x000000009E3779B1ULL, 0x0C3B4817F0C6B1DBULL }, /* XSUM_XXH64_testdata[2693] */
    { 1347, 0x0000000000000000ULL, 0x501B6E21E12B9E60ULL }, /* XSUM_XXH64_testdata[2694] */
    { 1347, 0x000000009E3779B1ULL, 0x227D23F3803B24CDULL }, /* XSUM_XXH64_testdata[2695] */
    { 1348, 0x0000000000000000ULL, 0x54E43E94FB42C61EULL }, /* XSUM_XXH64_testdata[2696] */
    { 1348, 0x000000009E3779B1ULL, 0x04AF23C4A0B4EB7FULL }, /* XSUM_XXH64_testdata[2697] */
    { 1349, 0x0000000000000000ULL, 0x197CC234355FD003ULL }, /* XSUM_XXH64_testdata[2698] */
    { 1349, 0x000000009E3779B1ULL, 0xBEB7DF3E0B8F389AULL }, /* XSUM_XXH64_testdata[2699] */
    { 1350, 0x0000000000000000ULL, 0x8E6D5D488D4DD6E3ULL }, /* XSUM_XXH64_testdata[2700] */
    { 1350, 0x000000009E3779B1ULL, 0xE7BE820CD7CEE527ULL }, /* XSUM_XXH64_testdata[2701] */
    { 1351, 0x0000000000000000ULL, 0x1CBB77C52C65DA71ULL }, /* XSUM_XXH64_testdata[2702] */
    { 1351, 0x000000009E3779B1ULL, 0x9B6867A790593D53ULL }, /* XSUM_XXH64_testdata[2703] */
    { 1352, 0x0000000000000000ULL, 0x6DFB8558EA5E0582ULL }, /* XSUM_XXH64_testdata[2704] */
    { 1352, 0x000000009E3779B1ULL, 0x27E3CED0D26CE4CBULL }, /* XSUM_XXH64_testdata[2705] */
    { 1353, 0x0000000000000000ULL, 0xF378009D91F1DCB5ULL }, /* XSUM_XXH64_testdata[2706] */
    { 1353, 0x000000009E3779B1ULL, 0x47C62E6F224B1F7AULL }, /* XSUM_XXH64_testdata[2707] */
    { 1354, 0x0000000000000000ULL, 0x927F840AE002C3F2ULL }, /* XSUM_XXH64_testdata[2708] */
    { 1354, 0x000000009E3779B1ULL, 0x2317F37121D094C8ULL }, /* XSUM_XXH64_testdata[2709] */
    { 1355, 0x0000000000000000ULL, 0xC6E08DB10CE995E1ULL }, /* XSUM_XXH64_testdata[2710] */
    { 1355, 0x000000009E3779B1ULL, 0x6F44B118D871357DULL }, /* XSUM_XXH64_testdata[2711] */
    { 1356, 0x0000000000000000ULL, 0x1393620564EC0EB1ULL }, /* XSUM_XXH64_testdata[2712] */
    { 1356, 0x000000009E3779B1ULL, 0x622FFF1D7F8177E8ULL }, /* XSUM_XXH64_testdata[2713] */
    { 1357, 0x0000000000000000ULL, 0x983262A18B586007ULL }, /* XSUM_XXH64_testdata[2714] */
    { 1357, 0x000000009E3779B1ULL, 0xBF042E03A98F6AE4ULL }, /* XSUM_XXH64_testdata[2715] */
    { 1358, 0x0000000000000000ULL, 0x859C256485F976E7ULL }, /* XSUM_XXH64_testdata[2716] */
    { 1358, 0x000000009E3779B1ULL, 0x6503CE93831EC22EULL }, /* XSUM_XXH64_testdata[2717] */
    { 1359, 0x0000000000000000ULL, 0x1D100ED534A2B810ULL }, /* XSUM_XXH64_testdata[2718] */
    { 1359, 0x000000009E3779B1ULL, 0xA8C9E649EB779358ULL }, /* XSUM_XXH64_testdata[2719] */
    { 1360, 0x0000000000000000ULL, 0x695F3D196CEEC9DDULL }, /* XSUM_XXH64_testdata[2720] */
    { 1360, 0x000000009E3779B1ULL, 0x961139EEE9C207DAULL }, /* XSUM_XXH64_testdata[2721] */
    { 1361, 0x0000000000000000ULL, 0xA3AC9A161CE70ADDULL }, /* XSUM_XXH64_testdata[2722] */
    { 1361, 0x000000009E3779B1ULL, 0x766B37641FF3F02BULL }, /* XSUM_XXH64_testdata[2723] */
    { 1362, 0x0000000000000000ULL, 0x36222398650CAC27ULL }, /* XSUM_XXH64_testdata[2724] */
    { 1362, 0x000000009E3779B1ULL, 0x05E749AF5E2B7653ULL }, /* XSUM_XXH64_testdata[2725] */
    { 1363, 0x0000000000000000ULL, 0x92379CCF5DA590BCULL }, /* XSUM_XXH64_testdata[2726] */
    { 1363, 0x000000009E3779B1ULL, 0x9ACD63E8D7AF8CB5ULL }, /* XSUM_XXH64_testdata[2727] */
    { 1364, 0x0000000000000000ULL, 0x1380DE1F0C1F2EF6ULL }, /* XSUM_XXH64_testdata[2728] */
    { 1364, 0x000000009E3779B1ULL, 0x3E66D65956E4E057ULL }, /* XSUM_XXH64_testdata[2729] */
    { 1365, 0x0000000000000000ULL, 0x2781F7BF3D5E0C02ULL }, /* XSUM_XXH64_testdata[2730] */
    { 1365, 0x000000009E3779B1ULL, 0x763FBFD7344F4B5CULL }, /* XSUM_XXH64_testdata[2731] */
    { 1366, 0x0000000000000000ULL, 0x52B1CD098243A478ULL }, /* XSUM_XXH64_testdata[2732] */
    { 1366, 0x000000009E3779B1ULL, 0xE989DD600715A8B2ULL }, /* XSUM_XXH64_testdata[2733] */
    { 1367, 0x0000000000000000ULL, 0xAB8832B33745668DULL }, /* XSUM_XXH64_testdata[2734] */
    { 1367, 0x000000009E3779B1ULL, 0xF2DB0271B62431EEULL }, /* XSUM_XXH64_testdata[2735] */
    { 1368, 0x0000000000000000ULL, 0x3E10A789EF2DE6B5ULL }, /* XSUM_XXH64_testdata[2736] */
    { 1368, 0x000000009E3779B1ULL, 0x3ACEDB96AA1231A4ULL }, /* XSUM_XXH64_testdata[2737] */
    { 1369, 0x0000000000000000ULL, 0x718FA0567EF47573ULL }, /* XSUM_XXH64_testdata[2738] */
    { 1369, 0x000000009E3779B1ULL, 0x0495FC84A8D0A331ULL }, /* XSUM_XXH64_testdata[2739] */
    { 1370, 0x0000000000000000ULL, 0xD508D60043853DE7ULL }, /* XSUM_XXH64_testdata[2740] */
    { 1370, 0x000000009E3779B1ULL, 0xBD970E64AB9E7DA5ULL }, /* XSUM_XXH64_testdata[2741] */
    { 1371, 0x0000000000000000ULL, 0xFEC8D842F5B0DFEBULL }, /* XSUM_XXH64_testdata[2742] */
    { 1371, 0x000000009E3779B1ULL, 0xC0CEBE8A2FB49D51ULL }, /* XSUM_XXH64_testdata[2743] */
    { 1372, 0x0000000000000000ULL, 0x80A3B95D583AA0B2ULL }, /* XSUM_XXH64_testdata[2744] */
    { 1372, 0x000000009E3779B1ULL, 0x420BE2BCA48D8E97ULL }, /* XSUM_XXH64_testdata[2745] */
    { 1373, 0x0000000000000000ULL, 0xB79CCFDC858203FFULL }, /* XSUM_XXH64_testdata[2746] */
    { 1373, 0x000000009E3779B1ULL, 0x1DC28B3C9F574291ULL }, /* XSUM_XXH64_testdata[2747] */
    { 1374, 0x0000000000000000ULL, 0x1BAA88C3B3C9655FULL }, /* XSUM_XXH64_testdata[2748] */
    { 1374, 0x000000009E3779B1ULL, 0x9EE63A79A32A3662ULL }, /* XSUM_XXH64_testdata[2749] */
    { 1375, 0x0000000000000000ULL, 0xA2AC5951A4B81E9AULL }, /* XSUM_XXH64_testdata[2750] */
    { 1375, 0x000000009E3779B1ULL, 0xB605B0B60623303DULL }, /* XSUM_XXH64_testdata[2751] */
    { 1376, 0x0000000000000000ULL, 0x05105AD85ED25464ULL }, /* XSUM_XXH64_testdata[2752] */
    { 1376, 0x000000009E3779B1ULL, 0x1B3486DF856CA7EAULL }, /* XSUM_XXH64_testdata[2753] */
    { 1377, 0x0000000000000000ULL, 0x9B980D34293F34CAULL }, /* XSUM_XXH64_testdata[2754] */
    { 1377, 0x000000009E3779B1ULL, 0xC8C8C18F611F229CULL }, /* XSUM_XXH64_testdata[2755] */
    { 1378, 0x0000000000000000ULL, 0x9E22C0A652672D0BULL }, /* XSUM_XXH64_testdata[2756] */
    { 1378, 0x000000009E3779B1ULL, 0x6BFAB8641B1E621CULL }, /* XSUM_XXH64_testdata[2757] */
    { 1379, 0x0000000000000000ULL, 0x5086E3821CC8406CULL }, /* XSUM_XXH64_testdata[2758] */
    { 1379, 0x000000009E3779B1ULL, 0xCFBF4F87BB412E3BULL }, /* XSUM_XXH64_testdata[2759] */
    { 1380, 0x0000000000000000ULL, 0x7BE9601EBCC8286CULL }, /* XSUM_XXH64_testdata[2760] */
    { 1380, 0x000000009E3779B1ULL, 0x4C80BA36A25C0399ULL }, /* XSUM_XXH64_testdata[2761] */
    { 1381, 0x0000000000000000ULL, 0x3C89911C7DA656CDULL }, /* XSUM_XXH64_testdata[2762] */
    { 1381, 0x000000009E3779B1ULL, 0xCE71438C1CC0C506ULL }, /* XSUM_XXH64_testdata[2763] */
    { 1382, 0x0000000000000000ULL, 0x2C3784F266003B55ULL }, /* XSUM_XXH64_testdata[2764] */
    { 1382, 0x000000009E3779B1ULL, 0x49AAE7ECA652DF1DULL }, /* XSUM_XXH64_testdata[2765] */
    { 1383, 0x0000000000000000ULL, 0x4F25B23A35CA6D18ULL }, /* XSUM_XXH64_testdata[2766] */
    { 1383, 0x000000009E3779B1ULL, 0xA5CAAD495EC98DBEULL }, /* XSUM_XXH64_testdata[2767] */
    { 1384, 0x0000000000000000ULL, 0x55FD1C3883B8E6E7ULL }, /* XSUM_XXH64_testdata[2768] */
    { 1384, 0x000000009E3779B1ULL, 0x3F9B9CE0F835FF7AULL }, /* XSUM_XXH64_testdata[2769] */
    { 1385, 0x0000000000000000ULL, 0x8CA9E11FCAFEE78EULL }, /* XSUM_XXH64_testdata[2770] */
    { 1385, 0x000000009E3779B1ULL, 0x1773739BA321ECF7ULL }, /* XSUM_XXH64_testdata[2771] */
    { 1386, 0x0000000000000000ULL, 0x4A3412EB728E91AEULL }, /* XSUM_XXH64_testdata[2772] */
    { 1386, 0x000000009E3779B1ULL, 0x64440665090CEF4CULL }, /* XSUM_XXH64_testdata[2773] */
    { 1387, 0x0000000000000000ULL, 0xFCB0771B2EB57A0AULL }, /* XSUM_XXH64_testdata[2774] */
    { 1387, 0x000000009E3779B1ULL, 0x426FCFEBF3D6E5E8ULL }, /* XSUM_XXH64_testdata[2775] */
    { 1388, 0x0000000000000000ULL, 0x2F30B02AA699CBE8ULL }, /* XSUM_XXH64_testdata[2776] */
    { 1388, 0x000000009E3779B1ULL, 0x64A446AB9B571DD2ULL }, /* XSUM_XXH64_testdata[2777] */
    { 1389, 0x0000000000000000ULL, 0x9DA2036562427656ULL }, /* XSUM_XXH64_testdata[2778] */
    { 1389, 0x000000009E3779B1ULL, 0xF1AEE90EAE91F957ULL }, /* XSUM_XXH64_testdata[2779] */
    { 1390, 0x0000000000000000ULL, 0xB2B8977223C5D2C1ULL }, /* XSUM_XXH64_testdata[2780] */
    { 1390, 0x000000009E3779B1ULL, 0x9462EFF8DE381453ULL }, /* XSUM_XXH64_testdata[2781] */
    { 1391, 0x0000000000000000ULL, 0x4C42F170AAD91664ULL }, /* XSUM_XXH64_testdata[2782] */
    { 1391, 0x000000009E3779B1ULL, 0x50AE4C1857E9ADD3ULL }, /* XSUM_XXH64_testdata[2783] */
    { 1392, 0x0000000000000000ULL, 0x69303B567524C0A3ULL }, /* XSUM_XXH64_testdata[2784] */
    { 1392, 0x000000009E3779B1ULL, 0x92374DE46EACAFE2ULL }, /* XSUM_XXH64_testdata[2785] */
    { 1393, 0x0000000000000000ULL, 0x7FB292558526C18EULL }, /* XSUM_XXH64_testdata[2786] */
    { 1393, 0x000000009E3779B1ULL, 0x162A2B64E1C9C595ULL }, /* XSUM_XXH64_testdata[2787] */
    { 1394, 0x0000000000000000ULL, 0xAF95D1BFD104F5AAULL }, /* XSUM_XXH64_testdata[2788] */
    { 1394, 0x000000009E3779B1ULL, 0x8F14240BD0721EC1ULL }, /* XSUM_XXH64_testdata[2789] */
    { 1395, 0x0000000000000000ULL, 0xDDF9460952022AC9ULL }, /* XSUM_XXH64_testdata[2790] */
    { 1395, 0x000000009E3779B1ULL, 0x9BD0060C13A38E86ULL }, /* XSUM_XXH64_testdata[2791] */
    { 1396, 0x0000000000000000ULL, 0xED4C2D524DC349FEULL }, /* XSUM_XXH64_testdata[2792] */
    { 1396, 0x000000009E3779B1ULL, 0x1941F5B34399C0CDULL }, /* XSUM_XXH64_testdata[2793] */
    { 1397, 0x0000000000000000ULL, 0xFA075133A00FB771ULL }, /* XSUM_XXH64_testdata[2794] */
    { 1397, 0x000000009E3779B1ULL, 0x140CCF6A98392415ULL }, /* XSUM_XXH64_testdata[2795] */
    { 1398, 0x0000000000000000ULL, 0xD3EFE91A84274D6CULL }, /* XSUM_XXH64_testdata[2796] */
    { 1398, 0x000000009E3779B1ULL, 0x85C4C7E082426AE9ULL }, /* XSUM_XXH64_testdata[2797] */
    { 1399, 0x0000000000000000ULL, 0x35F2EF47A529872BULL }, /* XSUM_XXH64_testdata[2798] */
    { 1399, 0x000000009E3779B1ULL, 0xA41F8535D0C66086ULL }, /* XSUM_XXH64_testdata[2799] */
    { 1400, 0x0000000000000000ULL, 0x2764EB1CFCCB0F47ULL }, /* XSUM_XXH64_testdata[2800] */
    { 1400, 0x000000009E3779B1ULL, 0x0729A7AEF3131B33ULL }, /* XSUM_XXH64_testdata[2801] */
    { 1401, 0x0000000000000000ULL, 0x434C8FAC341BAB69ULL }, /* XSUM_XXH64_testdata[2802] */
    { 1401, 0x000000009E3779B1ULL, 0xDBA0C947AACE6DE8ULL }, /* XSUM_XXH64_testdata[2803] */
    { 1402, 0x0000000000000000ULL, 0x8515BF3CB931F6ADULL }, /* XSUM_XXH64_testdata[2804] */
    { 1402, 0x000000009E3779B1ULL, 0x70BE88885AA321D6ULL }, /* XSUM_XXH64_testdata[2805] */
    { 1403, 0x0000000000000000ULL, 0x31F9D7532FC60CFCULL }, /* XSUM_XXH64_testdata[2806] */
    { 1403, 0x000000009E3779B1ULL, 0xB316CD5AC2EB3017ULL }, /* XSUM_XXH64_testdata[2807] */
    { 1404, 0x0000000000000000ULL, 0x9D5FF3DA416DCDA2ULL }, /* XSUM_XXH64_testdata[2808] */
    { 1404, 0x000000009E3779B1ULL, 0x1A55EC8281BF14D8ULL }, /* XSUM_XXH64_testdata[2809] */
    { 1405, 0x0000000000000000ULL, 0x52AFE94D8A457BDAULL }, /* XSUM_XXH64_testdata[2810] */
    { 1405, 0x000000009E3779B1ULL, 0x9A5FE08630205E30ULL }, /* XSUM_XXH64_testdata[2811] */
    { 1406, 0x0000000000000000ULL, 0x89FA771920AB788DULL }, /* XSUM_XXH64_testdata[2812] */
    { 1406, 0x000000009E3779B1ULL, 0xABCF86246F306DC7ULL }, /* XSUM_XXH64_testdata[2813] */
    { 1407, 0x0000000000000000ULL, 0xBD3CED06760E9D9DULL }, /* XSUM_XXH64_testdata[2814] */
    { 1407, 0x000000009E3779B1ULL, 0xBCB2C1C8334FD29DULL }, /* XSUM_XXH64_testdata[2815] */
    { 1408, 0x0000000000000000ULL, 0xB8ED29057DB3F656ULL }, /* XSUM_XXH64_testdata[2816] */
    { 1408, 0x000000009E3779B1ULL, 0x96B558FE2F7EC951ULL }, /* XSUM_XXH64_testdata[2817] */
    { 1409, 0x0000000000000000ULL, 0x387FB5D4FE9557F1ULL }, /* XSUM_XXH64_testdata[2818] */
    { 1409, 0x000000009E3779B1ULL, 0xBBC531AECA8C2299ULL }, /* XSUM_XXH64_testdata[2819] */
    { 1410, 0x0000000000000000ULL, 0x6B67D1773FBAC3A4ULL }, /* XSUM_XXH64_testdata[2820] */
    { 1410, 0x000000009E3779B1ULL, 0xAAA8764F5D162926ULL }, /* XSUM_XXH64_testdata[2821] */
    { 1411, 0x0000000000000000ULL, 0xAA9D378A0E424E33ULL }, /* XSUM_XXH64_testdata[2822] */
    { 1411, 0x000000009E3779B1ULL, 0xB5DE4BFAEDA569BBULL }, /* XSUM_XXH64_testdata[2823] */
    { 1412, 0x0000000000000000ULL, 0xD8ED1C02753A0C2AULL }, /* XSUM_XXH64_testdata[2824] */
    { 1412, 0x000000009E3779B1ULL, 0xBCF9F94C5EADD3C4ULL }, /* XSUM_XXH64_testdata[2825] */
    { 1413, 0x0000000000000000ULL, 0x930DCAE693006F34ULL }, /* XSUM_XXH64_testdata[2826] */
    { 1413, 0x000000009E3779B1ULL, 0x10885D81C03734B8ULL }, /* XSUM_XXH64_testdata[2827] */
    { 1414, 0x0000000000000000ULL, 0x7671A5E7871645B3ULL }, /* XSUM_XXH64_testdata[2828] */
    { 1414, 0x000000009E3779B1ULL, 0x38ACBF3BA2708BADULL }, /* XSUM_XXH64_testdata[2829] */
    { 1415, 0x0000000000000000ULL, 0x62C922A90C9D4771ULL }, /* XSUM_XXH64_testdata[2830] */
    { 1415, 0x000000009E3779B1ULL, 0x3314D5D248121BE8ULL }, /* XSUM_XXH64_testdata[2831] */
    { 1416, 0x0000000000000000ULL, 0x7FCFC2B8D7A05E7EULL }, /* XSUM_XXH64_testdata[2832] */
    { 1416, 0x000000009E3779B1ULL, 0xD3E65C430D8FED2BULL }, /* XSUM_XXH64_testdata[2833] */
    { 1417, 0x0000000000000000ULL, 0x05384040B0FFAE41ULL }, /* XSUM_XXH64_testdata[2834] */
    { 1417, 0x000000009E3779B1ULL, 0xCAB435B84527AA8DULL }, /* XSUM_XXH64_testdata[2835] */
    { 1418, 0x0000000000000000ULL, 0x14C7773C9211B772ULL }, /* XSUM_XXH64_testdata[2836] */
    { 1418, 0x000000009E3779B1ULL, 0x75D192F74DF1E368ULL }, /* XSUM_XXH64_testdata[2837] */
    { 1419, 0x0000000000000000ULL, 0x7BBDAEB0D052C59FULL }, /* XSUM_XXH64_testdata[2838] */
    { 1419, 0x000000009E3779B1ULL, 0x2F77DF0021087209ULL }, /* XSUM_XXH64_testdata[2839] */
    { 1420, 0x0000000000000000ULL, 0x5AB24699346A8A33ULL }, /* XSUM_XXH64_testdata[2840] */
    { 1420, 0x000000009E3779B1ULL, 0x8C007172379EB0E3ULL }, /* XSUM_XXH64_testdata[2841] */
    { 1421, 0x0000000000000000ULL, 0x88F6070327945BE5ULL }, /* XSUM_XXH64_testdata[2842] */
    { 1421, 0x000000009E3779B1ULL, 0xCA801BBAF31272C9ULL }, /* XSUM_XXH64_testdata[2843] */
    { 1422, 0x0000000000000000ULL, 0x51A1B2F87302C6D8ULL }, /* XSUM_XXH64_testdata[2844] */
    { 1422, 0x000000009E3779B1ULL, 0x5C16264DA6393D7DULL }, /* XSUM_XXH64_testdata[2845] */
    { 1423, 0x0000000000000000ULL, 0x5A0AF8D5F6D877BAULL }, /* XSUM_XXH64_testdata[2846] */
    { 1423, 0x000000009E3779B1ULL, 0xEF006D3E22294420ULL }, /* XSUM_XXH64_testdata[2847] */
    { 1424, 0x0000000000000000ULL, 0x1035CD2451591B7EULL }, /* XSUM_XXH64_testdata[2848] */
    { 1424, 0x000000009E3779B1ULL, 0xEA6BB73F47B12F70ULL }, /* XSUM_XXH64_testdata[2849] */
    { 1425, 0x0000000000000000ULL, 0x31B4370AECA70AF0ULL }, /* XSUM_XXH64_testdata[2850] */
    { 1425, 0x000000009E3779B1ULL, 0xD85F64E7BD1AEFB1ULL }, /* XSUM_XXH64_testdata[2851] */
    { 1426, 0x0000000000000000ULL, 0x8A5128B550E364E4ULL }, /* XSUM_XXH64_testdata[2852] */
    { 1426, 0x000000009E3779B1ULL, 0x8E9FC61253F0B806ULL }, /* XSUM_XXH64_testdata[2853] */
    { 1427, 0x0000000000000000ULL, 0x49D52BC80042A3C9ULL }, /* XSUM_XXH64_testdata[2854] */
    { 1427, 0x000000009E3779B1ULL, 0xBEF93A8BF95E29B2ULL }, /* XSUM_XXH64_testdata[2855] */
    { 1428, 0x0000000000000000ULL, 0x9AFAFC896AF5135AULL }, /* XSUM_XXH64_testdata[2856] */
    { 1428, 0x000000009E3779B1ULL, 0xEF0E6C08921028E0ULL }, /* XSUM_XXH64_testdata[2857] */
    { 1429, 0x0000000000000000ULL, 0xD716A4A02703FCD6ULL }, /* XSUM_XXH64_testdata[2858] */
    { 1429, 0x000000009E3779B1ULL, 0x2DEA819EEF6B4595ULL }, /* XSUM_XXH64_testdata[2859] */
    { 1430, 0x0000000000000000ULL, 0xEA46BF1375B51E01ULL }, /* XSUM_XXH64_testdata[2860] */
    { 1430, 0x000000009E3779B1ULL, 0x10E8697EA20375CDULL }, /* XSUM_XXH64_testdata[2861] */
    { 1431, 0x0000000000000000ULL, 0xD1677286E49D7AE9ULL }, /* XSUM_XXH64_testdata[2862] */
    { 1431, 0x000000009E3779B1ULL, 0x4684D4C0C84A53A7ULL }, /* XSUM_XXH64_testdata[2863] */
    { 1432, 0x0000000000000000ULL, 0xB8443E3175950346ULL }, /* XSUM_XXH64_testdata[2864] */
    { 1432, 0x000000009E3779B1ULL, 0x393277B05E885C65ULL }, /* XSUM_XXH64_testdata[2865] */
    { 1433, 0x0000000000000000ULL, 0x3C09ACEBA05DDEF4ULL }, /* XSUM_XXH64_testdata[2866] */
    { 1433, 0x000000009E3779B1ULL, 0x4A00F39B99CE0EA0ULL }, /* XSUM_XXH64_testdata[2867] */
    { 1434, 0x0000000000000000ULL, 0x269F19470CAE3C69ULL }, /* XSUM_XXH64_testdata[2868] */
    { 1434, 0x000000009E3779B1ULL, 0x6C690DC42C3A9A43ULL }, /* XSUM_XXH64_testdata[2869] */
    { 1435, 0x0000000000000000ULL, 0x347414263504B8C2ULL }, /* XSUM_XXH64_testdata[2870] */
    { 1435, 0x000000009E3779B1ULL, 0x62412B4D4DC300C8ULL }, /* XSUM_XXH64_testdata[2871] */
    { 1436, 0x0000000000000000ULL, 0x540681AD51327B7EULL }, /* XSUM_XXH64_testdata[2872] */
    { 1436, 0x000000009E3779B1ULL, 0x7632FBF9FD453F12ULL }, /* XSUM_XXH64_testdata[2873] */
    { 1437, 0x0000000000000000ULL, 0xA25FC78176580D43ULL }, /* XSUM_XXH64_testdata[2874] */
    { 1437, 0x000000009E3779B1ULL, 0xE088E98CDF324070ULL }, /* XSUM_XXH64_testdata[2875] */
    { 1438, 0x0000000000000000ULL, 0x2DDB228C75DB7167ULL }, /* XSUM_XXH64_testdata[2876] */
    { 1438, 0x000000009E3779B1ULL, 0xA867E2DCDC56505BULL }, /* XSUM_XXH64_testdata[2877] */
    { 1439, 0x0000000000000000ULL, 0x34A7198C97C57F64ULL }, /* XSUM_XXH64_testdata[2878] */
    { 1439, 0x000000009E3779B1ULL, 0x6ECEA6835BC51709ULL }, /* XSUM_XXH64_testdata[2879] */
    { 1440, 0x0000000000000000ULL, 0x8566C095BF096EA9ULL }, /* XSUM_XXH64_testdata[2880] */
    { 1440, 0x000000009E3779B1ULL, 0xE716D1071B5C5BA9ULL }, /* XSUM_XXH64_testdata[2881] */
    { 1441, 0x0000000000000000ULL, 0x3140D9FE67215224ULL }, /* XSUM_XXH64_testdata[2882] */
    { 1441, 0x000000009E3779B1ULL, 0x747696972CAD69FAULL }, /* XSUM_XXH64_testdata[2883] */
    { 1442, 0x0000000000000000ULL, 0xBAFFEBF129E5962FULL }, /* XSUM_XXH64_testdata[2884] */
    { 1442, 0x000000009E3779B1ULL, 0xF3CD672ADDC8AED5ULL }, /* XSUM_XXH64_testdata[2885] */
    { 1443, 0x0000000000000000ULL, 0xAE9E2011F52A8A64ULL }, /* XSUM_XXH64_testdata[2886] */
    { 1443, 0x000000009E3779B1ULL, 0xC7A6748860A43455ULL }, /* XSUM_XXH64_testdata[2887] */
    { 1444, 0x0000000000000000ULL, 0x92FE8E709EE3B9EAULL }, /* XSUM_XXH64_testdata[2888] */
    { 1444, 0x000000009E3779B1ULL, 0xFCE8A337561D1A7BULL }, /* XSUM_XXH64_testdata[2889] */
    { 1445, 0x0000000000000000ULL, 0x261231C0CF704346ULL }, /* XSUM_XXH64_testdata[2890] */
    { 1445, 0x000000009E3779B1ULL, 0x68215EE9EB5B80DAULL }, /* XSUM_XXH64_testdata[2891] */
    { 1446, 0x0000000000000000ULL, 0x7719D7F38F357225ULL }, /* XSUM_XXH64_testdata[2892] */
    { 1446, 0x000000009E3779B1ULL, 0x45D4AB2DF7BEC909ULL }, /* XSUM_XXH64_testdata[2893] */
    { 1447, 0x0000000000000000ULL, 0x4FD64C4CD3E8675BULL }, /* XSUM_XXH64_testdata[2894] */
    { 1447, 0x000000009E3779B1ULL, 0x76D0FA7C6F361546ULL }, /* XSUM_XXH64_testdata[2895] */
    { 1448, 0x0000000000000000ULL, 0x4C299D06102A101EULL }, /* XSUM_XXH64_testdata[2896] */
    { 1448, 0x000000009E3779B1ULL, 0xE91228A4672BF68EULL }, /* XSUM_XXH64_testdata[2897] */
    { 1449, 0x0000000000000000ULL, 0x0DE12AFCC005F1E1ULL }, /* XSUM_XXH64_testdata[2898] */
    { 1449, 0x000000009E3779B1ULL, 0x48A847A19C7DEFA6ULL }, /* XSUM_XXH64_testdata[2899] */
    { 1450, 0x0000000000000000ULL, 0xED52DD144A739FBCULL }, /* XSUM_XXH64_testdata[2900] */
    { 1450, 0x000000009E3779B1ULL, 0xFDF107770AF5E161ULL }, /* XSUM_XXH64_testdata[2901] */
    { 1451, 0x0000000000000000ULL, 0xBADF26C68BC84826ULL }, /* XSUM_XXH64_testdata[2902] */
    { 1451, 0x000000009E3779B1ULL, 0x9D3308507D63B6F7ULL }, /* XSUM_XXH64_testdata[2903] */
    { 1452, 0x0000000000000000ULL, 0x7FA6FFA49A4A597FULL }, /* XSUM_XXH64_testdata[2904] */
    { 1452, 0x000000009E3779B1ULL, 0x7B13FC644B3772EBULL }, /* XSUM_XXH64_testdata[2905] */
    { 1453, 0x0000000000000000ULL, 0xF39D65107F93CB0FULL }, /* XSUM_XXH64_testdata[2906] */
    { 1453, 0x000000009E3779B1ULL, 0xA48CAD1CA608E6B7ULL }, /* XSUM_XXH64_testdata[2907] */
    { 1454, 0x0000000000000000ULL, 0x101EFEAB0DCB65D3ULL }, /* XSUM_XXH64_testdata[2908] */
    { 1454, 0x000000009E3779B1ULL, 0xC7FA192E41805983ULL }, /* XSUM_XXH64_testdata[2909] */
    { 1455, 0x0000000000000000ULL, 0x8833E666865F2E5FULL }, /* XSUM_XXH64_testdata[2910] */
    { 1455, 0x000000009E3779B1ULL, 0x8278069ED1F682CBULL }, /* XSUM_XXH64_testdata[2911] */
    { 1456, 0x0000000000000000ULL, 0x2F01BD0C433E5550ULL }, /* XSUM_XXH64_testdata[2912] */
    { 1456, 0x000000009E3779B1ULL, 0xBD143DC1B73859B4ULL }, /* XSUM_XXH64_testdata[2913] */
    { 1457, 0x0000000000000000ULL, 0x272159E114DAB7EBULL }, /* XSUM_XXH64_testdata[2914] */
    { 1457, 0x000000009E3779B1ULL, 0x97E408F3690958EDULL }, /* XSUM_XXH64_testdata[2915] */
    { 1458, 0x0000000000000000ULL, 0x1045EEFF406CBEDEULL }, /* XSUM_XXH64_testdata[2916] */
    { 1458, 0x000000009E3779B1ULL, 0xFB2CAC5E57A0B6F1ULL }, /* XSUM_XXH64_testdata[2917] */
    { 1459, 0x0000000000000000ULL, 0x32211FA3D50BA16DULL }, /* XSUM_XXH64_testdata[2918] */
    { 1459, 0x000000009E3779B1ULL, 0xD1E9E3DDD13972C0ULL }, /* XSUM_XXH64_testdata[2919] */
    { 1460, 0x0000000000000000ULL, 0x3009626300D1513EULL }, /* XSUM_XXH64_testdata[2920] */
    { 1460, 0x000000009E3779B1ULL, 0xDB1A55314DFB90A1ULL }, /* XSUM_XXH64_testdata[2921] */
    { 1461, 0x0000000000000000ULL, 0x456D11EF8FC39F93ULL }, /* XSUM_XXH64_testdata[2922] */
    { 1461, 0x000000009E3779B1ULL, 0x4B2A5A2199951E7EULL }, /* XSUM_XXH64_testdata[2923] */
    { 1462, 0x0000000000000000ULL, 0x125C836BF1538374ULL }, /* XSUM_XXH64_testdata[2924] */
    { 1462, 0x000000009E3779B1ULL, 0x5BD1ED70A5E5E950ULL }, /* XSUM_XXH64_testdata[2925] */
    { 1463, 0x0000000000000000ULL, 0xD569E05067BE5FA6ULL }, /* XSUM_XXH64_testdata[2926] */
    { 1463, 0x000000009E3779B1ULL, 0x103170624ACB74ABULL }, /* XSUM_XXH64_testdata[2927] */
    { 1464, 0x0000000000000000ULL, 0x2B4483710726096CULL }, /* XSUM_XXH64_testdata[2928] */
    { 1464, 0x000000009E3779B1ULL, 0xA13F3D60CD7133E4ULL }, /* XSUM_XXH64_testdata[2929] */
    { 1465, 0x0000000000000000ULL, 0xDF0C24A1FA0470F3ULL }, /* XSUM_XXH64_testdata[2930] */
    { 1465, 0x000000009E3779B1ULL, 0x39A95CB70B9EAE27ULL }, /* XSUM_XXH64_testdata[2931] */
    { 1466, 0x0000000000000000ULL, 0x8E29827A525351CBULL }, /* XSUM_XXH64_testdata[2932] */
    { 1466, 0x000000009E3779B1ULL, 0xE1E83603AE96EA0EULL }, /* XSUM_XXH64_testdata[2933] */
    { 1467, 0x0000000000000000ULL, 0x79F1FA1757DC13FFULL }, /* XSUM_XXH64_testdata[2934] */
    { 1467, 0x000000009E3779B1ULL, 0x172D6678D6609F86ULL }, /* XSUM_XXH64_testdata[2935] */
    { 1468, 0x0000000000000000ULL, 0x0FD8ADA93856A4A6ULL }, /* XSUM_XXH64_testdata[2936] */
    { 1468, 0x000000009E3779B1ULL, 0xE246CD70954E2E67ULL }, /* XSUM_XXH64_testdata[2937] */
    { 1469, 0x0000000000000000ULL, 0x09ED73602ECE33F0ULL }, /* XSUM_XXH64_testdata[2938] */
    { 1469, 0x000000009E3779B1ULL, 0x0482AAB6C267ED20ULL }, /* XSUM_XXH64_testdata[2939] */
    { 1470, 0x0000000000000000ULL, 0x44F7890CFD1AF2BEULL }, /* XSUM_XXH64_testdata[2940] */
    { 1470, 0x000000009E3779B1ULL, 0xB20C1E6581F2C18DULL }, /* XSUM_XXH64_testdata[2941] */
    { 1471, 0x0000000000000000ULL, 0x3D3D725CA5A2DA86ULL }, /* XSUM_XXH64_testdata[2942] */
    { 1471, 0x000000009E3779B1ULL, 0x1562DCAD2E6FD432ULL }, /* XSUM_XXH64_testdata[2943] */
    { 1472, 0x0000000000000000ULL, 0xEDDF8EAA95CE1B30ULL }, /* XSUM_XXH64_testdata[2944] */
    { 1472, 0x000000009E3779B1ULL, 0x39B4C49D392F7522ULL }, /* XSUM_XXH64_testdata[2945] */
    { 1473, 0x0000000000000000ULL, 0xE1CFBD74D188ACC2ULL }, /* XSUM_XXH64_testdata[2946] */
    { 1473, 0x000000009E3779B1ULL, 0xCBF75E181751BF3BULL }, /* XSUM_XXH64_testdata[2947] */
    { 1474, 0x0000000000000000ULL, 0xC20EAB96671D3FBAULL }, /* XSUM_XXH64_testdata[2948] */
    { 1474, 0x000000009E3779B1ULL, 0x9099CABD8C20F483ULL }, /* XSUM_XXH64_testdata[2949] */
    { 1475, 0x0000000000000000ULL, 0x7FB5C672D39D8864ULL }, /* XSUM_XXH64_testdata[2950] */
    { 1475, 0x000000009E3779B1ULL, 0x2227B1D484DA4061ULL }, /* XSUM_XXH64_testdata[2951] */
    { 1476, 0x0000000000000000ULL, 0x7433E07CCD9FAA25ULL }, /* XSUM_XXH64_testdata[2952] */
    { 1476, 0x000000009E3779B1ULL, 0x980331CE0A840E3FULL }, /* XSUM_XXH64_testdata[2953] */
    { 1477, 0x0000000000000000ULL, 0x8B91EDB08E1B72A3ULL }, /* XSUM_XXH64_testdata[2954] */
    { 1477, 0x000000009E3779B1ULL, 0x5D0A2226FAFC9E03ULL }, /* XSUM_XXH64_testdata[2955] */
    { 1478, 0x0000000000000000ULL, 0xB3B50DB7128872C6ULL }, /* XSUM_XXH64_testdata[2956] */
    { 1478, 0x000000009E3779B1ULL, 0x061A1F8E4F13FB16ULL }, /* XSUM_XXH64_testdata[2957] */
    { 1479, 0x0000000000000000ULL, 0x70F03B127FD08568ULL }, /* XSUM_XXH64_testdata[2958] */
    { 1479, 0x000000009E3779B1ULL, 0x499DD506010B6EA9ULL }, /* XSUM_XXH64_testdata[2959] */
    { 1480, 0x0000000000000000ULL, 0x4840230663D42556ULL }, /* XSUM_XXH64_testdata[2960] */
    { 1480, 0x000000009E3779B1ULL, 0x466F19B2D39C2627ULL }, /* XSUM_XXH64_testdata[2961] */
    { 1481, 0x0000000000000000ULL, 0x60617B08B4FF6838ULL }, /* XSUM_XXH64_testdata[2962] */
    { 1481, 0x000000009E3779B1ULL, 0x7922EF1E30FFABABULL }, /* XSUM_XXH64_testdata[2963] */
    { 1482, 0x0000000000000000ULL, 0xE9D77667FA81C7E5ULL }, /* XSUM_XXH64_testdata[2964] */
    { 1482, 0x000000009E3779B1ULL, 0xFAF7EE8CA5BEAF83ULL }, /* XSUM_XXH64_testdata[2965] */
    { 1483, 0x0000000000000000ULL, 0xF33B1A5501ADF046ULL }, /* XSUM_XXH64_testdata[2966] */
    { 1483, 0x000000009E3779B1ULL, 0xB3C0C8D4B5DAF9CAULL }, /* XSUM_XXH64_testdata[2967] */
    { 1484, 0x0000000000000000ULL, 0x5418DB822BB143E5ULL }, /* XSUM_XXH64_testdata[2968] */
    { 1484, 0x000000009E3779B1ULL, 0x1091DA12D1F48071ULL }, /* XSUM_XXH64_testdata[2969] */
    { 1485, 0x0000000000000000ULL, 0x3A11E24EC8CB7555ULL }, /* XSUM_XXH64_testdata[2970] */
    { 1485, 0x000000009E3779B1ULL, 0x39D3027FDE2D55A6ULL }, /* XSUM_XXH64_testdata[2971] */
    { 1486, 0x0000000000000000ULL, 0x6E51DA2B6722709EULL }, /* XSUM_XXH64_testdata[2972] */
    { 1486, 0x000000009E3779B1ULL, 0x863BED60E6ED9AD0ULL }, /* XSUM_XXH64_testdata[2973] */
    { 1487, 0x0000000000000000ULL, 0x4D9DFD5C2924D020ULL }, /* XSUM_XXH64_testdata[2974] */
    { 1487, 0x000000009E3779B1ULL, 0x29BB8A2629150931ULL }, /* XSUM_XXH64_testdata[2975] */
    { 1488, 0x0000000000000000ULL, 0xAA5704F96972733BULL }, /* XSUM_XXH64_testdata[2976] */
    { 1488, 0x000000009E3779B1ULL, 0x337B4425C4848725ULL }, /* XSUM_XXH64_testdata[2977] */
    { 1489, 0x0000000000000000ULL, 0x8AF06779F20C39DEULL }, /* XSUM_XXH64_testdata[2978] */
    { 1489, 0x000000009E3779B1ULL, 0xDE53377A6AD53842ULL }, /* XSUM_XXH64_testdata[2979] */
    { 1490, 0x0000000000000000ULL, 0xF1288F7B9DF99262ULL }, /* XSUM_XXH64_testdata[2980] */
    { 1490, 0x000000009E3779B1ULL, 0x3C915FE67DD9348BULL }, /* XSUM_XXH64_testdata[2981] */
    { 1491, 0x0000000000000000ULL, 0x5BDCF7CD9ECF3DCEULL }, /* XSUM_XXH64_testdata[2982] */
    { 1491, 0x000000009E3779B1ULL, 0x7F29B947A05EA0DAULL }, /* XSUM_XXH64_testdata[2983] */
    { 1492, 0x0000000000000000ULL, 0xCB901C6DA9D69A57ULL }, /* XSUM_XXH64_testdata[2984] */
    { 1492, 0x000000009E3779B1ULL, 0x8B83F2BC74BEAFA6ULL }, /* XSUM_XXH64_testdata[2985] */
    { 1493, 0x0000000000000000ULL, 0x23FB34D375386B32ULL }, /* XSUM_XXH64_testdata[2986] */
    { 1493, 0x000000009E3779B1ULL, 0xFCFF53156B0A9FAEULL }, /* XSUM_XXH64_testdata[2987] */
    { 1494, 0x0000000000000000ULL, 0x47583913FCEB818DULL }, /* XSUM_XXH64_testdata[2988] */
    { 1494, 0x000000009E3779B1ULL, 0xA59F8BB05241C034ULL }, /* XSUM_XXH64_testdata[2989] */
    { 1495, 0x0000000000000000ULL, 0x3E827FBDE37ACFCEULL }, /* XSUM_XXH64_testdata[2990] */
    { 1495, 0x000000009E3779B1ULL, 0x591486946B610E70ULL }, /* XSUM_XXH64_testdata[2991] */
    { 1496, 0x0000000000000000ULL, 0x9F48EF32A6B79352ULL }, /* XSUM_XXH64_testdata[2992] */
    { 1496, 0x000000009E3779B1ULL, 0xEAC2A17B2E1FA603ULL }, /* XSUM_XXH64_testdata[2993] */
    { 1497, 0x0000000000000000ULL, 0x12C974795020ACD6ULL }, /* XSUM_XXH64_testdata[2994] */
    { 1497, 0x000000009E3779B1ULL, 0xB6B3EE57D83EB29BULL }, /* XSUM_XXH64_testdata[2995] */
    { 1498, 0x0000000000000000ULL, 0x022E0F7E3F965FC9ULL }, /* XSUM_XXH64_testdata[2996] */
    { 1498, 0x000000009E3779B1ULL, 0x8CF81EA9ACE4AB66ULL }, /* XSUM_XXH64_testdata[2997] */
    { 1499, 0x0000000000000000ULL, 0xE4626BF4E5922AF6ULL }, /* XSUM_XXH64_testdata[2998] */
    { 1499, 0x000000009E3779B1ULL, 0x28928FAAA1160219ULL }, /* XSUM_XXH64_testdata[2999] */
    { 1500, 0x0000000000000000ULL, 0x49560C97A8F0B46DULL }, /* XSUM_XXH64_testdata[3000] */
    { 1500, 0x000000009E3779B1ULL, 0xBE35D3678E4AEDF0ULL }, /* XSUM_XXH64_testdata[3001] */
    { 1501, 0x0000000000000000ULL, 0xF8F70D98A391B902ULL }, /* XSUM_XXH64_testdata[3002] */
    { 1501, 0x000000009E3779B1ULL, 0x35D59E740161C82EULL }, /* XSUM_XXH64_testdata[3003] */
    { 1502, 0x0000000000000000ULL, 0xDCC846D54234A2A9ULL }, /* XSUM_XXH64_testdata[3004] */
    { 1502, 0x000000009E3779B1ULL, 0x57001FF0F0ED9F15ULL }, /* XSUM_XXH64_testdata[3005] */
    { 1503, 0x0000000000000000ULL, 0x1945AF0AB4941D24ULL }, /* XSUM_XXH64_testdata[3006] */
    { 1503, 0x000000009E3779B1ULL, 0xC297BE0E382A662AULL }, /* XSUM_XXH64_testdata[3007] */
    { 1504, 0x0000000000000000ULL, 0x140DAF514AAD15B2ULL }, /* XSUM_XXH64_testdata[3008] */
    { 1504, 0x000000009E3779B1ULL, 0x9EF4891CA7E01BD0ULL }, /* XSUM_XXH64_testdata[3009] */
    { 1505, 0x0000000000000000ULL, 0x9561D082D9630409ULL }, /* XSUM_XXH64_testdata[3010] */
    { 1505, 0x000000009E3779B1ULL, 0x5D00D4D29A7BF531ULL }, /* XSUM_XXH64_testdata[3011] */
    { 1506, 0x0000000000000000ULL, 0x5190DC70ACD67724ULL }, /* XSUM_XXH64_testdata[3012] */
    { 1506, 0x000000009E3779B1ULL, 0xA96FDC925CE8F8FCULL }, /* XSUM_XXH64_testdata[3013] */
    { 1507, 0x0000000000000000ULL, 0x8E2BF8EACF31556AULL }, /* XSUM_XXH64_testdata[3014] */
    { 1507, 0x000000009E3779B1ULL, 0x03C9362F5DAB21E9ULL }, /* XSUM_XXH64_testdata[3015] */
    { 1508, 0x0000000000000000ULL, 0x217DB2B9AFAAD59BULL }, /* XSUM_XXH64_testdata[3016] */
    { 1508, 0x000000009E3779B1ULL, 0xCF853125C93523BFULL }, /* XSUM_XXH64_testdata[3017] */
    { 1509, 0x0000000000000000ULL, 0xF77FE60B27C52651ULL }, /* XSUM_XXH64_testdata[3018] */
    { 1509, 0x000000009E3779B1ULL, 0xC614821DCC4F07CCULL }, /* XSUM_XXH64_testdata[3019] */
    { 1510, 0x0000000000000000ULL, 0xEFE0D0198C565516ULL }, /* XSUM_XXH64_testdata[3020] */
    { 1510, 0x000000009E3779B1ULL, 0xA0887694F684205FULL }, /* XSUM_XXH64_testdata[3021] */
    { 1511, 0x0000000000000000ULL, 0x9E614D0CA40E1302ULL }, /* XSUM_XXH64_testdata[3022] */
    { 1511, 0x000000009E3779B1ULL, 0x52ED8B09FC3CF69CULL }, /* XSUM_XXH64_testdata[3023] */
    { 1512, 0x0000000000000000ULL, 0x19A560C966281136ULL }, /* XSUM_XXH64_testdata[3024] */
    { 1512, 0x000000009E3779B1ULL, 0xDE06A3D32E757E63ULL }, /* XSUM_XXH64_testdata[3025] */
    { 1513, 0x0000000000000000ULL, 0x5C7D84A24F21BD7AULL }, /* XSUM_XXH64_testdata[3026] */
    { 1513, 0x000000009E3779B1ULL, 0x68C92B8E68FE37C1ULL }, /* XSUM_XXH64_testdata[3027] */
    { 1514, 0x0000000000000000ULL, 0x549A43A8DF101AB2ULL }, /* XSUM_XXH64_testdata[3028] */
    { 1514, 0x000000009E3779B1ULL, 0x84570A879E8BDE41ULL }, /* XSUM_XXH64_testdata[3029] */
    { 1515, 0x0000000000000000ULL, 0x261A16A715DD3A2CULL }, /* XSUM_XXH64_testdata[3030] */
    { 1515, 0x000000009E3779B1ULL, 0xDB81470AAB634064ULL }, /* XSUM_XXH64_testdata[3031] */
    { 1516, 0x0000000000000000ULL, 0x99205CC8604F4359ULL }, /* XSUM_XXH64_testdata[3032] */
    { 1516, 0x000000009E3779B1ULL, 0xEFFFF995FE389291ULL }, /* XSUM_XXH64_testdata[3033] */
    { 1517, 0x0000000000000000ULL, 0xB80FD45BD6EFAA4FULL }, /* XSUM_XXH64_testdata[3034] */
    { 1517, 0x000000009E3779B1ULL, 0x487E7F148DCDAA5CULL }, /* XSUM_XXH64_testdata[3035] */
    { 1518, 0x0000000000000000ULL, 0x7D89BBEE9BBEF1C2ULL }, /* XSUM_XXH64_testdata[3036] */
    { 1518, 0x000000009E3779B1ULL, 0xD829A4AFE2E74E6AULL }, /* XSUM_XXH64_testdata[3037] */
    { 1519, 0x0000000000000000ULL, 0x25D1A26DBB0DC766ULL }, /* XSUM_XXH64_testdata[3038] */
    { 1519, 0x000000009E3779B1ULL, 0x51564685DEC4644DULL }, /* XSUM_XXH64_testdata[3039] */
    { 1520, 0x0000000000000000ULL, 0x0410748EEB5D5C22ULL }, /* XSUM_XXH64_testdata[3040] */
    { 1520, 0x000000009E3779B1ULL, 0x75CE75D294B3D04EULL }, /* XSUM_XXH64_testdata[3041] */
    { 1521, 0x0000000000000000ULL, 0xA8DFCD137707184EULL }, /* XSUM_XXH64_testdata[3042] */
    { 1521, 0x000000009E3779B1ULL, 0x6C0F885BFE39671EULL }, /* XSUM_XXH64_testdata[3043] */
    { 1522, 0x0000000000000000ULL, 0xDDC03FE01448EF49ULL }, /* XSUM_XXH64_testdata[3044] */
    { 1522, 0x000000009E3779B1ULL, 0xF3DE000FD7CCA6C8ULL }, /* XSUM_XXH64_testdata[3045] */
    { 1523, 0x0000000000000000ULL, 0xB4DF1A01C919AC8EULL }, /* XSUM_XXH64_testdata[3046] */
    { 1523, 0x000000009E3779B1ULL, 0x3AA57E8D2536BE21ULL }, /* XSUM_XXH64_testdata[3047] */
    { 1524, 0x0000000000000000ULL, 0xCD95EC15CB6D6E8DULL }, /* XSUM_XXH64_testdata[3048] */
    { 1524, 0x000000009E3779B1ULL, 0xE017E1103B241C15ULL }, /* XSUM_XXH64_testdata[3049] */
    { 1525, 0x0000000000000000ULL, 0xD2ECF6A326B27053ULL }, /* XSUM_XXH64_testdata[3050] */
    { 1525, 0x000000009E3779B1ULL, 0xE92ED4414E528E5AULL }, /* XSUM_XXH64_testdata[3051] */
    { 1526, 0x0000000000000000ULL, 0xD3FDC6B4B5A4EF92ULL }, /* XSUM_XXH64_testdata[3052] */
    { 1526, 0x000000009E3779B1ULL, 0x67E70AF6B2EFDE98ULL }, /* XSUM_XXH64_testdata[3053] */
    { 1527, 0x0000000000000000ULL, 0xE33B29BC261879F4ULL }, /* XSUM_XXH64_testdata[3054] */
    { 1527, 0x000000009E3779B1ULL, 0xC83AF2EE8BD9C666ULL }, /* XSUM_XXH64_testdata[3055] */
    { 1528, 0x0000000000000000ULL, 0xB1F1AB2114E0467EULL }, /* XSUM_XXH64_testdata[3056] */
    { 1528, 0x000000009E3779B1ULL, 0x5A0E27DD8B0DEB6BULL }, /* XSUM_XXH64_testdata[3057] */
    { 1529, 0x0000000000000000ULL, 0xE5B01782BD8D2103ULL }, /* XSUM_XXH64_testdata[3058] */
    { 1529, 0x000000009E3779B1ULL, 0x42ECC0C12EC1C396ULL }, /* XSUM_XXH64_testdata[3059] */
    { 1530, 0x0000000000000000ULL, 0x646670CF7FB6B60AULL }, /* XSUM_XXH64_testdata[3060] */
    { 1530, 0x000000009E3779B1ULL, 0x211B9A0BD0481ECAULL }, /* XSUM_XXH64_testdata[3061] */
    { 1531, 0x0000000000000000ULL, 0xD3930BB3B9FAC74AULL }, /* XSUM_XXH64_testdata[3062] */
    { 1531, 0x000000009E3779B1ULL, 0x08267ED1D7853CB2ULL }, /* XSUM_XXH64_testdata[3063] */
    { 1532, 0x0000000000000000ULL, 0x2069C958E2831898ULL }, /* XSUM_XXH64_testdata[3064] */
    { 1532, 0x000000009E3779B1ULL, 0xB5B8F1289B0974D0ULL }, /* XSUM_XXH64_testdata[3065] */
    { 1533, 0x0000000000000000ULL, 0xF6B03D02363C8B8DULL }, /* XSUM_XXH64_testdata[3066] */
    { 1533, 0x000000009E3779B1ULL, 0x95B05185B655D15BULL }, /* XSUM_XXH64_testdata[3067] */
    { 1534, 0x0000000000000000ULL, 0x54BA2E9539684FEBULL }, /* XSUM_XXH64_testdata[3068] */
    { 1534, 0x000000009E3779B1ULL, 0xFE4A363F9830E8F7ULL }, /* XSUM_XXH64_testdata[3069] */
    { 1535, 0x0000000000000000ULL, 0xB0A26C84A6D11794ULL }, /* XSUM_XXH64_testdata[3070] */
    { 1535, 0x000000009E3779B1ULL, 0xCEC2818C895599C7ULL }, /* XSUM_XXH64_testdata[3071] */
    { 1536, 0x0000000000000000ULL, 0x93BF99716366979FULL }, /* XSUM_XXH64_testdata[3072] */
    { 1536, 0x000000009E3779B1ULL, 0x7E445D56CB1C8732ULL }, /* XSUM_XXH64_testdata[3073] */
    { 1537, 0x0000000000000000ULL, 0x9FC5D763D81BD858ULL }, /* XSUM_XXH64_testdata[3074] */
    { 1537, 0x000000009E3779B1ULL, 0x52068B9CCF4C0277ULL }, /* XSUM_XXH64_testdata[3075] */
    { 1538, 0x0000000000000000ULL, 0x286A6D3BCE9EB9E5ULL }, /* XSUM_XXH64_testdata[3076] */
    { 1538, 0x000000009E3779B1ULL, 0xC04C9A4F363F6E29ULL }, /* XSUM_XXH64_testdata[3077] */
    { 1539, 0x0000000000000000ULL, 0x9610AFA59919D4BAULL }, /* XSUM_XXH64_testdata[3078] */
    { 1539, 0x000000009E3779B1ULL, 0x4F4929DF19379AAFULL }, /* XSUM_XXH64_testdata[3079] */
    { 1540, 0x0000000000000000ULL, 0xEEEC97C382795547ULL }, /* XSUM_XXH64_testdata[3080] */
    { 1540, 0x000000009E3779B1ULL, 0x2EAA8EC92FF8606DULL }, /* XSUM_XXH64_testdata[3081] */
    { 1541, 0x0000000000000000ULL, 0xC377BAA07CE1DD52ULL }, /* XSUM_XXH64_testdata[3082] */
    { 1541, 0x000000009E3779B1ULL, 0xEB796C83C9161003ULL }, /* XSUM_XXH64_testdata[3083] */
    { 1542, 0x0000000000000000ULL, 0x6189163679466377ULL }, /* XSUM_XXH64_testdata[3084] */
    { 1542, 0x000000009E3779B1ULL, 0xC795510F3036FF96ULL }, /* XSUM_XXH64_testdata[3085] */
    { 1543, 0x0000000000000000ULL, 0x8C0B48F97001490AULL }, /* XSUM_XXH64_testdata[3086] */
    { 1543, 0x000000009E3779B1ULL, 0x6C55158C1900B04BULL }, /* XSUM_XXH64_testdata[3087] */
    { 1544, 0x0000000000000000ULL, 0x10848522BA467A66ULL }, /* XSUM_XXH64_testdata[3088] */
    { 1544, 0x000000009E3779B1ULL, 0xAEBF7D36EEFC2568ULL }, /* XSUM_XXH64_testdata[3089] */
    { 1545, 0x0000000000000000ULL, 0xC36279AFB7971084ULL }, /* XSUM_XXH64_testdata[3090] */
    { 1545, 0x000000009E3779B1ULL, 0xBB09452E4DBC5D4FULL }, /* XSUM_XXH64_testdata[3091] */
    { 1546, 0x0000000000000000ULL, 0xF45A7E196D676EACULL }, /* XSUM_XXH64_testdata[3092] */
    { 1546, 0x000000009E3779B1ULL, 0xA58E3E21633C2833ULL }, /* XSUM_XXH64_testdata[3093] */
    { 1547, 0x0000000000000000ULL, 0x005C53B4E2B5F377ULL }, /* XSUM_XXH64_testdata[3094] */
    { 1547, 0x000000009E3779B1ULL, 0x943C7C8DDB84A1D2ULL }, /* XSUM_XXH64_testdata[3095] */
    { 1548, 0x0000000000000000ULL, 0x7D01D4EE629526A4ULL }, /* XSUM_XXH64_testdata[3096] */
    { 1548, 0x000000009E3779B1ULL, 0x11FC97DD54BFFF8FULL }, /* XSUM_XXH64_testdata[3097] */
    { 1549, 0x0000000000000000ULL, 0x0E4043E8E33564C7ULL }, /* XSUM_XXH64_testdata[3098] */
    { 1549, 0x000000009E3779B1ULL, 0x2C995886C7EA17E7ULL }, /* XSUM_XXH64_testdata[3099] */
    { 1550, 0x0000000000000000ULL, 0xF8021D46BA65DF46ULL }, /* XSUM_XXH64_testdata[3100] */
    { 1550, 0x000000009E3779B1ULL, 0x91E0272C80001330ULL }, /* XSUM_XXH64_testdata[3101] */
    { 1551, 0x0000000000000000ULL, 0xA1E2458DA689D9E0ULL }, /* XSUM_XXH64_testdata[3102] */
    { 1551, 0x000000009E3779B1ULL, 0xA6B710E397E83EE2ULL }, /* XSUM_XXH64_testdata[3103] */
    { 1552, 0x0000000000000000ULL, 0xC2B34609E3A5DC14ULL }, /* XSUM_XXH64_testdata[3104] */
    { 1552, 0x000000009E3779B1ULL, 0xF320C3DE0B1EAB67ULL }, /* XSUM_XXH64_testdata[3105] */
    { 1553, 0x0000000000000000ULL, 0xB43D8867AEE8AB7FULL }, /* XSUM_XXH64_testdata[3106] */
    { 1553, 0x000000009E3779B1ULL, 0xA52347876530CFD9ULL }, /* XSUM_XXH64_testdata[3107] */
    { 1554, 0x0000000000000000ULL, 0x16FF1F94505413E3ULL }, /* XSUM_XXH64_testdata[3108] */
    { 1554, 0x000000009E3779B1ULL, 0xB2496CB93C48C094ULL }, /* XSUM_XXH64_testdata[3109] */
    { 1555, 0x0000000000000000ULL, 0x189FCC4C4E4781BAULL }, /* XSUM_XXH64_testdata[3110] */
    { 1555, 0x000000009E3779B1ULL, 0xA7759F8B7D2DCABBULL }, /* XSUM_XXH64_testdata[3111] */
    { 1556, 0x0000000000000000ULL, 0x51C94AF7D2982AD7ULL }, /* XSUM_XXH64_testdata[3112] */
    { 1556, 0x000000009E3779B1ULL, 0xB8BDBF48798BF342ULL }, /* XSUM_XXH64_testdata[3113] */
    { 1557, 0x0000000000000000ULL, 0x8F07C1447350EC53ULL }, /* XSUM_XXH64_testdata[3114] */
    { 1557, 0x000000009E3779B1ULL, 0x07523DED634377B7ULL }, /* XSUM_XXH64_testdata[3115] */
    { 1558, 0x0000000000000000ULL, 0x64A8CDEC92FAD967ULL }, /* XSUM_XXH64_testdata[3116] */
    { 1558, 0x000000009E3779B1ULL, 0x67FE403B54CDDC5FULL }, /* XSUM_XXH64_testdata[3117] */
    { 1559, 0x0000000000000000ULL, 0x8D623B73C2F588A0ULL }, /* XSUM_XXH64_testdata[3118] */
    { 1559, 0x000000009E3779B1ULL, 0x451D946E1A1FB9DFULL }, /* XSUM_XXH64_testdata[3119] */
    { 1560, 0x0000000000000000ULL, 0x60C695F43F54B472ULL }, /* XSUM_XXH64_testdata[3120] */
    { 1560, 0x000000009E3779B1ULL, 0x453847F38F311A8CULL }, /* XSUM_XXH64_testdata[3121] */
    { 1561, 0x0000000000000000ULL, 0xAE980B4DDFD44E42ULL }, /* XSUM_XXH64_testdata[3122] */
    { 1561, 0x000000009E3779B1ULL, 0x1C2992ED0ECD4EF3ULL }, /* XSUM_XXH64_testdata[3123] */
    { 1562, 0x0000000000000000ULL, 0x585C095BEFD8EAC9ULL }, /* XSUM_XXH64_testdata[3124] */
    { 1562, 0x000000009E3779B1ULL, 0x3F9984D7A7167C0DULL }, /* XSUM_XXH64_testdata[3125] */
    { 1563, 0x0000000000000000ULL, 0x743C525FEC711C01ULL }, /* XSUM_XXH64_testdata[3126] */
    { 1563, 0x000000009E3779B1ULL, 0xAB26476612988EFFULL }, /* XSUM_XXH64_testdata[3127] */
    { 1564, 0x0000000000000000ULL, 0x42A4CB3320FF979AULL }, /* XSUM_XXH64_testdata[3128] */
    { 1564, 0x000000009E3779B1ULL, 0x106B29B01FF34ED4ULL }, /* XSUM_XXH64_testdata[3129] */
    { 1565, 0x0000000000000000ULL, 0xB0F830C7FA264EDFULL }, /* XSUM_XXH64_testdata[3130] */
    { 1565, 0x000000009E3779B1ULL, 0x4DAD9D8019E55A12ULL }, /* XSUM_XXH64_testdata[3131] */
    { 1566, 0x0000000000000000ULL, 0xEB1F580DDB952B6CULL }, /* XSUM_XXH64_testdata[3132] */
    { 1566, 0x000000009E3779B1ULL, 0x171CF524B44C545BULL }, /* XSUM_XXH64_testdata[3133] */
    { 1567, 0x0000000000000000ULL, 0xBEA76E6CFBF6D8A4ULL }, /* XSUM_XXH64_testdata[3134] */
    { 1567, 0x000000009E3779B1ULL, 0x55FFA73D711616A4ULL }, /* XSUM_XXH64_testdata[3135] */
    { 1568, 0x0000000000000000ULL, 0x0C56F9DC52C64626ULL }, /* XSUM_XXH64_testdata[3136] */
    { 1568, 0x000000009E3779B1ULL, 0x9ED44FAD3502E08BULL }, /* XSUM_XXH64_testdata[3137] */
    { 1569, 0x0000000000000000ULL, 0x74BB475D124451F2ULL }, /* XSUM_XXH64_testdata[3138] */
    { 1569, 0x000000009E3779B1ULL, 0x6D5697379E50ABDDULL }, /* XSUM_XXH64_testdata[3139] */
    { 1570, 0x0000000000000000ULL, 0x3459CFA4C466B401ULL }, /* XSUM_XXH64_testdata[3140] */
    { 1570, 0x000000009E3779B1ULL, 0x58AF1D4DE8A081E9ULL }, /* XSUM_XXH64_testdata[3141] */
    { 1571, 0x0000000000000000ULL, 0x42EE4433929FB9C6ULL }, /* XSUM_XXH64_testdata[3142] */
    { 1571, 0x000000009E3779B1ULL, 0x6D23E9AC6BD0804EULL }, /* XSUM_XXH64_testdata[3143] */
    { 1572, 0x0000000000000000ULL, 0xBE6AB6819A1B14B9ULL }, /* XSUM_XXH64_testdata[3144] */
    { 1572, 0x000000009E3779B1ULL, 0x27D38A33FDBB2AE5ULL }, /* XSUM_XXH64_testdata[3145] */
    { 1573, 0x0000000000000000ULL, 0xA2D8D1C4B8CEBFAEULL }, /* XSUM_XXH64_testdata[3146] */
    { 1573, 0x000000009E3779B1ULL, 0xF2A66ABD6B0145E9ULL }, /* XSUM_XXH64_testdata[3147] */
    { 1574, 0x0000000000000000ULL, 0xF8EAAA44A6BFD85CULL }, /* XSUM_XXH64_testdata[3148] */
    { 1574, 0x000000009E3779B1ULL, 0xE440BFD46148B50CULL }, /* XSUM_XXH64_testdata[3149] */
    { 1575, 0x0000000000000000ULL, 0xCC43F254AFBF800EULL }, /* XSUM_XXH64_testdata[3150] */
    { 1575, 0x000000009E3779B1ULL, 0x5495F19D53F7D925ULL }, /* XSUM_XXH64_testdata[3151] */
    { 1576, 0x0000000000000000ULL, 0xB8D18F5980CEC6BEULL }, /* XSUM_XXH64_testdata[3152] */
    { 1576, 0x000000009E3779B1ULL, 0x40B27A51F0B3E7DEULL }, /* XSUM_XXH64_testdata[3153] */
    { 1577, 0x0000000000000000ULL, 0x4CD7B81A400F8189ULL }, /* XSUM_XXH64_testdata[3154] */
    { 1577, 0x000000009E3779B1ULL, 0xF50C038651B4F7A0ULL }, /* XSUM_XXH64_testdata[3155] */
    { 1578, 0x0000000000000000ULL, 0xEF03C71CB8F2D000ULL }, /* XSUM_XXH64_testdata[3156] */
    { 1578, 0x000000009E3779B1ULL, 0x8B5FD6C755A68609ULL }, /* XSUM_XXH64_testdata[3157] */
    { 1579, 0x0000000000000000ULL, 0x62B67C941C552C28ULL }, /* XSUM_XXH64_testdata[3158] */
    { 1579, 0x000000009E3779B1ULL, 0x3C0789BB1801D2DEULL }, /* XSUM_XXH64_testdata[3159] */
    { 1580, 0x0000000000000000ULL, 0xF33379DC817BF81BULL }, /* XSUM_XXH64_testdata[3160] */
    { 1580, 0x000000009E3779B1ULL, 0xBD9393A65FCAC2FFULL }, /* XSUM_XXH64_testdata[3161] */
    { 1581, 0x0000000000000000ULL, 0xF9715C825CE09491ULL }, /* XSUM_XXH64_testdata[3162] */
    { 1581, 0x000000009E3779B1ULL, 0xBAAFD2B30168DE05ULL }, /* XSUM_XXH64_testdata[3163] */
    { 1582, 0x0000000000000000ULL, 0x4B314D195D75CC70ULL }, /* XSUM_XXH64_testdata[3164] */
    { 1582, 0x000000009E3779B1ULL, 0x6AE7B8E9F9C615E2ULL }, /* XSUM_XXH64_testdata[3165] */
    { 1583, 0x0000000000000000ULL, 0x46382D7DFAFCA254ULL }, /* XSUM_XXH64_testdata[3166] */
    { 1583, 0x000000009E3779B1ULL, 0xD9FB78478622157CULL }, /* XSUM_XXH64_testdata[3167] */
    { 1584, 0x0000000000000000ULL, 0x193C567AFDCE3DECULL }, /* XSUM_XXH64_testdata[3168] */
    { 1584, 0x000000009E3779B1ULL, 0x4564C95AB688D1B5ULL }, /* XSUM_XXH64_testdata[3169] */
    { 1585, 0x0000000000000000ULL, 0xCC54A68E3551DAB2ULL }, /* XSUM_XXH64_testdata[3170] */
    { 1585, 0x000000009E3779B1ULL, 0x8EB928FC7D44A911ULL }, /* XSUM_XXH64_testdata[3171] */
    { 1586, 0x0000000000000000ULL, 0x090FCEF6F92B0F3FULL }, /* XSUM_XXH64_testdata[3172] */
    { 1586, 0x000000009E3779B1ULL, 0x103F7599B36BD36DULL }, /* XSUM_XXH64_testdata[3173] */
    { 1587, 0x0000000000000000ULL, 0x05796452679CEA0DULL }, /* XSUM_XXH64_testdata[3174] */
    { 1587, 0x000000009E3779B1ULL, 0x7D92BC205561E616ULL }, /* XSUM_XXH64_testdata[3175] */
    { 1588, 0x0000000000000000ULL, 0x02253E746FC15B3FULL }, /* XSUM_XXH64_testdata[3176] */
    { 1588, 0x000000009E3779B1ULL, 0x3A35E5AAEFD3EB40ULL }, /* XSUM_XXH64_testdata[3177] */
    { 1589, 0x0000000000000000ULL, 0x2307DC21C2837496ULL }, /* XSUM_XXH64_testdata[3178] */
    { 1589, 0x000000009E3779B1ULL, 0x695ED2350A995E40ULL }, /* XSUM_XXH64_testdata[3179] */
    { 1590, 0x0000000000000000ULL, 0xFC7711C90DE93C22ULL }, /* XSUM_XXH64_testdata[3180] */
    { 1590, 0x000000009E3779B1ULL, 0x14D1EAD13B3F5219ULL }, /* XSUM_XXH64_testdata[3181] */
    { 1591, 0x0000000000000000ULL, 0x7FD3951CDDBE0BE9ULL }, /* XSUM_XXH64_testdata[3182] */
    { 1591, 0x000000009E3779B1ULL, 0xEA6B0D12249D4D56ULL }, /* XSUM_XXH64_testdata[3183] */
    { 1592, 0x0000000000000000ULL, 0xB9D5C6943B50DFE2ULL }, /* XSUM_XXH64_testdata[3184] */
    { 1592, 0x000000009E3779B1ULL, 0x7842AF14A4F83CFBULL }, /* XSUM_XXH64_testdata[3185] */
    { 1593, 0x0000000000000000ULL, 0xBC180FE1656F115CULL }, /* XSUM_XXH64_testdata[3186] */
    { 1593, 0x000000009E3779B1ULL, 0xF049D5310D20D841ULL }, /* XSUM_XXH64_testdata[3187] */
    { 1594, 0x0000000000000000ULL, 0xEF818D5332AEE3F9ULL }, /* XSUM_XXH64_testdata[3188] */
    { 1594, 0x000000009E3779B1ULL, 0x55F7DFCA9870A7BCULL }, /* XSUM_XXH64_testdata[3189] */
    { 1595, 0x0000000000000000ULL, 0x9A2E28E971D74BAFULL }, /* XSUM_XXH64_testdata[3190] */
    { 1595, 0x000000009E3779B1ULL, 0x1C0143F3594AED4BULL }, /* XSUM_XXH64_testdata[3191] */
    { 1596, 0x0000000000000000ULL, 0x2B35448A45DF6294ULL }, /* XSUM_XXH64_testdata[3192] */
    { 1596, 0x000000009E3779B1ULL, 0x00FAAA174712FF8AULL }, /* XSUM_XXH64_testdata[3193] */
    { 1597, 0x0000000000000000ULL, 0xCBCEEB8DDEF9CCB4ULL }, /* XSUM_XXH64_testdata[3194] */
    { 1597, 0x000000009E3779B1ULL, 0xD79C67A53A94CA38ULL }, /* XSUM_XXH64_testdata[3195] */
    { 1598, 0x0000000000000000ULL, 0xC60F8FB2BE7D4317ULL }, /* XSUM_XXH64_testdata[3196] */
    { 1598, 0x000000009E3779B1ULL, 0x1CF14314FE8BE210ULL }, /* XSUM_XXH64_testdata[3197] */
    { 1599, 0x0000000000000000ULL, 0x37AE9CF7A5E15FA5ULL }, /* XSUM_XXH64_testdata[3198] */
    { 1599, 0x000000009E3779B1ULL, 0x3791ADC4DE86513BULL }, /* XSUM_XXH64_testdata[3199] */
    { 1600, 0x0000000000000000ULL, 0x6C6DD95327AD9AB8ULL }, /* XSUM_XXH64_testdata[3200] */
    { 1600, 0x000000009E3779B1ULL, 0x3E37F89EC2EFB644ULL }, /* XSUM_XXH64_testdata[3201] */
    { 1601, 0x0000000000000000ULL, 0x907803F3AA9FB862ULL }, /* XSUM_XXH64_testdata[3202] */
    { 1601, 0x000000009E3779B1ULL, 0xD6FDB6B002A596C3ULL }, /* XSUM_XXH64_testdata[3203] */
    { 1602, 0x0000000000000000ULL, 0x64537A0034130DA7ULL }, /* XSUM_XXH64_testdata[3204] */
    { 1602, 0x000000009E3779B1ULL, 0x35A80F8EA516EDBAULL }, /* XSUM_XXH64_testdata[3205] */
    { 1603, 0x0000000000000000ULL, 0x0450A0D72CCBAD01ULL }, /* XSUM_XXH64_testdata[3206] */
    { 1603, 0x000000009E3779B1ULL, 0x1A2987931EFF8C26ULL }, /* XSUM_XXH64_testdata[3207] */
    { 1604, 0x0000000000000000ULL, 0xA44A0FED7FD8A11DULL }, /* XSUM_XXH64_testdata[3208] */
    { 1604, 0x000000009E3779B1ULL, 0x178A03C8E664AE08ULL }, /* XSUM_XXH64_testdata[3209] */
    { 1605, 0x0000000000000000ULL, 0x21536C43FA9ABAECULL }, /* XSUM_XXH64_testdata[3210] */
    { 1605, 0x000000009E3779B1ULL, 0xDC9B93185FFCF61FULL }, /* XSUM_XXH64_testdata[3211] */
    { 1606, 0x0000000000000000ULL, 0x200300F3BDECE679ULL }, /* XSUM_XXH64_testdata[3212] */
    { 1606, 0x000000009E3779B1ULL, 0x8A977089E14004DCULL }, /* XSUM_XXH64_testdata[3213] */
    { 1607, 0x0000000000000000ULL, 0xEF11D3D95E4E9294ULL }, /* XSUM_XXH64_testdata[3214] */
    { 1607, 0x000000009E3779B1ULL, 0xFDD068F60B2BC87EULL }, /* XSUM_XXH64_testdata[3215] */
    { 1608, 0x0000000000000000ULL, 0xFB6D69DD48D705A6ULL }, /* XSUM_XXH64_testdata[3216] */
    { 1608, 0x000000009E3779B1ULL, 0x5388ACBE24785350ULL }, /* XSUM_XXH64_testdata[3217] */
    { 1609, 0x0000000000000000ULL, 0x1E8A12632A3E3559ULL }, /* XSUM_XXH64_testdata[3218] */
    { 1609, 0x000000009E3779B1ULL, 0x5B4560D30A34F10CULL }, /* XSUM_XXH64_testdata[3219] */
    { 1610, 0x0000000000000000ULL, 0x9F86E451D3613F2DULL }, /* XSUM_XXH64_testdata[3220] */
    { 1610, 0x000000009E3779B1ULL, 0x96E9B33D44BF5D32ULL }, /* XSUM_XXH64_testdata[3221] */
    { 1611, 0x0000000000000000ULL, 0x7061A3E327AAB9A0ULL }, /* XSUM_XXH64_testdata[3222] */
    { 1611, 0x000000009E3779B1ULL, 0x2BB881112C9614F5ULL }, /* XSUM_XXH64_testdata[3223] */
    { 1612, 0x0000000000000000ULL, 0xAB8BA282F8F8AC43ULL }, /* XSUM_XXH64_testdata[3224] */
    { 1612, 0x000000009E3779B1ULL, 0x5264565685763403ULL }, /* XSUM_XXH64_testdata[3225] */
    { 1613, 0x0000000000000000ULL, 0x99C51EC586C4E8DFULL }, /* XSUM_XXH64_testdata[3226] */
    { 1613, 0x000000009E3779B1ULL, 0x3C2F8F920CB53EDCULL }, /* XSUM_XXH64_testdata[3227] */
    { 1614, 0x0000000000000000ULL, 0x49B3A0D6F1B619FAULL }, /* XSUM_XXH64_testdata[3228] */
    { 1614, 0x000000009E3779B1ULL, 0xC17BE04BBEEA1E89ULL }, /* XSUM_XXH64_testdata[3229] */
    { 1615, 0x0000000000000000ULL, 0x54EE93FDA11B6508ULL }, /* XSUM_XXH64_testdata[3230] */
    { 1615, 0x000000009E3779B1ULL, 0x2850CF718384D587ULL }, /* XSUM_XXH64_testdata[3231] */
    { 1616, 0x0000000000000000ULL, 0xC0A298ABFCAF2D99ULL }, /* XSUM_XXH64_testdata[3232] */
    { 1616, 0x000000009E3779B1ULL, 0x8912F04097F3062BULL }, /* XSUM_XXH64_testdata[3233] */
    { 1617, 0x0000000000000000ULL, 0x9565A5026C4A889DULL }, /* XSUM_XXH64_testdata[3234] */
    { 1617, 0x000000009E3779B1ULL, 0xBB1B629837C85C8EULL }, /* XSUM_XXH64_testdata[3235] */
    { 1618, 0x0000000000000000ULL, 0xB09CA9A19B1CB2A7ULL }, /* XSUM_XXH64_testdata[3236] */
    { 1618, 0x000000009E3779B1ULL, 0x0F65114B5A7292B0ULL }, /* XSUM_XXH64_testdata[3237] */
    { 1619, 0x0000000000000000ULL, 0xC16ABB4F5D05D510ULL }, /* XSUM_XXH64_testdata[3238] */
    { 1619, 0x000000009E3779B1ULL, 0x02D429A89937808DULL }, /* XSUM_XXH64_testdata[3239] */
    { 1620, 0x0000000000000000ULL, 0x3BB888CA930151C2ULL }, /* XSUM_XXH64_testdata[3240] */
    { 1620, 0x000000009E3779B1ULL, 0x3776AE69D3929F2EULL }, /* XSUM_XXH64_testdata[3241] */
    { 1621, 0x0000000000000000ULL, 0x6B161AF813DE14E0ULL }, /* XSUM_XXH64_testdata[3242] */
    { 1621, 0x000000009E3779B1ULL, 0xE4E901EB765CC055ULL }, /* XSUM_XXH64_testdata[3243] */
    { 1622, 0x0000000000000000ULL, 0x229C1A5F35070B6AULL }, /* XSUM_XXH64_testdata[3244] */
    { 1622, 0x000000009E3779B1ULL, 0x3BC4DD9FAD5D4E0EULL }, /* XSUM_XXH64_testdata[3245] */
    { 1623, 0x0000000000000000ULL, 0x94E1A54B5F09482DULL }, /* XSUM_XXH64_testdata[3246] */
    { 1623, 0x000000009E3779B1ULL, 0x8B8361A4293F42E3ULL }, /* XSUM_XXH64_testdata[3247] */
    { 1624, 0x0000000000000000ULL, 0xB79965DAA3E11D8FULL }, /* XSUM_XXH64_testdata[3248] */
    { 1624, 0x000000009E3779B1ULL, 0x39D9421CAB673FE0ULL }, /* XSUM_XXH64_testdata[3249] */
    { 1625, 0x0000000000000000ULL, 0x636C06CDA0161CB0ULL }, /* XSUM_XXH64_testdata[3250] */
    { 1625, 0x000000009E3779B1ULL, 0x771061B116642DDEULL }, /* XSUM_XXH64_testdata[3251] */
    { 1626, 0x0000000000000000ULL, 0xDA3F8A4D83AF7E97ULL }, /* XSUM_XXH64_testdata[3252] */
    { 1626, 0x000000009E3779B1ULL, 0x638E932AE98CCCA8ULL }, /* XSUM_XXH64_testdata[3253] */
    { 1627, 0x0000000000000000ULL, 0xB1C532D9C70C068BULL }, /* XSUM_XXH64_testdata[3254] */
    { 1627, 0x000000009E3779B1ULL, 0x048D897FC8BDE7BAULL }, /* XSUM_XXH64_testdata[3255] */
    { 1628, 0x0000000000000000ULL, 0x6ACCADAB0F8EF249ULL }, /* XSUM_XXH64_testdata[3256] */
    { 1628, 0x000000009E3779B1ULL, 0x3D5FD981B4CC16D3ULL }, /* XSUM_XXH64_testdata[3257] */
    { 1629, 0x0000000000000000ULL, 0x207F623CE92C4BD3ULL }, /* XSUM_XXH64_testdata[3258] */
    { 1629, 0x000000009E3779B1ULL, 0x34179AE45B7510AEULL }, /* XSUM_XXH64_testdata[3259] */
    { 1630, 0x0000000000000000ULL, 0xE96B777D4D364C96ULL }, /* XSUM_XXH64_testdata[3260] */
    { 1630, 0x000000009E3779B1ULL, 0x18ED908117AE1D73ULL }, /* XSUM_XXH64_testdata[3261] */
    { 1631, 0x0000000000000000ULL, 0x204424CE5002EAA5ULL }, /* XSUM_XXH64_testdata[3262] */
    { 1631, 0x000000009E3779B1ULL, 0xAC3539D300323399ULL }, /* XSUM_XXH64_testdata[3263] */
    { 1632, 0x0000000000000000ULL, 0xCE58A2CBA4494E66ULL }, /* XSUM_XXH64_testdata[3264] */
    { 1632, 0x000000009E3779B1ULL, 0xD722A1D00AC10A2FULL }, /* XSUM_XXH64_testdata[3265] */
    { 1633, 0x0000000000000000ULL, 0x49053FC53A197E2BULL }, /* XSUM_XXH64_testdata[3266] */
    { 1633, 0x000000009E3779B1ULL, 0x520A424E8E369406ULL }, /* XSUM_XXH64_testdata[3267] */
    { 1634, 0x0000000000000000ULL, 0x4F80E0D668BED51DULL }, /* XSUM_XXH64_testdata[3268] */
    { 1634, 0x000000009E3779B1ULL, 0x35F901BE3880E537ULL }, /* XSUM_XXH64_testdata[3269] */
    { 1635, 0x0000000000000000ULL, 0xC581E64E62BE5EB7ULL }, /* XSUM_XXH64_testdata[3270] */
    { 1635, 0x000000009E3779B1ULL, 0xAEBB7AD8588E0E56ULL }, /* XSUM_XXH64_testdata[3271] */
    { 1636, 0x0000000000000000ULL, 0xB4B8AAD2EBCAF803ULL }, /* XSUM_XXH64_testdata[3272] */
    { 1636, 0x000000009E3779B1ULL, 0xBD8DA8D6D5BBFF9FULL }, /* XSUM_XXH64_testdata[3273] */
    { 1637, 0x0000000000000000ULL, 0xF55828797D67A8ADULL }, /* XSUM_XXH64_testdata[3274] */
    { 1637, 0x000000009E3779B1ULL, 0x3DD0DC30CBE981BCULL }, /* XSUM_XXH64_testdata[3275] */
    { 1638, 0x0000000000000000ULL, 0x6DD7D9CBFC80A384ULL }, /* XSUM_XXH64_testdata[3276] */
    { 1638, 0x000000009E3779B1ULL, 0x93006E8C54C2CC8EULL }, /* XSUM_XXH64_testdata[3277] */
    { 1639, 0x0000000000000000ULL, 0x5BF801F38EA6C087ULL }, /* XSUM_XXH64_testdata[3278] */
    { 1639, 0x000000009E3779B1ULL, 0x5174BCB31752426AULL }, /* XSUM_XXH64_testdata[3279] */
    { 1640, 0x0000000000000000ULL, 0x0F233B0C0B128CA8ULL }, /* XSUM_XXH64_testdata[3280] */
    { 1640, 0x000000009E3779B1ULL, 0x7B14BAC52D3DD748ULL }, /* XSUM_XXH64_testdata[3281] */
    { 1641, 0x0000000000000000ULL, 0xD70D9B2CF3BD8665ULL }, /* XSUM_XXH64_testdata[3282] */
    { 1641, 0x000000009E3779B1ULL, 0xB443706BB2658309ULL }, /* XSUM_XXH64_testdata[3283] */
    { 1642, 0x0000000000000000ULL, 0x9FF8A37309F256E7ULL }, /* XSUM_XXH64_testdata[3284] */
    { 1642, 0x000000009E3779B1ULL, 0xD36A1438415D306EULL }, /* XSUM_XXH64_testdata[3285] */
    { 1643, 0x0000000000000000ULL, 0x9E120470D0779E8CULL }, /* XSUM_XXH64_testdata[3286] */
    { 1643, 0x000000009E3779B1ULL, 0x9AF8535DCACEC23FULL }, /* XSUM_XXH64_testdata[3287] */
    { 1644, 0x0000000000000000ULL, 0x2E8F3258593AF633ULL }, /* XSUM_XXH64_testdata[3288] */
    { 1644, 0x000000009E3779B1ULL, 0xC17FDCC70B62469FULL }, /* XSUM_XXH64_testdata[3289] */
    { 1645, 0x0000000000000000ULL, 0xE00ED1D3307E2D7BULL }, /* XSUM_XXH64_testdata[3290] */
    { 1645, 0x000000009E3779B1ULL, 0x95871F1F52636B14ULL }, /* XSUM_XXH64_testdata[3291] */
    { 1646, 0x0000000000000000ULL, 0x255B902A051238C1ULL }, /* XSUM_XXH64_testdata[3292] */
    { 1646, 0x000000009E3779B1ULL, 0x9F132DAFBE6BC93EULL }, /* XSUM_XXH64_testdata[3293] */
    { 1647, 0x0000000000000000ULL, 0xEF26A09CFB3F1706ULL }, /* XSUM_XXH64_testdata[3294] */
    { 1647, 0x000000009E3779B1ULL, 0x63AF896134E96129ULL }, /* XSUM_XXH64_testdata[3295] */
    { 1648, 0x0000000000000000ULL, 0x41E287447C7ACA72ULL }, /* XSUM_XXH64_testdata[3296] */
    { 1648, 0x000000009E3779B1ULL, 0x1201E1D2C55E4388ULL }, /* XSUM_XXH64_testdata[3297] */
    { 1649, 0x0000000000000000ULL, 0xD004CEDEF08B501CULL }, /* XSUM_XXH64_testdata[3298] */
    { 1649, 0x000000009E3779B1ULL, 0xD26C59D4578D32E2ULL }, /* XSUM_XXH64_testdata[3299] */
    { 1650, 0x0000000000000000ULL, 0x5269130062237423ULL }, /* XSUM_XXH64_testdata[3300] */
    { 1650, 0x000000009E3779B1ULL, 0x7E6C88EDADE17465ULL }, /* XSUM_XXH64_testdata[3301] */
    { 1651, 0x0000000000000000ULL, 0xD295B04F2893D550ULL }, /* XSUM_XXH64_testdata[3302] */
    { 1651, 0x000000009E3779B1ULL, 0x46551AA2C8EC7618ULL }, /* XSUM_XXH64_testdata[3303] */
    { 1652, 0x0000000000000000ULL, 0x00C565D934FBC073ULL }, /* XSUM_XXH64_testdata[3304] */
    { 1652, 0x000000009E3779B1ULL, 0xF335B0CB382444A1ULL }, /* XSUM_XXH64_testdata[3305] */
    { 1653, 0x0000000000000000ULL, 0x8972311D0FB8650BULL }, /* XSUM_XXH64_testdata[3306] */
    { 1653, 0x000000009E3779B1ULL, 0x544FF9079E902640ULL }, /* XSUM_XXH64_testdata[3307] */
    { 1654, 0x0000000000000000ULL, 0xF5586D62BB829B6FULL }, /* XSUM_XXH64_testdata[3308] */
    { 1654, 0x000000009E3779B1ULL, 0x7A3BA876138968C6ULL }, /* XSUM_XXH64_testdata[3309] */
    { 1655, 0x0000000000000000ULL, 0x6E0D7273096BD6EEULL }, /* XSUM_XXH64_testdata[3310] */
    { 1655, 0x000000009E3779B1ULL, 0x35EA8EC77D2F786CULL }, /* XSUM_XXH64_testdata[3311] */
    { 1656, 0x0000000000000000ULL, 0x7733E29A2C88DDA4ULL }, /* XSUM_XXH64_testdata[3312] */
    { 1656, 0x000000009E3779B1ULL, 0x2E4FC9EB0FEACCB9ULL }, /* XSUM_XXH64_testdata[3313] */
    { 1657, 0x0000000000000000ULL, 0xF5F186833A8EEC6FULL }, /* XSUM_XXH64_testdata[3314] */
    { 1657, 0x000000009E3779B1ULL, 0x828D4948F7B6A583ULL }, /* XSUM_XXH64_testdata[3315] */
    { 1658, 0x0000000000000000ULL, 0x68A818B7C263F74AULL }, /* XSUM_XXH64_testdata[3316] */
    { 1658, 0x000000009E3779B1ULL, 0x4A005BB85D0A79F7ULL }, /* XSUM_XXH64_testdata[3317] */
    { 1659, 0x0000000000000000ULL, 0x018B356CA3C9A9F1ULL }, /* XSUM_XXH64_testdata[3318] */
    { 1659, 0x000000009E3779B1ULL, 0x388F3CA3346F2B33ULL }, /* XSUM_XXH64_testdata[3319] */
    { 1660, 0x0000000000000000ULL, 0xEB801C9F3FBA55D1ULL }, /* XSUM_XXH64_testdata[3320] */
    { 1660, 0x000000009E3779B1ULL, 0x1B596F329DF90548ULL }, /* XSUM_XXH64_testdata[3321] */
    { 1661, 0x0000000000000000ULL, 0x1D2D873ADE00A4A1ULL }, /* XSUM_XXH64_testdata[3322] */
    { 1661, 0x000000009E3779B1ULL, 0x973B0041FA5B0DF4ULL }, /* XSUM_XXH64_testdata[3323] */
    { 1662, 0x0000000000000000ULL, 0x3FA2D1ADA4259173ULL }, /* XSUM_XXH64_testdata[3324] */
    { 1662, 0x000000009E3779B1ULL, 0xC4EFA6F2BA28926AULL }, /* XSUM_XXH64_testdata[3325] */
    { 1663, 0x0000000000000000ULL, 0x60BE83EC5E5F9868ULL }, /* XSUM_XXH64_testdata[3326] */
    { 1663, 0x000000009E3779B1ULL, 0x2EFF0EB2F239950EULL }, /* XSUM_XXH64_testdata[3327] */
    { 1664, 0x0000000000000000ULL, 0x5FAA366ACE68C4F9ULL }, /* XSUM_XXH64_testdata[3328] */
    { 1664, 0x000000009E3779B1ULL, 0x4FEE07A316F52D4FULL }, /* XSUM_XXH64_testdata[3329] */
    { 1665, 0x0000000000000000ULL, 0x04CAB9B038E28DB8ULL }, /* XSUM_XXH64_testdata[3330] */
    { 1665, 0x000000009E3779B1ULL, 0xB71811C91CA5D8C9ULL }, /* XSUM_XXH64_testdata[3331] */
    { 1666, 0x0000000000000000ULL, 0xD75FD910B590EF87ULL }, /* XSUM_XXH64_testdata[3332] */
    { 1666, 0x000000009E3779B1ULL, 0xE5FCABDA6312565FULL }, /* XSUM_XXH64_testdata[3333] */
    { 1667, 0x0000000000000000ULL, 0xAD550BC55A9A0F10ULL }, /* XSUM_XXH64_testdata[3334] */
    { 1667, 0x000000009E3779B1ULL, 0xD3D8AD861DEDB7ABULL }, /* XSUM_XXH64_testdata[3335] */
    { 1668, 0x0000000000000000ULL, 0xAC77F130F26CEBBFULL }, /* XSUM_XXH64_testdata[3336] */
    { 1668, 0x000000009E3779B1ULL, 0x7858391A2B46D82EULL }, /* XSUM_XXH64_testdata[3337] */
    { 1669, 0x0000000000000000ULL, 0x2244FA4B806CE1EBULL }, /* XSUM_XXH64_testdata[3338] */
    { 1669, 0x000000009E3779B1ULL, 0x3736AC22C458A0E4ULL }, /* XSUM_XXH64_testdata[3339] */
    { 1670, 0x0000000000000000ULL, 0x8638660334868725ULL }, /* XSUM_XXH64_testdata[3340] */
    { 1670, 0x000000009E3779B1ULL, 0x1C4496255C405FA6ULL }, /* XSUM_XXH64_testdata[3341] */
    { 1671, 0x0000000000000000ULL, 0x604D3DE86B3F1083ULL }, /* XSUM_XXH64_testdata[3342] */
    { 1671, 0x000000009E3779B1ULL, 0xF7A76A7454BD3A80ULL }, /* XSUM_XXH64_testdata[3343] */
    { 1672, 0x0000000000000000ULL, 0xE8287C45CA4FF145ULL }, /* XSUM_XXH64_testdata[3344] */
    { 1672, 0x000000009E3779B1ULL, 0x3BF83A8D746BAEB6ULL }, /* XSUM_XXH64_testdata[3345] */
    { 1673, 0x0000000000000000ULL, 0x54ACE1C76FEF5A27ULL }, /* XSUM_XXH64_testdata[3346] */
    { 1673, 0x000000009E3779B1ULL, 0x1C8B2E909DBEEB02ULL }, /* XSUM_XXH64_testdata[3347] */
    { 1674, 0x0000000000000000ULL, 0x2ECCDD3A05EA6AFCULL }, /* XSUM_XXH64_testdata[3348] */
    { 1674, 0x000000009E3779B1ULL, 0xBCD32AFAA9714D34ULL }, /* XSUM_XXH64_testdata[3349] */
    { 1675, 0x0000000000000000ULL, 0x837A229C386F65A6ULL }, /* XSUM_XXH64_testdata[3350] */
    { 1675, 0x000000009E3779B1ULL, 0xC1A1D814697E54D0ULL }, /* XSUM_XXH64_testdata[3351] */
    { 1676, 0x0000000000000000ULL, 0x5571732C93A2FE8BULL }, /* XSUM_XXH64_testdata[3352] */
    { 1676, 0x000000009E3779B1ULL, 0xCEBAC1E61ADF2DD4ULL }, /* XSUM_XXH64_testdata[3353] */
    { 1677, 0x0000000000000000ULL, 0xB8E3F65B4B00D676ULL }, /* XSUM_XXH64_testdata[3354] */
    { 1677, 0x000000009E3779B1ULL, 0x30482500656C48D8ULL }, /* XSUM_XXH64_testdata[3355] */
    { 1678, 0x0000000000000000ULL, 0xEB5EA8EB33DF1260ULL }, /* XSUM_XXH64_testdata[3356] */
    { 1678, 0x000000009E3779B1ULL, 0x60F5E62863A90828ULL }, /* XSUM_XXH64_testdata[3357] */
    { 1679, 0x0000000000000000ULL, 0x873F74310484F3E2ULL }, /* XSUM_XXH64_testdata[3358] */
    { 1679, 0x000000009E3779B1ULL, 0xB3FE1D83C98D4018ULL }, /* XSUM_XXH64_testdata[3359] */
    { 1680, 0x0000000000000000ULL, 0x0E314B095320C272ULL }, /* XSUM_XXH64_testdata[3360] */
    { 1680, 0x000000009E3779B1ULL, 0xA037C4F60E8E8C53ULL }, /* XSUM_XXH64_testdata[3361] */
    { 1681, 0x0000000000000000ULL, 0x9EB8189409EAFE58ULL }, /* XSUM_XXH64_testdata[3362] */
    { 1681, 0x000000009E3779B1ULL, 0xF1511B15429BC2EDULL }, /* XSUM_XXH64_testdata[3363] */
    { 1682, 0x0000000000000000ULL, 0xCD1A7CBA6D35158EULL }, /* XSUM_XXH64_testdata[3364] */
    { 1682, 0x000000009E3779B1ULL, 0xE0ECD12A13D6F323ULL }, /* XSUM_XXH64_testdata[3365] */
    { 1683, 0x0000000000000000ULL, 0xA1E6031EDAA25021ULL }, /* XSUM_XXH64_testdata[3366] */
    { 1683, 0x000000009E3779B1ULL, 0x16431DA2D43D7E83ULL }, /* XSUM_XXH64_testdata[3367] */
    { 1684, 0x0000000000000000ULL, 0x68B9E7598EEE21CAULL }, /* XSUM_XXH64_testdata[3368] */
    { 1684, 0x000000009E3779B1ULL, 0xADBA4CF078501597ULL }, /* XSUM_XXH64_testdata[3369] */
    { 1685, 0x0000000000000000ULL, 0x07CBF0A892F18C8CULL }, /* XSUM_XXH64_testdata[3370] */
    { 1685, 0x000000009E3779B1ULL, 0x4239A4DC9DE3B36FULL }, /* XSUM_XXH64_testdata[3371] */
    { 1686, 0x0000000000000000ULL, 0x3BBC196D8E9799B1ULL }, /* XSUM_XXH64_testdata[3372] */
    { 1686, 0x000000009E3779B1ULL, 0x767056D4CAD16E3AULL }, /* XSUM_XXH64_testdata[3373] */
    { 1687, 0x0000000000000000ULL, 0x5CBC8DBE3E6EF374ULL }, /* XSUM_XXH64_testdata[3374] */
    { 1687, 0x000000009E3779B1ULL, 0x8EBA46CA3F79A2E6ULL }, /* XSUM_XXH64_testdata[3375] */
    { 1688, 0x0000000000000000ULL, 0x7990C9FB13C5F12FULL }, /* XSUM_XXH64_testdata[3376] */
    { 1688, 0x000000009E3779B1ULL, 0xD8AEE7B73A86B131ULL }, /* XSUM_XXH64_testdata[3377] */
    { 1689, 0x0000000000000000ULL, 0xF22ADB86330554B4ULL }, /* XSUM_XXH64_testdata[3378] */
    { 1689, 0x000000009E3779B1ULL, 0x566E072DD513F8F6ULL }, /* XSUM_XXH64_testdata[3379] */
    { 1690, 0x0000000000000000ULL, 0xE4AC9CCE0113D3EBULL }, /* XSUM_XXH64_testdata[3380] */
    { 1690, 0x000000009E3779B1ULL, 0xDC18EFF19F4BFD31ULL }, /* XSUM_XXH64_testdata[3381] */
    { 1691, 0x0000000000000000ULL, 0x38115722334A3A66ULL }, /* XSUM_XXH64_testdata[3382] */
    { 1691, 0x000000009E3779B1ULL, 0xD4AD1B7F5C71DAC5ULL }, /* XSUM_XXH64_testdata[3383] */
    { 1692, 0x0000000000000000ULL, 0xE3276958E27BD95BULL }, /* XSUM_XXH64_testdata[3384] */
    { 1692, 0x000000009E3779B1ULL, 0xD74995A3CE7105B2ULL }, /* XSUM_XXH64_testdata[3385] */
    { 1693, 0x0000000000000000ULL, 0xC124BF02CD1FE936ULL }, /* XSUM_XXH64_testdata[3386] */
    { 1693, 0x000000009E3779B1ULL, 0x92F385A153692D0EULL }, /* XSUM_XXH64_testdata[3387] */
    { 1694, 0x0000000000000000ULL, 0xB0AF477397845F74ULL }, /* XSUM_XXH64_testdata[3388] */
    { 1694, 0x000000009E3779B1ULL, 0x04A7686B95001DD1ULL }, /* XSUM_XXH64_testdata[3389] */
    { 1695, 0x0000000000000000ULL, 0x7E05C9BE12CCE045ULL }, /* XSUM_XXH64_testdata[3390] */
    { 1695, 0x000000009E3779B1ULL, 0xCD6751AF8425EFD1ULL }, /* XSUM_XXH64_testdata[3391] */
    { 1696, 0x0000000000000000ULL, 0x4D2DB77F05A32425ULL }, /* XSUM_XXH64_testdata[3392] */
    { 1696, 0x000000009E3779B1ULL, 0x7732D72F5C76B1ECULL }, /* XSUM_XXH64_testdata[3393] */
    { 1697, 0x0000000000000000ULL, 0x09B9647CD1788055ULL }, /* XSUM_XXH64_testdata[3394] */
    { 1697, 0x000000009E3779B1ULL, 0xAF6E876FF2859051ULL }, /* XSUM_XXH64_testdata[3395] */
    { 1698, 0x0000000000000000ULL, 0xB3DE9C30D8CE5026ULL }, /* XSUM_XXH64_testdata[3396] */
    { 1698, 0x000000009E3779B1ULL, 0x6F06D8990008C3CBULL }, /* XSUM_XXH64_testdata[3397] */
    { 1699, 0x0000000000000000ULL, 0x342F47AC47AB3006ULL }, /* XSUM_XXH64_testdata[3398] */
    { 1699, 0x000000009E3779B1ULL, 0x1D1A6133D0FF4C28ULL }, /* XSUM_XXH64_testdata[3399] */
    { 1700, 0x0000000000000000ULL, 0xA3F8F2A97AB4543FULL }, /* XSUM_XXH64_testdata[3400] */
    { 1700, 0x000000009E3779B1ULL, 0xDE1F6E4CC71FAD03ULL }, /* XSUM_XXH64_testdata[3401] */
    { 1701, 0x0000000000000000ULL, 0xCC9C82EE8B57E96EULL }, /* XSUM_XXH64_testdata[3402] */
    { 1701, 0x000000009E3779B1ULL, 0x5BC8EFDB884B44ACULL }, /* XSUM_XXH64_testdata[3403] */
    { 1702, 0x0000000000000000ULL, 0xACCF70A9F06D4370ULL }, /* XSUM_XXH64_testdata[3404] */
    { 1702, 0x000000009E3779B1ULL, 0xE93D7A098026AE00ULL }, /* XSUM_XXH64_testdata[3405] */
    { 1703, 0x0000000000000000ULL, 0xC4F6C35ED815945BULL }, /* XSUM_XXH64_testdata[3406] */
    { 1703, 0x000000009E3779B1ULL, 0x8D8BEA6F4860E769ULL }, /* XSUM_XXH64_testdata[3407] */
    { 1704, 0x0000000000000000ULL, 0xDB47BC574089F55EULL }, /* XSUM_XXH64_testdata[3408] */
    { 1704, 0x000000009E3779B1ULL, 0x37D6D08840E3EF1EULL }, /* XSUM_XXH64_testdata[3409] */
    { 1705, 0x0000000000000000ULL, 0x2699F136DC53C798ULL }, /* XSUM_XXH64_testdata[3410] */
    { 1705, 0x000000009E3779B1ULL, 0x824255446F2EE361ULL }, /* XSUM_XXH64_testdata[3411] */
    { 1706, 0x0000000000000000ULL, 0xD62A889F292EC17EULL }, /* XSUM_XXH64_testdata[3412] */
    { 1706, 0x000000009E3779B1ULL, 0x1702CF9052C58735ULL }, /* XSUM_XXH64_testdata[3413] */
    { 1707, 0x0000000000000000ULL, 0x123BBAD844BBBC53ULL }, /* XSUM_XXH64_testdata[3414] */
    { 1707, 0x000000009E3779B1ULL, 0x89E311328DE51A98ULL }, /* XSUM_XXH64_testdata[3415] */
    { 1708, 0x0000000000000000ULL, 0x986AF39AF32D574BULL }, /* XSUM_XXH64_testdata[3416] */
    { 1708, 0x000000009E3779B1ULL, 0x70CC35BDA77D6ADEULL }, /* XSUM_XXH64_testdata[3417] */
    { 1709, 0x0000000000000000ULL, 0x1A023DD314C33689ULL }, /* XSUM_XXH64_testdata[3418] */
    { 1709, 0x000000009E3779B1ULL, 0xF50BEDE2B839A5C7ULL }, /* XSUM_XXH64_testdata[3419] */
    { 1710, 0x0000000000000000ULL, 0x60156579D9C1682EULL }, /* XSUM_XXH64_testdata[3420] */
    { 1710, 0x000000009E3779B1ULL, 0xBD1260444B1116DEULL }, /* XSUM_XXH64_testdata[3421] */
    { 1711, 0x0000000000000000ULL, 0x6C75FE0558CEF727ULL }, /* XSUM_XXH64_testdata[3422] */
    { 1711, 0x000000009E3779B1ULL, 0xA58E6DF0E53E819BULL }, /* XSUM_XXH64_testdata[3423] */
    { 1712, 0x0000000000000000ULL, 0x26A14DF448C0EBFBULL }, /* XSUM_XXH64_testdata[3424] */
    { 1712, 0x000000009E3779B1ULL, 0xC3BF20CA60750F16ULL }, /* XSUM_XXH64_testdata[3425] */
    { 1713, 0x0000000000000000ULL, 0xA3232BB3E7D13BF6ULL }, /* XSUM_XXH64_testdata[3426] */
    { 1713, 0x000000009E3779B1ULL, 0xEF838C8BF19BA816ULL }, /* XSUM_XXH64_testdata[3427] */
    { 1714, 0x0000000000000000ULL, 0x40EC017D27585BDCULL }, /* XSUM_XXH64_testdata[3428] */
    { 1714, 0x000000009E3779B1ULL, 0xBA76ECA3CA312676ULL }, /* XSUM_XXH64_testdata[3429] */
    { 1715, 0x0000000000000000ULL, 0xC202F3FA97954C32ULL }, /* XSUM_XXH64_testdata[3430] */
    { 1715, 0x000000009E3779B1ULL, 0x1DD23BA390FCFD77ULL }, /* XSUM_XXH64_testdata[3431] */
    { 1716, 0x0000000000000000ULL, 0x2D5BDA0248D035E2ULL }, /* XSUM_XXH64_testdata[3432] */
    { 1716, 0x000000009E3779B1ULL, 0x4F18A2F451223D88ULL }, /* XSUM_XXH64_testdata[3433] */
    { 1717, 0x0000000000000000ULL, 0xCC629A50E1667D14ULL }, /* XSUM_XXH64_testdata[3434] */
    { 1717, 0x000000009E3779B1ULL, 0x5730B39D7267ACF9ULL }, /* XSUM_XXH64_testdata[3435] */
    { 1718, 0x0000000000000000ULL, 0x5DCD78358AA3F8FAULL }, /* XSUM_XXH64_testdata[3436] */
    { 1718, 0x000000009E3779B1ULL, 0x4B071F9361A8B85EULL }, /* XSUM_XXH64_testdata[3437] */
    { 1719, 0x0000000000000000ULL, 0x6E80D2B9D82AEC43ULL }, /* XSUM_XXH64_testdata[3438] */
    { 1719, 0x000000009E3779B1ULL, 0x9ABD21AF82BC2D22ULL }, /* XSUM_XXH64_testdata[3439] */
    { 1720, 0x0000000000000000ULL, 0x2E9BC0FD5B1144FAULL }, /* XSUM_XXH64_testdata[3440] */
    { 1720, 0x000000009E3779B1ULL, 0xAD26D0AADFF06BC0ULL }, /* XSUM_XXH64_testdata[3441] */
    { 1721, 0x0000000000000000ULL, 0xB20B4A6727108B05ULL }, /* XSUM_XXH64_testdata[3442] */
    { 1721, 0x000000009E3779B1ULL, 0xB4BF4FF0CCC60866ULL }, /* XSUM_XXH64_testdata[3443] */
    { 1722, 0x0000000000000000ULL, 0x4240A18611B1D564ULL }, /* XSUM_XXH64_testdata[3444] */
    { 1722, 0x000000009E3779B1ULL, 0x44C1A81F8C0FB9F3ULL }, /* XSUM_XXH64_testdata[3445] */
    { 1723, 0x0000000000000000ULL, 0x5A7E212678293D5EULL }, /* XSUM_XXH64_testdata[3446] */
    { 1723, 0x000000009E3779B1ULL, 0x636EAFEF598703C5ULL }, /* XSUM_XXH64_testdata[3447] */
    { 1724, 0x0000000000000000ULL, 0x7D24EDD7355947F3ULL }, /* XSUM_XXH64_testdata[3448] */
    { 1724, 0x000000009E3779B1ULL, 0xEACFEE7DC598917CULL }, /* XSUM_XXH64_testdata[3449] */
    { 1725, 0x0000000000000000ULL, 0xF701ACF26677B7CDULL }, /* XSUM_XXH64_testdata[3450] */
    { 1725, 0x000000009E3779B1ULL, 0x18BB5E518BB85FF0ULL }, /* XSUM_XXH64_testdata[3451] */
    { 1726, 0x0000000000000000ULL, 0x1A46F2A428198B34ULL }, /* XSUM_XXH64_testdata[3452] */
    { 1726, 0x000000009E3779B1ULL, 0x08FB0151F8801A5AULL }, /* XSUM_XXH64_testdata[3453] */
    { 1727, 0x0000000000000000ULL, 0x915235E50A57D275ULL }, /* XSUM_XXH64_testdata[3454] */
    { 1727, 0x000000009E3779B1ULL, 0xEF705C921F5F1D28ULL }, /* XSUM_XXH64_testdata[3455] */
    { 1728, 0x0000000000000000ULL, 0x56E2C19A75F9E8BFULL }, /* XSUM_XXH64_testdata[3456] */
    { 1728, 0x000000009E3779B1ULL, 0xC02056594E646313ULL }, /* XSUM_XXH64_testdata[3457] */
    { 1729, 0x0000000000000000ULL, 0x3F8E58DFE327BD04ULL }, /* XSUM_XXH64_testdata[3458] */
    { 1729, 0x000000009E3779B1ULL, 0x590DD51947592217ULL }, /* XSUM_XXH64_testdata[3459] */
    { 1730, 0x0000000000000000ULL, 0xAD89489011AE7DFBULL }, /* XSUM_XXH64_testdata[3460] */
    { 1730, 0x000000009E3779B1ULL, 0x640EB7CE43ABA139ULL }, /* XSUM_XXH64_testdata[3461] */
    { 1731, 0x0000000000000000ULL, 0x70D754BAB814C9A3ULL }, /* XSUM_XXH64_testdata[3462] */
    { 1731, 0x000000009E3779B1ULL, 0xDD95E3F13F98049CULL }, /* XSUM_XXH64_testdata[3463] */
    { 1732, 0x0000000000000000ULL, 0xD80046DF363DC0FAULL }, /* XSUM_XXH64_testdata[3464] */
    { 1732, 0x000000009E3779B1ULL, 0xB0E778FF4B6E1568ULL }, /* XSUM_XXH64_testdata[3465] */
    { 1733, 0x0000000000000000ULL, 0xA1E4A4E0D47FFFA7ULL }, /* XSUM_XXH64_testdata[3466] */
    { 1733, 0x000000009E3779B1ULL, 0x6698FD93B0670C93ULL }, /* XSUM_XXH64_testdata[3467] */
    { 1734, 0x0000000000000000ULL, 0xB6DD5980B566FC2FULL }, /* XSUM_XXH64_testdata[3468] */
    { 1734, 0x000000009E3779B1ULL, 0x9DF21FF82ECAEF8BULL }, /* XSUM_XXH64_testdata[3469] */
    { 1735, 0x0000000000000000ULL, 0x9CCA793DAEC20CD8ULL }, /* XSUM_XXH64_testdata[3470] */
    { 1735, 0x000000009E3779B1ULL, 0x82EE3D976B3AF857ULL }, /* XSUM_XXH64_testdata[3471] */
    { 1736, 0x0000000000000000ULL, 0x9993E1397960F0DCULL }, /* XSUM_XXH64_testdata[3472] */
    { 1736, 0x000000009E3779B1ULL, 0xABB404039B73356CULL }, /* XSUM_XXH64_testdata[3473] */
    { 1737, 0x0000000000000000ULL, 0x35365EFD5C4471E2ULL }, /* XSUM_XXH64_testdata[3474] */
    { 1737, 0x000000009E3779B1ULL, 0x3257BDA08CC6ADAFULL }, /* XSUM_XXH64_testdata[3475] */
    { 1738, 0x0000000000000000ULL, 0x25F45BFE56B5CA9FULL }, /* XSUM_XXH64_testdata[3476] */
    { 1738, 0x000000009E3779B1ULL, 0x38ECE062CDC477A9ULL }, /* XSUM_XXH64_testdata[3477] */
    { 1739, 0x0000000000000000ULL, 0x8A38339E51186E6CULL }, /* XSUM_XXH64_testdata[3478] */
    { 1739, 0x000000009E3779B1ULL, 0xBD31F2E8AD9CD7A1ULL }, /* XSUM_XXH64_testdata[3479] */
    { 1740, 0x0000000000000000ULL, 0x12EF7936960AA308ULL }, /* XSUM_XXH64_testdata[3480] */
    { 1740, 0x000000009E3779B1ULL, 0x520B9AE652F337FCULL }, /* XSUM_XXH64_testdata[3481] */
    { 1741, 0x0000000000000000ULL, 0x6920C0FE251C374AULL }, /* XSUM_XXH64_testdata[3482] */
    { 1741, 0x000000009E3779B1ULL, 0x21654D8CF6D1A26DULL }, /* XSUM_XXH64_testdata[3483] */
    { 1742, 0x0000000000000000ULL, 0xB42CB16FC4BDAD49ULL }, /* XSUM_XXH64_testdata[3484] */
    { 1742, 0x000000009E3779B1ULL, 0x67E081A036D992D4ULL }, /* XSUM_XXH64_testdata[3485] */
    { 1743, 0x0000000000000000ULL, 0x0B5CD16F4CD4C660ULL }, /* XSUM_XXH64_testdata[3486] */
    { 1743, 0x000000009E3779B1ULL, 0x6E0E44C0AD41A008ULL }, /* XSUM_XXH64_testdata[3487] */
    { 1744, 0x0000000000000000ULL, 0x96E48BC1BBD85CF2ULL }, /* XSUM_XXH64_testdata[3488] */
    { 1744, 0x000000009E3779B1ULL, 0xC3F71B97D808D9C7ULL }, /* XSUM_XXH64_testdata[3489] */
    { 1745, 0x0000000000000000ULL, 0xE54F350E6AA7BCE9ULL }, /* XSUM_XXH64_testdata[3490] */
    { 1745, 0x000000009E3779B1ULL, 0x9AEFC9FC7BF6B0B9ULL }, /* XSUM_XXH64_testdata[3491] */
    { 1746, 0x0000000000000000ULL, 0x2971C6B8B26DCB67ULL }, /* XSUM_XXH64_testdata[3492] */
    { 1746, 0x000000009E3779B1ULL, 0xFD0BDBD97F50A52CULL }, /* XSUM_XXH64_testdata[3493] */
    { 1747, 0x0000000000000000ULL, 0x4FA4323493ACF24EULL }, /* XSUM_XXH64_testdata[3494] */
    { 1747, 0x000000009E3779B1ULL, 0x261F1370DD014DBDULL }, /* XSUM_XXH64_testdata[3495] */
    { 1748, 0x0000000000000000ULL, 0xDBA05A1AF9C1851AULL }, /* XSUM_XXH64_testdata[3496] */
    { 1748, 0x000000009E3779B1ULL, 0x3E12342B2B1A44F2ULL }, /* XSUM_XXH64_testdata[3497] */
    { 1749, 0x0000000000000000ULL, 0x0B9E82AC9F549857ULL }, /* XSUM_XXH64_testdata[3498] */
    { 1749, 0x000000009E3779B1ULL, 0x57170AED497AA965ULL }, /* XSUM_XXH64_testdata[3499] */
    { 1750, 0x0000000000000000ULL, 0xFC04C903251ED260ULL }, /* XSUM_XXH64_testdata[3500] */
    { 1750, 0x000000009E3779B1ULL, 0x24DB576773E75308ULL }, /* XSUM_XXH64_testdata[3501] */
    { 1751, 0x0000000000000000ULL, 0x50FF5014BD62F3DCULL }, /* XSUM_XXH64_testdata[3502] */
    { 1751, 0x000000009E3779B1ULL, 0x4E4A900C0F31FE5CULL }, /* XSUM_XXH64_testdata[3503] */
    { 1752, 0x0000000000000000ULL, 0x04FBB508FE01A73FULL }, /* XSUM_XXH64_testdata[3504] */
    { 1752, 0x000000009E3779B1ULL, 0x73C9C4B50A322B1EULL }, /* XSUM_XXH64_testdata[3505] */
    { 1753, 0x0000000000000000ULL, 0x8062F35168DFB18BULL }, /* XSUM_XXH64_testdata[3506] */
    { 1753, 0x000000009E3779B1ULL, 0x70B9D085B260C9ADULL }, /* XSUM_XXH64_testdata[3507] */
    { 1754, 0x0000000000000000ULL, 0x06E0EB228BB7ACBFULL }, /* XSUM_XXH64_testdata[3508] */
    { 1754, 0x000000009E3779B1ULL, 0x9518BB6476D67689ULL }, /* XSUM_XXH64_testdata[3509] */
    { 1755, 0x0000000000000000ULL, 0x37B87425B1FAA058ULL }, /* XSUM_XXH64_testdata[3510] */
    { 1755, 0x000000009E3779B1ULL, 0xB1955FAE0B147711ULL }, /* XSUM_XXH64_testdata[3511] */
    { 1756, 0x0000000000000000ULL, 0xF65468407B4553E1ULL }, /* XSUM_XXH64_testdata[3512] */
    { 1756, 0x000000009E3779B1ULL, 0x00F053BF395B2106ULL }, /* XSUM_XXH64_testdata[3513] */
    { 1757, 0x0000000000000000ULL, 0xFFB10BB605C9110EULL }, /* XSUM_XXH64_testdata[3514] */
    { 1757, 0x000000009E3779B1ULL, 0x1640DD5715A690F4ULL }, /* XSUM_XXH64_testdata[3515] */
    { 1758, 0x0000000000000000ULL, 0x5DEE77F59466D50BULL }, /* XSUM_XXH64_testdata[3516] */
    { 1758, 0x000000009E3779B1ULL, 0x8AA5DE5E6985EB84ULL }, /* XSUM_XXH64_testdata[3517] */
    { 1759, 0x0000000000000000ULL, 0x6DF102C54A4FAB83ULL }, /* XSUM_XXH64_testdata[3518] */
    { 1759, 0x000000009E3779B1ULL, 0x08FE7F7878532F68ULL }, /* XSUM_XXH64_testdata[3519] */
    { 1760, 0x0000000000000000ULL, 0xEF2CF03EDE2830EAULL }, /* XSUM_XXH64_testdata[3520] */
    { 1760, 0x000000009E3779B1ULL, 0x754AC7CE9010BD9CULL }, /* XSUM_XXH64_testdata[3521] */
    { 1761, 0x0000000000000000ULL, 0xCB7D1DFB7B2DB3BFULL }, /* XSUM_XXH64_testdata[3522] */
    { 1761, 0x000000009E3779B1ULL, 0x4247787E1084A707ULL }, /* XSUM_XXH64_testdata[3523] */
    { 1762, 0x0000000000000000ULL, 0x9D8A3065B8D7CBA0ULL }, /* XSUM_XXH64_testdata[3524] */
    { 1762, 0x000000009E3779B1ULL, 0x9B5DDCAE88071197ULL }, /* XSUM_XXH64_testdata[3525] */
    { 1763, 0x0000000000000000ULL, 0x193834739464B2BEULL }, /* XSUM_XXH64_testdata[3526] */
    { 1763, 0x000000009E3779B1ULL, 0x1C1D93E5112B6E9FULL }, /* XSUM_XXH64_testdata[3527] */
    { 1764, 0x0000000000000000ULL, 0x7494E37B90846CC1ULL }, /* XSUM_XXH64_testdata[3528] */
    { 1764, 0x000000009E3779B1ULL, 0x4F0FD3084E953A93ULL }, /* XSUM_XXH64_testdata[3529] */
    { 1765, 0x0000000000000000ULL, 0xC56C38A579B304A3ULL }, /* XSUM_XXH64_testdata[3530] */
    { 1765, 0x000000009E3779B1ULL, 0x48742B364F37C808ULL }, /* XSUM_XXH64_testdata[3531] */
    { 1766, 0x0000000000000000ULL, 0x153DB0985BE55DBDULL }, /* XSUM_XXH64_testdata[3532] */
    { 1766, 0x000000009E3779B1ULL, 0x02993D14529623B8ULL }, /* XSUM_XXH64_testdata[3533] */
    { 1767, 0x0000000000000000ULL, 0x493FC92A4186CB01ULL }, /* XSUM_XXH64_testdata[3534] */
    { 1767, 0x000000009E3779B1ULL, 0xF9C334FFA2FB7CECULL }, /* XSUM_XXH64_testdata[3535] */
    { 1768, 0x0000000000000000ULL, 0x502140C5FC4E24ECULL }, /* XSUM_XXH64_testdata[3536] */
    { 1768, 0x000000009E3779B1ULL, 0xF86DE152E0F26681ULL }, /* XSUM_XXH64_testdata[3537] */
    { 1769, 0x0000000000000000ULL, 0x84A97F4662C50091ULL }, /* XSUM_XXH64_testdata[3538] */
    { 1769, 0x000000009E3779B1ULL, 0x77D9E20B45659C55ULL }, /* XSUM_XXH64_testdata[3539] */
    { 1770, 0x0000000000000000ULL, 0xD00AC20E8B16543FULL }, /* XSUM_XXH64_testdata[3540] */
    { 1770, 0x000000009E3779B1ULL, 0x5FD0E9B86F32AF5AULL }, /* XSUM_XXH64_testdata[3541] */
    { 1771, 0x0000000000000000ULL, 0xA7F827B58C969A73ULL }, /* XSUM_XXH64_testdata[3542] */
    { 1771, 0x000000009E3779B1ULL, 0xA2A0F0E3BBF1149BULL }, /* XSUM_XXH64_testdata[3543] */
    { 1772, 0x0000000000000000ULL, 0x9364429C55E2B620ULL }, /* XSUM_XXH64_testdata[3544] */
    { 1772, 0x000000009E3779B1ULL, 0xE2D9CF031122FEE6ULL }, /* XSUM_XXH64_testdata[3545] */
    { 1773, 0x0000000000000000ULL, 0x4A75DEDCB338134FULL }, /* XSUM_XXH64_testdata[3546] */
    { 1773, 0x000000009E3779B1ULL, 0xABC8F48D7763BB2EULL }, /* XSUM_XXH64_testdata[3547] */
    { 1774, 0x0000000000000000ULL, 0xB2CFCD53A763AE9DULL }, /* XSUM_XXH64_testdata[3548] */
    { 1774, 0x000000009E3779B1ULL, 0x3ADD0CEE6C14D479ULL }, /* XSUM_XXH64_testdata[3549] */
    { 1775, 0x0000000000000000ULL, 0x6EC4D430924F55D4ULL }, /* XSUM_XXH64_testdata[3550] */
    { 1775, 0x000000009E3779B1ULL, 0xB90CB8273928BE7AULL }, /* XSUM_XXH64_testdata[3551] */
    { 1776, 0x0000000000000000ULL, 0x2BD368A7FC564A38ULL }, /* XSUM_XXH64_testdata[3552] */
    { 1776, 0x000000009E3779B1ULL, 0x23E7EF417A8811CAULL }, /* XSUM_XXH64_testdata[3553] */
    { 1777, 0x0000000000000000ULL, 0x24CC01996464C9EFULL }, /* XSUM_XXH64_testdata[3554] */
    { 1777, 0x000000009E3779B1ULL, 0xBFD73DB7C55CB28DULL }, /* XSUM_XXH64_testdata[3555] */
    { 1778, 0x0000000000000000ULL, 0xEB932D3915FE55F9ULL }, /* XSUM_XXH64_testdata[3556] */
    { 1778, 0x000000009E3779B1ULL, 0xEFC0BA40F2927379ULL }, /* XSUM_XXH64_testdata[3557] */
    { 1779, 0x0000000000000000ULL, 0xDB3C509D1A756424ULL }, /* XSUM_XXH64_testdata[3558] */
    { 1779, 0x000000009E3779B1ULL, 0x082688D72DD818EBULL }, /* XSUM_XXH64_testdata[3559] */
    { 1780, 0x0000000000000000ULL, 0x56F36053787856BEULL }, /* XSUM_XXH64_testdata[3560] */
    { 1780, 0x000000009E3779B1ULL, 0x63DCA8789B8F6C87ULL }, /* XSUM_XXH64_testdata[3561] */
    { 1781, 0x0000000000000000ULL, 0xAA4E0A7E6030B219ULL }, /* XSUM_XXH64_testdata[3562] */
    { 1781, 0x000000009E3779B1ULL, 0xD60D910581742446ULL }, /* XSUM_XXH64_testdata[3563] */
    { 1782, 0x0000000000000000ULL, 0x3105DE21BB957E66ULL }, /* XSUM_XXH64_testdata[3564] */
    { 1782, 0x000000009E3779B1ULL, 0x9E1C3E19EE168BE2ULL }, /* XSUM_XXH64_testdata[3565] */
    { 1783, 0x0000000000000000ULL, 0xB283E1DC6A55B445ULL }, /* XSUM_XXH64_testdata[3566] */
    { 1783, 0x000000009E3779B1ULL, 0x04F503CBEA9F2228ULL }, /* XSUM_XXH64_testdata[3567] */
    { 1784, 0x0000000000000000ULL, 0xB4D8AFD6504D88BCULL }, /* XSUM_XXH64_testdata[3568] */
    { 1784, 0x000000009E3779B1ULL, 0x18F18EB1F72820E0ULL }, /* XSUM_XXH64_testdata[3569] */
    { 1785, 0x0000000000000000ULL, 0x9D77A31559648691ULL }, /* XSUM_XXH64_testdata[3570] */
    { 1785, 0x000000009E3779B1ULL, 0xB583BDCB829E1064ULL }, /* XSUM_XXH64_testdata[3571] */
    { 1786, 0x0000000000000000ULL, 0xFCFC3C66D9B1FB0BULL }, /* XSUM_XXH64_testdata[3572] */
    { 1786, 0x000000009E3779B1ULL, 0xB1DD390373C80DCDULL }, /* XSUM_XXH64_testdata[3573] */
    { 1787, 0x0000000000000000ULL, 0xE5EBB1B705841BF8ULL }, /* XSUM_XXH64_testdata[3574] */
    { 1787, 0x000000009E3779B1ULL, 0x0C7566581024DAF4ULL }, /* XSUM_XXH64_testdata[3575] */
    { 1788, 0x0000000000000000ULL, 0xF286AA4EDF5166A3ULL }, /* XSUM_XXH64_testdata[3576] */
    { 1788, 0x000000009E3779B1ULL, 0xDC7964276E9FD51AULL }, /* XSUM_XXH64_testdata[3577] */
    { 1789, 0x0000000000000000ULL, 0x927D938D54E2D0BAULL }, /* XSUM_XXH64_testdata[3578] */
    { 1789, 0x000000009E3779B1ULL, 0x299905EE59AD6AD7ULL }, /* XSUM_XXH64_testdata[3579] */
    { 1790, 0x0000000000000000ULL, 0xA240FF78B36282EBULL }, /* XSUM_XXH64_testdata[3580] */
    { 1790, 0x000000009E3779B1ULL, 0x1912DED7D855378BULL }, /* XSUM_XXH64_testdata[3581] */
    { 1791, 0x0000000000000000ULL, 0xBB569C0D13C72242ULL }, /* XSUM_XXH64_testdata[3582] */
    { 1791, 0x000000009E3779B1ULL, 0xF926FD9CE3306EAEULL }, /* XSUM_XXH64_testdata[3583] */
    { 1792, 0x0000000000000000ULL, 0x3594A8E12E7A2590ULL }, /* XSUM_XXH64_testdata[3584] */
    { 1792, 0x000000009E3779B1ULL, 0xFE7F8AC76E5222C7ULL }, /* XSUM_XXH64_testdata[3585] */
    { 1793, 0x0000000000000000ULL, 0xDA50DDCB0825B3A6ULL }, /* XSUM_XXH64_testdata[3586] */
    { 1793, 0x000000009E3779B1ULL, 0xA1AB5CD29A3E14A9ULL }, /* XSUM_XXH64_testdata[3587] */
    { 1794, 0x0000000000000000ULL, 0x3F624E16FA68231FULL }, /* XSUM_XXH64_testdata[3588] */
    { 1794, 0x000000009E3779B1ULL, 0x7A0A78827045F625ULL }, /* XSUM_XXH64_testdata[3589] */
    { 1795, 0x0000000000000000ULL, 0x60305DA92FE860C1ULL }, /* XSUM_XXH64_testdata[3590] */
    { 1795, 0x000000009E3779B1ULL, 0xB21F264C0BF1D7D3ULL }, /* XSUM_XXH64_testdata[3591] */
    { 1796, 0x0000000000000000ULL, 0x826CF8B3BA1621DEULL }, /* XSUM_XXH64_testdata[3592] */
    { 1796, 0x000000009E3779B1ULL, 0xC2C476B658F20AF5ULL }, /* XSUM_XXH64_testdata[3593] */
    { 1797, 0x0000000000000000ULL, 0x72028C29B2FF8EF0ULL }, /* XSUM_XXH64_testdata[3594] */
    { 1797, 0x000000009E3779B1ULL, 0x0FA8FC5021DA98E1ULL }, /* XSUM_XXH64_testdata[3595] */
    { 1798, 0x0000000000000000ULL, 0x889AD4971681649AULL }, /* XSUM_XXH64_testdata[3596] */
    { 1798, 0x000000009E3779B1ULL, 0x01072B1F6245DB87ULL }, /* XSUM_XXH64_testdata[3597] */
    { 1799, 0x0000000000000000ULL, 0xE51F50DAC98D2CBBULL }, /* XSUM_XXH64_testdata[3598] */
    { 1799, 0x000000009E3779B1ULL, 0xF6999B80038E33D4ULL }, /* XSUM_XXH64_testdata[3599] */
    { 1800, 0x0000000000000000ULL, 0x075F283A158F02A9ULL }, /* XSUM_XXH64_testdata[3600] */
    { 1800, 0x000000009E3779B1ULL, 0xD80B80BACD6F6F53ULL }, /* XSUM_XXH64_testdata[3601] */
    { 1801, 0x0000000000000000ULL, 0xA993ACFF34C9D4CFULL }, /* XSUM_XXH64_testdata[3602] */
    { 1801, 0x000000009E3779B1ULL, 0xEB84D07671DABBA8ULL }, /* XSUM_XXH64_testdata[3603] */
    { 1802, 0x0000000000000000ULL, 0x9C37159086DA00E1ULL }, /* XSUM_XXH64_testdata[3604] */
    { 1802, 0x000000009E3779B1ULL, 0xFCC389D22B416502ULL }, /* XSUM_XXH64_testdata[3605] */
    { 1803, 0x0000000000000000ULL, 0x73219CD3384CCCC6ULL }, /* XSUM_XXH64_testdata[3606] */
    { 1803, 0x000000009E3779B1ULL, 0x8B5B8A7C3D14378EULL }, /* XSUM_XXH64_testdata[3607] */
    { 1804, 0x0000000000000000ULL, 0xF38DD0C046F408ADULL }, /* XSUM_XXH64_testdata[3608] */
    { 1804, 0x000000009E3779B1ULL, 0x4A8F1C4377DC0166ULL }, /* XSUM_XXH64_testdata[3609] */
    { 1805, 0x0000000000000000ULL, 0x8E791C1AD85881B5ULL }, /* XSUM_XXH64_testdata[3610] */
    { 1805, 0x000000009E3779B1ULL, 0x3F9DC16100D4FEB1ULL }, /* XSUM_XXH64_testdata[3611] */
    { 1806, 0x0000000000000000ULL, 0x2949624FB4CF675BULL }, /* XSUM_XXH64_testdata[3612] */
    { 1806, 0x000000009E3779B1ULL, 0xDC5D223E234BCB17ULL }, /* XSUM_XXH64_testdata[3613] */
    { 1807, 0x0000000000000000ULL, 0xC78DDFCD803DDFB3ULL }, /* XSUM_XXH64_testdata[3614] */
    { 1807, 0x000000009E3779B1ULL, 0x66C95C37EA43F8E9ULL }, /* XSUM_XXH64_testdata[3615] */
    { 1808, 0x0000000000000000ULL, 0x514782D24DD9D675ULL }, /* XSUM_XXH64_testdata[3616] */
    { 1808, 0x000000009E3779B1ULL, 0x8AE9E4457A74112AULL }, /* XSUM_XXH64_testdata[3617] */
    { 1809, 0x0000000000000000ULL, 0x8E0056C99BA79308ULL }, /* XSUM_XXH64_testdata[3618] */
    { 1809, 0x000000009E3779B1ULL, 0x90AA3F44B95C0790ULL }, /* XSUM_XXH64_testdata[3619] */
    { 1810, 0x0000000000000000ULL, 0x8CA329CC8E73179EULL }, /* XSUM_XXH64_testdata[3620] */
    { 1810, 0x000000009E3779B1ULL, 0x20FBEB6D64A2A9D7ULL }, /* XSUM_XXH64_testdata[3621] */
    { 1811, 0x0000000000000000ULL, 0x84694CD3D1CE1919ULL }, /* XSUM_XXH64_testdata[3622] */
    { 1811, 0x000000009E3779B1ULL, 0xDD8D80CF51F72CFAULL }, /* XSUM_XXH64_testdata[3623] */
    { 1812, 0x0000000000000000ULL, 0x785A195F3A0B95ACULL }, /* XSUM_XXH64_testdata[3624] */
    { 1812, 0x000000009E3779B1ULL, 0x35C8FFAD7F518909ULL }, /* XSUM_XXH64_testdata[3625] */
    { 1813, 0x0000000000000000ULL, 0x7AF977910D4CFF53ULL }, /* XSUM_XXH64_testdata[3626] */
    { 1813, 0x000000009E3779B1ULL, 0x02588030BA682EABULL }, /* XSUM_XXH64_testdata[3627] */
    { 1814, 0x0000000000000000ULL, 0x767DE7936A4FE947ULL }, /* XSUM_XXH64_testdata[3628] */
    { 1814, 0x000000009E3779B1ULL, 0x8AB1FD1128031449ULL }, /* XSUM_XXH64_testdata[3629] */
    { 1815, 0x0000000000000000ULL, 0xE8749E9ADB914ABEULL }, /* XSUM_XXH64_testdata[3630] */
    { 1815, 0x000000009E3779B1ULL, 0x03D39D7F57862FE6ULL }, /* XSUM_XXH64_testdata[3631] */
    { 1816, 0x0000000000000000ULL, 0x641C019CE87F8B88ULL }, /* XSUM_XXH64_testdata[3632] */
    { 1816, 0x000000009E3779B1ULL, 0x46E2D2FA5D3DF9F6ULL }, /* XSUM_XXH64_testdata[3633] */
    { 1817, 0x0000000000000000ULL, 0x1B7679A6B712C9A4ULL }, /* XSUM_XXH64_testdata[3634] */
    { 1817, 0x000000009E3779B1ULL, 0xEFC59F59C75060AAULL }, /* XSUM_XXH64_testdata[3635] */
    { 1818, 0x0000000000000000ULL, 0x8E7AD231C665EE44ULL }, /* XSUM_XXH64_testdata[3636] */
    { 1818, 0x000000009E3779B1ULL, 0x489A400AAA27FB83ULL }, /* XSUM_XXH64_testdata[3637] */
    { 1819, 0x0000000000000000ULL, 0x6C5631CF03ED9F59ULL }, /* XSUM_XXH64_testdata[3638] */
    { 1819, 0x000000009E3779B1ULL, 0x6751FB633FA15C59ULL }, /* XSUM_XXH64_testdata[3639] */
    { 1820, 0x0000000000000000ULL, 0x5DA956031BF8C94AULL }, /* XSUM_XXH64_testdata[3640] */
    { 1820, 0x000000009E3779B1ULL, 0x77D9BF48CD0BAA03ULL }, /* XSUM_XXH64_testdata[3641] */
    { 1821, 0x0000000000000000ULL, 0xB0A0E37C71B862AAULL }, /* XSUM_XXH64_testdata[3642] */
    { 1821, 0x000000009E3779B1ULL, 0x24687C4E7EE4CC59ULL }, /* XSUM_XXH64_testdata[3643] */
    { 1822, 0x0000000000000000ULL, 0xE42477D88E0F5AF7ULL }, /* XSUM_XXH64_testdata[3644] */
    { 1822, 0x000000009E3779B1ULL, 0x55EA10EFFA49BD8FULL }, /* XSUM_XXH64_testdata[3645] */
    { 1823, 0x0000000000000000ULL, 0xA13F57925BAC9F89ULL }, /* XSUM_XXH64_testdata[3646] */
    { 1823, 0x000000009E3779B1ULL, 0xA4D92E0E33FDA69EULL }, /* XSUM_XXH64_testdata[3647] */
    { 1824, 0x0000000000000000ULL, 0x8FA8E11212591F35ULL }, /* XSUM_XXH64_testdata[3648] */
    { 1824, 0x000000009E3779B1ULL, 0xB0F6C86A9EC4D627ULL }, /* XSUM_XXH64_testdata[3649] */
    { 1825, 0x0000000000000000ULL, 0xD0450465C595F872ULL }, /* XSUM_XXH64_testdata[3650] */
    { 1825, 0x000000009E3779B1ULL, 0xAA7E7064DF30CBE7ULL }, /* XSUM_XXH64_testdata[3651] */
    { 1826, 0x0000000000000000ULL, 0x97963B0EA0A1F5D0ULL }, /* XSUM_XXH64_testdata[3652] */
    { 1826, 0x000000009E3779B1ULL, 0x5A01CBA7BEF40882ULL }, /* XSUM_XXH64_testdata[3653] */
    { 1827, 0x0000000000000000ULL, 0xB40DBEEBBCB8D8ABULL }, /* XSUM_XXH64_testdata[3654] */
    { 1827, 0x000000009E3779B1ULL, 0x9AFBAD78FD7A1C7DULL }, /* XSUM_XXH64_testdata[3655] */
    { 1828, 0x0000000000000000ULL, 0x7053541B0C1AB395ULL }, /* XSUM_XXH64_testdata[3656] */
    { 1828, 0x000000009E3779B1ULL, 0x581F636679AF086BULL }, /* XSUM_XXH64_testdata[3657] */
    { 1829, 0x0000000000000000ULL, 0x7EC791BA03FCE492ULL }, /* XSUM_XXH64_testdata[3658] */
    { 1829, 0x000000009E3779B1ULL, 0x60B0DDDA8A70DF86ULL }, /* XSUM_XXH64_testdata[3659] */
    { 1830, 0x0000000000000000ULL, 0x67A2D183F5D03E2FULL }, /* XSUM_XXH64_testdata[3660] */
    { 1830, 0x000000009E3779B1ULL, 0xD528B12BD0B8D672ULL }, /* XSUM_XXH64_testdata[3661] */
    { 1831, 0x0000000000000000ULL, 0x67095D4F93F6E553ULL }, /* XSUM_XXH64_testdata[3662] */
    { 1831, 0x000000009E3779B1ULL, 0x304B433FA638E8BFULL }, /* XSUM_XXH64_testdata[3663] */
    { 1832, 0x0000000000000000ULL, 0x4C24C4C869106A95ULL }, /* XSUM_XXH64_testdata[3664] */
    { 1832, 0x000000009E3779B1ULL, 0xA180123F5C90E7A6ULL }, /* XSUM_XXH64_testdata[3665] */
    { 1833, 0x0000000000000000ULL, 0x21CE8B9EF29D0F98ULL }, /* XSUM_XXH64_testdata[3666] */
    { 1833, 0x000000009E3779B1ULL, 0xD7DE264A3846C875ULL }, /* XSUM_XXH64_testdata[3667] */
    { 1834, 0x0000000000000000ULL, 0xC50213C47C9958FBULL }, /* XSUM_XXH64_testdata[3668] */
    { 1834, 0x000000009E3779B1ULL, 0x42F6D146EFCE1583ULL }, /* XSUM_XXH64_testdata[3669] */
    { 1835, 0x0000000000000000ULL, 0x7E0E1533A208D7ECULL }, /* XSUM_XXH64_testdata[3670] */
    { 1835, 0x000000009E3779B1ULL, 0x0A07445114390317ULL }, /* XSUM_XXH64_testdata[3671] */
    { 1836, 0x0000000000000000ULL, 0xFBDD009852DE3524ULL }, /* XSUM_XXH64_testdata[3672] */
    { 1836, 0x000000009E3779B1ULL, 0x618838F56C9E5AB5ULL }, /* XSUM_XXH64_testdata[3673] */
    { 1837, 0x0000000000000000ULL, 0x676676CA10702072ULL }, /* XSUM_XXH64_testdata[3674] */
    { 1837, 0x000000009E3779B1ULL, 0xF179132BDD4BDAABULL }, /* XSUM_XXH64_testdata[3675] */
    { 1838, 0x0000000000000000ULL, 0xA4CBF37225582A90ULL }, /* XSUM_XXH64_testdata[3676] */
    { 1838, 0x000000009E3779B1ULL, 0x15BE563CC879BA7CULL }, /* XSUM_XXH64_testdata[3677] */
    { 1839, 0x0000000000000000ULL, 0x2F3ADF19315F7B23ULL }, /* XSUM_XXH64_testdata[3678] */
    { 1839, 0x000000009E3779B1ULL, 0x54405A06065FFD92ULL }, /* XSUM_XXH64_testdata[3679] */
    { 1840, 0x0000000000000000ULL, 0x83C859C0BACD65C2ULL }, /* XSUM_XXH64_testdata[3680] */
    { 1840, 0x000000009E3779B1ULL, 0x93AEBE7C2F426C81ULL }, /* XSUM_XXH64_testdata[3681] */
    { 1841, 0x0000000000000000ULL, 0x2E2E0354DB51681EULL }, /* XSUM_XXH64_testdata[3682] */
    { 1841, 0x000000009E3779B1ULL, 0x53A91CDED50F56E5ULL }, /* XSUM_XXH64_testdata[3683] */
    { 1842, 0x0000000000000000ULL, 0x8DE944AC4FA75183ULL }, /* XSUM_XXH64_testdata[3684] */
    { 1842, 0x000000009E3779B1ULL, 0x39C8893E34B9E6EFULL }, /* XSUM_XXH64_testdata[3685] */
    { 1843, 0x0000000000000000ULL, 0x0A23FBE54BCA92FAULL }, /* XSUM_XXH64_testdata[3686] */
    { 1843, 0x000000009E3779B1ULL, 0x95DDEB83526CB960ULL }, /* XSUM_XXH64_testdata[3687] */
    { 1844, 0x0000000000000000ULL, 0xC8A92677F1B07BC6ULL }, /* XSUM_XXH64_testdata[3688] */
    { 1844, 0x000000009E3779B1ULL, 0x640867D93ABFC476ULL }, /* XSUM_XXH64_testdata[3689] */
    { 1845, 0x0000000000000000ULL, 0xA648255EB632C796ULL }, /* XSUM_XXH64_testdata[3690] */
    { 1845, 0x000000009E3779B1ULL, 0x9F6CDE95BFDDCBB1ULL }, /* XSUM_XXH64_testdata[3691] */
    { 1846, 0x0000000000000000ULL, 0x30E382C8BCE8B80EULL }, /* XSUM_XXH64_testdata[3692] */
    { 1846, 0x000000009E3779B1ULL, 0xB5E55AD6BDF29F97ULL }, /* XSUM_XXH64_testdata[3693] */
    { 1847, 0x0000000000000000ULL, 0x8FD8106336630653ULL }, /* XSUM_XXH64_testdata[3694] */
    { 1847, 0x000000009E3779B1ULL, 0x0629F6712228ED3DULL }, /* XSUM_XXH64_testdata[3695] */
    { 1848, 0x0000000000000000ULL, 0x79B1CD7DAA94A618ULL }, /* XSUM_XXH64_testdata[3696] */
    { 1848, 0x000000009E3779B1ULL, 0x4114CA65265D35A8ULL }, /* XSUM_XXH64_testdata[3697] */
    { 1849, 0x0000000000000000ULL, 0x3AB01D69EB0EC09BULL }, /* XSUM_XXH64_testdata[3698] */
    { 1849, 0x000000009E3779B1ULL, 0x67ED35FD7918B8D9ULL }, /* XSUM_XXH64_testdata[3699] */
    { 1850, 0x0000000000000000ULL, 0xF62C3364D92DB928ULL }, /* XSUM_XXH64_testdata[3700] */
    { 1850, 0x000000009E3779B1ULL, 0x77B5F04363801A45ULL }, /* XSUM_XXH64_testdata[3701] */
    { 1851, 0x0000000000000000ULL, 0x098DD4D5B1ACF93CULL }, /* XSUM_XXH64_testdata[3702] */
    { 1851, 0x000000009E3779B1ULL, 0x60E13D42467485CEULL }, /* XSUM_XXH64_testdata[3703] */
    { 1852, 0x0000000000000000ULL, 0x00A4CC77EB00DD8CULL }, /* XSUM_XXH64_testdata[3704] */
    { 1852, 0x000000009E3779B1ULL, 0x264CB5B9B244E326ULL }, /* XSUM_XXH64_testdata[3705] */
    { 1853, 0x0000000000000000ULL, 0x368BD39B027D2F55ULL }, /* XSUM_XXH64_testdata[3706] */
    { 1853, 0x000000009E3779B1ULL, 0x7D5B5C6BB7248846ULL }, /* XSUM_XXH64_testdata[3707] */
    { 1854, 0x0000000000000000ULL, 0xC21D8794C543BBD3ULL }, /* XSUM_XXH64_testdata[3708] */
    { 1854, 0x000000009E3779B1ULL, 0x6C9849FC2608223CULL }, /* XSUM_XXH64_testdata[3709] */
    { 1855, 0x0000000000000000ULL, 0xB6540CCCF144B408ULL }, /* XSUM_XXH64_testdata[3710] */
    { 1855, 0x000000009E3779B1ULL, 0xB3FF3C8C9BB34DB2ULL }, /* XSUM_XXH64_testdata[3711] */
    { 1856, 0x0000000000000000ULL, 0x1FD57CC3A28B8B2FULL }, /* XSUM_XXH64_testdata[3712] */
    { 1856, 0x000000009E3779B1ULL, 0x0AC9224B7A7DE1A3ULL }, /* XSUM_XXH64_testdata[3713] */
    { 1857, 0x0000000000000000ULL, 0x8E5BEF30C4CCCE13ULL }, /* XSUM_XXH64_testdata[3714] */
    { 1857, 0x000000009E3779B1ULL, 0x0DC284EF18A34E94ULL }, /* XSUM_XXH64_testdata[3715] */
    { 1858, 0x0000000000000000ULL, 0xD183A589101F350DULL }, /* XSUM_XXH64_testdata[3716] */
    { 1858, 0x000000009E3779B1ULL, 0x6974B50A5ED9C55EULL }, /* XSUM_XXH64_testdata[3717] */
    { 1859, 0x0000000000000000ULL, 0x8A760EA06A32DCA4ULL }, /* XSUM_XXH64_testdata[3718] */
    { 1859, 0x000000009E3779B1ULL, 0x279374754D9ACB15ULL }, /* XSUM_XXH64_testdata[3719] */
    { 1860, 0x0000000000000000ULL, 0x67A71611B4E28F90ULL }, /* XSUM_XXH64_testdata[3720] */
    { 1860, 0x000000009E3779B1ULL, 0x46E1ADAAD0C971C7ULL }, /* XSUM_XXH64_testdata[3721] */
    { 1861, 0x0000000000000000ULL, 0xA2DEFC2A9887F526ULL }, /* XSUM_XXH64_testdata[3722] */
    { 1861, 0x000000009E3779B1ULL, 0x3BF6FC439ED5CBB4ULL }, /* XSUM_XXH64_testdata[3723] */
    { 1862, 0x0000000000000000ULL, 0x3FDA4CB9D1B4E91FULL }, /* XSUM_XXH64_testdata[3724] */
    { 1862, 0x000000009E3779B1ULL, 0x9A414C868F5DA835ULL }, /* XSUM_XXH64_testdata[3725] */
    { 1863, 0x0000000000000000ULL, 0xDB51F7445602B84FULL }, /* XSUM_XXH64_testdata[3726] */
    { 1863, 0x000000009E3779B1ULL, 0x5F1CEC7931D75D05ULL }, /* XSUM_XXH64_testdata[3727] */
    { 1864, 0x0000000000000000ULL, 0x0F58BB727F134477ULL }, /* XSUM_XXH64_testdata[3728] */
    { 1864, 0x000000009E3779B1ULL, 0xDF6DD5AB012398DAULL }, /* XSUM_XXH64_testdata[3729] */
    { 1865, 0x0000000000000000ULL, 0x74671FC0F2F2353CULL }, /* XSUM_XXH64_testdata[3730] */
    { 1865, 0x000000009E3779B1ULL, 0x34C10B2DC838DE09ULL }, /* XSUM_XXH64_testdata[3731] */
    { 1866, 0x0000000000000000ULL, 0xD15EF99D440333D1ULL }, /* XSUM_XXH64_testdata[3732] */
    { 1866, 0x000000009E3779B1ULL, 0xD6C76CB377C44611ULL }, /* XSUM_XXH64_testdata[3733] */
    { 1867, 0x0000000000000000ULL, 0xE32B4DCEAB692564ULL }, /* XSUM_XXH64_testdata[3734] */
    { 1867, 0x000000009E3779B1ULL, 0x9C31B2522984FD1FULL }, /* XSUM_XXH64_testdata[3735] */
    { 1868, 0x0000000000000000ULL, 0x12E8A18B72B4EB64ULL }, /* XSUM_XXH64_testdata[3736] */
    { 1868, 0x000000009E3779B1ULL, 0x210B2AC415D693BEULL }, /* XSUM_XXH64_testdata[3737] */
    { 1869, 0x0000000000000000ULL, 0x4707734110EF4F89ULL }, /* XSUM_XXH64_testdata[3738] */
    { 1869, 0x000000009E3779B1ULL, 0x573E3DACBFA62409ULL }, /* XSUM_XXH64_testdata[3739] */
    { 1870, 0x0000000000000000ULL, 0xE33A3E826B08855FULL }, /* XSUM_XXH64_testdata[3740] */
    { 1870, 0x000000009E3779B1ULL, 0x57EC447641925F48ULL }, /* XSUM_XXH64_testdata[3741] */
    { 1871, 0x0000000000000000ULL, 0x91F75B9458D06D71ULL }, /* XSUM_XXH64_testdata[3742] */
    { 1871, 0x000000009E3779B1ULL, 0x75A44826FFAB2417ULL }, /* XSUM_XXH64_testdata[3743] */
    { 1872, 0x0000000000000000ULL, 0x67F9F3BCA1F98F91ULL }, /* XSUM_XXH64_testdata[3744] */
    { 1872, 0x000000009E3779B1ULL, 0x7140DE7D50A0F686ULL }, /* XSUM_XXH64_testdata[3745] */
    { 1873, 0x0000000000000000ULL, 0x29FB2618263CC7A5ULL }, /* XSUM_XXH64_testdata[3746] */
    { 1873, 0x000000009E3779B1ULL, 0x390F98420FB3744FULL }, /* XSUM_XXH64_testdata[3747] */
    { 1874, 0x0000000000000000ULL, 0x2FEF3A35EA158263ULL }, /* XSUM_XXH64_testdata[3748] */
    { 1874, 0x000000009E3779B1ULL, 0x47B812A89C42F79FULL }, /* XSUM_XXH64_testdata[3749] */
    { 1875, 0x0000000000000000ULL, 0xD35E467343E1C3EBULL }, /* XSUM_XXH64_testdata[3750] */
    { 1875, 0x000000009E3779B1ULL, 0x470C019EC0977AEBULL }, /* XSUM_XXH64_testdata[3751] */
    { 1876, 0x0000000000000000ULL, 0xD866F27E7D33E219ULL }, /* XSUM_XXH64_testdata[3752] */
    { 1876, 0x000000009E3779B1ULL, 0x7B9C180CDE847FBFULL }, /* XSUM_XXH64_testdata[3753] */
    { 1877, 0x0000000000000000ULL, 0x2F4FE98177598E11ULL }, /* XSUM_XXH64_testdata[3754] */
    { 1877, 0x000000009E3779B1ULL, 0xAB02B72BF07B98D3ULL }, /* XSUM_XXH64_testdata[3755] */
    { 1878, 0x0000000000000000ULL, 0x2A420724B7DFB3B4ULL }, /* XSUM_XXH64_testdata[3756] */
    { 1878, 0x000000009E3779B1ULL, 0x2220B4D002F11057ULL }, /* XSUM_XXH64_testdata[3757] */
    { 1879, 0x0000000000000000ULL, 0x975DA402B27ACDB9ULL }, /* XSUM_XXH64_testdata[3758] */
    { 1879, 0x000000009E3779B1ULL, 0x5A444D678026DE66ULL }, /* XSUM_XXH64_testdata[3759] */
    { 1880, 0x0000000000000000ULL, 0x6454317F3170F18FULL }, /* XSUM_XXH64_testdata[3760] */
    { 1880, 0x000000009E3779B1ULL, 0x0BF5C212FBBFB2B9ULL }, /* XSUM_XXH64_testdata[3761] */
    { 1881, 0x0000000000000000ULL, 0x1996DEE2EE0411F4ULL }, /* XSUM_XXH64_testdata[3762] */
    { 1881, 0x000000009E3779B1ULL, 0xF07AAC423BD2698FULL }, /* XSUM_XXH64_testdata[3763] */
    { 1882, 0x0000000000000000ULL, 0xE3DA0CA62EB2881DULL }, /* XSUM_XXH64_testdata[3764] */
    { 1882, 0x000000009E3779B1ULL, 0xDF5429E239AA2430ULL }, /* XSUM_XXH64_testdata[3765] */
    { 1883, 0x0000000000000000ULL, 0xBEDD401C30B15316ULL }, /* XSUM_XXH64_testdata[3766] */
    { 1883, 0x000000009E3779B1ULL, 0x54AF0513CEF2A9FCULL }, /* XSUM_XXH64_testdata[3767] */
    { 1884, 0x0000000000000000ULL, 0x9E5CB412E4FB4F2CULL }, /* XSUM_XXH64_testdata[3768] */
    { 1884, 0x000000009E3779B1ULL, 0x7380BEC5F8F6BCBEULL }, /* XSUM_XXH64_testdata[3769] */
    { 1885, 0x0000000000000000ULL, 0xBCC7A7AAF9189A73ULL }, /* XSUM_XXH64_testdata[3770] */
    { 1885, 0x000000009E3779B1ULL, 0xD916FB038C5B8A56ULL }, /* XSUM_XXH64_testdata[3771] */
    { 1886, 0x0000000000000000ULL, 0xFF1F7499DA4C60BFULL }, /* XSUM_XXH64_testdata[3772] */
    { 1886, 0x000000009E3779B1ULL, 0x1D69724F18C1D7A0ULL }, /* XSUM_XXH64_testdata[3773] */
    { 1887, 0x0000000000000000ULL, 0xE04F9872D49D7344ULL }, /* XSUM_XXH64_testdata[3774] */
    { 1887, 0x000000009E3779B1ULL, 0xAC821F6DF95BB2B1ULL }, /* XSUM_XXH64_testdata[3775] */
    { 1888, 0x0000000000000000ULL, 0xC5C66830F2119D9EULL }, /* XSUM_XXH64_testdata[3776] */
    { 1888, 0x000000009E3779B1ULL, 0xA4FC5298D9EBB759ULL }, /* XSUM_XXH64_testdata[3777] */
    { 1889, 0x0000000000000000ULL, 0x681BA4449171958CULL }, /* XSUM_XXH64_testdata[3778] */
    { 1889, 0x000000009E3779B1ULL, 0x12E0521ED047B501ULL }, /* XSUM_XXH64_testdata[3779] */
    { 1890, 0x0000000000000000ULL, 0x4E9510238C49AD2FULL }, /* XSUM_XXH64_testdata[3780] */
    { 1890, 0x000000009E3779B1ULL, 0xBA954E0BF88B5829ULL }, /* XSUM_XXH64_testdata[3781] */
    { 1891, 0x0000000000000000ULL, 0xFB5221E42BB0C833ULL }, /* XSUM_XXH64_testdata[3782] */
    { 1891, 0x000000009E3779B1ULL, 0x2AA5F1095C25A2BCULL }, /* XSUM_XXH64_testdata[3783] */
    { 1892, 0x0000000000000000ULL, 0x8E970A1906282CFAULL }, /* XSUM_XXH64_testdata[3784] */
    { 1892, 0x000000009E3779B1ULL, 0xBFC9EBEAF7BA9C55ULL }, /* XSUM_XXH64_testdata[3785] */
    { 1893, 0x0000000000000000ULL, 0x4575D188C3A5152CULL }, /* XSUM_XXH64_testdata[3786] */
    { 1893, 0x000000009E3779B1ULL, 0x42AA1A42C891711AULL }, /* XSUM_XXH64_testdata[3787] */
    { 1894, 0x0000000000000000ULL, 0x4F68CCD0752A3DBBULL }, /* XSUM_XXH64_testdata[3788] */
    { 1894, 0x000000009E3779B1ULL, 0x71E062B6046D5CB9ULL }, /* XSUM_XXH64_testdata[3789] */
    { 1895, 0x0000000000000000ULL, 0xB224B2F6630C6397ULL }, /* XSUM_XXH64_testdata[3790] */
    { 1895, 0x000000009E3779B1ULL, 0xD8CCCD3D84F09463ULL }, /* XSUM_XXH64_testdata[3791] */
    { 1896, 0x0000000000000000ULL, 0x409D41078E0B8250ULL }, /* XSUM_XXH64_testdata[3792] */
    { 1896, 0x000000009E3779B1ULL, 0x469F0A5A48B3AA1EULL }, /* XSUM_XXH64_testdata[3793] */
    { 1897, 0x0000000000000000ULL, 0xEA88E6A7BE7CE0EFULL }, /* XSUM_XXH64_testdata[3794] */
    { 1897, 0x000000009E3779B1ULL, 0xB27CD3B095339B9CULL }, /* XSUM_XXH64_testdata[3795] */
    { 1898, 0x0000000000000000ULL, 0x29D39C1B14C470F8ULL }, /* XSUM_XXH64_testdata[3796] */
    { 1898, 0x000000009E3779B1ULL, 0x0A7CCABF2F95AB4FULL }, /* XSUM_XXH64_testdata[3797] */
    { 1899, 0x0000000000000000ULL, 0x7276FC8C2732236AULL }, /* XSUM_XXH64_testdata[3798] */
    { 1899, 0x000000009E3779B1ULL, 0x0CC2058938976D69ULL }, /* XSUM_XXH64_testdata[3799] */
    { 1900, 0x0000000000000000ULL, 0xA193F2EFD70BA805ULL }, /* XSUM_XXH64_testdata[3800] */
    { 1900, 0x000000009E3779B1ULL, 0x5D0CDC160A8675DDULL }, /* XSUM_XXH64_testdata[3801] */
    { 1901, 0x0000000000000000ULL, 0x61CC8DAE752C620EULL }, /* XSUM_XXH64_testdata[3802] */
    { 1901, 0x000000009E3779B1ULL, 0x973ABA1FD4F6A337ULL }, /* XSUM_XXH64_testdata[3803] */
    { 1902, 0x0000000000000000ULL, 0xA0A19AB5E1E3B64AULL }, /* XSUM_XXH64_testdata[3804] */
    { 1902, 0x000000009E3779B1ULL, 0xC50B5833783C2774ULL }, /* XSUM_XXH64_testdata[3805] */
    { 1903, 0x0000000000000000ULL, 0xE8299E51B678F032ULL }, /* XSUM_XXH64_testdata[3806] */
    { 1903, 0x000000009E3779B1ULL, 0xE1EE9F03CB62A3C6ULL }, /* XSUM_XXH64_testdata[3807] */
    { 1904, 0x0000000000000000ULL, 0x4A30720C9E532B7DULL }, /* XSUM_XXH64_testdata[3808] */
    { 1904, 0x000000009E3779B1ULL, 0x950B36638292336EULL }, /* XSUM_XXH64_testdata[3809] */
    { 1905, 0x0000000000000000ULL, 0x8732252AF5EA79CFULL }, /* XSUM_XXH64_testdata[3810] */
    { 1905, 0x000000009E3779B1ULL, 0xE34EEEEE1668D061ULL }, /* XSUM_XXH64_testdata[3811] */
    { 1906, 0x0000000000000000ULL, 0xECDDE30992D9DEC1ULL }, /* XSUM_XXH64_testdata[3812] */
    { 1906, 0x000000009E3779B1ULL, 0x53A447722B822E76ULL }, /* XSUM_XXH64_testdata[3813] */
    { 1907, 0x0000000000000000ULL, 0xB7E5AADB1BC4AC8BULL }, /* XSUM_XXH64_testdata[3814] */
    { 1907, 0x000000009E3779B1ULL, 0x82F497683FEACCD8ULL }, /* XSUM_XXH64_testdata[3815] */
    { 1908, 0x0000000000000000ULL, 0xD7311D87C9F93721ULL }, /* XSUM_XXH64_testdata[3816] */
    { 1908, 0x000000009E3779B1ULL, 0x51BF57BB18AFFAB4ULL }, /* XSUM_XXH64_testdata[3817] */
    { 1909, 0x0000000000000000ULL, 0x893B2C069A06A810ULL }, /* XSUM_XXH64_testdata[3818] */
    { 1909, 0x000000009E3779B1ULL, 0x0A450D1442501FD1ULL }, /* XSUM_XXH64_testdata[3819] */
    { 1910, 0x0000000000000000ULL, 0x38CB9156B3DE406EULL }, /* XSUM_XXH64_testdata[3820] */
    { 1910, 0x000000009E3779B1ULL, 0xCECCEBA93C6318D6ULL }, /* XSUM_XXH64_testdata[3821] */
    { 1911, 0x0000000000000000ULL, 0x2DA4871734515E8DULL }, /* XSUM_XXH64_testdata[3822] */
    { 1911, 0x000000009E3779B1ULL, 0x5644DD2251463DEEULL }, /* XSUM_XXH64_testdata[3823] */
    { 1912, 0x0000000000000000ULL, 0xD1216FF4E187173BULL }, /* XSUM_XXH64_testdata[3824] */
    { 1912, 0x000000009E3779B1ULL, 0x75F6605758F96652ULL }, /* XSUM_XXH64_testdata[3825] */
    { 1913, 0x0000000000000000ULL, 0xA55106AD72FF20F7ULL }, /* XSUM_XXH64_testdata[3826] */
    { 1913, 0x000000009E3779B1ULL, 0x4C4E77E22AC19C68ULL }, /* XSUM_XXH64_testdata[3827] */
    { 1914, 0x0000000000000000ULL, 0xF2475FD5C8971EDEULL }, /* XSUM_XXH64_testdata[3828] */
    { 1914, 0x000000009E3779B1ULL, 0x7350C8F7A15C7BFBULL }, /* XSUM_XXH64_testdata[3829] */
    { 1915, 0x0000000000000000ULL, 0x9E3EB7DB43AAACC3ULL }, /* XSUM_XXH64_testdata[3830] */
    { 1915, 0x000000009E3779B1ULL, 0x6510016F6BD747CAULL }, /* XSUM_XXH64_testdata[3831] */
    { 1916, 0x0000000000000000ULL, 0xD20A8FC57EABF467ULL }, /* XSUM_XXH64_testdata[3832] */
    { 1916, 0x000000009E3779B1ULL, 0xEFEEC3C059548C34ULL }, /* XSUM_XXH64_testdata[3833] */
    { 1917, 0x0000000000000000ULL, 0x537B84A9E4A2CFC7ULL }, /* XSUM_XXH64_testdata[3834] */
    { 1917, 0x000000009E3779B1ULL, 0xA2201494985BC745ULL }, /* XSUM_XXH64_testdata[3835] */
    { 1918, 0x0000000000000000ULL, 0x5294A1D07CC928B2ULL }, /* XSUM_XXH64_testdata[3836] */
    { 1918, 0x000000009E3779B1ULL, 0xFE7492D9CC08EE91ULL }, /* XSUM_XXH64_testdata[3837] */
    { 1919, 0x0000000000000000ULL, 0xD888A0374241D67DULL }, /* XSUM_XXH64_testdata[3838] */
    { 1919, 0x000000009E3779B1ULL, 0x52F7BE1192F8B0ABULL }, /* XSUM_XXH64_testdata[3839] */
    { 1920, 0x0000000000000000ULL, 0xAA3A4331FBFB9253ULL }, /* XSUM_XXH64_testdata[3840] */
    { 1920, 0x000000009E3779B1ULL, 0xB78B7AC8C44DC573ULL }, /* XSUM_XXH64_testdata[3841] */
    { 1921, 0x0000000000000000ULL, 0x8A55562623C20B73ULL }, /* XSUM_XXH64_testdata[3842] */
    { 1921, 0x000000009E3779B1ULL, 0xD920F4EDFE36E3F5ULL }, /* XSUM_XXH64_testdata[3843] */
    { 1922, 0x0000000000000000ULL, 0x1244034630E45543ULL }, /* XSUM_XXH64_testdata[3844] */
    { 1922, 0x000000009E3779B1ULL, 0x50F2479E6884A940ULL }, /* XSUM_XXH64_testdata[3845] */
    { 1923, 0x0000000000000000ULL, 0xE887672177AC3D01ULL }, /* XSUM_XXH64_testdata[3846] */
    { 1923, 0x000000009E3779B1ULL, 0x049C7CDB2AC31032ULL }, /* XSUM_XXH64_testdata[3847] */
    { 1924, 0x0000000000000000ULL, 0x1ADAC6C8C8DAD1DCULL }, /* XSUM_XXH64_testdata[3848] */
    { 1924, 0x000000009E3779B1ULL, 0x4D40152D5A550466ULL }, /* XSUM_XXH64_testdata[3849] */
    { 1925, 0x0000000000000000ULL, 0x999E55C1CBBB589BULL }, /* XSUM_XXH64_testdata[3850] */
    { 1925, 0x000000009E3779B1ULL, 0x9C0AA49DE94A3E94ULL }, /* XSUM_XXH64_testdata[3851] */
    { 1926, 0x0000000000000000ULL, 0xEDA1333D6075BB82ULL }, /* XSUM_XXH64_testdata[3852] */
    { 1926, 0x000000009E3779B1ULL, 0x144C5654454EF3F9ULL }, /* XSUM_XXH64_testdata[3853] */
    { 1927, 0x0000000000000000ULL, 0xA912F39DDF660890ULL }, /* XSUM_XXH64_testdata[3854] */
    { 1927, 0x000000009E3779B1ULL, 0x117170CF22EB5CAAULL }, /* XSUM_XXH64_testdata[3855] */
    { 1928, 0x0000000000000000ULL, 0xF39D5BCE889B4EF8ULL }, /* XSUM_XXH64_testdata[3856] */
    { 1928, 0x000000009E3779B1ULL, 0x8473A57B4487767DULL }, /* XSUM_XXH64_testdata[3857] */
    { 1929, 0x0000000000000000ULL, 0x78B0C0B645BE305FULL }, /* XSUM_XXH64_testdata[3858] */
    { 1929, 0x000000009E3779B1ULL, 0x4F878D6CDAB1AAE9ULL }, /* XSUM_XXH64_testdata[3859] */
    { 1930, 0x0000000000000000ULL, 0x2E57F3980656C1E4ULL }, /* XSUM_XXH64_testdata[3860] */
    { 1930, 0x000000009E3779B1ULL, 0xD5CCAFD481116352ULL }, /* XSUM_XXH64_testdata[3861] */
    { 1931, 0x0000000000000000ULL, 0x4516616F1D35FF2DULL }, /* XSUM_XXH64_testdata[3862] */
    { 1931, 0x000000009E3779B1ULL, 0xDA186B536C18DCDEULL }, /* XSUM_XXH64_testdata[3863] */
    { 1932, 0x0000000000000000ULL, 0x98DBC2BE1A771D87ULL }, /* XSUM_XXH64_testdata[3864] */
    { 1932, 0x000000009E3779B1ULL, 0xC202F6422D28EF77ULL }, /* XSUM_XXH64_testdata[3865] */
    { 1933, 0x0000000000000000ULL, 0xE9EAC37CF11571CCULL }, /* XSUM_XXH64_testdata[3866] */
    { 1933, 0x000000009E3779B1ULL, 0xA70CB2C1A5CC87EDULL }, /* XSUM_XXH64_testdata[3867] */
    { 1934, 0x0000000000000000ULL, 0x85155A8728EC7D6DULL }, /* XSUM_XXH64_testdata[3868] */
    { 1934, 0x000000009E3779B1ULL, 0x176EA6806965497EULL }, /* XSUM_XXH64_testdata[3869] */
    { 1935, 0x0000000000000000ULL, 0xCF04A6647082FE76ULL }, /* XSUM_XXH64_testdata[3870] */
    { 1935, 0x000000009E3779B1ULL, 0x26A991B9518896C7ULL }, /* XSUM_XXH64_testdata[3871] */
    { 1936, 0x0000000000000000ULL, 0x23D3266C6C71FF2AULL }, /* XSUM_XXH64_testdata[3872] */
    { 1936, 0x000000009E3779B1ULL, 0xEEF61E4054BD033AULL }, /* XSUM_XXH64_testdata[3873] */
    { 1937, 0x0000000000000000ULL, 0x8428AC7F24DAC012ULL }, /* XSUM_XXH64_testdata[3874] */
    { 1937, 0x000000009E3779B1ULL, 0xA3951A07D9E6417DULL }, /* XSUM_XXH64_testdata[3875] */
    { 1938, 0x0000000000000000ULL, 0x688DBBD59ABD11E0ULL }, /* XSUM_XXH64_testdata[3876] */
    { 1938, 0x000000009E3779B1ULL, 0x09780B80B2A7B063ULL }, /* XSUM_XXH64_testdata[3877] */
    { 1939, 0x0000000000000000ULL, 0x89D94BFD2170692FULL }, /* XSUM_XXH64_testdata[3878] */
    { 1939, 0x000000009E3779B1ULL, 0x61E2AE56DA6B4DF8ULL }, /* XSUM_XXH64_testdata[3879] */
    { 1940, 0x0000000000000000ULL, 0x2EAE10D307800B7CULL }, /* XSUM_XXH64_testdata[3880] */
    { 1940, 0x000000009E3779B1ULL, 0x4BA2D93551E4276EULL }, /* XSUM_XXH64_testdata[3881] */
    { 1941, 0x0000000000000000ULL, 0x20AB4C7DC9ADD088ULL }, /* XSUM_XXH64_testdata[3882] */
    { 1941, 0x000000009E3779B1ULL, 0x0B8F7EF29FD0F005ULL }, /* XSUM_XXH64_testdata[3883] */
    { 1942, 0x0000000000000000ULL, 0xA4B7BA7CC53C3F67ULL }, /* XSUM_XXH64_testdata[3884] */
    { 1942, 0x000000009E3779B1ULL, 0xF82EABF938492265ULL }, /* XSUM_XXH64_testdata[3885] */
    { 1943, 0x0000000000000000ULL, 0x6DBF7A2FBCC0D6EFULL }, /* XSUM_XXH64_testdata[3886] */
    { 1943, 0x000000009E3779B1ULL, 0x910DA317A1674C64ULL }, /* XSUM_XXH64_testdata[3887] */
    { 1944, 0x0000000000000000ULL, 0xC817FCD2CBAFE750ULL }, /* XSUM_XXH64_testdata[3888] */
    { 1944, 0x000000009E3779B1ULL, 0xAA77E3610948AC81ULL }, /* XSUM_XXH64_testdata[3889] */
    { 1945, 0x0000000000000000ULL, 0x5FE7345255630096ULL }, /* XSUM_XXH64_testdata[3890] */
    { 1945, 0x000000009E3779B1ULL, 0xE749917062D92DE7ULL }, /* XSUM_XXH64_testdata[3891] */
    { 1946, 0x0000000000000000ULL, 0xE331D9E9299AADE8ULL }, /* XSUM_XXH64_testdata[3892] */
    { 1946, 0x000000009E3779B1ULL, 0x7BB4C81772B72580ULL }, /* XSUM_XXH64_testdata[3893] */
    { 1947, 0x0000000000000000ULL, 0x6AD92255D909ADFEULL }, /* XSUM_XXH64_testdata[3894] */
    { 1947, 0x000000009E3779B1ULL, 0x705C8D49236F29EDULL }, /* XSUM_XXH64_testdata[3895] */
    { 1948, 0x0000000000000000ULL, 0xAF80A33543B24E74ULL }, /* XSUM_XXH64_testdata[3896] */
    { 1948, 0x000000009E3779B1ULL, 0x8CE985712CDED01DULL }, /* XSUM_XXH64_testdata[3897] */
    { 1949, 0x0000000000000000ULL, 0x1A9A50D9743F2CFBULL }, /* XSUM_XXH64_testdata[3898] */
    { 1949, 0x000000009E3779B1ULL, 0xDD1B5EDF471B43AEULL }, /* XSUM_XXH64_testdata[3899] */
    { 1950, 0x0000000000000000ULL, 0xB23316DCFC81CCE9ULL }, /* XSUM_XXH64_testdata[3900] */
    { 1950, 0x000000009E3779B1ULL, 0x65A71ED6591E8982ULL }, /* XSUM_XXH64_testdata[3901] */
    { 1951, 0x0000000000000000ULL, 0x02ECCECBB39F953EULL }, /* XSUM_XXH64_testdata[3902] */
    { 1951, 0x000000009E3779B1ULL, 0x352A3F5F8390B079ULL }, /* XSUM_XXH64_testdata[3903] */
    { 1952, 0x0000000000000000ULL, 0x4B9DBE938BE2BBC2ULL }, /* XSUM_XXH64_testdata[3904] */
    { 1952, 0x000000009E3779B1ULL, 0xBF092C83744F1D7BULL }, /* XSUM_XXH64_testdata[3905] */
    { 1953, 0x0000000000000000ULL, 0xC85DB2749C4ACC47ULL }, /* XSUM_XXH64_testdata[3906] */
    { 1953, 0x000000009E3779B1ULL, 0xC5AA2240F4A7991CULL }, /* XSUM_XXH64_testdata[3907] */
    { 1954, 0x0000000000000000ULL, 0x83296B902D443812ULL }, /* XSUM_XXH64_testdata[3908] */
    { 1954, 0x000000009E3779B1ULL, 0x7D7A444F595EE483ULL }, /* XSUM_XXH64_testdata[3909] */
    { 1955, 0x0000000000000000ULL, 0x1ACC00E9129B7D59ULL }, /* XSUM_XXH64_testdata[3910] */
    { 1955, 0x000000009E3779B1ULL, 0x05BE7458D58E40A4ULL }, /* XSUM_XXH64_testdata[3911] */
    { 1956, 0x0000000000000000ULL, 0x2D994C6301AC08ACULL }, /* XSUM_XXH64_testdata[3912] */
    { 1956, 0x000000009E3779B1ULL, 0x15E6435017A01DE2ULL }, /* XSUM_XXH64_testdata[3913] */
    { 1957, 0x0000000000000000ULL, 0xD9EA1E578DC991B5ULL }, /* XSUM_XXH64_testdata[3914] */
    { 1957, 0x000000009E3779B1ULL, 0x94E049848E9F64C9ULL }, /* XSUM_XXH64_testdata[3915] */
    { 1958, 0x0000000000000000ULL, 0x78CEF1BA0440649BULL }, /* XSUM_XXH64_testdata[3916] */
    { 1958, 0x000000009E3779B1ULL, 0x6C882F0C1CF8028EULL }, /* XSUM_XXH64_testdata[3917] */
    { 1959, 0x0000000000000000ULL, 0x329FB8413C9058DBULL }, /* XSUM_XXH64_testdata[3918] */
    { 1959, 0x000000009E3779B1ULL, 0x78C774AB8CFFFD21ULL }, /* XSUM_XXH64_testdata[3919] */
    { 1960, 0x0000000000000000ULL, 0x17428B7B845AC341ULL }, /* XSUM_XXH64_testdata[3920] */
    { 1960, 0x000000009E3779B1ULL, 0xDD61181F6611204CULL }, /* XSUM_XXH64_testdata[3921] */
    { 1961, 0x0000000000000000ULL, 0xD745F8EF20D58947ULL }, /* XSUM_XXH64_testdata[3922] */
    { 1961, 0x000000009E3779B1ULL, 0xF46BF355CCACFBDCULL }, /* XSUM_XXH64_testdata[3923] */
    { 1962, 0x0000000000000000ULL, 0x58DC08544B290C03ULL }, /* XSUM_XXH64_testdata[3924] */
    { 1962, 0x000000009E3779B1ULL, 0x0D7F75871539BFA0ULL }, /* XSUM_XXH64_testdata[3925] */
    { 1963, 0x0000000000000000ULL, 0x5580F80FE25E642DULL }, /* XSUM_XXH64_testdata[3926] */
    { 1963, 0x000000009E3779B1ULL, 0x2866096338373E52ULL }, /* XSUM_XXH64_testdata[3927] */
    { 1964, 0x0000000000000000ULL, 0x5CCA0BC526A9C3BDULL }, /* XSUM_XXH64_testdata[3928] */
    { 1964, 0x000000009E3779B1ULL, 0x614943C253C46CC1ULL }, /* XSUM_XXH64_testdata[3929] */
    { 1965, 0x0000000000000000ULL, 0x3D80DFF7A798BE56ULL }, /* XSUM_XXH64_testdata[3930] */
    { 1965, 0x000000009E3779B1ULL, 0x200D8CC2426C8C6EULL }, /* XSUM_XXH64_testdata[3931] */
    { 1966, 0x0000000000000000ULL, 0x09509DE6E6B24C25ULL }, /* XSUM_XXH64_testdata[3932] */
    { 1966, 0x000000009E3779B1ULL, 0x750D6423ABB6BE0CULL }, /* XSUM_XXH64_testdata[3933] */
    { 1967, 0x0000000000000000ULL, 0x302C505B14EF6D5DULL }, /* XSUM_XXH64_testdata[3934] */
    { 1967, 0x000000009E3779B1ULL, 0xBE588C12741DF4FDULL }, /* XSUM_XXH64_testdata[3935] */
    { 1968, 0x0000000000000000ULL, 0xBBEFAE279DA04E62ULL }, /* XSUM_XXH64_testdata[3936] */
    { 1968, 0x000000009E3779B1ULL, 0x87FE20E0B3EDE474ULL }, /* XSUM_XXH64_testdata[3937] */
    { 1969, 0x0000000000000000ULL, 0xD37E7E583D7775E2ULL }, /* XSUM_XXH64_testdata[3938] */
    { 1969, 0x000000009E3779B1ULL, 0x4AB1C29A196EE7FFULL }, /* XSUM_XXH64_testdata[3939] */
    { 1970, 0x0000000000000000ULL, 0x809FBD5697D7D9AAULL }, /* XSUM_XXH64_testdata[3940] */
    { 1970, 0x000000009E3779B1ULL, 0xCF4FC79D89D9CA91ULL }, /* XSUM_XXH64_testdata[3941] */
    { 1971, 0x0000000000000000ULL, 0xE68AACB19FA51DBFULL }, /* XSUM_XXH64_testdata[3942] */
    { 1971, 0x000000009E3779B1ULL, 0xC89AF0ABBB0B5079ULL }, /* XSUM_XXH64_testdata[3943] */
    { 1972, 0x0000000000000000ULL, 0x8AEBA0D906EA87DCULL }, /* XSUM_XXH64_testdata[3944] */
    { 1972, 0x000000009E3779B1ULL, 0xE232F48721B619F7ULL }, /* XSUM_XXH64_testdata[3945] */
    { 1973, 0x0000000000000000ULL, 0xDD791CC66475568EULL }, /* XSUM_XXH64_testdata[3946] */
    { 1973, 0x000000009E3779B1ULL, 0xCEEF7A9275FBA21CULL }, /* XSUM_XXH64_testdata[3947] */
    { 1974, 0x0000000000000000ULL, 0x904F000BA52402B4ULL }, /* XSUM_XXH64_testdata[3948] */
    { 1974, 0x000000009E3779B1ULL, 0x9414203BBEC1C96FULL }, /* XSUM_XXH64_testdata[3949] */
    { 1975, 0x0000000000000000ULL, 0x4C0F3B496D570402ULL }, /* XSUM_XXH64_testdata[3950] */
    { 1975, 0x000000009E3779B1ULL, 0x06EEC96A1DD0B4E6ULL }, /* XSUM_XXH64_testdata[3951] */
    { 1976, 0x0000000000000000ULL, 0x78A0A17A42C2D78AULL }, /* XSUM_XXH64_testdata[3952] */
    { 1976, 0x000000009E3779B1ULL, 0x50BFA0D736C207BEULL }, /* XSUM_XXH64_testdata[3953] */
    { 1977, 0x0000000000000000ULL, 0xCC92F434D4F6AAACULL }, /* XSUM_XXH64_testdata[3954] */
    { 1977, 0x000000009E3779B1ULL, 0xC892260DEFC04D2DULL }, /* XSUM_XXH64_testdata[3955] */
    { 1978, 0x0000000000000000ULL, 0xAE8BCDEA8C45C2FAULL }, /* XSUM_XXH64_testdata[3956] */
    { 1978, 0x000000009E3779B1ULL, 0x3E98A1573B2DCF2BULL }, /* XSUM_XXH64_testdata[3957] */
    { 1979, 0x0000000000000000ULL, 0xACA3FFFA93EA3C50ULL }, /* XSUM_XXH64_testdata[3958] */
    { 1979, 0x000000009E3779B1ULL, 0x9DB5CDE739411A64ULL }, /* XSUM_XXH64_testdata[3959] */
    { 1980, 0x0000000000000000ULL, 0x96C2D9479421FE62ULL }, /* XSUM_XXH64_testdata[3960] */
    { 1980, 0x000000009E3779B1ULL, 0xAD212FC0F390B219ULL }, /* XSUM_XXH64_testdata[3961] */
    { 1981, 0x0000000000000000ULL, 0xE98226F8F02EFD75ULL }, /* XSUM_XXH64_testdata[3962] */
    { 1981, 0x000000009E3779B1ULL, 0x7E9FA16D1DD08599ULL }, /* XSUM_XXH64_testdata[3963] */
    { 1982, 0x0000000000000000ULL, 0xA65E553BD359B07EULL }, /* XSUM_XXH64_testdata[3964] */
    { 1982, 0x000000009E3779B1ULL, 0x965C1A012957492EULL }, /* XSUM_XXH64_testdata[3965] */
    { 1983, 0x0000000000000000ULL, 0x88C25C2A304214F8ULL }, /* XSUM_XXH64_testdata[3966] */
    { 1983, 0x000000009E3779B1ULL, 0x09D47FC7FAD17081ULL }, /* XSUM_XXH64_testdata[3967] */
    { 1984, 0x0000000000000000ULL, 0xD67A96D6F1D56487ULL }, /* XSUM_XXH64_testdata[3968] */
    { 1984, 0x000000009E3779B1ULL, 0x332368D129DB8298ULL }, /* XSUM_XXH64_testdata[3969] */
    { 1985, 0x0000000000000000ULL, 0xCD3E5C6902A97395ULL }, /* XSUM_XXH64_testdata[3970] */
    { 1985, 0x000000009E3779B1ULL, 0xE9B7E0E8F2959B87ULL }, /* XSUM_XXH64_testdata[3971] */
    { 1986, 0x0000000000000000ULL, 0x1FC418BBB40177DAULL }, /* XSUM_XXH64_testdata[3972] */
    { 1986, 0x000000009E3779B1ULL, 0x193738968EBD6626ULL }, /* XSUM_XXH64_testdata[3973] */
    { 1987, 0x0000000000000000ULL, 0x1889E59C0549E0B0ULL }, /* XSUM_XXH64_testdata[3974] */
    { 1987, 0x000000009E3779B1ULL, 0x115F75C5C1F6A537ULL }, /* XSUM_XXH64_testdata[3975] */
    { 1988, 0x0000000000000000ULL, 0x2BF40954EAF218EAULL }, /* XSUM_XXH64_testdata[3976] */
    { 1988, 0x000000009E3779B1ULL, 0x4F739C5580C0F3E3ULL }, /* XSUM_XXH64_testdata[3977] */
    { 1989, 0x0000000000000000ULL, 0x0A4828AF9D5B8AFDULL }, /* XSUM_XXH64_testdata[3978] */
    { 1989, 0x000000009E3779B1ULL, 0x9EAFAE02A89A4AF2ULL }, /* XSUM_XXH64_testdata[3979] */
    { 1990, 0x0000000000000000ULL, 0x66AE938ABE8C0CC5ULL }, /* XSUM_XXH64_testdata[3980] */
    { 1990, 0x000000009E3779B1ULL, 0xB5DC6233ABF8B4BCULL }, /* XSUM_XXH64_testdata[3981] */
    { 1991, 0x0000000000000000ULL, 0xFA8FB6CC100885E3ULL }, /* XSUM_XXH64_testdata[3982] */
    { 1991, 0x000000009E3779B1ULL, 0x6E02C0E3382D578CULL }, /* XSUM_XXH64_testdata[3983] */
    { 1992, 0x0000000000000000ULL, 0x749C36F3AEFA2C1EULL }, /* XSUM_XXH64_testdata[3984] */
    { 1992, 0x000000009E3779B1ULL, 0xC4F641C0C8D5F970ULL }, /* XSUM_XXH64_testdata[3985] */
    { 1993, 0x0000000000000000ULL, 0xC9CD385C074B4222ULL }, /* XSUM_XXH64_testdata[3986] */
    { 1993, 0x000000009E3779B1ULL, 0x2D45B405309A44D2ULL }, /* XSUM_XXH64_testdata[3987] */
    { 1994, 0x0000000000000000ULL, 0xB7E091603B400C8FULL }, /* XSUM_XXH64_testdata[3988] */
    { 1994, 0x000000009E3779B1ULL, 0xB93DD93AB556697DULL }, /* XSUM_XXH64_testdata[3989] */
    { 1995, 0x0000000000000000ULL, 0xFE0A6A79BB0C0EFDULL }, /* XSUM_XXH64_testdata[3990] */
    { 1995, 0x000000009E3779B1ULL, 0x642687CAE0CCA424ULL }, /* XSUM_XXH64_testdata[3991] */
    { 1996, 0x0000000000000000ULL, 0xDC49CAF48A9AFEF6ULL }, /* XSUM_XXH64_testdata[3992] */
    { 1996, 0x000000009E3779B1ULL, 0x7466B8231FB6C767ULL }, /* XSUM_XXH64_testdata[3993] */
    { 1997, 0x0000000000000000ULL, 0x6269E02B71E7624EULL }, /* XSUM_XXH64_testdata[3994] */
    { 1997, 0x000000009E3779B1ULL, 0x8FD9E352DCC5C664ULL }, /* XSUM_XXH64_testdata[3995] */
    { 1998, 0x0000000000000000ULL, 0x50C7D18C6AFAD885ULL }, /* XSUM_XXH64_testdata[3996] */
    { 1998, 0x000000009E3779B1ULL, 0xF4C7282BD3EC8313ULL }, /* XSUM_XXH64_testdata[3997] */
    { 1999, 0x0000000000000000ULL, 0xD153742553898C04ULL }, /* XSUM_XXH64_testdata[3998] */
    { 1999, 0x000000009E3779B1ULL, 0xC3DBDEEE307F5628ULL }, /* XSUM_XXH64_testdata[3999] */
    { 2000, 0x0000000000000000ULL, 0x62654B255049664BULL }, /* XSUM_XXH64_testdata[4000] */
    { 2000, 0x000000009E3779B1ULL, 0x9BA1C02E581B8E86ULL }, /* XSUM_XXH64_testdata[4001] */
    { 2001, 0x0000000000000000ULL, 0x769143921AA83703ULL }, /* XSUM_XXH64_testdata[4002] */
    { 2001, 0x000000009E3779B1ULL, 0xD7871173B036D41EULL }, /* XSUM_XXH64_testdata[4003] */
    { 2002, 0x0000000000000000ULL, 0xF8F15E36A0BA9379ULL }, /* XSUM_XXH64_testdata[4004] */
    { 2002, 0x000000009E3779B1ULL, 0x6F77C90391E133E3ULL }, /* XSUM_XXH64_testdata[4005] */
    { 2003, 0x0000000000000000ULL, 0xF4753A24B037ADEEULL }, /* XSUM_XXH64_testdata[4006] */
    { 2003, 0x000000009E3779B1ULL, 0xF635B761B94B7AB0ULL }, /* XSUM_XXH64_testdata[4007] */
    { 2004, 0x0000000000000000ULL, 0x82A636472C34B9CEULL }, /* XSUM_XXH64_testdata[4008] */
    { 2004, 0x000000009E3779B1ULL, 0x8AB07CA205817C51ULL }, /* XSUM_XXH64_testdata[4009] */
    { 2005, 0x0000000000000000ULL, 0x3F9121198180FAE5ULL }, /* XSUM_XXH64_testdata[4010] */
    { 2005, 0x000000009E3779B1ULL, 0xB775561D23D7C05DULL }, /* XSUM_XXH64_testdata[4011] */
    { 2006, 0x0000000000000000ULL, 0xB9D32E9BE873529CULL }, /* XSUM_XXH64_testdata[4012] */
    { 2006, 0x000000009E3779B1ULL, 0xCC5B1AD22833E947ULL }, /* XSUM_XXH64_testdata[4013] */
    { 2007, 0x0000000000000000ULL, 0x0C932553C82F899CULL }, /* XSUM_XXH64_testdata[4014] */
    { 2007, 0x000000009E3779B1ULL, 0xF6251CA5EFC71C4DULL }, /* XSUM_XXH64_testdata[4015] */
    { 2008, 0x0000000000000000ULL, 0xCEEC6128C3F727ABULL }, /* XSUM_XXH64_testdata[4016] */
    { 2008, 0x000000009E3779B1ULL, 0x7CEB10301B8AAF9CULL }, /* XSUM_XXH64_testdata[4017] */
    { 2009, 0x0000000000000000ULL, 0xB4064FE1B4D918BFULL }, /* XSUM_XXH64_testdata[4018] */
    { 2009, 0x000000009E3779B1ULL, 0x496D3FFFE987FE93ULL }, /* XSUM_XXH64_testdata[4019] */
    { 2010, 0x0000000000000000ULL, 0x2E63AAFBE6D4236FULL }, /* XSUM_XXH64_testdata[4020] */
    { 2010, 0x000000009E3779B1ULL, 0xFA118923A1211202ULL }, /* XSUM_XXH64_testdata[4021] */
    { 2011, 0x0000000000000000ULL, 0xEBB9A25FBE1B2793ULL }, /* XSUM_XXH64_testdata[4022] */
    { 2011, 0x000000009E3779B1ULL, 0xF1C55CB6255ADE6EULL }, /* XSUM_XXH64_testdata[4023] */
    { 2012, 0x0000000000000000ULL, 0xABAF4AE292BF3613ULL }, /* XSUM_XXH64_testdata[4024] */
    { 2012, 0x000000009E3779B1ULL, 0xE5F7F374402B1E63ULL }, /* XSUM_XXH64_testdata[4025] */
    { 2013, 0x0000000000000000ULL, 0xC52E8E4828D404E5ULL }, /* XSUM_XXH64_testdata[4026] */
    { 2013, 0x000000009E3779B1ULL, 0x68B92FBFD9DB16E5ULL }, /* XSUM_XXH64_testdata[4027] */
    { 2014, 0x0000000000000000ULL, 0x0CF0D3FF2E7A281EULL }, /* XSUM_XXH64_testdata[4028] */
    { 2014, 0x000000009E3779B1ULL, 0x9C0F43C768EB5913ULL }, /* XSUM_XXH64_testdata[4029] */
    { 2015, 0x0000000000000000ULL, 0xE89A5F20ABEBE285ULL }, /* XSUM_XXH64_testdata[4030] */
    { 2015, 0x000000009E3779B1ULL, 0x0D56487C1EE09E3AULL }, /* XSUM_XXH64_testdata[4031] */
    { 2016, 0x0000000000000000ULL, 0x5F64A682689F51B2ULL }, /* XSUM_XXH64_testdata[4032] */
    { 2016, 0x000000009E3779B1ULL, 0xDF3FE4AE31B14AE2ULL }, /* XSUM_XXH64_testdata[4033] */
    { 2017, 0x0000000000000000ULL, 0x861F1A605A776FE5ULL }, /* XSUM_XXH64_testdata[4034] */
    { 2017, 0x000000009E3779B1ULL, 0x1D89140B4E17FF8FULL }, /* XSUM_XXH64_testdata[4035] */
    { 2018, 0x0000000000000000ULL, 0x8B89AE50463E5002ULL }, /* XSUM_XXH64_testdata[4036] */
    { 2018, 0x000000009E3779B1ULL, 0xFB200A46D72495DFULL }, /* XSUM_XXH64_testdata[4037] */
    { 2019, 0x0000000000000000ULL, 0x48E95E7E0DC0718FULL }, /* XSUM_XXH64_testdata[4038] */
    { 2019, 0x000000009E3779B1ULL, 0xE93B4484585B45EBULL }, /* XSUM_XXH64_testdata[4039] */
    { 2020, 0x0000000000000000ULL, 0xEED08765D07D8EEAULL }, /* XSUM_XXH64_testdata[4040] */
    { 2020, 0x000000009E3779B1ULL, 0xF262B86DC747B84AULL }, /* XSUM_XXH64_testdata[4041] */
    { 2021, 0x0000000000000000ULL, 0xF8B301686BFD6BC4ULL }, /* XSUM_XXH64_testdata[4042] */
    { 2021, 0x000000009E3779B1ULL, 0x0B6749E914F6116FULL }, /* XSUM_XXH64_testdata[4043] */
    { 2022, 0x0000000000000000ULL, 0x84B34BA156A0FB3DULL }, /* XSUM_XXH64_testdata[4044] */
    { 2022, 0x000000009E3779B1ULL, 0x64EEC7F22F613130ULL }, /* XSUM_XXH64_testdata[4045] */
    { 2023, 0x0000000000000000ULL, 0xD70DBB507CB28689ULL }, /* XSUM_XXH64_testdata[4046] */
    { 2023, 0x000000009E3779B1ULL, 0xF23DDD59C8B8FF0FULL }, /* XSUM_XXH64_testdata[4047] */
    { 2024, 0x0000000000000000ULL, 0xD169C56FBCB4C80AULL }, /* XSUM_XXH64_testdata[4048] */
    { 2024, 0x000000009E3779B1ULL, 0x5DAE692A30FB7A95ULL }, /* XSUM_XXH64_testdata[4049] */
    { 2025, 0x0000000000000000ULL, 0x65273D02D09FC508ULL }, /* XSUM_XXH64_testdata[4050] */
    { 2025, 0x000000009E3779B1ULL, 0xB3E3ED1BECDC13E5ULL }, /* XSUM_XXH64_testdata[4051] */
    { 2026, 0x0000000000000000ULL, 0xA57A15E674AD9C18ULL }, /* XSUM_XXH64_testdata[4052] */
    { 2026, 0x000000009E3779B1ULL, 0xFD9F0F8647CA0488ULL }, /* XSUM_XXH64_testdata[4053] */
    { 2027, 0x0000000000000000ULL, 0x0836EFECCAD6CDE6ULL }, /* XSUM_XXH64_testdata[4054] */
    { 2027, 0x000000009E3779B1ULL, 0xC704F8E26F95456BULL }, /* XSUM_XXH64_testdata[4055] */
    { 2028, 0x0000000000000000ULL, 0x5109653FB07433C4ULL }, /* XSUM_XXH64_testdata[4056] */
    { 2028, 0x000000009E3779B1ULL, 0xF86EC1FB54DEA364ULL }, /* XSUM_XXH64_testdata[4057] */
    { 2029, 0x0000000000000000ULL, 0xDE17AD18E05B5D9FULL }, /* XSUM_XXH64_testdata[4058] */
    { 2029, 0x000000009E3779B1ULL, 0xC7D54E5E728CD2ABULL }, /* XSUM_XXH64_testdata[4059] */
    { 2030, 0x0000000000000000ULL, 0x8FA6E3EC12FC2614ULL }, /* XSUM_XXH64_testdata[4060] */
    { 2030, 0x000000009E3779B1ULL, 0xE8069626E1A34CFAULL }, /* XSUM_XXH64_testdata[4061] */
    { 2031, 0x0000000000000000ULL, 0x53A7FB12D7C29015ULL }, /* XSUM_XXH64_testdata[4062] */
    { 2031, 0x000000009E3779B1ULL, 0xF31EE53CA68855B1ULL }, /* XSUM_XXH64_testdata[4063] */
    { 2032, 0x0000000000000000ULL, 0x5037DAC3E92AF969ULL }, /* XSUM_XXH64_testdata[4064] */
    { 2032, 0x000000009E3779B1ULL, 0xFCC3E06DAC012EB5ULL }, /* XSUM_XXH64_testdata[4065] */
    { 2033, 0x0000000000000000ULL, 0xFB2923BD783FEDA5ULL }, /* XSUM_XXH64_testdata[4066] */
    { 2033, 0x000000009E3779B1ULL, 0xE05D022642B48D13ULL }, /* XSUM_XXH64_testdata[4067] */
    { 2034, 0x0000000000000000ULL, 0xDFB31A67FB10933EULL }, /* XSUM_XXH64_testdata[4068] */
    { 2034, 0x000000009E3779B1ULL, 0x852CF923EF8BE2F0ULL }, /* XSUM_XXH64_testdata[4069] */
    { 2035, 0x0000000000000000ULL, 0x08527FCC79A4DFBFULL }, /* XSUM_XXH64_testdata[4070] */
    { 2035, 0x000000009E3779B1ULL, 0xFD570904132AA5E3ULL }, /* XSUM_XXH64_testdata[4071] */
    { 2036, 0x0000000000000000ULL, 0x144C7742AAB6A290ULL }, /* XSUM_XXH64_testdata[4072] */
    { 2036, 0x000000009E3779B1ULL, 0xF55A2D158DE6EC7DULL }, /* XSUM_XXH64_testdata[4073] */
    { 2037, 0x0000000000000000ULL, 0x4E1EC8207BFBEBB7ULL }, /* XSUM_XXH64_testdata[4074] */
    { 2037, 0x000000009E3779B1ULL, 0xFFB8A8934DBCAF36ULL }, /* XSUM_XXH64_testdata[4075] */
    { 2038, 0x0000000000000000ULL, 0xA9B1B6F67D7C4816ULL }, /* XSUM_XXH64_testdata[4076] */
    { 2038, 0x000000009E3779B1ULL, 0xDD890F871F5693B5ULL }, /* XSUM_XXH64_testdata[4077] */
    { 2039, 0x0000000000000000ULL, 0x29007A28BF5318F7ULL }, /* XSUM_XXH64_testdata[4078] */
    { 2039, 0x000000009E3779B1ULL, 0x3A4120FEA87D4E21ULL }, /* XSUM_XXH64_testdata[4079] */
    { 2040, 0x0000000000000000ULL, 0x5A05EF977D7BC520ULL }, /* XSUM_XXH64_testdata[4080] */
    { 2040, 0x000000009E3779B1ULL, 0x2CC20C74CF6B0E02ULL }, /* XSUM_XXH64_testdata[4081] */
    { 2041, 0x0000000000000000ULL, 0x619A7CACBED025DEULL }, /* XSUM_XXH64_testdata[4082] */
    { 2041, 0x000000009E3779B1ULL, 0x1A59057461DD07CAULL }, /* XSUM_XXH64_testdata[4083] */
    { 2042, 0x0000000000000000ULL, 0x90727221C4FE5BC5ULL }, /* XSUM_XXH64_testdata[4084] */
    { 2042, 0x000000009E3779B1ULL, 0x223094D8DBB3B150ULL }, /* XSUM_XXH64_testdata[4085] */
    { 2043, 0x0000000000000000ULL, 0xBE189C3B1A1ED2BEULL }, /* XSUM_XXH64_testdata[4086] */
    { 2043, 0x000000009E3779B1ULL, 0xA6C67750B09F8BABULL }, /* XSUM_XXH64_testdata[4087] */
    { 2044, 0x0000000000000000ULL, 0xB0A69EF01EF46139ULL }, /* XSUM_XXH64_testdata[4088] */
    { 2044, 0x000000009E3779B1ULL, 0xD939082D6D712291ULL }, /* XSUM_XXH64_testdata[4089] */
    { 2045, 0x0000000000000000ULL, 0x0CCC28FE6CDBF1A1ULL }, /* XSUM_XXH64_testdata[4090] */
    { 2045, 0x000000009E3779B1ULL, 0x73AE77047960B98CULL }, /* XSUM_XXH64_testdata[4091] */
    { 2046, 0x0000000000000000ULL, 0x478701CD7434C1F8ULL }, /* XSUM_XXH64_testdata[4092] */
    { 2046, 0x000000009E3779B1ULL, 0x1C03B8F3FDEE6D82ULL }, /* XSUM_XXH64_testdata[4093] */
    { 2047, 0x0000000000000000ULL, 0xF3A36F0A22C9E50AULL }, /* XSUM_XXH64_testdata[4094] */
    { 2047, 0x000000009E3779B1ULL, 0x2B5F2FBEA26C36DDULL }, /* XSUM_XXH64_testdata[4095] */
    { 2048, 0x0000000000000000ULL, 0x5940F2752BC04387ULL }, /* XSUM_XXH64_testdata[4096] */
    { 2048, 0x000000009E3779B1ULL, 0xAA26F33C2898013BULL }, /* XSUM_XXH64_testdata[4097] */
    { 2049, 0x0000000000000000ULL, 0x3BAC0FEF077CBFB5ULL }, /* XSUM_XXH64_testdata[4098] */
    { 2049, 0x000000009E3779B1ULL, 0x30123FD816C47DB7ULL }, /* XSUM_XXH64_testdata[4099] */
    { 2050, 0x0000000000000000ULL, 0x0044521A47BD8036ULL }, /* XSUM_XXH64_testdata[4100] */
    { 2050, 0x000000009E3779B1ULL, 0x6AC6CB2EBF59FD14ULL }, /* XSUM_XXH64_testdata[4101] */
    { 2051, 0x0000000000000000ULL, 0x84CB9FF208C3DE57ULL }, /* XSUM_XXH64_testdata[4102] */
    { 2051, 0x000000009E3779B1ULL, 0x6152B5430967FF6FULL }, /* XSUM_XXH64_testdata[4103] */
    { 2052, 0x0000000000000000ULL, 0x9D7CFAEECDC80D1AULL }, /* XSUM_XXH64_testdata[4104] */
    { 2052, 0x000000009E3779B1ULL, 0x181A17301EF72248ULL }, /* XSUM_XXH64_testdata[4105] */
    { 2053, 0x0000000000000000ULL, 0x0033894BA28C94FDULL }, /* XSUM_XXH64_testdata[4106] */
    { 2053, 0x000000009E3779B1ULL, 0x52A8A9E1B840782AULL }, /* XSUM_XXH64_testdata[4107] */
    { 2054, 0x0000000000000000ULL, 0x23DBA47C635F0B49ULL }, /* XSUM_XXH64_testdata[4108] */
    { 2054, 0x000000009E3779B1ULL, 0x3E92E5CA81EC20E6ULL }, /* XSUM_XXH64_testdata[4109] */
    { 2055, 0x0000000000000000ULL, 0x72207DF802398ED1ULL }, /* XSUM_XXH64_testdata[4110] */
    { 2055, 0x000000009E3779B1ULL, 0xFAA76E7407555C3CULL }, /* XSUM_XXH64_testdata[4111] */
    { 2056, 0x0000000000000000ULL, 0xBA34840EDA22A84BULL }, /* XSUM_XXH64_testdata[4112] */
    { 2056, 0x000000009E3779B1ULL, 0x839C2E5D42D7B646ULL }, /* XSUM_XXH64_testdata[4113] */
    { 2057, 0x0000000000000000ULL, 0xA821C86122AA5E90ULL }, /* XSUM_XXH64_testdata[4114] */
    { 2057, 0x000000009E3779B1ULL, 0x6CCEFE4854DE62A1ULL }, /* XSUM_XXH64_testdata[4115] */
    { 2058, 0x0000000000000000ULL, 0xAA54141DD94F60F4ULL }, /* XSUM_XXH64_testdata[4116] */
    { 2058, 0x000000009E3779B1ULL, 0x3EBBF00BA988AAA9ULL }, /* XSUM_XXH64_testdata[4117] */
    { 2059, 0x0000000000000000ULL, 0x9CFFA3E6D4EF856BULL }, /* XSUM_XXH64_testdata[4118] */
    { 2059, 0x000000009E3779B1ULL, 0xE97359B7C016054DULL }, /* XSUM_XXH64_testdata[4119] */
    { 2060, 0x0000000000000000ULL, 0x1096E5FEF0CEF2B7ULL }, /* XSUM_XXH64_testdata[4120] */
    { 2060, 0x000000009E3779B1ULL, 0x91674731DCAC45A9ULL }, /* XSUM_XXH64_testdata[4121] */
    { 2061, 0x0000000000000000ULL, 0x58645B5EBB1C5E86ULL }, /* XSUM_XXH64_testdata[4122] */
    { 2061, 0x000000009E3779B1ULL, 0xA1D8C75667515C1BULL }, /* XSUM_XXH64_testdata[4123] */
    { 2062, 0x0000000000000000ULL, 0x6F2FF264D5C53AE8ULL }, /* XSUM_XXH64_testdata[4124] */
    { 2062, 0x000000009E3779B1ULL, 0x2DF76774F2617CB8ULL }, /* XSUM_XXH64_testdata[4125] */
    { 2063, 0x0000000000000000ULL, 0x70C18AD3E99FBE72ULL }, /* XSUM_XXH64_testdata[4126] */
    { 2063, 0x000000009E3779B1ULL, 0x13698B043F04D8D6ULL }, /* XSUM_XXH64_testdata[4127] */
    { 2064, 0x0000000000000000ULL, 0xEE7AC386AA60384FULL }, /* XSUM_XXH64_testdata[4128] */
    { 2064, 0x000000009E3779B1ULL, 0x1F1FCC4810B765D0ULL }, /* XSUM_XXH64_testdata[4129] */
    { 2065, 0x0000000000000000ULL, 0x87EA9FCAE40E32C9ULL }, /* XSUM_XXH64_testdata[4130] */
    { 2065, 0x000000009E3779B1ULL, 0x0CA6EFB8FFA8A0DBULL }, /* XSUM_XXH64_testdata[4131] */
    { 2066, 0x0000000000000000ULL, 0x4AAF81185FAE54E2ULL }, /* XSUM_XXH64_testdata[4132] */
    { 2066, 0x000000009E3779B1ULL, 0x518BDE7776E23DE8ULL }, /* XSUM_XXH64_testdata[4133] */
    { 2067, 0x0000000000000000ULL, 0xC520996D5467D052ULL }, /* XSUM_XXH64_testdata[4134] */
    { 2067, 0x000000009E3779B1ULL, 0x87E959537D4EA858ULL }, /* XSUM_XXH64_testdata[4135] */
    { 2068, 0x0000000000000000ULL, 0x1282D865F4671573ULL }, /* XSUM_XXH64_testdata[4136] */
    { 2068, 0x000000009E3779B1ULL, 0x222605DA134EED25ULL }, /* XSUM_XXH64_testdata[4137] */
    { 2069, 0x0000000000000000ULL, 0xD77C60EA52421421ULL }, /* XSUM_XXH64_testdata[4138] */
    { 2069, 0x000000009E3779B1ULL, 0x1CF2197CEA4E73D0ULL }, /* XSUM_XXH64_testdata[4139] */
    { 2070, 0x0000000000000000ULL, 0x820745C3450FD7A6ULL }, /* XSUM_XXH64_testdata[4140] */
    { 2070, 0x000000009E3779B1ULL, 0xC81986FB4E1655F3ULL }, /* XSUM_XXH64_testdata[4141] */
    { 2071, 0x0000000000000000ULL, 0xD3CD04D7E49E6A7FULL }, /* XSUM_XXH64_testdata[4142] */
    { 2071, 0x000000009E3779B1ULL, 0x6804392508ABDA6DULL }, /* XSUM_XXH64_testdata[4143] */
    { 2072, 0x0000000000000000ULL, 0x49223E338D9581D8ULL }, /* XSUM_XXH64_testdata[4144] */
    { 2072, 0x000000009E3779B1ULL, 0x0564A719A29B44E9ULL }, /* XSUM_XXH64_testdata[4145] */
    { 2073, 0x0000000000000000ULL, 0xE12FD1AB308CF5EFULL }, /* XSUM_XXH64_testdata[4146] */
    { 2073, 0x000000009E3779B1ULL, 0x51A14BBFEEF3F96AULL }, /* XSUM_XXH64_testdata[4147] */
    { 2074, 0x0000000000000000ULL, 0x24E77388D9DEC52AULL }, /* XSUM_XXH64_testdata[4148] */
    { 2074, 0x000000009E3779B1ULL, 0x84961EE5CA565A4BULL }, /* XSUM_XXH64_testdata[4149] */
    { 2075, 0x0000000000000000ULL, 0x2D9F4D697BFC7818ULL }, /* XSUM_XXH64_testdata[4150] */
    { 2075, 0x000000009E3779B1ULL, 0xDB9E0F73E0E36113ULL }, /* XSUM_XXH64_testdata[4151] */
    { 2076, 0x0000000000000000ULL, 0x6985BAF864405429ULL }, /* XSUM_XXH64_testdata[4152] */
    { 2076, 0x000000009E3779B1ULL, 0x74A430F99F7E7D59ULL }, /* XSUM_XXH64_testdata[4153] */
    { 2077, 0x0000000000000000ULL, 0xD1FF0FB6DE762B65ULL }, /* XSUM_XXH64_testdata[4154] */
    { 2077, 0x000000009E3779B1ULL, 0x08925355BD02BEBEULL }, /* XSUM_XXH64_testdata[4155] */
    { 2078, 0x0000000000000000ULL, 0xE1AA4852C2F2D90FULL }, /* XSUM_XXH64_testdata[4156] */
    { 2078, 0x000000009E3779B1ULL, 0xE3EBF6643B95B8E0ULL }, /* XSUM_XXH64_testdata[4157] */
    { 2079, 0x0000000000000000ULL, 0x62A2B14D4A8CC547ULL }, /* XSUM_XXH64_testdata[4158] */
    { 2079, 0x000000009E3779B1ULL, 0xFDF336EEC6017DB9ULL }, /* XSUM_XXH64_testdata[4159] */
    { 2080, 0x0000000000000000ULL, 0x6799587A76386B65ULL }, /* XSUM_XXH64_testdata[4160] */
    { 2080, 0x000000009E3779B1ULL, 0xEE9AF077BF53BB21ULL }, /* XSUM_XXH64_testdata[4161] */
    { 2081, 0x0000000000000000ULL, 0x6C123C1D7A5F313AULL }, /* XSUM_XXH64_testdata[4162] */
    { 2081, 0x000000009E3779B1ULL, 0xDF1885BA2212AFA6ULL }, /* XSUM_XXH64_testdata[4163] */
    { 2082, 0x0000000000000000ULL, 0x86D404E83ECC772DULL }, /* XSUM_XXH64_testdata[4164] */
    { 2082, 0x000000009E3779B1ULL, 0x314A7511C6152CBDULL }, /* XSUM_XXH64_testdata[4165] */
    { 2083, 0x0000000000000000ULL, 0x41078C62E4CDBE9BULL }, /* XSUM_XXH64_testdata[4166] */
    { 2083, 0x000000009E3779B1ULL, 0x6474085CF26373E2ULL }, /* XSUM_XXH64_testdata[4167] */
    { 2084, 0x0000000000000000ULL, 0x89351FFED714F97AULL }, /* XSUM_XXH64_testdata[4168] */
    { 2084, 0x000000009E3779B1ULL, 0x14F34ACE8159FFCFULL }, /* XSUM_XXH64_testdata[4169] */
    { 2085, 0x0000000000000000ULL, 0x3B4394508B1B5A75ULL }, /* XSUM_XXH64_testdata[4170] */
    { 2085, 0x000000009E3779B1ULL, 0x806592BA26AA3EA9ULL }, /* XSUM_XXH64_testdata[4171] */
    { 2086, 0x0000000000000000ULL, 0x3A2FD0C243F9BB37ULL }, /* XSUM_XXH64_testdata[4172] */
    { 2086, 0x000000009E3779B1ULL, 0xD3351709697FC986ULL }, /* XSUM_XXH64_testdata[4173] */
    { 2087, 0x0000000000000000ULL, 0x780857FE80A34A08ULL }, /* XSUM_XXH64_testdata[4174] */
    { 2087, 0x000000009E3779B1ULL, 0xEAAD5FF6ECEF154CULL }, /* XSUM_XXH64_testdata[4175] */
    { 2088, 0x0000000000000000ULL, 0x8C92A97AB0A8AC7BULL }, /* XSUM_XXH64_testdata[4176] */
    { 2088, 0x000000009E3779B1ULL, 0x7B516808A34A2ECFULL }, /* XSUM_XXH64_testdata[4177] */
    { 2089, 0x0000000000000000ULL, 0xA55F7709B3E7B01DULL }, /* XSUM_XXH64_testdata[4178] */
    { 2089, 0x000000009E3779B1ULL, 0x4569B849606B8502ULL }, /* XSUM_XXH64_testdata[4179] */
    { 2090, 0x0000000000000000ULL, 0xD8BDC1D39CE0752EULL }, /* XSUM_XXH64_testdata[4180] */
    { 2090, 0x000000009E3779B1ULL, 0x9F2BC68076C09D7BULL }, /* XSUM_XXH64_testdata[4181] */
    { 2091, 0x0000000000000000ULL, 0x398E12B9780E0BA1ULL }, /* XSUM_XXH64_testdata[4182] */
    { 2091, 0x000000009E3779B1ULL, 0x62EB8E954AC92C8DULL }, /* XSUM_XXH64_testdata[4183] */
    { 2092, 0x0000000000000000ULL, 0x2142BCE894671761ULL }, /* XSUM_XXH64_testdata[4184] */
    { 2092, 0x000000009E3779B1ULL, 0x0A193CDDFF220C96ULL }, /* XSUM_XXH64_testdata[4185] */
    { 2093, 0x0000000000000000ULL, 0x9487066C0B904136ULL }, /* XSUM_XXH64_testdata[4186] */
    { 2093, 0x000000009E3779B1ULL, 0x9F6DEC10197482CCULL }, /* XSUM_XXH64_testdata[4187] */
    { 2094, 0x0000000000000000ULL, 0x72954797A955B808ULL }, /* XSUM_XXH64_testdata[4188] */
    { 2094, 0x000000009E3779B1ULL, 0xE6DA9081618333ABULL }, /* XSUM_XXH64_testdata[4189] */
    { 2095, 0x0000000000000000ULL, 0x09011C01FB315E1EULL }, /* XSUM_XXH64_testdata[4190] */
    { 2095, 0x000000009E3779B1ULL, 0x220EC8C4E5D46FBBULL }, /* XSUM_XXH64_testdata[4191] */
    { 2096, 0x0000000000000000ULL, 0x14652DD6033BE533ULL }, /* XSUM_XXH64_testdata[4192] */
    { 2096, 0x000000009E3779B1ULL, 0x2A78CFC91C228839ULL }, /* XSUM_XXH64_testdata[4193] */
    { 2097, 0x0000000000000000ULL, 0x9237135C5B1C656EULL }, /* XSUM_XXH64_testdata[4194] */
    { 2097, 0x000000009E3779B1ULL, 0xF2EBCA6F07120BE4ULL }, /* XSUM_XXH64_testdata[4195] */
    { 2098, 0x0000000000000000ULL, 0xC26062D31FFF67C3ULL }, /* XSUM_XXH64_testdata[4196] */
    { 2098, 0x000000009E3779B1ULL, 0x7AF3934AFFADC60CULL }, /* XSUM_XXH64_testdata[4197] */
    { 2099, 0x0000000000000000ULL, 0x3301C88334AFD200ULL }, /* XSUM_XXH64_testdata[4198] */
    { 2099, 0x000000009E3779B1ULL, 0x6C7912A7CF157428ULL }, /* XSUM_XXH64_testdata[4199] */
    { 2100, 0x0000000000000000ULL, 0xCE0A716B6C313392ULL }, /* XSUM_XXH64_testdata[4200] */
    { 2100, 0x000000009E3779B1ULL, 0x2860586DDA840F0CULL }, /* XSUM_XXH64_testdata[4201] */
    { 2101, 0x0000000000000000ULL, 0x1186E7E20799442DULL }, /* XSUM_XXH64_testdata[4202] */
    { 2101, 0x000000009E3779B1ULL, 0x444E38FAA5CFCD4EULL }, /* XSUM_XXH64_testdata[4203] */
    { 2102, 0x0000000000000000ULL, 0x7EACC755EE3137A5ULL }, /* XSUM_XXH64_testdata[4204] */
    { 2102, 0x000000009E3779B1ULL, 0x5B2115372C72793CULL }, /* XSUM_XXH64_testdata[4205] */
    { 2103, 0x0000000000000000ULL, 0x6B9762647B56CD52ULL }, /* XSUM_XXH64_testdata[4206] */
    { 2103, 0x000000009E3779B1ULL, 0x4F8E8560D5A7C7CFULL }, /* XSUM_XXH64_testdata[4207] */
    { 2104, 0x0000000000000000ULL, 0x74C601BB31E0DF08ULL }, /* XSUM_XXH64_testdata[4208] */
    { 2104, 0x000000009E3779B1ULL, 0x2383AEF86CA8A3CDULL }, /* XSUM_XXH64_testdata[4209] */
    { 2105, 0x0000000000000000ULL, 0xAF3345348D1009B5ULL }, /* XSUM_XXH64_testdata[4210] */
    { 2105, 0x000000009E3779B1ULL, 0x9E85C04B850EE216ULL }, /* XSUM_XXH64_testdata[4211] */
    { 2106, 0x0000000000000000ULL, 0xAFE877C6FD7C563BULL }, /* XSUM_XXH64_testdata[4212] */
    { 2106, 0x000000009E3779B1ULL, 0x4CB18BBE4045EB30ULL }, /* XSUM_XXH64_testdata[4213] */
    { 2107, 0x0000000000000000ULL, 0xA409FF6AF28DC820ULL }, /* XSUM_XXH64_testdata[4214] */
    { 2107, 0x000000009E3779B1ULL, 0xC9CA4D9C25C84B99ULL }, /* XSUM_XXH64_testdata[4215] */
    { 2108, 0x0000000000000000ULL, 0xA27F38B662E03C79ULL }, /* XSUM_XXH64_testdata[4216] */
    { 2108, 0x000000009E3779B1ULL, 0xD648D7BB80D814FEULL }, /* XSUM_XXH64_testdata[4217] */
    { 2109, 0x0000000000000000ULL, 0x5AC552E981AE8B24ULL }, /* XSUM_XXH64_testdata[4218] */
    { 2109, 0x000000009E3779B1ULL, 0x6D6A9FCAC6B03F2EULL }, /* XSUM_XXH64_testdata[4219] */
    { 2110, 0x0000000000000000ULL, 0x504E7C8643949EEFULL }, /* XSUM_XXH64_testdata[4220] */
    { 2110, 0x000000009E3779B1ULL, 0xFF3EE5A60DDBE095ULL }, /* XSUM_XXH64_testdata[4221] */
    { 2111, 0x0000000000000000ULL, 0xBE7DC56D5383A688ULL }, /* XSUM_XXH64_testdata[4222] */
    { 2111, 0x000000009E3779B1ULL, 0x9F4D200C77861730ULL }, /* XSUM_XXH64_testdata[4223] */
    { 2112, 0x0000000000000000ULL, 0x834C20C1D1CDDDE3ULL }, /* XSUM_XXH64_testdata[4224] */
    { 2112, 0x000000009E3779B1ULL, 0x84D3DE364520C70BULL }, /* XSUM_XXH64_testdata[4225] */
    { 2113, 0x0000000000000000ULL, 0xF4C8E415579EE594ULL }, /* XSUM_XXH64_testdata[4226] */
    { 2113, 0x000000009E3779B1ULL, 0x8D515665D403DC73ULL }, /* XSUM_XXH64_testdata[4227] */
    { 2114, 0x0000000000000000ULL, 0xA53B6D27612B9B51ULL }, /* XSUM_XXH64_testdata[4228] */
    { 2114, 0x000000009E3779B1ULL, 0x8C14F008F4132919ULL }, /* XSUM_XXH64_testdata[4229] */
    { 2115, 0x0000000000000000ULL, 0x47130CCABE4095E5ULL }, /* XSUM_XXH64_testdata[4230] */
    { 2115, 0x000000009E3779B1ULL, 0xC2D80E3E8B53222FULL }, /* XSUM_XXH64_testdata[4231] */
    { 2116, 0x0000000000000000ULL, 0xD6197D649A921D36ULL }, /* XSUM_XXH64_testdata[4232] */
    { 2116, 0x000000009E3779B1ULL, 0x2FE3E5AA6224198AULL }, /* XSUM_XXH64_testdata[4233] */
    { 2117, 0x0000000000000000ULL, 0xAAED01318EB254EDULL }, /* XSUM_XXH64_testdata[4234] */
    { 2117, 0x000000009E3779B1ULL, 0x8E439C09761E8132ULL }, /* XSUM_XXH64_testdata[4235] */
    { 2118, 0x0000000000000000ULL, 0x3F38EE9A3391DD62ULL }, /* XSUM_XXH64_testdata[4236] */
    { 2118, 0x000000009E3779B1ULL, 0xC3125F364FA13A87ULL }, /* XSUM_XXH64_testdata[4237] */
    { 2119, 0x0000000000000000ULL, 0x3E34DB0E06852641ULL }, /* XSUM_XXH64_testdata[4238] */
    { 2119, 0x000000009E3779B1ULL, 0x262FCBF508B5B3B7ULL }, /* XSUM_XXH64_testdata[4239] */
    { 2120, 0x0000000000000000ULL, 0xC5AE3CF484FA43B1ULL }, /* XSUM_XXH64_testdata[4240] */
    { 2120, 0x000000009E3779B1ULL, 0x76F8A12780996C81ULL }, /* XSUM_XXH64_testdata[4241] */
    { 2121, 0x0000000000000000ULL, 0x2443FF05EFC9ED92ULL }, /* XSUM_XXH64_testdata[4242] */
    { 2121, 0x000000009E3779B1ULL, 0x84FD6ED0A2E8F6BBULL }, /* XSUM_XXH64_testdata[4243] */
    { 2122, 0x0000000000000000ULL, 0x60BF6BE620291068ULL }, /* XSUM_XXH64_testdata[4244] */
    { 2122, 0x000000009E3779B1ULL, 0x2A4406CBBD6BABE5ULL }, /* XSUM_XXH64_testdata[4245] */
    { 2123, 0x0000000000000000ULL, 0x7B35FA5307533583ULL }, /* XSUM_XXH64_testdata[4246] */
    { 2123, 0x000000009E3779B1ULL, 0x3499FC630E4E282DULL }, /* XSUM_XXH64_testdata[4247] */
    { 2124, 0x0000000000000000ULL, 0xA6EF8CD6F5ED65C5ULL }, /* XSUM_XXH64_testdata[4248] */
    { 2124, 0x000000009E3779B1ULL, 0xA8EFFB4312F09C95ULL }, /* XSUM_XXH64_testdata[4249] */
    { 2125, 0x0000000000000000ULL, 0x7FFDFAE1632AEDE1ULL }, /* XSUM_XXH64_testdata[4250] */
    { 2125, 0x000000009E3779B1ULL, 0xBA808A1B7D5202E8ULL }, /* XSUM_XXH64_testdata[4251] */
    { 2126, 0x0000000000000000ULL, 0x1EA9E14D815B0E15ULL }, /* XSUM_XXH64_testdata[4252] */
    { 2126, 0x000000009E3779B1ULL, 0xCDB8A44CBAA78FA4ULL }, /* XSUM_XXH64_testdata[4253] */
    { 2127, 0x0000000000000000ULL, 0xF29148C17974794BULL }, /* XSUM_XXH64_testdata[4254] */
    { 2127, 0x000000009E3779B1ULL, 0x7FB7B39F13C2A6EBULL }, /* XSUM_XXH64_testdata[4255] */
    { 2128, 0x0000000000000000ULL, 0xD91E468DD5A9E938ULL }, /* XSUM_XXH64_testdata[4256] */
    { 2128, 0x000000009E3779B1ULL, 0xAAAD4A6FC44F967FULL }, /* XSUM_XXH64_testdata[4257] */
    { 2129, 0x0000000000000000ULL, 0x4F7A5955B9D5A37AULL }, /* XSUM_XXH64_testdata[4258] */
    { 2129, 0x000000009E3779B1ULL, 0x86969D6057AC0A5BULL }, /* XSUM_XXH64_testdata[4259] */
    { 2130, 0x0000000000000000ULL, 0x7EC790F0E5C01DBEULL }, /* XSUM_XXH64_testdata[4260] */
    { 2130, 0x000000009E3779B1ULL, 0x18991A7DF8F8CABAULL }, /* XSUM_XXH64_testdata[4261] */
    { 2131, 0x0000000000000000ULL, 0x07F65E66C773DDDAULL }, /* XSUM_XXH64_testdata[4262] */
    { 2131, 0x000000009E3779B1ULL, 0xD742E5B5D10066A7ULL }, /* XSUM_XXH64_testdata[4263] */
    { 2132, 0x0000000000000000ULL, 0xACD1F8F28C590CD4ULL }, /* XSUM_XXH64_testdata[4264] */
    { 2132, 0x000000009E3779B1ULL, 0x6CB8902519564A66ULL }, /* XSUM_XXH64_testdata[4265] */
    { 2133, 0x0000000000000000ULL, 0xE4D6A70BCB1A245EULL }, /* XSUM_XXH64_testdata[4266] */
    { 2133, 0x000000009E3779B1ULL, 0xF7529A659F22D37AULL }, /* XSUM_XXH64_testdata[4267] */
    { 2134, 0x0000000000000000ULL, 0xF312A484DFA93AFBULL }, /* XSUM_XXH64_testdata[4268] */
    { 2134, 0x000000009E3779B1ULL, 0xE6E1D440C014677EULL }, /* XSUM_XXH64_testdata[4269] */
    { 2135, 0x0000000000000000ULL, 0x8148BBE3013AA9E7ULL }, /* XSUM_XXH64_testdata[4270] */
    { 2135, 0x000000009E3779B1ULL, 0x198B1BB13B57A427ULL }, /* XSUM_XXH64_testdata[4271] */
    { 2136, 0x0000000000000000ULL, 0xA27C235275417E09ULL }, /* XSUM_XXH64_testdata[4272] */
    { 2136, 0x000000009E3779B1ULL, 0xD039DDDC08FB6B9DULL }, /* XSUM_XXH64_testdata[4273] */
    { 2137, 0x0000000000000000ULL, 0x0898F85EBE67332AULL }, /* XSUM_XXH64_testdata[4274] */
    { 2137, 0x000000009E3779B1ULL, 0xB80710F9DB9F327DULL }, /* XSUM_XXH64_testdata[4275] */
    { 2138, 0x0000000000000000ULL, 0xB51E48C7981571F4ULL }, /* XSUM_XXH64_testdata[4276] */
    { 2138, 0x000000009E3779B1ULL, 0x5BC03D99D9369EBCULL }, /* XSUM_XXH64_testdata[4277] */
    { 2139, 0x0000000000000000ULL, 0xD5B2D4AFF43F38ADULL }, /* XSUM_XXH64_testdata[4278] */
    { 2139, 0x000000009E3779B1ULL, 0x27CF28C671F98AFCULL }, /* XSUM_XXH64_testdata[4279] */
    { 2140, 0x0000000000000000ULL, 0x45EDBD88E2265690ULL }, /* XSUM_XXH64_testdata[4280] */
    { 2140, 0x000000009E3779B1ULL, 0xD8F82B9893BD894CULL }, /* XSUM_XXH64_testdata[4281] */
    { 2141, 0x0000000000000000ULL, 0xA0BBBEDF99503B3BULL }, /* XSUM_XXH64_testdata[4282] */
    { 2141, 0x000000009E3779B1ULL, 0x7686CA86FD044DF0ULL }, /* XSUM_XXH64_testdata[4283] */
    { 2142, 0x0000000000000000ULL, 0xD765F1EF7D2059C5ULL }, /* XSUM_XXH64_testdata[4284] */
    { 2142, 0x000000009E3779B1ULL, 0xFE6FBCF07AABC4CCULL }, /* XSUM_XXH64_testdata[4285] */
    { 2143, 0x0000000000000000ULL, 0x58175E7E13EAA9D8ULL }, /* XSUM_XXH64_testdata[4286] */
    { 2143, 0x000000009E3779B1ULL, 0xE546DB18393B277DULL }, /* XSUM_XXH64_testdata[4287] */
    { 2144, 0x0000000000000000ULL, 0x8990BB7C5F7480E5ULL }, /* XSUM_XXH64_testdata[4288] */
    { 2144, 0x000000009E3779B1ULL, 0x1A730E6F65DF72DBULL }, /* XSUM_XXH64_testdata[4289] */
    { 2145, 0x0000000000000000ULL, 0xBEC9CDFE264CEDA6ULL }, /* XSUM_XXH64_testdata[4290] */
    { 2145, 0x000000009E3779B1ULL, 0xCCAA93F2CC103401ULL }, /* XSUM_XXH64_testdata[4291] */
    { 2146, 0x0000000000000000ULL, 0x3C03458ACA57F868ULL }, /* XSUM_XXH64_testdata[4292] */
    { 2146, 0x000000009E3779B1ULL, 0x10676C21FF394B3BULL }, /* XSUM_XXH64_testdata[4293] */
    { 2147, 0x0000000000000000ULL, 0x0553858EE7DA568BULL }, /* XSUM_XXH64_testdata[4294] */
    { 2147, 0x000000009E3779B1ULL, 0x0BB4B9EAFF9440D2ULL }, /* XSUM_XXH64_testdata[4295] */
    { 2148, 0x0000000000000000ULL, 0x4916EF58834A3252ULL }, /* XSUM_XXH64_testdata[4296] */
    { 2148, 0x000000009E3779B1ULL, 0xEA0D33FC9C243A5DULL }, /* XSUM_XXH64_testdata[4297] */
    { 2149, 0x0000000000000000ULL, 0xFAE135CEDB95E7CEULL }, /* XSUM_XXH64_testdata[4298] */
    { 2149, 0x000000009E3779B1ULL, 0x90482F79FC1CA9F1ULL }, /* XSUM_XXH64_testdata[4299] */
    { 2150, 0x0000000000000000ULL, 0x6F1AEEBDD0E1823BULL }, /* XSUM_XXH64_testdata[4300] */
    { 2150, 0x000000009E3779B1ULL, 0xFFD07A254B97BACCULL }, /* XSUM_XXH64_testdata[4301] */
    { 2151, 0x0000000000000000ULL, 0x43EDE3066FDA0040ULL }, /* XSUM_XXH64_testdata[4302] */
    { 2151, 0x000000009E3779B1ULL, 0xAF7336B4D1853C7EULL }, /* XSUM_XXH64_testdata[4303] */
    { 2152, 0x0000000000000000ULL, 0x861FCE7AE8678941ULL }, /* XSUM_XXH64_testdata[4304] */
    { 2152, 0x000000009E3779B1ULL, 0x0F9C545750101511ULL }, /* XSUM_XXH64_testdata[4305] */
    { 2153, 0x0000000000000000ULL, 0x51870C634310F32AULL }, /* XSUM_XXH64_testdata[4306] */
    { 2153, 0x000000009E3779B1ULL, 0x0326BD661840DD86ULL }, /* XSUM_XXH64_testdata[4307] */
    { 2154, 0x0000000000000000ULL, 0x3DF958E2B948A48CULL }, /* XSUM_XXH64_testdata[4308] */
    { 2154, 0x000000009E3779B1ULL, 0x0F2B3E16806DF639ULL }, /* XSUM_XXH64_testdata[4309] */
    { 2155, 0x0000000000000000ULL, 0x4536713B86E9564DULL }, /* XSUM_XXH64_testdata[4310] */
    { 2155, 0x000000009E3779B1ULL, 0xD976733D8F9E0619ULL }, /* XSUM_XXH64_testdata[4311] */
    { 2156, 0x0000000000000000ULL, 0xD10F3C77932333EEULL }, /* XSUM_XXH64_testdata[4312] */
    { 2156, 0x000000009E3779B1ULL, 0xB93E27EFF2953E52ULL }, /* XSUM_XXH64_testdata[4313] */
    { 2157, 0x0000000000000000ULL, 0x5509CFEC5E92713FULL }, /* XSUM_XXH64_testdata[4314] */
    { 2157, 0x000000009E3779B1ULL, 0x3FA08BB4F066778EULL }, /* XSUM_XXH64_testdata[4315] */
    { 2158, 0x0000000000000000ULL, 0x47C128A5EFF25028ULL }, /* XSUM_XXH64_testdata[4316] */
    { 2158, 0x000000009E3779B1ULL, 0xC482683096EC165EULL }, /* XSUM_XXH64_testdata[4317] */
    { 2159, 0x0000000000000000ULL, 0xB16525A1BE2ACB88ULL }, /* XSUM_XXH64_testdata[4318] */
    { 2159, 0x000000009E3779B1ULL, 0xD4312DC78F979738ULL }, /* XSUM_XXH64_testdata[4319] */
    { 2160, 0x0000000000000000ULL, 0x86C3F4858ABD1937ULL }, /* XSUM_XXH64_testdata[4320] */
    { 2160, 0x000000009E3779B1ULL, 0x1A4B93C9621A6D29ULL }, /* XSUM_XXH64_testdata[4321] */
    { 2161, 0x0000000000000000ULL, 0xD763296BCDB7E927ULL }, /* XSUM_XXH64_testdata[4322] */
    { 2161, 0x000000009E3779B1ULL, 0x07D70A2A6A58B83FULL }, /* XSUM_XXH64_testdata[4323] */
    { 2162, 0x0000000000000000ULL, 0x3A9B0CFE29777F3CULL }, /* XSUM_XXH64_testdata[4324] */
    { 2162, 0x000000009E3779B1ULL, 0xD2AFEDD47D0451E7ULL }, /* XSUM_XXH64_testdata[4325] */
    { 2163, 0x0000000000000000ULL, 0x3FC71F79F6675489ULL }, /* XSUM_XXH64_testdata[4326] */
    { 2163, 0x000000009E3779B1ULL, 0x11222423ABFCF05AULL }, /* XSUM_XXH64_testdata[4327] */
    { 2164, 0x0000000000000000ULL, 0xD0EA8E4BCF7929F7ULL }, /* XSUM_XXH64_testdata[4328] */
    { 2164, 0x000000009E3779B1ULL, 0x8B337ABF3E1434D9ULL }, /* XSUM_XXH64_testdata[4329] */
    { 2165, 0x0000000000000000ULL, 0x5DCD8820A0E2E462ULL }, /* XSUM_XXH64_testdata[4330] */
    { 2165, 0x000000009E3779B1ULL, 0xC044B75DCC5D4DAAULL }, /* XSUM_XXH64_testdata[4331] */
    { 2166, 0x0000000000000000ULL, 0x8B57F38045CC69D7ULL }, /* XSUM_XXH64_testdata[4332] */
    { 2166, 0x000000009E3779B1ULL, 0xBEC998DED9EDCAA6ULL }, /* XSUM_XXH64_testdata[4333] */
    { 2167, 0x0000000000000000ULL, 0x6C3878F759B3E106ULL }, /* XSUM_XXH64_testdata[4334] */
    { 2167, 0x000000009E3779B1ULL, 0x7A9FE47D20942215ULL }, /* XSUM_XXH64_testdata[4335] */
    { 2168, 0x0000000000000000ULL, 0x874038A6E4222EF0ULL }, /* XSUM_XXH64_testdata[4336] */
    { 2168, 0x000000009E3779B1ULL, 0x2E7EAD2589A83B92ULL }, /* XSUM_XXH64_testdata[4337] */
    { 2169, 0x0000000000000000ULL, 0xFF8803E169EFD2A8ULL }, /* XSUM_XXH64_testdata[4338] */
    { 2169, 0x000000009E3779B1ULL, 0x79B3159B040EE36CULL }, /* XSUM_XXH64_testdata[4339] */
    { 2170, 0x0000000000000000ULL, 0x9D0E380D955C6317ULL }, /* XSUM_XXH64_testdata[4340] */
    { 2170, 0x000000009E3779B1ULL, 0xDFE68AC88309395DULL }, /* XSUM_XXH64_testdata[4341] */
    { 2171, 0x0000000000000000ULL, 0x2008B4A47392D513ULL }, /* XSUM_XXH64_testdata[4342] */
    { 2171, 0x000000009E3779B1ULL, 0x67FCB44E010AB0C9ULL }, /* XSUM_XXH64_testdata[4343] */
    { 2172, 0x0000000000000000ULL, 0xDC969F9C747067EAULL }, /* XSUM_XXH64_testdata[4344] */
    { 2172, 0x000000009E3779B1ULL, 0x7BD46D2827AAE44CULL }, /* XSUM_XXH64_testdata[4345] */
    { 2173, 0x0000000000000000ULL, 0x58BC7150352BA58FULL }, /* XSUM_XXH64_testdata[4346] */
    { 2173, 0x000000009E3779B1ULL, 0xBD32A63B9AF1786EULL }, /* XSUM_XXH64_testdata[4347] */
    { 2174, 0x0000000000000000ULL, 0xA925D126BE7B6462ULL }, /* XSUM_XXH64_testdata[4348] */
    { 2174, 0x000000009E3779B1ULL, 0xD7D50D29E043C558ULL }, /* XSUM_XXH64_testdata[4349] */
    { 2175, 0x0000000000000000ULL, 0x2BAF6491DCF87362ULL }, /* XSUM_XXH64_testdata[4350] */
    { 2175, 0x000000009E3779B1ULL, 0x95AFC2F6DA50A5E4ULL }, /* XSUM_XXH64_testdata[4351] */
    { 2176, 0x0000000000000000ULL, 0xD15101A732424692ULL }, /* XSUM_XXH64_testdata[4352] */
    { 2176, 0x000000009E3779B1ULL, 0x82FD009AA26EFF4FULL }, /* XSUM_XXH64_testdata[4353] */
    { 2177, 0x0000000000000000ULL, 0x9B9FACB2392017C8ULL }, /* XSUM_XXH64_testdata[4354] */
    { 2177, 0x000000009E3779B1ULL, 0x0F2DC2B9FB9D03DDULL }, /* XSUM_XXH64_testdata[4355] */
    { 2178, 0x0000000000000000ULL, 0x3B57E051C347FCBEULL }, /* XSUM_XXH64_testdata[4356] */
    { 2178, 0x000000009E3779B1ULL, 0x454C8FC8C2B75DB3ULL }, /* XSUM_XXH64_testdata[4357] */
    { 2179, 0x0000000000000000ULL, 0x2E90998F0F1F9E64ULL }, /* XSUM_XXH64_testdata[4358] */
    { 2179, 0x000000009E3779B1ULL, 0x198CA081782AAC42ULL }, /* XSUM_XXH64_testdata[4359] */
    { 2180, 0x0000000000000000ULL, 0x204C5B3AF52DC25CULL }, /* XSUM_XXH64_testdata[4360] */
    { 2180, 0x000000009E3779B1ULL, 0x88D79503E461DEE3ULL }, /* XSUM_XXH64_testdata[4361] */
    { 2181, 0x0000000000000000ULL, 0x078DA5447DFC0395ULL }, /* XSUM_XXH64_testdata[4362] */
    { 2181, 0x000000009E3779B1ULL, 0x2065CDFBCD1900C8ULL }, /* XSUM_XXH64_testdata[4363] */
    { 2182, 0x0000000000000000ULL, 0xEE9725992BCC2292ULL }, /* XSUM_XXH64_testdata[4364] */
    { 2182, 0x000000009E3779B1ULL, 0x63A828CB16339365ULL }, /* XSUM_XXH64_testdata[4365] */
    { 2183, 0x0000000000000000ULL, 0x13A0DDEAC067C804ULL }, /* XSUM_XXH64_testdata[4366] */
    { 2183, 0x000000009E3779B1ULL, 0x3BCBD977B1D8FC17ULL }, /* XSUM_XXH64_testdata[4367] */
    { 2184, 0x0000000000000000ULL, 0x2828598F4CC5CA5AULL }, /* XSUM_XXH64_testdata[4368] */
    { 2184, 0x000000009E3779B1ULL, 0x612B4B0D9E2BF6C1ULL }, /* XSUM_XXH64_testdata[4369] */
    { 2185, 0x0000000000000000ULL, 0x4E5D8F1A7298695EULL }, /* XSUM_XXH64_testdata[4370] */
    { 2185, 0x000000009E3779B1ULL, 0xB595A31711A62559ULL }, /* XSUM_XXH64_testdata[4371] */
    { 2186, 0x0000000000000000ULL, 0x0E61D730286A3963ULL }, /* XSUM_XXH64_testdata[4372] */
    { 2186, 0x000000009E3779B1ULL, 0xA890A