/*
 *         Copyright (C) 2008 Fadi Al-katout (cutout) <cutout33@gmail.com>
 * 
 *  Monajat is free software; you can redistribute it and/or modify   
 * it under the terms of the GNU General  Public Licence as published by the 
 * Free Software Foundation;  either version 2 of the Licence, 
 * or(at your option) any later version.
 * 
 * Monajat is distributed in  the hope that it will be useful,
 * but WITHOUT ANY WARRANTY;  without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A  PARTICULAR PURPOSE. 
 * See the GNU General  Public Licence for more details.
 * 
 * You should have received a copy of  the GNU General Public Licence
 * along with Monajat; 
 * if not, write to  the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor,  Boston, MA  02110-1301, USA
 */

package monajat.util.Language_util;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;

import monajat.util.PropertyManager;

public final class LanguageResource {

	private static Properties sProperties = new Properties();

	public static LanguageResource sLanguageResource;

	private static LanguageResource getInstance() {
		if (sLanguageResource == null) {
			sLanguageResource = new LanguageResource();
		}
		return sLanguageResource;
	}

	private LanguageResource() {
		super();
		try {
			loadProps();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	private static void loadProps() throws Exception {
		File aContextDir = new File(
				PropertyManager.getProperty("languagePath"), Language
						.getCurrentLocale().getLanguage());
		File[] aLanguageFiles = aContextDir
				.listFiles(new java.io.FilenameFilter() {
					public boolean accept(File dir, String name) {
						return (name.endsWith("xml") || name.endsWith("XML"));
					}
				});
		for (File aString : aLanguageFiles) {
			FileInputStream aFileInputStream = new FileInputStream(aString);
			sProperties.loadFromXML(aFileInputStream);
		}
	}

	public static String getString(String pKey) {
		return getInstance().getProperties().getProperty(pKey);
	}

	private Properties getProperties() {
		return sProperties;
	}

	public void setProperties(Properties pProperties) {
		sProperties = pProperties;
	}

}
