#!/bin/sh


Die() {
    echo "$1" >> /dev/stderr
    exit 1
}



# =================== main =================== 


mindi_path=`find /usr/{local,share} -name mindi -follow -type d -maxdepth 2 2> /dev/null | grep -v \"1\\.[2-9]x\"`
[ "$mindi_path" ] || Die "Cannot find mindi. Have you installed it already?"
mondo_path=`dirname $mindi_path`
docdir=/usr/share/doc/`find mondo* | grep "\.spec" | head -n1 | cut -d'.' -f1,2`

make all || Die "Unable to compile Mondo"
make install || Die "Unable to install Mondo"

echo "Installed Mondo OK!"
exit 0

