/* libmondo-files.c                                  file manipulation


07/02
- modified calls to popup_and_get_string()

04/26
- if >4 media est'd, say one meeeellion

04/07
- fixed find_home_of_exe()

01/14/2003
- if backup media type == nfs then don't estimate no. of media reqd
  if (bkpinfo->media_size[1]<=0 || bkpinfo->backup_media_type == nfs)


11/25/2002
- don't log/echo estimated # of media required if >=50

11/09
- chmod uses 0x, not decimal :)

11/07
- added is_this_file_compressed()

10/29
- replace convoluted grep with wc (KP)

09/01 - 09/30
- only show "number of media" estimate if no -x
- run_program_and_log_output() now takes boolean operator to specify
  whether it will log its activities in the event of _success_

08/01 - 08/31
- handle unknown media sizes
- cleaned up some log_it() calls

07/24
- created
*/



#include "my-stuff.h"
#include "mondostructures.h"
#include "libmondo-files.h"
#include "lib-common-externs.h"

#include "libmondo-tools-EXT.h"
#include "libmondo-gui-EXT.h"
#include "libmondo-fork-EXT.h"
#include "libmondo-string-EXT.h"




extern char err_log_lines[NOOF_ERR_LINES][MAX_STR_LEN];

extern int g_currentY;
extern char g_mondo_home[MAX_STR_LEN];


/*************************************************************************
 * calc_checksum_of_file() -- Hugo Rabson                                *
 *                                                                       *
 * Purpose:  Use 'md5sum' to calculate checksum of specified file        *
 * Called by:...                                                         *
 * Params:   filename         name of file for which to calc a checksum  *
 * Returns:  static string containing resultant checksum                 *
 *************************************************************************/
char *
calc_checksum_of_file (char *filename)
{
	/** buffers ******************************************************/
  static char output[MAX_STR_LEN];
  char command[MAX_STR_LEN*2];
  char tmp[MAX_STR_LEN];

	/** pointers *****************************************************/
  char *p;
  FILE *fin;

	/** initialize pointers ******************************************/

  p = output;

	/*****************************************************************/

  if (does_file_exist (filename))
    {
      sprintf (command, "md5sum \"%s\"", filename);
      fin = popen (command, "r");
      if (fin)
	{
	  fgets (output, MAX_STR_LEN, fin);
	  p = strchr (output, ' ');
	  pclose (fin);
	}
    }
  else
    {
      sprintf (tmp, "File '%s' not found; cannot calc checksum", filename);
      log_it (tmp);
    }
  if (p)
    {
      *p = '\0';
    }
  return (output);
}



/*************************************************************************
 * calc_file_ugly_minichecksum() -- Hugo Rabson                          *
 *                                                                       *
 * Purpose:  Generate a not-quite-unique string based on file's size,    *
 *           modification date, permissions, full path, etc.             *
 * Called by:...                                                         *
 * Returns:  static string containing resultant checksum                 *
 *************************************************************************/
char *
calc_file_ugly_minichecksum (char *curr_fname)
{

	/** buffers ******************************************************/
  static char curr_cksum[1000];

	/** pointers *****************************************************/
  char *sz_ptr;

	/** structures ***************************************************/
  struct stat buf;

  /** initialize data ****************************************************/
  curr_cksum[0] = '\0';

	/*****************************************************************/

  if (lstat (curr_fname, &buf))
    {
      return (curr_cksum);
    }

  sprintf (curr_cksum, "%ld-%ld-%ld", (long) (buf.st_size),
	   (long) (buf.st_mtime), (long) (buf.st_ctime));
  return (curr_cksum);
  /*
     }
     CalcCksum(curr_cksum,curr_fname);
   */
  /*
     sprintf(syscall,"cksum \"%s\" 2> /dev/null",curr_fname);

     pout=popen(syscall,"r");
     if (!pout)
     {return(curr_cksum);}
     fgets(curr_cksum,999,pout);
     pclose(pout);
   */

  sz_ptr = (char *) strchr (curr_cksum, ' ');
  if (!sz_ptr)
    {
      sz_ptr = curr_cksum;
    }
  *sz_ptr = '\0';
  return (curr_cksum);
}




/*************************************************************************
 * count_lines_in_file() -- Hugo Rabson                                  *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * Returns:                                                              *
 *************************************************************************/
long
count_lines_in_file (char *filename)
{

	/** buffers ******************************************************/
  char command[MAX_STR_LEN*2];
  char incoming[MAX_STR_LEN];
  char tmp[MAX_STR_LEN];

	/** long *********************************************************/
  long noof_lines = -1L;

	/** pointers *****************************************************/
  FILE *fin;

  /** initialize [0] to null *********************************************/
  incoming[0] = '\0';

/*
  sprintf(tmp,"Counting the lines in file '%s'",filename);
  log_it(tmp);
*/
  if (!does_file_exist (filename))
    {
      sprintf (tmp,
	       "%s does not exist, so I cannot found the number of lines in it",
	       filename);
      log_it (tmp);
      return (0);
    }
  //  sprintf (command, "grep -n \"\" %s | tail -n1 | cut -d':' -f1 2> /dev/null", filename);
  sprintf (command, "cat %s | wc -l", filename);
  if (!does_file_exist(filename)) { return(-1); }
  fin = popen (command, "r");
  if (fin)
    {
      if (feof (fin))
	{
	  noof_lines = 0;
	}
      else
	{
	  fgets (incoming, MAX_STR_LEN - 1, fin);
	  while (strlen (incoming) > 0
		 && incoming[strlen (incoming) - 1] < 32)
	    {
	      incoming[strlen (incoming) - 1] = '\0';
	    }
	  noof_lines = atol (incoming);
	}
      pclose (fin);
    }
/*
  sprintf(tmp,"File '%s' has %ld lines in it",filename,noof_lines);
  log_it(tmp);
*/
  return (noof_lines);
}



/*************************************************************************
 * does_file_exist() -- Hugo Rabson                                      *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * Returns:                                                              *
 *************************************************************************/
bool
does_file_exist (char *filename)
{

	/** structures ***************************************************/
  struct stat buf;

	/*****************************************************************/

  if (lstat (filename, &buf))
    {
      return (FALSE);
    }
  else
    {
      return (TRUE);
    }
}






/*************************************************************************
 * exclude_nonexistent_files() -- Hugo Rabson                            *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * Returns:                                                              *
 *************************************************************************/
void
exclude_nonexistent_files (char *inout)
{
  char infname[MAX_STR_LEN];
  char outfname[MAX_STR_LEN];
  char tmp[MAX_STR_LEN];
  char incoming[MAX_STR_LEN];

	/** int **********************************************************/
  int i;

	/** pointers *****************************************************/
  FILE *fin, *fout;


 /** end vars ************************************************************/

  sprintf (infname, "%s.in", inout);
  sprintf (outfname, "%s", inout);
  sprintf (tmp, "cp -f %s %s", inout, infname);
  run_program_and_log_output (tmp, FALSE);
  fin = fopen (infname, "r");
  fout = fopen (outfname, "w");
  for (fgets (incoming, MAX_STR_LEN, fin); !feof (fin);
       fgets (incoming, MAX_STR_LEN, fin))
    {
      i = strlen (incoming) - 1;
      if (i >= 0 && incoming[i] < 32)
	{
	  incoming[i] = '\0';
	}
      if (does_file_exist (incoming))
	{
	  fprintf (fout, "%s\n", incoming);
	}
      else
	{
	  sprintf (tmp, "Excluding '%s'-nonexistent\n", incoming);
	  log_it (tmp);
	}
    }
  fclose (fout);
  fclose (fin);
  unlink (infname);
}










int figure_out_kernel_path_interactively_if_necessary(char*kernel)
{
  char tmp[MAX_STR_LEN];

      if (!kernel[0])
        { strcpy(kernel, call_program_and_get_last_line_of_output("mindi --findkernel")); }
      log_it("Calling Mindi with kernel path of '%s'", kernel);
      while(!kernel[0])
        {
          if (!ask_me_yes_or_no("Kernel not found or invalid. Choose another?"))
            { return(1); }
          if (!popup_and_get_string("Kernel path", "What is the full path and filename of your kernel, please?", kernel, MAX_STR_LEN/4))
            { fatal_error("Kernel not found. Please specify with the '-k' flag."); }
          sprintf(tmp, "User says kernel is at %s", kernel);
          log_it(tmp);
        }
      return(0);
}






/*************************************************************************
 * find_home_of_exe() -- Hugo Rabson                                     *
 *                                                                       *
 * Purpose:  Find out where specified executable is installed.           *
 * Called by:                                                            *
 * Params:   fname                    filename of executable             *
 * Returns:  static string containing full path, or NULL if exe not found*
 *************************************************************************/
char *
find_home_of_exe (char *fname)
{
	/** buffers **********************/
  static char output[MAX_STR_LEN];
  char incoming[MAX_STR_LEN];
  char command[MAX_STR_LEN*2];

  incoming[0] = '\0';
 /**********************************/

  sprintf (command, "which %s", fname);
  strcpy (incoming, call_program_and_get_last_line_of_output (command));
  if (incoming[0] == '\0')
    {
      sprintf (command, "file %s 2> /dev/null | cut -d':' -f1'", incoming);
      strcpy (incoming, call_program_and_get_last_line_of_output (command));
    }
  if (incoming[0] == '\0') // yes, it is == '\0' twice, not once :)
    {
      sprintf (command, "dirname %s 2> /dev/null", incoming);
      strcpy (incoming, call_program_and_get_last_line_of_output (command));
    }
  strcpy (output, incoming);
  if (does_file_exist(output))
    { log_it("find_home_of_exe () --- Found %s at %s", fname, incoming); }
  else
    { output[0]='\0'; log_it("find_home_of_exe() --- Could not find %s", fname); }
  return (output);
}





/*************************************************************************
 * get_trackno_from_logfile() -- Hugo Rabson 										         *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
int
get_trackno_from_logfile (char *logfile)
{

	/** pointers **********************************************************/
  FILE *fin;

	/** int ***************************************************************/
  int trackno	= 0;
	int len	= 0;

	/** buffer *************************************************************/
  char datablock[32701];


  fin = fopen (logfile, "r");
  len = fread (datablock, 1, 32700, fin);
  fclose (fin);
  if (len <= 0)
    {
      return (0);
    }
  for (; len > 0 && !isdigit (datablock[len - 1]); len--);
  datablock[len--] = '\0';
  for (; len > 0 && isdigit (datablock[len - 1]); len--);
  trackno = atoi (datablock + len);
  /*
     sprintf(tmp,"datablock=%s; trackno=%d",datablock+len, trackno);
     log_it(tmp);
   */
  return (trackno);
}








/*************************************************************************
 * grab_percentage_from_last_line_of_file() -- Hugo Rabson               *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * Returns:                                                              *
 *************************************************************************/
int
grab_percentage_from_last_line_of_file (char *filename)
{

	/** buffers ******************************************************/
  char tmp[MAX_STR_LEN];
  char lastline[MAX_STR_LEN];

	/** pointers *****************************************************/
  char *p;

	/** int's ********************************************************/
  int i;


  /* strcpy(lastline,last_line_of_file(filename)); */
  strcpy (lastline, err_log_lines[NOOF_ERR_LINES - 1]);
  sprintf (tmp, "lastline = %s", lastline);
  p = strstr (lastline, "% done");
  if (!p)
    {
      p = strstr (lastline, "%% Done");
    }
  if (!p)
    {
      p = strstr (lastline, "%% ");
    }
  if (!p)
    {
      return (0);
    }
  *p = '\0';
  /*
     sprintf(tmp,"lastline = '%s'");
     log_to_screen(tmp);
   */
  for (p -= 1; *p != ' ' && p != lastline; p--);
  if (p != lastline)
    {
      p++;
    }
  i = atoi (p);
  /*
     sprintf(tmp,"'%s' --> %d",p,i);
     log_to_screen(tmp);
   */
  return (i);
}






/*************************************************************************
 * last_line_of_file() -- Hugo Rabson                                    *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * Returns:                                                              *
 *************************************************************************/
char *
last_line_of_file (char *filename)
{
	/** buffers ******************************************************/
  static char output[MAX_STR_LEN];
  static char command[MAX_STR_LEN*2];
  static char tmp[MAX_STR_LEN];

	/** pointers *****************************************************/
  FILE *fin;

	/** end vars *****************************************************/

  if (!does_file_exist (filename))
    {
      sprintf (tmp, "Tring to get last line of nonexistent file (%s)",
	       filename);
      log_it (tmp);
      output[0] = '\0';
      return (output);
    }
  sprintf (command, "cat %s | tail -n1", filename);
  fin = popen (command, "r");
  fgets (output, MAX_STR_LEN, fin);
  pclose (fin);
  while (strlen (output) > 0 && output[strlen (output) - 1] < 32)
    {
      output[strlen (output) - 1] = '\0';
    }
  return (output);
}
/*************************************************************************
 * length_of_file() -- Hugo Rabson                                       *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * Returns:                                                              *
 *************************************************************************/
long long
length_of_file (char *filename)
{
	/** pointers ****************************************************/
  FILE *fin;

	/** long long **************************************************/
  long long length;

  fin = fopen (filename, "r");
  if (!fin)
    {
      return (-1);
    }
  fseek (fin, 0, SEEK_END);
  length = ftell (fin);
  fclose (fin);
  return (length);
}




/*************************************************************************
 * make_checksum_list_file() -- Hugo Rabson                              *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * Returns:                                                              *
 *************************************************************************/
int
make_checksum_list_file (char *filelist, char *cksumlist, char *comppath)
{
	/** pointers *****************************************************/
  FILE *fin;
  FILE *fout;

	/** int   ********************************************************/
  int percentage;
  int i;
  int counter = 0;

	/** buffer *******************************************************/
  char stub_fname[1000];
  char curr_fname[1000];
  char curr_cksum[1000];
  char tmp[1000];

	/** end vars ****************************************************/
  long filelist_length;
  long curr_pos;
  long start_time;
  long current_time;
  long time_taken;
  long time_remaining;

	/** end vars ****************************************************/

  start_time = get_time ();
  filelist_length = length_of_file (filelist);
  sprintf (tmp, "filelist = %s; cksumlist = %s", filelist, cksumlist);
  log_it (tmp);
  fin = fopen (filelist, "r");
  if (fin == NULL)
    {
      log_to_screen ("Can't open filelist");
      return (1);
    }
  fout = fopen (cksumlist, "w");
  if (fout == NULL)
    {
      fclose (fin);
      log_to_screen ("Can't open checksum list");
      return (1);
    }
  for (fgets (stub_fname, 999, fin); !feof (fin);
       fgets (stub_fname, 999, fin))
    {
      if (stub_fname[(i = strlen (stub_fname) - 1)] < 32)
	{
	  stub_fname[i] = '\0';
	}
      sprintf (tmp, "%s%s", comppath, stub_fname);
      strcpy (curr_fname, tmp + 1);
      strcpy (curr_cksum, calc_file_ugly_minichecksum (curr_fname));
      fprintf (fout, "%s\t%s\n", curr_fname, curr_cksum);
      if (counter++ > 12)
	{
	  current_time = get_time ();
	  counter = 0;
	  curr_fname[37] = '\0';
	  curr_pos = ftell (fin) / 1024;
	  percentage = (int) (curr_pos * 100 / filelist_length);
	  time_taken = current_time - start_time;
	  if (percentage == 0)
	    {
	      /*              printf("%0d%% done      \r",percentage); */
	    }
	  else
	    {
	      time_remaining =
		time_taken * 100 / (long) (percentage) - time_taken;
	      sprintf (tmp,
		       "%02d%% done   %02d:%02d taken   %02d:%02d remaining  %-37s\r",
		       percentage, (int) (time_taken / 60),
		       (int) (time_taken % 60), (int) (time_remaining / 60),
		       (int) (time_remaining % 60), curr_fname);
	      log_to_screen (tmp);
	    }
	  sync ();
	}
    }
  fclose (fout);
  fclose (fin);
  log_it ("Done.");
  return (0);
}



/*************************************************************************
 * make_hole_for_file() -- Hugo Rabson                                   *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * Returns:                                                              *
 *************************************************************************/
int
make_hole_for_file (char *outfile_fname)
{
	/** buffer *******************************************************/
  char command[MAX_STR_LEN*2];

	/** int  *********************************************************/
  int res = 0;

	/** end vars ****************************************************/

  sprintf (command, "mkdir -p \"%s\" 2> /dev/null", outfile_fname);
  res += system (command);
  sprintf (command, "rmdir \"%s\" 2> /dev/null", outfile_fname);
  res += system (command);
  sprintf (command, "rm -f \"%s\" 2> /dev/null", outfile_fname);
  res += system (command);
  unlink (outfile_fname);
  return (0);
}




/*************************************************************************
 * make_list_of_files_to_ignore() -- Hugo Rabson 	                 *
 *                                                                       *
 * Purpose:  Unknown. Subroutine is not in use at this time.             *
 * Called by:No-one.                                                     *
 * Params:   ignorefiles_fname                                           *
 *           filelist_fname                                              *
 *           cklist_fname                                                *
 * Returns:  void                                                        *
 *           [file filelist_fname is written out]                        *
 *************************************************************************/
void
make_list_of_files_to_ignore (char *ignorefiles_fname, char *filelist_fname,
			      char *cklist_fname)
  /* make a list of files which have changed on the disk since backup */
{
	/** buffers ****/
/*
  char command[MAX_STR_LEN*2];


  log_to_screen
    ("Making a list of files which have changed on hard disk since backup\n");
  sprintf (command,
	   "%s/mondo-checksum %s %s / --verify | grep -v \"not found on filesystem\" | cut -f1 > %s",
	   g_mondo_home, filelist_fname, cklist_fname, ignorefiles_fname);
  log_it (command);
  if (system (command))
    {
      log_it ("Failed to make list of files to ignore");
    }
  exclude_nonexistent_files (ignorefiles_fname);
*/
}






/*************************************************************************
 * noof_lines_that_match_wildcard() -- Hugo Rabson                       *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * Returns:                                                              *
 *************************************************************************/
long
noof_lines_that_match_wildcard (char *filelist_fname, char *wildcard)
{
	/** long ********************************************************/
  long matches = 0;

	/** pointers ****************************************************/
  FILE *fin;

	/** buffers *****************************************************/
  char incoming[MAX_STR_LEN];

  fin = fopen (filelist_fname, "r");

	/** end vars ****************************************************/
  if (!fin)
    {
      return (0);
    }
  fgets (incoming, MAX_STR_LEN - 1, fin);
  while (!feof (fin))
    {
      if (strstr (incoming, wildcard))
	{
	  matches++;
	}
      fgets (incoming, MAX_STR_LEN - 1, fin);
    }
  fclose (fin);
  return (matches);
}





void register_pid(pid_t pid, char*name_str)
/*
Purpose:Register executable's PID in /var/run/monitas-[name_str].pid;
        store [pid] in data file
Params:	pid - process ID to be stored in data file
        name_str - name (e.g. "client" or "server") to be included
        in the data file name of the PID locking file
Return: None
NB:     Use pid=0 to delete the lock file and unregister the PID
*/
{
  char tmp[MAX_STR_LEN+1], lockfile_fname[MAX_STR_LEN+1];
  int res;
  FILE*fin;

  sprintf(lockfile_fname, "/var/run/monitas-%s.pid", name_str);
  if (!pid)
    {
      log_it("Unregistering PID");
      if (unlink(lockfile_fname)) { log_it( "Error unregistering PID"); }
      return;
    }
  if (does_file_exist(lockfile_fname))
    {
      tmp[0]='\0';
      if ((fin=fopen(lockfile_fname,"r"))) { fgets(tmp, MAX_STR_LEN, fin); fclose(fin); }
      pid = atol(tmp);
      sprintf(tmp, "ps %ld &> /dev/null", (long int)pid);
      res = system(tmp);
      if (!res)
        {
          log_it ("I believe the daemon is already running. If it isn't, please delete %s and try again.", lockfile_fname);
        }
    }
  sprintf(tmp, "echo %ld > %s", (long int)getpid(), lockfile_fname);
  if (system(tmp)) { fatal_error( "Cannot register PID"); }
}




/*************************************************************************
 * size_of_all_biggiefiles_K() -- Hugo Rabson                            *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * Returns:                                                              *
 *************************************************************************/
long
size_of_all_biggiefiles_K (struct s_bkpinfo *bkpinfo)
{
	/** buffers ******************************************************/
  char fname[MAX_STR_LEN];
  char biggielist[MAX_STR_LEN];
  char command[MAX_STR_LEN*2];
  char res_sz[MAX_STR_LEN];
  char comment[MAX_STR_LEN];

	/** long *********************************************************/
  long scratchL = 0;
  long file_len_K;

	/** pointers ****************************************************/
  FILE *fin;

	/** end vars ****************************************************/


  log_it ("Calculating size of all biggiefiles (in total)");
  sprintf (biggielist, "%s/biggielist.txt", bkpinfo->tmpdir);
  log_it("biggielist = %s", biggielist);
  if (!(fin = fopen (biggielist, "r")))
    {
      log_it
	("Cannot open biggielist. OK, so estimate is based on filesets only.");
    }
  else
    {
      log_it("Reading it...");
      for (fgets (fname, MAX_STR_LEN, fin); !feof (fin);
	   fgets (fname, MAX_STR_LEN, fin))
	{
	  //          log_it("fname = '%s'", fname);
	  strip_spaces (fname);
	  //          log_it("after stripping spaces, it is '%s'", fname);
	  if (0 == strncmp (fname, "/dev/", 5))
	    {
	      sprintf (command,
		       "cat %s/mountlist.txt | grep \"%s \" | head -n1 | cut -d' ' -f4",
		       bkpinfo->tmpdir, fname);
	      log_it (command);
	      strcpy (res_sz,
		      call_program_and_get_last_line_of_output (command));
	      file_len_K = atol (res_sz);
	      if (file_len_K > 0)
		{
		  scratchL += file_len_K;
		}
	    }
	  else
	    {
	      //              log_it("Asking for length of file '%s'", fname);
	      file_len_K = (long) (length_of_file (fname) / 1024);
	      if (file_len_K > 0)
		{
		  scratchL += file_len_K;
		}
	      //              log_it("Got it. It is %ld K", file_len_K);
	    }
	  sprintf (comment, "After adding %s, scratchL+%ld now equals %ld",
		   fname, file_len_K, scratchL);
	  //          log_it(comment);
          if (feof(fin)) { break; }
	}
    }
  log_it ("Closing...");
  fclose (fin);
  log_it ("Finished calculating total size of all biggiefiles");
  return (scratchL);
}


/*************************************************************************
 * space_occupied_by_cd() -- Hugo Rabson                                 *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * Returns:                                                              *
 *************************************************************************/
long long
space_occupied_by_cd (char *mountpt)
{
	/** buffer *******************************************************/
  char tmp[MAX_STR_LEN];
  char command[MAX_STR_LEN*2];
  long long llres;
	/** pointers *****************************************************/
  char *p;
  FILE *fin;

	/** end vars ****************************************************/

  sprintf (command, "du -sk %s", mountpt);
  fin = popen (command, "r");
  fgets (tmp, MAX_STR_LEN, fin);
  pclose (fin);
  p = strchr (tmp, '\t');
  if (p)
    {
      *p = '\0';
    }
  for(p=tmp,llres=0; *p!='\0'; p++)
    {
      llres*=10;
      llres+=(int)(*p - '0');
    }
  return (llres);
/*
  p = strchr (tmp, '\t');
  if (p)
    {
      *p = '\0';
    }
  return (atoll (tmp));
*/
}


/*************************************************************************
 * updcrc() -- Hugo Rabson                                               *
 *                                                                       *
 * Called by:...                                                         *
 * Params:   crc       original CRC value                                *
 * Params:   c         char to be added to the mix                       *
 * Returns:  new crc value                                               *
 *************************************************************************/
unsigned int
updcrc (unsigned int crc, unsigned int c)
{
  unsigned int tmp;
  tmp = (crc >> 8) ^ c;
  crc = (crc << 8) ^ crctttab[tmp & 255];
  return crc;
}

/*************************************************************************
 * updcrcr() -- Hugo Rabson                                              *
 *                                                                       *
 * Purpose:  update crc reverse                                          *
 * Called by:...                                                         *
 * Params:   crc       original CRC value                                *
 * Params:   c         char to be added to the mix                       *
 * Returns:  new crc value                                               *
 *************************************************************************/
unsigned int
updcrcr (crc, c)
     unsigned int crc;
     unsigned int c;
{
  unsigned int tmp;
  tmp = crc ^ c;
  crc = (crc >> 8) ^ crc16tab[tmp & 0xff];
  return crc;
}





/*************************************************************************
 * whine_if_not_found() -- Hugo Rabson                                   *
 *                                                                       *
 * Purpose:  Write error msg to log + screen if executable cannot be     *
 *           found by 'which'                                            *
 * Called by:some_basic_system_sanity_checks()                           *
 * Params:   fname        executable's filename                          *
 * Returns:  1=error (not found); otherwise, 0 (found)                   *
 *************************************************************************/
int
whine_if_not_found (char *fname)
{
	/** buffers ****/
  char command[MAX_STR_LEN*2];
  char errorstr[MAX_STR_LEN];


  sprintf (command, "which %s > /dev/null 2> /dev/null", fname);
  sprintf (errorstr, "Please install '%s'. I cannot find it on your system.",
	   fname);
  if (system (command))
    {
      log_to_screen (errorstr);
      log_to_screen
	("There may be hyperlink at http://www.mondorescue.com which");
      log_to_screen ("will take you to the relevant (missing) package.");
      return (1);
    }
  else
    {
      return (0);
    }
}







/*************************************************************************
 * write_one_liner_data_file() -- Hugo Rabson                            *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * Returns:                                                              *
 *************************************************************************/
int
write_one_liner_data_file (char *fname, char *contents)
{
	/** pointers ****************************************************/
  FILE *fout;

	/** end vars ****************************************************/

  if (!(fout = fopen (fname, "w")))
    {
      return (1);
    }
  fprintf (fout, "%s\n", contents);
  fclose (fout);
  return (0);
}











/*************************************************************************
 * copy_mondo_and_mindi_stuff() -- Hugo Rabson 									         *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
void
copy_mondo_and_mindi_stuff_to_scratchdir (struct s_bkpinfo *bkpinfo)
{
	/** Char buffers ***/
  char command[MAX_STR_LEN*2];
  char tmp[MAX_STR_LEN];

  mvaddstr_and_log_it (g_currentY, 0,
		       "Copying Mondo's core files to the scratch directory");

  sprintf (command, "cp --parents -pRdf %s %s", g_mondo_home,
	   bkpinfo->scratchdir);

  if (run_program_and_log_output (command, FALSE))
    {
      fatal_error ("Failed to copy Mondo's stuff to scratchdir");
    }

  sprintf (command, "cp -f %s/LAST-FILELIST-NUMBER %s", bkpinfo->tmpdir,
	   bkpinfo->scratchdir);

  if (run_program_and_log_output (command, FALSE))
    {
      fatal_error ("Failed to copy LAST-FILELIST-NUMBER to scratchdir");
    }

  strcpy (tmp,
	  call_program_and_get_last_line_of_output ("which mondorestore"));
  if (!tmp[0]) { fatal_error("'which mondorestore' returned null. Where's your mondorestore? `which` can't find it. That's odd. Did you install mondorestore?"); }
  sprintf (command, "cp -f %s %s", tmp, bkpinfo->tmpdir);
  if (run_program_and_log_output (command, FALSE))
    {
      fatal_error ("Failed to copy mondorestore to tmpdir");
    }

  sprintf (command, "hostname > %s/HOSTNAME", bkpinfo->scratchdir);
  system (command);

  if (bkpinfo->postnuke_tarball[0])
    {
      sprintf (command, "cp -f %s %s/post-nuke.tgz", bkpinfo->postnuke_tarball, bkpinfo->tmpdir);
      if (run_program_and_log_output (command, FALSE))
        { fatal_error("Unable to copy post-nuke tarball to tmpdir"); }
    }


  mvaddstr_and_log_it (g_currentY++, 74, "Done.");
}






/*************************************************************************
 * store_nfs_config() -- Hugo Rabson	                                   *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
void
store_nfs_config (struct s_bkpinfo *bkpinfo)
{

	/** buffers *********/
  char outfile[MAX_STR_LEN];
  char nfs_dev[MAX_STR_LEN];
  char nfs_mount[MAX_STR_LEN];
  char nfs_client_ipaddr[MAX_STR_LEN];
  char nfs_server_ipaddr[MAX_STR_LEN];
  char tmp[MAX_STR_LEN];
  char command[MAX_STR_LEN*2];

	/** pointers ******/
  char *p;
  FILE *fout;



  log_it ("Storing NFS configuration");
  strcpy (tmp, bkpinfo->nfs_mount);
  p = strchr (tmp, ':');
  if (!p)
    {
      fatal_error
	("NFS mount doesn't have a colon in it, e.g. 192.168.1.4:/home/nfs");
    }
  *(p++) = '\0';
  strcpy (nfs_server_ipaddr, tmp);
  strcpy (nfs_mount, p);
  sprintf (command,
	   "ifconfig | tr '\n' '#' | sed s/##// | tr '#' ' ' | tr '' '\n' | head -n1 | cut -d' ' -f1");
  strcpy (nfs_dev, call_program_and_get_last_line_of_output (command));
  sprintf (command,
	   "ifconfig | tr '\n' '#' | sed s/##// | tr '#' ' ' | tr '' '\\n' | head -n1 | tr -s '\t' ' ' | cut -d' ' -f7 | cut -d':' -f2");
  strcpy (nfs_client_ipaddr,
	  call_program_and_get_last_line_of_output (command));
  sprintf (tmp, "nfs_client_ipaddr=%s; nfs_server_ipaddr=%s; nfs_mount=%s",
	   nfs_client_ipaddr, nfs_server_ipaddr, nfs_mount);
  //  log_it(tmp);
  if (strlen (nfs_dev) < 2)
    {
      fatal_error
	("Unable to find ethN (eth0, eth1, ...) adapter via NFS mount you specified.");
    }
  sprintf (outfile, "%s/start-nfs", bkpinfo->tmpdir);
  sprintf (tmp, "outfile = %s", outfile);
  log_it (tmp);
  if (!(fout = fopen (outfile, "w")))
    {
      fatal_error ("Cannot store NFS config");
    }
  fprintf (fout, "ifconfig %s %s; # config client\n", nfs_dev,
	   nfs_client_ipaddr);
  fprintf (fout, "# ping -c1 %s; # ping server\n", nfs_server_ipaddr);
  fprintf (fout, "# mount %s -t nfs /mnt/isodir\n", bkpinfo->nfs_mount);
  fprintf (fout, "exit 0\n");
  fclose (fout);
  chmod (outfile, 0x777);
  system ("mkdir -p /var/cache/mondo-archive 2> /dev/null");
  sprintf (tmp, "cp -f %s /var/cache/mondo-archive", outfile);
  run_program_and_log_output(tmp, FALSE);

  sprintf (tmp, "%s/NFS-DEV", bkpinfo->tmpdir);
  write_one_liner_data_file (tmp, nfs_dev);

  sprintf (tmp, "%s/NFS-CLIENT-IPADDR", bkpinfo->tmpdir);
  write_one_liner_data_file (tmp, nfs_client_ipaddr);
  sprintf (tmp, "%s/NFS-SERVER-IPADDR", bkpinfo->tmpdir);
  write_one_liner_data_file (tmp, nfs_server_ipaddr);
  sprintf (tmp, "%s/NFS-SERVER-MOUNT", bkpinfo->tmpdir);
  write_one_liner_data_file (tmp, bkpinfo->nfs_mount);
  sprintf (tmp, "%s/NFS-SERVER-PATH", bkpinfo->tmpdir);
  write_one_liner_data_file (tmp, bkpinfo->nfs_remote_dir);
  log_it ("Finished storing NFS configuration");
}







/*************************************************************************
 * estimate_noof_media_required() -- Hugo Rabson                         *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * returns:                                                              *
 *************************************************************************/
void
estimate_noof_media_required (struct s_bkpinfo *bkpinfo, long noof_sets)
{
	/** buffers ****************/
  char tmp[MAX_STR_LEN];

	/** longs  ****************/
  long scratchLL;

  if (bkpinfo->media_size[1]<=0 || bkpinfo->backup_media_type == nfs)
    {
      log_to_screen("Number of media required: UNKNOWN");
      return;
    }

  log_it ("Estimating number of media required...");
  scratchLL = (long long)(noof_sets) * (long long)(bkpinfo->optimal_set_size)
    + (long long)(size_of_all_biggiefiles_K (bkpinfo));
  scratchLL = (scratchLL / 1024) / bkpinfo->media_size[1];
  scratchLL++;
  if (bkpinfo->use_lzo)
    {
      scratchLL = (scratchLL * 2) / 3;
    }
  else
    {
      scratchLL = scratchLL / 2;
    }
  if (!scratchLL)
    {
      scratchLL++;
    }
  if (scratchLL <= 1)
    {
      sprintf (tmp,
	       "Your backup will probably occupy a single CD/tape/ISO. Maybe two.");
    }
  else if (scratchLL > 4)
    {
      sprintf(tmp, "Your backup will occupy one meeeeellion media! (maybe %s)", 
	       number_to_text ((int) (scratchLL + 1)));
    }
  else
    {
      sprintf (tmp, "Your backup will occupy approximately %s media.",
	       number_to_text ((int) (scratchLL + 1)));
    }
  if (!bkpinfo->image_devs[0] && (scratchLL<50))
    {
      log_to_screen (tmp);
    }
}



char*sz_last_suffix(char*instr)
{
  static char outstr[MAX_STR_LEN];
  char *p;

  p = strrchr(instr,'.');
  if (!p)
    {
      outstr[0]='\0';
    }
  else
    {
      strcpy(outstr, p);
    }
  return(outstr);
}



bool is_this_file_compressed(char*filename)
{
  char do_not_compress_these[MAX_STR_LEN];
  char tmp[MAX_STR_LEN];
  char *p;

  sprintf(tmp, "%s/do-not-compress-these", g_mondo_home);
  if (!does_file_exist(tmp)) { return(FALSE); }
  strcpy(do_not_compress_these, last_line_of_file(tmp));
  for(p=do_not_compress_these; p!=NULL; p++)
    {
      strcpy(tmp, p);
      if (strchr(tmp, ' ')) { *(strchr(tmp, ' ')) ='\0'; }
      //      printf("Suffix = %s\n", tmp);
      //      printf("Comparing %s and %s\n", sz_last_suffix(filename), tmp);
      if (!strcmp(sz_last_suffix(filename), tmp))
	{ /*printf("MATCH\n");*/ return(TRUE); }
      if (!(p = strchr(p, ' '))) { break; }
    }
  return(FALSE);
}





