/* libmondo-fork.c

- subroutines for handling forking/pthreads/etc.


04/27/2003
- replace newtFinished() and newtInit() with
  newtSuspend() and newtResume()

12/10/2002
- patch by Heiko Schlittermann to handle % chars in issue.net

11/18
- if mkisofs in eval_call_to_make_ISO() returns an error then return it,
  whether ISO was created or not

10/30
- if mkisofs in eval_call_to_make_ISO() returns an error then find out if
  the output (ISO) file has been created; if it has then return 0 anyway

08/01 - 09/30
- run_program_and_log_output() now takes boolean operator to specify
  whether it will log its activities in the event of _success_
- system() now includes 2>/dev/null
- enlarged some tmp[]'s
- added run_program_and_log_to_screen() and run_program_and_log_output()

07/24
- created
*/


#include "my-stuff.h"
#include "mondostructures.h"
#include "libmondo-fork.h"
#include "libmondo-string-EXT.h"
#include "libmondo-gui-EXT.h"
#include "libmondo-files-EXT.h"
#include "libmondo-tools-EXT.h"
#include "lib-common-externs.h"






extern bool g_text_mode;


/*************************************************************************
 * *call_program_and_get_last_line_of_ouput() -- Hugo Rabson             *
 *                                                                       *
 * Purpose:  Run a program. Save its last line of output. Return it.     *
 * Called by:...                                                         *
 * Params:   call         call to executable w/params                    *
 * Returns:  char*        pointer to static string containing last line  *
 *                        of output of executable (stdout+stderr)        *
 *************************************************************************/

char *
call_program_and_get_last_line_of_output (char *call)
{
	/** buffers ******************************************************/
  static char result[MAX_STR_LEN];
  char tmp[MAX_STR_LEN];

	/** pointers *****************************************************/
  FILE *fin;

	/** initialize data **********************************************/
  result[0] = '\0';

  /***********************************************************************/
  if ((fin = popen (call, "r")))
    {
      for (fgets (tmp, MAX_STR_LEN, fin); !feof (fin);
	   fgets (tmp, MAX_STR_LEN, fin))
	{
	  if (strlen (tmp) > 1)
	    {
	      strcpy (result, tmp);
	    }
	}
      pclose (fin);
    }
  strip_spaces (result);
  return (result);
}






#define MONDO_POPMSG  "Your PC will not retract the CD tray automatically. Please call mondoarchive with the -m (manual CD tray) flag."


/*************************************************************************
 * eval_call_to_make_ISO() -- Hugo Rabson 	                         *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * Params:
 * Returns:                                                              *
 *************************************************************************/
int
eval_call_to_make_ISO (struct s_bkpinfo *bkpinfo,
	   char *basic_call, char *isofile,
	   int cd_no, char *logstub, char *what_i_am_doing)
{
  	
	/** int's  ****/
  int retval = 0;
  int res = 0;
  int blanklines = 0;
  int jj = 0;
  int i = 0;

  /** File pointer ****/
  FILE *fin;

	/** buffers      ****/
  char midway_call[MAX_STR_LEN*2];
  char ultimate_call[MAX_STR_LEN*2];
  char tmp[MAX_STR_LEN*2];
  char command[MAX_STR_LEN*2];
  char incoming[MAX_STR_LEN*2];
  char old_stderr[MAX_STR_LEN];
  char stderr_fname[MAX_STR_LEN];
  char lockfile[MAX_STR_LEN];
  char cd_number_str[MAX_STR_LEN];
  /* char popup_str[MAX_STR_LEN];  removed 19 apr 02 stan benoit */
  char *p;

  old_stderr[0] = '\0';
/*************   End Variables ***************************************/

  incoming[0]='\0';
  log_it ("basic call = '%s'", basic_call);
  sprintf (cd_number_str, "%d", cd_no);
  sprintf (stderr_fname, "%s/stderr.txt", bkpinfo->tmpdir);
  resolve_naff_tokens (midway_call, basic_call, isofile, "_ISO_");
  log_it ("midway_call = '%s'", midway_call);
  resolve_naff_tokens (tmp, midway_call, cd_number_str, "_CD#_");
  log_it ("tmp = '%s'", tmp);
  resolve_naff_tokens (ultimate_call, tmp, stderr_fname, "_ERR_");

  log_it ("ultimate call = '%s'", ultimate_call);


  sprintf (lockfile,
	   call_program_and_get_last_line_of_output
	   ("mktemp -q /tmp/mondo.XXXXXXXX"));
  unlink(stderr_fname);
  /*  if (!g_text_mode)
    {
  */
      sprintf (ultimate_call, "%s 2>> %s", ultimate_call, stderr_fname);
      //    } 

  sprintf (command, "echo hi > %s ; %s ; res=$?; rm -f %s; exit $res",
	   lockfile, ultimate_call, lockfile);

  log_it("Calling open_evalcall_form() with what_i_am_doing='%s'", what_i_am_doing);
  open_evalcall_form (what_i_am_doing);
  strcpy (tmp, command);
  if (bkpinfo->manual_cd_tray)
    {
      p = strstr (tmp, "2>>");
      sprintf (p, "   ");
      while(*p==' ') { p++; }
      for (; *p != ' '; p++)
	{
	  *p = ' ';
	}

      strcpy(command, tmp);
#ifndef _XWIN
      if (!g_text_mode)
	{
	  newtSuspend();
	}
#endif
      log_it (command);
      retval += system (command);
      //      clear();
      newtResume();
//      newtCls();
      if (retval)
	{
//	  log_it ("isofile = %s", isofile);
	  log_it ("Basic call '%s' returned an error.", basic_call);
	  popup_and_OK ("Press ENTER to continue.");
/*	  if (does_file_exist(isofile))
	    { retval=0; log_it ("...but it _did_ create the output ISO so I'm not worried :)"); }
	  else
	    {*/
              popup_and_OK("mkisofs and/or cdrecord returned an error. CD was not created"); 
//}
	}
      return (retval);
    }
  /* if text mode then do the above & RETURN; if not text mode, do this... */


  log_it ("NB: CD-burning command (FINAL) = %s", command);

  fin = popen (command, "r");

  if (!fin)
    {
      sprintf (tmp, "Failed utterly to call '%s'", command);
      log_to_screen (tmp);
      return (1);
    }
  for (i = 0; i < 5 && !does_file_exist (lockfile); sleep (1), i++);

  for (i = 0; does_file_exist (lockfile); sleep (1), i = (i + 1) % 10)
    {
      /*
      if (i==0)
	{
	  log_it("Still counting...");
      */

	  log_file_end_to_screen (stderr_fname, "");
	  jj = grab_percentage_from_last_line_of_file (stderr_fname);
	  if (jj>0 && i==0)
	    {
 	      log_it ("%d%% complete. Still working...", jj);
	    }
	  /*
	  sprintf(tmp,"jj = %d",jj);
	  log_it(tmp);
	  */
	  update_evalcall_form (jj);
	  //	}
    }
  log_it("Done counting.");

  for (fgets (incoming, MAX_STR_LEN, fin); !feof (fin);
       fgets (incoming, MAX_STR_LEN, fin))
    {
      incoming[78] = '\0';
      while (incoming[strlen (incoming) - 1] < 32 && strlen(incoming)>0)
	{
	  incoming[strlen (incoming) - 1] = '\0';
	}
      if (strlen (incoming) == 0)
	{
	  blanklines++;
	}
      log_to_screen (incoming);
    }

  log_it("About to close...");

  if (pclose (fin))
    {
      res = 1;
    }
  else
    {
      res = 0;
    }
  retval += res;
  close_evalcall_form ();
  log_it("Closed. Cool.");
  if (does_file_exist(stderr_fname))
    {
      sprintf (tmp, "cat %s >> %s", stderr_fname, MONDO_LOGFILE);
      system (tmp);
    }
  if (strstr (incoming, "<CR>"))
    {
      popup_and_OK(MONDO_POPMSG ); /* stan benoit 22 apr 2002 */
      retval++;
    }
  unlink (stderr_fname);
  return (retval);
}





/*************************************************************************
 * run_program_and_log_output() -- Hugo Rabson                           *
 *                                                                       *
 * Purpose:   Execute binary using shell. Log stdout, stderr. Catch      *
 *            error (if one occurs); log it; return value (or 0 if none) *
 * Called by: ...                                                        *
 * Params:    program         system call to make (e.g. "ls -l")         *
 *            log_if_success  do we log stdout, stderr if no error ret'd?*
 * Returns:   retval (0=success; nonzero=failure)                        *
 *************************************************************************/
int
run_program_and_log_output (char *program, bool log_if_success)
{
	/** buffer *******************************************************/
  char callstr[MAX_STR_LEN*2];
  char incoming[MAX_STR_LEN*2];
  char tmp[MAX_STR_LEN*2];
  char initial_label[MAX_STR_LEN*2];

	/** int **********************************************************/
  int res;
  int i;
  int len;

	/** pointers ****************************************************/
  FILE *fin;
  char *p;

	/** end vars ****************************************************/
  sprintf (callstr, "%s > /tmp/mondo-run-prog-thing.tmp 2> /tmp/mondo-run-prog-thing.err",
	   program);
  while ((p = strchr (callstr, '\r')))
    {
      *p = ' ';
    }
  while ((p = strchr (callstr, '\n')))
    {
      *p = ' ';
    }				/* single '=' is intentional */
  res = system (callstr);
  len = strlen (program);
  for (i = 0; i < 35 - len / 2; i++)
    {
      tmp[i] = '-';
    }
  tmp[i] = '\0';
  strcat (tmp, " ");
  strcat (tmp, program);
  strcat (tmp, " ");
  for (i = 0; i < 35 - len / 2; i++)
    {
      strcat (tmp, "-");
    }
  strcpy(initial_label, tmp);
  system ("cat /tmp/mondo-run-prog-thing.err >> /tmp/mondo-run-prog-thing.tmp 2> /dev/null");
  unlink ("/tmp/mondo-run-prog-thing.err");
  if (res!=0 || log_if_success) { log_it (initial_label); }
  fin = fopen ("/tmp/mondo-run-prog-thing.tmp", "r");
  if (fin)
    {
      for (fgets (incoming, MAX_STR_LEN, fin); !feof (fin);
	   fgets (incoming, MAX_STR_LEN, fin))
	{
	  /* patch by Heiko Schlittermann */
	  p = incoming;
	  while (p && *p)
	    {
	      if ((p = strchr(p, '%'))) 
		{
		  memmove(p, p+1, strlen(p) +1);
		  p += 2;
		}
	    }
	  /* end of patch */
	  strip_spaces (incoming);
	  if (res!=0 || log_if_success) { log_it (incoming); }
	}
      fclose (fin);
    }
  unlink("/tmp/mondo-run-prog-thing.tmp");
  if (res!=0 || log_if_success) { log_it ("--------------------------------end of output------------------------------"); }
  if (res) { log_it ("...ran with errors."); }
  else if (log_if_success) { log_it("...ran just fine. :-)"); }
  return (res);
}




/*************************************************************************
 * run_program_and_log_to_screen() -- Hugo Rabson                        *
 *                                                                       *
 * Purpose:                                                              *
 * Called by:                                                            *
 * Returns:                                                              *
 *************************************************************************/
int
run_program_and_log_to_screen (char *basic_call, char *what_i_am_doing)
{
	/** int *********************************************************/
  int retval = 0;
  int res = 0;
  int i;

	/**pointers *****************************************************/
  FILE *fin;

	/** buffers *****************************************************/
  char tmp[MAX_STR_LEN*2];
  char command[MAX_STR_LEN*2];
  char lockfile[MAX_STR_LEN];

	/** end vars ****************************************************/

  sprintf (lockfile,
	   call_program_and_get_last_line_of_output
	   ("mktemp -q /tmp/mojo-jojo.blah.XXXXXX"));
  sprintf (command,
	   "echo hi > %s ; %s >> %s 2>> %s; res=$?; rm -f %s; exit $res",
	   lockfile, basic_call, MONDO_LOGFILE, MONDO_LOGFILE, lockfile);
  open_evalcall_form (what_i_am_doing);
  sprintf (tmp, "Executing %s", basic_call);
  log_it (tmp);
  fin = popen (command, "r");
  if (!fin)
    {
      sprintf (tmp, "Failed utterly to call '%s'", command);
      log_to_screen (tmp);
      return (1);
    }
  for (i = 0; i < 3 && !does_file_exist (lockfile); sleep (1), i++)
    {
/*      log_it("So tired.. Tired of waiting..."); */
    }
  for (; does_file_exist (lockfile); sleep (1))
    {
      log_file_end_to_screen (MONDO_LOGFILE, "");
      update_evalcall_form (1);
    }
  if (pclose (fin))
    {
      res = 1;
    }
  retval += res;
  close_evalcall_form ();
  unlink (lockfile);
  return (retval);
}











