/***************************************************************************
                          mondostructures.h  -  description
                             -------------------
    begin                : Fri Apr 19 2002
    copyright            : (C) 2002 by Stan Benoit
    email                : troff@nakedsoul.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
struct mountlist_line
{
  char device[64];
  char mountpoint[64];
  char format[64];
  long size;
};

struct mountlist_itself
{
  int entries;
  struct mountlist_line el[ARBITRARY_MAXIMUM];
};

struct raid_var_line
{
  char label[64];
  char value[64];
};

struct additional_raid_variables
{
  int entries;
  struct raid_var_line el[MAXIMUM_ADDITIONAL_RAID_VARS];
};


struct s_disk
{
  char device[64];
  int index;
};

struct list_of_disks
{
  int entries;
  struct s_disk el[MAXIMUM_DISKS_PER_RAID_DEV];
};

typedef enum { none=0, iso, cdr, cdrw, cdstream, nfs, tape, udev } t_bkptype;

struct raid_device_record
{
  char raid_device[64];
  int raid_level;
  int persistent_superblock;
  int chunk_size;
  struct list_of_disks data_disks;
  struct list_of_disks spare_disks;
  struct list_of_disks parity_disks;
  struct list_of_disks failed_disks;
  struct additional_raid_variables additional_vars;
};

struct raidlist_itself
{
  int entries;
  struct raid_device_record el[MAXIMUM_RAID_DEVS];
};


#define MAX_NOOF_MEDIA 49

struct s_bkpinfo
{
  char media_device[MAX_STR_LEN/4];
  long media_size[MAX_NOOF_MEDIA+1];		/* in MB */
  char boot_loader;		/* G = GRUB, L = LILO */
  char boot_device[MAX_STR_LEN/4];	/* e.g. /dev/hda */
  char zip_exe[MAX_STR_LEN/4];	/* e.g. lzop or bzip2 */
  char zip_suffix[MAX_STR_LEN/4];	/* e.g. lzo or bz2 */
  char image_devs[MAX_STR_LEN];
  int compression_level;
  bool use_lzo;
  char do_not_compress_these[MAX_STR_LEN/2];
  bool verify_data;
  bool backup_data;
  bool restore_data;
  bool disaster_recovery;
  char isodir[MAX_STR_LEN/4];
  char scratchdir[MAX_STR_LEN/4];
  char tmpdir[MAX_STR_LEN/4];
  long optimal_set_size;
  t_bkptype backup_media_type;
  char include_paths[MAX_STR_LEN];
  char exclude_paths[MAX_STR_LEN];
  char restore_path[MAX_STR_LEN];
  char call_before_iso[MAX_STR_LEN];
  char call_make_iso[MAX_STR_LEN];
  char call_burn_iso[MAX_STR_LEN];
  char call_after_iso[MAX_STR_LEN];
  char kernel_path[MAX_STR_LEN];
  char nfs_mount[MAX_STR_LEN];
  char nfs_remote_dir[MAX_STR_LEN];
  char postnuke_tarball[MAX_STR_LEN];
  bool wipe_media_first;
  bool differential;
  int cdrw_speed;
  bool manual_cd_tray;
  bool please_dont_eject_when_restoring;
  bool nonbootable_backup;
  bool make_cd_use_lilo;
};




struct s_node
{
  char ch;
  struct s_node *right;
  struct s_node *down;
  bool selected;
  bool expanded;
};




struct s_wrapfifo {
	char public_device[MAX_STR_LEN/4]; // the one we write to / read from
	char private_device[MAX_STR_LEN/4];// the actual tape streamer
	char internal_buffer_IN_fifo[MAX_STR_LEN/4];
	char internal_buffer_OUT_fifo[MAX_STR_LEN/4];
	bool writing_to_private_device;
};




struct s_filename_and_lstat_info {
	char filename[MAX_STR_LEN];
	char checksum[64];
	char for_backward_compatibility;
	struct stat properties;
};



struct s_filelist_entry {
	char filename[MAX_STR_LEN];
	int severity; // 0 thru 3 --- 3 is most important
// 0 = /etc/mtab, /etc/adjtime, or other file which changes regularly
// 1 = 
};


struct s_filelist {
	int entries;
	struct s_filelist_entry el[ARBITRARY_MAXIMUM];
};




