// Copyright (c) 2014-2018, The Monero Project
//
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//
// 1. Redistributions of source code must retain the above copyright notice, this list of
//    conditions and the following disclaimer.
//
// 2. Redistributions in binary form must reproduce the above copyright notice, this list
//    of conditions and the following disclaimer in the documentation and/or other
//    materials provided with the distribution.
//
// 3. Neither the name of the copyright holder nor the names of its contributors may be
//    used to endorse or promote products derived from this software without specific
//    prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
// THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
// STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
// THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

/*!
 * \file lojban.h
 *
 * \brief New Lojban word list and map.
 */

/*
 * Word list authored by: sorpaas
 * Sources:
 *   lo gimste jo'u lo ma'oste (https://guskant.github.io/lojbo/gismu-cmavo.html)
 *   N-grams of Lojban corpus (https://mw.lojban.org/papri/N-grams_of_Lojban_corpus)
 */

#ifndef LOJBAN_H
#define LOJBAN_H

#include <vector>
#include <unordered_map>
#include "language_base.h"
#include <string>

/*!
 * \namespace Language
 * \brief Mnemonic language related namespace.
 */
namespace Language
{
  class Lojban: public Base
  {
  public:
    Lojban(): Base("Lojban", "Lojban", {}, 4)
    {
      static constexpr const char * const words[NWORDS] =
      {
      "backi",
      "bacru",
      "badna",
      "badri",
      "bajra",
      "bakfu",
      "bakni",
      "bakri",
      "baktu",
      "balji",
      "balni",
      "balre",
      "balvi",
      "bambu",
      "bancu",
      "bandu",
      "banfi",
      "bangu",
      "banli",
      "banro",
      "banxa",
      "banzu",
      "bapli",
      "barda",
      "bargu",
      "barja",
      "barna",
      "bartu",
      "basfa",
      "basna",
      "basti",
      "batci",
      "batke",
      "bavmi",
      "baxso",
      "bebna",
      "bekpi",
      "bemro",
      "bende",
      "bengo",
      "benji",
      "benre",
      "benzo",
      "bergu",
      "bersa",
      "berti",
      "besna",
      "besto",
      "betfu",
      "betri",
      "bevri",
      "bidju",
      "bifce",
      "bikla",
      "bilga",
      "bilma",
      "bilni",
      "bindo",
      "binra",
      "binxo",
      "birje",
      "birka",
      "birti",
      "bisli",
      "bitmu",
      "bitni",
      "blabi",
      "blaci",
      "blanu",
      "bliku",
      "bloti",
      "bolci",
      "bongu",
      "boske",
      "botpi",
      "boxfo",
      "boxna",
      "bradi",
      "brano",
      "bratu",
      "brazo",
      "bredi",
      "bridi",
      "brife",
      "briju",
      "brito",
      "brivo",
      "broda",
      "bruna",
      "budjo",
      "bukpu",
      "bumru",
      "bunda",
      "bunre",
      "burcu",
      "burna",
      "cabna",
      "cabra",
      "cacra",
      "cadga",
      "cadzu",
      "cafne",
      "cagna",
      "cakla",
      "calku",
      "calse",
      "canci",
      "cando",
      "cange",
      "canja",
      "canko",
      "canlu",
      "canpa",
      "canre",
      "canti",
      "carce",
      "carfu",
      "carmi",
      "carna",
      "cartu",
      "carvi",
      "casnu",
      "catke",
      "catlu",
      "catni",
      "catra",
      "caxno",
      "cecla",
      "cecmu",
      "cedra",
      "cenba",
      "censa",
      "centi",
      "cerda",
      "cerni",
      "certu",
      "cevni",
      "cfale",
      "cfari",
      "cfika",
      "cfila",
      "cfine",
      "cfipu",
      "ciblu",
      "cicna",
      "cidja",
      "cidni",
      "cidro",
      "cifnu",
      "cigla",
      "cikna",
      "cikre",
      "ciksi",
      "cilce",
      "cilfu",
      "cilmo",
      "cilre",
      "cilta",
      "cimde",
      "cimni",
      "cinba",
      "cindu",
      "cinfo",
      "cinje",
      "cinki",
      "cinla",
      "cinmo",
      "cinri",
      "cinse",
      "cinta",
      "cinza",
      "cipni",
      "cipra",
      "cirko",
      "cirla",
      "ciska",
      "cisma",
      "cisni",
      "ciste",
      "citka",
      "citno",
      "citri",
      "citsi",
      "civla",
      "cizra",
      "ckabu",
      "ckafi",
      "ckaji",
      "ckana",
      "ckape",
      "ckasu",
      "ckeji",
      "ckiku",
      "ckilu",
      "ckini",
      "ckire",
      "ckule",
      "ckunu",
      "cladu",
      "clani",
      "claxu",
      "cletu",
      "clika",
      "clinu",
      "clira",
      "clite",
      "cliva",
      "clupa",
      "cmaci",
      "cmalu",
      "cmana",
      "cmavo",
      "cmene",
      "cmeta",
      "cmevo",
      "cmila",
      "cmima",
      "cmoni",
      "cnano",
      "cnebo",
      "cnemu",
      "cnici",
      "cnino",
      "cnisa",
      "cnita",
      "cokcu",
      "condi",
      "conka",
      "corci",
      "cortu",
      "cpacu",
      "cpana",
      "cpare",
      "cpedu",
      "cpina",
      "cradi",
      "crane",
      "creka",
      "crepu",
      "cribe",
      "crida",
      "crino",
      "cripu",
      "crisa",
      "critu",
      "ctaru",
      "ctebi",
      "cteki",
      "ctile",
      "ctino",
      "ctuca",
      "cukla",
      "cukre",
      "cukta",
      "culno",
      "cumki",
      "cumla",
      "cunmi",
      "cunso",
      "cuntu",
      "cupra",
      "curmi",
      "curnu",
      "curve",
      "cusku",
      "cusna",
      "cutci",
      "cutne",
      "cuxna",
      "dacru",
      "dacti",
      "dadjo",
      "dakfu",
      "dakli",
      "damba",
      "damri",
      "dandu",
      "danfu",
      "danlu",
      "danmo",
      "danre",
      "dansu",
      "danti",
      "daplu",
      "dapma",
      "darca",
      "dargu",
      "darlu",
      "darno",
      "darsi",
      "darxi",
      "daski",
      "dasni",
      "daspo",
      "dasri",
      "datka",
      "datni",
      "datro",
      "decti",
      "degji",
      "dejni",
      "dekpu",
      "dekto",
      "delno",
      "dembi",
      "denci",
      "denmi",
      "denpa",
      "dertu",
      "derxi",
      "desku",
      "detri",
      "dicma",
      "dicra",
      "didni",
      "digno",
      "dikca",
      "diklo",
      "dikni",
      "dilcu",
      "dilma",
      "dilnu",
      "dimna",
      "dindi",
      "dinju",
      "dinko",
      "dinso",
      "dirba",
      "dirce",
      "dirgo",
      "disko",
      "ditcu",
      "divzi",
      "dizlo",
      "djacu",
      "djedi",
      "djica",
      "djine",
      "djuno",
      "donri",
      "dotco",
      "draci",
      "drani",
      "drata",
      "drudi",
      "dugri",
      "dukse",
      "dukti",
      "dunda",
      "dunja",
      "dunku",
      "dunli",
      "dunra",
      "dutso",
      "dzena",
      "dzipo",
      "facki",
      "fadni",
      "fagri",
      "falnu",
      "famti",
      "fancu",
      "fange",
      "fanmo",
      "fanri",
      "fanta",
      "fanva",
      "fanza",
      "fapro",
      "farka",
      "farlu",
      "farna",
      "farvi",
      "fasnu",
      "fatci",
      "fatne",
      "fatri",
      "febvi",
      "fegli",
      "femti",
      "fendi",
      "fengu",
      "fenki",
      "fenra",
      "fenso",
      "fepni",
      "fepri",
      "ferti",
      "festi",
      "fetsi",
      "figre",
      "filso",
      "finpe",
      "finti",
      "firca",
      "fisli",
      "fizbu",
      "flaci",
      "flalu",
      "flani",
      "flecu",
      "flese",
      "fliba",
      "flira",
      "foldi",
      "fonmo",
      "fonxa",
      "forca",
      "forse",
      "fraso",
      "frati",
      "fraxu",
      "frica",
      "friko",
      "frili",
      "frinu",
      "friti",
      "frumu",
      "fukpi",
      "fulta",
      "funca",
      "fusra",
      "fuzme",
      "gacri",
      "gadri",
      "galfi",
      "galtu",
      "galxe",
      "ganlo",
      "ganra",
      "ganse",
      "ganti",
      "ganxo",
      "ganzu",
      "gapci",
      "gapru",
      "garna",
      "gasnu",
      "gaspo",
      "gasta",
      "genja",
      "gento",
      "genxu",
      "gerku",
      "gerna",
      "gidva",
      "gigdo",
      "ginka",
      "girzu",
      "gismu",
      "glare",
      "gleki",
      "gletu",
      "glico",
      "glife",
      "glosa",
      "gluta",
      "gocti",
      "gomsi",
      "gotro",
      "gradu",
      "grafu",
      "grake",
      "grana",
      "grasu",
      "grava",
      "greku",
      "grusi",
      "grute",
      "gubni",
      "gugde",
      "gugle",
      "gumri",
      "gundi",
      "gunka",
      "gunma",
      "gunro",
      "gunse",
      "gunta",
      "gurni",
      "guska",
      "gusni",
      "gusta",
      "gutci",
      "gutra",
      "guzme",
      "jabre",
      "jadni",
      "jakne",
      "jalge",
      "jalna",
      "jalra",
      "jamfu",
      "jamna",
      "janbe",
      "janco",
      "janli",
      "jansu",
      "janta",
      "jarbu",
      "jarco",
      "jarki",
      "jaspu",
      "jatna",
      "javni",
      "jbama",
      "jbari",
      "jbena",
      "jbera",
      "jbini",
      "jdari",
      "jdice",
      "jdika",
      "jdima",
      "jdini",
      "jduli",
      "jecta",
      "jeftu",
      "jegvo",
      "jelca",
      "jemna",
      "jenca",
      "jendu",
      "jenmi",
      "jensi",
      "jerna",
      "jersi",
      "jerxo",
      "jesni",
      "jetce",
      "jetnu",
      "jgalu",
      "jganu",
      "jgari",
      "jgena",
      "jgina",
      "jgira",
      "jgita",
      "jibni",
      "jibri",
      "jicla",
      "jicmu",
      "jijnu",
      "jikca",
      "jikfi",
      "jikni",
      "jikru",
      "jilka",
      "jilra",
      "jimca",
      "jimpe",
      "jimte",
      "jinci",
      "jinda",
      "jinga",
      "jinku",
      "jinme",
      "jinru",
      "jinsa",
      "jinto",
      "jinvi",
      "jinzi",
      "jipci",
      "jipno",
      "jirna",
      "jisra",
      "jitfa",
      "jitro",
      "jivbu",
      "jivna",
      "jmaji",
      "jmifa",
      "jmina",
      "jmive",
      "jonse",
      "jordo",
      "jorne",
      "jubme",
      "judri",
      "jufra",
      "jukni",
      "jukpa",
      "julne",
      "julro",
      "jundi",
      "jungo",
      "junla",
      "junri",
      "junta",
      "jurme",
      "jursa",
      "jutsi",
      "juxre",
      "jvinu",
      "jviso",
      "kabri",
      "kacma",
      "kadno",
      "kafke",
      "kagni",
      "kajde",
      "kajna",
      "kakne",
      "kakpa",
      "kalci",
      "kalri",
      "kalsa",
      "kalte",
      "kamju",
      "kamni",
      "kampu",
      "kamre",
      "kanba",
      "kancu",
      "kandi",
      "kanji",
      "kanla",
      "kanpe",
      "kanro",
      "kansa",
      "kantu",
      "kanxe",
      "karbi",
      "karce",
      "karda",
      "kargu",
      "karli",
      "karni",
      "katci",
      "katna",
      "kavbu",
      "kazra",
      "kecti",
      "kekli",
      "kelci",
      "kelvo",
      "kenka",
      "kenra",
      "kensa",
      "kerfa",
      "kerlo",
      "kesri",
      "ketco",
      "ketsu",
      "kevna",
      "kibro",
      "kicne",
      "kijno",
      "kilto",
      "kinda",
      "kinli",
      "kisto",
      "klaji",
      "klaku",
      "klama",
      "klani",
      "klesi",
      "kliki",
      "klina",
      "kliru",
      "kliti",
      "klupe",
      "kluza",
      "kobli",
      "kogno",
      "kojna",
      "kokso",
      "kolme",
      "komcu",
      "konju",
      "korbi",
      "korcu",
      "korka",
      "korvo",
      "kosmu",
      "kosta",
      "krali",
      "kramu",
      "krasi",
      "krati",
      "krefu",
      "krici",
      "krili",
      "krinu",
      "krixa",
      "kruca",
      "kruji",
      "kruvi",
      "kubli",
      "kucli",
      "kufra",
      "kukte",
      "kulnu",
      "kumfa",
      "kumte",
      "kunra",
      "kunti",
      "kurfa",
      "kurji",
      "kurki",
      "kuspe",
      "kusru",
      "labno",
      "lacni",
      "lacpu",
      "lacri",
      "ladru",
      "lafti",
      "lakne",
      "lakse",
      "laldo",
      "lalxu",
      "lamji",
      "lanbi",
      "lanci",
      "landa",
      "lanka",
      "lanli",
      "lanme",
      "lante",
      "lanxe",
      "lanzu",
      "larcu",
      "larva",
      "lasna",
      "lastu",
      "latmo",
      "latna",
      "lazni",
      "lebna",
      "lelxe",
      "lenga",
      "lenjo",
      "lenku",
      "lerci",
      "lerfu",
      "libjo",
      "lidne",
      "lifri",
      "lijda",
      "limfa",
      "limna",
      "lince",
      "lindi",
      "linga",
      "linji",
      "linsi",
      "linto",
      "lisri",
      "liste",
      "litce",
      "litki",
      "litru",
      "livga",
      "livla",
      "logji",
      "loglo",
      "lojbo",
      "loldi",
      "lorxu",
      "lubno",
      "lujvo",
      "luksi",
      "lumci",
      "lunbe",
      "lunra",
      "lunsa",
      "luska",
      "lusto",
      "mabla",
      "mabru",
      "macnu",
      "majga",
      "makcu",
      "makfa",
      "maksi",
      "malsi",
      "mamta",
      "manci",
      "manfo",
      "mango",
      "manku",
      "manri",
      "mansa",
      "manti",
      "mapku",
      "mapni",
      "mapra",
      "mapti",
      "marbi",
      "marce",
      "marde",
      "margu",
      "marji",
      "marna",
      "marxa",
      "masno",
      "masti",
      "matci",
      "matli",
      "matne",
      "matra",
      "mavji",
      "maxri",
      "mebri",
      "megdo",
      "mekso",
      "melbi",
      "meljo",
      "melmi",
      "menli",
      "menre",
      "mensi",
      "mentu",
      "merko",
      "merli",
      "metfo",
      "mexno",
      "midju",
      "mifra",
      "mikce",
      "mikri",
      "milti",
      "milxe",
      "minde",
      "minji",
      "minli",
      "minra",
      "mintu",
      "mipri",
      "mirli",
      "misno",
      "misro",
      "mitre",
      "mixre",
      "mlana",
      "mlatu",
      "mleca",
      "mledi",
      "mluni",
      "mogle",
      "mokca",
      "moklu",
      "molki",
      "molro",
      "morji",
      "morko",
      "morna",
      "morsi",
      "mosra",
      "mraji",
      "mrilu",
      "mruli",
      "mucti",
      "mudri",
      "mugle",
      "mukti",
      "mulno",
      "munje",
      "mupli",
      "murse",
      "murta",
      "muslo",
      "mutce",
      "muvdu",
      "muzga",
      "nabmi",
      "nakni",
      "nalci",
      "namcu",
      "nanba",
      "nanca",
      "nandu",
      "nanla",
      "nanmu",
      "nanvi",
      "narge",
      "narju",
      "natfe",
      "natmi",
      "natsi",
      "navni",
      "naxle",
      "nazbi",
      "nejni",
      "nelci",
      "nenri",
      "nerde",
      "nibli",
      "nicfa",
      "nicte",
      "nikle",
      "nilce",
      "nimre",
      "ninja",
      "ninmu",
      "nirna",
      "nitcu",
      "nivji",
      "nixli",
      "nobli",
      "norgo",
      "notci",
      "nudle",
      "nukni",
      "nunmu",
      "nupre",
      "nurma",
      "nusna",
      "nutka",
      "nutli",
      "nuzba",
      "nuzlo",
      "pacna",
      "pagbu",
      "pagre",
      "pajni",
      "palci",
      "palku",
      "palma",
      "palne",
      "palpi",
      "palta",
      "pambe",
      "pamga",
      "panci",
      "pandi",
      "panje",
      "panka",
      "panlo",
      "panpi",
      "panra",
      "pante",
      "panzi",
      "papri",
      "parbi",
      "pardu",
      "parji",
      "pastu",
      "patfu",
      "patlu",
      "patxu",
      "paznu",
      "pelji",
      "pelxu",
      "pemci",
      "penbi",
      "pencu",
      "pendo",
      "penmi",
      "pensi",
      "pentu",
      "perli",
      "pesxu",
      "petso",
      "pevna",
      "pezli",
      "picti",
      "pijne",
      "pikci",
      "pikta",
      "pilda",
      "pilji",
      "pilka",
      "pilno",
      "pimlu",
      "pinca",
      "pindi",
      "pinfu",
      "pinji",
      "pinka",
      "pinsi",
      "pinta",
      "pinxe",
      "pipno",
      "pixra",
      "plana",
      "platu",
      "pleji",
      "plibu",
      "plini",
      "plipe",
      "plise",
      "plita",
      "plixa",
      "pluja",
      "pluka",
      "pluta",
      "pocli",
      "polje",
      "polno",
      "ponjo",
      "ponse",
      "poplu",
      "porpi",
      "porsi",
      "porto",
      "prali",
      "prami",
      "prane",
      "preja",
      "prenu",
      "preri",
      "preti",
      "prije",
      "prina",
      "pritu",
      "proga",
      "prosa",
      "pruce",
      "pruni",
      "pruri",
      "pruxi",
      "pulce",
      "pulji",
      "pulni",
      "punji",
      "punli",
      "pupsu",
      "purci",
      "purdi",
      "purmo",
      "racli",
      "ractu",
      "radno",
      "rafsi",
      "ragbi",
      "ragve",
      "rakle",
      "rakso",
      "raktu",
      "ralci",
      "ralju",
      "ralte",
      "randa",
      "rango",
      "ranji",
      "ranmi",
      "ransu",
      "ranti",
      "ranxi",
      "rapli",
      "rarna",
      "ratcu",
      "ratni",
      "rebla",
      "rectu",
      "rekto",
      "remna",
      "renro",
      "renvi",
      "respa",
      "rexsa",
      "ricfu",
      "rigni",
      "rijno",
      "rilti",
      "rimni",
      "rinci",
      "rindo",
      "rinju",
      "rinka",
      "rinsa",
      "rirci",
      "rirni",
      "rirxe",
      "rismi",
      "risna",
      "ritli",
      "rivbi",
      "rokci",
      "romge",
      "romlo",
      "ronte",
      "ropno",
      "rorci",
      "rotsu",
      "rozgu",
      "ruble",
      "rufsu",
      "runme",
      "runta",
      "rupnu",
      "rusko",
      "rutni",
      "sabji",
      "sabnu",
      "sacki",
      "saclu",
      "sadjo",
      "sakci",
      "sakli",
      "sakta",
      "salci",
      "salpo",
      "salri",
      "salta",
      "samcu",
      "sampu",
      "sanbu",
      "sance",
      "sanga",
      "sanji",
      "sanli",
      "sanmi",
      "sanso",
      "santa",
      "sarcu",
      "sarji",
      "sarlu",
      "sarni",
      "sarxe",
      "saske",
      "satci",
      "satre",
      "savru",
      "sazri",
      "sefsi",
      "sefta",
      "sekre",
      "selci",
      "selfu",
      "semto",
      "senci",
      "sengi",
      "senpi",
      "senta",
      "senva",
      "sepli",
      "serti",
      "sesre",
      "setca",
      "sevzi",
      "sfani",
      "sfasa",
      "sfofa",
      "sfubu",
      "sibli",
      "siclu",
      "sicni",
      "sicpi",
      "sidbo",
      "sidju",
      "sigja",
      "sigma",
      "sikta",
      "silka",
      "silna",
      "simlu",
      "simsa",
      "simxu",
      "since",
      "sinma",
      "sinso",
      "sinxa",
      "sipna",
      "sirji",
      "sirxo",
      "sisku",
      "sisti",
      "sitna",
      "sivni",
      "skaci",
      "skami",
      "skapi",
      "skari",
      "skicu",
      "skiji",
      "skina",
      "skori",
      "skoto",
      "skuba",
      "skuro",
      "slabu",
      "slaka",
      "slami",
      "slanu",
      "slari",
      "slasi",
      "sligu",
      "slilu",
      "sliri",
      "slovo",
      "sluji",
      "sluni",
      "smacu",
      "smadi",
      "smaji",
      "smaka",
      "smani",
      "smela",
      "smoka",
      "smuci",
      "smuni",
      "smusu",
      "snada",
      "snanu",
      "snidu",
      "snime",
      "snipa",
      "snuji",
      "snura",
      "snuti",
      "sobde",
      "sodna",
      "sodva",
      "softo",
      "solji",
      "solri",
      "sombo",
      "sonci",
      "sorcu",
      "sorgu",
      "sorni",
      "sorta",
      "sovda",
      "spaji",
      "spali",
      "spano",
      "spati",
      "speni",
      "spero",
      "spisa",
      "spita",
      "spofu",
      "spoja",
      "spuda",
      "sputu",
      "sraji",
      "sraku",
      "sralo",
      "srana",
      "srasu",
      "srera",
      "srito",
      "sruma",
      "sruri",
      "stace",
      "stagi",
      "staku",
      "stali",
      "stani",
      "stapa",
      "stasu",
      "stati",
      "steba",
      "steci",
      "stedu",
      "stela",
      "stero",
      "stici",
      "stidi",
      "stika",
      "stizu",
      "stodi",
      "stuna",
      "stura",
      "stuzi",
      "sucta",
      "sudga",
      "sufti",
      "suksa",
      "sumji",
      "sumne",
      "sumti",
      "sunga",
      "sunla",
      "surla",
      "sutra",
      "tabno",
      "tabra",
      "tadji",
      "tadni",
      "tagji",
      "taksi",
      "talsa",
      "tamca",
      "tamji",
      "tamne",
      "tanbo",
      "tance",
      "tanjo",
      "tanko",
      "tanru",
      "tansi",
      "tanxe",
      "tapla",
      "tarbi",
      "tarci",
      "tarla",
      "tarmi",
      "tarti",
      "taske",
      "tasmi",
      "tasta",
      "tatpi",
      "tatru",
      "tavla",
      "taxfu",
      "tcaci",
      "tcadu",
      "tcana",
      "tcati",
      "tcaxe",
      "tcena",
      "tcese",
      "tcica",
      "tcidu",
      "tcika",
      "tcila",
      "tcima",
      "tcini",
      "tcita",
      "temci",
      "temse",
      "tende",
      "tenfa",
      "tengu",
      "terdi",
      "terpa",
      "terto",
      "tifri",
      "tigni",
      "tigra",
      "tikpa",
      "tilju",
      "tinbe",
      "tinci",
      "tinsa",
      "tirna",
      "tirse",
      "tirxu",
      "tisna",
      "titla",
      "tivni",
      "tixnu",
      "toknu",
      "toldi",
      "tonga",
      "tordu",
      "torni",
      "torso",
      "traji",
      "trano",
      "trati",
      "trene",
      "tricu",
      "trina",
      "trixe",
      "troci",
      "tsaba",
      "tsali",
      "tsani",
      "tsapi",
      "tsiju",
      "tsina",
      "tsuku",
      "tubnu",
      "tubra",
      "tugni",
      "tujli",
      "tumla",
      "tunba",
      "tunka",
      "tunlo",
      "tunta",
      "tuple",
      "turko",
      "turni",
      "tutci",
      "tutle",
      "tutra",
      "vacri",
      "vajni",
      "valsi",
      "vamji",
      "vamtu",
      "vanbi",
      "vanci",
      "vanju",
      "vasru",
      "vasxu",
      "vecnu",
      "vedli",
      "venfu",
      "vensa",
      "vente",
      "vepre",
      "verba",
      "vibna",
      "vidni",
      "vidru",
      "vifne",
      "vikmi",
      "viknu",
      "vimcu",
      "vindu",
      "vinji",
      "vinta",
      "vipsi",
      "virnu",
      "viska",
      "vitci",
      "vitke",
      "vitno",
      "vlagi",
      "vlile",
      "vlina",
      "vlipa",
      "vofli",
      "voksa",
      "volve",
      "vorme",
      "vraga",
      "vreji",
      "vreta",
      "vrici",
      "vrude",
      "vrusi",
      "vubla",
      "vujnu",
      "vukna",
      "vukro",
      "xabju",
      "xadba",
      "xadji",
      "xadni",
      "xagji",
      "xagri",
      "xajmi",
      "xaksu",
      "xalbo",
      "xalka",
      "xalni",
      "xamgu",
      "xampo",
      "xamsi",
      "xance",
      "xango",
      "xanka",
      "xanri",
      "xansa",
      "xanto",
      "xarci",
      "xarju",
      "xarnu",
      "xasli",
      "xasne",
      "xatra",
      "xatsi",
      "xazdo",
      "xebni",
      "xebro",
      "xecto",
      "xedja",
      "xekri",
      "xelso",
      "xendo",
      "xenru",
      "xexso",
      "xigzo",
      "xindo",
      "xinmo",
      "xirma",
      "xislu",
      "xispo",
      "xlali",
      "xlura",
      "xorbo",
      "xorlo",
      "xotli",
      "xrabo",
      "xrani",
      "xriso",
      "xrotu",
      "xruba",
      "xruki",
      "xrula",
      "xruti",
      "xukmi",
      "xulta",
      "xunre",
      "xurdo",
      "xusra",
      "xutla",
      "zabna",
      "zajba",
      "zalvi",
      "zanru",
      "zarci",
      "zargu",
      "zasni",
      "zasti",
      "zbabu",
      "zbani",
      "zbasu",
      "zbepi",
      "zdani",
      "zdile",
      "zekri",
      "zenba",
      "zepti",
      "zetro",
      "zevla",
      "zgadi",
      "zgana",
      "zgike",
      "zifre",
      "zinki",
      "zirpu",
      "zivle",
      "zmadu",
      "zmiku",
      "zucna",
      "zukte",
      "zumri",
      "zungi",
      "zunle",
      "zunti",
      "zutse",
      "zvati",
      "zviki",
      "jbobau",
      "jbopre",
      "karsna",
      "cabdei",
      "zunsna",
      "gendra",
      "glibau",
      "nintadni",
      "pavyseljirna",
      "vlaste",
      "selbri",
      "latro'a",
      "zdakemkulgu'a",
      "mriste",
      "selsku",
      "fu'ivla",
      "tolmo'i",
      "snavei",
      "xagmau",
      "retsku",
      "ckupau",
      "skudji",
      "smudra",
      "prulamdei",
      "vokta'a",
      "tinju'i",
      "jefyfa'o",
      "bavlamdei",
      "kinzga",
      "jbocre",
      "jbovla",
      "xauzma",
      "selkei",
      "xuncku",
      "spusku",
      "jbogu'e",
      "pampe'o",
      "bripre",
      "jbosnu",
      "zi'evla",
      "gimste",
      "tolzdi",
      "velski",
      "samselpla",
      "cnegau",
      "velcki",
      "selja'e",
      "fasybau",
      "zanfri",
      "reisku",
      "favgau",
      "jbota'a",
      "rejgau",
      "malgli",
      "zilkai",
      "keidji",
      "tersu'i",
      "jbofi'e",
      "cnima'o",
      "mulgau",
      "ningau",
      "ponbau",
      "mrobi'o",
      "rarbau",
      "zmanei",
      "famyma'o",
      "vacysai",
      "jetmlu",
      "jbonunsla",
      "nunpe'i",
      "fa'orma'o",
      "crezenzu'e",
      "jbojbe",
      "cmicu'a",
      "zilcmi",
      "tolcando",
      "zukcfu",
      "depybu'i",
      "mencre",
      "matmau",
      "nunctu",
      "selma'o",
      "titnanba",
      "naldra",
      "jvajvo",
      "nunsnu",
      "nerkla",
      "cimjvo",
      "muvgau",
      "zipcpi",
      "runbau",
      "faumlu",
      "terbri",
      "balcu'e",
      "dragau",
      "smuvelcki",
      "piksku",
      "selpli",
      "bregau",
      "zvafa'i",
      "ci'izra",
      "noltruti'u",
      "samtci",
      "snaxa'a",
      };
      set_words(words);
      populate_maps();
    }
  };
}

#endif
