
type rc4_key
external rc4_key : string -> rc4_key = "ml_RC4_set_key"
external _rc4 : rc4_key -> string -> string -> unit = "ml_RC4"
let rc4 k s =
  let s' = String.create (String.length s) in
  _rc4 k s s' ;
  s'

external sha1 : string -> string = "ml_SHA1"

type -'a rsa_key
type priv_rsa_key = [`PRIVATE] rsa_key 
type pub_rsa_key = [`PUBLIC] rsa_key 
type any_rsa_key = [`PUBLIC | `PRIVATE] rsa_key
external decode_rsa_pubkey  : string -> pub_rsa_key = "ml_d2i_RSA_PUBKEY"
external decode_rsa_privkey : string -> priv_rsa_key = "ml_d2i_PKCS8_RSA_PrivateKey"

type digest = SHA1
external rsa_size : [< `PUBLIC | `PRIVATE] rsa_key -> int = "ml_RSA_size"
external _rsa_sign : priv_rsa_key -> digest -> string -> string -> int = "ml_RSA_sign"
let rsa_sign d k md =
  let size = rsa_size k in
  let sigbuf = String.create size in
  let siglen = _rsa_sign k d md sigbuf in
  if siglen = size
  then sigbuf
  else (Printf.eprintf "%d %d\n%!" size siglen ; String.sub sigbuf 0 siglen)

let rsa_sha1_sign k m = rsa_sign SHA1 k (sha1 m)

external rsa_verify : pub_rsa_key -> digest -> string -> string -> bool = "ml_RSA_verify"
let rsa_sha1_verify k m s = rsa_verify k SHA1 (sha1 m) s
