exception Error of string

let error s = raise (Error s)
let errorf fmt = Printf.kprintf error fmt

module StringMap = Map.Make(String)

type query_domain =
  | QUERY_ALL
  | QUERY_BRANCHES of string list
type date = string
type query_limit =
  | QUERY_NO_LIMIT
  | QUERY_BETWEEN of date * date
type query = query_domain * query_limit

type select_info = { query : query; preselect : string option; }

module NodeMap = StringMap
module EdgeMap = Map.Make (struct type t = string * string let compare = Pervasives.compare end)
module IdSet = Set.Make(String)

type sig_verif =
  | SIG_OK
  | SIG_BAD
  | SIG_UNKNOWN

type cert = {
    c_id        : string ;
    c_name      : string ;
    c_value     : string ;
    c_signer_id : string ;
    c_signature : sig_verif ;
  }

type node_kind =
  | REGULAR
  | NEIGHBOUR_IN
  | NEIGHBOUR_OUT
  | MERGE
  | DISAPPROVE
  | TAGGED of string

type relation = PARENT | CHILD

type a_node = {
    id       : string ;
    kind     : node_kind ;
    family   : (string * relation) list ;
  }

type node_data = {
    revision_id  : string ;
    manifest_id  : string ;
    revision_set : (string * Revision_types.change list) list ;
    certs        : cert list ;
  }

type edge_kind =
  | BRANCHING
  | SAME_BRANCH
  | DISAPPROVED
  | SPANNING

type agraph = {
  nodes           : a_node NodeMap.t ;
  ancestry        : edge_kind EdgeMap.t ;
  neighbour_nodes : IdSet.t ;
}

type c_node = {
  n_x : float;
  n_y : float;
  n_w : float;
  n_h : float;
  c_kind : node_kind ;
}

type edge = {
  startp    : float array;
  endp      : float array;
  controlp  : float array;
  edge_kind : edge_kind;
}

type cgraph = {
  bb      : float * float * float * float;
  c_nodes : c_node NodeMap.t;
  c_edges : edge EdgeMap.t;
}

let empty_agraph = { nodes = NodeMap.empty; 
		     ancestry = EdgeMap.empty; 
		     neighbour_nodes = IdSet.empty }
let empty_cgraph = { bb = (0., 0., 0., 0.); 
		     c_nodes = NodeMap.empty ; 
		     c_edges = EdgeMap.empty }

type direction = [
    `PARENT
  | `CHILD
  | `NEXT
  | `PREV ]

type autocolor =
  | NONE
  | BY_KEYID
  | BY_AUTHOR_HASH
  | BY_BRANCH_HASH
